/*
 * ***************************************************************************
 * MALOC = < Minimal Abstraction Layer for Object-oriented C >
 * Copyright (C) 1994--2000  Michael Holst
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * rcsid="$Id: vblas.h,v 1.1 2002/10/17 23:40:49 mholst Exp $"
 * ***************************************************************************
 */

/*
 * ***************************************************************************
 * File:     vblas.h
 *
 * Purpose:  The primary header for the BLAS.
 *           (Basic Linear Algebra Subroutines.)
 *
 * Notes:    We provide this header whether or not we provide the BLAS
 *           library itself.  This gives us some compile-time type-checking
 *           even for architecture-dependent assembly-coded BLAS.
 *
 * Author:   Michael Holst
 * ***************************************************************************
 */

#ifndef _VBLAS_H_
#define _VBLAS_H_

#include <maloc/maloc_base.h>

#include <maloc/vf2c.h>

/*
 * ***************************************************************************
 * Class VBLAS prototypes
 * ***************************************************************************
 */

real maloc_sdot(integer* N, real* X, integer* incX, real* Y, integer* incY);

doublereal maloc_ddot(integer* N, doublereal* X, integer* incX,
    doublereal* Y, integer* incY);

void maloc_cdotu(complex* retval, integer* N, complex* X, integer* incX,
    complex* Y, integer* incY);

void maloc_cdotc(complex* retval, integer* N, complex* X, integer* incX,
    complex* Y, integer* incY);

void maloc_zdotu(doublecomplex* retval, integer* N, doublecomplex* X,
    integer* incX, doublecomplex* Y, integer* incY);

void maloc_zdotc(doublecomplex* retval, integer* N, doublecomplex* X,
    integer* incX, doublecomplex* Y, integer* incY);

real maloc_snrm2(integer* N, real* X, integer* incX);

real maloc_sasum(integer* N, real* X, integer* incX);

doublereal maloc_dnrm2(integer* N, doublereal* X, integer* incX);

doublereal maloc_dasum(integer* N, doublereal* X, integer* incX);

real maloc_scnrm2(integer* N, complex* X, integer* incX);

real maloc_scasum(integer* N, complex* X, integer* incX);

doublereal maloc_dznrm2(integer* N, doublecomplex* X, integer* incX);

doublereal maloc_dzasum(integer* N, doublecomplex* X, integer* incX);

integer maloc_isamax(integer* N, real* X, integer* incX);

integer maloc_idamax(integer* N, doublereal* X, integer* incX);

integer maloc_icamax(integer* N, complex* X, integer* incX);

integer maloc_izamax(integer* N, doublecomplex* X, integer* incX);

int maloc_sswap(integer* N, real* X, integer* incX, real* Y, integer* incY);

int maloc_scopy(integer* N, real* X, integer* incX, real* Y, integer* incY);

int maloc_saxpy(integer* N, real* alpha, real* X, integer* incX,
    real* Y, integer* incY);

int maloc_dswap(integer* N, doublereal* X, integer* incX,
    doublereal* Y, integer* incY);

int maloc_dcopy(integer* N, doublereal* X, integer* incX,
    doublereal* Y, integer* incY);

int maloc_daxpy(integer* N, doublereal* alpha, doublereal* X, integer* incX,
    doublereal* Y, integer* incY);

int maloc_cswap(integer* N, complex* X, integer* incX,
    complex* Y, integer* incY);

int maloc_ccopy(integer* N, complex* X, integer* incX,
    complex* Y, integer* incY);

int maloc_caxpy(integer* N, complex* alpha,
    complex* X, integer* incX, complex* Y, integer* incY);

int maloc_zswap(integer* N, doublecomplex* X, integer* incX, doublecomplex* Y,
    integer* incY);

int maloc_zcopy(integer* N, doublecomplex* X, integer* incX, doublecomplex* Y,
    integer* incY);

int maloc_zaxpy(integer* N, doublecomplex* alpha, doublecomplex* X,
    integer* incX, doublecomplex* Y, integer* incY);

int maloc_srotg(real* a, real* b, real* c, real* s);

int maloc_srot(integer* N, real* X, integer* incX, real* Y, integer* incY,
    real* c, real* s);

int maloc_drotg(doublereal* a, doublereal* b, doublereal* c, doublereal* s);

int maloc_drot(integer* N, doublereal* X, integer* incX, doublereal* Y,
    integer* incY, doublereal* c, doublereal* s);

int maloc_sscal(integer* N, real* alpha, real* X, integer* incX);

int maloc_dscal(integer* N, doublereal* alpha, doublereal* X, integer* incX);

int maloc_cscal(integer* N, complex* alpha, complex* X, integer* incX);

int maloc_zscal(integer* N, doublecomplex* alpha, doublecomplex* X,
    integer* incX);

int maloc_csscal(integer* N, real* alpha, complex* X, integer* incX);

int maloc_zdscal(integer* N, doublereal* alpha, doublecomplex* X,
    integer* incX);

int maloc_sgemv(char* trans, integer* M, integer* N, real* alpha, real* A,
    integer* lda, real* X, integer* incX, real* beta, real* Y, integer* incY);

int maloc_sgbmv(char *trans, integer *M, integer *N, integer *KL, integer *KU, 
    real *alpha, real *A, integer *lda, real *X, integer *incX, real *beta, 
    real *Y, integer *incY);

int maloc_strmv(char* uplo, char *trans, char* diag, integer *N, real *A,
    integer *lda, real *X, integer *incX);

int maloc_stbmv(char* uplo, char* trans, char* diag, integer* N, integer* K,
    real* A, integer* lda, real* X, integer* incX);

int maloc_stpmv(char* uplo, char* trans, char* diag, integer* N, real* Ap, 
    real* X, integer* incX);

int maloc_strsv(char* uplo, char* trans, char* diag, integer* N, real* A,
    integer* lda, real* X, integer* incX);

int maloc_stbsv(char* uplo, char* trans, char* diag, integer* N, integer* K,
    real* A, integer* lda, real* X, integer* incX);

int maloc_stpsv(char* uplo, char* trans, char* diag, integer* N, real* Ap, 
    real* X, integer* incX);

int maloc_dgemv(char* trans, integer* M, integer* N, doublereal* alpha,
    doublereal* A, integer* lda, doublereal* X, integer* incX,
    doublereal* beta, doublereal* Y, integer* incY);

int maloc_dgbmv(char *trans, integer *M, integer *N, integer *KL, integer *KU, 
    doublereal *alpha, doublereal *A, integer *lda, doublereal *X,
    integer *incX, doublereal *beta, doublereal *Y, integer *incY);

int maloc_dtrmv(char* uplo, char *trans, char* diag, integer *N,  
    doublereal *A, integer *lda, doublereal *X, integer *incX);

int maloc_dtbmv(char* uplo, char* trans, char* diag, integer* N, integer* K,
    doublereal* A, integer* lda, doublereal* X, integer* incX);

int maloc_dtpmv(char* uplo, char* trans, char* diag, integer* N, 
    doublereal* Ap, doublereal* X, integer* incX);

int maloc_dtrsv(char* uplo, char* trans, char* diag, integer* N,
    doublereal* A, integer* lda, doublereal* X, integer* incX);

int maloc_dtbsv(char* uplo, char* trans, char* diag, integer* N, integer* K,
    doublereal* A, integer* lda, doublereal* X, integer* incX);

int maloc_dtpsv(char* uplo, char* trans, char* diag, integer* N, 
    doublereal* Ap, doublereal* X, integer* incX);

int maloc_cgemv(char* trans, integer* M, integer* N, complex* alpha,
    complex* A, integer* lda, complex* X, integer* incX, complex* beta,
    complex* Y, integer* incY);

int maloc_cgbmv(char *trans, integer *M, integer *N, integer *KL, integer *KU, 
    complex *alpha, complex *A, integer *lda, complex *X, integer *incX, 
    complex *beta, complex *Y, integer *incY);

int maloc_ctrmv(char* uplo, char *trans, char* diag, integer *N,  
    complex *A, integer *lda, complex *X, integer *incX);

int maloc_ctbmv(char* uplo, char* trans, char* diag, integer* N, integer* K,
    complex* A, integer* lda, complex* X, integer* incX);

int maloc_ctpmv(char* uplo, char* trans, char* diag, integer* N, 
    complex* Ap, complex* X, integer* incX);

int maloc_ctrsv(char* uplo, char* trans, char* diag, integer* N,
    complex* A, integer* lda, complex* X, integer* incX);

int maloc_ctbsv(char* uplo, char* trans, char* diag, integer* N, integer* K,
    complex* A, integer* lda, complex* X, integer* incX);

int maloc_ctpsv(char* uplo, char* trans, char* diag, integer* N, 
    complex* Ap, complex* X, integer* incX);

int maloc_zgemv(char* trans, integer* M, integer* N, doublecomplex* alpha,
    doublecomplex* A, integer* lda, doublecomplex* X, integer* incX,
    doublecomplex* beta, doublecomplex* Y, integer* incY);

int maloc_zgbmv(char *trans, integer *M, integer *N, integer *KL, integer *KU, 
    doublecomplex *alpha, doublecomplex *A, integer *lda, doublecomplex *X,
    integer *incX, doublecomplex *beta, doublecomplex *Y, integer *incY);

int maloc_ztrmv(char* uplo, char *trans, char* diag, integer *N,  
    doublecomplex *A, integer *lda, doublecomplex *X, integer *incX);

int maloc_ztbmv(char* uplo, char* trans, char* diag, integer* N, integer* K,
    doublecomplex* A, integer* lda, doublecomplex* X, integer* incX);

void maloc_ztpmv(char* uplo, char* trans, char* diag, integer* N, 
    doublecomplex* Ap, doublecomplex* X, integer* incX);

int maloc_ztrsv(char* uplo, char* trans, char* diag, integer* N,
    doublecomplex* A, integer* lda, doublecomplex* X, integer* incX);

int maloc_ztbsv(char* uplo, char* trans, char* diag, integer* N, integer* K,
    doublecomplex* A, integer* lda, doublecomplex* X, integer* incX);

int maloc_ztpsv(char* uplo, char* trans, char* diag, integer* N, 
    doublecomplex* Ap, doublecomplex* X, integer* incX);

int maloc_ssymv(char* uplo, integer* N, real* alpha, real* A, integer* lda,
    real* X, integer* incX, real* beta, real* Y, integer* incY);

int maloc_ssbmv(char* uplo, integer* N, integer* K, real* alpha,
    real* A, integer* lda, real* X, integer* incX, real* beta,
    real* Y, integer* incY);

int maloc_sspmv(char* uplo, integer* N, real* alpha, real* Ap,
    real* X, integer* incX, real* beta, real* Y, integer* incY);

int maloc_sger(integer* M, integer* N, real* alpha, real* X, integer* incX,
    real* Y, integer* incY, real* A, integer* lda);

int maloc_ssyr(char* uplo, integer* N, real* alpha, real* X, integer* incX,
    real* A, integer* lda);

int maloc_sspr(char* uplo, integer* N, real* alpha, real* X, integer* incX,
    real* Ap);

int maloc_ssyr2(char* uplo, integer* N, real* alpha, real* X, integer* incX,
    real* Y, integer* incY, real* A, integer* lda);

int maloc_sspr2(char* uplo, integer* N, real* alpha, real* X, integer* incX,
    real* Y, integer* incY, real* A);

int maloc_dsymv(char* uplo, integer* N, doublereal* alpha, doublereal* A,
    integer* lda, doublereal* X, integer* incX, doublereal* beta,
    doublereal* Y, integer* incY);

int maloc_dsbmv(char* uplo, integer* N, integer* K, doublereal* alpha,
    doublereal* A, integer* lda, doublereal* X, integer* incX,
    doublereal* beta, doublereal* Y, integer* incY);

int maloc_dspmv(char* uplo, integer* N, doublereal* alpha, doublereal* Ap,
    doublereal* X, integer* incX, doublereal* beta,
    doublereal* Y, integer* incY);

int maloc_dger(integer* M, integer* N, doublereal* alpha, doublereal* X,
    integer* incX, doublereal* Y, integer* incY, doublereal* A, integer* lda);

int maloc_dsyr(char* uplo, integer* N, doublereal* alpha, doublereal* X,
    integer* incX, doublereal* A, integer* lda);

int maloc_dspr(char* uplo, integer* N, doublereal* alpha, doublereal* X,
    integer* incX, doublereal* Ap);

int maloc_dsyr2(char* uplo, integer* N, doublereal* alpha, doublereal* X,
    integer* incX, doublereal* Y, integer* incY, doublereal* A, integer* lda);

int maloc_dspr2(char* uplo, integer* N, doublereal* alpha, doublereal* X,
    integer* incX, doublereal* Y, integer* incY, doublereal* A);

int maloc_chemv(char* uplo, integer* N, complex* alpha, complex* A,
    integer* lda, complex* X, integer* incX, complex* beta,
    complex* Y, integer* incY);

int maloc_chbmv(char* uplo, integer* N, integer* K, complex* alpha,
    complex* A, integer* lda, complex* X, integer* incX, complex* beta,
    complex* Y, integer* incY);

int maloc_chpmv(char* uplo, integer* N, complex* alpha, complex* Ap, 
    complex* X, integer* incX, complex* beta, complex* Y, integer* incY);

int maloc_cgeru(integer* M, integer* N, complex* alpha, complex* X,
    integer* incX, complex* Y, integer* incY, complex* A, integer* lda);

int maloc_cgerc(integer* M, integer* N, complex* alpha, complex* X,
    integer* incX, complex* Y, integer* incY, complex* A, integer* lda);

int maloc_cher(char* uplo, integer* N, real* alpha, complex* X, integer* incX,
    complex* A, integer* lda);

int maloc_chpr(char* uplo, integer* N, real* alpha, complex* X, integer* incX,
    complex* Ap);

int maloc_cher2(char* uplo, integer* N, complex* alpha, complex* X,
    integer* incX, complex* Y, integer* incY, complex* A, integer* lda);

int maloc_chpr2(char* uplo, integer* N, complex* alpha, complex* X,
    integer* incX, complex* Y, integer* incY, complex* Ap);

int maloc_zhemv(char* uplo, integer* N, doublecomplex* alpha,
    doublecomplex* A, integer* lda, doublecomplex* X, integer* incX,
    doublecomplex* beta, doublecomplex* Y, integer* incY);

int maloc_zhbmv(char* uplo, integer* N, integer* K, doublecomplex* alpha,
    doublecomplex* A, integer* lda, doublecomplex* X, integer* incX,
    doublecomplex* beta, doublecomplex* Y, integer* incY);

int maloc_zhpmv(char* uplo, integer* N, doublecomplex* alpha,
    doublecomplex* Ap, doublecomplex* X, integer* incX,
    doublecomplex* beta, doublecomplex* Y, integer* incY);

int maloc_zgeru(integer* M, integer* N, doublecomplex* alpha,
    doublecomplex* X, integer* incX, doublecomplex* Y, integer* incY,
    doublecomplex* A, integer* lda);

int maloc_zgerc(integer* M, integer* N, doublecomplex* alpha,
    doublecomplex* X, integer* incX, doublecomplex* Y, integer* incY,
    doublecomplex* A, integer* lda);

int maloc_zher(char* uplo, integer* N, doublereal* alpha,
    doublecomplex* X, integer* incX, doublecomplex* A, integer* lda);

int maloc_zhpr(char* uplo, integer* N, doublereal* alpha,
    doublecomplex* X, integer* incX, doublecomplex* Ap);

int maloc_zher2(char* uplo, integer* N, doublecomplex* alpha,
    doublecomplex* X, integer* incX, doublecomplex* Y, integer* incY,
    doublecomplex* A, integer* lda);

int maloc_zhpr2(char* uplo, integer* N, doublecomplex* alpha,
    doublecomplex* X, integer* incX, doublecomplex* Y, integer* incY,
    doublecomplex* Ap);

int maloc_sgemm(char* transA, char* transB, integer* M, integer* N,
    integer* K, real* alpha, real* A, integer* lda, real* B, integer* ldb,
    real* beta, real* C, integer* ldc);

int maloc_ssymm(char* side, char* uplo, integer* M, integer* N,
    real* alpha, real* A, integer* lda, real* B, integer* ldb,
    real* beta, real* C, integer* ldc);

int maloc_ssyrk(char* uplo, char* trans, integer* N, integer* K,
    real* alpha, real* A, integer* lda, real* beta, real* C, integer* ldc);

int maloc_ssyr2k(char* uplo, char* trans, integer* N, integer* K,
    real* alpha, real* A, integer* lda, real* B, integer* ldb,
    real* beta, real* C, integer* ldc);

int maloc_strmm(char* side, char* uplo, char* trans, char* diag, 
    integer* M, integer* N, real* alpha, real* A, integer* lda,
    real* B, integer* ldb);

int maloc_strsm(char* side, char* uplo, char* trans, char* diag,
    integer* M, integer* N, real* alpha, real* A, integer* lda,
    real* B, integer* ldb);

int maloc_dgemm(char* transA, char* transB, integer* M, integer* N,
    integer* K, doublereal* alpha, doublereal* A, integer* lda,
    doublereal* B, integer* ldb, doublereal* beta,
    doublereal* C, integer* ldc);

int maloc_dsymm(char* side, char* uplo, integer* M, integer* N,
    doublereal* alpha, doublereal* A, integer* lda, doublereal* B,
    integer* ldb, doublereal* beta, doublereal* C, integer* ldc);

int maloc_dsyrk(char* uplo, char* trans, integer* N, integer* K,
    doublereal* alpha, doublereal* A, integer* lda, doublereal* beta,
    doublereal* C, integer* ldc);

int maloc_dsyr2k(char* uplo, char* trans, integer* N, integer* K,
    doublereal* alpha, doublereal* A, integer* lda, doublereal* B,
    integer* ldb, doublereal* beta, doublereal* C, integer* ldc);

int maloc_dtrmm(char* side, char* uplo, char* trans, char* diag, 
    integer* M, integer* N, doublereal* alpha, doublereal* A,
    integer* lda, doublereal* B, integer* ldb);

int maloc_dtrsm(char* side, char* uplo, char* trans, char* diag,
    integer* M, integer* N, doublereal* alpha, doublereal* A,
    integer* lda, doublereal* B, integer* ldb);

int maloc_cgemm(char* transA, char* transB, integer* M, integer* N,
    integer* K, complex* alpha, complex* A, integer* lda, complex* B,
    integer* ldb, complex* beta, complex* C, integer* ldc);

int maloc_csymm(char* side, char* uplo, integer* M, integer* N,
    complex* alpha, complex* A, integer* lda, complex* B, integer* ldb,
    complex* beta, complex* C, integer* ldc);

int maloc_csyrk(char* uplo, char* trans, integer* N, integer* K,
    complex* alpha, complex* A, integer* lda, complex* beta,
    complex* C, integer* ldc);

int maloc_csyr2k(char* uplo, char* trans, integer* N, integer* K,
    complex* alpha, complex* A, integer* lda, complex* B, integer* ldb,
    complex* beta, complex* C, integer* ldc);

int maloc_ctrmm(char* side, char* uplo, char* trans, char* diag, 
    integer* M, integer* N, complex* alpha, complex* A, integer* lda,
    complex* B, integer* ldb);

int maloc_ctrsm(char* side, char* uplo, char* trans, char* diag,
    integer* M, integer* N, complex* alpha, complex* A, integer* lda,
    complex* B, integer* ldb);

int maloc_zgemm(char* transA, char* transB, integer* M, integer* N,
    integer* K, doublecomplex* alpha, doublecomplex* A, integer* lda,
    doublecomplex* B, integer* ldb, doublecomplex* beta,
    doublecomplex* C, integer* ldc);

int maloc_zsymm(char* side, char* uplo, integer* M, integer* N,
    doublecomplex* alpha, doublecomplex* A, integer* lda, doublecomplex* B,
    integer* ldb, doublecomplex* beta, doublecomplex* C, integer* ldc);

int maloc_zsyrk(char* uplo, char* trans, integer* N, integer* K,
    doublecomplex* alpha, doublecomplex* A, integer* lda,
    doublecomplex* beta, doublecomplex* C, integer* ldc);

int maloc_zsyr2k(char* uplo, char* trans, integer* N, integer* K,
    doublecomplex* alpha, doublecomplex* A, integer* lda, doublecomplex* B,
    integer* ldb, doublecomplex* beta, doublecomplex* C, integer* ldc);

int maloc_ztrmm(char* side, char* uplo, char* trans, char* diag, 
    integer* M, integer* N, doublecomplex* alpha, doublecomplex* A,
    integer* lda, doublecomplex* B, integer* ldb);

int maloc_ztrsm(char* side, char* uplo, char* trans, char* diag,
    integer* M, integer* N, doublecomplex* alpha, doublecomplex* A,
    integer* lda, doublecomplex* B, integer* ldb);

int maloc_chemm(char* side, char* uplo, integer* M, integer* N,
    complex* alpha, complex* A, integer* lda, complex* B, integer* ldb,
    complex* beta, complex* C, integer* ldc);

int maloc_cherk(char* uplo, char* trans, integer* N, integer* K,
    real* alpha, complex* A, integer* lda, real* beta,
    complex* C, integer* ldc);

int maloc_cher2k(char* uplo, char* trans, integer* N, integer* K,
    complex* alpha, complex* A, integer* lda, complex* B, integer* ldb,
    real* beta, complex* C, integer* ldc);

int maloc_zhemm(char* side, char* uplo, integer* M, integer* N,
    doublecomplex* alpha, doublecomplex* A, integer* lda, doublecomplex* B,
    integer* ldb, doublecomplex* beta, doublecomplex* C, integer* ldc);

int maloc_zherk(char* uplo, char* trans, integer* N, integer* K,
    doublereal* alpha, doublecomplex* A, integer* lda, doublereal* beta,
    doublecomplex* C, integer* ldc);

int maloc_zher2k(char* uplo, char* trans, integer* N, integer* K,
    doublecomplex* alpha, doublecomplex* A, integer* lda, doublecomplex* B,
    integer* ldb, doublereal* beta, doublecomplex* C, integer* ldc);

#endif /* _VBLAS_H_ */

