/*
 * ***************************************************************************
 * MALOC = < Minimal Abstraction Layer for Object-oriented C >
 * Copyright (C) 1994--2000  Michael Holst
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * rcsid="$Id: blasfb.c,v 1.6 2002/11/10 07:17:02 mholst Exp $"
 * ***************************************************************************
 */

/*
 * ***************************************************************************
 * File:     blasfb.c
 *
 * Purpose:  FORTRAN bindings for the BLAS.
 *
 * Notes:    We provide FORTRAN stubs for the following manglings:
 *
 *               maloc_vrnd --> default
 *
 *               vrnd   --> no underscore,     lowercase
 *               VRND   --> no underscore,     uppercase
 *               vrnd_  --> single underscore, lowercase
 *               VRND_  --> single underscore, uppercase
 *               vrnd__ --> double underscore, lowercase
 *               VRND__ --> double underscore, uppercase
 *
 * Author:   Michael Holst
 * ***************************************************************************
 */

#include <maloc/vblas.h>

/*
 * ***************************************************************************
 * Class BLAS FORTRAN binding STUBS (no underscore, lowercase)
 * ***************************************************************************
 */

real sdot(integer* N, real* X, integer* incX, real* Y, integer* incY)
{
    return maloc_sdot(N, X, incX, Y, incY);
}

doublereal ddot(integer* N, doublereal* X, integer* incX,
    doublereal* Y, integer* incY)
{
    return maloc_ddot(N, X, incX, Y, incY);
}

void cdotu(complex* retval, integer* N, complex* X, integer* incX,
    complex* Y, integer* incY)
{
    maloc_cdotu(retval, N, X, incX, Y, incY);
}

void cdotc(complex* retval, integer* N, complex* X, integer* incX,
    complex* Y, integer* incY)
{
    maloc_cdotc(retval, N, X, incX, Y, incY);
}

void zdotu(doublecomplex* retval, integer* N, doublecomplex* X,
    integer* incX, doublecomplex* Y, integer* incY)
{
    maloc_zdotu(retval, N, X, incX, Y, incY);
}

void zdotc(doublecomplex* retval, integer* N, doublecomplex* X,
    integer* incX, doublecomplex* Y, integer* incY)
{
    maloc_zdotc(retval, N, X, incX, Y, incY);
}

real snrm2(integer* N, real* X, integer* incX)
{
    return maloc_snrm2(N, X, incX);
}

real sasum(integer* N, real* X, integer* incX)
{
    return maloc_sasum(N, X, incX);
}

doublereal dnrm2(integer* N, doublereal* X, integer* incX)
{
    return maloc_dnrm2(N, X, incX);
}

doublereal dasum(integer* N, doublereal* X, integer* incX)
{
    return maloc_dasum(N, X, incX);
}

real scnrm2(integer* N, complex* X, integer* incX)
{
    return maloc_scnrm2(N, X, incX);
}

real scasum(integer* N, complex* X, integer* incX)
{
    return maloc_scasum(N, X, incX);
}

doublereal dznrm2(integer* N, doublecomplex* X, integer* incX)
{
    return maloc_dznrm2(N, X, incX);
}

doublereal dzasum(integer* N, doublecomplex* X, integer* incX)
{
    return maloc_dzasum(N, X, incX);
}

integer isamax(integer* N, real* X, integer* incX)
{
    return maloc_isamax(N, X, incX);
}

integer idamax(integer* N, doublereal* X, integer* incX)
{
    return maloc_idamax(N, X, incX);
}

integer icamax(integer* N, complex* X, integer* incX)
{
    return maloc_icamax(N, X, incX);
}

integer izamax(integer* N, doublecomplex* X, integer* incX)
{
    return maloc_izamax(N, X, incX);
}

int sswap(integer* N, real* X, integer* incX, real* Y, integer* incY)
{
    return maloc_sswap(N, X, incX, Y, incY);
}

int scopy(integer* N, real* X, integer* incX, real* Y, integer* incY)
{
    return maloc_scopy(N, X, incX, Y, incY);
}

int saxpy(integer* N, real* alpha, real* X, integer* incX,
    real* Y, integer* incY)
{
    return maloc_saxpy(N, alpha, X, incX, Y, incY);
}

int dswap(integer* N, doublereal* X, integer* incX,
    doublereal* Y, integer* incY)
{
    return maloc_dswap(N, X, incX, Y, incY);
}

int dcopy(integer* N, doublereal* X, integer* incX,
    doublereal* Y, integer* incY)
{
    return maloc_dcopy(N, X, incX, Y, incY);
}

int daxpy(integer* N, doublereal* alpha, doublereal* X, integer* incX,
    doublereal* Y, integer* incY)
{
    return maloc_daxpy(N, alpha, X, incX, Y, incY);
}

int cswap(integer* N, complex* X, integer* incX,
    complex* Y, integer* incY)
{
    return maloc_cswap(N, X, incX, Y, incY);
}

int ccopy(integer* N, complex* X, integer* incX,
    complex* Y, integer* incY)
{
    return maloc_ccopy(N, X, incX, Y, incY);
}

int caxpy(integer* N, complex* alpha,
    complex* X, integer* incX, complex* Y, integer* incY)
{
    return maloc_caxpy(N, alpha, X, incX, Y, incY);
}

int zswap(integer* N, doublecomplex* X, integer* incX, doublecomplex* Y,
    integer* incY)
{
    return maloc_zswap(N, X, incX, Y, incY);
}

int zcopy(integer* N, doublecomplex* X, integer* incX, doublecomplex* Y,
    integer* incY)
{
    return maloc_zcopy(N, X, incX, Y, incY);
}

int zaxpy(integer* N, doublecomplex* alpha, doublecomplex* X,
    integer* incX, doublecomplex* Y, integer* incY)
{
    return maloc_zaxpy(N, alpha, X, incX, Y, incY);
}

int srotg(real* a, real* b, real* c, real* s)
{
    return maloc_srotg(a, b, c, s);
}

int srot(integer* N, real* X, integer* incX, real* Y, integer* incY,
    real* c, real* s)
{
    return maloc_srot(N, X, incX, Y, incY, c, s);
}

int drotg(doublereal* a, doublereal* b, doublereal* c, doublereal* s)
{
    return maloc_drotg(a, b, c, s);
}

int drot(integer* N, doublereal* X, integer* incX, doublereal* Y,
    integer* incY, doublereal* c, doublereal* s)
{
    return maloc_drot(N, X, incX, Y, incY, c, s);
}

int sscal(integer* N, real* alpha, real* X, integer* incX)
{
    return maloc_sscal(N, alpha, X, incX);
}

int dscal(integer* N, doublereal* alpha, doublereal* X, integer* incX)
{
    return maloc_dscal(N, alpha, X, incX);
}

int cscal(integer* N, complex* alpha, complex* X, integer* incX)
{
    return maloc_cscal(N, alpha, X, incX);
}

int zscal(integer* N, doublecomplex* alpha, doublecomplex* X,
    integer* incX)
{
    return maloc_zscal(N, alpha, X, incX);
}

int csscal(integer* N, real* alpha, complex* X, integer* incX)
{
    return maloc_csscal(N, alpha, X, incX);
}

int zdscal(integer* N, doublereal* alpha, doublecomplex* X,
    integer* incX)
{
    return maloc_zdscal(N, alpha, X, incX);
}

int sgemv(char* trans, integer* M, integer* N, real* alpha, real* A,
    integer* lda, real* X, integer* incX, real* beta, real* Y, integer* incY)
{
    return maloc_sgemv(trans, M, N, alpha, A, lda, X, incX, beta, Y, incY);
}

int sgbmv(char *trans, integer *M, integer *N, integer *KL, integer *KU, 
    real *alpha, real *A, integer *lda, real *X, integer *incX, real *beta, 
    real *Y, integer *incY)
{
    return maloc_sgbmv(trans, M, N, KL, KU, alpha, A, lda, X, incX, beta,
        Y, incY);
}

int strmv(char* uplo, char *trans, char* diag, integer *N, real *A,
    integer *lda, real *X, integer *incX)
{
    return maloc_strmv(uplo, trans, diag, N, A, lda, X, incX);
}

int stbmv(char* uplo, char* trans, char* diag, integer* N, integer* K,
    real* A, integer* lda, real* X, integer* incX)
{
    return maloc_stbmv(uplo, trans, diag, N, K, A, lda, X, incX);
}

int stpmv(char* uplo, char* trans, char* diag, integer* N, real* Ap, 
    real* X, integer* incX)
{
    return maloc_stpmv(uplo, trans, diag, N, Ap, X, incX);
}

int strsv(char* uplo, char* trans, char* diag, integer* N, real* A,
    integer* lda, real* X, integer* incX)
{
    return maloc_strsv(uplo, trans, diag, N, A, lda, X, incX);
}

int stbsv(char* uplo, char* trans, char* diag, integer* N, integer* K,
    real* A, integer* lda, real* X, integer* incX)
{
    return maloc_stbsv(uplo, trans, diag, N, K, A, lda, X, incX);
}

int stpsv(char* uplo, char* trans, char* diag, integer* N, real* Ap, 
    real* X, integer* incX)
{
    return maloc_stpsv(uplo, trans, diag, N, Ap, X, incX);
}

int dgemv(char* trans, integer* M, integer* N, doublereal* alpha,
    doublereal* A, integer* lda, doublereal* X, integer* incX,
    doublereal* beta, doublereal* Y, integer* incY)
{
    return maloc_dgemv(trans, M, N, alpha, A, lda, X, incX, beta, Y, incY);
}

int dgbmv(char *trans, integer *M, integer *N, integer *KL, integer *KU, 
    doublereal *alpha, doublereal *A, integer *lda, doublereal *X,
    integer *incX, doublereal *beta, doublereal *Y, integer *incY)
{
    return maloc_dgbmv(trans, M, N, KL, KU, alpha, A, lda, X, incX, beta,
        Y, incY);
}

int dtrmv(char* uplo, char *trans, char* diag, integer *N,  
    doublereal *A, integer *lda, doublereal *X, integer *incX)
{
    return maloc_dtrmv(uplo, trans, diag, N, A, lda, X, incX);
}

int dtbmv(char* uplo, char* trans, char* diag, integer* N, integer* K,
    doublereal* A, integer* lda, doublereal* X, integer* incX)
{
    return maloc_dtbmv(uplo, trans, diag, N, K, A, lda, X, incX);
}

int dtpmv(char* uplo, char* trans, char* diag, integer* N, 
    doublereal* Ap, doublereal* X, integer* incX)
{
    return maloc_dtpmv(uplo, trans, diag, N, Ap, X, incX);
}

int dtrsv(char* uplo, char* trans, char* diag, integer* N,
    doublereal* A, integer* lda, doublereal* X, integer* incX)
{
    return maloc_dtrsv(uplo, trans, diag, N, A, lda, X, incX);
}

int dtbsv(char* uplo, char* trans, char* diag, integer* N, integer* K,
    doublereal* A, integer* lda, doublereal* X, integer* incX)
{
    return maloc_dtbsv(uplo, trans, diag, N, K, A, lda, X, incX);
}

int dtpsv(char* uplo, char* trans, char* diag, integer* N, 
    doublereal* Ap, doublereal* X, integer* incX)
{
    return maloc_dtpsv(uplo, trans, diag, N, Ap, X, incX);
}

int cgemv(char* trans, integer* M, integer* N, complex* alpha,
    complex* A, integer* lda, complex* X, integer* incX, complex* beta,
    complex* Y, integer* incY)
{
    return maloc_cgemv(trans, M, N, alpha, A, lda, X, incX, beta, Y, incY);
}

int cgbmv(char *trans, integer *M, integer *N, integer *KL, integer *KU, 
    complex *alpha, complex *A, integer *lda, complex *X, integer *incX, 
    complex *beta, complex *Y, integer *incY)
{
    return maloc_cgbmv(trans, M, N, KL, KU, alpha, A, lda, X, incX, beta,
        Y, incY);
}

int ctrmv(char* uplo, char *trans, char* diag, integer *N,  
    complex *A, integer *lda, complex *X, integer *incX)
{
    return maloc_ctrmv(uplo, trans, diag, N, A, lda, X, incX);
}

int ctbmv(char* uplo, char* trans, char* diag, integer* N, integer* K,
    complex* A, integer* lda, complex* X, integer* incX)
{
    return maloc_ctbmv(uplo, trans, diag, N, K, A, lda, X, incX);
}

int ctpmv(char* uplo, char* trans, char* diag, integer* N, 
    complex* Ap, complex* X, integer* incX)
{
    return maloc_ctpmv(uplo, trans, diag, N, Ap, X, incX);
}

int ctrsv(char* uplo, char* trans, char* diag, integer* N,
    complex* A, integer* lda, complex* X, integer* incX)
{
    return maloc_ctrsv(uplo, trans, diag, N, A, lda, X, incX);
}

int ctbsv(char* uplo, char* trans, char* diag, integer* N, integer* K,
    complex* A, integer* lda, complex* X, integer* incX)
{
    return maloc_ctbsv(uplo, trans, diag, N, K, A, lda, X, incX);
}

int ctpsv(char* uplo, char* trans, char* diag, integer* N, 
    complex* Ap, complex* X, integer* incX)
{
    return maloc_ctpsv(uplo, trans, diag, N, Ap, X, incX);
}

int zgemv(char* trans, integer* M, integer* N, doublecomplex* alpha,
    doublecomplex* A, integer* lda, doublecomplex* X, integer* incX,
    doublecomplex* beta, doublecomplex* Y, integer* incY)
{
    return maloc_zgemv(trans, M, N, alpha, A, lda, X, incX, beta, Y, incY);
}

int zgbmv(char *trans, integer *M, integer *N, integer *KL, integer *KU, 
    doublecomplex *alpha, doublecomplex *A, integer *lda, doublecomplex *X,
    integer *incX, doublecomplex *beta, doublecomplex *Y, integer *incY)
{
    return maloc_zgbmv(trans, M, N, KL, KU, alpha, A, lda, X, incX, beta,
        Y, incY);
}

int ztrmv(char* uplo, char *trans, char* diag, integer *N,  
    doublecomplex *A, integer *lda, doublecomplex *X, integer *incX)
{
    return maloc_ztrmv(uplo, trans, diag, N, A, lda, X, incX);
}

int ztbmv(char* uplo, char* trans, char* diag, integer* N, integer* K,
    doublecomplex* A, integer* lda, doublecomplex* X, integer* incX)
{
    return maloc_ztbmv(uplo, trans, diag, N, K, A, lda, X, incX);
}

void ztpmv(char* uplo, char* trans, char* diag, integer* N, 
    doublecomplex* Ap, doublecomplex* X, integer* incX)
{
    maloc_ztpmv(uplo, trans, diag, N, Ap, X, incX);
}

int ztrsv(char* uplo, char* trans, char* diag, integer* N,
    doublecomplex* A, integer* lda, doublecomplex* X, integer* incX)
{
    return maloc_ztrsv(uplo, trans, diag, N, A, lda, X, incX);
}

int ztbsv(char* uplo, char* trans, char* diag, integer* N, integer* K,
    doublecomplex* A, integer* lda, doublecomplex* X, integer* incX)
{
    return maloc_ztbsv(uplo, trans, diag, N, K, A, lda, X, incX);
}

int ztpsv(char* uplo, char* trans, char* diag, integer* N, 
    doublecomplex* Ap, doublecomplex* X, integer* incX)
{
    return maloc_ztpsv(uplo, trans, diag, N, Ap, X, incX);
}

int ssymv(char* uplo, integer* N, real* alpha, real* A, integer* lda,
    real* X, integer* incX, real* beta, real* Y, integer* incY)
{
    return maloc_ssymv(uplo, N, alpha, A, lda, X, incX, beta, Y, incY);
}

int ssbmv(char* uplo, integer* N, integer* K, real* alpha,
    real* A, integer* lda, real* X, integer* incX, real* beta,
    real* Y, integer* incY)
{
    return maloc_ssbmv(uplo, N, K, alpha, A, lda, X, incX, beta, Y, incY);
}

int sspmv(char* uplo, integer* N, real* alpha, real* Ap,
    real* X, integer* incX, real* beta, real* Y, integer* incY)
{
    return maloc_sspmv(uplo, N, alpha, Ap, X, incX, beta, Y, incY);
}

int sger(integer* M, integer* N, real* alpha, real* X, integer* incX,
    real* Y, integer* incY, real* A, integer* lda)
{
    return maloc_sger(M, N, alpha, X, incX, Y, incY, A, lda);
}

int ssyr(char* uplo, integer* N, real* alpha, real* X, integer* incX,
    real* A, integer* lda)
{
    return maloc_ssyr(uplo, N, alpha, X, incX, A, lda);
}

int sspr(char* uplo, integer* N, real* alpha, real* X, integer* incX,
    real* Ap)
{
    return maloc_sspr(uplo, N, alpha, X, incX, Ap);
}

int ssyr2(char* uplo, integer* N, real* alpha, real* X, integer* incX,
    real* Y, integer* incY, real* A, integer* lda)
{
    return maloc_ssyr2(uplo, N, alpha, X, incX, Y, incY, A, lda);
}

int sspr2(char* uplo, integer* N, real* alpha, real* X, integer* incX,
    real* Y, integer* incY, real* A)
{
    return maloc_sspr2(uplo, N, alpha, X, incX, Y, incY, A);
}

int dsymv(char* uplo, integer* N, doublereal* alpha, doublereal* A,
    integer* lda, doublereal* X, integer* incX, doublereal* beta,
    doublereal* Y, integer* incY)
{
    return maloc_dsymv(uplo, N, alpha, A, lda, X, incX, beta, Y, incY);
}

int dsbmv(char* uplo, integer* N, integer* K, doublereal* alpha,
    doublereal* A, integer* lda, doublereal* X, integer* incX,
    doublereal* beta, doublereal* Y, integer* incY)
{
    return maloc_dsbmv(uplo, N, K, alpha, A, lda, X, incX, beta, Y, incY);
}

int dspmv(char* uplo, integer* N, doublereal* alpha, doublereal* Ap,
    doublereal* X, integer* incX, doublereal* beta,
    doublereal* Y, integer* incY)
{
    return maloc_dspmv(uplo, N, alpha, Ap, X, incX, beta, Y, incY);
}

int dger(integer* M, integer* N, doublereal* alpha, doublereal* X,
    integer* incX, doublereal* Y, integer* incY, doublereal* A, integer* lda)
{
    return maloc_dger(M, N, alpha, X, incX, Y, incY, A, lda);
}

int dsyr(char* uplo, integer* N, doublereal* alpha, doublereal* X,
    integer* incX, doublereal* A, integer* lda)
{
    return maloc_dsyr(uplo, N, alpha, X, incX, A, lda);
}

int dspr(char* uplo, integer* N, doublereal* alpha, doublereal* X,
    integer* incX, doublereal* Ap)
{
    return maloc_dspr(uplo, N, alpha, X, incX, Ap);
}

int dsyr2(char* uplo, integer* N, doublereal* alpha, doublereal* X,
    integer* incX, doublereal* Y, integer* incY, doublereal* A, integer* lda)
{
    return maloc_dsyr2(uplo, N, alpha, X, incX, Y, incY, A, lda);
}

int dspr2(char* uplo, integer* N, doublereal* alpha, doublereal* X,
    integer* incX, doublereal* Y, integer* incY, doublereal* A)
{
    return maloc_dspr2(uplo, N, alpha, X, incX, Y, incY, A);
}

int chemv(char* uplo, integer* N, complex* alpha, complex* A,
    integer* lda, complex* X, integer* incX, complex* beta,
    complex* Y, integer* incY)
{
    return maloc_chemv(uplo, N, alpha, A, lda, X, incX, beta, Y, incY);
}

int chbmv(char* uplo, integer* N, integer* K, complex* alpha,
    complex* A, integer* lda, complex* X, integer* incX, complex* beta,
    complex* Y, integer* incY)
{
    return maloc_chbmv(uplo, N, K, alpha, A, lda, X, incX, beta, Y, incY);
}

int chpmv(char* uplo, integer* N, complex* alpha, complex* Ap, 
    complex* X, integer* incX, complex* beta, complex* Y, integer* incY)
{
    return maloc_chpmv(uplo, N, alpha, Ap, X, incX, beta, Y, incY);
}

int cgeru(integer* M, integer* N, complex* alpha, complex* X,
    integer* incX, complex* Y, integer* incY, complex* A, integer* lda)
{
    return maloc_cgeru(M, N, alpha, X, incX, Y, incY, A, lda);
}

int cgerc(integer* M, integer* N, complex* alpha, complex* X,
    integer* incX, complex* Y, integer* incY, complex* A, integer* lda)
{
    return maloc_cgerc(M, N, alpha, X, incX, Y, incY, A, lda);
}

int cher(char* uplo, integer* N, real* alpha, complex* X, integer* incX,
    complex* A, integer* lda)
{
    return maloc_cher(uplo, N, alpha, X, incX, A, lda);
}

int chpr(char* uplo, integer* N, real* alpha, complex* X, integer* incX,
    complex* Ap)
{
    return maloc_chpr(uplo, N, alpha, X, incX, Ap);
}

int cher2(char* uplo, integer* N, complex* alpha, complex* X,
    integer* incX, complex* Y, integer* incY, complex* A, integer* lda)
{
    return maloc_cher2(uplo, N, alpha, X, incX, Y, incY, A, lda);
}

int chpr2(char* uplo, integer* N, complex* alpha, complex* X,
    integer* incX, complex* Y, integer* incY, complex* Ap)
{
    return maloc_chpr2(uplo, N, alpha, X, incX, Y, incY, Ap);
}

int zhemv(char* uplo, integer* N, doublecomplex* alpha,
    doublecomplex* A, integer* lda, doublecomplex* X, integer* incX,
    doublecomplex* beta, doublecomplex* Y, integer* incY)
{
    return maloc_zhemv(uplo, N, alpha, A, lda, X, incX, beta, Y, incY);
}

int zhbmv(char* uplo, integer* N, integer* K, doublecomplex* alpha,
    doublecomplex* A, integer* lda, doublecomplex* X, integer* incX,
    doublecomplex* beta, doublecomplex* Y, integer* incY)
{
    return maloc_zhbmv(uplo, N, K, alpha, A, lda, X, incX, beta, Y, incY);
}

int zhpmv(char* uplo, integer* N, doublecomplex* alpha,
    doublecomplex* Ap, doublecomplex* X, integer* incX,
    doublecomplex* beta, doublecomplex* Y, integer* incY)
{
    return maloc_zhpmv(uplo, N, alpha, Ap, X, incX, beta, Y, incY);
}

int zgeru(integer* M, integer* N, doublecomplex* alpha,
    doublecomplex* X, integer* incX, doublecomplex* Y, integer* incY,
    doublecomplex* A, integer* lda)
{
    return maloc_zgeru(M, N, alpha, X, incX, Y, incY, A, lda);
}

int zgerc(integer* M, integer* N, doublecomplex* alpha,
    doublecomplex* X, integer* incX, doublecomplex* Y, integer* incY,
    doublecomplex* A, integer* lda)
{
    return maloc_zgerc(M, N, alpha, X, incX, Y, incY, A, lda);
}

int zher(char* uplo, integer* N, doublereal* alpha,
    doublecomplex* X, integer* incX, doublecomplex* A, integer* lda)
{
    return maloc_zher(uplo, N, alpha, X, incX, A, lda);
}

int zhpr(char* uplo, integer* N, doublereal* alpha,
    doublecomplex* X, integer* incX, doublecomplex* Ap)
{
    return maloc_zhpr(uplo, N, alpha, X, incX, Ap);
}

int zher2(char* uplo, integer* N, doublecomplex* alpha,
    doublecomplex* X, integer* incX, doublecomplex* Y, integer* incY,
    doublecomplex* A, integer* lda)
{
    return maloc_zher2(uplo, N, alpha, X, incX, Y, incY, A, lda);
}

int zhpr2(char* uplo, integer* N, doublecomplex* alpha,
    doublecomplex* X, integer* incX, doublecomplex* Y, integer* incY,
    doublecomplex* Ap)
{
    return maloc_zhpr2(uplo, N, alpha, X, incX, Y, incY, Ap);
}

int sgemm(char* transA, char* transB, integer* M, integer* N,
    integer* K, real* alpha, real* A, integer* lda, real* B, integer* ldb,
    real* beta, real* C, integer* ldc)
{
    return maloc_sgemm(transA, transB, M, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

int ssymm(char* side, char* uplo, integer* M, integer* N,
    real* alpha, real* A, integer* lda, real* B, integer* ldb,
    real* beta, real* C, integer* ldc)
{
    return maloc_ssymm(side, uplo, M, N, alpha, A, lda, B, ldb, beta, C, ldc);
}

int ssyrk(char* uplo, char* trans, integer* N, integer* K,
    real* alpha, real* A, integer* lda, real* beta, real* C, integer* ldc)
{
    return maloc_ssyrk(uplo, trans, N, K, alpha, A, lda, beta, C, ldc);
}

int ssyr2k(char* uplo, char* trans, integer* N, integer* K,
    real* alpha, real* A, integer* lda, real* B, integer* ldb,
    real* beta, real* C, integer* ldc)
{
    return maloc_ssyr2k(uplo, trans, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

int strmm(char* side, char* uplo, char* trans, char* diag, 
    integer* M, integer* N, real* alpha, real* A, integer* lda,
    real* B, integer* ldb)
{
    return maloc_strmm(side, uplo, trans, diag, M, N, alpha, A, lda, B, ldb);
}

int strsm(char* side, char* uplo, char* trans, char* diag,
    integer* M, integer* N, real* alpha, real* A, integer* lda,
    real* B, integer* ldb)
{
    return maloc_strsm(side, uplo, trans, diag, M, N, alpha, A, lda, B, ldb);
}

int dgemm(char* transA, char* transB, integer* M, integer* N,
    integer* K, doublereal* alpha, doublereal* A, integer* lda,
    doublereal* B, integer* ldb, doublereal* beta,
    doublereal* C, integer* ldc)
{
    return maloc_dgemm(transA, transB, M, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

int dsymm(char* side, char* uplo, integer* M, integer* N,
    doublereal* alpha, doublereal* A, integer* lda, doublereal* B,
    integer* ldb, doublereal* beta, doublereal* C, integer* ldc)
{
    return maloc_dsymm(side, uplo, M, N, alpha, A, lda, B, ldb, beta, C, ldc);
}

int dsyrk(char* uplo, char* trans, integer* N, integer* K,
    doublereal* alpha, doublereal* A, integer* lda, doublereal* beta,
    doublereal* C, integer* ldc)
{
    return maloc_dsyrk(uplo, trans, N, K, alpha, A, lda, beta, C, ldc);
}

int dsyr2k(char* uplo, char* trans, integer* N, integer* K,
    doublereal* alpha, doublereal* A, integer* lda, doublereal* B,
    integer* ldb, doublereal* beta, doublereal* C, integer* ldc)
{
    return maloc_dsyr2k(uplo, trans, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

int dtrmm(char* side, char* uplo, char* trans, char* diag, 
    integer* M, integer* N, doublereal* alpha, doublereal* A,
    integer* lda, doublereal* B, integer* ldb)
{
    return maloc_dtrmm(side, uplo, trans, diag, M, N, alpha, A, lda, B, ldb);
}

int dtrsm(char* side, char* uplo, char* trans, char* diag,
    integer* M, integer* N, doublereal* alpha, doublereal* A,
    integer* lda, doublereal* B, integer* ldb)
{
    return maloc_dtrsm(side, uplo, trans, diag, M, N, alpha, A, lda, B, ldb);
}

int cgemm(char* transA, char* transB, integer* M, integer* N,
    integer* K, complex* alpha, complex* A, integer* lda, complex* B,
    integer* ldb, complex* beta, complex* C, integer* ldc)
{
    return maloc_cgemm(transA, transB, M, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

int csymm(char* side, char* uplo, integer* M, integer* N,
    complex* alpha, complex* A, integer* lda, complex* B, integer* ldb,
    complex* beta, complex* C, integer* ldc)
{
    return maloc_csymm(side, uplo, M, N, alpha, A, lda, B, ldb, beta, C, ldc);
}

int csyrk(char* uplo, char* trans, integer* N, integer* K,
    complex* alpha, complex* A, integer* lda, complex* beta,
    complex* C, integer* ldc)
{
    return maloc_csyrk(uplo, trans, N, K, alpha, A, lda, beta, C, ldc);
}

int csyr2k(char* uplo, char* trans, integer* N, integer* K,
    complex* alpha, complex* A, integer* lda, complex* B, integer* ldb,
    complex* beta, complex* C, integer* ldc)
{
    return maloc_csyr2k(uplo, trans, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

int ctrmm(char* side, char* uplo, char* trans, char* diag, 
    integer* M, integer* N, complex* alpha, complex* A, integer* lda,
    complex* B, integer* ldb)
{
    return maloc_ctrmm(side, uplo, trans, diag, M, N, alpha, A, lda, B, ldb);
}

int ctrsm(char* side, char* uplo, char* trans, char* diag,
    integer* M, integer* N, complex* alpha, complex* A, integer* lda,
    complex* B, integer* ldb)
{
    return maloc_ctrsm(side, uplo, trans, diag, M, N, alpha, A, lda, B, ldb);
}

int zgemm(char* transA, char* transB, integer* M, integer* N,
    integer* K, doublecomplex* alpha, doublecomplex* A, integer* lda,
    doublecomplex* B, integer* ldb, doublecomplex* beta,
    doublecomplex* C, integer* ldc)
{
    return maloc_zgemm(transA, transB, M, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

int zsymm(char* side, char* uplo, integer* M, integer* N,
    doublecomplex* alpha, doublecomplex* A, integer* lda, doublecomplex* B,
    integer* ldb, doublecomplex* beta, doublecomplex* C, integer* ldc)
{
    return maloc_zsymm(side, uplo, M, N, alpha, A, lda, B, ldb, beta, C, ldc);
}

int zsyrk(char* uplo, char* trans, integer* N, integer* K,
    doublecomplex* alpha, doublecomplex* A, integer* lda,
    doublecomplex* beta, doublecomplex* C, integer* ldc)
{
    return maloc_zsyrk(uplo, trans, N, K, alpha, A, lda, beta, C, ldc);
}

int zsyr2k(char* uplo, char* trans, integer* N, integer* K,
    doublecomplex* alpha, doublecomplex* A, integer* lda, doublecomplex* B,
    integer* ldb, doublecomplex* beta, doublecomplex* C, integer* ldc)
{
    return maloc_zsyr2k(uplo, trans, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

int ztrmm(char* side, char* uplo, char* trans, char* diag, 
    integer* M, integer* N, doublecomplex* alpha, doublecomplex* A,
    integer* lda, doublecomplex* B, integer* ldb)
{
    return maloc_ztrmm(side, uplo, trans, diag, M, N, alpha, A, lda, B, ldb);
}

int ztrsm(char* side, char* uplo, char* trans, char* diag,
    integer* M, integer* N, doublecomplex* alpha, doublecomplex* A,
    integer* lda, doublecomplex* B, integer* ldb)
{
    return maloc_ztrsm(side, uplo, trans, diag, M, N, alpha, A, lda, B, ldb);
}

int chemm(char* side, char* uplo, integer* M, integer* N,
    complex* alpha, complex* A, integer* lda, complex* B, integer* ldb,
    complex* beta, complex* C, integer* ldc)
{
    return maloc_chemm(side, uplo, M, N, alpha, A, lda, B, ldb, beta, C, ldc);
}

int cherk(char* uplo, char* trans, integer* N, integer* K,
    real* alpha, complex* A, integer* lda, real* beta,
    complex* C, integer* ldc)
{
    return maloc_cherk(uplo, trans, N, K, alpha, A, lda, beta, C, ldc);
}

int cher2k(char* uplo, char* trans, integer* N, integer* K,
    complex* alpha, complex* A, integer* lda, complex* B, integer* ldb,
    real* beta, complex* C, integer* ldc)
{
    return maloc_cher2k(uplo, trans, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

int zhemm(char* side, char* uplo, integer* M, integer* N,
    doublecomplex* alpha, doublecomplex* A, integer* lda, doublecomplex* B,
    integer* ldb, doublecomplex* beta, doublecomplex* C, integer* ldc)
{
    return maloc_zhemm(side, uplo, M, N, alpha, A, lda, B, ldb, beta, C, ldc);
}

int zherk(char* uplo, char* trans, integer* N, integer* K,
    doublereal* alpha, doublecomplex* A, integer* lda, doublereal* beta,
    doublecomplex* C, integer* ldc)
{
    return maloc_zherk(uplo, trans, N, K, alpha, A, lda, beta, C, ldc);
}

int zher2k(char* uplo, char* trans, integer* N, integer* K,
    doublecomplex* alpha, doublecomplex* A, integer* lda, doublecomplex* B,
    integer* ldb, doublereal* beta, doublecomplex* C, integer* ldc)
{
    return maloc_zher2k(uplo, trans, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

/*
 * ***************************************************************************
 * Class BLAS FORTRAN binding STUBS (no underscore, uppercase)
 * ***************************************************************************
 */

real SDOT(integer* N, real* X, integer* incX, real* Y, integer* incY)
{
    return maloc_sdot(N, X, incX, Y, incY);
}

doublereal DDOT(integer* N, doublereal* X, integer* incX,
    doublereal* Y, integer* incY)
{
    return maloc_ddot(N, X, incX, Y, incY);
}

void CDOTU(complex* retval, integer* N, complex* X, integer* incX,
    complex* Y, integer* incY)
{
    maloc_cdotu(retval, N, X, incX, Y, incY);
}

void CDOTC(complex* retval, integer* N, complex* X, integer* incX,
    complex* Y, integer* incY)
{
    maloc_cdotc(retval, N, X, incX, Y, incY);
}

void ZDOTU(doublecomplex* retval, integer* N, doublecomplex* X,
    integer* incX, doublecomplex* Y, integer* incY)
{
    maloc_zdotu(retval, N, X, incX, Y, incY);
}

void ZDOTC(doublecomplex* retval, integer* N, doublecomplex* X,
    integer* incX, doublecomplex* Y, integer* incY)
{
    maloc_zdotc(retval, N, X, incX, Y, incY);
}

real SNRM2(integer* N, real* X, integer* incX)
{
    return maloc_snrm2(N, X, incX);
}

real SASUM(integer* N, real* X, integer* incX)
{
    return maloc_sasum(N, X, incX);
}

doublereal DNRM2(integer* N, doublereal* X, integer* incX)
{
    return maloc_dnrm2(N, X, incX);
}

doublereal DASUM(integer* N, doublereal* X, integer* incX)
{
    return maloc_dasum(N, X, incX);
}

real SCNRM2(integer* N, complex* X, integer* incX)
{
    return maloc_scnrm2(N, X, incX);
}

real SCASUM(integer* N, complex* X, integer* incX)
{
    return maloc_scasum(N, X, incX);
}

doublereal DZNRM2(integer* N, doublecomplex* X, integer* incX)
{
    return maloc_dznrm2(N, X, incX);
}

doublereal DZASUM(integer* N, doublecomplex* X, integer* incX)
{
    return maloc_dzasum(N, X, incX);
}

integer ISAMAX(integer* N, real* X, integer* incX)
{
    return maloc_isamax(N, X, incX);
}

integer IDAMAX(integer* N, doublereal* X, integer* incX)
{
    return maloc_idamax(N, X, incX);
}

integer ICAMAX(integer* N, complex* X, integer* incX)
{
    return maloc_icamax(N, X, incX);
}

integer IZAMAX(integer* N, doublecomplex* X, integer* incX)
{
    return maloc_izamax(N, X, incX);
}

int SSWAP(integer* N, real* X, integer* incX, real* Y, integer* incY)
{
    return maloc_sswap(N, X, incX, Y, incY);
}

int SCOPY(integer* N, real* X, integer* incX, real* Y, integer* incY)
{
    return maloc_scopy(N, X, incX, Y, incY);
}

int SAXPY(integer* N, real* alpha, real* X, integer* incX,
    real* Y, integer* incY)
{
    return maloc_saxpy(N, alpha, X, incX, Y, incY);
}

int DSWAP(integer* N, doublereal* X, integer* incX,
    doublereal* Y, integer* incY)
{
    return maloc_dswap(N, X, incX, Y, incY);
}

int DCOPY(integer* N, doublereal* X, integer* incX,
    doublereal* Y, integer* incY)
{
    return maloc_dcopy(N, X, incX, Y, incY);
}

int DAXPY(integer* N, doublereal* alpha, doublereal* X, integer* incX,
    doublereal* Y, integer* incY)
{
    return maloc_daxpy(N, alpha, X, incX, Y, incY);
}

int CSWAP(integer* N, complex* X, integer* incX,
    complex* Y, integer* incY)
{
    return maloc_cswap(N, X, incX, Y, incY);
}

int CCOPY(integer* N, complex* X, integer* incX,
    complex* Y, integer* incY)
{
    return maloc_ccopy(N, X, incX, Y, incY);
}

int CAXPY(integer* N, complex* alpha,
    complex* X, integer* incX, complex* Y, integer* incY)
{
    return maloc_caxpy(N, alpha, X, incX, Y, incY);
}

int ZSWAP(integer* N, doublecomplex* X, integer* incX, doublecomplex* Y,
    integer* incY)
{
    return maloc_zswap(N, X, incX, Y, incY);
}

int ZCOPY(integer* N, doublecomplex* X, integer* incX, doublecomplex* Y,
    integer* incY)
{
    return maloc_zcopy(N, X, incX, Y, incY);
}

int ZAXPY(integer* N, doublecomplex* alpha, doublecomplex* X,
    integer* incX, doublecomplex* Y, integer* incY)
{
    return maloc_zaxpy(N, alpha, X, incX, Y, incY);
}

int SROTG(real* a, real* b, real* c, real* s)
{
    return maloc_srotg(a, b, c, s);
}

int SROT(integer* N, real* X, integer* incX, real* Y, integer* incY,
    real* c, real* s)
{
    return maloc_srot(N, X, incX, Y, incY, c, s);
}

int DROTG(doublereal* a, doublereal* b, doublereal* c, doublereal* s)
{
    return maloc_drotg(a, b, c, s);
}

int DROT(integer* N, doublereal* X, integer* incX, doublereal* Y,
    integer* incY, doublereal* c, doublereal* s)
{
    return maloc_drot(N, X, incX, Y, incY, c, s);
}

int SSCAL(integer* N, real* alpha, real* X, integer* incX)
{
    return maloc_sscal(N, alpha, X, incX);
}

int DSCAL(integer* N, doublereal* alpha, doublereal* X, integer* incX)
{
    return maloc_dscal(N, alpha, X, incX);
}

int CSCAL(integer* N, complex* alpha, complex* X, integer* incX)
{
    return maloc_cscal(N, alpha, X, incX);
}

int ZSCAL(integer* N, doublecomplex* alpha, doublecomplex* X,
    integer* incX)
{
    return maloc_zscal(N, alpha, X, incX);
}

int CSSCAL(integer* N, real* alpha, complex* X, integer* incX)
{
    return maloc_csscal(N, alpha, X, incX);
}

int ZDSCAL(integer* N, doublereal* alpha, doublecomplex* X,
    integer* incX)
{
    return maloc_zdscal(N, alpha, X, incX);
}

int SGEMV(char* trans, integer* M, integer* N, real* alpha, real* A,
    integer* lda, real* X, integer* incX, real* beta, real* Y, integer* incY)
{
    return maloc_sgemv(trans, M, N, alpha, A, lda, X, incX, beta, Y, incY);
}

int SGBMV(char *trans, integer *M, integer *N, integer *KL, integer *KU, 
    real *alpha, real *A, integer *lda, real *X, integer *incX, real *beta, 
    real *Y, integer *incY)
{
    return maloc_sgbmv(trans, M, N, KL, KU, alpha, A, lda, X, incX, beta,
        Y, incY);
}

int STRMV(char* uplo, char *trans, char* diag, integer *N, real *A,
    integer *lda, real *X, integer *incX)
{
    return maloc_strmv(uplo, trans, diag, N, A, lda, X, incX);
}

int STBMV(char* uplo, char* trans, char* diag, integer* N, integer* K,
    real* A, integer* lda, real* X, integer* incX)
{
    return maloc_stbmv(uplo, trans, diag, N, K, A, lda, X, incX);
}

int STPMV(char* uplo, char* trans, char* diag, integer* N, real* Ap, 
    real* X, integer* incX)
{
    return maloc_stpmv(uplo, trans, diag, N, Ap, X, incX);
}

int STRSV(char* uplo, char* trans, char* diag, integer* N, real* A,
    integer* lda, real* X, integer* incX)
{
    return maloc_strsv(uplo, trans, diag, N, A, lda, X, incX);
}

int STBSV(char* uplo, char* trans, char* diag, integer* N, integer* K,
    real* A, integer* lda, real* X, integer* incX)
{
    return maloc_stbsv(uplo, trans, diag, N, K, A, lda, X, incX);
}

int STPSV(char* uplo, char* trans, char* diag, integer* N, real* Ap, 
    real* X, integer* incX)
{
    return maloc_stpsv(uplo, trans, diag, N, Ap, X, incX);
}

int DGEMV(char* trans, integer* M, integer* N, doublereal* alpha,
    doublereal* A, integer* lda, doublereal* X, integer* incX,
    doublereal* beta, doublereal* Y, integer* incY)
{
    return maloc_dgemv(trans, M, N, alpha, A, lda, X, incX, beta, Y, incY);
}

int DGBMV(char *trans, integer *M, integer *N, integer *KL, integer *KU, 
    doublereal *alpha, doublereal *A, integer *lda, doublereal *X,
    integer *incX, doublereal *beta, doublereal *Y, integer *incY)
{
    return maloc_dgbmv(trans, M, N, KL, KU, alpha, A, lda, X, incX, beta,
        Y, incY);
}

int DTRMV(char* uplo, char *trans, char* diag, integer *N,  
    doublereal *A, integer *lda, doublereal *X, integer *incX)
{
    return maloc_dtrmv(uplo, trans, diag, N, A, lda, X, incX);
}

int DTBMV(char* uplo, char* trans, char* diag, integer* N, integer* K,
    doublereal* A, integer* lda, doublereal* X, integer* incX)
{
    return maloc_dtbmv(uplo, trans, diag, N, K, A, lda, X, incX);
}

int DTPMV(char* uplo, char* trans, char* diag, integer* N, 
    doublereal* Ap, doublereal* X, integer* incX)
{
    return maloc_dtpmv(uplo, trans, diag, N, Ap, X, incX);
}

int DTRSV(char* uplo, char* trans, char* diag, integer* N,
    doublereal* A, integer* lda, doublereal* X, integer* incX)
{
    return maloc_dtrsv(uplo, trans, diag, N, A, lda, X, incX);
}

int DTBSV(char* uplo, char* trans, char* diag, integer* N, integer* K,
    doublereal* A, integer* lda, doublereal* X, integer* incX)
{
    return maloc_dtbsv(uplo, trans, diag, N, K, A, lda, X, incX);
}

int DTPSV(char* uplo, char* trans, char* diag, integer* N, 
    doublereal* Ap, doublereal* X, integer* incX)
{
    return maloc_dtpsv(uplo, trans, diag, N, Ap, X, incX);
}

int CGEMV(char* trans, integer* M, integer* N, complex* alpha,
    complex* A, integer* lda, complex* X, integer* incX, complex* beta,
    complex* Y, integer* incY)
{
    return maloc_cgemv(trans, M, N, alpha, A, lda, X, incX, beta, Y, incY);
}

int CGBMV(char *trans, integer *M, integer *N, integer *KL, integer *KU, 
    complex *alpha, complex *A, integer *lda, complex *X, integer *incX, 
    complex *beta, complex *Y, integer *incY)
{
    return maloc_cgbmv(trans, M, N, KL, KU, alpha, A, lda, X, incX, beta,
        Y, incY);
}

int CTRMV(char* uplo, char *trans, char* diag, integer *N,  
    complex *A, integer *lda, complex *X, integer *incX)
{
    return maloc_ctrmv(uplo, trans, diag, N, A, lda, X, incX);
}

int CTBMV(char* uplo, char* trans, char* diag, integer* N, integer* K,
    complex* A, integer* lda, complex* X, integer* incX)
{
    return maloc_ctbmv(uplo, trans, diag, N, K, A, lda, X, incX);
}

int CTPMV(char* uplo, char* trans, char* diag, integer* N, 
    complex* Ap, complex* X, integer* incX)
{
    return maloc_ctpmv(uplo, trans, diag, N, Ap, X, incX);
}

int CTRSV(char* uplo, char* trans, char* diag, integer* N,
    complex* A, integer* lda, complex* X, integer* incX)
{
    return maloc_ctrsv(uplo, trans, diag, N, A, lda, X, incX);
}

int CTBSV(char* uplo, char* trans, char* diag, integer* N, integer* K,
    complex* A, integer* lda, complex* X, integer* incX)
{
    return maloc_ctbsv(uplo, trans, diag, N, K, A, lda, X, incX);
}

int CTPSV(char* uplo, char* trans, char* diag, integer* N, 
    complex* Ap, complex* X, integer* incX)
{
    return maloc_ctpsv(uplo, trans, diag, N, Ap, X, incX);
}

int ZGEMV(char* trans, integer* M, integer* N, doublecomplex* alpha,
    doublecomplex* A, integer* lda, doublecomplex* X, integer* incX,
    doublecomplex* beta, doublecomplex* Y, integer* incY)
{
    return maloc_zgemv(trans, M, N, alpha, A, lda, X, incX, beta, Y, incY);
}

int ZGBMV(char *trans, integer *M, integer *N, integer *KL, integer *KU, 
    doublecomplex *alpha, doublecomplex *A, integer *lda, doublecomplex *X,
    integer *incX, doublecomplex *beta, doublecomplex *Y, integer *incY)
{
    return maloc_zgbmv(trans, M, N, KL, KU, alpha, A, lda, X, incX, beta,
        Y, incY);
}

int ZTRMV(char* uplo, char *trans, char* diag, integer *N,  
    doublecomplex *A, integer *lda, doublecomplex *X, integer *incX)
{
    return maloc_ztrmv(uplo, trans, diag, N, A, lda, X, incX);
}

int ZTBMV(char* uplo, char* trans, char* diag, integer* N, integer* K,
    doublecomplex* A, integer* lda, doublecomplex* X, integer* incX)
{
    return maloc_ztbmv(uplo, trans, diag, N, K, A, lda, X, incX);
}

void ZTPMV(char* uplo, char* trans, char* diag, integer* N, 
    doublecomplex* Ap, doublecomplex* X, integer* incX)
{
    maloc_ztpmv(uplo, trans, diag, N, Ap, X, incX);
}

int ZTRSV(char* uplo, char* trans, char* diag, integer* N,
    doublecomplex* A, integer* lda, doublecomplex* X, integer* incX)
{
    return maloc_ztrsv(uplo, trans, diag, N, A, lda, X, incX);
}

int ZTBSV(char* uplo, char* trans, char* diag, integer* N, integer* K,
    doublecomplex* A, integer* lda, doublecomplex* X, integer* incX)
{
    return maloc_ztbsv(uplo, trans, diag, N, K, A, lda, X, incX);
}

int ZTPSV(char* uplo, char* trans, char* diag, integer* N, 
    doublecomplex* Ap, doublecomplex* X, integer* incX)
{
    return maloc_ztpsv(uplo, trans, diag, N, Ap, X, incX);
}

int SSYMV(char* uplo, integer* N, real* alpha, real* A, integer* lda,
    real* X, integer* incX, real* beta, real* Y, integer* incY)
{
    return maloc_ssymv(uplo, N, alpha, A, lda, X, incX, beta, Y, incY);
}

int SSBMV(char* uplo, integer* N, integer* K, real* alpha,
    real* A, integer* lda, real* X, integer* incX, real* beta,
    real* Y, integer* incY)
{
    return maloc_ssbmv(uplo, N, K, alpha, A, lda, X, incX, beta, Y, incY);
}

int SSPMV(char* uplo, integer* N, real* alpha, real* Ap,
    real* X, integer* incX, real* beta, real* Y, integer* incY)
{
    return maloc_sspmv(uplo, N, alpha, Ap, X, incX, beta, Y, incY);
}

int SGER(integer* M, integer* N, real* alpha, real* X, integer* incX,
    real* Y, integer* incY, real* A, integer* lda)
{
    return maloc_sger(M, N, alpha, X, incX, Y, incY, A, lda);
}

int SSYR(char* uplo, integer* N, real* alpha, real* X, integer* incX,
    real* A, integer* lda)
{
    return maloc_ssyr(uplo, N, alpha, X, incX, A, lda);
}

int SSPR(char* uplo, integer* N, real* alpha, real* X, integer* incX,
    real* Ap)
{
    return maloc_sspr(uplo, N, alpha, X, incX, Ap);
}

int SSYR2(char* uplo, integer* N, real* alpha, real* X, integer* incX,
    real* Y, integer* incY, real* A, integer* lda)
{
    return maloc_ssyr2(uplo, N, alpha, X, incX, Y, incY, A, lda);
}

int SSPR2(char* uplo, integer* N, real* alpha, real* X, integer* incX,
    real* Y, integer* incY, real* A)
{
    return maloc_sspr2(uplo, N, alpha, X, incX, Y, incY, A);
}

int DSYMV(char* uplo, integer* N, doublereal* alpha, doublereal* A,
    integer* lda, doublereal* X, integer* incX, doublereal* beta,
    doublereal* Y, integer* incY)
{
    return maloc_dsymv(uplo, N, alpha, A, lda, X, incX, beta, Y, incY);
}

int DSBMV(char* uplo, integer* N, integer* K, doublereal* alpha,
    doublereal* A, integer* lda, doublereal* X, integer* incX,
    doublereal* beta, doublereal* Y, integer* incY)
{
    return maloc_dsbmv(uplo, N, K, alpha, A, lda, X, incX, beta, Y, incY);
}

int DSPMV(char* uplo, integer* N, doublereal* alpha, doublereal* Ap,
    doublereal* X, integer* incX, doublereal* beta,
    doublereal* Y, integer* incY)
{
    return maloc_dspmv(uplo, N, alpha, Ap, X, incX, beta, Y, incY);
}

int DGER(integer* M, integer* N, doublereal* alpha, doublereal* X,
    integer* incX, doublereal* Y, integer* incY, doublereal* A, integer* lda)
{
    return maloc_dger(M, N, alpha, X, incX, Y, incY, A, lda);
}

int DSYR(char* uplo, integer* N, doublereal* alpha, doublereal* X,
    integer* incX, doublereal* A, integer* lda)
{
    return maloc_dsyr(uplo, N, alpha, X, incX, A, lda);
}

int DSPR(char* uplo, integer* N, doublereal* alpha, doublereal* X,
    integer* incX, doublereal* Ap)
{
    return maloc_dspr(uplo, N, alpha, X, incX, Ap);
}

int DSYR2(char* uplo, integer* N, doublereal* alpha, doublereal* X,
    integer* incX, doublereal* Y, integer* incY, doublereal* A, integer* lda)
{
    return maloc_dsyr2(uplo, N, alpha, X, incX, Y, incY, A, lda);
}

int DSPR2(char* uplo, integer* N, doublereal* alpha, doublereal* X,
    integer* incX, doublereal* Y, integer* incY, doublereal* A)
{
    return maloc_dspr2(uplo, N, alpha, X, incX, Y, incY, A);
}

int CHEMV(char* uplo, integer* N, complex* alpha, complex* A,
    integer* lda, complex* X, integer* incX, complex* beta,
    complex* Y, integer* incY)
{
    return maloc_chemv(uplo, N, alpha, A, lda, X, incX, beta, Y, incY);
}

int CHBMV(char* uplo, integer* N, integer* K, complex* alpha,
    complex* A, integer* lda, complex* X, integer* incX, complex* beta,
    complex* Y, integer* incY)
{
    return maloc_chbmv(uplo, N, K, alpha, A, lda, X, incX, beta, Y, incY);
}

int CHPMV(char* uplo, integer* N, complex* alpha, complex* Ap, 
    complex* X, integer* incX, complex* beta, complex* Y, integer* incY)
{
    return maloc_chpmv(uplo, N, alpha, Ap, X, incX, beta, Y, incY);
}

int CGERU(integer* M, integer* N, complex* alpha, complex* X,
    integer* incX, complex* Y, integer* incY, complex* A, integer* lda)
{
    return maloc_cgeru(M, N, alpha, X, incX, Y, incY, A, lda);
}

int CGERC(integer* M, integer* N, complex* alpha, complex* X,
    integer* incX, complex* Y, integer* incY, complex* A, integer* lda)
{
    return maloc_cgerc(M, N, alpha, X, incX, Y, incY, A, lda);
}

int CHER(char* uplo, integer* N, real* alpha, complex* X, integer* incX,
    complex* A, integer* lda)
{
    return maloc_cher(uplo, N, alpha, X, incX, A, lda);
}

int CHPR(char* uplo, integer* N, real* alpha, complex* X, integer* incX,
    complex* Ap)
{
    return maloc_chpr(uplo, N, alpha, X, incX, Ap);
}

int CHER2(char* uplo, integer* N, complex* alpha, complex* X,
    integer* incX, complex* Y, integer* incY, complex* A, integer* lda)
{
    return maloc_cher2(uplo, N, alpha, X, incX, Y, incY, A, lda);
}

int CHPR2(char* uplo, integer* N, complex* alpha, complex* X,
    integer* incX, complex* Y, integer* incY, complex* Ap)
{
    return maloc_chpr2(uplo, N, alpha, X, incX, Y, incY, Ap);
}

int ZHEMV(char* uplo, integer* N, doublecomplex* alpha,
    doublecomplex* A, integer* lda, doublecomplex* X, integer* incX,
    doublecomplex* beta, doublecomplex* Y, integer* incY)
{
    return maloc_zhemv(uplo, N, alpha, A, lda, X, incX, beta, Y, incY);
}

int ZHBMV(char* uplo, integer* N, integer* K, doublecomplex* alpha,
    doublecomplex* A, integer* lda, doublecomplex* X, integer* incX,
    doublecomplex* beta, doublecomplex* Y, integer* incY)
{
    return maloc_zhbmv(uplo, N, K, alpha, A, lda, X, incX, beta, Y, incY);
}

int ZHPMV(char* uplo, integer* N, doublecomplex* alpha,
    doublecomplex* Ap, doublecomplex* X, integer* incX,
    doublecomplex* beta, doublecomplex* Y, integer* incY)
{
    return maloc_zhpmv(uplo, N, alpha, Ap, X, incX, beta, Y, incY);
}

int ZGERU(integer* M, integer* N, doublecomplex* alpha,
    doublecomplex* X, integer* incX, doublecomplex* Y, integer* incY,
    doublecomplex* A, integer* lda)
{
    return maloc_zgeru(M, N, alpha, X, incX, Y, incY, A, lda);
}

int ZGERC(integer* M, integer* N, doublecomplex* alpha,
    doublecomplex* X, integer* incX, doublecomplex* Y, integer* incY,
    doublecomplex* A, integer* lda)
{
    return maloc_zgerc(M, N, alpha, X, incX, Y, incY, A, lda);
}

int ZHER(char* uplo, integer* N, doublereal* alpha,
    doublecomplex* X, integer* incX, doublecomplex* A, integer* lda)
{
    return maloc_zher(uplo, N, alpha, X, incX, A, lda);
}

int ZHPR(char* uplo, integer* N, doublereal* alpha,
    doublecomplex* X, integer* incX, doublecomplex* Ap)
{
    return maloc_zhpr(uplo, N, alpha, X, incX, Ap);
}

int ZHER2(char* uplo, integer* N, doublecomplex* alpha,
    doublecomplex* X, integer* incX, doublecomplex* Y, integer* incY,
    doublecomplex* A, integer* lda)
{
    return maloc_zher2(uplo, N, alpha, X, incX, Y, incY, A, lda);
}

int ZHPR2(char* uplo, integer* N, doublecomplex* alpha,
    doublecomplex* X, integer* incX, doublecomplex* Y, integer* incY,
    doublecomplex* Ap)
{
    return maloc_zhpr2(uplo, N, alpha, X, incX, Y, incY, Ap);
}

int SGEMM(char* transA, char* transB, integer* M, integer* N,
    integer* K, real* alpha, real* A, integer* lda, real* B, integer* ldb,
    real* beta, real* C, integer* ldc)
{
    return maloc_sgemm(transA, transB, M, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

int SSYMM(char* side, char* uplo, integer* M, integer* N,
    real* alpha, real* A, integer* lda, real* B, integer* ldb,
    real* beta, real* C, integer* ldc)
{
    return maloc_ssymm(side, uplo, M, N, alpha, A, lda, B, ldb, beta, C, ldc);
}

int SSYRK(char* uplo, char* trans, integer* N, integer* K,
    real* alpha, real* A, integer* lda, real* beta, real* C, integer* ldc)
{
    return maloc_ssyrk(uplo, trans, N, K, alpha, A, lda, beta, C, ldc);
}

int SSYR2K(char* uplo, char* trans, integer* N, integer* K,
    real* alpha, real* A, integer* lda, real* B, integer* ldb,
    real* beta, real* C, integer* ldc)
{
    return maloc_ssyr2k(uplo, trans, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

int STRMM(char* side, char* uplo, char* trans, char* diag, 
    integer* M, integer* N, real* alpha, real* A, integer* lda,
    real* B, integer* ldb)
{
    return maloc_strmm(side, uplo, trans, diag, M, N, alpha, A, lda, B, ldb);
}

int STRSM(char* side, char* uplo, char* trans, char* diag,
    integer* M, integer* N, real* alpha, real* A, integer* lda,
    real* B, integer* ldb)
{
    return maloc_strsm(side, uplo, trans, diag, M, N, alpha, A, lda, B, ldb);
}

int DGEMM(char* transA, char* transB, integer* M, integer* N,
    integer* K, doublereal* alpha, doublereal* A, integer* lda,
    doublereal* B, integer* ldb, doublereal* beta,
    doublereal* C, integer* ldc)
{
    return maloc_dgemm(transA, transB, M, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

int DSYMM(char* side, char* uplo, integer* M, integer* N,
    doublereal* alpha, doublereal* A, integer* lda, doublereal* B,
    integer* ldb, doublereal* beta, doublereal* C, integer* ldc)
{
    return maloc_dsymm(side, uplo, M, N, alpha, A, lda, B, ldb, beta, C, ldc);
}

int DSYRK(char* uplo, char* trans, integer* N, integer* K,
    doublereal* alpha, doublereal* A, integer* lda, doublereal* beta,
    doublereal* C, integer* ldc)
{
    return maloc_dsyrk(uplo, trans, N, K, alpha, A, lda, beta, C, ldc);
}

int DSYR2K(char* uplo, char* trans, integer* N, integer* K,
    doublereal* alpha, doublereal* A, integer* lda, doublereal* B,
    integer* ldb, doublereal* beta, doublereal* C, integer* ldc)
{
    return maloc_dsyr2k(uplo, trans, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

int DTRMM(char* side, char* uplo, char* trans, char* diag, 
    integer* M, integer* N, doublereal* alpha, doublereal* A,
    integer* lda, doublereal* B, integer* ldb)
{
    return maloc_dtrmm(side, uplo, trans, diag, M, N, alpha, A, lda, B, ldb);
}

int DTRSM(char* side, char* uplo, char* trans, char* diag,
    integer* M, integer* N, doublereal* alpha, doublereal* A,
    integer* lda, doublereal* B, integer* ldb)
{
    return maloc_dtrsm(side, uplo, trans, diag, M, N, alpha, A, lda, B, ldb);
}

int CGEMM(char* transA, char* transB, integer* M, integer* N,
    integer* K, complex* alpha, complex* A, integer* lda, complex* B,
    integer* ldb, complex* beta, complex* C, integer* ldc)
{
    return maloc_cgemm(transA, transB, M, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

int CSYMM(char* side, char* uplo, integer* M, integer* N,
    complex* alpha, complex* A, integer* lda, complex* B, integer* ldb,
    complex* beta, complex* C, integer* ldc)
{
    return maloc_csymm(side, uplo, M, N, alpha, A, lda, B, ldb, beta, C, ldc);
}

int CSYRK(char* uplo, char* trans, integer* N, integer* K,
    complex* alpha, complex* A, integer* lda, complex* beta,
    complex* C, integer* ldc)
{
    return maloc_csyrk(uplo, trans, N, K, alpha, A, lda, beta, C, ldc);
}

int CSYR2K(char* uplo, char* trans, integer* N, integer* K,
    complex* alpha, complex* A, integer* lda, complex* B, integer* ldb,
    complex* beta, complex* C, integer* ldc)
{
    return maloc_csyr2k(uplo, trans, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

int CTRMM(char* side, char* uplo, char* trans, char* diag, 
    integer* M, integer* N, complex* alpha, complex* A, integer* lda,
    complex* B, integer* ldb)
{
    return maloc_ctrmm(side, uplo, trans, diag, M, N, alpha, A, lda, B, ldb);
}

int CTRSM(char* side, char* uplo, char* trans, char* diag,
    integer* M, integer* N, complex* alpha, complex* A, integer* lda,
    complex* B, integer* ldb)
{
    return maloc_ctrsm(side, uplo, trans, diag, M, N, alpha, A, lda, B, ldb);
}

int ZGEMM(char* transA, char* transB, integer* M, integer* N,
    integer* K, doublecomplex* alpha, doublecomplex* A, integer* lda,
    doublecomplex* B, integer* ldb, doublecomplex* beta,
    doublecomplex* C, integer* ldc)
{
    return maloc_zgemm(transA, transB, M, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

int ZSYMM(char* side, char* uplo, integer* M, integer* N,
    doublecomplex* alpha, doublecomplex* A, integer* lda, doublecomplex* B,
    integer* ldb, doublecomplex* beta, doublecomplex* C, integer* ldc)
{
    return maloc_zsymm(side, uplo, M, N, alpha, A, lda, B, ldb, beta, C, ldc);
}

int ZSYRK(char* uplo, char* trans, integer* N, integer* K,
    doublecomplex* alpha, doublecomplex* A, integer* lda,
    doublecomplex* beta, doublecomplex* C, integer* ldc)
{
    return maloc_zsyrk(uplo, trans, N, K, alpha, A, lda, beta, C, ldc);
}

int ZSYR2K(char* uplo, char* trans, integer* N, integer* K,
    doublecomplex* alpha, doublecomplex* A, integer* lda, doublecomplex* B,
    integer* ldb, doublecomplex* beta, doublecomplex* C, integer* ldc)
{
    return maloc_zsyr2k(uplo, trans, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

int ZTRMM(char* side, char* uplo, char* trans, char* diag, 
    integer* M, integer* N, doublecomplex* alpha, doublecomplex* A,
    integer* lda, doublecomplex* B, integer* ldb)
{
    return maloc_ztrmm(side, uplo, trans, diag, M, N, alpha, A, lda, B, ldb);
}

int ZTRSM(char* side, char* uplo, char* trans, char* diag,
    integer* M, integer* N, doublecomplex* alpha, doublecomplex* A,
    integer* lda, doublecomplex* B, integer* ldb)
{
    return maloc_ztrsm(side, uplo, trans, diag, M, N, alpha, A, lda, B, ldb);
}

int CHEMM(char* side, char* uplo, integer* M, integer* N,
    complex* alpha, complex* A, integer* lda, complex* B, integer* ldb,
    complex* beta, complex* C, integer* ldc)
{
    return maloc_chemm(side, uplo, M, N, alpha, A, lda, B, ldb, beta, C, ldc);
}

int CHERK(char* uplo, char* trans, integer* N, integer* K,
    real* alpha, complex* A, integer* lda, real* beta,
    complex* C, integer* ldc)
{
    return maloc_cherk(uplo, trans, N, K, alpha, A, lda, beta, C, ldc);
}

int CHER2K(char* uplo, char* trans, integer* N, integer* K,
    complex* alpha, complex* A, integer* lda, complex* B, integer* ldb,
    real* beta, complex* C, integer* ldc)
{
    return maloc_cher2k(uplo, trans, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

int ZHEMM(char* side, char* uplo, integer* M, integer* N,
    doublecomplex* alpha, doublecomplex* A, integer* lda, doublecomplex* B,
    integer* ldb, doublecomplex* beta, doublecomplex* C, integer* ldc)
{
    return maloc_zhemm(side, uplo, M, N, alpha, A, lda, B, ldb, beta, C, ldc);
}

int ZHERK(char* uplo, char* trans, integer* N, integer* K,
    doublereal* alpha, doublecomplex* A, integer* lda, doublereal* beta,
    doublecomplex* C, integer* ldc)
{
    return maloc_zherk(uplo, trans, N, K, alpha, A, lda, beta, C, ldc);
}

int ZHER2K(char* uplo, char* trans, integer* N, integer* K,
    doublecomplex* alpha, doublecomplex* A, integer* lda, doublecomplex* B,
    integer* ldb, doublereal* beta, doublecomplex* C, integer* ldc)
{
    return maloc_zher2k(uplo, trans, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

/*
 * ***************************************************************************
 * Class BLAS FORTRAN binding STUBS (single underscore, lowercase)
 * ***************************************************************************
 */

real sdot_(integer* N, real* X, integer* incX, real* Y, integer* incY)
{
    return maloc_sdot(N, X, incX, Y, incY);
}

doublereal ddot_(integer* N, doublereal* X, integer* incX,
    doublereal* Y, integer* incY)
{
    return maloc_ddot(N, X, incX, Y, incY);
}

void cdotu_(complex* retval, integer* N, complex* X, integer* incX,
    complex* Y, integer* incY)
{
    maloc_cdotu(retval, N, X, incX, Y, incY);
}

void cdotc_(complex* retval, integer* N, complex* X, integer* incX,
    complex* Y, integer* incY)
{
    maloc_cdotc(retval, N, X, incX, Y, incY);
}

void zdotu_(doublecomplex* retval, integer* N, doublecomplex* X,
    integer* incX, doublecomplex* Y, integer* incY)
{
    maloc_zdotu(retval, N, X, incX, Y, incY);
}

void zdotc_(doublecomplex* retval, integer* N, doublecomplex* X,
    integer* incX, doublecomplex* Y, integer* incY)
{
    maloc_zdotc(retval, N, X, incX, Y, incY);
}

real snrm2_(integer* N, real* X, integer* incX)
{
    return maloc_snrm2(N, X, incX);
}

real sasum_(integer* N, real* X, integer* incX)
{
    return maloc_sasum(N, X, incX);
}

doublereal dnrm2_(integer* N, doublereal* X, integer* incX)
{
    return maloc_dnrm2(N, X, incX);
}

doublereal dasum_(integer* N, doublereal* X, integer* incX)
{
    return maloc_dasum(N, X, incX);
}

real scnrm2_(integer* N, complex* X, integer* incX)
{
    return maloc_scnrm2(N, X, incX);
}

real scasum_(integer* N, complex* X, integer* incX)
{
    return maloc_scasum(N, X, incX);
}

doublereal dznrm2_(integer* N, doublecomplex* X, integer* incX)
{
    return maloc_dznrm2(N, X, incX);
}

doublereal dzasum_(integer* N, doublecomplex* X, integer* incX)
{
    return maloc_dzasum(N, X, incX);
}

integer isamax_(integer* N, real* X, integer* incX)
{
    return maloc_isamax(N, X, incX);
}

integer idamax_(integer* N, doublereal* X, integer* incX)
{
    return maloc_idamax(N, X, incX);
}

integer icamax_(integer* N, complex* X, integer* incX)
{
    return maloc_icamax(N, X, incX);
}

integer izamax_(integer* N, doublecomplex* X, integer* incX)
{
    return maloc_izamax(N, X, incX);
}

int sswap_(integer* N, real* X, integer* incX, real* Y, integer* incY)
{
    return maloc_sswap(N, X, incX, Y, incY);
}

int scopy_(integer* N, real* X, integer* incX, real* Y, integer* incY)
{
    return maloc_scopy(N, X, incX, Y, incY);
}

int saxpy_(integer* N, real* alpha, real* X, integer* incX,
    real* Y, integer* incY)
{
    return maloc_saxpy(N, alpha, X, incX, Y, incY);
}

int dswap_(integer* N, doublereal* X, integer* incX,
    doublereal* Y, integer* incY)
{
    return maloc_dswap(N, X, incX, Y, incY);
}

int dcopy_(integer* N, doublereal* X, integer* incX,
    doublereal* Y, integer* incY)
{
    return maloc_dcopy(N, X, incX, Y, incY);
}

int daxpy_(integer* N, doublereal* alpha, doublereal* X, integer* incX,
    doublereal* Y, integer* incY)
{
    return maloc_daxpy(N, alpha, X, incX, Y, incY);
}

int cswap_(integer* N, complex* X, integer* incX,
    complex* Y, integer* incY)
{
    return maloc_cswap(N, X, incX, Y, incY);
}

int ccopy_(integer* N, complex* X, integer* incX,
    complex* Y, integer* incY)
{
    return maloc_ccopy(N, X, incX, Y, incY);
}

int caxpy_(integer* N, complex* alpha,
    complex* X, integer* incX, complex* Y, integer* incY)
{
    return maloc_caxpy(N, alpha, X, incX, Y, incY);
}

int zswap_(integer* N, doublecomplex* X, integer* incX, doublecomplex* Y,
    integer* incY)
{
    return maloc_zswap(N, X, incX, Y, incY);
}

int zcopy_(integer* N, doublecomplex* X, integer* incX, doublecomplex* Y,
    integer* incY)
{
    return maloc_zcopy(N, X, incX, Y, incY);
}

int zaxpy_(integer* N, doublecomplex* alpha, doublecomplex* X,
    integer* incX, doublecomplex* Y, integer* incY)
{
    return maloc_zaxpy(N, alpha, X, incX, Y, incY);
}

int srotg_(real* a, real* b, real* c, real* s)
{
    return maloc_srotg(a, b, c, s);
}

int srot_(integer* N, real* X, integer* incX, real* Y, integer* incY,
    real* c, real* s)
{
    return maloc_srot(N, X, incX, Y, incY, c, s);
}

int drotg_(doublereal* a, doublereal* b, doublereal* c, doublereal* s)
{
    return maloc_drotg(a, b, c, s);
}

int drot_(integer* N, doublereal* X, integer* incX, doublereal* Y,
    integer* incY, doublereal* c, doublereal* s)
{
    return maloc_drot(N, X, incX, Y, incY, c, s);
}

int sscal_(integer* N, real* alpha, real* X, integer* incX)
{
    return maloc_sscal(N, alpha, X, incX);
}

int dscal_(integer* N, doublereal* alpha, doublereal* X, integer* incX)
{
    return maloc_dscal(N, alpha, X, incX);
}

int cscal_(integer* N, complex* alpha, complex* X, integer* incX)
{
    return maloc_cscal(N, alpha, X, incX);
}

int zscal_(integer* N, doublecomplex* alpha, doublecomplex* X,
    integer* incX)
{
    return maloc_zscal(N, alpha, X, incX);
}

int csscal_(integer* N, real* alpha, complex* X, integer* incX)
{
    return maloc_csscal(N, alpha, X, incX);
}

int zdscal_(integer* N, doublereal* alpha, doublecomplex* X,
    integer* incX)
{
    return maloc_zdscal(N, alpha, X, incX);
}

int sgemv_(char* trans, integer* M, integer* N, real* alpha, real* A,
    integer* lda, real* X, integer* incX, real* beta, real* Y, integer* incY)
{
    return maloc_sgemv(trans, M, N, alpha, A, lda, X, incX, beta, Y, incY);
}

int sgbmv_(char *trans, integer *M, integer *N, integer *KL, integer *KU, 
    real *alpha, real *A, integer *lda, real *X, integer *incX, real *beta, 
    real *Y, integer *incY)
{
    return maloc_sgbmv(trans, M, N, KL, KU, alpha, A, lda, X, incX, beta,
        Y, incY);
}

int strmv_(char* uplo, char *trans, char* diag, integer *N, real *A,
    integer *lda, real *X, integer *incX)
{
    return maloc_strmv(uplo, trans, diag, N, A, lda, X, incX);
}

int stbmv_(char* uplo, char* trans, char* diag, integer* N, integer* K,
    real* A, integer* lda, real* X, integer* incX)
{
    return maloc_stbmv(uplo, trans, diag, N, K, A, lda, X, incX);
}

int stpmv_(char* uplo, char* trans, char* diag, integer* N, real* Ap, 
    real* X, integer* incX)
{
    return maloc_stpmv(uplo, trans, diag, N, Ap, X, incX);
}

int strsv_(char* uplo, char* trans, char* diag, integer* N, real* A,
    integer* lda, real* X, integer* incX)
{
    return maloc_strsv(uplo, trans, diag, N, A, lda, X, incX);
}

int stbsv_(char* uplo, char* trans, char* diag, integer* N, integer* K,
    real* A, integer* lda, real* X, integer* incX)
{
    return maloc_stbsv(uplo, trans, diag, N, K, A, lda, X, incX);
}

int stpsv_(char* uplo, char* trans, char* diag, integer* N, real* Ap, 
    real* X, integer* incX)
{
    return maloc_stpsv(uplo, trans, diag, N, Ap, X, incX);
}

int dgemv_(char* trans, integer* M, integer* N, doublereal* alpha,
    doublereal* A, integer* lda, doublereal* X, integer* incX,
    doublereal* beta, doublereal* Y, integer* incY)
{
    return maloc_dgemv(trans, M, N, alpha, A, lda, X, incX, beta, Y, incY);
}

int dgbmv_(char *trans, integer *M, integer *N, integer *KL, integer *KU, 
    doublereal *alpha, doublereal *A, integer *lda, doublereal *X,
    integer *incX, doublereal *beta, doublereal *Y, integer *incY)
{
    return maloc_dgbmv(trans, M, N, KL, KU, alpha, A, lda, X, incX, beta,
        Y, incY);
}

int dtrmv_(char* uplo, char *trans, char* diag, integer *N,  
    doublereal *A, integer *lda, doublereal *X, integer *incX)
{
    return maloc_dtrmv(uplo, trans, diag, N, A, lda, X, incX);
}

int dtbmv_(char* uplo, char* trans, char* diag, integer* N, integer* K,
    doublereal* A, integer* lda, doublereal* X, integer* incX)
{
    return maloc_dtbmv(uplo, trans, diag, N, K, A, lda, X, incX);
}

int dtpmv_(char* uplo, char* trans, char* diag, integer* N, 
    doublereal* Ap, doublereal* X, integer* incX)
{
    return maloc_dtpmv(uplo, trans, diag, N, Ap, X, incX);
}

int dtrsv_(char* uplo, char* trans, char* diag, integer* N,
    doublereal* A, integer* lda, doublereal* X, integer* incX)
{
    return maloc_dtrsv(uplo, trans, diag, N, A, lda, X, incX);
}

int dtbsv_(char* uplo, char* trans, char* diag, integer* N, integer* K,
    doublereal* A, integer* lda, doublereal* X, integer* incX)
{
    return maloc_dtbsv(uplo, trans, diag, N, K, A, lda, X, incX);
}

int dtpsv_(char* uplo, char* trans, char* diag, integer* N, 
    doublereal* Ap, doublereal* X, integer* incX)
{
    return maloc_dtpsv(uplo, trans, diag, N, Ap, X, incX);
}

int cgemv_(char* trans, integer* M, integer* N, complex* alpha,
    complex* A, integer* lda, complex* X, integer* incX, complex* beta,
    complex* Y, integer* incY)
{
    return maloc_cgemv(trans, M, N, alpha, A, lda, X, incX, beta, Y, incY);
}

int cgbmv_(char *trans, integer *M, integer *N, integer *KL, integer *KU, 
    complex *alpha, complex *A, integer *lda, complex *X, integer *incX, 
    complex *beta, complex *Y, integer *incY)
{
    return maloc_cgbmv(trans, M, N, KL, KU, alpha, A, lda, X, incX, beta,
        Y, incY);
}

int ctrmv_(char* uplo, char *trans, char* diag, integer *N,  
    complex *A, integer *lda, complex *X, integer *incX)
{
    return maloc_ctrmv(uplo, trans, diag, N, A, lda, X, incX);
}

int ctbmv_(char* uplo, char* trans, char* diag, integer* N, integer* K,
    complex* A, integer* lda, complex* X, integer* incX)
{
    return maloc_ctbmv(uplo, trans, diag, N, K, A, lda, X, incX);
}

int ctpmv_(char* uplo, char* trans, char* diag, integer* N, 
    complex* Ap, complex* X, integer* incX)
{
    return maloc_ctpmv(uplo, trans, diag, N, Ap, X, incX);
}

int ctrsv_(char* uplo, char* trans, char* diag, integer* N,
    complex* A, integer* lda, complex* X, integer* incX)
{
    return maloc_ctrsv(uplo, trans, diag, N, A, lda, X, incX);
}

int ctbsv_(char* uplo, char* trans, char* diag, integer* N, integer* K,
    complex* A, integer* lda, complex* X, integer* incX)
{
    return maloc_ctbsv(uplo, trans, diag, N, K, A, lda, X, incX);
}

int ctpsv_(char* uplo, char* trans, char* diag, integer* N, 
    complex* Ap, complex* X, integer* incX)
{
    return maloc_ctpsv(uplo, trans, diag, N, Ap, X, incX);
}

int zgemv_(char* trans, integer* M, integer* N, doublecomplex* alpha,
    doublecomplex* A, integer* lda, doublecomplex* X, integer* incX,
    doublecomplex* beta, doublecomplex* Y, integer* incY)
{
    return maloc_zgemv(trans, M, N, alpha, A, lda, X, incX, beta, Y, incY);
}

int zgbmv_(char *trans, integer *M, integer *N, integer *KL, integer *KU, 
    doublecomplex *alpha, doublecomplex *A, integer *lda, doublecomplex *X,
    integer *incX, doublecomplex *beta, doublecomplex *Y, integer *incY)
{
    return maloc_zgbmv(trans, M, N, KL, KU, alpha, A, lda, X, incX, beta,
        Y, incY);
}

int ztrmv_(char* uplo, char *trans, char* diag, integer *N,  
    doublecomplex *A, integer *lda, doublecomplex *X, integer *incX)
{
    return maloc_ztrmv(uplo, trans, diag, N, A, lda, X, incX);
}

int ztbmv_(char* uplo, char* trans, char* diag, integer* N, integer* K,
    doublecomplex* A, integer* lda, doublecomplex* X, integer* incX)
{
    return maloc_ztbmv(uplo, trans, diag, N, K, A, lda, X, incX);
}

void ztpmv_(char* uplo, char* trans, char* diag, integer* N, 
    doublecomplex* Ap, doublecomplex* X, integer* incX)
{
    maloc_ztpmv(uplo, trans, diag, N, Ap, X, incX);
}

int ztrsv_(char* uplo, char* trans, char* diag, integer* N,
    doublecomplex* A, integer* lda, doublecomplex* X, integer* incX)
{
    return maloc_ztrsv(uplo, trans, diag, N, A, lda, X, incX);
}

int ztbsv_(char* uplo, char* trans, char* diag, integer* N, integer* K,
    doublecomplex* A, integer* lda, doublecomplex* X, integer* incX)
{
    return maloc_ztbsv(uplo, trans, diag, N, K, A, lda, X, incX);
}

int ztpsv_(char* uplo, char* trans, char* diag, integer* N, 
    doublecomplex* Ap, doublecomplex* X, integer* incX)
{
    return maloc_ztpsv(uplo, trans, diag, N, Ap, X, incX);
}

int ssymv_(char* uplo, integer* N, real* alpha, real* A, integer* lda,
    real* X, integer* incX, real* beta, real* Y, integer* incY)
{
    return maloc_ssymv(uplo, N, alpha, A, lda, X, incX, beta, Y, incY);
}

int ssbmv_(char* uplo, integer* N, integer* K, real* alpha,
    real* A, integer* lda, real* X, integer* incX, real* beta,
    real* Y, integer* incY)
{
    return maloc_ssbmv(uplo, N, K, alpha, A, lda, X, incX, beta, Y, incY);
}

int sspmv_(char* uplo, integer* N, real* alpha, real* Ap,
    real* X, integer* incX, real* beta, real* Y, integer* incY)
{
    return maloc_sspmv(uplo, N, alpha, Ap, X, incX, beta, Y, incY);
}

int sger_(integer* M, integer* N, real* alpha, real* X, integer* incX,
    real* Y, integer* incY, real* A, integer* lda)
{
    return maloc_sger(M, N, alpha, X, incX, Y, incY, A, lda);
}

int ssyr_(char* uplo, integer* N, real* alpha, real* X, integer* incX,
    real* A, integer* lda)
{
    return maloc_ssyr(uplo, N, alpha, X, incX, A, lda);
}

int sspr_(char* uplo, integer* N, real* alpha, real* X, integer* incX,
    real* Ap)
{
    return maloc_sspr(uplo, N, alpha, X, incX, Ap);
}

int ssyr2_(char* uplo, integer* N, real* alpha, real* X, integer* incX,
    real* Y, integer* incY, real* A, integer* lda)
{
    return maloc_ssyr2(uplo, N, alpha, X, incX, Y, incY, A, lda);
}

int sspr2_(char* uplo, integer* N, real* alpha, real* X, integer* incX,
    real* Y, integer* incY, real* A)
{
    return maloc_sspr2(uplo, N, alpha, X, incX, Y, incY, A);
}

int dsymv_(char* uplo, integer* N, doublereal* alpha, doublereal* A,
    integer* lda, doublereal* X, integer* incX, doublereal* beta,
    doublereal* Y, integer* incY)
{
    return maloc_dsymv(uplo, N, alpha, A, lda, X, incX, beta, Y, incY);
}

int dsbmv_(char* uplo, integer* N, integer* K, doublereal* alpha,
    doublereal* A, integer* lda, doublereal* X, integer* incX,
    doublereal* beta, doublereal* Y, integer* incY)
{
    return maloc_dsbmv(uplo, N, K, alpha, A, lda, X, incX, beta, Y, incY);
}

int dspmv_(char* uplo, integer* N, doublereal* alpha, doublereal* Ap,
    doublereal* X, integer* incX, doublereal* beta,
    doublereal* Y, integer* incY)
{
    return maloc_dspmv(uplo, N, alpha, Ap, X, incX, beta, Y, incY);
}

int dger_(integer* M, integer* N, doublereal* alpha, doublereal* X,
    integer* incX, doublereal* Y, integer* incY, doublereal* A, integer* lda)
{
    return maloc_dger(M, N, alpha, X, incX, Y, incY, A, lda);
}

int dsyr_(char* uplo, integer* N, doublereal* alpha, doublereal* X,
    integer* incX, doublereal* A, integer* lda)
{
    return maloc_dsyr(uplo, N, alpha, X, incX, A, lda);
}

int dspr_(char* uplo, integer* N, doublereal* alpha, doublereal* X,
    integer* incX, doublereal* Ap)
{
    return maloc_dspr(uplo, N, alpha, X, incX, Ap);
}

int dsyr2_(char* uplo, integer* N, doublereal* alpha, doublereal* X,
    integer* incX, doublereal* Y, integer* incY, doublereal* A, integer* lda)
{
    return maloc_dsyr2(uplo, N, alpha, X, incX, Y, incY, A, lda);
}

int dspr2_(char* uplo, integer* N, doublereal* alpha, doublereal* X,
    integer* incX, doublereal* Y, integer* incY, doublereal* A)
{
    return maloc_dspr2(uplo, N, alpha, X, incX, Y, incY, A);
}

int chemv_(char* uplo, integer* N, complex* alpha, complex* A,
    integer* lda, complex* X, integer* incX, complex* beta,
    complex* Y, integer* incY)
{
    return maloc_chemv(uplo, N, alpha, A, lda, X, incX, beta, Y, incY);
}

int chbmv_(char* uplo, integer* N, integer* K, complex* alpha,
    complex* A, integer* lda, complex* X, integer* incX, complex* beta,
    complex* Y, integer* incY)
{
    return maloc_chbmv(uplo, N, K, alpha, A, lda, X, incX, beta, Y, incY);
}

int chpmv_(char* uplo, integer* N, complex* alpha, complex* Ap, 
    complex* X, integer* incX, complex* beta, complex* Y, integer* incY)
{
    return maloc_chpmv(uplo, N, alpha, Ap, X, incX, beta, Y, incY);
}

int cgeru_(integer* M, integer* N, complex* alpha, complex* X,
    integer* incX, complex* Y, integer* incY, complex* A, integer* lda)
{
    return maloc_cgeru(M, N, alpha, X, incX, Y, incY, A, lda);
}

int cgerc_(integer* M, integer* N, complex* alpha, complex* X,
    integer* incX, complex* Y, integer* incY, complex* A, integer* lda)
{
    return maloc_cgerc(M, N, alpha, X, incX, Y, incY, A, lda);
}

int cher_(char* uplo, integer* N, real* alpha, complex* X, integer* incX,
    complex* A, integer* lda)
{
    return maloc_cher(uplo, N, alpha, X, incX, A, lda);
}

int chpr_(char* uplo, integer* N, real* alpha, complex* X, integer* incX,
    complex* Ap)
{
    return maloc_chpr(uplo, N, alpha, X, incX, Ap);
}

int cher2_(char* uplo, integer* N, complex* alpha, complex* X,
    integer* incX, complex* Y, integer* incY, complex* A, integer* lda)
{
    return maloc_cher2(uplo, N, alpha, X, incX, Y, incY, A, lda);
}

int chpr2_(char* uplo, integer* N, complex* alpha, complex* X,
    integer* incX, complex* Y, integer* incY, complex* Ap)
{
    return maloc_chpr2(uplo, N, alpha, X, incX, Y, incY, Ap);
}

int zhemv_(char* uplo, integer* N, doublecomplex* alpha,
    doublecomplex* A, integer* lda, doublecomplex* X, integer* incX,
    doublecomplex* beta, doublecomplex* Y, integer* incY)
{
    return maloc_zhemv(uplo, N, alpha, A, lda, X, incX, beta, Y, incY);
}

int zhbmv_(char* uplo, integer* N, integer* K, doublecomplex* alpha,
    doublecomplex* A, integer* lda, doublecomplex* X, integer* incX,
    doublecomplex* beta, doublecomplex* Y, integer* incY)
{
    return maloc_zhbmv(uplo, N, K, alpha, A, lda, X, incX, beta, Y, incY);
}

int zhpmv_(char* uplo, integer* N, doublecomplex* alpha,
    doublecomplex* Ap, doublecomplex* X, integer* incX,
    doublecomplex* beta, doublecomplex* Y, integer* incY)
{
    return maloc_zhpmv(uplo, N, alpha, Ap, X, incX, beta, Y, incY);
}

int zgeru_(integer* M, integer* N, doublecomplex* alpha,
    doublecomplex* X, integer* incX, doublecomplex* Y, integer* incY,
    doublecomplex* A, integer* lda)
{
    return maloc_zgeru(M, N, alpha, X, incX, Y, incY, A, lda);
}

int zgerc_(integer* M, integer* N, doublecomplex* alpha,
    doublecomplex* X, integer* incX, doublecomplex* Y, integer* incY,
    doublecomplex* A, integer* lda)
{
    return maloc_zgerc(M, N, alpha, X, incX, Y, incY, A, lda);
}

int zher_(char* uplo, integer* N, doublereal* alpha,
    doublecomplex* X, integer* incX, doublecomplex* A, integer* lda)
{
    return maloc_zher(uplo, N, alpha, X, incX, A, lda);
}

int zhpr_(char* uplo, integer* N, doublereal* alpha,
    doublecomplex* X, integer* incX, doublecomplex* Ap)
{
    return maloc_zhpr(uplo, N, alpha, X, incX, Ap);
}

int zher2_(char* uplo, integer* N, doublecomplex* alpha,
    doublecomplex* X, integer* incX, doublecomplex* Y, integer* incY,
    doublecomplex* A, integer* lda)
{
    return maloc_zher2(uplo, N, alpha, X, incX, Y, incY, A, lda);
}

int zhpr2_(char* uplo, integer* N, doublecomplex* alpha,
    doublecomplex* X, integer* incX, doublecomplex* Y, integer* incY,
    doublecomplex* Ap)
{
    return maloc_zhpr2(uplo, N, alpha, X, incX, Y, incY, Ap);
}

int sgemm_(char* transA, char* transB, integer* M, integer* N,
    integer* K, real* alpha, real* A, integer* lda, real* B, integer* ldb,
    real* beta, real* C, integer* ldc)
{
    return maloc_sgemm(transA, transB, M, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

int ssymm_(char* side, char* uplo, integer* M, integer* N,
    real* alpha, real* A, integer* lda, real* B, integer* ldb,
    real* beta, real* C, integer* ldc)
{
    return maloc_ssymm(side, uplo, M, N, alpha, A, lda, B, ldb, beta, C, ldc);
}

int ssyrk_(char* uplo, char* trans, integer* N, integer* K,
    real* alpha, real* A, integer* lda, real* beta, real* C, integer* ldc)
{
    return maloc_ssyrk(uplo, trans, N, K, alpha, A, lda, beta, C, ldc);
}

int ssyr2k_(char* uplo, char* trans, integer* N, integer* K,
    real* alpha, real* A, integer* lda, real* B, integer* ldb,
    real* beta, real* C, integer* ldc)
{
    return maloc_ssyr2k(uplo, trans, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

int strmm_(char* side, char* uplo, char* trans, char* diag, 
    integer* M, integer* N, real* alpha, real* A, integer* lda,
    real* B, integer* ldb)
{
    return maloc_strmm(side, uplo, trans, diag, M, N, alpha, A, lda, B, ldb);
}

int strsm_(char* side, char* uplo, char* trans, char* diag,
    integer* M, integer* N, real* alpha, real* A, integer* lda,
    real* B, integer* ldb)
{
    return maloc_strsm(side, uplo, trans, diag, M, N, alpha, A, lda, B, ldb);
}

int dgemm_(char* transA, char* transB, integer* M, integer* N,
    integer* K, doublereal* alpha, doublereal* A, integer* lda,
    doublereal* B, integer* ldb, doublereal* beta,
    doublereal* C, integer* ldc)
{
    return maloc_dgemm(transA, transB, M, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

int dsymm_(char* side, char* uplo, integer* M, integer* N,
    doublereal* alpha, doublereal* A, integer* lda, doublereal* B,
    integer* ldb, doublereal* beta, doublereal* C, integer* ldc)
{
    return maloc_dsymm(side, uplo, M, N, alpha, A, lda, B, ldb, beta, C, ldc);
}

int dsyrk_(char* uplo, char* trans, integer* N, integer* K,
    doublereal* alpha, doublereal* A, integer* lda, doublereal* beta,
    doublereal* C, integer* ldc)
{
    return maloc_dsyrk(uplo, trans, N, K, alpha, A, lda, beta, C, ldc);
}

int dsyr2k_(char* uplo, char* trans, integer* N, integer* K,
    doublereal* alpha, doublereal* A, integer* lda, doublereal* B,
    integer* ldb, doublereal* beta, doublereal* C, integer* ldc)
{
    return maloc_dsyr2k(uplo, trans, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

int dtrmm_(char* side, char* uplo, char* trans, char* diag, 
    integer* M, integer* N, doublereal* alpha, doublereal* A,
    integer* lda, doublereal* B, integer* ldb)
{
    return maloc_dtrmm(side, uplo, trans, diag, M, N, alpha, A, lda, B, ldb);
}

int dtrsm_(char* side, char* uplo, char* trans, char* diag,
    integer* M, integer* N, doublereal* alpha, doublereal* A,
    integer* lda, doublereal* B, integer* ldb)
{
    return maloc_dtrsm(side, uplo, trans, diag, M, N, alpha, A, lda, B, ldb);
}

int cgemm_(char* transA, char* transB, integer* M, integer* N,
    integer* K, complex* alpha, complex* A, integer* lda, complex* B,
    integer* ldb, complex* beta, complex* C, integer* ldc)
{
    return maloc_cgemm(transA, transB, M, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

int csymm_(char* side, char* uplo, integer* M, integer* N,
    complex* alpha, complex* A, integer* lda, complex* B, integer* ldb,
    complex* beta, complex* C, integer* ldc)
{
    return maloc_csymm(side, uplo, M, N, alpha, A, lda, B, ldb, beta, C, ldc);
}

int csyrk_(char* uplo, char* trans, integer* N, integer* K,
    complex* alpha, complex* A, integer* lda, complex* beta,
    complex* C, integer* ldc)
{
    return maloc_csyrk(uplo, trans, N, K, alpha, A, lda, beta, C, ldc);
}

int csyr2k_(char* uplo, char* trans, integer* N, integer* K,
    complex* alpha, complex* A, integer* lda, complex* B, integer* ldb,
    complex* beta, complex* C, integer* ldc)
{
    return maloc_csyr2k(uplo, trans, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

int ctrmm_(char* side, char* uplo, char* trans, char* diag, 
    integer* M, integer* N, complex* alpha, complex* A, integer* lda,
    complex* B, integer* ldb)
{
    return maloc_ctrmm(side, uplo, trans, diag, M, N, alpha, A, lda, B, ldb);
}

int ctrsm_(char* side, char* uplo, char* trans, char* diag,
    integer* M, integer* N, complex* alpha, complex* A, integer* lda,
    complex* B, integer* ldb)
{
    return maloc_ctrsm(side, uplo, trans, diag, M, N, alpha, A, lda, B, ldb);
}

int zgemm_(char* transA, char* transB, integer* M, integer* N,
    integer* K, doublecomplex* alpha, doublecomplex* A, integer* lda,
    doublecomplex* B, integer* ldb, doublecomplex* beta,
    doublecomplex* C, integer* ldc)
{
    return maloc_zgemm(transA, transB, M, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

int zsymm_(char* side, char* uplo, integer* M, integer* N,
    doublecomplex* alpha, doublecomplex* A, integer* lda, doublecomplex* B,
    integer* ldb, doublecomplex* beta, doublecomplex* C, integer* ldc)
{
    return maloc_zsymm(side, uplo, M, N, alpha, A, lda, B, ldb, beta, C, ldc);
}

int zsyrk_(char* uplo, char* trans, integer* N, integer* K,
    doublecomplex* alpha, doublecomplex* A, integer* lda,
    doublecomplex* beta, doublecomplex* C, integer* ldc)
{
    return maloc_zsyrk(uplo, trans, N, K, alpha, A, lda, beta, C, ldc);
}

int zsyr2k_(char* uplo, char* trans, integer* N, integer* K,
    doublecomplex* alpha, doublecomplex* A, integer* lda, doublecomplex* B,
    integer* ldb, doublecomplex* beta, doublecomplex* C, integer* ldc)
{
    return maloc_zsyr2k(uplo, trans, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

int ztrmm_(char* side, char* uplo, char* trans, char* diag, 
    integer* M, integer* N, doublecomplex* alpha, doublecomplex* A,
    integer* lda, doublecomplex* B, integer* ldb)
{
    return maloc_ztrmm(side, uplo, trans, diag, M, N, alpha, A, lda, B, ldb);
}

int ztrsm_(char* side, char* uplo, char* trans, char* diag,
    integer* M, integer* N, doublecomplex* alpha, doublecomplex* A,
    integer* lda, doublecomplex* B, integer* ldb)
{
    return maloc_ztrsm(side, uplo, trans, diag, M, N, alpha, A, lda, B, ldb);
}

int chemm_(char* side, char* uplo, integer* M, integer* N,
    complex* alpha, complex* A, integer* lda, complex* B, integer* ldb,
    complex* beta, complex* C, integer* ldc)
{
    return maloc_chemm(side, uplo, M, N, alpha, A, lda, B, ldb, beta, C, ldc);
}

int cherk_(char* uplo, char* trans, integer* N, integer* K,
    real* alpha, complex* A, integer* lda, real* beta,
    complex* C, integer* ldc)
{
    return maloc_cherk(uplo, trans, N, K, alpha, A, lda, beta, C, ldc);
}

int cher2k_(char* uplo, char* trans, integer* N, integer* K,
    complex* alpha, complex* A, integer* lda, complex* B, integer* ldb,
    real* beta, complex* C, integer* ldc)
{
    return maloc_cher2k(uplo, trans, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

int zhemm_(char* side, char* uplo, integer* M, integer* N,
    doublecomplex* alpha, doublecomplex* A, integer* lda, doublecomplex* B,
    integer* ldb, doublecomplex* beta, doublecomplex* C, integer* ldc)
{
    return maloc_zhemm(side, uplo, M, N, alpha, A, lda, B, ldb, beta, C, ldc);
}

int zherk_(char* uplo, char* trans, integer* N, integer* K,
    doublereal* alpha, doublecomplex* A, integer* lda, doublereal* beta,
    doublecomplex* C, integer* ldc)
{
    return maloc_zherk(uplo, trans, N, K, alpha, A, lda, beta, C, ldc);
}

int zher2k_(char* uplo, char* trans, integer* N, integer* K,
    doublecomplex* alpha, doublecomplex* A, integer* lda, doublecomplex* B,
    integer* ldb, doublereal* beta, doublecomplex* C, integer* ldc)
{
    return maloc_zher2k(uplo, trans, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

/*
 * ***************************************************************************
 * Class BLAS FORTRAN binding STUBS (single underscore, uppercase)
 * ***************************************************************************
 */

real SDOT_(integer* N, real* X, integer* incX, real* Y, integer* incY)
{
    return maloc_sdot(N, X, incX, Y, incY);
}

doublereal DDOT_(integer* N, doublereal* X, integer* incX,
    doublereal* Y, integer* incY)
{
    return maloc_ddot(N, X, incX, Y, incY);
}

void CDOTU_(complex* retval, integer* N, complex* X, integer* incX,
    complex* Y, integer* incY)
{
    maloc_cdotu(retval, N, X, incX, Y, incY);
}

void CDOTC_(complex* retval, integer* N, complex* X, integer* incX,
    complex* Y, integer* incY)
{
    maloc_cdotc(retval, N, X, incX, Y, incY);
}

void ZDOTU_(doublecomplex* retval, integer* N, doublecomplex* X,
    integer* incX, doublecomplex* Y, integer* incY)
{
    maloc_zdotu(retval, N, X, incX, Y, incY);
}

void ZDOTC_(doublecomplex* retval, integer* N, doublecomplex* X,
    integer* incX, doublecomplex* Y, integer* incY)
{
    maloc_zdotc(retval, N, X, incX, Y, incY);
}

real SNRM2_(integer* N, real* X, integer* incX)
{
    return maloc_snrm2(N, X, incX);
}

real SASUM_(integer* N, real* X, integer* incX)
{
    return maloc_sasum(N, X, incX);
}

doublereal DNRM2_(integer* N, doublereal* X, integer* incX)
{
    return maloc_dnrm2(N, X, incX);
}

doublereal DASUM_(integer* N, doublereal* X, integer* incX)
{
    return maloc_dasum(N, X, incX);
}

real SCNRM2_(integer* N, complex* X, integer* incX)
{
    return maloc_scnrm2(N, X, incX);
}

real SCASUM_(integer* N, complex* X, integer* incX)
{
    return maloc_scasum(N, X, incX);
}

doublereal DZNRM2_(integer* N, doublecomplex* X, integer* incX)
{
    return maloc_dznrm2(N, X, incX);
}

doublereal DZASUM_(integer* N, doublecomplex* X, integer* incX)
{
    return maloc_dzasum(N, X, incX);
}

integer ISAMAX_(integer* N, real* X, integer* incX)
{
    return maloc_isamax(N, X, incX);
}

integer IDAMAX_(integer* N, doublereal* X, integer* incX)
{
    return maloc_idamax(N, X, incX);
}

integer ICAMAX_(integer* N, complex* X, integer* incX)
{
    return maloc_icamax(N, X, incX);
}

integer IZAMAX_(integer* N, doublecomplex* X, integer* incX)
{
    return maloc_izamax(N, X, incX);
}

int SSWAP_(integer* N, real* X, integer* incX, real* Y, integer* incY)
{
    return maloc_sswap(N, X, incX, Y, incY);
}

int SCOPY_(integer* N, real* X, integer* incX, real* Y, integer* incY)
{
    return maloc_scopy(N, X, incX, Y, incY);
}

int SAXPY_(integer* N, real* alpha, real* X, integer* incX,
    real* Y, integer* incY)
{
    return maloc_saxpy(N, alpha, X, incX, Y, incY);
}

int DSWAP_(integer* N, doublereal* X, integer* incX,
    doublereal* Y, integer* incY)
{
    return maloc_dswap(N, X, incX, Y, incY);
}

int DCOPY_(integer* N, doublereal* X, integer* incX,
    doublereal* Y, integer* incY)
{
    return maloc_dcopy(N, X, incX, Y, incY);
}

int DAXPY_(integer* N, doublereal* alpha, doublereal* X, integer* incX,
    doublereal* Y, integer* incY)
{
    return maloc_daxpy(N, alpha, X, incX, Y, incY);
}

int CSWAP_(integer* N, complex* X, integer* incX,
    complex* Y, integer* incY)
{
    return maloc_cswap(N, X, incX, Y, incY);
}

int CCOPY_(integer* N, complex* X, integer* incX,
    complex* Y, integer* incY)
{
    return maloc_ccopy(N, X, incX, Y, incY);
}

int CAXPY_(integer* N, complex* alpha,
    complex* X, integer* incX, complex* Y, integer* incY)
{
    return maloc_caxpy(N, alpha, X, incX, Y, incY);
}

int ZSWAP_(integer* N, doublecomplex* X, integer* incX, doublecomplex* Y,
    integer* incY)
{
    return maloc_zswap(N, X, incX, Y, incY);
}

int ZCOPY_(integer* N, doublecomplex* X, integer* incX, doublecomplex* Y,
    integer* incY)
{
    return maloc_zcopy(N, X, incX, Y, incY);
}

int ZAXPY_(integer* N, doublecomplex* alpha, doublecomplex* X,
    integer* incX, doublecomplex* Y, integer* incY)
{
    return maloc_zaxpy(N, alpha, X, incX, Y, incY);
}

int SROTG_(real* a, real* b, real* c, real* s)
{
    return maloc_srotg(a, b, c, s);
}

int SROT_(integer* N, real* X, integer* incX, real* Y, integer* incY,
    real* c, real* s)
{
    return maloc_srot(N, X, incX, Y, incY, c, s);
}

int DROTG_(doublereal* a, doublereal* b, doublereal* c, doublereal* s)
{
    return maloc_drotg(a, b, c, s);
}

int DROT_(integer* N, doublereal* X, integer* incX, doublereal* Y,
    integer* incY, doublereal* c, doublereal* s)
{
    return maloc_drot(N, X, incX, Y, incY, c, s);
}

int SSCAL_(integer* N, real* alpha, real* X, integer* incX)
{
    return maloc_sscal(N, alpha, X, incX);
}

int DSCAL_(integer* N, doublereal* alpha, doublereal* X, integer* incX)
{
    return maloc_dscal(N, alpha, X, incX);
}

int CSCAL_(integer* N, complex* alpha, complex* X, integer* incX)
{
    return maloc_cscal(N, alpha, X, incX);
}

int ZSCAL_(integer* N, doublecomplex* alpha, doublecomplex* X,
    integer* incX)
{
    return maloc_zscal(N, alpha, X, incX);
}

int CSSCAL_(integer* N, real* alpha, complex* X, integer* incX)
{
    return maloc_csscal(N, alpha, X, incX);
}

int ZDSCAL_(integer* N, doublereal* alpha, doublecomplex* X,
    integer* incX)
{
    return maloc_zdscal(N, alpha, X, incX);
}

int SGEMV_(char* trans, integer* M, integer* N, real* alpha, real* A,
    integer* lda, real* X, integer* incX, real* beta, real* Y, integer* incY)
{
    return maloc_sgemv(trans, M, N, alpha, A, lda, X, incX, beta, Y, incY);
}

int SGBMV_(char *trans, integer *M, integer *N, integer *KL, integer *KU, 
    real *alpha, real *A, integer *lda, real *X, integer *incX, real *beta, 
    real *Y, integer *incY)
{
    return maloc_sgbmv(trans, M, N, KL, KU, alpha, A, lda, X, incX, beta,
        Y, incY);
}

int STRMV_(char* uplo, char *trans, char* diag, integer *N, real *A,
    integer *lda, real *X, integer *incX)
{
    return maloc_strmv(uplo, trans, diag, N, A, lda, X, incX);
}

int STBMV_(char* uplo, char* trans, char* diag, integer* N, integer* K,
    real* A, integer* lda, real* X, integer* incX)
{
    return maloc_stbmv(uplo, trans, diag, N, K, A, lda, X, incX);
}

int STPMV_(char* uplo, char* trans, char* diag, integer* N, real* Ap, 
    real* X, integer* incX)
{
    return maloc_stpmv(uplo, trans, diag, N, Ap, X, incX);
}

int STRSV_(char* uplo, char* trans, char* diag, integer* N, real* A,
    integer* lda, real* X, integer* incX)
{
    return maloc_strsv(uplo, trans, diag, N, A, lda, X, incX);
}

int STBSV_(char* uplo, char* trans, char* diag, integer* N, integer* K,
    real* A, integer* lda, real* X, integer* incX)
{
    return maloc_stbsv(uplo, trans, diag, N, K, A, lda, X, incX);
}

int STPSV_(char* uplo, char* trans, char* diag, integer* N, real* Ap, 
    real* X, integer* incX)
{
    return maloc_stpsv(uplo, trans, diag, N, Ap, X, incX);
}

int DGEMV_(char* trans, integer* M, integer* N, doublereal* alpha,
    doublereal* A, integer* lda, doublereal* X, integer* incX,
    doublereal* beta, doublereal* Y, integer* incY)
{
    return maloc_dgemv(trans, M, N, alpha, A, lda, X, incX, beta, Y, incY);
}

int DGBMV_(char *trans, integer *M, integer *N, integer *KL, integer *KU, 
    doublereal *alpha, doublereal *A, integer *lda, doublereal *X,
    integer *incX, doublereal *beta, doublereal *Y, integer *incY)
{
    return maloc_dgbmv(trans, M, N, KL, KU, alpha, A, lda, X, incX, beta,
        Y, incY);
}

int DTRMV_(char* uplo, char *trans, char* diag, integer *N,  
    doublereal *A, integer *lda, doublereal *X, integer *incX)
{
    return maloc_dtrmv(uplo, trans, diag, N, A, lda, X, incX);
}

int DTBMV_(char* uplo, char* trans, char* diag, integer* N, integer* K,
    doublereal* A, integer* lda, doublereal* X, integer* incX)
{
    return maloc_dtbmv(uplo, trans, diag, N, K, A, lda, X, incX);
}

int DTPMV_(char* uplo, char* trans, char* diag, integer* N, 
    doublereal* Ap, doublereal* X, integer* incX)
{
    return maloc_dtpmv(uplo, trans, diag, N, Ap, X, incX);
}

int DTRSV_(char* uplo, char* trans, char* diag, integer* N,
    doublereal* A, integer* lda, doublereal* X, integer* incX)
{
    return maloc_dtrsv(uplo, trans, diag, N, A, lda, X, incX);
}

int DTBSV_(char* uplo, char* trans, char* diag, integer* N, integer* K,
    doublereal* A, integer* lda, doublereal* X, integer* incX)
{
    return maloc_dtbsv(uplo, trans, diag, N, K, A, lda, X, incX);
}

int DTPSV_(char* uplo, char* trans, char* diag, integer* N, 
    doublereal* Ap, doublereal* X, integer* incX)
{
    return maloc_dtpsv(uplo, trans, diag, N, Ap, X, incX);
}

int CGEMV_(char* trans, integer* M, integer* N, complex* alpha,
    complex* A, integer* lda, complex* X, integer* incX, complex* beta,
    complex* Y, integer* incY)
{
    return maloc_cgemv(trans, M, N, alpha, A, lda, X, incX, beta, Y, incY);
}

int CGBMV_(char *trans, integer *M, integer *N, integer *KL, integer *KU, 
    complex *alpha, complex *A, integer *lda, complex *X, integer *incX, 
    complex *beta, complex *Y, integer *incY)
{
    return maloc_cgbmv(trans, M, N, KL, KU, alpha, A, lda, X, incX, beta,
        Y, incY);
}

int CTRMV_(char* uplo, char *trans, char* diag, integer *N,  
    complex *A, integer *lda, complex *X, integer *incX)
{
    return maloc_ctrmv(uplo, trans, diag, N, A, lda, X, incX);
}

int CTBMV_(char* uplo, char* trans, char* diag, integer* N, integer* K,
    complex* A, integer* lda, complex* X, integer* incX)
{
    return maloc_ctbmv(uplo, trans, diag, N, K, A, lda, X, incX);
}

int CTPMV_(char* uplo, char* trans, char* diag, integer* N, 
    complex* Ap, complex* X, integer* incX)
{
    return maloc_ctpmv(uplo, trans, diag, N, Ap, X, incX);
}

int CTRSV_(char* uplo, char* trans, char* diag, integer* N,
    complex* A, integer* lda, complex* X, integer* incX)
{
    return maloc_ctrsv(uplo, trans, diag, N, A, lda, X, incX);
}

int CTBSV_(char* uplo, char* trans, char* diag, integer* N, integer* K,
    complex* A, integer* lda, complex* X, integer* incX)
{
    return maloc_ctbsv(uplo, trans, diag, N, K, A, lda, X, incX);
}

int CTPSV_(char* uplo, char* trans, char* diag, integer* N, 
    complex* Ap, complex* X, integer* incX)
{
    return maloc_ctpsv(uplo, trans, diag, N, Ap, X, incX);
}

int ZGEMV_(char* trans, integer* M, integer* N, doublecomplex* alpha,
    doublecomplex* A, integer* lda, doublecomplex* X, integer* incX,
    doublecomplex* beta, doublecomplex* Y, integer* incY)
{
    return maloc_zgemv(trans, M, N, alpha, A, lda, X, incX, beta, Y, incY);
}

int ZGBMV_(char *trans, integer *M, integer *N, integer *KL, integer *KU, 
    doublecomplex *alpha, doublecomplex *A, integer *lda, doublecomplex *X,
    integer *incX, doublecomplex *beta, doublecomplex *Y, integer *incY)
{
    return maloc_zgbmv(trans, M, N, KL, KU, alpha, A, lda, X, incX, beta,
        Y, incY);
}

int ZTRMV_(char* uplo, char *trans, char* diag, integer *N,  
    doublecomplex *A, integer *lda, doublecomplex *X, integer *incX)
{
    return maloc_ztrmv(uplo, trans, diag, N, A, lda, X, incX);
}

int ZTBMV_(char* uplo, char* trans, char* diag, integer* N, integer* K,
    doublecomplex* A, integer* lda, doublecomplex* X, integer* incX)
{
    return maloc_ztbmv(uplo, trans, diag, N, K, A, lda, X, incX);
}

void ZTPMV_(char* uplo, char* trans, char* diag, integer* N, 
    doublecomplex* Ap, doublecomplex* X, integer* incX)
{
    maloc_ztpmv(uplo, trans, diag, N, Ap, X, incX);
}

int ZTRSV_(char* uplo, char* trans, char* diag, integer* N,
    doublecomplex* A, integer* lda, doublecomplex* X, integer* incX)
{
    return maloc_ztrsv(uplo, trans, diag, N, A, lda, X, incX);
}

int ZTBSV_(char* uplo, char* trans, char* diag, integer* N, integer* K,
    doublecomplex* A, integer* lda, doublecomplex* X, integer* incX)
{
    return maloc_ztbsv(uplo, trans, diag, N, K, A, lda, X, incX);
}

int ZTPSV_(char* uplo, char* trans, char* diag, integer* N, 
    doublecomplex* Ap, doublecomplex* X, integer* incX)
{
    return maloc_ztpsv(uplo, trans, diag, N, Ap, X, incX);
}

int SSYMV_(char* uplo, integer* N, real* alpha, real* A, integer* lda,
    real* X, integer* incX, real* beta, real* Y, integer* incY)
{
    return maloc_ssymv(uplo, N, alpha, A, lda, X, incX, beta, Y, incY);
}

int SSBMV_(char* uplo, integer* N, integer* K, real* alpha,
    real* A, integer* lda, real* X, integer* incX, real* beta,
    real* Y, integer* incY)
{
    return maloc_ssbmv(uplo, N, K, alpha, A, lda, X, incX, beta, Y, incY);
}

int SSPMV_(char* uplo, integer* N, real* alpha, real* Ap,
    real* X, integer* incX, real* beta, real* Y, integer* incY)
{
    return maloc_sspmv(uplo, N, alpha, Ap, X, incX, beta, Y, incY);
}

int SGER_(integer* M, integer* N, real* alpha, real* X, integer* incX,
    real* Y, integer* incY, real* A, integer* lda)
{
    return maloc_sger(M, N, alpha, X, incX, Y, incY, A, lda);
}

int SSYR_(char* uplo, integer* N, real* alpha, real* X, integer* incX,
    real* A, integer* lda)
{
    return maloc_ssyr(uplo, N, alpha, X, incX, A, lda);
}

int SSPR_(char* uplo, integer* N, real* alpha, real* X, integer* incX,
    real* Ap)
{
    return maloc_sspr(uplo, N, alpha, X, incX, Ap);
}

int SSYR2_(char* uplo, integer* N, real* alpha, real* X, integer* incX,
    real* Y, integer* incY, real* A, integer* lda)
{
    return maloc_ssyr2(uplo, N, alpha, X, incX, Y, incY, A, lda);
}

int SSPR2_(char* uplo, integer* N, real* alpha, real* X, integer* incX,
    real* Y, integer* incY, real* A)
{
    return maloc_sspr2(uplo, N, alpha, X, incX, Y, incY, A);
}

int DSYMV_(char* uplo, integer* N, doublereal* alpha, doublereal* A,
    integer* lda, doublereal* X, integer* incX, doublereal* beta,
    doublereal* Y, integer* incY)
{
    return maloc_dsymv(uplo, N, alpha, A, lda, X, incX, beta, Y, incY);
}

int DSBMV_(char* uplo, integer* N, integer* K, doublereal* alpha,
    doublereal* A, integer* lda, doublereal* X, integer* incX,
    doublereal* beta, doublereal* Y, integer* incY)
{
    return maloc_dsbmv(uplo, N, K, alpha, A, lda, X, incX, beta, Y, incY);
}

int DSPMV_(char* uplo, integer* N, doublereal* alpha, doublereal* Ap,
    doublereal* X, integer* incX, doublereal* beta,
    doublereal* Y, integer* incY)
{
    return maloc_dspmv(uplo, N, alpha, Ap, X, incX, beta, Y, incY);
}

int DGER_(integer* M, integer* N, doublereal* alpha, doublereal* X,
    integer* incX, doublereal* Y, integer* incY, doublereal* A, integer* lda)
{
    return maloc_dger(M, N, alpha, X, incX, Y, incY, A, lda);
}

int DSYR_(char* uplo, integer* N, doublereal* alpha, doublereal* X,
    integer* incX, doublereal* A, integer* lda)
{
    return maloc_dsyr(uplo, N, alpha, X, incX, A, lda);
}

int DSPR_(char* uplo, integer* N, doublereal* alpha, doublereal* X,
    integer* incX, doublereal* Ap)
{
    return maloc_dspr(uplo, N, alpha, X, incX, Ap);
}

int DSYR2_(char* uplo, integer* N, doublereal* alpha, doublereal* X,
    integer* incX, doublereal* Y, integer* incY, doublereal* A, integer* lda)
{
    return maloc_dsyr2(uplo, N, alpha, X, incX, Y, incY, A, lda);
}

int DSPR2_(char* uplo, integer* N, doublereal* alpha, doublereal* X,
    integer* incX, doublereal* Y, integer* incY, doublereal* A)
{
    return maloc_dspr2(uplo, N, alpha, X, incX, Y, incY, A);
}

int CHEMV_(char* uplo, integer* N, complex* alpha, complex* A,
    integer* lda, complex* X, integer* incX, complex* beta,
    complex* Y, integer* incY)
{
    return maloc_chemv(uplo, N, alpha, A, lda, X, incX, beta, Y, incY);
}

int CHBMV_(char* uplo, integer* N, integer* K, complex* alpha,
    complex* A, integer* lda, complex* X, integer* incX, complex* beta,
    complex* Y, integer* incY)
{
    return maloc_chbmv(uplo, N, K, alpha, A, lda, X, incX, beta, Y, incY);
}

int CHPMV_(char* uplo, integer* N, complex* alpha, complex* Ap, 
    complex* X, integer* incX, complex* beta, complex* Y, integer* incY)
{
    return maloc_chpmv(uplo, N, alpha, Ap, X, incX, beta, Y, incY);
}

int CGERU_(integer* M, integer* N, complex* alpha, complex* X,
    integer* incX, complex* Y, integer* incY, complex* A, integer* lda)
{
    return maloc_cgeru(M, N, alpha, X, incX, Y, incY, A, lda);
}

int CGERC_(integer* M, integer* N, complex* alpha, complex* X,
    integer* incX, complex* Y, integer* incY, complex* A, integer* lda)
{
    return maloc_cgerc(M, N, alpha, X, incX, Y, incY, A, lda);
}

int CHER_(char* uplo, integer* N, real* alpha, complex* X, integer* incX,
    complex* A, integer* lda)
{
    return maloc_cher(uplo, N, alpha, X, incX, A, lda);
}

int CHPR_(char* uplo, integer* N, real* alpha, complex* X, integer* incX,
    complex* Ap)
{
    return maloc_chpr(uplo, N, alpha, X, incX, Ap);
}

int CHER2_(char* uplo, integer* N, complex* alpha, complex* X,
    integer* incX, complex* Y, integer* incY, complex* A, integer* lda)
{
    return maloc_cher2(uplo, N, alpha, X, incX, Y, incY, A, lda);
}

int CHPR2_(char* uplo, integer* N, complex* alpha, complex* X,
    integer* incX, complex* Y, integer* incY, complex* Ap)
{
    return maloc_chpr2(uplo, N, alpha, X, incX, Y, incY, Ap);
}

int ZHEMV_(char* uplo, integer* N, doublecomplex* alpha,
    doublecomplex* A, integer* lda, doublecomplex* X, integer* incX,
    doublecomplex* beta, doublecomplex* Y, integer* incY)
{
    return maloc_zhemv(uplo, N, alpha, A, lda, X, incX, beta, Y, incY);
}

int ZHBMV_(char* uplo, integer* N, integer* K, doublecomplex* alpha,
    doublecomplex* A, integer* lda, doublecomplex* X, integer* incX,
    doublecomplex* beta, doublecomplex* Y, integer* incY)
{
    return maloc_zhbmv(uplo, N, K, alpha, A, lda, X, incX, beta, Y, incY);
}

int ZHPMV_(char* uplo, integer* N, doublecomplex* alpha,
    doublecomplex* Ap, doublecomplex* X, integer* incX,
    doublecomplex* beta, doublecomplex* Y, integer* incY)
{
    return maloc_zhpmv(uplo, N, alpha, Ap, X, incX, beta, Y, incY);
}

int ZGERU_(integer* M, integer* N, doublecomplex* alpha,
    doublecomplex* X, integer* incX, doublecomplex* Y, integer* incY,
    doublecomplex* A, integer* lda)
{
    return maloc_zgeru(M, N, alpha, X, incX, Y, incY, A, lda);
}

int ZGERC_(integer* M, integer* N, doublecomplex* alpha,
    doublecomplex* X, integer* incX, doublecomplex* Y, integer* incY,
    doublecomplex* A, integer* lda)
{
    return maloc_zgerc(M, N, alpha, X, incX, Y, incY, A, lda);
}

int ZHER_(char* uplo, integer* N, doublereal* alpha,
    doublecomplex* X, integer* incX, doublecomplex* A, integer* lda)
{
    return maloc_zher(uplo, N, alpha, X, incX, A, lda);
}

int ZHPR_(char* uplo, integer* N, doublereal* alpha,
    doublecomplex* X, integer* incX, doublecomplex* Ap)
{
    return maloc_zhpr(uplo, N, alpha, X, incX, Ap);
}

int ZHER2_(char* uplo, integer* N, doublecomplex* alpha,
    doublecomplex* X, integer* incX, doublecomplex* Y, integer* incY,
    doublecomplex* A, integer* lda)
{
    return maloc_zher2(uplo, N, alpha, X, incX, Y, incY, A, lda);
}

int ZHPR2_(char* uplo, integer* N, doublecomplex* alpha,
    doublecomplex* X, integer* incX, doublecomplex* Y, integer* incY,
    doublecomplex* Ap)
{
    return maloc_zhpr2(uplo, N, alpha, X, incX, Y, incY, Ap);
}

int SGEMM_(char* transA, char* transB, integer* M, integer* N,
    integer* K, real* alpha, real* A, integer* lda, real* B, integer* ldb,
    real* beta, real* C, integer* ldc)
{
    return maloc_sgemm(transA, transB, M, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

int SSYMM_(char* side, char* uplo, integer* M, integer* N,
    real* alpha, real* A, integer* lda, real* B, integer* ldb,
    real* beta, real* C, integer* ldc)
{
    return maloc_ssymm(side, uplo, M, N, alpha, A, lda, B, ldb, beta, C, ldc);
}

int SSYRK_(char* uplo, char* trans, integer* N, integer* K,
    real* alpha, real* A, integer* lda, real* beta, real* C, integer* ldc)
{
    return maloc_ssyrk(uplo, trans, N, K, alpha, A, lda, beta, C, ldc);
}

int SSYR2K_(char* uplo, char* trans, integer* N, integer* K,
    real* alpha, real* A, integer* lda, real* B, integer* ldb,
    real* beta, real* C, integer* ldc)
{
    return maloc_ssyr2k(uplo, trans, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

int STRMM_(char* side, char* uplo, char* trans, char* diag, 
    integer* M, integer* N, real* alpha, real* A, integer* lda,
    real* B, integer* ldb)
{
    return maloc_strmm(side, uplo, trans, diag, M, N, alpha, A, lda, B, ldb);
}

int STRSM_(char* side, char* uplo, char* trans, char* diag,
    integer* M, integer* N, real* alpha, real* A, integer* lda,
    real* B, integer* ldb)
{
    return maloc_strsm(side, uplo, trans, diag, M, N, alpha, A, lda, B, ldb);
}

int DGEMM_(char* transA, char* transB, integer* M, integer* N,
    integer* K, doublereal* alpha, doublereal* A, integer* lda,
    doublereal* B, integer* ldb, doublereal* beta,
    doublereal* C, integer* ldc)
{
    return maloc_dgemm(transA, transB, M, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

int DSYMM_(char* side, char* uplo, integer* M, integer* N,
    doublereal* alpha, doublereal* A, integer* lda, doublereal* B,
    integer* ldb, doublereal* beta, doublereal* C, integer* ldc)
{
    return maloc_dsymm(side, uplo, M, N, alpha, A, lda, B, ldb, beta, C, ldc);
}

int DSYRK_(char* uplo, char* trans, integer* N, integer* K,
    doublereal* alpha, doublereal* A, integer* lda, doublereal* beta,
    doublereal* C, integer* ldc)
{
    return maloc_dsyrk(uplo, trans, N, K, alpha, A, lda, beta, C, ldc);
}

int DSYR2K_(char* uplo, char* trans, integer* N, integer* K,
    doublereal* alpha, doublereal* A, integer* lda, doublereal* B,
    integer* ldb, doublereal* beta, doublereal* C, integer* ldc)
{
    return maloc_dsyr2k(uplo, trans, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

int DTRMM_(char* side, char* uplo, char* trans, char* diag, 
    integer* M, integer* N, doublereal* alpha, doublereal* A,
    integer* lda, doublereal* B, integer* ldb)
{
    return maloc_dtrmm(side, uplo, trans, diag, M, N, alpha, A, lda, B, ldb);
}

int DTRSM_(char* side, char* uplo, char* trans, char* diag,
    integer* M, integer* N, doublereal* alpha, doublereal* A,
    integer* lda, doublereal* B, integer* ldb)
{
    return maloc_dtrsm(side, uplo, trans, diag, M, N, alpha, A, lda, B, ldb);
}

int CGEMM_(char* transA, char* transB, integer* M, integer* N,
    integer* K, complex* alpha, complex* A, integer* lda, complex* B,
    integer* ldb, complex* beta, complex* C, integer* ldc)
{
    return maloc_cgemm(transA, transB, M, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

int CSYMM_(char* side, char* uplo, integer* M, integer* N,
    complex* alpha, complex* A, integer* lda, complex* B, integer* ldb,
    complex* beta, complex* C, integer* ldc)
{
    return maloc_csymm(side, uplo, M, N, alpha, A, lda, B, ldb, beta, C, ldc);
}

int CSYRK_(char* uplo, char* trans, integer* N, integer* K,
    complex* alpha, complex* A, integer* lda, complex* beta,
    complex* C, integer* ldc)
{
    return maloc_csyrk(uplo, trans, N, K, alpha, A, lda, beta, C, ldc);
}

int CSYR2K_(char* uplo, char* trans, integer* N, integer* K,
    complex* alpha, complex* A, integer* lda, complex* B, integer* ldb,
    complex* beta, complex* C, integer* ldc)
{
    return maloc_csyr2k(uplo, trans, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

int CTRMM_(char* side, char* uplo, char* trans, char* diag, 
    integer* M, integer* N, complex* alpha, complex* A, integer* lda,
    complex* B, integer* ldb)
{
    return maloc_ctrmm(side, uplo, trans, diag, M, N, alpha, A, lda, B, ldb);
}

int CTRSM_(char* side, char* uplo, char* trans, char* diag,
    integer* M, integer* N, complex* alpha, complex* A, integer* lda,
    complex* B, integer* ldb)
{
    return maloc_ctrsm(side, uplo, trans, diag, M, N, alpha, A, lda, B, ldb);
}

int ZGEMM_(char* transA, char* transB, integer* M, integer* N,
    integer* K, doublecomplex* alpha, doublecomplex* A, integer* lda,
    doublecomplex* B, integer* ldb, doublecomplex* beta,
    doublecomplex* C, integer* ldc)
{
    return maloc_zgemm(transA, transB, M, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

int ZSYMM_(char* side, char* uplo, integer* M, integer* N,
    doublecomplex* alpha, doublecomplex* A, integer* lda, doublecomplex* B,
    integer* ldb, doublecomplex* beta, doublecomplex* C, integer* ldc)
{
    return maloc_zsymm(side, uplo, M, N, alpha, A, lda, B, ldb, beta, C, ldc);
}

int ZSYRK_(char* uplo, char* trans, integer* N, integer* K,
    doublecomplex* alpha, doublecomplex* A, integer* lda,
    doublecomplex* beta, doublecomplex* C, integer* ldc)
{
    return maloc_zsyrk(uplo, trans, N, K, alpha, A, lda, beta, C, ldc);
}

int ZSYR2K_(char* uplo, char* trans, integer* N, integer* K,
    doublecomplex* alpha, doublecomplex* A, integer* lda, doublecomplex* B,
    integer* ldb, doublecomplex* beta, doublecomplex* C, integer* ldc)
{
    return maloc_zsyr2k(uplo, trans, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

int ZTRMM_(char* side, char* uplo, char* trans, char* diag, 
    integer* M, integer* N, doublecomplex* alpha, doublecomplex* A,
    integer* lda, doublecomplex* B, integer* ldb)
{
    return maloc_ztrmm(side, uplo, trans, diag, M, N, alpha, A, lda, B, ldb);
}

int ZTRSM_(char* side, char* uplo, char* trans, char* diag,
    integer* M, integer* N, doublecomplex* alpha, doublecomplex* A,
    integer* lda, doublecomplex* B, integer* ldb)
{
    return maloc_ztrsm(side, uplo, trans, diag, M, N, alpha, A, lda, B, ldb);
}

int CHEMM_(char* side, char* uplo, integer* M, integer* N,
    complex* alpha, complex* A, integer* lda, complex* B, integer* ldb,
    complex* beta, complex* C, integer* ldc)
{
    return maloc_chemm(side, uplo, M, N, alpha, A, lda, B, ldb, beta, C, ldc);
}

int CHERK_(char* uplo, char* trans, integer* N, integer* K,
    real* alpha, complex* A, integer* lda, real* beta,
    complex* C, integer* ldc)
{
    return maloc_cherk(uplo, trans, N, K, alpha, A, lda, beta, C, ldc);
}

int CHER2K_(char* uplo, char* trans, integer* N, integer* K,
    complex* alpha, complex* A, integer* lda, complex* B, integer* ldb,
    real* beta, complex* C, integer* ldc)
{
    return maloc_cher2k(uplo, trans, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

int ZHEMM_(char* side, char* uplo, integer* M, integer* N,
    doublecomplex* alpha, doublecomplex* A, integer* lda, doublecomplex* B,
    integer* ldb, doublecomplex* beta, doublecomplex* C, integer* ldc)
{
    return maloc_zhemm(side, uplo, M, N, alpha, A, lda, B, ldb, beta, C, ldc);
}

int ZHERK_(char* uplo, char* trans, integer* N, integer* K,
    doublereal* alpha, doublecomplex* A, integer* lda, doublereal* beta,
    doublecomplex* C, integer* ldc)
{
    return maloc_zherk(uplo, trans, N, K, alpha, A, lda, beta, C, ldc);
}

int ZHER2K_(char* uplo, char* trans, integer* N, integer* K,
    doublecomplex* alpha, doublecomplex* A, integer* lda, doublecomplex* B,
    integer* ldb, doublereal* beta, doublecomplex* C, integer* ldc)
{
    return maloc_zher2k(uplo, trans, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

/*
 * ***************************************************************************
 * Class BLAS FORTRAN binding STUBS (double underscore, lowercase)
 * ***************************************************************************
 */

real sdot__(integer* N, real* X, integer* incX, real* Y, integer* incY)
{
    return maloc_sdot(N, X, incX, Y, incY);
}

doublereal ddot__(integer* N, doublereal* X, integer* incX,
    doublereal* Y, integer* incY)
{
    return maloc_ddot(N, X, incX, Y, incY);
}

void cdotu__(complex* retval, integer* N, complex* X, integer* incX,
    complex* Y, integer* incY)
{
    maloc_cdotu(retval, N, X, incX, Y, incY);
}

void cdotc__(complex* retval, integer* N, complex* X, integer* incX,
    complex* Y, integer* incY)
{
    maloc_cdotc(retval, N, X, incX, Y, incY);
}

void zdotu__(doublecomplex* retval, integer* N, doublecomplex* X,
    integer* incX, doublecomplex* Y, integer* incY)
{
    maloc_zdotu(retval, N, X, incX, Y, incY);
}

void zdotc__(doublecomplex* retval, integer* N, doublecomplex* X,
    integer* incX, doublecomplex* Y, integer* incY)
{
    maloc_zdotc(retval, N, X, incX, Y, incY);
}

real snrm2__(integer* N, real* X, integer* incX)
{
    return maloc_snrm2(N, X, incX);
}

real sasum__(integer* N, real* X, integer* incX)
{
    return maloc_sasum(N, X, incX);
}

doublereal dnrm2__(integer* N, doublereal* X, integer* incX)
{
    return maloc_dnrm2(N, X, incX);
}

doublereal dasum__(integer* N, doublereal* X, integer* incX)
{
    return maloc_dasum(N, X, incX);
}

real scnrm2__(integer* N, complex* X, integer* incX)
{
    return maloc_scnrm2(N, X, incX);
}

real scasum__(integer* N, complex* X, integer* incX)
{
    return maloc_scasum(N, X, incX);
}

doublereal dznrm2__(integer* N, doublecomplex* X, integer* incX)
{
    return maloc_dznrm2(N, X, incX);
}

doublereal dzasum__(integer* N, doublecomplex* X, integer* incX)
{
    return maloc_dzasum(N, X, incX);
}

integer isamax__(integer* N, real* X, integer* incX)
{
    return maloc_isamax(N, X, incX);
}

integer idamax__(integer* N, doublereal* X, integer* incX)
{
    return maloc_idamax(N, X, incX);
}

integer icamax__(integer* N, complex* X, integer* incX)
{
    return maloc_icamax(N, X, incX);
}

integer izamax__(integer* N, doublecomplex* X, integer* incX)
{
    return maloc_izamax(N, X, incX);
}

int sswap__(integer* N, real* X, integer* incX, real* Y, integer* incY)
{
    return maloc_sswap(N, X, incX, Y, incY);
}

int scopy__(integer* N, real* X, integer* incX, real* Y, integer* incY)
{
    return maloc_scopy(N, X, incX, Y, incY);
}

int saxpy__(integer* N, real* alpha, real* X, integer* incX,
    real* Y, integer* incY)
{
    return maloc_saxpy(N, alpha, X, incX, Y, incY);
}

int dswap__(integer* N, doublereal* X, integer* incX,
    doublereal* Y, integer* incY)
{
    return maloc_dswap(N, X, incX, Y, incY);
}

int dcopy__(integer* N, doublereal* X, integer* incX,
    doublereal* Y, integer* incY)
{
    return maloc_dcopy(N, X, incX, Y, incY);
}

int daxpy__(integer* N, doublereal* alpha, doublereal* X, integer* incX,
    doublereal* Y, integer* incY)
{
    return maloc_daxpy(N, alpha, X, incX, Y, incY);
}

int cswap__(integer* N, complex* X, integer* incX,
    complex* Y, integer* incY)
{
    return maloc_cswap(N, X, incX, Y, incY);
}

int ccopy__(integer* N, complex* X, integer* incX,
    complex* Y, integer* incY)
{
    return maloc_ccopy(N, X, incX, Y, incY);
}

int caxpy__(integer* N, complex* alpha,
    complex* X, integer* incX, complex* Y, integer* incY)
{
    return maloc_caxpy(N, alpha, X, incX, Y, incY);
}

int zswap__(integer* N, doublecomplex* X, integer* incX, doublecomplex* Y,
    integer* incY)
{
    return maloc_zswap(N, X, incX, Y, incY);
}

int zcopy__(integer* N, doublecomplex* X, integer* incX, doublecomplex* Y,
    integer* incY)
{
    return maloc_zcopy(N, X, incX, Y, incY);
}

int zaxpy__(integer* N, doublecomplex* alpha, doublecomplex* X,
    integer* incX, doublecomplex* Y, integer* incY)
{
    return maloc_zaxpy(N, alpha, X, incX, Y, incY);
}

int srotg__(real* a, real* b, real* c, real* s)
{
    return maloc_srotg(a, b, c, s);
}

int srot__(integer* N, real* X, integer* incX, real* Y, integer* incY,
    real* c, real* s)
{
    return maloc_srot(N, X, incX, Y, incY, c, s);
}

int drotg__(doublereal* a, doublereal* b, doublereal* c, doublereal* s)
{
    return maloc_drotg(a, b, c, s);
}

int drot__(integer* N, doublereal* X, integer* incX, doublereal* Y,
    integer* incY, doublereal* c, doublereal* s)
{
    return maloc_drot(N, X, incX, Y, incY, c, s);
}

int sscal__(integer* N, real* alpha, real* X, integer* incX)
{
    return maloc_sscal(N, alpha, X, incX);
}

int dscal__(integer* N, doublereal* alpha, doublereal* X, integer* incX)
{
    return maloc_dscal(N, alpha, X, incX);
}

int cscal__(integer* N, complex* alpha, complex* X, integer* incX)
{
    return maloc_cscal(N, alpha, X, incX);
}

int zscal__(integer* N, doublecomplex* alpha, doublecomplex* X,
    integer* incX)
{
    return maloc_zscal(N, alpha, X, incX);
}

int csscal__(integer* N, real* alpha, complex* X, integer* incX)
{
    return maloc_csscal(N, alpha, X, incX);
}

int zdscal__(integer* N, doublereal* alpha, doublecomplex* X,
    integer* incX)
{
    return maloc_zdscal(N, alpha, X, incX);
}

int sgemv__(char* trans, integer* M, integer* N, real* alpha, real* A,
    integer* lda, real* X, integer* incX, real* beta, real* Y, integer* incY)
{
    return maloc_sgemv(trans, M, N, alpha, A, lda, X, incX, beta, Y, incY);
}

int sgbmv__(char *trans, integer *M, integer *N, integer *KL, integer *KU, 
    real *alpha, real *A, integer *lda, real *X, integer *incX, real *beta, 
    real *Y, integer *incY)
{
    return maloc_sgbmv(trans, M, N, KL, KU, alpha, A, lda, X, incX, beta,
        Y, incY);
}

int strmv__(char* uplo, char *trans, char* diag, integer *N, real *A,
    integer *lda, real *X, integer *incX)
{
    return maloc_strmv(uplo, trans, diag, N, A, lda, X, incX);
}

int stbmv__(char* uplo, char* trans, char* diag, integer* N, integer* K,
    real* A, integer* lda, real* X, integer* incX)
{
    return maloc_stbmv(uplo, trans, diag, N, K, A, lda, X, incX);
}

int stpmv__(char* uplo, char* trans, char* diag, integer* N, real* Ap, 
    real* X, integer* incX)
{
    return maloc_stpmv(uplo, trans, diag, N, Ap, X, incX);
}

int strsv__(char* uplo, char* trans, char* diag, integer* N, real* A,
    integer* lda, real* X, integer* incX)
{
    return maloc_strsv(uplo, trans, diag, N, A, lda, X, incX);
}

int stbsv__(char* uplo, char* trans, char* diag, integer* N, integer* K,
    real* A, integer* lda, real* X, integer* incX)
{
    return maloc_stbsv(uplo, trans, diag, N, K, A, lda, X, incX);
}

int stpsv__(char* uplo, char* trans, char* diag, integer* N, real* Ap, 
    real* X, integer* incX)
{
    return maloc_stpsv(uplo, trans, diag, N, Ap, X, incX);
}

int dgemv__(char* trans, integer* M, integer* N, doublereal* alpha,
    doublereal* A, integer* lda, doublereal* X, integer* incX,
    doublereal* beta, doublereal* Y, integer* incY)
{
    return maloc_dgemv(trans, M, N, alpha, A, lda, X, incX, beta, Y, incY);
}

int dgbmv__(char *trans, integer *M, integer *N, integer *KL, integer *KU, 
    doublereal *alpha, doublereal *A, integer *lda, doublereal *X,
    integer *incX, doublereal *beta, doublereal *Y, integer *incY)
{
    return maloc_dgbmv(trans, M, N, KL, KU, alpha, A, lda, X, incX, beta,
        Y, incY);
}

int dtrmv__(char* uplo, char *trans, char* diag, integer *N,  
    doublereal *A, integer *lda, doublereal *X, integer *incX)
{
    return maloc_dtrmv(uplo, trans, diag, N, A, lda, X, incX);
}

int dtbmv__(char* uplo, char* trans, char* diag, integer* N, integer* K,
    doublereal* A, integer* lda, doublereal* X, integer* incX)
{
    return maloc_dtbmv(uplo, trans, diag, N, K, A, lda, X, incX);
}

int dtpmv__(char* uplo, char* trans, char* diag, integer* N, 
    doublereal* Ap, doublereal* X, integer* incX)
{
    return maloc_dtpmv(uplo, trans, diag, N, Ap, X, incX);
}

int dtrsv__(char* uplo, char* trans, char* diag, integer* N,
    doublereal* A, integer* lda, doublereal* X, integer* incX)
{
    return maloc_dtrsv(uplo, trans, diag, N, A, lda, X, incX);
}

int dtbsv__(char* uplo, char* trans, char* diag, integer* N, integer* K,
    doublereal* A, integer* lda, doublereal* X, integer* incX)
{
    return maloc_dtbsv(uplo, trans, diag, N, K, A, lda, X, incX);
}

int dtpsv__(char* uplo, char* trans, char* diag, integer* N, 
    doublereal* Ap, doublereal* X, integer* incX)
{
    return maloc_dtpsv(uplo, trans, diag, N, Ap, X, incX);
}

int cgemv__(char* trans, integer* M, integer* N, complex* alpha,
    complex* A, integer* lda, complex* X, integer* incX, complex* beta,
    complex* Y, integer* incY)
{
    return maloc_cgemv(trans, M, N, alpha, A, lda, X, incX, beta, Y, incY);
}

int cgbmv__(char *trans, integer *M, integer *N, integer *KL, integer *KU, 
    complex *alpha, complex *A, integer *lda, complex *X, integer *incX, 
    complex *beta, complex *Y, integer *incY)
{
    return maloc_cgbmv(trans, M, N, KL, KU, alpha, A, lda, X, incX, beta,
        Y, incY);
}

int ctrmv__(char* uplo, char *trans, char* diag, integer *N,  
    complex *A, integer *lda, complex *X, integer *incX)
{
    return maloc_ctrmv(uplo, trans, diag, N, A, lda, X, incX);
}

int ctbmv__(char* uplo, char* trans, char* diag, integer* N, integer* K,
    complex* A, integer* lda, complex* X, integer* incX)
{
    return maloc_ctbmv(uplo, trans, diag, N, K, A, lda, X, incX);
}

int ctpmv__(char* uplo, char* trans, char* diag, integer* N, 
    complex* Ap, complex* X, integer* incX)
{
    return maloc_ctpmv(uplo, trans, diag, N, Ap, X, incX);
}

int ctrsv__(char* uplo, char* trans, char* diag, integer* N,
    complex* A, integer* lda, complex* X, integer* incX)
{
    return maloc_ctrsv(uplo, trans, diag, N, A, lda, X, incX);
}

int ctbsv__(char* uplo, char* trans, char* diag, integer* N, integer* K,
    complex* A, integer* lda, complex* X, integer* incX)
{
    return maloc_ctbsv(uplo, trans, diag, N, K, A, lda, X, incX);
}

int ctpsv__(char* uplo, char* trans, char* diag, integer* N, 
    complex* Ap, complex* X, integer* incX)
{
    return maloc_ctpsv(uplo, trans, diag, N, Ap, X, incX);
}

int zgemv__(char* trans, integer* M, integer* N, doublecomplex* alpha,
    doublecomplex* A, integer* lda, doublecomplex* X, integer* incX,
    doublecomplex* beta, doublecomplex* Y, integer* incY)
{
    return maloc_zgemv(trans, M, N, alpha, A, lda, X, incX, beta, Y, incY);
}

int zgbmv__(char *trans, integer *M, integer *N, integer *KL, integer *KU, 
    doublecomplex *alpha, doublecomplex *A, integer *lda, doublecomplex *X,
    integer *incX, doublecomplex *beta, doublecomplex *Y, integer *incY)
{
    return maloc_zgbmv(trans, M, N, KL, KU, alpha, A, lda, X, incX, beta,
        Y, incY);
}

int ztrmv__(char* uplo, char *trans, char* diag, integer *N,  
    doublecomplex *A, integer *lda, doublecomplex *X, integer *incX)
{
    return maloc_ztrmv(uplo, trans, diag, N, A, lda, X, incX);
}

int ztbmv__(char* uplo, char* trans, char* diag, integer* N, integer* K,
    doublecomplex* A, integer* lda, doublecomplex* X, integer* incX)
{
    return maloc_ztbmv(uplo, trans, diag, N, K, A, lda, X, incX);
}

void ztpmv__(char* uplo, char* trans, char* diag, integer* N, 
    doublecomplex* Ap, doublecomplex* X, integer* incX)
{
    maloc_ztpmv(uplo, trans, diag, N, Ap, X, incX);
}

int ztrsv__(char* uplo, char* trans, char* diag, integer* N,
    doublecomplex* A, integer* lda, doublecomplex* X, integer* incX)
{
    return maloc_ztrsv(uplo, trans, diag, N, A, lda, X, incX);
}

int ztbsv__(char* uplo, char* trans, char* diag, integer* N, integer* K,
    doublecomplex* A, integer* lda, doublecomplex* X, integer* incX)
{
    return maloc_ztbsv(uplo, trans, diag, N, K, A, lda, X, incX);
}

int ztpsv__(char* uplo, char* trans, char* diag, integer* N, 
    doublecomplex* Ap, doublecomplex* X, integer* incX)
{
    return maloc_ztpsv(uplo, trans, diag, N, Ap, X, incX);
}

int ssymv__(char* uplo, integer* N, real* alpha, real* A, integer* lda,
    real* X, integer* incX, real* beta, real* Y, integer* incY)
{
    return maloc_ssymv(uplo, N, alpha, A, lda, X, incX, beta, Y, incY);
}

int ssbmv__(char* uplo, integer* N, integer* K, real* alpha,
    real* A, integer* lda, real* X, integer* incX, real* beta,
    real* Y, integer* incY)
{
    return maloc_ssbmv(uplo, N, K, alpha, A, lda, X, incX, beta, Y, incY);
}

int sspmv__(char* uplo, integer* N, real* alpha, real* Ap,
    real* X, integer* incX, real* beta, real* Y, integer* incY)
{
    return maloc_sspmv(uplo, N, alpha, Ap, X, incX, beta, Y, incY);
}

int sger__(integer* M, integer* N, real* alpha, real* X, integer* incX,
    real* Y, integer* incY, real* A, integer* lda)
{
    return maloc_sger(M, N, alpha, X, incX, Y, incY, A, lda);
}

int ssyr__(char* uplo, integer* N, real* alpha, real* X, integer* incX,
    real* A, integer* lda)
{
    return maloc_ssyr(uplo, N, alpha, X, incX, A, lda);
}

int sspr__(char* uplo, integer* N, real* alpha, real* X, integer* incX,
    real* Ap)
{
    return maloc_sspr(uplo, N, alpha, X, incX, Ap);
}

int ssyr2__(char* uplo, integer* N, real* alpha, real* X, integer* incX,
    real* Y, integer* incY, real* A, integer* lda)
{
    return maloc_ssyr2(uplo, N, alpha, X, incX, Y, incY, A, lda);
}

int sspr2__(char* uplo, integer* N, real* alpha, real* X, integer* incX,
    real* Y, integer* incY, real* A)
{
    return maloc_sspr2(uplo, N, alpha, X, incX, Y, incY, A);
}

int dsymv__(char* uplo, integer* N, doublereal* alpha, doublereal* A,
    integer* lda, doublereal* X, integer* incX, doublereal* beta,
    doublereal* Y, integer* incY)
{
    return maloc_dsymv(uplo, N, alpha, A, lda, X, incX, beta, Y, incY);
}

int dsbmv__(char* uplo, integer* N, integer* K, doublereal* alpha,
    doublereal* A, integer* lda, doublereal* X, integer* incX,
    doublereal* beta, doublereal* Y, integer* incY)
{
    return maloc_dsbmv(uplo, N, K, alpha, A, lda, X, incX, beta, Y, incY);
}

int dspmv__(char* uplo, integer* N, doublereal* alpha, doublereal* Ap,
    doublereal* X, integer* incX, doublereal* beta,
    doublereal* Y, integer* incY)
{
    return maloc_dspmv(uplo, N, alpha, Ap, X, incX, beta, Y, incY);
}

int dger__(integer* M, integer* N, doublereal* alpha, doublereal* X,
    integer* incX, doublereal* Y, integer* incY, doublereal* A, integer* lda)
{
    return maloc_dger(M, N, alpha, X, incX, Y, incY, A, lda);
}

int dsyr__(char* uplo, integer* N, doublereal* alpha, doublereal* X,
    integer* incX, doublereal* A, integer* lda)
{
    return maloc_dsyr(uplo, N, alpha, X, incX, A, lda);
}

int dspr__(char* uplo, integer* N, doublereal* alpha, doublereal* X,
    integer* incX, doublereal* Ap)
{
    return maloc_dspr(uplo, N, alpha, X, incX, Ap);
}

int dsyr2__(char* uplo, integer* N, doublereal* alpha, doublereal* X,
    integer* incX, doublereal* Y, integer* incY, doublereal* A, integer* lda)
{
    return maloc_dsyr2(uplo, N, alpha, X, incX, Y, incY, A, lda);
}

int dspr2__(char* uplo, integer* N, doublereal* alpha, doublereal* X,
    integer* incX, doublereal* Y, integer* incY, doublereal* A)
{
    return maloc_dspr2(uplo, N, alpha, X, incX, Y, incY, A);
}

int chemv__(char* uplo, integer* N, complex* alpha, complex* A,
    integer* lda, complex* X, integer* incX, complex* beta,
    complex* Y, integer* incY)
{
    return maloc_chemv(uplo, N, alpha, A, lda, X, incX, beta, Y, incY);
}

int chbmv__(char* uplo, integer* N, integer* K, complex* alpha,
    complex* A, integer* lda, complex* X, integer* incX, complex* beta,
    complex* Y, integer* incY)
{
    return maloc_chbmv(uplo, N, K, alpha, A, lda, X, incX, beta, Y, incY);
}

int chpmv__(char* uplo, integer* N, complex* alpha, complex* Ap, 
    complex* X, integer* incX, complex* beta, complex* Y, integer* incY)
{
    return maloc_chpmv(uplo, N, alpha, Ap, X, incX, beta, Y, incY);
}

int cgeru__(integer* M, integer* N, complex* alpha, complex* X,
    integer* incX, complex* Y, integer* incY, complex* A, integer* lda)
{
    return maloc_cgeru(M, N, alpha, X, incX, Y, incY, A, lda);
}

int cgerc__(integer* M, integer* N, complex* alpha, complex* X,
    integer* incX, complex* Y, integer* incY, complex* A, integer* lda)
{
    return maloc_cgerc(M, N, alpha, X, incX, Y, incY, A, lda);
}

int cher__(char* uplo, integer* N, real* alpha, complex* X, integer* incX,
    complex* A, integer* lda)
{
    return maloc_cher(uplo, N, alpha, X, incX, A, lda);
}

int chpr__(char* uplo, integer* N, real* alpha, complex* X, integer* incX,
    complex* Ap)
{
    return maloc_chpr(uplo, N, alpha, X, incX, Ap);
}

int cher2__(char* uplo, integer* N, complex* alpha, complex* X,
    integer* incX, complex* Y, integer* incY, complex* A, integer* lda)
{
    return maloc_cher2(uplo, N, alpha, X, incX, Y, incY, A, lda);
}

int chpr2__(char* uplo, integer* N, complex* alpha, complex* X,
    integer* incX, complex* Y, integer* incY, complex* Ap)
{
    return maloc_chpr2(uplo, N, alpha, X, incX, Y, incY, Ap);
}

int zhemv__(char* uplo, integer* N, doublecomplex* alpha,
    doublecomplex* A, integer* lda, doublecomplex* X, integer* incX,
    doublecomplex* beta, doublecomplex* Y, integer* incY)
{
    return maloc_zhemv(uplo, N, alpha, A, lda, X, incX, beta, Y, incY);
}

int zhbmv__(char* uplo, integer* N, integer* K, doublecomplex* alpha,
    doublecomplex* A, integer* lda, doublecomplex* X, integer* incX,
    doublecomplex* beta, doublecomplex* Y, integer* incY)
{
    return maloc_zhbmv(uplo, N, K, alpha, A, lda, X, incX, beta, Y, incY);
}

int zhpmv__(char* uplo, integer* N, doublecomplex* alpha,
    doublecomplex* Ap, doublecomplex* X, integer* incX,
    doublecomplex* beta, doublecomplex* Y, integer* incY)
{
    return maloc_zhpmv(uplo, N, alpha, Ap, X, incX, beta, Y, incY);
}

int zgeru__(integer* M, integer* N, doublecomplex* alpha,
    doublecomplex* X, integer* incX, doublecomplex* Y, integer* incY,
    doublecomplex* A, integer* lda)
{
    return maloc_zgeru(M, N, alpha, X, incX, Y, incY, A, lda);
}

int zgerc__(integer* M, integer* N, doublecomplex* alpha,
    doublecomplex* X, integer* incX, doublecomplex* Y, integer* incY,
    doublecomplex* A, integer* lda)
{
    return maloc_zgerc(M, N, alpha, X, incX, Y, incY, A, lda);
}

int zher__(char* uplo, integer* N, doublereal* alpha,
    doublecomplex* X, integer* incX, doublecomplex* A, integer* lda)
{
    return maloc_zher(uplo, N, alpha, X, incX, A, lda);
}

int zhpr__(char* uplo, integer* N, doublereal* alpha,
    doublecomplex* X, integer* incX, doublecomplex* Ap)
{
    return maloc_zhpr(uplo, N, alpha, X, incX, Ap);
}

int zher2__(char* uplo, integer* N, doublecomplex* alpha,
    doublecomplex* X, integer* incX, doublecomplex* Y, integer* incY,
    doublecomplex* A, integer* lda)
{
    return maloc_zher2(uplo, N, alpha, X, incX, Y, incY, A, lda);
}

int zhpr2__(char* uplo, integer* N, doublecomplex* alpha,
    doublecomplex* X, integer* incX, doublecomplex* Y, integer* incY,
    doublecomplex* Ap)
{
    return maloc_zhpr2(uplo, N, alpha, X, incX, Y, incY, Ap);
}

int sgemm__(char* transA, char* transB, integer* M, integer* N,
    integer* K, real* alpha, real* A, integer* lda, real* B, integer* ldb,
    real* beta, real* C, integer* ldc)
{
    return maloc_sgemm(transA, transB, M, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

int ssymm__(char* side, char* uplo, integer* M, integer* N,
    real* alpha, real* A, integer* lda, real* B, integer* ldb,
    real* beta, real* C, integer* ldc)
{
    return maloc_ssymm(side, uplo, M, N, alpha, A, lda, B, ldb, beta, C, ldc);
}

int ssyrk__(char* uplo, char* trans, integer* N, integer* K,
    real* alpha, real* A, integer* lda, real* beta, real* C, integer* ldc)
{
    return maloc_ssyrk(uplo, trans, N, K, alpha, A, lda, beta, C, ldc);
}

int ssyr2k__(char* uplo, char* trans, integer* N, integer* K,
    real* alpha, real* A, integer* lda, real* B, integer* ldb,
    real* beta, real* C, integer* ldc)
{
    return maloc_ssyr2k(uplo, trans, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

int strmm__(char* side, char* uplo, char* trans, char* diag, 
    integer* M, integer* N, real* alpha, real* A, integer* lda,
    real* B, integer* ldb)
{
    return maloc_strmm(side, uplo, trans, diag, M, N, alpha, A, lda, B, ldb);
}

int strsm__(char* side, char* uplo, char* trans, char* diag,
    integer* M, integer* N, real* alpha, real* A, integer* lda,
    real* B, integer* ldb)
{
    return maloc_strsm(side, uplo, trans, diag, M, N, alpha, A, lda, B, ldb);
}

int dgemm__(char* transA, char* transB, integer* M, integer* N,
    integer* K, doublereal* alpha, doublereal* A, integer* lda,
    doublereal* B, integer* ldb, doublereal* beta,
    doublereal* C, integer* ldc)
{
    return maloc_dgemm(transA, transB, M, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

int dsymm__(char* side, char* uplo, integer* M, integer* N,
    doublereal* alpha, doublereal* A, integer* lda, doublereal* B,
    integer* ldb, doublereal* beta, doublereal* C, integer* ldc)
{
    return maloc_dsymm(side, uplo, M, N, alpha, A, lda, B, ldb, beta, C, ldc);
}

int dsyrk__(char* uplo, char* trans, integer* N, integer* K,
    doublereal* alpha, doublereal* A, integer* lda, doublereal* beta,
    doublereal* C, integer* ldc)
{
    return maloc_dsyrk(uplo, trans, N, K, alpha, A, lda, beta, C, ldc);
}

int dsyr2k__(char* uplo, char* trans, integer* N, integer* K,
    doublereal* alpha, doublereal* A, integer* lda, doublereal* B,
    integer* ldb, doublereal* beta, doublereal* C, integer* ldc)
{
    return maloc_dsyr2k(uplo, trans, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

int dtrmm__(char* side, char* uplo, char* trans, char* diag, 
    integer* M, integer* N, doublereal* alpha, doublereal* A,
    integer* lda, doublereal* B, integer* ldb)
{
    return maloc_dtrmm(side, uplo, trans, diag, M, N, alpha, A, lda, B, ldb);
}

int dtrsm__(char* side, char* uplo, char* trans, char* diag,
    integer* M, integer* N, doublereal* alpha, doublereal* A,
    integer* lda, doublereal* B, integer* ldb)
{
    return maloc_dtrsm(side, uplo, trans, diag, M, N, alpha, A, lda, B, ldb);
}

int cgemm__(char* transA, char* transB, integer* M, integer* N,
    integer* K, complex* alpha, complex* A, integer* lda, complex* B,
    integer* ldb, complex* beta, complex* C, integer* ldc)
{
    return maloc_cgemm(transA, transB, M, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

int csymm__(char* side, char* uplo, integer* M, integer* N,
    complex* alpha, complex* A, integer* lda, complex* B, integer* ldb,
    complex* beta, complex* C, integer* ldc)
{
    return maloc_csymm(side, uplo, M, N, alpha, A, lda, B, ldb, beta, C, ldc);
}

int csyrk__(char* uplo, char* trans, integer* N, integer* K,
    complex* alpha, complex* A, integer* lda, complex* beta,
    complex* C, integer* ldc)
{
    return maloc_csyrk(uplo, trans, N, K, alpha, A, lda, beta, C, ldc);
}

int csyr2k__(char* uplo, char* trans, integer* N, integer* K,
    complex* alpha, complex* A, integer* lda, complex* B, integer* ldb,
    complex* beta, complex* C, integer* ldc)
{
    return maloc_csyr2k(uplo, trans, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

int ctrmm__(char* side, char* uplo, char* trans, char* diag, 
    integer* M, integer* N, complex* alpha, complex* A, integer* lda,
    complex* B, integer* ldb)
{
    return maloc_ctrmm(side, uplo, trans, diag, M, N, alpha, A, lda, B, ldb);
}

int ctrsm__(char* side, char* uplo, char* trans, char* diag,
    integer* M, integer* N, complex* alpha, complex* A, integer* lda,
    complex* B, integer* ldb)
{
    return maloc_ctrsm(side, uplo, trans, diag, M, N, alpha, A, lda, B, ldb);
}

int zgemm__(char* transA, char* transB, integer* M, integer* N,
    integer* K, doublecomplex* alpha, doublecomplex* A, integer* lda,
    doublecomplex* B, integer* ldb, doublecomplex* beta,
    doublecomplex* C, integer* ldc)
{
    return maloc_zgemm(transA, transB, M, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

int zsymm__(char* side, char* uplo, integer* M, integer* N,
    doublecomplex* alpha, doublecomplex* A, integer* lda, doublecomplex* B,
    integer* ldb, doublecomplex* beta, doublecomplex* C, integer* ldc)
{
    return maloc_zsymm(side, uplo, M, N, alpha, A, lda, B, ldb, beta, C, ldc);
}

int zsyrk__(char* uplo, char* trans, integer* N, integer* K,
    doublecomplex* alpha, doublecomplex* A, integer* lda,
    doublecomplex* beta, doublecomplex* C, integer* ldc)
{
    return maloc_zsyrk(uplo, trans, N, K, alpha, A, lda, beta, C, ldc);
}

int zsyr2k__(char* uplo, char* trans, integer* N, integer* K,
    doublecomplex* alpha, doublecomplex* A, integer* lda, doublecomplex* B,
    integer* ldb, doublecomplex* beta, doublecomplex* C, integer* ldc)
{
    return maloc_zsyr2k(uplo, trans, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

int ztrmm__(char* side, char* uplo, char* trans, char* diag, 
    integer* M, integer* N, doublecomplex* alpha, doublecomplex* A,
    integer* lda, doublecomplex* B, integer* ldb)
{
    return maloc_ztrmm(side, uplo, trans, diag, M, N, alpha, A, lda, B, ldb);
}

int ztrsm__(char* side, char* uplo, char* trans, char* diag,
    integer* M, integer* N, doublecomplex* alpha, doublecomplex* A,
    integer* lda, doublecomplex* B, integer* ldb)
{
    return maloc_ztrsm(side, uplo, trans, diag, M, N, alpha, A, lda, B, ldb);
}

int chemm__(char* side, char* uplo, integer* M, integer* N,
    complex* alpha, complex* A, integer* lda, complex* B, integer* ldb,
    complex* beta, complex* C, integer* ldc)
{
    return maloc_chemm(side, uplo, M, N, alpha, A, lda, B, ldb, beta, C, ldc);
}

int cherk__(char* uplo, char* trans, integer* N, integer* K,
    real* alpha, complex* A, integer* lda, real* beta,
    complex* C, integer* ldc)
{
    return maloc_cherk(uplo, trans, N, K, alpha, A, lda, beta, C, ldc);
}

int cher2k__(char* uplo, char* trans, integer* N, integer* K,
    complex* alpha, complex* A, integer* lda, complex* B, integer* ldb,
    real* beta, complex* C, integer* ldc)
{
    return maloc_cher2k(uplo, trans, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

int zhemm__(char* side, char* uplo, integer* M, integer* N,
    doublecomplex* alpha, doublecomplex* A, integer* lda, doublecomplex* B,
    integer* ldb, doublecomplex* beta, doublecomplex* C, integer* ldc)
{
    return maloc_zhemm(side, uplo, M, N, alpha, A, lda, B, ldb, beta, C, ldc);
}

int zherk__(char* uplo, char* trans, integer* N, integer* K,
    doublereal* alpha, doublecomplex* A, integer* lda, doublereal* beta,
    doublecomplex* C, integer* ldc)
{
    return maloc_zherk(uplo, trans, N, K, alpha, A, lda, beta, C, ldc);
}

int zher2k__(char* uplo, char* trans, integer* N, integer* K,
    doublecomplex* alpha, doublecomplex* A, integer* lda, doublecomplex* B,
    integer* ldb, doublereal* beta, doublecomplex* C, integer* ldc)
{
    return maloc_zher2k(uplo, trans, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

/*
 * ***************************************************************************
 * Class BLAS FORTRAN binding STUBS (double underscore, uppercase)
 * ***************************************************************************
 */

real SDOT__(integer* N, real* X, integer* incX, real* Y, integer* incY)
{
    return maloc_sdot(N, X, incX, Y, incY);
}

doublereal DDOT__(integer* N, doublereal* X, integer* incX,
    doublereal* Y, integer* incY)
{
    return maloc_ddot(N, X, incX, Y, incY);
}

void CDOTU__(complex* retval, integer* N, complex* X, integer* incX,
    complex* Y, integer* incY)
{
    maloc_cdotu(retval, N, X, incX, Y, incY);
}

void CDOTC__(complex* retval, integer* N, complex* X, integer* incX,
    complex* Y, integer* incY)
{
    maloc_cdotc(retval, N, X, incX, Y, incY);
}

void ZDOTU__(doublecomplex* retval, integer* N, doublecomplex* X,
    integer* incX, doublecomplex* Y, integer* incY)
{
    maloc_zdotu(retval, N, X, incX, Y, incY);
}

void ZDOTC__(doublecomplex* retval, integer* N, doublecomplex* X,
    integer* incX, doublecomplex* Y, integer* incY)
{
    maloc_zdotc(retval, N, X, incX, Y, incY);
}

real SNRM2__(integer* N, real* X, integer* incX)
{
    return maloc_snrm2(N, X, incX);
}

real SASUM__(integer* N, real* X, integer* incX)
{
    return maloc_sasum(N, X, incX);
}

doublereal DNRM2__(integer* N, doublereal* X, integer* incX)
{
    return maloc_dnrm2(N, X, incX);
}

doublereal DASUM__(integer* N, doublereal* X, integer* incX)
{
    return maloc_dasum(N, X, incX);
}

real SCNRM2__(integer* N, complex* X, integer* incX)
{
    return maloc_scnrm2(N, X, incX);
}

real SCASUM__(integer* N, complex* X, integer* incX)
{
    return maloc_scasum(N, X, incX);
}

doublereal DZNRM2__(integer* N, doublecomplex* X, integer* incX)
{
    return maloc_dznrm2(N, X, incX);
}

doublereal DZASUM__(integer* N, doublecomplex* X, integer* incX)
{
    return maloc_dzasum(N, X, incX);
}

integer ISAMAX__(integer* N, real* X, integer* incX)
{
    return maloc_isamax(N, X, incX);
}

integer IDAMAX__(integer* N, doublereal* X, integer* incX)
{
    return maloc_idamax(N, X, incX);
}

integer ICAMAX__(integer* N, complex* X, integer* incX)
{
    return maloc_icamax(N, X, incX);
}

integer IZAMAX__(integer* N, doublecomplex* X, integer* incX)
{
    return maloc_izamax(N, X, incX);
}

int SSWAP__(integer* N, real* X, integer* incX, real* Y, integer* incY)
{
    return maloc_sswap(N, X, incX, Y, incY);
}

int SCOPY__(integer* N, real* X, integer* incX, real* Y, integer* incY)
{
    return maloc_scopy(N, X, incX, Y, incY);
}

int SAXPY__(integer* N, real* alpha, real* X, integer* incX,
    real* Y, integer* incY)
{
    return maloc_saxpy(N, alpha, X, incX, Y, incY);
}

int DSWAP__(integer* N, doublereal* X, integer* incX,
    doublereal* Y, integer* incY)
{
    return maloc_dswap(N, X, incX, Y, incY);
}

int DCOPY__(integer* N, doublereal* X, integer* incX,
    doublereal* Y, integer* incY)
{
    return maloc_dcopy(N, X, incX, Y, incY);
}

int DAXPY__(integer* N, doublereal* alpha, doublereal* X, integer* incX,
    doublereal* Y, integer* incY)
{
    return maloc_daxpy(N, alpha, X, incX, Y, incY);
}

int CSWAP__(integer* N, complex* X, integer* incX,
    complex* Y, integer* incY)
{
    return maloc_cswap(N, X, incX, Y, incY);
}

int CCOPY__(integer* N, complex* X, integer* incX,
    complex* Y, integer* incY)
{
    return maloc_ccopy(N, X, incX, Y, incY);
}

int CAXPY__(integer* N, complex* alpha,
    complex* X, integer* incX, complex* Y, integer* incY)
{
    return maloc_caxpy(N, alpha, X, incX, Y, incY);
}

int ZSWAP__(integer* N, doublecomplex* X, integer* incX, doublecomplex* Y,
    integer* incY)
{
    return maloc_zswap(N, X, incX, Y, incY);
}

int ZCOPY__(integer* N, doublecomplex* X, integer* incX, doublecomplex* Y,
    integer* incY)
{
    return maloc_zcopy(N, X, incX, Y, incY);
}

int ZAXPY__(integer* N, doublecomplex* alpha, doublecomplex* X,
    integer* incX, doublecomplex* Y, integer* incY)
{
    return maloc_zaxpy(N, alpha, X, incX, Y, incY);
}

int SROTG__(real* a, real* b, real* c, real* s)
{
    return maloc_srotg(a, b, c, s);
}

int SROT__(integer* N, real* X, integer* incX, real* Y, integer* incY,
    real* c, real* s)
{
    return maloc_srot(N, X, incX, Y, incY, c, s);
}

int DROTG__(doublereal* a, doublereal* b, doublereal* c, doublereal* s)
{
    return maloc_drotg(a, b, c, s);
}

int DROT__(integer* N, doublereal* X, integer* incX, doublereal* Y,
    integer* incY, doublereal* c, doublereal* s)
{
    return maloc_drot(N, X, incX, Y, incY, c, s);
}

int SSCAL__(integer* N, real* alpha, real* X, integer* incX)
{
    return maloc_sscal(N, alpha, X, incX);
}

int DSCAL__(integer* N, doublereal* alpha, doublereal* X, integer* incX)
{
    return maloc_dscal(N, alpha, X, incX);
}

int CSCAL__(integer* N, complex* alpha, complex* X, integer* incX)
{
    return maloc_cscal(N, alpha, X, incX);
}

int ZSCAL__(integer* N, doublecomplex* alpha, doublecomplex* X,
    integer* incX)
{
    return maloc_zscal(N, alpha, X, incX);
}

int CSSCAL__(integer* N, real* alpha, complex* X, integer* incX)
{
    return maloc_csscal(N, alpha, X, incX);
}

int ZDSCAL__(integer* N, doublereal* alpha, doublecomplex* X,
    integer* incX)
{
    return maloc_zdscal(N, alpha, X, incX);
}

int SGEMV__(char* trans, integer* M, integer* N, real* alpha, real* A,
    integer* lda, real* X, integer* incX, real* beta, real* Y, integer* incY)
{
    return maloc_sgemv(trans, M, N, alpha, A, lda, X, incX, beta, Y, incY);
}

int SGBMV__(char *trans, integer *M, integer *N, integer *KL, integer *KU, 
    real *alpha, real *A, integer *lda, real *X, integer *incX, real *beta, 
    real *Y, integer *incY)
{
    return maloc_sgbmv(trans, M, N, KL, KU, alpha, A, lda, X, incX, beta,
        Y, incY);
}

int STRMV__(char* uplo, char *trans, char* diag, integer *N, real *A,
    integer *lda, real *X, integer *incX)
{
    return maloc_strmv(uplo, trans, diag, N, A, lda, X, incX);
}

int STBMV__(char* uplo, char* trans, char* diag, integer* N, integer* K,
    real* A, integer* lda, real* X, integer* incX)
{
    return maloc_stbmv(uplo, trans, diag, N, K, A, lda, X, incX);
}

int STPMV__(char* uplo, char* trans, char* diag, integer* N, real* Ap, 
    real* X, integer* incX)
{
    return maloc_stpmv(uplo, trans, diag, N, Ap, X, incX);
}

int STRSV__(char* uplo, char* trans, char* diag, integer* N, real* A,
    integer* lda, real* X, integer* incX)
{
    return maloc_strsv(uplo, trans, diag, N, A, lda, X, incX);
}

int STBSV__(char* uplo, char* trans, char* diag, integer* N, integer* K,
    real* A, integer* lda, real* X, integer* incX)
{
    return maloc_stbsv(uplo, trans, diag, N, K, A, lda, X, incX);
}

int STPSV__(char* uplo, char* trans, char* diag, integer* N, real* Ap, 
    real* X, integer* incX)
{
    return maloc_stpsv(uplo, trans, diag, N, Ap, X, incX);
}

int DGEMV__(char* trans, integer* M, integer* N, doublereal* alpha,
    doublereal* A, integer* lda, doublereal* X, integer* incX,
    doublereal* beta, doublereal* Y, integer* incY)
{
    return maloc_dgemv(trans, M, N, alpha, A, lda, X, incX, beta, Y, incY);
}

int DGBMV__(char *trans, integer *M, integer *N, integer *KL, integer *KU, 
    doublereal *alpha, doublereal *A, integer *lda, doublereal *X,
    integer *incX, doublereal *beta, doublereal *Y, integer *incY)
{
    return maloc_dgbmv(trans, M, N, KL, KU, alpha, A, lda, X, incX, beta,
        Y, incY);
}

int DTRMV__(char* uplo, char *trans, char* diag, integer *N,  
    doublereal *A, integer *lda, doublereal *X, integer *incX)
{
    return maloc_dtrmv(uplo, trans, diag, N, A, lda, X, incX);
}

int DTBMV__(char* uplo, char* trans, char* diag, integer* N, integer* K,
    doublereal* A, integer* lda, doublereal* X, integer* incX)
{
    return maloc_dtbmv(uplo, trans, diag, N, K, A, lda, X, incX);
}

int DTPMV__(char* uplo, char* trans, char* diag, integer* N, 
    doublereal* Ap, doublereal* X, integer* incX)
{
    return maloc_dtpmv(uplo, trans, diag, N, Ap, X, incX);
}

int DTRSV__(char* uplo, char* trans, char* diag, integer* N,
    doublereal* A, integer* lda, doublereal* X, integer* incX)
{
    return maloc_dtrsv(uplo, trans, diag, N, A, lda, X, incX);
}

int DTBSV__(char* uplo, char* trans, char* diag, integer* N, integer* K,
    doublereal* A, integer* lda, doublereal* X, integer* incX)
{
    return maloc_dtbsv(uplo, trans, diag, N, K, A, lda, X, incX);
}

int DTPSV__(char* uplo, char* trans, char* diag, integer* N, 
    doublereal* Ap, doublereal* X, integer* incX)
{
    return maloc_dtpsv(uplo, trans, diag, N, Ap, X, incX);
}

int CGEMV__(char* trans, integer* M, integer* N, complex* alpha,
    complex* A, integer* lda, complex* X, integer* incX, complex* beta,
    complex* Y, integer* incY)
{
    return maloc_cgemv(trans, M, N, alpha, A, lda, X, incX, beta, Y, incY);
}

int CGBMV__(char *trans, integer *M, integer *N, integer *KL, integer *KU, 
    complex *alpha, complex *A, integer *lda, complex *X, integer *incX, 
    complex *beta, complex *Y, integer *incY)
{
    return maloc_cgbmv(trans, M, N, KL, KU, alpha, A, lda, X, incX, beta,
        Y, incY);
}

int CTRMV__(char* uplo, char *trans, char* diag, integer *N,  
    complex *A, integer *lda, complex *X, integer *incX)
{
    return maloc_ctrmv(uplo, trans, diag, N, A, lda, X, incX);
}

int CTBMV__(char* uplo, char* trans, char* diag, integer* N, integer* K,
    complex* A, integer* lda, complex* X, integer* incX)
{
    return maloc_ctbmv(uplo, trans, diag, N, K, A, lda, X, incX);
}

int CTPMV__(char* uplo, char* trans, char* diag, integer* N, 
    complex* Ap, complex* X, integer* incX)
{
    return maloc_ctpmv(uplo, trans, diag, N, Ap, X, incX);
}

int CTRSV__(char* uplo, char* trans, char* diag, integer* N,
    complex* A, integer* lda, complex* X, integer* incX)
{
    return maloc_ctrsv(uplo, trans, diag, N, A, lda, X, incX);
}

int CTBSV__(char* uplo, char* trans, char* diag, integer* N, integer* K,
    complex* A, integer* lda, complex* X, integer* incX)
{
    return maloc_ctbsv(uplo, trans, diag, N, K, A, lda, X, incX);
}

int CTPSV__(char* uplo, char* trans, char* diag, integer* N, 
    complex* Ap, complex* X, integer* incX)
{
    return maloc_ctpsv(uplo, trans, diag, N, Ap, X, incX);
}

int ZGEMV__(char* trans, integer* M, integer* N, doublecomplex* alpha,
    doublecomplex* A, integer* lda, doublecomplex* X, integer* incX,
    doublecomplex* beta, doublecomplex* Y, integer* incY)
{
    return maloc_zgemv(trans, M, N, alpha, A, lda, X, incX, beta, Y, incY);
}

int ZGBMV__(char *trans, integer *M, integer *N, integer *KL, integer *KU, 
    doublecomplex *alpha, doublecomplex *A, integer *lda, doublecomplex *X,
    integer *incX, doublecomplex *beta, doublecomplex *Y, integer *incY)
{
    return maloc_zgbmv(trans, M, N, KL, KU, alpha, A, lda, X, incX, beta,
        Y, incY);
}

int ZTRMV__(char* uplo, char *trans, char* diag, integer *N,  
    doublecomplex *A, integer *lda, doublecomplex *X, integer *incX)
{
    return maloc_ztrmv(uplo, trans, diag, N, A, lda, X, incX);
}

int ZTBMV__(char* uplo, char* trans, char* diag, integer* N, integer* K,
    doublecomplex* A, integer* lda, doublecomplex* X, integer* incX)
{
    return maloc_ztbmv(uplo, trans, diag, N, K, A, lda, X, incX);
}

void ZTPMV__(char* uplo, char* trans, char* diag, integer* N, 
    doublecomplex* Ap, doublecomplex* X, integer* incX)
{
    maloc_ztpmv(uplo, trans, diag, N, Ap, X, incX);
}

int ZTRSV__(char* uplo, char* trans, char* diag, integer* N,
    doublecomplex* A, integer* lda, doublecomplex* X, integer* incX)
{
    return maloc_ztrsv(uplo, trans, diag, N, A, lda, X, incX);
}

int ZTBSV__(char* uplo, char* trans, char* diag, integer* N, integer* K,
    doublecomplex* A, integer* lda, doublecomplex* X, integer* incX)
{
    return maloc_ztbsv(uplo, trans, diag, N, K, A, lda, X, incX);
}

int ZTPSV__(char* uplo, char* trans, char* diag, integer* N, 
    doublecomplex* Ap, doublecomplex* X, integer* incX)
{
    return maloc_ztpsv(uplo, trans, diag, N, Ap, X, incX);
}

int SSYMV__(char* uplo, integer* N, real* alpha, real* A, integer* lda,
    real* X, integer* incX, real* beta, real* Y, integer* incY)
{
    return maloc_ssymv(uplo, N, alpha, A, lda, X, incX, beta, Y, incY);
}

int SSBMV__(char* uplo, integer* N, integer* K, real* alpha,
    real* A, integer* lda, real* X, integer* incX, real* beta,
    real* Y, integer* incY)
{
    return maloc_ssbmv(uplo, N, K, alpha, A, lda, X, incX, beta, Y, incY);
}

int SSPMV__(char* uplo, integer* N, real* alpha, real* Ap,
    real* X, integer* incX, real* beta, real* Y, integer* incY)
{
    return maloc_sspmv(uplo, N, alpha, Ap, X, incX, beta, Y, incY);
}

int SGER__(integer* M, integer* N, real* alpha, real* X, integer* incX,
    real* Y, integer* incY, real* A, integer* lda)
{
    return maloc_sger(M, N, alpha, X, incX, Y, incY, A, lda);
}

int SSYR__(char* uplo, integer* N, real* alpha, real* X, integer* incX,
    real* A, integer* lda)
{
    return maloc_ssyr(uplo, N, alpha, X, incX, A, lda);
}

int SSPR__(char* uplo, integer* N, real* alpha, real* X, integer* incX,
    real* Ap)
{
    return maloc_sspr(uplo, N, alpha, X, incX, Ap);
}

int SSYR2__(char* uplo, integer* N, real* alpha, real* X, integer* incX,
    real* Y, integer* incY, real* A, integer* lda)
{
    return maloc_ssyr2(uplo, N, alpha, X, incX, Y, incY, A, lda);
}

int SSPR2__(char* uplo, integer* N, real* alpha, real* X, integer* incX,
    real* Y, integer* incY, real* A)
{
    return maloc_sspr2(uplo, N, alpha, X, incX, Y, incY, A);
}

int DSYMV__(char* uplo, integer* N, doublereal* alpha, doublereal* A,
    integer* lda, doublereal* X, integer* incX, doublereal* beta,
    doublereal* Y, integer* incY)
{
    return maloc_dsymv(uplo, N, alpha, A, lda, X, incX, beta, Y, incY);
}

int DSBMV__(char* uplo, integer* N, integer* K, doublereal* alpha,
    doublereal* A, integer* lda, doublereal* X, integer* incX,
    doublereal* beta, doublereal* Y, integer* incY)
{
    return maloc_dsbmv(uplo, N, K, alpha, A, lda, X, incX, beta, Y, incY);
}

int DSPMV__(char* uplo, integer* N, doublereal* alpha, doublereal* Ap,
    doublereal* X, integer* incX, doublereal* beta,
    doublereal* Y, integer* incY)
{
    return maloc_dspmv(uplo, N, alpha, Ap, X, incX, beta, Y, incY);
}

int DGER__(integer* M, integer* N, doublereal* alpha, doublereal* X,
    integer* incX, doublereal* Y, integer* incY, doublereal* A, integer* lda)
{
    return maloc_dger(M, N, alpha, X, incX, Y, incY, A, lda);
}

int DSYR__(char* uplo, integer* N, doublereal* alpha, doublereal* X,
    integer* incX, doublereal* A, integer* lda)
{
    return maloc_dsyr(uplo, N, alpha, X, incX, A, lda);
}

int DSPR__(char* uplo, integer* N, doublereal* alpha, doublereal* X,
    integer* incX, doublereal* Ap)
{
    return maloc_dspr(uplo, N, alpha, X, incX, Ap);
}

int DSYR2__(char* uplo, integer* N, doublereal* alpha, doublereal* X,
    integer* incX, doublereal* Y, integer* incY, doublereal* A, integer* lda)
{
    return maloc_dsyr2(uplo, N, alpha, X, incX, Y, incY, A, lda);
}

int DSPR2__(char* uplo, integer* N, doublereal* alpha, doublereal* X,
    integer* incX, doublereal* Y, integer* incY, doublereal* A)
{
    return maloc_dspr2(uplo, N, alpha, X, incX, Y, incY, A);
}

int CHEMV__(char* uplo, integer* N, complex* alpha, complex* A,
    integer* lda, complex* X, integer* incX, complex* beta,
    complex* Y, integer* incY)
{
    return maloc_chemv(uplo, N, alpha, A, lda, X, incX, beta, Y, incY);
}

int CHBMV__(char* uplo, integer* N, integer* K, complex* alpha,
    complex* A, integer* lda, complex* X, integer* incX, complex* beta,
    complex* Y, integer* incY)
{
    return maloc_chbmv(uplo, N, K, alpha, A, lda, X, incX, beta, Y, incY);
}

int CHPMV__(char* uplo, integer* N, complex* alpha, complex* Ap, 
    complex* X, integer* incX, complex* beta, complex* Y, integer* incY)
{
    return maloc_chpmv(uplo, N, alpha, Ap, X, incX, beta, Y, incY);
}

int CGERU__(integer* M, integer* N, complex* alpha, complex* X,
    integer* incX, complex* Y, integer* incY, complex* A, integer* lda)
{
    return maloc_cgeru(M, N, alpha, X, incX, Y, incY, A, lda);
}

int CGERC__(integer* M, integer* N, complex* alpha, complex* X,
    integer* incX, complex* Y, integer* incY, complex* A, integer* lda)
{
    return maloc_cgerc(M, N, alpha, X, incX, Y, incY, A, lda);
}

int CHER__(char* uplo, integer* N, real* alpha, complex* X, integer* incX,
    complex* A, integer* lda)
{
    return maloc_cher(uplo, N, alpha, X, incX, A, lda);
}

int CHPR__(char* uplo, integer* N, real* alpha, complex* X, integer* incX,
    complex* Ap)
{
    return maloc_chpr(uplo, N, alpha, X, incX, Ap);
}

int CHER2__(char* uplo, integer* N, complex* alpha, complex* X,
    integer* incX, complex* Y, integer* incY, complex* A, integer* lda)
{
    return maloc_cher2(uplo, N, alpha, X, incX, Y, incY, A, lda);
}

int CHPR2__(char* uplo, integer* N, complex* alpha, complex* X,
    integer* incX, complex* Y, integer* incY, complex* Ap)
{
    return maloc_chpr2(uplo, N, alpha, X, incX, Y, incY, Ap);
}

int ZHEMV__(char* uplo, integer* N, doublecomplex* alpha,
    doublecomplex* A, integer* lda, doublecomplex* X, integer* incX,
    doublecomplex* beta, doublecomplex* Y, integer* incY)
{
    return maloc_zhemv(uplo, N, alpha, A, lda, X, incX, beta, Y, incY);
}

int ZHBMV__(char* uplo, integer* N, integer* K, doublecomplex* alpha,
    doublecomplex* A, integer* lda, doublecomplex* X, integer* incX,
    doublecomplex* beta, doublecomplex* Y, integer* incY)
{
    return maloc_zhbmv(uplo, N, K, alpha, A, lda, X, incX, beta, Y, incY);
}

int ZHPMV__(char* uplo, integer* N, doublecomplex* alpha,
    doublecomplex* Ap, doublecomplex* X, integer* incX,
    doublecomplex* beta, doublecomplex* Y, integer* incY)
{
    return maloc_zhpmv(uplo, N, alpha, Ap, X, incX, beta, Y, incY);
}

int ZGERU__(integer* M, integer* N, doublecomplex* alpha,
    doublecomplex* X, integer* incX, doublecomplex* Y, integer* incY,
    doublecomplex* A, integer* lda)
{
    return maloc_zgeru(M, N, alpha, X, incX, Y, incY, A, lda);
}

int ZGERC__(integer* M, integer* N, doublecomplex* alpha,
    doublecomplex* X, integer* incX, doublecomplex* Y, integer* incY,
    doublecomplex* A, integer* lda)
{
    return maloc_zgerc(M, N, alpha, X, incX, Y, incY, A, lda);
}

int ZHER__(char* uplo, integer* N, doublereal* alpha,
    doublecomplex* X, integer* incX, doublecomplex* A, integer* lda)
{
    return maloc_zher(uplo, N, alpha, X, incX, A, lda);
}

int ZHPR__(char* uplo, integer* N, doublereal* alpha,
    doublecomplex* X, integer* incX, doublecomplex* Ap)
{
    return maloc_zhpr(uplo, N, alpha, X, incX, Ap);
}

int ZHER2__(char* uplo, integer* N, doublecomplex* alpha,
    doublecomplex* X, integer* incX, doublecomplex* Y, integer* incY,
    doublecomplex* A, integer* lda)
{
    return maloc_zher2(uplo, N, alpha, X, incX, Y, incY, A, lda);
}

int ZHPR2__(char* uplo, integer* N, doublecomplex* alpha,
    doublecomplex* X, integer* incX, doublecomplex* Y, integer* incY,
    doublecomplex* Ap)
{
    return maloc_zhpr2(uplo, N, alpha, X, incX, Y, incY, Ap);
}

int SGEMM__(char* transA, char* transB, integer* M, integer* N,
    integer* K, real* alpha, real* A, integer* lda, real* B, integer* ldb,
    real* beta, real* C, integer* ldc)
{
    return maloc_sgemm(transA, transB, M, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

int SSYMM__(char* side, char* uplo, integer* M, integer* N,
    real* alpha, real* A, integer* lda, real* B, integer* ldb,
    real* beta, real* C, integer* ldc)
{
    return maloc_ssymm(side, uplo, M, N, alpha, A, lda, B, ldb, beta, C, ldc);
}

int SSYRK__(char* uplo, char* trans, integer* N, integer* K,
    real* alpha, real* A, integer* lda, real* beta, real* C, integer* ldc)
{
    return maloc_ssyrk(uplo, trans, N, K, alpha, A, lda, beta, C, ldc);
}

int SSYR2K__(char* uplo, char* trans, integer* N, integer* K,
    real* alpha, real* A, integer* lda, real* B, integer* ldb,
    real* beta, real* C, integer* ldc)
{
    return maloc_ssyr2k(uplo, trans, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

int STRMM__(char* side, char* uplo, char* trans, char* diag, 
    integer* M, integer* N, real* alpha, real* A, integer* lda,
    real* B, integer* ldb)
{
    return maloc_strmm(side, uplo, trans, diag, M, N, alpha, A, lda, B, ldb);
}

int STRSM__(char* side, char* uplo, char* trans, char* diag,
    integer* M, integer* N, real* alpha, real* A, integer* lda,
    real* B, integer* ldb)
{
    return maloc_strsm(side, uplo, trans, diag, M, N, alpha, A, lda, B, ldb);
}

int DGEMM__(char* transA, char* transB, integer* M, integer* N,
    integer* K, doublereal* alpha, doublereal* A, integer* lda,
    doublereal* B, integer* ldb, doublereal* beta,
    doublereal* C, integer* ldc)
{
    return maloc_dgemm(transA, transB, M, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

int DSYMM__(char* side, char* uplo, integer* M, integer* N,
    doublereal* alpha, doublereal* A, integer* lda, doublereal* B,
    integer* ldb, doublereal* beta, doublereal* C, integer* ldc)
{
    return maloc_dsymm(side, uplo, M, N, alpha, A, lda, B, ldb, beta, C, ldc);
}

int DSYRK__(char* uplo, char* trans, integer* N, integer* K,
    doublereal* alpha, doublereal* A, integer* lda, doublereal* beta,
    doublereal* C, integer* ldc)
{
    return maloc_dsyrk(uplo, trans, N, K, alpha, A, lda, beta, C, ldc);
}

int DSYR2K__(char* uplo, char* trans, integer* N, integer* K,
    doublereal* alpha, doublereal* A, integer* lda, doublereal* B,
    integer* ldb, doublereal* beta, doublereal* C, integer* ldc)
{
    return maloc_dsyr2k(uplo, trans, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

int DTRMM__(char* side, char* uplo, char* trans, char* diag, 
    integer* M, integer* N, doublereal* alpha, doublereal* A,
    integer* lda, doublereal* B, integer* ldb)
{
    return maloc_dtrmm(side, uplo, trans, diag, M, N, alpha, A, lda, B, ldb);
}

int DTRSM__(char* side, char* uplo, char* trans, char* diag,
    integer* M, integer* N, doublereal* alpha, doublereal* A,
    integer* lda, doublereal* B, integer* ldb)
{
    return maloc_dtrsm(side, uplo, trans, diag, M, N, alpha, A, lda, B, ldb);
}

int CGEMM__(char* transA, char* transB, integer* M, integer* N,
    integer* K, complex* alpha, complex* A, integer* lda, complex* B,
    integer* ldb, complex* beta, complex* C, integer* ldc)
{
    return maloc_cgemm(transA, transB, M, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

int CSYMM__(char* side, char* uplo, integer* M, integer* N,
    complex* alpha, complex* A, integer* lda, complex* B, integer* ldb,
    complex* beta, complex* C, integer* ldc)
{
    return maloc_csymm(side, uplo, M, N, alpha, A, lda, B, ldb, beta, C, ldc);
}

int CSYRK__(char* uplo, char* trans, integer* N, integer* K,
    complex* alpha, complex* A, integer* lda, complex* beta,
    complex* C, integer* ldc)
{
    return maloc_csyrk(uplo, trans, N, K, alpha, A, lda, beta, C, ldc);
}

int CSYR2K__(char* uplo, char* trans, integer* N, integer* K,
    complex* alpha, complex* A, integer* lda, complex* B, integer* ldb,
    complex* beta, complex* C, integer* ldc)
{
    return maloc_csyr2k(uplo, trans, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

int CTRMM__(char* side, char* uplo, char* trans, char* diag, 
    integer* M, integer* N, complex* alpha, complex* A, integer* lda,
    complex* B, integer* ldb)
{
    return maloc_ctrmm(side, uplo, trans, diag, M, N, alpha, A, lda, B, ldb);
}

int CTRSM__(char* side, char* uplo, char* trans, char* diag,
    integer* M, integer* N, complex* alpha, complex* A, integer* lda,
    complex* B, integer* ldb)
{
    return maloc_ctrsm(side, uplo, trans, diag, M, N, alpha, A, lda, B, ldb);
}

int ZGEMM__(char* transA, char* transB, integer* M, integer* N,
    integer* K, doublecomplex* alpha, doublecomplex* A, integer* lda,
    doublecomplex* B, integer* ldb, doublecomplex* beta,
    doublecomplex* C, integer* ldc)
{
    return maloc_zgemm(transA, transB, M, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

int ZSYMM__(char* side, char* uplo, integer* M, integer* N,
    doublecomplex* alpha, doublecomplex* A, integer* lda, doublecomplex* B,
    integer* ldb, doublecomplex* beta, doublecomplex* C, integer* ldc)
{
    return maloc_zsymm(side, uplo, M, N, alpha, A, lda, B, ldb, beta, C, ldc);
}

int ZSYRK__(char* uplo, char* trans, integer* N, integer* K,
    doublecomplex* alpha, doublecomplex* A, integer* lda,
    doublecomplex* beta, doublecomplex* C, integer* ldc)
{
    return maloc_zsyrk(uplo, trans, N, K, alpha, A, lda, beta, C, ldc);
}

int ZSYR2K__(char* uplo, char* trans, integer* N, integer* K,
    doublecomplex* alpha, doublecomplex* A, integer* lda, doublecomplex* B,
    integer* ldb, doublecomplex* beta, doublecomplex* C, integer* ldc)
{
    return maloc_zsyr2k(uplo, trans, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

int ZTRMM__(char* side, char* uplo, char* trans, char* diag, 
    integer* M, integer* N, doublecomplex* alpha, doublecomplex* A,
    integer* lda, doublecomplex* B, integer* ldb)
{
    return maloc_ztrmm(side, uplo, trans, diag, M, N, alpha, A, lda, B, ldb);
}

int ZTRSM__(char* side, char* uplo, char* trans, char* diag,
    integer* M, integer* N, doublecomplex* alpha, doublecomplex* A,
    integer* lda, doublecomplex* B, integer* ldb)
{
    return maloc_ztrsm(side, uplo, trans, diag, M, N, alpha, A, lda, B, ldb);
}

int CHEMM__(char* side, char* uplo, integer* M, integer* N,
    complex* alpha, complex* A, integer* lda, complex* B, integer* ldb,
    complex* beta, complex* C, integer* ldc)
{
    return maloc_chemm(side, uplo, M, N, alpha, A, lda, B, ldb, beta, C, ldc);
}

int CHERK__(char* uplo, char* trans, integer* N, integer* K,
    real* alpha, complex* A, integer* lda, real* beta,
    complex* C, integer* ldc)
{
    return maloc_cherk(uplo, trans, N, K, alpha, A, lda, beta, C, ldc);
}

int CHER2K__(char* uplo, char* trans, integer* N, integer* K,
    complex* alpha, complex* A, integer* lda, complex* B, integer* ldb,
    real* beta, complex* C, integer* ldc)
{
    return maloc_cher2k(uplo, trans, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

int ZHEMM__(char* side, char* uplo, integer* M, integer* N,
    doublecomplex* alpha, doublecomplex* A, integer* lda, doublecomplex* B,
    integer* ldb, doublecomplex* beta, doublecomplex* C, integer* ldc)
{
    return maloc_zhemm(side, uplo, M, N, alpha, A, lda, B, ldb, beta, C, ldc);
}

int ZHERK__(char* uplo, char* trans, integer* N, integer* K,
    doublereal* alpha, doublecomplex* A, integer* lda, doublereal* beta,
    doublecomplex* C, integer* ldc)
{
    return maloc_zherk(uplo, trans, N, K, alpha, A, lda, beta, C, ldc);
}

int ZHER2K__(char* uplo, char* trans, integer* N, integer* K,
    doublecomplex* alpha, doublecomplex* A, integer* lda, doublecomplex* B,
    integer* ldb, doublereal* beta, doublecomplex* C, integer* ldc)
{
    return maloc_zher2k(uplo, trans, N, K, alpha, A, lda, B, ldb, beta,
        C, ldc);
}

