/*
 * FILE : apbslib.c
 * 
 * This file was automatically generated by :
 * Simplified Wrapper and Interface Generator (SWIG)
 * Version 1.1 (Patch 5)
 * 
 * Portions Copyright (c) 1995-1998
 * The University of Utah and The Regents of the University of California.
 * Permission is granted to distribute this file in any manner provided
 * this notice remains intact.
 * 
 * Do not make changes to this file--changes will be lost!
 *
 */


#define SWIGCODE
/* Implementation : PYTHON */

#define SWIGPYTHON
#include <string.h>
#include <stdlib.h>
/***********************************************************************
 * $Header: /home/apbs/cvsroot/apbs/tools/python/apbslib.c,v 1.2 2004/02/11 18:49:53 apbs Exp $
 * swig_lib/python/python.cfg
 *
 * This file contains coded needed to add variable linking to the
 * Python interpreter.   C variables are added as a new kind of Python
 * datatype.
 *
 * Also contains supporting code for building python under Windows
 * and things like that.
 *
 * $Log: apbslib.c,v $
 * Revision 1.2  2004/02/11 18:49:53  apbs
 * Allows Python wrapped APBS to use ELEC names
 *
 ************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif
#include "Python.h"
#ifdef __cplusplus
}
#endif

/* Definitions for Windows/Unix exporting */
#if defined(__WIN32__)
#   if defined(_MSC_VER)
#	define SWIGEXPORT(a,b) __declspec(dllexport) a b
#   else
#	if defined(__BORLANDC__)
#	    define SWIGEXPORT(a,b) a _export b
#	else
#	    define SWIGEXPORT(a,b) a b
#	endif
#   endif
#else
#   define SWIGEXPORT(a,b) a b
#endif

#ifdef SWIG_GLOBAL
#ifdef __cplusplus
#define SWIGSTATIC extern "C"
#else
#define SWIGSTATIC
#endif
#endif

#ifndef SWIGSTATIC
#define SWIGSTATIC static
#endif

typedef struct {
  char  *name;
  PyObject *(*get_attr)(void);
  int (*set_attr)(PyObject *);
} swig_globalvar;

typedef struct swig_varlinkobject {
  PyObject_HEAD
  swig_globalvar **vars;
  int      nvars;
  int      maxvars;
} swig_varlinkobject;

/* ----------------------------------------------------------------------
   swig_varlink_repr()

   Function for python repr method
   ---------------------------------------------------------------------- */

static PyObject *
swig_varlink_repr(swig_varlinkobject *v)
{
  v = v;
  return PyString_FromString("<Global variables>");
}

/* ---------------------------------------------------------------------
   swig_varlink_print()

   Print out all of the global variable names
   --------------------------------------------------------------------- */

static int
swig_varlink_print(swig_varlinkobject *v, FILE *fp, int flags)
{

  int i = 0;
  flags = flags;
  fprintf(fp,"Global variables { ");
  while (v->vars[i]) {
    fprintf(fp,"%s", v->vars[i]->name);
    i++;
    if (v->vars[i]) fprintf(fp,", ");
  }
  fprintf(fp," }\n");
  return 0;
}

/* --------------------------------------------------------------------
   swig_varlink_getattr
 
   This function gets the value of a variable and returns it as a
   PyObject.   In our case, we'll be looking at the datatype and
   converting into a number or string
   -------------------------------------------------------------------- */

static PyObject *
swig_varlink_getattr(swig_varlinkobject *v, char *n)
{
  int i = 0;
  char temp[128];

  while (v->vars[i]) {
    if (strcmp(v->vars[i]->name,n) == 0) {
      return (*v->vars[i]->get_attr)();
    }
    i++;
  }
  sprintf(temp,"C global variable %s not found.", n);
  PyErr_SetString(PyExc_NameError,temp);
  return NULL;
}

/* -------------------------------------------------------------------
   swig_varlink_setattr()

   This function sets the value of a variable.
   ------------------------------------------------------------------- */

static int
swig_varlink_setattr(swig_varlinkobject *v, char *n, PyObject *p)
{
  char temp[128];
  int i = 0;
  while (v->vars[i]) {
    if (strcmp(v->vars[i]->name,n) == 0) {
      return (*v->vars[i]->set_attr)(p);
    }
    i++;
  }
  sprintf(temp,"C global variable %s not found.", n);
  PyErr_SetString(PyExc_NameError,temp);
  return 1;
}

statichere PyTypeObject varlinktype = {
/*  PyObject_HEAD_INIT(&PyType_Type)  Note : This doesn't work on some machines */
  PyObject_HEAD_INIT(0)              
  0,
  "varlink",                          /* Type name    */
  sizeof(swig_varlinkobject),         /* Basic size   */
  0,                                  /* Itemsize     */
  0,                                  /* Deallocator  */ 
  (printfunc) swig_varlink_print,     /* Print        */
  (getattrfunc) swig_varlink_getattr, /* get attr     */
  (setattrfunc) swig_varlink_setattr, /* Set attr     */
  0,                                  /* tp_compare   */
  (reprfunc) swig_varlink_repr,       /* tp_repr      */    
  0,                                  /* tp_as_number */
  0,                                  /* tp_as_mapping*/
  0,                                  /* tp_hash      */
};

/* Create a variable linking object for use later */

SWIGSTATIC PyObject *
SWIG_newvarlink(void)
{
  swig_varlinkobject *result = 0;
  result = PyMem_NEW(swig_varlinkobject,1);
  varlinktype.ob_type = &PyType_Type;    /* Patch varlinktype into a PyType */
  result->ob_type = &varlinktype;
  /*  _Py_NewReference(result);  Does not seem to be necessary */
  result->nvars = 0;
  result->maxvars = 64;
  result->vars = (swig_globalvar **) malloc(64*sizeof(swig_globalvar *));
  result->vars[0] = 0;
  result->ob_refcnt = 0;
  Py_XINCREF((PyObject *) result);
  return ((PyObject*) result);
}

SWIGSTATIC void
SWIG_addvarlink(PyObject *p, char *name,
	   PyObject *(*get_attr)(void), int (*set_attr)(PyObject *p))
{
  swig_varlinkobject *v;
  v= (swig_varlinkobject *) p;
	
  if (v->nvars >= v->maxvars -1) {
    v->maxvars = 2*v->maxvars;
    v->vars = (swig_globalvar **) realloc(v->vars,v->maxvars*sizeof(swig_globalvar *));
    if (v->vars == NULL) {
      fprintf(stderr,"SWIG : Fatal error in initializing Python module.\n");
      exit(1);
    }
  }
  v->vars[v->nvars] = (swig_globalvar *) malloc(sizeof(swig_globalvar));
  v->vars[v->nvars]->name = (char *) malloc(strlen(name)+1);
  strcpy(v->vars[v->nvars]->name,name);
  v->vars[v->nvars]->get_attr = get_attr;
  v->vars[v->nvars]->set_attr = set_attr;
  v->nvars++;
  v->vars[v->nvars] = 0;
}



/*****************************************************************************
 * $Header: /home/apbs/cvsroot/apbs/tools/python/apbslib.c,v 1.2 2004/02/11 18:49:53 apbs Exp $
 *
 * swigptr.swg
 *
 * This file contains supporting code for the SWIG run-time type checking
 * mechanism.  The following functions are available :
 *
 * SWIG_RegisterMapping(char *origtype, char *newtype, void *(*cast)(void *));
 *
 *      Registers a new type-mapping with the type-checker.  origtype is the
 *      original datatype and newtype is an equivalent type.  cast is optional
 *      pointer to a function to cast pointer values between types (this
 *      is typically used to cast pointers from derived classes to base classes in C++)
 *      
 * SWIG_MakePtr(char *buffer, void *ptr, char *typestring);
 *     
 *      Makes a pointer string from a pointer and typestring.  The result is returned
 *      in buffer which is assumed to hold enough space for the result.
 *
 * char * SWIG_GetPtr(char *buffer, void **ptr, char *type)
 *
 *      Gets a pointer value from a string.  If there is a type-mismatch, returns
 *      a character string to the received type.  On success, returns NULL.
 *
 *
 * You can remap these functions by making a file called "swigptr.swg" in
 * your the same directory as the interface file you are wrapping.
 *
 * These functions are normally declared static, but this file can be
 * can be used in a multi-module environment by redefining the symbol
 * SWIGSTATIC.
 *****************************************************************************/

#include <stdlib.h>

#ifdef SWIG_GLOBAL
#ifdef __cplusplus
#define SWIGSTATIC extern "C"
#else
#define SWIGSTATIC
#endif
#endif

#ifndef SWIGSTATIC
#define SWIGSTATIC static
#endif


/* SWIG pointer structure */

typedef struct SwigPtrType {
  char               *name;               /* Datatype name                  */
  int                 len;                /* Length (used for optimization) */
  void               *(*cast)(void *);    /* Pointer casting function       */
  struct SwigPtrType *next;               /* Linked list pointer            */
} SwigPtrType;

/* Pointer cache structure */

typedef struct {
  int                 stat;               /* Status (valid) bit             */
  SwigPtrType        *tp;                 /* Pointer to type structure      */
  char                name[256];          /* Given datatype name            */
  char                mapped[256];        /* Equivalent name                */
} SwigCacheType;

/* Some variables  */

static int SwigPtrMax  = 64;           /* Max entries that can be currently held */
                                       /* This value may be adjusted dynamically */
static int SwigPtrN    = 0;            /* Current number of entries              */
static int SwigPtrSort = 0;            /* Status flag indicating sort            */
static int SwigStart[256];             /* Starting positions of types            */

/* Pointer table */
static SwigPtrType *SwigPtrTable = 0;  /* Table containing pointer equivalences  */

/* Cached values */

#define SWIG_CACHESIZE  8
#define SWIG_CACHEMASK  0x7
static SwigCacheType SwigCache[SWIG_CACHESIZE];  
static int SwigCacheIndex = 0;
static int SwigLastCache = 0;

/* Sort comparison function */
static int swigsort(const void *data1, const void *data2) {
	SwigPtrType *d1 = (SwigPtrType *) data1;
	SwigPtrType *d2 = (SwigPtrType *) data2;
	return strcmp(d1->name,d2->name);
}

/* Binary Search function */
static int swigcmp(const void *key, const void *data) {
  char *k = (char *) key;
  SwigPtrType *d = (SwigPtrType *) data;
  return strncmp(k,d->name,d->len);
}

/* Register a new datatype with the type-checker */

SWIGSTATIC 
void SWIG_RegisterMapping(char *origtype, char *newtype, void *(*cast)(void *)) {

  int i;
  SwigPtrType *t = 0,*t1;

  /* Allocate the pointer table if necessary */

  if (!SwigPtrTable) {     
    SwigPtrTable = (SwigPtrType *) malloc(SwigPtrMax*sizeof(SwigPtrType));
    SwigPtrN = 0;
  }
  /* Grow the table */
  if (SwigPtrN >= SwigPtrMax) {
    SwigPtrMax = 2*SwigPtrMax;
    SwigPtrTable = (SwigPtrType *) realloc((char *) SwigPtrTable,SwigPtrMax*sizeof(SwigPtrType));
  }
  for (i = 0; i < SwigPtrN; i++)
    if (strcmp(SwigPtrTable[i].name,origtype) == 0) {
      t = &SwigPtrTable[i];
      break;
    }
  if (!t) {
    t = &SwigPtrTable[SwigPtrN];
    t->name = origtype;
    t->len = strlen(t->name);
    t->cast = 0;
    t->next = 0;
    SwigPtrN++;
  }

  /* Check for existing entry */

  while (t->next) {
    if ((strcmp(t->name,newtype) == 0)) {
      if (cast) t->cast = cast;
      return;
    }
    t = t->next;
  }
  
  /* Now place entry (in sorted order) */

  t1 = (SwigPtrType *) malloc(sizeof(SwigPtrType));
  t1->name = newtype;
  t1->len = strlen(t1->name);
  t1->cast = cast;
  t1->next = 0;            
  t->next = t1;           
  SwigPtrSort = 0;
}

/* Make a pointer value string */

SWIGSTATIC 
void SWIG_MakePtr(char *_c, const void *_ptr, char *type) {
  static char _hex[16] =
  {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
   'a', 'b', 'c', 'd', 'e', 'f'};
  unsigned long _p, _s;
  char _result[20], *_r;    /* Note : a 64-bit hex number = 16 digits */
  _r = _result;
  _p = (unsigned long) _ptr;
  if (_p > 0) {
    while (_p > 0) {
      _s = _p & 0xf;
      *(_r++) = _hex[_s];
      _p = _p >> 4;
    }
    *_r = '_';
    while (_r >= _result)
      *(_c++) = *(_r--);
  } else {
    strcpy (_c, "NULL");
  }
  if (_ptr)
    strcpy (_c, type);
}

/* Define for backwards compatibility */

#define _swig_make_hex   SWIG_MakePtr 

/* Function for getting a pointer value */

SWIGSTATIC 
char *SWIG_GetPtr(char *_c, void **ptr, char *_t)
{
  unsigned long _p;
  char temp_type[256];
  char *name;
  int  i, len;
  SwigPtrType *sp,*tp;
  SwigCacheType *cache;
  int  start, end;
  _p = 0;

  /* Pointer values must start with leading underscore */
  if (*_c == '_') {
      _c++;
      /* Extract hex value from pointer */
      while (*_c) {
	  if ((*_c >= '0') && (*_c <= '9'))
	    _p = (_p << 4) + (*_c - '0');
	  else if ((*_c >= 'a') && (*_c <= 'f'))
	    _p = (_p << 4) + ((*_c - 'a') + 10);
	  else
	    break;
	  _c++;
      }

      if (_t) {
	if (strcmp(_t,_c)) { 
	  if (!SwigPtrSort) {
	    qsort((void *) SwigPtrTable, SwigPtrN, sizeof(SwigPtrType), swigsort); 
	    for (i = 0; i < 256; i++) {
	      SwigStart[i] = SwigPtrN;
	    }
	    for (i = SwigPtrN-1; i >= 0; i--) {
	      SwigStart[(int) (SwigPtrTable[i].name[1])] = i;
	    }
	    for (i = 255; i >= 1; i--) {
	      if (SwigStart[i-1] > SwigStart[i])
		SwigStart[i-1] = SwigStart[i];
	    }
	    SwigPtrSort = 1;
	    for (i = 0; i < SWIG_CACHESIZE; i++)  
	      SwigCache[i].stat = 0;
	  }
	  
	  /* First check cache for matches.  Uses last cache value as starting point */
	  cache = &SwigCache[SwigLastCache];
	  for (i = 0; i < SWIG_CACHESIZE; i++) {
	    if (cache->stat) {
	      if (strcmp(_t,cache->name) == 0) {
		if (strcmp(_c,cache->mapped) == 0) {
		  cache->stat++;
		  *ptr = (void *) _p;
		  if (cache->tp->cast) *ptr = (*(cache->tp->cast))(*ptr);
		  return (char *) 0;
		}
	      }
	    }
	    SwigLastCache = (SwigLastCache+1) & SWIG_CACHEMASK;
	    if (!SwigLastCache) cache = SwigCache;
	    else cache++;
	  }
	  /* We have a type mismatch.  Will have to look through our type
	     mapping table to figure out whether or not we can accept this datatype */

	  start = SwigStart[(int) _t[1]];
	  end = SwigStart[(int) _t[1]+1];
	  sp = &SwigPtrTable[start];
	  while (start < end) {
	    if (swigcmp(_t,sp) == 0) break;
	    sp++;
	    start++;
	  }
	  if (start >= end) sp = 0;
	  /* Try to find a match for this */
	  if (sp) {
	    while (swigcmp(_t,sp) == 0) {
	      name = sp->name;
	      len = sp->len;
	      tp = sp->next;
	      /* Try to find entry for our given datatype */
	      while(tp) {
		if (tp->len >= 255) {
		  return _c;
		}
		strcpy(temp_type,tp->name);
		strncat(temp_type,_t+len,255-tp->len);
		if (strcmp(_c,temp_type) == 0) {
		  
		  strcpy(SwigCache[SwigCacheIndex].mapped,_c);
		  strcpy(SwigCache[SwigCacheIndex].name,_t);
		  SwigCache[SwigCacheIndex].stat = 1;
		  SwigCache[SwigCacheIndex].tp = tp;
		  SwigCacheIndex = SwigCacheIndex & SWIG_CACHEMASK;
		  
		  /* Get pointer value */
		  *ptr = (void *) _p;
		  if (tp->cast) *ptr = (*(tp->cast))(*ptr);
		  return (char *) 0;
		}
		tp = tp->next;
	      }
	      sp++;
	      /* Hmmm. Didn't find it this time */
	    }
	  }
	  /* Didn't find any sort of match for this data.  
	     Get the pointer value and return the received type */
	  *ptr = (void *) _p;
	  return _c;
	} else {
	  /* Found a match on the first try.  Return pointer value */
	  *ptr = (void *) _p;
	  return (char *) 0;
	}
      } else {
	/* No type specified.  Good luck */
	*ptr = (void *) _p;
	return (char *) 0;
      }
  } else {
    if (strcmp (_c, "NULL") == 0) {
	*ptr = (void *) 0;
	return (char *) 0;
    }
    *ptr = (void *) 0;	
    return _c;
  }
}

/* Compatibility mode */

#define _swig_get_hex  SWIG_GetPtr

#define SWIG_init    initapbslibc

#define SWIG_name    "apbslibc"

#define APBS_SWIG 1
#include "maloc/maloc.h"
#include "apbscfg.h" 
#include "routines.h"
extern Vcom *Vcom_ctor(int );
extern void Vcom_dtor(Vcom **);
extern int Vcom_size(Vcom *);
extern int Vcom_rank(Vcom *);
extern Vmem *Vmem_ctor(char *);
extern void Vmem_dtor(Vmem **);
extern NOsh_calc *NOsh_getCalc(NOsh *,int );
extern char *NOsh_elecname(NOsh *,int );
extern int NOsh_elec2calc(NOsh *,int );
extern int NOsh_printWhat(NOsh *,int );
extern int NOsh_ctor2(NOsh *,int ,int );
extern void NOsh_dtor(NOsh **);
extern int NOsh_parseFile(NOsh *,char *);


#include <ctype.h>

/*------------------------------------------------------------------
  ptrcast(value,type)

  Constructs a new pointer value.   Value may either be a string
  or an integer. Type is a string corresponding to either the
  C datatype or mangled datatype.

  ptrcast(0,"Vector *")
               or
  ptrcast(0,"Vector_p")   
  ------------------------------------------------------------------ */

static PyObject *ptrcast(PyObject *_PTRVALUE, char *type) {

  char *r,*s;
  void *ptr;
  PyObject *obj;
  char *typestr,*c;

  /* Produce a "mangled" version of the type string.  */

  typestr = (char *) malloc(strlen(type)+2);
  
  /* Go through and munge the typestring */
  
  r = typestr;
  *(r++) = '_';
  c = type;
  while (*c) {
    if (!isspace(*c)) {
      if ((*c == '*') || (*c == '&')) {
	*(r++) = 'p';
      }
      else *(r++) = *c;
    } else {
        *(r++) = '_';
    }
    c++;
  }
  *(r++) = 0;

  /* Check to see what kind of object _PTRVALUE is */
  
  if (PyInt_Check(_PTRVALUE)) {
    ptr = (void *) PyInt_AsLong(_PTRVALUE);
    /* Received a numerical value. Make a pointer out of it */
    r = (char *) malloc(strlen(typestr)+22);
    if (ptr) {
      SWIG_MakePtr(r, ptr, typestr);
    } else {
      sprintf(r,"_0%s",typestr);
    }
    obj = PyString_FromString(r);
    free(r);
  } else if (PyString_Check(_PTRVALUE)) {
    /* Have a real pointer value now.  Try to strip out the pointer
       value */
    s = PyString_AsString(_PTRVALUE);
    r = (char *) malloc(strlen(type)+22);
    
    /* Now extract the pointer value */
    if (!SWIG_GetPtr(s,&ptr,0)) {
      if (ptr) {
	SWIG_MakePtr(r,ptr,typestr);
      } else {
	sprintf(r,"_0%s",typestr);
      }
      obj = PyString_FromString(r);
    } else {
      obj = NULL;
    }
    free(r);
  } else {
    obj = NULL;
  }
  free(typestr);
  if (!obj) 
    PyErr_SetString(PyExc_TypeError,"Type error in ptrcast. Argument is not a valid pointer value.");
  return obj;
}

/*------------------------------------------------------------------
  ptrvalue(ptr,type = 0)

  Attempts to dereference a pointer value.  If type is given, it 
  will try to use that type.  Otherwise, this function will attempt
  to "guess" the proper datatype by checking against all of the 
  builtin C datatypes. 
  ------------------------------------------------------------------ */

static PyObject *ptrvalue(PyObject *_PTRVALUE, int index, char *type) {
  void     *ptr;
  char     *s;
  PyObject *obj;

  if (!PyString_Check(_PTRVALUE)) {
    PyErr_SetString(PyExc_TypeError,"Type error in ptrvalue. Argument is not a valid pointer value.");
    return NULL;
  }
  s = PyString_AsString(_PTRVALUE);
  if (SWIG_GetPtr(s,&ptr,0)) {
    PyErr_SetString(PyExc_TypeError,"Type error in ptrvalue. Argument is not a valid pointer value.");
    return NULL;
  }

  /* If no datatype was passed, try a few common datatypes first */

  if (!type) {

    /* No datatype was passed.   Type to figure out if it's a common one */

    if (!SWIG_GetPtr(s,&ptr,"_int_p")) {
      type = "int";
    } else if (!SWIG_GetPtr(s,&ptr,"_double_p")) {
      type = "double";
    } else if (!SWIG_GetPtr(s,&ptr,"_short_p")) {
      type = "short";
    } else if (!SWIG_GetPtr(s,&ptr,"_long_p")) {
      type = "long";
    } else if (!SWIG_GetPtr(s,&ptr,"_float_p")) {
      type = "float";
    } else if (!SWIG_GetPtr(s,&ptr,"_char_p")) {
      type = "char";
    } else if (!SWIG_GetPtr(s,&ptr,"_char_pp")) {
      type = "char *";
    } else {
      type = "unknown";
    }
  }

  if (!ptr) {
    PyErr_SetString(PyExc_TypeError,"Unable to dereference NULL pointer.");
    return NULL;
  }

  /* Now we have a datatype.  Try to figure out what to do about it */
  if (strcmp(type,"int") == 0) {
    obj = PyInt_FromLong((long) *(((int *) ptr) + index));
  } else if (strcmp(type,"double") == 0) {
    obj = PyFloat_FromDouble((double) *(((double *) ptr)+index));
  } else if (strcmp(type,"short") == 0) {
    obj = PyInt_FromLong((long) *(((short *) ptr)+index));
  } else if (strcmp(type,"long") == 0) {
    obj = PyInt_FromLong((long) *(((long *) ptr)+index));
  } else if (strcmp(type,"float") == 0) {
    obj = PyFloat_FromDouble((double) *(((float *) ptr)+index));
  } else if (strcmp(type,"char") == 0) {
    obj = PyString_FromString(((char *) ptr)+index);
  } else if (strcmp(type,"char *") == 0) {
    char *c = *(((char **) ptr)+index);
    if (c) obj = PyString_FromString(c);
    else obj = PyString_FromString("NULL");
  } else {
    PyErr_SetString(PyExc_TypeError,"Unable to dereference unsupported datatype.");
    return NULL;
  }
  return obj;
}

/*------------------------------------------------------------------
  ptrcreate(type,value = 0,numelements = 1)

  Attempts to create a new object of given type.  Type must be
  a basic C datatype.  Will not create complex objects.
  ------------------------------------------------------------------ */

static PyObject *ptrcreate(char *type, PyObject *_PYVALUE, int numelements) {
  void     *ptr;
  PyObject *obj;
  int       sz;
  char     *cast;
  char      temp[40];

  /* Check the type string against a variety of possibilities */

  if (strcmp(type,"int") == 0) {
    sz = sizeof(int)*numelements;
    cast = "_int_p";
  } else if (strcmp(type,"short") == 0) {
    sz = sizeof(short)*numelements;
    cast = "_short_p";
  } else if (strcmp(type,"long") == 0) {
    sz = sizeof(long)*numelements;
    cast = "_long_p";
  } else if (strcmp(type,"double") == 0) {
    sz = sizeof(double)*numelements;
    cast = "_double_p";
  } else if (strcmp(type,"float") == 0) {
    sz = sizeof(float)*numelements;
    cast = "_float_p";
  } else if (strcmp(type,"char") == 0) {
    sz = sizeof(char)*numelements;
    cast = "_char_p";
  } else if (strcmp(type,"char *") == 0) {
    sz = sizeof(char *)*(numelements+1);
    cast = "_char_pp";
  } else {
    PyErr_SetString(PyExc_TypeError,"Unable to create unknown datatype."); 
    return NULL;
  }
   
  /* Create the new object */
  
  ptr = (void *) malloc(sz);
  if (!ptr) {
    PyErr_SetString(PyExc_MemoryError,"Out of memory in swig_create."); 
    return NULL;
  }

  /* Now try to set its default value */

  if (_PYVALUE) {
    if (strcmp(type,"int") == 0) {
      int *ip,i,ivalue;
      ivalue = (int) PyInt_AsLong(_PYVALUE);
      ip = (int *) ptr;
      for (i = 0; i < numelements; i++)
	ip[i] = ivalue;
    } else if (strcmp(type,"short") == 0) {
      short *ip,ivalue;
      int i;
      ivalue = (short) PyInt_AsLong(_PYVALUE);
      ip = (short *) ptr;
      for (i = 0; i < numelements; i++)
	ip[i] = ivalue;
    } else if (strcmp(type,"long") == 0) {
      long *ip,ivalue;
      int i;
      ivalue = (long) PyInt_AsLong(_PYVALUE);
      ip = (long *) ptr;
      for (i = 0; i < numelements; i++)
	ip[i] = ivalue;
    } else if (strcmp(type,"double") == 0) {
      double *ip,ivalue;
      int i;
      ivalue = (double) PyFloat_AsDouble(_PYVALUE);
      ip = (double *) ptr;
      for (i = 0; i < numelements; i++)
	ip[i] = ivalue;
    } else if (strcmp(type,"float") == 0) {
      float *ip,ivalue;
      int i;
      ivalue = (float) PyFloat_AsDouble(_PYVALUE);
      ip = (float *) ptr;
      for (i = 0; i < numelements; i++)
	ip[i] = ivalue;
    } else if (strcmp(type,"char") == 0) {
      char *ip,*ivalue;
      ivalue = (char *) PyString_AsString(_PYVALUE);
      ip = (char *) ptr;
      strncpy(ip,ivalue,numelements-1);
    } else if (strcmp(type,"char *") == 0) {
      char **ip, *ivalue;
      int  i;
      ivalue = (char *) PyString_AsString(_PYVALUE);
      ip = (char **) ptr;
      for (i = 0; i < numelements; i++) {
	if (ivalue) {
	  ip[i] = (char *) malloc(strlen(ivalue)+1);
	  strcpy(ip[i],ivalue);
	} else {
	  ip[i] = 0;
	}
      }
      ip[numelements] = 0;
    }
  } 
  /* Create the pointer value */
  
  SWIG_MakePtr(temp,ptr,cast);
  obj = PyString_FromString(temp);
  return obj;
}


/*------------------------------------------------------------------
  ptrset(ptr,value,index = 0,type = 0)

  Attempts to set the value of a pointer variable.  If type is
  given, we will use that type.  Otherwise, we'll guess the datatype.
  ------------------------------------------------------------------ */

static PyObject *ptrset(PyObject *_PTRVALUE, PyObject *_PYVALUE, int index, char *type) {
  void     *ptr;
  char     *s;
  PyObject *obj;

  if (!PyString_Check(_PTRVALUE)) {
    PyErr_SetString(PyExc_TypeError,"Type error in ptrset. Argument is not a valid pointer value.");
    return NULL;
  }
  s = PyString_AsString(_PTRVALUE);
  if (SWIG_GetPtr(s,&ptr,0)) {
    PyErr_SetString(PyExc_TypeError,"Type error in ptrset. Argument is not a valid pointer value.");
    return NULL;
  }

  /* If no datatype was passed, try a few common datatypes first */

  if (!type) {

    /* No datatype was passed.   Type to figure out if it's a common one */

    if (!SWIG_GetPtr(s,&ptr,"_int_p")) {
      type = "int";
    } else if (!SWIG_GetPtr(s,&ptr,"_double_p")) {
      type = "double";
    } else if (!SWIG_GetPtr(s,&ptr,"_short_p")) {
      type = "short";
    } else if (!SWIG_GetPtr(s,&ptr,"_long_p")) {
      type = "long";
    } else if (!SWIG_GetPtr(s,&ptr,"_float_p")) {
      type = "float";
    } else if (!SWIG_GetPtr(s,&ptr,"_char_p")) {
      type = "char";
    } else if (!SWIG_GetPtr(s,&ptr,"_char_pp")) {
      type = "char *";
    } else {
      type = "unknown";
    }
  }

  if (!ptr) {
    PyErr_SetString(PyExc_TypeError,"Unable to set NULL pointer.");
    return NULL;
  }
  
  /* Now we have a datatype.  Try to figure out what to do about it */
  if (strcmp(type,"int") == 0) {
    *(((int *) ptr)+index) = (int) PyInt_AsLong(_PYVALUE);
  } else if (strcmp(type,"double") == 0) {
    *(((double *) ptr)+index) = (double) PyFloat_AsDouble(_PYVALUE);
  } else if (strcmp(type,"short") == 0) {
    *(((short *) ptr)+index) = (short) PyInt_AsLong(_PYVALUE);
  } else if (strcmp(type,"long") == 0) {
    *(((long *) ptr)+index) = (long) PyInt_AsLong(_PYVALUE);
  } else if (strcmp(type,"float") == 0) {
    *(((float *) ptr)+index) = (float) PyFloat_AsDouble(_PYVALUE);
  } else if (strcmp(type,"char") == 0) {
    char *c = PyString_AsString(_PYVALUE);
    strcpy(((char *) ptr)+index, c);
  } else if (strcmp(type,"char *") == 0) {
    char *c = PyString_AsString(_PYVALUE);
    char **ca = (char **) ptr;
    if (ca[index]) free(ca[index]);
    if (strcmp(c,"NULL") == 0) {
      ca[index] = 0;
    } else {
      ca[index] = (char *) malloc(strlen(c)+1);
      strcpy(ca[index],c);
    }
  } else {
    PyErr_SetString(PyExc_TypeError,"Unable to set unsupported datatype.");
    return NULL;
  }
  Py_INCREF(Py_None);
  return Py_None;
}


/*------------------------------------------------------------------
  ptradd(ptr,offset)

  Adds a value to an existing pointer value.  Will do a type-dependent
  add for basic datatypes.  For other datatypes, will do a byte-add.
  ------------------------------------------------------------------ */

static PyObject *ptradd(PyObject *_PTRVALUE, int offset) {

  char *r,*s;
  void *ptr,*junk;
  PyObject *obj;
  char *type;

  /* Check to see what kind of object _PTRVALUE is */
  
  if (PyString_Check(_PTRVALUE)) {
    /* Have a potential pointer value now.  Try to strip out the value */
    s = PyString_AsString(_PTRVALUE);

    /* Try to handle a few common datatypes first */

    if (!SWIG_GetPtr(s,&ptr,"_int_p")) {
      ptr = (void *) (((int *) ptr) + offset);
    } else if (!SWIG_GetPtr(s,&ptr,"_double_p")) {
      ptr = (void *) (((double *) ptr) + offset);
    } else if (!SWIG_GetPtr(s,&ptr,"_short_p")) {
      ptr = (void *) (((short *) ptr) + offset);
    } else if (!SWIG_GetPtr(s,&ptr,"_long_p")) {
      ptr = (void *) (((long *) ptr) + offset);
    } else if (!SWIG_GetPtr(s,&ptr,"_float_p")) {
      ptr = (void *) (((float *) ptr) + offset);
    } else if (!SWIG_GetPtr(s,&ptr,"_char_p")) {
      ptr = (void *) (((char *) ptr) + offset);
    } else if (!SWIG_GetPtr(s,&ptr,0)) {
      ptr = (void *) (((char *) ptr) + offset);
    } else {
      PyErr_SetString(PyExc_TypeError,"Type error in ptradd. Argument is not a valid pointer value.");
      return NULL;
    }
    type = SWIG_GetPtr(s,&junk,"INVALID POINTER");
    r = (char *) malloc(strlen(type)+20);
    if (ptr) {
      SWIG_MakePtr(r,ptr,type);
    } else {
      sprintf(r,"_0%s",type);
    }
    obj = PyString_FromString(r);
    free(r);
  }
  return obj;
}

/*------------------------------------------------------------------
  ptrmap(type1,type2)

  Allows a mapping between type1 and type2. (Like a typedef)
  ------------------------------------------------------------------ */

static void ptrmap(char *type1, char *type2) {

  char *typestr1,*typestr2,*c,*r;

  /* Produce a "mangled" version of the type string.  */

  typestr1 = (char *) malloc(strlen(type1)+2);
  
  /* Go through and munge the typestring */
  
  r = typestr1;
  *(r++) = '_';
  c = type1;
  while (*c) {
    if (!isspace(*c)) {
      if ((*c == '*') || (*c == '&')) {
	*(r++) = 'p';
      }
      else *(r++) = *c;
    } else {
      *(r++) = '_';
    }
    c++;
  }
  *(r++) = 0;
  
  typestr2 = (char *) malloc(strlen(type2)+2);

  /* Go through and munge the typestring */
  
  r = typestr2;
  *(r++) = '_';
  c = type2;
  while (*c) {
    if (!isspace(*c)) {
      if ((*c == '*') || (*c == '&')) {
	*(r++) = 'p';
      }
      else *(r++) = *c;
    } else {
      *(r++) = '_';
    }
    c++;
  }
  *(r++) = 0;
  SWIG_RegisterMapping(typestr1,typestr2,0);
  SWIG_RegisterMapping(typestr2,typestr1,0);
}

/*------------------------------------------------------------------
  ptrfree(ptr)

  Destroys a pointer value
  ------------------------------------------------------------------ */

PyObject *ptrfree(PyObject *_PTRVALUE) {
  void *ptr, *junk;
  char *s;

  if (!PyString_Check(_PTRVALUE)) {
    PyErr_SetString(PyExc_TypeError,"Type error in ptrfree. Argument is not a valid pointer value.");
    return NULL;
  }
  s = PyString_AsString(_PTRVALUE);
  if (SWIG_GetPtr(s,&ptr,0)) {
    PyErr_SetString(PyExc_TypeError,"Type error in ptrfree. Argument is not a valid pointer value.");
    return NULL;
  }

  /* Check to see if this pointer is a char ** */
  if (!SWIG_GetPtr(s,&junk,"_char_pp")) {
    char **c = (char **) ptr;
    if (c) {
      int i = 0;
      while (c[i]) {
	free(c[i]);
	i++;
      }
    }
  } 
  if (ptr)
    free((char *) ptr);

  Py_INCREF(Py_None);
  return Py_None;
}


Valist **new_valist(int maxargs) {
   return (Valist **) malloc(maxargs*sizeof(Valist *));
}

Vgrid **new_gridlist(int maxargs) {
   return (Vgrid **) malloc(maxargs*sizeof(Vgrid *));
}

Vpmg **new_pmglist(int maxargs) {
   return (Vpmg **) malloc(maxargs*sizeof(Vpmg *));
}

Vpmg *get_Vpmg(Vpmg **args, int n) {
   return (Vpmg *)args[n];
}

Vpmgp **new_pmgplist(int maxargs) {
   return (Vpmgp **) malloc(maxargs*sizeof(Vpmgp *));
}

Vpbe **new_pbelist(int maxargs) {
   return (Vpbe **) malloc(maxargs*sizeof(Vpbe *));
}

AtomForce **new_atomforcelist(int maxargs) {
   return (AtomForce **) malloc(maxargs*sizeof(AtomForce *));
}

double *double_array(int size) {
     return (double *) malloc(size*sizeof(double));
  }

int *int_array(int size){
     return (int *) malloc(size*sizeof(int));
}
extern int loadMolecules(NOsh *,Valist *[NOSH_MAXMOL]);
extern void killMolecules(NOsh *,Valist *[NOSH_MAXMOL]);
extern int loadDielMaps(NOsh *,Vgrid *[NOSH_MAXMOL],Vgrid *[NOSH_MAXMOL],Vgrid *[NOSH_MAXMOL]);
extern void killDielMaps(NOsh *,Vgrid *[NOSH_MAXMOL],Vgrid *[NOSH_MAXMOL],Vgrid *[NOSH_MAXMOL]);
extern int loadKappaMaps(NOsh *,Vgrid *[NOSH_MAXMOL]);
extern void killKappaMaps(NOsh *,Vgrid *[NOSH_MAXMOL]);
extern int loadChargeMaps(NOsh *,Vgrid *[NOSH_MAXMOL]);
extern void killChargeMaps(NOsh *,Vgrid *[NOSH_MAXMOL]);
extern void printPBEPARM(PBEparm *);
extern void printMGPARM(MGparm *,double [3]);
extern int initMG(int ,NOsh *,MGparm *,PBEparm *,double [3],Vpbe *[NOSH_MAXCALC],Valist *[NOSH_MAXMOL],Vgrid *[NOSH_MAXMOL],Vgrid *[NOSH_MAXMOL],Vgrid *[NOSH_MAXMOL],Vgrid *[NOSH_MAXMOL],Vgrid *[NOSH_MAXMOL],Vpmgp *[NOSH_MAXCALC],Vpmg *[NOSH_MAXCALC]);
extern void killMG(NOsh *,Vpbe *[NOSH_MAXCALC],Vpmgp *[NOSH_MAXCALC],Vpmg *[NOSH_MAXCALC]);
extern int solveMG(NOsh *,Vpmg *,MGparm_CalcType );
extern int setPartMG(NOsh *,MGparm *,Vpmg *);
extern int energyMG(NOsh *,int ,Vpmg *,int *,double *,double *,double *,double *);
extern int npenergyMG(NOsh *,int ,Vpmg *,int *,double *);
extern void killEnergy();
extern int forceMG(Vmem *,NOsh *,PBEparm *,MGparm *,Vpmg *,int *,AtomForce **,Valist *[NOSH_MAXMOL]);
extern void killForce(Vmem *,NOsh *,int [NOSH_MAXCALC],AtomForce *[NOSH_MAXCALC]);
extern int writedataMG(int ,NOsh *,PBEparm *,Vpmg *);
extern int writematMG(int ,NOsh *,PBEparm *,Vpmg *);
extern int printEnergy(Vcom *,NOsh *,double [NOSH_MAXCALC],int );
extern int printForce(Vcom *,NOsh *,int [NOSH_MAXCALC],AtomForce *[NOSH_MAXCALC],int );
extern void startVio();
static PyObject *_wrap_Vcom_ctor(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    Vcom * _result;
    int  _arg0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"i:Vcom_ctor",&_arg0)) 
        return NULL;
    _result = (Vcom *)Vcom_ctor(_arg0);
    SWIG_MakePtr(_ptemp, (char *) _result,"_Vcom_p");
    _resultobj = Py_BuildValue("s",_ptemp);
    return _resultobj;
}

static PyObject *_wrap_Vcom_dtor(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    Vcom ** _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:Vcom_dtor",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_Vcom_pp")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of Vcom_dtor. Expected _Vcom_pp.");
        return NULL;
        }
    }
    Vcom_dtor(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_Vcom_size(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    Vcom * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:Vcom_size",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_Vcom_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of Vcom_size. Expected _Vcom_p.");
        return NULL;
        }
    }
    _result = (int )Vcom_size(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_Vcom_rank(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    Vcom * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:Vcom_rank",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_Vcom_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of Vcom_rank. Expected _Vcom_p.");
        return NULL;
        }
    }
    _result = (int )Vcom_rank(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_Vmem_ctor(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    Vmem * _result;
    char * _arg0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"s:Vmem_ctor",&_arg0)) 
        return NULL;
    _result = (Vmem *)Vmem_ctor(_arg0);
    SWIG_MakePtr(_ptemp, (char *) _result,"_Vmem_p");
    _resultobj = Py_BuildValue("s",_ptemp);
    return _resultobj;
}

static PyObject *_wrap_Vmem_dtor(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    Vmem ** _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:Vmem_dtor",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_Vmem_pp")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of Vmem_dtor. Expected _Vmem_pp.");
        return NULL;
        }
    }
    Vmem_dtor(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_NOsh_getCalc(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    NOsh_calc * _result;
    NOsh * _arg0;
    int  _arg1;
    char * _argc0 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"si:NOsh_getCalc",&_argc0,&_arg1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_NOsh_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of NOsh_getCalc. Expected _NOsh_p.");
        return NULL;
        }
    }
    _result = (NOsh_calc *)NOsh_getCalc(_arg0,_arg1);
    SWIG_MakePtr(_ptemp, (char *) _result,"_NOsh_calc_p");
    _resultobj = Py_BuildValue("s",_ptemp);
    return _resultobj;
}

static PyObject *_wrap_NOsh_elecname(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    NOsh * _arg0;
    int  _arg1;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"si:NOsh_elecname",&_argc0,&_arg1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_NOsh_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of NOsh_elecname. Expected _NOsh_p.");
        return NULL;
        }
    }
    _result = (char *)NOsh_elecname(_arg0,_arg1);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_NOsh_elec2calc(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    NOsh * _arg0;
    int  _arg1;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"si:NOsh_elec2calc",&_argc0,&_arg1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_NOsh_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of NOsh_elec2calc. Expected _NOsh_p.");
        return NULL;
        }
    }
    _result = (int )NOsh_elec2calc(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_NOsh_printWhat(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    NOsh * _arg0;
    int  _arg1;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"si:NOsh_printWhat",&_argc0,&_arg1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_NOsh_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of NOsh_printWhat. Expected _NOsh_p.");
        return NULL;
        }
    }
    _result = (int )NOsh_printWhat(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_NOsh_ctor2(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    NOsh * _arg0;
    int  _arg1;
    int  _arg2;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"sii:NOsh_ctor2",&_argc0,&_arg1,&_arg2)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_NOsh_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of NOsh_ctor2. Expected _NOsh_p.");
        return NULL;
        }
    }
    _result = (int )NOsh_ctor2(_arg0,_arg1,_arg2);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_NOsh_dtor(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    NOsh ** _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:NOsh_dtor",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_NOsh_pp")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of NOsh_dtor. Expected _NOsh_pp.");
        return NULL;
        }
    }
    NOsh_dtor(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_NOsh_parseFile(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    NOsh * _arg0;
    char * _arg1;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"ss:NOsh_parseFile",&_argc0,&_arg1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_NOsh_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of NOsh_parseFile. Expected _NOsh_p.");
        return NULL;
        }
    }
    _result = (int )NOsh_parseFile(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_ptrcast(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    PyObject * _result;
    PyObject * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:ptrcast",&_obj0,&_arg1)) 
        return NULL;
{
  _arg0 = _obj0;
}
    _result = (PyObject *)ptrcast(_arg0,_arg1);
{
  _resultobj = _result;
}
    return _resultobj;
}

static PyObject *_wrap_ptrvalue(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    PyObject * _result;
    PyObject * _arg0;
    int  _arg1 = 0;
    char * _arg2 = 0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O|is:ptrvalue",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
  _arg0 = _obj0;
}
    _result = (PyObject *)ptrvalue(_arg0,_arg1,_arg2);
{
  _resultobj = _result;
}
    return _resultobj;
}

static PyObject *_wrap_ptrset(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    PyObject * _result;
    PyObject * _arg0;
    PyObject * _arg1;
    int  _arg2 = 0;
    char * _arg3 = 0;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO|is:ptrset",&_obj0,&_obj1,&_arg2,&_arg3)) 
        return NULL;
{
  _arg0 = _obj0;
}
{
  _arg1 = _obj1;
}
    _result = (PyObject *)ptrset(_arg0,_arg1,_arg2,_arg3);
{
  _resultobj = _result;
}
    return _resultobj;
}

static PyObject *_wrap_ptrcreate(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    PyObject * _result;
    char * _arg0;
    PyObject * _arg1 = 0;
    int  _arg2 = 1;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s|Oi:ptrcreate",&_arg0,&_obj1,&_arg2)) 
        return NULL;
    if (_obj1)
{
  _arg1 = _obj1;
}
    _result = (PyObject *)ptrcreate(_arg0,_arg1,_arg2);
{
  _resultobj = _result;
}
    return _resultobj;
}

static PyObject *_wrap_ptrfree(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    PyObject * _result;
    PyObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:ptrfree",&_obj0)) 
        return NULL;
{
  _arg0 = _obj0;
}
    _result = (PyObject *)ptrfree(_arg0);
{
  _resultobj = _result;
}
    return _resultobj;
}

static PyObject *_wrap_ptradd(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    PyObject * _result;
    PyObject * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:ptradd",&_obj0,&_arg1)) 
        return NULL;
{
  _arg0 = _obj0;
}
    _result = (PyObject *)ptradd(_arg0,_arg1);
{
  _resultobj = _result;
}
    return _resultobj;
}

static PyObject *_wrap_ptrmap(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _arg0;
    char * _arg1;

    self = self;
    if(!PyArg_ParseTuple(args,"ss:ptrmap",&_arg0,&_arg1)) 
        return NULL;
    ptrmap(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_new_valist(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    Valist ** _result;
    int  _arg0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"i:new_valist",&_arg0)) 
        return NULL;
    _result = (Valist **)new_valist(_arg0);
    SWIG_MakePtr(_ptemp, (char *) _result,"_Valist_pp");
    _resultobj = Py_BuildValue("s",_ptemp);
    return _resultobj;
}

static PyObject *_wrap_new_gridlist(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    Vgrid ** _result;
    int  _arg0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"i:new_gridlist",&_arg0)) 
        return NULL;
    _result = (Vgrid **)new_gridlist(_arg0);
    SWIG_MakePtr(_ptemp, (char *) _result,"_Vgrid_pp");
    _resultobj = Py_BuildValue("s",_ptemp);
    return _resultobj;
}

static PyObject *_wrap_new_pmglist(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    Vpmg ** _result;
    int  _arg0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"i:new_pmglist",&_arg0)) 
        return NULL;
    _result = (Vpmg **)new_pmglist(_arg0);
    SWIG_MakePtr(_ptemp, (char *) _result,"_Vpmg_pp");
    _resultobj = Py_BuildValue("s",_ptemp);
    return _resultobj;
}

static PyObject *_wrap_get_Vpmg(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    Vpmg * _result;
    Vpmg ** _arg0;
    int  _arg1;
    char * _argc0 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"si:get_Vpmg",&_argc0,&_arg1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_Vpmg_pp")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of get_Vpmg. Expected _Vpmg_pp.");
        return NULL;
        }
    }
    _result = (Vpmg *)get_Vpmg(_arg0,_arg1);
    SWIG_MakePtr(_ptemp, (char *) _result,"_Vpmg_p");
    _resultobj = Py_BuildValue("s",_ptemp);
    return _resultobj;
}

static PyObject *_wrap_new_pmgplist(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    Vpmgp ** _result;
    int  _arg0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"i:new_pmgplist",&_arg0)) 
        return NULL;
    _result = (Vpmgp **)new_pmgplist(_arg0);
    SWIG_MakePtr(_ptemp, (char *) _result,"_Vpmgp_pp");
    _resultobj = Py_BuildValue("s",_ptemp);
    return _resultobj;
}

static PyObject *_wrap_new_pbelist(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    Vpbe ** _result;
    int  _arg0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"i:new_pbelist",&_arg0)) 
        return NULL;
    _result = (Vpbe **)new_pbelist(_arg0);
    SWIG_MakePtr(_ptemp, (char *) _result,"_Vpbe_pp");
    _resultobj = Py_BuildValue("s",_ptemp);
    return _resultobj;
}

static PyObject *_wrap_new_atomforcelist(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    AtomForce ** _result;
    int  _arg0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"i:new_atomforcelist",&_arg0)) 
        return NULL;
    _result = (AtomForce **)new_atomforcelist(_arg0);
    SWIG_MakePtr(_ptemp, (char *) _result,"_AtomForce_pp");
    _resultobj = Py_BuildValue("s",_ptemp);
    return _resultobj;
}

static PyObject *_wrap_double_array(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double * _result;
    int  _arg0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"i:double_array",&_arg0)) 
        return NULL;
    _result = (double *)double_array(_arg0);
    SWIG_MakePtr(_ptemp, (char *) _result,"_double_p");
    _resultobj = Py_BuildValue("s",_ptemp);
    return _resultobj;
}

static PyObject *_wrap_int_array(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int * _result;
    int  _arg0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"i:int_array",&_arg0)) 
        return NULL;
    _result = (int *)int_array(_arg0);
    SWIG_MakePtr(_ptemp, (char *) _result,"_int_p");
    _resultobj = Py_BuildValue("s",_ptemp);
    return _resultobj;
}

static PyObject *_wrap_loadMolecules(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    NOsh * _arg0;
    Valist ** _arg1;
    char * _argc0 = 0;
    char * _argc1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"ss:loadMolecules",&_argc0,&_argc1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_NOsh_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of loadMolecules. Expected _NOsh_p.");
        return NULL;
        }
    }
    if (_argc1) {
        if (SWIG_GetPtr(_argc1,(void **) &_arg1,"_Valist_pp")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of loadMolecules. Expected _Valist_pp.");
        return NULL;
        }
    }
    _result = (int )loadMolecules(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_killMolecules(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    NOsh * _arg0;
    Valist ** _arg1;
    char * _argc0 = 0;
    char * _argc1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"ss:killMolecules",&_argc0,&_argc1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_NOsh_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of killMolecules. Expected _NOsh_p.");
        return NULL;
        }
    }
    if (_argc1) {
        if (SWIG_GetPtr(_argc1,(void **) &_arg1,"_Valist_pp")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of killMolecules. Expected _Valist_pp.");
        return NULL;
        }
    }
    killMolecules(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_loadDielMaps(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    NOsh * _arg0;
    Vgrid ** _arg1;
    Vgrid ** _arg2;
    Vgrid ** _arg3;
    char * _argc0 = 0;
    char * _argc1 = 0;
    char * _argc2 = 0;
    char * _argc3 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"ssss:loadDielMaps",&_argc0,&_argc1,&_argc2,&_argc3)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_NOsh_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of loadDielMaps. Expected _NOsh_p.");
        return NULL;
        }
    }
    if (_argc1) {
        if (SWIG_GetPtr(_argc1,(void **) &_arg1,"_Vgrid_pp")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of loadDielMaps. Expected _Vgrid_pp.");
        return NULL;
        }
    }
    if (_argc2) {
        if (SWIG_GetPtr(_argc2,(void **) &_arg2,"_Vgrid_pp")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 3 of loadDielMaps. Expected _Vgrid_pp.");
        return NULL;
        }
    }
    if (_argc3) {
        if (SWIG_GetPtr(_argc3,(void **) &_arg3,"_Vgrid_pp")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 4 of loadDielMaps. Expected _Vgrid_pp.");
        return NULL;
        }
    }
    _result = (int )loadDielMaps(_arg0,_arg1,_arg2,_arg3);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_killDielMaps(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    NOsh * _arg0;
    Vgrid ** _arg1;
    Vgrid ** _arg2;
    Vgrid ** _arg3;
    char * _argc0 = 0;
    char * _argc1 = 0;
    char * _argc2 = 0;
    char * _argc3 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"ssss:killDielMaps",&_argc0,&_argc1,&_argc2,&_argc3)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_NOsh_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of killDielMaps. Expected _NOsh_p.");
        return NULL;
        }
    }
    if (_argc1) {
        if (SWIG_GetPtr(_argc1,(void **) &_arg1,"_Vgrid_pp")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of killDielMaps. Expected _Vgrid_pp.");
        return NULL;
        }
    }
    if (_argc2) {
        if (SWIG_GetPtr(_argc2,(void **) &_arg2,"_Vgrid_pp")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 3 of killDielMaps. Expected _Vgrid_pp.");
        return NULL;
        }
    }
    if (_argc3) {
        if (SWIG_GetPtr(_argc3,(void **) &_arg3,"_Vgrid_pp")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 4 of killDielMaps. Expected _Vgrid_pp.");
        return NULL;
        }
    }
    killDielMaps(_arg0,_arg1,_arg2,_arg3);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_loadKappaMaps(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    NOsh * _arg0;
    Vgrid ** _arg1;
    char * _argc0 = 0;
    char * _argc1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"ss:loadKappaMaps",&_argc0,&_argc1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_NOsh_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of loadKappaMaps. Expected _NOsh_p.");
        return NULL;
        }
    }
    if (_argc1) {
        if (SWIG_GetPtr(_argc1,(void **) &_arg1,"_Vgrid_pp")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of loadKappaMaps. Expected _Vgrid_pp.");
        return NULL;
        }
    }
    _result = (int )loadKappaMaps(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_killKappaMaps(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    NOsh * _arg0;
    Vgrid ** _arg1;
    char * _argc0 = 0;
    char * _argc1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"ss:killKappaMaps",&_argc0,&_argc1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_NOsh_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of killKappaMaps. Expected _NOsh_p.");
        return NULL;
        }
    }
    if (_argc1) {
        if (SWIG_GetPtr(_argc1,(void **) &_arg1,"_Vgrid_pp")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of killKappaMaps. Expected _Vgrid_pp.");
        return NULL;
        }
    }
    killKappaMaps(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_loadChargeMaps(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    NOsh * _arg0;
    Vgrid ** _arg1;
    char * _argc0 = 0;
    char * _argc1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"ss:loadChargeMaps",&_argc0,&_argc1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_NOsh_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of loadChargeMaps. Expected _NOsh_p.");
        return NULL;
        }
    }
    if (_argc1) {
        if (SWIG_GetPtr(_argc1,(void **) &_arg1,"_Vgrid_pp")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of loadChargeMaps. Expected _Vgrid_pp.");
        return NULL;
        }
    }
    _result = (int )loadChargeMaps(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_killChargeMaps(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    NOsh * _arg0;
    Vgrid ** _arg1;
    char * _argc0 = 0;
    char * _argc1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"ss:killChargeMaps",&_argc0,&_argc1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_NOsh_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of killChargeMaps. Expected _NOsh_p.");
        return NULL;
        }
    }
    if (_argc1) {
        if (SWIG_GetPtr(_argc1,(void **) &_arg1,"_Vgrid_pp")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of killChargeMaps. Expected _Vgrid_pp.");
        return NULL;
        }
    }
    killChargeMaps(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_printPBEPARM(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    PBEparm * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:printPBEPARM",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_PBEparm_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of printPBEPARM. Expected _PBEparm_p.");
        return NULL;
        }
    }
    printPBEPARM(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_printMGPARM(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    MGparm * _arg0;
    double * _arg1;
    char * _argc0 = 0;
    char * _argc1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"ss:printMGPARM",&_argc0,&_argc1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_MGparm_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of printMGPARM. Expected _MGparm_p.");
        return NULL;
        }
    }
    if (_argc1) {
        if (SWIG_GetPtr(_argc1,(void **) &_arg1,"_double_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of printMGPARM. Expected _double_p.");
        return NULL;
        }
    }
    printMGPARM(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_initMG(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    int  _arg0;
    NOsh * _arg1;
    MGparm * _arg2;
    PBEparm * _arg3;
    double * _arg4;
    Vpbe ** _arg5;
    Valist ** _arg6;
    Vgrid ** _arg7;
    Vgrid ** _arg8;
    Vgrid ** _arg9;
    Vgrid ** _arg10;
    Vgrid ** _arg11;
    Vpmgp ** _arg12;
    Vpmg ** _arg13;
    char * _argc1 = 0;
    char * _argc2 = 0;
    char * _argc3 = 0;
    char * _argc4 = 0;
    char * _argc5 = 0;
    char * _argc6 = 0;
    char * _argc7 = 0;
    char * _argc8 = 0;
    char * _argc9 = 0;
    char * _argc10 = 0;
    char * _argc11 = 0;
    char * _argc12 = 0;
    char * _argc13 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"isssssssssssss:initMG",&_arg0,&_argc1,&_argc2,&_argc3,&_argc4,&_argc5,&_argc6,&_argc7,&_argc8,&_argc9,&_argc10,&_argc11,&_argc12,&_argc13)) 
        return NULL;
    if (_argc1) {
        if (SWIG_GetPtr(_argc1,(void **) &_arg1,"_NOsh_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of initMG. Expected _NOsh_p.");
        return NULL;
        }
    }
    if (_argc2) {
        if (SWIG_GetPtr(_argc2,(void **) &_arg2,"_MGparm_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 3 of initMG. Expected _MGparm_p.");
        return NULL;
        }
    }
    if (_argc3) {
        if (SWIG_GetPtr(_argc3,(void **) &_arg3,"_PBEparm_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 4 of initMG. Expected _PBEparm_p.");
        return NULL;
        }
    }
    if (_argc4) {
        if (SWIG_GetPtr(_argc4,(void **) &_arg4,"_double_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 5 of initMG. Expected _double_p.");
        return NULL;
        }
    }
    if (_argc5) {
        if (SWIG_GetPtr(_argc5,(void **) &_arg5,"_Vpbe_pp")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 6 of initMG. Expected _Vpbe_pp.");
        return NULL;
        }
    }
    if (_argc6) {
        if (SWIG_GetPtr(_argc6,(void **) &_arg6,"_Valist_pp")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 7 of initMG. Expected _Valist_pp.");
        return NULL;
        }
    }
    if (_argc7) {
        if (SWIG_GetPtr(_argc7,(void **) &_arg7,"_Vgrid_pp")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 8 of initMG. Expected _Vgrid_pp.");
        return NULL;
        }
    }
    if (_argc8) {
        if (SWIG_GetPtr(_argc8,(void **) &_arg8,"_Vgrid_pp")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 9 of initMG. Expected _Vgrid_pp.");
        return NULL;
        }
    }
    if (_argc9) {
        if (SWIG_GetPtr(_argc9,(void **) &_arg9,"_Vgrid_pp")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 10 of initMG. Expected _Vgrid_pp.");
        return NULL;
        }
    }
    if (_argc10) {
        if (SWIG_GetPtr(_argc10,(void **) &_arg10,"_Vgrid_pp")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 11 of initMG. Expected _Vgrid_pp.");
        return NULL;
        }
    }
    if (_argc11) {
        if (SWIG_GetPtr(_argc11,(void **) &_arg11,"_Vgrid_pp")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 12 of initMG. Expected _Vgrid_pp.");
        return NULL;
        }
    }
    if (_argc12) {
        if (SWIG_GetPtr(_argc12,(void **) &_arg12,"_Vpmgp_pp")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 13 of initMG. Expected _Vpmgp_pp.");
        return NULL;
        }
    }
    if (_argc13) {
        if (SWIG_GetPtr(_argc13,(void **) &_arg13,"_Vpmg_pp")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 14 of initMG. Expected _Vpmg_pp.");
        return NULL;
        }
    }
    _result = (int )initMG(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5,_arg6,_arg7,_arg8,_arg9,_arg10,_arg11,_arg12,_arg13);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_killMG(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    NOsh * _arg0;
    Vpbe ** _arg1;
    Vpmgp ** _arg2;
    Vpmg ** _arg3;
    char * _argc0 = 0;
    char * _argc1 = 0;
    char * _argc2 = 0;
    char * _argc3 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"ssss:killMG",&_argc0,&_argc1,&_argc2,&_argc3)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_NOsh_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of killMG. Expected _NOsh_p.");
        return NULL;
        }
    }
    if (_argc1) {
        if (SWIG_GetPtr(_argc1,(void **) &_arg1,"_Vpbe_pp")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of killMG. Expected _Vpbe_pp.");
        return NULL;
        }
    }
    if (_argc2) {
        if (SWIG_GetPtr(_argc2,(void **) &_arg2,"_Vpmgp_pp")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 3 of killMG. Expected _Vpmgp_pp.");
        return NULL;
        }
    }
    if (_argc3) {
        if (SWIG_GetPtr(_argc3,(void **) &_arg3,"_Vpmg_pp")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 4 of killMG. Expected _Vpmg_pp.");
        return NULL;
        }
    }
    killMG(_arg0,_arg1,_arg2,_arg3);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_solveMG(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    NOsh * _arg0;
    Vpmg * _arg1;
    MGparm_CalcType * _arg2;
    char * _argc0 = 0;
    char * _argc1 = 0;
    char * _argc2 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"sss:solveMG",&_argc0,&_argc1,&_argc2)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_NOsh_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of solveMG. Expected _NOsh_p.");
        return NULL;
        }
    }
    if (_argc1) {
        if (SWIG_GetPtr(_argc1,(void **) &_arg1,"_Vpmg_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of solveMG. Expected _Vpmg_p.");
        return NULL;
        }
    }
    if (_argc2) {
        if (SWIG_GetPtr(_argc2,(void **) &_arg2,"_MGparm_CalcType_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 3 of solveMG. Expected _MGparm_CalcType_p.");
        return NULL;
        }
    }
    _result = (int )solveMG(_arg0,_arg1,*_arg2);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_setPartMG(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    NOsh * _arg0;
    MGparm * _arg1;
    Vpmg * _arg2;
    char * _argc0 = 0;
    char * _argc1 = 0;
    char * _argc2 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"sss:setPartMG",&_argc0,&_argc1,&_argc2)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_NOsh_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of setPartMG. Expected _NOsh_p.");
        return NULL;
        }
    }
    if (_argc1) {
        if (SWIG_GetPtr(_argc1,(void **) &_arg1,"_MGparm_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of setPartMG. Expected _MGparm_p.");
        return NULL;
        }
    }
    if (_argc2) {
        if (SWIG_GetPtr(_argc2,(void **) &_arg2,"_Vpmg_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 3 of setPartMG. Expected _Vpmg_p.");
        return NULL;
        }
    }
    _result = (int )setPartMG(_arg0,_arg1,_arg2);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_energyMG(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    NOsh * _arg0;
    int  _arg1;
    Vpmg * _arg2;
    int * _arg3;
    double * _arg4;
    double * _arg5;
    double * _arg6;
    double * _arg7;
    char * _argc0 = 0;
    char * _argc2 = 0;
    char * _argc3 = 0;
    char * _argc4 = 0;
    char * _argc5 = 0;
    char * _argc6 = 0;
    char * _argc7 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"sissssss:energyMG",&_argc0,&_arg1,&_argc2,&_argc3,&_argc4,&_argc5,&_argc6,&_argc7)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_NOsh_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of energyMG. Expected _NOsh_p.");
        return NULL;
        }
    }
    if (_argc2) {
        if (SWIG_GetPtr(_argc2,(void **) &_arg2,"_Vpmg_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 3 of energyMG. Expected _Vpmg_p.");
        return NULL;
        }
    }
    if (_argc3) {
        if (SWIG_GetPtr(_argc3,(void **) &_arg3,"_int_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 4 of energyMG. Expected _int_p.");
        return NULL;
        }
    }
    if (_argc4) {
        if (SWIG_GetPtr(_argc4,(void **) &_arg4,"_double_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 5 of energyMG. Expected _double_p.");
        return NULL;
        }
    }
    if (_argc5) {
        if (SWIG_GetPtr(_argc5,(void **) &_arg5,"_double_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 6 of energyMG. Expected _double_p.");
        return NULL;
        }
    }
    if (_argc6) {
        if (SWIG_GetPtr(_argc6,(void **) &_arg6,"_double_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 7 of energyMG. Expected _double_p.");
        return NULL;
        }
    }
    if (_argc7) {
        if (SWIG_GetPtr(_argc7,(void **) &_arg7,"_double_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 8 of energyMG. Expected _double_p.");
        return NULL;
        }
    }
    _result = (int )energyMG(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5,_arg6,_arg7);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_npenergyMG(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    NOsh * _arg0;
    int  _arg1;
    Vpmg * _arg2;
    int * _arg3;
    double * _arg4;
    char * _argc0 = 0;
    char * _argc2 = 0;
    char * _argc3 = 0;
    char * _argc4 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"sisss:npenergyMG",&_argc0,&_arg1,&_argc2,&_argc3,&_argc4)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_NOsh_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of npenergyMG. Expected _NOsh_p.");
        return NULL;
        }
    }
    if (_argc2) {
        if (SWIG_GetPtr(_argc2,(void **) &_arg2,"_Vpmg_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 3 of npenergyMG. Expected _Vpmg_p.");
        return NULL;
        }
    }
    if (_argc3) {
        if (SWIG_GetPtr(_argc3,(void **) &_arg3,"_int_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 4 of npenergyMG. Expected _int_p.");
        return NULL;
        }
    }
    if (_argc4) {
        if (SWIG_GetPtr(_argc4,(void **) &_arg4,"_double_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 5 of npenergyMG. Expected _double_p.");
        return NULL;
        }
    }
    _result = (int )npenergyMG(_arg0,_arg1,_arg2,_arg3,_arg4);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_killEnergy(PyObject *self, PyObject *args) {
    PyObject * _resultobj;

    self = self;
    if(!PyArg_ParseTuple(args,":killEnergy")) 
        return NULL;
    killEnergy();
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_forceMG(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    Vmem * _arg0;
    NOsh * _arg1;
    PBEparm * _arg2;
    MGparm * _arg3;
    Vpmg * _arg4;
    int * _arg5;
    AtomForce ** _arg6;
    Valist ** _arg7;
    char * _argc0 = 0;
    char * _argc1 = 0;
    char * _argc2 = 0;
    char * _argc3 = 0;
    char * _argc4 = 0;
    char * _argc5 = 0;
    char * _argc6 = 0;
    char * _argc7 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"ssssssss:forceMG",&_argc0,&_argc1,&_argc2,&_argc3,&_argc4,&_argc5,&_argc6,&_argc7)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_Vmem_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of forceMG. Expected _Vmem_p.");
        return NULL;
        }
    }
    if (_argc1) {
        if (SWIG_GetPtr(_argc1,(void **) &_arg1,"_NOsh_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of forceMG. Expected _NOsh_p.");
        return NULL;
        }
    }
    if (_argc2) {
        if (SWIG_GetPtr(_argc2,(void **) &_arg2,"_PBEparm_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 3 of forceMG. Expected _PBEparm_p.");
        return NULL;
        }
    }
    if (_argc3) {
        if (SWIG_GetPtr(_argc3,(void **) &_arg3,"_MGparm_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 4 of forceMG. Expected _MGparm_p.");
        return NULL;
        }
    }
    if (_argc4) {
        if (SWIG_GetPtr(_argc4,(void **) &_arg4,"_Vpmg_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 5 of forceMG. Expected _Vpmg_p.");
        return NULL;
        }
    }
    if (_argc5) {
        if (SWIG_GetPtr(_argc5,(void **) &_arg5,"_int_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 6 of forceMG. Expected _int_p.");
        return NULL;
        }
    }
    if (_argc6) {
        if (SWIG_GetPtr(_argc6,(void **) &_arg6,"_AtomForce_pp")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 7 of forceMG. Expected _AtomForce_pp.");
        return NULL;
        }
    }
    if (_argc7) {
        if (SWIG_GetPtr(_argc7,(void **) &_arg7,"_Valist_pp")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 8 of forceMG. Expected _Valist_pp.");
        return NULL;
        }
    }
    _result = (int )forceMG(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5,_arg6,_arg7);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_killForce(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    Vmem * _arg0;
    NOsh * _arg1;
    int * _arg2;
    AtomForce ** _arg3;
    char * _argc0 = 0;
    char * _argc1 = 0;
    char * _argc2 = 0;
    char * _argc3 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"ssss:killForce",&_argc0,&_argc1,&_argc2,&_argc3)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_Vmem_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of killForce. Expected _Vmem_p.");
        return NULL;
        }
    }
    if (_argc1) {
        if (SWIG_GetPtr(_argc1,(void **) &_arg1,"_NOsh_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of killForce. Expected _NOsh_p.");
        return NULL;
        }
    }
    if (_argc2) {
        if (SWIG_GetPtr(_argc2,(void **) &_arg2,"_int_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 3 of killForce. Expected _int_p.");
        return NULL;
        }
    }
    if (_argc3) {
        if (SWIG_GetPtr(_argc3,(void **) &_arg3,"_AtomForce_pp")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 4 of killForce. Expected _AtomForce_pp.");
        return NULL;
        }
    }
    killForce(_arg0,_arg1,_arg2,_arg3);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_writedataMG(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    int  _arg0;
    NOsh * _arg1;
    PBEparm * _arg2;
    Vpmg * _arg3;
    char * _argc1 = 0;
    char * _argc2 = 0;
    char * _argc3 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"isss:writedataMG",&_arg0,&_argc1,&_argc2,&_argc3)) 
        return NULL;
    if (_argc1) {
        if (SWIG_GetPtr(_argc1,(void **) &_arg1,"_NOsh_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of writedataMG. Expected _NOsh_p.");
        return NULL;
        }
    }
    if (_argc2) {
        if (SWIG_GetPtr(_argc2,(void **) &_arg2,"_PBEparm_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 3 of writedataMG. Expected _PBEparm_p.");
        return NULL;
        }
    }
    if (_argc3) {
        if (SWIG_GetPtr(_argc3,(void **) &_arg3,"_Vpmg_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 4 of writedataMG. Expected _Vpmg_p.");
        return NULL;
        }
    }
    _result = (int )writedataMG(_arg0,_arg1,_arg2,_arg3);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_writematMG(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    int  _arg0;
    NOsh * _arg1;
    PBEparm * _arg2;
    Vpmg * _arg3;
    char * _argc1 = 0;
    char * _argc2 = 0;
    char * _argc3 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"isss:writematMG",&_arg0,&_argc1,&_argc2,&_argc3)) 
        return NULL;
    if (_argc1) {
        if (SWIG_GetPtr(_argc1,(void **) &_arg1,"_NOsh_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of writematMG. Expected _NOsh_p.");
        return NULL;
        }
    }
    if (_argc2) {
        if (SWIG_GetPtr(_argc2,(void **) &_arg2,"_PBEparm_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 3 of writematMG. Expected _PBEparm_p.");
        return NULL;
        }
    }
    if (_argc3) {
        if (SWIG_GetPtr(_argc3,(void **) &_arg3,"_Vpmg_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 4 of writematMG. Expected _Vpmg_p.");
        return NULL;
        }
    }
    _result = (int )writematMG(_arg0,_arg1,_arg2,_arg3);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_printEnergy(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    Vcom * _arg0;
    NOsh * _arg1;
    double * _arg2;
    int  _arg3;
    char * _argc0 = 0;
    char * _argc1 = 0;
    char * _argc2 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"sssi:printEnergy",&_argc0,&_argc1,&_argc2,&_arg3)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_Vcom_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of printEnergy. Expected _Vcom_p.");
        return NULL;
        }
    }
    if (_argc1) {
        if (SWIG_GetPtr(_argc1,(void **) &_arg1,"_NOsh_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of printEnergy. Expected _NOsh_p.");
        return NULL;
        }
    }
    if (_argc2) {
        if (SWIG_GetPtr(_argc2,(void **) &_arg2,"_double_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 3 of printEnergy. Expected _double_p.");
        return NULL;
        }
    }
    _result = (int )printEnergy(_arg0,_arg1,_arg2,_arg3);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_printForce(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    Vcom * _arg0;
    NOsh * _arg1;
    int * _arg2;
    AtomForce ** _arg3;
    int  _arg4;
    char * _argc0 = 0;
    char * _argc1 = 0;
    char * _argc2 = 0;
    char * _argc3 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"ssssi:printForce",&_argc0,&_argc1,&_argc2,&_argc3,&_arg4)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_Vcom_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of printForce. Expected _Vcom_p.");
        return NULL;
        }
    }
    if (_argc1) {
        if (SWIG_GetPtr(_argc1,(void **) &_arg1,"_NOsh_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of printForce. Expected _NOsh_p.");
        return NULL;
        }
    }
    if (_argc2) {
        if (SWIG_GetPtr(_argc2,(void **) &_arg2,"_int_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 3 of printForce. Expected _int_p.");
        return NULL;
        }
    }
    if (_argc3) {
        if (SWIG_GetPtr(_argc3,(void **) &_arg3,"_AtomForce_pp")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 4 of printForce. Expected _AtomForce_pp.");
        return NULL;
        }
    }
    _result = (int )printForce(_arg0,_arg1,_arg2,_arg3,_arg4);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_startVio(PyObject *self, PyObject *args) {
    PyObject * _resultobj;

    self = self;
    if(!PyArg_ParseTuple(args,":startVio")) 
        return NULL;
    startVio();
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

#define new_MGparm() ((MGparm *) calloc(1,sizeof(MGparm)))
static PyObject *_wrap_new_MGparm(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    MGparm * _result;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,":new_MGparm")) 
        return NULL;
    _result = (MGparm *)new_MGparm();
    SWIG_MakePtr(_ptemp, (char *) _result,"_MGparm_p");
    _resultobj = Py_BuildValue("s",_ptemp);
    return _resultobj;
}

#define delete_MGparm(_swigobj) (free ((char *) _swigobj))
static PyObject *_wrap_delete_MGparm(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    MGparm * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:delete_MGparm",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_MGparm_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of delete_MGparm. Expected _MGparm_p.");
        return NULL;
        }
    }
    delete_MGparm(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

#define MGparm_type_set(_swigobj,_swigval) (_swigobj->type = *(_swigval),_swigval)
static PyObject *_wrap_MGparm_type_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    MGparm_CalcType * _result;
    MGparm * _arg0;
    MGparm_CalcType * _arg1;
    char * _argc0 = 0;
    char * _argc1 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"ss:MGparm_type_set",&_argc0,&_argc1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_MGparm_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of MGparm_type_set. Expected _MGparm_p.");
        return NULL;
        }
    }
    if (_argc1) {
        if (SWIG_GetPtr(_argc1,(void **) &_arg1,"_MGparm_CalcType_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of MGparm_type_set. Expected _MGparm_CalcType_p.");
        return NULL;
        }
    }
    _result = (MGparm_CalcType *)MGparm_type_set(_arg0,_arg1);
    SWIG_MakePtr(_ptemp, (char *) _result,"_MGparm_CalcType_p");
    _resultobj = Py_BuildValue("s",_ptemp);
    return _resultobj;
}

#define MGparm_type_get(_swigobj) (&_swigobj->type)
static PyObject *_wrap_MGparm_type_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    MGparm_CalcType * _result;
    MGparm * _arg0;
    char * _argc0 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"s:MGparm_type_get",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_MGparm_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of MGparm_type_get. Expected _MGparm_p.");
        return NULL;
        }
    }
    _result = (MGparm_CalcType *)MGparm_type_get(_arg0);
    SWIG_MakePtr(_ptemp, (char *) _result,"_MGparm_CalcType_p");
    _resultobj = Py_BuildValue("s",_ptemp);
    return _resultobj;
}

#define new_PBEparm() ((PBEparm *) calloc(1,sizeof(PBEparm)))
static PyObject *_wrap_new_PBEparm(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    PBEparm * _result;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,":new_PBEparm")) 
        return NULL;
    _result = (PBEparm *)new_PBEparm();
    SWIG_MakePtr(_ptemp, (char *) _result,"_PBEparm_p");
    _resultobj = Py_BuildValue("s",_ptemp);
    return _resultobj;
}

#define delete_PBEparm(_swigobj) (free ((char *) _swigobj))
static PyObject *_wrap_delete_PBEparm(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    PBEparm * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:delete_PBEparm",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_PBEparm_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of delete_PBEparm. Expected _PBEparm_p.");
        return NULL;
        }
    }
    delete_PBEparm(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

#define PBEparm_temp_set(_swigobj,_swigval) (_swigobj->temp = _swigval,_swigval)
static PyObject *_wrap_PBEparm_temp_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double  _result;
    PBEparm * _arg0;
    double  _arg1;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"sd:PBEparm_temp_set",&_argc0,&_arg1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_PBEparm_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of PBEparm_temp_set. Expected _PBEparm_p.");
        return NULL;
        }
    }
    _result = (double )PBEparm_temp_set(_arg0,_arg1);
    _resultobj = Py_BuildValue("d",_result);
    return _resultobj;
}

#define PBEparm_temp_get(_swigobj) ((double ) _swigobj->temp)
static PyObject *_wrap_PBEparm_temp_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double  _result;
    PBEparm * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:PBEparm_temp_get",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_PBEparm_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of PBEparm_temp_get. Expected _PBEparm_p.");
        return NULL;
        }
    }
    _result = (double )PBEparm_temp_get(_arg0);
    _resultobj = Py_BuildValue("d",_result);
    return _resultobj;
}

#define new_Vcom() ((Vcom *) calloc(1,sizeof(Vcom)))
static PyObject *_wrap_new_Vcom(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    Vcom * _result;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,":new_Vcom")) 
        return NULL;
    _result = (Vcom *)new_Vcom();
    SWIG_MakePtr(_ptemp, (char *) _result,"_Vcom_p");
    _resultobj = Py_BuildValue("s",_ptemp);
    return _resultobj;
}

#define delete_Vcom(_swigobj) (free ((char *) _swigobj))
static PyObject *_wrap_delete_Vcom(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    Vcom * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:delete_Vcom",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_Vcom_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of delete_Vcom. Expected _Vcom_p.");
        return NULL;
        }
    }
    delete_Vcom(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

#define new_Vmem() ((Vmem *) calloc(1,sizeof(Vmem)))
static PyObject *_wrap_new_Vmem(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    Vmem * _result;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,":new_Vmem")) 
        return NULL;
    _result = (Vmem *)new_Vmem();
    SWIG_MakePtr(_ptemp, (char *) _result,"_Vmem_p");
    _resultobj = Py_BuildValue("s",_ptemp);
    return _resultobj;
}

#define delete_Vmem(_swigobj) (free ((char *) _swigobj))
static PyObject *_wrap_delete_Vmem(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    Vmem * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:delete_Vmem",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_Vmem_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of delete_Vmem. Expected _Vmem_p.");
        return NULL;
        }
    }
    delete_Vmem(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

#define new_Vpmg() ((Vpmg *) calloc(1,sizeof(Vpmg)))
static PyObject *_wrap_new_Vpmg(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    Vpmg * _result;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,":new_Vpmg")) 
        return NULL;
    _result = (Vpmg *)new_Vpmg();
    SWIG_MakePtr(_ptemp, (char *) _result,"_Vpmg_p");
    _resultobj = Py_BuildValue("s",_ptemp);
    return _resultobj;
}

#define delete_Vpmg(_swigobj) (free ((char *) _swigobj))
static PyObject *_wrap_delete_Vpmg(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    Vpmg * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:delete_Vpmg",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_Vpmg_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of delete_Vpmg. Expected _Vpmg_p.");
        return NULL;
        }
    }
    delete_Vpmg(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

#define NOsh_calc_mgparm_set(_swigobj,_swigval) (_swigobj->mgparm = _swigval,_swigval)
static PyObject *_wrap_NOsh_calc_mgparm_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    MGparm * _result;
    NOsh_calc * _arg0;
    MGparm * _arg1;
    char * _argc0 = 0;
    char * _argc1 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"ss:NOsh_calc_mgparm_set",&_argc0,&_argc1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_NOsh_calc_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of NOsh_calc_mgparm_set. Expected _NOsh_calc_p.");
        return NULL;
        }
    }
    if (_argc1) {
        if (SWIG_GetPtr(_argc1,(void **) &_arg1,"_MGparm_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of NOsh_calc_mgparm_set. Expected _MGparm_p.");
        return NULL;
        }
    }
    _result = (MGparm *)NOsh_calc_mgparm_set(_arg0,_arg1);
    SWIG_MakePtr(_ptemp, (char *) _result,"_MGparm_p");
    _resultobj = Py_BuildValue("s",_ptemp);
    return _resultobj;
}

#define NOsh_calc_mgparm_get(_swigobj) ((MGparm *) _swigobj->mgparm)
static PyObject *_wrap_NOsh_calc_mgparm_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    MGparm * _result;
    NOsh_calc * _arg0;
    char * _argc0 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"s:NOsh_calc_mgparm_get",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_NOsh_calc_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of NOsh_calc_mgparm_get. Expected _NOsh_calc_p.");
        return NULL;
        }
    }
    _result = (MGparm *)NOsh_calc_mgparm_get(_arg0);
    SWIG_MakePtr(_ptemp, (char *) _result,"_MGparm_p");
    _resultobj = Py_BuildValue("s",_ptemp);
    return _resultobj;
}

#define NOsh_calc_femparm_set(_swigobj,_swigval) (_swigobj->femparm = _swigval,_swigval)
static PyObject *_wrap_NOsh_calc_femparm_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    FEMparm * _result;
    NOsh_calc * _arg0;
    FEMparm * _arg1;
    char * _argc0 = 0;
    char * _argc1 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"ss:NOsh_calc_femparm_set",&_argc0,&_argc1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_NOsh_calc_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of NOsh_calc_femparm_set. Expected _NOsh_calc_p.");
        return NULL;
        }
    }
    if (_argc1) {
        if (SWIG_GetPtr(_argc1,(void **) &_arg1,"_FEMparm_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of NOsh_calc_femparm_set. Expected _FEMparm_p.");
        return NULL;
        }
    }
    _result = (FEMparm *)NOsh_calc_femparm_set(_arg0,_arg1);
    SWIG_MakePtr(_ptemp, (char *) _result,"_FEMparm_p");
    _resultobj = Py_BuildValue("s",_ptemp);
    return _resultobj;
}

#define NOsh_calc_femparm_get(_swigobj) ((FEMparm *) _swigobj->femparm)
static PyObject *_wrap_NOsh_calc_femparm_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    FEMparm * _result;
    NOsh_calc * _arg0;
    char * _argc0 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"s:NOsh_calc_femparm_get",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_NOsh_calc_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of NOsh_calc_femparm_get. Expected _NOsh_calc_p.");
        return NULL;
        }
    }
    _result = (FEMparm *)NOsh_calc_femparm_get(_arg0);
    SWIG_MakePtr(_ptemp, (char *) _result,"_FEMparm_p");
    _resultobj = Py_BuildValue("s",_ptemp);
    return _resultobj;
}

#define NOsh_calc_pbeparm_set(_swigobj,_swigval) (_swigobj->pbeparm = _swigval,_swigval)
static PyObject *_wrap_NOsh_calc_pbeparm_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    PBEparm * _result;
    NOsh_calc * _arg0;
    PBEparm * _arg1;
    char * _argc0 = 0;
    char * _argc1 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"ss:NOsh_calc_pbeparm_set",&_argc0,&_argc1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_NOsh_calc_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of NOsh_calc_pbeparm_set. Expected _NOsh_calc_p.");
        return NULL;
        }
    }
    if (_argc1) {
        if (SWIG_GetPtr(_argc1,(void **) &_arg1,"_PBEparm_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of NOsh_calc_pbeparm_set. Expected _PBEparm_p.");
        return NULL;
        }
    }
    _result = (PBEparm *)NOsh_calc_pbeparm_set(_arg0,_arg1);
    SWIG_MakePtr(_ptemp, (char *) _result,"_PBEparm_p");
    _resultobj = Py_BuildValue("s",_ptemp);
    return _resultobj;
}

#define NOsh_calc_pbeparm_get(_swigobj) ((PBEparm *) _swigobj->pbeparm)
static PyObject *_wrap_NOsh_calc_pbeparm_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    PBEparm * _result;
    NOsh_calc * _arg0;
    char * _argc0 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"s:NOsh_calc_pbeparm_get",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_NOsh_calc_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of NOsh_calc_pbeparm_get. Expected _NOsh_calc_p.");
        return NULL;
        }
    }
    _result = (PBEparm *)NOsh_calc_pbeparm_get(_arg0);
    SWIG_MakePtr(_ptemp, (char *) _result,"_PBEparm_p");
    _resultobj = Py_BuildValue("s",_ptemp);
    return _resultobj;
}

#define NOsh_calc_calctype_set(_swigobj,_swigval) (_swigobj->calctype = _swigval,_swigval)
static PyObject *_wrap_NOsh_calc_calctype_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    NOsh_calc * _arg0;
    int  _arg1;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"si:NOsh_calc_calctype_set",&_argc0,&_arg1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_NOsh_calc_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of NOsh_calc_calctype_set. Expected _NOsh_calc_p.");
        return NULL;
        }
    }
    _result = (int )NOsh_calc_calctype_set(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define NOsh_calc_calctype_get(_swigobj) ((int ) _swigobj->calctype)
static PyObject *_wrap_NOsh_calc_calctype_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    NOsh_calc * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:NOsh_calc_calctype_get",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_NOsh_calc_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of NOsh_calc_calctype_get. Expected _NOsh_calc_p.");
        return NULL;
        }
    }
    _result = (int )NOsh_calc_calctype_get(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define new_NOsh() ((NOsh *) calloc(1,sizeof(NOsh)))
static PyObject *_wrap_new_NOsh(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    NOsh * _result;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,":new_NOsh")) 
        return NULL;
    _result = (NOsh *)new_NOsh();
    SWIG_MakePtr(_ptemp, (char *) _result,"_NOsh_p");
    _resultobj = Py_BuildValue("s",_ptemp);
    return _resultobj;
}

#define delete_NOsh(_swigobj) (free ((char *) _swigobj))
static PyObject *_wrap_delete_NOsh(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    NOsh * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:delete_NOsh",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_NOsh_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of delete_NOsh. Expected _NOsh_p.");
        return NULL;
        }
    }
    delete_NOsh(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

#define NOsh_ncalc_set(_swigobj,_swigval) (_swigobj->ncalc = _swigval,_swigval)
static PyObject *_wrap_NOsh_ncalc_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    NOsh * _arg0;
    int  _arg1;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"si:NOsh_ncalc_set",&_argc0,&_arg1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_NOsh_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of NOsh_ncalc_set. Expected _NOsh_p.");
        return NULL;
        }
    }
    _result = (int )NOsh_ncalc_set(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define NOsh_ncalc_get(_swigobj) ((int ) _swigobj->ncalc)
static PyObject *_wrap_NOsh_ncalc_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    NOsh * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:NOsh_ncalc_get",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_NOsh_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of NOsh_ncalc_get. Expected _NOsh_p.");
        return NULL;
        }
    }
    _result = (int )NOsh_ncalc_get(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define NOsh_nprint_set(_swigobj,_swigval) (_swigobj->nprint = _swigval,_swigval)
static PyObject *_wrap_NOsh_nprint_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    NOsh * _arg0;
    int  _arg1;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"si:NOsh_nprint_set",&_argc0,&_arg1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_NOsh_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of NOsh_nprint_set. Expected _NOsh_p.");
        return NULL;
        }
    }
    _result = (int )NOsh_nprint_set(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define NOsh_nprint_get(_swigobj) ((int ) _swigobj->nprint)
static PyObject *_wrap_NOsh_nprint_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    NOsh * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:NOsh_nprint_get",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_NOsh_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of NOsh_nprint_get. Expected _NOsh_p.");
        return NULL;
        }
    }
    _result = (int )NOsh_nprint_get(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define NOsh_nelec_set(_swigobj,_swigval) (_swigobj->nelec = _swigval,_swigval)
static PyObject *_wrap_NOsh_nelec_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    NOsh * _arg0;
    int  _arg1;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"si:NOsh_nelec_set",&_argc0,&_arg1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_NOsh_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of NOsh_nelec_set. Expected _NOsh_p.");
        return NULL;
        }
    }
    _result = (int )NOsh_nelec_set(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define NOsh_nelec_get(_swigobj) ((int ) _swigobj->nelec)
static PyObject *_wrap_NOsh_nelec_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    NOsh * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:NOsh_nelec_get",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_NOsh_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of NOsh_nelec_get. Expected _NOsh_p.");
        return NULL;
        }
    }
    _result = (int )NOsh_nelec_get(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define new_AtomForce() ((AtomForce *) calloc(1,sizeof(AtomForce)))
static PyObject *_wrap_new_AtomForce(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    AtomForce * _result;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,":new_AtomForce")) 
        return NULL;
    _result = (AtomForce *)new_AtomForce();
    SWIG_MakePtr(_ptemp, (char *) _result,"_AtomForce_p");
    _resultobj = Py_BuildValue("s",_ptemp);
    return _resultobj;
}

#define delete_AtomForce(_swigobj) (free ((char *) _swigobj))
static PyObject *_wrap_delete_AtomForce(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    AtomForce * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:delete_AtomForce",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_AtomForce_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of delete_AtomForce. Expected _AtomForce_p.");
        return NULL;
        }
    }
    delete_AtomForce(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyMethodDef apbslibcMethods[] = {
	 { "delete_AtomForce", _wrap_delete_AtomForce, 1 },
	 { "new_AtomForce", _wrap_new_AtomForce, 1 },
	 { "NOsh_nelec_get", _wrap_NOsh_nelec_get, 1 },
	 { "NOsh_nelec_set", _wrap_NOsh_nelec_set, 1 },
	 { "NOsh_nprint_get", _wrap_NOsh_nprint_get, 1 },
	 { "NOsh_nprint_set", _wrap_NOsh_nprint_set, 1 },
	 { "NOsh_ncalc_get", _wrap_NOsh_ncalc_get, 1 },
	 { "NOsh_ncalc_set", _wrap_NOsh_ncalc_set, 1 },
	 { "delete_NOsh", _wrap_delete_NOsh, 1 },
	 { "new_NOsh", _wrap_new_NOsh, 1 },
	 { "NOsh_calc_calctype_get", _wrap_NOsh_calc_calctype_get, 1 },
	 { "NOsh_calc_calctype_set", _wrap_NOsh_calc_calctype_set, 1 },
	 { "NOsh_calc_pbeparm_get", _wrap_NOsh_calc_pbeparm_get, 1 },
	 { "NOsh_calc_pbeparm_set", _wrap_NOsh_calc_pbeparm_set, 1 },
	 { "NOsh_calc_femparm_get", _wrap_NOsh_calc_femparm_get, 1 },
	 { "NOsh_calc_femparm_set", _wrap_NOsh_calc_femparm_set, 1 },
	 { "NOsh_calc_mgparm_get", _wrap_NOsh_calc_mgparm_get, 1 },
	 { "NOsh_calc_mgparm_set", _wrap_NOsh_calc_mgparm_set, 1 },
	 { "delete_Vpmg", _wrap_delete_Vpmg, 1 },
	 { "new_Vpmg", _wrap_new_Vpmg, 1 },
	 { "delete_Vmem", _wrap_delete_Vmem, 1 },
	 { "new_Vmem", _wrap_new_Vmem, 1 },
	 { "delete_Vcom", _wrap_delete_Vcom, 1 },
	 { "new_Vcom", _wrap_new_Vcom, 1 },
	 { "PBEparm_temp_get", _wrap_PBEparm_temp_get, 1 },
	 { "PBEparm_temp_set", _wrap_PBEparm_temp_set, 1 },
	 { "delete_PBEparm", _wrap_delete_PBEparm, 1 },
	 { "new_PBEparm", _wrap_new_PBEparm, 1 },
	 { "MGparm_type_get", _wrap_MGparm_type_get, 1 },
	 { "MGparm_type_set", _wrap_MGparm_type_set, 1 },
	 { "delete_MGparm", _wrap_delete_MGparm, 1 },
	 { "new_MGparm", _wrap_new_MGparm, 1 },
	 { "startVio", _wrap_startVio, 1 },
	 { "printForce", _wrap_printForce, 1 },
	 { "printEnergy", _wrap_printEnergy, 1 },
	 { "writematMG", _wrap_writematMG, 1 },
	 { "writedataMG", _wrap_writedataMG, 1 },
	 { "killForce", _wrap_killForce, 1 },
	 { "forceMG", _wrap_forceMG, 1 },
	 { "killEnergy", _wrap_killEnergy, 1 },
	 { "npenergyMG", _wrap_npenergyMG, 1 },
	 { "energyMG", _wrap_energyMG, 1 },
	 { "setPartMG", _wrap_setPartMG, 1 },
	 { "solveMG", _wrap_solveMG, 1 },
	 { "killMG", _wrap_killMG, 1 },
	 { "initMG", _wrap_initMG, 1 },
	 { "printMGPARM", _wrap_printMGPARM, 1 },
	 { "printPBEPARM", _wrap_printPBEPARM, 1 },
	 { "killChargeMaps", _wrap_killChargeMaps, 1 },
	 { "loadChargeMaps", _wrap_loadChargeMaps, 1 },
	 { "killKappaMaps", _wrap_killKappaMaps, 1 },
	 { "loadKappaMaps", _wrap_loadKappaMaps, 1 },
	 { "killDielMaps", _wrap_killDielMaps, 1 },
	 { "loadDielMaps", _wrap_loadDielMaps, 1 },
	 { "killMolecules", _wrap_killMolecules, 1 },
	 { "loadMolecules", _wrap_loadMolecules, 1 },
	 { "int_array", _wrap_int_array, 1 },
	 { "double_array", _wrap_double_array, 1 },
	 { "new_atomforcelist", _wrap_new_atomforcelist, 1 },
	 { "new_pbelist", _wrap_new_pbelist, 1 },
	 { "new_pmgplist", _wrap_new_pmgplist, 1 },
	 { "get_Vpmg", _wrap_get_Vpmg, 1 },
	 { "new_pmglist", _wrap_new_pmglist, 1 },
	 { "new_gridlist", _wrap_new_gridlist, 1 },
	 { "new_valist", _wrap_new_valist, 1 },
	 { "ptrmap", _wrap_ptrmap, 1 },
	 { "ptradd", _wrap_ptradd, 1 },
	 { "ptrfree", _wrap_ptrfree, 1 },
	 { "ptrcreate", _wrap_ptrcreate, 1 },
	 { "ptrset", _wrap_ptrset, 1 },
	 { "ptrvalue", _wrap_ptrvalue, 1 },
	 { "ptrcast", _wrap_ptrcast, 1 },
	 { "NOsh_parseFile", _wrap_NOsh_parseFile, 1 },
	 { "NOsh_dtor", _wrap_NOsh_dtor, 1 },
	 { "NOsh_ctor2", _wrap_NOsh_ctor2, 1 },
	 { "NOsh_printWhat", _wrap_NOsh_printWhat, 1 },
	 { "NOsh_elec2calc", _wrap_NOsh_elec2calc, 1 },
	 { "NOsh_elecname", _wrap_NOsh_elecname, 1 },
	 { "NOsh_getCalc", _wrap_NOsh_getCalc, 1 },
	 { "Vmem_dtor", _wrap_Vmem_dtor, 1 },
	 { "Vmem_ctor", _wrap_Vmem_ctor, 1 },
	 { "Vcom_rank", _wrap_Vcom_rank, 1 },
	 { "Vcom_size", _wrap_Vcom_size, 1 },
	 { "Vcom_dtor", _wrap_Vcom_dtor, 1 },
	 { "Vcom_ctor", _wrap_Vcom_ctor, 1 },
	 { NULL, NULL }
};
static PyObject *SWIG_globals;
#ifdef __cplusplus
extern "C" 
#endif
SWIGEXPORT(void,initapbslibc)() {
	 PyObject *m, *d;
	 SWIG_globals = SWIG_newvarlink();
	 m = Py_InitModule("apbslibc", apbslibcMethods);
	 d = PyModule_GetDict(m);
	 PyDict_SetItemString(d,"APBS_SWIG", PyInt_FromLong((long) 1));
/*
 * These are the pointer type-equivalency mappings. 
 * (Used by the SWIG pointer type-checker).
 */
	 SWIG_RegisterMapping("_signed_long","_long",0);
	 SWIG_RegisterMapping("_long","_unsigned_long",0);
	 SWIG_RegisterMapping("_long","_signed_long",0);
	 SWIG_RegisterMapping("_unsigned_long","_long",0);
	 SWIG_RegisterMapping("_signed_int","_int",0);
	 SWIG_RegisterMapping("_unsigned_short","_short",0);
	 SWIG_RegisterMapping("_signed_short","_short",0);
	 SWIG_RegisterMapping("_unsigned_int","_int",0);
	 SWIG_RegisterMapping("_short","_unsigned_short",0);
	 SWIG_RegisterMapping("_short","_signed_short",0);
	 SWIG_RegisterMapping("_int","_unsigned_int",0);
	 SWIG_RegisterMapping("_int","_signed_int",0);
}
