C
C SHELXWAT - Automatic recycling procedure for adding water;
C            Iteratively calls SHELXL until file name.end found.
C
C              Copyright (C) 1996-7 George M. Sheldrick
C Usage:
C
C  shelxwat name  or  shelxwat -n10 -s4 -u0.6 -r0.8 -m50 -w4 -h name
C
C These are the default settings for the switches -n (number of
C overall cycles), -s (scattering factor number for oxygen), -u
C (starting isotropic U for new waters), -r (water rejected if U
C refines to greater than this value), -m (maximum number of
C waters to be added in one cycle), -w (do not add water if peak
C height less than w*sigma where sigma is the rms deviation of the
C difference Fourier from its mean) and -h (half/full occupancies)
C or -f (full occupancies only).  All switches present must come
C before 'name'.
C
C Standard SHELXL files name.ins and name.hkl are required; the .ins
C file should contain 'CGLS 5 -20', 'FMAP 2', 'PLAN 200 2.4' or
C 'PLAN 200 -2.4' (half occupancies allowed), 'CONN 0 O_501 > LAST',
C 'BUMP' or similar instructions (the free R test is not obligatory)
C and MUST include at least one water at the end of the atom list.
C The waters will then be assigned dynamical residue numbers starting
C with the residue number of this water (501 in the above example)
C and should all have residue class 'HOH' and atom name 'O' with one
C atom per residue and no PART numbers.
C
C SHELXWAT calls SHELXL once each cycle, then edits the resulting .res
C file to prepare the .ins file for the next cycle.  The R1 (and R1
C free, if present) indices are extracted from the .lst file and
C included in the .res files as remarks; these and other remarks (REM)
C provide a protocol of the refinement.
C
      PROGRAM SHELXWAT
      COMMON X,Y,Z,G,H
      CHARACTER KF*80,KR*80,KT*80,KL*128,KS*1,KC*8
C
C ====================================================================
C
C System-specific part of program follows; comment out inappropriate
C versions.  NOS is a code to define the operating system.
C
C VMS version
C
C     REAL X(99999),Y(99999),Z(99999),G(99999),H(99999)
C     INTEGER CLI$GET_VALUE
C     MX=99999
C     KC='COPY'
C     KR=' '
C     I=CLI$GET_VALUE('$LINE',KR)
C     NOS=2
C
C UNIX version
C
      REAL X(99999),Y(99999),Z(99999),G(99999),H(99999)
      MX=99999
      KC='cp'
      KR=' '
      L=0
        DO 3 I=1,IARGC()
        KF=' '
        CALL GETARG(I,KF)
        IF(KF(1:1).EQ.'-')GOTO 1
        IF(I.LT.IARGC())GOTO 3
   1      DO 2 J=1,80
          IF(KF(J:J).EQ.' ')GOTO 2
          L=L+1
          IF(L.GT.79)GOTO 47
          KR(L:L)=KF(J:J)
   2      CONTINUE
        L=L+1
   3    CONTINUE
      NOS=3
C
C Lahey version for MSDOS
C
C     REAL X(9999),Y(9999),Z(9999),G(9999),H(9999)
C     MX=9999
C     KC='COPY'
C     KR=' '
C     CALL GETCL(KR)
C     NOS=1
C
C End of system-specific part - the rest should rarely need changing,
C except possibly for the three lines beginning with 'CALL SYSTEM',
C and one statement to OPEN a file with CARRIAGECONTROL='LIST' (VMS).
C
C ====================================================================
C
C LP..LI are logical unit numbers for input/output.
C
      LP=11
      LR=12
      LS=13
      LI=14
C
C Interpret command line
C
      NZ=10
      NS=4
      UI=0.6
      UR=0.8
      MW=50
      NH=1
      LN=0
      WW=4.
      SL=-999.
      I=0
   4  I=I+1
      IF(I.GT.80)GOTO 14
      IF(KR(I:I).EQ.' ')GOTO 4
      L=0
      KL=' '
   5  L=L+1
      KL(L:L)=KR(I:I)
      I=I+1
      IF(I.GT.80)GOTO 47
      IF(KR(I:I).NE.' ')GOTO 5
      IF(KL(1:1).EQ.'-')GOTO 6
      LN=L
      KF=KL(1:80)
      GOTO 4
   6  IF(KL(2:2).NE.'n'.AND.KL(2:2).NE.'N')GOTO 7
      READ(KL(3:80),*,ERR=47,END=47)NZ
      GOTO 4
   7  IF(KL(2:2).NE.'s'.AND.KL(2:2).NE.'S')GOTO 8
      READ(KL(3:80),*,ERR=47,END=47)NS
      GOTO 4
   8  IF(KL(2:2).NE.'u'.AND.KL(2:2).NE.'U')GOTO 9
      READ(KL(3:80),*,ERR=47,END=47)UI
      GOTO 4
   9  IF(KL(2:2).NE.'r'.AND.KL(2:2).NE.'R')GOTO 10
      READ(KL(3:80),*,ERR=47,END=47)UR
      GOTO 4
  10  IF(KL(2:2).NE.'m'.AND.KL(2:2).NE.'M')GOTO 11
      READ(KL(3:80),*,ERR=47,END=47)MW
      GOTO 4
  11  IF(KL(2:2).NE.'f'.AND.KL(2:2).NE.'F')GOTO 12
      NH=1
      GOTO 4
  12  IF(KL(2:2).NE.'h'.AND.KL(2:2).NE.'H')GOTO 13
      NH=2
      GOTO 4
  13  IF(KL(2:2).NE.'w'.AND.KL(2:2).NE.'W')GOTO 47
      READ(KL(3:80),*,ERR=47,END=47)WW
      GOTO 4
C
C Save input file and remove name.end if it happens to exist already
C For VMS change 'SYSTEM' to 'LIB$SPAWN', and change comments to
C activate the CARRIAGECONTROL='LIST' statement.
C
  14  IF(LN.EQ.0)GOTO 47
      KF(LN+1:LN+4)='.bak'
      IF(NOS.EQ.2)GOTO 15
      OPEN(LP,FILE=KF(1:LN+4),STATUS='OLD',IOSTAT=I)
      CLOSE(LP,STATUS='DELETE',IOSTAT=I)
  15  CALL SYSTEM(KC//KF(1:LN)//'.ins '//KF(1:LN+4))
      WRITE(*,29)KF(1:LN)//'.ins',KF(1:LN+4)
      KF(LN+1:LN+4)='.end'
      OPEN(LP,FILE=KF(1:LN+4),STATUS='OLD',IOSTAT=I)
      CLOSE(LP,STATUS='DELETE',IOSTAT=I)
      WRITE(KL,30)NZ,NS,UI,UR,MW,WW
        DO 17 N=1,51,10
        L=0
          DO 16 I=N,N+9
          IF(KL(I:I).EQ.' ')GOTO 16
          L=L+1
          KR(L:L)=KL(I:I)
  16      CONTINUE
        IF(N.EQ.1)WRITE(*,31)KR(1:L)//' Number of overall cycles'
        IF(N.EQ.11)WRITE(*,31)KR(1:L)//' Scattering factor number'
     +  //' for oxygen'
        IF(N.EQ.21)WRITE(*,31)KR(1:L)//' Starting isotropic U for'
     +  //' waters'
        IF(N.EQ.31)WRITE(*,31)KR(1:L)//' Water rejected or halved'
     +  //' if U exceeds this value'
        IF(N.EQ.41)WRITE(*,31)KR(1:L)//' Maximum number of waters'
     +  //' to be added in one cycle'
        IF(N.EQ.51)WRITE(*,31)KR(1:L)//' Minimum height/sigma for'
     +  //' added water'
  17    CONTINUE
      IF(NH.EQ.1)WRITE(*,31)'-f Full occupancies only [use -h for'
     +//' full and half occupancies]'
      IF(NH.EQ.2)WRITE(*,31)'-h Half and full occupancies [use -f'
     +//' for full occupancies only]'
      NC=0
C
C Execute SHELXL.  For VMS change 'SYSTEM' to 'LIB$SPAWN'
C
  18  CALL SYSTEM('shelxl '//KF(1:LN))
      NC=NC+1
C
C Open .ins, .res and .lst files
C
      L=LN+4
      KF(L-3:L)='.ins'
      IF(NOS.EQ.2)GOTO 19
      OPEN(LI,FILE=KF(1:L),STATUS='OLD',IOSTAT=I)
      CLOSE(LI,STATUS='DELETE',IOSTAT=I)
  19  CONTINUE
C
C The following version of the OPEN statement is required when the
C operating system is NOT VMS:
C
      OPEN(LI,FILE=KF(1:L),STATUS='NEW',ERR=48)
C
C And the following version is required for VMS.  One of the two
C must always be commented out:
C
C     OPEN(LI,FILE=KF(1:L),STATUS='NEW',ERR=45,
C    +CARRIAGECONTROL='LIST')
C
      KF(L-2:L)='res'
      OPEN(LR,FILE=KF(1:L),STATUS='OLD',ERR=48)
      KF(L-2:L)='lst'
      OPEN(LS,FILE=KF(1:L),STATUS='OLD',ERR=48)
C
C Copy all lines of .res to .ins until RESI...HOH found
C
      NQ=0
      GOTO 22
  20  L=1
        DO 21 I=1,80
        IF(KT(I:I).NE.' ')L=I
  21    CONTINUE
      WRITE(LI,'(A)')KR(1:L)
  22  READ(LR,'(A)',ERR=36,END=36)KR
        DO 23 I=1,80
        KS=KR(I:I)
        IF(KS.LT.' ')KS=' '
        IF(KS.GE.'a'.AND.KS.LE.'z')
     +  KS=CHAR(ICHAR(KS)-ICHAR('a')+ICHAR('A'))
        KT(I:I)=KS
  23    CONTINUE
      IF(KT(1:4).NE.'RESI')GOTO 20
      I=INDEX(KT,' HOH ')
      IF(I.EQ.0)GOTO 20
      KT(I+1:I+3)='   '
      READ(KT(5:80),*,ERR=36,END=36)NR
      NR=NR-1
      IF(NR.LT.0)GOTO 36
      NT=NR
C
C Copy waters with U less than UR; renumber residues accordingly,
C with halved occupancies where appropriate
C
  24  READ(LR,'(A)',ERR=36,END=36)KR
      L=1
        DO 25 I=1,80
        KS=KR(I:I)
        IF(KS.LT.' ')KS=' '
        IF(KS.EQ.'=')KS=' '
        IF(KS.GE.'a'.AND.KS.LE.'z')
     +  KS=CHAR(ICHAR(KS)-ICHAR('a')+ICHAR('A'))
        KT(I:I)=KS
        IF(KS.NE.' ')L=I
  25    CONTINUE
      IF(KT(1:3).NE.'REM')GOTO 26
      WRITE(LI,46)KR(1:L)
      GOTO 24
  26  IF(KT(1:1).EQ.' ')GOTO 24
      IF(KT(1:4).NE.'RESI')GOTO 27
      I=INDEX(KT,' HOH ')
      IF(I.EQ.0)GOTO 36
      KT(I+1:I+3)='   '
      READ(KT(5:80),*,ERR=36,END=36)N
      IF(N.LE.NR)GOTO 36
      GOTO 24
  27  IF(KT(1:2).NE.'O ')GOTO 35
      READ(KT(3:80),*,ERR=36,END=36)I,XX,YY,ZZ,P,U
      IF(U.LT.UR)GOTO 28
      IF(NH.EQ.1)GOTO 24
      IF(P.LT.10.9)GOTO 24
      P=10.5
  28  NT=NT+1
      IF(P.LT.10.9)NQ=NQ+1
      WRITE(LI,34)NT,NS,XX,YY,ZZ,P,U
      GOTO 24
C
C On reaching end of existing waters, read R1 from name.lst and
C include REM instructions into .ins file to act as protocol
C
  29  FORMAT(/' SHELXWAT - Crude automatic water divining using  ',
     +'SHELXL-97'/' Release 97-1  -  Copyright (C) 1996-7  George M',
     +'. Sheldrick'/' =============================================',
     +'============='//1X,A,' copied to ',A,' in case of accidents'
     +//' Switch settings for this run:')
  30  FORMAT('-n',I8,'-s',I8,'-u',F8.3,'-r',F8.3,'-m',I8,'-w',F8.3)
  31  FORMAT(1X,A)
  32  FORMAT('REM Iteration',I3,': Current contents',I5,
     +' full and',I5,' half occupancy waters')
  33  FORMAT('REM Peak heights ranged from',F6.3,'  to',F6.3,
     +'  for added waters')
  34  FORMAT('RESI',I5,'  HOH'/'O',I4,5F10.5,F7.2)
  35  IF(KT(1:4).EQ.'HKLF')GOTO 37
  36  WRITE(*,'(/A/)')' ** Unsuitable format for file '//
     +KF(1:LN)//'.res **',' '//KR(1:78)
      GOTO 50
  37  NN=0
  38  KL=' '
      READ(LS,'(A)',ERR=40,END=40)KL
      I=INDEX(KL(1:4),'R1')
      IF(I.EQ.0)GOTO 38
      IF(INDEX(KL,'merg').NE.0)GOTO 38
      IF(INDEX(KL,'Free').NE.0)GOTO 39
      WRITE(LI,'(A)')'REM '//KL(I:I+72)
      GOTO 38
  39  WRITE(LI,'(A)')'REM '//KL(I:I+37)//KL(I+43:I+76)
      GOTO 38
  40  READ(LR,'(A)',ERR=43,END=43)KR
      IF(INDEX(KR,'deepest').EQ.0)GOTO 41
      I=INDEX(KR,'level')
      IF(I.NE.0)READ(KR(I+5:I+11),*)SL
  41  IF(KR(1:1).NE.'Q')GOTO 40
      NN=NN+1
      READ(KR(8:56),*,ERR=36,END=36)X(NN),Y(NN),Z(NN),G(NN),P,H(NN)
      IF(H(NN).LT.WW*SL)GOTO 42
      IF(G(NN).LE.10.9)NQ=NQ+1
      IF(NN.LT.MIN0(MW,MX))GOTO 40
      GOTO 43
  42  NN=NN-1
  43  WRITE(LI,32)NC,NN+NT-NR-NQ,NQ
      IF(NN.GT.0)WRITE(LI,33)H(1),H(NN)
      IF(NC.EQ.1.AND.SL.LT.0.)WRITE(*,'(A)')' ** Sigma level not '
     +//'found in .res file - old version of SHELXL ? **'
        DO 44 I=1,NN
        NT=NT+1
        WRITE(LI,34)NT,NS,X(I),Y(I),Z(I),G(I),UI,H(I)
  44    CONTINUE
      L=0
        DO 45 I=1,80
        IF(KT(I:I).NE.' ')L=I
  45    CONTINUE
      WRITE(LI,'(A/A)')KT(1:L),'END'
C
C Recycle unless name.end exists (in which case delete it and finish)
C
      CLOSE(LI)
      CLOSE(LR)
      CLOSE(LS)
      IF(NC.GE.NZ)GOTO 49
      KF(LN+1:LN+4)='.end'
      OPEN(LP,FILE=KF(1:LN+4),STATUS='OLD',ERR=18)
      CLOSE(LP,STATUS='DELETE',IOSTAT=I)
      GOTO 49
  46  FORMAT(A)
  47  WRITE(*,'(/A)')' ** Bad command line **'
      GOTO 50
  48  WRITE(*,'(/A)')' ** Cannot open file '//KF(1:L)//' **'
C
C Update .res file too - for VMS change 'SYSTEM' to 'LIB$SPAWN'
C
  49  CALL SYSTEM(KC//KF(1:LN)//'.ins '//KF(1:LN)//'.res')
  50  WRITE(*,'(/A/)')' SHELXWAT finished'
      END
