C
      PROGRAM SHELXS
C
C UNIX Version of SHELXS-97 - Crystal Structure Solution
C       Copyright (C) George M. Sheldrick 1986-97
C
      PARAMETER(LM=200000,LS=1000000,LU=4096)
C
C In the unlikely event of it being necessary to change the sizes
C of the large arrays used in SHELXS, only this parameter statement
C should be changed.  LS may need to be increased for very large
C direct methods problems, but the program will adjust the number of
C parallel phase permutations to fill the available memory (up to a
C limit of 128).  The program tends to use array A as a Cache and
C B as a sort of backing store.  LU is the size of the I/O buffer.
C
      CHARACTER*1 IH(22),IT(76),IR(80),HK(80),KD
      CHARACTER*80 NM,FM
      COMMON F(LU),G(LU),A(LM),B(LS)
      COMMON/MEM/ST,SL,TC,TL,LR,LG,LH,LI,LP,LF,LA,LB,
     +LW,LY,LL,LQ,LE,LV,LX,LD,LZ,LJ,LN,LK,LC,HA,HD
      COMMON/WORD/IH,IT,IR,HK,NM,KD
C
C KD should be set to CHAR(13) for UNIX systems to write the .res
C file in DOS rather than UNIX format with <CR><LF> instead of <LF>
C as line terminator. This is useful if the disk can also be accessed
C by MSDOS PC's.  For standard UNIX action, set KD to CHAR(32) here.
C
      KD=CHAR(32)
C
C Switch off meaningless 'underflows' here if necessary
C Start timing and set default maxtime TL for finishing off.  TL
C could be set to say 0.8 times CPU limit for the job, if known.
C The value of TL may be reduced but not increased by means of
C the TIME instruction in the .ins file.  TC (and TX in the IBM
C version) handle possible resetting of the clock at midnight.
C
      TC=0.
      CALL SXTI(SL)
      ST=SL
      TL=9999999.
C
C Set chars/inch across (HA) and lines/inch down page (HD)
C (usually HA=10. and HD=6. or 8., may be more for laser printers).
C
      HA=16.66667
      HD=10.
C
C Set units for input (LR, usually 5), hkl data (LH, e.g. 3), printer
C (LI, usually 6), 'cardpunch' (LP, e.g. 7).  Also set binary scratch
C (unformatted) units (LA, LB, LF and LG, e.g. 2, 4, 8 and 9 resp.).
C All unit numbers must be different, and all files used by SHELXS-97
C are sequential.
C
      LR=1
      LA=2
      LH=3
      LB=4
      LP=7
      LF=8
      LG=9
      LI=10
      LC=11
C
C Open files using name from command line and standard extensions.
C The OPEN statements may need to be changed for some computers.
C Subroutine SXNM gets the generic filename from the command line.
C If the files are to be defined completely externally to the
C program (e.g. in a IBM or REX 'EXEC' procedure on an IBM
C computer), then SXNM sets LN to 0. Units 6 and 7 will often have
C STATUS='UNKNOWN', but VMS requires 'NEW'.  For UNIX, all filenames
C are converted to lower case.
C
      CALL SXNM
      IF(LN.EQ.0)GOTO 1
      FM=NM(1:LN)//'.ins'
      L=LN+4
      OPEN(UNIT=LR,FILE=FM(1:L),STATUS='OLD',ERR=7)
      FM=NM(1:LN)//'.lst'
      OPEN(UNIT=LI,FILE=FM(1:L),STATUS='OLD',IOSTAT=I)
      CLOSE(UNIT=LI,STATUS='DELETE',IOSTAT=I)
      OPEN(UNIT=LI,FILE=FM(1:L),STATUS='NEW',ERR=7)
      FM=NM(1:LN)//'.res'
      OPEN(UNIT=LP,FILE=FM(1:L),STATUS='OLD',IOSTAT=I)
      CLOSE(UNIT=LP,STATUS='DELETE',IOSTAT=I)
      OPEN(UNIT=LP,FILE=FM(1:L),STATUS='NEW',ERR=7)
C
C Open scratch files (unformatted, sequential).   As above,
C OPEN statements may need to be changed for some computers.
C
      FM='SCRATCH'
      L=7
      OPEN(UNIT=LA,STATUS='SCRATCH',FORM='UNFORMATTED',ERR=7)
      OPEN(UNIT=LB,STATUS='SCRATCH',FORM='UNFORMATTED',ERR=7)
      OPEN(UNIT=LF,STATUS='SCRATCH',FORM='UNFORMATTED',ERR=7)
      OPEN(UNIT=LG,STATUS='SCRATCH',FORM='UNFORMATTED',ERR=7)
C
C Delete any name.fin file left over from a previous job.
C
      CALL SXFN(I)
C
C Print heading then call first subroutine, which may be an overlay
C segment.  SX2A reads and interprets the .INS instruction file.
C
   1  CALL SXTL
      CALL SX2A(LM,LU,F,G,A)
C
C Open intensity data file here if required by input instructions.
C
      IF(LH.EQ.LR)GOTO 2
      IF(LN.EQ.0)GOTO 2
      CLOSE(UNIT=LR,STATUS='KEEP')
      FM=NM(1:LN)//'.hkl'
      L=LN+4
      OPEN(UNIT=LH,FILE=FM(1:L),STATUS='OLD',ERR=7)
C
C Call remaining subroutines, which may each be overlay segments.
C
   2  LK=1
      IF(LD.NE.0)GOTO 5
      CALL SX2B(LM,LS,LU,F,G,A,B)
      IF(LN.NE.0)CLOSE(LH,STATUS='KEEP')
      CALL SX2C(LM,LS,LU,F,G,A,B)
      CALL SX2D(LM,LS,LU,F,G,A,B)
      CALL SX2E(LM,LS,LU,F,G,A,B)
   3  CALL SX2F(LM,LS,LU,F,G,A,B)
   4  CALL SX2G(LM,LS,LU,F,G,A,B)
      IF(LK.GT.0)GOTO 3
   5  CALL SX2H(LM,LU,F,G,A)
      CALL SX2I(LM,LS,LU,F,G,A,B)
      CALL SX2J(LM,LS,LU,F,G,A,B)
      GOTO 4
   6  FORMAT(/' ** CANNOT OPEN FILE ',A)
   7  WRITE(*,6)FM(1:L)
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXNM
C
C Get generic filename (NAME) and its length (LN) from the command
C line. LN set to 0 if the file names are to be defined externally
C in a command procedure.  This routine is very computer-specific.
C For UNIX, all filenames are converted to lower case.
C
      CHARACTER*1 IH(22),IT(76),IR(80),HK(80),KD,KS
      CHARACTER*80 NM,KR
      COMMON/MEM/ST,SL,TC,TL,LR,LG,LH,LI,LP,LF,LA,LB,
     +LW,LY,LL,LQ,LE,LV,LX,LD,LZ,LJ,LN,LK,LC,HA,HD
      COMMON/WORD/IH,IT,IR,HK,NM,KD
C
   1  FORMAT(/' ** BAD COMMAND LINE **'/)
C
      KR=' '
      CALL GETARG(IARGC(),KR)
      LN=0
      NM=' '
        DO 2 I=1,80
        KS=KR(I:I)
        IF(KS.EQ.' ')GOTO 2
        LN=LN+1
        NM(LN:LN)=KS
   2    CONTINUE
      IF(LN.GT.0)GOTO 3
      WRITE(*,1)
      CALL SXIT
   3  RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXTL
C
C Put out SHELXS-97 heading and other useful information.  The array
C MON is commented out here but may be useful for systems which only
C provide the date in numerical form.
C
      CHARACTER*1 IH(22),IT(76),IR(80),HK(80),KD
      CHARACTER*25 TM
      CHARACTER*80 NM
      COMMON/MEM/ST,SL,TC,TL,LR,LG,LH,LI,LP,LF,LA,LB,
     +LW,LY,LL,LQ,LE,LV,LX,LD,LZ,LJ,LN,LK,LC,HA,HD
      COMMON/WORD/IH,IT,IR,HK,NM,KD
C
   1  FORMAT(//' ',63('+')/' +  SHELXS-97  -  CRYSTAL STRUCTURE ',
     +'SOLUTION  -  UNIX VERSION  +'/' +  Copyright(C) George M.',
     +' Sheldrick 1986-97     Release 97-2  +'/' +  ',A22,
     +' started at ',A8,' on ',A2,1X,A3,' ',A4,'  +'/' ',63('+')/)
C
      CALL FDATE(TM)
      WRITE(LI,1)NM(1:22),TM(12:19),TM(9:10),TM(5:7),TM(21:24)
      WRITE(*,1)NM(1:22),TM(12:19),TM(9:10),TM(5:7),TM(21:24)
      CALL SXFL
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXTI(T)
C
C Sets T to the CPU (or in some case elapsed) time used so far in
C seconds (not necessarily zero at the start of SHELXS). If the
C operating system does not provide any timing information, this
C subroutine should set T to -1.  TC keeps track of the last time
C determined by this routine to detect whether the clock is reset
C on passing through midnight.
C
      COMMON/MEM/ST,SL,TC,TL,LR,LG,LH,LI,LP,LF,LA,LB,
     +LW,LY,LL,LQ,LE,LV,LX,LD,LZ,LJ,LN,LK,LC,HA,HD
      REAL TX(2)
C
      T=ETIME(TX)
   1  IF(T.GT.TC-0.1)GOTO 2
      T=T+86400.
      GOTO 1
   2  TC=T
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXFL
C
C Flush console output buffer - useful for log files in batch jobs
C
      CALL FLUSH(6)
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXCC
C
C This subroutine is polled frequently to enable the user to signal
C to the program (with <Escape>) that he wishes to do no more phase
C refinement cycles but instead to tidy up and finish off, or (with
C <Ctrl-C> or - better - <Crtl-I>) that the job should be aborted.
C This subroutine is dummied out because most UNIX systems buffer
C keyboard input thereby making it difficult to implement.  The
C next subroutine (SXFN) provides an alternative to this use of the
C <Escape> key.
C
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXFN(I)
C
C This routine deletes the dummy file name.fin.  If successful
C (i.e. the file existed) the program tidies up and finishes off
C instead of doing further phase permutations or superposition
C maps.  This subroutine signals this by setting I to -1.  If
C the file name.fin cannot be deleted I is set to 0.  Note that
C this routine is also called at the beginning of a run to clear
C any name.fin file left over from a previous job.  This facility
C has the same action on a batch job as hitting the escape key
C for an interactive SHELXS run.
C
      CHARACTER*1 IH(22),IT(76),IR(80),HK(80),KD
      CHARACTER*80 NM
      COMMON/MEM/ST,SL,TC,TL,LR,LG,LH,LI,LP,LF,LA,LB,
     +LW,LY,LL,LQ,LE,LV,LX,LD,LZ,LJ,LN,LK,LC,HA,HD
      COMMON/WORD/IH,IT,IR,HK,NM,KD
C
      I=0
      OPEN(UNIT=LC,FILE=NM(1:LN)//'.fin',STATUS='OLD',ERR=1)
      CLOSE(UNIT=LC,STATUS='DELETE',ERR=1)
      I=-1
   1  RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXPG(LI)
C
C Print form feed = start new page.
C
      WRITE(LI,'(1X,A)')CHAR(12)
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXTM(SL,LI)
C
C Print CPU or elapsed time used since last called
C
   1  FORMAT(/F10.1,' seconds CPU time')
C
      T=SL
      CALL SXTI(SL)
      IF(SL.LT.0.)GOTO 2
      T=SL-T
      WRITE(LI,1)T
   2  RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXIT
C
C Terminate job in manner appropriate to operating system.
C E.g. print time and trailer, then stop.
C
      CHARACTER*1 IH(22),IT(76),IR(80),HK(80),KD
      CHARACTER*24 TM
      CHARACTER*80 NM
      COMMON/MEM/ST,SL,TC,TL,LR,LG,LH,LI,LP,LF,LA,LB,
     +LW,LY,LL,LQ,LE,LV,LX,LD,LZ,LJ,LN,LK,LC,HA,HD
      COMMON/WORD/IH,IT,IR,HK,NM,KD
C
   1  FORMAT(/' ',77('+')/' +  ',A17,' finished at ',A8,3X,
     +'Total CPU time:',F10.1,' secs  +'/' ',77('+'))
C
      CALL SXTI(T)
      T=T-ST
      CALL FDATE(TM)
      WRITE(LI,1)NM(1:17),TM(12:19),T
      WRITE(*,1)NM(1:17),TM(12:19),T
      CLOSE(UNIT=LI,IOSTAT=LY)
      CLOSE(UNIT=LP,IOSTAT=LY)
      CLOSE(UNIT=LA,STATUS='DELETE',IOSTAT=LY)
      CLOSE(UNIT=LB,STATUS='DELETE',IOSTAT=LY)
      CLOSE(UNIT=LF,STATUS='DELETE',IOSTAT=LY)
      CLOSE(UNIT=LG,STATUS='DELETE',IOSTAT=LY)
      CALL EXIT(0)
      STOP
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXUC(K)
C
C Convert a lower case character to upper case.
C If it is not a lower case letter do nothing.
C
      CHARACTER K*1
      IF(K.GT.'z')GOTO 1
      IF(K.LT.'a')GOTO 1
      K=CHAR(ICHAR(K)+ICHAR('A')-ICHAR('a'))
   1  RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXPS(X,KS)
C
C Pack 4 characters from character*4 string into one real.
C
      CHARACTER*4 KS
      READ(KS,'(A4)')X
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXUS(X,KS)
C
C Unpack 4 characters from one real into character*4 string.
C
      CHARACTER*4 KS
      WRITE(KS,'(A4)')X
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXPN(X,N)
C
C Left justify integer as string and pack into one real.
C
      CHARACTER*1 IH(22),IT(76),IR(80),HK(80),KD
      CHARACTER*4 KS
      CHARACTER*80 NM
      COMMON/WORD/IH,IT,IR,HK,NM,KD
C
      KS='    '
      K=0
      L=IABS(N)
      M=1000
   1  IF(M.LE.L)GOTO 2
      M=M/10
      IF(M.GT.1)GOTO 1
   2  K=K+1
      I=MOD(L/M,10)
      KS(K:K)=IH(I+1)
      M=M/10
      IF(M.GT.0)GOTO 2
      CALL SXPS(X,KS)
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXH2(W,X,Y,Z)
C
C Unpack reflection indices stored in one positive real.
C
      Z=AINT(2.5E-5*W+.5)
      X=W-40000.*Z
      X=AINT(X+SIGN(.5,X+.5))
      Y=AINT(5.E-3*X+SIGN(.5,X+.5))
      X=X-200.*Y
      X=AINT(X+SIGN(.5,X+.5))
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXER(MG)
C
C Error exit - output diagnostic message to console and
C printer (.LST file), then call exit routine.
C
      CHARACTER*(*)MG
      COMMON/MEM/ST,SL,TC,TL,LR,LG,LH,LI,LP,LF,LA,LB,
     +LW,LY,LL,LQ,LE,LV,LX,LD,LZ,LJ,LN,LK,LC,HA,HD
C
   1  FORMAT(/' ** ',A,' **'/)
   2  FORMAT(/' ** ',A,' **')
C
      WRITE(LI,1)MG
      WRITE(*,2)MG
      CALL SXIT
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXQS(NS,NN,NE,A)
C
C Shellsort records packed in array A. NE elements per record,
C sort on NNth element in record (first is number zero). If NE
C is negative the largest should become first and vice versa.
C Increase dimension of B if more than 10 elements per record.
C
      DIMENSION A(NS),B(10)
      ME=IABS(NE)
      S=REAL(ISIGN(1,NE))
      N=NS/ME
      M=1
   1  M=3*M+1
      IF(M.LT.N)GOTO 1
   2  M=M/3
      N=ME*M
      NI=N+1
      NJ=NI-ME
        DO 8 I=NI,NS,ME
        NL=I
          DO 3 L=1,ME
          B(L)=A(NL)
          NL=NL+1
   3      CONTINUE
        W=S*A(I+NN)
        J=I
   4    K=J-N
        IF(S*A(K+NN).LE.W)GOTO 6
          DO 5 L=1,ME
          A(J)=A(K)
          J=J+1
          K=K+1
   5      CONTINUE
        J=K-ME
        IF(J.GT.NJ)GOTO 4
   6      DO 7 L=1,ME
          A(J)=B(L)
          J=J+1
   7      CONTINUE
   8    CONTINUE
      IF(M.GT.2)GOTO 2
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SX2A(LM,LU,F,G,A)
C
C Interpret instructions
C
      CHARACTER*1 IH(22),IT(76),IR(80),HK(80)
      CHARACTER*1 IA(94),IB(94),IG(22),KD,KJ,KK,KU
      CHARACTER*4 KR,KS,KC(47)
      CHARACTER*80 NM
      REAL AR(94),AM(94),AG(94),AO(94),AU(94)
      REAL F(LU),G(LU),A(LM)
      COMMON/MEM/ST,SL,TC,TL,LR,LG,LH,LI,LP,LF,LA,LB,
     +LW,LY,LL,LQ,LE,LV,LX,LD,LZ,LJ,LN,LK,LC,HA,HD
      COMMON/WORD/IH,IT,IR,HK,NM,KD
C
C To avoid problems with different collating sequences, characters
C required for interpretation of the .INS file are defined here.
C
      DATA IG/'0','1','2','3','4','5','6','7','8','9','.','-',
     +'+','X','Y','Z',',','=','/',' ','*','Q'/,KJ/'!'/,KU/'_'/
C
C Atomic radius, weight, Cu, Mo and Ag absorption coefficients
C
      DATA IA(1)/'H'/,IB(1)/' '/,AR(1)/.32/,AM(1)/1.008/,
     +AU(1)/.655/,AO(1)/.624/,AG(1)/.614/
C
      DATA IA(2)/'H'/,IB(2)/'E'/,AR(2)/1.50/,AM(2)/4.00/,
     +AU(2)/1.94/,AO(2)/1.34/,AG(2)/1.28/
C
      DATA IA(3)/'L'/,IB(3)/'I'/,AR(3)/1.52/,AM(3)/6.94/,
     +AU(3)/5.76/,AO(3)/2.28/,AG(3)/2.06/
C
      DATA IA(4)/'B'/,IB(4)/'E'/,AR(4)/1.11/,AM(4)/9.01/,
     +AU(4)/16.6/,AO(4)/3.83/,AG(4)/3.13/
C
      DATA IA(5)/'B'/,IB(5)/' '/,AR(5)/0.82/,AM(5)/10.81/,
     +AU(5)/41.5/,AO(5)/6.61/,AG(5)/4.79/
C
      DATA IA(6)/'C'/,IB(6)/' '/,AR(6)/0.77/,AM(6)/12.01/,
     +AU(6)/89.9/,AO(6)/11.5/,AG(6)/7.45/
C
      DATA IA(7)/'N'/,IB(7)/' '/,AR(7)/0.70/,AM(7)/14.01/,
     +AU(7)/173./,AO(7)/19.6/,AG(7)/11.7/
C
      DATA IA(8)/'O'/,IB(8)/' '/,AR(8)/0.66/,AM(8)/16.00/,
     +AU(8)/304./,AO(8)/32.5/,AG(8)/18.2/
C
      DATA IA(9)/'F'/,IB(9)/' '/,AR(9)/0.64/,AM(9)/19.00/,
     +AU(9)/498./,AO(9)/51.5/,AG(9)/27.7/
C
      DATA IA(10)/'N'/,IB(10)/'E'/,AR(10)/1.50/,AM(10)/20.18/,
     +AU(10)/768./,AO(10)/78.6/,AG(10)/41.2/
C
      DATA IA(11)/'N'/,IB(11)/'A'/,AR(11)/1.86/,AM(11)/22.99/,
     +AU(11)/1140./,AO(11)/116./,AG(11)/59.6/
C
      DATA IA(12)/'M'/,IB(12)/'G'/,AR(12)/1.60/,AM(12)/24.31/,
     +AU(12)/1610./,AO(12)/165./,AG(12)/84.2/
C
      DATA IA(13)/'A'/,IB(13)/'L'/,AR(13)/1.25/,AM(13)/26.98/,
     +AU(13)/2220./,AO(13)/229./,AG(13)/116./
C
      DATA IA(14)/'S'/,IB(14)/'I'/,AR(14)/1.17/,AM(14)/28.09/,
     +AU(14)/2970./,AO(14)/310./,AG(14)/156./
C
      DATA IA(15)/'P'/,IB(15)/' '/,AR(15)/1.10/,AM(15)/30.97/,
     +AU(15)/3880./,AO(15)/410./,AG(15)/206./
C
      DATA IA(16)/'S'/,IB(16)/' '/,AR(16)/1.03/,AM(16)/32.06/,
     +AU(16)/4970./,AO(16)/532./,AG(16)/267./
C
      DATA IA(17)/'C'/,IB(17)/'L'/,AR(17)/0.99/,AM(17)/35.45/,
     +AU(17)/6240./,AO(17)/678./,AG(17)/341./
C
      DATA IA(18)/'A'/,IB(18)/'R'/,AR(18)/1.50/,AM(18)/39.95/,
     +AU(18)/7720./,AO(18)/851./,AG(18)/429./
C
      DATA IA(19)/'K'/,IB(19)/' '/,AR(19)/2.27/,AM(19)/39.10/,
     +AU(19)/9400./,AO(19)/1050./,AG(19)/532./
C
      DATA IA(20)/'C'/,IB(20)/'A'/,AR(20)/1.97/,AM(20)/40.08/,
     +AU(20)/11300./,AO(20)/1290./,AG(20)/652./
C
      DATA IA(21)/'S'/,IB(21)/'C'/,AR(21)/1.61/,AM(21)/44.96/,
     +AU(21)/13500./,AO(21)/1560./,AG(21)/789./
C
      DATA IA(22)/'T'/,IB(22)/'I'/,AR(22)/1.45/,AM(22)/47.90/,
     +AU(22)/15900./,AO(22)/1860./,AG(22)/947./
C
      DATA IA(23)/'V'/,IB(23)/' '/,AR(23)/1.31/,AM(23)/50.94/,
     +AU(23)/18500./,AO(23)/2200./,AG(23)/1120./
C
      DATA IA(24)/'C'/,IB(24)/'R'/,AR(24)/1.24/,AM(24)/52.00/,
     +AU(24)/21300./,AO(24)/2580./,AG(24)/1330./
C
      DATA IA(25)/'M'/,IB(25)/'N'/,AR(25)/1.37/,AM(25)/54.94/,
     +AU(25)/24600./,AO(25)/3020./,AG(25)/1550./
C
      DATA IA(26)/'F'/,IB(26)/'E'/,AR(26)/1.24/,AM(26)/55.85/,
     +AU(26)/28000./,AO(26)/3490./,AG(26)/1800./
C
      DATA IA(27)/'C'/,IB(27)/'O'/,AR(27)/1.25/,AM(27)/58.93/,
     +AU(27)/31400./,AO(27)/4010./,AG(27)/2070./
C
      DATA IA(28)/'N'/,IB(28)/'I'/,AR(28)/1.25/,AM(28)/58.71/,
     +AU(28)/4760./,AO(28)/4570./,AG(28)/2380./
C
      DATA IA(29)/'C'/,IB(29)/'U'/,AR(29)/1.28/,AM(29)/63.54/,
     +AU(29)/5470./,AO(29)/5180./,AG(29)/2710./
C
      DATA IA(30)/'Z'/,IB(30)/'N'/,AR(30)/1.33/,AM(30)/65.37/,
     +AU(30)/6290./,AO(30)/5860./,AG(30)/3070./
C
      DATA IA(31)/'G'/,IB(31)/'A'/,AR(31)/1.26/,AM(31)/69.72/,
     +AU(31)/7190./,AO(31)/6600./,AG(31)/3460./
C
      DATA IA(32)/'G'/,IB(32)/'E'/,AR(32)/1.22/,AM(32)/72.59/,
     +AU(32)/8190./,AO(32)/7380./,AG(32)/3870./
C
      DATA IA(33)/'A'/,IB(33)/'S'/,AR(33)/1.21/,AM(33)/74.92/,
     +AU(33)/9290./,AO(33)/8220./,AG(33)/4330./
C
      DATA IA(34)/'S'/,IB(34)/'E'/,AR(34)/1.17/,AM(34)/78.96/,
     +AU(34)/10500./,AO(34)/9110./,AG(34)/4820./
C
      DATA IA(35)/'B'/,IB(35)/'R'/,AR(35)/1.14/,AM(35)/79.91/,
     +AU(35)/11800./,AO(35)/10000./,AG(35)/5350./
C
      DATA IA(36)/'K'/,IB(36)/'R'/,AR(36)/1.50/,AM(36)/83.80/,
     +AU(36)/13200./,AO(36)/11000./,AG(36)/5920./
C
      DATA IA(37)/'R'/,IB(37)/'B'/,AR(37)/2.48/,AM(37)/85.47/,
     +AU(37)/14800./,AO(37)/12100./,AG(37)/6520./
C
      DATA IA(38)/'S'/,IB(38)/'R'/,AR(38)/2.15/,AM(38)/87.62/,
     +AU(38)/16500./,AO(38)/13200./,AG(38)/7150./
C
      DATA IA(39)/'Y'/,IB(39)/' '/,AR(39)/1.78/,AM(39)/88.91/,
     +AU(39)/18300./,AO(39)/14300./,AG(39)/7800./
C
      DATA IA(40)/'Z'/,IB(40)/'R'/,AR(40)/1.59/,AM(40)/91.22/,
     +AU(40)/20300./,AO(40)/2470./,AG(40)/8470./
C
      DATA IA(41)/'N'/,IB(41)/'B'/,AR(41)/1.43/,AM(41)/92.91/,
     +AU(41)/22300./,AO(41)/2730./,AG(41)/9220./
C
      DATA IA(42)/'M'/,IB(42)/'O'/,AR(42)/1.36/,AM(42)/95.94/,
     +AU(42)/24600./,AO(42)/3000./,AG(42)/11500./
C
      DATA IA(43)/'T'/,IB(43)/'C'/,AR(43)/1.35/,AM(43)/98.00/,
     +AU(43)/27000./,AO(43)/3320./,AG(43)/10700./
C
      DATA IA(44)/'R'/,IB(44)/'U'/,AR(44)/1.33/,AM(44)/101.07/,
     +AU(44)/29500./,AO(44)/3640./,AG(44)/1920./
C
      DATA IA(45)/'R'/,IB(45)/'H'/,AR(45)/1.35/,AM(45)/102.91/,
     +AU(45)/32300./,AO(45)/3990./,AG(45)/2100./
C
      DATA IA(46)/'P'/,IB(46)/'D'/,AR(46)/1.38/,AM(46)/106.40/,
     +AU(46)/35200./,AO(46)/4360./,AG(46)/2300./
C
      DATA IA(47)/'A'/,IB(47)/'G'/,AR(47)/1.44/,AM(47)/107.87/,
     +AU(47)/38200./,AO(47)/4760./,AG(47)/2510./
C
      DATA IA(48)/'C'/,IB(48)/'D'/,AR(48)/1.49/,AM(48)/112.40/,
     +AU(48)/41500./,AO(48)/5180./,AG(48)/2730./
C
      DATA IA(49)/'I'/,IB(49)/'N'/,AR(49)/1.44/,AM(49)/114.82/,
     +AU(49)/45000./,AO(49)/5630./,AG(49)/2970./
C
      DATA IA(50)/'S'/,IB(50)/'N'/,AR(50)/1.40/,AM(50)/118.69/,
     +AU(50)/48600./,AO(50)/6110./,AG(50)/3230./
C
      DATA IA(51)/'S'/,IB(51)/'B'/,AR(51)/1.41/,AM(51)/121.75/,
     +AU(51)/52500./,AO(51)/6620./,AG(51)/3500./
C
      DATA IA(52)/'T'/,IB(52)/'E'/,AR(52)/1.37/,AM(52)/127.60/,
     +AU(52)/56500./,AO(52)/7160./,AG(52)/3780./
C
      DATA IA(53)/'I'/,IB(53)/' '/,AR(53)/1.33/,AM(53)/126.90/,
     +AU(53)/60700./,AO(53)/7730./,AG(53)/4090./
C
      DATA IA(54)/'X'/,IB(54)/'E'/,AR(54)/1.50/,AM(54)/131.30/,
     +AU(54)/65200./,AO(54)/8340./,AG(54)/4410./
C
      DATA IA(55)/'C'/,IB(55)/'S'/,AR(55)/2.65/,AM(55)/132.91/,
     +AU(55)/70000./,AO(55)/8980./,AG(55)/4750./
C
      DATA IA(56)/'B'/,IB(56)/'A'/,AR(56)/2.17/,AM(56)/137.34/,
     +AU(56)/75000./,AO(56)/9650./,AG(56)/5110./
C
      DATA IA(57)/'L'/,IB(57)/'A'/,AR(57)/1.87/,AM(57)/138.91/,
     +AU(57)/80300./,AO(57)/10400./,AG(57)/5490./
C
      DATA IA(58)/'C'/,IB(58)/'E'/,AR(58)/1.83/,AM(58)/140.12/,
     +AU(58)/85700./,AO(58)/11100./,AG(58)/5880./
C
      DATA IA(59)/'P'/,IB(59)/'R'/,AR(59)/1.82/,AM(59)/140.91/,
     +AU(59)/91200./,AO(59)/11900./,AG(59)/6300./
C
      DATA IA(60)/'N'/,IB(60)/'D'/,AR(60)/1.81/,AM(60)/144.24/,
     +AU(60)/96800./,AO(60)/12700./,AG(60)/6740./
C
      DATA IA(61)/'P'/,IB(61)/'M'/,AR(61)/1.81/,AM(61)/147.00/,
     +AU(61)/102000./,AO(61)/13500./,AG(61)/7200./
C
      DATA IA(62)/'S'/,IB(62)/'M'/,AR(62)/1.80/,AM(62)/150.35/,
     +AU(62)/108000./,AO(62)/14400./,AG(62)/7680./
C
      DATA IA(63)/'E'/,IB(63)/'U'/,AR(63)/2.00/,AM(63)/151.96/,
     +AU(63)/110000./,AO(63)/15400./,AG(63)/8190./
C
      DATA IA(64)/'G'/,IB(64)/'D'/,AR(64)/1.79/,AM(64)/157.25/,
     +AU(64)/105000./,AO(64)/16300./,AG(64)/8720./
C
      DATA IA(65)/'T'/,IB(65)/'B'/,AR(65)/1.76/,AM(65)/158.92/,
     +AU(65)/84700./,AO(65)/17400./,AG(65)/9270./
C
      DATA IA(66)/'D'/,IB(66)/'Y'/,AR(66)/1.75/,AM(66)/162.50/,
     +AU(66)/97700./,AO(66)/18400./,AG(66)/9850./
C
      DATA IA(67)/'H'/,IB(67)/'O'/,AR(67)/1.74/,AM(67)/164.93/,
     +AU(67)/34700./,AO(67)/19500./,AG(67)/10400./
C
      DATA IA(68)/'E'/,IB(68)/'R'/,AR(68)/1.73/,AM(68)/167.26/,
     +AU(68)/36700./,AO(68)/20700./,AG(68)/11100./
C
      DATA IA(69)/'T'/,IB(69)/'M'/,AR(69)/1.72/,AM(69)/168.93/,
     +AU(69)/39300./,AO(69)/21900./,AG(69)/11700./
C
      DATA IA(70)/'Y'/,IB(70)/'B'/,AR(70)/1.94/,AM(70)/173.04/,
     +AU(70)/41000./,AO(70)/23100./,AG(70)/12400./
C
      DATA IA(71)/'L'/,IB(71)/'U'/,AR(71)/1.72/,AM(71)/174.97/,
     +AU(71)/45000./,AO(71)/24400./,AG(71)/13100./
C
      DATA IA(72)/'H'/,IB(72)/'F'/,AR(72)/1.56/,AM(72)/178.49/,
     +AU(72)/46000./,AO(72)/25800./,AG(72)/13900./
C
      DATA IA(73)/'T'/,IB(73)/'A'/,AR(73)/1.43/,AM(73)/180.95/,
     +AU(73)/48500./,AO(73)/27200./,AG(73)/14600./
C
      DATA IA(74)/'W'/,IB(74)/' '/,AR(74)/1.37/,AM(74)/183.85/,
     +AU(74)/51300./,AO(74)/28600./,AG(74)/15400./
C
      DATA IA(75)/'R'/,IB(75)/'E'/,AR(75)/1.37/,AM(75)/186.20/,
     +AU(75)/57200./,AO(75)/30100./,AG(75)/16200./
C
      DATA IA(76)/'O'/,IB(76)/'S'/,AR(76)/1.34/,AM(76)/190.20/,
     +AU(76)/58000./,AO(76)/31600./,AG(76)/17100./
C
      DATA IA(77)/'I'/,IB(77)/'R'/,AR(77)/1.36/,AM(77)/192.20/,
     +AU(77)/62400./,AO(77)/33100./,AG(77)/18000./
C
      DATA IA(78)/'P'/,IB(78)/'T'/,AR(78)/1.37/,AM(78)/195.09/,
     +AU(78)/63400./,AO(78)/34800./,AG(78)/18900./
C
      DATA IA(79)/'A'/,IB(79)/'U'/,AR(79)/1.44/,AM(79)/196.9655/,
     +AU(79)/66900./,AO(79)/36500./,AG(79)/19900./
C
      DATA IA(80)/'H'/,IB(80)/'G'/,AR(80)/1.50/,AM(80)/200.59/,
     +AU(80)/66800./,AO(80)/38200./,AG(80)/20900./
C
      DATA IA(81)/'T'/,IB(81)/'L'/,AR(81)/1.64/,AM(81)/204.37/,
     +AU(81)/75400./,AO(81)/40100./,AG(81)/21900./
C
      DATA IA(82)/'P'/,IB(82)/'B'/,AR(82)/1.60/,AM(82)/207.19/,
     +AU(82)/79800./,AO(82)/41900./,AG(82)/22900./
C
      DATA IA(83)/'B'/,IB(83)/'I'/,AR(83)/1.60/,AM(83)/208.98/,
     +AU(83)/84300./,AO(83)/43800./,AG(83)/24000./
C
      DATA IA(84)/'P'/,IB(84)/'O'/,AR(84)/1.60/,AM(84)/210.00/,
     +AU(84)/88100./,AO(84)/45800./,AG(84)/25100./
C
      DATA IA(85)/'A'/,IB(85)/'T'/,AR(85)/1.60/,AM(85)/210.00/,
     +AU(85)/86500./,AO(85)/40700./,AG(85)/26200./
C
      DATA IA(86)/'R'/,IB(86)/'N'/,AR(86)/1.80/,AM(86)/222.00/,
     +AU(86)/97200./,AO(86)/39800./,AG(86)/27300./
C
      DATA IA(87)/'F'/,IB(87)/'R'/,AR(87)/2.80/,AM(87)/223.00/,
     +AU(87)/102000./,AO(87)/32200./,AG(87)/28500./
C
      DATA IA(88)/'R'/,IB(88)/'A'/,AR(88)/2.20/,AM(88)/226.00/,
     +AU(88)/102000./,AO(88)/33000./,AG(88)/29800./
C
      DATA IA(89)/'A'/,IB(89)/'C'/,AR(89)/1.90/,AM(89)/227.00/,
     +AU(89)/143000./,AO(89)/54000./,AG(89)/31100./
C
      DATA IA(90)/'T'/,IB(90)/'H'/,AR(90)/1.85/,AM(90)/232.04/,
     +AU(90)/118000./,AO(90)/37000./,AG(90)/32300./
C
      DATA IA(91)/'P'/,IB(91)/'A'/,AR(91)/1.80/,AM(91)/231.00/,
     +AU(91)/106000./,AO(91)/38700./,AG(91)/34200./
C
      DATA IA(92)/'U'/,IB(92)/' '/,AR(92)/1.80/,AM(92)/238.03/,
     +AU(92)/112000./,AO(92)/40300./,AG(92)/35000./
C
      DATA IA(93)/'N'/,IB(93)/'P'/,AR(93)/1.80/,AM(93)/237.00/,
     +AU(93)/123000./,AO(93)/25700./,AG(93)/29900./
C
      DATA IA(94)/'P'/,IB(94)/'U'/,AR(94)/1.80/,AM(94)/242.00/,
     +AU(94)/113000./,AO(94)/16200./,AG(94)/22700./
C
C Commands
C
      DATA KC/'ZERR','TITL','CELL','LATT','SYMM','SFAC','UNIT',
     +'OMIT','REM ','ESEL','FMAP','GRID','MOLE','SPIN','FRAG',
     +'TREF','TEXP','HKLF','PHAS','MOVE','PATT','END ','TIME',
     +'PHAN','PSEE','LIST','MORE','FVAR','SHEL','VLEN','WGHT',
     +'    ','EXTI','VOID','AFIX','SPEC','EQIV','HFIX','BASF',
     +'EGEN','INIT','PLAN','TEMP','SIZE','XHAB','SPAG','VECT'/
C
   1  FORMAT(80A1)
   2  FORMAT(1X,80A1)
   3  FORMAT(/' V =',F12.2,5X,'At vol =',F8.1,5X,'F(000) =',F10.1,
     +5X,'mu =',F7.2,' mm-1'//' Max single Patterson vector =',
     +F6.1,'    cell wt =',F10.2,'    rho =',F7.3/)
   4  FORMAT('     ** Macromolecular delta-F data assumed for ',
     +'setting defaults **'/)
   5  FORMAT(/' ** WARNING - IT WOULD BE BETTER TO INPUT ',
     +'F-SQUARED THAN F SO'/' ** THAT ZERO AND NEGATIVE ',
     +'INTENSITIES ARE TREATED CORRECTLY')
   6  FORMAT(/' ** HKLF MATRIX CHANGES HAND OF AXES')
   7  FORMAT('FMAP 5',A1/'PLAN',I5,A1/'HKLF -3',A1)
C
      WRITE(*,'(A)')' Read instructions and process reflection data'
      CALL SXFL
C
C Default parameters
C
        DO 8 I=1,22
        IH(I)=IG(I)
   8    CONTINUE
        DO 9 I=1,80
        HK(I)=IG(20)
   9    CONTINUE
      IX=-1
      IQ=-1
      IU=-1
      IV=-1
      IW=-1
      IY=0
      KG=0
      LX=25
      LL=1
      LZ=0
      LQ=0
      LY=75
      LJ=0
      LW=0
      MV=0
      NF=127
      FG=.1
      PM=0.
      HS=0.
        DO 10 I=1,76
        IT(I)=IH(20)
  10    CONTINUE
        DO 11 I=1,86
        A(I)=0.
  11    CONTINUE
      A(14)=1.
      A(16)=1.
      A(19)=1.
      A(26)=1.2
      A(27)=5.
      A(28)=.005
      A(29)=.7
      A(30)=-9.E9
      A(32)=1.5
        DO 12 I=33,35
        A(I)=-2.
        A(I+3)=2.
  12    CONTINUE
      A(52)=2.
      A(53)=1.
      A(56)=28.
      A(58)=.5
      A(59)=1.5
      A(64)=1.
      A(65)=15.
      A(70)=1.
      A(75)=1.
      A(79)=1.
      A(83)=1.
        DO 13 I=121,123
        F(I)=1.
        F(I+3)=0.
  13    CONTINUE
      F(127)=1.
C
C Read instruction
C
  14  READ(LR,1)IR
      IF(IR(1).EQ.IH(13))CALL SXER('+file NOT ALLOWED')
      KR='    '
        DO 15 KB=1,4
        IF(IR(KB).LT.IH(20))IR(KB)=IH(20)
        KK=IR(KB)
        IF(KK.EQ.IH(20))GOTO 16
        IF(KK.EQ.KU)GOTO 19
        IF(KK.EQ.KJ)GOTO 16
        CALL SXUC(KK)
        KR(KB:KB)=KK
  15    CONTINUE
      KB=5
  16  JR=KB-1
      IF(JR.EQ.0)JR=1
      KE=80
        DO 17 I=KB,80
        IF(IR(I).LT.IH(20))IR(I)=IH(20)
        IF(IR(I).EQ.KJ)KE=MIN0(KE,I-1)
        IF(IR(I).NE.IH(20))JR=I
  17    CONTINUE
      WRITE(LI,2)(IR(I),I=1,JR)
      CALL SXPS(A(LX),KR)
        DO 18 NK=1,46
        IF(KR.EQ.KC(NK))GOTO 20
  18    CONTINUE
      NK=1
      GOTO 22
  19  CALL SXER('RESIDUES NOT ALLOWED')
  20  IF(NK.LT.10)WRITE(LP,1)(IR(I),I=1,JR),KD
      IF(NK.EQ.9)GOTO 14
      IF(NK.GT.42)WRITE(LP,1)(IR(I),I=1,JR),KD
      IF(NK.EQ.32)GOTO 14
      IF(NK.EQ.1)GOTO 14
      IF(NK.NE.2)GOTO 22
        DO 21 I=1,76
        IT(I)=IR(I+4)
  21    CONTINUE
      GOTO 14
C
C Decode instruction
C
  22  NA=0
        DO 23 I=KB,KE
        CALL SXUC(IR(I))
  23    CONTINUE
      CALL SXZA(G,126)
      JD=0
      KS=KC(32)
      KS(1:1)=IH(14)
      NJ=LY+7
      L=LY+21
      N=KB-1
      IF(NK.EQ.5)CALL SXZA(A(LY+12),12)
  24  W=1.
  25  V=0.
      NB=0
      Y=1.
      U=10.
      Z=1.
      X=0.
      GOTO 27
  26  Z=Y*Z
      V=U*ABS(V)+Z*X
      NB=1
      IF(ABS(V).LT.1.E-8)GOTO 27
      V=SIGN(V,W)
      W=V
  27  N=N+1
      K=11
      IF(N.GT.KE)GOTO 30
      X=0.
        DO 28 K=1,19
        IF(IR(N).EQ.IH(K))GOTO 29
        X=X+1.
  28    CONTINUE
      K=1
      GOTO 30
  29  IF(K.LT.11)GOTO 26
      K=K-9
  30  IF(NK.NE.5)GOTO 44
C
C SYMM
C
      IF(K.NE.10)GOTO 34
      IF(ABS(V).LT.1.E-8)GOTO 50
      N=N+1
      IF(N.GT.KE)GOTO 50
        DO 31 I=2,7
        IF(IH(I).EQ.IR(N))GOTO 32
  31    CONTINUE
      GOTO 50
  32  V=V/REAL(I-1)
      W=V
      IF(N.EQ.KE)GOTO 27
        DO 33 I=1,10
        IF(IH(I).EQ.IR(N+1))GOTO 50
  33    CONTINUE
      GOTO 27
  34  IF(K.EQ.9)GOTO 39
      IF(K.GT.7)GOTO 37
      IF(K.GT.4)GOTO 36
      IF(K.GT.2)GOTO 46
      IF(K.EQ.1)GOTO 27
  35  U=1.
      Y=.1
      GOTO 27
  36  K=K+NJ
      A(K)=W
      GOTO 24
  37  A(L)=A(L)+AINT(24.5*V)/24.
      L=L+1
      NJ=NJ+3
      IF(NJ+8.LT.L)GOTO 24
      LY=LY+12
      IF(LZ.EQ.0)GOTO 14
  38  CALL SXER('INSTRUCTIONS IN WRONG ORDER')
C
C Continuation lines and errors
C
  39  IF(NK.EQ.5)GOTO 40
      IF(NK.NE.6)GOTO 41
      IF(NA.GT.0)GOTO 41
  40  CALL SXER('CONTINUATION LINE NOT ALLOWED HERE')
  41  READ(LR,1)IR
      JR=1
      KE=80
        DO 42 I=2,80
        IF(IR(I).LT.IH(20))IR(I)=IH(20)
        IF(IR(I).EQ.KJ)KE=MIN0(KE,I-1)
        IF(IR(I).NE.IH(20))JR=I
  42    CONTINUE
      IF(KE.GT.JR)KE=JR
      WRITE(LI,2)(IR(I),I=1,JR)
      IF(IABS(NK-5).LT.4)WRITE(LP,1)(IR(I),I=1,JR),KD
      IF(NK.GT.42)WRITE(LP,1)(IR(I),I=1,JR),KD
        DO 43 I=1,KE
        CALL SXUC(IR(I))
  43    CONTINUE
      N=1
      IF(IR(1).EQ.IH(20))GOTO 24
      CALL SXER('BAD CONTINUATION LINE')
  44  IF(K.EQ.2)GOTO 35
      IF(NB.EQ.0)GOTO 48
      NA=NA+1
      IF(NA.GT.126)GOTO 50
      G(NA)=V
  45  IF(K.LT.9)GOTO 47
      IF(K.GT.9)GOTO 52
      GOTO 39
  46  A(L)=AINT(24.5*V)/24.
  47  IF(K.NE.3)GOTO 24
      W=-1.
      GOTO 25
  48  IF(K.EQ.1)K=6
      IF(IABS(K-6).GT.1)GOTO 45
      IF(IR(N).EQ.IH(20))GOTO 45
      JD=JD+1
        DO 49 K=1,4
        IF(N.GT.JR)GOTO 24
        IF(IR(N).EQ.IH(17))GOTO 24
        IF(IR(N).EQ.IH(18))GOTO 41
        IF(IR(N).EQ.IH(19))GOTO 52
        IF(IR(N).EQ.IH(20))GOTO 24
        IF(JD.EQ.1)KS(K:K)=IR(N)
        N=N+1
  49    CONTINUE
      GOTO 24
C
C CELL
C
  50  CALL SXER('WRONG NUMBER OF PARAMETERS')
  51  CALL SXER('ILLEGAL PARAMETER VALUE')
  52  IF(NK.GT.42)GOTO 14
      IF(NK.GT.39)GOTO 116
      IF(NK.GT.28)GOTO 14
      IF(NK.NE.3)GOTO 56
      IF(NA.NE.7)GOTO 50
        DO 53 J=1,7
        IF(.01.GT.G(J))GOTO 51
        A(J)=G(J)
  53    CONTINUE
      U=2.*A(2)*A(3)*A(4)
        DO 54 J=2,4
        X=1.74533E-2*A(J+3)
        G(J)=COS(X)
        G(J+3)=SIN(X)
        A(J+9)=U*G(J)/A(J)
        A(J+6)=A(J)*A(J)
  54    CONTINUE
      X=(G(2)*G(3)-G(4))/(G(5)*G(6))
      Y=SQRT(ABS(1.-X*X))
      A(46)=1./(A(2)*G(6)*Y)
      A(48)=1./(A(3)*G(5))
      A(47)=X*A(48)/Y
      A(49)=(-G(6)*G(2)*X-G(5)*G(3))/(A(4)*G(5)*G(6)*Y)
      A(51)=1./A(4)
      A(50)=-G(2)*A(51)/G(5)
      A(60)=1./(A(46)*A(48)*A(51))
      GOTO 14
C
C LATT
C
  55  CALL SXER('REPEATED OR MUTUALLY EXCLUSIVE INSTRUCTIONS')
  56  IF(NK.NE.4)GOTO 57
      IF(G(1).LT.0.)A(23)=1.
      IF(LL.NE.1)GOTO 55
      LL=INT(.5+ABS(G(1)))
      IF(LL.EQ.0)GOTO 51
      IF(LL.LT.8)GOTO 14
      GOTO 51
  57  IF(NK.NE.6)GOTO 80
      IF(LX.NE.25)GOTO 38
      IF(LL.GT.75)GOTO 73
      N=3*LL
      L=INT(4.1-2.*A(23))
        DO 58 I=4,12
        F(I)=.5
  58    CONTINUE
      CALL SXZA(F,3)
      IF(N.LT.12)GOTO 60
      IF(N.GT.12)GOTO 62
        DO 59 I=4,12,4
        F(I)=0.
  59    CONTINUE
  60  IF(N.NE.9)GOTO 63
        DO 61 I=4,9
        F(I)=.6666667
  61    CONTINUE
      F(5)=.3333333
      F(6)=.3333333
      F(7)=.3333333
      GOTO 63
  62  F(LL-1)=0.
      N=4
  63  LL=LY+8
        DO 65 K=2,L,2
          DO 64 J=1,N,3
          LL=LL+4
          A(LL)=3.-REAL(K)
          A(LL+1)=F(J)+99.5
          A(LL+2)=F(J+1)+99.5
          A(LL+3)=F(J+2)+99.5
  64      CONTINUE
  65    CONTINUE
      LQ=LL-1
      F(1)=1.1
C
C Check LATT/SYMM
C
      IF(A(1).LT.0.001)GOTO 51
      M=LY+12
      N=LQ+2
        DO 67 K=75,LY,12
        CALL SXCC
        IF(ABS(ABS(A(K)*(A(K+4)*A(K+8)-A(K+5)*A(K+7))+A(K+1)*
     +  (A(K+5)*A(K+6)-A(K+3)*A(K+8))+A(K+2)*(A(K+3)*A(K+7)-
     +  A(K+4)*A(K+6)))-1.).GT.0.01)CALL SXER('BAD SYMM')
          DO 66 L=M,LL,4
          N=N+3
          A(N)=AMOD(A(L)*(.143*A(K)+.277*A(K+1)+
     +    .811*A(K+2)+A(K+9))+A(L+1)+.5,1.)
          A(N+1)=AMOD(A(L)*(.143*A(K+3)+.277*A(K+4)+
     +    .811*A(K+5)+A(K+10))+A(L+2)+.5,1.)
          A(N+2)=AMOD(A(L)*(.143*A(K+6)+.277*A(K+7)+
     +    .811*A(K+8)+A(K+11))+A(L+3)+.5,1.)
  66      CONTINUE
  67    CONTINUE
        DO 72 K=75,LY,12
          DO 71 L=M,LL,4
          CALL SXCC
          I=LQ+2
  68      I=I+3
          IF(I.GT.N)GOTO 71
          X=AMOD(A(L)*(A(I)*A(K)+A(I+1)*A(K+1)+
     +    A(I+2)*A(K+2)+A(K+9))+A(L+1)+.5,1.)
          Y=AMOD(A(L)*(A(I)*A(K+3)+A(I+1)*A(K+4)+
     +    A(I+2)*A(K+5)+A(K+10))+A(L+2)+.5,1.)
          Z=AMOD(A(L)*(A(I)*A(K+6)+A(I+1)*A(K+7)+
     +    A(I+2)*A(K+8)+A(K+11))+A(L+3)+.5,1.)
          NB=0
          J=LQ+2
  69      J=J+3
          IF(J.GT.N)GOTO 70
          IF(ABS(X-A(J))+ABS(Y-A(J+1))+ABS(Z-A(J+2)).LT.0.001)NB=NB+1
          GOTO 69
  70      IF(NB.EQ.1)GOTO 68
          CALL SXER('INCONSISTENT LATT/SYMM')
  71      CONTINUE
  72    CONTINUE
C
C SFAC
C
  73  IF(NA.GT.0)GOTO 77
      K=4
  74  K=K+1
      IF(K.GT.79)GOTO 14
      IF(IR(K).EQ.IH(19))GOTO 14
      IF(IR(K).EQ.IH(20))GOTO 74
      IF(IR(K).EQ.IH(18))GOTO 40
        DO 75 J=1,94
        IF(IR(K).NE.IA(J))GOTO 75
        IF(IR(K+1).EQ.IB(J))GOTO 76
  75    CONTINUE
      CALL SXER('UNKNOWN ELEMENT FOR SFAC')
  76  LQ=LQ+5
      A(LQ)=REAL(J)
      A(LQ+1)=AR(J)
      LZ=LZ+1
      KS=IA(J)//IB(J)//IH(20)//IH(20)
      CALL SXPS(A(LQ+2),KS)
      A(LQ+3)=AU(J)
      IF(A(1).LT.1.)A(LQ+3)=AO(J)
      IF(A(1).LT.0.6)A(LQ+3)=AG(J)
      A(LQ+4)=AM(J)
      K=K+1
      GOTO 74
  77  LQ=LQ+5
      IF(NA.NE.5)GOTO 78
      NA=14
      A(LQ)=G(1)
      A(LQ+1)=G(4)
      A(LQ+3)=G(3)
      A(LQ+4)=G(5)
      GOTO 79
  78  A(LQ)=AINT(.5+G(1)+G(3)+G(5)+G(7)+G(9))
      A(LQ+1)=G(13)
      A(LQ+3)=G(12)
      A(LQ+4)=G(14)
  79  LZ=LZ+1
      CALL SXPS(A(LQ+2),KS)
      IF(NA.EQ.14)GOTO 14
      GOTO 50
C
C END
C
  80  IF(NK.NE.22)GOTO 81
      IF(NA.EQ.0)GOTO 129
      LR=INT(G(1))
      IF(LR.LT.0)GOTO 51
      IF(LR.EQ.LH)GOTO 51
      IF(LR.EQ.LI)GOTO 51
      IF(LR.EQ.LP)GOTO 51
      IF(LR.EQ.LF)GOTO 51
      IF(LR.EQ.LA)GOTO 51
      IF(LR.EQ.LB)GOTO 51
      IF(LR.EQ.LG)GOTO 51
      IF(NA.EQ.1)GOTO 14
      GOTO 50
C
C UNIT
C
  81  IF(NK.NE.7)GOTO 86
      IF(NA.NE.LZ)GOTO 50
      J=LL+4
      LE=LQ+3
      LX=LQ+5
      U=0.
      V=0.
      P=0.
      Q=0.
      R=0.
      Z=0.
      Y=0.
        DO 82 I=1,NA
        IF(A(J).GT.1.5)Z=Z+G(I)
        W=A(J)*G(I)
        P=P+W
        Q=Q+A(J+4)*G(I)
        A(J+4)=G(I)
        R=R+A(J+3)*G(I)
        HS=AMAX1(HS,A(J)*A(J))
        U=U+W*A(J)
        V=V+W*A(J)*A(J)
        Y=Y+W*SQRT(ABS(A(J)))
        J=J+5
  82    CONTINUE
      IF(U.LE.0.)GOTO 51
      T=Q*1.66052/A(60)
      R=R*.1/A(60)
      PM=HS*999.1/U
      W=0.
      IF(Z.GT.0.)W=A(60)/Z
      X=REAL(LL-LY-8)
      WRITE(LI,3)A(60),W,P,R,PM,Q,T
      A(24)=SQRT(ABS(.25*X/U))
C
C Default parameters for direct and Patterson methods
C
      IF(LY.EQ.75)A(26)=1.
      FD=8.
      T=(2.-A(23))/X
      A(45)=V/(U*SQRT(ABS(T*U)))
      PY=Y**2/(T*P**3)
      PX=16.*(200.+A(60)/X)
      X=PX/REAL(LY-63)
      FF=AINT(AMIN1(X,150.+.7*X))
      T=0.
      X=A(23)
      Y=A(23)
      Z=A(23)
        DO 83 K=75,LY,12
        IF(A(K).LT.-.5)X=0.
        IF(A(K+4).LT.-.5)Y=0.
        IF(A(K+8).LT.-.5)Z=0.
        IF(ABS(A(K+9))+ABS(A(K+10))+ABS(A(K+11)).GT.0.1)T=T+1.
  83    CONTINUE
      Q=.05*A(23)
      GG=.9-Q
      IF(X+Y+Z.GT.0.5)GG=GG-Q
      IF(LY.EQ.75)GG=Q-GG
      A(43)=10.1
      A(71)=.4-2.*Q
      T=30.-10.*AMIN1(T,1.)
      A(41)=2.01+A(23)
      A(42)=AMAX1(-.95+.2*A(23),AMIN1(-.2,-T*PY*(2.-A(23))))
      A(44)=.9
      A(67)=7.12+AINT(.02*FF)
      A(68)=.8
      A(69)=16.2
      IF(LY.EQ.75)A(69)=8.2
      A(72)=AINT(30.+.5*FF)+.1
      IF(LY.LT.88)A(72)=A(72)+FF*A(23)*REAL(99-LY)/120.
      IF(A(72).GT.FF)A(72)=FF
      A(73)=40.1
      A(74)=10.1
      ZA=4.
      ZG=0.
      Y=0.
      Z=0.0001
      I=LL-1
  84  I=I+5
      IF(I.GT.LQ)GOTO 85
      IF(ZG.LT.0.2*A(I))ZG=.2*A(I)
      IF(A(I).LT.10.)GOTO 84
      Y=Y+400.
      Z=Z+A(I)
      ZA=ZA+AMAX1(2.,AINT(A(I+4)*48./REAL((LL-LY-8)*(LY-63))))
      GOTO 84
  85  ZF=AMIN1(500.,AMAX1(100.,AINT(SQRT(Y*A(60)/Z))),
     +AINT(.1*REAL(LM-2000)/(REAL(LL-LY-12)/(8.-4.*A(23))+2.)))
      ZX=1.8
      IF(ZA.LT.8.)ZA=8.
      IF(ZA.GT.20.)ZA=20.
      IF(ZG.GT.7.)ZG=7.
      ZH=0.
      PA=1.1
      IF(W*A(23).LT.100.)GOTO 14
      IF(A(60).LT.1000.*REAL(LL-LY-8))GOTO 14
      IY=1
      WRITE(LI,4)
      FD=7.
      A(27)=2.5
      A(28)=0.
      A(41)=-2.01
      A(42)=0.25
      A(52)=0.5
      A(67)=20.12
      A(72)=300.1
      FF=500.1
      ZX=-AMAX1(8.,0.3*AMIN1(A(2),A(3),A(4)))
      ZF=AMIN1(500.,180.+5.*REAL(LY-63))
      ZH=20.1
      PA=4.1
      GOTO 14
C
C PHAS
C
  86  IF(NK.NE.19)GOTO 87
      IF(LX.EQ.25)GOTO 38
      IF(LX.NE.LE+2)GOTO 38
      LE=LE+2
      A(LE)=ABS(G(1)+200.*(G(2)+200.*G(3)))
      A(LE+1)=G(4)
      LX=LE+2
      IF(NA.EQ.4)GOTO 14
      GOTO 50
C
C OMIT
C
  87  IF(NK.NE.8)GOTO 89
      IF(NA.EQ.3)GOTO 88
      A(52)=.5*ABS(G(1))
      IF(NA.EQ.2)A(53)=SIGN((SIN(8.726646E-3*G(2)))**2,G(2))
      IF(NA.LE.2)GOTO 14
      GOTO 50
  88  IF(F(1).GT.119.5)CALL SXER('TOO MANY OMIT REFLECTIONS')
      F(1)=F(1)+1.
      I=INT(F(1))
      F(I)=G(1)+200.*(G(2)+200.*G(3))
      GOTO 14
C
C SPIN
C
  89  IF(NK.NE.14)GOTO 91
        DO 90 I=1,3
        F(I+120)=COS(G(I))
        F(I+123)=SIN(G(I))
  90    CONTINUE
      A(60)=-ABS(A(60))
      IF(NA.EQ.3)GOTO 14
      GOTO 50
C
C FRAG
C
  91  IF(NK.NE.15)GOTO 95
      KG=1
      IF(NA.LT.2)GOTO 93
        DO 92 I=2,4
        IF(G(I).LT.0.1)GOTO 51
        X=1.74533E-2*G(I+3)
        G(I+3)=COS(X)
        IF(G(I+3).GT.0.99)GOTO 51
        G(I+6)=SIN(X)
  92    CONTINUE
      X=(G(5)*G(6)-G(7))/(G(8)*G(9))
      Y=SQRT(ABS(1.-X*X))
      A(14)=1./(G(2)*G(9)*Y)
      A(16)=1./(G(3)*G(8))
      A(15)=A(16)*X/Y
      A(17)=(-G(9)*G(5)*X-G(8)*G(6))/(G(4)*G(8)*G(9)*Y)
      A(19)=1./G(4)
      A(18)=-G(5)*A(19)/G(8)
      IF(NA.EQ.7)GOTO 14
      GOTO 50
  93    DO 94 I=14,19
        A(I)=0.
  94    CONTINUE
      A(14)=1.
      A(16)=1.
      A(19)=1.
      GOTO 14
C
C TIME
C
  95  IF(NK.NE.23)GOTO 96
      IF(NA.GT.0)TL=AMIN1(TL,G(1))
      GOTO 14
C
C ESEL
C
  96  IF(NK.NE.10)GOTO 100
      IF(NA.EQ.0)G(1)=1.2
      G(4)=G(4)+10.*AINT(G(5))
      IF(NA.GT.4)NA=4
      IF(G(5).LT.0.)GOTO 51
      IF(G(5).GT.3.1)GOTO 51
      J=26
      IF(G(1).GE.0.)GOTO 97
      GG=-.75
      IF(IU.LT.3)A(22)=GG
      FF=AINT(AMIN1(PX/12.,150.+PX/24.))
      IF(IQ.LT.1)A(67)=7.12+AINT(.02*FF)
      IF(IV.LT.3)A(71)=.3
      IF(IY.NE.0)GOTO 97
      IF(IV.LT.4)A(72)=AMIN1(FF,AINT(30.+.7*FF)+.1)
      IF(IU.LT.4)A(41)=3.01
      IF(IU.LT.5)A(42)=AMAX1(-.75,AMIN1(-.2,-30.*PY))
  97  K=4
  98  IF(NA.LT.1)NA=1
        DO 99 I=1,NA
        A(J)=G(I)
        J=J+1
  99    CONTINUE
      IF(K.GE.NA)GOTO 14
      GOTO 50
C
C PHAN
C
 100  IF(NK.NE.24)GOTO 103
      IF(NA.LT.1)G(1)=A(43)
      IF(NA.LT.2)G(2)=A(44)
      IF(G(2).GT.1.)G(2)=1.
      IF(G(2).LT.0.)G(2)=0.
      IF(G(3).GT.1.)G(3)=1.
      IF(G(3).LT.0.)G(3)=0.
      IF(NA.LT.4)GOTO 101
      IF(ABS(G(4)).LT.1.)GOTO 51
      IF(NA.LT.5)GOTO 101
      IF(ABS(G(5)).LT.1.)GOTO 51
 101  A(43)=G(1)
      A(44)=G(2)
      IV=NA
      IF(NA.LE.2)GOTO 14
      J=71
        DO 102 I=3,NA
        A(J)=G(I)
        J=J+1
 102    CONTINUE
      GOTO 14
C
C FMAP
C
 103  IF(NK.NE.11)GOTO 105
      J=54
      G(1)=ABS(G(1))
 104  K=3
      GOTO 98
C
C GRID
C
 105  IF(NK.NE.12)GOTO 106
      J=33
      K=6
      GOTO 98
C
C MOLE
C
 106  IF(NK.NE.13)GOTO 107
      FG=.1+AMIN1(ABS(G(1)),99.)
      GOTO 14
C
C PATT
C
 107  IF(NK.NE.21)GOTO 108
      IF(ABS(A(21)).GT.0.01)GOTO 55
      IF(ABS(A(39)).GT.0.01)GOTO 55
      IF(NA.EQ.0)G(1)=PA
      A(21)=G(1)
      IF(ABS(A(21)).LT.0.99)GOTO 51
      IW=NA
      IF(NA.LT.2)G(2)=ZX
      IF(NA.LT.4)G(4)=ZF
      IF(NA.LT.5)G(5)=ZG
      IF(NA.LT.6)G(6)=ZA
      A(22)=AINT(ABS(G(4)))+.01*AMIN1(ABS(G(2)),99.)
      IF(G(2).LT.0.)A(22)=-A(22)
      A(42)=G(3)
      A(20)=AINT(ABS(G(6)))+.01*AMIN1(ABS(G(5)),99.)
      GOTO 14
C
C LIST
C
 108  IF(NK.NE.26)GOTO 109
      IF(G(1).LT.2.5)LW=INT(G(1))
      IF(LW.LT.0)GOTO 51
      IF(G(1).GT.2.5)LJ=INT(G(1))
      IF(LJ.GT.4)GOTO 51
      GOTO 14
C
C PSEE
C
 109  IF(NK.NE.25)GOTO 110
      IF(ABS(A(21)).GT.0.01)GOTO 55
      IF(ABS(A(39)).GT.0.01)GOTO 55
      A(20)=-9.E9
      IF(NA.EQ.0)G(1)=200.
      A(21)=G(1)
      IF(ABS(A(21)).LT.0.99)GOTO 51
      A(22)=SIN(8.726646E-3*G(2))
      IF(NA.LT.2)A(22)=.5*A(1)
      GOTO 14
C
C TREF
C
 110  IF(NK.NE.16)GOTO 111
      T=256.01
      IF(LY.EQ.75)T=T*(4.-3.*A(23))
      IF(NA.EQ.0)G(1)=T
      A(22)=GG
      IF(NA.GT.2)A(22)=G(3)
      IF(ABS(A(22)).LT.0.2)GOTO 51
      IF(ABS(A(22)).GT.5.)GOTO 51
      G(3)=G(4)
      G(4)=G(5)
      IU=NA
      NA=MAX0(2,NA-1)
      J=39
      IF(ABS(A(21)).GT.0.01)GOTO 55
      GOTO 97
C
C TEXP
C
 111  IF(NK.NE.17)GOTO 112
      IX=NA
      IF(NA.EQ.0)G(1)=0.6*FF
      J=30
      GOTO 104
C
C MOVE
C
 112  IF(NK.NE.20)GOTO 113
      A(64)=1.
      J=61
      GOTO 97
C
C MORE
C
 113  IF(NK.NE.27)GOTO 114
      A(70)=ABS(G(1))+.1
      IF(NA.LT.1)A(70)=1.1
      IF(NA.GT.1)GOTO 50
      GOTO 14
C
C FVAR
C
 114  IF(NK.NE.28)GOTO 119
      K=1
      IF(NF.EQ.127)K=2
      IF(NA.LT.K)GOTO 14
        DO 115 J=K,NA
        NF=NF+1
        IF(NF.GT.LU)CALL SXER('TOO MANY FVAR PARAMETERS')
        F(NF)=G(J)
 115    CONTINUE
      GOTO 14
C
C EGEN
C
 116  IF(NK.NE.40)GOTO 117
      A(65)=AMIN1(G(1),G(2))
      A(66)=AMAX1(G(1),G(2))
      GOTO 14
C
C PLAN
C
 117  IF(NK.NE.42)GOTO 118
      J=57
      GOTO 104
C
C INIT
C
 118  IF(NK.NE.41)GOTO 119
      IF(NA.LT.5)G(5)=.2
      IF(NA.LT.4)G(4)=.2
      G(4)=AMIN1(G(4),.5)
      IF(NA.LT.3)G(3)=.8
      G(3)=AMAX1(G(3),.5)
      IF(NA.LT.2)G(2)=A(69)
      G(2)=AINT(ABS(G(2)))
      IF(NA.EQ.0)G(1)=AINT(A(67))
      A(67)=AINT(ABS(G(1))+.1)+.1*AMIN1(1.,AMAX1(0.,G(5)))+.1
      A(68)=G(3)
      A(69)=G(2)+G(4)
      IQ=NA
      GOTO 14
C
C Atoms and VECT
C
 119  IF(NK.NE.1)GOTO 129
      IF(LX.EQ.25)GOTO 38
      CALL SXUS(A(LX),KR)
      IF(KR.NE.KC(47))GOTO 123
      IF(NA.NE.3)GOTO 50
      IF(MV.LT.0)GOTO 55
      I=LX
 120  I=I-8
      IF(I.LT.LE)GOTO 122
      CALL SXUS(A(I+1),KR)
      CALL SXPS(A(I+9),KR)
        DO 121 K=I+2,I+7
        A(K+8)=A(K)
 121    CONTINUE
      GOTO 120
 122  MV=MV+1
      CALL SXPN(A(I+9),MV)
      A(I+10)=G(1)
      A(I+11)=G(2)
      A(I+12)=G(3)
      A(I+13)=-9.E9
      A(I+14)=-1.
      A(I+15)=0.
      LX=LX+8
      GOTO 14
 123  IF(MV.GT.0)GOTO 55
      MV=-1
      A(LX+1)=FG+1000.*G(1)
      J=INT(ABS(G(1)))
      IF(J.LT.1)GOTO 51
      IF(J.GT.LZ)GOTO 51
      LX=LX+2
      IF(KG.EQ.0)GOTO 125
      IF(A(60).GT.0.)CALL SXER('SPIN MISSING')
      G(2)=G(2)/A(14)
      G(3)=(G(3)-G(2)*A(15))/A(16)
      G(4)=(G(4)-G(2)*A(17)-G(3)*A(18))/A(19)
      J=2
      K=3
        DO 124 I=121,123
        J=J+1
        IF(J.GT.4)J=J-3
        K=K+1
        IF(K.GT.4)K=K-3
        W=G(J)
        G(J)=W*F(I)-G(K)*F(I+3)
        G(K)=W*F(I+3)+G(K)*F(I)
 124    CONTINUE
      G(4)=G(2)*A(49)+G(3)*A(50)+G(4)*A(51)
      G(3)=G(2)*A(47)+G(3)*A(48)
      G(2)=G(2)*A(46)
 125  IF(NA.LT.5)G(5)=1.
      K=2
      IF(KG.NE.0)K=5
        DO 126 J=K,5
        M=MAX0(127,INT(ABS(G(J)*.1)+126.5))
        IF(M.GT.NF)GOTO 51
        Q=SIGN(.5,G(J)+5.)
        P=AMOD(G(J)+5.,10.)-10.*Q
        G(J)=P*(Q+AMOD(F(M)+5.,10.)-5.5)
 126    CONTINUE
        DO 127 J=2,4
        G(J)=A(64)*G(J)+A(J+59)
 127    CONTINUE
        DO 128 J=2,7
        A(LX)=G(J)
        LX=LX+1
 128    CONTINUE
      IF(NA.LT.4)GOTO 50
      IF(NA.EQ.11)GOTO 14
      IF(NA.GT.7)GOTO 50
      GOTO 14
C
C HKLF or end of instructions
C
 129  IF(LX.EQ.25)GOTO 38
      IF(MV.LT.1)GOTO 130
      IF(ABS(A(21)).GT.0.01)GOTO 130
      IF(ABS(A(39)).GT.0.01)GOTO 55
      A(21)=1.
      A(22)=SIGN(ZF+.01*ABS(ZX),ZX)
      A(42)=0.
      A(20)=ZA+.01*ZG
 130  A(60)=ABS(A(60))
      IF(G(1).LT.0.1)LH=LR
      K=IABS(INT(G(1)))
      IF(K.GT.7)GOTO 51
      IF(K.EQ.6)GOTO 51
      IF(G(1).LT.-.5)GOTO 132
        DO 131 I=1,79
        HK(I)=IR(I)
 131    CONTINUE
      HK(80)=KD
 132  IF(IX.EQ.0)A(30)=0.6*FF
      IF(IU.LT.2)A(40)=FF
      IF(A(26).GE.0.)GOTO 133
      IF(IW.LT.0)GOTO 133
      IF(IW.LT.5)A(20)=AMAX1(A(20),AMOD(A(20),1.)+16.)
 133  A(54)=ABS(A(54))
      J=INT(A(54))
      IF(IABS(J-4).EQ.1)GOTO 134
      IF(K.EQ.7)GOTO 134
      IF(IABS(K-4).EQ.1)WRITE(LI,5)
      IF(J.EQ.1)GOTO 135
      IF(J.EQ.6)GOTO 135
      IF(ABS(A(21)).LT.0.5)GOTO 134
      IF(J.NE.0)GOTO 55
      J=6
      GOTO 135
 134  IF(IABS(J-4).NE.1)GOTO 137
      IF(J+J+K.NE.13)GOTO 136
      IF(NA.GT.1)GOTO 50
 135  IF(ABS(A(39)).GT.0.1)GOTO 55
      IF(A(30).GT.-8.E9)GOTO 55
      IF(LE.GT.LQ+4)GOTO 55
      IF(J.EQ.6)A(54)=2.
      GOTO 138
 136  CALL SXER('BAD FMAP/HKLF COMBINATION')
 137  IF(K.GT.6)GOTO 136
 138  IF(J.EQ.0)GOTO 140
      IF(J.EQ.4)GOTO 139
      IF(J.LT.7)GOTO 142
 139  IF(ABS(A(39)).GT.0.1)GOTO 142
      IF(A(30).GT.-8.E9)GOTO 142
      A(30)=9.E9
      A(32)=0.
      GOTO 142
 140  IF(ABS(A(39)).LT.0.1)GOTO 141
      A(54)=FD
      GOTO 142
 141  IF(LE.GT.LQ+4)A(54)=9.
      IF(A(30).GT.-8.E9)A(54)=9.
 142  IF(J.EQ.5)A(26)=9.E9
      IF(A(20).LT.-8.E9)GOTO 144
      IF(ABS(A(21)).LT.0.5)GOTO 143
      IF(ABS(A(57)).LT.0.01)A(57)=80.
      IF(MV.LT.0)CALL SXER('ATOMS NOT ALLOWED WITH PATT')
      GOTO 144
 143  IF(ABS(A(54)-2.).LT.1.1)A(26)=SIGN(9.E9,A(26))
 144  IF(ABS(A(57)).GT.0.1)GOTO 146
      IF(A(54).LT.0.1)GOTO 146
      A(57)=ZH
      IF(ABS(ZH).GT.0.1)GOTO 146
      U=195.
      IF(A(20).LT.-8.E9)U=45.
      IF(A(54).LT.3.5)GOTO 145
      U=.28*(2.-A(23))*A(60)/REAL(LL-LY-8)
      IF(A(26).LT.0.)GOTO 145
      U=U*12./(REAL(LY-63)*(2.-A(23)))
 145  A(57)=-AMIN1(999.,5.-ABS(A(31))+AINT(U))
 146  IF(NA.GT.10)GOTO 147
      IF(NA.GT.2)GOTO 50
      G(3)=1.
      G(7)=1.
      G(11)=1.
      IF(NA.LT.2)G(2)=1.
 147  LV=LE-6
      IF(MV.GT.0)LV=LX-16
      X=G(3)*G(7)-G(4)*G(6)
      Y=G(4)*G(9)-G(3)*G(10)
      Z=G(6)*G(10)-G(7)*G(9)
      X=Z*G(5)+Y*G(8)+X*G(11)
      IF(ABS(X).LT.0.01)GOTO 51
      IF(X.LT.0.)WRITE(LI,6)
      LX=LX-8
      WRITE(LG)F
      REWIND LG
      U=2.*A(2)*A(3)*A(4)
        DO 148 J=2,4
        F(J)=U*COS(1.74533E-2*A(J+3))/A(J)
        F(J+3)=F(J)*F(J)
 148    CONTINUE
      V=U**2
      U=.5*A(1)**2/(V-A(8)*F(5)-A(9)*F(6)-A(10)*F(7)+
     +F(2)*F(3)*F(4))
        DO 149 J=8,10
        A(J+6)=.5*U*((V/A(J))-F(J-3))
        A(J+9)=-2.*U*A(J)*A(J+3)
 149    CONTINUE
      A(17)=A(17)+U*A(12)*A(13)
      A(18)=A(18)+U*A(11)*A(13)
      A(19)=A(19)+U*A(11)*A(12)
      LD=LX
      IF(NK.NE.22)LD=0
      M=INT(A(57))
      IF(LW.NE.0)WRITE(LP,7)KD,M,KD,KD
      IF(A(70).LT.0.5)A(57)=ABS(A(57))
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SX2B(LM,LS,LU,F,G,A,B)
C
C Read reflection data, generate and sort E-values
C
      CHARACTER*1 IH(22),IT(76),IR(80),HK(80),KD
      CHARACTER*80 NM
      INTEGER IP(20)
      REAL F(LU),G(LU),A(LM),B(LS)
      REAL E(87),RS(13),SO(14),SU(14)
      COMMON/MEM/ST,SL,TC,TL,LR,LG,LH,LI,LP,LF,LA,LB,
     +LW,LY,LL,LQ,LE,LV,LX,LD,LZ,LJ,LN,LK,LC,HA,HD
      COMMON/WORD/IH,IT,IR,HK,NM,KD
C
      DATA RS/5.,3.5,2.5,2.,1.7,1.5,1.4,1.3,1.2,1.1,1.,.9,.8/
C
   1  FORMAT(3I4,2F8.0)
   2  FORMAT(20I4)
   3  FORMAT(//I8,'  Reflections read, of which',I6,'  rejected'
     +//'    Maximum h, k, l and 2-Theta =',3F6.0,F8.2)
   4  FORMAT(/' Checksum O.K.')
   5  FORMAT(3F8.2,F12.2,F10.2,'     Sin(theta) greater than 1')
   6  FORMAT(/5X,'h',7X,'k',7X,'l',10X,'F*F      Sigma',
     +'     Why Rejected'/)
   7  FORMAT(3F8.2,F12.2,F10.2,
     +'     Observed but should be systematically absent')
   8  FORMAT(/' ** Etc. **')
   9  FORMAT('HKLF',I3,A1)
  10  FORMAT(///' INCONSISTENT EQUIVALENTS'//
     +'   h   k   l       F*F    Sigma(F*F)  Esd of mean(F*F)'/)
  11  FORMAT(3I4,F12.2,2F10.2)
  12  FORMAT(3I4,2F8.2,A1)
  13  FORMAT(3I4,2F8.0,A1)
  14  FORMAT(/I8,'  Unique reflections, of which',I7,
     +'  observed'//'    R(int) =',F7.4,'     R(sigma) =',F7.4,
     +'      Friedel opposites merged')
  15  FORMAT(' Data:',I8,' unique,',I7,' observed     R(int) =',
     +F7.4,'  R(sigma) =',F7.4/' Systematic absence violations:',
     +I5,'    Bad equivalents:',I5)
  16  FORMAT(///' NUMBER OF UNIQUE DATA AS A FUNCTION OF RESOLUTION ',
     +'IN ANGSTROMS'//' Resolution  Inf',13F8.2)
  17  FORMAT(/' N(observed) ',13F8.0)
  18  FORMAT(/' N(measured) ',13F8.0)
  19  FORMAT(/' N(theory)   ',13F8.0)
  20  FORMAT(/' Two-theta   0.0',13F8.1)
C
      NX=0
      LZ=LX+7
      CALL SXZA(SO,14)
      CALL SXZA(SU,14)
      ML=LY+12
        DO 21 J=ML,LL,4
        A(J+1)=A(J+1)-99.5
        A(J+2)=A(J+2)-99.5
        A(J+3)=A(J+3)-99.5
  21    CONTINUE
C
C Read data for FMAP 3 and 5
C
      CALL SXZA(A(61),4)
      SB=1.
      NR=-1
      M=0
      I=INT(A(54))
      IF(IABS(I-4).NE.1)GOTO 27
      LD=LX+4
      QE=.0001
  22  N=1
  23  F(N+2)=0.
      NR=NR+1
      IF(I.EQ.3)READ(LH,1,ERR=23,END=25)J,K,L,F(N+1)
      IF(I.EQ.5)READ(LH,1,ERR=23,END=25)J,K,L,F(N+1),F(N+2)
      IF(MAX0(IABS(J),IABS(K)).GT.99)GOTO 23
      X=REAL(J)
      Y=REAL(K)
      Z=REAL(L)
      U=X*G(3)+Y*G(4)+Z*G(5)
      V=X*G(6)+Y*G(7)+Z*G(8)
      W=X*G(9)+Y*G(10)+Z*G(11)
      IF(ABS(AMOD(U+999.5,1.)-.5)+ABS(AMOD(V+999.5,1.)-.5)+
     +ABS(AMOD(W+999.5,1.)-.5).GT.0.01)GOTO 23
      U=SIGN(AINT(ABS(U)+.5),U+.1)
      V=SIGN(AINT(ABS(V)+.5),V+.1)
      W=SIGN(AINT(ABS(W)+.5),W+.1)
      IF(ABS(U).GT.A(61))A(61)=ABS(U)
      IF(ABS(V).GT.A(62))A(62)=ABS(V)
      IF(ABS(W).GT.A(63))A(63)=ABS(W)
      F(N)=U+200.*(V+200.*W)
      IF(ABS(F(N)).LT.0.5)GOTO 25
      Q=U**2*A(14)+V**2*A(15)+W**2*A(16)+V*W*A(17)+U*W*A(18)+U*V*A(19)
      IF(Q.GT.1.)GOTO 23
      IF(Q.GT.A(64))A(64)=Q
      IF(A(20).GT.-8.E9)GOTO 24
      LD=LD+4
      A(LD)=F(N)
      A(LD+1)=SQRT(ABS(F(N+1)))
      IF(QE.LT.A(LD+1))QE=A(LD+1)
  24  M=M+1
      N=N+3
      IF(N.LT.LU-1)GOTO 23
      WRITE(LA)F
      CALL SXCC
      GOTO 22
  25  WRITE(LA)F
      REWIND LA
      NR=NR-M
      Q=114.5916*ATAN2(SQRT(A(64)),SQRT(1.-A(64)))
      WRITE(LI,3)M,NR,A(61),A(62),A(63),Q
      IF(A(20).LT.-8.E9)A(22)=AMIN1(A(22)**2,A(64))
      QE=3./QE
      L=LX+4
  26  L=L+4
      IF(L.GT.LD)GOTO 100
      A(L+1)=A(L+1)*QE
      GOTO 26
C
C Read condensed data
C
  27  N=1
      CALL SXZA(E(52),36)
      NR=0
      ND=0
      NU=0
      NW=0
      M=IABS(INT(G(1)))+1
      IF(M.NE.2)GOTO 36
      UM=G(13)
      KI=0
      KK=0
  28  READ(LH,2)IP
      KK=MOD(KK,99)+1
      JP=0
      GOTO 31
  29  X=1.
  30  UM=UM+X*ABS(REAL(IP(JP)))
      UM=AINT(UM+SIGN(.3,UM))
  31  JP=JP+1
      X=100.
      IF(JP.GT.20)GOTO 28
      KI=INT(AMOD(REAL(KI)+REAL(KK)*REAL(IP(JP)),10000.))
      IF(IP(JP).LT.0)GOTO 29
      IF(IP(JP).GT.0)GOTO 33
      IF(20.GT.JP)GOTO 32
      READ(LH,2)IP
      JP=0
  32  JP=JP+1
      IF(IP(JP).EQ.0)GOTO 49
      IF(IP(JP).NE.KI)GOTO 35
      WRITE(LI,4)
      GOTO 49
  33  L=IP(JP)/1000
      IF(L.LT.0)GOTO 29
      IF(L.EQ.0)GOTO 30
      UM=UM+REAL(L)
      L=MOD(IP(JP)/100,10)-5
      Q=REAL(MOD(IP(JP),100))*(10.**L)
      JP=JP+1
      IF(JP.LT.21)GOTO 34
      READ(LH,2)IP
      KK=MOD(KK,99)+1
      JP=1
  34  L=(IP(JP)/1000)-4
      KI=INT(AMOD(REAL(KI)+REAL(KK)*REAL(IP(JP)),10000.))
      T=REAL(MOD(IP(JP),1000))*(10.**L)
      S=100.*T
      IF(Q.GT.0.)S=AMIN1(S,AMAX1(.001*T,1./Q))
      Q=ABS(UM)
      Z=AINT(.5+.0001*Q)
      X=(AINT(.5+Q)-10000.*Z)*.01
      Y=AINT(X+SIGN(.5,X+.1))
      X=AINT(101.*(X-Y))
      T=T*G(2)
      S=2.*T*G(2)*SQRT(S)
      T=T**2
      GOTO 38
  35  CALL SXER('BAD CONDENSED DATA')
C
C Read h,k,l,E or h,k,l,F,sigma
C
  36  READ(LH,1,ERR=36,END=49)J,K,L,T,S
      T=ABS(T*G(2))
      S=ABS(S*G(2))
      IF(M.NE.4)GOTO 37
      S=2.*S*T
      T=T*T
  37  IF(S.LT.1.E-4)S=.1
      IF(T.LT.0.5*S)T=AMIN1(.25*S,.5*SB)
      SB=.8*SB+.2*S
      IF(IABS(J)+IABS(K)+IABS(L).EQ.0)GOTO 49
      X=REAL(J)
      Y=REAL(K)
      Z=REAL(L)
  38  F(N+1)=T
      F(N+2)=S
C
C Reorientate, reject lattice absences
C
      IF(T.LT.1.E-6)GOTO 47
      U=X*G(3)+Y*G(4)+Z*G(5)
      V=X*G(6)+Y*G(7)+Z*G(8)
      W=X*G(9)+Y*G(10)+Z*G(11)
      IF(ABS(AMOD(U+999.5,1.)-.5)+ABS(AMOD(V+999.5,1.)-.5)+
     +ABS(AMOD(W+999.5,1.)-.5).GT.0.01)GOTO 45
      U=SIGN(AINT(ABS(U)+.5),U+.1)
      V=SIGN(AINT(ABS(V)+.5),V+.1)
      W=SIGN(AINT(ABS(W)+.5),W+.1)
      J=ML
  39  J=J+4
      IF(J.GT.LL)GOTO 40
      IF(ABS(AMOD(U*A(J+1)+V*A(J+2)+
     +W*A(J+3)+999.5,1.)-.5).LT.0.01)GOTO 39
      GOTO 45
C
C Maximize indices
C
  40  F(N)=0.
        DO 41 K=75,LY,12
        X=U*A(K)+V*A(K+3)+W*A(K+6)
        Y=U*A(K+1)+V*A(K+4)+W*A(K+7)
        Z=U*A(K+2)+V*A(K+5)+W*A(K+8)
        IF(AMAX1(ABS(X),ABS(Y),ABS(Z)).GT.99.5)GOTO 47
        X=AINT(1.001*X)
        Y=AINT(1.001*Y)
        Z=AINT(1.001*Z)
        F(N)=AMAX1(F(N),ABS(X+200.*(Y+200.*Z)))
        A(61)=AMAX1(A(61),ABS(X))
        A(62)=AMAX1(A(62),ABS(Y))
        A(63)=AMAX1(A(63),ABS(Z))
  41    CONTINUE
      CALL SXH2(F(N),X,Y,Z)
      IF(E(52).GT.X)E(52)=X
      IF(E(53).LT.X)E(53)=X
      IF(E(54).GT.Y)E(54)=Y
      IF(E(55).LT.Y)E(55)=Y
      IF(E(56).GT.Z)E(56)=Z
      IF(E(57).LT.Z)E(57)=Z
C
C Reject systematic absences
C
      K=75
  42  K=K+12
      IF(K.GT.LY)GOTO 43
      Q=AINT(1.001*(X*A(K)+Y*A(K+3)+Z*A(K+6)))+
     +200.*(AINT(1.001*(X*A(K+1)+Y*A(K+4)+Z*A(K+7)))+
     +200.*AINT(1.001*(X*A(K+2)+Y*A(K+5)+Z*A(K+8))))
      IF(A(23).LT.0.5)Q=ABS(Q)
      IF(Q+.5.LT.F(N))GOTO 42
      IF(ABS(AMOD(.5+ABS(X*A(K+9)+Y*A(K+10)+Z*A(K+11)),1.)-.5)
     +.LT.0.01)GOTO 42
      GOTO 45
  43  Q=X**2*A(14)+Y**2*A(15)+Z**2*A(16)+Y*Z*A(17)+X*Z*A(18)+X*Y*A(19)
      IF(Q.GT.A(64))A(64)=Q
      IF(Q.LT.1.)GOTO 44
      IF(NU.EQ.0)WRITE(LI,6)
      IF(NU.LT.50)WRITE(LI,5)U,V,W,F(N+1),F(N+2)
      GOTO 46
  44  N=N+3
      IF(N.LT.LU-1)GOTO 48
      WRITE(LA)F
      CALL SXCC
      N=1
      GOTO 48
  45  IF(F(N+1).LT.4.*F(N+2))GOTO 47
      IF(NU.EQ.0)WRITE(LI,6)
      IF(NU.LT.50)WRITE(LI,7)U,V,W,F(N+1),F(N+2)
      NW=NW+1
  46  NU=NU+1
      IF(NU.EQ.50)WRITE(LI,8)
  47  NR=NR+1
  48  ND=ND+1
      IF(M.EQ.2)GOTO 31
      GOTO 36
C
C End of data
C
  49  F(N)=0.
      WRITE(LA)F
      REWIND LA
      IF(A(64).GT.1.)A(64)=1.
      X=114.5916*ATAN2(SQRT(A(64)),SQRT(1.-A(64)))
      WRITE(LI,3)ND,NR,A(61),A(62),A(63),X
      IF(A(20).LT.-8.E9)A(22)=AMIN1(A(22)**2,A(64))
      NU=0
      NR=0
      L=1
      QH=E(53)-E(52)+1.
      QK=E(55)-E(54)+1.
      QL=REAL(LX)+7.3
      QC=QL+.8-E(52)-QH*(E(54)-QK*E(56))
      RA=0.
      RB=.0001
      RC=0.
      RD=.0001
      ZM=REAL(LS)
      K4=0
      IF(LJ.EQ.0)GOTO 50
      N=-LJ
      WRITE(LP,9)N,KD
C
C Sort/merge reflection data
C
  50  QM=REAL(LM)+.3
      JF=0
      N=INT(AMIN1(QC+E(53)+QH*(E(55)+QK*E(57)),QM))
      NF=0
      M=LX+8
      CALL SXZA(A(M),N-M+1)
      IF(LZ.LT.N)LZ=N
  51  READ(LA)F
      CALL SXCC
      I=-2
      GOTO 53
  52  JF=-1
  53  I=I+3
      IF(I.GT.LU-2)GOTO 51
      IF(F(I).LT.0.5)GOTO 57
      CALL SXH2(F(I),X,Y,Z)
      Q=QC+QH*(Y+QK*Z)+X
      IF(Q.LT.QL)GOTO 53
      IF(Q.GT.QM)GOTO 52
      J=INT(Q)
      IF(NF.GT.0)GOTO 54
      A(J)=1.
      GOTO 53
  54  KI=INT(A(J))
      CALL SXCA(B(KI),E,5)
      IF(NF.GT.1)GOTO 55
      W=AMAX1(F(I+1)/F(I+2),3.)/F(I+2)
      E(1)=F(I)
      E(2)=E(2)+W
      E(3)=E(3)+W*F(I+1)
      E(4)=E(4)+1.
      E(5)=E(5)+F(I+1)
      GOTO 56
  55  E(2)=E(2)+ABS(F(I+1)-E(3))
      E(5)=E(5)+1./F(I+2)**2
  56  CALL SXCA(E,B(KI),5)
      GOTO 53
  57  REWIND LA
      IF(NF.GT.0)GOTO 61
      NF=1
      Q=1.3
      K=M
        DO 58 I=M,N
        IF(A(I).LT.0.5)GOTO 58
        A(I)=Q
        Q=Q+5.
        IF(Q.GT.ZM)GOTO 59
        K=I
  58    CONTINUE
      JF=JF+1
      Q=Q+5.
  59  QM=REAL(K)+.3
      KK=INT(Q-6.)
        DO 60 KI=1,KK
        B(KI)=0.
  60    CONTINUE
      IF(K4.LT.KK)K4=KK
      GOTO 51
  61  KI=-4
      IF(NF.EQ.2)GOTO 64
  62  KI=KI+5
      IF(KI.GT.KK)GOTO 63
      B(KI+2)=B(KI+2)/B(KI+1)
      B(KI+1)=0.
      IF(B(KI+3).GT.1.5)RB=RB+B(KI+4)
      B(KI+4)=0.
      GOTO 62
  63  NF=2
      GOTO 51
  64  READ(LG)F
      REWIND LG
      JU=INT(F(1))
  65  KI=KI+5
      IF(KI.GT.KK)GOTO 79
      NR=NR+1
C
C List reflections
C
      CALL SXCA(B(KI),E,5)
      G(L)=E(1)
      V=E(3)
      G(L+1)=SQRT(AMAX1(1.E-8,V))
      W=1./SQRT(E(5))
      CALL SXH2(G(L),X,Y,Z)
      J=INT(X)
      K=INT(Y)
      NI=INT(Z)
      IF(E(4).LT.1.5)GOTO 67
      RA=RA+E(2)
      P=E(2)/(E(4)*SQRT(E(4)-1.))
      IF(P.LT.5.*W)GOTO 66
      IF(NX.EQ.0)WRITE(LI,10)
      NX=NX+1
      IF(NX.LT.51)WRITE(LI,11)J,K,NI,V,W,P
      IF(NX.EQ.50)WRITE(LI,8)
  66  W=AMAX1(P,W)
  67  RF=2.*AINT(100.*W/V)
      IF(RF.GT.998.)RF=998.
      IF(LJ.EQ.0)GOTO 71
      P=V
      T=W
      IF(LJ.EQ.4)GOTO 68
      P=G(L+1)
      T=.5*T/P
      GOTO 69
  68  P=P*.001
      T=T*.001
  69  IF(P.GT.99999.99)GOTO 70
      IF(T.GT.99999.99)GOTO 70
      WRITE(LP,12)J,K,NI,P,T,KD
      GOTO 71
  70  WRITE(LP,13)J,K,NI,P,T,KD
C
C Find epsilon and restricted phases
C
  71  P=0.
      T=0.
        DO 72 K=75,LY,12
        Q=AINT(1.001*(X*A(K)+Y*A(K+3)+Z*A(K+6)))+
     +  200.*AINT(1.001*(X*A(K+1)+Y*A(K+4)+Z*A(K+7)))+
     +  40000.*AINT(1.001*(X*A(K+2)+Y*A(K+5)+Z*A(K+8)))
        S=SIGN(1.,Q)*(X*A(K+9)+Y*A(K+10)+Z*A(K+11))
        IF(A(23).LT.0.5)Q=ABS(Q)
        IF(Q+.5.GE.G(L))P=P+1.
        IF(.5-Q.GE.G(L))T=1000.*AINT(12.*AMOD(400.01-S,1.)+12.)
  72    CONTINUE
C
C Sin(theta), parity, R(int) and R(sigma)
C
      Q=X*X*A(14)+Y*Y*A(15)+Z*Z*A(16)+Y*Z*A(17)+X*Z*A(18)+X*Y*A(19)
      G(L+2)=Q+AINT(AMOD(X+998.01,2.)+AMOD(Y+998.01,2.)*2.+
     +AMOD(Z+998.01,2.)*4.)
      G(L+3)=T+(1./P)+RF
      J=58+INT(AMIN1(14.1,33.3333*Q/(A(1)*A(1))))
      E(J)=E(J)+1.
      E(J+15)=E(J+15)+V/P
      S=.5*A(1)/SQRT(Q)
      K=13
  73  IF(RS(K).GT.S)GOTO 74
      K=K-1
      IF(K.GT.0)GOTO 73
  74  K=K+1
      SU(K)=SU(K)+1.
      IF(SIGN(Q,A(53)).GT.A(53))GOTO 77
      J=1
  75  J=J+1
      IF(JU.LT.J)GOTO 76
      IF(ABS(G(L)-F(J)).LT.0.5)GOTO 77
      GOTO 75
  76  IF(V.GT.W*A(52))GOTO 78
  77  G(L+1)=-G(L+1)
      SO(K)=SO(K)+1.
      NU=NU+1
  78  RC=RC+W
      RD=RD+V
      L=L+4
      IF(L.LT.LU-2)GOTO 65
      WRITE(LB)G
      L=1
      GOTO 65
  79  QC=QC-QM+QL
      IF(JF.LT.1)GOTO 50
      G(L)=0.
      WRITE(LB)G
      REWIND LB
      NU=NR-NU
      RA=RA/RB
      RC=RC/RD
      WRITE(LI,14)NR,NU,RA,RC
      WRITE(*,15)NR,NU,RA,RC,NW,NX
      CALL SXFL
      I=0
      X=0.
      IF(LJ.NE.0)WRITE(LP,12)I,I,I,X,X,KD
C
C Number of unique data in shells
C
      EM=(.5*A(1)/AMAX1(A(66),1.E-8))**2
      EH=AMIN1(A(64),(.5*A(1)/AMAX1(A(65),1.E-8))**2)
      CALL SXZA(G(40),11)
      NF=1
      NQ=1
        DO 80 I=1,13
        IF(SU(I).GT.0.5)NQ=I
  80    CONTINUE
      P=RS(NQ)
      IF(A(66).GT.A(65))P=AMIN1(P,.5*A(1)/SQRT(A(64)+.001))
        DO 81 I=2,4
        X=AINT(A(I)/P)
        J=I+I+18
        G(J-1)=-X
        G(J)=X+.5
  81    CONTINUE
        DO 82 I=1,NQ
        P=.5*A(1)/RS(I)
        G(I+26)=P**2
        G(I+50)=114.592*ATAN2(P,SQRT(AMAX1(0.,1.-G(I+26))))
        SO(I)=SU(I)-SO(I)
        G(I)=0.
  82    CONTINUE
      G(14)=0.
      Z=0.
      IF(LY.EQ.87)GOTO 83
      IF(LY.EQ.135)GOTO 86
      IF(LY.LT.100)GOTO 86
      GOTO 85
  83  IF(A(91)*A(95).LT.0.)GOTO 85
  84  G(21)=0.
      GOTO 86
  85  G(23)=0.
      IF(LY.NE.111)GOTO 86
      IF(ABS(A(88))+ABS(A(100)).LT.0.1)GOTO 84
  86  Y=G(23)
  87  X=G(21)
  88  J=ML
  89  J=J+4
      IF(J.GT.LL)GOTO 90
      IF(ABS(AMOD(X*A(J+1)+Y*A(J+2)+Z*A(J+3)+999.5,1.)-.5).GT.0.01)
     +GOTO 98
      GOTO 89
  90  W=X+200.*(Y+200.*Z)+.5
      IF(W.LT.1.)GOTO 98
      NO=0
      K=75
  91  K=K+12
      IF(K.GT.LY)GOTO 92
      Q=AINT(1.001*(X*A(K)+Y*A(K+3)+Z*A(K+6)))+
     +200.*(AINT(1.001*(X*A(K+1)+Y*A(K+4)+Z*A(K+7)))+
     +200.*AINT(1.001*(X*A(K+2)+Y*A(K+5)+Z*A(K+8))))
      IF(ABS(Q).GT.W)GOTO 98
      IF(A(23).LT.0.5)Q=ABS(Q)
      IF(1.+Q.LT.W)GOTO 91
      IF(ABS(AMOD(.5+ABS(X*A(K+9)+Y*A(K+10)+Z*A(K+11)),1.)-.5)
     +.GT.0.01)NO=1
      GOTO 91
  92  Q=X**2*A(14)+Y**2*A(15)+Z**2*A(16)+Y*Z*A(17)+X*Z*A(18)+X*Y*A(19)
      IF(Q.LT.0.0001)GOTO 98
C
C Save generated reflections on file for later insertion
C
      IF(A(66).LE.A(65))GOTO 95
      IF(Q.GT.EH)GOTO 95
      IF(Q.LT.EM)GOTO 95
      IF(NO.NE.0)GOTO 93
      P=(10.*Q)/(A(64)+.001)
      K=INT(P)
      IF(K.GT.9)GOTO 95
      P=P-REAL(K)
      G(K+40)=G(K+40)+1.-P
      G(K+41)=G(K+41)+P
      GOTO 94
  93  IF(A(26).GT.0.)GOTO 95
  94  F(NF)=W
      F(NF+1)=Q
      NF=NF+2
      IF(NF.LT.LU)GOTO 95
      WRITE(LF)F
      NF=1
  95  IF(NO.NE.0)GOTO 98
      K=26+NQ
  96  IF(G(K).LT.Q)GOTO 97
      K=K-1
      IF(K.GT.26)GOTO 96
  97  K=K-25
      G(K)=G(K)+1.
  98  X=X+1.
      IF(X.LT.G(22))GOTO 88
      Y=Y+1.
      IF(Y.LT.G(24))GOTO 87
      Z=Z+1.
      IF(Z.LT.G(26))GOTO 86
      WRITE(LI,16)(RS(I),I=1,NQ)
      WRITE(LI,17)(SO(I),I=1,NQ)
      WRITE(LI,18)(SU(I),I=1,NQ)
      WRITE(LI,19)(G(I),I=1,NQ)
      WRITE(LI,20)(G(I+50),I=1,NQ)
C
C Theta dependence
C
      CALL SXZA(G,5)
      Q=-.015
        DO 99 I=58,72
        Q=Q+.03
        IF(E(I).LT.9.5)GOTO 99
        P=ALOG(E(I+15)/E(I))
        G(1)=G(1)+1.
        G(2)=G(2)+Q
        G(3)=G(3)+Q**2
        G(4)=G(4)+P
        G(5)=G(5)+P*Q
  99    CONTINUE
      G(6)=REAL(K4)
      IF(A(66).LE.A(65))GOTO 100
      F(NF)=9.E9
      WRITE(LF)F
      REWIND LF
 100  RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SX2C(LM,LS,LU,F,G,A,B)
C
C E-lists and E-calc
C
      CHARACTER*1 IH(22),IT(76),IR(80),HK(80),KD
      CHARACTER*80 NM
      INTEGER IP(20)
      REAL F(LU),G(LU),A(LM),B(LS),E(62)
      COMMON/MEM/ST,SL,TC,TL,LR,LG,LH,LI,LP,LF,LA,LB,
     +LW,LY,LL,LQ,LE,LV,LX,LD,LZ,LJ,LN,LK,LC,HA,HD
      COMMON/WORD/IH,IT,IR,HK,NM,KD
C
   1  FORMAT(//' Highest memory for sort/merge =',I6,' /',I6)
   2  FORMAT(//18X,' Centric Acentric    0kl      h0l      hk0',
     +6X,'Rest'//' Mean Abs(E*E-1)    0.968    0.736',4F9.3/)
   3  FORMAT(///' Observed E .GT.',10F6.3//' Number  ',6X,10I6)
   4  FORMAT(//I8,' missing weak reflections reinstated')
   5  FORMAT(/' ** NO OBSERVED E ABOVE',F7.3,' **')
   6  FORMAT('     SUMMARY OF PARAMETERS FOR ',76A1/)
   7  FORMAT(' ESEL  Emin',F7.3,'    Emax',F7.3,'    DelU',F6.3,
     +'    renorm',F6.3,'    axis',I2)
   8  FORMAT(' EGEN  d(min)',F6.2,'    d(max)',F6.2)
   9  FORMAT(' OMIT  s',F6.2,'    2theta(lim)',F7.1)
  10  FORMAT(' INIT  nn',I5,'    nf',I5,'    s+',F7.3,'    s-',
     +F7.3,'    wr',F7.3)
  11  FORMAT(' PHAN  steps',I5,'   cool',F6.3,'   Boltz',
     +F6.3,'   ns',I5,'   mtpr',I5,'   mnqr',I4)
  12  FORMAT(' TREF  np',F10.0,'    nE',I6,'    kapscal',F7.3,
     +'    ntan',I4,'    wn',F7.3)
  13  FORMAT(' TEXP  na',I5,'    nh',I4,'    Ek',F6.3)
  14  FORMAT(' PATT  nv',I4,'   dmin',F7.2,'   resl',F6.2,
     +'   Nsup',I5,'   Zmin',F6.2,'   maxat',I3)
  15  FORMAT(' FMAP  code',I3/' PLAN  npeaks',I6,
     +'    del1',F6.3,'    del2',F6.3)
  16  FORMAT(' MORE  verbosity',I3)
  17  FORMAT(' TIME  t',F12.0/)
  18  FORMAT(' PSEE  m',F7.0,'    2theta(max)',F7.1)
  19  FORMAT(3(3I3,F6.3,I2,2X),3I3,F6.3,I2,A1)
  20  FORMAT('READ',I5,' HKLE FOR ',40A1,' 2THETA.LT.',F7.2,A1)
  21  FORMAT(' RE =',F6.3,' for',I4,' atoms and',
     +I5,' E greater than',F7.3)
  22  FORMAT(/' ** BAD PHAS ',4F6.0)
  23  FORMAT(/' ** CANNOT PHASE ENOUGH REFLECTIONS **')
  24  FORMAT(//' Fixed phases'//4('    Code   ',
     +'h   k   l   E   Phi')/)
  25  FORMAT(4(I7,'.',3I4,F6.3,I4))
C
      IF(ABS(A(30)).LT.0.5)A(67)=AMOD(A(67),1.)
      JJ=IABS(INT(A(54)))
      IF(IABS(JJ-4).EQ.1)GOTO 63
      K4=INT(G(6))
C
C Normalize E-values
C
      P=20.
      IF(G(1).LT.0.5)GOTO 26
      Q=G(1)*G(3)-G(2)**2
      IF(Q.LT.1.E-6)GOTO 26
      P=(G(2)*G(4)-G(1)*G(5))/Q
  26  P=P/A(1)**2
      T=10./(A(64)+.001)
      MH=0
      NH=LU
      NR=1
      ND=LX+39
      LH=ND
      I=INT(A(29)*.1)
      IF(I.GT.0)LH=LH+2*INT(1.5+A(I+60))
      LD=LH-2
      W=1./A(27)**2
      W=W**2
      U=78.9568*A(28)/A(1)**2
      CALL SXZA(G,38)
        DO 61 M=1,4
        IF(M.NE.2)GOTO 34
        CALL SXZA(A(LX+27),LH-LX-26)
        R=0.
        Q=0.
          DO 27 K=12,19
          R=R+G(K)
          Q=Q+G(K+19)
  27      CONTINUE
        R=R/AMAX1(Q,.01)
          DO 28 K=31,38
          G(K)=G(K)*R
  28      CONTINUE
        J=LX+8
          DO 29 K=1,19
          A(J)=G(K)/AMAX1(G(K+19),.01)
          J=J+1
  29      CONTINUE
          DO 30 J=LX+19,LX+26
          A(J)=AMOD(A(29),10.)*(A(J)-1.)+1.
  30      CONTINUE
        IF(A(66).LE.A(65))GOTO 33
        J=LX+8
          DO 32 K=40,50
          V=.49
          Q=G(K-39)/AMAX1(G(K),.01)
          IF(ABS(Q-.5).GT.0.499)GOTO 31
          S=1.-Q
          V=S+Q*ALOG(Q)
          A(J)=A(J)*SQRT((1.-V*S)/Q)
  31      E(K+12)=SQRT(V)
          J=J+1
  32      CONTINUE
  33    IF(A(29).LT.5.)GOTO 61
  34    IF(M.NE.3)GOTO 36
        IF(A(29).LT.5.)GOTO 36
          DO 35 K=ND,LH,2
          A(K)=AMOD(A(29),10.)*(A(K)/AMAX1(A(K+1),.01)-1.)+1.
  35      CONTINUE
  36    IF(M.NE.4)GOTO 38
        J=LX+27
        L=J+3
          DO 37 K=J,L
          A(K+4)=A(K)/AMAX1(A(K+4),.01)
  37      CONTINUE
  38    READ(LB)F
        CALL SXCC
          DO 58 I=1,LU-3,4
          IF(F(I).LT.0.5)GOTO 60
          QC=AMOD(F(I+2),1.)
          R=F(I+1)**2*EXP(P*QC)*AMOD(F(I+3),2.)
          Q=QC*T
          N=INT(Q)
          Q=Q-REAL(N)
          N=N+1
          S=1.-Q
          L=INT(12.+F(I+2))
          IF(M.NE.1)GOTO 39
          G(L)=G(L)+1.
          G(L+19)=G(L+19)+R
          G(N)=G(N)+S
          G(N+1)=G(N+1)+Q
          G(N+19)=G(N+19)+R*S
          G(N+20)=G(N+20)+R*Q
          GOTO 58
  39      K=N+LX+7
          L=L+LX+7
          R=R*A(L)*(A(K)*S+A(K+1)*Q)
          CALL SXH2(F(I),XX,YY,ZZ)
          E(1)=ABS(XX)
          E(2)=ABS(YY)
          E(3)=ABS(ZZ)
          IF(A(29).LT.5.)GOTO 41
          J=INT(A(29)*.1)
          J=INT(.5+2.*E(J))+LX+39
          IF(M.NE.2)GOTO 40
          A(J)=A(J)+1.
          A(J+1)=A(J+1)+R
          GOTO 58
  40      R=R*A(J)
  41      IF(IABS(N-5).GT.2)GOTO 46
          IF(E(1).GT.0.5)GOTO 42
          IF(AMIN1(E(2),E(3)).LT.0.5)GOTO 46
          J=LX+27
          GOTO 44
  42      IF(E(2).GT.0.5)GOTO 43
          IF(E(3).LT.0.5)GOTO 46
          J=LX+28
          GOTO 44
  43      J=LX+29
          IF(E(3).GT.0.5)J=J+1
  44      IF(M.NE.3)GOTO 45
          A(J)=A(J)+1.
          A(J+4)=A(J+4)+R
          GOTO 58
  45      A(J+8)=A(J+8)+ABS(1.-R*A(J+4))
  46      IF(M.NE.4)GOTO 58
          Q=0.0002*AINT(.5*AMOD(F(I+3),1000.))**2
          R=(R+Q)/(1.+Q)
          IF(R.GT.0.001)R=SQRT(SQRT(1./(W+1./R**2)))*EXP(U*QC)
C
C Triclinic expansion
C
          FM=F(I)
  47      IF(A(26).GE.0.)GOTO 50
          L=3
          K=63
  48      K=K+12
          IF(K.GT.LY)GOTO 53
          X=XX*A(K)+YY*A(K+3)+ZZ*A(K+6)
          Y=XX*A(K+1)+YY*A(K+4)+ZZ*A(K+7)
          Z=XX*A(K+2)+YY*A(K+5)+ZZ*A(K+8)
          IF(AMAX1(ABS(X),ABS(Y),ABS(Z)).GT.99.5)GOTO 48
          G(NR)=ABS(AINT(1.001*X)+200.*(AINT(1.001*Y)+
     +    200.*AINT(1.001*Z)))
          L=L+1
          E(L)=G(NR)
          N=3
  49      N=N+1
          IF(N.GE.L)GOTO 51
          IF(ABS(E(N)-E(L)).LT.0.5)GOTO 48
          GOTO 49
  50      G(NR)=F(I)
          L=4
          E(4)=F(I)
  51      G(NR+1)=F(I+1)
          G(NR+2)=R
          NR=NR+3
          IF(NR.LT.LU-1)GOTO 52
          WRITE(LA)G
          NR=1
  52      IF(A(26).LT.0.)GOTO 48
  53      IF(R.LT.ABS(A(26)))GOTO 55
          IF(F(I+1).LT.0.)GOTO 55
            DO 54 K=4,L
            LD=LD+4
            A(LD)=E(K)
            IF(LD.GT.LM-2000)GOTO 59
            A(LD+1)=AMIN1(R,9.)
            A(LD+2)=0.
            IF(A(26).GT.0.)A(LD+2)=AINT(F(I+3)*.001)*10.
            A(LD+3)=1.
            IF(A(26).GT.0.)A(LD+3)=1./AMOD(F(I+3),2.)
  54        CONTINUE
C
C Including missing reflections
C
  55      IF(A(66).LE.A(65))GOTO 58
          IF(NH.LT.LU)GOTO 56
          READ(LF)(B(NH),NH=1,LU)
          NH=1
  56      Z=B(NH)-FM
          IF(Z.GT.0.5)GOTO 58
          IF(Z.GT.-.5)GOTO 57
          CALL SXH2(B(NH),XX,YY,ZZ)
          F(I)=B(NH)
          F(I+1)=-.01
          R=T*B(NH+1)
          K=INT(R)
          R=R-REAL(K)
          R=E(K+51)*(1.-R)+E(K+52)*R
          NH=NH+2
          MH=MH+1
          GOTO 47
  57      NH=NH+2
  58      CONTINUE
        GOTO 38
C
C Prepare statistics
C
  59    CALL SXER(
     +  'TOO MANY LARGE E - REDUCE DELTA(U) OR INCREASE E(MIN)')
  60    REWIND LB
  61    CONTINUE
      IF(A(66).LE.A(65))GOTO 62
      REWIND LF
      WRITE(LI,4)MH
  62  G(NR)=0.
      WRITE(LA)G
      REWIND LA
      IF(LZ.LT.LD+3)LZ=LD+3
      WRITE(LI,1)LZ,K4
  63  NA=LX+4
      AP=ABS(A(30))
      IF(A(30).LT.-8.E9)AP=-9.E9
      M=LY+12
        DO 64 I=M,LL,4
        A(I+1)=A(I+1)+99.5
        A(I+2)=A(I+2)+99.5
        A(I+3)=A(I+3)+99.5
  64    CONTINUE
      IF(JJ.EQ.5)GOTO 124
      IF(JJ.EQ.3)GOTO 85
      M=0
      K=0
      I=0
        DO 65 J=75,LY,12
        IF(ABS(A(J+1)).GT.0.5)I=1
        IF(ABS(A(J+2)).GT.0.5)K=1
        IF(ABS(A(J+5)).GT.0.5)M=1
  65    CONTINUE
      J=LX+27
      IF(I+K+M.NE.3)GOTO 68
        DO 67 M=1,2
        K=J+2
        X=A(J)+A(J+1)+A(K)
          DO 66 I=J,K
          A(I)=X
  66      CONTINUE
        J=J+8
  67    CONTINUE
      GOTO 73
  68  IF(I.EQ.0)GOTO 69
      I=LX+28
      GOTO 71
  69  IF(K.EQ.0)GOTO 70
      I=LX+29
      GOTO 71
  70  IF(M.EQ.0)GOTO 73
      J=LX+28
      I=LX+29
  71  M=J+8
        DO 72 K=J,M,8
        X=A(K)+A(I)
        A(K)=X
        A(I)=X
        I=I+8
  72    CONTINUE
  73  J=LX+27
        DO 74 I=1,4
        G(I)=A(J+8)/AMAX1(A(J),.01)
        J=J+1
  74    CONTINUE
      IF(LZ.LT.LD+3)LZ=LD+3
C
C File unique large E
C
      T=ABS(A(26))
      S=T
      IF(T.GT.8.E9)GOTO 80
        DO 75 I=5,14
        IP(I)=0
        G(I)=T
        T=T+.1
  75    CONTINUE
      I=LX+4
      K=LH-2
      IF(LD.GT.LH)GOTO 76
      WRITE(LI,5)S
      WRITE(*,5)S
      CALL SXIT
  76  M=1
  77  K=K+4
      IF(K.GT.LD)GOTO 79
      Q=A(K+1)
        DO 78 L=5,14
        IF(Q.GT.G(L))IP(L)=IP(L)+1
  78    CONTINUE
      I=I+4
      A(I)=A(K)
      F(M)=A(K)
      F(M+1)=A(K+2)+Q
      F(M+2)=A(K+3)
      A(I+1)=F(M+1)
      M=M+3
      A(I+2)=-1.
      A(I+3)=A(K+3)
      IF(M.LT.LU-1)GOTO 77
      CALL SXCC
      WRITE(LF)F
      GOTO 76
  79  LD=I
      F(M)=0.
      WRITE(LF)F
      REWIND LF
      WRITE(LI,3)(G(I),I=5,14),(IP(I),I=5,14)
  80  WRITE(LI,2)(G(I),I=1,4)
      T=SL
      CALL SXTM(SL,LI)
C
C Summarise parameters
C
      CALL SXPG(LI)
      WRITE(LI,6)IT
      WRITE(*,'(1X)')
      IF(ABS(A(26)).GT.8.E9)GOTO 81
      J=INT(A(29)*.1)
      U=A(29)-10.*REAL(J)
      WRITE(LI,7)A(26),A(27),A(28),U,J
      WRITE(*,7)A(26),A(27),A(28),U,J
      IF(A(66).LE.A(65))GOTO 81
      WRITE(LI,8)A(65),A(66)
      WRITE(*,8)A(65),A(66)
  81  P=2.*A(52)
      Q=ABS(A(53))
      Q=SIGN(114.59*ATAN2(SQRT(Q),SQRT(ABS(1.-Q))),A(53))
      WRITE(LI,9)P,Q
      WRITE(*,9)P,Q
      IF(ABS(A(39)).LT.0.5)GOTO 82
      L=INT(A(67))
      M=INT(A(69))
      P=AMOD(A(69),1.)
      Q=AMOD(ABS(A(67)),1.)*10.-1.
      WRITE(LI,10)L,M,A(68),P,Q
      WRITE(*,10)L,M,A(68),P,Q
      L=INT(A(43))
      M=INT(A(72))
      I=INT(A(73))
      J=INT(A(74))
      WRITE(LI,11)L,A(44),A(71),M,I,J
      WRITE(*,11)L,A(44),A(71),M,I,J
      J=INT(A(40))
      L=INT(A(41))
      WRITE(LI,12)A(39),J,A(22),L,A(42)
      WRITE(*,12)A(39),J,A(22),L,A(42)
  82  IF(ABS(A(21)).LT.0.1)GOTO 83
      IF(A(20).LT.-8.E9)GOTO 83
      I=INT(A(20))
      K=INT(A(21))
      A(42)=AMAX1(ABS(A(42)),.5*A(1)/SQRT(AMAX1(A(64),.0001)))
      J=INT(ABS(A(22)))
      P=100.*(A(20)-REAL(I))
      Q=100.*SIGN(ABS(A(22))-REAL(J),A(22))
      WRITE(LI,14)K,Q,A(42),J,P,I
      WRITE(*,14)K,Q,A(42),J,P,I
  83  IF(ABS(A(30)).GT.8.E9)GOTO 84
      I=INT(A(30))
      J=INT(A(31))
      WRITE(LI,13)I,J,A(32)
      WRITE(*,13)I,J,A(32)
  84  I=INT(A(54))
      IF(I.EQ.2)I=6
      J=INT(A(57))
      WRITE(LI,15)I,J,A(58),A(59)
      WRITE(*,15)I,J,A(58),A(59)
      J=INT(A(70))
      WRITE(LI,16)J
      WRITE(*,16)J
      WRITE(LI,17)TL
      WRITE(*,17)TL
      TL=TL+T
      CALL SXFL
      CALL SXCC
      IF(ABS(A(26)).GT.8.E9)GOTO 93
C
C Dump largest E-values (PSEE)
C
  85  IF(A(20).GT.-8.E9)GOTO 93
      NN=0
      J=LX
  86  J=J+4
      IF(J.GT.LD)GOTO 87
      CALL SXH2(A(J),X,Y,Z)
      IF(X*X*A(14)+Y*Y*A(15)+Z*Z*A(16)+Y*Z*A(17)+
     +X*Z*A(18)+X*Y*A(19).GT.A(22))A(J)=-A(J)
      IF(A(J).GT.0.)NN=NN+1
      GOTO 86
  87  X=114.5916*ATAN2(SQRT(A(22)),SQRT(1.-A(22)))
      NN=MIN0(NN,INT(.1+ABS(A(21))))
      WRITE(LI,18)A(21),X
      WRITE(LP,20)NN,(IT(M),M=1,40),X,KD
      M=0
  88  J=LX+4
      L=0
      Q=0.
  89  J=J+4
      IF(J.GT.LD)GOTO 90
      IF(A(J).LT.0.)GOTO 89
      P=AMOD(A(J+1),10.)
      IF(Q.GT.P)GOTO 89
      Q=P
      L=J
      GOTO 89
  90  CALL SXH2(A(L),X,Y,Z)
      IF(M.LT.4)GOTO 91
      WRITE(LP,19)(IP(I),IP(I+4),IP(I+8),F(I),IP(I+12),I=1,4),KD
      M=0
  91  M=M+1
      IP(M)=INT(X)
      IP(M+4)=INT(Y)
      IP(M+8)=INT(Z)
      F(M)=Q
      IP(M+12)=INT(A(L+3))
      A(L)=-A(L)
      NN=NN-1
      IF(NN.GT.0)GOTO 88
        DO 92 I=M+1,4
        IP(I)=0
        IP(I+4)=0
        IP(I+8)=0
        F(I)=0.
        IP(I+12)=0
  92    CONTINUE
      WRITE(LP,19)(IP(I),IP(I+4),IP(I+8),F(I),IP(I+12),I=1,4),KD
  93  IF(JJ.EQ.3)GOTO 124
      L=LX+4
  94  L=L+4
      IF(L.GT.LD)GOTO 95
      A(L)=ABS(A(L))
      A(L+3)=0.
      GOTO 94
C
C Convert symops to triclinic acentric
C
  95  IF(A(26).GT.0.)GOTO 100
      A(23)=1.
      I=LY+8
      J=83
  96  IF(I.GE.LL)GOTO 97
      I=I+4
      IF(A(I).LT.0.)GOTO 96
      J=J+4
      A(J)=A(I)
      A(J+1)=A(I+1)
      A(J+2)=A(I+2)
      A(J+3)=A(I+3)
      GOTO 96
  97  I=I+3
      LL=J
      LY=75
      J=J+3
  98  I=I+1
      IF(I.GT.LE+1)GOTO 99
      J=J+1
      A(J)=A(I)
      GOTO 98
  99  LQ=LQ+J-LE-1
      LE=J-1
C
C E-calc
C
 100  LJ=LL-1
      IF(IABS(JJ-1).LT.2)GOTO 124
      IF(ABS(A(39)).GT.0.5)GOTO 101
      IF(AP.LT.-8.E9)GOTO 107
 101  IF(LX.EQ.LV)GOTO 107
      M=0
      CALL SXZA(F,3)
      I=LX+4
 102  I=I+4
      IF(I.GT.LD)GOTO 106
      CALL SXCC
      R=AMOD(A(I+1),10.)
      CALL SXH2(A(I),X,Y,Z)
      X=X*6.283185
      Y=Y*6.283185
      Z=Z*6.283185
      O=0.
      P=0.
      J=LV
 103  J=J+8
      IF(J.GT.LX)GOTO 105
      K=INT(.001*A(J+1))*5+LJ
      Q=A(K)*A(J+5)
        DO 104 K=75,LY,12
        U=X*A(K)+Y*A(K+3)+Z*A(K+6)
        V=X*A(K+1)+Y*A(K+4)+Z*A(K+7)
        W=X*A(K+2)+Y*A(K+5)+Z*A(K+8)
        T=U*A(J+2)+V*A(J+3)+W*A(J+4)+X*A(K+9)+
     +  Y*A(K+10)+Z*A(K+11)
        O=O+Q*SIN(T)
        P=P+Q*COS(T)
 104    CONTINUE
      GOTO 103
 105  O=O*A(23)
      Q=SQRT(O**2+P**2)
      IF(Q.LT.1.E-6)GOTO 102
      A(I+2)=57.2958*ATAN2(O,P)
      IF(A(I+2).LT.0.)A(I+2)=A(I+2)+360.
      IF(R.LT.A(32))GOTO 102
      F(1)=F(1)+R*R
      F(2)=F(2)+R*Q
      F(3)=F(3)+Q*Q
      M=M+1
      A(I+3)=Q/R
      GOTO 102
 106  J=(LX-LV)/8
      R=SQRT(ABS(1.-F(2)**2/(F(1)*F(3))))
      WRITE(LI,21)R,J,M,A(32)
      WRITE(*,21)R,J,M,A(32)
      CALL SXFL
      CALL SXTM(SL,LI)
 107  IF(ABS(A(39)).GT.0.5)GOTO 108
      IF(AP.GT.-8.E9)GOTO 108
      IF(LE.LT.LQ+4)GOTO 124
C
C PHAS reflections
C
 108  I=LQ+3
 109  I=I+2
      IF(I.GT.LE)GOTO 112
      J=NA
 110  J=J+4
      IF(J.GT.LD)GOTO 111
      IF(ABS(A(J)-A(I)).GT.0.5)GOTO 110
      NA=NA+4
      P=A(NA)
      A(NA)=A(J)
      A(J)=P
      P=A(J+1)
      A(J+1)=A(NA+1)
      A(NA+1)=P
      A(J+2)=A(NA+2)
      A(NA+2)=A(I+1)
      A(J+3)=A(NA+3)
      P=.1*P
      IF(AMOD(15.*AINT(P)-A(I+1)+7200.5,180.).LT.1.)GOTO 109
      IF(A(23).GT.P)GOTO 109
 111  CALL SXH2(A(I),X,Y,Z)
      WRITE(LI,22)X,Y,Z,A(I+1)
      GOTO 109
 112  IF(LX.LT.LV+8)GOTO 117
C
C Select partial structure phases
C
 113  IF(AP.LT.0.5)GOTO 117
      Q=.001
      I=NA
      J=0
 114  I=I+4
      IF(I.GT.LD)GOTO 115
      IF(Q.GT.A(I+3))GOTO 114
      J=I
      Q=A(I+3)
      GOTO 114
 115  IF(J.GT.0)GOTO 116
      IF(A(30).GT.8.E9)GOTO 124
      WRITE(LI,23)
      GOTO 119
 116  NA=NA+4
      CALL SXCA(A(NA),F,4)
      CALL SXCA(A(J),A(NA),4)
      CALL SXCA(F,A(J),4)
      A(NA+3)=0.
      AP=AP-1.
      GOTO 113
C
C Print fixed phases
C
 117  I=LX+4
 118  I=I+4
      IF(I.GT.LD)GOTO 119
      A(I+3)=AMOD(A(I+1),10.)
      GOTO 118
 119  IF(NA.EQ.LX+4)GOTO 123
      IF(A(30).GT.-.5)GOTO 123
      IF(A(30).LT.-8.E9)GOTO 123
      WRITE(LI,24)
      N=0
      I=LX+4
 120  I=I+4
      IF(I.GT.NA)GOTO 122
      IF(N.LT.4)GOTO 121
      WRITE(LI,25)(IP(J),IP(J+4),IP(J+8),IP(J+12),
     +G(J),IP(J+16),J=1,4)
      N=0
 121  CALL SXH2(A(I),X,Y,Z)
      N=N+1
      IP(N)=(I-LX-4)/4
      IP(N+4)=INT(X)
      IP(N+8)=INT(Y)
      IP(N+12)=INT(Z)
      G(N)=AMOD(A(I+1),10.)
      IP(N+16)=INT(AMOD(720.5+A(I+2),360.))
      GOTO 120
 122  WRITE(LI,25)(IP(J),IP(J+4),IP(J+8),IP(J+12),
     +G(J),IP(J+16),J=1,N)
 123  IF(LD.GT.NA)CALL SXQS(LD-NA,3,-4,A(NA+4))
 124  LZ=NA
      CALL SXCC
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SX2D(LM,LS,LU,F,G,A,B)
C
C Derive phase relations
C
      CHARACTER*1 IH(22),IT(76),IR(80),HK(80),KD
      CHARACTER*80 NM
      REAL F(LU),G(LU),A(LM),B(LS)
      INTEGER IP(27)
      COMMON/MEM/ST,SL,TC,TL,LR,LG,LH,LI,LP,LF,LA,LB,
     +LW,LY,LL,LQ,LE,LV,LX,LD,LZ,LJ,LN,LK,LC,HA,HD
      COMMON/WORD/IH,IT,IR,HK,NM,KD
C
   1  FORMAT(' Phi(calc) =',F6.0,'     Alpha(calc) =',F8.1)
   2  FORMAT(///' TPR FOR PHASE ANNEALING'//' Phase shift ',
     +'(degrees), +/-Code(2), +/-Code(3), where  Phi(1)',
     +' = Shift +/-Phi(2) +/-Phi(3)')
   3  FORMAT(//' Code(1) =',I5,5X,'h =',I3,'  k =',I3,
     +'  l =',I3,'    E =',F7.3,'    Alpha(est) =',F8.1,A1,
     +4X,'Restricted to',I4,' or',I4)
   4  FORMAT(9(I6,2I4))
   5  FORMAT(I8,' Reflections and',F8.0,
     +' unique TPR for phase annealing')
   6  FORMAT(I8,' Phases refined using',F9.0,' unique TPR',
     +/I8,' Reflections and',F9.0,' unique TPR for R(alpha)')
   7  FORMAT(/' Highest memory used to derive ',
     +'phase relations =',I8,' /',I8)
   8  FORMAT(I8,' Unique negative quartets found,',I6,
     +' used for phase refinement')
C
      NA=LZ
      IF(ABS(A(39)).LT.0.5)GOTO 149
      IF(ABS(ABS(A(54))-1.5).LT.0.8)GOTO 149
      MM=-1
C
C Temporarily exclude reflections outside 1A resolution sphere
C
      Q=.25*A(1)**2
      JR=LD
      J4=-3
      NT=NA
      I=NA
   9  I=I+4
      IF(I.GT.LD)GOTO 11
      CALL SXH2(A(I),X,Y,Z)
      IF(Q.GT.X**2*A(14)+Y**2*A(15)+Z**2*A(16)+Y*Z*A(17)+
     +X*Z*A(18)+X*Y*A(19))GOTO 10
      J4=J4+4
      IF(J4.GT.LS-3)GOTO 81
      CALL SXCA(A(I),B(J4),4)
      GOTO 9
  10  NT=NT+4
      CALL SXCA(A(I),A(NT),4)
      GOTO 9
  11  LD=NT
      I4=1
  12  IF(I4.GT.J4)GOTO 13
      NT=NT+4
      CALL SXCA(B(I4),A(NT),4)
      I4=I4+4
      GOTO 12
  13  SR=0.
      PA=.1
      PS=.1
      PF=.1
      A(27)=0.
      NF=1
      NB=NA
      NC=NA
      NY=INT(ABS(A(40)))
      IF(ABS(A(30)).LT.16000.)NY=MAX0(NY,INT(ABS(A(30)))+10)
      NZ=MIN0(LD,INT(1.3*ABS(A(72))+1.1)*4+LX)
      MA=LX+4
      NS=1
      ME=JR+4
      MR=INT(ABS(A(73)))
      IF(MR.LT.1)MR=1
      GOTO 76
C
C Scan part of reflection list
C
  14  L=NA
      MB=NT+((NZ-LX)/4)+3
  15  L=L+4
      IF(L.GT.NZ)GOTO 60
      CALL SXCC
      R=AMOD(A(L+1),10.)*A(45)
      NQ=MB
      IZ=(L-LX-4)/4
C
C Find TPR (as sum)
C
      IW=INT(A(L))
      PQ=.0001
      RR=.0001
      Q=1.
      PI=0.
      NN=NT+2
      I=ME
      K=I
      MZ=NT
  16  J=MZ
  17  MZ=K+2*((J-K)/4)
      IF(INT(A(MZ)).GE.IW)GOTO 16
      K=MZ
      IF(J.GT.K+2)GOTO 17
      IB=INT(A(J))
  18  I=I+2
      IA=IW-INT(A(I))
  19  IF(I.GE.J)GOTO 25
      IF(IA.GT.IB)GOTO 18
      IF(IA.EQ.IB)GOTO 20
      J=J-2
      IB=INT(A(J))
      GOTO 19
  20  NI=INT(A(I+1)*Q)
      NJ=INT(A(J+1))
C
C Reject sigma-1 TPR
C
      IF(IABS(NJ).GT.IABS(NI))GOTO 21
      K=NI
      NI=NJ
      NJ=K
  21  IF(A(23).GT.0.5)GOTO 22
      NJ=-IABS(NJ)
      NI=IABS(NI)
  22  IF(NI+NJ.EQ.0)GOTO 24
      N=IABS(NJ)
      M=IABS(NI)
      IF(M.EQ.IZ)GOTO 24
      IF(N.EQ.IZ)GOTO 24
C
C Rough alpha sums to select p.a. reflections
C
      IF(NS.EQ.2)GOTO 23
      IF(NS.EQ.4)GOTO 23
      K=N*4+LX+5
      NK=M*4+LX+5
      P=(AMOD(A(K),10.)*AMOD(A(NK),10.))**2
      PQ=PQ+P
      GOTO 24
C
C Phase shift
C
  23  IF(NQ+3.GT.LM)GOTO 81
      NQ=NQ+2
      A(NQ)=REAL(NI)
      Y=AMOD(ABS(A(I+1)),1.)
      IF(Q.LT.0.)Y=AMOD(1.008-Y,1.)
      A(NQ+1)=SIGN(REAL(N)+AMOD(ABS(A(J+1))+Y,1.),REAL(NJ))
  24  IF(Q.LT.0.)GOTO 26
      GOTO 18
C
C Find TPR (as difference)
C
  25  Q=-1.
      I=ME
      J=MZ
  26  I=I+2
      IA=IW+INT(A(I))
  27  IF(IA.LT.IB)GOTO 26
      IF(IA.EQ.IB)GOTO 20
      J=J+2
      IF(J.GE.NN)GOTO 28
      IB=INT(A(J))
      GOTO 27
  28  IF(NS.EQ.3)GOTO 29
      IF(NS.GT.1)GOTO 30
  29  A(L+3)=R*SQRT(PQ)
      GOTO 15
C
C Find statistical weights for TPR
C
  30  I=MB
  31  I=I+2
      IF(I.GT.NQ)GOTO 38
      Q=1.
      N=IABS(INT(A(I)))
      NI=4*N+LX+5
      M=IABS(INT(A(I+1)))
      NJ=4*M+LX+5
      J=I
  32  J=J+2
  33  IF(J.GT.NQ)GOTO 36
      IF(IABS(INT(A(J))).NE.N)GOTO 32
      IF(IABS(INT(A(J+1))).NE.M)GOTO 32
      Q=Q+1.
      T=A(J)
      V=A(J+1)
      A(J)=A(NQ)
      A(J+1)=A(NQ+1)
      NQ=NQ-2
      IF(A(L+1).LT.10.)GOTO 32
      K=720+INT(12.*AMOD(ABS(A(I+1)),1.))-INT(12.*AMOD(ABS(V),1.))
      IF(A(I)*T.GT.0.)GOTO 34
      IF(A(NI).LT.10.)GOTO 33
      K=K+INT(SIGN(.1*A(NI),A(I)))
  34  IF(A(I+1)*V.GT.0.)GOTO 35
      IF(A(NJ).LT.10.)GOTO 33
      K=K+INT(SIGN(.1*A(NJ),A(I+1)))
  35  IF(MOD(K,12).NE.0)Q=-9.E5
      GOTO 33
  36  IF(Q.LT.0.)GOTO 31
C
C Count TPR and sum for alpha(est)
C
      IF(NS.NE.4)GOTO 37
      IF(M.GT.IZ)GOTO 37
      PA=PA+1.
      IF(L.LE.NC)PS=PS+1.
  37  Q=SQRT(Q)
      X=AMOD(A(NJ),10.)*AMOD(A(NI),10.)
      IF(NJ.EQ.NI)Q=Q*(X-1.)/X
      A(I)=SIGN(ABS(A(I))+Q*.1,A(I))
      X=X*Q*R*ABS(A(22))
      RR=RR+X**2
      Y=X*SQRT(2.-A(23))
      Y=AMIN1(Y*(.5658+Y*(Y*.0106-.1304)),Y/(.56+Y))
      PQ=PQ+X*(X+2.*Y*PI)
      PI=PI+X*Y
      GOTO 31
C
C Write TPR to file
C
  38  A(L+3)=SQRT(PQ)
      IF(NS.EQ.2)GOTO 41
      NQ=NQ+2
      A(NQ)=0.
      A(NQ+1)=REAL(IZ)
      I=MB
  39  I=I+2
      IF(I.GT.NQ)GOTO 40
      F(NF)=A(I)
      F(NF+1)=A(I+1)
      NF=NF+2
      IF(NF.LT.LU)GOTO 39
      WRITE(LB)F
      NF=1
      GOTO 39
  40  IF(PA.GT.2.*PS+.5)GOTO 82
      GOTO 15
C
C Retain strongest TPR only for phase annealing
C
  41  IF(NQ-MB.LE.2*MR)GOTO 48
      NQ=MIN0(NQ,MB+2*LU)
      K=0
      N=MB
  42  N=N+2
      IF(N.GT.NQ)GOTO 43
      I=4*INT(ABS(A(N)))+LX
      J=4*INT(ABS(A(N+1)))+LX
      K=K+1
      G(K)=AMOD(ABS(A(N)),1.)*AMOD(A(I+5),10.)*AMOD(A(J+5),10.)
      GOTO 42
  43  J=K
  44  Q=8.E9
        DO 45 I=1,K
        IF(Q.LT.G(I))GOTO 45
        Q=G(I)
        N=I
  45    CONTINUE
      G(N)=9.E9
      J=J-1
      IF(J.GT.MR)GOTO 44
      RR=0.
      PI=0.
      PQ=0.
      K=0
      M=MB
      N=MB
  46  N=N+2
      IF(N.GT.NQ)GOTO 47
      K=K+1
      IF(G(K).GT.8.E9)GOTO 46
      M=M+2
      A(M)=A(N)
      A(M+1)=A(N+1)
      X=10.*R*G(K)*ABS(A(22))
      RR=RR+X**2
      Y=X*SQRT(2.-A(23))
      Y=AMIN1(Y*(.5658+Y*(Y*.0106-.1304)),Y/(.56+Y))
      PQ=PQ+X*(X+2.*Y*PI)
      PI=PI+X*Y
      GOTO 46
  47  NQ=M
      A(L+3)=SQRT(PQ)
C
C Reflection and TPR lists for phase annealing
C
  48  SR=SR+SQRT(RR)
      IF(A(70).LT.2.5)GOTO 57
      CALL SXH2(A(L),X,Y,Z)
      IF(L.EQ.MA+4)WRITE(LI,2)
      I=INT(X)
      J=INT(Y)
      K=INT(Z)
      Q=AMOD(A(L+1),10.)
      IF(A(L+1).GT.10.)GOTO 49
      WRITE(LI,3)IZ,I,J,K,Q,A(L+3)
      GOTO 50
  49  N=15*INT(.1*A(L+1))
      M=N-180
      WRITE(LI,3)IZ,I,J,K,Q,A(L+3),IH(20),M,N
  50  IF(A(L+2).LT.-.5)GOTO 53
      P=0.
      Q=0.
      N=MB
  51  N=N+2
      IF(N.GT.NQ)GOTO 52
      I=4*INT(ABS(A(N)))+LX
      J=4*INT(ABS(A(N+1)))+LX
      X=AMOD(ABS(A(N)),1.)*AMOD(A(I+5),10.)*AMOD(A(J+5),10.)
      Y=.0174533*(SIGN(A(I+6),A(N))+SIGN(A(J+6),A(N+1))+
     +30.*AINT(12.*AMOD(ABS(A(N+1)),1.)))
      P=P+X*COS(Y)
      Q=Q+X*SIN(Y)
      GOTO 51
  52  Q=10.*R*SQRT(P**2+Q**2)
      WRITE(LI,1)A(L+2),Q
  53  WRITE(LI,4)
      IP(1)=0
      M=0
      N=MB
  54  N=N+2
      IF(N.GT.NQ)GOTO 56
      IF(M.LT.27)GOTO 55
      WRITE(LI,4)IP
      M=0
  55  M=M+3
      IP(M-2)=INT(12.*AMOD(ABS(A(N+1)),1.))*30
      IP(M-1)=INT(A(N))
      IP(M)=INT(A(N+1))
      GOTO 54
  56  IF(M.GT.0)WRITE(LI,4)(IP(I),I=1,M)
      WRITE(LI,4)
C
C TPR list for phase annealing
C
  57  I=MB
  58  I=I+2
      IF(I.GT.NQ)GOTO 59
      IF(INT(ABS(A(I+1))).LT.IZ)PF=PF+1.
      MM=MM+2
      B(MM)=A(I)
      B(MM+1)=A(I+1)
      GOTO 58
  59  MM=MM+2
      IF(MM.GT.LS-2000)GOTO 81
      B(MM)=0.
      MM=MM+1
      B(MM)=REAL(IZ)
      B(MM+1)=A(L+3)
      A(27)=A(27)+A(L+3)
      GOTO 15
C
C Choose reflections for phase annealing
C
  60  IF(NS.NE.1)GOTO 68
      NB=NA
      NC=LX+4*INT(ABS(A(72))+1.1)
  61  Q=.01
      I=NB
  62  I=I+4
      IF(I.GT.NZ)GOTO 63
      IF(Q.GT.A(I+3))GOTO 62
      Q=A(I+3)
      M=I
      GOTO 62
  63  IF(Q.LT.0.1)GOTO 65
      K=M+3
        DO 64 I=M,K
        P=A(I)
        A(I)=A(NB+4)
        A(NB+4)=P
        NB=NB+1
  64    CONTINUE
      IF(NB.LT.NC)GOTO 61
  65  I=NB
  66  I=I+4
      IF(I.GT.LD)GOTO 67
      A(I+3)=AMOD(A(I+1),10.)
      GOTO 66
  67  IF(LD.GT.NB)CALL SXQS(LD-NB,3,-4,A(NB+4))
      NS=2
      NZ=NB
      MB=NT
      GOTO 76
C
C Optimize reflection set for phase refinement
C
  68  IF(NS.NE.2)GOTO 69
      MM=MM+2
      B(MM)=0.
      B(MM+1)=0.
      NS=3
      NC=MIN0(LD,LX+4+4*NY)
      GOTO 75
  69  IF(NS.NE.3)GOTO 82
      NF=1
      NC=NB
  70  IF(NC.GT.LX+4*NY)GOTO 74
      Q=.01
      I=NC
  71  I=I+4
      IF(I.GT.NZ)GOTO 72
      IF(Q.GT.A(I+3))GOTO 71
      Q=A(I+3)
      M=I
      GOTO 71
  72  IF(Q.LT.0.1)GOTO 74
      K=M+3
        DO 73 I=M,K
        P=A(I)
        A(I)=A(NC+4)
        A(NC+4)=P
        NC=NC+1
  73    CONTINUE
      GOTO 70
  74  NS=4
  75  NZ=NC
C
C Expanded list
C
  76  L=MA
      NT=ME
      A(NT)=0.
      P=0.
  77  L=L+4
      CALL SXCC
      NG=NT
      P=P+1.
      CALL SXH2(A(L),X,Y,Z)
        DO 80 M=75,LY,12
        W=AINT(1.001*(X*A(M)+Y*A(M+3)+Z*A(M+6)))+
     +  200.*(AINT(1.001*(X*A(M+1)+Y*A(M+4)+Z*A(M+7)))+
     +  200.*AINT(1.001*(X*A(M+2)+Y*A(M+5)+Z*A(M+8))))
        Q=1.-A(23)*(1.-SIGN(1.,W))
        W=ABS(W)
        J=NG
  78    J=J+2
        IF(J.GT.NT)GOTO 79
        IF(ABS(W-A(J)).GT.0.5)GOTO 78
        GOTO 80
  79    NT=NT+2
        A(NT)=W
        A(NT+1)=Q*(P+AMOD(900.004-Q*(X*A(M+9)+Y*A(M+10)+
     +  Z*A(M+11)),1.))
  80    CONTINUE
      IF(NT.GT.LM-2000)GOTO 81
      IF(L.LT.NZ)GOTO 77
      CALL SXQS(NT-ME,0,2,A(ME+2))
      IF(NS.EQ.1)GOTO 14
      L=NA
      MB=NT
      IF(NS.LT.3)GOTO 15
      NZ=MIN0(LD,NC+2*NY)
      IF(NS.NE.4)GOTO 15
      L=MA
      NZ=LD
      LD=JR
      GOTO 15
C
C Summarize phase relations
C
  81  CALL SXER('NOT ENOUGH MEMORY TO FIND ALL TPR - REDUCE NS OR NE')
  82  IF(PF.LT.0.5)CALL SXER('BAD TEXP, TREF OR PHAN INSTRUCTIONS')
      F(NF)=0.
      F(NF+1)=0.
      WRITE(LB)F
      REWIND LB
      I=(NB-LX-4)/4
      WRITE(LI,5)
      WRITE(LI,5)I,PF
      WRITE(*,5)I,PF
      I=(NC-LX-4)/4
      WRITE(LI,6)
      WRITE(LI,6)I,PS,IZ,PA
      WRITE(*,6)I,PS,IZ,PA
      CALL SXFL
      A(28)=REAL(4*IZ+LX+4)
      CALL SXTM(SL,LI)
      NY=NT+4
      N4=MM+2
      B(N4)=-1.
      L4=N4-2
      IF(A(42).LT.0.9999)GOTO 83
      IF(A(72).GT.0.)GOTO 131
C
C Prune expanded list
C
  83  R=.85+.05*A(23)
      IF(A(22).LT.0.)GOTO 85
      R=R-.1
      N=(NB+NC-2*LX)/8
      J=NT+1
      I=ME+1
      NT=ME
  84  I=I+2
      IF(I.GT.J)GOTO 85
      IF(INT(ABS(A(I))).GT.N)GOTO 84
      NT=NT+2
      A(NT)=A(I-1)
      A(NT+1)=A(I)
      GOTO 84
C
C Small E for NQR
C
  85  A(NT+2)=9.E7
      MZ=INT(AMIN1(.3*REAL(LS)+.7*REAL(N4),REAL(N4)+16000.))
  86  READ(LA)F
      CALL SXCC
      I=-2
  87  I=I+3
      IF(I.GT.LU-2)GOTO 86
      IF(.5.GT.F(I))GOTO 93
      CALL SXH2(F(I),X,Y,Z)
      P=X*X*A(14)+Y*Y*A(15)+Z*Z*A(16)+Y*Z*A(17)+X*Z*A(18)+X*Y*A(19)
      IF(.005.GT.P)GOTO 87
      P=EXP(P/A(1)**2)*F(I+2)
      IF(P.GT.R)GOTO 87
      M4=N4
        DO 90 N=75,LY,12
        Q=ABS(AINT(1.001*(X*A(N)+Y*A(N+3)+Z*A(N+6)))+
     +  200.*(AINT(1.001*(X*A(N+1)+Y*A(N+4)+Z*A(N+7)))+
     +  200.*AINT(1.001*(X*A(N+2)+Y*A(N+5)+Z*A(N+8)))))
        J4=M4
  88    J4=J4+2
        IF(J4.GT.N4)GOTO 89
        IF(ABS(Q-B(J4)).LT.0.5)GOTO 90
        GOTO 88
  89    N4=N4+2
        B(N4)=Q
        B(N4+1)=P
  90    CONTINUE
  91  IF(N4.LT.MZ)GOTO 87
      R=R-.01
      J4=MM+2
      K4=N4
      N4=J4
  92  J4=J4+2
      IF(J4.GT.K4)GOTO 91
      IF(B(J4+1).GT.R)GOTO 92
      N4=N4+2
      CALL SXCA(B(J4),B(N4),2)
      GOTO 92
  93  REWIND LA
      CALL SXQS(N4-MM-2,0,2,B(MM+4))
      B(N4+2)=9.E7
C
C Derive NQR
C
      J4=200+NC-LX
      I4=3*J4
      IF(A(23).LT.0.5)I4=(2*I4)/3
        DO 94 K=75,LY,12
        IF(ABS(A(K+9))+ABS(A(K+10))+ABS(A(K+11)).GT.0.1)I4=(2*I4)/3
        IF(I4.LT.J4)I4=J4
  94    CONTINUE
      IF(A(22).LT.0.)I4=(5*I4)/2
      NY=NT+3
      PZ=0.
      PY=9.E9
      M4=N4-2
      L4=M4
      MP=M4+5
      MZ=5*MIN0((LS-N4-111)/13,I4)+M4
      KZ=0
      K4=MM+2
      NL=0
      L=LX+4
  95  L=L+4
      IF(L.GT.NC)GOTO 130
      CALL SXCC
      NL=NL+1
      I4=N4+2
      N=NT
      NU=-1
      S=1.
      Q=-1.
      IW=INT(A(L))
      IB=INT(B(N4))-IW
      J=ME+2
      IF(IB.LT.INT(A(J)))GOTO 98
      NV=NT-2
  96  K=NV
  97  NV=J+2*((K-J)/4)
      IF(INT(A(NV)).GT.IB)GOTO 96
      J=NV
      IF(K.GT.J+2)GOTO 97
  98  IA=INT(A(J))
  99  I4=I4-2
      IB=INT(B(I4))-IW
 100  IF(IA.LT.IB)GOTO 99
      IF(IA.EQ.IB)GOTO 126
      J=J-2
      IF(J.LE.ME)GOTO 101
      IA=INT(A(J))
      GOTO 100
 101  S=-1.
      NU=0
      IB=INT(B(I4))
 102  J=J+2
      IA=IW-INT(A(J))
 103  IF(IA.GT.IB)GOTO 102
      IF(IA.EQ.IB)GOTO 126
      I4=I4-2
      IF(I4.LE.K4)GOTO 104
      IB=INT(B(I4))
      GOTO 103
 104  Q=1.
      NU=1
      IB=INT(A(J))
 105  I4=I4+2
      IA=IW+INT(B(I4))
 106  IF(IA.LT.IB)GOTO 105
      IF(IA.EQ.IB)GOTO 126
      J=J+2
      IF(J.GT.NT)GOTO 107
      IB=INT(A(J))
      GOTO 106
 107  J=NT
 108  J=J+3
      IF(J.GT.N)GOTO 95
      IS=INT(A(J))+IW
      I=J+3
      IB=-INT(A(I))
      K=N+3
 109  K=K-3
      IA=IS+INT(A(K))
 110  IF(K.LE.I)GOTO 108
      IF(IA.LT.IB)GOTO 109
      IF(IA.EQ.IB)GOTO 111
      I=I+3
      IB=-INT(A(I))
      GOTO 110
C
C Reject if equivalent quartet is positive
C
 111  P=2.-A(I+2)-A(J+2)-A(K+2)
      IF(P.LT.0.4)GOTO 109
      T=.01
      IF(LY.EQ.75)GOTO 120
      G(6)=A(I)
      G(9)=G(6)
      G(7)=A(J)
      G(10)=G(7)
      G(8)=A(K)
      CALL SXH2(A(L),X,Y,Z)
        DO 119 NQ=6,8
        R=ABS(A(L)+G(NQ))
        CALL SXH2(R,U,V,W)
          DO 118 NK=87,LY,12
          R=1.
 112      IF(ABS(U*R-U*A(NK)-V*A(NK+3)-W*A(NK+6)).GT.0.5)GOTO 117
          IF(ABS(V*R-U*A(NK+1)-V*A(NK+4)-W*A(NK+7)).GT.0.5)GOTO 117
          IF(ABS(W*R-U*A(NK+2)-V*A(NK+5)-W*A(NK+8)).GT.0.5)GOTO 117
          TT=X*A(NK)+Y*A(NK+3)+Z*A(NK+6)+200.*(X*A(NK+1)+Y*A(NK+4)+
     +    Z*A(NK+7)+200.*(X*A(NK+2)+Y*A(NK+5)+Z*A(NK+8)))
          MQ=NQ
 113      MQ=MQ+1
          PI=ABS(G(MQ)*R+TT)-.5
          PQ=PI+1.
          M=ME
          NJ=NT+2
 114      NI=M
 115      M=((NJ-NI)/4)*2+NI
          IF(M.EQ.NI)GOTO 116
          IF(M.EQ.NJ)GOTO 116
          IF(A(M).LT.PI)GOTO 114
          NJ=M
          IF(A(M).GT.PQ)GOTO 115
          GOTO 109
 116      T=T+.005
          IF(MQ.LT.NQ+2)GOTO 113
 117      R=-R
          IF(A(23)+R.LT.-.5)GOTO 112
 118      CONTINUE
 119    CONTINUE
C
C Retain strongest NQR only
C
 120  G(2)=REAL(NL)
      G(3)=AINT(A(J+1))+SIGN(.4*P,A(J+1))
      G(4)=AINT(A(I+1))+SIGN(T,A(I+1))
      G(5)=A(K+1)
      KZ=KZ+1
        DO 121 NJ=2,5
        NV=INT(ABS(G(NJ)))*4+LX+5
        P=P*AMOD(A(NV),10.)
 121    CONTINUE
      IF(P.LT.PZ)GOTO 109
      G(1)=P
      G(2)=G(2)+AMOD(ABS(A(I+1))+ABS(A(J+1))+ABS(A(K+1)),1.)
      IF(L4.LT.MP)L4=MP
      IF(MP.LT.MZ)GOTO 125
 122  PY=1.1*PY
      PZ=PY
      J4=N4-2
 123  J4=J4+5
      IF(J4.GE.MP)GOTO 124
      IF(B(J4).GT.PZ)GOTO 123
      CALL SXCA(B(J4),B(MP),5)
      MP=MP-5
      CALL SXCA(B(MP),B(J4),5)
      GOTO 123
 124  IF(MP.GT.L4-50)GOTO 122
 125  IF(PY.GT.P)PY=P
      CALL SXCA(G,B(MP),5)
      MP=MP+5
      GOTO 109
C
C Intermediate list for NQR search
C
 126  NV=INT(ABS(A(J+1)))
      IF(NV.GE.NL)GOTO 129
      K=NT
 127  K=K+3
      IF(K.GT.N)GOTO 128
      IF(NV.EQ.INT(ABS(A(K+1))))GOTO 129
      GOTO 127
 128  IF(N.GT.LM-5)GOTO 107
      N=N+3
      IF(NY.LT.N+2)NY=N+2
      A(N)=A(J)*S
      X=AMOD(ABS(A(J+1)),1.)
      IF(S.LT.0.)X=AMOD(1.008-X,1.)
      A(N+1)=SIGN(AINT(ABS(A(J+1)))+X,A(J+1)*S)
      A(N+2)=B(I4+1)**2
 129  IF(NU.LT.0)GOTO 99
      IF(NU.EQ.0)GOTO 102
      GOTO 105
C
C NQR summary
C
 130  I4=(L4-N4+2)/5
      WRITE(LI,8)
      WRITE(LI,8)KZ,I4
      WRITE(*,8)KZ,I4
      CALL SXFL
 131  LZ=ME
      J4=N4-2
      K4=MM-3
 132  J4=J4+5
      IF(J4.GT.L4)GOTO 133
      K4=K4+5
      CALL SXCA(B(J4),B(K4),5)
      GOTO 132
C
C Prepare NQR index tables
C
 133  J4=MM-3
      P=0.
      Q=0.0001
 134  J4=J4+5
      IF(J4.GT.K4)GOTO 135
      P=P+1.
      Q=Q+AMOD(ABS(B(J4+3)),1.)
      GOTO 134
 135  Q=P/Q
      NI=LZ+1
      NJ=(NC-LX-4)/4+LZ
        DO 136 IZ=NI,NJ
        A(IZ)=.1
 136    CONTINUE
      MP=K4+5
      IW=MP
      B(IW)=0.
      J4=MM-3
 137  J4=J4+5
      IF(J4.GT.K4)GOTO 139
      P=AMOD(B(J4+3),1.)*Q
      B(J4)=B(J4)*ABS(P)
      IB=J4+3
      B(IB)=AINT(B(IB))+0.01*P
        DO 138 KZ=J4,IB
        M=INT(ABS(B(KZ+1)))
        IW=IW+2
        B(IW)=-REAL(M)
        B(IW+1)=REAL(J4)
        M=M+LZ
        A(M)=A(M)+2.
 138    CONTINUE
      GOTO 137
 139  MZ=MP
        DO 140 I=NI,NJ
        J4=INT(A(I))
        A(I)=REAL(MZ)
        MZ=MZ+J4
 140    CONTINUE
      I4=MP
 141  I4=I4+2
      IF(I4.GT.IW)GOTO 143
 142  IF(B(I4).GT.0.)GOTO 141
      M=INT(.1-B(I4))+LZ
      A(M)=A(M)+2.
      M4=INT(A(M))
      Q=B(M4)
      B(M4)=-B(I4)
      IF(I4.EQ.M4)GOTO 141
      B(I4)=Q
      Q=B(M4+1)
      B(M4+1)=B(I4+1)
      B(I4+1)=Q
      GOTO 142
C
C Write expanded NQRs
C
 143  L=0
      NF=1
      K=LX+4
 144  K=K+4
      IF(K.GT.NC)GOTO 148
      L=L+1
      NJ=L+LZ
      N4=INT(A(NJ))
 145  IF(INT(B(N4)).LT.L)GOTO 144
      J4=INT(B(N4+1))
      N4=N4-2
      T=AMOD(B(J4+1),1.)
      WQ=AMOD(ABS(B(J4+2)),1.)*AMOD(ABS(B(J4+3)),1.)
      W=AINT(B(J4+1))
      X=AINT(B(J4+2))
      Y=AINT(B(J4+3))
      Z=AINT(B(J4+4))
 146  IF(INT(ABS(W)).NE.L)GOTO 147
      IF(K.LE.NA)GOTO 145
      S=SIGN(1.,W)
      G(NF)=T+REAL(L)
      G(NF+1)=SIGN(ABS(X)+WQ,S*X)
      G(NF+2)=S*Y
      G(NF+3)=S*Z
      NF=NF+4
      IF(NF.LT.LU-2)GOTO 145
      WRITE(LG)G
      CALL SXCC
      NF=1
      GOTO 145
 147  S=W
      W=X
      X=Y
      Y=Z
      Z=S
      GOTO 146
 148  G(NF)=0.
      WRITE(LG)G
      REWIND LG
      CALL SXTM(SL,LI)
      J4=MAX0(IW+1,L4+4)
      WRITE(LI,7)NY,J4
      A(32)=REAL(MM)
      A(29)=REAL(K4)
      P=ABS(A(71))
      IF(P.LT.1.E-8)P=1.E-8
      F(2)=4.*SR/AMAX1(1.,REAL(NB-NA))
      F(1)=-ALOG(P)/F(2)
      LR=NB
      LH=NC
 149  LE=NA
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SX2E(LM,LS,LU,F,G,A,B)
C
C Phase annealing and refinement
C
      CHARACTER*1 IH(22),IT(76),IR(80),HK(80),KD
      CHARACTER*8 KT
      CHARACTER*80 NM,KR
      REAL RR(128),H(128),C(128),D(128),E(128),FB(128),
     +FC(128),FD(128),FE(128),FF(128),RV(128),SN(15)
      REAL F(LU),G(LU),A(LM),B(LS)
      INTEGER IP(20),ID(31)
      COMMON/MEM/ST,SL,TC,TL,LR,LG,LH,LI,LP,LF,LA,LB,
     +LW,LY,LL,LQ,LE,LV,LX,LD,LZ,LJ,LN,LK,LC,HA,HD
      COMMON/WORD/IH,IT,IR,HK,NM,KD
C
   1  FORMAT(//' ONE-PHASE SEMINVARIANTS'//
     +'   h   k   l     E      P+    Phi'/)
   2  FORMAT(3I4,F8.3,F7.2,I6)
   3  FORMAT(3I4,F8.3,7X,I6)
   4  FORMAT(/' Expected value of Sigma-1 =',F6.3,A1,
     +'    Calculated value from given atoms =',F6.3)
   5  FORMAT(//' Following phases held constant with unit weights',
     +' for the initial 4 weighted'/' tangent cycles (before phase',
     +' annealing):'//'   h   k   l     E     Phase/Comment'/)
   6  FORMAT(3I4,F8.3,I6,' phase fixed for INIT and PHAN stages')
   7  FORMAT(3I4,F8.3,I6,'    sigma-1 =',F6.3)
   8  FORMAT(3I4,F8.3,'   random phase')
   9  FORMAT(3I4,F8.3,I6,' or',I4,' at random')
  10  FORMAT(//' No phases held constant')
  11  FORMAT(/' All other phases random with initial weights of',
     +F6.3,' replaced by 0.2*alpha'/' (or 1 if less) during first',
     +' 4 cycles - unit weights for all phases thereafter'/)
  12  FORMAT(///' UNIQUE NEGATIVE QUARTETS FOR PHASE ANNEALING'//
     +'  Prob.   Phi(1) Phi(2) Phi(3) Phi(4) = Phi  Error'/)
  13  FORMAT(F7.3,4I7,'  =',I5,I6)
  14  FORMAT(I8,' Unique NQR employed in phase annealing')
  15  FORMAT(/' Available memory restricts NQR to first',I5,
     +' P.A. reflections')
  16  FORMAT(I8,' Parallel refinements,  highest memory =',
     +I8,' /',I8)
  17  FORMAT(/' Initial weighted tangent cycle:',I4)
  18  FORMAT(/' Phase annealing cycle:',I6,'   Beta =',F9.5)
  19  FORMAT(/' Phase refinement cycle:',I4)
  20  FORMAT(' Ralpha',20F6.3)
  21  FORMAT(' Nqual ',20F6.3)
  22  FORMAT(' Mabs  ',20F6.3)
  23  FORMAT(/F10.0,' Phase sets refined - ',
     +'best is code',F10.0,'  with CFOM =',F8.4/)
  24  FORMAT(' STRUCTURE SOLUTION for ',76A1/)
  25  FORMAT(/
     +'   Try    Ralpha Nqual Sigma-1 M(abs) CFOM   Seminvariants')
  26  FORMAT(//' CFOM Range   Frequency'/31(/F6.3,' -',F6.3,I7))
  27  FORMAT(//' Phases for best solution'//
     +4('    Code   ','h   k   l   E   Phi')/)
  28  FORMAT(4(I7,'.',3I4,F6.3,I4))
  29  FORMAT(F9.0,F6.3,4F7.3,A1,13(1X,5A1))
  30  FORMAT(3I4,2F8.2,A1)
C
      RX=2097152.
      BB=F(1)
      W=0.
      S=0.
      NA=LE
      IF(ABS(A(39)).LT.0.5)GOTO 186
      BM=ABS(A(44))
      JH=INT(A(32))
      ND=INT(A(28))
      MZ=INT(A(29))
      ME=LZ
      NB=LR
      NC=LH
      JP=INT(ABS(A(43)))+4
      WP=10.*AMOD(ABS(A(67)),1.)-1.
      WZ=250.*A(45)
      IF(LY.EQ.75)WZ=WZ*2.
      IF(LY.EQ.87.OR.LY.EQ.99)WZ=WZ*(1.+.5*A(23))
C
C Seminvariants and normalizing factors
C
      TG=0.
      TS=0.
      NS=LZ
      I=LX+4
  31  I=I+4
      IF(I.GT.ND)GOTO 33
      TS=TS+A(I+3)
      IF(I.GT.NC)GOTO 31
      TG=TG+A(I+3)
      IF(A(23).LT.0.5)GOTO 32
      IF(A(I+1).LT.10.)GOTO 31
      IF(A(I+1).LT.120.)GOTO 31
      IF(A(I+1).GT.130.)GOTO 31
  32  IF(NS.GT.LM-2000)GOTO 31
      CALL SXH2(A(I),X,Y,Z)
      IF(AMOD(900.1+Z,2.)+AMOD(98.1+Y,2.)+
     +AMOD(98.1+X,2.).GT.0.5)GOTO 31
      NS=NS+3
      A(NS-2)=REAL((I-LX-3)/4)
      A(NS-1)=0.
      A(NS)=A(I)
      GOTO 31
C
C Sigma-1 summations
C
  33  MF=0
      SP=2.*A(68)-1.
      SM=2.*AMOD(A(69),1.)-1.
      SR=0.
      SG=0.
      MK=LZ+195
      IF(MK.GT.NS)MK=NS
      IF(NS.LE.LZ)GOTO 50
      N=LU-2
  34  READ(LA)F
      CALL SXCC
        DO 39 I=1,N,3
        IF(F(I).LT.0.5)GOTO 40
        N4=INT(F(I))
        P=F(I+2)**2-1.
        CALL SXH2(F(I),X,Y,Z)
        M=0
          DO 38 K=75,LY,12
          K4=INT(1.001*(X*A(K)+Y*A(K+3)+Z*A(K+6)))+
     +    200*(INT(1.001*(X*A(K+1)+Y*A(K+4)+Z*A(K+7)))+
     +    200*INT(1.001*(X*A(K+2)+Y*A(K+5)+Z*A(K+8))))
          I4=N4-K4
          S=A(23)
  35        DO 36 L=LZ+3,NS,3
            J4=INT(A(L))
            IF(I4.NE.J4)GOTO 36
            A(L-1)=A(L-1)+P*SIGN(1.,AMOD(999.75+
     +      X*A(K+9)+Y*A(K+10)+Z*A(K+11),1.)-.5)
            GOTO 37
  36        CONTINUE
  37      IF(S.GT.0.5)GOTO 38
          I4=N4+K4
          S=1.
          GOTO 35
  38      CONTINUE
  39    CONTINUE
      GOTO 34
  40  REWIND LA
      WRITE(LI,1)
      Q=0.
      V=0.
        DO 46 I=LZ+3,NS,3
        CALL SXH2(A(I),X,Y,Z)
        J=INT(X)
        K=INT(Y)
        L=INT(Z)
        M=4*INT(A(I-2))+LX+4
        T=AMOD(A(M+1),10.)
        R=T*A(I-1)
        P=TANH(.25*A(45)*R)
        A(I)=P
        U=ABS(R)
        Q=Q+U
        SR=SR+ABS(P)
        SG=SG+U*ABS(P)
        P=.5+.5*P
        IF(A(M+2).LT.-.5)GOTO 42
        KI=MOD(INT(720.5+A(M+2)),360)
        V=V+R*COS(.0174533*REAL(KI))
        IF(U.LT.0.0001)GOTO 41
        WRITE(LI,2)J,K,L,T,P,KI
        GOTO 44
  41    WRITE(LI,3)J,K,L,T,KI
        GOTO 44
  42    IF(U.LT.0.0001)GOTO 43
        WRITE(LI,2)J,K,L,T,P
        GOTO 44
  43    WRITE(LI,2)J,K,L,T
  44    IF(MOD(I-LZ,15).EQ.0)WRITE(LI,2)
        IF(M.GT.NB)GOTO 46
        IF(A(I).GT.SP)GOTO 45
        IF(A(I).GT.SM)GOTO 46
  45    A(M)=-ABS(A(M))
        MF=MF+1
  46    CONTINUE
      Q=1./AMAX1(Q,.0001)
        DO 47 I=LZ+2,NS,3
        A(I)=A(I)*Q
  47    CONTINUE
      SG=SG*Q
      SR=SR/(SR+4.)
      IF(A(41).GT.0.)SR=0.
      IF(ABS(V).LT.1.E-8)GOTO 48
      V=V*Q
      WRITE(LI,4)SG,IH(20),V
      GOTO 49
  48  WRITE(LI,4)SG
  49  IF(A(70).LT.0.5)WRITE(LI,23)
C
C Flag reflections involved in strongest NQR
C
  50  M=MF+INT(ABS(A(67)))
      IF(M.EQ.MF)GOTO 59
      MS=(NB-LX-4)/4
      IF(MS.GT.LU)MS=LU
        DO 51 I=1,MS
        G(I)=.0001/REAL(I)
  51    CONTINUE
      I4=JH-3
  52  I4=I4+5
      IF(I4.GT.MZ)GOTO 54
      T=B(I4)
      J4=I4
        DO 53 I=1,4
        J4=J4+1
        J=INT(ABS(B(J4)))
        IF(J.GT.MS)GOTO 53
        G(J)=G(J)+T
  53    CONTINUE
      GOTO 52
  54  T=0.
      L=0
        DO 55 J=1,MS
        IF(G(J).LT.T)GOTO 55
        L=J
        T=G(J)
  55    CONTINUE
      IF(L.EQ.0)GOTO 59
      G(L)=-1.
      K=4*L+LX+4
      IF(K.LE.NA)GOTO 54
      IF(A(K).LT.0.)GOTO 54
C
C Check if involved in TPR with two other INIT phases
C
      M4=-1
  56  N=0
  57  M4=M4+2
      I=INT(ABS(B(M4)))
      IF(I.EQ.0)GOTO 58
      I=4*I+LX+4
      IF(A(I).GT.0.)GOTO 57
      I=4*INT(ABS(B(M4+1)))+LX+4
      IF(A(I).LT.0.)N=N+1
      GOTO 57
  58  M4=M4+1
      IF(INT(ABS(B(M4))).NE.L)GOTO 56
      IF(N.NE.0)GOTO 54
      A(K)=-A(K)
      MF=MF+1
      IF(MF.LT.M)GOTO 54
C
C Print starting phases
C
  59  IF(A(70).LT.0.5)GOTO 68
      IF(MF+NA-LX-4.EQ.0)GOTO 66
      WRITE(LI,5)
      M=LZ+3
      L=LX+4
  60  L=L+4
      IF(L.GT.NB)GOTO 67
      P=AMOD(A(L+1),10.)
      CALL SXH2(ABS(A(L)),X,Y,Z)
      I=INT(X)
      J=INT(Y)
      K=INT(Z)
      IF(L.GT.NA)GOTO 61
      N=INT(A(L+2)+.5)
      WRITE(LI,6)I,J,K,P,N
      GOTO 60
  61  IF(A(L).GT.0.)GOTO 60
      IF(M.GT.NS)GOTO 64
  62  N=4*INT(A(M-2))+LX+4
      IF(N.GT.L)GOTO 64
      T=A(M)
      M=M+3
      IF(N.LT.L)GOTO 62
      IF(T.GT.SP)GOTO 63
      IF(T.GE.SM)GOTO 64
  63  N=0
      IF(T.LT.0.)N=180
      T=.5+.5*T
      WRITE(LI,7)I,J,K,P,N,T
      GOTO 60
  64  IF(A(L+1).GT.10.)GOTO 65
      WRITE(LI,8)I,J,K,P
      GOTO 60
  65  N=15*INT(.1*A(L+1))
      IZ=N-180
      WRITE(LI,9)I,J,K,P,IZ,N
      GOTO 60
  66  WRITE(LI,10)
      IF(ABS(A(30)).LT.0.5)GOTO 68
  67  WRITE(LI,11)WP
C
C List unique NQR for phase annealing
C
  68  ME=NS+1
      KI=0
      KJ=-1
      NJ=INT(ABS(A(74)))
      MS=(NB-LX-4)/4
      IF(A(70).LT.2.5)GOTO 72
      WRITE(LI,12)
      I4=JH-3
  69  I4=I4+5
      IF(I4.GT.MZ)GOTO 72
      IF(INT(B(I4+1)).GT.MS)GOTO 69
      IP(1)=INT(B(I4+1))
      IP(2)=INT(B(I4+2))
      IP(3)=INT(B(I4+3))
      IP(4)=INT(B(I4+4))
      IP(5)=INT(12.*AMOD(9999.52-B(I4+1),1.))*30
      J=5
      Q=7379.5-REAL(IP(5))
      T=1.
        DO 70 M=1,4
        L=IABS(IP(M))*4+LX+5
        T=T*AMOD(A(L),10.)
        P=A(L+1)
        IF(P.LT.-.5)GOTO 71
        IF(IP(M).LT.0)P=-P
        Q=Q+P
  70    CONTINUE
      J=6
      IP(6)=INT(AMOD(Q,360.))-179
  71  R=.5+.5*TANH(B(I4)*A(45)**2/(1.+A(23)))
      WRITE(LI,13)R,(IP(L),L=1,J)
      GOTO 69
C
C Read back and select expanded NQR for phase annealing
C
  72  READ(LG)G
      CALL SXCC
      MM=ME
      I=-3
  73  I=I+4
      IF(I.GT.LU-3)GOTO 72
      L=INT(G(I))
      K=4*L+LX+4
      IF(L.EQ.KJ)GOTO 80
      IF(KI.LE.NJ)GOTO 79
      ME=MIN0(ME,MM+4*LU)
      K=0
      J=MM-4
  74  J=J+4
      IF(J.GE.ME)GOTO 76
      K=K+1
      F(K)=AMOD(ABS(A(J+1)),1.)
        DO 75 M=J,J+3
        N=4*INT(ABS(A(M)))+LX
        F(K)=F(K)*AMOD(A(N+5),10.)
  75    CONTINUE
      GOTO 74
  76  Q=8.E9
        DO 77 J=1,KI
        IF(Q.LT.F(J))GOTO 77
        N=J
        Q=F(J)
  77    CONTINUE
      F(N)=9.E9
      K=K-1
      IF(K.GT.NJ)GOTO 76
      K=0
      M=ME
      ME=MM
      J=ME-4
  78  J=J+4
      IF(J.GE.M)GOTO 79
      K=K+1
      IF(F(K).GT.8.E9)GOTO 78
      CALL SXCA(A(J),A(ME),4)
      ME=ME+4
      GOTO 78
  79  IF(L.EQ.0)GOTO 81
      IF(L.GT.MS)GOTO 81
      KI=0
      KJ=L
      MM=ME
  80  IF(INT(ABS(G(I+1))).GT.MS)GOTO 73
      IF(INT(ABS(G(I+2))).GT.MS)GOTO 73
      IF(INT(ABS(G(I+3))).GT.MS)GOTO 73
      CALL SXCA(G(I),A(ME),4)
      KI=KI+1
      ME=ME+4
      IF(ME.LT.LM-500)GOTO 73
      WRITE(LI,15)L
  81  REWIND LG
      I=(ME-NS)/16
      WRITE(*,14)I
      CALL SXFL
      WRITE(LI,14)
      WRITE(LI,14)I
      A(ME)=0.
C
C Set up phase determination
C
      MH=1
      I4=NC-LX-4
      IF(A(39).LT.0.)GOTO 82
      X=2.*REAL(LS-JH-2)
      L4=INT(A(39)-.5)
      MH=MIN0(128,L4+1,INT(X/REAL(I4)))
      IF(A(70).GT.1.5)MH=MIN0(20,MH)
      K4=L4+MH
      MH=L4/(K4/MH)+1
  82  ML=(I4/2)*MH+JH+2
      WRITE(LI,'(/)')
      WRITE(LI,16)MH,ME,ML
      WRITE(*,16)MH,ME,ML
      MT=INT(ABS(A(41)))
      NE=JH+3
      ML=NE-MH
      MM=MH
      CALL SXTM(SL,LI)
      CALL SXPG(LI)
      WRITE(LI,24)IT
      WRITE(*,25)
      CALL SXFL
      RN=RX*AMOD(SQRT(.4321*ABS(A(39)+0.5)),1.)
      PQ=9.E9
      GF=9.E9
      TN=.3
      PS=0.
        DO 83 NJ=1,15
        SN(NJ)=SIN(REAL(NJ-1)*.523598)
  83    CONTINUE
        DO 84 NG=1,31
        ID(NG)=0
  84    CONTINUE
  85  CALL SXZA(FB,MM)
      CALL SXZA(FD,MM)
      CALL SXZA(FE,MM)
      CALL SXZA(FF,MM)
      CALL SXZA(C,MM)
      CALL SXZA(H,MM)
      CALL SXZA(D,MM)
      CALL SXZA(E,MM)
        DO 86 NH=1,MM
        FC(NH)=.0001
  86    CONTINUE
      N4=(NC-LX-4)/4
      JH=MH*N4
      BT=BB
C
C Starting phases
C
  87  N4=NE
        DO 99 I=1,MM
        RN=AMOD((1.+2.*AINT(RN/2.+.3))*5.,RX)
        RR(I)=RN
        IF(A(39).LT.0.)RR(I)=-A(39)
        R=RR(I)/RX
        RV(I)=R
        K4=N4
        N4=N4+1
        M=LZ+3
        L=LX+4
  88    L=L+4
        IF(L.GT.NC)GOTO 99
        IF(L.LE.NB)GOTO 89
        B(K4)=0.
        B(K4+JH)=0.
        GOTO 98
  89    W=AMOD(A(L+1),10.)
        IF(L.LE.NA)GOTO 90
        IF(ABS(A(30)).GT.0.5)GOTO 91
  90    Q=A(L+2)/360.
        GOTO 96
  91    IF(L.LE.NB)GOTO 92
        B(K4)=0.
        B(K4+JH)=0.
        GOTO 98
  92    IF(A(L).GT.0.)W=WP*W
        IF(M.GT.NS)GOTO 93
        IF(4*INT(A(M-2))+LX+4.GT.L)GOTO 93
        T=A(M)
        M=M+3
        IF(T.GT.SP)GOTO 94
        IF(T.LT.SM)GOTO 94
  93    R=AMOD((1.+2.*AINT(1048576.*R+.3))*5.,RX)/RX
        IF(A(23).GT.0.5)GOTO 95
        T=AMOD(R+.75,1.)-.5
  94    P=SIGN(1.,T)
        Q=0.
        GOTO 97
  95    Q=R
        IF(A(L+1).GT.10.)Q=AMOD(AINT(.1*A(L+1))/24.+9.25-Q,.5)-.25+Q
  96    Q=Q*6.28319
        P=COS(Q)
        Q=SIN(Q)
  97    B(K4)=W*P
        B(K4+JH)=W*((P+Q)*A(23)-P)
  98    K4=K4+MH
        GOTO 88
  99    CONTINUE
      IZ=1
      IF(ABS(A(30)).LT.0.5)IZ=5
      NZ=0
      GOTO 159
C
C Read in TPR for phase refinement
C
 100  READ(LG)G
      NG=1
 101  READ(LB)F
      M=-1
 102  M=M+2
      IF(M.GT.LU-1)GOTO 101
      P=F(M)
      T=ABS(P)
      XQ=F(M+1)
      Z=ABS(XQ)
      I4=INT(T)*MH+ML
      J4=INT(Z)*MH+ML
      IF(I4.EQ.ML)GOTO 111
C
C TPR sum
C
 103  KI=INT(T)*4+LX+5
      KJ=INT(Z)*4+LX+5
      T=10.*AMOD(T,1.)
      Z=AMOD(Z,1.)
      IF(A(23).GT.0.5)GOTO 105
      IF(Z.GT.0.25)J4=J4+JH
      IF(ABS(T-1.).GT.0.001)GOTO 104
      CALL SV21(D,B(I4),B(J4),MM)
      GOTO 109
 104  CALL SV22(D,B(I4),B(J4),T,MM)
      GOTO 109
 105  R=SIGN(1.,P)
      S=SIGN(1.,XQ)
      K=INT(12.*Z)
      V=SN(K+1)*T
      U=SN(K+4)*T
C
C Simplify TPR sums involving two restricted phases
C
      KJ=INT(.1*A(KJ))
      IF(KJ.LT.12)GOTO 108
      IF(ABS(V).GT.0.001)GOTO 108
      KI=INT(.1*A(KI))
      IF(KI.NE.12)GOTO 107
      T=U
      IF(KJ.EQ.12)GOTO 104
      IF(KJ.NE.18)GOTO 108
      T=T*S
      J4=J4+JH
 106  CALL SV22(E,B(I4),B(J4),T,MM)
      GOTO 109
 107  IF(KI.NE.18)GOTO 108
      T=U*R
      I4=I4+JH
      IF(KJ.EQ.12)GOTO 106
      T=-T*S
      J4=J4+JH
      IF(KJ.EQ.18)GOTO 104
      J4=J4-JH
      I4=I4-JH
 108  CALL SV23(D,E,B(I4),B(I4+JH),B(J4),B(J4+JH),R,S,U,V,MM)
C
C Next TPR for phase annealing
C
 109  IF(NZ.GT.0)GOTO 102
 110  M4=M4+2
      P=B(M4)
      XQ=B(M4+1)
      T=ABS(P)
      Z=ABS(XQ)
      I4=INT(T)*MH+ML
      J4=INT(Z)*MH+ML
      IF(I4.GT.ML)GOTO 103
C
C NQR sums
C
 111  IF(J4.EQ.ML)GOTO 132
      MP=INT(Z)
      IF(NZ.EQ.0)GOTO 116
 112  IF(MP.NE.INT(G(NG)))GOTO 118
      W=AMOD(G(NG),1.)
      X=G(NG+1)
      Y=G(NG+2)
      Z=G(NG+3)
 113  WQ=WZ*AMOD(ABS(X),1.)
      N4=INT(ABS(X))*MH+ML
      K4=INT(ABS(Y))*MH+ML
      L4=INT(ABS(Z))*MH+ML
      IF(A(23).GT.0.5)GOTO 114
      IF(W.GT.0.25)N4=N4+JH
      CALL SV24(H,B(N4),B(K4),B(L4),WQ,MM)
      GOTO 115
 114  I=INT(12.*W)
      Q=WQ*SN(I+1)
      P=WQ*SN(I+4)
      R=SIGN(1.,X)
      S=SIGN(1.,Y)
      T=SIGN(1.,Z)
      CALL SV25(H,C,B(N4),B(N4+JH),B(K4),B(K4+JH),B(L4),
     +B(L4+JH),R,S,T,P,Q,MM)
 115  NG=NG+4
      IF(NZ.EQ.0)GOTO 116
      IF(NG.LT.LU-2)GOTO 112
      READ(LG)G
      NG=1
      GOTO 112
 116  IF(IZ.LT.5)GOTO 117
      IF(MP.NE.INT(A(NG)))GOTO 117
      W=AMOD(A(NG),1.)
      X=A(NG+1)
      Y=A(NG+2)
      Z=A(NG+3)
      GOTO 113
C
C Phase restrictions
C
 117  M4=M4+1
      Z=B(M4+1)
 118  CALL SXCC
      L=4*INT(XQ)+LX+4
      P=AMOD(A(L+1),10.)
      IF(A(L+1).LT.10.)GOTO 120
      Q=.261799*AINT(.1*A(L+1))
      U=COS(Q)
      V=SIN(Q)
      IF(NZ.GT.0)GOTO 119
      CALL SV29(D,E,U,V,MM)
      GOTO 120
 119  CALL SV26(H,C,D,E,U,V,MM)
C
C Sum for figures of merit
C
 120  IF(NZ.GT.0)Z=A(L+3)
      ZG=1./(Z+5.)
      T=P*A(45)
      IF(NH.EQ.0)GOTO 122
      IF(A(23).GT.0.5)GOTO 121
      CALL SV27(H,D,FB,FC,FD,FE,FF,T,Z,ZG,NH)
      GOTO 122
 121  CALL SV28(H,C,D,E,FB,FC,FD,FE,FF,T,Z,ZG,NH)
 122  IF(L.LE.NC)GOTO 123
      CALL SV2H(H,C,D,E,MM)
      GOTO 109
C
C Derive new phases
C
 123  ZZ=(Z/T)**2
      Q=BT
      IF(IZ.LT.5)Q=.2
      T=T*Q
      IF(A(23).LT.0.5)GOTO 127
      IF(NZ.GT.0)GOTO 125
      IF(IZ.LT.5)GOTO 126
      IF(A(L+1).GT.10.)GOTO 124
      CALL SV2B(H,C,D,E,RV,B(J4),B(J4+JH),T,P,ZZ,MM)
      GOTO 109
 124  CALL SV2G(H,C,D,E,RV,B(J4),B(J4+JH),T,P,MM)
      GOTO 109
 125  IF(A(L+1).LT.10.)CALL SV2F(H,C,D,E,ZZ,MM)
      CALL SV2C(H,C,D,E,B(J4),B(J4+JH),P,MM)
      GOTO 131
 126  IF(A(L).GT.0.)CALL SV2J(D,E,B(J4),B(J4+JH),T,P,MM)
      GOTO 129
 127  IF(NZ.GT.0)GOTO 130
      IF(IZ.LT.5)GOTO 128
      CALL SV2E(H,D,RV,B(J4),B(J4+JH),T,P,MM)
      GOTO 131
 128  IF(A(L).GT.0.)CALL SV2I(D,B(J4),B(J4+JH),T,P,MM)
 129  IF(L.GT.LX+(IZ*(NB-LX))/3)GOTO 132
      GOTO 110
 130  CALL SV2D(H,D,B(J4),B(J4+JH),P,MM)
 131  IF(L.LT.NC)GOTO 109
      IF(NZ.EQ.MT)GOTO 109
C
C End of iteration
C
 132  IF(NH.EQ.0)GOTO 138
      IF(NZ.EQ.MT)GOTO 161
      P=TG
      IF(NZ.EQ.0)P=A(27)
      CALL SV2A(FB,FC,FD,FE,FF,P,NH)
      IF(NZ.GT.0)GOTO 134
      IF(IZ.GT.4)GOTO 133
      WRITE(LI,17)IZ
      GOTO 135
 133  WRITE(LI,18)IZ-4,BT
      GOTO 135
 134  WRITE(LI,19)NZ
 135    DO 136 K=1,NH
        IF(FD(K).GT.9.999)FD(K)=9.999
        IF(FE(K).GT.9.999)FE(K)=9.999
 136    CONTINUE
      WRITE(LI,20)(FD(K),K=1,NH)
      IF(IZ.GT.4)WRITE(LI,21)(FB(K),K=1,NH)
      WRITE(LI,22)(FE(K),K=1,NH)
      CALL SXZA(FB,NH)
      CALL SXZA(FD,NH)
      CALL SXZA(FE,NH)
      CALL SXZA(FF,NH)
        DO 137 K=1,NH
        FC(K)=.0001
 137    CONTINUE
 138  IF(IZ.GE.JP)GOTO 163
      IZ=IZ+1
      IF(IZ.GT.5)BT=BT/BM
C
C Calculate negative quartet sum for unique NQR
C
      IF(IZ.NE.5)GOTO 160
      IF(A(69).LT.1.)GOTO 160
      IF(MM.EQ.1)GOTO 158
      IF(MM.LE.(MH/4))GOTO 158
      IF(NG.GE.ME)GOTO 142
 139  W=A(NG)
      X=ABS(A(NG+1))
      IF(X.LT.W)GOTO 141
      Y=ABS(A(NG+2))
      IF(Y.LT.W)GOTO 141
      Z=ABS(A(NG+3))
      IF(Z.LT.W)GOTO 141
      WQ=AMOD(X,1.)
      M4=INT(W)*MH+ML
      N4=INT(X)*MH+ML
      K4=INT(Y)*MH+ML
      L4=INT(Z)*MH+ML
      IF(A(23).LT.0.5)GOTO 140
      IF(AMOD(W,1.).GT.0.25)M4=M4+JH
      CALL SV2K(FB,B(M4),B(N4),B(K4),B(L4),WQ,MM)
      GOTO 141
 140  I=INT(12.*AMOD(W,1.))
      Q=WQ*SN(I+1)
      P=WQ*SN(I+4)
      R=SIGN(1.,A(NG+1))
      S=SIGN(1.,A(NG+2))
      T=SIGN(1.,A(NG+3))
      CALL SV2L(FB,B(M4),B(M4+JH),B(N4),B(N4+JH),B(K4),
     +B(K4+JH),B(L4),B(L4+JH),R,S,T,P,Q,MM)
 141  NG=NG+4
      IF(NG.LT.ME)GOTO 139
C
C Calculate Mabs
C
 142  M4=-1
 143  M4=M4+2
      P=B(M4)
      XQ=B(M4+1)
      T=ABS(P)
      Z=ABS(XQ)
      I4=INT(T)*MH+ML
      J4=INT(Z)*MH+ML
      IF(I4.GT.ML)GOTO 148
      IF(J4.EQ.ML)GOTO 151
      M4=M4+1
      CALL SXCC
      L=4*INT(XQ)+LX+4
      P=AMOD(A(L+1),10.)
      IF(A(23).GT.0.5)GOTO 145
        DO 144 I=1,MM
        FE(I)=FE(I)+P*ABS(D(I))
 144    CONTINUE
      GOTO 147
 145    DO 146 I=1,MM
        FE(I)=FE(I)+P*SQRT(D(I)**2+E(I)**2)
 146    CONTINUE
      CALL SXZA(E,MM)
 147  CALL SXZA(D,MM)
      GOTO 143
 148  Z=AMOD(Z,1.)
      T=10.*AMOD(T,1.)
      IF(A(23).GT.0.5)GOTO 150
      IF(Z.GT.0.25)J4=J4+JH
      IF(ABS(T-1.).GT.0.001)GOTO 149
      CALL SV21(D,B(I4),B(J4),MM)
      GOTO 143
 149  CALL SV22(D,B(I4),B(J4),T,MM)
      GOTO 143
 150  R=SIGN(1.,P)
      S=SIGN(1.,XQ)
      K=INT(12.*Z)
      V=SN(K+1)*T
      U=SN(K+4)*T
      CALL SV23(D,E,B(I4),B(I4+JH),B(J4),B(J4+JH),R,S,U,V,MM)
      GOTO 143
C
C Save solutions with best (most negative) NQEST and largest Mabs
C
 151  T=-9.E9
        DO 152 I=1,MM
        IF(T.LT.FB(I))T=FB(I)
 152    CONTINUE
      T=T+1.
        DO 153 I=1,MM
        FB(I)=(FB(I)-T)*FE(I)**2
        FE(I)=0.
 153    CONTINUE
      NG=MM-INT(A(69))
 154  P=9.E9
      N=0
        DO 155 I=1,MM
        IF(P.LT.FB(I))GOTO 155
        P=FB(I)
        N=I
 155    CONTINUE
      IF(N.EQ.0)GOTO 157
      M4=N+NE-1
      N4=MM+NE-1
        DO 156 I=LX+8,NB,4
        Q=B(M4)
        B(M4)=B(N4)
        B(N4)=Q
        Q=B(M4+JH)
        B(M4+JH)=B(N4+JH)
        B(N4+JH)=Q
        M4=M4+MH
        N4=N4+MH
 156    CONTINUE
      Q=RR(N)
      RR(N)=RR(MM)
      RR(MM)=Q
      Q=RV(N)
      RV(N)=RV(MM)
      RV(MM)=Q
      FB(N)=FB(MM)
      FB(MM)=0.
      MM=MM-1
      IF(MM.GT.NG)GOTO 154
 157  CALL SXZA(FB,MM)
      IZ=1
      GOTO 87
C
C Set up next iteration
C
 158  MM=MH
 159  NH=MM
      IF(NH.GT.20)NH=20
      IF(A(70).LT.0.5)NH=0
      IF(TN.GT.0.7)NH=0
      IF(IZ.EQ.1)NH=0
      IF(A(70).GT.1.5)NH=MM
 160  M4=-1
      NG=NS+1
      GOTO 110
 161  IF(TN.LT.0.7)GOTO 162
      IF(A(70).LT.1.5)GOTO 163
 162  WRITE(LI,25)
      WRITE(LI,2)
 163  REWIND LB
      REWIND LG
      NZ=NZ+1
      IF(NZ.EQ.MT)NH=MM
      IF(NZ.LE.MT)GOTO 100
C
C Calculate and compare CFOM
C
      Q=9.E9
      R=0.
      V=0.
      T=0.
      M=0
        DO 167 K=1,MM
        L4=K-1+ML
        D(K)=0.
        E(K)=FE(K)/TS
        C(K)=FD(K)/FF(K)
        FE(K)=0.
        FF(K)=0.
        N=LZ
 164    N=N+3
        IF(N.GT.NS)GOTO 165
        I4=INT(A(N-2))*MH+L4
        FE(K)=FE(K)+B(I4)*A(N-1)
        GOTO 164
 165    P=C(K)
        IF(FE(K).LT.SG)P=P+SR*(FE(K)-SG)**2
        IF(ABS(FC(K)).LT.0.001)GOTO 166
        D(K)=FB(K)/FC(K)
        IF(D(K).GT.A(42))P=P+(D(K)-A(42))**2
 166    IF(P.GT.9.999)P=9.999
        I=INT(AMIN1(31.5,1.+50.*P))
        ID(I)=ID(I)+1
        H(K)=P
        IF(P.GT.Q)GOTO 167
        Q=P
        R=C(K)
        S=D(K)
        W=RR(K)
        T=E(K)
        Y=FE(K)
        M=K
 167    CONTINUE
        DO 171 K=1,MM
        IF(A(70).GT.1.5)GOTO 168
        IF(K.EQ.M)GOTO 168
        IF(H(K).GT.GF)GOTO 171
 168    J=1
        IR(1)=IH(21)
        IF(K.NE.M)IR(1)=IH(20)
        IF(Q.GE.PQ)IR(1)=IH(20)
        L4=K-1+ML
        N=LZ
 169    N=N+3
        IF(N.GT.MK)GOTO 170
        I4=INT(A(N-2))*MH+L4
        J=J+1
        IR(J)=IH(13)
        IF(B(I4).LT.0.)IR(J)=IH(12)
        GOTO 169
 170    WRITE(LI,29)RR(K),C(K),D(K),FE(K),E(K),H(K),(IR(I),I=1,J)
 171    CONTINUE
      WRITE(LI,29)
      I4=M
      M4=I4-1+ML
      K=0
      J=1
      N=LZ
 172  N=N+3
      IF(N.GT.MK)GOTO 173
      I4=INT(A(N-2))*MH+M4
      J=J+1
      IR(J)=IH(13)
      IF(B(I4).LT.0.)IR(J)=IH(12)
      GOTO 172
C
C Print and save results
C
 173  N=MIN0(26,J)
      IR(1)=IH(20)
      IF(PQ.GT.Q)IR(1)=IH(21)
      WRITE(*,29)W,R,S,Y,T,Q,(IR(I),I=1,N)
      KR=' Freq:'
      N=6
        DO 175 I=1,31
        WRITE(KT,'(I8)')ID(I)
        L=N+1
          DO 174 K=1,8
          IF(KT(K:K).EQ.IH(20))GOTO 174
          L=L+1
          IF(L.GT.69)GOTO 176
          KR(L:L)=KT(K:K)
 174      CONTINUE
        N=L
 175    CONTINUE
 176  I4=1
      IF(A(39).GT.0.)I4=INT(TN+REAL(MM))
      N=N+3
      KR(N-2:N)=' / '
      WRITE(KT,'(I8)')I4
        DO 177 K=1,8
        IF(KT(K:K).EQ.IH(20))GOTO 177
        N=N+1
        KR(N:N)=KT(K:K)
 177    CONTINUE
      WRITE(*,'(A)')KR(1:N)
      CALL SXFL
      IF(PQ.LE.Q)GOTO 180
      I=LX+4
 178  I=I+4
      IF(I.GT.NC)GOTO 179
      M4=M4+MH
      U=-9.E9
      IF(ABS(B(M4))+ABS(B(M4+JH)*A(23)).GT.0.01)U=
     +57.29578*ATAN2(B(M4+JH)*A(23),B(M4))
      IF(U.LT.0.)U=U+360.
      A(I+2)=U
      GOTO 178
 179  PQ=Q
      GF=PQ+0.05
      PS=W
C
C Terminate tangent refinement
C
 180  TN=TN+REAL(MM)
      CALL SXCC
      CALL SXTI(T)
      CALL SXFN(I)
      IF(I.LT.0)TL=-1.
      IF(T.GT.TL)GOTO 181
      IF(TN.LT.A(39))GOTO 85
 181    DO 182 I=1,31
        F(I)=REAL(I-1)*.02
 182    CONTINUE
      F(32)=9.999
      WRITE(LI,26)(F(I),F(I+1),ID(I),I=1,31)
      P=AMOD(100.*A(68),100.)
      IF(TN.LT.1.1)TN=1.1
      WRITE(LI,23)TN,PS,PQ
      WRITE(*,23)TN,PS,PQ
      CALL SXFL
      IF(A(70).GT.1.5)WRITE(LI,27)
      A(30)=0.
C
C Set up tangent expansion
C
      K=0
      I=NA
 183  M=0
 184  I=I+4
      IF(I.GT.NC)GOTO 185
      K=K+1
      A(I)=ABS(A(I))
      IF(A(I+2).LT.-8.E9)GOTO 184
      NA=NA+4
      P=A(NA)
      A(NA)=A(I)
      A(I)=P
      P=A(NA+1)
      A(NA+1)=A(I+1)
      A(I+1)=P
      P=A(NA+2)
      A(NA+2)=A(I+2)
      A(I+2)=P
      CALL SXH2(A(NA),X,Y,Z)
      M=M+1
      IP(M)=K
      IP(M+4)=INT(X)
      IP(M+8)=INT(Y)
      IP(M+12)=INT(Z)
      IP(M+16)=INT(A(NA+2)+.5)
      F(M)=AMOD(A(NA+1),10.)
      Q=.0174533*A(NA+2)
      P=F(M)*COS(Q)
      Q=F(M)*SIN(Q)
      IF(LW.EQ.1)WRITE(LP,30)IP(M+4),IP(M+8),IP(M+12),P,Q,KD
      IF(A(70).LT.1.5)GOTO 183
      IF(M.LT.4)GOTO 184
      WRITE(LI,28)(IP(J),IP(J+4),IP(J+8),IP(J+12),
     +F(J),IP(J+16),J=1,4)
      GOTO 183
 185  IF(M.GT.0)WRITE(LI,28)(IP(J),IP(J+4),
     +IP(J+8),IP(J+12),F(J),IP(J+16),J=1,M)
      M=0
      P=0.
      IF(LW.EQ.1)WRITE(LP,30)M,M,M,P,P,KD
      CALL SXTM(SL,LI)
 186  LE=NA
      RETURN
      END
C
C -----------------------------------------------------------
C
      SUBROUTINE SX2F(LM,LS,LU,F,G,A,B)
C
C Partial structure expansion
C
      CHARACTER*1 IH(22),IT(76),IR(80),HK(80),KD
      CHARACTER*4 KR
      CHARACTER*80 NM
      REAL F(LU),G(LU),A(LM),B(LS),E(10)
      COMMON/MEM/ST,SL,TC,TL,LR,LG,LH,LI,LP,LF,LA,LB,
     +LW,LY,LL,LQ,LE,LV,LX,LD,LZ,LJ,LN,LK,LC,HA,HD
      COMMON/WORD/IH,IT,IR,HK,NM,KD
C
   1  FORMAT(//' Tangent expanded to',I5,'  out of',I5,
     +'  E greater than',F7.3/' Highest memory used =',I6,' /',I6)
   2  FORMAT(' TPR search restricted by memory')
   3  FORMAT(/' ** Array A is too small for required Fourier',
     +' resolution **'/)
   4  FORMAT(//' FMAP and GRID set by program'//' FMAP',3I4/
     +' GRID',2(F10.3,2I4))
   5  FORMAT(//' Peak list optimization'
     +/' RE =',F6.3,' for',I4,' surviving atoms and',I5,
     +' E-values    Highest memory used =',I6,' /',I6)
   6  FORMAT(3I4,2F8.2,A1)
C
      NA=LE
      NZ=INT(A(54))
      IF(NZ.LT.4)GOTO 37
      IF(NZ.EQ.5)GOTO 37
      IF(NA.LE.LX-4)GOTO 37
      NT=1
      B(NT)=0.
      PQ=10.
      NB=LX+4
      I=NB
   7  I=I+4
      P=AMOD(A(I+1),10.)
      Q=1.74533E-2*A(I+2)
      A(I+2)=P*COS(Q)
      A(I+3)=P*SIN(Q)
      IF(I.LT.NA)GOTO 7
      IF(A(30).GT.8.E9)GOTO 33
C
C Expanded list
C
   8  IF(NT.GT.LS-6)GOTO 18
      NQ=NT
      I=NB
   9  I=I+4
      IF(I.GT.NA)GOTO 13
      CALL SXCC
      CALL SXH2(A(I),X,Y,Z)
        DO 12 J=75,LY,12
        P=6.283185*(X*A(J+9)+Y*A(J+10)+Z*A(J+11))
        U=COS(P)
        V=SIN(P)
        P=U*A(I+2)+V*A(I+3)
        Q=U*A(I+3)-V*A(I+2)
        W=AINT(1.001*(X*A(J)+Y*A(J+3)+Z*A(J+6)))+
     +  200.*(AINT(1.001*(X*A(J+1)+Y*A(J+4)+Z*A(J+7)))+
     +  200.*AINT(1.001*(X*A(J+2)+Y*A(J+5)+Z*A(J+8))))
        IF(W.LT.0.)Q=-Q
        W=ABS(W)
        K4=NQ
  10    K4=K4+3
        IF(K4.GT.NT)GOTO 11
        IF(ABS(W-B(K4)).LT.0.5)GOTO 12
        GOTO 10
  11    NT=NT+3
        B(NT)=W
        B(NT+1)=P
        B(NT+2)=Q*A(23)
        IF(NT.GT.LS-6)GOTO 13
  12    CONTINUE
      NQ=NT
      GOTO 9
C
C Sort expanded list
C
  13  NN=NT+3
      B(NN)=9.E9
      M4=NN/3
  14  M4=M4/2
      IF(M4.LT.1)GOTO 18
      CALL SXCC
      N4=M4*3
      K4=NN-N4
      J4=1
  15  I4=J4
  16  L4=I4+N4
      CALL SXCA(B(I4),F(1),3)
      CALL SXCA(B(L4),F(4),3)
      IF(F(1).LT.F(4))GOTO 17
      CALL SXCA(F(4),B(I4),3)
      CALL SXCA(F(1),B(L4),3)
      I4=I4-N4
      IF(I4.GT.1)GOTO 16
  17  J4=J4+3
      IF(J4.GT.K4)GOTO 14
      GOTO 15
C
C Tangent expansion
C
  18  NB=NA
      S=0.
      L=NB
  19  L=L+4
      IF(L.GT.LD)GOTO 31
      CALL SXCC
      P=AMOD(A(L+1),10.)
      U=0.
      V=0.
      Z=A(L)-.5
      Q=1.
      I4=1
      K4=I4
      M4=NT
  20  J4=M4
  21  M4=K4+3*((J4-K4)/6)
      IF(B(M4).GT.Z)GOTO 20
      K4=M4
      IF(J4.GT.K4+3)GOTO 21
      Z=Z+.5
  22  I4=I4+3
  23  IF(I4.GT.J4)GOTO 25
      X=Z-B(I4)-B(J4)
      IF(X.GT.0.5)GOTO 22
      IF(X.GT.-.5)GOTO 24
      J4=J4-3
      GOTO 23
  24  CALL SXCA(B(I4+1),F(1),2)
      CALL SXCA(B(J4+1),F(3),2)
      U=U+F(1)*F(3)-F(2)*F(4)*Q
      V=V+F(1)*F(4)+F(2)*F(3)*Q
      IF(Q.LT.0.)GOTO 26
      GOTO 22
  25  I4=1
      J4=M4
      Q=-1.
  26  I4=I4+3
  27  X=Z+B(I4)-B(J4)
      IF(X.LT.-.5)GOTO 26
      IF(X.LT.0.5)GOTO 24
      J4=J4+3
      IF(J4.LT.NN)GOTO 27
C
C Accept new phases
C
      IF(A(L+1).LT.10.)GOTO 28
      W=.261799*AINT(.1*A(L+1))
      X=COS(W)
      W=SIN(W)
      V=X*U+W*V
      U=X*V
      V=W*V
  28  W=SQRT(U*U+V*V)
      X=P*W*A(45)
      IF(S.LT.X)S=X
      IF(X.LT.PQ)GOTO 19
      NA=NA+4
      Q=A(L)
      T=A(L+1)
      J=L
  29  J=J-4
      IF(J.LT.NA)GOTO 30
      A(J+4)=A(J)
      A(J+5)=A(J+1)
      GOTO 29
  30  A(NA)=Q
      A(NA+1)=T
      A(NA+2)=P*U/W
      A(NA+3)=P*V*A(23)/W
      IF(NA-NB.LT.400)GOTO 19
  31  PQ=PQ*.8
      IF(S.LT.0.1)GOTO 32
      IF(NA.EQ.LD)GOTO 32
      IF(NA.GT.NB)GOTO 8
      PQ=.8*S
      GOTO 18
C
C Results to file
C
  32  I=(NA-LX-4)/4
      J=(LD-LX-4)/4
      P=ABS(A(26))
      WRITE(LI,1)I,J,P,LD+3,NN
      IF(NN.GT.LS-4)WRITE(LI,2)
      CALL SXTM(SL,LI)
  33  I=LX+4
  34  N=-2
  35  I=I+4
      IF(I.GT.NA)GOTO 36
      N=N+3
      F(N)=A(I)
      F(N+1)=A(I+2)
      F(N+2)=A(I+3)
      IF(N.LT.LU-4)GOTO 35
      WRITE(LA)F
      GOTO 34
  36  N=N+3
      F(N)=0.
      WRITE(LA)F
      REWIND LA
      LE=-1
  37  IF(NZ.EQ.0)GOTO 101
      IF(ABS(A(55)).GT.0.5)GOTO 66
C
C Find asymmetric unit of Fourier
C
      MY=LY
      IF(LX.LT.LV+8)GOTO 38
      CALL SXUS(A(LX),KR)
      IF(KR.EQ.'VECT')MY=75
  38  WP=1.
      IF(NZ.LT.4)WP=0.
      XJ=A(2)
      YJ=A(3)
      ZJ=A(4)
      IX=0
      IY=0
      IZ=0
      KP=1
      IF(A(23).LT.0.5)GOTO 39
      IF(NZ.LT.4)KP=2
  39  ML=LY+12
        DO 41 I=1,3
        J=I+30
          DO 40 K=I,J,6
          F(K)=9.E9
          F(K+3)=1.
  40      CONTINUE
  41    CONTINUE
        DO 53 L=ML,LL,4
          DO 52 N=75,MY,12
          W=A(L)
            DO 51 K=1,KP
            X=AMOD(A(N+9)*W*WP+A(L+1)+.501,1.)-.001
            Y=AMOD(A(N+10)*W*WP+A(L+2)+.501,1.)-.001
            Z=AMOD(A(N+11)*W*WP+A(L+3)+.501,1.)-.001
            IX=9
            IF(AMAX1(ABS(A(N+1)),ABS(A(N+2))).GT.0.01)GOTO 42
            IX=1
            IF(ABS(X).GT.0.01)GOTO 42
            IF(A(N)*W.LT.0.5)GOTO 42
            IX=0
  42        IY=9
            IF(AMAX1(ABS(A(N+3)),ABS(A(N+5))).GT.0.01)GOTO 43
            IY=1
            IF(ABS(Y).GT.0.01)GOTO 43
            IF(A(N+4)*W.LT.0.5)GOTO 43
            IY=0
  43        IZ=9
            IF(AMAX1(ABS(A(N+6)),ABS(A(N+7))).GT.0.01)GOTO 46
            IZ=1
            IF(ABS(Z).GT.0.01)GOTO 44
            IF(A(N+8)*W.LT.0.5)GOTO 44
            IZ=0
  44        IF(A(N+8)*W.LT.0.)GOTO 45
            IF(IZ.EQ.0)GOTO 46
            IF(IX+IY.LT.1)F(6)=AMIN1(F(6),Z)
            IF(IX.LT.1)F(12)=AMIN1(F(12),Z)
            IF(IY.LT.1)F(18)=AMIN1(F(18),Z)
            IF(F(30).GT.Z)F(30)=Z
            GOTO 46
  45        IF(IX+IY.LT.1)F(3)=AMIN1(F(3),Z)
            IF(IX.LT.1)F(9)=AMIN1(F(9),Z)
            IF(IY.LT.1)F(15)=AMIN1(F(15),Z)
            IF(F(27).GT.Z)F(27)=Z
  46        IF(IY.GT.1)GOTO 48
            IF(A(N+4)*W.LT.0.)GOTO 47
            IF(IY.EQ.0)GOTO 48
            IF(IX+IZ.LT.1)F(11)=AMIN1(F(11),Y)
            IF(IX.LT.1)F(5)=AMIN1(F(5),Y)
            IF(IZ.LT.1)F(35)=AMIN1(F(35),Y)
            IF(F(17).GT.Y)F(17)=Y
            GOTO 48
  47        IF(IX+IZ.LT.1)F(8)=AMIN1(F(8),Y)
            IF(IX.LT.1)F(2)=AMIN1(F(2),Y)
            IF(IZ.LT.1)F(32)=AMIN1(F(32),Y)
            IF(F(14).GT.Y)F(14)=Y
  48        IF(IX.GT.1)GOTO 50
            IF(A(N)*W.LT.0.)GOTO 49
            IF(IX.EQ.0)GOTO 50
            IF(IY+IZ.LT.1)F(16)=AMIN1(F(16),X)
            IF(IY.LT.1)F(22)=AMIN1(F(22),X)
            IF(IZ.LT.1)F(28)=AMIN1(F(28),X)
            IF(F(4).GT.X)F(4)=X
            GOTO 50
  49        IF(IY+IZ.LT.1)F(13)=AMIN1(F(13),X)
            IF(IY.LT.1)F(19)=AMIN1(F(19),X)
            IF(IZ.LT.1)F(25)=AMIN1(F(25),X)
            IF(F(1).GT.X)F(1)=X
  50        W=-W
  51        CONTINUE
  52      CONTINUE
  53    CONTINUE
        DO 54 I=1,27,13
        F(I+6)=F(I)
        F(I+9)=F(I+3)
  54    CONTINUE
        DO 55 I=3,13,5
        F(I+18)=F(I)
        F(I+21)=F(I+3)
  55    CONTINUE
        DO 57 I=1,31,6
        J=I+2
          DO 56 K=I,J
          F(K)=.5*F(K)
          IF(F(K).LT.1.)F(K+3)=.5*F(K+3)
          IF(F(K).GT.1.)F(K)=0.
  56      CONTINUE
  57    CONTINUE
C
C Set up FMAP and GRID
C
      RE=16.*AMIN1(SIN(1.74533E-2*A(5)),SIN(1.74533E-2*A(6)),
     +SIN(1.74533E-2*A(7)))**2*A(1)/SQRT(A(64))
      RR=1.
  58  U=9.E9
        DO 63 M=1,31,6
          DO 62 N=1,3
          K=1
          IF(.501.GT.F(M+5)*RR)GOTO 59
          K=2
  59      J=1
          IF(.501.GT.F(M+4)*RR)GOTO 60
          J=2
  60      V=REAL(J*K)*F(M+3)
          IF(V.GT.U)GOTO 61
          IF(U.GT.V+.01)W=9.E9
          U=V+.001
          X=YJ*REAL(J)-RE
          Y=ZJ*REAL(K)-RE
          Z=X*X+Y*Y
          IF(Z.GT.W)GOTO 61
          W=Z
          ER=AMAX1(X,0.)+AMAX1(Y,0.)
          A(55)=REAL(N)
          IX=INT(100.01*F(M+1))-J
          IY=INT(100.01*F(M+2))-K
          IZ=J
          KP=K
          A(56)=RR*AINT(3.5+100.*F(M+3)*XJ/RE)
          A(36)=F(M+3)*100./(ABS(A(56))-3.)
          A(33)=100.*F(M)-A(36)
  61      X=XJ
          XJ=YJ
          YJ=ZJ
          ZJ=X
          X=F(M)
          F(M)=F(M+1)
          F(M+1)=F(M+2)
          F(M+2)=X
          X=F(M+3)
          F(M+3)=F(M+4)
          F(M+4)=F(M+5)
          F(M+5)=X
  62      CONTINUE
  63    CONTINUE
      CALL SXUS(A(LX),KR)
      T=33999.
      IF(KR.EQ.'VECT')T=45999.
      IF(IZ+KP.LT.3)GOTO 65
      IF(ER.LT.RE)GOTO 65
      IF(A(20).LT.-8.E9)GOTO 65
      IF(REAL(LM).LT.T)GOTO 64
      RR=-1.
      GOTO 58
  64  WRITE(LI,3)
  65  J=INT(A(55))
      K=INT(A(56))
      L=NZ
      IF(NZ.EQ.2)L=6
      WRITE(LI,4)L,J,K,A(33),IX,IY,A(36),IZ,KP
      A(34)=IX
      A(35)=IY
      A(37)=IZ
      A(38)=KP
  66  IF(NZ.LT.7)GOTO 101
      IF(LE.LT.0)GOTO 101
      A(54)=A(54)-1.
C
C Set up peaklist optimisation
C
      LZ=LD+8
      N4=-8
      RC=0.
      HM=0.
      S=27.*(ABS(A(57))-5.)
      IF(S.LT.27.)S=27.
      R=S
      T=0.
      I=LV
  67  I=I+8
      IF(I.GT.LD)GOTO 68
      J=INT(A(I+1)*.001)*5+LJ
      A(I+6)=A(J)
      IF(I.GT.LX)GOTO 67
      IF(HM.LT.A(J))HM=A(J)
      R=R+A(I+5)*A(J)**2
      GOTO 67
  68  READ(LF)F
      CALL SXCC
        DO 73 I=1,LU-2,3
        IF(F(I).LT.0.5)GOTO 74
        IF(F(I+1).LT.0.)GOTO 73
        P=AMOD(F(I+1),10.)
        IF(ABS(P**2-.8).LT.T)GOTO 73
  69    IF(N4+16.LT.LS)GOTO 72
        T=T+.05
        J4=-8
  70    J4=J4+9
  71    IF(J4.GT.N4)GOTO 69
        CALL SXCA(B(N4+4),E,3)
        IF(ABS(E(2)**2-.8).GT.T)GOTO 70
        CALL SXCA(E,B(J4+4),3)
        N4=N4-9
        GOTO 71
  72    N4=N4+9
        B(N4+6)=F(I)
        B(N4+5)=P
        B(N4+4)=F(I+2)
  73    CONTINUE
      GOTO 68
  74  REWIND LF
        DO 77 I4=1,N4,9
        CALL SXH2(B(I4+6),X,Y,Z)
        B(I4)=X
        B(I4+1)=Y
        B(I4+2)=Z
        Q=SQRT(X*X*A(14)+Y*Y*A(15)+Z*Z*A(16)+Y*Z*A(17)+
     +  X*Z*A(18)+X*Y*A(19))/A(1)
        TB=47.*Q*SQRT(Q)
        B(I4+7)=TB
        T=S*(3.834/(3.834+TB))**2
        J=LV
  75    J=J+8
        IF(J.GT.LX)GOTO 76
        K=INT(A(J+1)*.001)*5+LJ
        W=SQRT(A(K)*SQRT(A(K)))
        T=T+A(J+5)*(W*A(K)/(W+TB))**2
        GOTO 75
  76    P=B(I4+5)
        TB=SQRT(R/T)
        B(I4+8)=TB
        P=P/TB
        B(I4+3)=P
        RC=RC+P*P
        B(I4+5)=0.
        B(I4+6)=0.
  77    CONTINUE
      J=LZ
        DO 78 I=1,1251
        A(J)=SIN(6.283185E-3*REAL(I-1))
        J=J+1
  78    CONTINUE
      IX=(LD-LX)/16
      IZ=LV+1
      NA=LD+8
      KP=(LD-LV)/8
      SM=0.
C
C Scan peaks
C
      IY=0
  79  I=NA
  80  I=I-8
      IF(I.LT.IZ)GOTO 93
      IF(ABS(A(I+5)).LT.1.E-8)GOTO 80
      CALL SXCC
      NK=-2
        DO 81 J=75,LY,12
        NK=NK+3
        G(NK)=1000.*(A(I+2)*A(J)+A(I+3)*A(J+1)+
     +  A(I+4)*A(J+2)+A(J+9))
        G(NK+1)=1000.*(A(I+2)*A(J+3)+A(I+3)*A(J+4)+
     +  A(I+4)*A(J+5)+A(J+10))
        G(NK+2)=1000.*(A(I+2)*A(J+6)+A(I+3)*A(J+7)+
     +  A(I+4)*A(J+8)+A(J+11))
  81    CONTINUE
  82  RA=0.
      RB=0.
C
C Triclinic inner loop
C
      X=G(1)
      Y=G(2)
      Z=G(3)
      W=SQRT(A(I+6)*SQRT(A(I+6)))
      T=W*A(I+6)*A(I+5)*A(24)
      IF(LY.NE.75)GOTO 84
        DO 83 J4=1,N4,9
        CALL SXCA(B(J4),E,8)
        KZ=LZ+INT(AMOD(1000000.5+E(1)*X+E(2)*Y+E(3)*Z,1000.))
        O=T/(W+E(8))
        E(9)=E(6)-A(KZ+250)*O
        E(10)=E(7)-A(KZ)*O*A(23)
        S=(E(9)**2+E(10)**2)/E(5)
        RA=RA+S
        IF(IX.GE.IY)CALL SXCA(E(9),B(J4+5),2)
        RB=RB+E(4)*SQRT(S)
  83    CONTINUE
      GOTO 91
C
C Monoclinic inner loop
C
  84  XJ=G(4)
      YJ=G(5)
      ZJ=G(6)
      IF(LY.NE.87)GOTO 86
        DO 85 J4=1,N4,9
        CALL SXCA(B(J4),E,8)
        KZ=LZ+INT(AMOD(1000000.5+E(1)*X+E(2)*Y+E(3)*Z,1000.))
        KY=LZ+INT(AMOD(1000000.5+E(1)*XJ+E(2)*YJ+E(3)*ZJ,1000.))
        O=T/(W+E(8))
        E(9)=E(6)-O*(A(KZ+250)+A(KY+250))
        E(10)=E(7)-A(23)*O*(A(KZ)+A(KY))
        S=(E(9)**2+E(10)**2)/E(5)
        RA=RA+S
        IF(IX.GE.IY)CALL SXCA(E(9),B(J4+5),2)
        RB=RB+SQRT(S)*E(4)
  85    CONTINUE
      GOTO 91
C
C Orthorhombic inner loop
C
  86  IF(LY.NE.111)GOTO 88
      XK=G(7)
      YK=G(8)
      ZK=G(9)
      XL=G(10)
      YL=G(11)
      ZL=G(12)
        DO 87 J4=1,N4,9
        CALL SXCA(B(J4),E,8)
        KZ=LZ+INT(AMOD(1000000.5+E(1)*X+E(2)*Y+E(3)*Z,1000.))
        KY=LZ+INT(AMOD(1000000.5+E(1)*XJ+E(2)*YJ+E(3)*ZJ,1000.))
        KX=LZ+INT(AMOD(1000000.5+E(1)*XK+E(2)*YK+E(3)*ZK,1000.))
        KW=LZ+INT(AMOD(1000000.5+E(1)*XL+E(2)*YL+E(3)*ZL,1000.))
        O=T/(W+E(8))
        E(9)=E(6)-O*(A(KZ+250)+A(KY+250)+A(KX+250)+A(KW+250))
        E(10)=E(7)-A(23)*O*(A(KZ)+A(KY)+A(KX)+A(KW))
        S=(E(9)**2+E(10)**2)/E(5)
        RA=RA+S
        IF(IX.GE.IY)CALL SXCA(E(9),B(J4+5),2)
        RB=RB+SQRT(S)*E(4)
  87    CONTINUE
      GOTO 91
C
C Inner loop for other crystal systems
C
  88    DO 90 J4=1,N4,9
        CALL SXCA(B(J4),E,8)
        X=0.
        Y=0.
          DO 89 K=1,NK,3
          KZ=LZ+INT(AMOD(1000000.5+E(1)*G(K)+E(2)*G(K+1)+
     +    E(3)*G(K+2),1000.))
          X=X+A(KZ+250)
          Y=Y+A(KZ)
  89      CONTINUE
        O=T/(W+E(8))
        E(9)=E(6)-X*O
        E(10)=E(7)-Y*A(23)*O
        S=(E(9)**2+E(10)**2)/E(5)
        RA=RA+S
        IF(IX.GE.IY)CALL SXCA(E(9),B(J4+5),2)
        RB=RB+SQRT(S)*E(4)
  90    CONTINUE
  91  W=RB*RB/(RA*RC)
      IF(IY.LT.0)GOTO 92
      IF(IY.EQ.0)GOTO 80
      IF(W.LT.SM)GOTO 80
      IY=-IY
      GOTO 82
C
C Eliminate peak
C
  92  A(I+5)=0.
      KP=KP-1
      IX=IX-1
      IY=-IY
      SM=W
  93  IF(IY.EQ.IX+1)GOTO 96
      IF(IY.NE.0)GOTO 95
      SM=W
      IZ=LX+1
        DO 94 J4=1,N4,9
        B(J4+5)=-B(J4+5)
        B(J4+6)=-B(J4+6)
  94    CONTINUE
  95  IF(IX.LT.1)GOTO 96
      IF(I.GT.IZ-1)GOTO 80
      IY=IX+1
      GOTO 79
C
C Write weighted Fourier file, print R-index
C
  96  I=1
      G(1)=-.5
      G(2)=.8
      G(3)=-.02
      G(4)=-.5
      G(5)=1.9
      G(6)=-.02
      G(7)=1.
      G(8)=2.4
      G(9)=-.01
      X=0.
      Y=0.
        DO 97 J4=1,N4,9
        X=X+B(J4+5)**2+B(J4+6)**2
        Y=Y+B(J4+3)**2
  97    CONTINUE
      X=SQRT(Y/X)
        DO 100 J4=1,N4,9
        CALL SXCA(B(J4),E,9)
        F(I)=E(1)+200.*(E(2)+200.*E(3))
        W=1.
        IF(HM.GT.18.5)GOTO 99
        U=A(14)*E(1)**2+A(15)*E(2)**2+A(16)*E(3)**2+
     +  A(17)*E(2)*E(3)+A(18)*E(1)*E(3)+A(19)*E(1)*E(2)
        U=U*78.9568/A(1)**2
        S=SQRT(U+U)
          DO 98 K=1,7,3
          V=G(K+1)*S
          W=W+G(K)*SIN(V)*EXP(U*G(K+2))/V
  98      CONTINUE
        W=SQRT(W)
  99    U=X*E(6)
        V=X*E(7)
        S=SQRT(U**2+V**2)
        O=SQRT(1./E(5))
        T=100.*W*(2.*E(4)*TANH(S*O*E(4)*E(9)**2)/S-O)
        IF(A(54).GT.6.5)T=T*E(9)
        F(I+1)=U*T
        F(I+2)=V*T
        KI=INT(E(1))
        KJ=INT(E(2))
        KK=INT(E(3))
        IF(NZ-LW.EQ.5)WRITE(LP,6)KI,KJ,KK,F(I+1),F(I+2),KD
        I=I+3
        IF(I.LT.LU-1)GOTO 100
        WRITE(LA)F
        I=1
 100    CONTINUE
      F(I)=0.
      WRITE(LA)F
      REWIND LA
      S=SQRT(1.-SM)
      I4=N4+8
      J4=I4/9
      WRITE(LI,5)S,KP,J4,LZ+1250,I4
      WRITE(*,'(A,F6.3,A,I4,A,I6,A)')' RE =',S,' for',KP,
     +' atoms and',J4,' E-values'
      CALL SXFL
      M=0
      P=0.
      IF(NZ-LW.EQ.5)WRITE(LP,6)M,M,M,P,P,KD
      CALL SXTM(SL,LI)
 101  LE=0
      I=LV
 102  I=I+8
      IF(I.GT.LX)GOTO 103
      CALL SXUS(A(I),KR)
      IF(KR.EQ.'VECT')GOTO 103
      J=INT(.001*A(I+1))*5+LJ
      A(I+7)=(.1+A(J+1))**2
      GOTO 102
 103  RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SX2G(LM,LS,LU,F,G,A,B)
C
C Pattersons, E-maps and peaksearch
C
      CHARACTER*1 IH(22),IT(76),IR(80),HK(80),KD
      CHARACTER*4 KR,KS
      CHARACTER*80 NM
      INTEGER IP(53)
      REAL F(LU),G(LU),A(LM),B(LS),FI(103),GC(103),GS(103)
      COMMON/MEM/ST,SL,TC,TL,LR,LG,LH,LI,LP,LF,LA,LB,
     +LW,LY,LL,LQ,LE,LV,LX,LD,LZ,LJ,LN,LK,LC,HA,HD
      COMMON/WORD/IH,IT,IR,HK,NM,KD
C
   1  FORMAT(//' Patterson vector superposition minimum ',
     +'function for ',76A1/)
   2  FORMAT(' Patt. sup. on vector ',A,3F8.4,'   Height',F5.0,
     +'   Length',F6.2)
   3  FORMAT(' Patterson superposition on input vector ',A,3F8.4)
   4  FORMAT(' Fourier and peaksearch')
   5  FORMAT(' Patterson and peaksearch')
   6  FORMAT('PATT',2I4,'      GRID',2(F8.3,2I3),A1)
   7  FORMAT(I3,I2,25I3,A1/26I3,A1)
   8  FORMAT(//' Super-sharp Patterson for ',76A1)
   9  FORMAT(//' Patterson for ',76A1)
  10  FORMAT(//' E-Fourier for ',76A1)
  11  FORMAT(/' Maximum =',F8.2,',  minimum =',F8.2,
     +6X,' highest memory used =',I6,' /',I6,A1,5X,'disk mode')
  12  FORMAT(/' Rms Patterson density excluding points close to the ',
     +'origin or an equivalent'/' lattice point is',F8.2,
     +//10X,'X',7X,'Y',7X,'Z',5X,'Weight  Peak   Sigma  Length'/)
  13  FORMAT(1X,A4,3F8.4,F7.0,F8.0,2F8.2)
  14  FORMAT(//' Heavy-atom assignments:'//10X,'x',7X,'y',7X,
     +'z    s.o.f.   Height'/)
  15  FORMAT(1X,A4,4F8.4,F8.1)
  16  FORMAT(//' Vectors selected for Patterson superposition:'//
     +' Vector   X',7X,'Y',7X,'Z     Weight  Peak  Length'/)
C
      LD=LX
      LK=0
      RR=.1
      IF(AMAX1(A(5),A(6),A(7)).GT.110.)RR=.3
      NZ=INT(A(54))
      IF(NZ.LT.4)LK=-1
      IF(NZ.EQ.0)LK=0
      IF(NZ.GT.6)LK=1
      IF(NZ.EQ.6)NZ=4
      IF(NZ.GT.6)NZ=6
      IF(NZ.EQ.0)GOTO 107
      IF(ABS(A(57)).LT.0.5)GOTO 107
      SP=0.
      PP=0.0001
      IF(A(20).LT.-8.E9)A(56)=ABS(A(56))
      MQ=53
      IF(A(56).LT.0.)MQ=103
      MZ=0
      MY=LY
      JL=LL
      L4=0
      QT=A(23)
      XV=0.
      YV=0.
      ZV=0.
      MI=2
      CALL SXUS(A(LX),KR)
      IF(KR.NE.'VECT')GOTO 19
      CALL SXPG(LI)
      WRITE(LI,1)IT
      CALL SXUS(A(LX+1),KR)
      IF(A(LX+6).LT.0.)GOTO 17
      WRITE(LI,2)KR,A(LX+2),A(LX+3),A(LX+4),A(LX+6),A(LX+7)
      WRITE(*,2)KR,A(LX+2),A(LX+3),A(LX+4),A(LX+6),A(LX+7)
      GOTO 18
  17  WRITE(LI,3)KR,A(LX+2),A(LX+3),A(LX+4)
      WRITE(*,3)KR,A(LX+2),A(LX+3),A(LX+4)
  18  A(57)=AINT(ABS(A(22)))
      MY=75
      MI=4
      MZ=MQ**2
      IF(QT.LT.0.5)JL=(LL+LY+8)/2
      QT=1.
      XV=A(LX+2)*50.
      YV=A(LX+3)*50.
      ZV=A(LX+4)*50.
      LX=LV
      GOTO 21
  19  IF(NZ.GT.3)GOTO 20
      WRITE(*,5)
      IF(A(20).LT.-8.E9)GOTO 21
      LV=LQ-3+8*INT(ABS(A(21)))
      LX=LV
      GOTO 21
  20  WRITE(*,4)
  21  IF(NZ.LT.4)GOTO 22
      IF(NZ.EQ.5)GOTO 22
      LX=MIN0(LX,LV+8*INT(ABS(A(31))))
      RR=.5
  22  LD=LX
      TP=A(LX+6)
      A(LX+6)=9.E9
      P=ABS(A(57))
      IF(A(54).GT.8.5)P=P/(A(54)-7.)
      MP=INT(P)*8+LX
      A(MP+6)=0.
      ML=LY+12
      NX=INT(ABS(A(56)))
      LZ=MP+16
      MW=MQ**2
      MG=MW-MQ-MQ
      MT=3*MW
      CALL SXFL
      IF(LZ+MZ+MT+200.GT.LM)GOTO 40
      NL=0
      NH=LZ+8134
      CALL SXZA(A(LZ),8135)
      MA=MAX0(MIN0(INT(ABS(A(55))),3),1)
      MR=LZ+MZ+MT
      NA=NH-3
      SS=0.
      ZZ=A(33)
      KP=1
      NF=1
      NG=1
      WP=1.
      IF(NZ.GT.3)GOTO 24
      WP=0.
      IF(QT.LT.0.5)GOTO 23
      KP=2
C
C Dump Patterson parameters
C
  23  IF(A(20).GT.-8.E9)GOTO 24
      I=INT(A(55))
      J=INT(A(56))-2
      M=INT(A(37))
      N=INT(A(38))
      K=M+INT(A(34))
      L=N+INT(A(35))
      P=A(33)+A(36)
      WRITE(LP,6)I,J,P,K,L,A(36),M,N,KD
C
C Read reflections
C
  24  READ(LA)F
      CALL SXCC
      I=-2
  25  I=I+3
      IF(I.GT.LU-2)GOTO 24
      IF(ABS(F(I)).LT.0.5)GOTO 38
      S=F(I+1)**2+F(I+2)**2
      IF(S.LT.1.E-10)GOTO 25
      U=SQRT(S)
      CALL SXH2(F(I),X,Y,Z)
      EZ=0.
      L=NA
C
C Locating scheme
C
        DO 31 K=75,LY,12
        P=AINT(1.001*(X*A(K)+Y*A(K+3)+Z*A(K+6)))
        Q=AINT(1.001*(X*A(K+1)+Y*A(K+4)+Z*A(K+7)))
        R=AINT(1.001*(X*A(K+2)+Y*A(K+5)+Z*A(K+8)))
        W=P+200.*(Q+200.*R)
        A(L+6)=P*XV+Q*YV+R*ZV
        A(L+7)=ABS(W)
        IF(ABS(W-F(I)).LT.0.5)EZ=EZ+1.
        IF(ABS(W+F(I)).LT.0.5-QT)EZ=EZ+1.
        J=NA
  26    J=J+4
        IF(J.GT.L)GOTO 27
        IF(.5.GT.ABS(A(J+3)-A(L+7)))GOTO 31
        GOTO 26
  27      DO 28 J=1,MA
          A(L+4)=P
          P=Q
          Q=R
          R=A(L+4)
  28      CONTINUE
        IF(A(55).LT.0.)GOTO 29
        T=P
        P=Q
        Q=T
  29    IF(ABS(Q).GT.63.5)GOTO 31
        T=127.*P+Q
        IF(ABS(T).GT.8134.5)GOTO 31
        M=INT(ABS(T)+.001)+LZ
        L=L+4
        IF(NF.GT.1)GOTO 30
        A(M)=1.1
        GOTO 31
  30    IF(NZ.GT.3)A(L+2)=100.*(X*A(K+9)+Y*A(K+10)+Z*A(K+11))
        A(L+1)=T
  31    CONTINUE
      IF(NF.EQ.1)GOTO 25
C
C Fourier type
C
      P=F(I+1)
      K=NA
      T=SQRT(EZ)
      IF(NZ.GT.3)GOTO 34
      IF(NZ.EQ.3)GOTO 33
      P=P**2
      IF(NZ.EQ.1)GOTO 33
      P=ABS(T*F(I+1)*F(I+2))
      IF(A(20).GT.-8.E9)GOTO 32
      IF(A(21).GT.0.)GOTO 33
  32  P=SQRT(P)*T*F(I+2)
  33  Q=0.
      GOTO 35
  34  Q=F(I+2)
      IF(NZ.EQ.5)GOTO 35
      Q=Q*T
      P=P*T
  35  K=K+4
      IF(K.GT.L)GOTO 25
      Y=SIGN(1.,A(K+1)+.1)
      X=Y*A(K)
      SS=SS+SQRT(P**2+Q**2)
      T=ABS(A(K+1))+.001
      M=INT(T)+LZ
      J4=INT(A(M))
      R=Y*A(K+2)
      Y=Q*Y
      IF(NF.NE.3)GOTO 36
      G(NG)=REAL(J4)
      G(NG+1)=T
      G(NG+2)=X
      G(NG+3)=R
      G(NG+4)=P
      G(NG+5)=Y
      NG=NG+6
      IF(NG.LT.LU-4)GOTO 36
      WRITE(LG)G
      NG=1
  36  N4=(J4*L4)+1
      B(N4)=T
C
C hx sums
C
      S=.0628319*(X*ZZ+R)
      O=SIN(S)
      S=COS(S)
      T=P*S+Y*O
      S=P*O-Y*S
      Z=.0628319*X*A(36)
      W=COS(Z)
      Z=SIN(Z)
      IF(MI.LT.3)GOTO 37
      O=.0628319*(X*ZZ-R)
      R=COS(O)
      O=SIN(O)
      X=P*O-Y*R
      Y=P*R+Y*O
      CALL SXF2(B(N4),W,Z,S,T,X,Y,NH-1)
      GOTO 35
  37  CALL SXF1(B(N4),W,Z,S,T,NH-1)
      GOTO 35
C
C Allocate memory
C
  38  REWIND LA
      IF(NF.NE.1)GOTO 44
      NF=2
      M=0
        DO 39 I=LZ,NH
        M=M+INT(A(I))
  39    CONTINUE
      IF(M.LE.0)CALL SXER('NO DATA FOR FOURIER')
      M4=M
      N4=LS/M4
      IF(N4.GT.16000)N4=16000
      NH=MIN0(NX,(N4-1)/MI)
      IF(NH.LT.NX)NF=3
      NH=NH*MI+1
      L4=NH
      IF(NH.GT.1)GOTO 41
  40  CALL SXER('INSUFFICIENT MEMORY FOR FOURIER')
  41  NL=(L4*M4)+1
        DO 42 M4=1,NL
        B(M4)=0.
  42    CONTINUE
      K=0
      L=LZ+8134
        DO 43 I=LZ,L
        IF(A(I).LT.0.5)GOTO 43
        A(I)=REAL(K)
        K=K+1
  43    CONTINUE
      GOTO 24
C
C Initiate scans
C
  44  NC=-1
      NB=-1
      NA=LZ
      G(NG)=-1.
      NG=0
      EZ=9999.
      A(44)=0.
      YM=AMOD(A(34)+1000.1,100.)-.1
      ZM=AMOD(A(35)+1000.1,100.)-.1
      B(NL)=1000000.
      SS=999.1/SS
      IF(NF.EQ.2)GOTO 45
      WRITE(LG)G
      REWIND LG
  45    DO 46 I=1,126
        G(I)=SIN(6.283185E-2*REAL(I-1))
  46    CONTINUE
      GOTO 53
C
C Read back data (disk mode)
C
  47  M4=NL-1
        DO 48 N4=1,M4
        B(N4)=0.
  48    CONTINUE
      NH=MIN0(NH,MI*(NX-NG)+1)
  49  READ(LG)F
      CALL SXCC
      I=-5
  50  I=I+6
      IF(I.GT.LU-5)GOTO 49
      J4=INT(F(I))
      IF(J4.LT.0)GOTO 52
      N4=(J4*L4)+1
      B(N4)=F(I+1)
      R=F(I+3)
      S=.0628319*(F(I+2)*ZZ+R)
      O=SIN(S)
      S=COS(S)
      T=F(I+4)*S+F(I+5)*O
      S=F(I+4)*O-F(I+5)*S
      Z=.0628319*F(I+2)*A(36)
      W=COS(Z)
      Z=SIN(Z)
      IF(MI.LT.3)GOTO 51
      O=.0628319*(F(I+2)*ZZ-R)
      R=COS(O)
      O=SIN(O)
      X=F(I+4)*O-F(I+5)*R
      Y=F(I+4)*R+F(I+5)*O
      CALL SXF2(B(N4),W,Z,S,T,X,Y,NH-1)
      GOTO 50
  51  CALL SXF1(B(N4),W,Z,S,T,NH-1)
      GOTO 50
C
C Fourier summations
C
  52  REWIND LG
  53  MS=2
  54  Z=0.
      W=63.5
      CALL SXZA(A(NA),MW)
      CALL SXZA(F,MQ)
      CALL SXZA(FI,MQ)
      N4=MS
        DO 61 M4=1,NL,L4
        IF(W.GT.B(M4))GOTO 57
        CALL SXCC
        K=INT(AMOD(Z*A(38),100.))
        L=INT(AMOD(Z*ZM,100.))
        N=NA
          DO 56 J=1,MQ
          L=MOD(L,100)
          W=G(L+1)
          Z=G(L+26)
C
C ** Critical loop **
C
            DO 55 M=1,MQ
            A(N)=A(N)+F(M)*Z+FI(M)*W
            N=N+1
  55        CONTINUE
C
          L=L+K
  56      CONTINUE
        IF(M4.EQ.NL)GOTO 60
        Z=AINT(B(M4)/127.+.5)+.0001
        W=127.*Z+63.5
        CALL SXZA(F,MQ)
        CALL SXZA(FI,MQ)
  57    U=AMOD(B(M4)+63.,127.)+37.
        K=INT(AMOD(U*A(37),100.))
        L=INT(AMOD(U*YM,100.))
        U=B(N4)*SS
        V=B(N4+1)*SS
          DO 58 J=1,MQ
          GS(J)=G(L+1)
          GC(J)=G(L+26)
          L=MOD(L+K,100)
  58      CONTINUE
C
C ** Critical loop **
C
          DO 59 J=1,MQ
          F(J)=F(J)+U*GC(J)-V*GS(J)
          FI(J)=FI(J)-V*GC(J)-U*GS(J)
  59      CONTINUE
C
  60    N4=N4+L4
  61    CONTINUE
C
C Vector superposition
C
      NK=NA+MW-1
      J=LZ+MT
      MZ=-MZ
      IF(MZ.EQ.0)GOTO 65
      IF(MZ.GT.0)GOTO 63
      MS=MS+2
        DO 62 I=NA,NK
        A(J)=A(I)
        J=J+1
  62    CONTINUE
      GOTO 54
  63    DO 64 I=NA,NK
        IF(A(I).GT.A(J))A(I)=A(J)
        J=J+1
  64    CONTINUE
C
C Dump encoded Patterson
C
  65  IF(NC.LT.0)GOTO 84
      IF(NZ.GT.3)GOTO 68
      IF(A(20).GT.-8.E9)GOTO 68
      IP(1)=NG-1
        DO 67 I=53,2703,53
          DO 66 K=1,51
          N=I+K+NB
          IP(K+2)=MAX0(-99,MIN0(999,INT(A(N))))
  66      CONTINUE
        IP(2)=I/53
        WRITE(LP,7)(IP(K),K=1,27),KD,(IP(K),K=28,53),KD
  67    CONTINUE
C
C Locate maxima
C
  68  Z=A(35)
        DO 83 I=MQ,MG,MQ
        Z=Z+A(38)
        Y=A(34)
          DO 82 K=1,MQ-2
          Y=Y+A(37)
          NK=I+K
          M=NK+NB
          P=A(M)
          IF(EZ.GT.P)EZ=P
          IF(MZ.GT.0)GOTO 72
          IF(NZ.GT.3)GOTO 72
          W=.01*(ZZ-A(36))
          V=.01*Y
          U=.01*Z
          IF(A(55).LT.0.)GOTO 69
          T=U
          U=V
          V=T
  69        DO 70 MK=1,MA
            T=W
            W=V
            V=U
            U=T
  70        CONTINUE
            DO 71 MK=ML,JL,4
            R=AMOD(U+A(MK+1),1.)-.5
            S=AMOD(V+A(MK+2),1.)-.5
            T=AMOD(W+A(MK+3),1.)-.5
            IF(AMAX1(ABS(R),ABS(S),ABS(T)).LT.0.1)GOTO 72
            IF(A(8)*R**2+A(9)*S**2+A(10)*T**2+S*T*A(11)+
     +      R*T*A(12)+R*S*A(13).LT.6.25)GOTO 72
  71        CONTINUE
          SP=SP+P**2
          PP=PP+1.
  72      IF(P*1.2.LT.A(MP+6))GOTO 82
          IF(A(M-1).GT.P)GOTO 82
          IF(A(M+1).GT.P)GOTO 82
          MH=M-MQ
          IF(AMAX1(A(MH-1),A(MH),A(MH+1)).GT.P)GOTO 82
          MX=M+MQ
          IF(AMAX1(A(MX-1),A(MX),A(MX+1)).GT.P)GOTO 82
          L=NK+NC
          MJ=L-MQ
          MK=L+MQ
          IF(AMAX1(A(MJ),A(L-1),A(L),A(L+1),A(MK)).GT.P)GOTO 82
          N=NK+NA
          MJ=N-MQ
          MK=N+MQ
          IF(AMAX1(A(MJ),A(N-1),A(N),A(N+1),A(MK)).GT.P)GOTO 82
          Q=P+P
          U=A(L)-A(N)
          V=A(M-1)-A(M+1)
          W=A(MH)-A(MX)
          R=U/(A(N)+A(L)-Q)
          S=V/(A(M-1)+A(M+1)-Q)
          T=W/(A(MH)+A(MX)-Q)
          H=P-(U*R+V*S+W*T)*.0416667
          IF(H.GT.A(44))A(44)=H
          IF(H.LT.A(MP+6))GOTO 82
C
C Eliminate equivalents, find s.o.f.
C
          W=.01*ZZ+A(36)*(.005*R-.01)
          V=.005*(Y+Y+A(37)*S)
          U=.005*(Z+Z+A(38)*T)
          IF(A(55).LT.0.)GOTO 73
          T=U
          U=V
          V=T
  73        DO 74 NK=1,MA
            T=W
            W=V
            V=U
            U=T
  74        CONTINUE
          J=LD+8
          SK=0.
          XS=0.
          YS=0.
          ZS=0.
          CS=1.
            DO 78 NK=1,KP
              DO 77 L=75,MY,12
              XA=U*A(L)+V*A(L+1)+W*A(L+2)+WP*A(L+9)
              YA=U*A(L+3)+V*A(L+4)+W*A(L+5)+WP*A(L+10)
              ZA=U*A(L+6)+V*A(L+7)+W*A(L+8)+WP*A(L+11)
                DO 76 M=ML,JL,4
                O=CS*A(M)*XA+A(M+1)
                P=CS*A(M)*YA+A(M+2)
                Q=CS*A(M)*ZA+A(M+3)
                N=LV
                IF(NZ.LT.4)N=LX
                R=AMOD(O-U,1.)-.5
                S=AMOD(P-V,1.)-.5
                T=AMOD(Q-W,1.)-.5
                IF(A(8)*R**2+A(9)*S**2+A(10)*T**2+S*T*A(11)+
     +          R*T*A(12)+R*S*A(13).GT.RR)GOTO 75
                XS=XS+R+U
                YS=YS+S+V
                ZS=ZS+T+W
                SK=SK+1.
  75            N=N+8
                IF(N.GT.LD)GOTO 76
                R=AMOD(O-A(N+2),1.)-.5
                S=AMOD(P-A(N+3),1.)-.5
                T=AMOD(Q-A(N+4),1.)-.5
                IF(A(8)*R**2+A(9)*S**2+A(10)*T**2+S*T*A(11)+
     +          R*T*A(12)+R*S*A(13).GE.A(N+7))GOTO 75
                IF(N.LE.LX)GOTO 82
                IF(H.LE.A(N+6))GOTO 82
                J=N
                GOTO 75
  76            CONTINUE
  77          CONTINUE
            CS=-1.
  78        CONTINUE
C
C Sort peaks
C
          IF(J.GT.LD)LD=MIN0(J,MP)
          NK=J
  79      J=J-8
          IF(A(J+6).GT.H)GOTO 81
          GOTO 79
  80      CALL SXCA(A(NK),A(NK+8),8)
  81      NK=NK-8
          IF(J.LT.NK)GOTO 80
          A(J+8)=0.
          A(J+9)=1000.1
          A(J+15)=RR
          SK=1./SK
          A(J+10)=XS*SK
          A(J+11)=YS*SK
          A(J+12)=ZS*SK
          A(J+13)=SK
          A(J+14)=H
  82      CONTINUE
  83    CONTINUE
      CALL SXCC
C
C Recycle
C
  84  NC=NB
      NB=NA
      NA=NA+MW
      IF(NA.GE.LZ+MT)NA=LZ
      MS=MS+2
      NG=NG+1
      ZZ=ZZ+A(36)
      IF(NX.EQ.NG)GOTO 85
      IF(MS.GT.NH)GOTO 47
      GOTO 54
  85  A(LX+6)=TP
      IF(NZ.GT.3)GOTO 88
      IF(NZ.NE.2)GOTO 87
      IF(A(20).LT.-8.E9)GOTO 86
      IF(MZ.NE.0)GOTO 89
  86  WRITE(LI,8)IT
      GOTO 89
  87  WRITE(LI,9)IT
      GOTO 89
  88  WRITE(LI,10)IT
  89  IF(NF.EQ.2)WRITE(LI,11)A(44),EZ,MR,NL
      IF(NF.EQ.3)WRITE(LI,11)A(44),EZ,MR,NL,IH(20)
      CALL SXTM(SL,LI)
      IF(ABS(A(39)).GT.0.5)GOTO 90
      IF(NZ.EQ.6)GOTO 107
      GOTO 93
C
C Assign names to peaks
C
  90  A(39)=0.
      IF(A(31).GT.0.5)GOTO 107
      Z=0.
      N=LL-1
  91  N=N+5
      IF(N.GT.LQ)GOTO 92
      IF(A(N).LT.Z)GOTO 91
      Z=A(N)
      GOTO 91
  92  IF(Z.LT.10.5)GOTO 107
      Z=1.1*Z/A(LX+14)
      Y=AMAX1(.2*Z,10.)
  93  M=6
      J=0
      I=LX
  94  I=I+8
      IF(I.GT.LD)GOTO 98
      J=J+1
      CALL SXPN(A(I),J)
      IF(NZ.NE.M)GOTO 97
      P=Z*A(I+6)
      T=9.E9
      N=LL-1
  95  N=N+5
      IF(N.GT.LQ)GOTO 96
      R=ABS(P/A(N)-1.)
      IF(R.GT.T)GOTO 95
      T=R
      L=N
      GOTO 95
  96  IF(A(L).LT.Y)M=-1
      IF(P.LT.0.4*A(L))M=-1
      IF(M.LT.0)GOTO 97
      A(I+1)=200.*REAL(L-LL)+200.1
      CALL SXUS(A(I),KR)
      CALL SXUS(A(L+2),KS)
      L=2
      IF(KS(2:2).NE.IH(20))L=3
      KS(L:4)=KR(1:5-L)
      CALL SXPS(A(I),KS)
      A(31)=A(31)+1.
      LX=I
      IF(J.EQ.1)WRITE(LI,14)
      L=I+2
      N=I+6
      WRITE(LI,15)KS,(A(K),K=L,N)
  97  IF(J.LT.9999)GOTO 94
      LD=I
  98  IF(NZ.GT.3)GOTO 107
      IF(MZ.NE.0)GOTO 107
C
C Patterson output
C
      I=LX
      SP=SQRT(SP/PP)
      WRITE(LI,12)SP
  99  I=I+8
      IF(I.GT.LD)GOTO 101
      Q=9.E9
      X=A(I+2)
      Y=A(I+3)
      Z=A(I+4)
        DO 100 M=ML,LL,4
        U=AMOD(X+A(M+1),1.)-.5
        V=AMOD(Y+A(M+2),1.)-.5
        W=AMOD(Z+A(M+3),1.)-.5
        P=U*U*A(8)+V*V*A(9)+W*W*A(10)+V*W*A(11)+
     +  U*W*A(12)+U*V*A(13)
        IF(P.GT.Q)GOTO 100
        Q=P
        A(I+2)=AMOD(99.+U,1.)
        A(I+3)=AMOD(99.+V,1.)
        A(I+4)=AMOD(99.+W,1.)
 100    CONTINUE
      A(I+5)=1./A(I+5)
      K=I+7
      A(K)=SQRT(Q)
      J=I+2
      CALL SXUS(A(I),KR)
      WRITE(LI,13)KR,(A(M),M=J,K-1),A(K-1)/SP,A(K)
      GOTO 99
 101  IF(A(20).LT.-8.E9)CALL SXIT
C
C Best superposition vector
C
      M=INT(ABS(A(21)))
      IF(M.EQ.0)CALL SXIT
      LK=1
      R=AMAX1(AMOD(100.*ABS(A(22)),100.),0.01)
      A(55)=0.
      LV=LQ-3
      M=LV+8*M
      LE=LX+8
      I=LE
 102  I=I+8
      IF(I.GT.LD)GOTO 103
      IF(A(I+7).LT.R)GOTO 102
      LV=LV+8
      IF(LV.LT.M)GOTO 102
 103  IF(LV.LT.LQ)CALL SXER('NO SUITABLE SUPERPOSITION VECTOR')
      WRITE(LI,16)
      LX=LV
      K=LX
      LV=LV-8
 104  Q=-1.
      I=LE
 105  I=I+8
      IF(I.GT.LD)GOTO 106
      IF(A(I+7).LT.R)GOTO 105
      T=A(I+6)/A(I+5)
      IF(T.LT.Q)GOTO 105
      Q=T
      J=I
      GOTO 105
 106  CALL SXCA(A(J+2),A(K+2),6)
      N=(LX-K+8)/8
      L=K+5
      CALL SXPS(A(K),'VECT')
      CALL SXPN(A(K+1),N)
      CALL SXUS(A(K+1),KR)
      WRITE(LI,13)KR,(A(I+2),I=K,L)
      A(J+7)=0.
      A(K+5)=-9.E9
      K=K-8
      IF(K.GT.LQ)GOTO 104
 107  RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SX2H(LM,LU,F,G,A)
C
C Molecule assembly, geometry and projection
C
      CHARACTER*1 IH(22),IT(76),IR(80),HK(80),KR(120),KD
      CHARACTER*4 KS,KT
      CHARACTER*80 NM
      REAL F(LU),G(LU),A(LM)
      COMMON/MEM/ST,SL,TC,TL,LR,LG,LH,LI,LP,LF,LA,LB,
     +LW,LY,LL,LQ,LE,LV,LX,LD,LZ,LJ,LN,LK,LC,HA,HD
      COMMON/WORD/IH,IT,IR,HK,NM,KD
C
   1  FORMAT(A1/'L.S. 4',A1/'BOND',A1/'FMAP 2',A1/'PLAN 20',A1/A1)
   2  FORMAT(' Molecule',I3,5X,'scale',F6.3,
     +' inches =',F6.3,' cm per Angstrom')
   3  FORMAT(///' Molecule',I3)
   4  FORMAT(1X,120A1)
   5  FORMAT(//' Atom Peak     x',7X,'y',7X,'z',5X,
     +'SOF  Height  Distances and Angles')
   6  FORMAT(/1X,A4,F5.0,3F8.4,F7.3,F6.2,I4,1X,A4,F6.3)
   7  FORMAT(47X,I4,1X,A4,F6.3,11F6.1)
   8  FORMAT(//' Atom Code   x       y       z    Height',
     +'  Symmetry transformation'/)
   9  FORMAT(1X,A4,I3,3F8.4,F7.2,1X,3(F8.4,4A1))
  10  FORMAT(A4,I3,3F8.4,F10.6,'  0.05',F8.2,A1)
  11  FORMAT(A4,I3,3F8.4,F10.6,'  0.05',A1)
  12  FORMAT('MOLE',I4,A1)
  13  FORMAT(//' Peak  Atom     x       y       z      sof'/)
  14  FORMAT(F6.0,2X,A4,4F8.4)
  15  FORMAT(8X,A4,4F8.4)
  16  FORMAT(80A1)
  17  FORMAT('END ',A1)
C
      IF(LV.GE.LD)GOTO 88
      A(44)=AMAX1(A(44),1.)*1.1
      ML=LY+12
      IF(LK.LE.0)WRITE(LP,1)(KD,I=1,6)
      IF(LK.LT.0)GOTO 89
C
C Assemble molecules
C
      Q=.5
      NK=0
      T=.1
      I=LV
      MA=I
      MB=0
  18  I=I+8
      IF(I.GT.LD)GOTO 19
      A(I+7)=AMOD(A(I+1),1000.)
      IF(T.LT.A(I+7))T=A(I+7)
      IF(I.LE.LX)A(I+6)=0.
      A(I+5)=AINT(1./A(I+5)+.2)+A(I+6)/A(44)
      K=INT(.001*A(I+1))*5+LL
      A(I+6)=A(K)
      GOTO 18
  19  IF(LD+300.GT.LM)GOTO 31
      IF(A(57).LT.0.)GOTO 20
      WRITE(LI,13)
      NX=0
      GOTO 34
  20  IF(T.LT.0.5)GOTO 22
      GOTO 23
  21  IF(MB.LT.1)GOTO 32
  22  MB=-1
      Q=T+.4
      T=T+1.
  23  I=LV
  24  I=I+8
      IF(I.GT.LD)GOTO 21
      IF(A(I+7).GT.0.5)GOTO 24
      IF(MB.GT.-1)GOTO 25
      A(I+7)=T
      MB=0
      MA=I
      GOTO 24
  25  P=A(I+6)+A(58)
      CALL SXCC
      K=LD+5
      NK=K+3
        DO 27 L=75,LY,12
        X=A(I+2)*A(L)+A(I+3)*A(L+1)+A(I+4)*A(L+2)+A(L+9)
        Y=A(I+2)*A(L+3)+A(I+3)*A(L+4)+A(I+4)*A(L+5)+A(L+10)
        Z=A(I+2)*A(L+6)+A(I+3)*A(L+7)+A(I+4)*A(L+8)+A(L+11)
          DO 26 M=ML,LL,4
          K=K+3
          A(K)=A(M)*X+A(M+1)
          A(K+1)=A(M)*Y+A(M+2)
          A(K+2)=A(M)*Z+A(M+3)
  26      CONTINUE
  27    CONTINUE
      J=LV
      MB=LD
      IF(I.GT.MA)GOTO 28
      J=MA
      MB=J+8
  28  J=J+8
      IF(J.GT.MB)GOTO 24
      IF(A(J+7).LT.Q)GOTO 28
      S=(P+A(J+6))**2
        DO 29 L=NK,K,3
        U=AMOD(A(L)-A(J+2),1.)-.5
        V=AMOD(A(L+1)-A(J+3),1.)-.5
        W=AMOD(A(L+2)-A(J+4),1.)-.5
        IF(A(8)*U**2+A(9)*V**2+A(10)*W**2+V*W*A(11)+U*W*A(12)+
     +  U*V*A(13).LT.S)GOTO 30
  29    CONTINUE
      GOTO 28
  30  A(I+2)=A(J+2)+U
      A(I+3)=A(J+3)+V
      A(I+4)=A(J+4)+W
      A(I+7)=A(J+7)
      MA=I-8
      GOTO 23
  31  CALL SXER('NOT ENOUGH MEMORY FOR PLAN')
C
C Set up plots
C
  32  A(50)=A(2)*COS(.0174533*A(6))
      A(49)=A(3)*SIN(.0174533*A(5))
      A(51)=A(3)*COS(.0174533*A(5))
      A(48)=(A(2)*A(3)*COS(.0174533*A(7))-A(51)*A(50))/A(49)
      A(47)=SQRT(A(2)**2-A(50)**2-A(48)**2)
      A(52)=A(4)
C
C Write mole numbers and peaks to results file
C
      NK=INT(T)
      NX=0
  33  NX=NX+1
      IF(NX.GT.NK)GOTO 39
      WRITE(LP,12)NX,KD
  34  I=LV
  35  I=I+8
      IF(I.GT.LD)GOTO 33
      IF(A(57).GE.0.)GOTO 36
      IF(INT(A(I+7)).NE.NX)GOTO 35
  36  M=INT(.001*A(I+1))
      T=1./AINT(A(I+5))
      S=T+10.
      CALL SXUS(A(I),KT)
        DO 37 KI=1,10
        IF(KT(1:1).EQ.IH(KI))GOTO 38
  37    CONTINUE
      WRITE(LP,11)KT,M,A(I+2),A(I+3),A(I+4),S,KD
      IF(A(57).GE.0.)WRITE(LI,15)KT,A(I+2),A(I+3),A(I+4),T
      GOTO 35
  38  Y=A(44)*AMOD(A(I+5),1.)
      Z=0.05
      KS=IH(22)//KT(1:3)
      WRITE(LP,10)KS,M,A(I+2),A(I+3),A(I+4),S,Y,KD
      IF(A(57).GE.0.)WRITE(LI,14)Y,KS,A(I+2),A(I+3),A(I+4),T
      GOTO 35
  39  WRITE(LP,16)HK
      WRITE(LP,17)KD
      IF(A(57).GE.0.)GOTO 87
C
C Environment
C
      NX=0
  40  NX=NX+1
      IF(NX.GT.NK)GOTO 87
      N=LD
      MB=4
      I=LV
  41  I=I+8
      IF(I.GT.LD)GOTO 49
      CALL SXCC
      IF(A(I+7).GT.999.)A(I+7)=0.
      IF(INT(A(I+7)).EQ.NX)MB=MB+2
      T=A(I+6)+A(58)
      S=AMAX1(T,A(I+6)+ABS(A(59)))
        DO 48 L=75,LY,12
        U=A(I+2)*A(L)+A(I+3)*A(L+1)+A(I+4)*A(L+2)+A(L+9)
        V=A(I+2)*A(L+3)+A(I+3)*A(L+4)+A(I+4)*A(L+5)+A(L+10)
        W=A(I+2)*A(L+6)+A(I+3)*A(L+7)+A(I+4)*A(L+8)+A(L+11)
          DO 47 M=ML,LL,4
          X=A(M)*U+A(M+1)
          Y=A(M)*V+A(M+2)
          Z=A(M)*W+A(M+3)
          J=LV
  42      J=J+8
          IF(J.GT.LD)GOTO 47
          IF(INT(A(J+7)).NE.NX)GOTO 42
          P=AMOD(X-A(J+2),1.)-.5
          Q=AMOD(Y-A(J+3),1.)-.5
          R=AMOD(Z-A(J+4),1.)-.5
          O=A(8)*P**2+A(9)*Q**2+A(10)*R**2+Q*R*A(11)+P*R*A(12)+P*Q*A(13)
          IF(O.GT.(S+A(J+6))**2)GOTO 42
          P=P+A(J+2)
          Q=Q+A(J+3)
          R=R+A(J+4)
          IF(INT(A(I+7)).NE.NX)GOTO 43
          IF(ABS(P-A(I+2))+ABS(Q-A(I+3))+ABS(R-A(I+4)).LT.0.01)
     +    GOTO 42
  43      IF(O.LT.(T+A(J+6))**2)GOTO 44
          IF(AMAX1(A(I+1),A(J+1)).LT.SIGN(2500.,A(59)))GOTO 42
  44      K=N+8
  45      K=K-8
          IF(K.EQ.LD)GOTO 46
          IF(ABS(P-A(K+2))+ABS(Q-A(K+3))+ABS(R-A(K+4)).LT.0.01)
     +    GOTO 42
          GOTO 45
  46      N=N+8
          IF(N+59.GT.LM)GOTO 31
          A(N)=REAL(I)
          A(N+1)=REAL(L)
          A(N+2)=P
          A(N+3)=Q
          A(N+4)=R
          A(N+5)=REAL(M)
          A(N+6)=A(I+6)
          A(N+7)=REAL(NX)
          GOTO 42
  47      CONTINUE
  48    CONTINUE
      GOTO 41
C
C Find scale and orientation
C
  49  IF(MB.EQ.4)GOTO 40
      IF(MB.LT.14)GOTO 70
      MA=N+8
      IF(MA+((N-LD)/4)+MB.GT.LM)GOTO 31
      A(MA)=-9.E9
        DO 50 M=1,9
        G(M)=0.
  50    CONTINUE
      G(10)=9.E9
      G(11)=-9.E9
      G(12)=9.E9
      G(13)=-9.E9
      G(14)=9.E9
        DO 62 K=4,13,3
        IF(K.LT.10)S=.01
        I=LV
  51    I=I+8
        IF(I.GT.N)GOTO 60
        IF(INT(A(I+7)).NE.NX)GOTO 51
        U=A(47)*A(I+2)
        V=A(48)*A(I+2)+A(49)*A(I+3)
        W=A(50)*A(I+2)+A(51)*A(I+3)+A(52)*A(I+4)
        IF(K.GT.7)GOTO 54
        J=I
  52    J=J+8
        IF(J.GT.N)GOTO 51
        IF(INT(A(J+7)).NE.NX)GOTO 52
        X=A(47)*A(J+2)-U
        Y=A(48)*A(J+2)+A(49)*A(J+3)-V
        Z=A(50)*A(J+2)+A(51)*A(J+3)+A(52)*A(J+4)-W
        IF(K.EQ.4)GOTO 53
        P=Y*G(6)-Z*G(5)
        Q=Z*G(4)-X*G(6)
        Z=X*G(5)-Y*G(4)
        X=P
        Y=Q
  53    R=X*X+Y*Y+Z*Z
        IF(R.LT.S)GOTO 52
        S=R
        R=1./SQRT(R)
        G(K)=X*R
        G(K+1)=Y*R
        G(K+2)=Z*R
        GOTO 52
  54    X=U*G(1)+V*G(2)+W*G(3)
        Y=U*G(4)+V*G(5)+W*G(6)
        Z=U*G(7)+V*G(8)+W*G(9)
        IF(K.GT.10)GOTO 55
        IF(G(10).GT.X)G(10)=X
        IF(G(11).LT.X)G(11)=X
        IF(G(12).GT.Y)G(12)=Y
        IF(G(13).LT.Y)G(13)=Y
        IF(G(14).GT.Z)G(14)=Z
        GOTO 52
  55    U=X-G(10)
        V=Y-G(12)
        IF(T.GT.0.)GOTO 56
        U=V
        V=G(11)-X
  56    Q=200.*AINT(R*U+.5)+S*V+201.5
        J=MA+2
        L=J
  57    J=J-2
        IF(A(J).GT.Q)GOTO 57
        GOTO 59
  58    A(L+2)=A(L)
        A(L+3)=A(L+1)
  59    L=L-2
        IF(J.LT.L)GOTO 58
        A(J+2)=Q
        A(J+3)=REAL(I)
        IF(I.GT.LD)A(J+3)=A(I)
        MA=MA+2
        A(I+7)=1000.+(Z-G(14))*ABS(T)
        GOTO 51
  60    IF(K.NE.7)GOTO 61
        G(1)=G(5)*G(9)-G(6)*G(8)
        G(2)=G(6)*G(7)-G(4)*G(9)
        G(3)=G(4)*G(8)-G(5)*G(7)
  61    IF(K.NE.10)GOTO 62
        R=G(13)-G(12)
        S=G(11)-G(10)
        T=AMIN1(1.,116./(HA*R),57./(HD*S))
        IF(T.LT.0.8)T=-AMIN1(1.,97./(HD*R),116./(HA*S))
        R=HD*ABS(T)
        S=HA*ABS(T)
  62    CONTINUE
C
C Plot atoms
C
      S=2.54*ABS(T)
      CALL SXPG(LI)
      WRITE(LI,2)NX,ABS(T),S
      M=0
        DO 63 J=1,120
        KR(J)=IH(20)
  63    CONTINUE
      K=1
      I=N+8
  64  I=I+2
      IF(I.GT.MA)GOTO 69
      CALL SXCC
      NC=INT(A(I)*.005)
  65  IF(NC.EQ.M)GOTO 67
      WRITE(LI,4)(KR(J),J=1,K)
        DO 66 J=1,K
        KR(J)=IH(20)
  66    CONTINUE
      K=1
      M=M+1
      GOTO 65
  67  L=INT(A(I+1))
      CALL SXUS(A(L),KT)
      L=INT(AMOD(A(I),200.))
        DO 68 J=1,4
        IF(KT(J:J).EQ.IH(20))GOTO 64
        IF(KR(L).NE.IH(20))KT(J:J)=IH(21)
        KR(L)=KT(J:J)
        IF(K.LT.L)K=L
        L=L+1
  68    CONTINUE
      GOTO 64
  69  WRITE(LI,4)(KR(J),J=1,K)
      GOTO 72
C
C Distances and angles
C
  70  WRITE(LI,3)NX
      N=LD
      I=LV
  71  I=I+8
      IF(I.GT.N)GOTO 72
      IF(INT(A(I+7)).EQ.NX)A(I+7)=1000.001
      GOTO 71
  72  WRITE(LI,5)
      I=LV
  73  I=I+8
      IF(I.GT.LD)GOTO 81
      IF(A(I+7).LT.999.)GOTO 73
      CALL SXCC
      T=A(I+6)+A(58)
      S=AMAX1(T,A(I+6)+ABS(A(59)))
      MA=N+8
      A(MA)=-9.E9
      J=LV
  74  J=J+8
      IF(J.GT.N)GOTO 77
      IF(A(J+7).LT.999.)GOTO 74
      IF(J.EQ.I)GOTO 74
      X=A(I+2)-A(J+2)
      Y=A(I+3)-A(J+3)
      Z=A(I+4)-A(J+4)
      R=X**2*A(8)+Y**2*A(9)+Z**2*A(10)+Y*Z*A(11)+X*Z*A(12)+X*Y*A(13)
      IF(R.GT.(S+A(J+6))**2)GOTO 74
      R=SQRT(R)
      IF(R.LT.T+A(J+6))GOTO 76
      IF(AMAX1(A(I+1),A(J+1)).LT.SIGN(2500.,A(59)))GOTO 74
      L=LV
  75  L=L+8
      IF(L.GT.LX)GOTO 76
      IF(A(L+7).LT.999.)GOTO 75
      U=A(L+2)-A(I+2)
      V=A(L+3)-A(I+3)
      W=A(L+4)-A(I+4)
      IF(A(8)*U**2+A(9)*V**2+A(10)*W**2+V*W*A(11)+U*W*A(12)+
     +U*V*A(13).GT.(T+A(L+6))**2)GOTO 75
      U=A(L+2)-A(J+2)
      V=A(L+3)-A(J+3)
      W=A(L+4)-A(J+4)
      IF(A(8)*U**2+A(9)*V**2+A(10)*W**2+V*W*A(11)+U*W*A(12)+
     +U*V*A(13).GT.(A(J+6)+A(L+6)+A(58))**2)GOTO 75
      GOTO 74
  76  A(MA+2)=R
      A(MA+3)=REAL(J)
      MA=MIN0(MA+2,N+56)
      GOTO 74
  77  J=N+8
      X=1./AINT(A(I+5))
      Y=A(44)*AMOD(A(I+5),1.)
      Z=AMOD(A(I+7),1000.)
      CALL SXUS(A(I),KT)
      IF(MA.GT.N+8)GOTO 78
      WRITE(LI,6)KT,Y,A(I+2),A(I+3),A(I+4),X
      GOTO 73
  78  J=J+2
      IF(J.GT.MA)GOTO 73
      NB=N+8
      M=1
      F(1)=A(J)
      NC=INT(A(J+1))
      K=MAX0(0,(NC-LD)/8)
      MB=NC
      IF(MB.GT.LD)MB=INT(A(NC))
      CALL SXUS(A(MB),KS)
      IF(J.GT.N+10)GOTO 79
      WRITE(LI,6)KT,Y,A(I+2),A(I+3),A(I+4),X,Z,K,KS,F(1)
      GOTO 78
  79  NB=NB+2
      IF(NB.EQ.J)GOTO 80
      L=INT(A(NB+1))
      U=A(NC+2)-A(L+2)
      V=A(NC+3)-A(L+3)
      W=A(NC+4)-A(L+4)
      T=A(8)*U**2+A(9)*V**2+A(10)*W**2+V*W*A(11)+U*W*A(12)+U*V*A(13)
      S=(A(J)**2+A(NB)**2-T)/(2.*A(J)*A(NB))
      W=SQRT(ABS(1.-S**2))
      M=M+1
      F(M)=ATAN2(W,S)*57.29578
      IF(M.LT.12)GOTO 79
  80  WRITE(LI,7)K,KS,(F(L),L=1,M)
      GOTO 78
C
C Symmetry generated atoms
C
  81  M=0
      IF(N.EQ.LD)GOTO 40
      WRITE(LI,8)
      I=LD
  82  I=I+8
      IF(I.GT.N)GOTO 40
      CALL SXCC
      M=M+1
      Z=AMOD(A(I+7),1000.)
      K=INT(A(I))
      J=INT(A(I+1))
      L=INT(A(I+5))
      S=A(L)
      U=A(I+2)-S*(A(K+2)*A(J)+A(K+3)*A(J+1)+A(K+4)*A(J+2))
      V=A(I+3)-S*(A(K+2)*A(J+3)+A(K+3)*A(J+4)+A(K+4)*A(J+5))
      W=A(I+4)-S*(A(K+2)*A(J+6)+A(K+3)*A(J+7)+A(K+4)*A(J+8))
        DO 83 L=1,12
        KR(L)=IH(20)
  83    CONTINUE
        DO 86 NB=1,9,4
        L=NB
          DO 85 NC=14,16
          T=S*A(J)
          IF(ABS(T).LT.0.5)GOTO 84
          KR(L)=IH(13)
          IF(T.LT.0.)KR(L)=IH(12)
          KR(L+1)=IH(NC)
          L=L+2
  84      J=J+1
  85      CONTINUE
  86    CONTINUE
      CALL SXUS(A(K),KT)
      WRITE(LI,9)KT,M,A(I+2),A(I+3),A(I+4),Z,U,
     +(KR(J),J=1,4),V,(KR(J),J=5,8),W,(KR(J),J=9,12)
      GOTO 82
  87  CALL SXTM(SL,LI)
  88  CALL SXIT
  89  RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SX2I(LM,LS,LU,F,G,A,B)
C
C Heavy-atom patterson solution - part 1
C
      CHARACTER*1 IH(22),IT(76),IR(80),HK(80),KD
      CHARACTER*80 NM
      INTEGER IB(10)
      REAL F(LU),G(LU),A(LM),B(LS)
      COMMON/MEM/ST,SL,TC,TL,LR,LG,LH,LI,LP,LF,LA,LB,
     +LW,LY,LL,LQ,LE,LV,LX,LD,LZ,LJ,LN,LK,LC,HA,HD
      COMMON/WORD/IH,IT,IR,HK,NM,KD
C
   1  FORMAT(I5,3F7.3,F8.2,8(I4,':',F5.2))
   2  FORMAT(' Vector Superposition Minimum Function',
     +' for',76A1//10X,'x      y      z    Height ',
     +'  Shortest distances (greater than',F6.2,' Angstroms)'/)
   3  FORMAT(/I6,' Superposition peaks employed, maximum height',
     +F6.1,'  and minimum height',F6.1,'  on atomic number scale')
   4  FORMAT(/' ** Restricted to',I6,'  peaks by memory ',
     +'limitations (array A dimension) **')
   5  FORMAT(//' Potential origin shifts before symmetry check'//
     +'  del(x)  del(y)  del(z)  Weight'/)
   6  FORMAT(3F8.4,F7.1)
   7  FORMAT(//' ** No consistent origin shift found - use another',
     +' superposition vector **')
C
C Set up general superposition parameters
C
      LJ=LY+12
      LZ=LL
      IF(A(23).LT.0.5)LZ=(LZ+LJ-4)/2
      ZM=100.*AMOD(A(20),1.)
      A(27)=AMAX1(AMOD(100.*ABS(A(22)),100.),0.01)
      A(28)=AMIN1(A(2),A(3),A(4))
      I=LJ
   8  I=I+4
      IF(I.GT.LZ)GOTO 9
      X=AMOD(A(I+1),1.)-.5
      Y=AMOD(A(I+2),1.)-.5
      Z=AMOD(A(I+3),1.)-.5
      A(28)=AMIN1(A(28),SQRT(X*X*A(8)+Y*Y*A(9)+Z*Z*A(10)+
     +Y*Z*A(11)+X*Z*A(12)+X*Y*A(13)))
      GOTO 8
   9  LR=LD+7
      AM=0.
      N=LL-1
  10  N=N+5
      IF(N.GT.LQ)GOTO 11
      IF(A(N).LT.AM)GOTO 10
      AM=A(N)
      GOTO 10
  11  A(43)=AMAX1(.1,1.5*A(1)**2/(AMIN1(32.,AM)*(.5*A(1)/
     +AMAX1(A(42),.0001))**2))
      A(53)=8./A(43)
        DO 12 I=61,63
        A(I)=SQRT(A(43))/A(I-59)
  12    CONTINUE
C
C Expand peaklist and assign provisional atomic numbers
C
      Q=2.*AM/(A(LX+14)+A(LX+22))
      LE=LV+8
      IF(LD.LT.LE)CALL SXER('NO SUPERPOSITION PEAKS FOUND')
      LX=LV
      T=0.4*ZM
        DO 13 L=LE,LD,8
        A(LX+13)=Q*A(LX+14)
        IF(A(LX+13).LT.T)GOTO 14
        LX=LX+8
  13    CONTINUE
  14  MS=LX+13
      LD=LX+8
      JZ=MIN0((LM/2)+(MS/2)-1050,LM-3500)
      A(LD)=-9.E9
        DO 17 L=LE,LX,8
        S=1.
  15      DO 16 K=LJ,LZ,4
          LD=LD+5
          A(LD)=A(L+5)
          A(LD+1)=S*REAL((L-LV)/8)
          A(LD+2)=AMOD(A(K+1)+S*A(L+2)+.5,1.)
          A(LD+3)=AMOD(A(K+2)+S*A(L+3)+.5,1.)
          A(LD+4)=AMOD(A(K+3)+S*A(L+4)+.5,1.)
  16      CONTINUE
        S=-S
        IF(S.LT.0.)GOTO 15
        ND=L
        IF(LD.GT.JZ)GOTO 18
  17    CONTINUE
  18  JZ=JZ+1000
      CALL SXQS(LD-LX-8,4,5,A(MS))
C
C Lookup table based on z values
C
      S=2.*SQRT(SQRT(REAL((LY-63)/12)*(2.-A(23))))*A(63)
      NL=LD
      I=LX+8
  19  I=I+5
      IF(A(I+4).GT.S)GOTO 20
      LD=LD+5
      CALL SXCA(A(I),A(LD),4)
      A(LD+4)=A(I+4)+1.
      IF(LD.LT.JZ)GOTO 19
  20  J=1
      G(1)=REAL(LX+7)
      A(LD+9)=9.E9
      I=LX+8
  21  I=I+5
  22  IF(A(I+4).LT.REAL(J)*.01)GOTO 21
      J=J+1
      G(J)=REAL(I-6)
      IF(J.LT.LU)GOTO 22
      LR=LD+9
C
C Superposition coordinate table
C
      IF(A(70).LT.2.5)GOTO 29
      CALL SXPG(LI)
      WRITE(LI,2)IT,A(27)
      VM=AMAX1(0.1,A(27)**2)
      NN=0
      IB(1)=0
        DO 28 I=LE,LX,8
        CALL SXCC
        J=I+2
        K=I+5
        NN=NN+1
        N=1
        F(1)=-1.
        F(9)=4.
        XX=99.5+A(I+2)
        YY=99.5+A(I+3)
        ZZ=99.5+A(I+4)
          DO 26 M=MS,NL,5
          X=AMOD(XX-A(M+2),1.)-.5
          Y=AMOD(YY-A(M+3),1.)-.5
          Z=AMOD(ZZ-A(M+4),1.)-.5
          Z=A(8)*X**2+A(9)*Y**2+A(10)*Z**2+A(11)*Y*Z+
     +    A(12)*X*Z+A(13)*X*Y
          IF(Z.GT.F(9)**2)GOTO 26
          IF(Z.LT.VM)GOTO 26
          Z=SQRT(Z)
          NK=N+1
          NJ=NK
  23      NJ=NJ-1
          IF(Z.LT.F(NJ))GOTO 23
          GOTO 25
  24      F(NK+1)=F(NK)
          IB(NK+1)=IB(NK)
  25      NK=NK-1
          IF(NJ.LT.NK)GOTO 24
          F(NJ+1)=Z
          IB(NJ+1)=INT(A(M+1))
          IF(N.LT.9)N=N+1
  26      CONTINUE
        IF(N.GT.1)GOTO 27
        WRITE(LI,1)NN,(A(M),M=J,K)
        GOTO 28
  27    WRITE(LI,1)NN,(A(M),M=J,K),(IB(M),F(M),M=2,N)
  28    CONTINUE
      WRITE(LI,1)
      GOTO 30
  29  I=(LX-LV)/8
      WRITE(LI,3)I,A(LE+5),A(LX+5)
C
C Space group type and allowed origin shifts
C
  30  J=(ND-LV)/8
      IF(ND.LT.LX)WRITE(LI,4)J
      NI=0
      NJ=0
      NK=0
      NA=1
      N=1
      ZN=.5
        DO 31 L=75,LY,12
        IF(A(L).LT.0.9)NI=1
        IF(A(L+4).LT.0.9)NJ=1
        IF(A(L+8).LT.0.9)NK=1
        IF(ABS(A(L+1)).GT.0.9)NA=2
        IF(ABS(A(L))+ABS(A(L+1)).GT.1.9)N=2
        IF(ABS(A(L+2))+ABS(A(L+5)).GT.0.1)ZN=1.
  31    CONTINUE
      NA=NA*N
      IF(ZN.GT.0.7)NA=4
      IF(ABS(A(5)-A(6))+ABS(A(6)-A(7)).GT.0.1)GOTO 32
      IF(LY.EQ.99)NA=1
      IF(LY.EQ.135)NA=1
  32  ND=LD+5
      NE=-3
      JZ=MIN0(LX,LV+400,LV+8*((LX-LV+96)/24))
      SK=AMAX1(ZM,A(JZ+5),A(LE+29)*.5)
      IF(A(21).LT.0.)SK=.7*SK
      SJ=.4*SK
      IF(A(23).LT.0.5)GOTO 98
C
C If space group is P1, retain all atoms and inverses
C
      IF(NI+NJ+NK.GT.0)GOTO 36
      ND=LD+10
      A(ND)=1.
      A(ND+1)=99.9
      A(ND+2)=.5
      A(ND+3)=.5
      A(ND+4)=.5
        DO 34 I=LE,LX,8
        IF(A(I+5).LT.ZM)GOTO 35
        CALL SXCC
        NE=NE+4
        B(NE)=A(I+5)
        CALL SXCA(A(I+2),B(NE+1),3)
          DO 33 L=LJ,LZ,4
          U=AMOD(A(L+1)+2.*A(I+2),1.)-.5
          V=AMOD(A(L+2)+2.*A(I+3),1.)-.5
          W=AMOD(A(L+3)+2.*A(I+4),1.)-.5
          R=A(8)*U**2+A(9)*V**2+A(10)*W**2+A(11)*V*W+A(12)*U*W+
     +    A(13)*U*V
          IF(R.LT.A(43))GOTO 34
  33      CONTINUE
        NE=NE+4
        B(NE)=A(I+5)
        B(NE+1)=1.-A(I+2)
        B(NE+2)=1.-A(I+3)
        B(NE+3)=1.-A(I+4)
  34    CONTINUE
  35  NE=NE+4
      B(NE)=0.
      GOTO 116
C
C Set up auxiliary lookup table
C
  36  JZ=LD+10
      A(JZ)=-9.E9
      NE=-4
      MR=4
      IF(NK.EQ.0)GOTO 65
      MR=3
      IF(NI.EQ.0)MR=2
      IF(LY.EQ.99)GOTO 37
      IF(LY.NE.135)GOTO 38
  37  IF(ABS(A(6)-A(7))+ABS(A(5)-A(6)).LT.1.)MR=1
  38    DO 39 I=MS,NL,5
        JZ=JZ+5
        IF(JZ.GT.LM-9)GOTO 109
        A(JZ)=A(I)
        A(JZ+1)=AMOD(99.+A(I+2)+A(I+3)+A(I+4),1.)
        CALL SXCA(A(I+2),A(JZ+2),3)
        J=JZ+MR
        A(JZ+1)=A(J)
  39    CONTINUE
      I=JZ-LD-10
      IF(I.GT.0)CALL SXQS(I,1,5,A(LD+15))
      SS=A(63)*5.333
      IF(MR.GT.1)SS=4.*A(MR+59)
      NW=JZ
      I=LD+10
  40  I=I+5
      IF(A(I+1).GT.SS)GOTO 41
      JZ=JZ+5
      IF(JZ.GT.LM-9)GOTO 109
      A(JZ)=A(I)
      A(JZ+1)=A(I+1)+1.
      CALL SXCA(A(I+2),A(JZ+2),3)
      GOTO 40
  41  JZ=JZ+5
      A(JZ+1)=9.E9
      SS=.25*SS
      J=1
      F(1)=REAL(LD+6)
      I=LD+10
  42  I=I+5
  43  IF(A(I+1).LT.REAL(J)*.01)GOTO 42
      J=J+1
      F(J)=REAL(I-9)
      IF(J.LT.LU)GOTO 43
      LR=JZ+4
C
C Rhombohedral axes
C
      IF(MR.NE.1)GOTO 55
      K=75
      IF(LY.EQ.99)GOTO 45
  44  K=K+12
      IF(K.GT.LY)GOTO 54
      IF(A(K+8).GT.-.9)GOTO 44
      SS=1.5*SS
  45  I=LD+10
  46  I=I+5
      IF(I.GT.NW)GOTO 87
      IF(A(I).LT.SK)GOTO 46
      T=A(I+1)-SS
      IF(T.LT.0.5*SS)T=T+1.
      J=INT(100.*T+1.)
      IF(J.GT.LU)J=LU
      Q=T+2.*SS
      U=A(I+2)-A(I+3)+99.5
      V=A(I+4)+99.
      J=INT(F(J))
  47  J=J+5
      IF(A(J).LT.T)GOTO 47
  48  IF(A(J).GT.Q)GOTO 46
      IF(A(J-1).LT.SJ)GOTO 53
      H=ABS(T+SS-A(J))
      IF(K.EQ.75)GOTO 52
        DO 51 L=MS,NL,5
        IF(A(L).LT.SJ)GOTO 51
        W=ABS(AMOD(U-A(L+2)+A(L+3),1.)-.5)+H
        IF(W.GT.SS)GOTO 51
        Z=.5-AMOD(V+A(L+4),1.)*.5
        X=AMOD(99.-Z-A(L+4)-A(J+1),1.)
        P=W+ABS(AMOD(99.5+A(L+2)+A(J+3)+X+Z,1.)-.5)
        IF(P.GT.SS)GOTO 49
        NE=NE+5
        B(NE)=A(I)*A(L)*A(J-1)/(1.+(P*A(2))**2*A(53))
        B(NE+2)=X
        B(NE+3)=AMOD(99.-X-A(I+2)-A(L+3),1.)
        B(NE+4)=Z
  49    Y=AMOD(99.-Z-A(L+4)-A(J+2),1.)
        P=W+ABS(AMOD(99.5+A(L+3)+A(J+3)+Y+Z,1.)-.5)
        IF(P.GT.SS)GOTO 50
        NE=NE+5
        B(NE)=A(I)*A(L)*A(J-1)/(1.+(P*A(2))**2*A(53))
        B(NE+2)=AMOD(99.-Y-A(I+2)-A(L+3),1.)
        B(NE+3)=Y
        B(NE+4)=Z
  50    IF(NE.GT.LS-14)GOTO 87
  51    CONTINUE
      GOTO 53
  52  NE=NE+5
      B(NE)=A(I)*A(J-1)/(1.+(H*A(2))**2*A(53))
      B(NE+2)=AMOD(99.+A(I+4)-A(J+1),1.)
      B(NE+3)=AMOD(99.+B(NE+2)+A(I+2)-A(J+2),1.)
      B(NE+4)=0.
      NE=NE+5
      B(NE)=B(NE-5)
      B(NE+3)=AMOD(99.+A(I+4)-A(J+2),1.)
      B(NE+2)=AMOD(99.+B(NE+3)+A(I+3)-A(J+1),1.)
      B(NE+4)=0.
      IF(NE.GT.LS-14)GOTO 87
  53  J=J+5
      GOTO 48
  54  CALL SXER('UNKNOWN SPACE GROUP')
C
C Polar x axis
C
  55  K=75
      IF(MR.NE.2)GOTO 57
  56  K=K+12
      IF(K.GT.LY)GOTO 54
      IF(ABS(A(K)-1.)+ABS(A(K+1))+ABS(A(K+2)).GT.0.1)GOTO 56
      IF(ABS(A(K+3))+ABS(A(K+4)+1.)+ABS(A(K+5)).GT.0.1)GOTO 56
      IF(ABS(A(K+6))+ABS(A(K+7))+ABS(A(K+8)+1.).GT.0.1)GOTO 56
      S=A(K+9)+99.-SS
      U=A(K+10)+99.
      V=A(K+11)+99.
      GOTO 59
C
C Polar y axis
C
  57  IF(MR.NE.3)GOTO 65
      IF(NJ.NE.0)GOTO 65
  58  K=K+12
      IF(K.GT.LY)GOTO 54
      IF(ABS(A(K)+1.)+ABS(A(K+1))+ABS(A(K+2)).GT.0.1)GOTO 58
      IF(ABS(A(K+3))+ABS(A(K+4)-1.)+ABS(A(K+5)).GT.0.1)GOTO 58
      IF(ABS(A(K+6))+ABS(A(K+7))+ABS(A(K+8)+1.).GT.0.1)GOTO 58
      U=A(K+9)+99.
      S=A(K+10)+99.-SS
      V=A(K+11)+99.
C
C Polar x or y axis search
C
  59  I=LD+10
  60  I=I+5
      IF(I.GT.NW)GOTO 87
      IF(A(I).LT.SK)GOTO 60
      T=AMOD(A(I+1)+S,1.)
      IF(T.LT.0.5*SS)T=T+1.
      J=INT(100.*T+1.)
      IF(J.GT.LU)J=LU
      Q=T+2.*SS
      J=INT(F(J))
  61  J=J+5
      IF(A(J).LT.T)GOTO 61
  62  IF(A(J).GT.Q)GOTO 60
      IF(A(J-1).LT.SJ)GOTO 64
      H=ABS(T+SS-A(J))*A(MR)
      IF(NE.GT.LS-19)GOTO 87
      NE=NE+5
      B(NE)=A(I)*A(J-1)/(1.+H**2*A(53))
      B(NE+4)=AMOD(V-A(J+3)-A(I+4),1.)*.5
      IF(MR.EQ.3)GOTO 63
      B(NE+2)=0.
      B(NE+3)=AMOD(U-A(J+2)-A(I+3),1.)*.5
      GOTO 64
  63  B(NE+2)=AMOD(U-A(J+1)-A(I+2),1.)*.5
      B(NE+3)=0.
  64  J=J+5
      GOTO 62
C
C Prepare general searches
C
  65  K=75
      T=99.
  66  K=K+12
      IF(K.GT.LY)GOTO 68
      IF(ABS(A(K+2))+ABS(A(K+5))+ABS(A(K+6))+ABS(A(K+7))+
     +ABS(A(K+8)-1.).GT.0.1)GOTO 66
      IF(LY.EQ.87)GOTO 67
      IF(ABS((A(K)-1.)*(A(K+4)-1.)-A(K+1)*A(K+3)).LT.0.1)GOTO 66
  67  S=AMOD(99.99+A(K+11),1.)
      IF(T.LT.S)GOTO 66
      T=S
      M=K
      GOTO 66
  68  IF(T.GT.98.)GOTO 54
      S=T+99.01-A(63)
      NN=1
      U=A(M+9)
      V=A(M+10)
      IF(NK.NE.0)GOTO 69
      XX=-.5
      XY=0.
      YX=0.
      YY=-.5
      IF(NI.EQ.0)GOTO 72
      IF(NJ.NE.0)GOTO 69
      NI=-1
      GOTO 72
  69  YY=A(M+4)-1.
      ZZ=(A(M)-1.)*YY-A(M+1)*A(M+3)
      NN=INT(ABS(ZZ)+.01)
      IF(NN.NE.2)GOTO 70
      IF(LY.GT.206)NN=4
  70  IF(NN.EQ.0)GOTO 54
      XX=YY/ZZ
      YY=(A(M)-1.)/ZZ
      XY=A(M+1)/ZZ
      YX=A(M+3)/ZZ
      IF(NK.EQ.0)GOTO 72
      K=75
  71  K=K+12
      IF(K.GT.LY)GOTO 54
      IF(ABS(A(K+2))+ABS(A(K+5))+ABS(A(K+6))+ABS(A(K+7))+
     +ABS(A(K+8)+1.).GT.0.1)GOTO 71
C
C Primary search
C
  72  I=LX+8
  73  I=I+5
      IF(I.GT.NL)GOTO 87
      IF(A(I).LT.SK)GOTO 73
      CALL SXCC
      T=AMOD(A(I+4)+S,1.)
      IF(T.LT.0.5*A(63))T=T+1.
      J=INT(100.*T+1.)
      IF(J.GT.LU)J=LU
      Q=T+2.*A(63)
      J=INT(G(J))
  74  J=J+5
      IF(A(J).LT.T)GOTO 74
  75  IF(A(J).GT.Q)GOTO 73
      IF(A(J-4).LT.SJ)GOTO 80
      H=((T+A(63)-A(J))*A(4))**2
      X=A(J-2)-A(I+2)-U
      Z=A(J-1)-A(I+3)-V
      IF(NI.GT.0)GOTO 76
      Y=Z
      IF(NI.EQ.0)Y=X
      L=2-NI
      H=H+((AMOD(Y+99.5,1.)-.5)*A(L))**2
      IF(H.GT.A(43))GOTO 80
  76  Y=Z*YY-X*YX
      X=X*XX-Z*XY
      JJ=1
      IF(NK.NE.0)GOTO 81
      NE=NE+5
      B(NE)=A(I)*A(J-4)/(1.+H*A(53))
      B(NE+2)=X-A(I+2)
      IF(NI.EQ.0)B(NE+2)=0.
      B(NE+3)=Y-A(I+3)
      IF(NI.EQ.-1)B(NE+3)=0.
      B(NE+4)=0.
      IF(NN.NE.3)GOTO 78
      IF(LY.EQ.99)GOTO 79
      IF(LZ-LJ.EQ.8)GOTO 79
        DO 77 L=1,2
        NE=NE+5
        B(NE)=B(NE-5)
        B(NE+2)=B(NE-3)+.3333333
        B(NE+3)=B(NE-2)+.6666667
        B(NE+4)=0.
  77    CONTINUE
      GOTO 79
  78  B(NE+2)=AMOD(99.+B(NE+2),.5)
      B(NE+3)=AMOD(99.+B(NE+3),.5)
      IF(NN.EQ.1)GOTO 79
      NE=NE+5
      B(NE)=B(NE-5)
      B(NE+2)=B(NE-3)+.5
      B(NE+3)=B(NE-2)
      B(NE+4)=0.
  79  IF(NE.GT.LS-19)GOTO 87
  80  J=J+5
      GOTO 75
C
C Secondary search
C
  81  W=A(K)*X+A(K+1)*Y+A(K+9)+A(I+2)-X+99.5
      P=AMOD(99.+A(K+3)*X+A(K+4)*Y+A(K+10)+A(I+3)-Y-SS,1.)
      Z=A(K+11)-A(I+4)
      IF(P.LT.0.5*SS)P=P+1.
      L=INT(100.*P+1.)
      IF(L.GT.LU)L=LU
      R=P+2.*SS
      L=INT(F(L))
  82  L=L+5
      IF(A(L).LT.P)GOTO 82
  83  IF(A(L).GT.R)GOTO 85
      IF(A(L-1).LT.SJ)GOTO 84
      TX=AMOD(W-A(L+1),1.)-.5
      TY=P+SS-A(L)
      TX=A(8)*TX**2+A(9)*TY**2+A(13)*TX*TY+H
      IF(TX.GT.A(43))GOTO 84
      NE=NE+5
      B(NE)=A(I)*A(J-4)*A(L-1)/(1.+TX*A(53))
      B(NE+2)=X-A(I+2)
      B(NE+3)=Y-A(I+3)
      B(NE+4)=.5*(Z-A(L+3))
      IF(NE.GT.LS-14)GOTO 87
  84  L=L+5
      GOTO 83
  85  JJ=JJ+1
      IF(JJ.GE.NN)GOTO 80
      IF(NN.NE.3)GOTO 86
      IF(LZ-LJ.EQ.8)GOTO 80
      X=X+.3333333
      Y=Y+.6666667
      GOTO 81
  86  X=X+.5
      IF(JJ.EQ.2)Y=Y+.5
      GOTO 81
C
C Sort acentric list and retain strongest indications
C
  87  IF(NE.LT.0)GOTO 115
      I4=-4
  88  I4=I4+5
      IF(I4.GT.NE)GOTO 110
      U=B(I4+2)
      V=B(I4+3)
      W=B(I4+4)
      T=B(I4)
      J4=I4
  89  J4=J4+5
  90  IF(J4.GT.NE)GOTO 93
      XX=B(J4+2)-U
      YY=B(J4+3)-V
      ZZ=B(J4+4)-W+.5-.5*ZN
        DO 92 L=LJ,LZ,4
        X=AMOD(A(L+1)+XX,1.)-.5
        Y=AMOD(A(L+2)+YY,1.)-.5
        IF(ABS(X).LT.A(61))GOTO 91
        IF(NA.NE.2)GOTO 89
        X=AMOD(X+9.,1.)-.5
        IF(ABS(X).GT.A(61))GOTO 89
        Y=AMOD(Y+9.,1.)-.5
        IF(ABS(Y).GT.A(62))GOTO 89
  91    Z=AMOD(A(L+3)+ZZ,ZN)-.5*ZN
        R=A(8)*X**2+A(9)*Y**2+A(10)*Z**2+A(11)*Y*Z+A(12)*X*Z+
     +  A(13)*X*Y
        IF(R.GT.A(43))GOTO 92
        T=T+B(J4)
        P=B(J4)/T
        U=U+X*P
        V=V+Y*P
        W=W+Z*P
        CALL SXCA(B(NE),B(J4),5)
        NE=NE-5
        GOTO 90
  92    CONTINUE
      GOTO 89
  93  IF(ND.LT.LM-9)GOTO 96
      W=T
      L=0
      J=LD+5
  94  J=J+5
      IF(J.GT.ND)GOTO 95
      IF(A(J).GT.W)GOTO 94
      L=J
      W=A(J)
      GOTO 94
  95  IF(L.EQ.0)GOTO 88
      GOTO 97
  96  ND=ND+5
      L=ND
  97  A(L)=T
      A(L+2)=AMOD(99.+U,1.)
      A(L+3)=AMOD(99.+V,1.)
      A(L+4)=AMOD(99.+W,1.)
      GOTO 88
C
C If centrosymmetric, look for inversion centre
C
  98  NI=0
      N=LV
  99  N=N+8
      IF(N.GT.JZ)GOTO 104
      IF(A(N+5).LT.SK)GOTO 104
      CALL SXCC
      XX=99.5+A(N+2)
      YY=99.5+A(N+3)
      ZZ=99.5+A(N+4)
      NI=NI+1
      M=LX+8
 100  M=M+5
      IF(M.GT.NL)GOTO 99
      IF(A(M).LT.SJ)GOTO 100
      IF(INT(ABS(A(M+1))).LT.NI)GOTO 100
      X=0.5*(XX-A(M+2))
      Y=0.5*(YY-A(M+3))
      Z=0.5*(ZZ-A(M+4))
      P=A(N+5)*A(M)
      S=1.
 101  L=LD+5
 102  L=L+5
      IF(L.GT.ND)GOTO 103
      U=AMOD(X-A(L+2)*S,.5)-.25
      V=AMOD(Y-A(L+3)*S,.5)-.25
      W=AMOD(Z-A(L+4)*S,.5)-.25
      IF(A(8)*U**2+A(9)*V**2+A(10)*W**2+A(11)*V*W+
     +A(12)*U*W+A(13)*U*V.GT.A(43))GOTO 102
      A(L)=A(L)+P
      P=P*S/A(L)
      A(L+2)=A(L+2)+U*P
      A(L+3)=A(L+3)+V*P
      A(L+4)=A(L+4)+W*P
      GOTO 100
 103  S=-S
      IF(S.LT.0.)GOTO 101
      ND=ND+5
      A(ND)=P
      A(ND+2)=AMOD(X,.5)+.25
      A(ND+3)=AMOD(Y,.5)+.25
      A(ND+4)=AMOD(Z,.5)+.25
      IF(ND.LT.LM-8)GOTO 100
C
C Sort centric list and retain strongest indications
C
 104  L=LD+5
      LR=ND+4
      IF(ND.GT.L)CALL SXQS(ND-L,0,-5,A(L+5))
      J=MIN0(ND,L+10)
      Q=.25*A(J)
      IF(A(21).LT.0.)Q=.4*Q
 105  L=L+5
      IF(L.GT.ND)GOTO 106
      IF(A(L).GT.Q)GOTO 105
 106  ND=L-5
      M=ND
      J=1
 107  J=J+1
      IF(J.GT.NA)GOTO 110
      L=LD+5
 108  L=L+5
      IF(L.GT.M)GOTO 107
      IF(ND.GT.LM-9)GOTO 110
      ND=ND+5
      A(ND)=A(L)
      A(ND+2)=A(L+2)+.5*REAL(J/3)
      A(ND+3)=A(L+3)+.5*REAL(MOD(J+1,2))
      A(ND+4)=A(L+4)
      GOTO 108
 109  CALL SXER('INSUFFICIENT MEMORY FOR PATTERSON ANALYSIS')
 110  L=ND-LD-5
      IF(L.GT.0)CALL SXQS(L,0,-5,A(LD+10))
      LR=MAX0(JZ+4,ND+4)
      Q=.2*A(LD+10)
      NK=LD+105
      L=LD+5
      IF(A(21).GT.0.)GOTO 111
      Q=.5*Q
      NK=NK+150
 111  L=L+5
      IF(L.GT.ND)GOTO 112
      IF(L.GT.NK)GOTO 112
      IF(L.GT.LM-2000)GOTO 112
      IF(A(L).GT.Q)GOTO 111
 112  ND=L-5
      GOTO 113
 113  IF(ND.LT.LD+9)GOTO 115
      IF(A(70).LT.1.5)GOTO 116
      WRITE(LI,5)
      L=LD+5
      P=99.9/A(L+5)
 114  L=L+5
      IF(L.GT.ND)GOTO 116
      A(L)=A(L)*P
      WRITE(LI,6)A(L+2),A(L+3),A(L+4),A(L)
      GOTO 114
 115  WRITE(LI,7)
 116  A(40)=REAL(ND)
      A(41)=REAL(NE)
      A(44)=AM
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SX2J(LM,LS,LU,F,G,A,B)
C
C Heavy-atom Patterson solution - part 2
C
      CHARACTER*1 IH(22),IT(76),IR(80),HK(80),KD
      CHARACTER*4 KR,KS
      CHARACTER*80 NM
      REAL F(LU),G(LU),A(LM),B(LS)
      COMMON/MEM/ST,SL,TC,TL,LR,LG,LH,LI,LP,LF,LA,LB,
     +LW,LY,LL,LQ,LE,LV,LX,LD,LZ,LJ,LN,LK,LC,HA,HD
      COMMON/WORD/IH,IT,IR,HK,NM,KD
C
   1  FORMAT(/' ** Nsup too large for full symmetry check **'/)
   2  FORMAT(//' Symmetry-consistent potential atoms'//'  del(x)  de',
     +'l(y)  del(z)  misses  min(peak)  weight     x       y       z')
   3  FORMAT(/3F8.4,I6,F11.2,F10.1,3F8.4)
   4  FORMAT(24X,I6,F11.2,F10.1,3F8.4)
   5  FORMAT(//' Potential origin shifts after symmetry check'//
     +'  del(x)  del(y)  del(z)  N(atoms)  SYMFOM  '/)
   6  FORMAT(3F8.4,I7,F10.1)
   7  FORMAT(' PATFOM =',F5.1,'   Corr. Coeff. =',F5.1,
     +'   SYMFOM =',F5.1,'  for',I4,' heavy atoms')
   8  FORMAT(///' Heavy-Atom Location for ',76A1//I7,
     +' reflections used for structure factor sums')
   9  FORMAT(///' Solution',I4,'    CFOM =',F6.2,'    PATFOM =',
     +F5.1,'    Corr. Coeff. =',F5.1,'    SYMFOM =',F5.1
     +//' Shift to be added to superposition coordinates:',
     +3F8.4///' Name  At.No.   x       y       z    s.o.f.',
     +'  Minimum distances / PATSMF (self first)')
  10  FORMAT(/1X,A4,F6.1,4F8.4,2F8.2,11F6.2)
  11  FORMAT(A4,I4,4F9.5,'   0.04',A1)
  12  FORMAT(43X,2F8.1,11F6.1)
  13  FORMAT(//' ** No consistent heavy atoms found **')
  14  FORMAT(//' Maximum memory for Patterson ',
     +'interpretation =',I6,' /',I6)
  15  FORMAT(80A1/'END ',A1)
C
      ZM=100.*AMOD(A(20),1.)
      ND=INT(A(40))
      NE=INT(A(41))
      M4=NE+3
      AM=A(44)
      TN=-1.
      IF(INT(A(23))+75.GT.LY)GOTO 48
      M4=M4+1
      IF(ND.LT.LD+9)GOTO 119
      NT=(LY-63)/12
      IF(A(23).LT.0.5)NT=NT*2
      Q=SQRT(SQRT(REAL(NT)))
        DO 16 I=61,63
        A(I)=A(I)*Q
  16    CONTINUE
      A(43)=A(43)*Q**2
      NT=NT-INT(0.7*REAL(NT+1))
C
C Generate full potential atom list
C
        DO 17 I=LE,LX,8
        A(I+6)=0.
        A(I+7)=0.
  17    CONTINUE
      NF=ND
      NG=ND+5
        DO 19 I=LE,LX,8
        IF(NF.GT.LM-14)GOTO 20
        CALL SXCC
        NF=NF+5
        A(NF)=SQRT(A(I+5))
        CALL SXCA(A(I+2),A(NF+2),3)
        A(I+6)=REAL(NF+1)
        A(I+7)=A(I+6)
          DO 18 L=LJ,LZ,4
          X=AMOD(A(L+1)+2.*A(I+2),1.)-.5
          Y=AMOD(A(L+2)+2.*A(I+3),1.)-.5
          Z=AMOD(A(L+3)+2.*A(I+4),1.)-.5
          IF(A(8)*X**2+A(9)*Y**2+A(10)*Z**2+A(11)*Y*Z+
     +    A(12)*X*Z+A(13)*X*Y.LT.A(43))GOTO 19
  18      CONTINUE
        NF=NF+5
        A(NF)=A(NF-5)
        A(NF+2)=1.-A(I+2)
        A(NF+3)=1.-A(I+3)
        A(NF+4)=1.-A(I+4)
        A(I+7)=REAL(NF+1)
  19    CONTINUE
      GOTO 21
  20  WRITE(LI,1)
      WRITE(*,1)
      CALL SXFL
C
C For each likely origin shift, search for equivalents
C
  21  TH=.4*A(NG)
      MR=0
      IF(A(70).GT.1.5)WRITE(LI,2)
  22  N=LD+5
  23  N=N+5
      IF(N.GT.ND)GOTO 45
      IF(MR.EQ.0)GOTO 24
      ZS=.0001
      A(N)=REAL(NE)+4.1
      IF(A(N+1).LT.TN)GOTO 43
  24  A(N+1)=0.
        DO 25 I=NG,NF,5
        A(I+1)=0.
  25    CONTINUE
      NH=0
        DO 42 I=NG,NF,5
        IF(A(I).LT.TH)GOTO 42
        IF(A(I+1).GT.0.1)GOTO 42
        CALL SXCC
        U=A(I+2)+A(N+2)
        V=A(I+3)+A(N+3)
        W=A(I+4)+A(N+4)
        SP=0.
          DO 27 NS=LJ,LL,4
            DO 26 NK=75,LY,12
            X=AMOD(A(NS+1)+U-A(NS)*(U*A(NK)+V*A(NK+1)+
     +      W*A(NK+2)+A(NK+9)),1.)-.5
            Y=AMOD(A(NS+2)+V-A(NS)*(U*A(NK+3)+V*A(NK+4)+
     +      W*A(NK+5)+A(NK+10)),1.)-.5
            Z=AMOD(A(NS+3)+W-A(NS)*(U*A(NK+6)+V*A(NK+7)+
     +      W*A(NK+8)+A(NK+11)),1.)-.5
            IF(A(8)*X**2+A(9)*Y**2+A(10)*Z**2+A(11)*Y*Z+A(12)*X*Z+
     +      A(13)*X*Y.LT.A(43))SP=SP+1.
  26        CONTINUE
  27      CONTINUE
        WT=0.
        P=A(I)
        K=75
        IF(SP.LT.1.5)GOTO 28
        IF(A(22).LT.0.)GOTO 42
  28    XC=0.
        YC=0.
        ZC=0.
        NI=0
        WX=1.
        S=1.
        TM=999.9
  29    K=K+12
        IF(K.GT.LY)GOTO 37
        XX=99.5+S*(U*A(K)+V*A(K+1)+W*A(K+2)+A(K+9))-A(N+2)
        YY=99.5+S*(U*A(K+3)+V*A(K+4)+W*A(K+5)+A(K+10))-A(N+3)
        ZZ=99.5+S*(U*A(K+6)+V*A(K+7)+W*A(K+8)+A(K+11))-A(N+4)
        NJ=0
        T=AMOD(ZZ-A(63)+.5,1.)
        IF(T.LT.0.5*A(63))T=T+1.
        J=INT(100.*T+1.)
        IF(J.GT.LU)J=LU
        Q=T+2.*A(63)
        R=A(43)
        J=INT(G(J))
  30    J=J+5
        IF(A(J).LT.T)GOTO 30
  31    IF(A(J).GT.Q)GOTO 32
        J=J+5
        IF(A(J-9).LT.0.)GOTO 31
        X=AMOD(XX-A(J-7),1.)-.5
        IF(ABS(X).GT.A(61))GOTO 31
        Y=AMOD(YY-A(J-6),1.)-.5
        Z=AMOD(ZZ-A(J-5),1.)-.5
        Z=A(8)*X**2+A(9)*Y**2+A(10)*Z**2+A(11)*Y*Z+A(12)*X*Z+
     +  A(13)*X*Y
        IF(Z.GT.R)GOTO 31
        R=Z
        NJ=J-9
        T=A(NJ)
        GOTO 31
  32    IF(NJ.GT.0)GOTO 33
        NI=NI+1
        IF(NI.GT.NT)GOTO 42
        GOTO 29
  33    IF(MR.EQ.0)GOTO 36
        XT=A(NJ+2)+A(N+2)
        YT=A(NJ+3)+A(N+3)
        ZT=A(NJ+4)+A(N+4)
        R=A(43)
          DO 35 NS=LJ,LL,4
            DO 34 NK=75,LY,12
            X=AMOD(A(NS+1)+U-A(NS)*(XT*A(NK)+YT*A(NK+1)+
     +      ZT*A(NK+2)+A(NK+9)),1.)-.5
            Y=AMOD(A(NS+2)+V-A(NS)*(XT*A(NK+3)+YT*A(NK+4)+
     +      ZT*A(NK+5)+A(NK+10)),1.)-.5
            Z=AMOD(A(NS+3)+W-A(NS)*(XT*A(NK+6)+YT*A(NK+7)+
     +      ZT*A(NK+8)+A(NK+11)),1.)-.5
            H=A(8)*X**2+A(9)*Y**2+A(10)*Z**2+A(11)*Y*Z+A(12)*X*Z+
     +      A(13)*X*Y
            IF(H.GT.R)GOTO 34
            R=H
            XQ=X
            YQ=Y
            ZQ=Z
  34        CONTINUE
  35      CONTINUE
  36    H=SQRT(T)/(1.+A(53)*R)
        P=P+H
        IF(MR.EQ.0)GOTO 29
        XC=XC-XQ*H
        YC=YC-YQ*H
        ZC=ZC-ZQ*H
        Z=A(NJ+1)
        NJ=INT(ABS(Z))*8+LV
        IF(INT(A(NJ+6)).EQ.I+1)WX=.5
        IF(INT(A(NJ+7)).EQ.I+1)WX=.5
        IF(Z.LT.0.)NJ=NJ+1
        NJ=INT(A(NJ+6))
        IF(NJ.GT.0)A(NJ)=1.
        TM=AMIN1(ABS(T),TM)
        GOTO 29
  37    S=-S
        K=63
        IF(S.LT.-2.*A(23))GOTO 29
        IF(MR.EQ.0)GOTO 41
        IF(P.LE.WT)GOTO 38
        U=U+XC/P
        V=V+YC/P
        W=W+ZC/P
        IF(P.LT.WT+.05)GOTO 39
        WT=P
        P=0.
        GOTO 28
  38    P=WT
  39    WS=P**2
        IF(ZS.LT.WS)ZS=WS
        IF(AM*(WS/ZS+.05).LT.ZM)GOTO 42
        NE=NE+4
        B(NE)=WS
        B(NE+1)=U
        B(NE+2)=V
        B(NE+3)=W
        IF(A(70).LT.1.5)GOTO 41
        IF(NH.EQ.0)GOTO 40
        WRITE(LI,4)NI,TM,WS,U,V,W
        GOTO 41
  40    WRITE(LI,3)A(N+2),A(N+3),A(N+4),NI,TM,WS,U,V,W
        NH=1
  41    A(N+1)=A(N+1)+WX*(P**2/SP)**2/(1.5+REAL(NI))
  42    CONTINUE
      IF(AMOD(99.002+A(N+2),.25)+AMOD(99.002+A(N+3),.25)+
     +AMOD(99.002+A(N+4),.25).LT.0.01)A(N+1)=.5*A(N+1)
      IF(MR.EQ.0)GOTO 23
      GOTO 44
  43  A(N+1)=-1.
  44  NE=NE+4
      B(NE)=0.
      IF(NE.LT.LS-400)GOTO 23
C
C Select best solutions
C
  45  IF(MR.GT.0)GOTO 48
      TN=.0001
      I=LD+5
  46  I=I+5
      IF(I.GT.ND)GOTO 47
      IF(A(I+1).GT.TN)TN=A(I+1)
      GOTO 46
  47  NE=-3
      MR=1
      TN=.25*TN
      IF(A(21).LT.0.)TN=.6*TN
      TH=0.
      GOTO 22
C
C Sort and shuffle up solution list
C
  48  N=ND-LD-5
      IF(M4.LT.NE)M4=NE
      IF(N.GT.5)CALL SXQS(N,1,-5,A(LD+10))
      IF(A(LD+11).LT.0.02)GOTO 118
      T=99.9/A(LD+11)
      P=.25*A(LD+11)
      IF(A(21).LT.0.)P=.6*P
      LX=LV
      N=LD+5
  49  N=N+5
      IF(N.GT.ND)GOTO 50
      IF(N.GT.LD+105)GOTO 50
      IF(A(N+1).LT.P)GOTO 50
      Q=T*A(N+1)
      LX=LX+9
      A(LX)=A(N)
      A(LX+2)=Q
      CALL SXCA(A(N+2),A(LX+3),3)
      CALL SXZA(A(LX+6),3)
      GOTO 49
  50  IF(A(70).LT.1.5)GOTO 51
      WRITE(LI,5)
C
C Prepare atom list for structure factor sums
C
  51  N=LV
      LE=LX+2
      LD=LX+9
  52  N=N+9
      IF(N.GT.LX)GOTO 61
      L4=INT(A(N))
      A(N)=REAL(LE+7)
      NJ=LE
      I4=L4-4
      J4=I4
  53  J4=J4+4
      IF(ABS(B(J4)).GT.0.1)GOTO 53
      CALL SXQS(J4-I4,0,-4,B(L4))
  54  I4=I4+4
      IF(ABS(B(I4)).LT.0.1)GOTO 60
      WT=AM*(B(I4)/B(L4)+.05)
      IF(WT.LT.ZM)GOTO 60
      CALL SXCC
      H=0.
      X=0.
      Y=0.
      Z=0.
      U=B(I4+1)
      V=B(I4+2)
      W=B(I4+3)
        DO 58 K=75,LY,12
        XX=U*A(K)+V*A(K+1)+W*A(K+2)+A(K+9)
        YY=U*A(K+3)+V*A(K+4)+W*A(K+5)+A(K+10)
        ZZ=U*A(K+6)+V*A(K+7)+W*A(K+8)+A(K+11)
          DO 57 M=LJ,LL,4
          L=NJ
  55      L=L+7
          IF(L.GT.LE)GOTO 56
          P=AMOD(A(M+1)+A(M)*XX-A(L+2),1.)-.5
          Q=AMOD(A(M+2)+A(M)*YY-A(L+3),1.)-.5
          R=AMOD(A(M+3)+A(M)*ZZ-A(L+4),1.)-.5
          R=A(8)*P**2+A(9)*Q**2+A(10)*R**2+A(11)*Q*R+A(12)*P*R+
     +    A(13)*P*Q
          IF(R.LT.A(43))GOTO 54
          IF(R.GT.2.)GOTO 55
          IF(A(L).GT.2.*A(L+1)*WT)GOTO 54
          GOTO 55
  56      P=AMOD(A(M+1)+A(M)*XX-U,1.)-.5
          Q=AMOD(A(M+2)+A(M)*YY-V,1.)-.5
          R=AMOD(A(M+3)+A(M)*ZZ-W,1.)-.5
          IF(A(8)*P**2+A(9)*Q**2+A(10)*R**2+A(11)*Q*R+A(12)*P*R+
     +    A(13)*P*Q.GT.A(43))GOTO 57
          H=H+1.
          X=X+P
          Y=Y+Q
          Z=Z+R
  57      CONTINUE
  58    CONTINUE
      H=1./H
      IF(A(22).GT.0.)GOTO 59
      IF(H.LT.0.9)GOTO 54
  59  LE=LE+7
      A(LE)=WT*H
      A(LE+1)=H
      A(LE+2)=AMOD(U+X*H+99.,1.)
      A(LE+3)=AMOD(V+Y*H+99.,1.)
      A(LE+4)=AMOD(W+Z*H+99.,1.)
      A(LE+5)=REAL(N+6)
      IF(LE.GE.NJ+7*INT(A(20)))GOTO 60
      IF(LE.LT.LM-100)GOTO 54
      LX=N
  60  A(N+1)=REAL(LE)
      IF(LE.EQ.NJ)GOTO 52
      A(LE+1)=-ABS(A(LE+1))
      M=(LE-NJ)/7
      IF(A(70).GT.1.5)WRITE(LI,6)A(N+3),A(N+4),A(N+5),M,A(N+2)
      GOTO 52
C
C Generate triangular vector table
C
  61  NE=-4
      IF(LE.LT.LD)GOTO 118
      N=LV
  62  N=N+9
      IF(N.GT.LX)GOTO 73
      N4=NE
      MT=INT(A(N))-7
      I=MT
  63  I=I+7
      IF(I.GT.INT(A(N+1)))GOTO 62
      CALL SXCC
      U=A(I+2)
      V=A(I+3)
      W=A(I+4)
      A(I+6)=REAL(NE+5)
      P=9.E9
      J4=NE
      J=I
  64  S=1.
      I4=NE
      NN=0
  65    DO 70 K=75,LY,12
        XX=AMOD(99.5+S*(U*A(K)+V*A(K+1)+W*A(K+2)+
     +  A(K+9))-A(J+2),1.)-.5
        YY=AMOD(99.5+S*(U*A(K+3)+V*A(K+4)+W*A(K+5)+
     +  A(K+10))-A(J+3),1.)-.5
        ZZ=AMOD(99.5+S*(U*A(K+6)+V*A(K+7)+W*A(K+8)+
     +  A(K+11))-A(J+4),1.)-.5
        L4=I4
  66    L4=L4+5
        IF(L4.GT.NE)GOTO 67
        IF(ABS(XX-B(L4+1))+ABS(YY-B(L4+2))+ABS(ZZ-B(L4+3))
     +  .GT.0.01)GOTO 66
        GOTO 70
  67    T=A(28)**2
          DO 68 L=LJ,LZ,4
          X=AMOD(XX+A(L+1),1.)-.5
          Y=AMOD(YY+A(L+2),1.)-.5
          Z=AMOD(ZZ+A(L+3),1.)-.5
          R=A(8)*X**2+A(9)*Y**2+A(10)*Z**2+A(11)*Y*Z+
     +    A(12)*X*Z+A(13)*X*Y
          IF(R.LT.A(43))GOTO 69
          IF(R.LT.T)T=R
          IF(I.EQ.J)GOTO 68
          IF(R.GT.P)GOTO 68
          P=R
          A(I+2)=X+A(J+2)
          A(I+3)=Y+A(J+3)
          A(I+4)=Z+A(J+4)
  68      CONTINUE
        IF(NE.GT.LS-1000)GOTO 72
        NE=NE+5
        NN=NE+4
        B(NE)=0.
        B(NE+1)=XX
        B(NE+2)=YY
        B(NE+3)=ZZ
        B(NN)=T
        GOTO 70
  69    IF(I.EQ.J)GOTO 70
        NE=J4
        A(I)=0.
        GOTO 63
  70    CONTINUE
      S=-S
      IF(S.LT.-2.*A(23))GOTO 65
      IF(NN.GT.0)GOTO 71
      NE=NE+5
      NN=NE+4
      CALL SXZA(B(NE),4)
      B(NN)=A(28)**2
  71  B(NN)=-B(NN)
      IF(J.EQ.I)J=MT
      J=J+7
      IF(J.GT.MT+84)GOTO 63
      IF(J.LT.I)GOTO 64
      GOTO 63
  72  LX=N-9
      NE=N4
C
C Scan reflection data, generate Laue equivalents
C
  73  JZ=LE+7
      N4=NE+3
      NA=0
      SF=0.
      SS=0.
      H=0.
  74  READ(LA)F
        DO 84 I=1,LU-2,3
        IF(.5.GT.F(I))GOTO 85
        IF(F(I+1).LT.0.)GOTO 84
        CALL SXH2(F(I),X,Y,Z)
        CALL SXCC
        S=0.
        N=LE+2
          DO 77 K=75,LY,12
          P=AINT(1.001*(X*A(K)+Y*A(K+3)+Z*A(K+6)))
          Q=AINT(1.001*(X*A(K+1)+Y*A(K+4)+Z*A(K+7)))
          R=AINT(1.001*(X*A(K+2)+Y*A(K+5)+Z*A(K+8)))
          W=P+200.*(Q+200.*R)
          T=ABS(W)
          IF(A(23).LT.0.5)W=T
          J=LE+2
  75      J=J+5
          IF(J.GT.N)GOTO 76
          IF(ABS(A(J+3)-T).GT.0.5)GOTO 75
          T=-T
  76      N=N+5
          A(N)=6.283185*P
          A(N+1)=6.283185*Q
          A(N+2)=6.283185*R
          A(N+3)=T
          A(N+4)=6.283185*(X*A(K+9)+Y*A(K+10)+Z*A(K+11))
          IF(ABS(F(I)-W).LT.0.5)S=S+1.
  77      CONTINUE
        LR=MAX0(LR,N+4)
C
C Evaluate E*F Patterson at specific points
C
        U=S*F(I+2)**2
        P=F(I+1)*SQRT(U)
          DO 78 J=JZ,N,5
          IF(A(J+3).LT.0.)GOTO 78
          X=A(J)
          Y=A(J+1)
          Z=A(J+2)
          H=H+P
          CALL SV2P(B(1),P,X,Y,Z,N4)
  78      CONTINUE
C
C Calculate correlation coefficient for each solution
C
        NA=NA+1
        SF=SF+U
        SS=SS+U**2
        P=0.
        Q=0.
          DO 83 K=LD,LE,7
          S=A(K)
          X=A(K+2)
          Y=A(K+3)
          Z=A(K+4)
          IF(A(23).GT.0.5)GOTO 80
C
C ** Critical loops (short vector length) **
C
            DO 79 J=JZ,N,5
            P=P+S*COS(X*A(J)+Y*A(J+1)+Z*A(J+2)+A(J+4))
  79        CONTINUE
          GOTO 82
  80        DO 81 J=JZ,N,5
            T=X*A(J)+Y*A(J+1)+Z*A(J+2)+A(J+4)
            P=P+S*COS(T)
            Q=Q+S*SIN(T)
  81        CONTINUE
C
  82      IF(A(K+1).GT.0.)GOTO 83
          J=INT(A(K+5))
          V=P**2+Q**2
          A(J)=A(J)+V**2
          A(J+1)=A(J+1)+V
          A(J+2)=A(J+2)+U*V
          P=0.
          Q=0.
  83      CONTINUE
  84    CONTINUE
      GOTO 74
C
C Calculate Correlation Coefficient and PATFOM
C
  85  H=999./AMAX1(H,0.0001)
      REWIND LA
      NL=LV+9
        DO 104 NI=NL,LX,9
        N=INT(A(NI+1))
        M=INT(A(NI))
        IF(M.GT.N)GOTO 104
        CALL SXCC
        T=REAL(NA)
        A(NI+6)=(A(NI+8)*T-A(NI+7)*SF)/SQRT((SS*T-SF**2)*
     +  (A(NI+6)*T-A(NI+7)**2))
        ND=MIN0((N-M+7)/7,252)
        NF=NE+2
          DO 95 I=M,N,7
          IF(ABS(A(I)).LT.1.E-8)GOTO 95
          I4=INT(A(I+6))
          J=0
  86      J=J+1
          L4=I4
  87      L4=L4+5
          IF(B(L4-1).GT.0.)GOTO 87
          NT=(L4-I4)/5
          NT=NT+81-INT(.7*REAL(NT+1))
          G(80)=-999.
          L=80
  88      R=AMAX1(H*B(I4),0.)
          NK=L+1
          MR=NK
  89      NK=NK-1
          IF(R.LT.G(NK))GOTO 89
          GOTO 91
  90      G(MR+1)=G(MR)
  91      MR=MR-1
          IF(MR.GT.NK)GOTO 90
          MR=MR+1
          G(MR)=R
          L=MIN0(L+1,NT)
          I4=I4+5
          IF(B(I4-1).GT.0.)GOTO 88
          R=0.
            DO 92 NK=81,L
            R=R+G(NK)
  92        CONTINUE
          R=R/REAL(L-80)
          NF=NF+3
          B(NF)=R
          NK=(I-M+7)/7
          B(NF+1)=REAL(NK)
          IF(J.EQ.1)GOTO 93
          B(NF+2)=REAL(J-1)
          GOTO 94
  93      B(NF+2)=B(NF+1)
          B(NF)=2.*R-.0001
  94      IF(J.LT.MIN0(NK,13))GOTO 86
  95      CONTINUE
        IF(NF.GT.NE+2)CALL SXQS(NF-NE-2,0,-3,B(NE+5))
        IF(M4.LT.NF)M4=NF
        A(NI+7)=0.0001
        GOTO 99
  96    X=Y
  97    A(NI+7)=A(NI+7)+SQRT(ABS(B(NF)))
        N4=NF
        NF=NE+2
          DO 98 J4=NE+5,N4,3
          IF(ABS(X-B(J4+1)).LT.0.1)GOTO 98
          IF(ABS(X-B(J4+2)).LT.0.1)GOTO 98
          NF=NF+3
          CALL SXCA(B(J4),B(NF),3)
  98      CONTINUE
  99    IF(NF.LT.NE+6)GOTO 104
        CALL SXZA(F,ND)
        IF(M4.LT.NF+2)M4=NF+2
        J4=NF+3
 100    J4=J4-3
        IF(J4.LT.NE+4)GOTO 101
        IF(B(J4).GT.0.01)GOTO 101
        NK=INT(B(J4+1))
        F(NK)=F(NK)+1.
        NK=INT(B(J4+2))
        F(NK)=F(NK)+1.
        GOTO 100
 101    Y=-1.
          DO 102 J=1,ND
          IF(F(J).LT.Y)GOTO 102
          X=REAL(J)
 102      CONTINUE
        IF(Y.GT.0.5)GOTO 97
        X=B(NF+1)
        Y=B(NF+2)
        IF(ABS(X-Y).LT.0.1)GOTO 97
        J4=NF
 103    J4=J4-3
        IF(ABS(X-B(J4+1)).LT.0.1)GOTO 97
        IF(ABS(X-B(J4+2)).LT.0.1)GOTO 97
        IF(ABS(Y-B(J4+1)).LT.0.1)GOTO 96
        IF(ABS(Y-B(J4+2)).LT.0.1)GOTO 96
        GOTO 103
 104    CONTINUE
C
C Sort and print best solutions
C
      IF(A(70).GT.1.5)CALL SXPG(LI)
      WRITE(LI,8)IT,NA
      ZZ=-1.
        DO 105 N=NL,LX,9
        IF(A(N).GT.A(N+1))GOTO 105
        IF(ZZ.LT.A(N+7))ZZ=A(N+7)
 105    CONTINUE
      QT=.4
      IF(A(21).LT.0.)QT=.2
      NN=0
      XY=.0001
 106  Q=0.
      NF=LY+INT(12.1-12.1*A(23))
        DO 107 N=NL,LX,9
        IF(A(N).GT.A(N+1))GOTO 107
        P=100.*A(N+7)*A(N+6)**2/ZZ
        IF(NF.GT.87)P=.01*A(N+2)*P
        IF(P.LT.Q)GOTO 107
        Q=P
        M=N
 107    CONTINUE
      IF(XY.LT.Q)XY=Q
      IF(Q.LT.QT*XY)GOTO 119
      CALL SXCC
      P=A(M+2)
      R=100.*A(M+6)
      A(M+6)=0.
      S=A(M+7)*99.9/ZZ
      NN=NN+1
      WRITE(LI,9)NN,Q,S,R,P,A(M+3),A(M+4),A(M+5)
      N=INT(A(M+1))
      M=INT(A(M))
      NF=(N-M+7)/7
      IF(NN.EQ.1)WRITE(*,7)S,R,P,NF
      CALL SXFL
      NF=1
        DO 117 I=M,N,7
        IF(ABS(A(I)).LT.1.E-8)GOTO 117
        Q=ABS(A(I+1))
        P=.95*(A(I)/Q+.075*AM)
        I4=INT(A(I+6))
        J=0
 108    J=J+1
        F(J)=A(28)
        L4=I4
 109    L4=L4+5
        IF(B(L4-1).GT.0.)GOTO 109
        NT=81+INT(.058*REAL(L4-I4))
        G(80)=-999.
        L=80
 110    R=AMAX1(H*B(I4),0.)
        NK=L+1
        MR=NK
 111    NK=NK-1
        IF(R.LT.G(NK))GOTO 111
        GOTO 113
 112    G(MR+1)=G(MR)
 113    MR=MR-1
        IF(MR.GT.NK)GOTO 112
        MR=MR+1
        G(MR)=R
        L=MIN0(L+1,NT)
        I4=I4+5
        R=SQRT(ABS(B(I4-1)))
        IF(F(J).GT.R)F(J)=R
        IF(B(I4-1).GT.0.)GOTO 110
        R=0.
          DO 114 NK=81,L
          R=R+G(NK)
 114      CONTINUE
        G(J)=R/REAL(L-80)
        IF(J.LT.MIN0(13,(I-M+7)/7))GOTO 108
        NT=LL-1
        T=9.E9
 115    NT=NT+5
        IF(NT.GT.LQ)GOTO 116
        R=ABS(P/A(NT)-1.)
        IF(R.GT.T)GOTO 115
        T=R
        L=NT+2
        NK=(NT-LL+1)/5
        GOTO 115
 116    CALL SXUS(A(L),KS)
        L=2
        IF(KS(2:2).NE.IH(20))L=3
        CALL SXPN(R,NF)
        CALL SXUS(R,KR)
        KS(L:4)=KR(1:5-L)
        WRITE(LI,10)KS,P,A(I+2),A(I+3),A(I+4),Q,(F(K),K=1,J)
        WRITE(LI,12)(G(K),K=1,J)
        Q=Q+10.
        IF(NN.EQ.1)WRITE(LP,11)KS,NK,A(I+2),A(I+3),A(I+4),Q,KD
        NF=NF+1
 117    CONTINUE
      GOTO 106
 118  WRITE(LI,13)
 119  WRITE(LI,14)LR,M4
      WRITE(LP,15)HK,KD
      CALL SXTM(SL,LI)
      CALL SXFN(I)
      IF(I.LT.0)TL=-1.
      CALL SXTI(T)
      IF(T.GE.TL)GOTO 120
      LX=LV
      IF(LX.LT.LQ)GOTO 120
      LV=LV-8
      IF(A(LX+5).LT.-8.E9)GOTO 121
 120  CALL SXIT
 121  RETURN
      END
