C
C  SHELXPRO - SHELX user interface for protein applications
C             Copyright (C) 1996-9 George M. Sheldrick
C
      PROGRAM SHELXPRO
      COMMON/XTAL/SY(12,192),CELL(15),II(1369),NS,LAT,LU,LN,
     +LO,LP,LF,LM,LS,NOS,IER,NPG
      COMMON/WORD/KF,KR,KD,KE,KA,KB,KN,FMT,COL,OPT
      CHARACTER KF*80,KR*80,KD(462)*52,KA(50000)*4,KE(9999)*4,
     +KB(250)*80,KN(10000)*9,FMT*20,COL*4,OPT*1
C
C ====================================================================
C
C System-specific part of program follows; comment out inappropriate
C versions. KP is a string that clears the screen and moves the cursor
C to the top left hand corner. FMT is a run-time format for requesting
C an answer on the same line.  KR should be set to the command line
C (excluding program name).  NOS is a code to define the operating
C system.  Set LA to the dimension of the array A, which is used as
C working space, and should be as large as conveniently possible.
C
C VMS version
C
C     COMMON A(3000000)
C     INTEGER CLI$GET_VALUE
C     CHARACTER KP*3
C     LA=3000000
C     KP=CHAR(12)//CHAR(12)//CHAR(12)
C     FMT='(A,$)'
C     KR=' '
C     I=CLI$GET_VALUE('$LINE',KR)
C     NOS=2
C
C UNIX version (NOS=3 for SGI, 4 for UNIX with record length of direct
C access files specified in bytes rather than 4-byte words (e.g. Linux)
C
      COMMON A(14000000)
      CHARACTER KP*1
      LA=14000000
      KP=CHAR(12)
      FMT='(A,$)'
      KR=' '
      CALL GETARG(IARGC(),KR)
      NOS=4
C
C Lahey version for MSDOS
C
C     COMMON A(1200000)
C     CHARACTER KP*3
C     LA=1200000
C     KP=CHAR(13)//CHAR(10)//CHAR(10)
C     FMT='(A,$)'
C     KR=' '
C     CALL GETCL(KR)
C     NOS=1
C
C The following may have to be changed for non-standard compilers;
C LU is usd for converting upper to lower case, LO..LS are logical
C unit numbers for input/output.
C
      LU=ICHAR('a')-ICHAR('A')
      LO=10
      LP=11
      LF=12
      LM=13
      LS=14
C
C End of system-specific part - the rest should rarely need changing
C except for subroutine WROPEN for VMS (see comments).
C
C ====================================================================
C
   1  FORMAT(A)
   2  FORMAT(1X,A/' SHELXPRO - SHELX interface for protein applicati',
     +'ons - Version 97-3'/' Copyright(C) George M. Sheldrick 1996-',
     +'2003'//' [F] New output filename',19X,'[V] R(free) files'/
     +' [A] Anisotropic scaling (Hope & Parkin)   [I] .ins from PDB ',
     +'file'/' [P] Progress of LS refinement diagram     [L] Luzzati ',
     +'plot'/' [T] Thermal displacement analysis',9X,'[E] Esd analysis'
     +/' [U] Update .res (and .pdb) to .ins file   [N] NCS analysis'/
     +' [R] Ramachandran Phi-Psi plot',13X,'[K] Kleywegt NCS plot'/
     +' [M] Map file for O from .fcf              [O] PDB file for O'/
     +' [H] .hkl file from other data formats     [Y] X-PLOR/CNS .fob',
     +' to .hkl'/' [D] Convert DENZO/SCALEPACK .sca to .hkl  ',
     +'[C] Color plots (now ',A/' [X] Write XtalView map coefficients',
     +7X,'[W] Write Turbo-Frodo map'/' [S] Reflection statistics from',
     +' .fcf       [Z] Least-squares fit'/' [J] Generate restraints ',
     +'from model        [B] PDB deposition'/' [G] Generate PDB file ',
     +'from .res or .pdb   [Q] Quit'/)
C
C Extract file name stem from command line or ask for it; open the
C files name.pro (text output) and name.ps (Postscript output).
C
      CALL RAMDAT
      NPG=0
      COL='on) '
      LN=0
      KF=' '
      CELL(1)=-1.
      LAT=-99
      M=0
        DO 3 I=1,80
        IF(KR(I:I).EQ.' ')GOTO 3
        M=M+1
        IF(M.EQ.I.AND.NOS.EQ.2)GOTO 3
        LN=LN+1
        KF(LN:LN)=KR(I:I)
   3    CONTINUE
      IF(LN.GT.0)GOTO 6
   4  WRITE(*,1)' Enter filename (without extension) for .pro '//
     +'(text output file) and'
      WRITE(*,FMT)' .ps (Postscript output): '
      KR=' '
      READ(*,'(A)',ERR=4,END=4)KR
      CALL LINTRM(KR,L)
      LN=0
        DO 5 I=1,L
        IF(KR(I:I).EQ.' ')GOTO 5
        LN=LN+1
        KF(LN:LN)=KR(I:I)
   5    CONTINUE
      IF(LN.EQ.0)GOTO 7
   6  KF(LN+1:LN+4)='.pro'
      CALL WROPEN(LO,KF,LN+4,I)
      IF(I.NE.0)GOTO 8
      KF(LN+1:LN+4)='.ps '
      CALL WROPEN(LP,KF,LN+3,I)
      IF(I.NE.0)GOTO 8
      CALL PROLOG
      GOTO 9
   7  LN=-3
   8  WRITE(*,'(/A/)')' ** Cannot open file '//KF(1:LN+4)//' **'
      GOTO 4
C
C Display main menu and request option
C
   9  WRITE(*,2)KP,COL
      WRITE(*,FMT)' Enter option: '
      KR=' '
      READ(*,'(A)',ERR=9,END=9)KR
      CALL LINTRM(KR,I)
      IF(I.EQ.0)I=1
      OPT=KR(I:I)
      IF(OPT.GE.'a')OPT=CHAR(ICHAR(OPT)-LU)
      CALL OPTINF
      IF(IER.LT.0)GOTO 9
      IF(IER.GT.0)GOTO 26
      WRITE(*,'(1X,A)')KP
C
C Toggle Postscript color, open new .pro and .ps output files
C
      IF(OPT.NE.'C')GOTO 11
      IF(COL(2:2).NE.'n')GOTO 10
      COL='off)'
      GOTO 9
  10  COL='on) '
      GOTO 9
  11  IF(OPT.EQ.'F')GOTO 4
C
C File conversion operations
C
      IF(OPT.NE.'I')GOTO 12
      CALL PDBINS(A(1),A(10001),A(20001),A(30001),A(40001),
     +A(50001),A(60001))
      GOTO 25
  12  IF(OPT.NE.'D')GOTO 13
      CALL DENZOS
      GOTO 25
  13  IF(OPT.NE.'Y')GOTO 14
      N=LA/6
      CALL FOBHKL(N,A(1),A(N+1),A(2*N+1),A(3*N+1),A(4*N+1),A(5*N+1))
      GOTO 25
  14  IF(OPT.NE.'V')GOTO 15
      CALL RFREE
      GOTO 25
  15  IF(OPT.NE.'O')GOTO 16
      CALL PDBTOO(A(1),A(10001))
      GOTO 26
  16  IF(OPT.NE.'H')GOTO 17
      CALL HKLGEN
      GOTO 25
  17  IF(OPT.NE.'U')GOTO 18
      N=(LA-512)/19
      CALL OTOINS(N,A(1),A(N+1),A(2*N+1),A(3*N+1),A(4*N+1),A(5*N+1),
     +A(6*N+1),A(7*N+1),A(8*N+1),A(9*N+1),A(10*N+1),A(11*N+1),
     +A(12*N+1),A(13*N+1),A(19*N+1))
      GOTO 26
  18  IF(OPT.NE.'B')GOTO 19
      N=(LA-50000)/4
      CALL PDBDEP(N,A(1),A(10001),A(20001),A(30001),A(40001),
     +A(50001),A(N+50001),A(2*N+50001),A(3*N+50001))
      GOTO 25
C
C Open .fcf and extract cell, symmetry etc. if option A, L, M or S
C
  19  IF(OPT.EQ.'A')GOTO 20
      IF(OPT.EQ.'L')GOTO 20
      IF(OPT.EQ.'M')GOTO 20
      IF(OPT.EQ.'W')GOTO 20
      IF(OPT.EQ.'X')GOTO 20
      IF(OPT.NE.'S')GOTO 27
  20  CALL FCFINP
      IF(IER.NE.0)GOTO 26
C
C Reflection data statistics, maps and anisotropic scaling
C
      IF(OPT.EQ.'L')GOTO 21
      IF(OPT.NE.'S')GOTO 22
  21  N=MIN0(LA/11,100)
      CALL FCFSTA(N,A(1),A(N+1),A(2*N+1),A(3*N+1),A(4*N+1),
     +A(5*N+1),A(6*N+1),A(7*N+1),A(8*N+1),A(9*N+1),A(10*N+1))
      GOTO 25
  22  IF(OPT.EQ.'X')GOTO 23
      IF(OPT.EQ.'W')GOTO 23
      IF(OPT.NE.'M')GOTO 24
  23  N=(LA-4096)/9
      M=N/4
      CALL FCFMAP(N,M,A(1),A(4097),A(N+4097),A(2*N+4097),A(3*N+4097),
     +A(4*N+4097),A(5*N+4097),A(6*N+4097),A(7*N+4097),A(8*N+4097))
      GOTO 25
  24  N=LA/7
      CALL HOPE(N,A(1),A(N+1),A(2*N+1),A(3*N+1),A(4*N+1),A(5*N+1),
     +A(6*N+1))
  25  IER=-1
  26  CLOSE(LF,IOSTAT=I)
      IF(IER.EQ.0)GOTO 9
      WRITE(*,'(1X)')
      WRITE(*,FMT)' <Enter> to continue: '
      READ(*,'(A)',ERR=9,END=9)KR
      GOTO 9
C
C Generate Postscript plots from .lst for options E, N, T or P
C
  27  IF(OPT.EQ.'N')GOTO 28
      IF(OPT.EQ.'K')GOTO 28
      IF(OPT.EQ.'R')GOTO 28
      IF(OPT.NE.'T')GOTO 29
  28  N=(LA-100000)/2
      CALL LST2PS(N,A(1),A(10001),A(20001),A(30001),A(40001),
     +A(50001),A(60001),A(70001),A(80001),A(90001),A(N+100001))
      IF(OPT.EQ.'R'.OR.OPT.EQ.'K')IER=-1
      GOTO 26
  29  IF(OPT.NE.'E')GOTO 30
      CALL LSTESD(N,A(1),A(10001))
      GOTO 25
  30  IF(OPT.NE.'P')GOTO 31
      CALL WATPRO(A(1),A(10001),A(20001),A(30001))
      GOTO 25
  31  IF(OPT.NE.'Z')GOTO 32
      N=(LA-44)/7
      CALL LSQFIT(N,A(1),A(N+1),A(2*N+1),A(3*N+1),A(4*N+1),A(5*N+1),
     +A(6*N+1),A(7*N+1))
      GOTO 25
  32  IF(OPT.EQ.'J')GOTO 33
      IF(OPT.NE.'G')GOTO 34
  33  N=(LA-512)/6
      CALL NEWPDB(N,A(1),A(N+1),A(2*N+1),A(3*N+1),A(4*N+1),A(5*N+1),
     +A(6*N+1))
      GOTO 26
  34  IF(OPT.NE.'Q')GOTO 9
      CALL PSTERM
      END
C
C -------------------------------------------------------------------
C
      SUBROUTINE WROPEN(N,KT,L,IER)
C
C Open a text file for writing.  The filename is contained in KT(1:L)
C and IER is set to 0 if successful and 1 if an error occurs.
C
      CHARACTER*(*)KT
      CLOSE(N,IOSTAT=IER)
C
C These instructions should be used if the operating system is NOT VMS.
C They must be commented out for VMS.
C
      OPEN(N,FILE=KT(1:L),STATUS='OLD',IOSTAT=IER)
      CLOSE(N,STATUS='DELETE',IOSTAT=IER)
      OPEN(N,FILE=KT(1:L),STATUS='NEW',FORM='FORMATTED',IOSTAT=IER)
C
C And the following are needed for VMS.  They have to be commented out
C for other systems because some compilers do not like CARRIAGECONTROL.
C
C     OPEN(N,FILE=KT(1:L),STATUS='NEW',FORM='FORMATTED',
C    +CARRIAGECONTROL='LIST',IOSTAT=IER)
C
      RETURN
      END
C
C -------------------------------------------------------------------
C
      SUBROUTINE OPTINF
C
C Explain option selected and permit exit with 'N'
C
      COMMON/XTAL/SY(12,192),CELL(15),II(1369),NS,LAT,LU,LN,
     +LO,LP,LF,LM,LS,NOS,IER,NPG
      COMMON/WORD/KF,KR,KD,KE,KA,KB,KN,FMT,COL,OPT
      CHARACTER KF*80,KR*80,KD(462)*52,KA(50000)*4,KE(9999)*4,
     +KB(250)*80,KN(10000)*9,FMT*20,COL*4,OPT*1
C
      WRITE(*,'(1X)')
      IF(OPT.NE.'F')GOTO 2
      WRITE(*,1)
      GOTO 55
   1  FORMAT(' Reset the filename stem used for creating new files; ',
     +'this was originally'/' set from the command line or prompted ',
     +'for (if the program was started with'/' no command line',
     +' arguments).  The name.pro log file and name.ps Postscript '/
     +' output file are closed and reopened with the new names.')
C
   2  IF(OPT.NE.'V')GOTO 4
      WRITE(*,3)
      GOTO 55
   3  FORMAT(' Reads a file in SHELX HKLF 3 or 4 format and creates',
     +' a new .hkl file in'/' which P% of the data are flagged for',
     +' use in an R(free) test by SHELXL using'/' CGLS N -1 or L.S.',
     +' N -1. These reflections may be chosen either at random or'/
     +' in thin resolution shells. The latter option is recommended',
     +' when NCS (non-'/' crystallographic symmetry) or twinning is',
     +' present. CGLS or L.S. without the'/' second parameter may be',
     +' used for the final refinement against all data.'/' See A.T. B',
     +'runger, Nature 355 (1992) 472-475 for a discussion of R(free).')
C
   4  IF(OPT.NE.'A')GOTO 6
      WRITE(*,5)
      GOTO 55
   5  FORMAT(' Reads a file name.fcf created using the LIST 6 ',
     +'instruction in SHELXL, writes'/' a NEW name.hkl file after ',
     +'application of anisotropic scaling by the method of '/
     +' S.Parkin, B.Moezzi & H.Hope, J.Appl.Cryst. 28 (1995) 53-56. ',
     +'The modification'/' of the observed structure factors in this',
     +' way is scientifically suspect and'/' is intended for ',
     +'testing purposes only.  It is much better to use the HOPE '/
     +' instruction in SHELXL so that parameter correlations are ',
     +'taken into account'/' and the observed data are not modified.',
     +'  The SHELXPRO correction provides a'/' quick test as to ',
     +'whether HOPE in SHELXL will result in a significant'/
     +' improvement; in this case the question about the filename',
     +' for corrected data'/' should be answered with <CR>.  A ',
     +'"local" R-free test is applied to establish'/
     +' how many parameters [none(!), 12, 18',
     +' or 24] may justifiably be fitted.  A'/' significant',
     +' improvement is not to be expected if anisotropic refinement',
     +' has'/' been performed or if a large number of symmetry ',
     +'equivalents were merged in'/' the data reduction.')
C
   6  IF(OPT.NE.'I')GOTO 9
      WRITE(*,7)
      WRITE(*,8)
      GOTO 55
   7  FORMAT(' Reads a PDB file and generates a SHELXL .ins file.  ',
     +'The PDB file is assumed'/' to conform strictly to the PDB ',
     +'format as defined by the Protein Data Bank,'/' but closely ',
     +'related non-standard formats (e.g. CCP4 and XPLOR) can usually'
     +/' be understood.  The program will ask for the missing cell ',
     +'and symmetry'/' information etc.  Engh and Huber restraints ',
     +'are included in the .ins file'/' for standard residues, and ',
     +'extra restraints are added for disulfide bridges'/' and C-term',
     +'inal carboxyl groups.  A summary of the residue and atom names',
     +' is'/' written to the .pro file for subsequent reference.')
   8  FORMAT(/' ** The ''I'' option is intended for initial input of',
     +' a structure to SHELXL,'/' NOT for updating between refinement',
     +' jobs, for which ''U'' should be used. **')
C
   9  IF(OPT.NE.'P')GOTO 11
      WRITE(*,10)
      GOTO 55
  10  FORMAT(' Reads SHELXL .res output file containing accumulated',
     +'R and R(free) values in'/' the form of remarks.  A diagram ',
     +'of the refinement progress is prepared in'/' the form of a ',
     +'Postscript file.  It is important to move the appropriate REM'
     +/' instructions to before HKLF after each SHELXL run !  The ',
     +'automatic water'/' divining (SHELXWAT) is plotted with',
     +' smaller intervals than the full cycles.')
C
  11  IF(OPT.NE.'L')GOTO 13
      WRITE(*,12)
      GOTO 55
  12  FORMAT(' Reads .fcf file created using the LIST 6 instruction',
     +' in SHELXL and outputs a'/' Postscript Luzzati plot [Acta ',
     +'Cryst. 5 (1952) 802-810]. This gives estimates'/' of the ',
     +'average errors in atomic coordinates for an incompletely ',
     +'refined'/' structure assuming perfect data, NOT (as widely ',
     +'assumed by people who have'/' not read this paper which ',
     +'happens to be in French) estimates of the esds'/' in the ',
     +'atomic positions.  For small proteins and high resolution ',
     +'data, esds'/' in individual bond lengths and atomic positions',
     +' may be estimated rigorously'/' using SHELXL (see the E ',
     +'option in SHELXPRO).  Nevertheless, a plot of'/' R-factor ',
     +'against resolution is always entertaining.')
C
  13  IF(OPT.NE.'U')GOTO 15
      WRITE(*,14)
      GOTO 55
  14  FORMAT(' Converts SHELXL .res file to a new .ins file by inc',
     +'luding new or changed atoms'/' from PDB format files such as',
     +' those written by the graphics program "O".  All'/' other',
     +' SHELXL commands are retained unchanged.  This instruction ',
     +'also provides'/' for setting up disorder refinement ',
     +'and updating the list of solvent molecules.'/' The .res file ',
     +'should not contain instructions other than RESI, AFIX, PART ',
     +'and'/' atoms between FVAR AND HKLF, and both FVAR and HKLF ',
     +'must be present. Note that'/' although it is possible to ',
     +'set up threefold or multiple disorders in this way,'/' the ',
     +'necessary SUMP restraints must be edited into the .ins file ',
     +'later by hand.'/' This option may also be used without a .pdb',
     +' file to update .res to .ins and'/' apply various checks.')
C
  15  IF(OPT.NE.'H')GOTO 17
      WRITE(*,16)
      GOTO 55
  16  FORMAT(' Reads a variety of reflection data file formats and ',
     +'writes .hkl file in SHELX'/' HKLF 4 or HKLF 3 format.  The ',
     +'input file should contain one reflection per'/' line, but ',
     +'lines may be stripped from the beginning and end, e.g. to ',
     +'process'/' data transferred by email.  On reading the file, ',
     +'the first line is displayed.'/' To skip this line and move ',
     +'to the next, hit the <Enter> key.  To read h,k,l,'/' F (or ',
     +'F-squared) and sigma(F or F-squared) from this and subsequent',
     +' lines'/' in free format, enter the character * followed',
     +' by <Enter>; to read in fixed'/' format, fill the ',
     +'positions under these quantities with H,K,L,F or S.  Thus to'/
     +' read a correctly formated .hkl file, enter the line:'/
     +' HHHHKKKKLLLLFFFFFFFFSSSSSSSS')
C
  17  IF(OPT.NE.'Y')GOTO 19
      WRITE(*,18)
      GOTO 55
  18  FORMAT(' Reads a reflection file in X-PLOR/CNS format and ',
     +'extracts h,k,l, F, sigma(F)'/' and (if present) the free R ',
     +'flags. These are written to a .hkl file in SHELX'/' HKLF 3 ',
     +'format. It does not matter whether the input file contains',
     +' a header,'/' or how many lines are used per reflection. ',
     +'Although this requires inputting F'/' (HKLF 3) rather than ',
     +'F-squared (HKLF 4) to SHELXL, for macromolecules this is'
     +/' less serious than flagging different reflections for the ',
     +'free R test. SHELXL'/' will convert the F-values to F-squared',
     +' for refinement, but the corresponding'/' sigma(F-squared) ',
     +'values will be degraded compared to the original'/
     +' experimental values.')
C
  19  IF(OPT.NE.'E')GOTO 21
      WRITE(*,20)
      GOTO 55
  20  FORMAT(' Reads SHELXL .lst file and prepares Postscript ',
     +'scatter plots of esds in atom'/' positions and bond lengths',
     +' against (equivalent) B values.  The refinement'/' should ',
     +'normally have been performed with the SHELXL instructions ',
     +'L.S. 1,'/' DAMP 0 0, BLOC 1 and BOND.  If geometrical ',
     +'restraints were used in the'/' refinement the bond length ',
     +'esds will be very low, but high resolution data'/' are ',
     +'required to perform such a refinement without restraints.  ',
     +'Disordered'/' atoms, atoms on special positions, and atoms ',
     +'other than C, N and O are not'/' included in the diagrams.',
     +'  Such atoms are recognized by the first letter of'/' their ',
     +'names in the atom coordinate table, so it may be necessary',
     +' to remove'/' calcium and other atoms that might be mistaken',
     +'ly identified from this table'/' by editing the .lst file ',
     +'before running SHELXPRO.  See the ''T'' option for'/
     +' further ways of displaying esds.')
C
  21  IF(OPT.NE.'T')GOTO 23
      WRITE(*,22)
      GOTO 55
  22  FORMAT(' Reads SHELXL .lst file from an isotropic or anisotrop',
     +'ic refinement and'/' prepares Postscript displays of mean (eq',
     +'uivalent) B and (optionally)'/' anisotropy (minimum eigenvalu',
     +'e divided by maximum eigenvalue) or mean atomic'/' positional',
     +' esd against residue number.  The refinement should have been'/
     +' performed with FMAP 2, so that the residue diagnostics table',
     +' is present'/' in the .lst file.  For the esd plots it must ',
     +'have been performed with L.S. 1'/' and BLOC 0 0 and with ',
     +'restraints removed.  Unless black and white Postscript'/
     +' output is set, the main-chain plots are color-coded according',
     +' to secondary'/' structure (which must be defined by the user)',
     +' and the side-chain plots by'/' residue type.  The color',
     +' schemes are defined in the .pro output file.')
C
  23  IF(OPT.NE.'Z')GOTO 25
      WRITE(*,24)
      GOTO 55
  24  FORMAT(' Reads PDB format files and performs least-squares fits',
     +' by the Quaternion'/' method.  The rms deviations may be ',
     +'plotted as a function of residue number.'/' The current struct',
     +'ure is read first, followed by one or more models that are'/
     +' to be fitted.  The PDB files may be SHELXL output or ',
     +'from other sources.'/' For disordered components only the ',
     +'one with an alternative position flag of'/' "A" (PART 1) is ',
     +'used.  The fitted coordinates may be output to a PDB file,'/
     +' and a file may be generated to display the fit using the ',
     +'SHELXTL program XP.')
C
  25  IF(OPT.NE.'N')GOTO 27
      WRITE(*,26)
      GOTO 55
  26  FORMAT(' Reads SHELXL .lst file and prepares diagrams for ',
     +'analysis of non-crystallo-'/' graphic symmetry. The .lst ',
     +'file should contain RTAB values for the torsions'/
     +' phi, psi, omega, chi1..4.  Differences (2 components) and ',
     +'maximum and rms'/' deviations (more than 2) are plotted ',
     +'and tabulated as a function of base'/' residue number.  ',
     +'The program treats angles modulo 360 degrees and allows for'/
     +' equivalent positions of chi3 for Glu and Chi2 for Phe,',
     +' Tyr and Asp rotated'/' through 180 degrees.  If disorder ',
     +'has been modeled, only the PART 0 and'/' PART 1 atoms',
     +' are considered.  The refinement should have been performed'/
     +' with FMAP 2, so that the residue diagnostics table is pres',
     +'ent in the .lst'/' file.  Unless black and white Postscript',
     +' output is set, the main-chain plots'/' are color coded ',
     +'according to secondary structure (which must be defined by'/
     +' the user) and the side-chain plots by residue type.  ',
     +'The color schemes are'/' defined in the .pro output file.')
C
  27  IF(OPT.NE.'R')GOTO 29
      WRITE(*,28)
      GOTO 55
  28  FORMAT(' Reads SHELXL .lst file and extracts the psi and phi ',
     +'torsion angles to make'/' Ramachandran plots.  If the main-',
     +'chain is disordered, only the PART 1 (and'/' of course PART 0)',
     +' atoms are used.  Glycines are included optionally as'/
     +' open squares.  A list of outliers appears on the screen and ',
     +'in the .pro'/' file. Residues are color-coded unless ',
     +'black and white Postscript has been'/' specified (option C in ',
     +'the main menu).  The refinement should have been'/
     +' performed with appropriate RTAB instructions for the',
     +' Phi and Psi torsion'/' angles and with FMAP 2, so that the',
     +' residue diagnostics table is present in'/' the .lst file.  ',
     +'See G.J.Kleywegt & T.A.Jones, Structure 4 (1996) 1395-1400.')
C
  29  IF(OPT.NE.'K')GOTO 32
      WRITE(*,30)
      WRITE(*,31)
      GOTO 55
  30  FORMAT(' Reads SHELXL .lst file and extracts the psi and phi ',
     +'torsion angles to make'/'multiple-model Ramachandran plots. ',
     +' These were introduced for the analysis'/' of non-crystallog',
     +'raphic symmetry (NCS) by G.J. Kleywegt, Acta Cryst. D52'/
     +' (1996) 842-857.  They give a striking picture of how well',
     +' NCS is obeyed by'/' main-chain atoms and also a good',
     +' indication of the quality of the structure'/' determination.',
     +'  The Phi/Psi point for each residue in each monomer is joined'
     +/' by straight lines to the Phi/Psi points for all equivalent ',
     +'residues in other'/' monomers.  These lines may cross the ',
     +'edges of the diagram and reappear else-'/' where!  If the main',
     +'-chain is disordered, only PART 1 (and PART 0) atoms')
  31  FORMAT(' are used.  Glycines are included optionally in the',
     +' plots as open squares.'/' Residues are color-coded ',
     +'unless black and white Postscript was specified'/
     +' (option C in the main menu).  The refinement should have ',
     +'been performed with'/' appropriate RTAB instructions ',
     +'for the Phi and Psi torsion angles and with'/' FMAP 2, so that',
     +' the residue diagnostics table is present in the .lst file.'/
     +' See G.J.Kleywegt & T.A.Jones, Structure 4 (1996) 1395-1400 ',
     +'for core regions.')
C
  32  IF(OPT.NE.'M')GOTO 34
      WRITE(*,33)
      GOTO 55
  33  FORMAT(' Reads .fcf file created by LIST 6 in SHELXL and ',
     +'generates a .map file for O;'/' a .pdb file (e.g. from WPDB',
     +' in SHELXL) may be scanned to derive the region of'/' space',
     +' that will cover the protein. In this case the program',
     +' is able to suggest'/' default values for all parameters.',
     +'  The map is scaled in units of sigma.')
C
  34  IF(OPT.NE.'W')GOTO 36
      WRITE(*,35)
      GOTO 55
  35  FORMAT(' Reads .fcf file created by LIST 6 in SHELXL and ',
     +'generates a .map file for'/' Turbo-Frodo; a .pdb file (e.g.',
     +' from WPDB in SHELXL) may be scanned to derive'/' the region',
     +' of space that will cover the protein. In this case the ',
     +'program'/' is able to suggest default values for all paramet',
     +'eters.  The map is scaled'/' in units of sigma.')
C
  36  IF(OPT.NE.'X')GOTO 38
      WRITE(*,37)
      GOTO 55
  37  FORMAT(' Reads .fcf file created by LIST 6 in SHELXL and ',
     +'generates a .phs file for '/' calculating a Sigma-a map ',
     +'using the program XTALVIEW.  Each line of this'/' file ',
     +'contains h, k, l, Sigma-a coefficient disguised as Fo, ',
     +'fom (always 1.0)'/' and phase angle in degrees (all in free',
     +' format).')
C
  38  IF(OPT.NE.'O')GOTO 40
      WRITE(*,39)
      GOTO 55
  39  FORMAT(' The otherwise exemplary program "O" is unfortunately',
     +' not able to understand'/' absolutely Brookhaven standard ',
     +'PDB files when disordered residues are present.'/' It is ',
     +'therefore necessary to modify PDB files created by SHELXL ',
     +'(and also'/' those from the data bank itself) by splitting ',
     +'disordered residues into two'/' (or more) residues of the ',
     +'same type but with different residue numbers.  Each'/' new ',
     +'residue contains a copy of the non-disordered atoms plus ',
     +'one disorder'/' component.  The program tries to find a ',
     +'single residue number "offset" that'/' can be used for all ',
     +'disordered residues, but provides for manual intervention'/
     +' if necessary.  It should not be necessary to change the ',
     +'O connectivity file'/' (usually called "all.dat").')
C
  40  IF(OPT.NE.'D')GOTO 42
      WRITE(*,41)
      GOTO 55
  41  FORMAT(' Reads DENZO/SCALEPACK .sca file created with or ',
     +'without the "anomalous"'/' option and writes SHELX .hkl ',
     +'file for input to SHELXS or SHELXL with HKLF 4.'/' If the ',
     +'.sca file was created with the "anomalous" option, an ',
     +'anomalous'/' delta-F file may be created for heavy-atom ',
     +'location with SHELXS.')
C
  42  IF(OPT.NE.'C')GOTO 44
      WRITE(*,43)
      GOTO 55
  43  FORMAT(' Toggles subsequent Postscript plot output between ',
     +'colored and black and'/' white. The current state is shown ',
     +'in the main menu. Mixed colored and black'/' and white .ps ',
     +'files are permitted.')
C
  44  IF(OPT.NE.'S')GOTO 46
      WRITE(*,45)
      GOTO 55
  45  FORMAT(' Reads file name.fcf and creates table of completeness',
     +' and residuals as a'/' function of resolution.  The ',
     +'resolution ranges have to be specified, and'/' may be chosen ',
     +'to match those used by data reduction programs etc.')
C
  46  IF(OPT.NE.'B')GOTO 49
      WRITE(*,47)
      WRITE(*,48)
      GOTO 55
  47  FORMAT(' Reads files name.pdb and name.lst written by final',
     +' SHELXL refinement job and'/' creates a file name.ent in PDB',
     +' format suitable for deposition in Brookhaven.'/' Some of this',
     +' file is in the form of a template suitable for hand editing, '/
     +' e.g. to include literature reference, experimental details,',
     +' special features'/' of the refinement, connectivity etc.',
     +' The input PDB file is assumed to have'/' been created by the',
     +' same SHELXL job as the .lst file, and may NOT contain')
  48  FORMAT(' chain identifiers; these may be generated by this util',
     +'ity. The various R'/' factors required for the deposition shou',
     +'ld be extracted correctly if the'/' structure has been refined',
     +' using R free and the final refinement has been'/' performed',
     +' against all data.  The free R factors are extracted from the',
     +' REM'/' records that are retained when updating .res to .ins',
     +' with the ''U'' option.')
C
  49  IF(OPT.NE.'G')GOTO 51
      WRITE(*,50)
      GOTO 55
  50  FORMAT(' Reads a .ins, .res or .pdb format file and generates',
     +' a new PDB format file.'/' This file may be used for input to',
     +' standard protein programs such as AMoRe,'/' or re-read by ',
     +'SHELXPRO for least-squares fitting.  B-values may be reset to'/
     +' typical values, disorder, solvent and H-atoms removed, chain',
     +' IDs created,'/' and multiple copies of chains generated by ',
     +'(non-)crystallographic symmetry.'/' In the new PDB file all ',
     +'atoms are isotropic.')
C
  51  IF(OPT.NE.'J')GOTO 53
      WRITE(*,52)
      GOTO 55
  52  FORMAT(' Reads a .ins, .res, PDB or Cambridge Data Base .dat ',
     +'format file and generates'/' DFIX and DANG restraints for use',
     +' by SHELXL. An orthogonal fragment may be set'/' up for least',
     +'-squares fitting in SHELXL prior to refinement; this fragment',
     +' may'/' be plotted using the XP program in the Bruker SHELXTL',
     +' system (CELL 1, then'/' READ ..., FMOL, MPLN and TELP etc.).',
     +' All the restraints generated from the'/' model apply to the',
     +' same residue type; it may be necessary to add FLAT and'/
     +' CHIV restraints by hand. The atom names should be the same ',
     +'in the model file'/' and in the structure to be refined. Note',
     +' that where the input is from a CSD'/' file, atom names ',
     +'beginning with ''H'' will be interpreted as hydrogen and hence'
     +/' ignored. DANG instructions may be duplicated for 1,3-dist',
     +'ances across'/' four-membered rings, but this is harmless.')
C
  53  IF(OPT.NE.'Q')GOTO 56
      WRITE(*,54)
      GOTO 55
  54  FORMAT(' Terminates SHELXPRO and returns to operating system ',
     +'prompt.')
C
  55  WRITE(*,'(1X)')
      WRITE(*,FMT)' Enter N to abort option, <Enter> to continue: '
      KR=' '
      READ(*,'(A)',ERR=55,END=55)KR
      IER=-1
      IF(INDEX(KR,'N').NE.0)GOTO 57
      IF(INDEX(KR,'n').NE.0)GOTO 57
      IER=0
      GOTO 57
  56  WRITE(*,'(/A/)')' ** Option "'//OPT//'" unknown **'
      IER=1
  57  RETURN
      END
C
C -------------------------------------------------------------------
C
      SUBROUTINE PROLOG
C
C Output Postscript prolog
C
      COMMON/XTAL/SY(12,192),CELL(15),II(1369),NS,LAT,LU,LN,
     +LO,LP,LF,LM,LS,NOS,IER,NPG
      COMMON/WORD/KF,KR,KD,KE,KA,KB,KN,FMT,COL,OPT
      CHARACTER KF*80,KR*80,KD(462)*52,KA(50000)*4,KE(9999)*4,
     +KB(250)*80,KN(10000)*9,FMT*20,COL*4,OPT*1
C
C Output prolog to .ps file
C
   1  FORMAT(A)
      WRITE(LP,1)'%!PS-Adobe-3.0'
      WRITE(LP,1)'%%Title: '//KF(1:LN)
      WRITE(LP,1)'%%Creator: George Sheldrick'
      WRITE(LP,1)'%%DocumentNeededResources: font Times-Roman Symbol'
      WRITE(LP,1)'%%BoundingBox: 10 10 590 780'
      WRITE(LP,1)'%%Pages: (atend)'
      WRITE(LP,1)'%%EndComments'
      WRITE(LP,1)'%%BeginProlog'
      WRITE(LP,1)'/W { setlinewidth } bind def'
      WRITE(LP,1)'/L { newpath moveto lineto stroke } bind def'
      WRITE(LP,1)'/D { newpath 1.5 0 360 arc fill } bind def'
      WRITE(LP,1)'/E { newpath 3.0 0 360 arc fill } bind def'
      WRITE(LP,1)'/B { 4 copy 4 2 roll exch 6 -1 roll exch 6 1 roll'
     +//' exch'
      WRITE(LP,1)'     newpath moveto lineto lineto lineto closepath'
     +//' gsave'
      WRITE(LP,1)'     0 setgray stroke grestore fill } bind def'
      WRITE(LP,1)'/H { 4 copy 4 2 roll exch 6 -1 roll exch 6 1 roll'
     +//' exch newpath'
      WRITE(LP,1)'     moveto lineto lineto lineto closepath'
     +//' fill } bind def'
      WRITE(LP,1)'/P { moveto 2 copy /Times-Roman findfont exch'
     +//' scalefont setfont'
      WRITE(LP,1)'     stringwidth pop -2 div exch -3 div rmoveto'
     +//' show } bind def'
      WRITE(LP,1)'/Q { moveto 2 copy /Times-Roman findfont exch'
     +//' scalefont setfont'
      WRITE(LP,1)'     stringwidth pop -2 div exch 3 div exch'
     +//' rmoveto gsave'
      WRITE(LP,1)'     currentpoint translate 90 rotate show'
     +//' grestore } bind def'
      WRITE(LP,1)'/C0 { 0 setgray } bind def'
      WRITE(LP,1)'/C1 { 0.0 1.0 0.0 setrgbcolor } bind def'
      WRITE(LP,1)'/C2 { 1.0 0.0 0.0 setrgbcolor } bind def'
      WRITE(LP,1)'/C3 { 0.0 0.0 1.0 setrgbcolor } bind def'
      WRITE(LP,1)'/C4 { 1.0 0.8 0.0 setrgbcolor } bind def'
      WRITE(LP,1)'/C5 { 1.0 0.0 1.0 setrgbcolor } bind def'
      WRITE(LP,1)'/C6 { 0.0 1.0 1.0 setrgbcolor } bind def'
      WRITE(LP,1)'/C7 { 1.0 setgray } bind def'
      WRITE(LP,1)'/C8 { 0.5 setgray } bind def'
      WRITE(LP,1)'/C9 { 0.0 0.5 1.0 setrgbcolor } bind def'
      WRITE(LP,1)'%%EndProlog'
      WRITE(LP,1)'%%BeginSetup'
      WRITE(LP,1)' 1 setlinecap 1 setlinejoin 1 setlinewidth 0'
      WRITE(LP,1)' setgray [ ] 0 setdash newpath'
      WRITE(LP,1)'%%EndSetup'
      RETURN
      END
C
C -------------------------------------------------------------------
C
      SUBROUTINE RAMDAT
C
C Data from G.J. Kleywegt & T.A. Jones, Structure 4 (1996) 1395-1400
C for Ramachandran plots.  The plot is divided up into a 37x37 grid of
C 10 degree boxes (columns 1 and 37 and rows 1 and 37 are identical)
C and the frequency of each phi/psi combination in each box is given
C in the following DATA statements.  When new data become available,
C only this table needs to be altered - the program works out the
C threshold for contouring the core region etc.
C
      COMMON/XTAL/SY(12,192),CELL(15),II(1369),NS,LAT,LU,LN,
     +LO,LP,LF,LM,LS,NOS,IER,NPG
      INTEGER IU(1369)
      DATA IU(1)/16/,IU(2)/45/,IU(3)/64/,IU(4)/51/,IU(5)/40/,IU(6)/
     +39/,IU(7)/32/,IU(8)/38/,IU(9)/43/,IU(10)/63/,IU(11)/35/,IU(12)/
     +4/,IU(13)/0/,IU(14)/0/,IU(15)/0/,IU(16)/0/,IU(17)/0/,IU(18)/0/,
     +IU(19)/0/,IU(20)/0/,IU(21)/1/,IU(22)/0/,IU(23)/1/,IU(24)/1/,
     +IU(25)/2/,IU(26)/2/,IU(27)/0/,IU(28)/0/,IU(29)/0/,IU(30)/0/,
     +IU(31)/0/,IU(32)/0/,IU(33)/0/,IU(34)/0/,IU(35)/1/,IU(36)/0/,IU
     +(37)/16/,IU(38)/1/,IU(39)/10/,IU(40)/23/,IU(41)/25/,IU(42)/18/,
     +IU(43)/16/,IU(44)/12/,IU(45)/15/,IU(46)/19/,IU(47)/21/,IU(48)/7/
      DATA IU(49)/0/,IU(50)/0/,IU(51)/0/,IU(52)/0/,IU(53)/0/,IU(54)/
     +0/,IU(55)/0/,IU(56)/0/,IU(57)/0/,IU(58)/0/,IU(59)/0/,IU(60)/0/,
     +IU(61)/1/,IU(62)/4/,IU(63)/0/,IU(64)/0/,IU(65)/1/,IU(66)/0/,
     +IU(67)/0/,IU(68)/0/,IU(69)/0/,IU(70)/0/,IU(71)/0/,IU(72)/0/,
     +IU(73)/0/,IU(74)/1/,IU(75)/0/,IU(76)/1/,IU(77)/7/,IU(78)/5/,
     +IU(79)/2/,IU(80)/7/,IU(81)/3/,IU(82)/5/,IU(83)/3/,IU(84)/3/,
     +IU(85)/4/,IU(86)/1/,IU(87)/1/,IU(88)/0/,IU(89)/0/,IU(90)/0/,
     +IU(91)/0/,IU(92)/0/,IU(93)/0/,IU(94)/0/,IU(95)/0/,IU(96)/0/
      DATA IU(97)/1/,IU(98)/3/,IU(99)/3/,IU(100)/1/,IU(101)/0/,IU
     +(102)/0/,IU(103)/0/,IU(104)/0/,IU(105)/0/,IU(106)/0/,IU(107)/
     +0/,IU(108)/1/,IU(109)/0/,IU(110)/0/,IU(111)/0/,IU(112)/1/,IU
     +(113)/5/,IU(114)/2/,IU(115)/1/,IU(116)/3/,IU(117)/3/,IU(118)/4/,
     +IU(119)/4/,IU(120)/3/,IU(121)/1/,IU(122)/0/,IU(123)/1/,IU(124)/
     +0/,IU(125)/0/,IU(126)/0/,IU(127)/0/,IU(128)/0/,IU(129)/0/,IU
     +(130)/0/,IU(131)/0/,IU(132)/0/,IU(133)/0/,IU(134)/1/,IU(135)/
     +11/,IU(136)/2/,IU(137)/0/,IU(138)/0/,IU(139)/0/,IU(140)/0/
      DATA IU(141)/0/,IU(142)/0/,IU(143)/0/,IU(144)/0/,IU(145)/0/,
     +IU(146)/0/,IU(147)/0/,IU(148)/1/,IU(149)/1/,IU(150)/1/,IU(151)/
     +2/,IU(152)/0/,IU(153)/1/,IU(154)/2/,IU(155)/8/,IU(156)/2/,IU
     +(157)/5/,IU(158)/0/,IU(159)/1/,IU(160)/0/,IU(161)/0/,IU(162)/
     +0/,IU(163)/0/,IU(164)/0/,IU(165)/0/,IU(166)/0/,IU(167)/0/,IU
     +(168)/0/,IU(169)/0/,IU(170)/0/,IU(171)/3/,IU(172)/9/,IU(173)/0/,
     +IU(174)/0/,IU(175)/0/,IU(176)/0/,IU(177)/0/,IU(178)/0/
      DATA IU(179)/0/,IU(180)/0/,IU(181)/0/,IU(182)/0/,IU(183)/0/,
     +IU(184)/0/,IU(185)/1/,IU(186)/0/,IU(187)/0/,IU(188)/2/,IU(189)/
     +0/,IU(190)/3/,IU(191)/2/,IU(192)/5/,IU(193)/8/,IU(194)/1/,IU
     +(195)/0/,IU(196)/0/,IU(197)/1/,IU(198)/0/,IU(199)/0/,IU(200)/0/,
     +IU(201)/0/,IU(202)/0/,IU(203)/0/,IU(204)/0/,IU(205)/0/,IU(206)/
     +0/,IU(207)/1/,IU(208)/6/,IU(209)/11/,IU(210)/6/,IU(211)/1/,
     +IU(212)/0/,IU(213)/0/,IU(214)/0/,IU(215)/0/,IU(216)/0/
      DATA IU(217)/0/,IU(218)/1/,IU(219)/0/,IU(220)/0/,IU(221)/
     +0/,IU(222)/0/,IU(223)/0/,IU(224)/0/,IU(225)/0/,IU(226)/0/,
     +IU(227)/1/,IU(228)/1/,IU(229)/3/,IU(230)/4/,IU(231)/2/,IU(232)/
     +0/,IU(233)/0/,IU(234)/0/,IU(235)/1/,IU(236)/0/,IU(237)/1/,IU
     +(238)/0/,IU(239)/0/,IU(240)/0/,IU(241)/1/,IU(242)/0/,IU(243)/0/,
     +IU(244)/1/,IU(245)/4/,IU(246)/7/,IU(247)/2/,IU(248)/0/,IU(249)/
     +0/,IU(250)/0/,IU(251)/0/,IU(252)/0/,IU(253)/0/,IU(254)/0/,IU
     +(255)/0/,IU(256)/0/,IU(257)/0/,IU(258)/0/,IU(259)/0/,IU(260)/0/
      DATA IU(261)/0/,IU(262)/0/,IU(263)/1/,IU(264)/1/,IU(265)/1/,IU
     +(266)/3/,IU(267)/1/,IU(268)/1/,IU(269)/0/,IU(270)/0/,IU(271)/0/,
     +IU(272)/1/,IU(273)/0/,IU(274)/1/,IU(275)/0/,IU(276)/0/,IU(277)/
     +0/,IU(278)/0/,IU(279)/2/,IU(280)/2/,IU(281)/0/,IU(282)/2/,IU
     +(283)/4/,IU(284)/2/,IU(285)/1/,IU(286)/0/,IU(287)/1/,IU(288)/0/,
     +IU(289)/0/,IU(290)/0/,IU(291)/0/,IU(292)/0/,IU(293)/0/,IU(294)/
     +0/,IU(295)/0/,IU(296)/0/,IU(297)/0/,IU(298)/2/,IU(299)/0/,IU
     +(300)/2/,IU(301)/4/,IU(302)/2/,IU(303)/6/,IU(304)/5/,IU(305)/2/
      DATA IU(306)/0/,IU(307)/0/,IU(308)/1/,IU(309)/1/,IU(310)/0/,IU
     +(311)/1/,IU(312)/0/,IU(313)/1/,IU(314)/0/,IU(315)/0/,IU(316)/0/,
     +IU(317)/1/,IU(318)/1/,IU(319)/1/,IU(320)/2/,IU(321)/2/,IU(322)/
     +0/,IU(323)/0/,IU(324)/0/,IU(325)/0/,IU(326)/0/,IU(327)/0/,IU
     +(328)/0/,IU(329)/0/,IU(330)/0/,IU(331)/0/,IU(332)/1/,IU(333)/0/,
     +IU(334)/1/,IU(335)/0/,IU(336)/0/,IU(337)/0/,IU(338)/1/,IU(339)/
     +7/,IU(340)/5/,IU(341)/2/,IU(342)/2/,IU(343)/4/,IU(344)/1/
      DATA IU(345)/2/,IU(346)/0/,IU(347)/3/,IU(348)/2/,IU(349)/0/,IU
     +(350)/2/,IU(351)/1/,IU(352)/1/,IU(353)/2/,IU(354)/0/,IU(355)/0/,
     +IU(356)/0/,IU(357)/0/,IU(358)/0/,IU(359)/0/,IU(360)/0/,IU(361)/
     +0/,IU(362)/0/,IU(363)/0/,IU(364)/0/,IU(365)/0/,IU(366)/0/,IU
     +(367)/0/,IU(368)/0/,IU(369)/2/,IU(370)/1/,IU(371)/0/,IU(372)/0/,
     +IU(373)/4/,IU(374)/2/,IU(375)/5/,IU(376)/5/,IU(377)/7/,IU(378)/
     +6/,IU(379)/7/,IU(380)/9/,IU(381)/6/,IU(382)/4/,IU(383)/4/
      DATA IU(384)/5/,IU(385)/7/,IU(386)/1/,IU(387)/2/,IU(388)/0/,IU
     +(389)/0/,IU(390)/1/,IU(391)/0/,IU(392)/0/,IU(393)/0/,IU(394)/0/,
     +IU(395)/0/,IU(396)/3/,IU(397)/0/,IU(398)/0/,IU(399)/0/,IU(400)/
     +0/,IU(401)/0/,IU(402)/0/,IU(403)/0/,IU(404)/1/,IU(405)/0/,IU
     +(406)/0/,IU(407)/0/,IU(408)/0/,IU(409)/0/,IU(410)/5/,IU(411)/
     +4/,IU(412)/5/,IU(413)/13/,IU(414)/22/,IU(415)/12/,IU(416)/16/
      DATA IU(417)/22/,IU(418)/30/,IU(419)/49/,IU(420)/52/,IU(421)/
     +31/,IU(422)/18/,IU(423)/7/,IU(424)/2/,IU(425)/0/,IU(426)/0/,
     +IU(427)/0/,IU(428)/0/,IU(429)/0/,IU(430)/0/,IU(431)/0/,IU(432)/
     +0/,IU(433)/6/,IU(434)/1/,IU(435)/0/,IU(436)/0/,IU(437)/0/,
     +IU(438)/1/,IU(439)/1/,IU(440)/0/,IU(441)/1/,IU(442)/0/,IU(443)/
     +0/,IU(444)/0/,IU(445)/1/,IU(446)/1/,IU(447)/1/,IU(448)/4/,IU
     +(449)/10/,IU(450)/13/,IU(451)/38/,IU(452)/34/,IU(453)/49/,IU
     +(454)/72/,IU(455)/160/,IU(456)/709/,IU(457)/1013/,IU(458)/205/
      DATA IU(459)/45/,IU(460)/1/,IU(461)/2/,IU(462)/0/,IU(463)/1/,
     +IU(464)/0/,IU(465)/1/,IU(466)/0/,IU(467)/0/,IU(468)/0/,IU(469)/
     +4/,IU(470)/7/,IU(471)/1/,IU(472)/1/,IU(473)/1/,IU(474)/0/,IU
     +(475)/0/,IU(476)/0/,IU(477)/0/,IU(478)/0/,IU(479)/1/,IU(480)/0/,
     +IU(481)/1/,IU(482)/0/,IU(483)/0/,IU(484)/0/,IU(485)/1/,IU(486)/
     +10/,IU(487)/22/,IU(488)/42/,IU(489)/67/,IU(490)/101/,IU(491)/
     +229/,IU(492)/1035/,IU(493)/6328/,IU(494)/3530/,IU(495)/357/,
     +IU(496)/18/,IU(497)/6/,IU(498)/2/,IU(499)/0/,IU(500)/0/
      DATA IU(501)/1/,IU(502)/0/,IU(503)/1/,IU(504)/0/,IU(505)/0/,
     +IU(506)/6/,IU(507)/2/,IU(508)/2/,IU(509)/1/,IU(510)/0/,IU(511)/
     +2/,IU(512)/0/,IU(513)/1/,IU(514)/2/,IU(515)/0/,IU(516)/0/,IU
     +(517)/1/,IU(518)/0/,IU(519)/0/,IU(520)/0/,IU(521)/1/,IU(522)/
     +3/,IU(523)/8/,IU(524)/25/,IU(525)/51/,IU(526)/91/,IU(527)/172/,
     +IU(528)/309/,IU(529)/1589/,IU(530)/4895/,IU(531)/1978/,IU(532)/
     +146/,IU(533)/10/,IU(534)/1/,IU(535)/0/,IU(536)/0/,IU(537)/0/,IU
     +(538)/0/,IU(539)/0/,IU(540)/0/,IU(541)/0/,IU(542)/1/,IU(543)/7/
      DATA IU(544)/5/,IU(545)/1/,IU(546)/0/,IU(547)/1/,IU(548)/0/,
     +IU(549)/0/,IU(550)/1/,IU(551)/1/,IU(552)/1/,IU(553)/0/,IU(554)/
     +1/,IU(555)/0/,IU(556)/1/,IU(557)/0/,IU(558)/2/,IU(559)/4/,IU
     +(560)/19/,IU(561)/46/,IU(562)/97/,IU(563)/125/,IU(564)/199/,
     +IU(565)/387/,IU(566)/966/,IU(567)/1888/,IU(568)/714/,IU(569)/
     +29/,IU(570)/1/,IU(571)/1/,IU(572)/0/,IU(573)/0/,IU(574)/0/,IU
     +(575)/0/,IU(576)/0/,IU(577)/0/,IU(578)/0/,IU(579)/1/,IU(580)/2/,
     +IU(581)/2/,IU(582)/1/,IU(583)/0/,IU(584)/0/,IU(585)/1/
      DATA IU(586)/0/,IU(587)/0/,IU(588)/1/,IU(589)/0/,IU(590)/0/,
     +IU(591)/0/,IU(592)/1/,IU(593)/0/,IU(594)/0/,IU(595)/2/,IU(596)/
     +7/,IU(597)/23/,IU(598)/78/,IU(599)/145/,IU(600)/180/,IU(601)/
     +298/,IU(602)/521/,IU(603)/872/,IU(604)/873/,IU(605)/140/,
     +IU(606)/9/,IU(607)/0/,IU(608)/0/,IU(609)/0/,IU(610)/0/,IU(611)/
     +0/,IU(612)/0/,IU(613)/0/,IU(614)/0/,IU(615)/0/,IU(616)/1/,
     +IU(617)/0/,IU(618)/2/,IU(619)/3/,IU(620)/1/,IU(621)/1/,IU(622)/
     +0/,IU(623)/0/,IU(624)/1/,IU(625)/1/,IU(626)/0/,IU(627)/0/
      DATA IU(628)/0/,IU(629)/0/,IU(630)/1/,IU(631)/0/,IU(632)/1/,
     +IU(633)/9/,IU(634)/25/,IU(635)/93/,IU(636)/127/,IU(637)/251/,
     +IU(638)/438/,IU(639)/625/,IU(640)/517/,IU(641)/172/,IU(642)/16/,
     +IU(643)/1/,IU(644)/0/,IU(645)/0/,IU(646)/0/,IU(647)/0/,IU(648)/
     +0/,IU(649)/0/,IU(650)/0/,IU(651)/0/,IU(652)/0/,IU(653)/2/,IU
     +(654)/4/,IU(655)/11/,IU(656)/6/,IU(657)/3/,IU(658)/0/,IU(659)/
     +0/,IU(660)/0/,IU(661)/1/,IU(662)/0/,IU(663)/0/,IU(664)/0/,IU
     +(665)/0/,IU(666)/1/,IU(667)/0/,IU(668)/0/,IU(669)/3/,IU(670)/17/
      DATA IU(671)/38/,IU(672)/117/,IU(673)/167/,IU(674)/379/,IU(675)/
     +456/,IU(676)/374/,IU(677)/124/,IU(678)/12/,IU(679)/4/,IU(680)/
     +0/,IU(681)/0/,IU(682)/0/,IU(683)/0/,IU(684)/0/,IU(685)/0/,
     +IU(686)/0/,IU(687)/0/,IU(688)/0/,IU(689)/0/,IU(690)/3/,IU(691)/
     +24/,IU(692)/31/,IU(693)/6/,IU(694)/0/,IU(695)/0/,IU(696)/0/,
     +IU(697)/0/,IU(698)/0/,IU(699)/0/,IU(700)/0/,IU(701)/0/,IU(702)/
     +0/,IU(703)/0/,IU(704)/0/,IU(705)/2/,IU(706)/6/,IU(707)/14/,IU
     +(708)/42/,IU(709)/105/,IU(710)/205/,IU(711)/282/,IU(712)/247/
      DATA IU(713)/96/,IU(714)/20/,IU(715)/3/,IU(716)/1/,IU(717)/0/,
     +IU(718)/0/,IU(719)/0/,IU(720)/0/,IU(721)/0/,IU(722)/0/,IU(723)/
     +0/,IU(724)/0/,IU(725)/0/,IU(726)/0/,IU(727)/16/,IU(728)/76/,IU
     +(729)/40/,IU(730)/4/,IU(731)/0/,IU(732)/0/,IU(733)/0/,IU(734)/
     +0/,IU(735)/0/,IU(736)/0/,IU(737)/0/,IU(738)/0/,IU(739)/0/,IU
     +(740)/0/,IU(741)/0/,IU(742)/0/,IU(743)/4/,IU(744)/12/,IU(745)/
     +32/,IU(746)/78/,IU(747)/143/,IU(748)/133/,IU(749)/62/,IU(750)/
     +18/,IU(751)/11/,IU(752)/1/,IU(753)/2/,IU(754)/0/,IU(755)/0/
      DATA IU(756)/0/,IU(757)/0/,IU(758)/0/,IU(759)/0/,IU(760)/0/,
     +IU(761)/0/,IU(762)/0/,IU(763)/6/,IU(764)/89/,IU(765)/109/,
     +IU(766)/19/,IU(767)/3/,IU(768)/1/,IU(769)/0/,IU(770)/0/,IU(771)/
     +0/,IU(772)/0/,IU(773)/0/,IU(774)/0/,IU(775)/0/,IU(776)/1/,IU
     +(777)/0/,IU(778)/0/,IU(779)/1/,IU(780)/4/,IU(781)/14/,IU(782)/
     +30/,IU(783)/56/,IU(784)/59/,IU(785)/30/,IU(786)/15/,IU(787)/13/,
     +IU(788)/2/,IU(789)/1/,IU(790)/0/,IU(791)/0/,IU(792)/0/,IU(793)/
     +0/,IU(794)/0/,IU(795)/0/,IU(796)/0/,IU(797)/0/,IU(798)/0/
      DATA IU(799)/2/,IU(800)/31/,IU(801)/206/,IU(802)/129/,IU(803)/
     +10/,IU(804)/1/,IU(805)/0/,IU(806)/0/,IU(807)/0/,IU(808)/0/,IU
     +(809)/0/,IU(810)/0/,IU(811)/0/,IU(812)/0/,IU(813)/0/,IU(814)/0/,
     +IU(815)/0/,IU(816)/1/,IU(817)/1/,IU(818)/13/,IU(819)/18/,
     +IU(820)/30/,IU(821)/27/,IU(822)/14/,IU(823)/13/,IU(824)/13/,
     +IU(825)/7/,IU(826)/3/,IU(827)/1/,IU(828)/0/,IU(829)/0/,IU(830)/
     +1/,IU(831)/0/,IU(832)/0/,IU(833)/0/,IU(834)/1/,IU(835)/0/,
     +IU(836)/7/,IU(837)/111/,IU(838)/263/,IU(839)/74/,IU(840)/2/
      DATA IU(841)/3/,IU(842)/1/,IU(843)/0/,IU(844)/0/,IU(845)/0/,
     +IU(846)/0/,IU(847)/0/,IU(848)/0/,IU(849)/0/,IU(850)/0/,IU(851)/
     +0/,IU(852)/0/,IU(853)/0/,IU(854)/5/,IU(855)/12/,IU(856)/28/,IU
     +(857)/25/,IU(858)/7/,IU(859)/9/,IU(860)/13/,IU(861)/40/,IU(862)/
     +21/,IU(863)/3/,IU(864)/2/,IU(865)/0/,IU(866)/0/,IU(867)/0/,IU
     +(868)/0/,IU(869)/0/,IU(870)/0/,IU(871)/0/,IU(872)/1/,IU(873)/
     +10/,IU(874)/84/,IU(875)/103/,IU(876)/17/,IU(877)/0/,IU(878)/3/,
     +IU(879)/0/,IU(880)/0/,IU(881)/0/,IU(882)/0/,IU(883)/0/
      DATA IU(884)/0/,IU(885)/0/,IU(886)/0/,IU(887)/0/,IU(888)/0/,IU
     +(889)/0/,IU(890)/4/,IU(891)/12/,IU(892)/27/,IU(893)/41/,IU(894)/
     +47/,IU(895)/15/,IU(896)/5/,IU(897)/39/,IU(898)/65/,IU(899)/32/,
     +IU(900)/1/,IU(901)/1/,IU(902)/0/,IU(903)/0/,IU(904)/0/,IU(905)/
     +0/,IU(906)/0/,IU(907)/0/,IU(908)/0/,IU(909)/3/,IU(910)/10/,
     +IU(911)/33/,IU(912)/29/,IU(913)/4/,IU(914)/1/,IU(915)/0/,
     +IU(916)/0/,IU(917)/0/,IU(918)/1/,IU(919)/0/,IU(920)/0/,IU(921)/
     +0/,IU(922)/0/,IU(923)/0/,IU(924)/1/,IU(925)/0/,IU(926)/2/
      DATA IU(927)/1/,IU(928)/14/,IU(929)/30/,IU(930)/82/,IU(931)/59/,
     +IU(932)/16/,IU(933)/15/,IU(934)/53/,IU(935)/106/,IU(936)/43/,IU
     +(937)/1/,IU(938)/1/,IU(939)/0/,IU(940)/2/,IU(941)/0/,IU(942)/0/,
     +IU(943)/0/,IU(944)/0/,IU(945)/0/,IU(946)/1/,IU(947)/5/,IU(948)/
     +4/,IU(949)/9/,IU(950)/1/,IU(951)/1/,IU(952)/0/,IU(953)/1/,IU
     +(954)/0/,IU(955)/0/,IU(956)/0/,IU(957)/0/,IU(958)/0/,IU(959)/0/,
     +IU(960)/1/,IU(961)/0/,IU(962)/2/,IU(963)/1/,IU(964)/9/,IU(965)/
     +15/,IU(966)/28/,IU(967)/59/,IU(968)/69/,IU(969)/44/,IU(970)/28/
      DATA IU(971)/57/,IU(972)/104/,IU(973)/46/,IU(974)/4/,IU(975)/0/,
     +IU(976)/0/,IU(977)/0/,IU(978)/2/,IU(979)/0/,IU(980)/0/,IU(981)/
     +0/,IU(982)/0/,IU(983)/1/,IU(984)/2/,IU(985)/3/,IU(986)/1/,IU
     +(987)/2/,IU(988)/1/,IU(989)/0/,IU(990)/0/,IU(991)/1/,IU(992)/0/,
     +IU(993)/0/,IU(994)/0/,IU(995)/0/,IU(996)/0/,IU(997)/0/,IU(998)/
     +0/,IU(999)/1/,IU(1000)/1/,IU(1001)/7/,IU(1002)/19/,IU(1003)/35/,
     +IU(1004)/46/,IU(1005)/82/,IU(1006)/85/,IU(1007)/73/,IU(1008)/
     +100/,IU(1009)/115/,IU(1010)/36/,IU(1011)/10/,IU(1012)/2/
      DATA IU(1013)/1/,IU(1014)/0/,IU(1015)/0/,IU(1016)/1/,IU(1017)/
     +0/,IU(1018)/0/,IU(1019)/1/,IU(1020)/0/,IU(1021)/0/,IU(1022)/1/,
     +IU(1023)/1/,IU(1024)/0/,IU(1025)/1/,IU(1026)/1/,IU(1027)/0/,IU
     +(1028)/0/,IU(1029)/0/,IU(1030)/0/,IU(1031)/0/,IU(1032)/2/,IU
     +(1033)/0/,IU(1034)/0/,IU(1035)/1/,IU(1036)/1/,IU(1037)/3/,IU
     +(1038)/13/,IU(1039)/27/,IU(1040)/58/,IU(1041)/114/,IU(1042)/
     +179/,IU(1043)/237/,IU(1044)/264/,IU(1045)/239/,IU(1046)/180/,
     +IU(1047)/85/,IU(1048)/26/,IU(1049)/5/,IU(1050)/4/,IU(1051)/1/
      DATA IU(1052)/1/,IU(1053)/0/,IU(1054)/0/,IU(1055)/0/,IU(1056)/
     +0/,IU(1057)/0/,IU(1058)/0/,IU(1059)/0/,IU(1060)/0/,IU(1061)/2/,
     +IU(1062)/4/,IU(1063)/1/,IU(1064)/1/,IU(1065)/0/,IU(1066)/1/,
     +IU(1067)/0/,IU(1068)/0/,IU(1069)/0/,IU(1070)/1/,IU(1071)/0/,
     +IU(1072)/0/,IU(1073)/3/,IU(1074)/3/,IU(1075)/15/,IU(1076)/27/,
     +IU(1077)/101/,IU(1078)/219/,IU(1079)/360/,IU(1080)/458/,
     +IU(1081)/528/,IU(1082)/443/,IU(1083)/331/,IU(1084)/206/,
     +IU(1085)/120/,IU(1086)/58/,IU(1087)/22/,IU(1088)/7/,IU(1089)/0/
      DATA IU(1090)/0/,IU(1091)/0/,IU(1092)/1/,IU(1093)/0/,IU(1094)/
     +0/,IU(1095)/0/,IU(1096)/0/,IU(1097)/1/,IU(1098)/1/,IU(1099)/0/,
     +IU(1100)/2/,IU(1101)/1/,IU(1102)/1/,IU(1103)/0/,IU(1104)/0/,IU
     +(1105)/0/,IU(1106)/1/,IU(1107)/0/,IU(1108)/0/,IU(1109)/0/,IU
     +(1110)/3/,IU(1111)/4/,IU(1112)/27/,IU(1113)/69/,IU(1114)/202/,
     +IU(1115)/397/,IU(1116)/798/,IU(1117)/940/,IU(1118)/762/,IU
     +(1119)/632/,IU(1120)/499/,IU(1121)/436/,IU(1122)/442/,IU(1123)/
     +336/,IU(1124)/110/,IU(1125)/15/,IU(1126)/4/,IU(1127)/0/
      DATA IU(1128)/1/,IU(1129)/0/,IU(1130)/0/,IU(1131)/0/,IU(1132)/
     +0/,IU(1133)/0/,IU(1134)/1/,IU(1135)/2/,IU(1136)/0/,IU(1137)/1/,
     +IU(1138)/2/,IU(1139)/0/,IU(1140)/0/,IU(1141)/0/,IU(1142)/0/,IU
     +(1143)/0/,IU(1144)/0/,IU(1145)/0/,IU(1146)/0/,IU(1147)/4/,IU
     +(1148)/12/,IU(1149)/56/,IU(1150)/155/,IU(1151)/293/,IU(1152)/
     +617/,IU(1153)/883/,IU(1154)/852/,IU(1155)/717/,IU(1156)/565/,
     +IU(1157)/559/,IU(1158)/668/,IU(1159)/801/,IU(1160)/587/,
     +IU(1161)/115/,IU(1162)/2/,IU(1163)/2/,IU(1164)/0/,IU(1165)/1/
      DATA IU(1166)/0/,IU(1167)/0/,IU(1168)/0/,IU(1169)/0/,IU(1170)/
     +0/,IU(1171)/0/,IU(1172)/1/,IU(1173)/1/,IU(1174)/2/,IU(1175)/0/,
     +IU(1176)/0/,IU(1177)/0/,IU(1178)/0/,IU(1179)/0/,IU(1180)/1/,
     +IU(1181)/0/,IU(1182)/0/,IU(1183)/1/,IU(1184)/12/,IU(1185)/13/,
     +IU(1186)/94/,IU(1187)/231/,IU(1188)/462/,IU(1189)/690/,IU(1190)/
     +734/,IU(1191)/567/,IU(1192)/480/,IU(1193)/384/,IU(1194)/457/,
     +IU(1195)/685/,IU(1196)/856/,IU(1197)/434/,IU(1198)/36/,IU(1199)/
     +2/,IU(1200)/0/,IU(1201)/0/,IU(1202)/0/,IU(1203)/0/,IU(1204)/0/
      DATA IU(1205)/0/,IU(1206)/0/,IU(1207)/0/,IU(1208)/0/,IU(1209)/
     +0/,IU(1210)/1/,IU(1211)/2/,IU(1212)/0/,IU(1213)/0/,IU(1214)/0/,
     +IU(1215)/0/,IU(1216)/0/,IU(1217)/0/,IU(1218)/0/,IU(1219)/0/,IU
     +(1220)/4/,IU(1221)/13/,IU(1222)/20/,IU(1223)/188/,IU(1224)/423/,
     +IU(1225)/486/,IU(1226)/737/,IU(1227)/612/,IU(1228)/440/,IU
     +(1229)/300/,IU(1230)/303/,IU(1231)/401/,IU(1232)/594/,IU(1233)/
     +549/,IU(1234)/150/,IU(1235)/14/,IU(1236)/1/,IU(1237)/0/,IU
     +(1238)/0/,IU(1239)/0/,IU(1240)/0/,IU(1241)/0/,IU(1242)/0/
      DATA IU(1243)/0/,IU(1244)/0/,IU(1245)/0/,IU(1246)/0/,IU(1247)/
     +2/,IU(1248)/2/,IU(1249)/0/,IU(1250)/0/,IU(1251)/1/,IU(1252)/0/,
     +IU(1253)/0/,IU(1254)/0/,IU(1255)/0/,IU(1256)/1/,IU(1257)/2/,IU
     +(1258)/20/,IU(1259)/57/,IU(1260)/189/,IU(1261)/362/,IU(1262)/
     +392/,IU(1263)/468/,IU(1264)/342/,IU(1265)/239/,IU(1266)/201/,
     +IU(1267)/199/,IU(1268)/313/,IU(1269)/394/,IU(1270)/209/,
     +IU(1271)/21/,IU(1272)/3/,IU(1273)/0/,IU(1274)/0/,IU(1275)/0/,
     +IU(1276)/0/,IU(1277)/0/,IU(1278)/0/,IU(1279)/0/,IU(1280)/0/
      DATA IU(1281)/0/,IU(1282)/0/,IU(1283)/0/,IU(1284)/3/,IU(1285)/
     +0/,IU(1286)/0/,IU(1287)/0/,IU(1288)/0/,IU(1289)/0/,IU(1290)/0/,
     +IU(1291)/0/,IU(1292)/1/,IU(1293)/1/,IU(1294)/5/,IU(1295)/57/,
     +IU(1296)/32/,IU(1297)/100/,IU(1298)/162/,IU(1299)/169/,IU(1300)/
     +160/,IU(1301)/118/,IU(1302)/99/,IU(1303)/94/,IU(1304)/102/,IU
     +(1305)/117/,IU(1306)/137/,IU(1307)/43/,IU(1308)/6/,IU(1309)/0/,
     +IU(1310)/0/,IU(1311)/0/,IU(1312)/0/,IU(1313)/0/,IU(1314)/0/,IU
     +(1315)/0/,IU(1316)/0/,IU(1317)/0/,IU(1318)/0/,IU(1319)/1/
      DATA IU(1320)/4/,IU(1321)/2/,IU(1322)/1/,IU(1323)/0/,IU(1324)/
     +0/,IU(1325)/0/,IU(1326)/0/,IU(1327)/0/,IU(1328)/1/,IU(1329)/0/,
     +IU(1330)/0/,IU(1331)/2/,IU(1332)/32/,IU(1333)/16/,IU(1334)/45/,
     +IU(1335)/64/,IU(1336)/51/,IU(1337)/40/,IU(1338)/39/,IU(1339)/
     +32/,IU(1340)/38/,IU(1341)/43/,IU(1342)/63/,IU(1343)/35/,IU(1344)
     +/4/,IU(1345)/0/,IU(1346)/0/,IU(1347)/0/,IU(1348)/0/,IU(1349)/0/
      DATA IU(1350)/0/,IU(1351)/0/,IU(1352)/0/,IU(1353)/1/,IU(1354)/
     +0/,IU(1355)/1/,IU(1356)/1/,IU(1357)/2/,IU(1358)/2/IU(1359)/0/,
     +IU(1360)/0/,IU(1361)/0/,IU(1362)/0/,IU(1363)/0/,IU(1364)/0/,
     +IU(1365)/0/,IU(1366)/0/,IU(1367)/1/,IU(1368)/0/,IU(1369)/16/
        DO 1 I=1,1369
        II(I)=IU(I)
   1    CONTINUE
      RETURN
      END
C
C -------------------------------------------------------------------
C
      SUBROUTINE PSTERM
C
C Output Postscript trailer
C
      COMMON/XTAL/SY(12,192),CELL(15),II(1369),NS,LAT,LU,LN,
     +LO,LP,LF,LM,LS,NOS,IER,NPG
   1  FORMAT(/'%%Trailer'/'%%Pages:',I5/'%%EOF')
      WRITE(LP,1)NPG
      RETURN
      END
C
C -------------------------------------------------------------------
C
      SUBROUTINE LINTRM(KR,L)
C
C Replace control characters with blanks and set L to position of
C last non-blank character in a string
C
      CHARACTER*(*)KR
C
      M=LEN(KR)
      L=0
        DO 1 I=1,M
        IF(KR(I:I).LT.' ')KR(I:I)=' '
        IF(KR(I:I).NE.' ')L=I
   1    CONTINUE
      RETURN
      END
C
C -------------------------------------------------------------------
C
      SUBROUTINE FOBHKL(NN,IH,IK,IL,FF,SI,JF)
C
C Read X-PLOR or CNS .fob file and write .hkl file (HKLF 3 format)
C
      COMMON/XTAL/SY(12,192),CELL(15),II(1369),NS,LAT,LU,LN,
     +LO,LP,LF,LM,LS,NOS,IER,NPG
      COMMON/WORD/KF,KR,KD,KE,KA,KB,KN,FMT,COL,OPT
      CHARACTER KF*80,KR*80,KD(462)*52,KA(50000)*4,KE(9999)*4,
     +KB(250)*80,KN(10000)*9,FMT*20,COL*4,OPT*1,KS*1
      INTEGER IH(NN),IK(NN),IL(NN),JF(NN)
      REAL FF(NN),SI(NN)
C
C Open X-PLOR/CNS file for input
C
      KF(LN+1:LN+4)='.fob'
   1  WRITE(*,FMT)' Input X-PLOR or CNS file ['//KF(1:LN+4)//']: '
      READ(*,37,ERR=1,END=1)KR
      CALL LINTRM(KR,N)
      L=0
      M=0
        DO 2 I=1,N
        IF(KR(I:I).EQ.'.')M=I
        IF(KR(I:I).EQ.' ')GOTO 2
        L=L+1
        KR(L:L)=KR(I:I)
   2    CONTINUE
      IF(M.NE.0)GOTO 4
      IF(L.NE.0)GOTO 3
      KR=KF
      L=LN
   3  L=L+4
      KR(L-3:L)='.fob'
   4  OPEN(LF,FILE=KR(1:L),STATUS='OLD',ERR=38)
      WRITE(LO,39)KR(1:L)
C
C Open .hkl file for output
C
      KF(LN+1:LN+4)='.hkl'
   5  WRITE(*,FMT)' Filename for .hkl file to write ['//
     +KF(1:LN+4)//']: '
      KR=' '
      READ(*,37,ERR=5,END=5)KR
      CALL LINTRM(KR,N)
      L=0
        DO 6 I=1,N
        IF(KR(I:I).EQ.' ')GOTO 6
        L=L+1
        KR(L:L)=KR(I:I)
   6    CONTINUE
      IF(L.GT.0)GOTO 7
      KR=KF
      L=LN+4
      GOTO 8
   7  IF(INDEX(KR,'.').NE.0)GOTO 8
      L=L+4
      KR(L-3:L)='.hkl'
   8  CALL WROPEN(LM,KR,L,I)
      IF(I.NE.0)GOTO 38
      WRITE(LO,40)KR(1:L)
C
C Read and store reflections
C
      N=0
      JJ=1
      JE=0
   9  READ(LF,37,END=25)KR
      CALL LINTRM(KR,L)
        DO 10 I=1,L
        KS=KR(I:I)
        IF(KS.GE.'a'.AND.KS.LE.'z')KR(I:I)=CHAR(ICHAR(KS)-32)
  10    CONTINUE
      K=INDEX(KR,'INDE')
      IF(K.EQ.0)GOTO 14
      IF(N.GT.NN)GOTO 24
      JJ=0
  11  K=K+1
      IF(K.GT.L)GOTO 13
      IF(KR(K-1:K-1).EQ.'=')GOTO 12
      IF(KR(K:K).NE.' ')GOTO 11
  12  READ(KR(K:L),*,ERR=13,END=13)IH(N+1),IK(N+1),IL(N+1)
      N=N+1
      FF(N)=-9.E9
      SI(N)=-9.E9
      JF(N)=0
      GOTO 14
  13  JJ=1
      JE=JE+1
      WRITE(*,41)KR(1:L)
      WRITE(LO,41)KR(1:L)
  14  IF(JJ.NE.0)GOTO 9
      K=INDEX(KR,'FOBS')
      IF(K.EQ.0)GOTO 18
  15  K=K+1
      IF(K.GT.L)GOTO 17
      IF(KR(K-1:K-1).EQ.'=')GOTO 16
      IF(KR(K:K).NE.' ')GOTO 15
  16  READ(KR(K:L),*,ERR=17,END=17)T
      FF(N)=T
      GOTO 18
  17  JE=JE+1
      WRITE(*,42)KR(1:L)
      WRITE(LO,42)KR(1:L)
      IF(JE.GT.99)GOTO 50
      GOTO 9
  18  K=INDEX(KR,'SIGM')
      IF(K.EQ.0)GOTO 21
  19  K=K+1
      IF(K.GT.L)GOTO 17
      IF(KR(K-1:K-1).EQ.'=')GOTO 20
      IF(KR(K:K).NE.' ')GOTO 19
  20  READ(KR(K:L),*,ERR=17,END=17)T
      SI(N)=T
  21  K=INDEX(KR,'TEST')
      IF(K.EQ.0)GOTO 9
  22  K=K+1
      IF(K.GT.L)GOTO 17
      IF(KR(K-1:K-1).EQ.'=')GOTO 23
      IF(KR(K:K).NE.' ')GOTO 22
  23  READ(KR(K:L),*,ERR=17,END=17)I
      JF(N)=I
      GOTO 9
C
C Check stored reflections
C
  24  WRITE(*,45)
      WRITE(LO,45)
  25  T=0.
      J=0
      K=0
      L=0
      M=0
        DO 27 I=1,N
        IF(FF(I).GT.-8.E9.AND.SI(I).GT.-8.E9)GOTO 26
        J=J+1
        GOTO 27
  26    T=AMAX1(T,FF(I),SI(I))
        IF(FF(I).LT.0.)K=K+1
        IF(FF(I).GT.0.0.AND.SI(I).LE.0.)L=L+1
        M=M+JF(I)
  27    CONTINUE
      IF(J.EQ.0)GOTO 28
      WRITE(*,43)J
      WRITE(LO,43)J
  28  IF(K+L.EQ.0)GOTO 29
      WRITE(*,44)K,L
      WRITE(LO,44)K,L
  29  Q=1.
  30  IF(Q*T.LT.999999.)GOTO 31
      Q=0.1*Q
      GOTO 30
  31  IF(Q.GT.0.9)GOTO 32
      WRITE(*,46)Q
      WRITE(LO,46)Q
C
C Write good reflections to .hkl file
C
  32    DO 36 I=1,N
        IF(FF(I).LT.0.0.OR.SI(I).LE.0.0)GOTO 36
        P=Q*FF(I)
        S=Q*SI(I)
        NF=1
        IF(JF(I).NE.0)NF=-1
        T=AMAX1(P,S)
        IF(T.GT.999.)GOTO 33
        WRITE(LM,'(3I4,2F8.3,I4)')IH(I),IK(I),IL(I),P,S,NF
        GOTO 36
  33    IF(T.GT.9999.)GOTO 34
        WRITE(LM,'(3I4,2F8.2,I4)')IH(I),IK(I),IL(I),P,S,NF
        GOTO 36
  34    IF(T.GT.99999.)GOTO 35
        WRITE(LM,'(3I4,2F8.1,I4)')IH(I),IK(I),IL(I),P,S,NF
        GOTO 36
  35    WRITE(LM,'(3I4,2F8.0,I4)')IH(I),IK(I),IL(I),P,S,NF
  36    CONTINUE
      N=N-J-K-L
      GOTO 51
C
C Messages and finish off
C
  37  FORMAT(A)
  38  WRITE(*,'(/A/)')' ** Cannot open file '//KR(1:L)//' **'
      GOTO 52
  39  FORMAT(/1X,78('=')//' Reading X-PLOR/CNS file: ',A)
  40  FORMAT(/' Writing SHELX (HKLF 3) file: ',A)
  41  FORMAT(/' ** Bad record in input file - cannot extract h, k ',
     +'and l **'/1X,A)
  42  FORMAT(/' ** Bad record in input file - cannot extract F',
     +', Sigma(F) or free R flag **'/1X,A)
  43  FORMAT(/I8,' Reflections ignored because F or sigma(F) missing')
  44  FORMAT(/I8,' Reflections with F<0 ignored and',I8,
     +' others with sigma=<0 ignored')
  45  FORMAT(/' ** Too many reflections in input file - rest ',
     +'ignored **')
  46  FORMAT(/' F and sigma(F) multiplied by',F7.4,' to fit format')
  47  FORMAT('   0   0   0    0.00    0.00   0')
  48  FORMAT(/' ** Too many errors in input file - conversion ',
     +'aborted **/')
  49  FORMAT(/I8,' Reflections copied, of which',I6,
     +' flagged for R(free)')
  50  WRITE(*,48)
      WRITE(LO,48)
      CLOSE(LM,STATUS='DELETE',IOSTAT=I)
      GOTO 52
  51  WRITE(LM,47)
      WRITE(*,49)N,M
      WRITE(LO,49)N,M
  52  CLOSE(LM,IOSTAT=I)
      RETURN
      END
C
C -------------------------------------------------------------------
C
      SUBROUTINE RFREE
C
C Read .hkl file and create a new .hkl file with R(free) reflections
C flagged by making the batch number negative.
C
      COMMON/XTAL/SY(12,192),CELL(15),II(1369),NS,LAT,LU,LN,
     +LO,LP,LF,LM,LS,NOS,IER,NPG
      COMMON/WORD/KF,KR,KD,KE,KA,KB,KN,FMT,COL,OPT
      CHARACTER KF*80,KR*80,KD(462)*52,KA(50000)*4,KE(9999)*4,
     +KB(250)*80,KN(10000)*9,FMT*20,COL*4,OPT*1,KS*1
      REAL D(6)
C
C Open .hkl file for input
C
      KF(LN+1:LN+4)='.hkl'
   1  WRITE(*,FMT)' Input reflection data file ['//KF(1:LN+4)//']: '
      READ(*,19,ERR=1,END=1)KR
      CALL LINTRM(KR,N)
      L=0
      M=0
        DO 2 I=1,N
        IF(KR(I:I).EQ.'.')M=I
        IF(KR(I:I).EQ.' ')GOTO 2
        L=L+1
        KR(L:L)=KR(I:I)
   2    CONTINUE
      IF(M.NE.0)GOTO 4
      IF(L.NE.0)GOTO 3
      KR=KF
      L=LN
   3  L=L+4
      KR(L-3:L)='.hkl'
   4  OPEN(LF,FILE=KR(1:L),STATUS='OLD',ERR=22)
      WRITE(LO,20)KR(1:L)
C
C Open .hkl file for output
C
      M=LN
      IF(NOS.EQ.1)M=MIN0(M,7)
      KF(M+1:M+5)='t.hkl'
   5  WRITE(*,FMT)' Filename for .hkl file to write ['//
     +KF(1:M+5)//']: '
      KR=' '
      READ(*,19,ERR=5,END=5)KR
      CALL LINTRM(KR,N)
      L=0
        DO 6 I=1,N
        IF(KR(I:I).EQ.' ')GOTO 6
        L=L+1
        KR(L:L)=KR(I:I)
   6    CONTINUE
      IF(L.GT.0)GOTO 7
      KR=KF
      L=M+5
      GOTO 8
   7  IF(INDEX(KR,'.').NE.0)GOTO 8
      L=L+4
      KR(L-3:L)='.hkl'
   8  CALL WROPEN(LM,KR,L,I)
      IF(I.NE.0)GOTO 22
   9  WRITE(*,FMT)' Percentage of data to be flagged for R(free) [5]: '
      KR=' '
      READ(*,19,ERR=9,END=9)KR
      CALL LINTRM(KR,N)
      IF(N.EQ.0)KR='5.0 '
      READ(KR,*,ERR=9,END=9)P
      IF(P.LE.0.)GOTO 9
      IF(P.GE.100.)GOTO 9
  10  WRITE(*,FMT)' R(free) reflections random (R) or in thin shells'
     +//' (S) [R]: '
      KR=' '
      READ(*,19,ERR=10,END=10)KR
      CALL LINTRM(KR,N)
      KS='R'
      IF(N.EQ.0)GOTO 14
      KS=KR(N:N)
      IF(KS.EQ.'r')KS='R'
      IF(KS.EQ.'R')GOTO 14
      IF(KS.EQ.'s')KS='S'
      IF(KS.NE.'S')GOTO 10
C
C Set up thin shells
C
  11  WRITE(*,FMT)' Enter a,b,c,alpha,beta,gamma: '
      KR=' '
      READ(*,19,ERR=11,END=11)KR
      CALL LINTRM(KR,N)
      IF(N.EQ.0)GOTO 11
      READ(KR(1:N),*,ERR=11,END=11)(CELL(I),I=1,6)
        DO 12 I=1,3
        IF(CELL(I).LT.0.1)GOTO 11
        T=.0174533*CELL(I+3)
        IF(T.LT.0.001)GOTO 11
        D(I)=SIN(T)
        D(I+3)=COS(T)
        CELL(I+6)=(D(I)/CELL(I))**2
  12    CONTINUE
      V=1.-D(4)**2-D(5)**2-D(6)**2+2.*D(4)*D(5)*D(6)
      CELL(7)=CELL(7)/V
      CELL(8)=CELL(8)/V
      CELL(9)=CELL(9)/V
      CELL(10)=2.*SQRT(CELL(8)*CELL(9))*(D(5)*D(6)-D(4))/(D(2)*D(3))
      CELL(11)=2.*SQRT(CELL(7)*CELL(9))*(D(4)*D(6)-D(5))/(D(1)*D(3))
      CELL(12)=2.*SQRT(CELL(7)*CELL(8))*(D(4)*D(5)-D(6))/(D(1)*D(2))
  13  WRITE(*,FMT)' Shell thickness in Angstrom^-2 [0.001]: '
      KR=' '
      READ(*,19,ERR=13,END=13)KR
      CALL LINTRM(KR,N)
      Q=0.001
      IF(N.GT.0)READ(KR(1:N),*,ERR=13,END=13)Q
      IF(Q.LE.0.)GOTO 13
      P=100.*Q/P
C
C Read and divide data
C
  14  M=0
      N=0
      JR=3924
  15  KR=' '
      READ(LF,19,ERR=15,END=24)KR(1:28)
      CALL LINTRM(KR(1:28),I)
      IF(KR(1:12).EQ.'            ')GOTO 15
      IF(KR(1:12).EQ.'   0   0   0')GOTO 24
      J=1
      IF(KS.EQ.'S')GOTO 17
      JR=MOD(JR*106+1283,6075)
      IF(REAL(JR).LT.60.75*P)J=-1
  16  M=M+(1-J)/2
      N=N+1
      WRITE(LM,18)KR(1:28),J
      GOTO 15
  17  READ(KR,'(3I4)',ERR=15,END=15)I,K,L
      U=REAL(I)
      V=REAL(K)
      W=REAL(L)
      T=CELL(7)*U**2+CELL(8)*V**2+CELL(9)*W**2+CELL(10)*V*W+
     +CELL(11)*U*W+CELL(12)*U*V
      IF(AMOD(T+0.5*P,P).LT.Q)J=-1
      GOTO 16
C
C Messages and finish off
C
  18  FORMAT(A28,I4)
  19  FORMAT(A)
  20  FORMAT(/1X,78('=')//' Reading file: ',A/)
  21  FORMAT('   0   0   0    0.00    0.00   0')
  22  WRITE(*,'(/A/)')' ** Cannot open file '//KR(1:L)//' **'
      GOTO 25
  23  FORMAT(/I8,' Reflections copied, of which',I6,
     +' flagged for R(free)')
  24  WRITE(LM,21)
      WRITE(*,23)N,M
      WRITE(LO,23)N,M
  25  CLOSE(LM,IOSTAT=I)
      RETURN
      END
C
C -------------------------------------------------------------------
C
      SUBROUTINE DENZOS
C
C Read .sca file from DENZO/SCALEPACK and convert to .hkl file
C
      COMMON/XTAL/SY(12,192),CELL(15),II(1369),NS,LAT,LU,LN,
     +LO,LP,LF,LM,LS,NOS,IER,NPG
      COMMON/WORD/KF,KR,KD,KE,KA,KB,KN,FMT,COL,OPT
      CHARACTER KF*80,KR*80,KD(462)*52,KA(50000)*4,KE(9999)*4,
     +KB(250)*80,KN(10000)*9,FMT*20,COL*4,OPT*1,KT*80,KS*1,KQ*10
C
C Open .sca file and extract cell and space group
C
      KF(LN+1:LN+4)='.sca'
   1  WRITE(*,FMT)' Name of .sca file created using DENZO/SCALEPACK'
     +//' ['//KF(1:LN+4)//']: '
      READ(*,'(A)',ERR=1,END=1)KR
      CALL LINTRM(KR,N)
      L=0
      M=0
        DO 2 I=1,N
        IF(KR(I:I).EQ.'.')M=I
        IF(KR(I:I).EQ.' ')GOTO 2
        L=L+1
        KR(L:L)=KR(I:I)
   2    CONTINUE
      IF(M.NE.0)GOTO 4
      IF(L.NE.0)GOTO 3
      KR=KF
      L=LN
   3  L=L+4
      KR(L-3:L)='.sca'
   4  OPEN(LF,FILE=KR(1:L),STATUS='OLD',ERR=28)
      WRITE(LO,21)KR(1:L)
      READ(LF,'(A)',ERR=27,END=27)KR
      READ(LF,'(A)',ERR=27,END=27)KR
      READ(LF,'(A)',ERR=27,END=27)KR
      CALL LINTRM(KR,I)
      READ(KR,'(6F10.3)',ERR=27,END=27)(CELL(I),I=1,6)
      KT=' '
      KT(1:19)=KR(62:80)
      WRITE(*,22)(CELL(I),I=1,6),KT(1:30)
      WRITE(LO,22)(CELL(I),I=1,6),KT(1:30)
C
C Open .hkl file for output
C
      KF(LN+1:LN+4)='.hkl'
   5  WRITE(*,FMT)' Enter name of .hkl output file ['//
     +KF(1:LN+4)//']: '
      KR=' '
      READ(*,'(A)',ERR=5,END=5)KR
      CALL LINTRM(KR,N)
      L=0
        DO 6 I=1,N
        IF(KR(I:I).EQ.' ')GOTO 6
        L=L+1
        KR(L:L)=KR(I:I)
   6    CONTINUE
      IF(L.GT.0)GOTO 7
      KR=KF
      L=LN+4
      GOTO 8
   7  IF(INDEX(KR,'.').NE.0)GOTO 8
      L=L+4
      KR(L-3:L)='.hkl'
   8  CALL WROPEN(LS,KR,L,I)
      IF(I.NE.0)GOTO 30
      M=0
C
C Convert data formats
C
   9  WRITE(*,'(A)')' Copy all data including Friedel opposites'
     +//' (C), merge Friedel opposites'
      WRITE(*,FMT)' if any (M) or prepare anomalous delta-F file'
     +//' (A) [M]: '
      KT=' '
      READ(*,'(A)',ERR=9,END=9)KT
      CALL LINTRM(KT,I)
      KS='M'
      IF(I.GT.0)KS=KT(I:I)
      IF(KS.EQ.'m')KS='M'
      IF(KS.EQ.'a')KS='A'
      IF(KS.EQ.'c')KS='C'
      IF(KS.EQ.'Q'.OR.KS.EQ.'q')GOTO 30
      IF(KS.NE.'A'.AND.KS.NE.'C'.AND.KS.NE.'M')GOTO 9
  10  KT=' '
      READ(LF,'(A)',ERR=10,END=29)KT
      CALL LINTRM(KT,I)
      READ(KT,'(3I4)',ERR=10,END=10)I,J,K
      KQ=KT(13:20)//'00'
      IF(INDEX(KQ,'.').EQ.0)KQ(9:9)='.'
      READ(KQ,*)F
      F=0.1*F
      KQ=KT(21:28)//'00'
      IF(INDEX(KQ,'.').EQ.0)KQ(9:9)='.'
      READ(KQ,*)S
      S=0.1*S
      KQ=KT(29:36)//'00'
      IF(INDEX(KQ,'.').EQ.0)KQ(9:9)='.'
      READ(KQ,*)P
      P=0.1*P
      KQ=KT(37:44)//'00'
      IF(INDEX(KQ,'.').EQ.0)KQ(9:9)='.'
      READ(KQ,*)Q
      Q=0.1*Q
      IF(KS.NE.'C')GOTO 15
      IF(S.LT.0.0001)GOTO 14
  11  M=M+1
      IF(F.GT.9999.99)GOTO 12
      WRITE(LS,23)I,J,K,F,S
      GOTO 14
  12  IF(F.GT.99999.9)GOTO 13
      WRITE(LS,24)I,J,K,F,S
      GOTO 14
  13  WRITE(LS,25)I,J,K,F,S
  14  IF(Q.LT.0.0001)GOTO 10
      I=-I
      J=-J
      K=-K
      GOTO 18
  15  IF(KS.NE.'A')GOTO 16
      IF(S.LT.0.0001.OR.Q.LT.0.0001)GOTO 10
      IF(F.LT.0.25*S)F=0.25*S
      IF(P.LT.0.25*Q)P=0.25*Q
      F=SQRT(F)
      P=SQRT(P)
      T=ABS(F-P)
      S=SQRT(S**2+Q**2)/(F+P)
      Q=2.*T*S+S**2
      P=T**2
      GOTO 18
  16  IF(S.GT.0.0001)GOTO 17
      IF(Q.LT.0.0001)GOTO 10
      GOTO 18
  17  IF(Q.LT.0.0001)GOTO 11
      T=1./S**2+1./Q**2
      P=(F/S**2+P/Q**2)/T
      Q=1./SQRT(T)
  18  M=M+1
      IF(P.GT.9999.99)GOTO 19
      WRITE(LS,23)I,J,K,P,Q
      GOTO 10
  19  IF(P.GT.99999.9)GOTO 20
      WRITE(LS,24)I,J,K,P,Q
      GOTO 10
  20  WRITE(LS,25)I,J,K,P,Q
      GOTO 10
C
C Messages and finish off
C
  21  FORMAT(/1X,78('=')//' Reading file: ',A/)
  22  FORMAT(' Cell:',6F10.3/' Space group: ',A)
  23  FORMAT(3I4,2F8.2)
  24  FORMAT(3I4,2F8.1)
  25  FORMAT(3I4,2F8.0)
  26  FORMAT(I8,' Reflections written in HKLF 4 format to file ',A)
  27  WRITE(*,'(/A/)')' ** Badly formatted .sca file **'
      GOTO 30
  28  WRITE(*,'(/A/)')' ** Cannot open file '//KR(1:L)//' **'
      GOTO 30
  29  I=0
      S=0.
      WRITE(LS,24)I,I,I,S,S
      WRITE(*,26)M,KR(1:L)
      WRITE(LO,'(1X)')
      WRITE(LO,26)M,KR(1:L)
  30  CLOSE(LS,IOSTAT=I)
      RETURN
      END
C
C -------------------------------------------------------------------
C
      SUBROUTINE FCFINP
C
C Open .fcf file and extract crystal data
C
      CHARACTER TX(3)*10
      REAL D(6)
      COMMON/XTAL/SY(12,192),CELL(15),II(1369),NS,LAT,LU,LN,
     +LO,LP,LF,LM,LS,NOS,IER,NPG
      COMMON/WORD/KF,KR,KD,KE,KA,KB,KN,FMT,COL,OPT
      CHARACTER KF*80,KR*80,KD(462)*52,KA(50000)*4,KE(9999)*4,
     +KB(250)*80,KN(10000)*9,FMT*20,COL*4,OPT*1
C
C Open .fcf file
C
      KF(LN+1:LN+4)='.fcf'
   1  WRITE(*,FMT)' Name of .fcf file created using SHELXL '
     +//'and LIST 6 ['//KF(1:LN+4)//']: '
      READ(*,'(A)',ERR=1,END=1)KR
      CALL LINTRM(KR,N)
      L=0
      M=0
        DO 2 I=1,N
        IF(KR(I:I).EQ.'.')M=I
        IF(KR(I:I).EQ.' ')GOTO 2
        L=L+1
        KR(L:L)=KR(I:I)
   2    CONTINUE
      IF(M.NE.0)GOTO 4
      IF(L.NE.0)GOTO 3
      KR=KF
      L=LN
   3  L=L+4
      KR(L-3:L)='.fcf'
   4  OPEN(LF,FILE=KR(1:L),STATUS='OLD',ERR=14)
   5  FORMAT(/1X,78('=')//1X,A//' Symmetry operators:')
      WRITE(LO,5)'Reading file '//KR(1:L)
C
C Initialize parameters
C
      NL=0
      NS=0
        DO 6 I=1,14
        CELL(I)=0.
   6    CONTINUE
   7  MS=0
   8  KR=' '
      READ(LF,'(A)',ERR=15,END=15)KR
      CALL LINTRM(KR,I)
      IF(MS.EQ.0)GOTO 11
C
C Decode symmetry operators
C
      IF(INDEX(KR,'y').EQ.0)GOTO 7
      NS=NS+1
        DO 9 I=1,12
        SY(I,NS)=0.
   9    CONTINUE
      K=INDEX(KR,'''')+1
      J=INDEX(KR,',')
      TX(1)='+'//KR(K:J-1)
      I=INDEX(KR(J+1:80),',')+J
      TX(2)='+'//KR(J+2:I-1)
      J=INDEX(KR(I+1:80),'''')+I-1
      TX(3)='+'//KR(I+2:J)
      WRITE(LO,'(1X,A)')KR(K:J)
      M=1
        DO 10 I=1,3
        IF(INDEX(TX(I),'+x').NE.0)SY(M,NS)=1.
        IF(INDEX(TX(I),'-x').NE.0)SY(M,NS)=-1.
        IF(INDEX(TX(I),'+y').NE.0)SY(M+1,NS)=1.
        IF(INDEX(TX(I),'-y').NE.0)SY(M+1,NS)=-1.
        IF(INDEX(TX(I),'+z').NE.0)SY(M+2,NS)=1.
        IF(INDEX(TX(I),'-z').NE.0)SY(M+2,NS)=-1.
        M=M+3
        J=INDEX(TX(I),'/')
        IF(J.EQ.0)GOTO 10
        READ(TX(I)(J-2:J+1),'(I2,1X,I1)')K,L
        SY(I+9,NS)=REAL(K)/REAL(L)
  10    CONTINUE
      GOTO 8
C
C Extract resolution, LIST code and unit-cell dimensions
C
  11  I=INDEX(KR,'_reflns_d_resolution_high')
      IF(I.NE.0)READ(KR(I+25:80),*,ERR=15)CELL(13)
      I=INDEX(KR,'F_000')
      IF(I.NE.0)READ(KR(I+5:80),*,ERR=15)CELL(14)
      I=INDEX(KR,'_cell_length_a')
      IF(I.NE.0)READ(KR(I+14:80),*,ERR=15)CELL(1)
      I=INDEX(KR,'_cell_length_b')
      IF(I.NE.0)READ(KR(I+14:80),*,ERR=15)CELL(2)
      I=INDEX(KR,'_cell_length_c')
      IF(I.NE.0)READ(KR(I+14:80),*,ERR=15)CELL(3)
      I=INDEX(KR,'_cell_angle_alpha')
      IF(I.NE.0)READ(KR(I+17:80),*,ERR=15)CELL(4)
      I=INDEX(KR,'_cell_angle_beta')
      IF(I.NE.0)READ(KR(I+16:80),*,ERR=15)CELL(5)
      I=INDEX(KR,'_cell_angle_gamma')
      IF(I.NE.0)READ(KR(I+17:80),*,ERR=15)CELL(6)
      I=INDEX(KR,'_shelx_refln_list_code')
      IF(I.NE.0)READ(KR(I+22:80),*,ERR=15)NL
      IF(INDEX(KR,'_symmetry_equiv_pos_as_xyz').NE.0)MS=1
      IF(INDEX(KR,'_refln_phase_calc').EQ.0)GOTO 8
C
C Check data and find coefficients for calculating d
C
      IF(NS.LT.1)GOTO 15
      IF(CELL(13).LT.0.0001)GOTO 15
      IF(CELL(14).LT.0.0001)GOTO 15
      IF(NL.NE.6)GOTO 15
        DO 12 I=1,3
        IF(CELL(I).LT.0.1)GOTO 15
        T=.0174533*CELL(I+3)
        IF(T.LT.0.001)GOTO 15
        D(I)=SIN(T)
        D(I+3)=COS(T)
        CELL(I+6)=(D(I)/CELL(I))**2
  12    CONTINUE
      V=1.-D(4)**2-D(5)**2-D(6)**2+2.*D(4)*D(5)*D(6)
      CELL(7)=CELL(7)/V
      CELL(8)=CELL(8)/V
      CELL(9)=CELL(9)/V
      CELL(10)=2.*SQRT(CELL(8)*CELL(9))*(D(5)*D(6)-D(4))/(D(2)*D(3))
      CELL(11)=2.*SQRT(CELL(7)*CELL(9))*(D(4)*D(6)-D(5))/(D(1)*D(3))
      CELL(12)=2.*SQRT(CELL(7)*CELL(8))*(D(4)*D(5)-D(6))/(D(1)*D(2))
      CELL(15)=CELL(1)*CELL(2)*CELL(3)*SQRT(V)
C
C Output summary and error messages
C
      WRITE(LO,'(/A,3F9.3,3F9.2)')' Unit-cell:',(CELL(I),I=1,6)
  13  FORMAT(/A,F8.4,A//1X,78('-'))
      WRITE(LO,13)' Maximum resolution =',CELL(13),' Angstroms'
      GOTO 17
  14  WRITE(*,'(A)')' ** Cannot open file '//KR(1:L)//' **'
      GOTO 16
  15  WRITE(*,'(A)')
     +' ** Bad .fcf file format (not SHELXL LIST 6 ?) **'
  16  IER=1
  17  RETURN
      END
C
C -------------------------------------------------------------------
C
      SUBROUTINE FCFSTA(NM,RES,UN,SI,PC,PO,RA,RO,SA,SO,RS,SC)
C
C Statistical analysis of reflection data after refinement
C
      REAL D(7),RES(NM),UN(NM),SI(NM),RS(NM),SC(NM)
      REAL PC(NM),PO(NM),RA(NM),RO(NM),SA(NM),SO(NM),X(25),Y(25)
      COMMON/XTAL/SY(12,192),CELL(15),II(1369),NS,LAT,LU,LN,
     +LO,LP,LF,LM,LS,NOS,IER,NPG
      COMMON/WORD/KF,KR,KD,KE,KA,KB,KN,FMT,COL,OPT
      CHARACTER KF*80,KR*80,KD(462)*52,KA(50000)*4,KE(9999)*4,
     +KB(250)*80,KN(10000)*9,FMT*20,COL*4,OPT*1
      INTEGER LUZ(25),LUR(25)
      DATA LUZ/0,25,50,74,98,122,145,168,191,214,237,281,319,353,
     +385,414,440,463,483,502,518,548,564,574,580/
      DATA LUR/0,1,2,3,4,5,6,7,8,9,10,12,14,16,18,20,22,24,26,28,
     +30,35,40,45,50/
      DN=99999.
C
C Set fixed resolution ranges for Luzzati plot
C
      IF(OPT.NE.'L')GOTO 2
      T=0.0625/CELL(13)**2
      RES(1)=99999.
        DO 1 I=2,16
        RES(I)=1./SQRT(REAL(I-1)*T)
   1    CONTINUE
      L=17
      GOTO 7
C
C Ask for and sort resolution ranges
C
   2  WRITE(*,'(A,F8.4/)')' Maximum resolution =',CELL(13)
   3  WRITE(*,'(A/)')' Enter resolution range boundaries on one '//
     +'line, e.g. 8 3 2.5 2.1 1.9 1.8'
      KR=' '
      READ(*,'(A)',END=3,ERR=3)KR
      CALL LINTRM(KR,I)
      L=1
      RES(L)=999.999
        DO 4 I=1,79
        IF(KR(I:I).EQ.',')KR(I:I)=' '
        IF(KR(I:I).EQ.' ')GOTO 4
        IF(KR(I+1:I+1).EQ.' ')L=L+1
   4    CONTINUE
      READ(KR,*)(RES(I),I=2,L)
        DO 6 I=2,L
          DO 5 J=I+1,L
          IF(RES(I).GE.RES(J))GOTO 5
          T=RES(I)
          RES(I)=RES(J)
          RES(J)=T
   5      CONTINUE
   6    CONTINUE
      L=L+1
   7  RES(L)=0.
        DO 8 I=1,L
        UN(I)=0.
        SI(I)=0.
        PC(I)=0.
        PO(I)=0.
        RA(I)=0.
        RO(I)=0.
        SA(I)=0.
        SO(I)=0.
        RS(I)=0.
        SC(I)=0.
   8    CONTINUE
C
C Read reflection data
C
   9  KR=' '
      READ(LF,'(A)',END=11)KR
      CALL LINTRM(KR,I)
      READ(KR,*,ERR=9,END=9)D
      R=1./SQRT(CELL(7)*D(1)**2+CELL(8)*D(2)**2+CELL(9)*D(3)**2+
     +CELL(10)*D(2)*D(3)+CELL(11)*D(1)*D(3)+CELL(12)*D(1)*D(2))
      IF(R.LT.DN)DN=R
      T=SQRT(AMAX1(0.,D(4)))
      S=ABS(T-D(6))
      Q=AMAX1(D(5),0.0001)
        DO 10 I=1,L-1
        IF(R.GE.RES(I))GOTO 10
        IF(R.LT.RES(I+1))GOTO 10
        UN(I)=UN(I)+1.
        SI(I)=SI(I)+D(4)/Q
        RA(I)=RA(I)+S
        SA(I)=SA(I)+T
        RS(I)=RS(I)+1./R
        SC(I)=SC(I)+D(6)
        IF(D(4).LT.2.*Q)GOTO 10
        PO(I)=PO(I)+1.
        RO(I)=RO(I)+S
        SO(I)=SO(I)+T
  10    CONTINUE
      UN(L)=UN(L)+1.
      SI(L)=SI(L)+D(4)/Q
      RA(L)=RA(L)+S
      SA(L)=SA(L)+T
      SC(I)=SC(I)+D(6)
      IF(D(4).LT.2.*Q)GOTO 9
      PO(L)=PO(L)+1.
      RO(L)=RO(L)+S
      SO(L)=SO(L)+T
      GOTO 9
C
C Theoretical number of unique reflections in each shell
C
  11  IF(UN(L).LT.0.5)GOTO 45
      DN=DN-0.00001
      RES(L)=DN
      MAXH=INT(CELL(1)/CELL(13)+.5)
      MAXK=INT(CELL(2)/CELL(13)+.5)
      MAXL=INT(CELL(3)/CELL(13)+.5)
      MINH=-1-MAXH
      MINK=-1-MAXK
      ML=-1
  12  ML=ML+1
      IF(ML.GT.MAXL)GOTO 19
      W=REAL(ML)
      MK=MINK
      IF(ML.EQ.0)MK=-1
  13  MK=MK+1
      IF(MK.GT.MAXK)GOTO 12
      V=REAL(MK)
      MT=IABS(MK)+IABS(ML)
      MH=MINH
      IF(MT.EQ.0)MH=0
  14  MH=MH+1
      IF(MH.GT.MAXH)GOTO 13
      IF(IABS(MH)+MT.EQ.0)GOTO 14
      U=REAL(MH)
        DO 17 N=2,NS
        M=1
        IH=INT(1.0001*(U*SY(1,N)+V*SY(4,N)+W*SY(7,N)))
        IK=INT(1.0001*(U*SY(2,N)+V*SY(5,N)+W*SY(8,N)))
        IL=INT(1.0001*(U*SY(3,N)+V*SY(6,N)+W*SY(9,N)))
        IF(IL.GT.0)GOTO 16
        IF(IL.LT.0)GOTO 15
        IF(IK.GT.0)GOTO 16
        IF(IK.LT.0)GOTO 15
        IF(IH.GE.0)GOTO 16
  15    IH=-IH
        IK=-IK
        IL=-IL
        M=-1
  16    IF(IL.GT.ML)GOTO 14
        IF(IL.LT.ML)GOTO 17
        IF(IK.GT.MK)GOTO 14
        IF(IK.LT.MK)GOTO 17
        IF(IH.GT.MH)GOTO 14
        IF(IH.LT.MH)GOTO 17
        IF(M.LT.0)GOTO 17
        IF(ABS(AMOD(999.5+U*SY(10,N)+V*SY(11,N)+W*SY(12,N),1.)-
     +  .5).GT.0.1)GOTO 14
  17    CONTINUE
      R=1./SQRT(CELL(7)*U**2+CELL(8)*V**2+CELL(9)*W**2+
     +CELL(10)*V*W+CELL(11)*U*W+CELL(12)*U*V)
      IF(R.LT.DN)GOTO 14
        DO 18 I=1,L-1
        IF(R.GE.RES(I))GOTO 18
        IF(R.LT.RES(I+1))GOTO 18
        PC(I)=PC(I)+1.
  18    CONTINUE
      PC(L)=PC(L)+1.
      GOTO 14
C
C Scale Luzzati plot
C
  19  KR=' '
      K=1
      IF(OPT.NE.'L')GOTO 41
      NPG=NPG+1
      WRITE(LP,31)NPG,NPG
      R=0.1*AINT(10.*RS(1)/AMAX1(0.1,UN(1))-0.5)
      S=0.1*AINT(10.*RS(L-1)/AMAX1(0.1,UN(L-1))+1.5)
      J=INT(25.*S)
      N=25
  20  N=N-1
      IF(LUR(N).GT.J)GOTO 20
      T=REAL(LUZ(N+1))*0.001
        DO 21 I=1,L-1
        T=AMAX1(T,0.1+RO(I)/AMAX1(0.0001,SO(I)))
  21    CONTINUE
      M=4
  22  M=M+1
      J=INT(5.*S*REAL(M+1))
      N=25
  23  N=N-1
      IF(LUR(N).GT.J)GOTO 23
      IF(M.LT.8.AND.REAL(LUZ(N+1))*0.001.LT.T)GOTO 22
C
C Output Luzzati plot
C
      WRITE(LP,30)'3 W C7 110 330 490 710 B C0 1 W'
        DO 24 I=1,L-1
        P=110.+380.*(RS(I)/AMAX1(UN(I),0.1)-R)/(S-R)
        Q=330.+380.*RO(I)/(AMAX1(SO(I),0.0001)*T)
        IF(I.GT.1)WRITE(LP,35)U,V,P,Q
        WRITE(LP,34)P,Q
        U=P
        V=Q
  24    CONTINUE
      WRITE(LP,30)'(Luzzati plot) 20 300 740 P'
      WRITE(LP,30)'(R1-Index [F>4sigma(F)]) 15 65 520 Q'
      WRITE(LP,30)'(1/d (reciprocal Angstroms)) 15 300 290 P'
      WRITE(LP,30)'(Mean error in Angstroms) 15 535 520 Q 1 W'
      P=R
  25  WRITE(KR,'(F3.1)')P
      IF(KR(1:1).EQ.' ')KR(1:1)='0'
      U=110.+380.*(P-R)/(S-R)
      WRITE(LP,32)KR(1:3),U,U,U
      P=P+0.1
      IF(P.LT.S+0.01)GOTO 25
      P=0.
  26  WRITE(KR,'(F4.2)')P
      IF(KR(1:1).EQ.' ')KR(1:1)='0'
      U=330.+380.*P/T
      WRITE(LP,33)KR(1:4),U,U,U
      P=P+0.05
      IF(P.LE.T)GOTO 26
        DO 29 I=1,M
        K=1
        N=25
          DO 27 J=1,25
          X(J)=110.+380.*(REAL(LUR(J))/REAL(5*I)-R)/(S-R)
          Y(J)=330.+0.380*REAL(LUZ(J))/T
          IF(X(J).LT.111.)K=J
          IF(X(J).LT.489.)N=J
  27      CONTINUE
        Y(K)=Y(K)+(111.-X(K))*(Y(K+1)-Y(K))/(X(K+1)-X(K))
        Y(N+1)=Y(N)+(490.-X(N))*(Y(N+1)-Y(N))/(X(N+1)-X(N))
        X(K)=111.
        X(N+1)=490.
          DO 28 J=K,N
          WRITE(LP,36)X(J),Y(J),X(J+1),Y(J+1)
  28      CONTINUE
        WRITE(KR,'(F4.2)')0.05*REAL(I)
        IF(KR(1:1).EQ.' ')KR(1:1)='0'
        WRITE(LP,37)KR(1:4),Y(N+1),Y(N+1),Y(N+1)
  29    CONTINUE
      WRITE(LP,30)'showpage XSave restore'
      GOTO 40
  30  FORMAT(A)
  31  FORMAT(/'%%Page:',2I5/'/XSave save def')
  32  FORMAT('(',A,') 12',F7.2,' 315 P',F7.2,' 325',F7.2,' 329 L')
  33  FORMAT('(',A,') 12 92',F7.2,' P',' 105',F7.2,' 109',F7.2,' L')
  34  FORMAT(2F7.2,' E')
  35  FORMAT('2 W',4F7.2,' L 1 W')
  36  FORMAT(4F7.2,' L')
  37  FORMAT('(',A,') 12 508',F7.2,' P',' 491',F7.2,' 495',F7.2,' L')
C
C Output table
C
  38  FORMAT(/' REFLECTION DATA STATISTICS',A//
     +' Systematic absences are taken into account in ',
     +'calculating the percentages.'/' The percentage with ',
     +'I>2sigma is expressed relative to the theoretical number'/
     +' of unique reflections.   R1 = Sum(|Fo-Fc|)/Sum(Fo), ',
     +' s = sigma(I),'/' Scale = Sum(Fo)/Sum(Fc).'//
     +'   Resl. range N(unique) Mean(I/s) %(I>2s)',
     +' %Complete  Scale   R1(all) R1(I>2s)'/)
  39  FORMAT(I7,3F9.2,3F9.3)
  40  KR=' USED TO CALCULATE PLOT'
      K=31
  41  WRITE(*,38)KR(1:K)
      WRITE(LO,38)KR(1:K)
      RES(1)=9.
        DO 44 I=1,L
        T=100./AMAX1(PC(I),0.1)
        IF(I.NE.L-1)GOTO 42
        IF(UN(I).LT.0.1)GOTO 44
  42    U=1./AMAX1(UN(I),0.1)
        KR='    All data'
        IF(I.LT.L)WRITE(KR,'(F7.3,A,F6.3)')AMAX1(DN,RES(I)),
     +  ' >',AMAX1(DN,RES(I+1))
        IF(I.EQ.L-1)WRITE(KR(10:15),'(F6.3)')CELL(13)
        IF(I.EQ.1)KR(1:7)='  inf. '
        WRITE(KR(17:77),39)INT(UN(I)),U*SI(I),T*PO(I),T*UN(I),
     +  SA(I)/AMAX1(0.0001,SC(I)),RA(I)/AMAX1(0.0001,SA(I)),
     +  RO(I)/AMAX1(0.0001,SO(I))
        IF(I.LT.L)GOTO 43
        WRITE(*,'(1X)')
        WRITE(LO,'(1X)')
  43    WRITE(*,'(A)')KR(1:79)
        WRITE(LO,'(A)')KR(1:79)
  44    CONTINUE
      WRITE(LO,'(1X)')
      GOTO 46
C
C Error mesages
C
  45  WRITE(*,'(A)')' ** Corrupted .fcf file **'
      IER=1
  46  RETURN
      END
C
C -------------------------------------------------------------------
C
      SUBROUTINE FCFMAP(MR,MF,EB,A,B,E,G,F,IH,IK,IL,IS)
C
C Create map file for O or Turbo-Frodo.  This version has only been
C tested on SGI and Linux/Intel !  May also be used to generate a .phs
C reflection file for generating a Sigma-A map with XTALVIEW (which
C does not itself calculate such a map).
C
      CHARACTER KS*80,KT*80,KO*1,KW*1
      COMMON/XTAL/SY(12,192),CELL(15),II(1369),NS,LAT,LU,LN,
     +LO,LP,LF,LM,LS,NOS,IER,NPG
      COMMON/WORD/KF,KR,KD,KE,KA,KB,KN,FMT,COL,OPT
      CHARACTER KF*80,KR*80,KD(462)*52,KA(50000)*4,KE(9999)*4,
     +KB(250)*80,KN(10000)*9,FMT*20,COL*4,OPT*1
      REAL EB(4096),A(MR),B(MR),E(MR),F(MR),G(MR),C(7),D(6)
      INTEGER*2 IR(256),IS(MF,8),IB
      INTEGER IH(MR),IK(MR),IL(MR),IG(9),IZ(16)
      EQUIVALENCE(IB,BB)
C
C BB needs to be declared as INTEGER*1 on some systems
C
      BYTE BB(2)
C
C Open PDB file for defining real space area of interest
C
      IF(OPT.EQ.'X')GOTO 26
      KF(LN+1:LN+4)='.pdb'
   1  WRITE(*,FMT)' Enter name of PDB file ['//KF(1:LN+4)//']: '
      KR=' '
      READ(*,'(A)',ERR=1,END=1)KR
      CALL LINTRM(KR,L)
   2  N=0
        DO 3 I=1,L
        IF(KR(I:I).EQ.' ')GOTO 3
        N=N+1
        KR(N:N)=KR(I:I)
   3    CONTINUE
      IF(N.GT.0)GOTO 4
      KR=KF
      N=LN+4
      GOTO 5
   4  IF(INDEX(KR,'.').NE.0)GOTO 5
      N=N+4
      KR(N-3:N)='.pdb'
   5  OPEN(UNIT=LS,FILE=KR(1:N),STATUS='OLD',ERR=25)
        DO 6 I=1,9
        IG(I)=0
   6    CONTINUE
C
C Scan PDB file to find SCALE cards
C
   7  KR=' '
      READ(LS,'(A)',ERR=7,END=10)KR
      CALL LINTRM(KR,I)
      IF(KR(1:6).NE.'SCALE1')GOTO 8
      READ(KR,'(10X,3F10.6,5X,F10.5)',ERR=10,END=10)(EB(I),I=1,4)
   8  IF(KR(1:6).NE.'SCALE2')GOTO 9
      READ(KR,'(10X,3F10.6,5X,F10.5)',ERR=10,END=10)(EB(I),I=5,8)
   9  IF(KR(1:6).NE.'SCALE3')GOTO 7
      READ(KR,'(10X,3F10.6,5X,F10.5)',ERR=10,END=10)(EB(I),I=9,12)
      GOTO 13
  10  WRITE(*,'(A)')' SCALE instructions not found in PDB file'
     +//' - default transformation applied'
        DO 11 I=1,12
        EB(I)=0.
  11    CONTINUE
        DO 12 I=1,3
        T=0.0174533*CELL(I+3)
        C(I)=SIN(T)
        C(I+3)=COS(T)
  12    CONTINUE
      T=1./SQRT(1.-C(4)**2-C(5)**2-C(6)**2+2.*C(4)*C(5)*C(6))
      EB(1)=1./CELL(1)
      EB(2)=-EB(1)*C(6)/C(3)
      EB(3)=EB(1)*T*(C(4)*C(6)-C(5))/C(3)
      EB(6)=1./(CELL(2)*C(3))
      EB(7)=EB(6)*T*(C(5)*C(6)-C(4))
      EB(11)=T*C(3)/CELL(3)
      REWIND LS
C
C Scan PDB file to determine limits
C
  13    DO 14 I=1,3
        D(I)=9.E9
        D(I+3)=-9.E9
  14    CONTINUE
      KO='?'
      KW='?'
  15  KR=' '
      READ(LS,'(A)',ERR=15,END=24)KR
      CALL LINTRM(KR,I)
      IF(KR(1:4).EQ.'ATOM')GOTO 16
      IF(KR(1:6).NE.'HETATM')GOTO 15
  16  IF(KR(14:20).NE.'O   HOH')GOTO 19
      IF(KO.NE.'?')GOTO 18
  17  KO=' '
      WRITE(*,FMT)' Include all waters in the volume covered by map'
     +//'? [Y]: '
      READ(*,'(A)',ERR=17,END=17)KO
      IF(KO.EQ.'n')KO='N'
      IF(KO.EQ.'y'.OR.KO.EQ.' ')KO='Y'
      IF(KO.NE.'N'.AND.KO.NE.'Y')GOTO 17
  18  IF(KO.NE.'Y')GOTO 15
  19  IF(KR(14:20).NE.'W   HOH')GOTO 22
      IF(KW.NE.'?')GOTO 21
  20  KW=' '
      WRITE(*,FMT)' Include all peaks in the volume covered by map'
     +//'? [N]: '
      READ(*,'(A)',ERR=20,END=20)KW
      IF(KW.EQ.'n')KW='N'
      IF(KW.EQ.' '.OR.KW.EQ.'y')KW='Y'
      IF(KW.NE.'N'.AND.KW.NE.'Y')GOTO 20
  21  IF(KW.NE.'Y')GOTO 15
  22  READ(KR,'(30X,3F8.3)')U,V,W
      C(1)=U*EB(1)+V*EB(2)+W*EB(3)+EB(4)
      C(2)=U*EB(5)+V*EB(6)+W*EB(7)+EB(8)
      C(3)=U*EB(9)+V*EB(10)+W*EB(11)+EB(12)
        DO 23 I=1,3
        D(I)=AMIN1(D(I),C(I))
        D(I+3)=AMAX1(D(I+3),C(I))
  23    CONTINUE
      GOTO 15
C
C Trouble with PDB file
C
  24  CLOSE(LS,IOSTAT=I)
      IF(D(1).LT.8.E9)GOTO 26
  25  KR=' '
      WRITE(*,FMT)' Problems with .pdb file.  Enter new name or '
     +//'<Enter> to skip: '
      READ(*,'(A)',ERR=25,END=25)KR
      CALL LINTRM(KR,I)
      IF(I.NE.0)GOTO 2
      IG(9)=-1
C
C Eliminate lattice and inversion operators
C
  26  I=0
  27  I=I+1
      IF(I.GT.NS)GOTO 32
      N=I
  28  N=N+1
  29  IF(N.GT.NS)GOTO 27
      U=0.
      V=0.
        DO 30 J=1,9
        U=U+ABS(SY(J,N)-SY(J,I))
        V=V+ABS(SY(J,N)+SY(J,I))
  30    CONTINUE
      IF(AMIN1(U,V).GT.0.01)GOTO 28
        DO 31 J=1,12
        SY(J,N)=SY(J,NS)
  31    CONTINUE
      NS=NS-1
      GOTO 29
C
C Number of grid points in each direction
C
  32  IF(OPT.EQ.'X')GOTO 44
      L=INT(3.*CELL(1)/CELL(13))
      IG(1)=1
  33  IG(1)=IG(1)*2
      IF(IG(1).LT.L)GOTO 33
      L=INT(3.*CELL(2)/CELL(13))
      IG(2)=1
  34  IG(2)=IG(2)*2
      IF(IG(2).LT.L)GOTO 34
      IG(3)=8*INT(.5*CELL(3)/CELL(13))
      KR=' '
      WRITE(KR,'(I6,A1,I5,A1,I5)')IG(1),'/',IG(2),'/',IG(3)
      KS=' ['
      L=2
        DO 35 I=1,18
        IF(KR(I:I).EQ.' ')GOTO 35
        IF(KR(I:I).EQ.CHAR(13))GOTO 35
        L=L+1
        KS(L:L)=KR(I:I)
        IF(KS(L:L).EQ.'/')KS(L:L)=' '
  35    CONTINUE
  36  WRITE(*,'(A)')' Number of grid points per cell in x, y and z'
     +//' (the first two MUST be powers of'
      WRITE(*,FMT)
     +' 2, and the last MUST be a multiple of 8)'//KS(1:L)//']: '
      KR=' '
      READ(*,'(A)',ERR=36,END=36)KR
      CALL LINTRM(KR,I)
      IF(I.EQ.0)KR(3:80)=KS(3:80)
      READ(KR,*,ERR=36,END=36)N1,N2,N3
      I=1
  37  IF(I.GT.N1)GOTO 36
      I=I*2
      IF(I.NE.N1)GOTO 37
      I=1
  38  IF(I.GT.N2)GOTO 36
      I=I*2
      IF(I.NE.N2)GOTO 38
      IF(N3.NE.8*(N3/8))GOTO 36
      N4=2*N1*N2
      IF(N4.GT.MR)GOTO 113
      IG(1)=N1
      IG(2)=N2
      IG(3)=N3
      WRITE(LO,'(A,3I5)')' Number of grid points per cell in x, y'
     +//' and z:',N1,N2,N3
C
C Define real space extent of map
C
      L=1
      KR='?'
      IF(IG(9).LT.0)GOTO 40
        DO 39 I=1,3
        IG(I+3)=8*INT(0.125*REAL(IG(I))*(D(I)-5./CELL(I)))
        IG(I+6)=8+8*INT(0.125*REAL(IG(I))*(D(I+3)-D(I)+10./CELL(I)))
  39    CONTINUE
      WRITE(KR,'(I6,A1,I5,A1,I5)')IG(4),'/',IG(5),'/',IG(6)
  40  KS=' ['
      L=2
        DO 41 I=1,18
        IF(KR(I:I).EQ.' ')GOTO 41
        IF(KR(I:I).EQ.CHAR(13))GOTO 41
        L=L+1
        KS(L:L)=KR(I:I)
        IF(KS(L:L).EQ.'/')KS(L:L)=' '
  41    CONTINUE
      WRITE(*,'(A)')' Origin of map along x, y and z (grid points)'
     +//KS(1:L)//']'
      WRITE(*,FMT)' (must all be multiples of 8): '
      KR=' '
      READ(*,'(A)',ERR=40,END=40)KR
      CALL LINTRM(KR,I)
      IF(I.EQ.0)KR(3:80)=KS(3:80)
      READ(KR,*,ERR=40,END=40)I1,I2,I3
      IF(MOD(I1,8)+MOD(I2,8)+MOD(I3,8).NE.0)GOTO 40
      WRITE(LO,'(A,3I5)')' Origin of map along x, y and z '//
     +'(grid points):',I1,I2,I3
      KR=' '
      L=1
      IF(IG(9).LT.0)GOTO 43
      WRITE(KR,'(I6,A1,I5,A1,I5)')IG(7),'/',IG(8),'/',IG(9)
      KS=' ['
      L=2
        DO 42 I=1,18
        IF(KR(I:I).EQ.' ')GOTO 42
        IF(KR(I:I).EQ.CHAR(13))GOTO 42
        L=L+1
        KS(L:L)=KR(I:I)
        IF(KS(L:L).EQ.'/')KS(L:L)=' '
  42    CONTINUE
  43  WRITE(*,'(A)')' Extent of map along x, y and z (grid points)'
     +//KS(1:L)//']'
      WRITE(*,FMT)' (must all be multiples of 8): '
      KR=' '
      READ(*,'(A)',ERR=43,END=43)KR
      CALL LINTRM(KR,I)
      IF(I.EQ.0)KR(3:80)=KS(3:80)
      READ(KR,*,ERR=43,END=43)L1,L2,L3
      IF(MOD(L1,8)+MOD(L2,8)+MOD(L3,8).NE.0)GOTO 43
      L4=L1*L2
      IF(L4.GT.MF)GOTO 113
      WRITE(LO,'(A,3I5/)')' Extent of map along x, y and z (grid '
     +//'points):',L1,L2,L3
C
C Set Fourier type
C
  44  WRITE(*,'(A)')' Fourier type (-3=mFo-DFc (Sigma-A difference '
     +//'map), -2=2mFo-DFc (Sigma-A map),'
      WRITE(*,FMT)' -1=Fo-Fc, 0=Fc, 1=Fo, 2=2Fo-Fc, n=nFo-(n-1)Fc '
     +//'[-2]: '
      KR=' '
      READ(*,'(A)',ERR=44,END=44)KR
      CALL LINTRM(KR,I)
      IF(I.EQ.0)KR='-2'
      READ(KR,*,ERR=44,END=44)NF
      IF(NF.LT.-3)GOTO 44
      IF(NF.GT.9)GOTO 44
      SR=1.
      SC=2./CELL(15)
      FZ=0.5*CELL(14)
      IF(NF.EQ.-1.OR.NF.EQ.-3)FZ=0.
      KS='Fc$'
      IF(NF.GT.1)WRITE(KS,'(I1,A,I1,A)')NF,'Fo-',NF-1,'Fc$'
      IF(NF.EQ.2)KS(5:8)='Fc$ '
      IF(NF.EQ.1)KS='Fo$'
      IF(NF.EQ.-1)KS='Fo-Fc$'
      KT='fc.map'
      IF(NF.GT.1)WRITE(KT,'(I1,A,I1,A)')NF,'fo',NF-1,'fc.map'
      IF(NF.EQ.2)KT(4:10)='fc.map '
      IF(NF.EQ.1)KT='fo.map'
      IF(NF.EQ.-1)KT='fofc.map'
      IF(NF.GT.-2)GOTO 46
      KS='2mFo-DFc (Sigma-A)$'
      KT='sigmaa.map'
      IF(NF.NE.-3)GOTO 45
      KS(1:1)=' '
      KT(6:6)='d'
  45  WRITE(*,FMT)' Enter reference/working set Sigma-A ratio from'
     +//' SHELXL [0.97]: '
      KR=' '
      READ(*,'(A)',ERR=45,END=45)KR
      CALL LINTRM(KR,I)
      IF(I.EQ.0)KR='0.97'
      READ(KR,*,ERR=45,END=45)SR
      IF(SR.LT.0.01)GOTO 45
      IF(SR.GT.1.)SR=1.
  46  WRITE(*,FMT)' Apply sharpening (Y or N) ? [N]: '
      KR=' '
      READ(*,'(A)',ERR=46,END=46)KR
      MG=0
      IF(INDEX(KR,'Y')+INDEX(KR,'y').NE.0)MG=1
      M=INDEX(KT,'.')+3
      IF(MG.EQ.0)GOTO 47
      WRITE(LO,'(A)')' Coefficients sharpened by factor '
     +//' <F^2(shell)>^-0.25'
      M=M+2
      KT(M-5:M)='-s.map'
C
C Set up map and scratch files
C
  47  IF(OPT.EQ.'X')GOTO 58
      NTS=2-MOD(NOS,2)
  48  WRITE(KR,'(I1)')NTS
      WRITE(*,FMT)' Relative endian code for target computer (1-4) ['
     +//KR(1:1)//']: '
      READ(*,'(A)',ERR=48,END=48)KR
      CALL LINTRM(KR,I)
      IF(I.GT.0)READ(KR,*,ERR=48,END=48)NTS
      IF(NTS.LT.1.OR.NTS.GT.4)GOTO 48
      WRITE(*,FMT)' Enter name of map file ['//KT(1:M)//']: '
      KR=' '
      READ(*,'(A)',ERR=114,END=114)KR
      CALL LINTRM(KR,I)
  49  N=0
        DO 50 I=1,80
        IF(KR(I:I).EQ.' ')GOTO 50
        N=N+1
        KR(N:N)=KR(I:I)
  50    CONTINUE
      IF(N.GT.0)GOTO 51
      KR=KT
      N=M
      GOTO 52
  51  IF(INDEX(KR(1:N),'.').NE.0)GOTO 52
      N=N+4
      KR(N-3:N)='.map'
  52  IF(NOS.EQ.2)GOTO 53
      OPEN(LM,FILE=KR(1:N),STATUS='OLD',IOSTAT=I)
      CLOSE(LM,STATUS='DELETE',IOSTAT=I)
  53  M=128
      IF(NOS.EQ.1.OR.NOS.EQ.4)M=512
      OPEN(LM,FILE=KR(1:N),STATUS='NEW',ACCESS='DIRECT',RECL=M,
     +FORM='UNFORMATTED',ERR=114)
      L=INDEX(KS,'$')-1
      WRITE(LO,'(1X,A,A)')KS(1:L),' map written to file '//KR(1:N)
      I=INT(REAL(L1)*REAL(L2)*REAL(L3)/262144.+1.)
  54  WRITE(*,'(A,I4,A)')' A',I,'MB scratch file will be created.'
     +//'  Enter filename if you do not wish to'
      WRITE(*,FMT)' create it in the current directory, else <CR>: '
      KR=' '
      READ(*,'(A)',ERR=54,END=54)KR
      CALL LINTRM(KR,I)
      L=0
        DO 55 I=1,80
        IF(KR(I:I).NE.' ')L=I
  55    CONTINUE
      IF(L.EQ.0)GOTO 57
      IF(NOS.EQ.2)GOTO 56
      OPEN(LS,FILE=KR(1:L),STATUS='OLD',IOSTAT=I)
      CLOSE(LS,STATUS='DELETE',IOSTAT=I)
  56  OPEN(LS,FILE=KR(1:L),STATUS='NEW',FORM='UNFORMATTED',ERR=54)
      GOTO 63
  57  CLOSE(LS,IOSTAT=I)
      OPEN(LS,STATUS='SCRATCH',FORM='UNFORMATTED',ERR=116)
      GOTO 63
C
C Open file for input to XTALVIEW
C
  58  KT(M-2:M)='phs'
      WRITE(*,FMT)' Enter name of file for input to XTALVIEW ['
     +//KT(1:M)//']: '
      KR=' '
      READ(*,'(A)',ERR=114,END=114)KR
      CALL LINTRM(KR,I)
  59  N=0
        DO 60 I=1,80
        IF(KR(I:I).EQ.' ')GOTO 60
        N=N+1
        KR(N:N)=KR(I:I)
  60    CONTINUE
      IF(N.GT.0)GOTO 61
      KR=KT
      N=M
      GOTO 62
  61  IF(INDEX(KR(1:N),'.').NE.0)GOTO 62
      N=N+4
      KR(N-3:N)='.phs'
  62  CALL WROPEN(LM,KR,N,IER)
      IF(IER.NE.0)GOTO 114
C
C Read in phased reflection file
C
  63  RR=10.*CELL(13)**2
        DO 64 I=1,60
        EB(I)=0.
  64    CONTINUE
      ML=0
      NR=0
  65  KR=' '
      READ(LF,'(A)',ERR=65,END=68)KR
      CALL LINTRM(KR,I)
      READ(KR,*,ERR=65,END=65)C
      IF(C(6).LT.1.E-4)GOTO 65
      NR=NR+1
      IF(NR.GT.MR)GOTO 113
      IH(NR)=INT(1.0001*C(1))
      IK(NR)=INT(1.0001*C(2))
      IL(NR)=INT(1.0001*C(3))
      F(NR)=C(4)
      E(NR)=C(5)
      A(NR)=COS(0.0174533*C(7))*C(6)
      B(NR)=SIN(0.0174533*C(7))*C(6)
      W=0.
      U=0.
        DO 66 J=1,NS
        L=INT(1.0001*(C(1)*SY(1,J)+C(2)*SY(4,J)+C(3)*SY(7,J)))
        M=INT(1.0001*(C(1)*SY(2,J)+C(2)*SY(5,J)+C(3)*SY(8,J)))
        N=INT(1.0001*(C(1)*SY(3,J)+C(2)*SY(6,J)+C(3)*SY(9,J)))
        IF(IABS(L-INT(1.0001*C(1)))+IABS(M-INT(1.0001*C(2)))
     +  +IABS(N-INT(1.0001*C(3))).EQ.0)W=W+1.
        S=0.
        IF(IABS(L+INT(1.0001*C(1)))+IABS(M+INT(1.0001*C(2)))
     +  +IABS(N+INT(1.0001*C(3))).EQ.0)S=1.
        IF(LAT.GT.0)W=W+S
        IF(LAT.LT.0)U=U+S
  66    CONTINUE
      V=RR*(CELL(7)*C(1)**2+CELL(8)*C(2)**2+CELL(9)*C(3)**2+
     +CELL(10)*C(2)*C(3)+CELL(11)*C(1)*C(3)+CELL(12)*C(1)*C(2))
      I=MIN0(INT(V),9)
      V=V-REAL(I)
      S=C(4)/W
      T=C(6)**2/W
      IF(LAT.GT.0.OR.U.GT.0.5)W=-W
      G(NR)=W
      EB(I+1)=EB(I+1)+(1.-V)*S
      EB(I+2)=EB(I+2)+V*S
      EB(I+12)=EB(I+12)+1.-V
      EB(I+13)=EB(I+13)+V
      EB(I+23)=EB(I+23)+(1.-V)*T
      EB(I+24)=EB(I+24)+V*T
      GOTO 65
C
C Normalize structure factors and derive Sigma-A and D
C
  67  FORMAT(' Sigma-A as a function of resolution in Angstroms'/
     +10X,'Infinity',10F6.2/' Effective N',11I6)
  68  IF(NR.EQ.0)GOTO 117
      IF(NF.LT.-1)WRITE(LO,67)(SQRT(RR/REAL(I)),I=1,10),
     +(INT(.5+EB(I)),I=12,22)
        DO 69 I=1,11
        EB(I)=SQRT(EB(I+11)/AMAX1(0.01,EB(I)))
        EB(I+11)=SQRT(EB(I+11)/AMAX1(0.01,EB(I+22)))
        EB(I+22)=0.
  69    CONTINUE
        DO 70 I=1,NR
        U=RR*(CELL(7)*REAL(IH(I))**2+CELL(8)*REAL(IK(I))**2+CELL(9)
     +  *REAL(IL(I))**2+CELL(10)*REAL(IK(I))*REAL(IL(I))+CELL(11)*
     +  REAL(IH(I))*REAL(IL(I))+CELL(12)*REAL(IH(I))*REAL(IK(I)))
        J=MIN0(INT(U),9)
        U=U-REAL(J)
        T=1.-U
        P=F(I)*(T*EB(J+1)+U*EB(J+2))**2/ABS(G(I))-1.
        Q=(A(I)**2+B(I)**2)*(T*EB(J+12)+U*EB(J+13))**2/ABS(G(I))-1.
        EB(J+23)=EB(J+23)+T*P*Q
        EB(J+24)=EB(J+24)+U*P*Q
        EB(J+34)=EB(J+34)+T*P**2
        EB(J+35)=EB(J+35)+U*P**2
        EB(J+45)=EB(J+45)+T*Q**2
        EB(J+46)=EB(J+46)+U*Q**2
  70    CONTINUE
        DO 71 I=1,11
        EB(I+22)=SQRT(AMAX1(0.0001,EB(I+22)/AMAX1(0.01,SQRT(EB(I+33)*
     +  EB(I+44)))))*SR
  71    CONTINUE
      IF(NF.LT.-1)WRITE(LO,'(A,11F6.3)')' Sigma-A    ',(EB(I),I=23,33)
        DO 72 I=25,31
        EB(56)=EB(56)+1.
        T=REAL(I-23)
        EB(57)=EB(57)+T
        EB(58)=EB(58)+T**2
        S=ALOG(EB(I))
        EB(59)=EB(59)+S
        EB(60)=EB(60)+S*T
  72    CONTINUE
      PF=EXP((EB(59)*EB(58)-EB(60)*EB(57))/(EB(56)*EB(58)-EB(57)**2))
      IF(NF.GT.-2)GOTO 73
      WRITE(LO,'(A,F6.3,A)')' These values include a factor of',SR,
     +' to compensate for overfitting'
      WRITE(LO,'(/A,F6.3)')' Estimated fraction of scattering power '
     +//'accounted for =',PF
C
C Weights and Fourier coefficients
C
  73  NJ=NR
        DO 83 I=1,NJ
        U=REAL(IH(I))
        V=REAL(IK(I))
        W=REAL(IL(I))
        R=RR*(CELL(7)*U**2+CELL(8)*V**2+CELL(9)*W**2+CELL(10)*V*W+
     +  CELL(11)*U*W+CELL(12)*U*V)
        JJ=MIN0(INT(R),9)
        R=R-REAL(JJ)
        FO=SQRT(F(I))
        FF=A(I)**2+B(I)**2
        FC=SQRT(FF)
        S=REAL(NF)*FO-REAL(NF-1)*FC
        IF(NF.GE.0)GOTO 75
        S=FO-FC
        IF(NF.EQ.-1)GOTO 75
        S=AMIN1(0.999,(1.-R)*EB(JJ+23)+R*EB(JJ+24))
        T=2.*S*FO*FC*((1.-R)*EB(JJ+1)+R*EB(JJ+2))*
     +  ((1.-R)*EB(JJ+12)+R*EB(JJ+13))/ABS(G(I)*(1.-S**2))
        IF(G(I).GT.0.)GOTO 74
        S=FO
        IF(NF.EQ.-3)S=FO-FC
        IF(T.LT.10.)S=S*(EXP(T)-1.)/(EXP(T)+1.)
        GOTO 75
  74    WF=1.
        IF(NF.EQ.-2)WF=2.
        S=WF*AMIN1(T*(.5658+T*(T*.0106-.1304)),T/(.56+T))*FO-S*FC/PF
  75    IF(MG.GT.0)S=S*SQRT((1.-R)*EB(JJ+1)+R*EB(JJ+2))
        R=S*FF*FC/(FF**2+E(I)**2)
C
C XTALVIEW output
C
        IF(OPT.NE.'X')GOTO 78
        S=R*FC
        T=AMOD(720.+57.2957795*ATAN2(B(I),A(I)),360.)
        IF(S.LT.0.)T=AMOD(T+180.,360.)
        WRITE(KR,77)IH(I),IK(I),IL(I),ABS(S),T
        L=0
          DO 76 J=1,43
          IF(KR(J:J).EQ.' ')GOTO 76
          L=L+1
          KR(L:L)=KR(J:J)
          IF(KR(L:L).EQ.'$')KR(L:L)=' '
  76      CONTINUE
        WRITE(LM,'(A)')KR(1:L)
        GOTO 83
  77    FORMAT(3(I5,'$'),F14.3,'$1.0$',F6.1)
C
C Expand to triclinic
C
  78    NI=NR
          DO 82 J=1,NS
          L=INT(1.0001*(U*SY(1,J)+V*SY(4,J)+W*SY(7,J)))
          M=INT(1.0001*(U*SY(2,J)+V*SY(5,J)+W*SY(8,J)))
          N=INT(1.0001*(U*SY(3,J)+V*SY(6,J)+W*SY(9,J)))
          S=6.283185
          FB=B(I)
          K=N
          IF(K.EQ.0)K=M
          IF(K.EQ.0)K=L
          IF(K.GE.0)GOTO 79
          S=-S
          FB=-FB
          L=-L
          M=-M
          N=-N
  79      K=NR
  80      K=K+1
          IF(K.GT.NI)GOTO 81
          IF(IH(K).NE.L)GOTO 80
          IF(IK(K).NE.M)GOTO 80
          IF(IL(K).NE.N)GOTO 80
          GOTO 82
  81      NI=NI+1
          IF(NI.GT.MR)GOTO 113
          IH(NI)=L
          IK(NI)=M
          IL(NI)=N
          ML=MAX0(ML,N)
          T=S*(U*SY(10,J)+V*SY(11,J)+W*SY(12,J))
          Q=R*SIN(T)
          T=R*COS(T)
          A(NI)=A(I)*T+FB*Q
          B(NI)=FB*T-A(I)*Q
  82      CONTINUE
        IH(I)=IH(NI)
        IK(I)=IK(NI)
        IL(I)=IL(NI)
        A(I)=A(NI)
        B(I)=B(NI)
        NR=NI-1
  83    CONTINUE
      IF(OPT.EQ.'X')GOTO 118
C
C Set up Fourier grid etc.
C
      T=SQRT(CELL(14))
      IF(MG.NE.0)FZ=0.5*T*SQRT(T)
      DL=6.283185/REAL(N3)
        DO 84 N=1,NR
        L=IH(N)
        IF(L.LT.0)L=L+N1
        M=IK(N)
        IF(M.LT.0)M=M+N2
        IH(N)=2*(L+M*N1)+1
  84    CONTINUE
        DO 85 I=1,16
        IZ(I)=0
  85    CONTINUE
C
C Sort reflection array into order for fastest FFT
C
      K=0
        DO 87 M=0,ML
        L=K
  86    L=L+1
        IF(L.GT.NR)GOTO 87
        IF(IL(L).NE.M)GOTO 86
        K=K+1
        IF(K.EQ.L)GOTO 86
        J=IH(K)
        IH(K)=IH(L)
        IH(L)=J
        J=IL(K)
        IL(K)=M
        IL(L)=J
        T=A(K)
        A(K)=A(L)
        A(L)=T
        T=B(K)
        B(K)=B(L)
        B(L)=T
        GOTO 86
  87    CONTINUE
C
C Outer loop over layers perpendicular to ab-plane - sum complex
C coefficients and Fourier transform one layer
C
      ZL=REAL(I3-1)*DL
      DM=-9.E9
      DN=9.E9
      DS=0.
      SN=0.
      NB=0
      KR=' '
        DO 94 NL=1,L3
        ZL=ZL+DL
          DO 88 I=1,N4
          E(I)=0.
  88      CONTINUE
        L=0
        U=1.
        V=0.
          DO 90 N=1,NR
          IF(IL(N).EQ.L)GOTO 89
          L=IL(N)
          T=ZL*REAL(L)
          U=COS(T)
          V=SIN(T)
  89      I=IH(N)
          E(I)=E(I)+U*A(N)+V*B(N)
          E(I+1)=E(I+1)+V*A(N)-U*B(N)
  90      CONTINUE
        CALL SXFT(E,N1,N2,1)
C
C Set up block of data relative to chosen origin; scale and find
C maximum, minimum and sigma of electron density; output to scratch
C
        M1=100*N1+I1-1
        M2=100*N2+I2-1
          DO 93 J=1,L2
          N=MOD(J+M2,N2)*N1*2+1
            DO 92 I=1,L1
            NB=NB+1
            IF(NB.LT.4097)GOTO 91
            WRITE(LS)EB
            NB=1
  91        T=SC*(E(2*MOD(I+M1,N1)+N)+FZ)
            EB(NB)=T
            IF(DM.LT.T)DM=T
            IF(DN.GT.T)DN=T
            DS=DS+T**2
            SN=SN+1.
  92        CONTINUE
  93      CONTINUE
  94    CONTINUE
      WRITE(LS)EB
      REWIND LS
C
C Output ranges
C
  95  FORMAT(/' Maximum electron density =',F7.2,' eA^-3 =',F7.2,
     +' sigma'/' Minimum electron density =',F7.2,' eA^-3 =',F7.2,
     +' sigma'/' Rms electron density (sigma) =',F8.3,' eA^-3')
      DS=SQRT(DS/SN)
      WRITE(*,95)DM,DM/DS,DN,DN/DS,DS
      WRITE(LO,95)DM,DM/DS,DN,DN/DS,DS
      IF(MG.GT.0)WRITE(LO,'(/A)')' Because of sharpening, the '//
     +'electron density scale is arbitrary'
C
C Write header record of .map file
C
        DO 96 I=1,256
        IR(I)=0
  96    CONTINUE
      IR(1)=I1
      IR(2)=I2
      IR(3)=I3
      IR(4)=L1
      IR(5)=L2
      IR(6)=L3
      IR(7)=N1
      IR(8)=N2
      IR(9)=N3
      P=80.
      IF(OPT.EQ.'W')P=100.
        DO 97 I=1,6
        IR(I+9)=INT(P*CELL(I)+.5)
  97    CONTINUE
      P=0.01*AINT(25500./(DM-DN))
      Q=AINT(-P*DN)
      IR(16)=INT(25500.*DS/(DM-DN))
      IR(17)=INT(Q)
      IF(OPT.EQ.'W')GOTO 98
      IR(18)=80
      IR(19)=100
C
C Skip following loop for SGI byte order
C
  98  IF(NTS.EQ.1.OR.NTS.EQ.4)GOTO 100
        DO 99 I=1,19
        IB=IR(I)
        J=BB(1)
        BB(1)=BB(2)
        BB(2)=J
        IR(I)=IB
  99    CONTINUE
 100  NR=1
      WRITE(LM,REC=NR)IR
C
C Read back slab of 8 layers in Z and scale to 0-255 range
C
      NB=4096
        DO 109 NL=1,L3,8
          DO 103 L=1,8
          J=0
            DO 102 I=1,L4
            J=J+1
            NB=NB+1
            IF(NB.LT.4097)GOTO 101
            READ(LS)EB
            NB=1
 101        IS(J,L)=INT(EB(NB)*P+Q)
 102        CONTINUE
 103      CONTINUE
C
C Pack into 8x8x8-byte 'bricks' for .map file
C
          DO 108 J=0,L2-1,8
          JZ=J+7
            DO 107 K=1,L1,8
            KZ=K+7
            N=0
              DO 106 I=1,8
                DO 105 JJ=J,JZ
                M=JJ*L1+K
                L=0
                  DO 104 KK=K,KZ
                  N=N+L
                  IF(NTS.LT.3)L=1-L
                  BB(L+1)=IS(M,I)
                  NK=IS(M,I)/16+1
                  IZ(NK)=IZ(NK)+1
                  IF(NTS.GT.2)L=1-L
                  IF(L.EQ.0)IR(N)=IB
                  M=M+1
 104              CONTINUE
 105            CONTINUE
 106          CONTINUE
            NR=NR+1
            WRITE(LM,REC=NR)IR
 107        CONTINUE
 108      CONTINUE
 109    CONTINUE
C
C Output density histogram
C
      WRITE(*,111)
      WRITE(LO,111)
      U=DN
        DO 110 I=1,16
        V=(REAL(I*16)-Q)/P
        WRITE(*,112)IZ(I),U,V,U/DS,V/DS
        WRITE(LO,112)IZ(I),U,V,U/DS,V/DS
        U=V
 110    CONTINUE
      GOTO 118
 111  FORMAT(/' Electron density histogram'/'   #Points      ED',
     +' in eA^-3      ED in sigma units')
 112  FORMAT(I9,F11.3,' -',F7.3,F11.3,' -',F7.3)
C
C Error exits
C
 113  WRITE(*,'(/A/)')' ** Memory too small for Fourier '//
     +'calculation **'
      GOTO 118
 114  WRITE(*,'(/A/)')' ** Cannot open file '//KR(1:N)//' **'
 115  WRITE(*,FMT)' Enter new filename (<Enter> to return to'//
     +' main menu): '
      READ(*,'(A)',ERR=115,END=115)KR
      CALL LINTRM(KR,I)
      IF(I.EQ.0)GOTO 118
      IF(OPT.EQ.'X')GOTO 59
      GOTO 49
 116  WRITE(*,'(/A/)')' ** Cannot open scratch file **'
      GOTO 118
 117  WRITE(*,'(/A/)')' ** Corrupted .fcf file **'
 118  CLOSE(LS,STATUS='DELETE',IOSTAT=I)
      CLOSE(LM,IOSTAT=I)
      END
C
C -------------------------------------------------------------------
C
      SUBROUTINE LST2PS(MA,UM,AM,US,AS,EM,EN,ES,ET,IC,IS,A)
C
C Read SHELXL .lst file and prepare Postscript displays as a fuction
C of residue number
C
      COMMON/XTAL/SY(12,192),CELL(15),II(1369),NS,LAT,LU,LN,
     +LO,LP,LF,LM,LS,NOS,IER,NPG
      COMMON/WORD/KF,KR,KD,KE,KA,KB,KN,FMT,COL,OPT
      CHARACTER KF*80,KR*80,KD(462)*52,KA(50000)*4,KE(9999)*4,KG*1,
     +KB(250)*80,KN(10000)*9,FMT*20,COL*4,OPT*1,KT*80,KK*80,KS*3,
     +KQ*80,KH*2
      REAL D(6),UM(10000),AM(10000),US(10000),AS(10000),A(MA)
      REAL EM(10000),EN(10000),ES(10000),ET(10000)
      INTEGER IS(MA),IC(10000),IN(50)
C
      IER=0
      MB=10000
      MR=0
      BM=20.0001
      EE=0.05
      NA=-2
        DO 1 I=1,9999
        UM(I)=-1.
        US(I)=-1.
        AM(I)=-1.
        AS(I)=-1.
        EM(I)=0.
        EN(I)=0.
        ES(I)=0.
        ET(I)=0.
        IC(I)=7
        IS(I)=2
   1    CONTINUE
C
C Set up .lst file for reading
C
      KF(LN+1:LN+4)='.lst'
   2  WRITE(*,FMT)' Name of .lst file created using SHELXL ['
     +//KF(1:LN+4)//']: '
      READ(*,'(A)',ERR=2,END=2)KR
      CALL LINTRM(KR,N)
      L=0
      M=0
        DO 3 I=1,N
        IF(KR(I:I).EQ.'.')M=I
        IF(KR(I:I).EQ.' ')GOTO 3
        L=L+1
        KR(L:L)=KR(I:I)
   3    CONTINUE
      IF(M.NE.0)GOTO 5
      IF(L.NE.0)GOTO 4
      KR=KF
      L=LN
   4  L=L+4
      KR(L-3:L)='.lst'
   5  OPEN(LF,FILE=KR(1:L),STATUS='OLD',ERR=24)
      WRITE(LO,27)'Reading file '//KR(1:L)
C
C Extract information from .lst file
C
   6  KR=' '
      READ(LF,'(A)',ERR=22,END=22)KR
      CALL LINTRM(KR,I)
      IF(OPT.EQ.'T')GOTO 10
      I=INDEX(KR,'Dihedral angle')
      IF(I.EQ.0)GOTO 10
      J=0
      IF(KR(I+15:I+18).EQ.'PHI ')J=1
      IF(KR(I+15:I+18).EQ.'PSI ')J=2
      IF(OPT.EQ.'K'.OR.OPT.EQ.'R')GOTO 7
      IF(KR(I+15:I+18).EQ.'OMEG')J=3
      IF(KR(I+15:I+18).EQ.'CHI ')J=4
      IF(KR(I+15:I+18).EQ.'CHI1')J=4
      IF(KR(I+15:I+18).EQ.'CHI2')J=5
      IF(KR(I+15:I+18).EQ.'CHI3')J=6
      IF(KR(I+15:I+18).EQ.'CHI4')J=7
   7  IF(J.EQ.0)GOTO 6
      READ(LF,'(A)',ERR=23,END=23)KT
   8  READ(LF,'(A)',ERR=23,END=23)KT
      CALL LINTRM(KT,N)
      I=INDEX(KT,'_')
      IF(I.EQ.0)GOTO 6
      IF(INDEX(KT,'b ')+INDEX(KT,'c ')+INDEX(KT,'d ').GT.0)GOTO 8
      READ(KT(I+1:N+1),*,ERR=23,END=23)K
      NA=NA+3
      IF(NA+2.GT.MA)GOTO 26
      A(NA)=REAL(K)
      A(NA+1)=REAL(J)
      READ(KT(1:I),*,ERR=23,END=23)A(NA+2)
      IF(J.EQ.6.AND.KT(I-3:I-1).EQ.'Glu')GOTO 9
      IF(J.NE.5)GOTO 8
      IF(KT(I-3:I-1).EQ.'Asp')GOTO 9
      IF(KT(I-3:I-1).EQ.'Phe')GOTO 9
      IF(KT(I-3:I-1).NE.'Tyr')GOTO 8
   9  A(NA+1)=-A(NA+1)
      GOTO 8
  10  IF(KR(1:5).NE.' ATOM'.AND.KR(1:5).NE.'ATOM ')GOTO 17
  11  J=-1
  12  READ(LF,'(A)',ERR=23,END=23)KR
      IF(INDEX(KR,'Final').NE.0)GOTO 6
      I=INDEX(KR,'_')
      IF(I.EQ.0)GOTO 15
      K=0
        DO 13 J=1,I
        IF(KR(J:J).EQ.' ')GOTO 13
        K=K+1
        KT(K:K)=KR(J:J)
  13    CONTINUE
        DO 14 J=I+1,I+4
        IF(KR(J:J).LT.'0'.OR.KR(J:J).GT.'9')KR(J:J)=' '
  14    CONTINUE
      READ(KR(I+1:I+4),*,ERR=23,END=23)J
      READ(KR(44:52),*,ERR=23,END=23)S
      GOTO 12
  15  IF(KR(7:10).EQ.'    ')GOTO 11
      READ(KR(1:10),*,ERR=11,END=11)T
      IF(T.LT.0.00001)GOTO 11
      IF(KT(1:1).EQ.'H')GOTO 11
      IF(KT(1:2).EQ.'N_'.OR.KT(1:2).EQ.'C_'.OR.KT(1:3).EQ.'CA_'.
     +OR.KT(1:2).EQ.'O_')GOTO 16
      ES(J)=ES(J)+T
      ET(J)=ET(J)+S
      GOTO 11
  16  EM(J)=EM(J)+T
      EN(J)=EN(J)+S
      GOTO 11
  17  IF(INDEX(KR,'reliability criteria').EQ.0)GOTO 6
      READ(LF,'(A)',ERR=23,END=23)KT
      READ(LF,'(A)',ERR=23,END=23)KT
      READ(LF,'(A)',ERR=23,END=23)KT
      IF(INDEX(KR,'main-chain').EQ.0)GOTO 19
  18  KR=' '
      READ(LF,'(A)',ERR=23,END=23)KR
      CALL LINTRM(KR,N)
      K=INDEX(KR,'_')
      IF(K.EQ.0)GOTO 6
      READ(KR(K+1:N+1),*,ERR=23,END=23)J,D
      KN(J)=' '//KR(K-3:K+4)
      UM(J)=D(4)*78.956835
      BM=AMAX1(BM,UM(J))
      AM(J)=D(6)
      MR=MAX0(MR,J)
      MB=MIN0(MB,J)
      KS=KR(K-3:K-1)
      KG=KS(2:2)
      IF(KG.GT.'Z')KS(2:2)=CHAR(ICHAR(KG)-LU)
      KG=KS(3:3)
      IF(KG.GT.'Z')KS(3:3)=CHAR(ICHAR(KG)-LU)
      IF(KS.EQ.'SER'.OR.KS.EQ.'THR')IC(J)=8
      IF(KS.EQ.'PHE'.OR.KS.EQ.'TYR'.OR.KS.EQ.'TRP'.OR.KS.EQ.
     +'HIS')IC(J)=1
      IF(KS.EQ.'GLU'.OR.KS.EQ.'ASP')IC(J)=2
      IF(KS.EQ.'ARG'.OR.KS.EQ.'LYS')IC(J)=3
      IF(KS.EQ.'CYS'.OR.KS.EQ.'MET')IC(J)=4
      IF(KS.EQ.'GLN'.OR.KS.EQ.'ASN')IC(J)=5
      IF(KS.EQ.'LEU'.OR.KS.EQ.'ILE'.OR.KS.EQ.'VAL'.OR.KS.EQ.
     +'ALA'.OR.KS.EQ.'PRO')IC(J)=6
      IF(KS.EQ.'GLY')IC(J)=9
      GOTO 18
  19  IF(INDEX(KR,'side-chain').EQ.0)GOTO 23
  20  KR=' '
      READ(LF,'(A)',ERR=23,END=23)KR
      CALL LINTRM(KR,K)
      K=INDEX(KR,'_')
      IF(K.EQ.0)GOTO 21
      READ(KR(K+1:80),*,ERR=23,END=23)J,D
      US(J)=D(4)*78.956835
      BM=AMAX1(BM,US(J))
      AS(J)=D(6)
      GOTO 20
  21  IF(MR.GT.0)GOTO 31
  22  WRITE(*,'(/A/)')' ** Bad .lst file format - no FMAP 2 ?! **'
      GOTO 25
  23  WRITE(*,'(/A/)')' ** Bad .lst file format **'
      GOTO 25
  24  WRITE(*,'(/A/)')' ** Cannot open file '//KR(1:L)//' **'
  25  IER=1
      GOTO 162
  26  WRITE(*,'(/A/)')' ** Not enough memory to store torsion'//
     +' angles **'
      GOTO 25
  27  FORMAT(/1X,78('=')//1X,A)
C
C Input secondary structure
C
  28  FORMAT(/' Enter alpha-helices and beta-strands one per line',
     +' with "A n1 n2" or "B n1 n2"'/' where n1 and n2 are the ',
     +'first and last residues of the helix or strand.')
  29  FORMAT(' Use base residue numbers and',
     +' Terminate the list with a blank line.')
  30  FORMAT(' Terminate the list with a blank line.')
  31  IF(OPT.EQ.'R')GOTO 126
      IF(OPT.EQ.'K')GOTO 40
      IF(COL(2:2).EQ.'f')GOTO 40
      WRITE(*,28)
      IF(OPT.EQ.'N')WRITE(*,29)
      IF(OPT.EQ.'T')WRITE(*,30)
  32  KR=' '
      WRITE(*,FMT)' Helix or strand: '
      READ(*,'(A)',ERR=32,END=32)KR
      CALL LINTRM(KR,I)
      I=INDEX(KR,'A')
      IF(I.EQ.0)I=INDEX(KR,'a')
      IF(I.EQ.0)GOTO 33
      J=3
      GOTO 34
  33  I=INDEX(KR,'B')
      IF(I.EQ.0)I=INDEX(KR,'b')
      IF(I.EQ.0)GOTO 36
      J=1
  34  KR(I:I)=' '
      READ(KR,*,ERR=37,END=37)K,L
      IF(K.GT.L)GOTO 37
      IF(K.LT.0)GOTO 37
      IF(L.GT.9999)GOTO 37
        DO 35 I=K,L
        IS(I)=J
  35    CONTINUE
      GOTO 32
  36  IF(KR(1:4).EQ.'    ')GOTO 40
  37  WRITE(*,'(A)')' ** Bad helix or strand definition ignored **'
      GOTO 32
C
C Define residue ranges for NCS
C
  38  FORMAT(/' Define the numbers that have to be added to the base',
     +' residue numbers to'/' generate the NCS related units.  For ',
     +'fourfold NCS the usual SHELXL convention'/' of numbering ',
     +'equivalent chains 1001..., 2001... etc. would require the')
  39  FORMAT(/' Minimum deviations in angles (deg.) and B for ',
     +'output to .pro file;')
  40  KQ=' [aBM '
      IF(OPT.EQ.'T')GOTO 46
      WRITE(*,38)
      WRITE(*,FMT)' input "1000 2000 3000 4000" here [1000 2000]: '
      KT='1000 2000'
      KR=' '
      READ(*,'(A)',ERR=40,END=40)KR
      CALL LINTRM(KR,I)
      IF(I.EQ.0)KR=KT
      NN=0
      CALL NUMIN(KR,IN,NN)
      IF(NN.LT.1)GOTO 40
      MB=MAX0(1,MB-IN(1))
      MR=MAX0(MB,MR-IN(NN))
      IF(OPT.EQ.'K')GOTO 126
  41  WRITE(*,39)
      WRITE(*,FMT)' 0 to print all, 999 to suppress [10 5]: '
      KT='10 5'
      KR=' '
      READ(*,'(A)',ERR=40,END=40)KR
      CALL LINTRM(KR,I)
      IF(I.EQ.0)KR=KT
      READ(KR,*,ERR=41,END=41)AX,BX
C
C Set up diagram control
C
  42  FORMAT(/'%%Page:',2I5/'/XSave save def')
  43  FORMAT(/' There may be up to four diagrams on one page, start',
     +'ing at the top.  Each'/' should be defined by entering three',
     +' characters: a symbol to label the diagram,')
  44  FORMAT(' then either B (B-values), A (anisotropy) or E(esds),',
     +' followed by M (main-chain)'/' or S (side-chain) and then',
     +' the numbers of the first and last residues.'/
     +' END terminates the list.')
  45  FORMAT(' then either D (absolute difference [rms absolute dif',
     +'erence from mean if more'/' than 2 components]), M (maximum ',
     +'absolute deviation [from mean if more than 2])'/' or A (aver',
     +'age), followed by the letter H (phi), Y (psi), P (phi and ',
     +'psi),'/' O (omega), C (chi1), T (all chi), M (main-chain B)',
     +' or S (side-chain B) and'/' then the numbers of the first ',
     +'and last base residues.  Note that A is only'/' allowed with',
     +' S or M and that P or T must be preceded by M.  ',
     +'END terminates'/' the list.')
      KQ=' [aMH '
  46  WRITE(KR,'(I6,A,I6)')MB,'/',MR
      L=6
        DO 47 I=1,13
        IF(KR(I:I).EQ.' ')GOTO 47
        L=L+1
        KQ(L:L)=KR(I:I)
        IF(KQ(L:L).EQ.'/')KQ(L:L)=' '
  47    CONTINUE
  48  NPG=NPG+1
      WRITE(LP,42)NPG,NPG
      WRITE(*,43)
      IF(OPT.EQ.'T')WRITE(*,44)
      IF(OPT.EQ.'N')WRITE(*,45)
      IX=110
      JX=550
C
C Loop over four diagrams on one page - solicit diagram type
C
        DO 124 N=1,4
  49    WRITE(*,FMT)' Next diagram'//KQ(1:L)//']: '
        KR=' '
        READ(*,'(A)',ERR=54,END=54)KR
        CALL LINTRM(KR,I)
        IF(I.EQ.0)GOTO 51
  50    L=3
        KQ(L:L)='?'
        GOTO 52
  51    IF(L.LT.4)GOTO 54
        KR(3:80)=KQ(3:80)
        IF(KQ(3:5).EQ.'cBS')KQ(3:4)='dA'
        IF(KQ(3:5).EQ.'bAM'.OR.KQ(3:5).EQ.'bEM')KQ(3:5)='cBS'
        IF(KQ(3:5).EQ.'aBM')KQ(3:4)='bA'
        IF(KQ(3:5).EQ.'hAS')GOTO 50
        IF(KQ(3:5).EQ.'gAM')KQ(3:5)='hAS'
        IF(KQ(3:5).EQ.'fMS')KQ(3:5)='gAM'
        IF(KQ(3:5).EQ.'eMM')KQ(3:5)='fMS'
        IF(KQ(3:5).EQ.'dMT')KQ(3:5)='eMM'
        IF(KQ(3:5).EQ.'cMO')KQ(3:5)='dMT'
        IF(KQ(3:5).EQ.'bMY')KQ(3:5)='cMO'
        IF(KQ(3:5).EQ.'aMH')KQ(3:5)='bMY'
  52    K=0
          DO 53 I=1,80
          IF(KR(I:I).EQ.' ')GOTO 53
          K=K+1
          KS(K:K)=KR(I:I)
          KR(I:I)=' '
          IF(K.EQ.1)GOTO 53
          IF(KS(K:K).GE.'a')KS(K:K)=CHAR(ICHAR(KS(K:K))-LU)
          IF(K.EQ.3)GOTO 55
  53      CONTINUE
  54    WRITE(*,'(A)')' ** Incorrectly specified diagram - '//
     +  'try again **'
        GOTO 49
  55    IF(KS.EQ.'END'.OR.KS.EQ.'eND')GOTO 125
        IF(OPT.EQ.'N')GOTO 56
        IF(KS(2:2).NE.'B'.AND.KS(2:2).NE.'A'.AND.KS(2:2).NE.'E')GOTO 54
        IF(KS(3:3).NE.'M'.AND.KS(3:3).NE.'S')GOTO 54
        GOTO 57
  56    IF(KS(2:2).NE.'D'.AND.KS(2:2).NE.'M'.AND.KS(2:2).NE.'A')
     +  GOTO 54
        IF(KS(3:3).NE.'H'.AND.KS(3:3).NE.'Y'.AND.KS(3:3).NE.'P'
     +  .AND.KS(3:3).NE.'O'.AND.KS(3:3).NE.'C'.AND.KS(3:3).NE.'T'
     +  .AND.KS(3:3).NE.'M'.AND.KS(3:3).NE.'S'.AND.KS(3:3).NE.'B')
     +  GOTO 54
  57    READ(KR,*,ERR=54,END=54)MB,MR
        IF(MR.LT.1)GOTO 54
        IF(MB.GE.MR)GOTO 54
C
C Plot frame and title
C
        IY=830-180*N
        JY=IY+110
        IF(OPT.EQ.'N')GOTO 60
        IF(KS(2:2).NE.'B')GOTO 58
        KR='(( ) Mean equivalent B of side-chain atoms)'
        IF(KS(3:3).EQ.'M')KR(27:30)='main'
        NL=43
        GOTO 72
  58    IF(KS(2:2).NE.'E')GOTO 59
        KR='(( ) Mean positional esd of side-chain atoms)'
        IF(KS(3:3).EQ.'M')KR(29:32)='main'
        NL=45
        GOTO 72
  59    KR='(( ) Mean anisotropy of side-chain atoms)'
        NL=41
        IF(KS(3:3).EQ.'M')KR(25:28)='main'
        GOTO 72
  60    IF(KS(2:3).NE.'AS'.AND.KS(2:3).NE.'AM')GOTO 61
        KR='(( ) Mean B-values of side-chain atoms)'
        IF(KS(3:3).EQ.'M')KR(23:26)='main'
        NL=39
        GOTO 72
  61    IF(KS(2:2).EQ.'A')GOTO 54
        IF(NN.LT.2)GOTO 54
        IF(NN.GT.2)GOTO 62
        KR='(( ) Absolute differences in'
        NL=28
        IF(KS(2:3).NE.'MP'.AND.KS(2:3).NE.'MT')GOTO 63
        KR='(( ) Maximum absolute differences in'
        NL=36
        GOTO 63
  62    KR='(( ) Rms deviations from mean values of'
        NL=39
        IF(KS(2:2).EQ.'D')GOTO 63
        KR='(( ) Maximum deviations from mean values of'
        NL=43
  63    IF(KS(3:3).NE.'S'.AND.KS(3:3).NE.'M')GOTO 66
        IF(NN.GT.2)GOTO 64
        NL=NL+5
        KR(NL-4:NL)=' mean'
  64    IF(KS(3:3).NE.'S')GOTO 65
        NL=NL+24
        KR(NL-23:NL)=' B for side-chain atoms)'
        GOTO 72
  65    NL=NL+24
        KR(NL-23:NL)=' B for main-chain atoms)'
        GOTO 72
  66    IF(KS(3:3).NE.'H')GOTO 67
        NL=NL+5
        KR(NL-4:NL)=' phi)'
        GOTO 72
  67    IF(KS(3:3).NE.'Y')GOTO 68
        NL=NL+5
        KR(NL-4:NL)=' psi)'
        GOTO 72
  68    IF(KS(3:3).NE.'O')GOTO 69
        NL=NL+7
        KR(NL-6:NL)=' omega)'
        GOTO 72
  69    IF(KS(3:3).NE.'C')GOTO 70
        NL=NL+6
        KR(NL-5:NL)=' chi1)'
        GOTO 72
  70    IF(KS(3:3).NE.'P')GOTO 71
        IF(KS(2:2).NE.'M')GOTO 54
        NL=NL+12
        KR(NL-11:NL)=' phi or psi)'
        GOTO 72
  71    IF(KS(3:3).NE.'T')GOTO 54
        IF(KS(2:2).NE.'M')GOTO 54
        NL=NL+15
        KR(NL-14:NL)=' chi1,2,3 or 4)'
  72    KR(3:3)=KS(1:1)
        WRITE(LP,'(A,4I4,A)')'3 W C7',IX,IY,JX,JY,' B C0 1 W'
        WRITE(LP,'(A,2I4,A)')KR(1:NL)//' 15',(IX+JX)/2,JY+12,' P'
        WRITE(LO,'(/A/A,I5,A,I5,A)')' Diagram: '//KR(2:NL-1),
     +  ' written to .ps for base residues',MB,' to',MR,' inclusive.'
        IF(COL(2:2).NE.'n')GOTO 77
        IF(KS(3:3).NE.'M')GOTO 75
        WRITE(LO,73)
        GOTO 77
  73    FORMAT(' Color coded according to secondary structure:  ',
     +  'blue = alpha-helix,'/' green = beta-strand,  red = other.')
  74    FORMAT(' Color coded according to residue characteristics:',
     +  '  yellow = Cys, Met;'/' green = Phe, Tyr, Trp, His;  ',
     +  'cyan =',A,'Ala, Leu, Ile, Val, Pro;'/
     +  ' red = Glu, Asp;  blue = Arg, Lys;  purple = Gln, Asn;',
     +  '  gray = Ser, Thr.')
  75    WRITE(LO,74)' Gly, '
C
C Evalute quantity to be plotted and print residue by residue summary
C
  76    FORMAT(/' Residue Max. Rms Dev. Mean  Individual values of ',
     +  A/)
  77    Q=BM
        IF(KS(2:2).EQ.'E')Q=EE
        IF(OPT.EQ.'T')GOTO 101
        Q=0.
          DO 78 I=MB,MR
          AM(I)=0.
  78      CONTINUE
          DO 98 NI=1,8
          IF(NI.NE.1)GOTO 79
          IF(KS(3:3).NE.'H'.AND.KS(3:3).NE.'P')GOTO 98
          IF(AX.LT.998.)WRITE(LO,76)'Phi'
          GOTO 85
  79      IF(NI.NE.2)GOTO 80
          IF(KS(3:3).NE.'Y'.AND.KS(3:3).NE.'P')GOTO 98
          IF(AX.LT.998.)WRITE(LO,76)'Psi'
          GOTO 85
  80      IF(NI.NE.3)GOTO 81
          IF(KS(3:3).NE.'O')GOTO 98
          IF(AX.LT.998.)WRITE(LO,76)'Omega'
          GOTO 85
  81      IF(NI.NE.4)GOTO 82
          IF(KS(3:3).NE.'C'.AND.KS(3:3).NE.'T')GOTO 98
          IF(AX.LT.998.)WRITE(LO,76)'Chi1'
          GOTO 85
  82      IF(NI.GT.7)GOTO 83
          IF(KS(3:3).NE.'T')GOTO 98
          IF(AX.LT.998.)WRITE(LO,76)'Chi'//CHAR(45+NI)
          GOTO 85
  83      IF(KS(3:3).NE.'S')GOTO 84
          IF(BX.LT.998.)WRITE(LO,76)'mean B (side-chain)'
          GOTO 85
  84      IF(KS(3:3).NE.'M')GOTO 98
          IF(BX.LT.998.)WRITE(LO,76)'mean B (main-chain)'
  85        DO 97 M=MB,MR
            NH=3
            NJ=0
            CX=AX
            IF(KS(3:3).NE.'M')GOTO 87
              DO 86 I=1,NN
              J=IN(I)+M
              IF(UM(J).LT.0.)GOTO 86
              NH=NH+2
              AS(NH-1)=REAL(J)
              AS(NH)=UM(J)
  86          CONTINUE
            GOTO 89
  87        IF(KS(3:3).NE.'S')GOTO 90
              DO 88 I=1,NN
              J=IN(I)+M
              IF(US(J).LT.0.)GOTO 88
              NH=NH+2
              AS(NH-1)=REAL(J)
              AS(NH)=US(J)
  88          CONTINUE
  89        CX=BX
            GOTO 93
  90          DO 92 K=1,NN
              J=M+IN(K)
                DO 91 I=1,NA,3
                IF(INT(A(I)).NE.J)GOTO 91
                IF(INT(ABS(A(I+1))).NE.NI)GOTO 91
                NH=NH+2
                AS(NH-1)=REAL(J)
                AS(NH)=A(I+2)
                IF(A(I+1).LT.0.)NJ=1
                GOTO 92
  91            CONTINUE
  92          CONTINUE
  93        IF(NH.LT.4)GOTO 97
            T=0.
              DO 94 I=5,NH,2
              U=AS(I)
              IF(NI.LT.8)U=AMOD(900.+U-AS(5),360.)-180.+AS(5)
              IF(NJ.GT.0)U=AMOD(990.+U-AS(5),180.)-90.+AS(5)
              T=T+U
  94          CONTINUE
            W=0.5*REAL(NH-3)
            AS(3)=T/W
            AS(1)=0.
            S=0.
              DO 95 I=5,NH,2
              U=AS(I)-AS(3)
              IF(NI.LT.8)U=AMOD(900.+U,360.)-180.
              IF(NJ.GT.0)U=AMOD(990.+U,180.)-90.
              AS(1)=AMAX1(AS(1),ABS(U))
              S=S+U**2
  95          CONTINUE
            AS(2)=SQRT(S/W)
            IF(AS(1).LT.CX)GOTO 96
            J=MIN0(11,NH)
            WRITE(LO,99)M,AS(1),AS(2),AS(3),(INT(AS(I-1)),AS(I),
     +      I=5,J,2)
            IF(J.LT.NH)WRITE(LO,100)(INT(AS(I-1)),AS(I),I=J+2,NH,2)
  96        S=AS(1)
            IF(NN.EQ.2)S=2.*S
            IF(KS(2:2).EQ.'M')AM(M)=AMAX1(AM(M),S)
            S=AS(2)
            IF(NN.EQ.2)S=2.*S
            IF(KS(2:2).EQ.'D')AM(M)=S
            IF(KS(2:2).EQ.'A')AM(M)=AS(3)
            Q=AMAX1(Q,AM(M))
  97        CONTINUE
  98      CONTINUE
  99    FORMAT(I6,3F7.1,4(I6,F7.1))
 100    FORMAT(27X,4(I6,F7.1))
C
C Esd analysis for printer
C
 101    KR='(Mean B-value)'
        NL=14
        IF(OPT.NE.'T')GOTO 109
        IF(KS(2:2).NE.'E')GOTO 107
        KR='(Mean esd in Angstroms)'
        NL=23
        WRITE(LO,'(/A/)')' Residue number, mean main-chain and '//
     +  'mean side-chain positional esds'
          DO 106 M=MB,MR
          IF(EN(M).GT.0.1)GOTO 102
          EM(M)=-1.
          GOTO 103
 102      EM(M)=EM(M)/EN(M)
          EN(M)=1.
          EE=AMAX1(EE,EM(M))
 103      IF(ET(M).GT.0.1)GOTO 104
          ES(M)=-1.
          IF(EM(M).LT.0.)GOTO 106
          WRITE(LO,'(I5,F9.4)')M,EM(M)
          GOTO 106
 104      ES(M)=ES(M)/ET(M)
          ET(M)=1.
          EE=AMAX1(EE,ES(M))
          IF(EM(M).LT.0.)GOTO 105
          WRITE(LO,'(I5,2F9.4)')M,EM(M),ES(M)
          GOTO 106
 105      WRITE(LO,'(I5,F18.4)')M,ES(M)
 106      CONTINUE
        Q=1000.*EE
C
C Label vertical axis
C
 107    IF(KS(2:2).NE.'A')GOTO 111
          DO 108 M=0,110,22
          T=REAL(110-M)/110.
          WRITE(LP,'(A,F5.1,A,2I4,A,4I4,A)')'(',T,') 12',IX-20,M+IY,
     +    ' P',IX-4,M+IY,IX,M+IY,' L'
 108      CONTINUE
        KR='(Mean anisotropy)'
        NL=17
        GOTO 116
 109    IF(KS(2:3).EQ.'AM')GOTO 111
        IF(KS(2:3).EQ.'AS')GOTO 111
        KR='(Difference)'
        NL=12
        IF(NN.LT.3)GOTO 110
        KR='(Deviation)'
        NL=11
 110    IF(KS(3:3).EQ.'M')GOTO 111
        IF(KS(3:3).EQ.'S')GOTO 111
        KR='(Difference (deg.))'
        NL=19
        IF(NN.LT.3)GOTO 111
        KR='(Deviation (deg.))'
        NL=18
 111    JM=10*INT(0.1*Q)+10
        J=MAX0(5,5*INT(0.05*REAL(JM)))
        IF(J.EQ.35)J=30
        WRITE(KK,'(I5,A,I5)')JM,'/',J
        IF(KS(2:2).EQ.'E')WRITE(KK,'(F5.3,A,F5.3)')AMIN1(9.999,
     +  0.001*REAL(JM)),'/',AMIN1(9.999,0.001*REAL(J))
        M=0
          DO 112 I=1,11
          IF(KK(I:I).EQ.' ')GOTO 112
          M=M+1
          KK(M:M)=KK(I:I)
          IF(KK(M:M).EQ.'/')KK(M:M)=' '
 112      CONTINUE
        KK(M+1:80)=' '
        WRITE(*,FMT)' Maximum value and step for vertical scale ['
     +  //KK(1:M)//']: '
        KT=' '
        READ(*,'(A)',ERR=111,END=111)KT
        CALL LINTRM(KT,I)
        IF(I.EQ.0)KT=KK
        IF(KS(2:2).EQ.'E')GOTO 114
        READ(KT,*,ERR=111,END=111)JM,J
        IF(JM.LT.1)GOTO 111
        IF(J.LT.1)GOTO 111
          DO 113 M=0,JM,J
          K=IY+INT(110.*REAL(M)/REAL(JM)+0.5)
          WRITE(LP,'(A,I5,A,2I4,A,4I4,A)')'(',M,') 12',IX-20,K,
     +    ' P',IX-4,K,IX,K,' L'
 113      CONTINUE
        GOTO 116
 114    READ(KT,*,ERR=111,END=111)S,T
        JM=NINT(1000.*S)
        J=NINT(1000.*T)
        IF(JM.LT.1)GOTO 111
        IF(J.LT.1)GOTO 111
          DO 115 M=0,JM,J
          K=IY+INT(110.*REAL(M)/REAL(JM)+0.5)
          WRITE(LP,'(A,F5.3,A,2I4,A,4I4,A)')'(',AMIN1(9.999,0.001*
     +    REAL(M)),') 12',IX-20,K,' P',IX-4,K,IX,K,' L'
 115      CONTINUE
 116    I=IX-37
        IF(KS(2:2).EQ.'E')I=I-8
        WRITE(LP,'(A,2I4,A)')KR(1:NL)//' 15',I,(IY+JY)/2,' Q'
C
C Label horizontal axis
C
        U=REAL(JX-IX-1)/REAL(MR-MB+2)
        K=10*MAX0(1,((MR-MB)/50))
          DO 118 M=K+MB-1,MR,K
          V=U*(REAL(M-MB)+1.)+REAL(IX)
          WRITE(KR,'(A,I5)')'(',M
          NL=0
            DO 117 I=1,6
            IF(KR(I:I).EQ.' ')GOTO 117
            NL=NL+1
            KR(NL:NL)=KR(I:I)
 117        CONTINUE
          WRITE(LP,'(A,F7.2,I4,A,2(F7.2,I4),A)')KR(1:NL)//') 12',V,
     +    IY-15,' P',V,IY,V,IY-5,' L'
 118      CONTINUE
C
C Plot stick diagram
C
          DO 123 M=MB,MR
          T=AM(M)
          IF(OPT.EQ.'N')GOTO 121
          IF(KS(2:2).EQ.'B')GOTO 120
          IF(KS(2:2).NE.'E')GOTO 119
          T=EM(M)
          IF(KS(3:3).EQ.'S')T=ES(M)
          T=110000.*T/REAL(JM)
          GOTO 122
 119      IF(KS(3:3).EQ.'S')T=AS(M)
          IF(T.LT.0.)T=1.
          T=110.*(1.-T)
          GOTO 122
 120      T=US(M)
          IF(KS(3:3).EQ.'M')T=UM(M)
 121      T=110.*T/REAL(JM)
 122      IF(T.LE.0.)GOTO 123
          IF(T.GT.110.001)T=110.001
          T=T+REAL(IY)
          V=U*REAL(M-MB+.65)+REAL(IX)
          I=M
          IF(OPT.EQ.'N')I=I+IN(1)
          J=IS(M)
          IF(KS(3:3).EQ.'S')J=IC(I)
          IF(KS(3:3).EQ.'C')J=IC(I)
          IF(KS(3:3).EQ.'T')J=IC(I)
          IF(J.EQ.9)J=6
          IF(COL(2:2).EQ.'f')J=0
          WRITE(LP,'(A,I1,4F7.2,A)')'C',J,V+.7*U,REAL(IY),V,T,' H'
 123      CONTINUE
 124    CONTINUE
      N=5
C
C Extra label after last diagram
C
 125  IY=980-180*N
      WRITE(LP,'(A,2I4,A)')'C0 (Residue number) 15',(IX+JX)/2,IY,' P'
      WRITE(LP,'(A)')'showpage XSave restore'
      IF(OPT.EQ.'T')GOTO 162
      WRITE(*,'(1X)')
      KR='N'
      IF(KT(3:5).EQ.'dMT')KR='Y'
      WRITE(*,FMT)' Continue on next page ? ['//KR(1:1)//']: '
      KR=' '
      READ(*,'(A)',ERR=162,END=162)KR
      IF(INDEX(KR,'Y')+INDEX(KR,'y').GT.0)GOTO 48
      GOTO 162
C
C Ramachandran and Kleywegt plots
C
 126  WRITE(*,FMT)' Include Gly (as open squares) ? (Y or N) [N]: '
      KR=' '
      READ(*,'(A)',ERR=126,END=126)KR
      CALL LINTRM(KR,I)
      KG='N'
      IF(I.GT.0)KG=KR(I:I)
      IF(KG.EQ.'n')KG='N'
      IF(KG.EQ.'y')KG='Y'
      IF(KG.NE.'Y'.AND.KG.NE.'N')GOTO 126
      NPG=NPG+1
      WRITE(LP,42)NPG,NPG
      WRITE(LP,'(A)')'C7 3 W 95 260 545 710 B C0 1 W'
      IF(OPT.EQ.'R')WRITE(LP,159)'Ramachandran plot'
      IF(OPT.EQ.'K')WRITE(LP,159)'Kleywegt NCS plot'
      WRITE(LP,'(A)')'(Phi (degrees)) 15 320 230 P'
      WRITE(LP,'(A)')'(Psi (degrees)) 15 60 485 Q'
        DO 127 I=-150,150,50
        WRITE(KR,'(A,I4)')'(',I
        S=485.+1.25*REAL(I)
        T=320.+1.25*REAL(I)
        WRITE(LP,160)KR(1:5),S,S,S
        IF(KR(2:2).EQ.' ')KR(1:2)=' ('
        IF(KR(2:3).EQ.'( ')KR(2:3)=' ('
        IF(KR(3:4).EQ.'( ')KR(3:4)=' ('
        WRITE(LP,161)KR(1:5),T,T,T
 127    CONTINUE
C
C Deduce thresholds for 90% and 80% regions
C
        DO 128 I=1,250
        IS(I)=0
 128    CONTINUE
        DO 130 I=1,1369
          DO 129 J=1,250
          IF(II(I).GT.J-2)IS(J)=IS(J)+II(I)
 129      CONTINUE
 130    CONTINUE
      CI=0.
      T=.98*REAL(IS(1))
        DO 133 K=1,2
          DO 131 J=2,250
          IF(REAL(IS(J)).LT.T)GOTO 132
 131      CONTINUE
        J=250
 132    CO=CI
        CI=REAL(J-1)-(T-REAL(IS(J)))/(REAL(IS(J-1))-REAL(IS(J)))
        T=.8*REAL(IS(1))
 133    CONTINUE
C
C Outline preferred regions
C
      T=CI
      WRITE(LP,'(A)')'C1 0.5 W'
        DO 140 K=1,2
        N=0
          DO 139 I=1,36
            DO 138 J=1,37
            N=N+1
            IF(J.EQ.37)GOTO 138
            U=9.E9
            P=9.E9
            Q=0.
            IF((REAL(II(N))-T)*(REAL(II(N+1))-T).GE.0.)GOTO 134
            P=82.5+12.5*(REAL(J)+(T-REAL(II(N)))/
     +      (REAL(II(N+1))-REAL(II(N))))
            Q=247.5+12.5*REAL(I)
 134        IF((REAL(II(N+1))-T)*(REAL(II(N+38))-T).GE.0.)GOTO 135
            U=P
            V=Q
            P=95.+12.5*REAL(J)
            Q=247.5+12.5*(REAL(I)+(T-REAL(II(N+1)))/
     +      (REAL(II(N+38))-REAL(II(N+1))))
 135        IF((REAL(II(N+38))-T)*(REAL(II(N+37))-T).GE.0.)GOTO 136
            U=P
            V=Q
            P=82.5+12.5*(REAL(J)+(T-REAL(II(N+37)))/
     +      (REAL(II(N+38))-REAL(II(N+37))))
            Q=260.+12.5*REAL(I)
 136        IF((REAL(II(N+37))-T)*(REAL(II(N))-T).GE.0.)GOTO 137
            U=P
            V=Q
            P=82.5+12.5*REAL(J)
            Q=247.5+12.5*(REAL(I)+(T-REAL(II(N)))/
     +      (REAL(II(N+37))-REAL(II(N))))
 137        IF(U.LT.8.E9)WRITE(LP,'(4F7.2,A)')P,Q,U,V,' L'
 138        CONTINUE
 139      CONTINUE
        T=CO
        IF(K.EQ.1)WRITE(LP,'(A)')'C0 1 W'
 140    CONTINUE
C
C Phi/psi list
C
      NB=-2
        DO 142 I=1,NA,3
        IF(A(I+1).GT.1.5)GOTO 142
        K=INT(A(I))
        IF(IC(K).EQ.7)GOTO 142
        IF(IC(K).EQ.9.AND.KG.EQ.'N')GOTO 142
          DO 141 L=1,NA,3
          IF(K.NE.INT(A(L)))GOTO 141
          IF(A(L+1).LT.1.5)GOTO 141
          NB=NB+3
          IS(NB)=K
          IS(NB+1)=I
          IS(NB+2)=L
 141      CONTINUE
 142    CONTINUE
C
C Lines for Kleywegt plot - allow for axis intersections
C
      IF(OPT.NE.'K')GOTO 152
      IF(NN.EQ.0)GOTO 152
      WRITE(LP,'(A)')'C0 1.5 W'
        DO 150 I=1,NB,3
        K=IS(I)
        IF(K.LE.IN(1))GOTO 150
        IF(K.GT.IN(2))GOTO 150
        NF=NB+3
        IS(NF)=I
          DO 144 J=2,NN
          M=K+IN(J)-IN(1)
            DO 143 L=1,NB,3
            IF(IS(L).NE.M)GOTO 143
            NF=NF+1
            IS(NF)=L
 143        CONTINUE
 144      CONTINUE
        N=IC(K)
        IF(N.EQ.9)N=6
        IF(COL(2:2).EQ.'f')N=0
          DO 149 J=NB+3,NF
          L=IS(J)
          R=A(IS(L+1)+2)
          S=A(IS(L+2)+2)
          P=320.+1.25*R
          Q=485.+1.25*S
            DO 148 M=J+1,NF
            L=IS(M)
            U=P+1.25*(AMOD(900.+A(IS(L+1)+2)-R,360.)-180.)
            V=Q+1.25*(AMOD(900.+A(IS(L+2)+2)-S,360.)-180.)
 145        T=1.
            IF(U.GT.P)T=(545.-P)/(U-P)
            IF(U.LT.P)T=(95.-P)/(U-P)
            W=1.
            IF(V.GT.Q)W=(710.-Q)/(V-Q)
            IF(V.LT.Q)W=(260.-Q)/(V-Q)
            IF(AMIN1(W,T).GT.0.999)GOTO 147
            IF(W.GT.T)GOTO 146
            PX=P*(1.-W)+U*W
            QX=Q*(1.-W)+V*W
            WRITE(LP,'(A,I1,4F7.2,A)')'C',N,P,Q,PX,QX,' L'
            P=PX
            T=SIGN(450.,485.-QX)
            Q=QX+T
            V=V+T
            GOTO 145
 146        PX=P*(1.-T)+U*T
            QX=Q*(1.-T)+V*T
            WRITE(LP,'(A,I1,4F7.2,A)')'C',N,P,Q,PX,QX,' L'
            T=SIGN(450.,320.-PX)
            P=PX+T
            Q=QX
            U=U+T
            GOTO 145
 147        WRITE(LP,'(A,I1,4F7.2,A)')'C',N,P,Q,U,V,' L'
 148        CONTINUE
 149      CONTINUE
 150    CONTINUE
C
C Ramachandran plot - flag outliers
C
 151  FORMAT(/' Residue    Phi    Psi  for Ramachandran plot outliers')
 152  WRITE(LO,151)
      WRITE(*,151)
      NK=0
      NE=0
      NF=0
        DO 157 I=1,NB,3
        K=IS(I)
        J=IC(K)
        IF(J.EQ.7)GOTO 157
        IF(J.NE.9)GOTO 153
        IF(KG.EQ.'N')GOTO 157
        J=6
 153    IF(COL(2:2).EQ.'f')J=0
        P=A(IS(I+1)+2)
        Q=A(IS(I+2)+2)
        U=320.+1.25*P
        V=485.+1.25*Q
        IF(IC(K).EQ.9)GOTO 155
        KH=' D'
        IF(OPT.NE.'K')KH=' E'
        WRITE(LP,'(A,I1,2F7.2,A)')'C',J,U,V,KH
        NF=NF+1
        M=INT(AMOD(90.+0.1*P,36.))+37*INT(AMOD(90.+0.1*Q,36.))+1
        IF(REAL(II(M)).GT.CI)NK=NK+1
        IF(REAL(II(M)).GT.CO)GOTO 154
        WRITE(LO,'(A,2F7.1)')KN(K),P,Q
        WRITE(*,'(A,2F7.1)')KN(K),P,Q
        GOTO 157
 154    NE=NE+1
        GOTO 157
 155    IF(OPT.EQ.'K')GOTO 156
        WRITE(LP,'(A,4F7.2,A)')'C7 2.0 W',U-2.5,V-2.5,U+2.5,
     +  V+2.5,' B'
        GOTO 157
 156    WRITE(LP,'(A,4F7.2,A)')'C7 1.2 W',U-1.4,V-1.4,U+1.4,
     +  V+1.4,' B'
 157    CONTINUE
      WRITE(LP,'(A)')'showpage XSave restore'
      IF(NF.EQ.0)GOTO 162
      T=100./REAL(NF)
      WRITE(LO,158)NF,NE,T*REAL(NE),NK,T*REAL(NK)
      WRITE(*,158)NF,NE,T*REAL(NE),NK,T*REAL(NK)
      IF(COL(2:2).EQ.'f')GOTO 162
      WRITE(LO,160)
      WRITE(LO,74)' '
 158  FORMAT(/I6,' Standard residues excluding Gly'/I6,' (',F5.1,
     +'% ) in core region according to K&J (expected 98%)'/I6,' (',
     +F5.1,'% ) in inner core region as well (expected 80%)'//
     +' G.J.Kleywegt & T.A.Jones, Structure 4 (1996) 1395-1400.')
 159  FORMAT('(',A,') 20 320 740 P')
 160  FORMAT(A,') 12 76',F7.2,' P 2 W 90',F7.2,' 94',F7.2,' L 1 W')
 161  FORMAT(A,') 12',F7.2,' 248 P 2 W',F7.2,' 255',F7.2,' 259 L 1 W')
 162  RETURN
      END
C
C -------------------------------------------------------------------
C
      SUBROUTINE SXFT(D,N1,N2,IS)
C
C N1 x N2 2D-FFT of data in D. D is a real array of dimension 2*N1*N2
C and the data are stored in two-dimensional "complex" FORTRAN form
C (real before imaginary) with index 1..N1 changing more rapidly than
C 1..N2.  IS = +1 for the forward transform and -1 for the inverse.
C Simplified from Press et al., Numerical recipes, Cambridge 1986.
C
      REAL D(*)
      I=2
      J=I*N1
      K=J*N2
        DO 12 ND=1,2
        NJ=1
          DO 6 M=1,J,I
          IF(M.GE.NJ)GOTO 3
          NK=M+I-2
            DO 2 L=M,NK,2
              DO 1 N=L,K,J
              NL=NJ+N-M
              T=D(N)
              D(N)=D(NL)
              D(NL)=T
              T=D(N+1)
              D(N+1)=D(NL+1)
              D(NL+1)=T
   1          CONTINUE
   2        CONTINUE
   3      NI=J/2
   4      IF((NI.LT.I).OR.(NJ.LE.NI))GOTO 5
          NJ=NJ-NI
          NI=NI/2
          GOTO 4
   5      NJ=NJ+NI
   6      CONTINUE
        NI=I
   7    IF(NI.GE.J)GOTO 11
        NJ=2*NI
        T=6.2831853/REAL(IS*NJ/I)
        UR=-2.*SIN(0.5*T)**2
        UI=SIN(T)
        WR=1.
        WI=0.
          DO 10 N=1,NI,I
          NL=N+I-2
            DO 9 L=N,NL,2
              DO 8 M=L,K,NJ
              NK=M+NI
              TR=WR*D(NK)-WI*D(NK+1)
              TI=WR*D(NK+1)+WI*D(NK)
              D(NK)=D(M)-TR
              D(NK+1)=D(M+1)-TI
              D(M)=D(M)+TR
              D(M+1)=D(M+1)+TI
   8          CONTINUE
   9        CONTINUE
          T=WR
          WR=WR*UR-WI*UI+WR
          WI=WI*UR+T*UI+WI
  10      CONTINUE
        NI=NJ
        GOTO 7
  11    I=J
        J=K
  12    CONTINUE
      RETURN
      END
C
C -------------------------------------------------------------------
C
      SUBROUTINE HOPE(MR,RH,RK,RL,FF,FC,WT,SQ)
C
      CHARACTER KT*80
      COMMON/XTAL/SY(12,192),CELL(15),II(1369),NS,LAT,LU,LN,
     +LO,LP,LF,LM,LS,NOS,IER,NPG
      COMMON/WORD/KF,KR,KD,KE,KA,KB,KN,FMT,COL,OPT
      CHARACTER KF*80,KR*80,KD(462)*52,KA(50000)*4,KE(9999)*4,
     +KB(250)*80,KN(10000)*9,FMT*20,COL*4,OPT*1
      REAL D(6),X(24),RH(MR),RK(MR),RL(MR),FF(MR),FC(MR),WT(MR),SQ(MR)
      REAL*8 AM(600),BM(24),DM(24)
C
C Set up parameters
C
   1  WRITE(*,FMT)' Enter number of parameters (12, 18 or 24) [12]: '
      KR=' '
      READ(*,'(A)',END=1,ERR=1)KR
      CALL LINTRM(KR,I)
      IF(I.EQ.0)KR='12'
      READ(KR,*,END=2,ERR=2)NP
   2  IF(NP.NE.12.AND.NP.NE.18.AND.NP.NE.24)GOTO 1
   3  WRITE(*,FMT)' Enter minimum I/sigma for parameter '//
     +'refinement [0]: '
      KR=' '
      READ(*,'(A)',END=3,ERR=3)KR
      CALL LINTRM(KR,I)
      IF(I.EQ.0)KR='0.0'
      READ(KR,*,END=4,ERR=4)SIG
   4  WW=10.
      N=0
        DO 5 I=7,24
        X(I)=0.
   5    CONTINUE
        DO 6 I=1,6
        X(I)=WW*CELL(I+6)
   6    CONTINUE
C
C Read reflection data
C
   7  KR=' '
      READ(LF,'(A)',ERR=7,END=14)KR
      CALL LINTRM(KR,I)
      READ(KR,*,ERR=7,END=7)D
      IF(D(5)*SIG.GT.D(4))GOTO 7
      N=N+1
      IF(N.GT.MR)GOTO 8
      RH(N)=D(1)
      RK(N)=D(2)
      RL(N)=D(3)
      FF(N)=D(4)
      FC(N)=D(6)**2
      WT(N)=1./(D(5)**2+(0.033333*(2.*FC(N)+D(4)))**2)
      SQ(N)=WW*(CELL(7)*D(1)**2+CELL(8)*D(2)**2+CELL(9)*D(3)**2+
     +CELL(10)*D(2)*D(3)+CELL(11)*D(1)*D(3)+CELL(12)*D(1)*D(2))
      GOTO 7
C
C Error mesages and format statements
C
   8  WRITE(*,'(A)')' ** Too many reflections **'
      GOTO 31
   9  WRITE(*,'(A)')' ** Cannot open file '//KT(1:NL)//
     +' for writing **'
      GOTO 31
  10  WRITE(*,'(A)')' ** Bad .fcf file format **'
      GOTO 31
  11  FORMAT(/I8,' Reflexions with I >',F6.3,' sigma(I) selected ',
     +'for determination of',I3/' anisotropic scaling parameters',
     +' by the method of S. Parkin, B. Moezzi & H. Hope,'/
     +' J. Appl. Cryst. 28 (1995) 53-56.'//I7,' Further reflections',
     +' used in R(free) test'/)
  12  FORMAT(' wR2 =',F8.4,'    R1 =',F8.4,'    R1(free) =',F8.4,
     +'    before cycle',I4)
  13  FORMAT(/I8,' reflections written to file ',A,
     +' in SHELX HKLF 4 format'//' wR2 =',F8.4,'  R1 =',F8.4,
     +'  for all anisotropically scaled data')
C
C Refine parameters and output results
C
  14  IF(N.LT.NP)GOTO 10
      NR=N/10
      WRITE(*,'(I7,A,I5,A/)')N-NR,' Data selected for refinement'//
     +' and',NR,' data for R(free) test'
      WRITE(LO,11)N-NR,SIG,NP,NR
      RT=999.
        DO 18 NC=1,50
        L=0
          DO 16 J=1,NP
          BM(J)=0.
            DO 15 K=1,J
            L=L+1
            AM(L)=0.
  15        CONTINUE
  16      CONTINUE
        CALL LSMADD(NP,X,N,RH,RK,RL,FF,FC,WT,SQ,AM,BM,DM,T,R,RF)
        WRITE(*,12)T,R,RF,NC
        WRITE(LO,12)T,R,RF,NC
        CALL FMLS(NP,AM,BM)
          DO 17 I=1,NP
          X(I)=X(I)+BM(I)
  17      CONTINUE
        IF(T.GT.RT-1.E-7)GOTO 19
        RT=T
  18    CONTINUE
  19  WRITE(LO,'(/A/(6F13.8))')' Refined parameter values:',
     +(X(I),I=1,NP)
C
C Set up .hkl file for writing
C
      KF(LN+1:LN+4)='.hkl'
      WRITE(*,'(/A/)')' THIS ROUTINE MAY OVERWRITE YOUR .hkl FILE !!'
  20  WRITE(*,FMT)' Name of HKLF 4 format file to be written (<CR>'//
     +' to NOT process data): '
      KR=' '
      READ(*,'(A)',ERR=20,END=20)KR
      CALL LINTRM(KR,N)
      NL=0
        DO 21 I=1,N
        IF(KR(I:I).EQ.' ')GOTO 21
        NL=NL+1
        KT(NL:NL)=KR(I:I)
  21    CONTINUE
      IF(NL.EQ.0)GOTO 30
      IF(INDEX(KT(1:NL),'.').NE.0)GOTO 22
      NL=NL+4
      KT(NL-3:NL)='.hkl'
  22  CALL WROPEN(LM,KT,NL,I)
      IF(I.NE.0)GOTO 9
C
C Write new .hkl file
C
      REWIND LF
      N=0
      R=0.
      T=0.
      V=0.
      W=0.
  23  KR=' '
      READ(LF,'(A)',ERR=23,END=10)KR
      IF(INDEX(KR,'_refln_phase_calc').EQ.0)GOTO 23
  24  KR=' '
      READ(LF,'(A)',ERR=24,END=29)KR
      CALL LINTRM(KR,I)
      IF(I.EQ.0)GOTO 24
      READ(KR,*,ERR=24,END=24)D
      Q=WW*(CELL(7)*D(1)**2+CELL(8)*D(2)**2+CELL(9)*D(3)**2+
     +CELL(10)*D(2)*D(3)+CELL(11)*D(1)*D(3)+CELL(12)*D(1)*D(2))
      DM(7)=D(1)**2
      DM(8)=D(2)**2
      DM(9)=D(3)**2
      DM(10)=D(2)*D(3)
      DM(11)=D(1)*D(3)
      DM(12)=D(1)*D(2)
        DO 25 J=1,6
        DM(J+6)=DM(J+6)
        DM(J)=DM(J+6)/Q
        DM(J+12)=DM(J+6)*Q
        DM(J+18)=DM(J+12)*Q
  25    CONTINUE
      P=0.
        DO 26 J=1,NP
        P=P+DM(J)*X(J)
  26    CONTINUE
      D(4)=D(4)/P
      D(5)=D(5)/P
      WG=1./(D(5)**2+(0.033333*(2.*D(6)**2+D(4)))**2)
      U=D(4)-D(6)**2
      R=R+WG*U**2
      T=T+WG*D(4)**2
      Q=SQRT(AMAX1(D(4),0.))
      V=V+ABS(ABS(D(6))-Q)
      W=W+Q
      N=N+1
      IF(D(4).GT.9999.99)GOTO 27
      IF(D(5).GT.9999.99)GOTO 27
      WRITE(LM,'(3I4,2F8.2)')INT(D(1)),INT(D(2)),INT(D(3)),D(4),D(5)
      GOTO 24
  27  IF(D(4).GT.99999.9)GOTO 28
      IF(D(5).GT.99999.9)GOTO 28
      WRITE(LM,'(3I4,2F8.1)')INT(D(1)),INT(D(2)),INT(D(3)),D(4),D(5)
      GOTO 24
  28  WRITE(LM,'(3I4,2F8.0)')INT(D(1)),INT(D(2)),INT(D(3)),D(4),D(5)
      GOTO 24
  29  I=0
      U=0.
      WRITE(LM,'(3I4,2F8.2)')I,I,I,U,U
      R=SQRT(R/T)
      V=V/W
      WRITE(*,13)N,KT(1:NL),R,V
      WRITE(LO,13)N,KT(1:NL),R,V
  30  CLOSE(LM,IOSTAT=I)
  31  RETURN
      END
C
C --------------------------------------------------------------------
C
      SUBROUTINE LSMADD(NP,X,N,RH,RK,RL,FF,FC,WT,SQ,AM,BM,DM,F2,F1,RF)
C
C Accumulate LS matrix and vector, calculate F2 = wR2 and F1 = R1.
C Every 10th reflection is not used for refinement, wR2 or R1, but
C contributes instead to RF = R1(free).
C
      REAL X(24),RH(N),RK(N),RL(N),FF(N),FC(N),WT(N),SQ(N)
      REAL*8 AM(600),BM(24),DM(24),TT,UU
      R=0.
      T=0.
      V=0.
      W=0.
      RF=0.
      RG=0.
        DO 6 I=1,N
        DM(7)=RH(I)**2
        DM(8)=RK(I)**2
        DM(9)=RL(I)**2
        DM(10)=RK(I)*RL(I)
        DM(11)=RH(I)*RL(I)
        DM(12)=RH(I)*RK(I)
        Q=SQ(I)
          DO 1 J=1,6
          DM(J+6)=DM(J+6)*FC(I)
          DM(J)=DM(J+6)/Q
          DM(J+12)=DM(J+6)*Q
          DM(J+18)=DM(J+12)*Q
   1      CONTINUE
        P=0.
          DO 2 J=1,NP
          P=P+DM(J)*X(J)
   2      CONTINUE
        U=FF(I)-P
        R=R+WT(I)*U**2
        T=T+WT(I)*FF(I)**2
        Q=SQRT(AMAX1(FF(I),0.))
        S=ABS(SQRT(AMAX1(P,0.))-Q)
        IF(MOD(I,10).NE.0)GOTO 3
        RF=RF+S
        RG=RG+Q
        GOTO 6
   3    V=V+S
        W=W+Q
        UU=U
        L=0
          DO 5 J=1,NP
          TT=WT(I)*DM(J)
          BM(J)=BM(J)+UU*TT
            DO 4 K=1,J
            L=L+1
            AM(L)=AM(L)+TT*DM(K)
   4        CONTINUE
   5      CONTINUE
   6    CONTINUE
      F2=SQRT(R/T)
      F1=V/W
      RF=RF/RG
      RETURN
      END
C
C --------------------------------------------------------------------
C
      SUBROUTINE FMLS(NN,A,D)
C
C Find L.S. shifts given a least-squares matrix for NN parameters
C stored in lower triangular form in A(1..NN*(NN+1)) and a L.S. vector
C D(1..NN).  The shifts are returned in D and matrix A is destroyed.
C
      IMPLICIT REAL*8(A-H,O-Z)
      REAL*8 A(600),D(24)
C
C Estimate damping factor S (1/1000000 of mean diagonal element)
C
      S=0.
      K=1
        DO 1 N=1,NN
        S=S+A(K)
        K=K+1+N
   1    CONTINUE
      S=0.000001*S/REAL(NN)
C
C Cholesky factorization and scaling to minimize rounding errors
C
      I=0
        DO 5 N=1,NN
        I=I+1
        L=I
        M=1
        J=1
   2    IF(J.EQ.I)GOTO 4
        A(I)=A(I)*A(J)
        D(N)=D(N)-A(I)*D(M)
        M=M+1
        NI=I
        I=I+1
        J=J+1
        T=A(I)
          DO 3 K=L,NI
          T=T-A(J)*A(K)
          J=J+1
   3      CONTINUE
        A(I)=T
        GOTO 2
   4    A(I)=1./SQRT(S+A(I))
        D(N)=D(N)*A(I)
   5    CONTINUE
C
C Calculate shifts
C
      T=D(M)
   6  D(M)=T*A(I)
      I=I-M
      M=M-1
      IF(M.LT.1)GOTO 8
      T=D(M)
      K=I+M
        DO 7 N=M+1,NN
        T=T-D(N)*A(K)
        K=K+N
   7    CONTINUE
      GOTO 6
   8  RETURN
      END
C
C --------------------------------------------------------------------
C
      SUBROUTINE PDBINS(A,NEW,ID,IY,NRN,NTN,NTC)
C
C Read a PDB file and generate a SHELXL .ins file.  The PDB file is
C assumed to conform to the Protein Data Bank notes "Atomic Coordinate
C and Bibliographic Entry Format Description", but related formats
C (e.g. CCP4 and XPLOR) can usually be converted (the program will ask
C for the missing cell, symmetry etc). A summary of the residue and
C atom names is written to the .pro file for subsequent reference.
C
      CHARACTER KI*1,KT*1,KJ*2,KC*4,RC*4,RN*4
      CHARACTER KM(99)*2,KQ*4,IW*9,KS*80,KZ*80,KY*55
      INTEGER ID(10000),IY(10000),NRN(10000),NTN(10000),NTC(10000)
      INTEGER NEW(10000)
      REAL A(10000),E(6),F(99),UU(6),UO(6),G(3)
      COMMON/XTAL/SY(12,192),CELL(15),II(1369),NS,LAT,LU,LN,
     +LO,LP,LF,LM,LS,NOS,IER,NPG
      COMMON/WORD/KF,KR,KD,KE,KA,KB,KN,FMT,COL,OPT
      CHARACTER KF*80,KR*80,KD(462)*52,KA(50000)*4,KE(9999)*4,
     +KB(250)*80,KN(10000)*9,FMT*20,COL*4,OPT*1
C
      KD(1)='RTAB_* Cvol CA'
      KD(2)='RTAB_* Omeg CA_+ N_+ C CA'
      KD(3)='RTAB_* Phi C_- N CA C'
      KD(4)='RTAB_* Psi N CA C N_+'
      KD(5)='DFIX_* 1.329 C_- N'
      KD(6)='DANG_* 2.425 CA_- N'
      KD(7)='DANG_* 2.250 O_- N'
      KD(8)='DANG_* 2.435 C_- CA'
      KD(9)='FLAT_* 0.5 O_- CA_- N C_- CA'
      KD(10)='REM HFIX_ALA 43 N'
      KD(11)='REM HFIX_ALA 13 CA'
      KD(12)='REM HFIX_ALA 33 CB'
      KD(13)='CHIV_ALA C'
      KD(14)='CHIV_ALA 2.477 CA'
      KD(15)='DFIX_ALA 1.231 C O'
      KD(16)='DFIX_ALA 1.525 C CA'
      KD(17)='DFIX_ALA 1.521 CA CB'
      KD(18)='DFIX_ALA 1.458 N CA'
      KD(19)='DANG_ALA 2.462 C N'
      KD(20)='DANG_ALA 2.401 O CA'
      KD(21)='DANG_ALA 2.503 C CB'
      KD(22)='DANG_ALA 2.446 CB N'
      KD(23)='REM HFIX_ARG 13 CA'
      KD(24)='REM HFIX_ARG 23 CB CG CD'
      KD(25)='REM HFIX_ARG 43 N NE'
      KD(26)='REM HFIX_ARG 93 NH1 NH2'
      KD(27)='RTAB_ARG Chi1 N CA CB CG'
      KD(28)='RTAB_ARG Chi2 CA CB CG CD'
      KD(29)='RTAB_ARG Chi3 CB CG CD NE'
      KD(30)='RTAB_ARG Chi4 CG CD NE CZ'
      KD(31)='CHIV_ARG C CZ'
      KD(32)='CHIV_ARG 2.503 CA'
      KD(33)='FLAT_ARG CD NH1 NH2 NE CZ'
      KD(34)='DFIX_ARG 1.231 C O'
      KD(35)='DFIX_ARG 1.458 CA N'
      KD(36)='DFIX_ARG 1.525 C CA'
      KD(37)='DFIX_ARG 1.530 CA CB'
      KD(38)='DFIX_ARG 1.520 CB CG CG CD'
      KD(39)='DFIX_ARG 1.460 CD NE'
      KD(40)='DFIX_ARG 1.326 CZ NE CZ NH1 CZ NH2'
      KD(41)='DANG_ARG 2.455 N CB'
      KD(42)='DANG_ARG 2.401 O CA'
      KD(43)='DANG_ARG 2.504 C CB'
      KD(44)='DANG_ARG 2.462 C N'
      KD(45)='DANG_ARG 2.559 CA CG'
      KD(46)='DANG_ARG 2.510 CB CD'
      KD(47)='DANG_ARG 2.471 CG NE'
      KD(48)='DANG_ARG 2.466 CD CZ'
      KD(49)='DANG_ARG 2.299 NE NH1 NE NH2'
      KD(50)='DANG_ARG 2.293 NH1 NH2'
      KD(51)='REM HFIX_ASN 43 N'
      KD(52)='REM HFIX_ASN 13 CA'
      KD(53)='REM HFIX_ASN 23 CB'
      KD(54)='REM HFIX_ASN 93 ND2'
      KD(55)='RTAB_ASN Chi1 N CA CB CG'
      KD(56)='RTAB_ASN Chi2 CA CB CG OD1'
      KD(57)='CHIV_ASN C CG'
      KD(58)='CHIV_ASN 2.503 CA'
      KD(59)='DFIX_ASN 1.231 C O CG OD1'
      KD(60)='DFIX_ASN 1.525 C CA'
      KD(61)='DFIX_ASN 1.458 N CA'
      KD(62)='DFIX_ASN 1.530 CA CB'
      KD(63)='DFIX_ASN 1.516 CB CG'
      KD(64)='DFIX_ASN 1.328 CG ND2'
      KD(65)='DANG_ASN 2.401 O CA'
      KD(66)='DANG_ASN 2.462 C N'
      KD(67)='DANG_ASN 2.455 CB N'
      KD(68)='DANG_ASN 2.504 C CB'
      KD(69)='DANG_ASN 2.534 CA CG'
      KD(70)='DANG_ASN 2.393 CB OD1'
      KD(71)='DANG_ASN 2.419 CB ND2'
      KD(72)='DANG_ASN 2.245 OD1 ND2'
      KD(73)='REM HFIX_ASP 43 N'
      KD(74)='REM HFIX_ASP 13 CA'
      KD(75)='REM HFIX_ASP 23 CB'
      KD(76)='RTAB_ASP Chi1 N CA CB CG'
      KD(77)='RTAB_ASP Chi2 CA CB CG OD1'
      KD(78)='CHIV_ASP C CG'
      KD(79)='CHIV_ASP 2.503 CA'
      KD(80)='DFIX_ASP 1.231 C O'
      KD(81)='DFIX_ASP 1.525 C CA'
      KD(82)='DFIX_ASP 1.530 CA CB'
      KD(83)='DFIX_ASP 1.516 CB CG'
      KD(84)='DFIX_ASP 1.458 CA N'
      KD(85)='DFIX_ASP 1.249 CG OD1 CG OD2'
      KD(86)='DANG_ASP 2.401 O CA'
      KD(87)='DANG_ASP 2.462 C N'
      KD(88)='DANG_ASP 2.455 CB N'
      KD(89)='DANG_ASP 2.504 C CB'
      KD(90)='DANG_ASP 2.534 CA CG'
      KD(91)='DANG_ASP 2.379 CB OD1 CB OD2'
      KD(92)='DANG_ASP 2.194 OD1 OD2'
      KD(93)='REM HFIX_CYS 43 N'
      KD(94)='REM HFIX_CYS 13 CA'
      KD(95)='REM HFIX_CYS 23 CB'
      KD(96)='RTAB_CYS Chi1 N CA CB SG'
      KD(97)='CHIV_CYS C'
      KD(98)='CHIV_CYS 2.503 CA'
      KD(99)='DFIX_CYS 1.231 C O'
      KD(100)='DFIX_CYS 1.525 C CA'
      KD(101)='DFIX_CYS 1.458 N CA'
      KD(102)='DFIX_CYS 1.530 CA CB'
      KD(103)='DFIX_CYS 1.808 CB SG'
      KD(104)='DANG_CYS 2.401 O CA'
      KD(105)='DANG_CYS 2.504 C CB'
      KD(106)='DANG_CYS 2.455 CB N'
      KD(107)='DANG_CYS 2.462 C N'
      KD(108)='DANG_CYS 2.810 CA SG'
      KD(109)='REM HFIX_GLN 43 N'
      KD(110)='REM HFIX_GLN 13 CA'
      KD(111)='REM HFIX_GLN 23 CB CG'
      KD(112)='REM HFIX_GLN 93 NE2'
      KD(113)='RTAB_GLN Chi1 N CA CB CG'
      KD(114)='RTAB_GLN Chi2 CA CB CG CD'
      KD(115)='RTAB_GLN Chi3 CB CG CD OE1'
      KD(116)='CHIV_GLN C CD'
      KD(117)='CHIV_GLN 2.503 CA'
      KD(118)='DFIX_GLN 1.231 C O'
      KD(119)='DFIX_GLN 1.458 N CA'
      KD(120)='DFIX_GLN 1.525 C CA'
      KD(121)='DFIX_GLN 1.530 CA CB'
      KD(122)='DFIX_GLN 1.520 CB CG'
      KD(123)='DFIX_GLN 1.516 CG CD'
      KD(124)='DFIX_GLN 1.231 CD OE1'
      KD(125)='DFIX_GLN 1.328 CD NE2'
      KD(126)='DANG_GLN 2.401 O CA'
      KD(127)='DANG_GLN 2.462 C N'
      KD(128)='DANG_GLN 2.455 CB N'
      KD(129)='DANG_GLN 2.504 C CB'
      KD(130)='DANG_GLN 2.559 CA CG'
      KD(131)='DANG_GLN 2.526 CB CD'
      KD(132)='DANG_GLN 2.393 CG OE1'
      KD(133)='DANG_GLN 2.419 CG NE2'
      KD(134)='DANG_GLN 2.245 OE1 NE2'
      KD(135)='REM HFIX_GLU 43 N'
      KD(136)='REM HFIX_GLU 13 CA'
      KD(137)='REM HFIX_GLU 23 CB CG'
      KD(138)='RTAB_GLU Chi1 N CA CB CG'
      KD(139)='RTAB_GLU Chi2 CA CB CG CD'
      KD(140)='RTAB_GLU Chi3 CB CG CD OE1'
      KD(141)='CHIV_GLU C CD'
      KD(142)='CHIV_GLU 2.503 CA'
      KD(143)='DFIX_GLU 1.231 C O'
      KD(144)='DFIX_GLU 1.458 N CA'
      KD(145)='DFIX_GLU 1.525 C CA'
      KD(146)='DFIX_GLU 1.530 CA CB'
      KD(147)='DFIX_GLU 1.520 CB CG'
      KD(148)='DFIX_GLU 1.516 CG CD'
      KD(149)='DFIX_GLU 1.249 CD OE1 CD OE2'
      KD(150)='DANG_GLU 2.401 O CA'
      KD(151)='DANG_GLU 2.462 C N'
      KD(152)='DANG_GLU 2.455 CB N'
      KD(153)='DANG_GLU 2.504 C CB'
      KD(154)='DANG_GLU 2.559 CA CG'
      KD(155)='DANG_GLU 2.526 CB CD'
      KD(156)='DANG_GLU 2.379 CG OE1 CG OE2'
      KD(157)='DANG_GLU 2.194 OE1 OE2'
      KD(158)='REM HFIX_GLY 43 N'
      KD(159)='REM HFIX_GLY 23 CA'
      KD(160)='CHIV_GLY C'
      KD(161)='DFIX_GLY 1.231 O C'
      KD(162)='DFIX_GLY 1.516 C CA'
      KD(163)='DFIX_GLY 1.451 CA N'
      KD(164)='DANG_GLY 2.467 C N'
      KD(165)='DANG_GLY 2.393 O CA'
      KD(166)='REM HFIX_HIS 13 CA'
      KD(167)='REM HFIX_HIS 23 CB'
      KD(168)='REM HFIX_HIS 43 N ND1 CE1 CD2'
      KD(169)='RTAB_HIS Chi1 N CA CB CG'
      KD(170)='RTAB_HIS Chi2 CA CB CG ND1'
      KD(171)='FLAT_HIS CB ND1 NE2 CD2 CE1 CG'
      KD(172)='CHIV_HIS C'
      KD(173)='CHIV_HIS 2.503 CA'
      KD(174)='DFIX_HIS 1.231 C O'
      KD(175)='DFIX_HIS 1.525 C CA'
      KD(176)='DFIX_HIS 1.458 CA N'
      KD(177)='DFIX_HIS 1.530 CA CB'
      KD(178)='DFIX_HIS 1.497 CB CG'
      KD(179)='DFIX_HIS 1.378 CG ND1'
      KD(180)='DFIX_HIS 1.321 ND1 CE1 CE1 NE2'
      KD(181)='DFIX_HIS 1.374 NE2 CD2'
      KD(182)='DFIX_HIS 1.354 CD2 CG'
      KD(183)='DANG_HIS 2.401 O CA'
      KD(184)='DANG_HIS 2.462 C N'
      KD(185)='DANG_HIS 2.504 C CB'
      KD(186)='DANG_HIS 2.455 N CB'
      KD(187)='DANG_HIS 2.536 CA CG'
      KD(188)='DANG_HIS 2.524 CB ND1'
      KD(189)='DANG_HIS 2.597 CB CD2'
      KD(190)='DANG_HIS 2.202 CG CE1'
      KD(191)='DANG_HIS 2.196 CG NE2'
      KD(192)='DANG_HIS 2.194 CE1 CD2'
      KD(193)='DANG_HIS 2.143 ND1 NE2'
      KD(194)='DANG_HIS 2.170 ND1 CD2'
      KD(195)='REM HFIX_ILE 43 N'
      KD(196)='REM HFIX_ILE 13 CA CB'
      KD(197)='REM HFIX_ILE 23 CG1'
      KD(198)='REM HFIX_ILE 33 CD1 CG2'
      KD(199)='RTAB_ILE Chi1 N CA CB CG1'
      KD(200)='RTAB_ILE Chi2 CA CB CG1 CD1'
      KD(201)='RTAB_ILE Cvol CB'
      KD(202)='CHIV_ILE C'
      KD(203)='CHIV_ILE 2.516 CA'
      KD(204)='CHIV_ILE 2.495 CB'
      KD(205)='DFIX_ILE 1.231 C O'
      KD(206)='DFIX_ILE 1.525 C CA'
      KD(207)='DFIX_ILE 1.458 CA N'
      KD(208)='DFIX_ILE 1.540 CA CB'
      KD(209)='DFIX_ILE 1.530 CB CG1'
      KD(210)='DFIX_ILE 1.521 CB CG2'
      KD(211)='DFIX_ILE 1.513 CG1 CD1'
      KD(212)='DANG_ILE 2.401 O CA'
      KD(213)='DANG_ILE 2.462 C N'
      KD(214)='DANG_ILE 2.479 N CB'
      KD(215)='DANG_ILE 2.576 CA CG1'
      KD(216)='DANG_ILE 2.515 CA CG2'
      KD(217)='DANG_ILE 2.549 CB CD1'
      KD(218)='DANG_ILE 2.510 CG1 CG2'
      KD(219)='DANG_ILE 2.497 C CB'
      KD(220)='REM HFIX_LEU 43 N'
      KD(221)='REM HFIX_LEU 13 CA CG'
      KD(222)='REM HFIX_LEU 23 CB'
      KD(223)='REM HFIX_LEU 33 CD1 CD2'
      KD(224)='RTAB_LEU Chi1 N CA CB CG'
      KD(225)='RTAB_LEU Chi2 CA CB CG CD1'
      KD(226)='CHIV_LEU C'
      KD(227)='CHIV_LEU 2.503 CA'
      KD(228)='CHIV_LEU -2.589 CG'
      KD(229)='DFIX_LEU 1.231 C O'
      KD(230)='DFIX_LEU 1.525 C CA'
      KD(231)='DFIX_LEU 1.458 N CA'
      KD(232)='DFIX_LEU 1.530 CA CB CB CG'
      KD(233)='DFIX_LEU 1.521 CG CD1 CG CD2'
      KD(234)='DANG_LEU 2.401 O CA'
      KD(235)='DANG_LEU 2.462 C N'
      KD(236)='DANG_LEU 2.455 N CB'
      KD(237)='DANG_LEU 2.504 C CB'
      KD(238)='DANG_LEU 2.599 CA CG'
      KD(239)='DANG_LEU 2.510 CB CD1 CB CD2'
      KD(240)='DANG_LEU 2.504 CD1 CD2'
      KD(241)='REM HFIX_LYS 43 N'
      KD(242)='REM HFIX_LYS 13 CA'
      KD(243)='REM HFIX_LYS 23 CB CG CD CE'
      KD(244)='REM HFIX_LYS 33 NZ'
      KD(245)='RTAB_LYS Chi1 N CA CB CG'
      KD(246)='RTAB_LYS Chi2 CA CB CG CD'
      KD(247)='RTAB_LYS Chi3 CB CG CD CE'
      KD(248)='RTAB_LYS Chi4 CG CD CE NZ'
      KD(249)='CHIV_LYS C'
      KD(250)='CHIV_LYS 2.503 CA'
      KD(251)='DFIX_LYS 1.231 C O'
      KD(252)='DFIX_LYS 1.525 C CA'
      KD(253)='DFIX_LYS 1.458 CA N'
      KD(254)='DFIX_LYS 1.530 CA CB'
      KD(255)='DFIX_LYS 1.520 CB CG CG CD CD CE'
      KD(256)='DFIX_LYS 1.489 CE NZ'
      KD(257)='DANG_LYS 2.401 O CA'
      KD(258)='DANG_LYS 2.462 C N'
      KD(259)='DANG_LYS 2.455 N CB'
      KD(260)='DANG_LYS 2.504 C CB'
      KD(261)='DANG_LYS 2.559 CA CG'
      KD(262)='DANG_LYS 2.510 CB CD CG CE'
      KD(263)='DANG_LYS 2.493 CD NZ'
      KD(264)='REM HFIX_MET 43 N'
      KD(265)='REM HFIX_MET 13 CA'
      KD(266)='REM HFIX_MET 23 CB CG'
      KD(267)='REM HFIX_MET 33 CE'
      KD(268)='RTAB_MET Chi1 N CA CB CG'
      KD(269)='RTAB_MET Chi2 CA CB CG SD'
      KD(270)='RTAB_MET Chi3 CB CG SD CE'
      KD(271)='CHIV_MET C'
      KD(272)='CHIV_MET 2.503 CA'
      KD(273)='DFIX_MET 1.231 C O'
      KD(274)='DFIX_MET 1.458 N CA'
      KD(275)='DFIX_MET 1.525 C CA'
      KD(276)='DFIX_MET 1.530 CA CB'
      KD(277)='DFIX_MET 1.520 CB CG'
      KD(278)='DFIX_MET 1.803 CG SD'
      KD(279)='DFIX_MET 1.791 SD CE'
      KD(280)='DANG_MET 2.401 O CA'
      KD(281)='DANG_MET 2.462 C N'
      KD(282)='DANG_MET 2.455 N CB'
      KD(283)='DANG_MET 2.559 CA CG'
      KD(284)='DANG_MET 2.771 CB SD'
      KD(285)='DANG_MET 2.504 C CB'
      KD(286)='DANG_MET 2.771 CG CE'
      KD(287)='REM HFIX_PHE 13 CA'
      KD(288)='REM HFIX_PHE 23 CB'
      KD(289)='REM HFIX_PHE 43 N CD1 CD2 CE1 CE2 CZ'
      KD(290)='RTAB_PHE Chi1 N CA CB CG'
      KD(291)='RTAB_PHE Chi2 CA CB CG CD1'
      KD(292)='FLAT_PHE CG CD1 CE2 CB CD2 CE1 CZ'
      KD(293)='CHIV_PHE C'
      KD(294)='CHIV_PHE 2.503 CA'
      KD(295)='DFIX_PHE 1.231 C O'
      KD(296)='DFIX_PHE 1.458 N CA'
      KD(297)='DFIX_PHE 1.525 C CA'
      KD(298)='DFIX_PHE 1.530 CA CB'
      KD(299)='DFIX_PHE 1.520 CB CG'
      KD(300)='DFIX_PHE 1.384 CG CD1 CG CD2'
      KD(301)='DFIX_PHE 1.382 CD1 CE1 CD2 CE2 CE1 CZ CE2 CZ'
      KD(302)='DANG_PHE 2.401 O CA'
      KD(303)='DANG_PHE 2.462 C N'
      KD(304)='DANG_PHE 2.504 C CB'
      KD(305)='DANG_PHE 2.455 N CB'
      KD(306)='DANG_PHE 2.555 CA CG'
      KD(307)='DANG_PHE 2.525 CB CD1 CB CD2'
      KD(308)='DANG_PHE 2.404 CG CE1 CG CE2'
      KD(309)='DANG_PHE 2.394 CD1 CZ CD2 CZ CE1 CE2'
      KD(310)='DANG_PHE 2.380 CD1 CD2'
      KD(311)='REM HFIX_PRO 13 CA'
      KD(312)='REM HFIX_PRO 23 CB CG CD'
      KD(313)='RTAB_PRO Chi1 N CA CB CG'
      KD(314)='RTAB_PRO Chi2 CA CB CG CD'
      KD(315)='RTAB_PRO Chi3 CB CG CD N'
      KD(316)='CHIV_PRO C N'
      KD(317)='CHIV_PRO 2.728 CA'
      KD(318)='DFIX_PRO 1.231 C O'
      KD(319)='DFIX_PRO 1.525 C CA'
      KD(320)='DFIX_PRO 1.466 CA N'
      KD(321)='DFIX_PRO 1.473 N CD'
      KD(322)='DFIX_PRO 1.503 CD CG'
      KD(323)='DFIX_PRO 1.492 CG CB'
      KD(324)='DFIX_PRO 1.530 CB CA'
      KD(325)='DANG_PRO 2.401 O CA'
      KD(326)='DANG_PRO 2.477 C N'
      KD(327)='DANG_PRO 2.504 C CB'
      KD(328)='DANG_PRO 2.437 CA CD'
      KD(329)='DANG_PRO 2.332 N CG'
      KD(330)='DANG_PRO 2.393 CD CB'
      KD(331)='DANG_PRO 2.390 CA CG'
      KD(332)='DANG_PRO 2.345 N CB'
      KD(333)='DANG_PRO 2.497 CD C_-'
      KD(334)='REM HFIX_SER 43 N'
      KD(335)='REM HFIX_SER 13 CA'
      KD(336)='REM HFIX_SER 23 CB'
      KD(337)='REM HFIX_SER 83 OG'
      KD(338)='RTAB_SER Chi1 N CA CB OG'
      KD(339)='CHIV_SER C'
      KD(340)='CHIV_SER 2.503 CA'
      KD(341)='DFIX_SER 1.231 C O'
      KD(342)='DFIX_SER 1.525 C CA'
      KD(343)='DFIX_SER 1.458 N CA'
      KD(344)='DFIX_SER 1.530 CA CB'
      KD(345)='DFIX_SER 1.417 CB OG'
      KD(346)='DANG_SER 2.401 O CA'
      KD(347)='DANG_SER 2.462 C N'
      KD(348)='DANG_SER 2.504 C CB'
      KD(349)='DANG_SER 2.455 N CB'
      KD(350)='DANG_SER 2.431 CA OG'
      KD(351)='REM HFIX_THR 43 N'
      KD(352)='REM HFIX_THR 13 CA CB'
      KD(353)='REM HFIX_THR 33 CG2'
      KD(354)='REM HFIX_THR 83 OG1'
      KD(355)='RTAB_THR Chi1 N CA CB OG1'
      KD(356)='RTAB_THR Cvol CB'
      KD(357)='CHIV_THR C'
      KD(358)='CHIV_THR 2.516 CA'
      KD(359)='CHIV_THR -2.628 CB'
      KD(360)='DFIX_THR 1.231 C O'
      KD(361)='DFIX_THR 1.525 C CA'
      KD(362)='DFIX_THR 1.458 N CA'
      KD(363)='DFIX_THR 1.540 CA CB'
      KD(364)='DFIX_THR 1.433 CB OG1'
      KD(365)='DFIX_THR 1.521 CB CG2'
      KD(366)='DANG_THR 2.401 O CA'
      KD(367)='DANG_THR 2.462 C N'
      KD(368)='DANG_THR 2.497 C CB'
      KD(369)='DANG_THR 2.479 N CB'
      KD(370)='DANG_THR 2.430 CA OG1'
      KD(371)='DANG_THR 2.515 CA CG2'
      KD(372)='DANG_THR 2.373 OG1 CG2'
      KD(373)='REM HFIX_TRP 13 CA'
      KD(374)='REM HFIX_TRP 23 CB'
      KD(375)='REM HFIX_TRP 43 N CD1 NE1 CZ2 CH2 CZ3 CE3'
      KD(376)='RTAB_TRP Chi1 N CA CB CG'
      KD(377)='RTAB_TRP Chi2 CA CB CG CD1'
      KD(378)='FLAT_TRP CB CE2 CZ3 CG CD1 NE1 CD2 CZ2 CH2 CE3'
      KD(379)='CHIV_TRP C'
      KD(380)='CHIV_TRP 2.503 CA'
      KD(381)='DFIX_TRP 1.231 C O'
      KD(382)='DFIX_TRP 1.525 C CA'
      KD(383)='DFIX_TRP 1.458 N CA'
      KD(384)='DFIX_TRP 1.530 CA CB'
      KD(385)='DFIX_TRP 1.498 CB CG'
      KD(386)='DFIX_TRP 1.365 CG CD1'
      KD(387)='DFIX_TRP 1.374 CD1 NE1'
      KD(388)='DFIX_TRP 1.370 NE1 CE2'
      KD(389)='DFIX_TRP 1.394 CE2 CZ2'
      KD(390)='DFIX_TRP 1.368 CZ2 CH2'
      KD(391)='DFIX_TRP 1.400 CH2 CZ3'
      KD(392)='DFIX_TRP 1.382 CZ3 CE3'
      KD(393)='DFIX_TRP 1.398 CE3 CD2'
      KD(394)='DFIX_TRP 1.433 CD2 CG'
      KD(395)='DFIX_TRP 1.409 CD2 CE2'
      KD(396)='DANG_TRP 2.401 O CA'
      KD(397)='DANG_TRP 2.462 C N'
      KD(398)='DANG_TRP 2.504 C CB'
      KD(399)='DANG_TRP 2.455 N CB'
      KD(400)='DANG_TRP 2.534 CA CG'
      KD(401)='DANG_TRP 2.562 CB CD1'
      KD(402)='DANG_TRP 2.621 CB CD2'
      KD(403)='DANG_TRP 2.246 CG NE1'
      KD(404)='DANG_TRP 2.605 CG CE3'
      KD(405)='DANG_TRP 2.288 CG CE2'
      KD(406)='DANG_TRP 2.233 CD1 CE2'
      KD(407)='DANG_TRP 2.239 CD1 CD2'
      KD(408)='DANG_TRP 2.240 NE1 CD2'
      KD(409)='DANG_TRP 2.361 CE2 CH2'
      KD(410)='DANG_TRP 2.416 CE2 CE3'
      KD(411)='DANG_TRP 2.390 CD2 CZ3'
      KD(412)='DANG_TRP 2.456 CD2 CZ2'
      KD(413)='DANG_TRP 2.423 CE3 CH2'
      KD(414)='DANG_TRP 2.415 CZ3 CZ2'
      KD(415)='DANG_TRP 2.506 NE1 CZ2'
      KD(416)='REM HFIX_TYR 13 CA'
      KD(417)='REM HFIX_TYR 23 CB'
      KD(418)='REM HFIX_TYR 43 N CD1 CD2 CE1 CE2'
      KD(419)='REM HFIX_TYR 83 OH'
      KD(420)='RTAB_TYR Chi1 N CA CB CG'
      KD(421)='RTAB_TYR Chi2 CA CB CG CD1'
      KD(422)='FLAT_TYR CB CD1 CE2 CG CD2 CE1 CZ OH'
      KD(423)='CHIV_TYR C'
      KD(424)='CHIV_TYR 2.503 CA'
      KD(425)='DFIX_TYR 1.231 C O'
      KD(426)='DFIX_TYR 1.458 N CA'
      KD(427)='DFIX_TYR 1.525 C CA'
      KD(428)='DFIX_TYR 1.530 CA CB'
      KD(429)='DFIX_TYR 1.512 CB CG'
      KD(430)='DFIX_TYR 1.389 CG CD2 CG CD1'
      KD(431)='DFIX_TYR 1.382 CD2 CE2 CD1 CE1'
      KD(432)='DFIX_TYR 1.378 CE2 CZ CE1 CZ'
      KD(433)='DFIX_TYR 1.376 CZ OH'
      KD(434)='DANG_TYR 2.401 O CA'
      KD(435)='DANG_TYR 2.462 C N'
      KD(436)='DANG_TYR 2.455 N CB'
      KD(437)='DANG_TYR 2.504 C CB'
      KD(438)='DANG_TYR 2.550 CA CG'
      KD(439)='DANG_TYR 2.523 CB CD1 CB CD2'
      KD(440)='DANG_TYR 2.414 CG CE1 CG CE2'
      KD(441)='DANG_TYR 2.385 CZ CD1 CZ CD2'
      KD(442)='DANG_TYR 2.384 OH CE1 OH CE2'
      KD(443)='DANG_TYR 2.382 CD1 CD2'
      KD(444)='DANG_TYR 2.390 CE1 CE2'
      KD(445)='REM HFIX_VAL 43 N'
      KD(446)='REM HFIX_VAL 13 CA CB'
      KD(447)='REM HFIX_VAL 33 CG1 CG2'
      KD(448)='RTAB_VAL Chi1 N CA CB CG1'
      KD(449)='CHIV_VAL C'
      KD(450)='CHIV_VAL 2.516 CA'
      KD(451)='CHIV_VAL -2.622 CB'
      KD(452)='DFIX_VAL 1.231 C O'
      KD(453)='DFIX_VAL 1.458 N CA'
      KD(454)='DFIX_VAL 1.525 C CA'
      KD(455)='DFIX_VAL 1.540 CA CB'
      KD(456)='DFIX_VAL 1.521 CB CG2 CB CG1'
      KD(457)='DANG_VAL 2.401 O CA'
      KD(458)='DANG_VAL 2.462 C N'
      KD(459)='DANG_VAL 2.497 C CB'
      KD(460)='DANG_VAL 2.515 CA CG1 CA CG2'
      KD(461)='DANG_VAL 2.479 N CB'
      KD(462)='DANG_VAL 2.504 CG1 CG2'
C
C Initilize flags etc.
C
      NT=0
      NS=1
      NL=1
      NZ=0
      MRN=0
      MTN=0
      MTC=0
      IZ=4
      KY='P212121'
C
C Set up scratch, .ins and .ent (PDB) files
C
      CLOSE(LM,IOSTAT=I)
      OPEN(UNIT=LM,STATUS='SCRATCH',FORM='UNFORMATTED',ERR=153)
      KF(LN+1:LN+4)='.ins'
   1  WRITE(*,FMT)' Enter name of .ins file ['//KF(1:LN+4)//']: '
      KS=' '
      READ(*,'(A)',ERR=1,END=1)KS
      CALL LINTRM(KS,N)
      L=0
        DO 2 I=1,N
        IF(KS(I:I).EQ.' ')GOTO 2
        L=L+1
        KS(L:L)=KS(I:I)
   2    CONTINUE
      IF(L.GT.0)GOTO 3
      KS=KF
      L=LN+4
      GOTO 4
   3  IF(INDEX(KS,'.').NE.0)GOTO 4
      L=L+4
      KS(L-3:L)='.ins'
   4  CALL WROPEN(LS,KS,L,I)
      IF(I.NE.0)GOTO 154
      KF(LN+1:LN+4)='.ent'
      WRITE(*,FMT)' Enter name of PDB file ['//KF(1:LN+4)//']: '
      KR=' '
      READ(*,'(A)')KR
      CALL LINTRM(KR,N)
      N=0
        DO 5 I=1,80
        IF(KR(I:I).EQ.' ')GOTO 5
        N=N+1
        KR(N:N)=KR(I:I)
   5    CONTINUE
      IF(N.GT.0)GOTO 6
      KR=KF
      N=LN+4
      GOTO 7
   6  IF(INDEX(KR,'.').NE.0)GOTO 7
      N=N+4
      KR(N-3:N)='.ent'
   7  OPEN(UNIT=LF,FILE=KR(1:N),STATUS='OLD',ERR=155)
      WRITE(LO,8)KR(1:N),KS(1:L)
   8  FORMAT(/1X,78('=')//' Converting PDB file ',A,
     +' to SHELXL instruction file ',A)
C
C Prompt for TITL and write to .ins file
C
   9  WRITE(*,FMT)' Enter title ['//KF(1:LN)//']: '
      KR=' '
      READ(*,'(A)',ERR=9,END=9)KR
      CALL LINTRM(KR,N)
      IF(N.GT.0)GOTO 10
      KR=KF(1:LN)
      N=LN
  10  WRITE(LS,'(A)')'TITL '//KR(1:N)
      WRITE(LO,'(/A)')' TITL '//KR(1:N)
C
C Extract CELL, Z and space group from PDB file
C
  11  CELL(6)=-999.
  12  KR=' '
      READ(LF,'(A)',ERR=15,END=15)KR
      IF(KR(1:6).NE.'CRYST1')GOTO 12
      CALL LINTRM(KR,N)
      READ(KR,'(6X,3F9.3,3F7.2)',ERR=11,END=11)(CELL(I),I=1,6)
        DO 13 I=1,3
        IF(CELL(I).LT.2.)GOTO 11
        IF(CELL(I+3).LT.20.)GOTO 11
        IF(CELL(I+3).GT.160.)GOTO 11
  13    CONTINUE
      IF(N.GT.66)READ(KR,'(66X,I4)',ERR=14,END=14)IZ
  14  KR(1:11)=KR(56:66)
      KR(12:80)=' '
      CALL LINTRM(KR,N)
      IF(N.GT.0)KY(1:11)=KR(1:11)
  15  REWIND LF
      KS=' '
      L=1
      IF(CELL(6).LT.0.)GOTO 17
      WRITE(KR,'(3(F10.3,A1),2(F9.2,A1),F9.2)')
     +(CELL(I),'$',I=1,5),CELL(6)
      L=0
        DO 16 I=1,62
        IF(KR(I:I).EQ.' ')GOTO 16
        L=L+1
        KS(L:L)=KR(I:I)
        IF(KS(L:L).EQ.'$')KS(L:L)=' '
  16    CONTINUE
C
C Prompt user for alternative cell and Z
C
  17  KR=' '
      WRITE(*,'(A)')' CELL in Angstroms and deg. ['//KS(1:L)//']:'
      WRITE(*,FMT)' '
      READ(*,'(A)',ERR=17,END=17)KR
      CALL LINTRM(KR,I)
      IF(I.EQ.0)GOTO 19
      READ(KR,*,ERR=17,END=17)(CELL(I),I=1,6)
        DO 18 I=1,3
        IF(CELL(I).LT.2.)GOTO 17
        IF(CELL(I+3).LT.20.)GOTO 17
        IF(CELL(I+3).GT.160.)GOTO 17
  18    CONTINUE
  19  WRITE(KR,'(I5)')IZ
      L=0
        DO 20 I=1,5
        IF(KR(I:I).EQ.' ')GOTO 20
        L=L+1
        KS(L:L)=KR(I:I)
  20    CONTINUE
  21  KR=' '
      WRITE(*,FMT)' Enter Z (number of molecules per cell) ['//
     +KS(1:L)//']: '
      READ(*,'(A)')KR
      CALL LINTRM(KR,I)
      IF(I.GT.0)READ(KR,*,ERR=21,END=21)IZ
      IF(IZ.LT.1)GOTO 21
C
C Standardize and check space group code
C
      CALL LINTRM(KY,L)
  22  KR=' '
      WRITE(*,FMT)' Enter space group in PDB or XPREP notation ['//
     +KY(1:L)//']: '
      READ(*,'(A)',ERR=22,END=22)KR
      CALL LINTRM(KR,I)
      IF(I.EQ.0)KR(1:55)=KY
      KS=KR
      CALL SPAGSY(KR)
      IF(IER.NE.0)GOTO 22
C
C Estimate cell esds and calculate reciprocal cell lengths
C
      U=0.01745329
      V=SQRT(1.-COS(U*CELL(4))**2-COS(U*CELL(5))**2-COS(U*CELL(6))**2+
     +2.*COS(U*CELL(4))*COS(U*CELL(5))*COS(U*CELL(6)))
        DO 23 I=1,3
        E(I)=0.001*CELL(I)
        E(I+3)=0.
        IF(ABS(ABS(CELL(I+3)-105.)-15.).GT.0.01)E(I+3)=0.05
        G(I)=SIN(U*CELL(I+3))/(V*CELL(I))
  23    CONTINUE
C
C Get wavelength and output CELL, ZERR and LATT
C
  24  KR=' '
      WRITE(*,FMT)' Enter wavelength in Angstroms [1.54178]: '
      READ(*,'(A)',ERR=24,END=24)KR
      CALL LINTRM(KR,I)
      IF(I.EQ.0)KR='1.54178'
      READ(KR,*,ERR=24,END=24)WL
      IF(WL.LT.0.01)GOTO 24
      WRITE(LS,25)'CELL',WL,(CELL(I),I=1,6),'ZERR',IZ,E,
     +'REM Space group '//KS(1:20),'LATT',LAT
      WRITE(LO,25)' CELL',WL,(CELL(I),I=1,6),' ZERR',IZ,E,
     +' REM Space group '//KS(1:20),' LATT',LAT
  25  FORMAT(A,F9.5,3F9.3,3F7.2/A,I9,3F9.3,3F7.2//A//A,I3)
C
C Output SYMM instructions
C
        DO 31 N=2,NS
        KR='SYMM '
        L=5
        NT=10
          DO 30 K=1,7,3
          J=L
          I=INT(AMOD(288.5+12.*SY(NT,N),12.))
          IF(I.EQ.0)GOTO 26
          L=L+3
          KR(L-2:L)='1/'//CHAR(ICHAR('0')+12/MIN0(I,12-I))
          IF(I.GT.7)KR(L-2:L-2)=CHAR(ICHAR('2')+I-8+I/10)
  26        DO 29 I=K,K+2
            IF(SY(I,N).GT.-0.5)GOTO 27
            L=L+1
            KR(L:L)='-'
            GOTO 28
  27        IF(SY(I,N).LT.0.5)GOTO 29
            IF(L.EQ.J)GOTO 28
            L=L+1
            KR(L:L)='+'
  28        L=L+1
            KR(L:L)=CHAR(ICHAR('X')+I-K)
  29        CONTINUE
          L=L+2
          KR(L-1:L)=', '
          NT=NT+1
  30      CONTINUE
        L=L-2
        WRITE(LS,'(A)')KR(1:L)
        WRITE(LO,'(1X,A)')KR(1:L)
  31    CONTINUE
      REWIND LF
C
C Set up atom scan and orthogonal to crystal conversion
C
      NA=0
      NQ=-1
      NC=-1
      NM=0
      NR=0
      NN=0
      NW=0
      NG=14
      KI=' '
      RN='    '
      RC='    '
      XC=-99999.
      YC=-99999.
      ZC=-99999.
      NF=6
      KM(1)='C '
      KM(2)='H '
      KM(3)='N '
      KM(4)='O '
      KM(5)='S '
      KM(6)='P '
      IW=' '
        DO 32 I=1,10000
        NEW(I)=-1
  32    CONTINUE
        DO 33 I=1,99
        F(I)=0.
  33    CONTINUE
      IF(NL.LT.-4)NL=-2
      NS=NS*IABS(NL)
      NL=0
  34  KR=' '
      READ(LF,'(A)',ERR=38,END=38)KR
      IF(KR(1:6).NE.'SCALE1')GOTO 34
      CALL LINTRM(KR,I)
      READ(KR,'(10X,3F10.6,5X,F10.5)',ERR=38)(A(I),I=1,4)
  35  KR=' '
      READ(LF,'(A)',ERR=38,END=38)KR
      IF(KR(1:6).NE.'SCALE2')GOTO 35
      CALL LINTRM(KR,I)
      READ(KR,'(10X,3F10.6,5X,F10.5)',ERR=38)(A(I),I=5,8)
  36  KR=' '
      READ(LF,'(A)',ERR=38,END=38)KR
      IF(KR(1:6).NE.'SCALE3')GOTO 36
      CALL LINTRM(KR,I)
      READ(KR,'(10X,3F10.6,5X,F10.5)',ERR=38)(A(I),I=9,12)
  37  WRITE(*,'(A)')' Generate atom coordinates using SCALE '//
     +'instructions from PDB file (P) or use'
      WRITE(*,FMT)' current cell to calculate transformation'//
     +' matrix (C) [C]: '
      KR='C'
      READ(*,'(A)',ERR=37,END=37)KR
      IF(INDEX(KR,'P')+INDEX(KR,'p').NE.0)GOTO 42
      GOTO 39
  38  WRITE(*,'(A/A)')' SCALE instructions not found in PDB file'
     +//' - standard transformation',' applied using current cell'
      REWIND LF
  39    DO 40 I=1,12
        A(I)=0.
  40    CONTINUE
        DO 41 I=1,3
        T=0.0174533*CELL(I+3)
        E(I)=SIN(T)
        E(I+3)=COS(T)
  41    CONTINUE
      T=1./SQRT(1.-E(4)**2-E(5)**2-E(6)**2+2.*E(4)*E(5)*E(6))
      A(1)=1./CELL(1)
      A(2)=-A(1)*E(6)/E(3)
      A(3)=A(1)*T*(E(4)*E(6)-E(5))/E(3)
      A(6)=1./(CELL(2)*E(3))
      A(7)=A(6)*T*(E(5)*E(6)-E(4))
      A(11)=T*E(3)/CELL(3)
  42  WRITE(LO,'(/A//3(A7,3F12.6,F16.5/)/1X,A/)')
     +' Conversion from PDB to fractional crystallographic '
     +//'coordinates',' SCALE1',(A(I),I=1,4),' SCALE2',(A(I),I=5,8),
     +' SCALE3',(A(I),I=9,12),' Old Name   New Name   NA  '
     +//'Atom names (and occupancies)'
C
C Set up chain ID conversion
C
      NWS=0
      ND=0
  43  KR=' '
      READ(LF,'(A)',ERR=43,END=47)KR
      CALL LINTRM(KR,I)
      IF(KR(1:6).NE.'HETATM'.AND.KR(1:4).NE.'ATOM')GOTO 43
      READ(KR(23:26),*,ERR=44,END=44)I
      NWS=MAX0(NWS,I)
  44  IF(KR(22:22).EQ.' ')GOTO 43
      IF(KR(18:20).EQ.'H2O'.OR.KR(18:20).EQ.'OH2'.OR.KR(18:20)
     +.EQ.'WAT'.OR.KR(18:20).EQ.'HOH')GOTO 43
        DO 45 I=1,ND
        IF(KN(I)(9:9).EQ.KR(22:22))GOTO 43
  45    CONTINUE
      ND=ND+1
      IF(ND.GT.1)GOTO 46
      WRITE(*,'(/A/A/A)')' SHELXL does not recognize chain ID letters'
     +//', so it will be necessary to',' incorporate these into the'//
     +' residue numbers by adding offsets of (say) 1000',' for chain '
     +//'A, 2000 for B etc. to the residue numbers from the PDB file.'
  46  KT=CHAR(MIN0(57,ND+48))
      WRITE(*,FMT)' Offset for chain '//KR(22:22)//' ['//KT//'000]: '
      KS=' '
      READ(*,'(A)',ERR=46,END=46)KS
      CALL LINTRM(KS,I)
      IF(I.EQ.0)KS=KT//'000'
      READ(KS,*,ERR=46,END=46)ID(ND)
      KN(ND)(9:9)=KR(22:22)
      GOTO 43
  47  REWIND LF
C
C Ask about renumbering and N and C terminii
C
      WRITE(*,'(/A/A)')' Enter old residue numbers (modified by chain'
     +//' ID, if any) for all N-terminii',' (<CR> if none). To '//
     +'continue on the next line, put "=" at the end of the line'
      WRITE(*,FMT)' : '
      MTN=0
  48  KR=' '
      READ(*,'(A)')KR
      CALL NUMIN(KR,NTN,MTN)
      IF(INDEX(KR,'=').NE.0)GOTO 48
      WRITE(*,'(1X)')
      WRITE(*,FMT)' Enter old residue numbers for all C-terminii'
     +//' in the same way: '
      MTC=0
  49  KR=' '
      READ(*,'(A)')KR
      CALL NUMIN(KR,NTC,MTC)
      IF(INDEX(KR,'=').NE.0)GOTO 49
      WRITE(*,'(/A/A)')' Enter old residue numbers in the same way at'
     +//' which renumbering of a block of',' residues should start.'
     +//' The block continues until the next residue specified'
      WRITE(*,FMT)' here (<CR> if none): '
      MRN=0
  50  KR=' '
      READ(*,'(A)',ERR=50,END=50)KR
      CALL NUMIN(KR,NRN,MRN)
      IF(INDEX(KR,'=').NE.0)GOTO 50
      K=0
        DO 51 I=1,ND
        K=MAX0(K,ID(I))
  51    CONTINUE
      KT=CHAR(MIN0(57,49+(K+NWS)/1000))
  52  WRITE(*,'(1X)')
      WRITE(*,FMT)' New residue number for first solvent water ['//
     +KT//'001]: '
      KR=' '
      READ(*,'(A)',ERR=52,END=52)KR
      CALL LINTRM(KR,I)
      IF(I.EQ.0)KR=KT//'001'
      READ(KR,*,ERR=52,END=52)NWS
  53  WRITE(*,'(1X)')
      WRITE(*,FMT)' Reset water occupancies to unity (Y or N) ? [Y]: '
      KR=' '
      READ(*,'(A)',ERR=53,END=53)KR
      IRO=INDEX(KR,'N')+INDEX(KR,'n')
C
C Interpret ATOM and HETATM instructions but ignore hydrogens.
C Convert orthogonal to crystal coordinates and B to U.
C
      KZ=' '
  54  READ(LF,'(A)',ERR=106,END=106)KZ
  55  KR=KZ
      IF(KR(1:4).NE.'ATOM'.AND.KR(1:6).NE.'HETATM')GOTO 54
      KZ=' '
      READ(LF,'(A)',ERR=59,END=59)KZ
      KY=' '
      IF(KZ(1:6).NE.'ANISOU')GOTO 60
      IF(NZ.LT.0)GOTO 59
      IF(NZ.GT.0)GOTO 57
  56  WRITE(*,'(1X)')
      WRITE(*,FMT)' Convert anisotropic atoms to isotropic (Y or N)'
     +//' [Y]: '
      KY=' '
      READ(*,'(A)',ERR=56,END=56)KY
      NZ=-1
      IF(INDEX(KY,'N')+INDEX(KY,'n').NE.0)NZ=1
      IF(NZ.LE.0)GOTO 59
  57  READ(KZ,'(28X,6F7.0)')(UO(I),I=1,6)
        DO 58 I=1,3
        J=4*MOD(I,3)+1
        K=4*MOD(I+1,3)+1
        L=4*I-3
        UU(I)=0.0001*(UO(1)*A(L)**2+UO(2)*A(L+1)**2+UO(3)*A(L+2)**2+
     +  2.*(UO(4)*A(L)*A(L+1)+UO(5)*A(L)*A(L+2)+UO(6)*A(L+1)*A(L+2)))
     +  /G(I)**2
        UU(I+3)=0.0001*(UO(1)*A(J)*A(K)+UO(2)*A(J+1)*A(K+1)+UO(3)*
     +  A(J+2)*A(K+2)+UO(4)*(A(J)*A(K+1)+A(J+1)*A(K))+UO(5)*(A(J)*
     +  A(K+2)+A(J+2)*A(K))+UO(6)*(A(J+1)*A(K+2)+A(J+2)*A(K+1)))
     +  /(G(MOD(I,3)+1)*G(MOD(I+1,3)+1))
  58    CONTINUE
      WRITE(KY,'(A1,4X,5F10.5)')'=',(UU(I),I=2,6)
  59  KZ=' '
  60  CALL LINTRM(KR,I)
      IF(KR(55:60).EQ.'      ')KR(55:60)=' 1.000'
      IF(KR(61:66).EQ.'      ')KR(61:66)=' 0.000'
      READ(KR,'(30X,3F8.5,2F6.3)',ERR=105)(A(I),I=13,17)
      IF(KR(13:13).GE.'0'.AND.KR(13:13).LE.'9')GOTO 55
      KJ=KR(13:14)
      IF(KJ.EQ.' H')GOTO 55
      IF(KJ.EQ.'HD')GOTO 55
      IF(KJ.EQ.'HE')GOTO 55
      IF(KJ.EQ.'HH')GOTO 55
      IF(KJ.EQ.' W'.AND.KR(18:20).EQ.'HOH')GOTO 55
      IF(KJ(1:1).EQ.' ')KJ=KR(14:14)
      E(1)=A(1)*A(13)+A(2)*A(14)+A(3)*A(15)+A(4)
      E(2)=A(5)*A(13)+A(6)*A(14)+A(7)*A(15)+A(8)
      E(3)=A(9)*A(13)+A(10)*A(14)+A(11)*A(15)+A(12)
      E(4)=10.+A(16)
      IF(KR(18:20).NE.'H2O'.AND.KR(18:20).NE.'OH2'.AND.KR(18:20)
     +.NE.'WAT'.AND.KR(18:20).NE.'HOH')GOTO 61
      IF(IRO.EQ.0)E(4)=11.
  61  E(5)=0.0126651*A(17)
      IF(E(5).LT.0.001)E(5)=0.2
      IF(KY(1:1).NE.' ')E(5)=UU(1)
      IF(KJ.NE.' A')GOTO 62
      F(3)=F(3)+0.5*A(16)
      F(4)=F(4)+0.5*A(16)
      GOTO 65
  62    DO 63 I=1,NF
        IF(KJ.EQ.KM(I))GOTO 64
  63    CONTINUE
      NF=NF+1
      KM(NF)=KJ
      I=NF
  64  F(I)=F(I)+A(16)
C
C Residue number and class
C
  65  KC=KR(18:20)
        DO 66 I=1,NQ,2
        IF(KC.EQ.KA(I))KC=KA(I+1)
  66    CONTINUE
      JW=-1
  67  N=0
      KQ='    '
        DO 68 I=1,4
        KT=KC(I:I)
        IF(KT.EQ.' ')GOTO 68
        IF(KT.GE.'a'.AND.KT.LE.'z')KT=CHAR(ICHAR(KT)-LU)
        N=N+1
        KQ(N:N)=KT
  68    CONTINUE
      IF(KQ.EQ.'    '.AND.KR(23:26).EQ.'   0')GOTO 70
      IF(KQ(1:1).GE.'A'.AND.KQ(1:1).LE.'Z')GOTO 70
      IF(JW.NE.0)WRITE(*,'(1X,A)')KR(1:72)
      KC=KQ
  69  WRITE(*,FMT)' '//KC//' is not a legal SHELXL residue class - '
     +//'enter alternative: '
      KC=' '
      READ(*,'(A)',ERR=69,END=69)KC
      CALL LINTRM(KC,I)
      JW=0
      GOTO 67
  70  IF(JW.NE.0)GOTO 71
      NQ=MIN0(NQ+2,499)
      KA(NQ)=KR(18:20)
      KA(NQ+1)=KQ
  71  IF(KQ.EQ.'CSS '.OR.KQ.EQ.'CSH ')KQ='CYS '
      IF(KQ.EQ.'H2O '.OR.KQ.EQ.'OH2 '.OR.KQ.EQ.'WAT '.OR.
     +KQ.EQ.'HOH ')KQ='HOH '
      KC=KR(23:26)
      N=0
      IF(KQ.NE.'    ')GOTO 72
      IF(RC.EQ.'    ')GOTO 90
      GOTO 88
  72  N=NC
      IF(KC.NE.RN)GOTO 73
      IF(KQ.EQ.RC)GOTO 90
  73  IF(KQ.NE.'HOH ')GOTO 74
      N=NWS
      NRE=NWS
      NWS=MIN0(NWS+1,9999)
      GOTO 86
  74  READ(KC,*,ERR=75,END=75)N
  75    DO 76 I=1,ND
        IF(KR(22:22).EQ.KN(I)(9:9))N=N+ID(I)
  76    CONTINUE
      N=MIN0(N,9999)
      NRE=N
        DO 77 I=1,MRN
        IF(N.EQ.NRN(I))GOTO 78
  77    CONTINUE
      N=MAX0(1,MIN0(N+NN,9999))
      GOTO 79
  78  WRITE(*,'(/A,I5,A)')' Current old residue number is',NRE,
     +'.  Enter new residue number.  This defines the'
      WRITE(*,FMT)' offset to be applied to residue numbers for'
     +//' the rest of this block: '
      KC=' '
      READ(*,'(A)',ERR=78,END=78)KC
      CALL LINTRM(KC,I)
      READ(KC,*,ERR=78,END=78)N
      NN=N-NRE
  79  IF(NC.EQ.0)GOTO 85
      IF(KR(13:16).NE.' N  ')GOTO 86
      IF(XC.LT.-99998.)GOTO 80
      T=(A(13)-XC)**2+(A(14)-YC)**2+(A(15)-ZC)**2
      IF(T.GT.1.0.AND.T.LT.4.0)GOTO 82
  80  IF(N.NE.NC+1)GOTO 85
  81  WRITE(*,'(/1X,A/A/A,I5,A,I5,A/A/A)')KR(1:79),
     +' This residue is not bonded to the previous amino-acid but'
     +//'they now have',' consecutive residue numbers of',NC,' and',
     +N,'.  The default restraints',' will attempt to link them '//
     +'together.  Enter <CR> if you really intend this,',
     +' otherwise enter new residue number.  This will also define '
     +//'the offset to be'
      WRITE(*,FMT)' applied to the residue numbers for the rest of '
     +//'this block: '
      KC=' '
      READ(*,'(A)',ERR=81,END=81)KC
      CALL LINTRM(KC,I)
      IF(I.EQ.0)GOTO 85
      READ(KC,*,ERR=81,END=81)N
      GOTO 84
  82  IF(N.EQ.NC+1)GOTO 85
  83  WRITE(*,'(/1X,A/A/A,I5,A,I5,A/A/A)')KR(1:79),
     +' This residue is bonded to the previous amino-acid but they '
     +//'now do not have',' consecutive residue numbers (',NC,' and',
     +N,').  Extra restraints will',' be required to link them '//
     +'together.  Enter <CR> if you really intend this,',
     +' otherwise enter new residue number.  This will also define '
     +//'the offset'
      WRITE(*,FMT)' to be applied to the residue numbers for the '
     +//'rest of this block: '
      KC=' '
      READ(*,'(A)',ERR=83,END=83)KC
      CALL LINTRM(KC,I)
      IF(I.EQ.0)GOTO 84
      READ(KC,*,ERR=81,END=81)N
  84  N=MAX0(1,MIN0(N,9999))
      NN=N-NRE
  85  XC=-99999.
      YC=-99999.
      ZC=-99999.
  86  NEW(NRE+1)=N
      IF(N.EQ.0)KQ='    '
        DO 87 I=1,NR
        IF(KQ.EQ.KE(I))GOTO 88
  87    CONTINUE
      NR=MIN0(NR+1,999)
      KE(NR)=KQ
      IY(NR)=0
  88  IF(NL.EQ.0)GOTO 89
      WRITE(KS(21:25),'(I5)')NM
      WRITE(LO,'(1X,A)')KS(1:NL)
  89  KS=' '
      WRITE(KS,'(1X,2A4,3X,A4,I4)')KR(18:21),KR(23:26),KQ,N
      NM=0
      NL=26
  90  NC=N
      RC=KQ
      RN=KR(23:26)
C
C Process atom name etc.
C
      KC='    '
      K=0
        DO 91 I=13,16
        IF(KR(I:I).EQ.' ')GOTO 91
        K=K+1
        KC(K:K)=KR(I:I)
  91    CONTINUE
      IF(KC.NE.'C   ')GOTO 92
      XC=A(13)
      YC=A(14)
      ZC=A(15)
  92  IF(KC.EQ.'CD  '.AND.KQ.EQ.'ILE ')KC='CD1 '
        DO 93 I=1,MTC
        IF(NRE.EQ.NTC(I))GOTO 94
  93    CONTINUE
      GOTO 95
  94  IF(KC.EQ.'O   '.OR.KC.EQ.'OX  '.OR.KC.EQ.'OX1 ')KC='OT1 '
      IF(KC.EQ.'OT  '.OR.KC.EQ.'OXT '.OR.KC.EQ.'OX2 ')KC='OT2 '
  95  IF(KQ.NE.'HOH ')GOTO 98
      NW=NW+1
      IF(NW.GT.1)GOTO 98
      L=0
        DO 96 I=1,4
        IF(KC(I:I).EQ.' ')GOTO 96
        L=L+1
        IW(L:L)=KC(I:I)
  96    CONTINUE
      IF(KQ.EQ.'    ')GOTO 98
      L=L+1
      IW(L:L)='_'
        DO 97 I=17,20
        IF(KS(I:I).EQ.' ')GOTO 97
        L=L+1
        IW(L:L)=KS(I:I)
  97    CONTINUE
  98  N=0
      KI=KR(17:17)
      IF(KI.GE.'A'.AND.KI.LE.'Z')N=ICHAR(KI)-ICHAR('A')+1
      IF(KI.GE.'0'.AND.KI.LE.'9')N=ICHAR(KI)-ICHAR('0')
      IF(KQ.NE.'CYS ')GOTO 100
      IF(KC.NE.'SG  ')GOTO 100
        DO 99 I=18,NG,4
        IF(INT(A(I)).EQ.NC)GOTO 100
  99    CONTINUE
      NG=NG+4
      A(NG)=REAL(NC)+0.1
      A(NG+1)=A(13)
      A(NG+2)=A(14)
      A(NG+3)=A(15)
 100  KI=KR(22:22)
      WRITE(KR,'(A4,3X,A2,3F10.6,2F10.5,A4,I5,I4,A1)')KC,KJ,
     +(E(I),I=1,5),RC,NC,N,KY(1:1)
      WRITE(LM)KR
      IF(KY(1:1).NE.' ')WRITE(LM)KY
      IF(KC.NE.'N   ')GOTO 101
      IF(NM.NE.0)GOTO 101
      IF(NA.EQ.0)NA=NC
 101  NM=NM+1
      IF(67.GT.NL)GOTO 102
      WRITE(LO,'(1X,A)')KS(1:NL)
      KS=' '
      NL=26
 102  NL=NL+1
        DO 103 I=1,4
        IF(KC(I:I).EQ.' ')GOTO 103
        NL=NL+1
        KS(NL:NL)=KC(I:I)
 103    CONTINUE
      IF(N.EQ.0)GOTO 104
      NL=NL+2
      KS(NL-1:NL)='/'//CHAR(MAX0(49,MIN0(57,48+N)))
 104  IF(ABS(1.-A(16)).LT.0.01)GOTO 55
      NL=NL+5
      WRITE(KS(NL-3:NL),'(F4.2)')A(16)
      GOTO 55
 105  WRITE(*,'(/1X,A//1X,A/)')'** Bad ATOM or HETATM record **',
     +KR(1:72)
      GOTO 156
C
C Set up SFAC and UNIT
C
 106  REWIND LM
      IF(NL.EQ.0)GOTO 107
      WRITE(KS(21:25),'(I5)')NM
      WRITE(LO,'(1X,A)')KS(1:NL)
 107  F(2)=AINT(1.2*(F(1)+F(3)+F(4))+0.5)
      KR='SFAC '
      K=5
        DO 108 I=1,NF
        IF(F(I).LT.0.01)GOTO 108
        K=MIN0(K+3,80)
        KR(K-2:K)=' '//KM(I)
 108    CONTINUE
      WRITE(LS,'(A)')KR(1:K)
      KR='UNIT '
      K=5
      T=REAL(IABS(LAT))
      IF(T.GT.4.5)T=2.
      IF(LAT.GT.0)T=2.*T
      T=T*REAL(NS)
        DO 110 I=1,NF
        IF(F(I).LT.0.01)GOTO 110
        WRITE(KS,'(F10.0)')F(I)*T
        L=9
        IF(K.GE.80)GOTO 110
        K=K+1
          DO 109 J=1,L
          IF(KS(J:J).EQ.' ')GOTO 109
          IF(K.GE.80)GOTO 109
          K=K+1
          KR(K:K)=KS(J:J)
 109      CONTINUE
 110    CONTINUE
      WRITE(LS,'(A)')KR(1:K)
C
C Refinement instructions and general restraints etc.
C
      WRITE(LS,'(/A/A/A/A/A/A/A/)')'DEFS 0.02 0.1 0.01 0.04',
     +'CGLS 10','SHEL 10 0.1','FMAP 2','PLAN 200 2.3','LIST 6',
     +'WPDB 2'
      KS=' $C_* $N_* $O_* $S_*'
      L=20
      IF(F(5).LT.0.01)L=15
      KS(L+1:L+5)=' $P_*'
      IF(F(6).GT.0.01)L=L+5
      WRITE(LS,'(A/A)')'DELU'//KS(1:L),'SIMU 0.1'//KS(1:L)
      L=1
        DO 111 I=1,9
        IF(IW(I:I).NE.' ')L=I
 111    CONTINUE
      IF(NW.GT.0)GOTO 112
      WRITE(LS,'(A)')'REM ISOR and CONN 0 recommended on adding water'
      GOTO 113
 112  WRITE(LS,'(A)')'ISOR 0.1 '//IW(1:L)//' > LAST'
      WRITE(LS,'(A)')'CONN 0 '//IW(1:L)//' > LAST'
 113  WRITE(LS,'(A/A/A/)')'BUMP','SWAT','REM HOPE'
      WRITE(LS,'(A)')'REM Remove MERG 4 instruction if Friedel '//
     +'opposites should not be merged'
      WRITE(LS,'(/A/)')'MERG 4'
      WRITE(LS,'(A)')'REM MORE 0 would reduce output if not '//
     +'required for diagnostic purposes'
      WRITE(LS,'(/A)')'REM MORE 0'
C
C Copy RTAB instructions for all residues
C
      WRITE(LS,'(/A/)')'REM Remove ''REM '' before RTAB to '
     +//'activate remaining tables'
        DO 118 N=1,462
        IF(INDEX(KD(N),'RTAB').EQ.0)GOTO 118
        I=INDEX(KD(N),'_')
        RN=KD(N)(I+1:I+4)
        IF(RN(1:1).EQ.'*')GOTO 115
          DO 114 I=1,NR
          IF(KE(I).EQ.RN)GOTO 116
 114      CONTINUE
        GOTO 118
 115    RN='*   '
 116    I=47
 117    I=I-1
        IF(KD(N)(I:I).EQ.' ')GOTO 117
        WRITE(LS,'(A)')KD(N)(1:I)
 118    CONTINUE
C
C Copy HFIX instructions for all residues starting with N-terminus
C
      WRITE(LS,'(/A)')'REM Remove ''REM '' in following to '
     +//'activate H-atom generation'
      IF(MTN.EQ.0)GOTO 121
      WRITE(LS,'(1X)')
      KR='REM HFIX 33'
      L=11
        DO 120 I=1,MTN
        J=NTN(I)+1
        J=NEW(J)
        IF(J.LE.0)GOTO 120
        WRITE(KC,'(I4)')J
        L=L+3
        KR(L-2:L)=' N_'
          DO 119 J=1,4
          IF(KC(J:J).EQ.' ')GOTO 119
          L=L+1
          KR(L:L)=KC(J:J)
 119      CONTINUE
        IF(L.LT.71)GOTO 120
        L=L+2
        KR(L-1:L)=' ='
        WRITE(LS,'(A)')KR(1:L)
        KR=' '
        L=11
 120    CONTINUE
      IF(L.GT.11)WRITE(LS,'(A)')KR(1:L)
 121    DO 126 N=1,462
        IF(INDEX(KD(N),'HFIX').EQ.0)GOTO 126
        I=INDEX(KD(N),'_')
        RN=KD(N)(I+1:I+4)
        IF(RN(1:1).EQ.'*')GOTO 123
          DO 122 I=1,NR
          IF(KE(I).EQ.RN)GOTO 124
 122      CONTINUE
        GOTO 126
 123    RN='*   '
 124    I=47
 125    I=I-1
        IF(KD(N)(I:I).EQ.' ')GOTO 125
        IF(KC.NE.RN)WRITE(LS,'(1X)')
        WRITE(LS,'(A)')KD(N)(1:I)
        KC=RN
 126    CONTINUE
C
C Copy restraints for all residues involved
C
        DO 132 N=1,462
        IF(INDEX(KD(N),'RTAB').NE.0)GOTO 132
        IF(INDEX(KD(N),'HFIX').NE.0)GOTO 132
        I=INDEX(KD(N),'_')
        RN=KD(N)(I+1:I+4)
        IF(RN(1:1).NE.'*')GOTO 127
        RN='*   '
        GOTO 130
 127      DO 128 I=1,NR
          IF(KE(I).EQ.RN)GOTO 129
 128      CONTINUE
        GOTO 132
 129    IY(I)=1
 130    I=47
 131    I=I-1
        IF(KD(N)(I:I).EQ.' ')GOTO 131
        IF(KC.NE.RN)WRITE(LS,'(1X)')
        WRITE(LS,'(A)')KD(N)(1:I)
        KC=RN
 132    CONTINUE
C
C Locate S-S bridges (if any) and add DFIX instructions for them
C
      WRITE(LS,'(1X)')
      IF(NG.LT.19)GOTO 139
      KS='DFIX 2.031'
      KC='+SG_'
      KQ=KC
      L=10
        DO 138 J=1,2
          DO 137 N=18,NG-4,4
            DO 136 M=N+4,NG,4
            IF((A(M+1)-A(N+1))**2+(A(M+2)-A(N+2))**2+(A(M+3)-
     +      A(N+3))**2.GT.9.)GOTO 136
 133        IF(L.LT.65)GOTO 134
            WRITE(LS,'(A)')KS(1:L)
            L=10
 134        WRITE(KR,'(2(A,I5))')KC,INT(A(N)+.1),KQ,INT(A(M)+.1)
              DO 135 I=1,18
              KT=KR(I:I)
              IF(KT.EQ.' ')GOTO 135
              IF(KT.EQ.'+')KT=' '
              L=L+1
              KS(L:L)=KT
 135          CONTINUE
            RC=KC
            KC=KQ
            KQ=RC
            IF(KQ.NE.'+SG_')GOTO 133
 136        CONTINUE
 137      CONTINUE
        IF(L.GT.10)WRITE(LS,'(A)')KS(1:L)
        KC='+CB_'
        KS(1:10)='DANG 3.035'
        L=10
 138    CONTINUE
C
C Add restraints for C-terminii
C
 139    DO 141 I=1,MTC
        J=NTC(I)+1
        J=NEW(J)
        IF(J.LE.0)GOTO 141
        KR='_'
        L=1
        WRITE(KC,'(I4)')J
          DO 140 J=1,4
          IF(KC(J:J).EQ.' ')GOTO 140
          L=L+1
          KR(L:L)=KC(J:J)
 140      CONTINUE
        WRITE(LS,'(A)')'DFIX'//KR(1:L)//' 1.249 C OT1 C OT2'
        WRITE(LS,'(A)')'DANG'//KR(1:L)//' 2.379 CA OT1 CA OT2'
        WRITE(LS,'(A)')'DANG'//KR(1:L)//' 2.194 OT1 OT2'
 141    CONTINUE
C
C Generate atom list including RESI and PART
C
      WRITE(LS,'(/A//A)')'WGHT  0.1','FVAR  1.00000'
      KS=' '
      KS(68:68)='0'
      KS(72:72)='0'
 142  READ(LM,END=147)KR
      CALL LINTRM(KR,I)
      IF(KR(69:72).NE.KS(69:72))WRITE(LS,'(A)')'PART'//KR(69:72)
      IF(KR(60:68).EQ.KS(60:68))GOTO 143
      WRITE(LS,'(/A)')'RESI '//KR(65:68)//'  '//KR(60:63)
 143  KJ=KR(8:9)
      IF(KJ.EQ.'A ')KJ='O '
      K=0
        DO 144 I=1,NF
        IF(F(I).LT.0.01)GOTO 144
        K=K+1
        IF(KJ.EQ.KM(I))GOTO 145
 144    CONTINUE
 145  WRITE(KR(5:9),'(I5)')K
      KS=KR
      IF(KR(73:73).NE.' ')GOTO 146
      WRITE(LS,'(A)')KR(1:59)
      GOTO 142
 146  WRITE(LS,'(A)')KR(1:59)//' ='
      READ(LM,END=147)KR(1:55)
      KR(1:1)=' '
      WRITE(LS,'(A)')KR(1:55)
      GOTO 142
C
C Finish off with appropriate HKLF instruction
C
 147  KS=' '
      WRITE(*,'(1X)')
      WRITE(*,FMT)' HKLF code (3 for F, 4 for F-squared) [4]: '
      READ(*,'(A)',ERR=147,END=147)KS
      CALL LINTRM(KR,I)
        DO 148 I=1,80
        IF(KS(I:I).NE.' ')GOTO 149
 148    CONTINUE
      KS='4'
      I=1
 149  WRITE(LS,'(/A/A)')'HKLF '//KS(I:I),'END '
      N=0
        DO 150 I=1,NR
        IF(IY(I).NE.0)GOTO 150
        IF(KE(I).EQ.'H2O '.OR.KE(I).EQ.'OH2 '.OR.KE(I).EQ.'WAT '
     +  .OR.KE(I).EQ.'HOH ')GOTO 150
        N=N+1
        KE(N)=KE(I)
 150    CONTINUE
      IF(N.EQ.0)GOTO 152
      WRITE(*,151)(KE(I),I=1,N)
      WRITE(LO,'(1X)')
      WRITE(LO,151)(KE(I),I=1,N)
 151  FORMAT(/' May have to add restraints etc. for the following',
     +' residues that were not'/' matched in the dictionary file:',
     +9(1X,A)/(16(1X,A)))
 152  WRITE(*,'(/A/A)')' The .ins file has been written successfully.'
     +//'  The U option in SHELXPRO may',' be used for further '//
     +'checking of occupancies etc.'
      GOTO 157
C
C Error and normal exits
C
 153  WRITE(*,'(/A/)')' ** Cannot create scratch file **'
      GOTO 156
 154  WRITE(*,'(/A/)')' ** Cannot create file '//KS(1:L)//' **'
      GOTO 156
 155  WRITE(*,'(/A/)')' ** Cannot open file '//KR(1:N)//' **'
 156  IER=1
      GOTO 158
 157  IER=0
 158  CLOSE(UNIT=LS)
      CLOSE(UNIT=LM)
      RETURN
      END
C
C -------------------------------------------------------------------
C
      SUBROUTINE NUMIN(KR,IN,N)
C
C Extract signless integers from string KR
C
      CHARACTER*80 KR
      INTEGER IN(*)
C
      CALL LINTRM(KR,K)
      J=0
      M=0
        DO 2 I=1,K
        IF(KR(I:I).EQ.'=')GOTO 3
        IF(KR(I:I).GE.'0'.AND.KR(I:I).LE.'9')GOTO 1
        IF(J.EQ.0)GOTO 2
        N=N+1
        IN(N)=M
        M=0
        J=0
        GOTO 2
   1    M=M*10+ICHAR(KR(I:I))-ICHAR('0')
        J=1
   2    CONTINUE
   3  IF(J.EQ.0)GOTO 4
      N=N+1
      IN(N)=M
   4  RETURN
      END
C
C -------------------------------------------------------------------
C
      SUBROUTINE SPAGSY(KR)
C
C Interpret string KR as a space group in PDB notation, store symmetry
C operations in SY, number of symops in NS, LATT code in LAT.
C
      CHARACTER S(81)*21,KR*80,KT*1
      COMMON/XTAL/SY(12,192),CELL(15),II(1369),NS,LAT,LU,LN,
     +LO,LP,LF,LM,LS,NOS,IER,NPG
C
C Encoded space group operators (chiral space groups only). Some
C common non-standard settings are allowed, eg. I2, P22(1)2(1), A222.
C R3 and R32 may be given with either rhombohedral or hexagonal axes.
C
      DATA S(1)/'P1'/,S(2)/'A1'/,S(3)/'B1'/,S(4)/'C1'/,S(5)/'I1'/,
     +S(6)/'F1'/,S(7)/'P2 UYW'/,S(8)/'P7 UEW'/,S(9)/'C2 UYW'/,S(10)/
     +'I2 UYW'/,S(11)/'P82 UVZUYW'/,S(12)/'P87 UVFUYC'/,S(13)/
     +'P78 DVWAVZ'/,S(14)/'P272 UEWXBW'/,S(15)/'P772 UVZAEW'/
      DATA S(16)/'P277 XVWUBF'/,S(17)/'P727 UYWDVC'/,S(18)/
     +'P777 AVFUEC'/,S(19)/'C87 UVFUYC'/,S(20)/'A78 DVWAVZ'/,S(21)/
     +'B272 UEWXBW'/,S(22)/'C82 UVZUYW'/,S(23)/'A82 XVWUVZ'/,S(24)/
     +'B82 UYWXVW'/,S(25)/'F82 UVZUYW'/,S(26)/'I82 UVZUYW'/
      DATA S(27)/'I777 AVFUEC'/,S(28)/'P4 VXZ'/,S(29)/'P42 VXF'/,
     +S(30)/'P41 VX1Z'/,S(31)/'P43 VX3Z'/,S(32)/'I4 VXZ'/,S(33)/
     +'I41 VD1Z'/,S(34)/'P48 VXZUYW'/,S(35)/'P472 BDZAEW'/,S(36)/
     +'P482 VXFUYW'/,S(37)/'P4272 BDFAEC'/
      DATA S(38)/'P418 VX1ZUYW'/,S(39)/'P438 VX3ZUYW'/,S(40)/
     +'P4172 BD1ZAE1W'/,S(41)/'P4372 BD3ZAE3W'/,S(42)/
     +'I48 VXZUYW'/,S(43)/'I418 VD1ZAY3W'/,S(44)/'P3 VTZ'/S(45)/
     +'P31 VT4Z'/,S(46)/'P9 VT5Z'/,S(47)/'H3 VTZ'/,S(48)/'R3 ZXY'/
      DATA S(49)/'P37 VTZYXW'/,S(50)/'P317 VT4ZYXW'/,S(51)/
     +'P97 VT5ZYXW'/,S(52)/'H9 VTZYXW'/,S(53)/'R9 ZXYVUW'/,S(54)/
     +'P312 VTZVUW'/,S(55)/'P3112 VT4ZVU5W'/,S(56)/'P372 VT5ZVU4W'/,
     +S(57)/'P6 VTZUVZ'/,S(58)/'P63 VTZUVF'/,S(59)/'P62 VT5ZUVZ'/
      DATA S(60)/'P64 VT4ZUVZ'/,S(61)/'P61 VT4ZUVF'/,S(62)/
     +'P65 VT5ZUVF'/,S(63)/'P68 VTZUVZYXW'/,S(64)/'P638 VTZUVFYXW'/,
     +S(65)/'P682 VT5ZUVZYX5W'/,S(66)/'P648 VT4ZUVZYX4W'/,
     +S(67)/'P618 VT4ZUVFYX4W'/,S(68)/'P658 VT5ZUVFYX5W'/
      DATA S(69)/'P23 UVZUYWZXY'/,S(70)/'P73 AVFUECZXY'/,
     +S(71)/'I23 UVZUYWZXY'/,S(72)/'I73 AVFUECZXY'/,S(73)/
     +'F23 UVZUYWZXY'/,S(74)/'P49 UVZUYWZXYYXW'/,S(75)/
     +'P429 UVZUYWZXYEDC'/,S(76)/'P419 AVFUECZXY3Y1X1W'/
      DATA S(77)/'P439 AVFUECZXY1Y3X3W'/,S(78)/
     +'I49 UVZUYWZXYYXW'/,S(79)/'I419 AVFUECZXY3Y1X1W'/,S(80)/
     +'F49 UVZUYWZXYYXW'/,S(81)/'F419 UBFAEWZXY3Y1X3W'/
C
C Standardize space group name
C
      K=0
        DO 1 I=1,80
        KT=KR(I:I)
        IF(KT.GE.'a'.AND.KT.LE.'z')KT=CHAR(ICHAR(KT)-LU)
        IF(KT.EQ.' ')GOTO 1
        IF(KT.EQ.CHAR(40))GOTO 1
        IF(KT.EQ.CHAR(41))GOTO 1
        K=K+1
        KR(K:K)=KT
   1    CONTINUE
      IF(KR(1:5).EQ.'P1211')KR='P21'
      IF(KR(1:4).EQ.'P121')KR='P2'
      IF(KR(1:4).EQ.'C121')KR='C2'
      IF(KR(1:4).EQ.'I121')KR='I2'
      KR(K+1:80)=' '
      IF(KR(1:1).NE.'R')GOTO 2
      IF(CELL(6)-CELL(5).GT.20.)KR(1:1)='H'
   2  I=INDEX(KR(1:11),'21')
      IF(I.EQ.0)GOTO 4
      KR(I:I)='7'
        DO 3 J=I+1,11
        KR(J:J)=KR(J+1:J+1)
   3    CONTINUE
      GOTO 2
   4  I=INDEX(KR(1:11),'22')
      IF(I.EQ.0)GOTO 6
      KR(I:I)='8'
        DO 5 J=I+1,11
        KR(J:J)=KR(J+1:J+1)
   5    CONTINUE
      GOTO 4
   6  I=INDEX(KR(1:11),'32')
      IF(I.EQ.0)GOTO 8
      KR(I:I)='9'
        DO 7 J=I+1,11
        KR(J:J)=KR(J+1:J+1)
   7    CONTINUE
      GOTO 6
C
C Identify space group
C
   8  K=INDEX(KR,' ')
        DO 9 NG=1,81
        IF(KR(1:K).EQ.S(NG)(1:K))GOTO 10
   9    CONTINUE
      IER=1
      WRITE(*,'(/A/)')' ** Cannot interpret space group symbol **'
      GOTO 25
C
C Set lattice type (SHELX code) in LAT
C
  10  IER=0
      LAT=-1
      KT=KR(1:1)
      IF(KT.EQ.'I')LAT=-2
      IF(KT.EQ.'H')LAT=-3
      IF(KT.EQ.'F')LAT=-4
      IF(KT.LE.'C')LAT=-5+ICHAR('A')-ICHAR(KT)
C
C Store symmetry generators in SY
C
      NS=1
        DO 11 I=1,12
        SY(I,NS)=0.
  11    CONTINUE
        DO 12 I=1,9,4
        SY(I,NS)=1.
  12    CONTINUE
      K=K+1
  13  IF(S(NG)(K:K).EQ.' ')GOTO 25
      NS=NS+1
      N=1
      L=10
        DO 14 I=1,12
        SY(I,NS)=0.
  14    CONTINUE
  15  KT=S(NG)(K:K)
      IF(KT.LT.'A'.OR.KT.GT.'F')GOTO 16
      KT=CHAR(ICHAR(KT)+20)
      SY(L,NS)=.5
  16  T=1.
      IF(KT.LT.'U'.OR.KT.GT.'W')GOTO 17
      KT=CHAR(ICHAR(KT)+3)
      T=-1.
  17  IF(KT.LT.'X'.OR.KT.GT.'Z')GOTO 18
      I=N+ICHAR(KT)-ICHAR('X')
      SY(I,NS)=T
      GOTO 20
  18  IF(KT.EQ.'T')GOTO 19
      I=3*(ICHAR(KT)-ICHAR('0'))
      IF(I.EQ.21)I=10
      IF(I.EQ.18)I=2
      IF(I.EQ.15)I=8
      IF(I.EQ.12)I=4
      SY(L,NS)=REAL(I)/12.
      GOTO 21
  19  SY(N,NS)=1.
      SY(N+1,NS)=-1.
  20  N=N+3
      L=L+1
  21  K=K+1
      IF(N.LT.8)GOTO 15
C
C Expand to symmetry operators in SY
C
      NL=NS
  22  J=NS
        DO 24 I=2,NL
        NS=NS+1
        N=10
          DO 23 L=1,7,3
          SY(L,NS)=SY(L,J)*SY(1,I)+SY(L+1,J)*SY(4,I)+
     +    SY(L+2,J)*SY(7,I)
          SY(L+1,NS)=SY(L,J)*SY(2,I)+SY(L+1,J)*SY(5,I)+
     +    SY(L+2,J)*SY(8,I)
          SY(L+2,NS)=SY(L,J)*SY(3,I)+SY(L+1,J)*SY(6,I)+
     +    SY(L+2,J)*SY(9,I)
          SY(N,NS)=SY(L,J)*SY(10,I)+SY(L+1,J)*SY(11,I)+
     +    SY(L+2,J)*SY(12,I)+SY(N,J)
          N=N+1
  23      CONTINUE
  24    CONTINUE
      J=NS
      IF(SY(1,J)+SY(5,J)+SY(9,J)-ABS(SY(2,J))-ABS(SY(4,J))
     +.LT.2.9)GOTO 22
      NS=NS-1
      GOTO 13
  25  RETURN
      END
C
C -------------------------------------------------------------------
C
      SUBROUTINE LSTESD(MM,B,E)
C
C Read SHELXL .lst file including esds in atom coordinates and bond
C lengths and prepare Postscript plots against equivalent B-values.
C
      COMMON/XTAL/SY(12,192),CELL(15),II(1369),NS,LAT,LU,LN,
     +LO,LP,LF,LM,LS,NOS,IER,NPG
      COMMON/WORD/KF,KR,KD,KE,KA,KB,KN,FMT,COL,OPT
      CHARACTER KF*80,KR*80,KD(462)*52,KA(50000)*4,KE(9999)*4,
     +KB(250)*80,KN(10000)*9,FMT*20,COL*4,OPT*1,KQ*1
      CHARACTER KL*128,KM*128,KS*1,KI*9
      REAL B(MM),E(MM),D(9),BM(9),EM(9)
C
C Questions about plotting quadratics in B
C
C     JM=0
C     JZ=-1
   1  WRITE(*,FMT)' Fit atom radial esds to quadratic in B ? [Y]: '
      KR=' '
      READ(*,55,ERR=1,END=1)KR
      CALL LINTRM(KR,N)
      N=MAX0(N,1)
      KQ=KR(N:N)
      IF(KQ.EQ.'n')KQ='N'
      IF(KQ.EQ.'N')GOTO 2
      IF(KQ.EQ.'y'.OR.KQ.EQ.' ')KQ='Y'
      IF(KQ.NE.'Y')GOTO 1
C
C Set up .lst file for reading
C
   2  KF(LN+1:LN+4)='.lst'
   3  WRITE(*,FMT)' Name of .lst file created using SHELXL ['
     +//KF(1:LN+4)//']: '
      KR=' '
      READ(*,55,ERR=3,END=3)KR
      CALL LINTRM(KR,N)
      L=0
      M=0
        DO 4 I=1,N
        IF(KR(I:I).EQ.'.')M=I
        IF(KR(I:I).EQ.' ')GOTO 4
        L=L+1
        KR(L:L)=KR(I:I)
   4    CONTINUE
      IF(M.NE.0)GOTO 6
      IF(L.NE.0)GOTO 5
      KR=KF
      L=LN
   5  L=L+4
      KR(L-3:L)='.lst'
   6  OPEN(LF,FILE=KR(1:L),STATUS='OLD',ERR=65)
      WRITE(LO,57)'Reading file '//KR(1:L)
      ME=-1
      MB=0
      IF(COL(2:2).EQ.'f')GOTO 8
   7  WRITE(*,55)' Minimum and maximum residue numbers for '//
     +'solvent (<CR> to include protein'
      WRITE(*,FMT)' and solvent in same diagram) []: '
      KL=' '
      READ(*,55,ERR=7,END=7)KL
      CALL LINTRM(KL,I)
      IF(I.EQ.0)GOTO 8
      READ(KL,*,ERR=7,END=7)MB,ME
      IF(ME.LT.0)GOTO 7
   8    DO 9 I=1,3
        BM(I)=-1.
        EM(I)=-1.
   9    CONTINUE
      NB=0
      BW=0.
      BN=0.
C
C Scan .lst file four or ten times, start Postscript page
C
      MZ=3
      IF(COL(2:2).EQ.'f')MZ=9
        DO 52 NZ=0,MZ
        IF(NZ.EQ.0)GOTO 24
        IF(NZ.LT.MZ-5)GOTO 52
        IF(NZ*ME.EQ.-3)GOTO 68
        NPG=NPG+1
        WRITE(LP,54)NPG,NPG
        WRITE(LP,55)'3 W C7 110 270 550 710 B C0 1 W'
        KL=' (a) Positional esds (excluding solvent)'
        L=40
        IF(ME.LT.0)L=20
        IF(NZ.EQ.1)GOTO 10
        KL=' (b) Bond length esds'
        L=21
        IF(NZ.EQ.2)GOTO 10
        KL=' (c) Positional esds for solvent'
        L=32
        IF(NZ.EQ.3)GOTO 10
        KL=' (a) Positional esds for C-atoms'
        IF(NZ.EQ.4)GOTO 10
        KL(3:3)='b'
        KL(26:26)='N'
        IF(NZ.EQ.5)GOTO 10
        KL(3:3)='c'
        KL(26:26)='O'
        IF(NZ.EQ.6)GOTO 10
        KL=' (d) C-C bond length esds'
        L=25
        IF(NZ.EQ.7)GOTO 10
        KL(3:8)='e) C-N'
        IF(NZ.EQ.8)GOTO 10
        KL(3:8)='f) C-O'
  10    WRITE(*,56)KL(1:L)
        WRITE(LO,56)KL(1:L)
        NE=0
        NF=0
C
C Establish and mark scale for horizontal axis
C
  11    JB=10*INT(0.1*BM(NZ)+1.1)
        IB=MAX0(5,5*INT(0.04*REAL(JB)))
        WRITE(KL,'(I5,A,I5)')JB,'/',IB
        M=0
          DO 12 I=1,11
          IF(KL(I:I).EQ.' ')GOTO 12
          M=M+1
          KL(M:M)=KL(I:I)
          IF(KL(M:M).EQ.'/')KL(M:M)=' '
  12      CONTINUE
        WRITE(*,FMT)' Maximum and step for B-values ['//KL(1:M)//']: '
        KL=' '
        READ(*,55,ERR=11,END=11)KL
        CALL LINTRM(KL,I)
        IF(I.EQ.0)WRITE(KL,'(2I5)')JB,IB
        READ(KL,*,ERR=11,END=11)JB,IB
        IF(JB.LT.1)GOTO 11
        IF(IB.LT.1)GOTO 11
          DO 14 M=0,JB,IB
          V=440.*REAL(M)/REAL(JB)+110.
          WRITE(KL,'(A,I5)')'(',M
          L=0
            DO 13 I=1,6
            IF(KL(I:I).EQ.' ')GOTO 13
            L=L+1
            KL(L:L)=KL(I:I)
  13        CONTINUE
          WRITE(LP,63)KL(1:L),V,V,V
  14      CONTINUE
        BM(NZ)=REAL(JB)
C
C Establish and mark scale for vertical axis
C
  15    J=INT(100.*EM(NZ)+1.1)
        K=MAX0(1,INT(0.2*REAL(J)))
        WRITE(KL,'(F6.2,A,F6.2)')0.01*REAL(J),'/',0.01*REAL(K)
        M=0
          DO 16 I=1,13
          IF(KL(I:I).EQ.' ')GOTO 16
          M=M+1
          KL(M:M)=KL(I:I)
          IF(KL(M:M).EQ.'/')KL(M:M)=' '
  16      CONTINUE
        WRITE(*,FMT)' Maximum and step for esds ['//KL(1:M)//']: '
        KL=' '
        READ(*,55,ERR=15,END=15)KL
        CALL LINTRM(KL,I)
        IF(I.EQ.0)WRITE(KL,'(2F7.3)')0.01*REAL(J),0.01*REAL(K)
        READ(KL,*,ERR=15,END=15)U,V
        J=INT(100.*U+0.5)
        IF(J.LT.1)GOTO 15
        K=INT(100.*V+0.5)
        IF(K.LT.1)GOTO 15
          DO 17 M=0,J,K
          V=440.*REAL(M)/REAL(J)+270.
          WRITE(LP,64)0.01*REAL(M),V,V,V
  17      CONTINUE
        EM(NZ)=REAL(J)*0.01
C
C Label diagrams and axes
C
        IF(NZ.NE.2.AND.NZ.LT.7)GOTO 18
        WRITE(LP,55)'(Bond length esd) 15 65 490 Q'
        WRITE(LP,55)'(Average equivalent B-value) 15 330 230 P'
        IF(NZ.EQ.2)WRITE(LP,55)'((b) Bond length esds (Angstroms))'
     +  //' 15 330 730 P'
        IF(NZ.EQ.7)WRITE(LP,55)
     +  '((d) C-C bond length esds (Angstroms)) 15 330 730 P'
        IF(NZ.EQ.8)WRITE(LP,55)
     +  '((e) C-N bond length esds (Angstroms)) 15 330 730 P'
        IF(NZ.EQ.9)WRITE(LP,55)
     +  '((f) C-O bond length esds (Angstroms)) 15 330 730 P'
        GOTO 36
  18    WRITE(LP,55)'(Positional esd) 15 65 490 Q'
        WRITE(LP,55)'(Equivalent B-value) 15 330 230 P'
        IF(NZ.GT.3)GOTO 20
        IF(NZ.EQ.3)GOTO 19
        KL='ex'
        IF(ME.LT.0)KL='in'
        WRITE(LP,55)'((a) Atom positional esds '//KL(1:2)//
     +  'cluding solvent (Angstroms)) 15 330 730 P'
        GOTO 21
  19    WRITE(LP,55)'((c) Atom positional esds '
     +  //'for solvent (Angstroms)) 15 330 730 P'
        GOTO 24
  20    IF(NZ.EQ.4)WRITE(LP,55)
     +  '((a) Carbon atom positional esds (Angstroms)) 15 330 730 P'
        IF(NZ.EQ.5)WRITE(LP,55)
     +  '((b) Nitrogen atom positional esds (Angstroms)) 15 330 730 P'
        IF(NZ.EQ.6)WRITE(LP,55)
     +  '((c) Oxygen atom positional esds (Angstroms)) 15 330 730 P'
C
C Plot quadratics in B
C
  21    IF(KQ.NE.'Y')GOTO 24
          DO 23 J=4,6
          IF(NZ.NE.1.AND.J.NE.NZ)GOTO 23
          I=0
          IF(J.EQ.5)I=9
          IF(J.EQ.6)I=2
          IF(J.EQ.NZ)I=0
          WRITE(LP,59)I
          V=2.494
          IF(J.EQ.5)V=3.219
          IF(J.EQ.6)V=4.089
          V=V*EM(NZ)
          D(4)=110.
          D(5)=270.+AMAX1(0.,440.*D(1)/V)
            DO 22 I=120,550,10
            D(6)=REAL(I)
            T=(D(6)-110.)*BM(NZ)/440.
            D(7)=270.+AMAX1(0.,440.*(D(1)+T*(D(2)+T*D(3)))/V)
            IF(D(7).GT.709.99)GOTO 23
            WRITE(LP,60)(D(L),L=4,7)
            D(4)=D(6)
            D(5)=D(7)
  22        CONTINUE
  23      CONTINUE
C
C Extract B(eq) and atom positional esds from .lst file. The first of
C the four scans finds their maximum values, the remaining scans plot
C them immediately as dots for the three figures in turn.  Atoms on
C special positions and disordered atoms are ignored, as are atoms
C other than C, N and O.  The latter are identified as having names
C beginning with C, N or O.
C
  24    KL=' '
        READ(LF,55,ERR=24,END=66)KL
        IF(INDEX(KL,'ATOM           x         y').EQ.0)GOTO 24
  25    KL=' '
        READ(LF,55,ERR=25,END=66)KL
        CALL LINTRM(KL,I)
  26    IF(INDEX(KL,'Final').NE.0)GOTO 35
        KM=KL
        KL=' '
        READ(LF,55,ERR=26,END=66)KL
        CALL LINTRM(KL,I)
        IF(KL(1:2).NE.'  ')GOTO 26
        L=1
        IF(KM(1:1).EQ.' ')L=2
        IF(KM(L:L).EQ.' ')GOTO 25
        READ(KM(42:52),*,ERR=25,END=25)T
        IF(T.LT.0.99)GOTO 25
        KS=KM(L:L)
        IF(KS.EQ.'C')GOTO 27
        IF(KS.EQ.'N')GOTO 27
        IF(KS.NE.'O')GOTO 25
  27    READ(KL(1:10),*,ERR=26,END=26)V
        I=129
  28    I=I-1
        IF(I.LT.10)GOTO 25
        IF(KM(I:I).EQ.' ')GOTO 28
        READ(KM(MAX0(1,I-9):I),*,ERR=25,END=25)T
        U=T*78.956835
        J=0
        I=INDEX(KM,'_')
  29    I=I+1
        IF(KM(I:I).GT.'9'.OR.KM(I:I).LT.'0')GOTO 30
        J=10*J+ICHAR(KM(I:I))-48
        GOTO 29
  30    I=1
        IF(J.EQ.0)I=3
        IF(J.GE.MB.AND.J.LE.ME)I=3
        IF(NZ.GT.0)GOTO 31
        BM(I)=AMAX1(BM(I),U)
        EM(I)=AMAX1(EM(I),V)
        BW=BW+U
        BN=BN+1.
        IF(I.GT.1)GOTO 25
        NB=NB+1
        IF(NB.GT.9999)GOTO 67
        KN(NB)=KM(L:L+8)
        B(NB)=U
        E(NB)=V
        GOTO 25
  31    IF(NZ.LT.4)GOTO 32
        I=0
        IF(NZ.EQ.4.AND.KS.EQ.'C')GOTO 33
        IF(NZ.EQ.5.AND.KS.EQ.'N')GOTO 33
        IF(NZ.EQ.6.AND.KS.EQ.'O')GOTO 33
        GOTO 34
  32    IF(I.NE.NZ)GOTO 25
        I=0
        IF(KS.EQ.'N')I=9
        IF(KS.EQ.'O')I=2
  33    U=440.*U/BM(NZ)+110.
        IF(U.LT.109.99)GOTO 34
        IF(U.GT.550.01)GOTO 34
        V=440.*V/EM(NZ)+270.
        IF(V.LT.269.99)GOTO 34
        IF(V.GT.710.01)GOTO 34
        WRITE(LP,58)I,U,V
        NE=NE+1
        GOTO 25
  34    NF=NF+1
        GOTO 25
C
C Extract bond length esds from .lst and find maximum or plot
C
  35    IF(NZ.NE.0)GOTO 46
  36    KL=' '
        READ(LF,55,ERR=36,END=46)KL
        CALL LINTRM(KL,I)
        IF(INDEX(KL,'Distance       Angles').EQ.0)GOTO 36
        L=1
        IF(KL(1:1).EQ.' ')L=2
        K=INDEX(KL,'-')
        IF(K.NE.0)KL(K:K)=' '
        KI=KL(L:L+8)
          DO 37 NI=1,NB
          IF(KI.EQ.KN(NI))GOTO 38
  37      CONTINUE
        GOTO 36
  38    KS=KI(1:1)
        KL=' '
  39    READ(LF,55,ERR=36,END=46)KL
        CALL LINTRM(KL,L)
        L=1
        IF(KL(1:1).EQ.' ')L=2
        IF(KL(L:L).EQ.' ')GOTO 36
        KI=KL(L:L+8)
        KL(L:L+8)='         '
          DO 40 J=1,NI-1
          IF(KI.EQ.KN(J))GOTO 41
  40      CONTINUE
        GOTO 39
  41    K=INDEX(KL,'(')
        IF(K.EQ.0)GOTO 39
        L=INDEX(KL,')')
        IF(L.EQ.0)GOTO 39
        I=-1
        IF(KS.EQ.'C'.AND.KI(1:1).EQ.'C')I=0
        IF(KS.EQ.'C'.AND.KI(1:1).EQ.'N')I=9
        IF(KS.EQ.'N'.AND.KI(1:1).EQ.'C')I=9
        IF(KS.EQ.'C'.AND.KI(1:1).EQ.'O')I=2
        IF(KS.EQ.'O'.AND.KI(1:1).EQ.'C')I=2
        IF(I.LT.0)GOTO 39
        IF(NZ.LT.4)GOTO 43
        IF(NZ.EQ.7.AND.I.EQ.0)GOTO 43
        IF(NZ.EQ.8.AND.I.EQ.9)GOTO 42
        IF(NZ.EQ.9.AND.I.EQ.2)GOTO 42
        GOTO 39
  42    I=0
  43    U=0.5*(B(NI)+B(J))
        READ(KL(K+1:L-1),*,ERR=36,END=36)V
        IF(NZ.NE.0)GOTO 44
        BM(2)=AMAX1(BM(2),U)
        EM(2)=AMAX1(EM(2),V)
        GOTO 39
  44    U=440.*U/BM(2)+110.
        IF(U.LT.109.99)GOTO 45
        IF(U.GT.550.01)GOTO 45
        V=440.*V/EM(2)+270.
        IF(V.LT.269.99)GOTO 45
        IF(V.GT.710.01)GOTO 45
        WRITE(LP,58)I,U,V
        NE=NE+1
        GOTO 39
  45    NF=NF+1
        GOTO 39
C
C Finish off each diagram
C
  46    IF(NZ.EQ.0)GOTO 47
        WRITE(LP,55)'showpage XSave restore'
        WRITE(*,61)NE,NF
        WRITE(LO,61)NE,NF
        WRITE(LO,62)
        GOTO 51
  47      DO 48 I=4,6
          BM(I)=BM(1)
          EM(I)=EM(1)
          BM(I+3)=BM(2)
          EM(I+3)=EM(2)
  48      CONTINUE
C
C Fit quadratic in B to esds
C
          DO 49 I=1,9
          D(I)=0.
  49      CONTINUE
          DO 50 I=1,NB
          T=2.494
          IF(KN(I)(1:1).EQ.'N')T=3.219
          IF(KN(I)(1:1).EQ.'O')T=4.089
          U=B(I)**2
          W=1./AMAX1(4.,U)
          D(1)=D(1)+W
          D(2)=D(2)+W*B(I)
          D(4)=D(4)+W*U
          D(5)=D(5)+W*U*B(I)
          D(6)=D(6)+W*U**2
          T=W*T*E(I)
          D(7)=D(7)+T
          D(8)=D(8)+T*B(I)
          D(9)=D(9)+T*U
  50      CONTINUE
        T=D(1)*(D(4)*D(6)-D(5)**2)-D(2)*(D(2)*D(6)-D(5)*D(4))+
     +  D(4)*(D(2)*D(5)-D(4)**2)
        IF(T.LT.1.E-8)KQ='?'
        IF(KQ.NE.'Y')GOTO 51
        U=(D(7)*(D(4)*D(6)-D(5)**2)-D(8)*(D(2)*D(6)-D(5)*D(4))+
     +  D(9)*(D(2)*D(5)-D(4)**2))/T
        D(3)=(D(1)*(D(4)*D(9)-D(5)*D(8))-D(2)*(D(2)*D(9)-D(8)*D(4))+
     +  D(7)*(D(2)*D(5)-D(4)**2))/T
        D(2)=(D(1)*(D(8)*D(6)-D(5)*D(9))-D(7)*(D(2)*D(6)-D(5)*D(4))+
     +  D(4)*(D(2)*D(9)-D(4)*D(8)))/T
        D(1)=U
        T=BW/AMAX1(BN,0.1)
        WRITE(*,53)D(1),D(2),D(3),T
        WRITE(LO,53)D(1),D(2),D(3),T
  51    REWIND LF
  52    CONTINUE
      GOTO 68
C
C Format statements and error messages
C
  53  FORMAT(/' Least-squares fit with weights 1/B^2 gives:'//
     +' sigma(r) = (',F9.5,'  +',F9.6,' * B  +',F10.7,' * B^2 ) / Z#'
     +//' Z# is scattering factor at sin(theta)/lambda = 0.3 ',
     +'(C 2.494, N 3.219, O 4.089)'/
     +/' Mean B for fully occupied C, N and O =',F7.1)
  54  FORMAT(/'%%Page:',2I5/'/XSave save def')
  55  FORMAT(A)
  56  FORMAT(/A)
  57  FORMAT(/1X,78('=')//1X,A)
  58  FORMAT('C',I1,2F7.2,' D')
  59  FORMAT('2 W C',I1)
  60  FORMAT(4F7.2,' L')
  61  FORMAT(I7,' Points plotted and',I5,'  outliers ignored ')
  62  FORMAT(/' Only C, N and O atoms and C-C, C-N and C-O bonds',
     +' inlcuded.  Disordered'/' atoms, riding atoms and atoms on ',
     +'special positions are excluded, as are'/' points that would',
     +' fall outside the specified regions.  Color scheme:  black'/
     +' = C atom or C-C bond,  blue = N atom or C-N bond,  ',
     +'red = O atom or C-O bond.'/' C, N and O are plotted ',
     +'separately for black and white Postscript output.'/)
  63  FORMAT(A,') 12',F7.2,' 255 P',F7.2,' 265',F7.2,' 269 L')
  64  FORMAT('(',F4.2,') 12 92',F7.2,' P',' 105',F7.2,
     +' 109',F7.2,' L')
  65  WRITE(*,'(/A/)')' ** Cannot open file '//KR(1:L)//' **'
      GOTO 68
  66  WRITE(*,'(/A/)')' ** Bad .lst file format **'
      GOTO 68
  67  WRITE(*,'(/A/)')' ** Too many atoms **'
  68  RETURN
      END
C
C -------------------------------------------------------------------
C
      SUBROUTINE PDBTOO(IR,IX)
C
C Read SHELXL .pdb file and convert to a non-standard PDB format for
C reading into the program O. Disordered residues are split into two
C or more residues with separate numbers.
C
      COMMON/XTAL/SY(12,192),CELL(15),II(1369),NS,LAT,LU,LN,
     +LO,LP,LF,LM,LS,NOS,IER,NPG
      COMMON/WORD/KF,KR,KD,KE,KA,KB,KN,FMT,COL,OPT
      CHARACTER KF*80,KR*80,KD(462)*52,KA(50000)*4,KE(9999)*4,
     +KB(250)*80,KN(10000)*9,FMT*20,COL*4,OPT*1,KT*80,KS*1
      INTEGER IR(10000),IX(10000)
C
C Set up .pdb files
C
      IER=1
      KF(LN+1:LN+4)='.pdb'
   1  WRITE(*,FMT)' Name of PDB format file to read ['
     +//KF(1:LN+4)//']: '
      KR=' '
      READ(*,'(A)',ERR=1,END=1)KR
      CALL LINTRM(KR,N)
      L=0
        DO 2 I=1,N
        IF(KR(I:I).EQ.' ')GOTO 2
        L=L+1
        KR(L:L)=KR(I:I)
   2    CONTINUE
      IF(L.GT.0)GOTO 3
      KR=KF
      L=LN+4
      GOTO 4
   3  IF(INDEX(KR,'.').NE.0)GOTO 4
      L=L+4
      KR(L-3:L)='.pdb'
   4  OPEN(UNIT=LF,FILE=KR(1:L),STATUS='OLD',ERR=47)
      WRITE(*,FMT)' Name of PDB format file to write [o.pdb]: '
      KR=' '
      READ(*,'(A)')KR
      CALL LINTRM(KR,N)
      N=0
        DO 5 I=1,80
        IF(KR(I:I).EQ.' ')GOTO 5
        N=N+1
        KR(N:N)=KR(I:I)
   5    CONTINUE
      IF(N.GT.0)GOTO 6
      KR='o.pdb'
      N=5
      GOTO 7
   6  IF(INDEX(KR,'.').NE.0)GOTO 7
      N=N+4
      KR(N-3:N)='.pdb'
   7  CALL WROPEN(LS,KR,N,I)
      IF(I.NE.0)GOTO 47
C
C Read PDB input file, collect disorder and residue information
C
        DO 8 I=1,10000
        IR(I)=0
   8    CONTINUE
   9  KR=' '
      READ(LF,'(A)',END=11,ERR=11)KR
      IF(KR(1:4).EQ.'ATOM')GOTO 10
      IF(KR(1:6).NE.'HETATM')GOTO 9
  10  READ(KR(23:26),'(I4)',ERR=46)N
      IR(N+1)=MAX0(1,IR(N+1),ICHAR(KR(17:17))-64)
      GOTO 9
  11  REWIND LF
      ND=0
        DO 12 I=1,10000
        IF(IR(I).LE.1)GOTO 12
        ND=ND+1
        IX(ND)=I
  12    CONTINUE
C
C Establish suitable offset for splitting residues
C
      M=500
      IF(ND.EQ.0)GOTO 19
        DO 15 M=500,9500,500
          DO 14 I=1,ND
          L=IX(I)
          K=IR(L)
            DO 13 J=2,K
            L=L+M
            IF(L.GT.10000)GOTO 15
            IF(IR(L).NE.0)GOTO 15
  13        CONTINUE
  14      CONTINUE
        WRITE(KR,'(I6)')M
        GOTO 16
  15    CONTINUE
      KR='     ?'
      M=0
  16    DO 17 I=1,6
        IF(KR(I:I).NE.' ')GOTO 18
  17    CONTINUE
  18  WRITE(*,FMT)' Offset to be applied to disordered residue '//
     +'numbers ['//KR(I:6)//']: '
      KR=' '
      READ(*,'(A)',ERR=18,END=18)KR
      CALL LINTRM(KR,I)
      IF(I.NE.0)READ(KR,*,ERR=18,END=18)M
      IF(M.LT.1)GOTO 18
C
C Write PDB output file - temporarily buffer disordered residues
C
  19  NW=-1
      NA=0
  20  KR=' '
      READ(LF,'(A)',END=48,ERR=48)KR
      CALL LINTRM(KR,I)
  21  IF(KR(1:4).EQ.'ATOM')GOTO 22
      IF(KR(1:3).EQ.'TER')GOTO 25
      IF(KR(1:5).EQ.'CRYST')GOTO 26
      IF(KR(1:5).EQ.'SCALE')GOTO 26
      IF(KR(1:6).NE.'HETATM')GOTO 20
  22  READ(KR(23:26),'(I4)',ERR=46)N
      N=N+1
        DO 23 I=1,ND
        IF(IX(I).EQ.N)GOTO 28
  23    CONTINUE
      IF(NW.EQ.0)GOTO 25
      IF(KR(13:16).NE.' W  ')GOTO 25
      IF(NW.EQ.1)GOTO 20
  24  WRITE(*,FMT)' Include difference electron density peaks '//
     +'(atom name "W") (Y or N) [Y]: '
      READ(*,'(A)',ERR=24,END=24)KT
      CALL LINTRM(KT,I)
      NW=0
      IF(INDEX(KT,'N')+INDEX(KT,'n').EQ.0)GOTO 25
      NW=1
      GOTO 20
  25  NA=NA+1
      WRITE(KR(7:11),'(I5)')NA
  26  L=1
        DO 27 I=1,80
        IF(KR(I:I).NE.' ')L=I
  27    CONTINUE
      WRITE(LS,'(A)')KR(1:L)
      GOTO 20
  28  NB=0
  29  NB=NB+1
      IF(NB.GT.250)GOTO 45
      KB(NB)=KR
  30  KR=' '
      READ(LF,'(A)',END=32,ERR=32)KR
      CALL LINTRM(KR,I)
      IF(KR(1:3).EQ.'TER')GOTO 33
      IF(KR(1:3).EQ.'END')GOTO 33
      IF(KR(1:6).EQ.'MASTER')GOTO 33
      IF(KR(1:4).EQ.'ATOM')GOTO 31
      IF(KR(1:6).NE.'HETATM')GOTO 30
  31  READ(KR(23:26),'(I4)',ERR=46)J
      IF(J+1.EQ.N)GOTO 29
      GOTO 33
C
C Expand disordered residues
C
  32  KR='END'
  33  NC=N-1
        DO 44 I=1,IR(N)
        KS=CHAR(64+I)
          DO 35 J=1,NB
          IF(KB(J)(1:4).EQ.'ATOM')GOTO 34
          IF(KB(J)(1:4).NE.'HETA')GOTO 35
  34      IF(KB(J)(17:17).EQ.KS)GOTO 36
  35      CONTINUE
        GOTO 44
  36    IF(NC.LT.N)GOTO 40
  37    IF(IR(NC+1).EQ.0)GOTO 40
        WRITE(KT,'(I8)')NC
  38    WRITE(*,FMT)KT(1:8)//' would be a duplicate residue number; '
     +  //'enter new one: '
  39    READ(*,*,ERR=38,END=38)NC
        IF(NC.GE.0.AND.NC.LE.9999)GOTO 37
        WRITE(*,FMT)' Illegal residue number; enter new one: '
        GOTO 39
  40      DO 43 J=1,NB
          KT=KB(J)
          IF(KT(17:17).EQ.KS)GOTO 41
          IF(KT(17:17).NE.' ')GOTO 43
  41      NA=NA+1
          WRITE(KT(7:11),'(I5)')NA
          KT(17:17)=' '
          WRITE(KT(23:26),'(I4)')NC
          L=1
            DO 42 K=1,80
            IF(KT(K:K).NE.' ')L=K
  42        CONTINUE
          WRITE(LS,'(A)')KT(1:L)
  43      CONTINUE
        NC=NC+M
  44    CONTINUE
      GOTO 21
  45  WRITE(*,'(/A,I5,A/)')' ** Too many atoms in residue',N,'  **'
      GOTO 49
  46  WRITE(*,'(/A/)')' ** Bad PDB format **'
      GOTO 49
  47  WRITE(*,'(/A/)')' ** Cannot open file **'
      GOTO 49
  48  IER=0
  49  CLOSE(LS,IOSTAT=I)
      RETURN
      END
C
C -------------------------------------------------------------------
C
      SUBROUTINE HKLGEN
C
C Read reflection data file and reformat into SHELX .hkl format.
C
      COMMON/XTAL/SY(12,192),CELL(15),II(1369),NS,LAT,LU,LN,
     +LO,LP,LF,LM,LS,NOS,IER,NPG
      COMMON/WORD/KF,KR,KD,KE,KA,KB,KN,FMT,COL,OPT
      CHARACTER KF*80,KR*80,KD(462)*52,KA(50000)*4,KE(9999)*4,
     +KB(250)*80,KN(10000)*9,FMT*20,COL*4,OPT*1,KT*80,KS*80
C
C Set up files
C
      KF(LN+1:LN+4)='.raw'
   1  WRITE(*,FMT)' Name of reflection data file to read ['
     +//KF(1:LN+4)//']: '
      KR=' '
      READ(*,'(A)',ERR=1,END=1)KR
      CALL LINTRM(KR,N)
      L=0
        DO 2 I=1,N
        IF(KR(I:I).EQ.' ')GOTO 2
        L=L+1
        KR(L:L)=KR(I:I)
   2    CONTINUE
      IF(L.GT.0)GOTO 3
      KR=KF
      L=LN+4
      GOTO 4
   3  IF(INDEX(KR,'.').NE.0)GOTO 4
      L=L+4
      KR(L-3:L)='.raw'
   4  OPEN(UNIT=LF,FILE=KR(1:L),STATUS='OLD',ERR=22)
      KF(LN+1:LN+4)='.hkl'
   5  WRITE(*,FMT)' Name of .hkl format file to write ['//
     +KF(1:LN+4)//']: '
      KR=' '
      READ(*,'(A)',ERR=5,END=5)KR
      CALL LINTRM(KR,N)
      N=0
        DO 6 I=1,80
        IF(KR(I:I).EQ.' ')GOTO 6
        N=N+1
        KR(N:N)=KR(I:I)
   6    CONTINUE
      IF(N.GT.0)GOTO 7
      KR=KF
      N=LN+4
      GOTO 8
   7  IF(INDEX(KR,'.').NE.0)GOTO 8
      N=N+4
      KR(N-3:N)='.pdb'
   8  CALL WROPEN(LS,KR,N,I)
      IF(I.NE.0)GOTO 22
C
C Read input file, set up format
C
      NN=0
      NT=0
   9  KR=' '
      READ(LF,'(A)',ERR=21,END=21)KR
      CALL LINTRM(KR,I)
      IF(I.EQ.0)GOTO 9
      WRITE(*,'(1X,A)')KR(1:I)
      WRITE(*,FMT)' '
      KT=' '
      READ(*,'(A)',ERR=21)KT
      CALL LINTRM(KT,L)
      IF(L.EQ.0)GOTO 9
        DO 10 I=1,L
        IF(KT(I:I).GE.'a'.AND.KT(I:I).LE.'z')KT(I:I)=
     +  CHAR(ICHAR(KT(I:I))-32)
  10    CONTINUE
      IF(INDEX(KT,'*').NE.0)GOTO 20
      NT=1
      GOTO 12
  11  KR=' '
      READ(LF,'(A)',ERR=23,END=23)KR
      CALL LINTRM(KR,I)
  12  NH=0
      NK=10
      NL=20
      NF=30
      NE=50
      KS=KR
      KR=' '
        DO 17 N=1,L
        IF(KT(N:N).NE.'H')GOTO 13
        NH=NH+1
        KR(NH:NH)=KS(N:N)
        GOTO 17
  13    IF(KT(N:N).NE.'K')GOTO 14
        NK=NK+1
        KR(NK:NK)=KS(N:N)
        GOTO 17
  14    IF(KT(N:N).NE.'L')GOTO 15
        NL=NL+1
        KR(NL:NL)=KS(N:N)
        GOTO 17
  15    IF(KT(N:N).NE.'F')GOTO 16
        NF=NF+1
        KR(NF:NF)=KS(N:N)
        GOTO 17
  16    IF(KT(N:N).NE.'S')GOTO 17
        NE=NE+1
        KR(NE:NE)=KS(N:N)
  17    CONTINUE
      GOTO 20
  18  WRITE(LS,'(3I4,2F8.0)')I,J,K,F,S
  19  IF(IABS(I)+IABS(J)+IABS(K).EQ.0)GOTO 24
      NN=NN+1
      IF(NT.NE.0)GOTO 11
      KR=' '
      READ(LF,'(A)',ERR=23,END=23)KR
      CALL LINTRM(KR,I)
  20  READ(KR,*,ERR=23,END=23)I,J,K,F,S
      IF(F.GT.99999.99)GOTO 18
      IF(S.GT.99999.99)GOTO 18
      IF(F.LT.-9999.99)GOTO 18
      IF(S.LT.-9999.99)GOTO 18
      WRITE(LS,'(3I4,2F8.2)')I,J,K,F,S
      GOTO 19
  21  WRITE(*,'(/A/)')' ** Inconsistent reflection data format **'
      GOTO 25
  22  WRITE(*,'(/A/)')' ** Cannot open file **'
      GOTO 25
  23  I=0
      F=0.
      WRITE(LS,'(3I4,2F8.2)')I,I,I,F,F
  24  WRITE(*,'(I7,A)')NN,' reflections processed'
  25  CLOSE(LS,IOSTAT=I)
      RETURN
      END
C
C -------------------------------------------------------------------
C
      SUBROUTINE PDBDEP(MX,IR,IX,ID,IY,IN,IM,XX,YY,ZZ)
C
C Copy PDB file written by SHELXL and insert material needed for
C deposition with the Brookhaven PDB.  Some of the necessary items
C are extracted from the .lst file, others are input by interaction
C with the user or must be edited by hand later.
C
      COMMON/XTAL/SY(12,192),CELL(15),II(1369),NS,LAT,LU,LN,
     +LO,LP,LF,LM,LS,NOS,IER,NPG
      COMMON/WORD/KF,KR,KD,KE,KA,KB,KN,FMT,COL,OPT
      CHARACTER KF*80,KR*80,KD(462)*52,KA(50000)*4,KE(9999)*4,KSP*20,
     +KB(250)*80,KN(10000)*9,FMT*20,COL*4,OPT*1,KT*80,KQ*11,KL*128,
     +KG(44)*3,KC*1,KZ*3
      REAL D(6)
      INTEGER IR(10000),IX(10000),ID(10000),IY(10000),IN(10000),IM(MX)
      REAL XX(MX),YY(MX),ZZ(MX),WK(20)
      DATA KG/'ALA','ARG','ASN','ASP','CYS','GLN','GLU','GLY','HIS',
     +'ILE','LEU','LYS','MET','PHE','PRO','SER','THR','TRP','TYR',
     +'VAL','ALI','ACD','PCA','ARO','GLX','SAR','ABU','ALB','HYP',
     +'ASX','BAS','UNK','A  ','C  ','G  ','I  ','T  ','U  ','ACE',
     +'FOR','HOH','WAT','H2O','OH2'/
      DATA WK/89.09,174.20,132.12,133.10,121.15,146.15,147.13,75.07,
     +155.16,131.17,131.17,146.19,149.21,165.19,115.13,105.09,119.12,
     +204.23,181.19,117.15/
C
C Set up template
C
      KSP='P 21 21 21'
      KQ='REMARK   3 '
      KD(1)='HEADER'
      KD(2)='TITLE'
      KD(3)='COMPND    MOL_ID: 1;'
      KD(4)='COMPND   2 MOLECULE:'
      KD(5)='SOURCE    ORGANISM_SCIENTIFIC:'
      KD(6)='KEYWDS'
      KD(7)='EXPDTA    X-RAY DIFFRACTION'
      KD(8)='AUTHOR'
      KD(9)='REVDAT'
      KD(10)='JRNL        AUTH'
      KD(11)='JRNL        TITL'
      KD(12)='JRNL        REF    TO BE PUBLISHED'
      KD(13)='JRNL        REFN'
      KD(14)='REMARK   1'
      KD(15)='REMARK   2'
      KD(16)='REMARK   2 RESOLUTION.       ANGSTROMS.'
      KD(17)=' '
      KD(18)='REFINEMENT.'
      KD(19)=' PROGRAM     : SHELXL-97'
      KD(20)=' AUTHORS     : G.M.SHELDRICK'
      KD(21)=' '
      KD(22)='DATA USED IN REFINEMENT.'
      KD(23)=' RESOLUTION RANGE HIGH (ANGSTROMS) :'
      KD(24)=' RESOLUTION RANGE LOW  (ANGSTROMS) :'
      KD(25)=' DATA CUTOFF            (SIGMA(F)) :  0.0'
      KD(26)=' COMPLETENESS FOR RANGE        (%) :'
      KD(27)=' CROSS-VALIDATION METHOD           :  FREE R'
      KD(28)=' FREE R VALUE TEST SET SELECTION   :  RANDOM'
      KD(29)=' '
      KD(30)='FIT TO DATA USED IN REFINEMENT (NO CUTOFF).'
      KD(31)=' R VALUE   (WORKING + TEST SET, NO CUTOFF) :'
      KD(32)=' R VALUE          (WORKING SET, NO CUTOFF) :'
      KD(33)=' FREE R VALUE                  (NO CUTOFF) :'
      KD(34)=' FREE R VALUE TEST SET SIZE (%, NO CUTOFF) :'
      KD(35)=' FREE R VALUE TEST SET COUNT   (NO CUTOFF) :'
      KD(36)=' TOTAL NUMBER OF REFLECTIONS   (NO CUTOFF) :'
      KD(37)=' '
      KD(38)='FIT/AGREEMENT OF MODEL FOR DATA WITH F>4SIG(F).'
      KD(39)=' R VALUE   (WORKING + TEST SET, F>4SIG(F)) :'
      KD(40)=' R VALUE          (WORKING SET, F>4SIG(F)) :'
      KD(41)=' FREE R VALUE                  (F>4SIG(F)) :'
      KD(42)=' FREE R VALUE TEST SET SIZE (%, F>4SIG(F)) :'
      KD(43)=' FREE R VALUE TEST SET COUNT   (F>4SIG(F)) :'
      KD(44)=' TOTAL NUMBER OF REFLECTIONS   (F>4SIG(F)) :'
      KD(45)=' '
      KD(46)='NUMBER OF NON-HYDROGEN ATOMS USED IN REFINEMENT.'
      KD(47)=' PROTEIN ATOMS      :'
      KD(48)=' NUCLEIC ACID ATOMS :'
      KD(49)=' HETEROGEN ATOMS    :'
      KD(50)=' SOLVENT ATOMS      :'
      KD(51)=' '
      KD(52)='MODEL REFINEMENT.'
      KD(53)=' OCCUPANCY SUM OF NON-HYDROGEN ATOMS      :'
      KD(54)=' OCCUPANCY SUM OF HYDROGEN ATOMS          :'
      KD(55)=' NUMBER OF DISCRETELY DISORDERED RESIDUES :'
      KD(56)=' NUMBER OF LEAST-SQUARES PARAMETERS       :'
      KD(57)=' NUMBER OF RESTRAINTS                     :'
      KD(58)=' '
      KD(59)='RMS DEVIATIONS FROM RESTRAINT TARGET VALUES.'
      KD(60)=' BOND LENGTHS                         (A) :'
      KD(61)=' ANGLE DISTANCES                      (A) :'
      KD(62)=' SIMILAR DISTANCES (NO TARGET VALUES) (A) :'
      KD(63)=' DISTANCES FROM RESTRAINT PLANES      (A) :'
      KD(64)=' ZERO CHIRAL VOLUMES               (A**3) :'
      KD(65)=' NON-ZERO CHIRAL VOLUMES           (A**3) :'
      KD(66)=' ANTI-BUMPING DISTANCE RESTRAINTS     (A) :'
      KD(67)=' RIGID-BOND ADP COMPONENTS         (A**2) :'
      KD(68)=' SIMILAR ADP COMPONENTS            (A**2) :'
      KD(69)=' APPROXIMATELY ISOTROPIC ADPS      (A**2) :'
      KD(70)=' '
      KD(71)='BULK SOLVENT MODELING.'
      KD(72)=' METHOD USED : NONE'
      KD(73)=' '
      KD(74)='STEREOCHEMISTRY TARGET VALUES : ENGH AND HUBER'
      KD(75)=' SPECIAL CASE:'
      KD(76)=' '
      KD(77)='OTHER REFINEMENT REMARKS:'
      KD(78)=' '
      KD(79)='EXPERIMENTAL DETAILS.'
      KD(80)=' EXPERIMENT TYPE                : X-RAY DIFFRACTION'
      KD(81)=' DATE OF DATA COLLECTION        :'
      KD(82)=' TEMPERATURE           (KELVIN) :'
      KD(83)=' PH                             :'
      KD(84)=' NUMBER OF CRYSTALS USED        :'
      KD(85)=' '
      KD(86)=' SYNCHROTRON              (Y/N) :'
      KD(87)=' RADIATION SOURCE               :'
      KD(88)=' BEAMLINE                       :'
      KD(89)=' X-RAY GENERATOR MODEL          :'
      KD(90)=' MONOCHROMATIC OR LAUE    (M/L) : M'
      KD(91)=' WAVELENGTH OR RANGE        (A) :'
      KD(92)=' MONOCHROMATOR                  :'
      KD(93)=' OPTICS                         :'
      KD(94)=' '
      KD(95)=' DETECTOR TYPE                  :'
      KD(96)=' DETECTOR MANUFACTURER          :'
      KD(97)=' INTENSITY-INTEGRATION SOFTWARE :'
      KD(98)=' DATA SCALING SOFTWARE          :'
      KD(99)=' '
      KD(100)=' NUMBER OF UNIQUE REFLECTIONS   :'
      KD(101)=' RESOLUTION RANGE HIGH      (A) :'
      KD(102)=' RESOLUTION RANGE LOW       (A) :'
      KD(103)=' REJECTION CRITERIA (SIGMA/I)   : NONE'
      KD(104)=' '
      KD(105)='OVERALL.'
      KD(106)=' COMPLETENESS FOR RANGE     (%) :'
      KD(107)=' DATA REDUNDANCY                :'
      KD(108)=' R MERGE                    (I) :'
      KD(109)=' R SYM                      (I) : NULL'
      KD(110)=' <I/SIGMA(I)> FOR THE DATA SET  :'
      KD(111)=' '
      KD(112)='IN THE HIGHEST RESOLUTION SHELL.'
      KD(113)=' HIGHEST RESOLUTION SHELL, RANGE HIGH (A) :'
      KD(114)=' HIGHEST RESOLUTION SHELL, RANGE LOW  (A) :'
      KD(115)=' COMPLETENESS FOR SHELL     (%) :'
      KD(116)=' DATA REDUNDANCY IN SHELL       :'
      KD(117)=' R MERGE FOR SHELL          (I) :'
      KD(118)=' R SYM FOR SHELL            (I) : NULL'
      KD(119)=' <I/SIGMA(I)> FOR SHELL         :'
      KD(120)=' '
      KD(121)='METHOD USED TO DETERMINE THE STRUCTURE: AB INITIO'
      KD(122)='SOFTWARE USED: SHELX'
      KD(123)='STARTING MODEL: NONE'
      KD(124)=' '
      KD(125)='REMARK:'
      KD(126)=' '
      KD(127)='CRYSTAL'
      KD(128)='SOLVENT CONTENT, VS   (%):'
      KD(129)='MATTHEWS COEFFICIENT, VM (ANGSTROMS**3/DA):'
      KD(130)=' '
      KD(131)='CRYSTALLIZATION CONDITIONS:'
      KD(132)=' '
      RE=0.1
      RF=999.
      VO=-999.
      WL=-999.
      TM=-999.
      IZ=0
      NR=0
      JH=0
      JA=0
      JR=0
      JW=0
      MM=0
      NP=0
      NN=0
      NH=0
      NW=0
      IH=0
        DO 1 I=1,10000
        IX(I)=0
        IY(I)=0
        ID(I)=0
        IN(I)=0
   1    CONTINUE
C
C Set up .pdb and .ent files
C
      IER=1
      KF(LN+1:LN+4)='.pdb'
   2  WRITE(*,FMT)' Name of .pdb file written by SHELXL ['
     +//KF(1:LN+4)//']: '
      KR=' '
      READ(*,'(A)',ERR=2,END=2)KR
      CALL LINTRM(KR,N)
      L=0
        DO 3 I=1,N
        IF(KR(I:I).EQ.' ')GOTO 3
        L=L+1
        KR(L:L)=KR(I:I)
   3    CONTINUE
      IF(L.GT.0)GOTO 4
      KR=KF
      L=LN+4
      GOTO 5
   4  IF(INDEX(KR,'.').NE.0)GOTO 5
      L=L+4
      KR(L-3:L)='.pdb'
   5  OPEN(UNIT=LF,FILE=KR(1:L),STATUS='OLD',ERR=131)
      KF(LN+1:LN+4)='.ent'
   6  WRITE(*,FMT)' Name of file to write for deposition ['
     +//KF(1:LN+4)//']: '
      KR=' '
      READ(*,'(A)',ERR=6,END=6)KR
      CALL LINTRM(KR,N)
      L=0
        DO 7 I=1,N
        IF(KR(I:I).EQ.' ')GOTO 7
        L=L+1
        KR(L:L)=KR(I:I)
   7    CONTINUE
      IF(L.GT.0)GOTO 8
      KR=KF
      L=LN+4
      GOTO 9
   8  IF(INDEX(KR,'.').NE.0)GOTO 9
      L=L+4
      KR(L-3:L)='.ent'
   9  CALL WROPEN(LS,KR,L,I)
      IF(I.NE.0)GOTO 131
C
C Open .lst file if possible
C
      KF(LN+1:LN+4)='.lst'
  10  WRITE(*,FMT)' Name of .lst file written by SHELXL ['
     +//KF(1:LN+4)//']: '
      KR=' '
      READ(*,'(A)',ERR=10,END=10)KR
      CALL LINTRM(KR,N)
      L=0
        DO 11 I=1,N
        IF(KR(I:I).EQ.' ')GOTO 11
        L=L+1
        KR(L:L)=KR(I:I)
  11    CONTINUE
      IF(L.GT.0)GOTO 12
      KR=KF
      L=LN+4
      GOTO 13
  12  IF(INDEX(KR,'.').NE.0)GOTO 13
      L=L+4
      KR(L-3:L)='.lst'
  13  OPEN(UNIT=LM,FILE=KR(1:L),STATUS='OLD',ERR=27)
C
C Read .lst file and extract useful information if available
C
  14  KR=' '
      READ(LM,'(A)',ERR=15,END=26)KL
      N=INDEX(KL,'+')
      IF(N.EQ.0)GOTO 14
  15  KR=' '
      READ(LM,'(A)',ERR=15,END=26)KL
      CALL LINTRM(KL,I)
  16    DO 17 I=N,N+3
        IF(KL(I:I).GE.'a'.AND.KL(I:I).LE.'z')KL(I:I)=
     +  CHAR(ICHAR(KL(I:I))-32)
  17    CONTINUE
      IF(KL(N:N+3).NE.'CELL')GOTO 18
      KL(N:N+3)='    '
      READ(KL,*,ERR=15,END=15)WL
  18  IF(KL(N:N+14).EQ.'REM Space group')KSP=KL(N+16:N+35)
      IF(KL(N:N+3).NE.'SHEL')GOTO 19
      KL(N:N+3)='    '
      READ(KL,*,ERR=15,END=15)P,Q
      RE=AMIN1(P,Q)
      RF=AMAX1(P,Q)
      GOTO 15
  19  IF(KL(N+9:N+16).EQ.'fuse sol')JW=1
      IF(KL(N:N+3).EQ.'HOPE')JH=1
      IF(KL(N:N+3).NE.'ZERR')GOTO 20
      READ(KL(N+4:80),*,ERR=20,END=20)T
      IZ=INT(T)
  20  IF(KL(N:N+3).EQ.'PRIN'.AND.KL(N+16:N+19).EQ.'quar')JA=1
      IF(KL(N:N+6).NE.'RMS dev')GOTO 22
      IF(KL(N+19:N+22).EQ.'FLAT')GOTO 21
      KD(66)(44:50)=KL(N+15:N+21)
      KD(60)(44:50)=KL(N+24:N+30)
      KD(61)(44:50)=KL(N+33:N+39)
      KD(62)(44:50)=KL(N+42:N+48)
      KD(64)(44:50)=KL(N+51:N+57)
      KD(65)(44:50)=KL(N+60:N+66)
      KD(63)(44:50)=KL(N+69:N+75)
      KD(67)(44:50)=KL(N+78:N+84)
      KD(68)(44:50)=KL(N+87:N+93)
      KD(69)(44:50)=KL(N+96:N+102)
      GOTO 22
  21  KD(63)(44:50)=KL(N+33:N+39)
  22  IF(KL(N:N+3).EQ.'GOOF'.AND.KL(N+67:N+70).EQ.'rest')
     +KD(57)(44:50)=KL(N+59:N+65)
      IF(KL(N:N+3).EQ.'TOTA'.AND.KL(N+16:N+19).EQ.'l.s.')
     +KD(56)(45:50)=KL(N+33:N+38)
      IF(KL(N+7:N+12).NE.'cy sum')GOTO 23
      KD(53)(45:52)=KL(N+34:N+41)
      KD(54)(45:52)=KL(N+63:N+70)
  23  IF(KL(N:N+3).NE.'R1 ='.OR.KL(N+29:N+32).NE.'4sig')GOTO 24
      KD(39)(45:52)=KL(N+4:N+11)
      KD(44)(46:52)=KL(N+16:N+22)
      KD(31)(45:52)=KL(N+42:N+49)
      KD(36)(46:52)=KL(N+58:N+64)
      READ(KL(N+58:N+64),'(I7)',ERR=15,END=15)NR
      GOTO 15
  24  IF(KL(N:N+5).NE.'REM R1')GOTO 25
      IF(KL(N+7:N+10).NE.'Free')GOTO 25
      KD(41)(45:52)=KL(N+14:N+21)
      KD(43)(47:52)=KL(N+26:N+31)
      KD(33)(45:52)=KL(N+51:N+58)
      KD(35)(47:52)=KL(N+67:N+72)
      KR=' '
      READ(LM,'(A)',ERR=15,END=26)KL
      CALL LINTRM(KL,I)
      IF(KL(N:N+7).NE.'REM R1 =')GOTO 16
      KD(40)(45:52)=KL(N+8:N+15)
      KD(32)(45:52)=KL(N+46:N+53)
      GOTO 15
  25  I=INDEX(KL,'Max. 2-theta =')
      IF(I.EQ.0)GOTO 15
      READ(KL(I+14:I+21),*,ERR=15,END=15)TM
      GOTO 15
  26  CLOSE(UNIT=LM)
      GOTO 28
  27  WRITE(*,'(/A/)')' ** .lst file cannot be opened, so more '//
     +'hand editing will be needed **'
C
C Read PDB input file, collect residue information etc.
C
  28  KR=' '
      READ(LF,'(A)',END=36,ERR=36)KR
      CALL LINTRM(KR,I)
      IF(KR(1:6).NE.'CRYST1')GOTO 31
      READ(KR(7:80),*,ERR=28,END=28)(CELL(I),I=1,6)
      IF(KR(56:56).NE.' ')KSP=KR(56:66)
      I=0
      IF(KR(67:70).NE.'    ')READ(KR(67:71),*,ERR=29,END=29)I
      IF(I.GT.0)IZ=I
  29    DO 30 I=1,3
        IF(CELL(I).LT.0.1)GOTO 28
        T=.0174533*CELL(I+3)
        IF(T.LT.0.001)GOTO 28
        D(I)=SIN(T)
        D(I+3)=COS(T)
        CELL(I+6)=(D(I)/CELL(I))**2
  30    CONTINUE
      V=1.-D(4)**2-D(5)**2-D(6)**2+2.*D(4)*D(5)*D(6)
      VO=V*CELL(1)*CELL(2)*CELL(3)
      CELL(7)=CELL(7)/V
      CELL(8)=CELL(8)/V
      CELL(9)=CELL(9)/V
      CELL(10)=2.*SQRT(CELL(8)*CELL(9))*(D(5)*D(6)-D(4))/(D(2)*D(3))
      CELL(11)=2.*SQRT(CELL(7)*CELL(9))*(D(4)*D(6)-D(5))/(D(1)*D(3))
      CELL(12)=2.*SQRT(CELL(7)*CELL(8))*(D(4)*D(5)-D(6))/(D(1)*D(2))
      GOTO 28
  31  IF(KR(1:4).NE.'HETA'.AND.KR(1:4).NE.'ATOM')GOTO 28
      IF(KR(14:20).EQ.'W   HOH')GOTO 28
      READ(KR(23:26),'(I4)',ERR=28,END=28)J
      IF(J.LT.0)GOTO 28
      IF(IN(J+1).NE.0)GOTO 32
      JR=JR+1
      IN(J+1)=JR
      IR(JR)=J
      IY(JR)=J
      KN(JR)=KR(18:20)//' '
      IF(KR(22:22).EQ.' ')GOTO 32
      WRITE(*,'(/A/)')' ** Chain IDs not allowed in input PDB file **'
      GOTO 39
  32  J=IN(J+1)
      IX(J)=IX(J)+1
      IF(KR(17:17).NE.' ')ID(J)=1
      IF(KR(13:13).GE.'A'.AND.KR(13:13).LE.'Z')GOTO 33
      IF(KR(14:14).EQ.'H')GOTO 28
  33  IF(KR(18:20).EQ.'HOH')GOTO 34
      IF(KR(17:17).NE.' '.AND.KR(17:17).NE.'A')GOTO 34
      MM=MM+1
      IF(MM.GT.MX)GOTO 38
      IF(MM.GT.50000)GOTO 38
      KA(MM)='    '
      READ(KR,'(12X,A4,6X,I4,4X,3F8.3)',ERR=37,END=37)KA(MM),
     +IM(MM),XX(MM),YY(MM),ZZ(MM)
  34    DO 35 I=1,44
        IF(KR(18:20).NE.KG(I))GOTO 35
        IF(I.LT.33)NP=NP+1
        IF(I.GT.32.AND.I.LT.39)NN=NN+1
        IF(I.GT.40)NW=NW+1
        GOTO 28
  35    CONTINUE
      NH=NH+1
      GOTO 28
  36  REWIND LF
      IF(VO.GT.-998.)GOTO 41
  37  WRITE(*,'(/A/)')' ** Bad PDB input file **'
      GOTO 39
  38  WRITE(*,'(/A/)')' ** Too many atoms in PDB input file **'
  39  IER=1
      GOTO 134
C
C Define chains (if any)
C
  40  FORMAT(/' Define chains; if there is only one, it should',
     +' be given the symbol ''*''.'/' Enter letter to identify',
     +' chain (''$'' if none) followed by the first and last'/
     +' old residue numbers and the first new residue number.  Term',
     +'inate the input'/' with a blank line.  It may be necessary',
     +' to renumber the solvent!  Thus if'/' there were two chains',
     +' numbered 1001-1189 and 2001-2189 followed by waters'/
     +' with residue numbers 1-111, three lines should be entered:'/
     +' A 1001 1189 1'/' B 2001 2189 1'/' $ 1 111 201'/)
  41  WRITE(*,40)
  42  WRITE(*,FMT)' Define chain: '
      KR=' '
      READ(*,'(A)',ERR=47,END=47)KR
      CALL LINTRM(KR,I)
        DO 43 J=1,I
        IF(KR(J:J).NE.' ')GOTO 46
  43    CONTINUE
      KN(JR+1)(4:4)=' '
        DO 45 I=1,JR
        KN(I)(5:6)=' H'
        IF(KN(I)(4:4).NE.KN(I+1)(4:4))KN(I)(5:5)=KN(I)(4:4)
          DO 44 J=1,20
          IF(KN(I)(1:3).EQ.KG(J))KN(I)(6:6)='A'
  44      CONTINUE
  45    CONTINUE
      GOTO 50
  46  KC=KR(J:J)
      IF(KC.LT.'0'.OR.KC.GT.'9')GOTO 48
  47  WRITE(*,'(/A/)')' ** Bad chain definition - try again **'
      GOTO 42
  48  KR(J:J)=' '
      READ(KR,*,ERR=47,END=47)J,K,L
      IF(K.LT.J)GOTO 47
      IF(L.LT.1)GOTO 47
      IF(K.GT.9999)GOTO 47
      IF(L+K-J.GT.9999)GOTO 47
      IF(KC.GE.'a'.AND.KC.LE.'z')KC=CHAR(ICHAR(KC)-32)
      IF(KC.EQ.'$')KC=' '
        DO 49 I=1,JR
        IF(IR(I).LT.J)GOTO 49
        IF(IR(I).GT.K)GOTO 49
        IY(I)=L+IR(I)-J
        KN(I)(4:4)=KC
  49    CONTINUE
      GOTO 42
C
C Convert space group name to PDB convention and generate operators
C
  50  IER=0
      N=1
        DO 51 I=1,20
        IF(KSP(I:I).NE.' ')N=I
  51    CONTINUE
      WRITE(*,'(1X)')
  52  WRITE(*,FMT)' Enter space group ['//KSP(1:N)//']: '
      KR=' '
      READ(*,'(A)',ERR=59,END=59)KR
      CALL LINTRM(KR,I)
      IF(I.EQ.0)KR(1:20)=KSP
        DO 53 I=1,20
        IF(KR(I:I).NE.' ')GOTO 54
  53    CONTINUE
      GOTO 52
  54  IF(KR(I:I).GE.'a'.AND.KR(I:I).LE.'z')KR(I:I)=
     +CHAR(ICHAR(KR(I:I))-32)
      KSP=KR(I:I)//' '
      N=2
  55  I=I+1
      IF(I.GT.20)GOTO 56
      IF(KR(I:I).EQ.' ')GOTO 55
      IF(KR(I:I).EQ.CHAR(40))GOTO 55
      IF(KR(I:I).EQ.CHAR(41))GOTO 55
      N=N+1
      KSP(N:N)=KR(I:I)
      GOTO 55
  56  IF(N.LT.4)GOTO 58
      IF(KSP(3:5).EQ.'23 ')KSP(3:5)='2 3'
      IF(KSP(1:5).EQ.'R 32 ')KSP(3:5)='3 2'
      IF(KSP(3:6).EQ.'213 ')KSP(3:6)='21 3'
      IF(KSP(3:7).NE.'4212 ')GOTO 57
      KSP(3:8)='4 21 2'
      GOTO 58
  57  KR(1:20)=KSP
      IF(N.EQ.5)KSP(3:7)=KR(3:3)//' '//KR(4:4)//' '//KR(5:5)
      IF(N.EQ.6)KSP(3:8)=KR(3:4)//' '//KR(5:5)//' '//KR(6:6)
      IF(N.GT.6)KSP(3:10)=KR(3:4)//' '//KR(5:6)//' '//KR(7:8)
  58  KR(1:20)=KSP
      CALL SPAGSY(KR)
      IF(IER.EQ.0)GOTO 60
  59  KSP='?'
      GOTO 41
C
C Incorporate lattice operators into symmetry operators
C
  60  IF(LAT.EQ.-1)GOTO 68
      N=NS
      L=5-LAT
      IF(LAT.GT.-5)GOTO 62
        DO 61 I=1,N
        NS=NS+1
        SY(L,NS)=SY(L,I)+.5
  61    CONTINUE
      GOTO 68
  62  IF(LAT.NE.-2)GOTO 64
        DO 63 I=1,N
        NS=NS+1
        SY(10,NS)=SY(10,I)+.5
        SY(11,NS)=SY(11,I)+.5
        SY(12,NS)=SY(12,I)+.5
  63    CONTINUE
  64  IF(LAT.NE.-3)GOTO 66
        DO 65 I=1,N
        NS=NS+1
        SY(10,NS)=SY(10,I)+.6666667
        SY(11,NS)=SY(11,I)+.3333333
        SY(12,NS)=SY(12,I)+.3333333
        NS=NS+1
        SY(10,NS)=SY(10,I)+.3333333
        SY(11,NS)=SY(11,I)+.6666667
        SY(12,NS)=SY(12,I)+.6666667
  65    CONTINUE
  66  IF(LAT.NE.-4)GOTO 68
        DO 67 I=1,N
        NS=NS+1
        SY(12,NS)=SY(12,I)+.5
        SY(11,NS)=SY(11,I)+.5
        NS=NS+1
        SY(10,NS)=SY(10,I)+.5
        SY(12,NS)=SY(12,I)+.5
        NS=NS+1
        SY(10,NS)=SY(10,I)+.5
        SY(11,NS)=SY(11,I)+.5
  67    CONTINUE
C
C Theoretical number of unique reflections
C
  68  IF(IZ.LT.1)IZ=NS
      IF(TM.LE.0.)GOTO 69
      IF(WL.LE.0.)GOTO 69
      RE=AMAX1(RE,0.5*WL/SIN(0.008726646*TM))
  69  WRITE(KR,'(F7.3)',ERR=69)RE
      WRITE(*,'(1X)')
      WRITE(*,FMT)' Highest resolution ['//KR(1:7)//']: '
      KR=' '
      READ(*,'(A)',ERR=69,END=69)KR
      CALL LINTRM(KR,I)
      IF(I.GT.0)READ(KR,*,ERR=69,END=69)RE
      IF(RE.LT.0.01)GOTO 69
      WRITE(KD(16)(24:28),'(F5.2)')RE
      WRITE(KD(23)(37:42),'(F6.2)')RE
      IF(RF.LT.998.)WRITE(KD(24)(37:42),'(F6.2)')RF
      IF(RF.GE.998.)KD(24)(39:46)='INFINITY'
      MAXH=INT(CELL(1)/RE+.5)
      MAXK=INT(CELL(2)/RE+.5)
      MAXL=INT(CELL(3)/RE+.5)
      MINH=-1-MAXH
      MINK=-1-MAXK
      RE=RE-1.E-6
      RF=RF+1.E-6
      ML=-1
  70  ML=ML+1
      IF(ML.GT.MAXL)GOTO 76
      W=REAL(ML)
      MK=MINK
      IF(ML.EQ.0)MK=-1
  71  MK=MK+1
      IF(MK.GT.MAXK)GOTO 70
      V=REAL(MK)
      MT=IABS(MK)+IABS(ML)
      MH=MINH
      IF(MT.EQ.0)MH=0
  72  MH=MH+1
      IF(MH.GT.MAXH)GOTO 71
      IF(IABS(MH)+MT.EQ.0)GOTO 72
      U=REAL(MH)
        DO 75 N=2,NS
        M=1
        IH=INT(1.0001*(U*SY(1,N)+V*SY(4,N)+W*SY(7,N)))
        IK=INT(1.0001*(U*SY(2,N)+V*SY(5,N)+W*SY(8,N)))
        IL=INT(1.0001*(U*SY(3,N)+V*SY(6,N)+W*SY(9,N)))
        IF(IL.GT.0)GOTO 74
        IF(IL.LT.0)GOTO 73
        IF(IK.GT.0)GOTO 74
        IF(IK.LT.0)GOTO 73
        IF(IH.GE.0)GOTO 74
  73    IH=-IH
        IK=-IK
        IL=-IL
        M=-1
  74    IF(IL.GT.ML)GOTO 72
        IF(IL.LT.ML)GOTO 75
        IF(IK.GT.MK)GOTO 72
        IF(IK.LT.MK)GOTO 75
        IF(IH.GT.MH)GOTO 72
        IF(IH.LT.MH)GOTO 75
        IF(M.LT.0)GOTO 75
        IF(ABS(AMOD(999.5+U*SY(10,N)+V*SY(11,N)+W*SY(12,N),1.)-
     +  .5).GT.0.1)GOTO 72
  75    CONTINUE
      R=1./SQRT(CELL(7)*U**2+CELL(8)*V**2+CELL(9)*W**2+
     +CELL(10)*V*W+CELL(11)*U*W+CELL(12)*U*V)
      IF(R.GE.RE.AND.R.LE.RF)Q=Q+1.
      GOTO 72
  76  IF(NR.GT.0)GOTO 78
  77  WRITE(*,FMT)' Enter total number of reflections in range: '
      READ(*,*,ERR=77,END=77)NR
      IF(NR.LE.0)GOTO 77
  78  T=100.*REAL(NR)/Q
      WRITE(*,'(/A,F7.2,A,F8.2,A,F5.2)')' Completeness =',T,
     +' %  for',RF,' > d >',RE
      IF(T.GT.100.01)WRITE(*,'(A/A)')' A value above 100% indicates'
     +//' that MERG 4 was not used for SHELXL, or that',' an '//
     +'incorrect value has been entered for the highest resolution !'
      T=AMIN1(T,100.)
      WRITE(KD(26)(38:42),'(F5.1)')T
C
C Write start of PDB file for deposition
C
      WRITE(KD(47)(22:27),'(I6)')NP
      WRITE(KD(48)(22:27),'(I6)')NN
      WRITE(KD(49)(22:27),'(I6)')NH
      WRITE(KD(50)(22:27),'(I6)')NW
      IF(NR.LE.0)GOTO 79
      READ(KD(35)(45:52),*,ERR=79,END=79)N
      IF(N.LE.0)GOTO 79
      WRITE(KD(34)(45:52),'(F8.1)')100.*REAL(N)/REAL(NR)
  79  READ(KD(43)(45:52),*,ERR=80,END=80)N
      IF(N.LE.0)GOTO 80
      READ(KD(44)(45:52),*,ERR=80,END=80)L
      IF(L.LE.0)GOTO 80
      WRITE(KD(42)(45:52),'(F8.1)')100.*REAL(N)/REAL(L)
  80  N=0
        DO 81 I=1,JR
        N=N+ID(I)
  81    CONTINUE
      WRITE(KD(55)(47:50),'(I4)')N
      NA=0
        DO 83 I=1,16
        L=1
          DO 82 K=1,52
          IF(KD(I)(K:K).NE.' ')L=K
  82      CONTINUE
        WRITE(LS,'(A)')KD(I)(1:L)
  83    CONTINUE
C
C Find Matthews coefficient
C
      W=0.
        DO 84 I=1,JR
        IR(I)=1
        KZ=KN(I)(1:3)
        IF(KZ.EQ.'   '.OR.KZ.EQ.'HOH'.OR.KZ.EQ.'WAT'.
     +  OR.KZ.EQ.'H2O')IR(I)=0
  84    CONTINUE
        DO 90 I=1,JR
        IF(IR(I).EQ.0)GOTO 90
        KZ=KN(I)(1:3)
C ** TEMP
        NRES=0
C **
          DO 85 J=1,20
          IF(KZ.EQ.KG(J))GOTO 87
  85      CONTINUE
        T=0.
  86    WRITE(*,'(1X)')
        WRITE(*,FMT)' Formula weight of residue '//KZ//
     +  ' <CR> to leave out of mol. wt. sum: '
        KR=' '
        READ(*,'(A)',ERR=86,END=88)KR
        CALL LINTRM(KR,I)
        IF(I.EQ.0)GOTO 88
        READ(KR,*,ERR=86,END=88)T
        GOTO 88
  87    T=WK(J)
  88      DO 89 J=I,JR
          IF(IR(J).EQ.0)GOTO 89
          IF(KN(J)(1:3).NE.KZ)GOTO 89
          W=W+T
C ** TEMP
          NRES=NRES+1
C **
          IR(J)=0
  89      CONTINUE
C ** TEMP
        WRITE(*,'(1X,A,I5,F9.2)')KZ,NRES,T
C **
  90    CONTINUE
      IF(W.GT.0.01.AND.IZ.GT.0.AND.NS.GT.0)GOTO 91
      WRITE(*,'(/A)')' ** Cannot calculate Matthews coefficient **'
      GOTO 92
  91  U=VO/(W*REAL(NS))
      V=W*REAL(NS)/REAL(IZ)
      S=AMAX1(0.,100.-123./U)
      WRITE(*,'(2(/A,F9.1,A)/A,F7.2,A,F6.1,A)')
     +' Molecular weight of asymmetric unit =',W,' Daltons',
     +' Molecular weight of monomer =',V,' Daltons',
     +' Matthews coefficient =',U,'    Solvent content =',S,' %'
      WRITE(KD(128)(26:31),'(F6.1)')S
      WRITE(KD(129)(45:51),'(F7.2)')U
C
C Output remaining REMARK records
C
  92    DO 96 I=17,132
        L=1
          DO 93 K=1,52
          IF(KD(I)(K:K).NE.' ')L=K
  93      CONTINUE
        IF(I.NE.72)GOTO 94
        IF(JW.NE.1)GOTO 94
        WRITE(LS,'(A,A)')KQ,KD(72)(1:L-4)//
     +  'MOEWS & KRETSINGER, J.MOL.BIOL.91(1973)201-228'
        GOTO 96
  94    IF(I.NE.78)GOTO 95
        IF(JH.EQ.1)WRITE(LS,'(A,A)')KQ,'  ANISOTROPIC SCALING APP'//
     +  'LIED BY THE METHOD OF '
        IF(JH.EQ.1)WRITE(LS,'(A,A)')KQ,'  PARKIN, MOEZZI & HOPE,'
     +  //' J.APPL.CRYST.28(1995)53-56'
        IF(JA.EQ.1)WRITE(LS,'(A,A)')KQ,' ANISOTROPIC '//
     +  'REFINEMENT REDUCED FREE R (NO CUTOFF) BY ?'
        KQ(8:10)='200'
  95    WRITE(LS,'(A,A)')KQ,KD(I)(1:L)
        IF(I.EQ.125)KQ(9:9)='8'
  96    CONTINUE
C
C HET residues etc.
C
      K=0
      J=0
  97  J=J+1
      IF(J.GT.JR)GOTO 102
      IF(KN(J)(4:4).EQ.' ')GOTO 97
      L=16
      N=1
      M=J
  98  IF(KN(M)(4:4).EQ.'*')KN(M)(4:4)=' '
      IF(KN(M)(5:5).NE.' ')GOTO 100
      N=N+1
      M=M+1
      IF(M.LE.JR)GOTO 98
      GOTO 102
  99  J=J+1
 100  L=L+4
      KC=KN(J)(4:4)
      IF(L.LT.70)GOTO 101
      K=K+1
      WRITE(LS,'(A,I4,1X,A1,1X,I4,A)')'SEQRES',K,KC,N,KR(18:70)
      L=20
 101  KR(L:L+2)=KN(J)(1:3)
      IF(KN(J)(5:5).EQ.' ')GOTO 99
      K=K+1
      WRITE(LS,'(A,I4,1X,A1,1X,I4,A)')'SEQRES',K,KC,N,KR(18:L+2)
      GOTO 97
 102    DO 103 I=1,JR
        IF(KN(I)(6:6).NE.'H')GOTO 103
        IF(KN(I)(1:3).EQ.'HOH')GOTO 103
        WRITE(LS,'(A,4X,A,2X,A,I4,I8,5X,A)')
     +  'HET',KN(I)(1:3),KN(I)(4:4),IY(I),IX(I),'?'
 103    CONTINUE
        DO 104 I=1,JR
        IF(KN(I)(6:6).NE.'H')GOTO 104
        IF(KN(I)(1:3).EQ.'HOH')GOTO 104
        WRITE(LS,'(A,5X,A)')'HETNAM',KN(I)(1:3)//' ?'
 104    CONTINUE
      K=0
        DO 105 I=1,JR
        IF(KN(I)(6:6).NE.'H')GOTO 105
        IF(KN(I)(1:3).EQ.'HOH')GOTO 105
        K=K+1
        WRITE(LS,'(A,I4,2X,A,4X,A)')'FORMUL',K,KN(I)(1:3),'?'
 105    CONTINUE
C
C SSBOND records
C
      JS=0
        DO 107 I=1,MM
        IF(KA(I).NE.' SG ')GOTO 107
        K=IN(IM(I)+1)
        IF(KN(K)(1:3).NE.'CYS')GOTO 107
          DO 106 J=I+1,MM
          IF(KA(J).NE.' SG ')GOTO 106
          L=IN(IM(J)+1)
          IF(KN(L)(1:3).NE.'CYS')GOTO 106
          T=(XX(I)-XX(J))**2+(YY(I)-YY(J))**2+(ZZ(I)-ZZ(J))**2
          IF(T.GT.9.)GOTO 106
          JS=JS+1
          WRITE(LS,'(A,I4,A,I5,4X,A,I5)')'SSBOND',JS,' CYS '//
     +    KN(K)(4:4),IY(K),'CYS '//KN(L)(4:4),IY(L)
 106      CONTINUE
 107    CONTINUE
C
C LINK records
C
        DO 111 I=1,MM
        K=IN(IM(I)+1)
        IF(KN(K)(6:6).NE.'H')GOTO 111
        P=1.6
        IF(KA(I)(1:1).NE.' ')GOTO 108
        IF(KA(I)(2:2).EQ.'C'.OR.KA(I)(2:2).EQ.'N'.OR.KA(I)(2:2)
     +  .EQ.'O'.OR.KA(I)(2:2).EQ.'B'.OR.KA(I)(2:2).EQ.'F')P=1.2
 108      DO 110 J=1,MM
          L=IN(IM(J)+1)
          IF(L.EQ.K)GOTO 110
          IF(KN(L)(6:6).EQ.'H'.AND.J.LT.I)GOTO 110
          Q=P+1.1
          IF(KA(J)(1:1).NE.' ')GOTO 109
          IF(KA(J)(2:2).EQ.'C'.OR.KA(J)(2:2).EQ.'N'.OR.KA(J)(2:2)
     +    .EQ.'O'.OR.KA(J)(2:2).EQ.'B'.OR.KA(J)(2:2).EQ.'F')Q=P+0.7
 109      T=(XX(I)-XX(J))**2+(YY(I)-YY(J))**2+(ZZ(I)-ZZ(J))**2
          IF(T.GT.Q**2)GOTO 110
          WRITE(LS,'(A,8X,A,I4,16X,A,I4)')'LINK',KA(I)//' '//
     +    KN(K)(1:3)//' '//KN(K)(4:4),IY(K),KA(J)//' '//KN(L)(1:3)//
     +    ' '//KN(L)(4:4),IY(L)
 110      CONTINUE
 111    CONTINUE
C
C CISPEP records
C
      JJ=0
        DO 117 I=1,MM
        IF(KA(I).NE.' CA ')GOTO 117
        K=IN(IM(I)+1)
          DO 116 J=I+1,MM
          IF(KA(J).NE.' CA ')GOTO 116
          L=IN(IM(J)+1)
          IF(IY(L).NE.IY(K)+1)GOTO 116
          IF(KN(K)(4:4).NE.KN(L)(4:4))GOTO 116
          T=(XX(I)-XX(J))**2+(YY(I)-YY(J))**2+(ZZ(I)-ZZ(J))**2
          IF(T.GT.11.)GOTO 116
            DO 112 N=1,MM
            IF(KA(N).NE.' C  ')GOTO 112
            IF(IM(N).EQ.IM(I))GOTO 113
 112        CONTINUE
          GOTO 116
 113        DO 114 M=1,MM
            IF(KA(M).NE.' N  ')GOTO 114
            IF(IM(M).EQ.IM(J))GOTO 115
 114        CONTINUE
          GOTO 116
 115      X=XX(M)-XX(N)
          Y=YY(M)-YY(N)
          Z=ZZ(M)-ZZ(N)
          P=XX(I)-XX(N)
          Q=YY(I)-YY(N)
          R=ZZ(I)-ZZ(N)
          U=Y*R-Z*Q
          V=Z*P-X*R
          W=X*Q-Y*P
          P=XX(J)-XX(M)
          Q=YY(J)-YY(M)
          R=ZZ(J)-ZZ(M)
          S=Z*P-X*R
          T=X*Q-Y*P
          R=Y*R-Z*Q
          P=X*(V*T-W*S)+Y*(W*R-U*T)+Z*(U*S-V*R)
          Q=SQRT(X**2+Y**2+Z**2)*(U*R+V*S+W*T)
          IF(P**2+Q**2.LT.1.E-6)GOTO 116
          P=AMOD(720.+57.2958*ATAN2(P,Q),360.)
          JJ=JJ+1
          WRITE(LS,'(A,I4,A,I5,4X,A,I5,18X,F6.2)')'CISPEP',JJ,
     +    ' '//KN(K)(1:3)//' '//KN(K)(4:4),IY(K),
     +    KN(L)(1:3)//' '//KN(L)(4:4),IY(L),P
 116      CONTINUE
 117    CONTINUE
      WRITE(*,'(/2(I5,A))')JS,' SS-bonds and',JJ,' cis-peptides found'
C
C CRYST1/ORIGXn
C
      JS=-1
 118  KR=' '
      READ(LF,'(A)',ERR=118,END=133)KR
      IF(KR(1:4).EQ.'TER ')GOTO 118
      CALL LINTRM(KR,I)
      IF(KR(1:6).NE.'CRYST1')GOTO 122
      KR(56:66)=KSP(1:11)
      WRITE(KR(67:70),'(I4)')IZ
      L=1
        DO 119 K=1,80
        IF(KR(K:K).NE.' ')L=K
 119    CONTINUE
      WRITE(LS,'(A)')KR(1:L)
        DO 121 I=1,3
          DO 120 K=1,4
          D(K)=0.
 120      CONTINUE
        D(I)=1.
        WRITE(LS,'(A5,I1,4X,3F10.6,5X,F10.6)')'ORIGX',I,(D(K),K=1,4)
 121    CONTINUE
      GOTO 118
C
C Atom records
C
 122  IF(JS.LT.1)GOTO 124
      IF(KR(1:4).EQ.'CONN'.OR.KR(1:4).EQ.'MAST'.OR.KR(1:4).EQ.
     +'END ')GOTO 123
      IF(KR(1:4).NE.'ATOM'.AND.KR(1:4).NE.'HETA')GOTO 124
      READ(KR(23:26),'(I4)',ERR=37,END=37)J
      IF(J.EQ.JS)GOTO 124
 123  J=IN(JS+1)
      IF(KN(J)(5:5).EQ.' ')GOTO 124
      NA=NA+1
      WRITE(LS,'(A,3X,I5,6X,A,I4)')'TER',NA,KN(J)(1:3)//' '//
     +KN(J)(4:4),IY(J)
      JS=-1
 124  IF(KR(1:3).EQ.'END')GOTO 133
      IF(KR(1:4).NE.'ATOM'.AND.KR(1:6).NE.'HETATM'.AND.KR(1:3)
     +.NE.'SIG'.AND.KR(1:6).NE.'ANISOU')GOTO 128
      IF(KR(1:4).EQ.'ATOM'.AND.KR(14:20).EQ.'W   HOH')GOTO 118
      IF(KR(13:13).GE.'A'.AND.KR(13:13).LE.'Z')GOTO 125
      IF(KR(14:14).NE.'H')GOTO 125
      IF(IH.LT.0)GOTO 118
      IF(IH.GT.0)GOTO 125
      WRITE(*,'(1X)')
      WRITE(*,FMT)' Do you really want to include hydrogens '//
     +'(with non-standard names) ? [N]: '
      IH=-1
      KT=' '
      READ(*,'(A)',ERR=125,END=125)KT
      IF(INDEX(KT,'Y')+INDEX(KT,'y').GT.0)IH=1
      IF(IH.LT.0)GOTO 118
 125  READ(KR(23:26),'(I4)',ERR=37,END=37)JS
      J=IN(JS+1)
      IF(KN(J)(5:5).EQ.' ')GOTO 126
      IF(KR(13:16).EQ.' OT1')KR(15:16)='  '
      IF(KR(13:16).EQ.' OT2'.OR.KR(13:16).EQ.' OT ')KR(15:16)='XT'
 126  IF(KR(1:3).EQ.'SIG'.OR.KR(1:6).EQ.'ANISOU')GOTO 127
      READ(KR(55:60),'(F6.2)',ERR=37,END=37)T
      WRITE(KR(55:60),'(F6.2)')T
      NA=NA+1
      IF(KN(J)(6:6).EQ.'H')KR(1:6)='HETATM'
 127  WRITE(KR(7:11),'(I5)')NA
      KR(77:78)=KR(13:14)
      IF(KR(77:77).GE.'0'.AND.KR(77:77).LE.'9')KR(77:77)=' '
      KR(22:22)=KN(J)(4:4)
      WRITE(KR(23:26),'(I4)')IY(J)
      GOTO 129
 128  JS=-1
 129  L=1
        DO 130 K=1,80
        IF(KR(K:K).NE.' ')L=K
 130    CONTINUE
      WRITE(LS,'(A)')KR(1:L)
      GOTO 118
C
C Tidy up
C
 131  WRITE(*,'(/A/)')' ** Cannot open file '//KR(1:L)//' **'
      GOTO 134
 132  FORMAT(/' File created for deposition in Brookhaven.  You will',
     +' need to edit the'/' HEADER, TITLE, SOURCE, KEYWDS, AUTHOR, ',
     +'REVDAT, JRNL, DBREF, HET, HETNAM'/' and FORMUL records (if ',
     +'any) and the REFINEMENT and EXPERIMENTAL sections.')
 133  WRITE(LS,'(A)')'END'
      WRITE(*,132)
 134  CLOSE(LM,IOSTAT=I)
      CLOSE(LS,IOSTAT=I)
      RETURN
      END
C
C -------------------------------------------------------------------
C
      SUBROUTINE WATPRO(R,RF,WS,WX)
C
C Read SHELXL .res file including REM records with R-indices during
C the refinement and prepare Postscript plots of refinement progress
C
      COMMON/XTAL/SY(12,192),CELL(15),II(1369),NS,LAT,LU,LN,
     +LO,LP,LF,LM,LS,NOS,IER,NPG
      COMMON/WORD/KF,KR,KD,KE,KA,KB,KN,FMT,COL,OPT
      CHARACTER KF*80,KR*80,KD(462)*52,KA(50000)*4,KE(9999)*4,
     +KB(250)*80,KN(10000)*9,FMT*20,COL*4,OPT*1
      REAL R(9999),RF(9999),WS(9999),WX(9999)
C
C Type of plot
C
   1  WRITE(*,FMT)' Use R values for F>4sigma(F) (F) or all data'
     +//' (A) [F]: '
      KR=' '
      READ(*,25,ERR=1,END=1)KR
      NA=0
      IF(INDEX(KR,'A')+INDEX(KR,'a').GT.0)NA=1
C
C Set up .res file for reading
C
      KF(LN+1:LN+4)='.res'
   2  WRITE(*,FMT)' Name of .res file created using SHELXL ['
     +//KF(1:LN+4)//']: '
      KR=' '
      READ(*,25,ERR=2,END=2)KR
      CALL LINTRM(KR,N)
      L=0
      M=0
        DO 3 I=1,N
        IF(KR(I:I).EQ.'.')M=I
        IF(KR(I:I).EQ.' ')GOTO 3
        L=L+1
        KR(L:L)=KR(I:I)
   3    CONTINUE
      IF(M.NE.0)GOTO 5
      IF(L.NE.0)GOTO 4
      KR=KF
      L=LN
   4  L=L+4
      KR(L-3:L)='.res'
   5  OPEN(LF,FILE=KR(1:L),STATUS='OLD',ERR=33)
C
C Extract appropriate R-indices from remarks in .res file
C
      NW=0
      XX=1.
      NC=0
   6  KR=' '
      READ(LF,25,ERR=6,END=10)KR
      CALL LINTRM(KR,I)
   7  IF(KR(1:6).NE.'REM R1')GOTO 6
      I=INDEX(KR,'=')
      IF(NA.NE.0)I=INDEX(KR(I+1:80),'and')+I+2
      READ(KR(I+1:I+8),*,ERR=33,END=33)S
      NC=NC+1
      R(NC)=-1.
      RF(NC)=-1.
      WS(NC)=-1.
      WX(NC)=1.
      IF(INDEX(KR,'Free').EQ.0)GOTO 8
      RF(NC)=S
      KR=' '
      READ(LF,25,ERR=33,END=33)KR
      CALL LINTRM(KR,I)
      IF(KR(1:6).NE.'REM R1')GOTO 33
      I=INDEX(KR,'=')
      IF(NA.NE.0)I=INDEX(KR(I+1:80),'and')+I+2
      READ(KR(I+1:I+8),*,ERR=33,END=33)S
   8  R(NC)=S
      KR=' '
      READ(LF,25,ERR=33,END=33)KR
      CALL LINTRM(KR,I)
      IF(INDEX(KR,'Iteration').NE.0)GOTO 9
      XX=1.
      GOTO 7
   9  I=INDEX(KR,'full')
      IF(I.LT.8)GOTO 33
      READ(KR(I-6:I-2),*,ERR=33,END=33)M
      I=INDEX(KR,'half')
      IF(I.LT.8)GOTO 33
      READ(KR(I-6:I-2),*,ERR=33,END=33)N
      WS(NC)=REAL(M)+0.5*REAL(N)
      WX(NC)=XX
      XX=0.4
      NW=1
      GOTO 6
C
C Titles and scale for diagram
C
  10  IF(NC.LT.2)GOTO 33
      NPG=NPG+1
      WRITE(LP,26)NPG,NPG
      WRITE(LP,25)'C7 3 W 110 330 490 710 B C0 1 W'
      WRITE(LP,25)'(Refinement progress) 20 300 740 P'
      WRITE(LP,25)'(Run number) 15 300 290 P'
      P=999.
      Q=0.
      WW=0.
      XX=-1.
        DO 12 I=1,NC
        XX=XX+WX(I)
        IF(R(I).LT.0.)GOTO 11
        IF(R(I).LT.P)P=R(I)
        IF(R(I).GT.Q)Q=R(I)
  11    IF(WW.LT.WS(I))WW=WS(I)
        IF(RF(I).LT.0.)GOTO 12
        IF(RF(I).LT.P)P=RF(I)
        IF(RF(I).GT.Q)Q=RF(I)
  12    CONTINUE
      P=AMAX1(0.,P-0.05)
      Q=AMAX1(0.,Q+0.05)
      XX=340./XX
      W=130.-XX
      N=1
        DO 14 I=1,NC
        W=W+XX*WX(I)
        IF(I.EQ.1.OR.I.EQ.NC)GOTO 13
        IF(WX(I+1).LT.0.7)GOTO 14
  13    N=N+1
        WRITE(KR,'(I5)')N
        J=5
        IF(I.GT.9)J=4
        IF(I.GT.99)J=3
        WRITE(LP,27)KR(J:5),W,W,W
  14    CONTINUE
C
C R-indices
C
      KR(1:8)='C1 (R1 ['
      IF(COL(2:2).EQ.'f')KR(2:2)='0'
      IF(NA.NE.0)WRITE(LP,25)KR(1:8)//'all data]) 15 65 520 Q'
      IF(NA.EQ.0)WRITE(LP,25)KR(1:8)//'F>4sigma(F)]) 15 65 520 Q'
        DO 15 I=1,19
        T=0.05*REAL(I)
        S=330.+380.*(T-P)/(Q-P)
        IF(S.LT.335.)GOTO 15
        IF(S.GT.705.)GOTO 15
        WRITE(KR,'(F4.2)')T
        IF(KR(1:1).EQ.' ')KR(1:1)='0'
        WRITE(LP,28)KR(1:4),S,S,S
  15    CONTINUE
      J=0
      W=130.-XX
        DO 17 I=1,NC
        W=W+XX*WX(I)
        IF(R(I).LT.0.)GOTO 16
        S=330.+380.*(R(I)-P)/(Q-P)
        IF(J.GT.0)WRITE(LP,31)U,V,W,S
        WRITE(LP,30)W,S
        U=W
        V=S
        J=1
        GOTO 17
  16    J=0
  17    CONTINUE
      IF(COL(2:2).NE.'f')WRITE(LP,25)'C6'
      J=0
      W=130.-XX
        DO 19 I=1,NC
        W=W+XX*WX(I)
        IF(RF(I).LT.0.)GOTO 18
        S=330.+380.*(RF(I)-P)/(Q-P)
        IF(J.GT.0)WRITE(LP,31)U,V,W,S
        WRITE(LP,30)W,S
        U=W
        V=S
        J=1
        GOTO 19
  18    J=0
  19    CONTINUE
C
C Number of water molecules
C
      IF(NW.EQ.0)GOTO 24
  20  WRITE(*,FMT)' Plot number of water molecules as well as R'//
     +'-index ? [N]: '
      KR=' '
      READ(*,25,ERR=20,END=20)KR
      IF(INDEX(KR,'Y')+INDEX(KR,'y').EQ.0)GOTO 24
      KR='C2 (Number of water molecules) 15 535 520 Q 1 W'
      IF(COL(2:2).EQ.'f')KR(2:2)='0'
      WRITE(LP,25)KR(1:47)
      J=2
      N=INT(WW+.5)
      IF(N.GT.15)J=4
      IF(N.GT.39)J=10
      IF(N.GT.79)J=20
      IF(N.GT.159)J=40
      IF(N.GT.399)J=100
      IF(N.GT.799)J=200
      IF(N.GT.1599)J=400
        DO 21 I=0,N+J,J
        S=350.+340.*REAL(I)/WW
        IF(S.GT.705.)GOTO 21
        WRITE(KR,'(I6)')I
        K=6
        IF(I.GT.9)K=5
        IF(I.GT.99)K=4
        IF(I.GT.999)K=3
        IF(I.GT.9999)K=2
        WRITE(LP,29)KR(K:6),S,S,S
  21    CONTINUE
      J=0
      W=130.-XX
        DO 23 I=1,NC
        W=W+XX*WX(I)
        IF(WS(I).LT.0.)GOTO 22
        S=350.+340.*WS(I)/WW
        IF(J.GT.0)WRITE(LP,31)U,V,W,S
        WRITE(LP,30)W,S
        U=W
        V=S
        J=1
        GOTO 23
  22    J=0
  23    CONTINUE
  24  WRITE(LP,32)
      GOTO 34
C
C Formats and finish off
C
  25  FORMAT(A)
  26  FORMAT(/'%%Page:',2I5/'/XSave save def')
  27  FORMAT('(',A,') 12',F7.2,' 315 P',F7.2,' 325',F7.2,' 329 L')
  28  FORMAT('(',A,') 12 92',F7.2,' P',' 105',F7.2,' 109',F7.2,' L')
  29  FORMAT('(',A,') 12 508',F7.2,' P',' 491',F7.2,' 495',F7.2,' L')
  30  FORMAT(2F7.2,' E')
  31  FORMAT('2 W',4F7.2,' L 1 W')
  32  FORMAT('showpage XSave restore')
  33  WRITE(*,'(/A)')' ** Bad .res file format or cannot open file **'
  34  RETURN
      END
C
C -------------------------------------------------------------------
C
      SUBROUTINE INSLIN(A,NA,KK,KQ)
C
C Decode one line of an .ins file, taking comments and continuation
C lines into account.  Only atoms and certain types of instruction
C (usually found in the atom list) are permitted.
C
      COMMON/XTAL/SY(12,192),CELL(15),II(1369),NS,LAT,LU,LN,
     +LO,LP,LF,LM,LS,NOS,IER,NPG
      COMMON/WORD/KF,KR,KD,KE,KA,KB,KN,FMT,COL,OPT
      CHARACTER KF*80,KR*80,KD(462)*52,KA(50000)*4,KE(9999)*4,KQ*4,
     +KB(250)*80,KN(10000)*9,FMT*20,COL*4,OPT*1,KK*4,KT*20,KX*12
      REAL A(512)
C
      IER=0
      KX='0123456789.-'
        DO 1 I=1,80
        IF(KR(I:I).LT.' ')KR(I:I)=' '
   1    CONTINUE
      KQ=KR(1:4)
        DO 2 I=1,4
        IF(KQ(I:I).GE.'a'.AND.KQ(I:I).LE.'z')KQ(I:I)=CHAR
     +  (ICHAR(KQ(I:I))-32)
   2    CONTINUE
      NA=0
      KK=' '
      IF(KQ.EQ.'REM ')GOTO 11
   3  L=80
      I=INDEX(KR,'!')
      IF(I.GT.0)L=I-1
      J=INDEX(KR(1:L),'=')
      IF(J.GT.0)L=J-1
      K=4
   4  K=K+1
      IF(K.GT.L)GOTO 9
      IF(KR(K:K).EQ.' ')GOTO 4
      IF(KR(K:K).EQ.',')GOTO 4
      IF(INDEX(KX,KR(K:K)).NE.0)GOTO 5
      M=MIN0(3,L-K)
      I=INDEX(KR(K:L),' ')-2
      IF(I.GE.0.AND.I.LT.M)M=I
      I=INDEX(KR(K:L),',')-2
      IF(I.GE.0.AND.I.LT.M)M=I
      KK=KR(K:K+M)
      K=K+M
      GOTO 4
   5  M=K
      KT(1:1)=KR(K:K)
   6  M=M+1
      IF(M.GT.L)GOTO 7
      I=INDEX(KX,KR(M:M))
      IF(I.EQ.0)GOTO 7
      IF(I.EQ.12)GOTO 7
      I=M-K+1
      KT(I:I)=KR(M:M)
      GOTO 6
   7  I=M-K
      IF(INDEX(KT(1:I),'.').NE.0)GOTO 8
      I=I+1
      KT(I:I)='.'
   8  I=I+1
      KT(I:I)=' '
      K=M-1
      IF(KT(1:3).EQ.'-. '.OR.KT(1:3).EQ.'+. ')GOTO 4
      NA=NA+1
      READ(KT(1:I),*,ERR=10,END=10)A(NA)
      GOTO 4
   9  IF(J.EQ.0)GOTO 11
      KR=' '
      READ(LF,'(A)',ERR=10,END=10)KR
      GOTO 3
  10  IER=1
  11  RETURN
      END
C
C -------------------------------------------------------------------
C
      SUBROUTINE OTOINS(MX,X,Y,Z,OC,UI,DD,FV,NV,IS,IR,IP,IA,IL,UA,A)
C
C Read SHELXL .res file and convert to an .ins file for input to the
C next job, taking updated atom coordinates from one or more PDB
C format files written by the program O.  The .res file may not
C contain instructions other than RESI, AFIX, PART and atoms between
C the FVAR and HKLF instructions.  The rest of the .res file is
C copied unchanged.
C
      COMMON/XTAL/SY(12,192),CELL(15),II(1369),NS,LAT,LU,LN,
     +LO,LP,LF,LM,LS,NOS,IER,NPG
      COMMON/WORD/KF,KR,KD,KE,KA,KB,KN,FMT,COL,OPT
      CHARACTER KF*80,KR*80,KD(462)*52,KA(50000)*4,KE(9999)*4,KS*80,
     +KB(250)*80,KN(10000)*9,FMT*20,COL*4,OPT*1,KT*80,KQ*4,KK*4,KG*9,
     +KP*1,KC(99)*2
      REAL A(512),X(MX),Y(MX),Z(MX),OC(MX),UI(MX),DD(MX),FV(MX)
      REAL UA(MX,6),C(6),G(3)
      INTEGER IS(MX),IR(MX),IP(MX),IA(MX),IL(MX),NV(MX),IC(12),IG(12)
C
C Set up .ins and .res files
C
      KF(LN+1:LN+4)='.res'
   1  WRITE(*,FMT)' Name of .res (or .ins) file to read ['
     +//KF(1:LN+4)//']: '
      KR=' '
      READ(*,'(A)',ERR=1,END=1)KR
      CALL LINTRM(KR,N)
      L=0
        DO 2 I=1,N
        IF(KR(I:I).EQ.' ')GOTO 2
        L=L+1
        KR(L:L)=KR(I:I)
   2    CONTINUE
      IF(L.GT.0)GOTO 3
      KR=KF
      L=LN+4
      GOTO 4
   3  IF(INDEX(KR(1:L),'.').NE.0)GOTO 4
      L=L+4
      KR(L-3:L)='.res'
   4  OPEN(UNIT=LF,FILE=KR(1:L),STATUS='OLD',ERR=264)
      OPEN(UNIT=LM,STATUS='SCRATCH',FORM='UNFORMATTED',ERR=264)
C
C Copy this file to scratch file saving CELL and coefficients for
C calculating Ueq, until first FVAR, RESI or PART instruction.
C
      CELL(1)=-1.
      LAT=1
      NS=1
        DO 5 I=1,12
        SY(I,1)=0.
   5    CONTINUE
        DO 6 I=1,9,4
        SY(I,1)=1.
   6    CONTINUE
      NR=0
      NL=-10000
      NP=0
      PS=-9.E9
      NM=0
      AD=-9.E9
      AS=-9.E9
      AU=-9.E9
      NX=0
      NF=0
      NW=10000
      NZ=0
      NU=0
      SL=-9.E9
        DO 7 I=1,MX
        NV(I)=0
   7    CONTINUE
        DO 8 I=1,9999
        KE(I)='    '
   8    CONTINUE
   9  KR=' '
      READ(LF,'(A)',ERR=9,END=270)KR
      CALL LINTRM(KR,I)
      CALL INSLIN(A,NA,KK,KQ)
      IF(IER.NE.0)GOTO 270
        DO 10 I=1,4
        IF(KQ(I:I).GE.'a'.AND.KQ(I:I).LE.'z')KQ(I:I)=CHAR
     +  (ICHAR(KQ(I:I))-32)
  10    CONTINUE
      IF(KQ.NE.'SFAC')GOTO 12
      WRITE(LM)NR,KR
      I=4
  11  I=I+1
      IF(I.GT.79)GOTO 9
      IF(KR(I:I).LT.'A'.OR.KR(I:I).GT.'Z')GOTO 11
      NU=NU+1
      J=I
      IF(KR(I+1:I+1).EQ.' ')J=I-1
      KC(NU)=KR(J:J+1)
      IF(NA.GT.0)GOTO 9
      I=I+1
      GOTO 11
  12  IF(KQ.EQ.'FVAR')GOTO 43
      IF(KQ.EQ.'RESI')GOTO 43
      IF(KQ.EQ.'PART')GOTO 43
      IF(KQ.NE.'DFIX'.AND.KQ.NE.'CHIV'.AND.KQ.NE.'DANG')GOTO 13
      I=INT(0.1*ABS(A(1))+0.5)
      IF(I.GT.0.AND.I.LE.MX)NV(I)=1
  13  WRITE(LM)NR,KR
      IF(KQ.NE.'CELL')GOTO 16
      IF(NA.NE.7)GOTO 270
        DO 14 I=1,6
        CELL(I)=A(I+1)
        IF(CELL(I).LT.0.1)GOTO 270
        C(I)=CELL(I)**2
  14    CONTINUE
        DO 15 I=4,6
        Q=1.74533E-2*CELL(I)
        A(I-3)=SIN(Q)
        A(I)=COS(Q)
        C(I)=2.*CELL(1)*CELL(2)*CELL(3)*A(I)/CELL(I-3)
  15    CONTINUE
      Q=1./(3.+6.*A(4)*A(5)*A(6)-3.*(A(4)**2+A(5)**2+A(6)**2))
      CELL(7)=Q*A(1)**2
      CELL(8)=Q*A(2)**2
      CELL(9)=Q*A(3)**2
      CELL(10)=2.*Q*A(2)*A(3)*A(4)
      CELL(11)=2.*Q*A(3)*A(1)*A(5)
      CELL(12)=2.*Q*A(1)*A(2)*A(6)
      Q=SQRT(3.*Q)
      G(1)=Q*A(1)/CELL(1)
      G(2)=Q*A(2)/CELL(2)
      G(3)=Q*A(3)/CELL(3)
      GOTO 9
C
C Extract symmetry information
C
  16  IF(KQ.NE.'LATT')GOTO 18
      IF(NS.GT.1)GOTO 263
      LAT=INT(A(1))
        DO 17 I=1,12
        A(I)=SY(I,1)
  17    CONTINUE
      NS=0
      GOTO 35
  18  IF(KQ.NE.'SYMM')GOTO 9
      Q=9.E9
        DO 19 I=1,12
        A(I)=0.
  19    CONTINUE
      M=1
      N=10
      I=4
  20  J=0
      KT=' '
  21  I=I+1
      IF(I.GT.76)GOTO 24
      KP=KR(I:I)
      IF(KP.EQ.' ')GOTO 21
      IF(KP.EQ.'!')GOTO 34
      IF(J.EQ.0.AND.KP.EQ.'-')GOTO 23
      IF(KP.EQ.'.')GOTO 23
      IF(KP.GE.'0'.AND.KP.LE.'9')GOTO 23
      P=1.
      IF(J.GT.1)GOTO 25
      IF(J.EQ.0)GOTO 28
      IF(KT(:1).NE.'-')GOTO 25
      P=-1.
      GOTO 28
  22  J=0
      KT=' '
  23  IF(J.GT.19)GOTO 21
      J=J+1
      KT(J:J)=KP
      GOTO 21
  24  IF(J.EQ.0)GOTO 34
  25    DO 26 L=J+1,12
        KT(L:L)='0'
  26    CONTINUE
      IF(INDEX(KT(1:J),'.').EQ.0)KT(J+1:J+1)='.'
      READ(KT,'(F20.0)',END=263,ERR=263)P
      IF(Q.LT.8.E9)GOTO 27
      IF(KP.NE.'/')GOTO 28
      Q=P
      GOTO 20
  27  IF(ABS(P).LT.0.1)GOTO 263
      P=Q/P
      Q=9.E9
  28  IF(KP.NE.'X')GOTO 29
      IF(A(M).NE.0.)GOTO 263
      A(M)=P
      GOTO 32
  29  IF(KP.NE.'Y')GOTO 30
      IF(A(M+1).NE.0.)GOTO 263
      A(M+1)=P
      GOTO 32
  30  IF(KP.NE.'Z')GOTO 31
      IF(A(M+2).NE.0.)GOTO 263
      A(M+2)=P
      GOTO 32
  31  IF(J.EQ.0)GOTO 33
      IF(A(N).NE.0.)GOTO 263
      A(N)=P
  32  IF(KP.EQ.'-')GOTO 22
  33  IF(KP.NE.',')GOTO 20
      N=N+1
      M=M+3
      IF(M.LT.8)GOTO 20
  34  IF(ABS(1.-ABS(A(1)*(A(5)*A(9)-A(6)*A(8))+A(2)*(A(6)*A(7)-
     +A(4)*A(9))+A(3)*(A(4)*A(8)-A(5)*A(7)))).GT.0.01)GOTO 263
  35    DO 36 I=14,24
        A(I)=0.5
  36    CONTINUE
      A(13)=0.
      A(17)=0.
      A(21)=0.
      N=IABS(LAT)
      IF(N.EQ.5)A(14)=0.
      IF(N.EQ.6)A(18)=0.
      IF(N.EQ.7)A(22)=0.
      IF(N.GT.4)N=2
      IF(N.NE.4)GOTO 37
      A(14)=0.
      A(19)=0.
      A(24)=0.
  37  IF(N.NE.3)GOTO 38
      A(14)=.6666667
      A(18)=.3333333
      A(22)=.3333333
      A(15)=.3333333
      A(19)=.6666667
      A(23)=.6666667
  38  M=1
      IF(LAT.GT.0)M=2
      P=1.
        DO 41 I=1,M
          DO 40 J=1,N
          NS=NS+1
            DO 39 K=1,9
            SY(K,NS)=P*A(K)
  39        CONTINUE
          SY(10,NS)=A(J+12)+P*A(10)
          SY(11,NS)=A(J+16)+P*A(11)
          SY(12,NS)=A(J+20)+P*A(12)
  40      CONTINUE
        P=-1.
  41    CONTINUE
      GOTO 9
C
C Interpret and store atoms, RESI, PART and AFIX
C
  42  KR=' '
      READ(LF,'(A)',ERR=42,END=58)KR
      GOTO 44
  43  IF(CELL(1).LT.0.)GOTO 270
  44  CALL INSLIN(A,NA,KK,KQ)
      IF(IER.NE.0)GOTO 270
      IF(KQ.NE.'REM ')GOTO 45
      WRITE(LM)NR,KR
      GOTO 42
  45  IF(KQ.NE.'FVAR')GOTO 47
        DO 46 I=1,NA
        NF=NF+1
        FV(NF)=A(I)
  46    CONTINUE
      GOTO 42
  47  IF(KQ.NE.'RESI')GOTO 48
      NR=0
      NL=-9999
      IF(NA.LT.1)GOTO 42
      NR=INT(ABS(A(1))*1.00001)
      IF(NR.GT.9999)GOTO 270
      IF(NR.EQ.0)GOTO 42
      NZ=MAX0(NZ,NR)
      IF(KK.EQ.'HOH '.OR.KK.EQ.'H2O '.OR.KK.EQ.'WAT ')NW=MIN0(NW,NR)
      KE(NR)=KK
      IF(NA.GT.1)NL=INT(ABS(A(2))*1.00001)
      IF(NL.GT.9999)GOTO 270
      GOTO 42
  48  IF(KQ.NE.'PART')GOTO 49
      NP=0
      PS=-9.E9
      IF(NA.GT.0)NP=INT(A(1)*1.00001)
      IF(NA.GT.2)PS=A(2)
      GOTO 42
  49  IF(KQ.NE.'AFIX')GOTO 50
      NM=0
      AD=-9.E9
      AS=-9.E9
      AU=-9.E9
      IF(NA.GT.0)NM=INT(A(1)*1.00001)
      IF(NA.GT.1)AD=A(2)
      IF(NA.GT.2)AS=A(3)
      IF(NA.GT.3)AU=A(4)
      GOTO 42
  50  IF(KQ.EQ.'    ')GOTO 42
      IF(KQ.EQ.'HKLF')GOTO 59
      IF(KQ.EQ.'SADI'.OR.KQ.EQ.'SAME'.OR.KQ.EQ.'DFIX'.OR.KQ.EQ.
     +'DANG'.OR.KQ.EQ.'FLAT'.OR.KQ.EQ.'ANIS'.OR.KQ.EQ.'SUMP'.OR.
     +KQ.EQ.'EADP'.OR.KQ.EQ.'EXYZ'.OR.KQ.EQ.'CHIV'.OR.KQ.EQ.'RTAB'
     +.OR.KQ.EQ.'HTAB'.OR.KQ.EQ.'DELU'.OR.KQ.EQ.'SIMU')GOTO 265
      IF(NA.GT.5.AND.NA.LT.11)NA=6
        DO 51 I=2,NA
        J=INT(0.1*ABS(A(I))+0.5)
        IF(J.LT.2)GOTO 51
        IF(J.GT.NF)GOTO 267
        IF(J.LE.MX)NV(J)=1
  51    CONTINUE
      NX=NX+1
      IF(NX.GT.MX)GOTO 266
      IF(NX.GT.50000)GOTO 266
      KA(NX)=KQ
      UA(NX,1)=-9.E9
      IF(NA.NE.11)GOTO 54
      UI(NX)=0.
        DO 53 I=1,6
        T=A(I+5)
        UA(NX,I)=T
        J=INT(0.1*ABS(T)+0.5)
        IF(J.EQ.0)GOTO 52
        Q=SIGN(0.5,T+5.)
        R=AMOD(T+5.,10.)-10.*Q
        T=1.
        IF(J.GT.1)T=FV(J)
        T=R*(Q+T-0.5)
  52    UI(NX)=UI(NX)+T*CELL(I+6)
  53    CONTINUE
      GOTO 57
  54  IF(NA.NE.4)GOTO 55
      NA=5
      A(5)=11.
  55  IF(NA.NE.5)GOTO 56
      NA=6
      A(6)=0.2
  56  J=0
      IF(NA.NE.6)GOTO 267
      IF(AU.GT.-8.E9)A(6)=AU
      UI(NX)=A(6)
  57  IF(AS.GT.-8.E9)A(5)=AS
      IF(PS.GT.-8.E9)A(5)=PS
      OC(NX)=A(5)
      X(NX)=A(2)
      Y(NX)=A(3)
      Z(NX)=A(4)
      IS(NX)=INT(A(1)*1.00001)
      IR(NX)=NR
      IP(NX)=NP
      IA(NX)=NM
      IL(NX)=NL
      DD(NX)=AD
      GOTO 42
C
C On reaching HKLF, copy HKLF and REM's and save peaklist
C
  58  KS='HKLF 4'
      GOTO 63
  59  NN=NX
      KS=KR
  60  KT=' '
      READ(LF,'(A)',ERR=60,END=63)KR
      CALL LINTRM(KR,I)
        DO 61 I=1,4
        IF(KR(I:I).GE.'a'.AND.KR(I:I).LE.'z')KR(I:I)=CHAR
     +  (ICHAR(KR(I:I))-32)
  61    CONTINUE
      IF(KR(1:4).NE.'REM ')GOTO 62
      WRITE(LM)NR,KR
      IF(INDEX(KR,'deepest').EQ.0)GOTO 62
      I=INDEX(KR,'level')
      IF(I.NE.0)READ(KR(I+5:I+11),*,ERR=62,END=62)Q
      SL=Q
  62  IF(KR(1:1).NE.'Q'.OR.KR(2:2).GT.'9')GOTO 60
      CALL INSLIN(A,NA,KK,KQ)
      IF(IER.NE.0)GOTO 270
      NX=NX+1
      IF(NX.GT.MX)GOTO 266
      IF(NX.GT.50000)GOTO 266
      KA(NX)='O   '
      UA(NX,1)=-9.E9
      X(NX)=A(2)
      Y(NX)=A(3)
      Z(NX)=A(4)
      OC(NX)=A(5)
      UA(NX,2)=A(7)
      IS(NX)=4
      IR(NX)=-1
      IP(NX)=0
      IA(NX)=0
      IL(NX)=-9999
      DD(NX)=-9.E9
      GOTO 60
  63  KT='HKLF'
      I=99999
      WRITE(LM)I,KT
      WRITE(LM)I,KS
      REWIND LM
      CLOSE(LF,IOSTAT=I)
      IF(NF.GT.0)GOTO 65
      NF=1
      FV(1)=1.
C
C Replace ALL atoms ?
C
  65  WRITE(*,'(/I6,A,I5,A)')NN,' atoms and',NX-NN,' peaks read'
      WRITE(*,'(/5(A/))')' There are now two alternative approaches'
     +//' to updating the atom list.  If a',' graphics program such'
     +//' as XtalView that understands disorder and anisotropy',
     +' has been used to prepare a PDB format file, ALL atoms may '
     +//'be taken from',' this file.  With other graphics programs'
     +//' such as O it is better to start',' with atoms from '//
     +'a .res file and update individual residues interactively.'
      WRITE(*,FMT)' Replace ALL atoms and peaks with atoms from'
     +//' a PDB file (Y/N)? [Y]: '
      KR=' '
      READ(*,'(A)',ERR=65,END=86)KR
      IF(INDEX(KR,'N')+INDEX(KR,'n').NE.0)GOTO 86
C
C Prepare list of occupancy factors to be transferred to new atoms
C
      NG=0
        DO 67 I=1,NN
        IF(IP(I).EQ.0)GOTO 67
        J=NINT(ABS(0.1*OC(I)))
        IF(J.LT.2)GOTO 67
        IF(J.GT.4999)GOTO 67
        IF(OC(I).LT.0.)J=10000-J
        K=IABS(IP(I))
        IF(K.GT.26)GOTO 67
        IF(IR(I).GT.9999)GOTO 67
        WRITE(KG,'(2I4,A1)')J,IR(I),CHAR(K+64)
          DO 66 J=1,NG
          IF(KG.EQ.KN(J))GOTO 67
  66      CONTINUE
        IF(NG.GT.9999)GOTO 67
        NG=NG+1
        KN(NG)=KG
  67    CONTINUE
C
C Open PDB file and extract coordinate conversion matrix
C
      KF(LN+1:LN+4)='.pdb'
      WRITE(*,FMT)' Name of PDB file to read ['//KF(1:LN+4)//']: '
      KR=' '
      READ(*,'(A)',ERR=85,END=85)KR
      CALL LINTRM(KR,N)
      L=0
        DO 68 I=1,N
        IF(KR(I:I).EQ.' ')GOTO 68
        L=L+1
        KR(L:L)=KR(I:I)
  68    CONTINUE
      IF(L.GT.0)GOTO 69
      KR=KF
      L=LN+4
      GOTO 70
  69  IF(INDEX(KR,'.').NE.0)GOTO 70
      L=L+4
      KR(L-3:L)='.pdb'
  70  OPEN(UNIT=LF,FILE=KR(1:L),STATUS='OLD',ERR=85)
  71  READ(LF,'(A)',ERR=71,END=85)KR
      CALL LINTRM(KR,I)
      IF(KR(1:5).NE.'SCALE')GOTO 71
      READ(KR(6:6),'(I1)')I
      M=I*4
      READ(KR(11:55),'(3F10.6,5X,F10.6)')(A(I),I=M-3,M)
      IF(M.NE.12)GOTO 71
C
C Move peaks temporarily to end of the atom list
C
      NP=MX+1
        DO 73 I=NN+1,NX
        NP=NP-1
        IS(NP)=IS(I)
        X(NP)=X(I)
        Y(NP)=Y(I)
        Z(NP)=Z(I)
        OC(NP)=OC(I)
        IR(NP)=IR(I)
        IP(NP)=IP(I)
        IA(NP)=IA(I)
        IL(NP)=IL(I)
        DD(NP)=DD(I)
        UI(NP)=UI(I)
          DO 72 J=1,6
          UA(NP,J)=UA(I,J)
  72      CONTINUE
  73    CONTINUE
C
C Replace atoms in current list with atoms from PDB file
C
      NN=0
  74  KR=' '
      READ(LF,'(A)',ERR=74,END=82)KR
      CALL LINTRM(KR,I)
      IF(KR(1:6).NE.'ANISOU')GOTO 76
      IF(NN.EQ.0)GOTO 85
      READ(KR,'(28X,6F7.0)')(A(I),I=13,18)
        DO 75 I=1,3
        J=4*MOD(I,3)+1
        K=4*MOD(I+1,3)+1
        L=4*I-3
        UA(NN,I)=0.0001*(A(13)*A(L)**2+A(14)*A(L+1)**2+A(15)*A(L+2)**2
     +  +2.*(A(16)*A(L)*A(L+1)+A(17)*A(L)*A(L+2)+A(18)*A(L+1)*A(L+2)))
     +  /G(I)**2
        UA(NN,I+3)=0.0001*(A(13)*A(J)*A(K)+A(14)*A(J+1)*A(K+1)+A(15)*
     +  A(J+2)*A(K+2)+A(16)*(A(J)*A(K+1)+A(J+1)*A(K))+A(17)*(A(J)*
     +  A(K+2)+A(J+2)*A(K))+A(18)*(A(J+1)*A(K+2)+A(J+2)*A(K+1)))
     +  /(G(MOD(I,3)+1)*G(MOD(I+1,3)+1))
  75    CONTINUE
  76  IF(KR(1:4).EQ.'ATOM')GOTO 77
      IF(KR(1:6).NE.'HETATM')GOTO 74
  77  KQ=' '
      READ(KR,'(12X,A4,A1,A3,2X,I4,4X,3F8.3,2F6.2)',ERR=85,END=85)
     +KK,KP,KQ(1:3),N,U,V,W,S,T
      IF(KK.EQ.' W  '.AND.KQ.EQ.'HOH ')GOTO 74
      IF(NN.GE.MX)GOTO 266
      IF(NN.GE.50000)GOTO 266
      NN=NN+1
      IS(NN)=5
        DO 78 I=1,NU
        IF(KC(I).EQ.KK(1:2))IS(NN)=I
  78    CONTINUE
      X(NN)=U*A(1)+V*A(2)+W*A(3)+A(4)
      Y(NN)=U*A(5)+V*A(6)+W*A(7)+A(8)
      Z(NN)=U*A(9)+V*A(10)+W*A(11)+A(12)
      OC(NN)=S+10.
      UI(NN)=0.01266515*T
      UA(NN,1)=-9.E9
      IF(N.GT.0)KE(N)=KQ
      IR(NN)=N
      IP(NN)=0
      IF(KP.NE.' ')IP(NN)=ICHAR(KP)-64
      IF(IP(NN).EQ.0)GOTO 81
      WRITE(KG(5:9),'(I4,A1)')N,KP
        DO 79 I=1,NG
        IF(KN(I)(5:9).EQ.KG(5:9))GOTO 80
  79    CONTINUE
      GOTO 81
  80  READ(KN(I),'(I4)')N
      IF(N.GT.5000)N=N-10000
      OC(NN)=10.*REAL(IABS(N))+1.
      IF(N.LT.0)OC(NN)=-OC(NN)
  81  IA(NN)=0
      IL(NN)=-9999
      DD(NN)=0.
      KA(NN)=KK
      IF(KK(1:1).EQ.' ')KA(NN)=KK(2:4)//' '
      GOTO 74
  82  NX=NN
        DO 84 I=MX,MAX0(NP,NN+1),-1
        NX=NX+1
        KA(NX)='O   '
        IS(NX)=IS(I)
        X(NX)=X(I)
        Y(NX)=Y(I)
        Z(NX)=Z(I)
        OC(NX)=OC(I)
        IR(NX)=IR(I)
        IP(NX)=IP(I)
        IA(NX)=IA(I)
        IL(NX)=IL(I)
        DD(NX)=DD(I)
        UI(NX)=UI(I)
          DO 83 J=1,6
          UA(NX,J)=UA(I,J)
  83      CONTINUE
  84    CONTINUE
      GOTO 163
  85  WRITE(*,'(/A)')' ** Bad PDB file; ''Q'' to exit, <CR> to '//
     +'try again: '
      KR=' '
      READ(*,'(A)',ERR=271,END=271)KR
      IF(INDEX(KR,'Q')+INDEX(KR,'q').EQ.0)GOTO 271
      GOTO 65
C
C Delete atoms from list
C
  86  WRITE(*,'(/A/A/A/A)')' Atoms may now be deleted from the '//
     +'current list.  Note that this is not',' necessary for atoms '
     +//'for which new coordinates are to be read from a PDB file,',
     +' and that there is an alternative automated method of '
     +//'updating solvent atoms.',' To delete disorder components,'
     +//' the PART number must be appended as /n.'
  87  WRITE(*,'(1X)')
      WRITE(*,FMT)' Enter residue number from which atoms should '
     +//'be deleted, <CR> if none: '
      KR=' '
      READ(*,'(A)',ERR=87,END=112)KR
      CALL LINTRM(KR,I)
      IF(I.EQ.0)GOTO 112
      READ(KR,*,ERR=112,END=112)N
      IF(N.LT.0)GOTO 87
      KR=' '
      L=1
      J=0
        DO 92 I=1,NN
        IF(IR(I).NE.N)GOTO 92
        J=J+1
        IF(L.GT.70)GOTO 92
          DO 88 K=1,4
          IF(KA(I)(K:K).EQ.' ')GOTO 89
          L=L+1
          KR(L:L)=KA(I)(K:K)
  88      CONTINUE
  89    IF(IP(I).EQ.0)GOTO 91
        WRITE(KK,'(A1,I3)')'/',IP(I)
          DO 90 K=1,4
          IF(KK(K:K).EQ.' ')GOTO 90
          L=L+1
          KR(L:L)=KK(K:K)
  90      CONTINUE
  91    L=L+1
        IF(L.LT.69)GOTO 92
        L=L+4
        KR(L-3:L)='etc.'
  92    CONTINUE
  93  WRITE(KK,'(I4)')N
      KT=KE(N)
      K=INDEX(KT,' ')
      KT(K:K)='_'
        DO 94 I=1,4
        IF(KK(I:I).EQ.' ')GOTO 94
        K=K+1
        KT(K:K)=KK(I:I)
  94    CONTINUE
      WRITE(*,'(A,I5,A/A)')' Residue '//KT(1:K)//
     +' contains the following',J,' atoms:',KR(1:L)
      WRITE(*,FMT)' First and last'
     +//' atoms to be deleted (<CR> for none, * for all): '
      KT=' '
      READ(*,'(A)',ERR=93,END=93)KT
      CALL LINTRM(KT,I)
      KK=' '
      KQ=' '
      NI=0
      NL=0
      I=0
  95  I=I+1
      IF(I.GT.77)GOTO 101
      IF(KT(I:I).EQ.' ')GOTO 95
        DO 96 K=1,4
        KK(K:K)=KT(I:I)
        I=I+1
        IF(KT(I:I).EQ.' '.OR.KT(I:I).EQ.'/')GOTO 97
  96    CONTINUE
  97  IF(KT(I:I).NE.'/')GOTO 98
      READ(KT(I+1:80),*,ERR=93,END=93)NI
      I=I+2
      IF(NI.GT.9)I=I+1
  98  I=I+1
      IF(I.GT.77)GOTO 101
      IF(KT(I:I).EQ.' ')GOTO 98
        DO 99 K=1,4
        KQ(K:K)=KT(I:I)
        I=I+1
        IF(KT(I:I).EQ.' '.OR.KT(I:I).EQ.'/')GOTO 100
  99    CONTINUE
 100  IF(KT(I:I).NE.'/')GOTO 101
      READ(KT(I+1:80),*,ERR=93,END=93)NL
      I=I+2
      IF(NL.GT.9)I=I+1
 101  IF(KK.EQ.'    ')GOTO 87
      L=1
      M=NN
      IF(KK.EQ.'*   ')GOTO 108
      L=0
      M=0
        DO 102 I=1,NN
        IF(IR(I).NE.N)GOTO 102
        IF(NI.NE.IP(I))GOTO 102
        IF(KK.EQ.KA(I))GOTO 105
 102    CONTINUE
 103  IF(NI.EQ.0)GOTO 104
      WRITE(*,'(A,I1,A,I5)')' Atom '//KK//'/',NI,
     +' not found in residue',N
      GOTO 87
 104  WRITE(*,'(A,I5)')' Atom '//KK//' not found in residue',N
      GOTO 87
 105  L=I
        DO 106 I=1,NN
        IF(IR(I).NE.N)GOTO 106
        IF(NL.NE.IP(I))GOTO 106
        IF(KQ.EQ.KA(I))GOTO 107
 106    CONTINUE
      KK=KQ
      NI=NL
      IF(KQ.NE.'    ')GOTO 103
      I=L
 107  M=I
 108    DO 109 I=L,M
        IF(IR(I).EQ.N)IS(I)=0
 109    CONTINUE
      N=0
        DO 111 I=1,NX
        IF(IS(I).EQ.0)GOTO 111
        N=N+1
        IS(N)=IS(I)
        KA(N)=KA(I)
        X(N)=X(I)
        Y(N)=Y(I)
        Z(N)=Z(I)
        OC(N)=OC(I)
        UI(N)=UI(I)
        IR(N)=IR(I)
        IP(N)=IP(I)
        IA(N)=IA(I)
        IL(N)=IL(I)
        DD(N)=DD(I)
          DO 110 J=1,6
          UA(N,J)=UA(I,J)
 110      CONTINUE
 111    CONTINUE
      NN=N+NN-NX
      NX=N
      GOTO 87
C
C Update residue using PDB file
C
 112  KF(LN+1:LN+4)='.pdb'
      KS=KF
      NL=LN+4
      WRITE(*,'(/A/A/A)')' Answer the next question with * to insert'
     +//' (or replace with) all atoms in',' a PDB format file;'//
     +' disorder components cannot be generated in this way,',
     +' and residue numbers must agree in the input files and are'
     +//' retained unchanged.'
      GOTO 115
 113  WRITE(*,'(/A/)')' ** SCALEn cards missing or bad in PDB file **'
      GOTO 115
 114  WRITE(*,'(/A)')' ** Cannot open PDB file '//KR(1:L)//' **'
 115  CLOSE(LF,IOSTAT=I)
 116  WRITE(*,'(1X)')
      WRITE(*,FMT)' Residue number to update using PDB file '
     +//'(<CR> if none): '
      KR=' '
      READ(*,'(A)',ERR=116,END=116)KR
      CALL LINTRM(KR,I)
      IF(I.EQ.0)GOTO 163
      NR=-1
      IF(KR(I:I).EQ.'*')GOTO 117
      READ(KR,*,ERR=116,END=116)NR
      IF(NR.LT.0)GOTO 116
 117  WRITE(*,FMT)' Name of PDB file to read ['//KS(1:NL)//']: '
      KR=' '
      READ(*,'(A)',ERR=117,END=117)KR
      CALL LINTRM(KR,N)
      L=0
        DO 118 I=1,N
        IF(KR(I:I).EQ.' ')GOTO 118
        L=L+1
        KR(L:L)=KR(I:I)
 118    CONTINUE
      IF(L.GT.0)GOTO 119
      KR=KS
      L=NL
      GOTO 120
 119  IF(INDEX(KR,'.').NE.0)GOTO 120
      L=L+4
      KR(L-3:L)='.pdb'
 120  OPEN(UNIT=LF,FILE=KR(1:L),STATUS='OLD',ERR=114)
      KS=KR
      NL=L
 121  READ(LF,'(A)',ERR=113,END=113)KR
      IF(KR(1:5).NE.'SCALE')GOTO 121
      CALL LINTRM(KR,I)
      READ(KR(6:6),'(I1)')I
      M=I*4
      READ(KR(11:55),'(3F10.6,5X,F10.6)')(A(I),I=M-3,M)
      IF(M.NE.12)GOTO 121
      IF(NR.LT.0)GOTO 124
      WRITE(KK,'(I4)')NR
        DO 122 L=1,4
        IF(KK(L:L).NE.' ')GOTO 123
 122    CONTINUE
 123  WRITE(*,FMT)' Corresponding residue number in PDB file ['//
     +KK(L:4)//']: '
      KR=' '
      READ(*,'(A)',ERR=116,END=116)KR
      CALL LINTRM(KR,I)
      IF(I.EQ.0)KR(1:4)=KK
      READ(KR,*,ERR=116,END=116)NP
      IF(NP.LE.0)GOTO 123
 124  WRITE(*,FMT)' Isotropic U for atoms inserted from PDB file'
     +//' (<CR> use PDB value): '
      KR=' '
      READ(*,'(A)',ERR=124,END=124)KR
      CALL LINTRM(KR,I)
      IF(I.EQ.0)KR='-1.0'
      READ(KR,*,ERR=124,END=124)UW
      IF(NR.LT.0)GOTO 131
C
C Atoms to be added/updated
C
      KR=' '
      L=1
      J=0
        DO 129 I=1,NN
        IF(IR(I).NE.NR)GOTO 129
        J=J+1
        IF(L.GT.70)GOTO 129
          DO 125 K=1,4
          IF(KA(I)(K:K).EQ.' ')GOTO 126
          L=L+1
          KR(L:L)=KA(I)(K:K)
 125      CONTINUE
 126    IF(IP(I).EQ.0)GOTO 128
        WRITE(KK,'(A1,I3)')'/',IP(I)
          DO 127 K=1,4
          IF(KK(K:K).EQ.' ')GOTO 127
          L=L+1
          KR(L:L)=KK(K:K)
 127      CONTINUE
 128    L=L+1
        IF(L.LT.69)GOTO 129
        L=L+4
        KR(L-3:L)='etc.'
 129    CONTINUE
      WRITE(KK,'(I4)')NR
      KT=KE(NR)
      K=INDEX(KT,' ')
      KT(K:K)='_'
        DO 130 I=1,4
        IF(KK(I:I).EQ.' ')GOTO 130
        K=K+1
        KT(K:K)=KK(I:I)
 130    CONTINUE
      WRITE(*,'(A,I5,A/A/A/A)')' Residue '//KT(1:K)//
     +' currently contains the following',J,' atoms:',KR(1:L),
     +' For each atom from PDB file, enter N (No action), A (Add),'
     +//' or R (Replace),',' followed by the new PART number if'//
     +' non-zero.'
C
C Read new coordinates from PDB file
C
      JS=-9999
      MM=0
 131  KR=' '
      READ(LF,'(A)',ERR=140,END=140)KR
      IF(KR(1:4).EQ.'ATOM')GOTO 132
      IF(KR(1:6).NE.'HETATM')GOTO 131
 132  KQ=' '
      READ(KR,'(12X,A4,1X,A3,2X,I4,4X,3F8.3,6X,F6.2)',ERR=162,END=162)
     +KK,KQ(1:3),N,U,V,W,T
      IF(NR.LT.0)GOTO 135
C
C Prompt if residue fits
C
        DO 133 I=1,MM
        IF(N.EQ.IG(I))GOTO 134
 133    CONTINUE
      IF(MM.GT.11)GOTO 134
      MM=MM+1
      IG(MM)=N
 134  IF(N.NE.NP)GOTO 131
 135  JS=-1
      IF(KK(1:2).EQ.' C')JS=1
      IF(KK(1:2).EQ.' H')JS=2
      IF(KK(1:2).EQ.' N')JS=3
      IF(KK(1:2).EQ.' S')JS=5
      IF(NR+JS.EQ.-2)JS=6
      IF(KK(1:1).EQ.' ')KK=KR(14:16)//' '
      M=0
      L=NN
      NY=NR
      IF(NY.LT.0)NY=N
        DO 136 I=1,NN
        IF(IR(I).NE.NY)GOTO 136
        L=I
        IF(KK.NE.KA(I))GOTO 136
        N=I
        M=M+1
        IF(M.GT.12)GOTO 139
        IC(M)=IP(I)
        JS=IS(I)
 136    CONTINUE
      XX=U*A(1)+V*A(2)+W*A(3)+A(4)
      YY=U*A(5)+V*A(6)+W*A(7)+A(8)
      ZZ=U*A(9)+V*A(10)+W*A(11)+A(12)
      IF(M.NE.0)GOTO 142
      L=0
        DO 137 I=1,NN
        IF(IR(I).LE.NY)L=I
 137    CONTINUE
      IF(NR.LT.0)GOTO 154
 138  WRITE(*,FMT)' '//KK//' No current atom; options N, A [A]: '
      KR=' '
      READ(*,'(A)',ERR=138,END=138)KR
      CALL LINTRM(KR,I)
      IF(I.EQ.0)KR='A'
      IF(INDEX(KR,'N')+INDEX(KR,'n').GT.0)GOTO 131
      IF(INDEX(KR,'A')+INDEX(KR,'a').EQ.0)GOTO 138
      GOTO 154
 139  WRITE(*,'(/A/)')' ** Too many disorder components **'
      GOTO 115
 140  IF(JS.GT.-9998)GOTO 115
      WRITE(*,141)NP,(IG(I),I=1,MM)
      WRITE(*,'(1X)')
      REWIND LF
      GOTO 121
 141  FORMAT(/' Residue',I5,'  not found in PDB file, but the ',
     +'following residues were present:'/12I6,' etc.')
 142  IF(NR.LT.0)GOTO 161
        DO 144 J=1,13
          DO 143 I=1,M
          IF(IC(I).EQ.J)GOTO 144
 143      CONTINUE
        GOTO 145
 144    CONTINUE
 145  K=13
      KR=' Options: N, '
        DO 147 I=1,M
        KQ='R'
        IF(IC(I).GT.0)WRITE(KQ,'(A1,I3)')'R',IC(I)
          DO 146 L=1,4
          IF(KQ(L:L).EQ.' ')GOTO 146
          K=K+1
          KR(K:K)=KQ(L:L)
 146      CONTINUE
        K=K+2
        KR(K-1:K)=', '
 147    CONTINUE
      WRITE(KQ,'(I4)')J
      K=K+1
      KR(K:K)='A'
        DO 148 L=1,4
        IF(KQ(L:L).EQ.' ')GOTO 148
        K=K+1
        KR(K:K)=KQ(L:L)
 148    CONTINUE
      IF(M.NE.1)GOTO 149
      IF(IC(1).NE.0)GOTO 149
      K=K+4
      KR(K-3:K)=', A2'
 149  WRITE(*,FMT)' '//KK//KR(1:K)//' [N]: '
      KT=' '
      READ(*,'(A)',ERR=149,END=149)KT
      CALL LINTRM(KT,I)
      KQ=' '
      L=0
        DO 150 I=1,80
        IF(KT(I:I).LT.'0')GOTO 150
        L=L+1
        KQ(L:L)=KT(I:I)
        IF(KQ(L:L).GE.'a'.AND.KQ(L:L).LE.'z')KQ(L:L)=CHAR
     +  (ICHAR(KQ(L:L))-32)
 150    CONTINUE
      IF(L.EQ.0)GOTO 131
      IF(INDEX(KR(1:K),KQ(1:L)).EQ.0)GOTO 149
      IF(KQ(1:1).EQ.'N')GOTO 131
      IF(KQ(2:2).EQ.' ')KQ(2:2)='0'
      READ(KQ(2:4),*,ERR=149,END=149)M
      IF(KQ(1:1).NE.'R')GOTO 152
        DO 151 N=1,NN
        IF(IR(N).NE.NR)GOTO 151
        IF(KA(N).NE.KK)GOTO 151
        IF(IP(N).EQ.M)GOTO 161
 151    CONTINUE
      GOTO 149
 152  L=0
        DO 153 I=1,NN
        IF(IR(I).NE.NR)GOTO 153
        IF(KA(I).EQ.KK)L=I
 153    CONTINUE
      IF(IP(L).NE.0)GOTO 154
      IP(L)=1
      IF(M.EQ.1)IP(L)=2
 154  NX=NX+1
      IF(NX.GT.MX)GOTO 266
      NN=NN+1
      N=NX
 155  I=N-1
      IF(I.LE.L)GOTO 157
      IS(N)=IS(I)
      KA(N)=KA(I)
      X(N)=X(I)
      Y(N)=Y(I)
      Z(N)=Z(I)
      OC(N)=OC(I)
      UI(N)=UI(I)
      IR(N)=IR(I)
      IP(N)=IP(I)
      IA(N)=IA(I)
      IL(N)=IL(I)
      DD(N)=DD(I)
        DO 156 J=1,6
        UA(N,J)=UA(I,J)
 156    CONTINUE
      N=N-1
      GOTO 155
 157  IF(JS.GT.0)GOTO 159
 158  WRITE(*,FMT)' Scattering factor number [5]: '
      KR=' '
      READ(*,'(A)',ERR=158,END=158)KR
      CALL LINTRM(KR,I)
      IF(I.EQ.0)KR='5'
      READ(KR,*,ERR=158,END=158)JS
      IF(JS.LT.1)GOTO 158
 159  IS(N)=JS
      KA(N)=KK
      OC(N)=11.
      UI(N)=UW
      IF(UW.LT.0.)UI(N)=.01266515*T
      IR(N)=NY
      IP(N)=M
      IA(N)=0
      IL(N)=-9999
      DD(N)=0.
      UA(N,1)=-9.E9
        DO 160 J=2,6
        UA(N,J)=0.
 160    CONTINUE
 161  X(N)=XX
      Y(N)=YY
      Z(N)=ZZ
      GOTO 131
 162  WRITE(*,'(/A//1X,A/)')KR(1:70),' ** Bad PDB file **',KR(1:70)
      GOTO 115
C
C Tidy up occupancies and free variables
C
 163  L=0
      KR=' '
        DO 165 I=2,NF
        IF(NV(I).NE.0)GOTO 165
        WRITE(KT,'(I6)')I
        L=L+1
          DO 164 K=1,6
          IF(KT(K:K).EQ.' ')GOTO 164
          L=L+1
          KR(L:L)=KT(K:K)
 164      CONTINUE
        IF(L.GT.72)GOTO 166
 165    CONTINUE
 166  IF(L.GT.0)WRITE(*,'(/A/A/)')' The following free variables '//
     +'appear to be currently unused:',KR(1:L)
 167  NP=1
      MI=0
 168  NI=NP
      NP=10000
      NR=0
      NA=NN+1
        DO 169 I=1,NN
        L=IR(I)
        KK=KE(L)
        IF(KK.EQ.'HOH '.OR.KK.EQ.'H2O '.OR.KK.EQ.'WAT ')GOTO 169
        IF(L.GT.NI)NP=MIN0(L,NP)
        IF(L.NE.NI)GOTO 169
        NA=MIN0(I,NA)
        NR=I
        IF(IP(I).GE.0)IR(I)=-IR(I)
 169    CONTINUE
      IF(NA.LE.NN)GOTO 171
      IF(NP.LT.10000)GOTO 168
 170  IF(MI.EQ.0)GOTO 194
      WRITE(*,'(1X)')
      WRITE(*,FMT)' Repeat occupancy check (Y or N) [N]: '
      KR=' '
      READ(*,'(A)',ERR=170,END=170)KR
      IF(INDEX(KR,'Y')+INDEX(KR,'y').GT.0)GOTO 167
      GOTO 194
C
C Occupancies for PART 0
C
 171  NC=0
        DO 175 I=NA,NR
        IF(IR(I).GE.0)GOTO 175
        NC=MAX0(NC,IP(I))
        IF(IP(I).GT.0)GOTO 175
        IF(ABS(OC(I)-11.).LT.0.0001)GOTO 174
        L=-IR(I)
        WRITE(KR,'(A,I5,A,F12.5)')'$Occupancy$of$'//KA(I)//'_'//
     +  KE(L),L,'$given$as$',OC(I)
        L=0
          DO 172 K=1,50
          IF(KR(K:K).EQ.' ')GOTO 172
          IF(KR(K:K).EQ.'$')KR(K:K)=' '
          L=L+1
          KR(L:L)=KR(K:K)
 172      CONTINUE
        WRITE(*,'(1X)')
 173    WRITE(*,FMT)KR(1:L)//'  Replace with 11 ? [Y]: '
        KT=' '
        READ(*,'(A)',ERR=173,END=173)KT
        CALL LINTRM(KT,K)
        IF(K.EQ.0)KT='Y'
        MI=MI+1
        IF(INDEX(KT,'N')+INDEX(KT,'n').GT.0)GOTO 174
        IF(INDEX(KT,'Y')+INDEX(KT,'y').EQ.0)GOTO 173
        MI=MI-1
        OC(I)=11.
 174    IR(I)=IABS(IR(I))
 175    CONTINUE
C
C Occupancies for disorder components
C
      IF(NC.EQ.0)GOTO 168
      L=IABS(IR(NA))
      WRITE(KR,'(A,I5)')KE(L),L
      L=0
        DO 176 K=1,9
        IF(KR(K:K).EQ.' ')GOTO 176
        L=L+1
        KR(L:L)=KR(K:K)
 176    CONTINUE
      WRITE(*,'(/A)')' Occupancies (as they appear in the .ins '
     +//'file) for disordered residue '//KR(1:L)//':'
        DO 180 J=1,NC
        L=1
        KR=' '
          DO 178 I=NA,NR
          IF(IR(I).GE.0)GOTO 178
          IF(IP(I).NE.J)GOTO 178
          WRITE(KT,'(F12.5)')OC(I)
          L=L+1
          KR(L:L)=' '
            DO 177 K=1,12
            IF(KT(K:K).EQ.' ')GOTO 177
            L=L+1
            KR(L:L)=KT(K:K)
 177        CONTINUE
          IF(KR(L-3:L).EQ.'0000')L=L-4
          IF(L.LT.57)GOTO 178
          L=MIN0(L+5,70)
          KR(L-4:L)=' etc.'
          GOTO 179
 178      CONTINUE
 179    IF(L.GT.1)WRITE(*,'(A,I3,A)')' PART',J,KR(1:L)
 180    CONTINUE
 181  WRITE(*,FMT)' Do you wish to change these (Y or N, S to skip'
     +//' rest) ? [N]: '
      KQ=' '
      READ(*,'(A)',ERR=181,END=181)KQ
      CALL LINTRM(KQ,I)
      MI=MI+1
      IF(I.EQ.0)KQ='N'
      IF(INDEX(KQ,'S')+INDEX(KQ,'s').GT.0)GOTO 192
      IF(INDEX(KQ,'N')+INDEX(KQ,'n').GT.0)GOTO 192
      IF(INDEX(KQ,'Y')+INDEX(KQ,'y').EQ.0)GOTO 181
      M=0
        DO 189 J=1,NC
          DO 186 I=NA,NR
          IF(IR(I).GE.0)GOTO 186
          IF(IP(I).NE.J)GOTO 186
 182      WRITE(KK,'(I3)')J
          WRITE(KR,'(F7.1)')10.*REAL(NF)+11.
          IF(J.EQ.NC.AND.M.EQ.1)WRITE(KR,'(F7.1)')-T
          L=0
            DO 183 K=1,7
            IF(KR(K:K).EQ.' ')GOTO 183
            L=L+1
            KR(L:L)=KR(K:K)
 183        CONTINUE
          M=M+1
          WRITE(*,FMT)' Occupancy (as in .ins) for all PART'//
     +    KK(1:3)//' atoms ['//KR(1:L)//']: '
          KT=' '
          READ(*,'(A)',ERR=182,END=182)KT
          CALL LINTRM(KT,K)
          IF(K.EQ.0)KT=KR(1:L)
          READ(KT,*,ERR=182,END=182)T
          K=INT(0.1*ABS(T)+0.5)
          IF(K.LT.2)GOTO 187
          IF(K.LE.NF+1)GOTO 184
          WRITE(*,'(A)')' ** Free variable number too large **'
          GOTO 182
 184      NF=MAX0(NF,K)
          IF(NV(K).NE.0)GOTO 187
          WRITE(KK,'(I4)')K
 185      WRITE(*,FMT)' Starting value for new free variable'//KK
     +    //' [0.5]: '
          KR=' '
          READ(*,'(A)',ERR=185,END=185)KR
          CALL LINTRM(KR,L)
          IF(L.EQ.0)KR='0.5'
          READ(KR,*,ERR=185,END=185)W
          IF(W.LT.0.)GOTO 185
          IF(W.GT.1.)GOTO 185
          FV(K)=W
          NV(K)=1
          GOTO 187
 186      CONTINUE
        GOTO 189
 187      DO 188 I=NA,NR
          IF(IR(I).GE.0)GOTO 188
          IF(IP(I).NE.J)GOTO 188
          OC(I)=T
 188      CONTINUE
 189    CONTINUE
      IF(M.NE.1)GOTO 192
 190  WRITE(*,FMT)' Convert all atoms in this residue to PART 0'
     +//' (Y or N) ? [Y]: '
      READ(*,'(A)',ERR=190,END=190)KK
      CALL LINTRM(KK,I)
      IF(I.EQ.0)KK='Y'
      IF(INDEX(KK,'N')+INDEX(KK,'n').NE.0)GOTO 192
      IF(INDEX(KK,'Y')+INDEX(KK,'y').EQ.0)GOTO 190
        DO 191 I=NA,NR
        IF(IABS(IR(I)).EQ.NI)IP(I)=0
 191    CONTINUE
 192    DO 193 I=NA,NR
        IR(I)=IABS(IR(I))
 193    CONTINUE
      IF(INDEX(KQ,'S')+INDEX(KQ,'s').EQ.0)GOTO 168
C
C Renumber residues
C
 194  WRITE(*,'(1X)')
      WRITE(*,FMT)' Renumber residues (other than waters) ? [N]: '
      KR=' '
      READ(*,'(A)',ERR=194,END=194)KR
      CALL LINTRM(KR,I)
      IF(I.EQ.0)GOTO 200
      IF(INDEX(KR,'n')+INDEX(KR,'N').GT.0)GOTO 200
 195  WRITE(*,FMT)' First and last consecutive residue numbers to '
     +//'change (<CR> if none): '
      KR=' '
      READ(*,'(A)',ERR=195,END=195)KR
      CALL LINTRM(KR,I)
      IF(I.EQ.0)GOTO 200
      READ(KR(1:I),*,ERR=195,END=195)NI,NP
 196  WRITE(*,FMT)' New residue number for the first of these: '
      KR=' '
      READ(*,'(A)',ERR=196,END=196)KR
      CALL LINTRM(KR,I)
      IF(I.EQ.0)GOTO 200
      READ(KR(1:I),*,ERR=196,END=196)NH
      IF(NH.LT.0)GOTO 199
      IF(NH-NI+NP.GT.9999)GOTO 199
        DO 197 I=1,NN
        J=IR(I)
        IF(J.LT.NI.OR.J.GT.NP)GOTO 197
        K=J+NH-NI
        IF(KE(K).EQ.'    ')GOTO 197
        WRITE(*,'(A,I5,A)')' ** Residue number',K,' in use, so no '
     +  //'changes made **'
        GOTO 195
 197    CONTINUE
        DO 198 I=1,NN
        J=IR(I)
        IF(J.LT.NI.OR.J.GT.NP)GOTO 198
        K=J+NH-NI
        IR(I)=K
        IF(KE(K).EQ.'    ')KE(K)=KE(J)
        KE(J)='    '
 198    CONTINUE
      GOTO 195
 199  WRITE(*,'(A/)')' ** Would create residue number outside '
     +//'range 0 to 9999, so no changes made **'
      GOTO 195
C
C Tidy up waters
C
 200  WRITE(*,'(1X)')
      WRITE(*,FMT)' Add, halve or delete waters (Y or N) ? [Y]: '
      KR=' '
      READ(*,'(A)',ERR=200,END=200)KR
      SL=1.
      SP=99999.
      NH=0
      UR=99999.
      UW=0.5
      IF(INDEX(KR,'n')+INDEX(KR,'N').GT.0)GOTO 208
 201  WRITE(*,FMT)' Should occupancies be halved for waters with'
     +//' high U-values (Y or N) ? [N]: '
      KR=' '
      READ(*,'(A)',ERR=201,END=201)KR
      IF(INDEX(KR,'y')+INDEX(KR,'Y').GT.0)NH=1
 202  IF(NH.EQ.1)GOTO 203
      WRITE(*,FMT)' Ueq-threshold for rejecting waters [0.8]: '
      GOTO 204
 203  WRITE(*,FMT)' Ueq-threshold for halving waters (or rejecting'
     +//' half waters) [0.8]: '
 204  KR=' '
      READ(*,'(A)',ERR=202,END=202)KR
      CALL LINTRM(KR,I)
      IF(I.EQ.0)KR='0.8'
      READ(KR,*,ERR=202,END=202)UR
      IF(NN.EQ.NX)GOTO 208
 205  WRITE(*,FMT)' Sigma level for adding waters from peaklist [4]: '
      KR=' '
      READ(*,'(A)',ERR=205,END=205)KR
      CALL LINTRM(KR,I)
      IF(I.EQ.0)KR='4.0'
      READ(KR,*,ERR=205,END=205)SP
      UW=0.5
      IF(SL.GT.0.)GOTO 207
 206  WRITE(*,FMT)' 1-Sigma level of map: '
      KR=' '
      READ(*,'(A)',ERR=206,END=206)KR
      CALL LINTRM(KR,I)
      IF(I.EQ.0)GOTO 206
      READ(KR,*,ERR=206,END=206)SL
 207  WRITE(*,FMT)' Isotropic U value to be assigned to new waters'
     +//' [0.5]: '
      KR=' '
      READ(*,'(A)',ERR=207,END=207)KR
      CALL LINTRM(KR,I)
      IF(I.EQ.0)KR='0.5'
      READ(KR,*,ERR=207,END=207)UW
C
C Starting residue number for waters
C
 208  WRITE(*,'(1X)')
      WRITE(*,FMT)' Renumber residues for waters ? [Y]: '
      KR=' '
      READ(*,'(A)',ERR=208,END=208)KR
      CALL LINTRM(KR,I)
      I=MAX0(1,I)
      NI=-1
      NW=MIN0(NW,100*(NZ/100+1)+1)
      IF(KR(I:I).EQ.'N'.OR.KR(I:I).EQ.'n')GOTO 211
      IF(KR(I:I).NE.' '.AND.KR(I:I).NE.'Y'.AND.KR(I:I).NE.'y')GOTO 208
      WRITE(KT,'(I5)')NW
      IF(NW.GT.9999)KT='    ?'
        DO 209 L=1,5
        IF(KT(L:L).NE.' ')GOTO 210
 209    CONTINUE
 210  WRITE(*,FMT)' Starting residue number for waters ['//
     +KT(L:5)//']: '
      KR=' '
      READ(*,'(A)',ERR=210,END=210)KR
      CALL LINTRM(KR,I)
      IF(I.EQ.0)KR=KT
      READ(KR,*,ERR=210,END=210)NI
C
C Process waters
C
 211  N=NN
      NN=0
      NJ=0
      NK=0
        DO 219 I=1,NX
        IF(I.LE.N)GOTO 212
        IF(UA(I,2).LT.SP*SL)GOTO 219
 212    J=IR(I)
        IF(J.LT.0)GOTO 214
        KK=KE(J)
        IF(KK.NE.'HOH '.AND.KK.NE.'H2O '.AND.KK.NE.'WAT ')GOTO 216
        IF(ABS(UI(I)).GE.15.)GOTO 215
        IF(UI(I).LE.UR)GOTO 215
        IF(NH.EQ.0)GOTO 219
        IF(ABS(OC(I)).GE.15.)GOTO 218
        IF(AMOD(ABS(OC(I)),10.).LT.0.9)GOTO 218
        OC(I)=10.5
        UI(I)=0.6*UI(I)
        IF(UA(I,1).LT.8.E-9)GOTO 215
          DO 213 J=1,6
          UA(I,J)=0.6*UA(I,J)
 213      CONTINUE
        GOTO 215
 214    UI(I)=UW
        IR(I)=NW
        NW=NW+1
 215    KA(NN+1)='O   '
        IF(NI.LT.0)GOTO 216
        IR(I)=NI
        KE(NI)='HOH '
        NI=NI+1
 216    NN=NN+1
        IS(NN)=IS(I)
        X(NN)=X(I)
        Y(NN)=Y(I)
        Z(NN)=Z(I)
        OC(NN)=OC(I)
        UI(NN)=UI(I)
        IR(NN)=IR(I)
        IP(NN)=IP(I)
        IA(NN)=IA(I)
        IL(NN)=IL(I)
        DD(NN)=DD(I)
          DO 217 J=1,6
          UA(NN,J)=UA(I,J)
 217      CONTINUE
 218    KK=KE(IR(NN))
        IF(KK.NE.'HOH '.AND.KK.NE.'H2O '.AND.KK.NE.'WAT ')GOTO 219
        NK=NK+1
        IF(AMOD(ABS(OC(I)),10.).LT.0.99)NJ=NJ+1
 219    CONTINUE
      NK=NK-NJ
      WRITE(KT,'(2(I6,A),I7,A)')NK,' full and',NJ,' partly occupied'
     +//' waters plus',NN-NK-NJ,' other atoms in list'
      WRITE(*,'(/A)')KT(1:76)
C
C Transform waters to equivalent nearest to a non-water
C
 220  WRITE(*,'(1X)')
      WRITE(*,FMT)' Transform waters to equivalent nearest to a '//
     +'non-water (Y or N) ? [Y]: '
      KR=' '
      READ(*,'(A)',ERR=220,END=220)KR
      IF(INDEX(KR,'n')+INDEX(KR,'N').GT.0)GOTO 241
      IF(NN+NS.LE.MX)GOTO 221
      WRITE(*,'(A)')' ** Array too small for calculation - increase '
     +//'LA and recompile **'
      GOTO 241
 221  WRITE(*,'(/A)')' Emulate WHAT-IF bug of ignoring PART numbers '
     +//'greater than 1? This only works'
      WRITE(*,FMT)' if PART 1 atoms come before PART 2 etc.! [N]: '
      KR=' '
      READ(*,'(A)',ERR=221,END=221)KR
      IQ=99999
      IF(INDEX(KR,'y')+INDEX(KR,'Y').GT.0)IQ=1
        DO 238 N=1,NN
        J=IR(N)
        IF(KE(J).NE.'HOH ')GOTO 238
        NA=NN
          DO 223 K=1,NS
          U=SY(1,K)*X(N)+SY(2,K)*Y(N)+SY(3,K)*Z(N)+SY(10,K)
          V=SY(4,K)*X(N)+SY(5,K)*Y(N)+SY(6,K)*Z(N)+SY(11,K)
          W=SY(7,K)*X(N)+SY(8,K)*Y(N)+SY(9,K)*Z(N)+SY(12,K)
            DO 222 J=NN+1,NA
            P=AMOD(X(J)-U,1.)-0.5
            Q=AMOD(Y(J)-V,1.)-0.5
            R=AMOD(Z(J)-W,1.)-0.5
            T=P**2*C(1)+Q**2*C(2)+R**2*C(3)+Q*R*C(4)+
     +      P*R*C(5)+P*Q*C(6)
            IF(T.LT.1.)GOTO 223
 222        CONTINUE
          NA=NA+1
          X(NA)=19.5+U
          Y(NA)=19.5+V
          Z(NA)=19.5+W
          IS(NA)=K
 223      CONTINUE
        U=9.E9
        V=9.E9
          DO 228 M=1,NN
          NR=IR(M)
          IF(NR.EQ.0)GOTO 228
          IF(KE(NR).EQ.'HOH ')GOTO 228
          IF(IS(M).EQ.2)GOTO 228
          IF(IP(M).GT.IQ)GOTO 228
          IF(IP(N).EQ.IP(M))GOTO 224
          IF(IP(N)*IP(M).NE.0)GOTO 228
 224      P=X(N)-X(M)
          Q=Y(N)-Y(M)
          R=Z(N)-Z(M)
          S=P**2*C(1)+Q**2*C(2)+R**2*C(3)+Q*R*C(4)+
     +    P*R*C(5)+P*Q*C(6)
          IF(U.LE.S)GOTO 225
          U=S
          J=M
 225        DO 227 I=NN+1,NA
            P=AMOD(X(I)-X(M),1.)-0.5
            Q=AMOD(Y(I)-Y(M),1.)-0.5
            R=AMOD(Z(I)-Z(M),1.)-0.5
            T=P**2*C(1)+Q**2*C(2)+R**2*C(3)+Q*R*C(4)+
     +      P*R*C(5)+P*Q*C(6)
            IF(I.GT.NN+1)GOTO 226
            IF(T+0.1.GT.S)GOTO 227
 226        IF(V.LE.T)GOTO 227
            V=T
            K=M
            L=I
 227        CONTINUE
 228      CONTINUE
        IF(V.GT.U+0.1)GOTO 238
        WRITE(*,'(1X)')
        KP='N'
        IF(V.LT.U)KP='Y'
        KK='    '
          DO 233 M=1,2
          I=IR(J)
          WRITE(KR,239)SQRT(U),KA(N),IR(N),IP(N),KA(J),KE(I),I,IP(J)
          IF(IABS(IP(N))+IABS(IP(J)).NE.0)GOTO 229
          KR(25:37)='             '
          KR(51:63)='             '
          GOTO 230
 229      IF(U.LT.5.29)WRITE(KK,'(I4)')IP(N)
 230        DO 231 I=44,46
            IF(KR(I:I).GE.'A'.AND.KR(I:I).LE.'Z')KR(I:I)=CHAR(ICHAR
     +      (KR(I:I))+32)
 231        CONTINUE
          IF(M.EQ.2)KR(14:14)='#'
          J=0
            DO 232 I=1,63
            IF(KR(I:I).EQ.' ')GOTO 232
            IF(KR(I:I).EQ.'$')KR(I:I)=' '
            J=J+1
            KR(J:J)=KR(I:I)
 232        CONTINUE
          WRITE(*,'(A)')KR(1:J)
          J=K
          U=V
 233      CONTINUE
 234    IF(KK.EQ.'    ')GOTO 235
        WRITE(*,FMT)' Confirm/reset PART number of water as ['//
     +  KK(4:4)//']: '
        KR=' '
        READ(*,'(A)',ERR=234,END=234)KR
        CALL LINTRM(KR,I)
        IF(I.EQ.0)KR=KK(1:1)
        READ(KK,*,ERR=234,END=234)IP(N)
 235    WRITE(*,FMT)' Transform water to symmetry equivalent # ['
     +  //KP//']: '
        KR=' '
        READ(*,'(A)',ERR=235,END=235)KR
        CALL LINTRM(KR,I)
        IF(I.EQ.0)KR=KP
        IF(INDEX(KR,'n')+INDEX(KR,'N').GT.0)GOTO 238
        X(N)=X(K)+AMOD(X(L)-X(K),1.)-0.5
        Y(N)=Y(K)+AMOD(Y(L)-Y(K),1.)-0.5
        Z(N)=Z(K)+AMOD(Z(L)-Z(K),1.)-0.5
        IF(UA(N,1).LT.-8.E9)GOTO 238
        L=IS(L)
          DO 236 K=1,6
          A(K)=UA(N,K)
 236      CONTINUE
          DO 237 K=1,6
          I=MIN0(7,10-3*IABS(K-4))
          J=MAX0(1,7-3*IABS(K-3))
          UA(N,K)=A(1)*SY(I,L)*SY(J,L)+A(2)*SY(I+1,L)*
     +    SY(J+1,L)+A(3)*SY(I+2,L)*SY(J+2,L)+A(4)*
     +    (SY(I+1,L)*SY(J+2,L)+SY(I+2,L)*SY(J+1,L))+A(5)*
     +    (SY(I,L)*SY(J+2,L)+SY(I+2,L)*SY(J,L))+A(6)*
     +    (SY(I,L)*SY(J+1,L)+SY(I+1,L)*SY(J,L))
 237      CONTINUE
 238    CONTINUE
 239  FORMAT('$',F11.3,'$$',A4,'_',I4,'$(PART$',I5,')$',A4,'_',A4,I4,
     +'$(PART$',I5,')')
 240  WRITE(*,'(1X)')
      WRITE(*,FMT)' Repeat water reorganization (Y or N) ? [N]: '
      KR=' '
      READ(*,'(A)',ERR=240,END=240)KR
      IF(INDEX(KR,'y')+INDEX(KR,'Y').GT.0)GOTO 221
C
C Open .ins file to write
C
 241  KF(LN+1:LN+4)='.ins'
      WRITE(*,'(1X)')
 242  WRITE(*,FMT)' .ins file to write (may be same as read) ['
     +//KF(1:LN+4)//']: '
      KR=' '
      READ(*,'(A)',ERR=242,END=243)KR
      CALL LINTRM(KR,I)
 243  L=0
        DO 244 I=1,80
        IF(KR(I:I).EQ.' ')GOTO 244
        L=L+1
        KR(L:L)=KR(I:I)
 244    CONTINUE
      IF(L.GT.0)GOTO 245
      KR=KF
      L=LN+4
      GOTO 246
 245  IF(INDEX(KR,'.').NE.0)GOTO 246
      L=L+4
      KR(L-3:L)='.ins'
 246  CALL WROPEN(LS,KR,L,I)
      IF(I.NE.0)GOTO 264
C
C Write .ins file
C
 247  READ(LM,ERR=247,END=248)NQ,KR
      IF(NQ.GT.0)GOTO 248
      CALL LINTRM(KR,L)
      L=MAX0(L,1)
      WRITE(LS,'(A)')KR(1:L)
      GOTO 247
 248  WRITE(LS,'(A/1X)')'REM '//KT(1:75)
        DO 249 J=1,NF,7
        WRITE(LS,'(A,F14.5,6F10.5)')'FVAR',(FV(I),I=J,MIN0(J+6,NF))
 249    CONTINUE
      NR=0
      NA=0
      NP=0
        DO 258 I=1,NN
        IF(NA.EQ.IA(I))GOTO 250
        IF(IA(I).NE.0)GOTO 250
        NA=0
        WRITE(LS,'(A,I5)')'AFIX',NA
 250    IF(NR.EQ.IR(I))GOTO 253
        NR=IR(I)
        IF(IL(I).GE.0)GOTO 251
        WRITE(LS,'(/A,I5,3X,A)')'RESI',NR,KE(NR)
        GOTO 252
 251    WRITE(LS,'(/A,I5,3X,A,I5)')'RESI',NR,KE(NR),IL(I)
 252    IF(NQ.GT.NR)GOTO 253
        CALL LINTRM(KR,L)
        L=MAX0(L,1)
        WRITE(LS,'(A)')KR(1:L)
        READ(LM,ERR=253,END=253)NQ,KR
        GOTO 252
 253    IF(NP.EQ.IP(I))GOTO 254
        NP=IP(I)
        WRITE(LS,'(A,I5)')'PART',NP
 254    IF(NA.EQ.IA(I))GOTO 256
        NA=IA(I)
        IF(DD(I).GT.-8.E9)GOTO 255
        WRITE(LS,'(A,I5)')'AFIX',NA
        GOTO 256
 255    WRITE(LS,'(A,I5,F8.4)')'AFIX',NA,DD(I)
 256    IF(UA(I,1).GT.-8.E9)GOTO 257
        WRITE(LS,260)KA(I),IS(I),X(I),Y(I),Z(I),OC(I),UI(I)
        GOTO 258
 257    WRITE(LS,260)KA(I),IS(I),X(I),Y(I),Z(I),OC(I),(UA(I,J),J=1,6)
 258    CONTINUE
 259  READ(LM,ERR=259,END=261)I,KR
      GOTO 262
 260  FORMAT(A,I4,3F12.6,F12.5,F11.5,F10.5,' ='/4X,4F10.5)
 261  KR='HKLF 4'
 262  CALL LINTRM(KR,L)
      L=MAX0(L,1)
      WRITE(LS,'(1X/A/A)')KR(1:L),'END'
      GOTO 272
C
C Error messages and finish off
C
 263  WRITE(*,'(/A/A)')' ** Bad or misplaced LATT or SYMM '//
     +'instruction **',KR(1:79)
      GOTO 271
 264  WRITE(*,'(/A/)')' ** Cannot open file **'
      GOTO 271
 265  WRITE(*,'(/A)')' ** '//KQ//' instruction should be deleted or'
     +//' moved to before FVAR **'
      GOTO 271
 266  WRITE(*,'(/A)')' ** Too many atoms ** '
      GOTO 271
 267  WRITE(KR,'(A,I5)')KQ//'_'//KE(NR),NR
      L=0
        DO 268 I=1,14
        IF(KR(I:I).EQ.' ')GOTO 268
        L=L+1
        KR(L:L)=KR(I:I)
 268    CONTINUE
      IF(J.GT.NF)GOTO 269
      WRITE(*,'(/A)')' ** Badly formatted atom '//KR(1:L)//' **'
      GOTO 271
 269  WRITE(*,'(/A)')' ** Free variable out of range for '//
     +KR(1:L)//' **'
      GOTO 271
 270  WRITE(*,'(/1X,A//A)')KR(1:78),
     +' ** Bad or unsuitable input file **'
 271  IER=1
 272  CLOSE(LS,IOSTAT=I)
      CLOSE(LM,IOSTAT=I)
      RETURN
      END
C
C -------------------------------------------------------------------
C
      SUBROUTINE LSQFIT(NA,XO,YO,ZO,B,IP,IR,D,G)
C
C Read PDB file(s) and perform least-squares fits by the Quaternion
C method.  Summarize deviations in Postscript plots.
C
      COMMON/XTAL/SY(12,192),CELL(15),II(1369),NS,LAT,LU,LN,
     +LO,LP,LF,LM,LS,NOS,IER,NPG
      COMMON/WORD/KF,KR,KD,KE,KA,KB,KN,FMT,COL,OPT
      CHARACTER KF*80,KR*80,KD(462)*52,KA(50000)*4,KE(9999)*4,KG*80,
     +KB(250)*80,KN(10000)*9,FMT*20,COL*4,OPT*1,KC*1,KQ*80,KT*24
      REAL XO(NA),YO(NA),ZO(NA),B(NA),D(NA),G(44)
      INTEGER IP(NA),IR(NA),IG(80)
C
C Read in current structure from PDB format file
C
      MA=MIN0(NA,9999)
   1  KF(LN+1:LN+4)='.pdb'
   2  WRITE(*,FMT)' Name of PDB file for current structure ['
     +//KF(1:LN+4)//']: '
      KR=' '
      READ(*,'(A)',ERR=2,END=2)KR
      CALL LINTRM(KR,N)
      L=0
        DO 3 I=1,N
        IF(KR(I:I).EQ.' ')GOTO 3
        L=L+1
        KR(L:L)=KR(I:I)
   3    CONTINUE
      IF(L.GT.0)GOTO 6
      KR=KF
      L=LN+4
      GOTO 7
   4  WRITE(*,'(/A/)')' ** Cannot open file '//KR(1:L)//' **'
      GOTO 2
   5  FORMAT(/1X,78('=')//' Current structure from file ',A/)
   6  IF(INDEX(KR,'.').NE.0)GOTO 7
      L=L+4
      KR(L-3:L)='.pdb'
   7  OPEN(UNIT=LF,FILE=KR(1:L),STATUS='OLD',ERR=4)
      WRITE(LO,5)KR(1:L)
   8  WRITE(*,FMT)' Chain to be read in (if any) [ ]: '
      KR=' '
      READ(*,'(A)',ERR=8,END=8)KR
      CALL LINTRM(KR,N)
      KC=' '
      IF(N.GT.0)KC=KR(N:N)
      K=9999
      L=0
      NX=0
      N=0
   9  KR=' '
      READ(LF,'(A80)',ERR=11,END=11)KR
      IF(KR(1:6).NE.'HEADER'.AND.KR(1:6).NE.'COMPND'.AND.KR(1:6).NE.
     +'CRYST1'.AND.KR(1:5).NE.'SCALE')GOTO 10
      NX=NX+1
      KB(NX)=KR
      GOTO 9
  10  IF(KR(1:4).NE.'ATOM'.AND.KR(1:6).NE.'HETATM')GOTO 9
      IF(KR(27:27).NE.' ')GOTO 9
      IF(KR(22:22).NE.KC)GOTO 9
      N=N+1
      IF(N.GT.MA)GOTO 133
      IF(KR(17:17).NE.' '.AND.KR(17:17).NE.'A')GOTO 9
      KR(17:17)=' '
      READ(KR,'(12X,2A4,2X,I4,4X,3F8.4,6X,F6.3)')KA(N),KE(N),IR(N),
     +XO(N),YO(N),ZO(N),B(N)
      K=MIN0(IR(N),K)
      L=MAX0(IR(N),L)
      GOTO 9
  11  WRITE(*,'(A,I5,A,I5)')' Minimum and maximum residue numbers '
     +//'stored are',K,' and',L
  12  WRITE(*,FMT)' Min. and max. to retain for plots etc. (<CR>'
     +//' to keep all): '
      KR=' '
      READ(*,'(A)',ERR=12,END=12)KR
      CALL LINTRM(KR,I)
      IF(I.GT.2)READ(KR(1:I),*,ERR=12,END=12)K,L
  13  KR=' '
      WRITE(KR,'(I5)')K
        DO 14 I=1,5
        IF(KR(I:I).NE.' ')GOTO 15
  14    CONTINUE
  15  WRITE(*,FMT)' SHELXPRO residue number for residue '//KR(I:5)//
     +' ['//KR(I:5)//']: '
      KR=' '
      READ(*,'(A)',ERR=13,END=13)KR
      CALL LINTRM(KR,I)
      M=K
      IF(I.GT.0)READ(KR(1:I),*,ERR=13,END=13)M
      NC=0
      MAR=0
      MIR=9999
        DO 16 I=1,N
        IF(IR(I).LT.K)GOTO 16
        IF(IR(I).GT.L)GOTO 16
        NC=NC+1
        XO(NC)=XO(I)
        YO(NC)=YO(I)
        ZO(NC)=ZO(I)
        B(NC)=B(I)
        IR(NC)=IR(I)+M-K
        MAR=MAX0(MAR,IR(NC))
        MIR=MIN0(MIR,IR(NC))
        KA(NC)=KA(I)
        KE(NC)=KE(I)
  16    CONTINUE
      CLOSE(LF,IOSTAT=I)
      WRITE(*,'(I6,A)')NC,' current structure atoms stored'
      K=K-M
      IF(KC.EQ.' ')WRITE(LO,17)NC,MIR+K,MAR+K,' ',MIR,MAR
      IF(KC.NE.' ')WRITE(LO,17)NC,MIR+K,MAR+K,' of chain '//KC,MIR,MAR
  17  FORMAT(I7,' atoms stored from residues',I5,' to',I5,A,
     +' in file'/' Assigned SHELXPRO residue numbers',I5,' to',I5/)
  18  KR=' '
      WRITE(KR,'(2I5)')MIR,MAR
        DO 19 I=1,5
        IF(KR(I:I).NE.' ')GOTO 20
  19    CONTINUE
  20    DO 21 J=6,10
        IF(KR(J:J).NE.' ')GOTO 22
  21    CONTINUE
  22  WRITE(*,FMT)' Limiting SHELXPRO residue numbers for storing'
     +//' all models ['//KR(I:5)//' '//KR(J:10)//']: '
      KR=' '
      READ(*,'(A)',ERR=18,END=18)KR
      CALL LINTRM(KR,I)
      MIS=MIR
      MAS=MAR
      IF(I.GT.0)READ(KR(1:I),*,ERR=18,END=18)MIS,MAS
C
C Read in reference model from PDB format file
C
      KF(LN+1:LN+4)='.pdb'
      KQ=KF
  23  WRITE(*,'(1X)')
  24  CALL LINTRM(KQ,L)
      WRITE(*,FMT)' Name of PDB file for reference model ['
     +//KQ(1:L)//']: '
      KR=' '
      READ(*,'(A)',ERR=24,END=24)KR
      CALL LINTRM(KR,N)
      L=0
        DO 25 I=1,N
        IF(KR(I:I).EQ.' ')GOTO 25
        L=L+1
        KR(L:L)=KR(I:I)
  25    CONTINUE
      IF(L.GT.0)GOTO 27
      KR=KQ
      CALL LINTRM(KR,L)
      GOTO 28
  26  WRITE(*,'(/A/)')' ** Cannot open file '//KR(1:L)//' **'
      GOTO 24
  27  IF(INDEX(KR,'.').NE.0)GOTO 28
      L=L+4
      KR(L-3:L)='.pdb'
  28  OPEN(UNIT=LF,FILE=KR(1:L),STATUS='OLD',ERR=26)
      WRITE(LO,'(/A/)')' Reference model read from file '//KR(1:L)
  29  WRITE(*,FMT)' Chain to be read in (if any) [ ]: '
      KR=' '
      READ(*,'(A)',ERR=29,END=29)KR
      CALL LINTRM(KR,N)
      KC=' '
      IF(N.GT.0)KC=KR(N:N)
      K=9999
      L=0
      N=NC
  30  KR=' '
      READ(LF,'(A80)',ERR=31,END=31)KR
      IF(KR(1:4).NE.'ATOM'.AND.KR(1:6).NE.'HETATM')GOTO 30
      IF(KR(27:27).NE.' ')GOTO 30
      IF(KR(22:22).NE.KC)GOTO 30
      IF(KR(17:17).NE.' '.AND.KR(17:17).NE.'A')GOTO 30
      KR(17:17)=' '
      N=N+1
      IF(N.GT.MA)GOTO 133
      READ(KR,'(12X,2A4,2X,I4,4X,3F8.4,6X,F6.3)')KA(N),KE(N),IR(N),
     +XO(N),YO(N),ZO(N),B(N)
      K=MIN0(IR(N),K)
      L=MAX0(IR(N),L)
      GOTO 30
  31  IF(K.LE.L)GOTO 33
      CLOSE(LF,IOSTAT=I)
      WRITE(*,'(/A/)')' ** No residues stored for current chain **'
  32  WRITE(*,FMT)' Enter ''Q'' to exit, <CR> to read new PDB file: '
      KR=' '
      READ(*,'(A)',ERR=32,END=32)KR
      CALL LINTRM(KR,I)
      IF(I.EQ.0)GOTO 24
      IF(KR(I:I).EQ.'Q'.OR.KR(I:I).EQ.'q')GOTO 134
      IF(KR(I:I).EQ.'E'.OR.KR(I:I).EQ.'e')GOTO 134
      GOTO 32
  33  WRITE(*,'(A,I5,A,I5)')' Min. and max. residue numbers '
     +//'stored temporarily are',K,' and',L
  34  KR=' '
      WRITE(KR,'(I5)')K
        DO 35 I=1,5
        IF(KR(I:I).NE.' ')GOTO 36
  35    CONTINUE
  36  WRITE(*,FMT)' Minimum residue number to be retained ['//
     +KR(I:5)//']: '
      KR=' '
      READ(*,'(A)',ERR=34,END=34)KR
      CALL LINTRM(KR,I)
      M=K
      IF(I.GT.0)READ(KR(1:I),*,ERR=34,END=34)M
  37  KR=' '
      WRITE(KR,'(I5)')M
        DO 38 I=1,5
        IF(KR(I:I).NE.' ')GOTO 39
  38    CONTINUE
  39  WRITE(*,FMT)' Corresponding SHELXPRO residue number ['//
     +KR(I:5)//']: '
      KR=' '
      READ(*,'(A)',ERR=34,END=34)KR
      CALL LINTRM(KR,I)
      K=M
      IF(I.GT.0)READ(KR(1:I),*,ERR=37,END=37)K
      NM=NC
      K=K-M
      L=9999
      M=0
        DO 41 I=NC+1,N
        J=IR(I)+K
        IF(J.LT.MIS)GOTO 41
        IF(J.GT.MAS)GOTO 41
        L=MIN0(J,L)
        M=MAX0(J,M)
        NM=NM+1
        IR(NM)=J
        XO(NM)=XO(I)
        YO(NM)=YO(I)
        ZO(NM)=ZO(I)
        B(NM)=B(I)
        KA(NM)=KA(I)
        KE(NM)=KE(I)
        IP(NM)=0
          DO 40 J=1,NC
          IF(IR(J).NE.IR(NM))GOTO 40
          IF(KA(J).NE.KA(NM))GOTO 40
          IP(NM)=J
          GOTO 41
  40      CONTINUE
  41    CONTINUE
      CLOSE(LF,IOSTAT=I)
      IF(KC.EQ.' ')WRITE(LO,17)NM-NC,L-K,M-K,' ',L,M
      IF(KC.NE.' ')WRITE(LO,17)NM-NC,L-K,M-K,' of chain '//KC,L,M
      WRITE(LO,'(A)')' SHELXPRO residue numbers used exclusively '//
     +'from now on'
      WRITE(*,'(I6,A/A/)')NM-NC,' reference model atoms stored.  '//
     +' SHELXPRO residue numbers will',' be used for all further '
     +//'calculations, output files and plots.'
C
C Define atoms to be fitted
C
  42  WRITE(KR,'(I8,A3,I8)')MIR,'$>$',MAR
      N=0
        DO 43 I=1,19
        IF(KR(I:I).EQ.' ')GOTO 43
        N=N+1
        KR(N:N)=KR(I:I)
        IF(KR(N:N).EQ.'$')KR(N:N)=' '
  43    CONTINUE
  44  WRITE(*,'(A)')' Residue numbers for fit (''m > n'' for m to n '
     +//'inclusive) ['//KR(1:N)//']:'
      WRITE(*,FMT)' '
      KT=' '
      READ(*,'(A)',ERR=44,END=44)KT
      CALL LINTRM(KT,I)
      IG(1)=MIR
      IG(2)=MAR
      L=2
      IF(I.EQ.0)GOTO 50
      L=0
      N=0
  45  K=0
      J=2
  46  N=N+1
      IF(N.GT.I)GOTO 49
      IF(KT(N:N).EQ.'>')J=0
      IF(KT(N:N).LT.'0'.OR.KT(N:N).GT.'9')GOTO 46
      K=ICHAR(KT(N:N))-ICHAR('0')
  47  N=N+1
      IF(N.GT.I)GOTO 48
      IF(KT(N:N).LT.'0'.OR.KT(N:N).GT.'9')GOTO 48
      K=10*K+ICHAR(KT(N:N))-ICHAR('0')
      GOTO 47
  48  IF(K.LT.MIR.OR.K.GT.MAR)GOTO 44
      L=L+J
      IF(L.EQ.0)GOTO 44
      IG(L)=K
      IF(J.EQ.2)IG(L-1)=K
      N=N-1
      GOTO 45
  49  IF(L.EQ.0)GOTO 44
  50  WRITE(*,'(A)')' Names of atoms to fit (must be same in both,'
     +//' <CR> for all):'
      WRITE(*,FMT)' '
      KR=' '
      READ(*,'(A)',ERR=44,END=44)KR
      CALL LINTRM(KR,N)
      IF(N.GT.78)GOTO 50
      IF(N.EQ.0)GOTO 52
        DO 51 I=1,79
        J=80-I
        IF(KR(J:J).GE.'a'.AND.KR(J:J).LE.'z')KR(J:J)=CHAR
     +  (ICHAR(KR(J:J))-LU)
        KR(J+1:J+1)=KR(J:J)
  51    CONTINUE
      KR(1:1)=' '
      N=N+2
      KR(N:N)=' '
  52  J=0
        DO 56 I=NC+1,NM
        IF(IP(I).EQ.0)GOTO 56
        IP(I)=-IABS(IP(I))
          DO 53 K=1,L,2
          IF(IR(I).GE.IG(K).AND.IR(I).LE.IG(K+1))GOTO 54
  53      CONTINUE
        GOTO 56
  54    IF(N.EQ.0)GOTO 55
        M=4
        IF(KA(I)(3:3).EQ.' ')M=3
        IF(INDEX(KR(1:N),KA(I)(1:M)).EQ.0)GOTO 56
  55    IP(I)=IABS(IP(I))
        J=J+1
  56    CONTINUE
      IF(J.GT.2)GOTO 58
      WRITE(*,'(/A/)')' ** Not enough atoms to fit **'
      GOTO 82
  57  FORMAT(/' Fitting ',A,' atoms from residues:'/1X,A)
  58  NIT=1
      CALL LINTRM(KT,I)
      IF(N.GT.0)GOTO 59
      WRITE(LO,57)'all',KT(1:I)
      GOTO 60
  59  WRITE(LO,57)'following',KT(1:I)
      WRITE(LO,'(A)')KR(1:N)
C
C Quaternion fit (Acta Cryst. A40 (1984) 165-6 with corrections)
C
  60    DO 61 I=1,20
        G(I)=0.
  61    CONTINUE
        DO 74 M=1,3
          DO 66 L=NC+1,NM
          J=IP(L)
          IF(J.LE.0)GOTO 66
          IF(M.NE.1)GOTO 62
          G(1)=G(1)+XO(L)
          G(2)=G(2)+YO(L)
          G(3)=G(3)+ZO(L)
          G(4)=G(4)+XO(J)
          G(5)=G(5)+YO(J)
          G(6)=G(6)+ZO(J)
          G(7)=G(7)+1.
          GOTO 66
  62      G(21)=XO(L)-G(1)
          G(22)=YO(L)-G(2)
          G(23)=ZO(L)-G(3)
          G(24)=XO(J)-G(4)
          G(25)=YO(J)-G(5)
          G(26)=ZO(J)-G(6)
          IF(M.NE.2)GOTO 64
          W=SQRT(G(21)**2+G(22)**2+G(23)**2)
            DO 63 I=21,23
            G(I+6)=G(I)+G(I+3)
            G(I+9)=G(I)-G(I+3)
  63        CONTINUE
          G(9)=G(9)+(G(28)**2+G(29)**2)*W
          G(10)=G(10)-W*G(27)*G(28)
          G(11)=G(11)+(G(27)**2+G(29)**2)*W
          G(12)=G(12)-W*G(27)*G(29)
          G(13)=G(13)-W*G(29)*G(28)
          G(14)=G(14)+(G(27)**2+G(28)**2)*W
          G(15)=G(15)+W*(G(32)*G(28)-G(31)*G(29))
          G(16)=G(16)+W*(G(30)*G(29)-G(32)*G(27))
          G(17)=G(17)+W*(G(31)*G(27)-G(30)*G(28))
          GOTO 66
  64      Q=0.
            DO 65 I=33,35
            G(I+9)=G(I)*G(21)+G(I+3)*G(22)+G(I+6)*G(23)
            Q=Q+(G(I+9)-G(I-9))**2
  65        CONTINUE
          G(8)=G(8)+Q
  66      CONTINUE
        IF(M.NE.1)GOTO 68
        W=1./AMAX1(G(7),0.0001)
          DO 67 I=1,3
          G(I)=G(I)*W
          G(I+3)=G(I+3)*W
  67      CONTINUE
  68    IF(M.NE.2)GOTO 74
C
C Solve equations
C
        IF(G(9).LT.0.0001)GOTO 132
        G(9)=1./SQRT(G(9))
        G(10)=G(10)*G(9)
        T=G(11)-G(10)**2
        IF(T.LT.0.0001)GOTO 132
        G(11)=1./SQRT(T)
        G(12)=G(12)*G(9)
        G(13)=G(11)*(G(13)-G(10)*G(12))
        G(15)=G(15)*G(9)
        G(16)=G(11)*(G(16)-G(10)*G(15))
        T=G(14)-G(13)**2-G(12)**2
        IF(T.LT.0.0001)GOTO 132
        G(17)=(G(17)-G(12)*G(15)-G(13)*G(16))/T
        G(16)=G(11)*(G(16)-G(17)*G(13))
        G(15)=G(9)*(G(15)-G(16)*G(10)-G(17)*G(12))
        T=G(15)**2+G(16)**2+G(17)**2
        Q=SQRT(T)
        IF(Q.LT.0.0001)GOTO 70
          DO 69 I=15,17
          G(I+3)=G(I)/Q
  69      CONTINUE
  70    S=1.+T
        T=2.*T/S
        S=2.*Q/S
        Q=1.-T
          DO 71 I=33,41,4
          G(I)=Q
  71      CONTINUE
        G(40)=S*G(18)
        G(38)=-G(40)
        G(35)=S*G(19)
        G(39)=-G(35)
        G(36)=S*G(20)
        G(34)=-G(36)
        K=33
          DO 73 I=18,20
            DO 72 J=18,20
            G(K)=G(K)+T*G(I)*G(J)
            K=K+1
  72        CONTINUE
  73      CONTINUE
  74    CONTINUE
      NIT=NIT+1
      IF(NIT.GT.4)GOTO 76
        DO 75 M=NC+1,NM
        U=XO(M)-G(1)
        V=YO(M)-G(2)
        W=ZO(M)-G(3)
        XO(M)=G(33)*U+G(36)*V+G(39)*W+G(4)
        YO(M)=G(34)*U+G(37)*V+G(40)*W+G(5)
        ZO(M)=G(35)*U+G(38)*V+G(41)*W+G(6)
  75    CONTINUE
      GOTO 60
  76  S=SQRT(G(8)/G(7))
  77  FORMAT(I6,' atoms fitted, r.m.s. deviation',F8.4,' Angstroms'
     +//' Deviations of atoms fitted greater than 2sigma:')
      WRITE(*,77)INT(G(7)),S
      WRITE(LO,77)INT(G(7)),S
      KR=' '
      L=-2
        DO 81 I=NC+1,NM
        J=IABS(IP(I))
        IF(J.EQ.0)GOTO 81
        D(I)=(XO(I)-XO(J))**2+(YO(I)-YO(J))**2+(ZO(I)-ZO(J))**2
        IF(IP(I).LT.0)GOTO 81
        T=SQRT(D(I))
        IF(T.LT.2.*S)GOTO 81
        IF(L.LT.60)GOTO 78
        WRITE(*,'(1X,A)')KR(1:L)
        WRITE(LO,'(1X,A)')KR(1:L)
        KR=' '
        L=-2
  78    L=L+2
        WRITE(KT,'(A,I5,A,F8.2)')KA(I)//'_'//KE(I),IR(I),'$',T
          DO 79 J=8,9
          IF(KT(J:J).GE.'A'.AND.KT(J:J).LE.'Z')KT(J:J)=CHAR
     +    (ICHAR(KT(J:J))+32)
  79      CONTINUE
          DO 80 J=1,23
          IF(KT(J:J).EQ.' ')GOTO 80
          IF(KT(J:J).EQ.'$')KT(J:J)=' '
          L=L+1
          KR(L:L)=KT(J:J)
  80      CONTINUE
  81    CONTINUE
      IF(L.LT.0)GOTO 82
      WRITE(*,'(1X,A)')KR(1:L)
      WRITE(LO,'(1X,A/)')KR(1:L)
  82  WRITE(*,'(/A)')' New current structure (C), new model (M), '//
     +'Repeat fit (R), write PDB file (P),'
      WRITE(*,FMT)' XP file (X), Postscript plot of differences'
     +//' (D) or exit (E) [E]: '
      KR=' '
      READ(*,'(A)',ERR=82,END=82)KR
      CALL LINTRM(KR,I)
      KC='E'
      IF(I.GT.0)KC=KR(I:I)
      IF(KC.EQ.'e'.OR.KC.EQ.'E')GOTO 134
      IF(KC.EQ.'q'.OR.KC.EQ.'Q')GOTO 134
      IF(KC.EQ.'c'.OR.KC.EQ.'C')GOTO 1
      IF(KC.EQ.'m'.OR.KC.EQ.'M')GOTO 23
      IF(KC.EQ.'r'.OR.KC.EQ.'R')GOTO 42
      IF(KC.EQ.'p'.OR.KC.EQ.'P')GOTO 103
      IF(KC.EQ.'d'.OR.KC.EQ.'D')GOTO 110
      IF(KC.NE.'x'.AND.KC.NE.'X')GOTO 82
C
C Write file for XP
C
      KF(LN+1:LN+4)='.ort'
  83  WRITE(*,FMT)' Name of orthogonal coordinate file for XP ['
     +//KF(1:LN+4)//']: '
      KR=' '
      READ(*,'(A)',ERR=83,END=83)KR
      CALL LINTRM(KR,N)
      L=0
        DO 84 I=1,N
        IF(KR(I:I).EQ.' ')GOTO 84
        L=L+1
        KR(L:L)=KR(I:I)
  84    CONTINUE
      IF(L.GT.0)GOTO 86
      KR=KF
      L=LN+4
      GOTO 87
  85  WRITE(*,'(/A/)')' ** Cannot open file '//KR(1:L)//' **'
      GOTO 83
  86  IF(INDEX(KR,'.').NE.0)GOTO 87
      L=L+4
      KR(L-3:L)='.ort'
  87  CALL WROPEN(LF,KR,L,I)
      IF(I.NE.0)GOTO 85
      WRITE(LF,'(A/A/A/A)')'TITL L.S. FIT','CELL 1','SFAC C H N O S',
     +'PART 1'
  88  WRITE(*,FMT)' Offset to add to residue numbers for model '//
     +'[1000]: '
      KR=' '
      READ(*,'(A)',ERR=88,END=88)KR
      CALL LINTRM(KR,I)
      N=1000
      IF(I.GT.0)READ(KR(1:I),*,ERR=88,END=88)N
      M=0
        DO 90 I=1,NM
        L=IABS(IR(I))
        IF(I.GT.NC)L=L+N
        IF(L.EQ.M)GOTO 89
        M=L
        WRITE(LF,'(A,I7,2X,A)')'RESI',L,KE(I)(2:4)
  89    J=6
        IF(KA(I)(1:2).EQ.' C')J=1
        IF(KA(I)(1:2).EQ.' H')J=2
        IF(KA(I)(1:2).EQ.' N')J=3
        IF(KA(I)(1:2).EQ.' O')J=4
        IF(KA(I)(1:2).EQ.' S')J=5
        K=2
        IF(KA(I)(1:1).NE.' ')K=1
        WRITE(LF,'(A,I3,3F9.5)')KA(I)(K:4),J,XO(I),YO(I),ZO(I)
        IF(I.EQ.NC)WRITE(LF,'(A)')'PART 2'
  90    CONTINUE
      WRITE(LF,'(A/A)')'FMOL/N CA','MPLN/N'
        DO 96 I=MIS,MAS-1
          DO 91 J=1,NC
          IF(KA(J).NE.' CA ')GOTO 91
          IF(IABS(IR(J)).EQ.I)GOTO 92
  91      CONTINUE
        GOTO 96
  92      DO 93 J=1,NC
          IF(KA(J).NE.' CA ')GOTO 93
          IF(IABS(IR(J)).EQ.I+1)GOTO 94
  93      CONTINUE
        GOTO 96
  94    WRITE(KR,'(A,I6,A,I6)')'JOIN$CA_',I,'$CA_',I+1
        L=4
          DO 95 J=5,24
          IF(KR(J:J).EQ.' ')GOTO 95
          IF(KR(J:J).EQ.'$')KR(J:J)=' '
          L=L+1
          KR(L:L)=KR(J:J)
  95      CONTINUE
        WRITE(LF,'(A)')KR(1:L)
  96    CONTINUE
        DO 102 I=MIS,MAS-1
          DO 97 J=NC+1,NM
          IF(KA(J).NE.' CA ')GOTO 97
          IF(IABS(IR(J)).EQ.I)GOTO 98
  97      CONTINUE
        GOTO 102
  98      DO 99 J=NC+1,NM
          IF(KA(J).NE.' CA ')GOTO 99
          IF(IABS(IR(J)).EQ.I+1)GOTO 100
  99      CONTINUE
        GOTO 102
 100    WRITE(KR,'(A,I6,A,I6,A)')'LINK$CA_',I+N,'$CA_',I+N+1,'$5'
        L=4
          DO 101 J=5,26
          IF(KR(J:J).EQ.' ')GOTO 101
          IF(KR(J:J).EQ.'$')KR(J:J)=' '
          L=L+1
          KR(L:L)=KR(J:J)
 101      CONTINUE
        WRITE(LF,'(A)')KR(1:L)
 102    CONTINUE
      WRITE(LF,'(A)')'END '
      CLOSE(LF,IOSTAT=I)
      WRITE(*,'(4(/A))')' XP file written with the two models'//
     +' as PART 1 and PART 2, and CA atoms only',
     +' (with CA-CA ''bonds'') in current FMOL list. A new FMOL/N'//
     +' instruction is needed',' to obtain all atoms, or FMOL/N '//
     +'PART2 to obtain the just the model positioned',
     +' in the unitcell of the fitted structure.'
      GOTO 82
C
C Write PDB file
C
 103  WRITE(*,FMT)' Name of PDB file to be written [fit.pdb]: '
      KR=' '
      READ(*,'(A)',ERR=103,END=103)KR
      CALL LINTRM(KR,N)
      L=0
        DO 104 I=1,N
        IF(KR(I:I).EQ.' ')GOTO 104
        L=L+1
        KR(L:L)=KR(I:I)
 104    CONTINUE
      IF(L.GT.0)GOTO 106
      KR='fit.pdb'
      L=7
      GOTO 107
 105  WRITE(*,'(/A/)')' ** Cannot open file '//KR(1:L)//' **'
      GOTO 103
 106  IF(INDEX(KR,'.').NE.0)GOTO 107
      L=L+4
      KR(L-3:L)='.pdb'
 107  CALL WROPEN(LF,KR,L,I)
      IF(I.NE.0)GOTO 105
        DO 108 I=1,NX
        CALL LINTRM(KB(I),L)
        WRITE(LF,'(A)')KB(I)(1:L)
 108    CONTINUE
      T=1.
      J=0
        DO 109 I=1,NM
        J=J+1
        KC='A'
        IF(I.GT.NC)KC='B'
        WRITE(LF,'(A4,I7,1X,2A4,1X,A1,I4,4X,3F8.3,F6.3,F6.2)')'ATOM',
     +  J,KA(I),KE(I),KC,IR(I),XO(I),YO(I),ZO(I),T,B(I)
        IF(I.NE.NC)GOTO 109
        J=J+1
        WRITE(LF,'(A,I9)')'TER',J
 109    CONTINUE
      WRITE(LF,'(A)')'END'
      CLOSE(LF,IOSTAT=I)
      GOTO 82
C
C Postscript plots of differences against residue number
C
 110  NPG=NPG+1
      WRITE(LP,'(/A,2I5/A)')'%%Page:',NPG,NPG,'/XSave save def'
      IY=400
 112  WRITE(*,FMT)' Vertical scale in inch/A (plot is'
     +//' 3.0" high) and step in A [1.0 0.5]: '
      KR=' '
      READ(*,'(A)',ERR=112,END=112)KR
      CALL LINTRM(KR,L)
      SC=1.
      SS=0.5
      IF(L.GT.0)READ(KR(1:L),*,ERR=112,END=112)SC,SS
      SC=100.*SC
      JY=700
      WRITE(*,FMT)' Title for plot: '
      KR=' '
      READ(*,'(A)')KR
      CALL LINTRM(KR,L)
      IF(L.GT.0)WRITE(LO,'(/A)')' Plot title: '//KR(1:L)
      IF(L.GT.0)WRITE(LP,'(A/A,I4,A)')'('//KR(1:L)//')',
     +' 15 330',JY+12,' P'
      WRITE(LP,'(A,I4,A,I4,A)')'3 W C7 110',IY,' 550 ',JY,' B C0 1 W'
C
C Label axes
C
      T=0.
 113  K=IY+T*SC
      WRITE(KR,'(A,F4.1)')'(',T
      IF(KR(3:3).EQ.' ')KR(3:3)='0'
      WRITE(LP,'(A,I4,A,I4,A,I4,A)')KR(1:5)//') 12 90',K,
     +' P 2 W 106',K,' 109',K,' L 1 W'
      T=T+SS
      IF(T.LT.9.9.AND.T*SC.LT.300.1)GOTO 113
      WRITE(LP,'(A,I4,A)')'(Rms deviation in Angstroms)'//' 15 73',
     +(IY+JY)/2,' Q 2 W'
 114  KR=' '
      WRITE(KR,'(2I5)')MIR,MAR
        DO 115 I=1,5
        IF(KR(I:I).NE.' ')GOTO 116
 115    CONTINUE
 116    DO 117 J=6,10
        IF(KR(J:J).NE.' ')GOTO 118
 117    CONTINUE
 118  WRITE(*,FMT)' First and last SHELXPRO residue numbers for plot'
     +//' ['//KR(I:5)//' '//KR(J:10)//']: '
      KR=' '
      READ(*,'(A)',ERR=114,END=114)KR
      CALL LINTRM(KR,I)
      MIT=MIR
      MAT=MAR
      IF(I.GT.0)READ(KR(1:I),*,ERR=114,END=114)MIT,MAT
 119  WRITE(*,FMT)' Offset from SHELXPRO residue '//
     +'numbers for labeling axis [0]: '
      KR=' '
      READ(*,'(A)',ERR=119,END=119)KR
      CALL LINTRM(KR,I)
      J=0
      IF(I.GT.0)READ(KR(1:I),*,ERR=119,END=119)J
      U=430./REAL(MAX0(MAT-MIT,1))
      K=10*MAX0(1,((MAT-MIT)/50))
        DO 121 M=K*((MIT+J)/K+1),MAT+J,K
        V=U*REAL(M-MIT-J)+115.
        WRITE(KR,'(A,I5)')'(',M
        L=0
          DO 120 I=1,6
          IF(KR(I:I).EQ.' ')GOTO 120
          L=L+1
          KR(L:L)=KR(I:I)
 120      CONTINUE
        WRITE(LP,'(A,F7.2,I4,A,2(F7.2,I4),A)')KR(1:L)//') 12',V,
     +  IY-15,' P',V,IY-1,V,IY-5,' L'
 121    CONTINUE
      WRITE(LP,'(A)')'C1 1 W'
C
C Plot curve
C
 122  WRITE(*,'(A)')' Atom names for calculating rms deviation '
     +//'(SC for side-chain, <CR> for all): '
      WRITE(*,FMT)' '
      READ(*,'(A)',ERR=122,END=122)KR
      CALL LINTRM(KR,L)
      IF(L.GT.78)GOTO 122
      WRITE(LO,'(/A/)')' Rms and individual deviations in Angstroms'
     +//' (long atom lists truncated)'
      IF(L.EQ.0)GOTO 124
        DO 123 I=1,79
        J=80-I
        IF(KR(J:J).GE.'a'.AND.KR(J:J).LE.'z')KR(J:J)=CHAR
     +  (ICHAR(KR(J:J))-32)
        KR(J+1:J+1)=KR(J:J)
 123    CONTINUE
      KR(1:1)=' '
      L=L+2
      KR(L:L)=' '
 124    DO 131 M=MIT,MAT
        KG=' '
        N=0
        K=0
        T=0.
        S=0.
          DO 129 I=NC+1,NM
          IF(IR(I).NE.M)GOTO 129
          J=IABS(IP(I))
          IF(J.EQ.0)GOTO 129
          IF(L.EQ.0)GOTO 127
          IF(KE(I).EQ.KE(J))GOTO 125
          IF(KA(I).NE.' N  '.AND.KA(I).NE.' CA '.AND.KA(I).NE.' C  '
     +    .AND.KA(I).NE.' O  '.AND.KA(I).NE.' CB ')GOTO 129
 125      IF(INDEX(KR,' SC ').EQ.0)GOTO 126
          IF(KA(I).NE.' N  '.AND.KA(I).NE.' CA '.AND.KA(I).NE.' C  '
     +    .AND.KA(I).NE.' O  ')GOTO 127
 126      J=4
          IF(KA(I)(3:3).EQ.' ')J=3
          IF(INDEX(KR,KA(I)(1:J)).EQ.0)GOTO 129
 127      T=T+1.
          S=S+D(I)
          WRITE(KT,'(A,I5,A,F9.2)')KE(I)//'_',IR(I),KA(I)//'$',
     +    SQRT(D(I))
          IF(KT(20:21).EQ.' 0')KT(21:21)=' '
          IF(N.GT.62)GOTO 129
          N=N+1
            DO 128 J=11,24
            IF(KT(J:J).EQ.' ')GOTO 128
            IF(KT(J:J).EQ.'$')KT(J:J)=' '
            N=N+1
            KG(N:N)=KT(J:J)
 128        CONTINUE
 129      CONTINUE
        IF(T.LT.0.5)GOTO 131
        S=SQRT(S/T)
        WRITE(KT(11:23),'(A,F10.3,A)')'$$',S,'$'
        K=0
          DO 130 J=1,23
          IF(KT(J:J).EQ.' ')GOTO 130
          IF(KT(J:J).EQ.'$')KT(J:J)=' '
          K=K+1
          KT(K:K)=KT(J:J)
 130      CONTINUE
        KC=KT(2:2)
        KT(2:2)=CHAR(ICHAR(KC)+LU)
        KC=KT(3:3)
        KT(3:3)=CHAR(ICHAR(KC)+LU)
        WRITE(LO,'(1X,A)')KT(1:K)//KG(1:N)
        KC='2'
        IF(COL(2:2).EQ.'f')KC='0'
        S=AMIN1(300.,SC*S)+REAL(IY)
        V=U*REAL(M-MIR)+115.
        IF(M.GT.MIR)WRITE(LP,'(4F7.2,A)')V-U,W,V,S,' L'
        W=S
 131    CONTINUE
      WRITE(LP,'(A,I4,A)')'C0 (Residue number) 15 330',IY-30,' P'
      WRITE(LP,'(A)')'showpage XSave restore'
      GOTO 82
 132  WRITE(*,'(/A/)')' ** Bad fit **'
      GOTO 82
 133  WRITE(*,'(/A/)')' ** Too many atoms read **'
      CLOSE(LF,IOSTAT=I)
 134  RETURN
      END
C
C -------------------------------------------------------------------
C
      SUBROUTINE NEWPDB(MX,X,Y,Z,OC,B,FV,A)
C
C Read SHELXL .ins or .res file or any PDB format file and generate
C a new PDB format file, e.g. for input to AMoRe or least-squares
C fitting with SHELXPRO.  In addition to general tidying-up, the
C B-values may be replaced by typical values and extra copies of a
C monomer may be generated using specified symmetry operations.
C This subroutine is also used for the generation of DFIX and DANG
C restraints from .ins, .res, PDB or CSD files.
C
      COMMON/XTAL/SY(12,192),CELL(15),II(1369),NS,LAT,LU,LN,
     +LO,LP,LF,LM,LS,NOS,IER,NPG
      COMMON/WORD/KF,KR,KD,KE,KA,KB,KN,FMT,COL,OPT
      CHARACTER KF*80,KR*80,KD(462)*52,KA(50000)*4,KE(9999)*4,KG*9,
     +KSP*12,KB(250)*80,KN(10000)*9,FMT*20,COL*4,OPT*1,KQ*4,KK*4,
     +KH*1,KW*1,KU*1,KY*1,KZ*1,KI(69)*4,KO(20)*3,TX(3)*15,KJ*1,KL*1
      INTEGER IJ(9)
      REAL A(512),X(MX),Y(MX),Z(MX),OC(MX),B(MX),FV(MX),D(12),E(12)
C
      DATA KI/'ABSC','ACTA','AFIX','AFLS','ANIS','BASF','BIND','BLOC',
     +'BOND','BUMP','CGLS','CHIV','CONF','CONN','DAMP','DANG','DEFS',
     +'DELU','DFIX','DISP','EADP','EQIV','ESEL','EXTI','EXYZ','FACE',
     +'FLAT','FMAP','FREE','GRID','HFIX','HOPE','HTAB','ILSF','ISOR',
     +'LATT','LIST','L.S.','MERG','MOLE','MORE','MOVE','MPLA','NCSY',
     +'OMIT','PLAN','RTAB','SADI','SAME','SHEL','SIMU','SIZE','SLIM',
     +'SPEC','SPIN','STIR','SUMP','SWAT','SYMM','TEMP','TIME','TITL',
     +'TWIN','UNDO','UNIT','WGHT','WPDB','ZERR','    '/
      DATA KO/'ALA','ARG','ASN','ASP','CYS','GLN','GLU','GLY','HIS',
     +'ILE','LEU','LYS','MET','PHE','PRO','SER','THR','TRP','TYR',
     +'VAL'/
C
C Set up input file
C
   1  KR='), CSD .dat (C)'
      L=15
      IF(OPT.NE.'J')L=1
      WRITE(*,FMT)' Read PDB (P'//KR(1:L)//' or SHELX .ins or .res '
     +//'(S) file [S]: '
      KR=' '
      READ(*,'(A)',ERR=1,END=1)KR
      CALL LINTRM(KR,N)
      KJ='S'
      IF(N.GT.0)KJ=KR(N:N)
      IF(KJ.EQ.'s')KJ='S'
      IF(KJ.EQ.'p')KJ='P'
      IF(KJ.EQ.'c')KJ='C'
      IF(KJ.NE.'C')GOTO 2
      IF(OPT.NE.'J')GOTO 1
      KF(LN+1:LN+4)='.dat'
      GOTO 3
   2  KF(LN+1:LN+4)='.pdb'
      IF(KJ.EQ.'P')GOTO 3
      KF(LN+1:LN+4)='.res'
      IF(KJ.NE.'S')GOTO 1
   3  WRITE(*,FMT)' Name of file to read ['//KF(1:LN+4)//']: '
      KR=' '
      READ(*,'(A)',ERR=3,END=3)KR
      CALL LINTRM(KR,N)
      L=0
        DO 4 I=1,N
        IF(KR(I:I).EQ.' ')GOTO 4
        L=L+1
        KR(L:L)=KR(I:I)
   4    CONTINUE
      IF(L.GT.0)GOTO 5
      KR=KF
      L=LN+4
      GOTO 6
   5  IF(INDEX(KR(1:L),'.').NE.0)GOTO 6
      L=L+4
      KR(L-3:L)='.res'
      IF(KJ.EQ.'P')KR(L-3:L)='.pdb'
      IF(KJ.EQ.'C')KR(L-3:L)='.dat'
   6  OPEN(UNIT=LF,FILE=KR(1:L),STATUS='OLD',ERR=153)
C
C Specify modifications to atom list
C
      KU='N'
      KH='Y'
      KZ='Y'
      KW='A'
      UT=99999.
      IF(OPT.EQ.'J')GOTO 14
   7  WRITE(*,FMT)' Replace B-values with standard values '//
     +'(Y or N) ? [N]: '
      KR=' '
      READ(*,'(A)',ERR=7,END=7)KR
      CALL LINTRM(KR,N)
      IF(N.GT.0)KU=KR(N:N)
      IF(KU.EQ.'n')KU='N'
      IF(KU.EQ.'y')KU='Y'
      IF(KU.NE.'N'.AND.KU.NE.'Y')GOTO 7
   8  WRITE(*,FMT)' Remove hydrogen atoms (Y or N) ? [Y]: '
      KR=' '
      READ(*,'(A)',ERR=8,END=8)KR
      CALL LINTRM(KR,N)
      IF(N.GT.0)KH=KR(N:N)
      IF(KH.EQ.'n')KH='N'
      IF(KH.EQ.'y')KH='Y'
      IF(KH.NE.'N'.AND.KH.NE.'Y')GOTO 8
   9  WRITE(*,FMT)' Reset PART 1 occ. to 1, delete other'//
     +' disorder components (Y or N) ? [Y]: '
      KR=' '
      READ(*,'(A)',ERR=9,END=9)KR
      CALL LINTRM(KR,N)
      IF(N.GT.0)KZ=KR(N:N)
      IF(KZ.EQ.'n')KZ='N'
      IF(KZ.EQ.'y')KZ='Y'
      IF(KZ.NE.'N'.AND.KZ.NE.'Y')GOTO 9
  10  WRITE(*,FMT)' Remove all residues except standard amino-'//
     +'acids (Y or N) ? [N]: '
      KR=' '
      READ(*,'(A)',ERR=10,END=10)KR
      CALL LINTRM(KR,N)
      KY='N'
      IF(N.GT.0)KY=KR(N:N)
      IF(KY.EQ.'n')KY='N'
      IF(KY.EQ.'y')KY='Y'
      IF(KY.NE.'N'.AND.KY.NE.'Y')GOTO 10
      IF(KY.EQ.'Y')GOTO 14
  11  WRITE(*,FMT)' Remove all waters (A), remove high-B waters '//
     +'(B) or keep all (K) ? [K]: '
      KR=' '
      READ(*,'(A)',ERR=11,END=11)KR
      CALL LINTRM(KR,N)
      KW='K'
      IF(N.GT.0)KW=KR(N:N)
      IF(KW.EQ.'b')KW='B'
      IF(KW.NE.'B')GOTO 13
  12  WRITE(*,FMT)' B (not U!) threshold to retain waters in '//
     +'PDB file [50]: '
      KR=' '
      READ(*,'(A)',ERR=12,END=12)KR
      CALL LINTRM(KR,N)
      UT=50.
      IF(N.GT.0)READ(KR(1:N),*,ERR=12,END=12)UT
      GOTO 14
  13  IF(KW.EQ.'a')KW='A'
      IF(KW.EQ.'k')KW='K'
      IF(KW.NE.'A'.AND.KW.NE.'K')GOTO 11
      IF(KW.EQ.'A')UT=-99999.
  14  KSP=' '
      IZ=0
      CELL(1)=-1.
      D(4)=-9.E9
      D(8)=-9.E9
      D(12)=-9.E9
      NX=0
      NF=0
      NT=0
      KG='        0'
      NP=0
      NJ=0
      BT=10.
      IF(KJ.EQ.'P')GOTO 52
      IF(KJ.NE.'C')GOTO 27
      GOTO 16
C
C Read CSD .dat file
C
  15  WRITE(*,FMT)' Entry not found - <CR> to try again, Q to quit: '
      KG=' '
      READ(*,'(A)',ERR=160,END=160)KG
      IF(INDEX(KG,'Q')+INDEX(KG,'q').NE.0)GOTO 160
  16  WRITE(*,FMT)' Enter refcode required (<CR> for first in '//
     +'file): '
      KG=' '
      READ(*,'(A)',ERR=16,END=16)KG
      CALL LINTRM(KG,L)
        DO 17 I=1,L
        KZ=KG(I:I)
        IF(KZ.GE.'a'.AND.KZ.LE.'z')KG(I:I)=CHAR(ICHAR(KZ)-32)
  17    CONTINUE
  18  KR=' '
      READ(LF,'(A)',ERR=15,END=15)KR
      IF(KR(1:1).NE.'#')GOTO 18
      IF(L.EQ.0)GOTO 19
      IF(KR(2:9).NE.KG(1:8))GOTO 18
  19  WRITE(*,'(/A)')' Reading CSD entry '//KR(2:9)
      READ(KR,'(44X,I3)',ERR=155,END=155)N
      KR=' '
      READ(LF,'(A)',ERR=155,END=155)KR
      CALL LINTRM(KR,L)
      READ(KR,'(6I6)',ERR=155,END=155)(IJ(I),I=1,6)
        DO 20 I=4,6
        READ(LF,'(A)',ERR=155,END=155)KR
        CELL(I-3)=0.001*REAL(IJ(I-3))
        IF(IJ(I).LT.181)IJ(I)=IJ(I)*100
        CELL(I)=0.01*REAL(IJ(I))
  20    CONTINUE
        DO 26 L=1,N,3
        KR=' '
        READ(LF,'(A)',ERR=155,END=155)KR
        K=1
          DO 25 J=L,MIN0(L+2,N)
          READ(KR(K:K+25),'(A4,1X,3I7)',ERR=155,END=155)KA(NX+1),
     +    IJ(1),IJ(2),IJ(3)
          IF(KA(NX+1)(1:1).NE.'H')GOTO 21
          IF(KA(NX+1)(2:2).LT.'A'.OR.KA(NX+1)(2:2).GT.'Z')GOTO 24
  21      NX=NX+1
          X(NX)=0.00001*REAL(IJ(1))
          Y(NX)=0.00001*REAL(IJ(2))
          Z(NX)=0.00001*REAL(IJ(3))
          OC(NX)=0.95
          KN(NX)='        0'
          KZ=KA(NX)(1:1)
          IF(KA(NX)(2:2).GE.'A'.AND.KA(N)(2:2).LE.'Z')GOTO 22
          IF(KZ.EQ.'B'.OR.KZ.EQ.'C'.OR.KZ.EQ.'N'.OR.KZ.EQ.'O'.OR.
     +    KZ.EQ.'F')GOTO 24
          OC(NX)=1.25
          IF(KZ.EQ.'P'.OR.KZ.EQ.'S')GOTO 24
          OC(NX)=1.45
          IF(KZ.EQ.'I')GOTO 24
          GOTO 23
  22      OC(NX)=0.95
          IF(KA(NX)(1:2).EQ.'BE')GOTO 24
          OC(NX)=1.30
          IF(KA(NX)(1:2).EQ.'CL'.OR.KA(NX)(1:2).EQ.'SI')GOTO 24
          OC(NX)=1.35
          IF(KA(NX)(1:2).EQ.'GA'.OR.KA(NX)(1:2).EQ.'GE'.OR.
     +    KA(NX)(1:2).EQ.'SE'.OR.KA(NX)(1:2).EQ.'BR')GOTO 24
          OC(NX)=1.45
          IF(KA(NX)(1:2).EQ.'IN'.OR.KA(NX)(1:2).EQ.'SN'.OR.
     +    KA(NX)(1:2).EQ.'AS'.OR.KA(NX)(1:2).EQ.'TE')GOTO 24
  23      OC(NX)=1.55
  24      K=K+27
  25      CONTINUE
  26    CONTINUE
      GOTO 64
C
C Read line from .res or .ins file
C
  27  KR=' '
      READ(LF,'(A)',ERR=64,END=64)KR
      IF(KR(1:1).EQ.'+')GOTO 27
      I=INDEX(KR,'!')
      IF(I.GT.0)KR(I+1:80)=' '
      CALL LINTRM(KR,N)
        DO 28 I=1,N
        IF(KR(I:I).GE.'a'.AND.KR(I:I).LE.'z')KR(I:I)=CHAR
     +  (ICHAR(KR(I:I))-LU)
  28    CONTINUE
      IF(N.LT.80)KR(N+1:80)=' '
      IF(KR(1:4).EQ.'REM ')GOTO 27
      CALL INSLIN(A,NA,KK,KQ)
      IF(IER.NE.0)GOTO 159
C
C Interpret CELL and derive conversion factors
C
      IF(KQ.NE.'CELL')GOTO 31
      IF(NA.NE.7)GOTO 159
        DO 29 I=1,6
        CELL(I)=A(I+1)
        IF(CELL(I).LT.0.1)GOTO 159
  29    CONTINUE
        DO 30 I=4,6
        Q=1.74533E-2*CELL(I)
        A(I-3)=SIN(Q)
        A(I)=COS(Q)
  30    CONTINUE
      Q=1./(3.+6.*A(4)*A(5)*A(6)-3.*(A(4)**2+A(5)**2+A(6)**2))
      CELL(7)=Q*A(1)**2
      CELL(8)=Q*A(2)**2
      CELL(9)=Q*A(3)**2
      CELL(10)=2.*Q*A(2)*A(3)*A(4)
      CELL(11)=2.*Q*A(3)*A(1)*A(5)
      CELL(12)=2.*Q*A(1)*A(2)*A(6)
      GOTO 27
C
C Pick up space group from REM instruction if present
C
  31  IF(KR(1:16).NE.'REM SPACE GROUP ')GOTO 32
      KSP=KR(17:28)
      GOTO 27
C
C Interpret and store FVAR, SFAC, RESI and PART, skip FRAG...FEND
C
  32  IF(KQ.NE.'FVAR')GOTO 34
        DO 33 I=1,NA
        NF=NF+1
        FV(NF)=A(I)
  33    CONTINUE
      GOTO 27
  34  IF(KQ.NE.'SFAC')GOTO 37
      IF(NA.EQ.0)GOTO 35
      NT=NT+1
      KE(NT)=KK
      GOTO 27
  35  I=4
  36  I=I+1
      IF(I.GT.N)GOTO 27
      IF(KR(I:I).GT.'Z'.OR.KR(I:I).LT.'A')GOTO 36
      NT=NT+1
      KE(NT)=KR(I:I+1)//'  '
      IF(KR(I+1:I+1).NE.' ')I=I+1
      GOTO 36
  37  IF(KQ.NE.'RESI')GOTO 40
      IF(NA.LT.1)A(1)=0.
      N=INT(ABS(A(1))*1.00001)
      IF(KK.EQ.'H2O '.OR.KK.EQ.'WAT ')KK='HOH '
      IF(N.LT.1.OR.N.GT.9999)GOTO 158
      IF(KY.NE.'Y')GOTO 39
        DO 38 I=1,20
        IF(KK(1:3).EQ.KO(I))GOTO 39
  38    CONTINUE
      KK='?  '
  39  WRITE(KG,'(A3,A1,I5)')KK(1:3),' ',N
      GOTO 27
  40  IF(KQ.NE.'PART')GOTO 41
      NP=0
      IF(NA.GT.0)NP=INT(A(1)*1.00001)
      GOTO 27
  41  IF(KQ.NE.'FEND')GOTO 42
      NJ=1
      GOTO 27
  42  IF(KQ.NE.'FRAG')GOTO 43
      NJ=0
      GOTO 27
C
C Interpret atoms, ignore rest
C
  43  IF(KQ.EQ.'HKLF'.OR.KQ.EQ.'END '.OR.KQ.EQ.'LAUE')GOTO 64
      IF(NJ.NE.0)GOTO 27
        DO 44 I=1,69
        IF(KQ.EQ.KI(I))GOTO 27
  44    CONTINUE
      IF(NA.LT.4)GOTO 159
      IF(NA.GT.7.AND.NA.NE.11)GOTO 159
      IF(KG(1:1).EQ.'?')GOTO 27
      IF(NP.GT.1.AND.KZ.EQ.'Y')GOTO 27
      K=INT(1.0001*ABS(A(1)))
      IF(K.GT.NT)GOTO 157
      IF(KH.EQ.'Y'.AND.KE(K).EQ.'H   ')GOTO 27
      IF(KQ.EQ.'Q   '.AND.K.EQ.1)GOTO 27
      IF(NA.EQ.7)NA=6
        DO 45 I=2,NA
        J=INT(0.1*ABS(A(I))+0.5)
        IF(J.LT.1)GOTO 45
        IF(J.GT.NF)GOTO 156
        Q=SIGN(0.5,A(I)+5.)
        R=AMOD(A(I)+5.,10.)-10.*Q
        T=1.
        IF(J.GT.1)T=FV(J)
        A(I)=R*(Q+T-0.5)
  45    CONTINUE
      IF(NA.LT.5)A(5)=1.
      IF(NP.EQ.1.AND.KZ.EQ.'Y')A(5)=1.
      IF(NA.LT.6)A(6)=0.1
      IF(NA.NE.11)GOTO 47
      T=0.
        DO 46 I=6,11
        T=T+A(I)*CELL(I+1)
  46    CONTINUE
      A(6)=T
  47  T=78.956835*A(6)
      IF(A(6).LT.-0.2.AND.A(6).GT.-5.)GOTO 48
      BT=T
      GOTO 49
  48  T=ABS(BT*A(6))
  49  IF(KG(1:3).EQ.'HOH'.AND.T.GT.UT)GOTO 27
      NX=NX+1
      IF(NX.GT.MX)GOTO 154
      IF(NX.GT.10000)GOTO 154
      KA(NX)=KQ
      IF(KE(K)(2:2).EQ.' '.AND.OPT.NE.'J')KA(NX)=' '//KQ(1:3)
      KN(NX)=KG
      IF(KZ.NE.'Y'.AND.NP.NE.0)KN(NX)(4:4)=CHAR(NP+64)
      X(NX)=A(2)
      Y(NX)=A(3)
      Z(NX)=A(4)
      OC(NX)=A(5)
      B(NX)=T
      IF(OPT.NE.'J')GOTO 27
      OC(NX)=0.95
      IF(KE(K)(2:2).GE.'A'.AND.KE(K)(2:2).LE.'Z')GOTO 50
      IF(KE(K)(1:1).EQ.'B'.OR.KE(K)(1:1).EQ.'C'.OR.KE(K)(1:1).EQ.
     +'N'.OR.KE(K)(1:1).EQ.'O'.OR.KE(K)(1:1).EQ.'F')GOTO 27
      OC(NX)=1.25
      IF(KE(K)(1:1).EQ.'P'.OR.KE(K)(1:1).EQ.'S')GOTO 27
      OC(NX)=1.45
      IF(KE(K)(1:1).EQ.'I')GOTO 27
      GOTO 51
  50  OC(NX)=0.95
      IF(KE(K)(1:2).EQ.'BE')GOTO 27
      OC(NX)=1.30
      IF(KE(K)(1:2).EQ.'CL'.OR.KE(K)(1:2).EQ.'SI')GOTO 27
      OC(NX)=1.35
      IF(KE(K)(1:2).EQ.'GA'.OR.KE(K)(1:2).EQ.'GE'.OR.
     +KE(K)(1:2).EQ.'SE'.OR.KE(K)(1:2).EQ.'BR')GOTO 27
      OC(NX)=1.45
      IF(KE(K)(1:2).EQ.'IN'.OR.KE(K)(1:2).EQ.'SN'.OR.
     +KE(K)(1:2).EQ.'AS'.OR.KE(K)(1:2).EQ.'TE')GOTO 27
  51  OC(NX)=1.55
      GOTO 27
C
C Read PDB format file
C
  52  KR=' '
      READ(LF,'(A)',ERR=64,END=64)KR
      IF(KR(1:6).NE.'CRYST1')GOTO 54
      CALL LINTRM(KR,I)
      IF(I.LT.80)KR(I:80)=' '
      READ(KR,'(6X,3F9.3,3F7.2)',ERR=52,END=52)(CELL(I),I=1,6)
      KSP=KR(56:66)
        DO 53 I=1,3
        IF(CELL(I).LT.2.)GOTO 159
        IF(CELL(I+3).LT.20.)GOTO 159
        IF(CELL(I+3).GT.160.)GOTO 159
  53    CONTINUE
      READ(KR(67:70),*,ERR=52,END=52)IZ
      GOTO 52
  54  IF(KR(1:5).NE.'SCALE')GOTO 55
      READ(KR(6:6),'(I1)',ERR=52,END=52)N
      N=4*N-3
      READ(KR,'(10X,3F10.6,5X,F10.5)',ERR=52,END=52)D(N),D(N+1),
     +D(N+2),D(N+3)
      GOTO 52
  55  IF(KR(1:4).EQ.'ATOM')GOTO 56
      IF(KR(1:6).NE.'HETATM')GOTO 52
  56  IF(KR(18:20).EQ.'WAT'.OR.KR(18:20).EQ.'H2O')KR(18:20)='HOH'
      IF(KR(13:16).EQ.' W  '.AND.KR(18:20).EQ.'HOH')GOTO 52
      NX=NX+1
      IF(NX.GT.10000)GOTO 154
      IF(NX.GT.MX)GOTO 154
      READ(KR,'(12X,A4,A1,A3,1X,A5,4X,3F8.3,2F6.2)',ERR=63,END=63)
     +KA(NX),KN(NX)(4:4),KN(NX)(1:3),KN(NX)(5:9),X(NX),Y(NX),Z(NX),
     +OC(NX),B(NX)
      IF(KR(18:20).EQ.'HOH'.AND.B(NX).GT.UT)GOTO 62
      IF(KH.EQ.'Y'.AND.KA(NX)(1:2).EQ.' H')GOTO 62
      KG(1:4)=KA(NX)
      IF(OPT.NE.'J')GOTO 59
      IF(KG(1:1).NE.' ')GOTO 57
      KA(NX)=KG(2:4)//' '
      OC(NX)=0.95
      IF(KG(2:2).EQ.'B'.OR.KG(2:2).EQ.'C'.OR.KG(2:2).EQ.'N'.OR.
     +KG(2:2).EQ.'O'.OR.KG(2:2).EQ.'F')GOTO 59
      OC(NX)=1.25
      IF(KG(2:2).EQ.'P'.OR.KG(2:2).EQ.'S')GOTO 59
      OC(NX)=1.45
      IF(KG(2:2).EQ.'I')GOTO 59
      GOTO 58
  57  OC(NX)=0.95
      IF(KG(1:2).EQ.'BE')GOTO 59
      OC(NX)=1.30
      IF(KG(1:2).EQ.'CL'.OR.KG(1:2).EQ.'SI')GOTO 59
      OC(NX)=1.35
      IF(KG(1:2).EQ.'GA'.OR.KG(1:2).EQ.'GE'.OR.
     +KG(1:2).EQ.'SE'.OR.KG(1:2).EQ.'BR')GOTO 59
      OC(NX)=1.45
      IF(KG(1:2).EQ.'IN'.OR.KG(1:2).EQ.'SN'.OR.
     +KG(1:2).EQ.'AS'.OR.KG(1:2).EQ.'TE')GOTO 59
  58  OC(NX)=1.55
  59  IF(KZ.EQ.'N')GOTO 60
      IF(KN(NX)(4:4).EQ.' ')GOTO 60
      IF(KN(NX)(4:4).NE.'A')GOTO 62
      KN(NX)(4:4)=' '
      OC(NX)=1.
  60  IF(KY.NE.'Y')GOTO 52
        DO 61 I=1,20
        IF(KN(NX)(1:3).EQ.KO(I))GOTO 52
  61    CONTINUE
  62  NX=NX-1
      GOTO 52
C
C Finished reading input file.  Prompt for missing information.
C
  63  NX=NX-1
  64  CLOSE(LF,IOSTAT=I)
      WRITE(*,'(/I6,A/)')NX,' atoms stored'
      IF(D(4)+D(8)+D(12).LT.-99999.)GOTO 65
      IF(CELL(1).GT.0.)GOTO 71
      CELL(1)=D(1)
      CELL(2)=SQRT(D(2)**2+D(6)**2)
      CELL(3)=SQRT(D(3)**2+D(7)**2+D(11)**2)
      CELL(6)=AMOD(360.+57.29578*ATAN2(D(6),D(2)),360.)
      T=D(3)/CELL(3)
      CELL(5)=AMOD(360.+57.29578*ATAN2(SQRT(ABS(1.-T**2)),T),360.)
      T=(D(7)*D(6)+D(2)*D(3))/(CELL(2)*CELL(3))
      CELL(4)=AMOD(360.+57.29578*ATAN2(SQRT(ABS(1.-T**2)),T),360.)
      WRITE(*,'(A/6F9.2/)')' Cell calculated from SCALEn records:',
     +(CELL(I),I=1,6)
      GOTO 71
  65  IF(CELL(1).GT.0.)GOTO 68
  66  WRITE(*,FMT)' Enter unit-cell: '
      KR=' '
      READ(*,'(A)',ERR=66,END=66)KR(5:80)
      CALL INSLIN(A,NA,KK,KQ)
      IF(IER.NE.0)GOTO 66
      IF(NA.NE.6)GOTO 66
        DO 67 I=1,6
        CELL(I)=A(I)
  67    CONTINUE
      IF(D(4)+D(8)+D(12).GT.-99999.)GOTO 71
  68    DO 69 I=1,3
        IF(CELL(I).LT.0.1)GOTO 66
        IF(CELL(I+3).LT.0.1)GOTO 66
        Q=1.74533E-2*CELL(I+3)
        A(I)=SIN(Q)
        A(I+3)=COS(Q)
  69    CONTINUE
        DO 70 I=1,12
        D(I)=0.
  70    CONTINUE
      D(1)=1./CELL(1)
      D(2)=-A(6)/(CELL(1)*A(3))
      T=SQRT(1.+2.*A(4)*A(5)*A(6)-A(4)**2-A(5)**2-A(6)**2)
      D(3)=(A(4)*A(6)-A(5))/(T*CELL(1)*A(3))
      D(6)=1./(CELL(2)*A(3))
      D(7)=(A(5)*A(6)-A(4))/(T*CELL(2)*A(3))
      D(11)=A(3)/(T*CELL(3))
  71  IF(OPT.EQ.'J')GOTO 130
      IF(IZ.GT.0)GOTO 73
  72  WRITE(*,FMT)' Enter (integer) number of molecules per cell: '
      KR=' '
      READ(*,'(A)',ERR=72,END=72)KR
      READ(KR,*,ERR=72,END=72)IZ
      IF(IZ.LE.0)GOTO 72
  73  KR=' '
      KR(1:12)=KSP
      IF(KSP(1:1).NE.' ')GOTO 75
  74  WRITE(*,FMT)' Enter space group [P 21 21 21]: '
      KR=' '
      READ(*,'(A)',ERR=74,END=74)KR
      CALL LINTRM(KR,N)
      IF(N.EQ.0)KR='P 21 21 21'
      KL=KR(1:1)
      IF(KL.GE.'a'.AND.KL.LE.'z')KR(1:1)=CHAR(ICHAR(KL)-LU)
C
C Convert space group to PDB notation
C
  75  CALL LINTRM(KR,L)
        DO 76 N=1,L
        IF(KR(N:N).NE.' ')GOTO 77
  76    CONTINUE
      GOTO 74
  77  M=1
      KSP(1:1)=KR(N:N)//' '
        DO 78 I=N+1,L
        IF(KR(I:I).LT.'0'.OR.KR(I:I).GT.'9')GOTO 78
        M=M+1
        KR(M:M)=KR(I:I)
  78    CONTINUE
      KR(M+1:80)=' '
      KSP(3:12)=KR(2:11)
      IF(KSP(1:4).EQ.'R 32')KSP(4:5)=' 2'
      J=INDEX(KSP,'23  ')
      IF(J.NE.0)KSP(J:J+2)='2 3'
      J=INDEX(KSP,'13  ')
      IF(J.NE.0)KSP(J:J+2)='1 3'
      IF(N.LT.I+2)GOTO 79
      IF(KSP(3:3).NE.'3')GOTO 79
      J=INDEX(KSP,'12  ')
      IF(J.NE.0)KSP(J:J+3)=' 1 2'
      J=INDEX(KSP,'21  ')
      IF(J.NE.0)KSP(J:J+3)=' 2 1'
      GOTO 80
  79  J=INDEX(KSP,'22  ')
      IF(J.NE.0)KSP(J:J+3)=' 2 2'
      J=INDEX(KSP,'212  ' )
      IF(J.NE.0)KSP(J:J+4)=' 21 2'
      J=INDEX(KSP,'221  ' )
      IF(J.NE.0)KSP(J:J+4)=' 2 21'
      J=INDEX(KSP,'2121  ' )
      IF(J.NE.0)KSP(J:J+5)=' 21 21'
      J=INDEX(KSP,'32  ')
      IF(J.NE.0)KSP(J:J+3)=' 3 2'
C
C Convert orthogonal coordinates to fractional
C
  80  IF(KJ.NE.'P')GOTO 82
        DO 81 I=1,NX
        U=X(I)
        V=Y(I)
        X(I)=U*D(1)+V*D(2)+Z(I)*D(3)+D(4)
        Y(I)=U*D(5)+V*D(6)+Z(I)*D(7)+D(8)
        Z(I)=U*D(9)+V*D(10)+Z(I)*D(11)+D(12)
  81    CONTINUE
C
C Reset B-values to standard values
C
  82  IF(KU.NE.'Y')GOTO 89
        DO 88 I=1,NX
        KK=KA(I)
        KQ=KN(I)(1:3)//' '
        IF(KQ.NE.'PRO ')GOTO 83
        B(I)=20.
        IF(KK.EQ.' CG ')B(I)=30.
        GOTO 87
  83    IF(KQ.NE.'HIS '.AND.KQ.NE.'ILE '.AND.KQ.NE.'LEU '.AND.KQ.NE.
     +  'THR '.AND.KQ.NE.'VAL '.AND.KQ.NE.'PHE '.AND.KQ.NE.'PHE '
     +  .AND.KQ.NE.'TRP '.AND.KQ.NE.'TYR ')GOTO 84
        B(I)=25.
        IF(KQ.NE.'TYR ')GOTO 87
        IF(KK.EQ.' CZ '.OR.KK.EQ.' OH ')B(I)=30.
        GOTO 87
  84    IF(KQ.NE.'MET ')GOTO 85
        B(I)=27.
        IF(KK.EQ.' CE ')B(I)=40.
        GOTO 87
  85    IF(KQ.NE.'ARG '.AND.KQ.NE.'ASN '.AND.KQ.NE.'ASP '.AND.KQ.NE.
     +  'LYS '.AND.KQ.NE.'GLU '.AND.KQ.NE.'GLN ')GOTO 86
        B(I)=35.
        IF(KK.EQ.' CG ')B(I)=27.
        IF(KQ.NE.'ARG '.AND.KQ.NE.'LYS ')GOTO 87
        IF(KK.NE.' CG '.AND.KK.NE.' CD ')B(I)=45.
  86    IF(KQ.EQ.'CYS ')B(I)=20.
        IF(KQ.EQ.'SER ')B(I)=30.
  87    IF(KK.EQ.' N  '.OR.KK.EQ.' CA ')B(I)=16.
        IF(KK.EQ.' C  '.OR.KK.EQ.' O  '.OR.KK.EQ.' CB ')B(I)=20.
        IF(KK.EQ.' OT1'.OR.KK.EQ.' OT2')B(I)=40.
  88    CONTINUE
C
C Open .pdb file to write
C
  89  KF(LN+1:LN+4)='.pdb'
  90  WRITE(*,FMT)' PDB file to write (may be same as read) ['
     +//KF(1:LN+4)//']: '
      KR=' '
      READ(*,'(A)',ERR=90,END=91)KR
      CALL LINTRM(KR,I)
  91  L=0
        DO 92 I=1,80
        IF(KR(I:I).EQ.' ')GOTO 92
        L=L+1
        KR(L:L)=KR(I:I)
  92    CONTINUE
      IF(L.GT.0)GOTO 93
      KR=KF
      L=LN+4
      GOTO 94
  93  IF(INDEX(KR,'.').NE.0)GOTO 94
      L=L+4
      KR(L-3:L)='.pdb'
  94  CALL WROPEN(LF,KR,L,I)
      IF(I.NE.0)GOTO 153
C
C Write .pdb file headings
C
  95  WRITE(*,'(A)')' Name of protein for PDB file: '
      KR=' '
      READ(*,'(A)',ERR=95,END=95)KR
      CALL LINTRM(KR,N)
      IF(N.GT.70)GOTO 95
      IF(N.GT.0)WRITE(LF,'(A)')'COMPND    '//KR(1:N)
      WRITE(LF,'(A6,3F9.3,3F7.2,1X,A11,I4)')'CRYST1',(CELL(I),I=1,6),
     +KSP(1:11),IZ
        DO 96 I=4,12,4
        WRITE(LF,'(A5,I1,4X,3F10.6,5X,F10.5)')'SCALE',I/4,
     +  (D(J),J=I-3,I)
  96    CONTINUE
      NN=0
C
C Write monomers to PDB file, possibly symmetry transformed
C
      WRITE(*,'(A/A/A/)')' Now the atoms are written to the PDB '
     +//'file, starting with chains, followed',' by the '//
     +'remaining atoms. In both cases residues may be selected '//
     +'by number;',' symmetry transformations may also be applied.'
  97  WRITE(*,FMT)' Select chain (''$'' if chain ID blank, <CR> '
     +//'to exit): '
      KR=' '
      READ(*,'(A)',ERR=97,END=97)KR
      CALL LINTRM(KR,I)
      IF(I.EQ.0)GOTO 128
      KW=KR(I:I)
      IF(KW.EQ.'$')KW=' '
      IF(KW.GE.'a'.AND.KW.LE.'z')KW=CHAR(ICHAR(KW)-LU)
      NJ=9999
      NK=0
        DO 98 I=1,NX
        IF(KN(I)(5:5).NE.KW)GOTO 98
        READ(KN(I)(6:9),*,ERR=98,END=98)J
        NJ=MIN0(NJ,J)
        NK=MAX0(NK,J)
  98    CONTINUE
      IF(NJ.LE.NK)GOTO 100
      WRITE(*,'(/A/)')' ** No residues stored for current chain **'
  99  WRITE(*,FMT)' Enter ''Q'' to exit, <CR> to change chain: '
      KR=' '
      READ(*,'(A)',ERR=99,END=99)KR
      CALL LINTRM(KR,I)
      KH=' '
      IF(I.GT.0)KH=KR(I:I)
      IF(KH.EQ.'Q'.OR.KH.EQ.'q')GOTO 128
      IF(KH.EQ.'E'.OR.KH.EQ.'e')GOTO 128
      GOTO 97
 100  KH=KW
        DO 101 I=1,12
        E(I)=0.
 101    CONTINUE
      E(1)=1.
      E(5)=1.
      E(9)=1.
 102  WRITE(*,FMT)' New ID for this chain in PDB file ['//KH//']: '
      KR=' '
      READ(*,'(A)',ERR=102,END=102)KR
      CALL LINTRM(KR,I)
      IF(I.GT.0)KH=KR(I:I)
      IF(KH.GE.'a'.AND.KH.LE.'z')KH=CHAR(ICHAR(KH)-LU)
      WRITE(*,'(A)')' The symmetry operator may be specifed using '
     +//'decimals or fractions'
 103  WRITE(*,FMT)' Symmetry operator [x,y,z]: '
      KR=' '
      READ(*,'(A)',ERR=115,END=115)KR
      CALL LINTRM(KR,I)
      IF(I.GT.0)GOTO 104
      I=5
      KR='x,y,z'
C
C Decode symmetry operators
C
 104    DO 105 I=1,12
        E(I)=0.
 105    CONTINUE
      CALL LINTRM(KR,K)
      L=0
        DO 106 I=1,K
        IF(KR(I:I).EQ.' ')GOTO 106
        IF(KR(I:I).GE.'A'.AND.KR(I:I).LE.'Z')KR(I:I)=
     +  CHAR(ICHAR(KR(I:I))+32)
        L=L+1
        KR(L:L)=KR(I:I)
 106    CONTINUE
      J=INDEX(KR,',')
      IF(J.EQ.0)GOTO 115
      IF(J.GT.15)GOTO 115
      TX(1)='+'//KR(1:J-1)
      I=INDEX(KR(J+1:80),',')+J
      IF(I.EQ.J)GOTO 115
      IF(I-J.GT.15)GOTO 115
      TX(2)='+'//KR(J+1:I-1)
      IF(L-I.GT.14)GOTO 115
      TX(3)='+'//KR(I+1:L)
      M=1
        DO 114 I=1,3
        IF(INDEX(TX(I),'+x').NE.0)E(M)=1.
        IF(INDEX(TX(I),'-x').NE.0)E(M)=-1.
        IF(INDEX(TX(I),'+y').NE.0)E(M+1)=1.
        IF(INDEX(TX(I),'-y').NE.0)E(M+1)=-1.
        IF(INDEX(TX(I),'+z').NE.0)E(M+2)=1.
        IF(INDEX(TX(I),'-z').NE.0)E(M+2)=-1.
        M=M+3
        E(I+9)=0.
        J=INDEX(TX(I),'/')
        IF(J.EQ.0)GOTO 107
        READ(TX(I)(J-2:J+1),'(I2,1X,I1)')K,L
        E(I+9)=REAL(K)/REAL(L)
        GOTO 114
 107    J=0
 108    K=J
 109    J=J+1
        IF(J.GT.15)GOTO 112
        IF(TX(I)(J:J).EQ.'.')GOTO 110
        IF(TX(I)(J:J).LT.'0'.OR.TX(I)(J:J).GT.'9')GOTO 111
 110    IF(K.GT.0)GOTO 109
        GOTO 108
 111    IF(K.LE.0)GOTO 109
 112    J=J-1
        IF(K.LT.1)GOTO 114
        IF(INDEX(TX(I)(K:J),'.').EQ.0)GOTO 113
        READ(TX(I)(K:J),*,ERR=115,END=115)E(I+9)
        GOTO 114
 113    KR=TX(I)(K:J)//'.0'
        READ(KR(1:J-K+3),*,ERR=115,END=115)E(I+9)
 114    CONTINUE
      T=E(1)*(E(5)*E(9)-E(6)*E(8))+E(2)*(E(6)*E(7)-E(4)*E(9))+
     +E(3)*(E(4)*E(8)-E(5)*E(7))
      IF(ABS(ABS(T)-1.).LT.0.0001)GOTO 116
 115  WRITE(*,'(/A/)')' ** Illegal symmetry operator **'
      GOTO 103
 116  IF(T.GT.0.)GOTO 117
      WRITE(*,FMT)' Symmetry operator changes hand.  OK (Y or N) '
     +//'? [N]: '
      KR=' '
      READ(*,'(A)',ERR=116,END=116)KR
      CALL LINTRM(KR,L)
      IF(L.EQ.0)GOTO 103
      IF(KR(L:L).NE.'y'.AND.KR(L:L).NE.'Y')GOTO 103
 117  WRITE(KR,'(2I5)')NJ,NK
        DO 118 I=1,5
        IF(KR(I:I).NE.' ')GOTO 119
 118    CONTINUE
 119    DO 120 J=6,10
        IF(KR(J:J).NE.' ')GOTO 121
 120    CONTINUE
 121  WRITE(*,FMT)' First and last residues to process ['//KR(I:5)//
     +KR(J-1:10)//']: '
      KR=' '
      READ(*,'(A)',ERR=117,END=117)KR
      CALL LINTRM(KR,I)
      NI=NJ
      NP=NK
      IF(I.EQ.0)GOTO 122
      READ(KR(1:I),*,ERR=117,END=117)NI,NP
 122  WRITE(KR,'(I6)')NI
        DO 123 I=1,6
        IF(KR(I:I).NE.' ')GOTO 124
 123    CONTINUE
 124  WRITE(*,FMT)' New residue number for the first of these ['//
     +KR(I:6)//']: '
      KR=' '
      READ(*,'(A)',ERR=122,END=122)KR
      CALL LINTRM(KR,I)
      NH=NI
      IF(I.GT.0)READ(KR(1:I),*,ERR=122,END=122)NH
      NH=NH-NI
        DO 125 I=1,NX
        IF(KN(I)(5:5).NE.KW)GOTO 125
        READ(KN(I)(6:9),*,ERR=125,END=125)J
        IF(J.LT.NI.OR.J.GT.NP)GOTO 125
        K=J+NH
        IF(K.LT.0.OR.K.GT.9999)GOTO 129
 125    CONTINUE
      N=0
        DO 127 I=1,NX
        IF(KN(I)(5:5).NE.KW)GOTO 127
        KK=KN(I)(6:9)
        READ(KK,*,ERR=127,END=127)J
        IF(J.LT.NI.OR.J.GT.NP)GOTO 127
        WRITE(KK,'(I4)')J+NH
        KR=' '
        NN=NN+1
        W=(E(7)*X(I)+E(8)*Y(I)+E(9)*Z(I)+E(12)-D(12))/D(11)
        V=(E(4)*X(I)+E(5)*Y(I)+E(6)*Z(I)+E(11)-W*D(7)-D(8))/D(6)
        WRITE(KR,'(A6,I5,1X,A4,A1,A3,1X,A1,A4,4X,3F8.3,F6.3,F6.2)')
     +  'HETATM',NN,KA(I),KN(I)(4:4),KN(I)(1:3),KH,KK,
     +  (E(1)*X(I)+E(2)*Y(I)+E(3)*Z(I)+E(10)-V*D(2)-W*D(3)-D(4))
     +  /D(1),V,W,OC(I),B(I)
          DO 126 J=1,20
          IF(KO(J).EQ.KN(I)(1:3))KR(1:6)='ATOM  '
 126      CONTINUE
        CALL LINTRM(KR,J)
        WRITE(LF,'(A)')KR(1:J)
        N=N+1
 127    CONTINUE
      WRITE(*,'(I5,A)')N,' atoms written to PDB file'
      IF(KH.EQ.' ')GOTO 97
      NN=NN+1
      WRITE(LF,'(A,I8)')'TER',NN
      GOTO 97
 128  WRITE(LF,'(A)')'END'
      GOTO 161
 129  WRITE(*,'(A/)')' ** Would create residue outside '
     +//'range 0 to 9999, so no atoms written **'
      GOTO 117
C
C Analyse model - first strip out unwanted residues
C
 130  KG=KN(1)
        DO 131 I=1,NX
        IF(KN(I).NE.KG)GOTO 132
 131    CONTINUE
      GOTO 133
 132  WRITE(*,FMT)' More than one residue in model; specify '//
     +'residue number to be used: '
      KR=' '
      READ(*,'(A)',ERR=132,END=132)KR
      CALL LINTRM(KR,L)
      IF(L.EQ.0)GOTO 132
      READ(KR(1:L),*,ERR=132,END=132)N
      WRITE(KG,'(I9)')N
 133  N=0
        DO 134 I=1,NX
        IF(KN(I)(5:9).NE.KG(5:9))GOTO 134
        N=N+1
        X(N)=X(I)
        Y(N)=Y(I)
        Z(N)=Z(I)
        KA(N)=KA(I)
        KN(N)=KN(I)
        OC(N)=OC(I)
 134    CONTINUE
C
C Then orthogonalise coordinates
C
      IF(KJ.EQ.'P')GOTO 136
        DO 135 I=1,N
        Z(I)=Z(I)/D(11)
        Y(I)=(Y(I)-D(7)*Z(I))/D(6)
        X(I)=(X(I)-D(2)*Y(I)-D(3)*Z(I))/D(1)
 135    CONTINUE
 136    DO 137 I=N,1,-1
        X(I)=X(I)-X(1)
        Y(I)=Y(I)-Y(1)
        Z(I)=Z(I)-Z(1)
 137    CONTINUE
C
C Open file for DFIX and DANG output
C
      KF(LN+1:LN+4)='.dfx'
 138  WRITE(*,FMT)' File to write containing DFIX and DANG '//
     +'restraints ['//KF(1:LN+4)//']: '
      KR=' '
      READ(*,'(A)',ERR=138,END=138)KR
      CALL LINTRM(KR,L)
      IF(L.GT.0)GOTO 139
      KR=KF
      L=LN+4
      GOTO 140
 139  IF(INDEX(KR,'.').NE.0)GOTO 140
      L=L+4
      KR(L-3:L)='.dfx'
 140  CALL WROPEN(LF,KR,L,I)
      IF(I.EQ.0)GOTO 141
      KR=' '
      WRITE(*,FMT)' Cannot open file.  Enter ''Q'' to quit, <CR> '//
     +'to try again: '
      READ(*,'(A)',ERR=160,END=160)KR
      IF(INDEX(KR,'Q')+INDEX(KR,'q').EQ.0)GOTO 138
      GOTO 160
 141  KG=KN(1)(1:3)//'      '
      IF(KG(1:3).EQ.'   ')KG='TMP'
 142  WRITE(*,FMT)' (New) residue name for DFIX and DANG '//
     +'instructions ['//KG(1:3)//']: '
      KR=' '
      READ(*,'(A)',ERR=142,END=142)KR
      CALL LINTRM(KR,L)
      IF(L.GT.0)KG=KR(1:9)
C
C Generate DFIX and DANG restraints
C
        DO 144 I=1,N
          DO 143 J=I+1,N
          T=SQRT((X(I)-X(J))**2+(Y(I)-Y(J))**2+(Z(I)-Z(J))**2)
          IF(T.LE.OC(I)+OC(J))WRITE(LF,'(A,F6.3,2(1X,A))')
     +    'DFIX_'//KG(1:4),T,KA(I),KA(J)
 143      CONTINUE
 144    CONTINUE
      WRITE(LF,'(1X)')
        DO 147 I=1,N
          DO 146 J=1,N
          IF(J.EQ.I)GOTO 146
          S=SQRT((X(I)-X(J))**2+(Y(I)-Y(J))**2+(Z(I)-Z(J))**2)
          IF(S.GT.OC(I)+OC(J))GOTO 146
            DO 145 K=J+1,N
            IF(K.EQ.I)GOTO 145
            T=SQRT((X(I)-X(K))**2+(Y(I)-Y(K))**2+(Z(I)-Z(K))**2)
            IF(T.GT.OC(I)+OC(K))GOTO 145
            T=SQRT((X(J)-X(K))**2+(Y(J)-Y(K))**2+(Z(J)-Z(K))**2)
            IF(T.LT.OC(J)+OC(K))GOTO 145
            WRITE(LF,'(A,F6.3,2(1X,A))')'DANG_'//KG(1:4),T,KA(J),KA(K)
 145        CONTINUE
 146      CONTINUE
 147    CONTINUE
      WRITE(LF,'(1X)')
      CLOSE(LF,IOSTAT=I)
      WRITE(*,'(A,I6,A)')' DFIX and DANG restraints generated for',
     +N,' atoms'
C
C Open file for orthogonal fragment (for FRAG...FEND in SHELXL)
C
 148  WRITE(*,FMT)' File to write containing orthogonal '//
     +'fragment (<CR> for none): '
      KR=' '
      READ(*,'(A)',ERR=148,END=148)KR
      CALL LINTRM(KR,L)
      IF(L.EQ.0)GOTO 161
      IF(INDEX(KR,'.').NE.0)GOTO 149
      L=L+4
      KR(L-3:L)='.frg'
 149  CALL WROPEN(LF,KR,L,I)
      IF(I.EQ.0)GOTO 150
      KR=' '
      WRITE(*,FMT)' Cannot open file.  Enter ''Q'' to quit, <CR> '//
     +'to try again: '
      READ(*,'(A)',ERR=160,END=160)KR
      IF(INDEX(KR,'Q')+INDEX(KR,'q').EQ.0)GOTO 148
      GOTO 160
C
C Output orthogonal fragment
C
 150    DO 152 I=1,N
        J=5
        IF(KA(I)(2:2).GE.'A'.AND.KA(I)(2:2).LE.'Z')GOTO 151
        KZ=KA(I)(1:1)
        IF(KZ.EQ.'C')J=1
        IF(KZ.EQ.'H')J=2
        IF(KZ.EQ.'N')J=3
        IF(KZ.EQ.'O')J=4
 151    WRITE(LF,'(A,I3,3F10.5)')KA(I),J,X(I),Y(I),Z(I)
 152    CONTINUE
      GOTO 161
C
C Error messages and finish off
C
 153  WRITE(*,'(/A/)')' ** Cannot open file **'
      GOTO 160
 154  WRITE(*,'(/A)')' ** Too many atoms to be stored ** '
      GOTO 160
 155  WRITE(*,'(/A)')' ** Bad CSD input file **'
      GOTO 160
 156  CALL LINTRM(KR,I)
      WRITE(*,'(/1X,A//A)')KR(1:I),' ** Unset free variable **'
      GOTO 160
 157  CALL LINTRM(KR,I)
      WRITE(*,'(/1X,A//A)')KR(1:I),' ** SFAC number out of range **'
      GOTO 160
 158  CALL LINTRM(KR,I)
      WRITE(*,'(/1X,A//A)')KR(1:I),' ** Residue number out of range'//
     +' (possibly caused by chain offset) **'
      GOTO 160
 159  CALL LINTRM(KR,I)
      WRITE(*,'(/1X,A//A)')KR(1:I),' ** Error in input file **'
 160  IER=1
 161  CLOSE(LF,IOSTAT=I)
      RETURN
      END
