C
      PROGRAM SHELXD
C
C               Macromolecular direct methods
C               =============================
C
C  ** FORTRAN-95 - version 2006/3 - February 2006  **
C
C LM is the maximum number of atom plus peaks, all other variable
C working space is allocated dynamically. The maximum number of
C reflections may be set with the -L switch on the command line.
C
      PARAMETER(LM=100000)
      CHARACTER::KA(94)*2,NM*80,KF(60)*81
      INTEGER,ALLOCATABLE,DIMENSION(:)::IM,IN,IH,IK,IL,JH,JL,IW,IY,IZ
      REAL,ALLOCATABLE,DIMENSION(:)::FH,SH,AH,BH,DH,EH,AR,BR,RP,BP,CP
      INTEGER::IS(LM)
      REAL::A(596),QD(11),TMI(10),SC(12501),BT(6440),EF(940),ZW(10)
      REAL::XA(LM),YA(LM),ZA(LM),HA(LM)
      COMMON/FLAGS/ST,SL,LF,LI,LP,LR,LN,LZ,LY,LE,LW,LS,LV,LQ,JU,
     +LO,LG,LU,LX,NP,MP,JR,JS,JK,JW,FM,RM,PC,PP,HP,FW,PW,WX
      COMMON/SFAC/EF
      COMMON/ATSYM/KA
      COMMON/FILE/NM,KF
      COMMON/TIMS/TMI,ETI,NTI
C
C Start timing. ST = initial time, SL = time at last call,
C
      CALL SXTI(SL)
      ST=SL
      CALL SXTO(0)
      CALL SXTO(1)
C
C Set units for input reflection data (unit LF), printer output (to
C .lst, LI) and peaklist (.res file, LP).  LR defines the .ins file
C for instructions.
C
      LF=3
      LI=2
      LP=7
      LR=8
C
C CALL subroutine SXNM to get generic filename and amount of memory
C to be allocated for the reflection arrays, then allocate memory
C and OPEN files using standard extensions and output headings.
C JU will be set later to 1 by SXFN if .fin file is found and deleted,
C otherwise JU = 0. First any .fin file left over from a previous job
C has to be cleared.
C
      CALL SXNM(NM,LD)
      ALLOCATE(IM(LD),IN(LD),IH(LD),IK(LD),IL(LD),JH(LD),JL(LD),
     +IW(LD),IY(LD),IZ(LD),FH(LD),SH(LD),AH(LD),BH(LD),DH(LD),
     +EH(LD),AR(LD),BR(LD),RP(LD),BP(LD),CP(LD),STAT=I)
      IF(I.NE.0)CALL SXER('CANNOT ALLOCATE ENOUGH MEMORY')
      L=LN+4
      NM(LN+1:L)='    '
      IF(LN.EQ.0)GOTO 5
      NM(LN+1:L)='.lst'
      OPEN(UNIT=LI,FILE=NM(1:L),STATUS='OLD',IOSTAT=LW)
      CLOSE(UNIT=LI,STATUS='DELETE',IOSTAT=LW)
      OPEN(UNIT=LI,FILE=NM(1:L),STATUS='NEW',ERR=5)
      NM(LN+1:L)='    '
      CALL SXTL(NM)
      NM(LN+1:L)='.ins'
      OPEN(UNIT=LR,FILE=NM(1:L),STATUS='OLD',ERR=5)
      CALL SXFN
      JU=0
C
C CALL main subroutines
C
      CALL SX1A(LM,LD,IS,XA,YA,ZA,HA,BP,ZW,A)
      IF(LN.EQ.0)GOTO 1
      IF(LZ.LT.0)GOTO 1
      NM(LN+1:L)='.hkl'
      OPEN(UNIT=LF,FILE=NM(1:L),STATUS='OLD',ERR=5)
   1  CALL SX1B(LD,IM,IN,IH,IK,IL,FH,SH,DH,EH,AH,BH,
     +AR,BR,RP,BP,CP,QD,SC,BT,ZW,A)
   2  J=1
      CALL SX1C(LM,LD,IM,IN,IH,IK,IL,JH,JL,FH,SH,EH,AH,
     +BH,AR,BR,DH,RP,CP,BP,IS,XA,YA,ZA,HA,IW,IY,IZ,SC,BT,A)
      IF(A(63).GT.-0.01)GOTO 3
      J=0
      IF(PC.GT.FM)J=1
      IF(PP.GT.HP)J=1
      HP=AMAX1(PP,HP)
   3  FM=AMAX1(PC,FM)
      IF(J.EQ.0)GOTO 4
      IF(NINT(ABS(A(50))).EQ.0)GOTO 4
      CALL SX1E(LM,LD,IM,IN,IH,IK,IL,FH,SH,EH,AH,BH,
     +AR,BR,DH,RP,CP,BP,IS,XA,YA,ZA,HA,QD,SC,ZW,A)
   4  CALL SXFN
      J=NINT(A(111))
      IF(J.NE.0.AND.LO.GE.J)JU=1
      IF(JU.EQ.0)GOTO 2
      CALL SXEX
   5  WRITE(*,6)NM(1:L)
   6  FORMAT(/' ** CANNOT OPEN FILE ',A/)
      CALL EXIT(0)
      STOP' '
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXNM(NM,LD)
C
C Get generic filename (NM) and its length (LN) from the command
C line.  The the number of reflections that can be stored is set
C by the -L switch (e.g. -L1 would set the default LD=1000000).
C
      CHARACTER::NM*80,KR*80
      COMMON/FLAGS/ST,SL,LF,LI,LP,LR,LN,LZ,LY,LE,LW,LS,LV,LQ,JU,
     +LO,LG,LU,LX,NP,MP,JR,JS,JK,JW,FM,RM,PC,PP,HP,FW,PW,WX
C
      LD=1
        DO 3 J=1,IARGC()
        KR=' '
        CALL GETARG(J,KR)
        IF(KR(1:2).NE.'-l'.and.KR(1:2).NE.'-L')GOTO 1
        READ(KR(3:80),*,ERR=3,END=3)L
        LD=L
        GOTO 3
   1    LN=0
        NM=' '
          DO 2 I=1,80
          IF(KR(I:I).EQ.' ')GOTO 2
          LN=LN+1
          NM(LN:LN)=KR(I:I)
   2      CONTINUE
   3    CONTINUE
      IF(LD.GT.0.AND.LN.GT.0)GOTO 5
      WRITE(*,4)
      CALL EXIT(0)
      STOP' '
   4  FORMAT(/' ** BAD COMMAND LINE **'/)
   5  LD=1000000*LD
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXTL(NM)
C
C Output program heading and other useful information
C
      CHARACTER::NM*80,KD*8,KT*10,KZ*5,MON(12)*3
      INTEGER::IQ(8)
      COMMON/FLAGS/ST,SL,LF,LI,LP,LR,LN,LZ,LY,LE,LW,LS,LV,LQ,JU,
     +LO,LG,LU,LX,NP,MP,JR,JS,JK,JW,FM,RM,PC,PP,HP,FW,PW,WX
      DATA MON/'Jan','Feb','Mar','Apr','May','Jun','Jul','Aug',
     +'Sep','Oct','Nov','Dec'/
   1  FORMAT(/'  ',72('+')/'  +  SHELXD-2006/3 - MACROMOLECULAR ',
     +'DIRECT METHODS - FORTRAN-95 VERSION  +'/'  +  Copyright (C)  ',
     +'George M. Sheldrick 2000-2006',24X,'+'/'  +  ',A31,' started ',
     +'at ',A2,':',A2,':',A2,' on ',A2,1X,A3,1X,A4,'  +'/'  ',72('+')/)
      CALL DATE_AND_TIME(KD,KT,KZ,IQ)
      WRITE(LI,1)NM(1:31),KT(1:2),KT(3:4),KT(5:6),KD(7:8),
     +MON(IQ(2)),KD(1:4)
      WRITE(*,1)NM(1:31),KT(1:2),KT(3:4),KT(5:6),KD(7:8),
     +MON(IQ(2)),KD(1:4)
      JS=MOD(IQ(8)+1000*(IQ(7)+60*(IQ(6)+60*IQ(5))),139968)
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXTI(T)
C
C Set T to the CPU (or elapsed) time used so far in seconds (not
C necessarily zero at the start of SHELXD).  If timing information
C is not available, this subroutine should set T to -1. Since CPU_TIME
C is technically FORTRAN-95 and not implemented in all FORTRAN-90
C compilers, the alternative ETIME (common in UNIX systems) may be used
C instead. One of the two should be commented out.
C
      CALL CPU_TIME(T)
C
C     REAL::ET(2)
C     T=ETIME(ET)
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXTO(N)
C
C Sum times for different operations
C
      REAL::TMI(10)
      COMMON/TIMS/TMI,ETI,NTI
      IF(N.GT.0)GOTO 2
      NTI=0
      ETI=0.
        DO 1 I=1,10
        TMI(I)=0.
   1    CONTINUE
   2  CALL SXTI(Q)
      T=Q-ETI-86400.
      ETI=Q
      IF(NTI.EQ.0)GOTO 4
   3  T=T+86400.
      IF(T.LT.0.)GOTO 3
      IF(NTI.GT.0)TMI(NTI)=TMI(NTI)+T
   4  NTI=N
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXFN
C
C Set SL to current time; if .fin file found, delete it and set JU to 1
C
      CHARACTER::NM*80,KF(60)*81
      COMMON/FLAGS/ST,SL,LF,LI,LP,LR,LN,LZ,LY,LE,LW,LS,LV,LQ,JU,
     +LO,LG,LU,LX,NP,MP,JR,JS,JK,JW,FM,RM,PC,PP,HP,FW,PW,WX
      COMMON/FILE/NM,KF
      CALL SXTI(T)
   1  IF(T.GT.SL)GOTO 2
      T=T+86400.
      GOTO 1
   2  SL=T
      OPEN(UNIT=LF,FILE=NM(1:LN)//'.fin',STATUS='OLD',ERR=3)
      CLOSE(UNIT=LF,STATUS='DELETE',ERR=3)
      JU=1
   3  RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXEX
C
C Normal job termination - print time and CPU (or elapsed) time
C
      CHARACTER::KD*8,KT*10,KZ*5
      INTEGER::IQ(8)
      REAL::TMI(10)
      COMMON/FLAGS/ST,SL,LF,LI,LP,LR,LN,LZ,LY,LE,LW,LS,LV,LQ,JU,
     +LO,LG,LU,LX,NP,MP,JR,JS,JK,JW,FM,RM,PC,PP,HP,FW,PW,WX
      COMMON/TIMS/TMI,ETI,NTI
   1  FORMAT(' ',78('=')//' CPU times required in seconds'/
     +' ',29('-')//F12.1,' - Data input and E-values'/
     +F12.1,' - Generate TPR'/F12.1,' - PATS'/
     +F12.1,' - Full symmetry PSMF'/F12.1,' - FIND'/F12.1,' - PLOP'/
     +F12.1,' - GROP'/F12.1,' - All FFTs'/F12.1,' - All peak-searches'/
     +F12.1,' - Rest')
   2  FORMAT(/'  ',68('+')/'  +  SHELXD finished at ',A2,':',A2,':',
     +A2,'      Total time:',F13.2,' secs  +'/'  ',68('+'))
C
      CALL SXTO(10)
      CALL SXTI(T)
      T=T-ST-86400.
   3  T=T+86400.
      IF(T.LT.0.)GOTO 3
      WRITE(LI,1)(TMI(I),I=1,10)
      WRITE(*,1)(TMI(I),I=1,10)
      CALL DATE_AND_TIME(KD,KT,KZ,IQ)
      WRITE(LI,2)KT(1:2),KT(3:4),KT(5:6),T
      WRITE(*,2)KT(1:2),KT(3:4),KT(5:6),T
      CLOSE(LI)
      CALL EXIT(0)
      STOP' '
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXUC(K)
C
C Convert a lower case character to upper case, leave rest unchanged
C
      CHARACTER::K*1
      IF(K.GT.'z')GOTO 1
      IF(K.LT.'a')GOTO 1
      K=CHAR(ICHAR(K)+ICHAR('A')-ICHAR('a'))
   1  RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXER(KM)
C
C Error exit - diagnostic message to console and printer
C
      CHARACTER(LEN=*)::KM
      COMMON/FLAGS/ST,SL,LF,LI,LP,LR,LN,LZ,LY,LE,LW,LS,LV,LQ,JU,
     +LO,LG,LU,LX,NP,MP,JR,JS,JK,JW,FM,RM,PC,PP,HP,FW,PW,WX
   1  FORMAT(/' ** ',A,' **'/)
      WRITE(LI,1)KM
      WRITE(*,1)KM
      CALL SXEX
      RETURN
      END
C
C --------------------------------------------------------------------
C
      SUBROUTINE SXIS(LE,IN,IH,IK,IL,FH,SH,DH,EH,AH,BH,AR,BR,RP,
     +BP,CP)
C
C Sort-merge data using order N algorithm (no NlogN nonsense here !)
C in order of ascending IH(I).  The allowed range of values in IH(I)
C is detemined by the dimension of IN, and is here -999 ... +999.
C
      INTEGER::IN(1999),IH(LE),IK(LE),IL(LE)
      REAL::FH(LE),SH(LE),DH(LE),EH(LE),AH(LE),BH(LE),AR(LE),BR(LE),
     +RP(LE),BP(LE),CP(LE)
        DO 1 I=1,1999
        IN(I)=0
   1    CONTINUE
        DO 2 I=1,LE
        J=IH(I)+1000
        IF(J.LT.1.OR.J.GT.1999)CALL SXER('REFLECTION INDEX OUTSIDE '
     +  //'RANGE -999 TO +999')
        IN(J)=IN(J)+1
        AH(I)=REAL(IH(I))
        BH(I)=REAL(IK(I))
        AR(I)=REAL(IL(I))
        BR(I)=FH(I)
        EH(I)=SH(I)
        CP(I)=DH(I)
        BP(I)=RP(I)
   2    CONTINUE
      J=0
        DO 3 I=1,1999
        K=J
        J=J+IN(I)
        IN(I)=K
   3    CONTINUE
        DO 4 I=1,LE
        J=INT(AH(I))+1000
        IN(J)=IN(J)+1
        J=IN(J)
        IH(J)=INT(AH(I))
        IK(J)=INT(BH(I))
        IL(J)=INT(AR(I))
        FH(J)=BR(I)
        SH(J)=EH(I)
        DH(J)=CP(I)
        RP(J)=BP(I)
   4    CONTINUE
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXFT(D,N1,N2,IS)
C
C N1 x N2 2D-FFT of data in D. D is a real array of dimension 2*N1*N2
C (real before imaginary) with index 1..N1 changing more rapidly than
C 1..N2.  IS = +1 for the forward transform and -1 for the inverse.
C
      REAL::D(2*N1*N2)
      I=2
      J=I*N1
      K=J*N2
        DO 12 ND=1,2
        NJ=1
          DO 6 M=1,J,I
          IF(M.GE.NJ)GOTO 3
          NK=M+I-2
            DO 2 L=M,NK,2
              DO 1 N=L,K,J
              NL=NJ+N-M
              T=D(N)
              D(N)=D(NL)
              D(NL)=T
              T=D(N+1)
              D(N+1)=D(NL+1)
              D(NL+1)=T
   1          CONTINUE
   2        CONTINUE
   3      NI=J/2
   4      IF((NI.LT.I).OR.(NJ.LE.NI))GOTO 5
          NJ=NJ-NI
          NI=NI/2
          GOTO 4
   5      NJ=NJ+NI
   6      CONTINUE
        NI=I
   7    IF(NI.GE.J)GOTO 11
        NJ=2*NI
        T=6.2831853/REAL(IS*NJ/I)
        UR=-2.*SIN(0.5*T)**2
        UI=SIN(T)
        WR=1.
        WI=0.
          DO 10 N=1,NI,I
          NL=N+I-2
            DO 9 L=N,NL,2
              DO 8 M=L,K,NJ
              NK=M+NI
              TR=WR*D(NK)-WI*D(NK+1)
              TI=WR*D(NK+1)+WI*D(NK)
              D(NK)=D(M)-TR
              D(NK+1)=D(M+1)-TI
              D(M)=D(M)+TR
              D(M+1)=D(M+1)+TI
   8          CONTINUE
   9        CONTINUE
          T=WR
          WR=WR*UR-WI*UI+WR
          WI=WI*UR+T*UI+WI
  10      CONTINUE
        NI=NJ
        GOTO 7
  11    I=J
        J=K
  12    CONTINUE
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXPS(NP,NF,FF,FR,XA,YA,ZA,HA,IM)
C
C Calculate PSMF for weakest fraction FR of Patterson vectors XA etc.
C The local allocatable array IP is used to store the Patterson, so
C this subroutine must also be called to initialize it.
C
      INTEGER::IM(NP)
      INTEGER(KIND=2),ALLOCATABLE,DIMENSION(:)::IP
      REAL::XA(NP),YA(NP),ZA(NP),HA(NP)
      SAVE IP,NI,NJ,NK,WZ
C
C Set up Patterson array
C
      IF(NF.NE.-1)GOTO 1
      DEALLOCATE(IP)
      GOTO 13
   1  IF(NF.NE.0)GOTO 2
      NJ=IM(1)
      NK=IM(2)
      WZ=FF
      NI=0
      N=NJ*NK*IM(3)
      ALLOCATE(IP(N),STAT=I)
      IF(I.NE.0)CALL SXER('CANNOT ALLOCATE ENOUGH MEMORY TO STORE '//
     +'PATTERSON')
      GOTO 13
C
C Store one layer of Patterson
C
   2  IF(NF.NE.1)GOTO 4
      N=NJ*NK
        DO 3 I=1,N
        IP(I+NI)=IM(I)
   3    CONTINUE
      NI=NI+N
      GOTO 13
C
C Find Patterson values for list of NP vectors
C
   4  U=REAL(NJ)
      V=REAL(NK)
      FF=0.
      NN=1+INT(FR*REAL(NP))
      NT=0
        DO 5 I=1,NP
        X=99.+XA(I)
        X=X-AINT(X)
        Y=99.+YA(I)
        Y=Y-AINT(Y)
        Z=99.+ZA(I)
        Z=Z-AINT(Z)
        IF(Z.GT.0.5)THEN
        X=1.-X
        Y=1.-Y
        Z=1.-Z
        ENDIF
        T=0.00098772*REAL(IP(1+MOD(NINT(U*X),NJ)+
     +  NJ*(MOD(NINT(V*Y),NK)+NK*NINT(WZ*Z))))
        HA(I)=SIGN(T**2,T)
        IF(HA(I).LT.0.)THEN
        NT=NT+1
        FF=FF+HA(I)
        ENDIF
   5    CONTINUE
      IF(NT.EQ.NN)GOTO 13
C
C Add extra positive values to PSMF
C
      IF(NT.GT.NN)GOTO 9
      N=0
        DO 6 I=1,NP
        IF(HA(I).GE.0.)THEN
        N=N+1
        HA(N)=HA(I)
        ENDIF
   6    CONTINUE
   7  Q=HA(1)
      K=1
        DO 8 I=2,N
        IF(Q.GT.HA(I))THEN
        Q=HA(I)
        K=I
        ENDIF
   8    CONTINUE
      FF=FF+Q
      NT=NT+1
      IF(NT.EQ.NN)GOTO 13
      HA(K)=HA(N)
      N=N-1
      GOTO 7
C
C Subtract extra negative values from PSMF
C
   9  N=0
        DO 10 I=1,NP
        IF(HA(I).LE.0.)THEN
        N=N+1
        HA(N)=HA(I)
        ENDIF
  10    CONTINUE
  11  Q=HA(1)
      K=1
        DO 12 I=2,N
        IF(Q.LT.HA(I))THEN
        Q=HA(I)
        K=I
        ENDIF
  12    CONTINUE
      FF=FF-Q
      NT=NT-1
      IF(NT.EQ.NN)GOTO 13
      HA(K)=HA(N)
      N=N-1
      GOTO 11
  13  RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXPO(LE,EH,SH,AR,BR,DH,AH,CP,QD,B)
C
C Fit  P + Q * (AR^2+BR^2)  to  EH^2  in resolution shells; save
C Ec = SQRT(Q*(AR^2+BR^2)) in AH.
C
      REAL::EH(LE),SH(LE),AR(LE),BR(LE),DH(LE),AH(LE),CP(LE),
     +QD(11),B(55)
C
        DO 1 I=1,55
        B(I)=0.
   1    CONTINUE
        DO 4 I=1,LE
        IF(SH(I).LT.0.)GOTO 4
        Q=1./DH(I)**2
        U=(EH(I)/CP(I))**2
        V=(AR(I)**2+BR(I)**2)/CP(I)**2
        AH(I)=V
          DO 2 J=2,10
          IF(Q.LT.QD(J))GOTO 3
   2      CONTINUE
        J=11
   3    J=J-1
        W=(Q-QD(J))/(QD(J+1)-QD(J))
        T=1.-W
        B(J)=B(J)+T
        B(J+1)=B(J+1)+W
        B(J+11)=B(J+11)+T*U
        B(J+12)=B(J+12)+W*U
        B(J+22)=B(J+22)+T*V
        B(J+23)=B(J+23)+W*V
        B(J+33)=B(J+33)+T*V**2
        B(J+34)=B(J+34)+W*V**2
        B(J+44)=B(J+44)+T*U*V
        B(J+45)=B(J+45)+W*U*V
   4    CONTINUE
        DO 5 I=1,11
        B(I)=AMAX1(0.,B(I)*B(I+44)-B(I+11)*B(I+22))
     +  /AMAX1(1.E-8,B(I)*B(I+33)-B(I+22)**2)
   5    CONTINUE
        DO 8 I=1,LE
        IF(SH(I).LT.0.)GOTO 8
        Q=1./DH(I)**2
          DO 6 J=2,10
          IF(Q.LT.QD(J))GOTO 7
   6      CONTINUE
        J=11
   7    J=J-1
        W=(Q-QD(J))/(QD(J+1)-QD(J))
        AH(I)=CP(I)*SQRT(AMAX1(.000001,AH(I)*(B(J)*(1.-W)+B(J+1)*W)))
   8    CONTINUE
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXOP(LP,C,D)
C
C Print symmetry operator as text string to unit LP.  The 3x3
C matrix and 3x1 vector in C are combined with a possible inversion
C [D(1)=+1 or -1] and lattice translation [+99.5 in D(2-4)].
C
      CHARACTER::KX(3)*1,KT*4,KR*40
      REAL::C(12),D(4)
      DATA KX/'x','y','z'/
C
      KR=' '''
      L=2
      K=0
        DO 11 NI=2,4
        NL=L
          DO 3 M=1,3
          K=K+1
          P=C(K)*D(1)
          IF(P.GT.0.0001)GOTO 1
          IF(P.GT.-0.0001)GOTO 3
          KR(L+1:L+1)='-'
          L=L+1
          GOTO 2
   1      IF(L.EQ.NL)GOTO 2
          L=L+1
          KR(L:L)='+'
   2      L=L+1
          KR(L:L)=KX(M)
   3      CONTINUE
        NT=INT((D(NI)+D(1)*C(NI+8)-99.5)*48.1)
        KR(L+1:L+1)='+'
        IF(NT.GT.0)GOTO 4
        IF(NT.EQ.0)GOTO 10
        KR(L+1:L+1)='-'
   4    L=L+1
        M=48
   5    IF(MOD(NT,2).NE.0)GOTO 6
        IF(MOD(M,2).NE.0)GOTO 6
        M=M/2
        NT=NT/2
        IF(NT.NE.0)GOTO 5
   6    IF(MOD(NT,3).NE.0)GOTO 7
        IF(MOD(M,3).NE.0)GOTO 7
        M=M/3
        NT=NT/3
        IF(NT.NE.0)GOTO 6
   7    WRITE(KT,'(I4)')IABS(NT)
          DO 8 I=1,4
          IF(KT(I:I).EQ.' ')GOTO 8
          L=L+1
          KR(L:L)=KT(I:I)
   8      CONTINUE
        IF(M.EQ.1)GOTO 10
        L=L+1
        KR(L:L)='/'
        WRITE(KT,'(I4)')M
          DO 9 I=1,4
          IF(KT(I:I).EQ.' ')GOTO 9
          L=L+1
          KR(L:L)=KT(I:I)
   9      CONTINUE
  10    L=L+2
        KR(L-1:L)=', '
  11    CONTINUE
      L=L-1
      KR(L:L)=''''
      WRITE(LP,'(A)')KR(1:L)
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SX1A(LM,LD,IS,XA,YA,ZA,HA,BP,ZW,A)
C
C Interpret instructions
C
      CHARACTER::IH(21)*1,KA(94)*2,KS*2,KC(42)*4,KX*4,NM*80,KR*80,
     +KF(60)*81
      INTEGER::IS(LM)
      REAL::A(596),D(13),XA(LM),YA(LM),ZA(LM),HA(LM),BP(LD),ZW(10)
      COMMON/FLAGS/ST,SL,LF,LI,LP,LR,LN,LZ,LY,LE,LW,LS,LV,LQ,JU,
     +LO,LG,LU,LX,NP,MP,JR,JS,JK,JW,FM,RM,PC,PP,HP,FW,PW,WX
      COMMON/FILE/NM,KF
      COMMON/ATSYM/KA
C
      DATA IH/'0','1','2','3','4','5','6','7','8','9','.','-',
     +'+','X','Y','Z',',','=','/',' ','!'/
      DATA KC/'    ','REM ','ZERR','DISP','TITL','SIZE','TEMP','CELL',
     +'LATT','SYMM','SFAC','UNIT','ESEL','SHEL','NTRY','FIND','KEEP',
     +'PLOP','TEST','SEED','MOVE','FRES','PREJ','DSUL','PSMF','HETA',
     +'MIND','XXXX','SKIP','TRIC','TRIK','TANG','WEED','PATS','NTPR',
     +'CCWT','GROP','ATOM','BASF','TWIN','HKLF','END '/
C
   1  FORMAT(A)
   2  FORMAT(1X,A)
   3  FORMAT(/' ** WARNING - HKLF or TWIN matrix changes hand',
     +' of axes **')
C
      WRITE(*,1)' Read instructions and process reflection data'
C
C Default parameter values
C
      JR=0
      LW=0
      LQ=0
      LS=0
      LY=121
      LG=LM+1
      MT=0
      NK=0
        DO 4 I=1,132
        A(I)=0.
   4    CONTINUE
      A(21)=10.
      A(22)=99.
      A(23)=100.
      A(24)=1.8
      A(25)=1.2
      A(27)=2.06
      A(30)=-1.
      A(31)=999.99
      A(33)=-0.3
      A(35)=1.
      A(37)=2.45
      A(39)=99.
      A(43)=2.5
      A(45)=-1.
      A(47)=1.
      A(48)=-999.
      A(49)=.4
      A(51)=.7
      A(61)=999999.
      A(62)=1.
      A(63)=1.
      A(64)=-0.1
      A(65)=2.5
      A(66)=0.34
      A(67)=-0.5
      A(104)=1.
      A(112)=3.1
      A(113)=-0.01
      A(114)=1.1
      A(121)=1.
      A(125)=1.
      A(129)=1.
      ZW(1)=-99.
      ZW(10)=0.5
C
C Read and interpret instruction
C
   5  KR=' '
      READ(LR,1,END=95)KR
      JJ=1
        DO 6 I=1,80
        IF(KR(I:I).LT.IH(20))KR(I:I)=IH(20)
        IF(KR(I:I).NE.IH(20))JJ=I
   6    CONTINUE
      WRITE(LI,2)KR(1:JJ)
      KX=' '
      JJ=4
      JK=5
        DO 7 I=1,80
        IF(I.LT.JK)KX(I:I)=KR(I:I)
        IF(KR(I:I).EQ.IH(21))GOTO 8
        IF(KR(I:I).NE.IH(20))JJ=I
        IF(I.GT.4)GOTO 7
        IF(KR(I:I).EQ.IH(20))JK=I
   7    CONTINUE
   8    DO 9 I=1,4
        CALL SXUC(KX(I:I))
   9    CONTINUE
        DO 10 NK=1,42
        IF(KX.EQ.KC(NK))GOTO 11
  10    CONTINUE
      IF(KX.EQ.'AFIX')GOTO 5
      IF(KX.EQ.'PART')GOTO 5
      IF(KX.EQ.'RESI')GOTO 5
      IF(KX.EQ.'FVAR')GOTO 5
      IF(KX.EQ.'WGHT')GOTO 5
      IF(KX.EQ.'MERG')GOTO 5
      IF(KX.EQ.'MOLE')GOTO 5
      IF(KX.EQ.'FEND')GOTO 5
      NK=43
C
C Decode numbers and symmetry operators
C
  11  IF(NK.EQ.1)GOTO 5
      IF(NK.GT.12.AND.NK.LT.39)GOTO 12
      IF(NK.EQ.43)GOTO 12
      IF(LQ.GE.60)CALL SXER('TOO MANY INSTRUCTIONS TO SAVE FOR .res')
      LQ=LQ+1
      KF(LQ)=KR//CHAR(JJ)
  12  IF(NK.LT.8)GOTO 5
      NA=0
        DO 13 I=JK,JJ
        CALL SXUC(KR(I:I))
  13    CONTINUE
        DO 14 I=1,13
        D(I)=0.
  14    CONTINUE
      IF(NK.EQ.38.OR.NK.EQ.26)GOTO 89
      NJ=LY+7
      L=LY+21
      N=JK
      IF(N.GT.4)N=4
      IF(NK.NE.10)GOTO 16
      IF(LS.NE.0)GOTO 38
        DO 15 I=LY+12,LY+23
        A(I)=0.
  15    CONTINUE
  16  W=1.
      X=0.
  17  V=0.
      NB=0
      Y=1.
      U=10.
      Z=1.
      GOTO 19
  18  Z=Y*Z
      V=U*ABS(V)+Z*X
      NB=1
      IF(ABS(V).LT.1.E-8)GOTO 19
      V=SIGN(V,W)
      W=V
  19  N=N+1
      K=11
      IF(N.GT.JJ)GOTO 22
      X=0.
        DO 20 K=1,19
        IF(KR(N:N).EQ.IH(K))GOTO 21
        X=X+1.
  20    CONTINUE
      K=1
      GOTO 22
  21  IF(K.LT.11)GOTO 18
      K=K-9
  22  IF(NK.NE.10)GOTO 34
C
C SYMM - store in A(121) to A(LY+11) as r11, r12 ... r33, t1 ... t3
C
      IF(K.NE.10)GOTO 26
      IF(ABS(V).LT.1.E-8)GOTO 40
      N=N+1
      IF(N.GT.JJ)GOTO 40
        DO 23 I=2,7
        IF(IH(I).EQ.KR(N:N))GOTO 24
  23    CONTINUE
      GOTO 40
  24  V=V/REAL(I-1)
      W=V
      IF(N.EQ.JJ)GOTO 19
        DO 25 I=1,10
        IF(IH(I).EQ.KR(N+1:N+1))GOTO 40
  25    CONTINUE
      GOTO 19
  26  IF(K.EQ.9)GOTO 30
      IF(K.GT.7)GOTO 29
      IF(K.GT.4)GOTO 28
      IF(K.GT.2)GOTO 36
      IF(K.EQ.1)GOTO 19
  27  U=1.
      Y=.1
      GOTO 19
  28  K=K+NJ
      A(K)=W
      GOTO 16
  29  U=AINT(V)
      A(L)=A(L)+U+AINT(24.5*(V-U))/24.
      L=L+1
      NJ=NJ+3
      IF(NJ+8.LT.L)GOTO 16
      LY=LY+12
      IF(LS.EQ.0)GOTO 5
      GOTO 38
C
C Continuation lines
C
  30  IF(NK.EQ.10)GOTO 39
      KR=' '
      READ(LR,1,ERR=39,END=39)KR
      JJ=2
        DO 31 I=2,80
        IF(KR(I:I).LT.IH(20))KR(I:I)=IH(20)
        IF(KR(I:I).NE.IH(20))JJ=I
  31    CONTINUE
      WRITE(LI,2)KR(1:JJ)
      JJ=2
        DO 32 I=2,80
        IF(KR(I:I).EQ.IH(21))GOTO 33
        CALL SXUC(KR(I:I))
  32    CONTINUE
  33  N=1
      IF(KR(1:1).EQ.IH(20))GOTO 16
      GOTO 39
  34  IF(K.EQ.2)GOTO 27
      IF(NB.EQ.0)GOTO 35
      NA=NA+1
      IF(NA.GT.13)GOTO 40
      D(NA)=V
  35  IF(K.LT.9)GOTO 37
      IF(K.GT.9)GOTO 42
      GOTO 30
  36  A(L)=AINT(24.5*V)/24.
  37  IF(K.NE.3)GOTO 16
      W=-1.
      GOTO 17
C
C Error messages
C
  38  CALL SXER('INSTRUCTIONS REPEATED OR IN WRONG ORDER')
  39  CALL SXER('BAD CONTINUATION LINE')
  40  CALL SXER('WRONG NUMBER OF PARAMETERS')
  41  CALL SXER('ILLEGAL PARAMETER VALUE')
C
C CELL - store lambda, a ... gamma in A(1) ... A(7) and a**2 ...
C 2ab.cos(gamma) [for calculating distances] in A(8) ... A(13).
C A(14) ... A(19) hold the coefficients a**2 ... 2a*b*cos(gamma*)
C for calculating 1/d**2, and A(20) the unit-cell volume.
C
  42  IF(NK.NE.8)GOTO 46
      IF(NA.NE.7)GOTO 40
        DO 43 J=1,7
        IF(.01.GT.D(J))GOTO 41
        A(J)=D(J)
  43    CONTINUE
      U=A(2)*A(3)*A(4)
        DO 44 J=2,4
        X=1.74533E-2*A(J+3)
        D(J)=COS(X)
        D(J+3)=SIN(X)
        A(J+9)=2.*U*D(J)/A(J)
        A(J+6)=A(J)**2
  44    CONTINUE
      V=1./(1.-D(2)**2-D(3)**2-D(4)**2+2.*D(2)*D(3)*D(4))
        DO 45 J=2,4
        A(J+12)=V*(D(J+3)/A(J))**2
  45    CONTINUE
      T=2.*V/U
      A(17)=T*A(2)*(D(3)*D(4)-D(2))
      A(18)=T*A(3)*(D(2)*D(4)-D(3))
      A(19)=T*A(4)*(D(2)*D(3)-D(4))
      A(20)=U*SQRT(V)
C
C Triangular matrix for orthogonal to crystal transformation
C
      X=(D(2)*D(3)-D(4))/(D(5)*D(6))
      Y=SQRT(ABS(1.-X*X))
      A(115)=1./(A(2)*D(6)*Y)
      A(117)=1./(A(3)*D(5))
      A(116)=A(117)*X/Y
      A(118)=(-D(6)*D(2)*X-D(5)*D(3))/(A(4)*D(5)*D(6)*Y)
      A(120)=1./A(4)
      A(119)=-D(2)*A(120)/D(5)
      GOTO 5
C
C LATT - set A(62) to lattice type code
C
  46  IF(NK.NE.9)GOTO 47
      IF(NA.NE.1)GOTO 40
      A(62)=D(1)
      GOTO 5
C
C SFAC - store pointers to scattering factors and number of atoms per
C cell in A(LY+12) [2] A(LS+1).  Only one SFAC instruction is allowed,
C and numerical information is not permitted.
C
  47  IF(NK.NE.11)GOTO 53
      IF(LS.NE.0)GOTO 50
      IF(NA.GT.0)GOTO 51
      LS=LY+10
      K=4
  48  K=K+1
      IF(K.GT.79)GOTO 5
      IF(KR(K:K).EQ.IH(21))GOTO 5
      IF(KR(K:K).EQ.IH(20))GOTO 48
      IF(KR(K:K).EQ.IH(18))GOTO 39
      KS=KR(K:K+1)
      K=K+1
        DO 49 J=1,94
        IF(KS.NE.KA(J))GOTO 49
        LS=LS+2
        A(LS)=REAL(10*J-9)
        GOTO 48
  49    CONTINUE
      CALL SXER('UNKNOWN ELEMENT FOR SFAC')
  50  CALL SXER('MORE THAN ONE SFAC INSTRUCTION')
  51  CALL SXER('THIS FORM OF SFAC INSTRUCTION IS NOT ALLOWED')
  52  CALL SXER('TRIC OR TRIK MUST COME IMMEDIATELY AFTER UNIT')
C
C UNIT - calculate effective number of atoms per cell
C
  53  IF(NK.NE.12)GOTO 55
      IF(LS.LT.LY)GOTO 38
      IF(LS-LY-10.NE.2*NA)CALL SXER('SFAC AND UNIT DO NOT MATCH')
      IF(A(20).LT.0.)GOTO 52
      L=LY+10
      X=0.
      Y=0.
        DO 54 J=1,NA
        L=L+2
        T=0.1*(A(L)+9.)
        Z=D(J)*T
        X=X+Z*T
        Y=Y+Z*T**2
        A(L+1)=D(J)
  54    CONTINUE
      Z=ABS(A(62))
      IF(Z.GT.4.5)Z=2.
      A(30)=2.*Y/(X*SQRT(X/Z))
      A(42)=Z*REAL(LY-109)*(1.5+SIGN(.5,A(62)))/12.
      GOTO 5
C
C ESEL
C
  55  IF(NK.NE.13)GOTO 56
      IF(NA.GT.0)A(46)=D(1)
      IF(NA.GT.1)A(47)=D(2)
      IF(NA.GT.2)GOTO 40
      GOTO 5
C
C SHEL - resolution limits
C
  56  IF(NK.NE.14)GOTO 57
      IF(NA.NE.2)GOTO 40
      A(31)=AMAX1(D(1),D(2))
      A(32)=AMIN1(D(1),D(2))
      GOTO 5
C
C NTRY - overall number of FIND or PATS attempts before stopping
C
  57  IF(NK.NE.15)GOTO 58
      IF(NA.NE.1)GOTO 40
      A(111)=D(1)
      GOTO 5
C
C FIND - dual space recycling
C
  58  IF(NK.NE.16)GOTO 59
      IF(NA.GT.2)GOTO 40
      IF(NA.LT.1)GOTO 40
      IF(NINT(D(1)).EQ.0)GOTO 41
      A(44)=D(1)
      IF(NA.EQ.2)A(45)=ABS(D(2))
      GOTO 5
C
C KEEP - special treatment of heavy atoms
C
  59  IF(NK.NE.17)GOTO 60
      IF(NA.NE.1)GOTO 40
      A(68)=D(1)
      GOTO 5
C
C PLOP - peaklist optimization
C
  60  IF(NK.NE.18)GOTO 62
      IF(NA.GT.10)GOTO 40
      IF(NA.LT.1)GOTO 40
      A(50)=REAL(NA)
        DO 61 J=1,NA
        IF(D(J).LT.0.999)GOTO 41
        A(J+50)=D(J)
  61    CONTINUE
      A(33)=ABS(A(33))
      IF(A(48).LT.-998.)A(48)=0.9
      A(67)=ABS(A(67))
      GOTO 5
C
C TEST - termination tests etc.
C
  62  IF(NK.NE.19)GOTO 64
      IF(NA.GT.2)GOTO 40
        DO 63 I=1,NA
        A(I+20)=D(I)
  63    CONTINUE
      MT=1
      GOTO 5
C
C SEED - set random number seed
C
  64  IF(NK.NE.20)GOTO 65
      IF(NA.NE.1)GOTO 40
      IF(D(1).LT.0.)GOTO 41
      JR=MOD(NINT(D(1)),714025)
      GOTO 5
C
C MOVE - dx dy dz +/-1
C
  65  IF(NK.NE.21)GOTO 67
      IF(NA.LT.3)GOTO 40
      IF(NA.GT.4)GOTO 40
        DO 66 I=1,NA
        A(I+100)=D(I)
  66    CONTINUE
      GOTO 5
C
C FRES - resolution factor for all Fourier maps
C
  67  IF(NK.NE.22)GOTO 68
      IF(D(1).LT.0.1)GOTO 41
      A(43)=D(1)
      GOTO 5
C
C PREJ - rejection criteria for atoms from peaksearch for PLOP
C
  68  IF(NK.NE.23)GOTO 70
      IF(NA.GT.3)GOTO 40
        DO 69 I=1,NA
        A(I+111)=D(I)
  69    CONTINUE
      GOTO 5
C
C DSUL
C
  70  IF(NK.NE.24)GOTO 72
      IF(NA.LT.1)GOTO 40
      IF(NA.GT.2)GOTO 40
        DO 71 I=1,NA
        IF(D(I).LT.0.1)GOTO 41
        A(I+25)=D(I)
  71    CONTINUE
      GOTO 5
C
C PSMF
C
  72  IF(NK.NE.25)GOTO 74
      IF(NA.GT.2)GOTO 40
        DO 73 I=1,NA
        A(64+I)=D(I)
  73    CONTINUE
      GOTO 5
C
C MIND - minimum distance between atoms
C
  74  IF(NK.NE.27)GOTO 76
      IF(NA.GT.2)GOTO 40
        DO 75 I=1,NA
        A(I+62)=D(I)
  75    CONTINUE
      GOTO 5
C
C SKIP
C
  76  IF(NK.NE.29)GOTO 77
      IF(NA.NE.1)GOTO 40
      A(67)=D(1)
      GOTO 5
C
C TRIC or TRIK - convert to non-centrosymmetric triclinic
C
  77  IF(NK.EQ.31)GOTO 78
      IF(NK.NE.30)GOTO 79
  78  IF(NA.GT.0)GOTO 40
      A(20)=-ABS(A(20))
      GOTO 5
C
C TANG - tangent expansion for the initial FIND cycles
C
  79  IF(NK.NE.32)GOTO 80
      IF(NA.GT.2)GOTO 40
      IF(NA.GT.0)A(48)=D(1)
      IF(NA.GT.1)A(49)=D(2)
      GOTO 5
C
C WEED - fractions of randomly omitted peaks
C
  80  IF(NK.NE.33)GOTO 81
      IF(NA.GT.1)GOTO 40
      A(33)=D(1)
      GOTO 5
C
C PATS - Patterson vector search followed by PSMF
C
  81  IF(NK.NE.34)GOTO 82
      IF(NA.GT.3)GOTO 40
      IF(A(109).LT.-0.1)GOTO 84
      IF(NA.EQ.0)D(1)=100.
      A(24)=D(1)
      A(109)=0.2
      IF(NA.GT.1.AND.NINT(D(2)).EQ.0)GOTO 41
      IF(NA.GT.1)A(109)=ABS(D(2))
      IF(A(109).LT.0.1)GOTO 41
      A(110)=5.
      IF(NA.GT.2)A(110)=D(3)
      IF(NINT(A(110)).LT.1)GOTO 41
      GOTO 5
C
C NTPR
C
  82  IF(NK.NE.35)GOTO 83
      IF(NA.NE.1)GOTO 40
      A(23)=D(1)
      GOTO 5
C
C CCWT
C
  83  IF(NK.NE.36)GOTO 85
      IF(NA.GT.1)GOTO 40
      A(40)=ABS(D(1))
      GOTO 5
C
C GROP
C
  84  CALL SXER('GROP AND PATS MUTUALLY EXCLUSIVE')
  85  IF(NK.NE.37)GOTO 86
      IF(NA.GT.4)GOTO 40
      IF(A(109).GT.0.1)GOTO 84
      A(110)=999.
      IF(NA.GT.0)A(110)=ABS(D(1))
      IF(NA.GT.1)A(24)=ABS(D(2))
      IF(NA.GT.2)A(25)=D(3)
      A(109)=-999.
      IF(NA.LT.4)GOTO 5
      A(109)=-ABS(D(4))
      IF(NINT(A(109)).EQ.0)GOTO 41
      GOTO 5
C
C BASF
C
  86  IF(NK.NE.39)GOTO 87
      IF(D(1).LE.0.)GOTO 41
      IF(D(1).GE.1.)GOTO 41
      ZW(10)=D(1)
      GOTO 5
C
C TWIN
C
  87  IF(NK.NE.40)GOTO 93
      IF(NA.NE.9)GOTO 40
      X=D(1)*D(5)-D(2)*D(4)
      Y=D(2)*D(7)-D(1)*D(8)
      Z=D(4)*D(8)-D(5)*D(7)
      X=Z*D(3)+Y*D(6)+X*D(9)
      IF(ABS(ABS(X)-1.).GT.0.01)GOTO 41
      IF(X.LT.0.)WRITE(LI,3)
        DO 88 I=1,9
        ZW(I)=D(I)
  88    CONTINUE
      GOTO 5
C
C ATOM or HETA - interpret PDB format atom
C
  89  LG=LG-1
      IF(LG.LE.LW)GOTO 92
      READ(KR,'(12X,A2,16X,3F8.3,F6.3)')KS,XA(LG),YA(LG),ZA(LG),HA(LG)
      IF(KS(1:1).EQ.' ')KS=KR(14:14)//' '
        DO 90 J=1,94
        IF(KS.EQ.KA(J))GOTO 91
  90    CONTINUE
      CALL SXER('UNKNOWN ELEMENT ON PDB ATOM OR HETATM INSTRUCTION')
  91  IS(LG)=J*10-9
      GOTO 5
C
C Atoms
C
  92  CALL SXER('TOO MANY ATOMS')
  93  IF(NK.NE.43)GOTO 94
      IF(NA.LT.4)CALL SXER('UNKNOWN '//KX//' INSTRUCTION')
      LW=LW+1
      IF(LW.GE.LG)GOTO 92
      N=NINT(D(1))
      IF(N.LT.1)GOTO 41
      N=N*2+LY+10
      IF(N.GT.LS)GOTO 41
      IS(LW)=NINT(A(N))
      IF(NA.LT.5)D(5)=1.
      HA(LW)=AMOD(D(5),10.)
      BP(LW)=1.
      XA(LW)=A(101)+A(104)*D(2)
      YA(LW)=A(102)+A(104)*D(3)
      ZA(LW)=A(103)+A(104)*D(4)
      GOTO 5
C
C END - set default HKLF 3
C
  94  IF(NK.NE.42)GOTO 97
      IF(NA.NE.0)GOTO 40
  95    DO 96 J=1,13
        D(J)=0.
  96    CONTINUE
      D(1)=3.
      NA=1
C
C HKLF - prepare to read reflection data in next subroutine
C
  97  LZ=INT(1.001*D(1))
      M=IABS(LZ)
      IF(IABS(M-1).EQ.1)GOTO 41
      IF(M.GT.4)GOTO 41
      IF(NA.GT.2)GOTO 98
      IF(NA.LT.2)D(2)=1.
      D(3)=1.
      D(7)=1.
      D(11)=1.
      NA=11
  98  IF(NA.LT.11)GOTO 40
      X=D(3)*D(7)-D(4)*D(6)
      Y=D(4)*D(9)-D(3)*D(10)
      Z=D(6)*D(10)-D(7)*D(9)
      X=Z*D(5)+Y*D(8)+X*D(11)
      IF(ABS(X).LT.0.01)GOTO 41
      IF(X.LT.0.)WRITE(LI,3)
        DO 99 I=1,13
        A(I+87)=D(I)
  99    CONTINUE
      IF(LZ.LT.0)LF=LR
C
C Set remaining defaults and check instructions for internal consistency
C
      IF(LS.EQ.0)CALL SXER('SFAC MISSING')
      IF(A(30).LT.0.)CALL SXER('UNIT MISSING')
      A(33)=AMAX1(A(33),0.)
      IF(A(48).LT.-998.)A(48)=-0.9
      A(67)=AMAX1(A(67),0.)
      U=1.
      V=1.
      W=1.
        DO 100 K=121,LY,12
        U=AMIN1(U,A(K))
        V=AMIN1(V,A(K+4))
        W=AMIN1(W,A(K+8))
 100    CONTINUE
      U=U+V+W
      IF(A(62).GT.0.)U=-3.
      IF(A(109).LT.0.1)GOTO 101
      IF(A(109).GT.0.3)GOTO 101
      A(109)=SIGN(9999.,A(109))
      IF(U.LT.-2.5)A(109)=SIGN(99999.,A(109))
 101  IF(NINT(A(44)).EQ.0)GOTO 102
      IF(NINT(A(45)).GE.0)GOTO 102
      A(45)=AMAX1(20.,A(44))
      IF(A(109).GT.0.2)A(45)=AMIN1(3.*A(44),20.)
 102  IF(A(46).GT.0.0001)GOTO 103
      A(46)=1.2
      IF(ABS(A(63)).GT.1.6.OR.A(109).GT.0.2)A(46)=1.5
 103  K=NINT(ABS(A(44)))
      IF(K.EQ.0)GOTO 104
      IF(NINT(A(109)).NE.0)GOTO 104
      IF(NINT(A(45)).EQ.0)CALL SXER('BAD FIND INSTRUCTION')
 104  M=NINT(A(50))
      IF(M.EQ.0)GOTO 105
      IF(K.EQ.0)GOTO 105
      IF(MT.NE.0)GOTO 105
      A(21)=45.
      A(22)=1.
 105  IF(NINT(ABS(A(109))).NE.0)GOTO 106
      IF(K.GT.0)GOTO 107
      IF(M.EQ.0)CALL SXER('AT LEAST ONE OF PATS, GROP, FIND '
     +//'OR PLOP MUST BE SPECIFIED')
      IF(LW.EQ.0)CALL SXER('NO SOURCE OF ATOMS FOR PLOP OR BREF')
      A(111)=1.
      GOTO 107
 106  IF(LW.NE.0)CALL SXER('ATOM INPUT INCONSISTENT WITH PATS OR GROP')
      IF(NINT(A(44)).EQ.0.AND.NINT(A(50)).EQ.0)CALL SXER('PATS AND '//
     +'GROP REQUIRE FIND AND/OR PLOP')
 107  JW=LG
      IF(LG.LE.LM.AND.A(109).GT.-0.5)CALL SXER
     +('PDB FORMAT ATOMS REQUIRE GROP')
      IF(LG.GT.LM.AND.A(109).LT.-0.5)CALL SXER
     +('GROP REQUIRES PDB FORMAT ATOMS')
      IF(ZW(1).GT.-98.0.AND.NINT(A(50)).EQ.0)CALL SXER
     +('TWIN requires PLOP')
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SX1B(LD,IM,IN,IH,IK,IL,FH,SH,DH,EH,AH,BH,
     +AR,BR,RP,BP,CP,QD,SC,BT,ZW,A)
C
C Read and process reflection data
C
      CHARACTER::IR*80
      INTEGER::IM(LD),IN(LD),IH(LD),IK(LD),IL(LD),IQ(20)
      REAL::FH(LD),SH(LD),AH(LD),BH(LD),DH(LD),EH(LD),AR(LD),BR(LD),
     +RP(LD),BP(LD),CP(LD),QD(11),SC(12501),A(596),BT(6440),ZW(10)
      COMMON/FLAGS/ST,SL,LF,LI,LP,LR,LN,LZ,LY,LE,LW,LS,LV,LQ,JU,
     +LO,LG,LU,LX,NP,MP,JR,JS,JK,JW,FM,RM,PC,PP,HP,FW,PW,WX
C
   1  FORMAT(A)
   2  FORMAT(20I4)
   3  FORMAT(3I4,2F8.2)
   4  FORMAT(/I8,'  reflections read, of which',I6,'  rejected')
   5  FORMAT(/' Checksum O.K.')
   6  FORMAT(/I8,' unique data;  R(int) =',F6.3,';  R(sigma) =',F6.3,
     +';  Mean|E^2-1| =',F6.3/'    Friedel opposites merged'/)
   7  FORMAT(I8,' unique data;  R(int) =',F6.3,';  R(sigma) =',F6.3,
     +';  Mean|E^2-1| =',F6.3)
   8  FORMAT(I8,'  bad systematic absences')
   9  FORMAT(' E >',11F6.1,F7.1/'  N ',11I6,I7/)
  10  FORMAT(' Expanded to triclinic hemisphere of',I8,' reflections')
  11  FORMAT(' ',77('='))
  12  FORMAT(' SHEL  dmax',F8.2,'   dmin',F7.2/' MIND  mdis',F7.3,
     +'   mdeq',F7.3/' FRES  res',F5.1/' SEED  nrand',I7)
  13  FORMAT(' GROP  nor',I7,'   Eg',F6.2,'   dg',F6.2,'   ntr',I6)
  14  FORMAT(' PATS  np',I5,'   npt',I9,'   nf',I6)
  15  FORMAT(' PATS  dis',F7.3,'   npt',I9,'   nf',I6)
  16  FORMAT(' PSMF  pres',F5.1,'   psfac',F7.3)
  17  FORMAT(' FIND  na',I6,'   ncy',I8/' DSUL  nss',I5,'   dss',F6.3)
  18  FORMAT(' TANG  ftan',F7.3,'   fex',F6.3/' NTPR  ntpr',I6/
     +' SKIP  min2',F6.1)
  19  FORMAT(' ESEL  Emin',F6.3,'   dlim',F6.3/' WEED  fro',F7.3)
  20  FORMAT(' TEST  CCmin',F7.2,'   delCC',F7.2)
  21  FORMAT(' PLOP  maxats',10I6)
  22  FORMAT(' CCWT  g',F8.3)
  23  FORMAT(' KEEP  nh',I6/' PREJ  maxb',I5,'   dsp',F7.3,'   mf',I4)
  24  FORMAT(' NTRY  ntry',I10)
  25  FORMAT(' TWIN ',9F8.4/' BASF  twinfr',F9.5)
C
C Read and unpack 'condensed data'
C
      LE=0
      KI=0
      JP=0
      KK=0
      ML=INT(ABS(A(62)))
      NS=0
      NR=0
      M=IABS(LZ)
      UM=A(100)
      IF(M.GT.1)GOTO 37
  26  IR=' '
      READ(LF,1,END=36)IR
        DO 27 I=1,80
        IF(IR(I:I).LT.' ')IR(I:I)=' '
  27    CONTINUE
      READ(IR,2,ERR=36)IQ
      KK=MOD(KK,99)+1
      JP=0
      GOTO 30
  28  X=1.
  29  UM=UM+X*ABS(REAL(IQ(JP)))
      UM=AINT(UM+SIGN(.3,UM))
  30  JP=JP+1
      X=100.
      IF(JP.GT.20)GOTO 26
      KI=INT(AMOD(REAL(KI)+REAL(KK)*REAL(IQ(JP)),10000.))
      IF(IQ(JP).LT.0)GOTO 28
      IF(IQ(JP).GT.0)GOTO 33
      IF(20.GT.JP)GOTO 32
      IR=' '
      READ(LF,1,END=36)IR
        DO 31 I=1,80
        IF(IR(I:I).LT.' ')IR(I:I)=' '
  31    CONTINUE
      READ(IR,2,ERR=36)IQ
      JP=0
  32  JP=JP+1
      IF(IQ(JP).EQ.0)GOTO 59
      IF(IQ(JP).NE.KI)CALL SXER('BAD CONDENSED DATA')
      WRITE(LI,5)
      GOTO 59
  33  L=IQ(JP)/1000
      IF(L.LT.0)GOTO 28
      IF(L.EQ.0)GOTO 29
      UM=UM+REAL(L)
      L=MOD(IQ(JP)/100,10)-5
      Q=REAL(MOD(IQ(JP),100))*(10.**L)
      JP=JP+1
      IF(JP.LT.21)GOTO 35
      IR=' '
      READ(LF,1,END=36)IR
        DO 34 I=1,80
        IF(IR(I:I).LT.' ')IR(I:I)=' '
  34    CONTINUE
      READ(IR,2,ERR=36)IQ
      KK=MOD(KK,99)+1
      JP=1
  35  L=(IQ(JP)/1000)-4
      KI=INT(AMOD(REAL(KI)+REAL(KK)*REAL(IQ(JP)),10000.))
      T=REAL(MOD(IQ(JP),1000))*(10.**L)
      S=100.*T
      IF(Q.GT.0.)S=AMIN1(S,AMAX1(.001*T,1./Q))
      Q=ABS(UM)
      Z=AINT(.5+.0001*Q)
      X=(AINT(.5+Q)-10000.*Z)*.01
      Y=AINT(X+SIGN(.5,X+.1))
      X=AINT(101.*(X-Y))
      T=T*A(89)
      S=SQRT(S)*A(89)
      GOTO 40
  36  CALL SXER('BAD CONDENSED DATA')
C
C Read h, k, l, F or F**2, sigma(F) or sigma(F**2)
C
  37  IR=' '
      READ(LF,1,END=59)IR
        DO 38 I=1,80
        IF(IR(I:I).LT.' ')IR(I:I)=' '
  38    CONTINUE
      READ(IR,3,ERR=59)J,K,L,T,S
      IF(IABS(J)+IABS(K)+IABS(L).EQ.0)GOTO 59
      T=T*A(89)
      S=ABS(S*A(89))
      IF(S.LT.0.0001)S=.1
      IF(M.NE.4)GOTO 39
      T=SQRT(AMAX1(0.,T))
      S=0.5*S/AMAX1(0.5*SQRT(S),T)
  39  X=REAL(J)
      Y=REAL(K)
      Z=REAL(L)
  40  IF(LE.GE.LD)CALL SXER(
     +'ARRAYS TOO SMALL TO STORE REFLECTION DATA - INCREASE LD')
      FH(LE+1)=T
      SH(LE+1)=S
C
C Apply HKLF reorientation matrix and reject lattice absences
C
      U=X*A(90)+Y*A(91)+Z*A(92)
      V=X*A(93)+Y*A(94)+Z*A(95)
      W=X*A(96)+Y*A(97)+Z*A(98)
      UU=U+9999.5
      VV=V+9999.5
      WW=W+9999.5
      IF(ABS(UU-AINT(UU)-0.5)+ABS(VV-AINT(VV)-0.5)+
     +ABS(WW-AINT(WW)-0.5).GT.0.1)GOTO 58
      IF(ML.NE.2)GOTO 41
      IF(ABS(AMOD(U+V+W+9998.5,2.)-0.5).LT.0.1)GOTO 46
      GOTO 57
  41  IF(ML.NE.3)GOTO 42
      IF(ABS(AMOD(V+W-U+9999.5,3.)-0.5).LT.0.1)GOTO 46
      GOTO 57
  42  IF(ML.NE.4)GOTO 43
      Q=ABS(U*V*W)+0.5
      IF(ABS(AMOD(Q,8.)-0.5).LT.0.1)GOTO 46
      IF(ABS(AMOD(Q,2.)-0.5).GT.0.9)GOTO 46
      GOTO 57
  43  IF(ML.NE.5)GOTO 44
      IF(ABS(AMOD(V+W+9998.5,2.)-0.5).LT.0.1)GOTO 46
      GOTO 57
  44  IF(ML.NE.6)GOTO 45
      IF(ABS(AMOD(U+W+9998.5,2.)-0.5).LT.0.1)GOTO 46
      GOTO 57
  45  IF(ML.NE.7)GOTO 46
      IF(ABS(AMOD(U+V+9998.5,2.)-0.5).GT.0.1)GOTO 57
C
C Find equivalent reflection with standard indices
C
  46  Q=0.
      MH=NINT(U)
      MK=NINT(V)
      MN=NINT(W)
        DO 50 K=121,LY,12
        NH=NINT(U*A(K)+V*A(K+3)+W*A(K+6))
        NK=NINT(U*A(K+1)+V*A(K+4)+W*A(K+7))
        NL=NINT(U*A(K+2)+V*A(K+5)+W*A(K+8))
        T=1.
        IF(NL.GT.0)GOTO 48
        IF(NL.LT.0)GOTO 47
        IF(NK.GT.0)GOTO 48
        IF(NK.LT.0)GOTO 47
        IF(NH.GE.0)GOTO 48
  47    NH=-NH
        NK=-NK
        NL=-NL
        T=-1.
  48    IF(NL.LT.MN)GOTO 50
        IF(NL.GT.MN)GOTO 49
        IF(NK.LT.MK)GOTO 50
        IF(NK.GT.MK)GOTO 49
        IF(NH.LT.MH)GOTO 50
  49    MH=NH
        MK=NK
        MN=NL
  50    CONTINUE
      IH(LE+1)=MH
      IK(LE+1)=MK
      IL(LE+1)=MN
      U=REAL(MH)
      V=REAL(MK)
      W=REAL(MN)
C
C Reject systematic absences
C
      IF(A(20).LT.0.)GOTO 55
      Q=Q-0.5
        DO 54 K=133,LY,12
        NH=NINT(U*A(K)+V*A(K+3)+W*A(K+6))
        NK=NINT(U*A(K+1)+V*A(K+4)+W*A(K+7))
        NL=NINT(U*A(K+2)+V*A(K+5)+W*A(K+8))
        IF(NH.NE.MH)GOTO 51
        IF(NK.NE.MK)GOTO 51
        IF(NL.EQ.MN)GOTO 53
  51    IF(A(62).LT.0.)GOTO 54
        IF(NL.GT.0)GOTO 54
        IF(NL.LT.0)GOTO 52
        IF(NK.GT.0)GOTO 54
        IF(NK.LT.0)GOTO 52
        IF(NH.GE.0)GOTO 54
  52    NH=-NH
        NK=-NK
        NL=-NL
        IF(NH.NE.MH)GOTO 54
        IF(NK.NE.MK)GOTO 54
        IF(NL.NE.MN)GOTO 54
  53    Q=999.5+U*A(K+9)+V*A(K+10)+W*A(K+11)
        IF(Q-AINT(Q).LT.0.4)
     +  GOTO 57
  54    CONTINUE
C
C Apply resolution limit and save minimum d (actually used) in A(61)
C
  55  Q=1./SQRT(U**2*A(14)+V**2*A(15)+W**2*A(16)+V*W*A(17)+
     +U*W*A(18)+U*V*A(19))
      IF(Q.GT.A(31))GOTO 58
      IF(Q.LT.A(32))GOTO 58
      IF(Q.LT.A(61))A(61)=Q
      LE=LE+1
      DH(LE)=Q
      RP(LE)=0.
  56  IF(M.EQ.1)GOTO 30
      GOTO 37
  57  IF(FH(LE+1).LT.4.*SH(LE+1))GOTO 58
      NS=NS+1
  58  NR=NR+1
      GOTO 56
C
C End of data - close all open input files
C
  59  WRITE(LI,4)LE+NR,NR
      IF(NS.GT.0)WRITE(LI,8)NS
      IF(LN.EQ.0)GOTO 60
      IF(LF.NE.LR)CLOSE(LF,STATUS='KEEP')
      CLOSE(LR,STATUS='KEEP')
C
C Sort data into standard order so that equivalents are adjacent
C
  60  CALL SXIS(LE,IN,IH,IK,IL,FH,SH,DH,EH,AH,BH,AR,BR,RP,BP,CP)
      CALL SXIS(LE,IN,IK,IL,IH,FH,SH,DH,EH,AH,BH,AR,BR,RP,BP,CP)
      CALL SXIS(LE,IN,IL,IH,IK,FH,SH,DH,EH,AH,BH,AR,BR,RP,BP,CP)
C
C Merge equivalents and sum for R(int) and R(sigma)
C
      RA=0.
      RB=0.0001
      RC=0.
      RD=0.0001
      N=0
      I=1
  61  IF(I.GT.LE)GOTO 65
      W=1./SH(I)**2
      U=W*FH(I)
      V=U*FH(I)
      K=I
  62  I=I+1
      IF(I.GT.LE)GOTO 63
      IF(IH(I).NE.IH(K))GOTO 63
      IF(IK(I).NE.IK(K))GOTO 63
      IF(IL(I).NE.IL(K))GOTO 63
      T=1./SH(I)**2
      W=W+T
      U=U+T*FH(I)
      V=V+T*FH(I)**2
      GOTO 62
  63  N=N+1
      IH(N)=IH(K)
      IK(N)=IK(K)
      IL(N)=IL(K)
      DH(N)=DH(K)
      FH(N)=U/W
      IF(I.LE.K+1)GOTO 64
      T=REAL(I-K)
      S=V-U*FH(N)
      RA=RA+S*T
      RB=RB+V*(T-1.)
      IF(S.LT.T-1.)GOTO 64
      W=W*(T-1.)/S
  64  W=SQRT(W)
      SH(N)=1./W
      RC=RC+2.*FH(N)/W
      RD=RD+FH(N)**2
      GOTO 61
  65  RA=SQRT(RA/RB)
      RC=RC/RD
      LE=N
C
C Find resolution boundaries for division into 10 approx. equal groups
C
      QD(1)=0.
      QD(11)=999.
        DO 66 I=1,2000
        IM(I)=0
  66    CONTINUE
        DO 67 I=1,LE
        P=ABS(DH(I))
        IF(QD(1).LT.P)QD(1)=P
        IF(QD(11).GT.P)QD(11)=P
        J=MAX0(1,2000-INT(100.*P))
        IM(J)=IM(J)+1
  67    CONTINUE
      J=0
      M=0
        DO 69 I=1,9
        L=I*LE/10
  68    J=J+1
        M=M+IM(J)
        IF(M.LT.L)GOTO 68
        QD(I+1)=REAL(2000-J)*0.01
  69    CONTINUE
        DO 70 I=1,11
        QD(I)=1./AMAX1(0.0001,QD(I)**2)
  70    CONTINUE
C
C Find epsilon values
C
        DO 73 I=1,LE
        X=REAL(IH(I))
        Y=REAL(IK(I))
        Z=REAL(IL(I))
        S=0.
          DO 72 K=121,LY,12
          NH=INT(1.001*(X*A(K)+Y*A(K+3)+Z*A(K+6)))
          NK=INT(1.001*(X*A(K+1)+Y*A(K+4)+Z*A(K+7)))
          NL=INT(1.001*(X*A(K+2)+Y*A(K+5)+Z*A(K+8)))
          IF(NH.NE.IH(I))GOTO 71
          IF(NK.NE.IK(I))GOTO 71
          IF(NL.NE.IL(I))GOTO 71
          S=S+1.
  71      IF(NH.NE.-IH(I))GOTO 72
          IF(NK.NE.-IK(I))GOTO 72
          IF(NL.NE.-IL(I))GOTO 72
          IF(A(62).GT.0.)S=S+1.
          IF(A(62).LT.0.)DH(I)=-ABS(DH(I))
  72      CONTINUE
        CP(I)=SQRT(S)
  73    CONTINUE
C
C Estimate E-values
C
      R=20.*A(61)**2
        DO 74 I=1,20
        BP(I)=0.
        BP(I+20)=0.
        IM(I)=0
        BP(I+40)=.1*REAL(I+7)
  74    CONTINUE
        DO 75 I=1,LE
        P=AMAX1(1.0001,R/DH(I)**2)
        N=MIN0(INT(P),19)
        P=P-REAL(N)
        Q=1.-P
        T=(FH(I)/CP(I))**2
        BP(N)=BP(N)+Q*T
        BP(N+1)=BP(N+1)+P*T
        BP(N+20)=BP(N+20)+Q
        BP(N+21)=BP(N+21)+P
  75    CONTINUE
        DO 76 I=1,20
        BP(I)=BP(I+20)/AMAX1(BP(I),0.0001)
  76    CONTINUE
      S=0.
      T=0.
        DO 78 I=1,LE
        P=AMAX1(1.0001,R/DH(I)**2)
        N=MIN0(INT(P),19)
        P=P-REAL(N)
        Q=1.-P
        P=SQRT(BP(N)*Q+BP(N+1)*P)
        SH(I)=SH(I)*P
        EH(I)=SQRT(SQRT(1./(.00390625+1./AMAX1(0.01,P*FH(I))**4)))
        N=MIN0(18,INT(10.*EH(I)-7.))
          DO 77 J=1,N
          IM(J)=IM(J)+1
  77      CONTINUE
        IF(DH(I).LT.0.)GOTO 78
        IF(CP(I).GT.1.1)GOTO 78
        S=S+ABS(EH(I)**2-1.)
        T=T+1.
  78    CONTINUE
      S=S/T
      WRITE(LI,6)LE,RA,RC,S
      WRITE(*,7)LE,RA,RC,S
      WRITE(LI,9)(BP(I),I=43,53),BP(58),(IM(I),I=3,13),IM(18)
C
C Expand to triclinic hemisphere
C
      IF(A(20).GT.0.)GOTO 86
      A(20)=ABS(A(20))
      A(62)=-ABS(A(62))
      A(42)=-A(62)
      IF(ABS(A(42)).GT.4.5)A(42)=2.
      LL=LE
        DO 83 I=1,LL
        X=REAL(IH(I))
        Y=REAL(IK(I))
        Z=REAL(IL(I))
        M=LE
          DO 82 K=133,LY,12
          NH=INT(1.001*(X*A(K)+Y*A(K+3)+Z*A(K+6)))
          NK=INT(1.001*(X*A(K+1)+Y*A(K+4)+Z*A(K+7)))
          NL=INT(1.001*(X*A(K+2)+Y*A(K+5)+Z*A(K+8)))
          S=1.
          L=NL
          IF(L.EQ.0)L=NK
          IF(L.EQ.0)L=NH
          IF(L.GE.0)GOTO 79
          S=-S
          NH=-NH
          NK=-NK
          NL=-NL
  79      J=M
          IF(NH.NE.IH(I))GOTO 80
          IF(NK.NE.IK(I))GOTO 80
          IF(NL.EQ.IL(I))GOTO 82
  80      J=J+1
          IF(J.GT.LE)GOTO 81
          IF(NH.NE.IH(J))GOTO 80
          IF(NK.NE.IK(J))GOTO 80
          IF(NL.NE.IL(J))GOTO 80
          GOTO 82
  81      IF(LE.GE.LD)CALL SXER('ARRAYS TOO SMALL - INCREASE LD')
          LE=LE+1
          IH(LE)=NH
          IK(LE)=NK
          IL(LE)=NL
          FH(LE)=FH(I)
          SH(LE)=SH(I)
          EH(LE)=EH(I)
          RP(LE)=0.
  82      CONTINUE
  83    CONTINUE
      CALL SXIS(LE,IN,IH,IK,IL,FH,SH,EH,DH,AH,BH,AR,BR,RP,BP,CP)
      CALL SXIS(LE,IN,IK,IL,IH,FH,SH,EH,DH,AH,BH,AR,BR,RP,BP,CP)
      CALL SXIS(LE,IN,IL,IH,IK,FH,SH,EH,DH,AH,BH,AR,BR,RP,BP,CP)
        DO 84 I=1,LE
        U=REAL(IH(I))
        V=REAL(IK(I))
        W=REAL(IL(I))
        DH(I)=1./SQRT(U**2*A(14)+V**2*A(15)+W**2*A(16)+V*W*A(17)+
     +  U*W*A(18)+U*V*A(19))
        CP(I)=1.
  84    CONTINUE
      L=LS
      LS=131
        DO 85 I=LY+12,L,2
        LS=LS+2
        A(LS)=A(I)
        A(LS+1)=A(I+1)
  85    CONTINUE
      LY=121
      WRITE(LI,10)LE
      WRITE(*,10)LE
C
C Print parameter summary
C
  86  A(41)=.5-SIGN(.5,A(62))
      WRITE(*,11)
      WRITE(LI,11)
      J=NINT(A(50))
      WRITE(*,12)A(31),A(32),A(63),A(64),A(43),JR
      K=NINT(A(109))
      IF(K.LT.0)WRITE(*,13)NINT(A(110)),A(24),A(25),NINT(ABS(A(109)))
      IF(K.GT.0.AND.A(24).GT.0.)WRITE(*,14)NINT(A(24)),NINT(A(109)),
     +NINT(A(110))
      IF(K.GT.0.AND.A(24).LT.0.)WRITE(*,15)A(24),NINT(A(109)),
     +NINT(A(110))
      IF(K.GT.0.OR.A(63).LT.0.)WRITE(*,16)A(65),A(66)
      IF(NINT(A(44)).NE.0)WRITE(*,17)NINT(A(44)),MAX0(0,NINT(A(45))),
     +NINT(A(26)),A(27)
      IF(NINT(A(45)).GT.0)WRITE(*,18)A(48),A(49),NINT(A(23)),A(67)
      IF(NINT(A(44)).NE.0)WRITE(*,19)A(46),A(47),A(33)
      WRITE(*,20)A(21),A(22)
      IF(J.GT.0)WRITE(*,21)(NINT(A(I+50)),I=1,J)
      WRITE(*,22)A(40)
      IF(J.GT.0)WRITE(*,23)NINT(A(68)),NINT(A(112)),A(113),NINT(A(114))
      IF(NINT(A(50)).NE.0.OR.NINT(A(44)).NE.0)WRITE(*,24)NINT(A(111))
      WRITE(LI,12)A(31),A(32),A(63),A(64),A(43),JR
      IF(ZW(1).GT.-98.)WRITE(*,25)(ZW(I),I=1,10)
      IF(K.LT.0)WRITE(LI,13)NINT(A(110)),A(24),A(25),NINT(ABS(A(109)))
      IF(K.GT.0.AND.A(24).GT.0.)WRITE(LI,14)NINT(A(24)),NINT(A(109)),
     +NINT(A(110))
      IF(K.GT.0.AND.A(24).LT.0.)WRITE(LI,15)A(24),NINT(A(109)),
     +NINT(A(110))
      IF(K.GT.0.OR.A(63).LT.0.)WRITE(LI,16)A(65),A(66)
      IF(NINT(A(44)).NE.0)WRITE(LI,17)NINT(A(44)),MAX0(0,NINT(A(45))),
     +NINT(A(26)),A(27)
      IF(NINT(A(45)).GT.0)WRITE(LI,18)A(48),A(49),NINT(A(23)),A(67)
      IF(NINT(A(44)).NE.0)WRITE(LI,19)A(46),A(47),A(33)
      WRITE(LI,20)A(21),A(22)
      IF(J.GT.0)WRITE(LI,21)(NINT(A(I+50)),I=1,J)
      WRITE(LI,22)A(40)
      IF(J.GT.0)WRITE(LI,23)NINT(A(68)),NINT(A(112)),A(113),NINT(A(114))
      IF(NINT(A(50)).NE.0.OR.NINT(A(44)).NE.0)WRITE(LI,24)NINT(A(111))
      IF(ZW(1).GT.-98.)WRITE(LI,25)(ZW(I),I=1,10)
      WRITE(LI,11)
      WRITE(*,11)
C
C Set up lattice / inversion operators
C
      M=INT(ABS(A(62)))
      N=3*M
      BP(1)=0.
      BP(2)=0.
      BP(3)=0.
        DO 87 I=4,12
        BP(I)=.5
  87    CONTINUE
      IF(N.LT.12)GOTO 89
      IF(N.GT.12)GOTO 91
        DO 88 I=4,12,4
        BP(I)=0.
  88    CONTINUE
  89  IF(N.NE.9)GOTO 92
        DO 90 I=4,9
        BP(I)=.6666667
  90    CONTINUE
      BP(5)=.3333333
      BP(6)=.3333333
      BP(7)=.3333333
      GOTO 92
  91  BP(M-1)=0.
      N=4
  92  LV=65
      S=1.
  93    DO 94 J=1,N,3
        LV=LV+4
        A(LV)=S
        A(LV+1)=BP(J)+99.5
        A(LV+2)=BP(J+1)+99.5
        A(LV+3)=BP(J+2)+99.5
  94    CONTINUE
      S=-S
      IF(A(62)*S.LT.0.)GOTO 93
C
C Trigonometric tables for interpolation
C
        DO 95 I=1,12501
        SC(I)=SIN(6.283185E-4*REAL(I-1))
  95    CONTINUE
        DO 96 I=1,1440
        BT(I)=COS(.0174533*REAL(I))
  96    CONTINUE
        DO 97 I=1441,6440
        T=0.001*REAL(I-1441)
        BT(I)=AMIN1(T*(.5658+T*(T*.0106-.1304)),T/(.56+T))
  97    CONTINUE
      IF(JR.EQ.0)JR=JS
      JS=MOD(JR,139968)
      JK=0
      FM=0.
      RM=0.
      HP=0.
      LO=0
      LU=0
      NP=LW
      PC=0.
      PP=0.
      FW=0.
      PW=0.
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SX1C(LM,LD,IM,IN,IH,IK,IL,JH,JL,FH,SH,EH,
     +AH,BH,AR,BR,DH,RP,CP,BP,IS,XA,YA,ZA,HA,IW,IY,IZ,SC,BT,A)
C
C Solve phase problem by dual space tangent / random omit iteration
C
      CHARACTER::KA(94)*2,KN*4,KK*4,KR*20,NM*80,KF(60)*81
      INTEGER::IM(LD),IN(LD),IH(LD),IK(LD),IL(LD),IS(LM),
     +JH(LD),JL(LD),IW(LD),IY(LD),IZ(LD)
      REAL::FH(LD),SH(LD),EH(LD),AH(LD),BH(LD),AR(LD),BR(LD),DH(LD),
     +RP(LD),CP(LD),BP(LD),XA(LM),YA(LM),ZA(LM),HA(LM),
     +A(596),SC(12501),BT(6440),D(18)
      REAL,ALLOCATABLE,DIMENSION(:)::B
      COMMON/FLAGS/ST,SL,LF,LI,LP,LR,LN,LZ,LY,LE,LW,LS,LV,LQ,JU,
     +LO,LG,LU,LX,NP,MP,JR,JS,JK,JW,FM,RM,PC,PP,HP,FW,PW,WX
      COMMON/FILE/NM,KF
      COMMON/ATSYM/KA
C
   1  FORMAT(2F9.3)
   2  FORMAT(' Number of phase relations per reflection limited ',
     +'by available memory')
   3  FORMAT(I7,' E >',F6.3,',  average of',F7.1,
     +' TPR for each phase,  <wt.av.cos> =',F6.3)
   4  FORMAT(' Try',I6,', CC All/Weak',F6.2,' /',F6.2,', best',F6.2,
     +' /',F6.2,', best ',A,F6.2)
   5  FORMAT(2A)
   6  FORMAT(' PATFOM',F7.2)
   7  FORMAT(/4X,'x',7X,'y',7X,'z      sof  height')
   8  FORMAT('REM TRY',I7,'   CC',F6.2,'   CC(weak)',F6.2,
     +'   TIME',I8,' SECS'/'REM ')
   9  FORMAT(A4,I4,3F10.6,F9.4,'  0.2')
  10  FORMAT(A)
  11  FORMAT(3F8.5,F7.3,F7.2)
  12  FORMAT(/' Minimum distances (top row, 0 if special position)',
     +' and PSMF (bottom row)'//
     +' Peak    x      y      z      self  cross-vectors')
  13  FORMAT(/F5.1,F8.4,2F7.4,F7.1,F6.1,17F5.1)
  14  FORMAT(27X,F7.1,F6.1,17F5.1)
C
      CALL SXTO(1)
      MC=NINT(A(45))
      MT=NINT(ABS(A(45)*A(48)))
      IF(ABS(A(48)).LT.0.9999)MT=MIN0(MT,MC-1)
      IF(MC.LE.1.AND.NINT(A(109)).NE.0)MT=0
      MX=NINT(ABS(A(44)))
      NW=0
      IF(LG.GT.LM)GOTO 17
      IF(A(109).GE.0.)GOTO 17
C
C Move fragment centroid to 0 0 0
C
      U=0.
      V=0.
      W=0.
      T=0.
        DO 15 I=LG,LM
        U=U+XA(I)
        V=V+YA(I)
        W=W+ZA(I)
        T=T+1.
  15    CONTINUE
      U=U/T
      V=V/T
      W=W/T
        DO 16 I=LG,LM
        XA(I)=XA(I)-U
        YA(I)=YA(I)-V
        ZA(I)=ZA(I)-W
  16    CONTINUE
C
C Find restricted phases and epsilon values
C
  17    DO 21 I=1,LE
        AH(I)=0.
        BH(I)=0.
        X=REAL(IH(I))
        Y=REAL(IK(I))
        Z=REAL(IL(I))
        S=0.
          DO 20 K=121,LY,12
          NH=NINT(X*A(K)+Y*A(K+3)+Z*A(K+6))
          NK=NINT(X*A(K+1)+Y*A(K+4)+Z*A(K+7))
          NL=NINT(X*A(K+2)+Y*A(K+5)+Z*A(K+8))
          IF(NH.NE.IH(I))GOTO 18
          IF(NK.NE.IK(I))GOTO 18
          IF(NL.NE.IL(I))GOTO 18
          S=S+1.
          GOTO 20
  18      IF(NH.NE.-IH(I))GOTO 20
          IF(NK.NE.-IK(I))GOTO 20
          IF(NL.NE.-IL(I))GOTO 20
          IF(A(62).LT.0.)GOTO 19
          S=S+1.
          GOTO 20
  19      T=3.141593*(X*A(K+9)+Y*A(K+10)+Z*A(K+11))
          Q=COS(T)
          AH(I)=ABS(Q)
          T=SIN(T)
          IF(AH(I).LT.0.01)Q=T
          BH(I)=T*SIGN(1.,Q)
          DH(I)=-ABS(DH(I))
  20      CONTINUE
        CP(I)=SQRT(S)
        IN(I)=0
        IF(ABS(DH(I)).LT.A(47))GOTO 21
        IF(EH(I).GE.A(46)*CP(I))IN(I)=1
  21    CONTINUE
C
C Expanded list of E-values for FIND using ESEL parameters
C
      NP=LW
      LL=LE
      IF(MX+NINT(ABS(A(109))).EQ.0)GOTO 97
      IF(MX.EQ.0)GOTO 63
        DO 22 I=1,LE
        BP(I)=0.
  22    CONTINUE
      IF(LO.EQ.0)GOTO 24
      I=0
  23  I=I+1
      J=JH(I)
      IF(J.EQ.0)GOTO 25
      BP(J)=1.
      GOTO 23
  24  JH(1)=0
  25  LL=LE
      NS=LE+1
      NT=0
        DO 34 I=1,LE
        IF(MT.EQ.0)GOTO 26
        IF(BP(I).GT.0.5)GOTO 27
        IF(LO.GT.0)GOTO 34
  26    IF(ABS(DH(I)).LT.A(47))GOTO 34
        IF(EH(I).LT.A(46)*CP(I))GOTO 34
        BP(I)=1.
  27    NT=NT+1
        X=REAL(IH(I))
        Y=REAL(IK(I))
        Z=REAL(IL(I))
        M=LL
          DO 33 K=121,LY,12
          NH=NINT(X*A(K)+Y*A(K+3)+Z*A(K+6))
          NK=NINT(X*A(K+1)+Y*A(K+4)+Z*A(K+7))
          NL=NINT(X*A(K+2)+Y*A(K+5)+Z*A(K+8))
          J=M
  28      J=J+1
          IF(J.GT.LL)GOTO 29
          IF(NH.NE.IH(J))GOTO 28
          IF(NK.NE.IK(J))GOTO 28
          IF(NL.NE.IL(J))GOTO 28
          GOTO 30
  29      IF(LL.GE.LD)CALL SXER('ARRAYS TOO SMALL - INCREASE LD')
          LL=LL+1
          IH(LL)=NH
          IK(LL)=NK
          IL(LL)=NL
          EH(LL)=EH(I)/CP(I)
          IF(A(23).LT.0.)EH(LL)=EH(LL)/(1.+(SH(I)/CP(I))**2)
          DH(LL)=719999.-360.*(X*A(K+9)+Y*A(K+10)+Z*A(K+11))
          SH(LL)=57.29578
          RP(LL)=REAL(I)+0.1
  30      J=M
  31      J=J+1
          IF(J.GT.LL)GOTO 32
          IF(NH+IH(J).NE.0)GOTO 31
          IF(NK+IK(J).NE.0)GOTO 31
          IF(NL+IL(J).NE.0)GOTO 31
          GOTO 33
  32      LL=LL+1
          IH(LL)=-NH
          IK(LL)=-NK
          IL(LL)=-NL
          EH(LL)=EH(I)/CP(I)
          IF(A(23).LT.0.)EH(LL)=EH(LL)/(1.+(SH(I)/CP(I))**2)
          DH(LL)=719999.+360.*(X*A(K+9)+Y*A(K+10)+Z*A(K+11))
          SH(LL)=-57.29578
          RP(LL)=REAL(I)+0.1
  33      CONTINUE
  34    CONTINUE
      N=LL-LE
      CALL SXIS(N,IM,IH(NS),IK(NS),IL(NS),EH(NS),DH(NS),SH(NS),
     +FH(NS),AH(NS),BH(NS),AR(NS),BR(NS),RP(NS),BP(NS),CP(NS))
      CALL SXIS(N,IM,IK(NS),IL(NS),IH(NS),EH(NS),DH(NS),SH(NS),
     +FH(NS),AH(NS),BH(NS),AR(NS),BR(NS),RP(NS),BP(NS),CP(NS))
      CALL SXIS(N,IM,IL(NS),IH(NS),IK(NS),EH(NS),DH(NS),SH(NS),
     +FH(NS),AH(NS),BH(NS),AR(NS),BR(NS),RP(NS),BP(NS),CP(NS))
      IF(MT.GT.0)GOTO 36
        DO 35 I=1,LE
        IN(I)=1
        IF(BP(I).LT.0.0001)IN(I)=0
  35    CONTINUE
      GOTO 63
  36  J=MAX0(LL,2000)
        DO 37 I=1,J
        IN(I)=0
  37    CONTINUE
        DO 38 I=NS,LL
        IM(I)=IH(I)+1000*(IK(I)+1000*IL(I))
  38    CONTINUE
      IF(LO.GT.0)GOTO 58
C
C Find TPR, sum E(H)*E(-K)*E(K-H) for reflection H
C
      CALL SXTO(2)
      J=LE
      P=0.
        DO 45 I=1,LE
        IF(BP(I).LT.0.0001)GOTO 45
        BP(I)=0.
        N=IH(I)+1000*(IK(I)+1000*IL(I))
        M=LL
  39    J=J+1
        K=IM(J)+IM(M)
        IF(K.LT.N)GOTO 39
        J=J-1
        L=J
  40    L=L+1
  41    IF(L.GT.M)GOTO 44
        K=IM(L)+IM(M)
        IF(K.LT.N)GOTO 40
        IF(K.GT.N)GOTO 43
        IF(INT(RP(L)).EQ.INT(RP(M)))GOTO 42
        IF(INT(RP(L)).EQ.I)GOTO 42
        IF(INT(RP(M)).EQ.I)GOTO 42
        T=EH(L)*EH(M)
        K=MIN0(INT(100.*T)+1,2000)
        IN(K)=IN(K)+1
        IF(A(23).LT.0.)T=T/(1.+(SH(I)/CP(I))**2)
        BP(I)=BP(I)+T*EH(I)/CP(I)
  42    L=L+1
  43    M=M-1
        GOTO 41
  44    BP(I)=SQRT(BP(I))
        P=AMAX1(P,BP(I))
  45    CONTINUE
C
C Eliminate reflections with no TPR and sort roughly on sum
C
      N=LE
        DO 46 I=NS,LL
        J=INT(RP(I))
        IF(BP(J).LT.0.001)GOTO 46
        N=N+1
        IH(N)=IH(I)
        IK(N)=IK(I)
        IL(N)=IL(I)
        IM(N)=IM(I)
        EH(N)=EH(I)
        SH(N)=SH(I)
        DH(N)=DH(I)
        RP(N)=RP(I)
  46    CONTINUE
      LL=N
      NT=0
      Q=P
  47  Q=Q-0.002*P
        DO 48 I=1,LE
        IF(BP(I).LT.Q)GOTO 48
        NT=NT+1
        JH(NT)=I
        BP(I)=0.
  48    CONTINUE
      IF(Q.GT.0.003*P)GOTO 47
      JH(NT+1)=0
      NJ=2000
      K=INT(ABS(A(23)))*NT
      IF(K.LT.LD)GOTO 49
      WRITE(*,2)
      WRITE(LI,2)
      K=LD
  49  K=K-IN(NJ)
      IF(K.LT.0)GOTO 50
      NJ=NJ-1
      IF(NJ.GT.0)GOTO 49
C
C Generate strongest ntpr TPR per phase, largest sums first
C
  50  NW=0
        DO 56 NI=1,NT
        J=LE
        I=JH(NI)
        N=IH(I)+1000*(IK(I)+1000*IL(I))
        M=LL
        L=LE
  51    L=L+1
  52    IF(L.GT.M)GOTO 55
        K=IM(L)+IM(M)
        IF(K.LT.N)GOTO 51
        IF(K.GT.N)GOTO 54
        IF(INT(RP(L)).EQ.INT(RP(M)))GOTO 53
        IF(INT(RP(L)).EQ.I)GOTO 53
        IF(INT(RP(M)).EQ.I)GOTO 53
        T=EH(L)*EH(M)
        IF(INT(100.*T).LT.NJ)GOTO 53
        NW=MIN0(NW+1,LD)
        IF(A(23).LT.0.)T=T/(1.+(SH(I)/CP(I))**2)
        IW(NW)=MIN0(INT(1000.*T*A(30)*EH(I)/CP(I)+1441.5),6440)
        IY(NW)=L
        IZ(NW)=M
  53    L=L+1
  54    M=M-1
        GOTO 52
  55    JL(NI)=NW
  56    CONTINUE
        DO 57 I=1,2000
        IN(I)=0
  57    CONTINUE
C
C Estimated function values
C
  58    DO 59 I=NS,LL
        J=INT(RP(I))
        IN(I)=IN(J)
        IN(J)=I
  59    CONTINUE
      IF(LO.GT.0)GOTO 63
      WX=0.
      P=0.
      NI=0
      J=0
  60  J=J+1
      I=JH(J)
      IF(I.EQ.0)GOTO 62
      NJ=JL(J)
      X=0.
        DO 61 K=NI+1,NJ
        L=IW(K)
        T=.001*REAL(L-1441)
        X=X+T*BT(L)
        WX=WX+T
  61    CONTINUE
      P=P+X
      NI=NJ
      GOTO 60
  62  WRITE(KR,1)A(46),A(47)
      IF(NT.LT.1)CALL SXER('NO REFLECTIONS WITH  E >'//KR(1:9)//
     +'  AND  d <'//KR(10:18))
      P=P/WX
      T=REAL(NW)/REAL(NT)
      WRITE(*,3)NT,A(46),T,P
      WRITE(LI,3)NT,A(46),T,P
  63  CALL SX1D(LM,LD,LL,MC,MT,MX,IM,IN,IH,IK,IL,JH,JL,FH,SH,
     +EH,AH,BH,AR,BR,DH,RP,CP,BP,IS,XA,YA,ZA,HA,IW,IY,IZ,SC,BT,A)
C
C Calculate correlation coefficient
C
      R=0.
      S=0.
      U=0.
      V=0.
      W=0.
      P=0.
        DO 64 I=1,LE
        WT=1./(A(40)+SH(I)**2)
        Q=AR(I)**2+BR(I)**2
        V=V+Q*WT
        Q=SQRT(Q)*WT
        R=R+Q
        S=S+Q*EH(I)
        U=U+EH(I)*WT
        W=W+WT
        P=P+EH(I)**2*WT
  64    CONTINUE
      PC=100.*(S*W-R*U)/SQRT(AMAX1((P*W-U**2)*(V*W-R**2),1.E-8))
      R=0.
      S=0.
      U=0.
      V=0.
      W=0.
      P=0.
        DO 65 I=1,LE
        IF(IABS(IN(I)).NE.0)GOTO 65
        WT=1./(A(40)+SH(I)**2)
        Q=AR(I)**2+BR(I)**2
        V=V+Q*WT
        Q=SQRT(Q)*WT
        R=R+Q
        S=S+Q*EH(I)
        U=U+EH(I)*WT
        W=W+WT
        P=P+EH(I)**2*WT
  65    CONTINUE
      PW=100.*(S*W-R*U)/SQRT(AMAX1((P*W-U**2)*(V*W-R**2),1.E-8))
      R=AMAX1(PW,FW)
      T=AMAX1(PC,FM)
      IF(INT(A(50)).EQ.0)GOTO 66
      WRITE(*,4)LO,PC,PW,T,R,'final CC',RM
      WRITE(LI,4)LO,PC,PW,T,R,'final CC',RM
      GOTO 67
  66  WRITE(*,4)LO,PC,PW,T,R,'PATFOM',HP
      WRITE(LI,4)LO,PC,PW,T,R,'PATFOM',HP
  67  FW=R
      IF(PC.LT.A(21))GOTO 68
      IF(PC+A(22).GT.FM)GOTO 69
  68  IF(RM+HP.LT.0.01)A(21)=A(21)-0.1
      CALL SXFN
      J=NINT(A(111))
      IF(J.NE.0.AND.LO.GE.J)JU=1
      IF(JU.NE.0)CALL SXEX
      FM=T
      GOTO 63
C
C Output shuffled atoms to .res file if best CC so far and no PLOP
C
  69  IF(PC.LE.FM)GOTO 86
      IF(NINT(A(50)).NE.0)GOTO 86
        DO 73 I=1,NP
        XX=XA(I)
        YY=YA(I)
        ZZ=ZA(I)
        S=9.E9
          DO 72 K=121,LY,12
          U=XX*A(K)+YY*A(K+1)+ZZ*A(K+2)+A(K+9)
          V=XX*A(K+3)+YY*A(K+4)+ZZ*A(K+5)+A(K+10)
          W=XX*A(K+6)+YY*A(K+7)+ZZ*A(K+8)+A(K+11)
            DO 71 J=1,I-1
              DO 70 L=69,LV,4
              X=A(L+1)+A(L)*U-XA(J)
              X=X-AINT(X)-0.5
              Y=A(L+2)+A(L)*V-YA(J)
              Y=Y-AINT(Y)-0.5
              Z=A(L+3)+A(L)*W-ZA(J)
              Z=Z-AINT(Z)-0.5
              T=A(8)*X**2+A(9)*Y**2+A(10)*Z**2+A(11)*Y*Z+
     +        A(12)*X*Z+A(13)*X*Y
              IF(T.GE.S)GOTO 70
              S=T
              XA(I)=XA(J)+X
              YA(I)=YA(J)+Y
              ZA(I)=ZA(J)+Z
  70          CONTINUE
  71        CONTINUE
  72      CONTINUE
  73    CONTINUE
      OPEN(UNIT=LP,FILE=NM(1:LN)//'.res',STATUS='OLD',IOSTAT=I)
      CLOSE(UNIT=LP,STATUS='DELETE',IOSTAT=I)
      OPEN(UNIT=LP,FILE=NM(1:LN)//'.res',STATUS='NEW',ERR=79)
      CALL SXTI(T)
      T=T-ST-86400.
  74  T=T+86400.
      IF(T.LT.0.)GOTO 74
      WRITE(LP,8)LO,PC,PW,INT(T)
        DO 75 I=1,LQ-1
        L=ICHAR(KF(I)(81:81))
        WRITE(LP,10)KF(I)(1:L)
  75    CONTINUE
      KK=KA(INT(0.1*(10.+A(LS))))//'00'
      IF(KK(2:2).EQ.' ')KK(2:2)='0'
        DO 78 I=1,NP
        KN=KK
        KN(4:4)=CHAR(48+MOD(I,10))
        KN(3:3)=CHAR(48+MOD(I/10,10))
        IF(KK(2:2).NE.'0')GOTO 76
        IF(I.GT.3599)GOTO 78
        KN(2:2)=CHAR(48+MOD(I/100,10))
        IF(I.LT.1000)GOTO 77
        KN(2:2)=CHAR(55+I/100)
        GOTO 77
  76    IF(I.LT.100)GOTO 77
        KN(3:3)=CHAR(55+I/10)
        IF(I.LT.360)GOTO 77
        J=I-360
        KN(4:4)=CHAR(65+MOD(J,26))
        J=J/26
        IF(J.GT.35)GOTO 78
        KN(3:3)=CHAR(48+J)
        IF(J.LT.10)GOTO 77
        KN(3:3)=CHAR(55+J)
  77    WRITE(LP,9)KN,(LS-LY-10)/2,XA(I),YA(I),ZA(I),
     +  HA(I)*BP(I)/HA(LX+1)
  78    CONTINUE
      IF(KF(LQ)(1:4).EQ.'HKLF')GOTO 80
      WRITE(LP,10)'HKLF 4','END '
      GOTO 81
  79  CALL SXER('CANNOT OPEN .res OR .pdb FILE ')
  80  L=ICHAR(KF(LQ)(81:81))
      WRITE(LP,10)KF(LQ)(1:L),'END '
  81  CLOSE(LP,STATUS='KEEP')
C
C Output atoms to PDB format file
C
      OPEN(UNIT=LP,FILE=NM(1:LN)//'.pdb',STATUS='OLD',IOSTAT=I)
      CLOSE(UNIT=LP,STATUS='DELETE',IOSTAT=I)
      OPEN(UNIT=LP,FILE=NM(1:LN)//'.pdb',STATUS='NEW',ERR=79)
        DO 82 I=1,3
        Q=1.74533E-2*A(I+4)
        D(I+12)=SIN(Q)
        D(I+15)=COS(Q)
  82    CONTINUE
        DO 83 I=1,12
        D(I)=0.
  83    CONTINUE
      D(1)=1./A(2)
      D(2)=-D(18)/(A(2)*D(15))
      T=SQRT(1.+2.*D(16)*D(17)*D(18)-D(16)**2-D(17)**2-D(18)**2)
      D(3)=(D(16)*D(18)-D(17))/(T*A(2)*D(15))
      D(6)=1./(A(3)*D(15))
      D(7)=(D(17)*D(18)-D(16))/(T*A(3)*D(15))
      D(11)=D(15)/(T*A(4))
      WRITE(LP,'(A6,3F9.3,3F7.2)')'CRYST1',(A(I),I=2,7)
        DO 84 I=4,12,4
        WRITE(LP,'(A5,I1,4X,3F10.6,5X,F10.5)')'SCALE',I/4,
     +  (D(J),J=I-3,I)
  84    CONTINUE
      M=0
        DO 85 I=1,NP
        M=M+1
        W=(ZA(I)-D(12))/D(11)
        V=(YA(I)-W*D(7)-D(8))/D(6)
        U=(XA(I)-V*D(2)-W*D(3)-D(4))/D(1)
        WRITE(LP,'(A6,I5,2X,A7,I6,4X,3F8.3,F6.3,A)')'HETATM',M,
     +  'S   HAT',M,U,V,W,HA(I)*BP(I)/HA(LX+1),' 20.00'
  85    CONTINUE
      WRITE(LP,'(A)')'END '
      CLOSE(LP,STATUS='KEEP')
C
C Prepare crossword table and calculate PATFOM
C
  86  IF(A(63).GT.-0.1)GOTO 97
      CALL SXTO(5)
      LK=NP*(NP+1)
      ALLOCATE(B(LK),STAT=I)
      IF(I.NE.0)GOTO 96
      P=0.
      W=0.
      ND=LV
      IF(A(62).GT.0.)ND=(LV+65)/2
      SS=99.9/HA(1)
      NT=-1
      MK=NINT(ABS(A(44)))
      IF(MK.EQ.0)MK=NP
        DO 91 I=1,NP
        MP=MIN0(18,I)
        HA(I)=SS*HA(I)
          DO 90 J=1,I
          IF(J.GT.MP.AND.J.LT.I)GOTO 90
          T=9.E9
          N=NP
            DO 89 K=121,LY,12
            S=1.
  87        N=N+1
            IF(N.GT.LM)CALL SXER('ARRAYS TOO SMALL - INCREASE LM')
            HA(N)=0.
            XA(N)=XA(I)-S*(XA(J)*A(K)+YA(J)*A(K+1)+ZA(J)*A(K+2)+
     +      A(K+9))
            YA(N)=YA(I)-S*(XA(J)*A(K+3)+YA(J)*A(K+4)+ZA(J)*A(K+5)+
     +      A(K+10))
            ZA(N)=ZA(I)-S*(XA(J)*A(K+6)+YA(J)*A(K+7)+ZA(J)*A(K+8)+
     +      A(K+11))
              DO 88 L=69,ND,4
              IF(J.EQ.I.AND.K+L.EQ.190)GOTO 88
              X=A(L+1)+XA(N)
              X=X-AINT(X)-0.5
              Y=A(L+2)+YA(N)
              Y=Y-AINT(Y)-0.5
              Z=A(L+3)+ZA(N)
              Z=Z-AINT(Z)-0.5
              T=AMIN1(T,A(8)*X**2+A(9)*Y**2+A(10)*Z**2+A(11)*Y*Z+
     +        A(12)*X*Z+A(13)*X*Y)
  88          CONTINUE
            S=-S
            IF(S+A(41).LT.-0.5)GOTO 87
  89        CONTINUE
          NT=NT+2
          IF(T.GT.8.E9)T=0.
          B(NT)=SQRT(T)
          L=NP+1
          CALL SXPS(N-NP,2,Q,A(66),XA(L),YA(L),ZA(L),HA(L),IM)
          Q=AMAX1(Q,0.)
          B(NT+1)=Q
          IF(I.GT.MK)GOTO 90
          IF(Q.GT.998.)GOTO 90
          P=P+Q
          W=W+1.
  90      CONTINUE
  91    CONTINUE
      PP=P/AMAX1(W,0.001)
      WRITE(LI,5)
      WRITE(*,6)PP
      WRITE(LI,6)PP
      WRITE(LI,7)
C
C If no PLOP requested write atoms to .lst file
C
      IF(NINT(A(50)).NE.0)GOTO 93
        DO 92 I=1,NP
        WRITE(LI,11)XA(I),YA(I),ZA(I),BP(I),HA(I)
  92    CONTINUE
C
C Write crossword table to .lst file if CC or PATFOM best so far
C
  93  IF(PC.LE.FM.AND.PP.LE.HP)GOTO 95
      WRITE(LI,12)
      N=-1
        DO 94 I=1,NP
        IF(MK.EQ.I-1)WRITE(LI,'(/127A1)')' ',('-',J=1,5*I+29)
        M=N+2*MIN0(18,I)
        IF(I.GT.MP)M=M+2
        WRITE(LI,13)HA(I),XA(I),YA(I),ZA(I),B(M),(B(J),J=N+2,M-2,2)
        WRITE(LI,14)B(M+1),(B(J),J=N+3,M-1,2)
        N=M
  94    CONTINUE
      WRITE(LI,11)
  95  DEALLOCATE(B)
      GOTO 97
  96  CALL SXER('CANNOT ALLOCATE ENOUGH WORKING SPACE MEMORY')
  97  RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SX1D(LM,LD,LL,MC,MT,MX,IM,IN,
     +IH,IK,IL,JH,JL,FH,SH,EH,AH,BH,AR,BR,DH,RP,CP,BP,IS,
     +XA,YA,ZA,HA,IW,IY,IZ,SC,BT,A)
C
C Inner loops of dual space tangent / random omit iteration
C
      CHARACTER::KS*4,KT*80
      INTEGER::IM(LD),IN(LD),IH(LD),IK(LD),IL(LD),IS(LM),
     +JH(LD),JL(LD),IW(LD),IY(LD),IZ(LD)
      REAL::FH(LD),SH(LD),EH(LD),AH(LD),BH(LD),AR(LD),BR(LD),DH(LD),
     +RP(LD),CP(LD),BP(LD),XA(LM),YA(LM),ZA(LM),HA(LM),
     +A(596),SC(12501),BT(6440)
      REAL,ALLOCATABLE,DIMENSION(:)::B,C
      COMMON/FLAGS/ST,SL,LF,LI,LP,LR,LN,LZ,LY,LE,LW,LS,LV,LQ,JU,
     +LO,LG,LU,LX,NP,MP,JR,JS,JK,JW,FM,RM,PC,PP,HP,FW,PW,WX
C
   1  FORMAT(1X,77('-'))
   2  FORMAT(/A,'Patterson (* indicates vector selected ',
     +'for search)'//4X,'X',7X,'Y',7X,'Z    Height   Mult   Length'/)
   3  FORMAT(3F8.4,F7.1,F8.4,F8.2,1X,A1)
   4  FORMAT(I6,' Reflections with E >',F6.3,' and d >',F6.3,
     +' in preliminary fragment search')
   5  FORMAT(' Try',I6,'. GROP CC(d>',F5.2,'A) =',F6.2,';',
     +I5,' packing tests of which',I5,' failed')
   6  FORMAT(/' ** No peaks in PSMF - try',I7,'  aborted **'/)
   7  FORMAT(A)
   8  FORMAT(' R =',F6.3,', Min.fun. =',F6.3,', <cos> =',F6.3,
     +', Ra =',F6.3)
C
C Outer and inner loop control
C
      NV=LV
      IF(A(62).GT.0.)NV=65+(LV-65)/2
   9  LO=LO+1
      IF(MAX0(MT,0)+LO.EQ.1)GOTO 10
      WRITE(*,1)
      WRITE(LI,1)
  10  LC=0
C
C Comment out non-standard Fortran-95 'CALL FLUSH' if necessary
C
      CALL FLUSH(LI)
C
C Calculate Patterson if required
C
      LX=0
      NI=0
      NJ=0
      IF(LO.GT.1)GOTO 19
      IF(A(63).LT.0.)GOTO 11
      IF(A(109).LT.0.5)GOTO 19
  11  J=MAX0(0,NINT(A(24)))
      IF(NINT(A(109)).EQ.0)GOTO 12
      IF(NINT(A(44)).NE.1)NI=J
  12  MP=NI*5+100
      N=JW-NI
      CALL SX1F(LM,LD,LL,IM,IN,IH,IK,IL,FH,SH,EH,AH,BH,
     +AR,BR,DH,RP,CP,BP,IS,XA,YA,ZA,HA,A,1)
      IF(A(65).GT.0.)WRITE(LI,2)' '
      IF(A(65).LT.0.)WRITE(LI,2)' Super-sharp '
        DO 16 J=1,NP
        T=9.E9
        Q=1.
  13      DO 14 L=69,LV,4
          U=A(L+1)+Q*A(L)*XA(J)
          U=U-AINT(U)-0.5
          V=A(L+2)+Q*A(L)*YA(J)
          V=V-AINT(V)-0.5
          W=A(L+3)+Q*A(L)*ZA(J)
          W=W-AINT(W)-0.5
          T=AMIN1(A(8)*U**2+A(9)*V**2+A(10)*W**2+A(11)*V*W+
     +    A(12)*U*W+A(13)*U*V,T)
  14      CONTINUE
        Q=-Q
        IF(Q.LT.0.)GOTO 13
        T=SQRT(T)
        KS=' '
        IF(JW.LE.N)GOTO 15
        IF(T.LT.ABS(A(63)))GOTO 15
        IF(BP(J).LT.0.9)GOTO 15
        KS='*'
        JW=JW-1
        XA(JW)=XA(J)
        YA(JW)=YA(J)
        ZA(JW)=ZA(J)
  15    WRITE(LI,3)XA(J),YA(J),ZA(J),HA(J)*999.9/HA(1),BP(J),T,KS
        IF(J.LT.50)GOTO 16
        IF(JW.EQ.N)GOTO 17
  16    CONTINUE
  17  IF(JW.LE.LM.OR.NI.EQ.0.OR.NINT(A(44)).EQ.1)GOTO 19
  18  CALL SXER('NO SUITABLE PATTERSON VECTORS FOUND')
C
C Outer PATS loop
C
  19  QQ=A(63)**2
      JP=NINT(A(109))
      IF(JP.EQ.0)GOTO 90
      QP=-9.E9
      JQ=NINT(ABS(A(110)))
      CALL SXTO(3)
      IF(JP.LT.0)GOTO 41
      XA(1)=0.
      YA(1)=0.
      ZA(1)=0.
      HA(1)=1.
      HA(2)=1.
      NQ=2
      LG=JW
      IF(NINT(A(44)).EQ.1)NQ=1
        DO 36 NH=1,JP
        IF(NINT(A(44)).EQ.1)GOTO 23
        IF(A(24).LT.0.)GOTO 21
C
C Choose biased random starting vector (PATS +n)
C
        NJ=LM-JW+1
        IF(NJ.LE.0)GOTO 18
        N=JW
          DO 20 NW=1,JQ
          JR=MOD(JR*1366+150889,714025)
          N=MAX0(N,LM-MOD(JR,NJ))
  20      CONTINUE
        XA(NQ)=XA(N)
        YA(NQ)=YA(N)
        ZA(NQ)=ZA(N)
        HA(NQ)=1.
        GOTO 23
C
C Best of nf random orientations for fixed length vector (PATS -d)
C
  21    QN=-9.E9
          DO 22 NW=1,JQ
          JS=MOD(JS*3877+29573,139968)
          JK=MOD(JK*3613+45289,214326)
          JR=MOD(JR*1366+150889,714025)
          R=4.4890156E-5*REAL(JS)
          S=2.9316020E-5*REAL(JK)
          W=8.7996713E-6*REAL(JR)
          P=COS(W)
          Q=SIN(W)
          U=COS(R)
          V=SIN(R)
          W=COS(S)
          T=SIN(S)
          TT=-A(24)*U
          R=TT*W
          S=TT*T
          N=LG-1
          ZA(N)=R*A(118)+S*A(119)+V*A(24)*A(120)
          YA(N)=R*A(116)+S*A(117)
          XA(N)=R*A(115)
          CALL SXPS(LG-N,2,Q,A(66),XA(N),YA(N),ZA(N),HA(N),IM)
          IF(Q.LT.QN)GOTO 22
          QN=Q
          XA(NQ)=XA(N)
          YA(NQ)=YA(N)
          ZA(NQ)=ZA(N)
          HA(NQ)=1.
  22      CONTINUE
C
C Apply random translation(s) to one atom or two atom vector
C
  23    NJ=NQ
        JS=MOD(JS*3877+29573,139968)
        JK=MOD(JK*3613+45289,214326)
        JR=MOD(JR*1366+150889,714025)
        X=7.1444902E-6*REAL(JS)
        Y=4.6657895E-6*REAL(JK)
        Z=1.4005112E-6*REAL(JR)
          DO 24 I=1,NQ
          NJ=NJ+1
          XA(NJ)=XA(I)+X
          YA(NJ)=YA(I)+Y
          ZA(NJ)=ZA(I)+Z
          HA(NJ)=HA(I)
  24      CONTINUE
C
C Special case of P1 - put extra atom on origin if only two atoms
C
        IF(LY.NE.121)GOTO 25
        IF(A(62).GT.0.)GOTO 25
        NJ=NJ+1
        XA(NJ)=0.
        YA(NJ)=0.
        ZA(NJ)=0.
        HA(NJ)=1.
C
C Generate symmetry equivalents
C
  25    NS=NJ
          DO 29 K=121,LY,12
          S=1.
          IF(K.EQ.121)GOTO 28
  26        DO 27 J=NQ+1,NS
            NJ=NJ+1
            XA(NJ)=S*(XA(J)*A(K)+YA(J)*A(K+1)+ZA(J)*A(K+2)+A(K+9))
            YA(NJ)=S*(XA(J)*A(K+3)+YA(J)*A(K+4)+
     +      ZA(J)*A(K+5)+A(K+10))
            ZA(NJ)=S*(XA(J)*A(K+6)+YA(J)*A(K+7)+
     +      ZA(J)*A(K+8)+A(K+11))
            HA(NJ)=HA(J)
  27        CONTINUE
  28      S=-S
          IF(S*A(62).LT.0.)GOTO 26
  29      CONTINUE
C
C Generate all independent vectors, check distances and calculate PSMF
C
          DO 32 I=NQ+1,NS
            DO 31 J=NS+1,NJ
              DO 30 L=69,NV,4
              X=A(L+1)+XA(J)-XA(I)
              X=X-AINT(X)-0.5
              Y=A(L+2)+YA(J)-YA(I)
              Y=Y-AINT(Y)-0.5
              Z=A(L+3)+ZA(J)-ZA(I)
              Z=Z-AINT(Z)-0.5
              IF(A(8)*X**2+A(9)*Y**2+A(10)*Z**2+A(11)*Y*Z+
     +        A(12)*X*Z+A(13)*X*Y.LT.QQ)GOTO 36
  30          CONTINUE
  31        CONTINUE
  32      CONTINUE
        N=LG
          DO 34 I=NQ+1,NS
            DO 33 J=I+1,NJ
            N=N-1
            XA(N)=99.5+XA(J)-XA(I)
            XA(N)=XA(N)-AINT(XA(N))-0.5
            YA(N)=99.5+YA(J)-YA(I)
            YA(N)=YA(N)-AINT(YA(N))-0.5
            ZA(N)=99.5+ZA(J)-ZA(I)
            ZA(N)=ZA(N)-AINT(ZA(N))-0.5
  33        CONTINUE
  34      CONTINUE
        IF(N.EQ.LG)GOTO 36
        CALL SXPS(LG-N,2,Q,A(66),XA(N),YA(N),ZA(N),HA(N),IM)
        IF(Q.LT.QP)GOTO 36
        QP=Q
        LG=JW
          DO 35 I=NQ+1,NJ
          LG=LG-1
          XA(LG)=99.5+XA(I)
          YA(LG)=99.5+YA(I)
          ZA(LG)=99.5+ZA(I)
          HA(LG)=HA(I)
  35      CONTINUE
  36    CONTINUE
C
C Call SX1F to find peaks using full-symmetry PSMF
C
      MP=MIN0(MX+8,LG-1-NJ)
      CALL SX1F(LM,LD,LL,IM,IN,IH,IK,IL,FH,SH,EH,AH,BH,
     +AR,BR,DH,RP,CP,BP,IS,XA,YA,ZA,HA,A,3)
      KT=' '
      WRITE(KT,'(A,F10.2,A)')'#PSUM#',QP,'##PSMF#Peaks:'
      K=0
        DO 37 I=1,30
        IF(KT(I:I).EQ.' ')GOTO 37
        K=K+1
        KT(K:K)=KT(I:I)
        IF(KT(K:K).EQ.'#')KT(K:K)=' '
  37    CONTINUE
      KT(K+1:80)=' '
        DO 40 I=LX+1,NP
        AH(I)=HA(I)
        IS(I)=51
        IF(K.GE.77)GOTO 40
        J=NINT(HA(I))
        WRITE(KS,'(I4)')J
        K=K+1
        L=K
          DO 38 J=1,4
          IF(KS(J:J).EQ.' ')GOTO 38
          K=K+1
          IF(K.GT.77)GOTO 39
          KT(K:K)=KS(J:J)
  38      CONTINUE
        GOTO 40
  39    K=78
        KT(L:80)=' '
  40    CONTINUE
      WRITE(*,7)KT(1:77)
      WRITE(LI,7)
      WRITE(LI,7)KT(1:77)
      IF(MX.NE.0)NP=MIN0(NP,MX)
      LC=1
      IF(NP.GT.0)GOTO 95
      WRITE(*,6)LO
      WRITE(LI,6)LO
      CALL SXTO(5)
      GOTO 9
C
C Set up GROP fragment search - select reflections
C
  41  CALL SXTO(7)
      JP=IABS(JP)
      MS=(LY-109)/2
      ALLOCATE(B(MS*LE),STAT=I)
      IF(I.NE.0)GOTO 120
      NX=1
      NY=1
      NZ=1
      IF(A(62).GT.0.)GOTO 43
      NX=0
      NY=0
      NZ=0
        DO 42 K=133,LY,12
        IF(ABS(A(K)-1.)+ABS(A(K+1))+ABS(A(K+2)).GT.0.1)NX=1
        IF(ABS(A(K+3))+ABS(A(K+4)-1.)+ABS(A(K+5)).GT.0.1)NY=1
        IF(ABS(A(K+6))+ABS(A(K+7))+ABS(A(K+8)-1.).GT.0.1)NZ=1
  42    CONTINUE
      IF(NX+NY+NZ.EQ.0)JP=-JP
  43  NP=LM-LG+1
      IF(4*NP.GT.LM)CALL SXER('ARRAY DIMENSION LM TOO SMALL')
      MB=-5
        DO 48 L=1,2
        MA=MB
          DO 47 I=1,LE
          IF(ABS(DH(I)).LT.ABS(A(25)))GOTO 47
          IF(EH(I).LT.A(24)*ABS(CP(I)))GOTO 44
          IF(MA.GT.0)GOTO 47
          GOTO 45
  44      IF(MA.LT.0)GOTO 47
  45      X=10000.*REAL(IH(I))
          Y=10000.*REAL(IK(I))
          Z=10000.*REAL(IL(I))
          T=EH(I)**2
          B(MB+6)=EH(I)
            DO 46 K=121,LY,12
            MB=MB+6
            B(MB+1)=X*A(K)+Y*A(K+3)+Z*A(K+6)
            B(MB+2)=X*A(K+1)+Y*A(K+4)+Z*A(K+7)
            B(MB+3)=X*A(K+2)+Y*A(K+5)+Z*A(K+8)
            IF(K.EQ.121)GOTO 46
            B(MB)=REAL(MOD(MOD(NINT(X*A(K+9)+Y*A(K+10)+Z*A(K+11)),
     +      10000)+10000,10000)+1)
  46        CONTINUE
  47      CONTINUE
  48    CONTINUE
      T=AMAX1(ABS(A(25)),A(61))
      IF(LO.GT.1)GOTO 49
      I=(MA+5)/MS
      WRITE(*,4)I,ABS(A(24)),T
      WRITE(LI,4)
      WRITE(LI,4)I,ABS(A(24)),T
      WRITE(LI,4)
      IF(MA.LT.10*MS)CALL SXER('TOO FEW DATA FOR PRELIMINARY '//
     +'FRAGMENT SEARCH')
  49  T=0.5*T
      DX=T/A(2)
      DY=T/A(3)
      DZ=T/A(4)
C
C Prepare packing test
C
      QM=0.
      QL=0.
      T=0.
      J=0
        DO 50 I=LG,LM
        J=J+1
        IS(J)=IS(I)
        BP(J)=1.
        HA(J)=HA(I)
        HA(J+NP)=REAL(IS(I)+9)*HA(I)
        HA(J+2*NP)=HA(J+NP)
        S=XA(I)**2+YA(I)**2+ZA(I)**2
        T=AMAX1(S,T)
  50    CONTINUE
      RA=(SQRT(T)+1.)**2
      RB=(2.*SQRT(T)+1.)**2
C
C GROP orientation loop - generate random orientations
C
  51  QS=0.
        DO 56 NW=1,JQ
        JS=MOD(JS*3877+29573,139968)
        JK=MOD(JK*3613+45289,214326)
        JR=MOD(JR*1366+150889,714025)
        R=4.4890156E-5*REAL(JS)
        S=2.9316020E-5*REAL(JK)
        W=8.7996713E-6*REAL(JR)
        P=COS(W)
        Q=SIN(W)
        U=COS(R)
        V=SIN(R)
        W=COS(S)
        T=SIN(S)
        NJ=NP
          DO 52 I=LG,LM
          NJ=NJ+1
          S=YA(I)*P-ZA(I)*Q
          R=YA(I)*Q+ZA(I)*P
          SS=R*U-XA(I)*V
          TT=R*V+XA(I)*U
          R=TT*W-S*T
          S=TT*T+S*W
          ZA(NJ)=R*A(118)+S*A(119)+SS*A(120)
          YA(NJ)=R*A(116)+S*A(117)
          XA(NJ)=R*A(115)
  52      CONTINUE
C
C Filter orientations on Sum(Eo^2*Ec^2)
C
        Q=0.
        W=0.
          DO 54 I=1,MA,6
          IF(MOD(I,MS).EQ.1)W=B(I)**2
          U=0.
          V=0.
            DO 53 K=NP+1,NJ
            J=MOD(MOD(NINT(B(I+1)*XA(K)+B(I+2)*YA(K)+B(I+3)*ZA(K)),
     +      10000)+10000,10000)
            U=U+HA(K)*SC(J+2501)
            V=V+HA(K)*SC(J+1)
  53        CONTINUE
          Q=Q+W*(U**2+V**2*A(41))
  54      CONTINUE
        IF(Q.LT.QS)GOTO 56
        QS=Q
          DO 55 I=NP+1,NJ
          XA(I+NP)=XA(I)
          YA(I+NP)=YA(I)
          ZA(I+NP)=ZA(I)
  55      CONTINUE
  56    CONTINUE
C
C Calculate structure factors for all data in resolution range
C
      QN=0.
      QS=0.
      QT=0.
      NK=NJ+NP
        DO 59 I=1,MB,6
        U=0.
        V=0.
          DO 57 K=NJ+1,NK
          J=MOD(MOD(NINT(B(I+1)*XA(K)+B(I+2)*YA(K)+B(I+3)*ZA(K)),
     +    10000)+10000,10000)
          U=U+HA(K)*SC(J+2501)
          V=V+HA(K)*SC(J+1)
  57      CONTINUE
        IF(MOD(I,MS).NE.1)GOTO 58
        B(I+4)=U
        B(I+5)=V
        QN=QN+1.
        QS=QS+B(I)
        QT=QT+B(I)**2
        GOTO 59
  58    J=NINT(B(I))
        S=SC(J)
        T=SC(J+2500)
        B(I+4)=U*T-V*S
        B(I+5)=U*S+V*T
  59    CONTINUE
      QT=QT*QN-QS**2
C
C Correlation coefficient for P1 search
C
      MN=0
      MF=0
      IF(JP.GT.0)GOTO 63
      P=0.
      Q=0.
      R=0.
      X=0.
      Y=0.
      Z=0.
      W=0.
        DO 60 L=1,MB,6
        IF(MOD(L,MS).EQ.1)W=B(L)
        T=B(L+4)**2+B(L+5)**2*A(41)
        Q=Q+T
        T=SQRT(T)
        P=P+T
        R=R+T*W
        X=X+W
        Y=Y+W**2
        Z=Z+1.
  60    CONTINUE
      Q=100.*(R*Z-P*X)/SQRT((Y*Z-X**2)*(Q*Z-P**2))
      IF(Q.LT.QP)GOTO 62
      QP=Q
      J=2*NP
        DO 61 I=1,NP
        J=J+1
        XA(I)=XA(J)
        YA(I)=YA(J)
        ZA(I)=ZA(J)
  61    CONTINUE
  62  JP=JP+1
      IF(JP.LT.0)GOTO 51
      GOTO 89
C
C Refine translations from random starts
C
  63  DD=1.
        DO 87 NL=1,JP
        J=NP
        JS=MOD(JS*3877+29573,139968)
        JK=MOD(JK*3613+45289,214326)
        JR=MOD(JR*1366+150889,714025)
        X=7.1444902E-6*REAL(JS)
        Y=4.6657895E-6*REAL(JK)
        Z=1.4005112E-6*REAL(JR)
        M=0
  64    Q=0.
          DO 66 L=1,MA,MS
          S=0.
          T=0.
          K=L+MS-6
            DO 65 I=L,K,6
            J=MOD(MOD(NINT(B(I+1)*X+B(I+2)*Y+B(I+3)*Z),10000)
     +      +10000,10000)
            V=SC(J+1)
            U=SC(J+2501)
            T=T+B(I+4)*U-B(I+5)*V
            S=S+B(I+4)*V+B(I+5)*U
  65        CONTINUE
          Q=Q+B(L)*(T**2+S**2*A(41))
  66      CONTINUE
        IF(M.NE.0)GOTO 68
        DD=1.
  67    NI=NX
        NJ=0
        IF(NI.EQ.0)NJ=NY
        NK=0
        IF(NI.EQ.0.AND.NJ.EQ.0)NK=NZ
        M=2
        GOTO 70
  68    IF(M.EQ.1)GOTO 74
        IF(M.NE.2)GOTO 72
        M=3
        QL=Q
        IF(Q.LT.QM)GOTO 71
  69    QL=QM
  70    QM=Q
        IF(NI.EQ.1)X=X+DD*DX
        IF(NJ.EQ.1)Y=Y+DD*DY
        IF(NK.EQ.1)Z=Z+DD*DZ
        GOTO 64
  71    DD=-DD
        IF(NI.EQ.1)X=X+2.*DD*DX
        IF(NJ.EQ.1)Y=Y+2.*DD*DY
        IF(NK.EQ.1)Z=Z+2.*DD*DZ
        GOTO 64
  72    IF(Q.GE.QM)GOTO 69
        T=-DD
        IF(ABS(DD).GT.0.5)GOTO 73
        T=0.5*DD*(Q-QL)/AMAX1(1.E-6,2.*QM-QL-Q)-DD
        M=1
  73    IF(NI.EQ.1)X=X+T*DX
        IF(NJ.EQ.1)Y=Y+T*DY
        IF(NK.EQ.1)Z=Z+T*DZ
        NI=MIN0(NI,-NI)
        NJ=MIN0(NJ,-NJ)
        NK=MIN0(NK,-NK)
        IF(M.EQ.1)GOTO 64
        Q=QM
  74    M=2
        IF(NI+NX.NE.0)NI=1
        IF(NJ+NY.NE.0.AND.NI.NE.1)NJ=1
        IF(NK+NZ.NE.0.AND.NI.NE.1.AND.NJ.NE.1)NK=1
        IF(MAX0(NI,NJ,NK).EQ.1)GOTO 70
        DD=DD*0.4
        IF(ABS(DD).GT.0.3)GOTO 67
C
C Calculate correlation coefficient using all data in resolution range
C
        P=0.
        Q=0.
        R=0.
          DO 76 L=1,MB,MS
          S=0.
          T=0.
          K=L+MS-6
            DO 75 I=L,K,6
            J=MOD(MOD(NINT(B(I+1)*X+B(I+2)*Y+B(I+3)*Z),10000)
     +      +10000,10000)
            V=SC(J+1)
            U=SC(J+2501)
            T=T+B(I+4)*U-B(I+5)*V
            S=S+B(I+4)*V+B(I+5)*U
  75        CONTINUE
          T=T**2+S**2*A(41)
          Q=Q+T
          T=SQRT(T)
          P=P+T
          R=R+T*B(L)
  76      CONTINUE
        Q=100.*(QN*R-P*QS)/SQRT(QT*(Q*QN-P**2))
        IF(Q.LT.QP)GOTO 87
        NK=2*NP
          DO 77 I=NP+1,NK
          XA(I)=XA(I+NP)+X
          YA(I)=YA(I+NP)+Y
          ZA(I)=ZA(I+NP)+Z
  77      CONTINUE
C
C Packing tests
C
        IF(A(25).GE.0.)GOTO 85
        MN=MN+1
        NJ=3*NP
          DO 84 K=121,LY,12
            DO 83 L=69,LV,4
            R=A(L+1)+A(L)*(X*A(K)+Y*A(K+1)+Z*A(K+2)+A(K+9))
            S=A(L+2)+A(L)*(X*A(K+3)+Y*A(K+4)+Z*A(K+5)+A(K+10))
            T=A(L+3)+A(L)*(X*A(K+6)+Y*A(K+7)+Z*A(K+8)+A(K+11))
            IF(K+L.EQ.190)GOTO 78
            U=R-X
            U=U-AINT(U)-0.5
            V=S-Y
            V=V-AINT(V)-0.5
            W=T-Z
            W=W-AINT(W)-0.5
            IF(A(8)*U**2+A(9)*V**2+A(10)*W**2+A(11)*V*W+
     +      A(12)*U*W+A(13)*U*V.GT.RB)GOTO 83
  78        N=NJ
              DO 79 J=NP+1,NK
              N=N+1
              XA(N)=R+A(L)*(XA(J)*A(K)+YA(J)*A(K+1)+ZA(J)*A(K+2))
              YA(N)=S+A(L)*(XA(J)*A(K+3)+YA(J)*A(K+4)+ZA(J)*A(K+5))
              ZA(N)=T+A(L)*(XA(J)*A(K+6)+YA(J)*A(K+7)+ZA(J)*A(K+8))
  79          CONTINUE
            N=NJ
              DO 82 J=NP+1,NK
              M=N
              N=N+1
              IF(K+L.EQ.190)GOTO 80
              U=R-XA(J)
              U=U-AINT(U)-0.5
              V=S-YA(J)
              V=V-AINT(V)-0.5
              W=T-ZA(J)
              W=W-AINT(W)-0.5
              IF(A(8)*U**2+A(9)*V**2+A(10)*W**2+A(11)*V*W+
     +        A(12)*U*W+A(13)*U*V.GT.RA)GOTO 82
              M=N
  80            DO 81 I=NJ+1,M
                U=XA(I)-XA(J)
                U=U-AINT(U)-0.5
                V=YA(I)-YA(J)
                V=V-AINT(V)-0.5
                W=ZA(I)-ZA(J)
                W=W-AINT(W)-0.5
                IF(A(8)*U**2+A(9)*V**2+A(10)*W**2+A(11)*V*W+
     +          A(12)*U*W+A(13)*U*V.LT.1.)GOTO 87
  81            CONTINUE
  82          CONTINUE
  83        CONTINUE
  84      CONTINUE
        MF=MF+1
  85    QP=Q
          DO 86 I=1,NP
          XA(I)=XA(I+NP)
          YA(I)=YA(I+NP)
          ZA(I)=ZA(I+NP)
  86      CONTINUE
  87    CONTINUE
      IF(QP.GT.0.)GOTO 89
      WRITE(*,88)
      WRITE(LI,88)
      GOTO 51
  88  FORMAT(' ** All translations failed packing test - trying ',
     +'another orientation **')
  89  MF=MN-MF
      WRITE(*,5)LO,ABS(A(25)),QP,MN,MF
      WRITE(LI,5)LO,ABS(A(25)),QP,MN,MF
      DEALLOCATE(B)
      GOTO 95
C
C Pseudo-random starting atoms
C
  90  CALL SXTO(5)
      NP=0
      MX=NINT(A(44))
        DO 94 NI=1,2*MX+10
        J=NP+1
        JS=MOD(JS*3877+29573,139968)
        JK=MOD(JK*3613+45289,214326)
        JR=MOD(JR*1366+150889,714025)
        XA(J)=7.1444902E-6*REAL(JS)
        YA(J)=4.6657895E-6*REAL(JK)
        ZA(J)=1.4005112E-6*REAL(JR)
C
C Reject atom if too close to existing atom or special position
C
          DO 93 K=121,LY,12
            DO 92 L=69,LV,4
            X=A(L+1)+A(L)*(XA(J)*A(K)+YA(J)*A(K+1)+
     +      ZA(J)*A(K+2)+A(K+9))
            Y=A(L+2)+A(L)*(XA(J)*A(K+3)+YA(J)*A(K+4)+
     +      ZA(J)*A(K+5)+A(K+10))
            Z=A(L+3)+A(L)*(XA(J)*A(K+6)+YA(J)*A(K+7)+
     +      ZA(J)*A(K+8)+A(K+11))
              DO 91 I=1,J-1
              U=X-XA(I)
              U=U-AINT(U)-0.5
              V=Y-YA(I)
              V=V-AINT(V)-0.5
              W=Z-ZA(I)
              W=W-AINT(W)-0.5
              IF(A(8)*U**2+A(9)*V**2+A(10)*W**2+A(11)*V*W+
     +        A(12)*U*W+A(13)*U*V.LT.QQ)GOTO 94
  91          CONTINUE
            IF(K+L.EQ.190)GOTO 92
            U=X-XA(J)
            U=U-AINT(U)-0.5
            V=Y-YA(J)
            V=V-AINT(V)-0.5
            W=Z-ZA(J)
            W=W-AINT(W)-0.5
            IF(A(8)*U**2+A(9)*V**2+A(10)*W**2+A(11)*V*W+
     +      A(12)*U*W+A(13)*U*V.LT.6.25)GOTO 94
  92        CONTINUE
  93      CONTINUE
        NP=NP+1
        IS(NP)=LY+12
        BP(NP)=1.
        HA(NP)=1.
        IF(NP.EQ.MX)GOTO 95
  94    CONTINUE
      IF(NP.LT.1)CALL SXER('CELL TOO SMALL TO PLACE ATOMS RANDOMLY')
  95  CALL SXTO(5)
      IF(LC.GE.MC)GOTO 159
  96  LC=LC+1
        DO 97 I=1,LE
        AR(I)=0.
        BR(I)=0.
        IN(I)=IABS(IN(I))
  97    CONTINUE
C
C Weed out fraction of peaks at random (except first and last cycles)
C
      IF(A(33).LT.0.0001)GOTO 99
      IF(LC.EQ.1.OR.LC.GE.MC-1)GOTO 99
      J=NP
      NP=0
      N=MAX0(3,NINT((1.-A(33))*REAL(J)))
        DO 98 I=1,J
        JR=MOD(JR*1366+150889,714025)
        IF(NP+N.GT.I.AND.1.400511E-6*REAL(JR).LT.A(33))GOTO 98
        NP=NP+1
        IS(NP)=IS(I)
        XA(NP)=XA(I)
        YA(NP)=YA(I)
        ZA(NP)=ZA(I)
        HA(NP)=HA(I)
  98    CONTINUE
C
C Structure-factor calculation
C
  99  NP=MIN0(NP,12*(LM/(LY-109)))
      IF(LC.GT.MT)GOTO 121
      NP=MIN0(NP,MAX0(3,MX+NINT(A(26))))
      N=NP
        DO 101 J=1,NP
        X=XA(J)
        Y=YA(J)
        Z=ZA(J)
        RP(J)=HA(J)*BP(J)
          DO 100 K=133,LY,12
          N=N+1
          XA(N)=X*A(K)+Y*A(K+1)+Z*A(K+2)+A(K+9)
          YA(N)=X*A(K+3)+Y*A(K+4)+Z*A(K+5)+A(K+10)
          ZA(N)=X*A(K+6)+Y*A(K+7)+Z*A(K+8)+A(K+11)
          RP(N)=RP(J)
 100      CONTINUE
 101    CONTINUE
      IF(A(41).GT.0.1)GOTO 104
        DO 103 I=1,LE
        U=0.
        IF(IN(I).NE.0)THEN
        X=6.2831853*REAL(IH(I))
        Y=6.2831853*REAL(IK(I))
        Z=6.2831853*REAL(IL(I))
          DO 102 K=1,N
          U=U+RP(K)*COS(X*XA(K)+Y*YA(K)+Z*ZA(K))
 102      CONTINUE
        ENDIF
        AR(I)=U
        BR(I)=0.
 103    CONTINUE
      GOTO 107
 104    DO 106 I=1,LE
        U=0.
        V=0.
        IF(IN(I).NE.0)THEN
        X=6.2831853*REAL(IH(I))
        Y=6.2831853*REAL(IK(I))
        Z=6.2831853*REAL(IL(I))
          DO 105 K=1,N
          Q=X*XA(K)+Y*YA(K)+Z*ZA(K)
          V=V+RP(K)*SIN(Q)
          U=U+RP(K)*COS(Q)
 105      CONTINUE
        ENDIF
        AR(I)=U
        BR(I)=V
 106    CONTINUE
C
C Decide which reflections to hold in tangent refinement
C
 107  Q=-1.
        DO 108 I=1,LE
        IF(IN(I).LE.0)GOTO 108
        RP(I)=SQRT(AR(I)**2+BR(I)**2)
        Q=AMAX1(Q,RP(I))
 108    CONTINUE
        DO 109 I=1,1002
        IM(I)=0
 109    CONTINUE
      Q=1000./Q
      P=0.
        DO 110 I=1,LE
        IF(IN(I).LE.0)GOTO 110
        J=INT(Q*RP(I)+2.5)
        IM(J)=IM(J)+1
        P=P+1.
 110    CONTINUE
      K=INT(P*ABS(A(49)))
      IM(1)=K
      L=1003
 111  L=L-1
      K=K-IM(L)
      IF(K.GT.0)GOTO 111
      T=REAL(L-3)/Q
        DO 112 I=1,LE
        IF(IN(I).LE.0)GOTO 112
        IF(RP(I).GT.T)IN(I)=-IN(I)
 112    CONTINUE
C
C Starting phases for equivalent reflections
C
        DO 115 I=1,LE
        N=IABS(IN(I))
        IF(N.EQ.0)GOTO 114
        T=AR(I)**2+BR(I)**2
        IF(T.LT.1.E-6)BR(I)=-0.0001
        T=EH(I)/SQRT(AMAX1(T,1.E-8))
        AR(I)=AR(I)*T
        BR(I)=BR(I)*T
        T=ATAN2(BR(I),AR(I))
        IM(I)=MOD(INT(57.29578*T+720.5),360)
 113    IM(N)=MOD(INT(DH(N)+SH(N)*T),360)+1
        AR(N)=EH(N)
        IF(IN(I).GT.0)AR(N)=0.
        N=IN(N)
        IF(N.GT.0)GOTO 113
        GOTO 115
 114    AR(I)=0.
        BR(I)=0.
 115    CONTINUE
C
C Tangent formula phase refinement
C
      NI=0
      J=0
 116  J=J+1
      I=JH(J)
      IF(I.EQ.0)GOTO 155
      NJ=JL(J)
      IF(IN(I).LT.0)GOTO 119
      U=0.
      V=0.
        DO 117 K=NI+1,NJ
        T=AR(IY(K))*AR(IZ(K))
        L=IM(IY(K))+IM(IZ(K))
        U=U+T*BT(L)
        V=V+T*BT(L+270)
 117    CONTINUE
      V=V*A(41)
      T=U**2+V**2
      IF(T.LT.0.0001)GOTO 119
      T=EH(I)/SQRT(T)
      AR(I)=T*U
      BR(I)=T*V
      T=ATAN2(V,U)
      IM(I)=MOD(INT(57.29578*T+720.5),360)
      N=IABS(IN(I))
 118  IM(N)=MOD(INT(DH(N)+SH(N)*T),360)+1
      AR(N)=EH(N)
      N=IN(N)
      IF(N.GT.0)GOTO 118
 119  NI=NJ
      IN(I)=IABS(IN(I))
      GOTO 116
C
C Structure factor calculation for occupancy refinement
C
 120  CALL SXER('NOT ENOUGH MEMORY TO ALLOCATE WORKING SPACE')
 121  LK=NP*LE
      IF(A(48).GE.0.)GOTO 122
      ALLOCATE(B(LK),C(LK),STAT=I)
      IF(I.NE.0)GOTO 120
 122    DO 123 I=1,LE
        AR(I)=0.
        BR(I)=0.
 123    CONTINUE
      M=0
        DO 128 J=1,NP
        N=NP+1
        X=XA(J)
        Y=YA(J)
        Z=ZA(J)
        XA(N)=X
        YA(N)=Y
        ZA(N)=Z
          DO 124 K=133,LY,12
          N=N+1
          XA(N)=X*A(K)+Y*A(K+1)+Z*A(K+2)+A(K+9)
          YA(N)=X*A(K+3)+Y*A(K+4)+Z*A(K+5)+A(K+10)
          ZA(N)=X*A(K+6)+Y*A(K+7)+Z*A(K+8)+A(K+11)
 124      CONTINUE
          DO 127 I=1,LE
          IF(IN(I).NE.0.OR.A(48).LT.0.)THEN
          P=0.
          Q=0.
          U=6.2831853*REAL(IH(I))
          V=6.2831853*REAL(IK(I))
          W=6.2831853*REAL(IL(I))
          IF(A(41).GT.0.1)THEN
            DO 125 K=NP+1,N
            T=U*XA(K)+V*YA(K)+W*ZA(K)
            Q=Q+SIN(T)
            P=P+COS(T)
 125        CONTINUE
          ELSE
            DO 126 K=NP+1,N
            P=P+COS(U*XA(K)+V*YA(K)+W*ZA(K))
 126        CONTINUE
          ENDIF
          P=P*BP(J)
          Q=Q*BP(J)
          AR(I)=AR(I)+P*HA(J)
          BR(I)=BR(I)+Q*HA(J)
          IF(A(48).LT.0.)THEN
          M=M+1
          B(M)=P
          C(M)=Q
          ENDIF
          ENDIF
 127      CONTINUE
 128    CONTINUE
C
C Find starting occupancies
C
      IF(A(48).GE.0.)GOTO 147
      U=0.
      V=0.
      T=0.
      X=0.
      Y=0.
      Z=0.
      NJ=0
        DO 129 I=1,LE
        W=1./(A(40)+SH(I)**2)
        P=EH(I)**2
        Q=AR(I)**2+BR(I)**2
        U=U+W*P*Q
        T=T+W*P**2
        V=V+W*P
        X=X+W*Q**2
        Y=Y+W*Q
        Z=Z+W
        NJ=NJ+1
 129    CONTINUE
      Q=U*Z-V*Y
      IF(Q.LE.0.)GOTO 143
      IF(Q**2.LT.0.0025*(T*Z-V**2)*(X*Z-Y**2))GOTO 143
      T=AMAX1(1.E-4,X*Z-Y**2)
      P=SQRT(Q/T)
      HA(NP+1)=(X*V-Y*U)/T
        DO 130 I=1,NP
        HA(I)=P*HA(I)
 130    CONTINUE
C
C Sum derivatives
C
        DO 140 NI=1,3
          DO 131 I=1,NP+1
          RP(I)=0.
          AR(I)=0.
 131      CONTINUE
        M=0
          DO 134 I=1,LE
          W=1./(A(40)+SH(I)**2)
          M=M+1
          K=M
          U=0.
          V=0.
            DO 132 J=1,NP
            U=U+HA(J)*B(K)
            V=V+HA(J)*C(K)
            K=K+NJ
 132        CONTINUE
          T=W*(EH(I)**2-U**2-V**2-HA(NP+1))
          K=M
            DO 133 J=1,NP
            Q=2.*(U*B(K)+V*C(K))
            RP(J)=RP(J)+W*Q**2
            AR(J)=AR(J)+Q*T
            K=K+NJ
 133        CONTINUE
          RP(NP+1)=RP(NP+1)+W
          AR(NP+1)=AR(NP+1)+T
 134      CONTINUE
C
C Conjugate gradient refinement
C
        P=0.
          DO 135 I=1,NP
          BR(I)=AR(I)
          P=P+AR(I)**2
 135      CONTINUE
          DO 139 N=1,5
          Q=0.
            DO 136 I=1,NP+1
            Q=Q+RP(I)*BR(I)**2
 136        CONTINUE
          T=P/Q
          W=0.7*T
          Q=0.
            DO 137 I=1,NP+1
            HA(I)=AMAX1(0.,HA(I)+W*BR(I))
            AR(I)=AR(I)-T*RP(I)*BR(I)
            Q=Q+AR(I)**2
 137        CONTINUE
          T=Q/P
            DO 138 I=1,NP+1
            BR(I)=AR(I)+T*BR(I)
 138        CONTINUE
          P=Q
 139      CONTINUE
 140    CONTINUE
      M=0
        DO 142 I=1,LE
        M=M+1
        K=M
        U=0.
        V=0.
          DO 141 J=1,NP
          U=U+HA(J)*B(K)
          V=V+HA(J)*C(K)
          K=K+NJ
 141      CONTINUE
        AR(I)=U
        BR(I)=V
 142    CONTINUE
 143  DEALLOCATE(B,C)
      IF(LC.LT.MC)GOTO 147
C
C Sort peaks on refined occupancies
C
      K=NP
 144  K=INT(REAL(K)/1.3)
      IF(K.LT.1)K=1
      IF(K.EQ.9.OR.K.EQ.10)K=11
      M=0
        DO 145 I=1,NP-K
        Q=HA(I+K)
        IF(Q.LE.HA(I))GOTO 145
        HA(I+K)=HA(I)
        HA(I)=Q
        Q=XA(I+K)
        XA(I+K)=XA(I)
        XA(I)=Q
        Q=YA(I+K)
        YA(I+K)=YA(I)
        YA(I)=Q
        Q=ZA(I+K)
        ZA(I+K)=ZA(I)
        ZA(I)=Q
        Q=BP(I+K)
        BP(I+K)=BP(I)
        BP(I)=Q
        M=1
 145    CONTINUE
      IF(M+K.GT.1)GOTO 144
        DO 146 I=1,NP
        AH(I)=HA(I)
 146    CONTINUE
      LX=0
      GOTO 167
C
C Weights for E-map if no tangent expansion
C
 147  U=0.
      V=0.
        DO 148 I=1,LE
        N=IABS(IN(I))
        IF(N.EQ.0)GOTO 148
        U=U+SQRT(AR(I)**2+BR(I)**2)/CP(I)
        V=V+SQRT((EH(I)/CP(I))**2-1.)
 148    CONTINUE
      R=V/U
        DO 154 I=1,LE
        IF(IABS(IN(I)).EQ.0)GOTO 153
        Q=SQRT(AMAX1(AR(I)**2+BR(I)**2,1.E-8))
        S=R*Q
        X=ABS(2.*EH(I)*S/CP(I)**2)
        IF(DH(I).LT.0.)GOTO 149
        IF(A(62).LT.0.)GOTO 151
 149    P=1.
        IF(X.GT.12.)GOTO 150
        P=EXP(X)
        P=(P-1.)/(P+1.)
 150    T=P*EH(I)/Q
        GOTO 152
 151    P=AMIN1(X*(.5658+X*(X*.0106-.1304)),X/(.56+X))
        T=(2.*P*EH(I)-S)/Q
 152    AR(I)=AR(I)*T
        BR(I)=BR(I)*T
        GOTO 154
 153    AR(I)=0.
        BR(I)=0.
 154    CONTINUE
C
C Calculate and peaksearch E-map
C
 155  LX=0
      MP=NINT(ABS(A(44))/AMAX1(0.1,1.-A(33)))
      J=MIN0(MAX0(NINT(ABS(A(44)))+2,NINT(1.4*ABS(A(44)))),LM-1000)
      IF(LC.GE.MT.AND.A(48).LT.0.)MP=J
      IF(LC.GE.MC)MP=J
      CALL SX1F(LM,LD,LL,IM,IN,IH,IK,IL,FH,SH,EH,AH,BH,
     +AR,BR,DH,RP,CP,BP,IS,XA,YA,ZA,HA,A,2)
      CALL SXTO(5)
        DO 156 I=1,NP
        AH(I)=HA(I)
 156    CONTINUE
      IF(NP.EQ.1)GOTO 158
      J=0
      IF(HA(2).LT.A(67)*HA(1))J=1
      NP=NP-J
      IF(J.GT.0)AH(1)=-AH(1)
        DO 157 I=1,NP
        J=J+1
        IF(LC.LT.MC)HA(I)=SQRT(HA(J))
        XA(I)=XA(J)
        YA(I)=YA(J)
        ZA(I)=ZA(J)
        BP(I)=BP(J)
        IS(I)=IS(J)
 157    CONTINUE
 158  IF(MOD(LC,20).NE.0.AND.LC.LT.MC)GOTO 96
C
C Structure factors (all E-values if last iteration)
C
 159  NI=NP
      NN=NP
      IF(MX.NE.0)NN=MIN0(NP,MX+NINT(A(26)))
        DO 161 J=1,NN
        X=XA(J)
        Y=YA(J)
        Z=ZA(J)
          DO 160 K=121,LY,12
          NI=NI+1
          XA(NI)=X*A(K)+Y*A(K+1)+Z*A(K+2)+A(K+9)
          YA(NI)=X*A(K+3)+Y*A(K+4)+Z*A(K+5)+A(K+10)
          ZA(NI)=X*A(K+6)+Y*A(K+7)+Z*A(K+8)+A(K+11)
          HA(NI)=HA(J)*BP(J)
 160      CONTINUE
 161    CONTINUE
      IF(A(41).GT.0.1)GOTO 164
        DO 163 I=1,LE
        U=0.
        N=IABS(IN(I))
        IF(N.NE.0.OR.LC.GE.MC)THEN
        X=6.2831853*REAL(IH(I))
        Y=6.2831853*REAL(IK(I))
        Z=6.2831853*REAL(IL(I))
          DO 162 K=NP+1,NI
          U=U+HA(K)*COS(X*XA(K)+Y*YA(K)+Z*ZA(K))
 162      CONTINUE
        ENDIF
        AR(I)=U
        BR(I)=0.
 163    CONTINUE
      GOTO 167
 164    DO 166 I=1,LE
        U=0.
        V=0.
        N=IABS(IN(I))
        IF(N.NE.0.OR.LC.GE.MC)THEN
        X=6.2831853*REAL(IH(I))
        Y=6.2831853*REAL(IK(I))
        Z=6.2831853*REAL(IL(I))
          DO 165 K=NP+1,NI
          Q=X*XA(K)+Y*YA(K)+Z*ZA(K)
          V=V+HA(K)*SIN(Q)
          U=U+HA(K)*COS(Q)
 165      CONTINUE
        ENDIF
        AR(I)=U
        BR(I)=V
 166    CONTINUE
C
C Conventional R-factor and phases for minimal function and R(alpha)
C
 167  IF(MX.EQ.0)GOTO 179
      RX=0.
      RY=0.
        DO 169 I=1,LE
        N=IABS(IN(I))
        IF(N.EQ.0)GOTO 169
        RX=RX+EH(I)/CP(I)
        RY=RY+SQRT(AR(I)**2+BR(I)**2)/CP(I)
        IF(MT.EQ.0)GOTO 169
        T=ATAN2(BR(I),AR(I))
        IM(I)=MOD(INT(57.29578*T+720.5),360)
 168    IM(N)=MOD(INT(DH(N)+SH(N)*T),360)+1
        N=IN(N)
        IF(N.GT.0)GOTO 168
 169    CONTINUE
      Z=RX/RY
      X=0.
      Y=0.
        DO 170 I=1,LE
        IF(IABS(IN(I)).EQ.0)GOTO 170
        T=EH(I)/CP(I)
        X=X+ABS(T-Z*SQRT(AR(I)**2+BR(I)**2)/CP(I))
        Y=Y+T
 170    CONTINUE
      Z=X/Y
C
C Minimal function and R(alpha) figures of merit
C
      P=0.
      Q=0.
      R=0.
      IF(MT.EQ.0)GOTO 174
      S=0.
      V=0.
      NI=0
      J=0
 171  J=J+1
      I=JH(J)
      IF(I.EQ.0)GOTO 173
      NJ=JL(J)
      N=360-IM(I)
      U=0.
      W=0.
        DO 172 K=NI+1,NJ
        L=IW(K)
        T=0.001*REAL(L-1441)
        M=IM(IY(K))+IM(IZ(K))+N
        R=R+T*(BT(M)-BT(L))**2
        U=U+T*BT(M)
        W=W+T*BT(L)
 172    CONTINUE
      P=P+U
      V=V+U**2
      S=S+U*W
      Q=Q+W**2
      NI=NJ
      GOTO 171
 173  R=R/WX
      P=P/WX
      Q=SQRT(ABS(1.-S**2/(V*Q)))
C
C Output figures of merit
C
 174  IF(LC.LE.0)GOTO 179
      WRITE(KT,'(A,I7,A,I6,A)')'#Try#',LO,':',LC,'/t##Peaks'
      IF(LC.GT.MT)KT(20:21)='  '
      K=0
        DO 175 I=1,28
        IF(KT(I:I).EQ.' ')GOTO 175
        K=K+1
        KT(K:K)=KT(I:I)
        IF(KT(K:K).EQ.'#')KT(K:K)=' '
 175    CONTINUE
      KT(K+1:80)=' '
      T=99.5/ABS(AH(LX+1))
        DO 177 I=LX+1,NP
        WRITE(KS,'(I4)')INT(T*AH(I))
        K=K+1
          DO 176 J=1,4
          IF(KS(J:J).EQ.' ')GOTO 176
          K=K+1
          KT(K:K)=KS(J:J)
 176      CONTINUE
        IF(K.GT.75)GOTO 178
 177    CONTINUE
 178  WRITE(*,'(A)')KT(1:K)
      WRITE(LI,'(A)')KT(1:K)
      WRITE(*,8)Z,R,P,Q
      WRITE(LI,8)Z,R,P,Q
      IF(LC.LT.MC)GOTO 96
 179  RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SX1E(LM,LD,IM,IN,IH,IK,IL,FH,SH,EH,AH,BH,
     +AR,BR,DH,RP,CP,BP,IS,XA,YA,ZA,HA,QD,SC,ZW,A)
C
C Peaklist optimization
C
      CHARACTER::KM*4,KN*4,KR*79,NM*80,KF(60)*81,KA(94)*2
      INTEGER::IM(LD),IN(LD),IH(LD),IK(LD),IL(LD),IS(LM)
      REAL::FH(LD),SH(LD),AH(LD),BH(LD),EH(LD),AR(LD),BR(LD),DH(LD),
     +RP(LD),CP(LD),BP(LD),XA(LM),YA(LM),ZA(LM),HA(LM),
     +A(596),EF(940),QD(11),SC(12501),ZW(10),D(18)
      COMMON/FLAGS/ST,SL,LF,LI,LP,LR,LN,LZ,LY,LE,LW,LS,LV,LQ,JU,
     +LO,LG,LU,LX,NP,MP,JR,JS,JK,JW,FM,RM,PC,PP,HP,FW,PW,WX
      COMMON/FILE/NM,KF
      COMMON/SFAC/EF
      COMMON/ATSYM/KA
C
   1  FORMAT(' Peaklist optimization cycle',I3,'    CC =',F6.2,
     +' %    BG =',F6.3,'   for',I5,' atoms')
   2  FORMAT(A)
   3  FORMAT('REM TRY',I7,'   FINAL CC',F6.2,'   TIME',I8,' SECS'/
     +'REM',A/'REM ')
   4  FORMAT(A4,I3,4F9.5,A,F8.2)
C
C Generate indices of twin-related reflections
C
      CALL SXTO(6)
      LT=LE
      IF(ZW(1).GT.-98.)LT=2*LE
      IF(LT.GT.LD)CALL SXER('NOT ENOUGH REFLECTION WORKING SPACE -'//
     +'USE -L SWITCH TO INCREASE')
      TW=1.-ZW(10)
        DO 5 I=LE+1,LT
        U=REAL(IH(I-LE))
        V=REAL(IK(I-LE))
        W=REAL(IL(I-LE))
        IH(I)=NINT(U*ZW(1)+V*ZW(2)+W*ZW(3))
        IK(I)=NINT(U*ZW(4)+V*ZW(5)+W*ZW(6))
        IL(I)=NINT(U*ZW(7)+V*ZW(8)+W*ZW(9))
        AR(I)=0.
        BR(I)=0.
   5    CONTINUE
C
C If atoms input instead of FIND, PATS or GROP, calculate phases
C
      RT=-1.
      LC=0
      LX=0
      IF(NINT(A(44)).NE.0)GOTO 62
      IF(NINT(A(109)).NE.0)GOTO 62
      LX=NP
      LO=1
      N=LW
        DO 7 J=1,LW
        X=XA(J)
        Y=YA(J)
        Z=ZA(J)
        BP(J)=HA(J)
        HA(J)=HA(J)*REAL(IS(J)+9)
          DO 6 K=133,LY,12
          N=N+1
          XA(N)=X*A(K)+Y*A(K+1)+Z*A(K+2)+A(K+9)
          YA(N)=X*A(K+3)+Y*A(K+4)+Z*A(K+5)+A(K+10)
          ZA(N)=X*A(K+6)+Y*A(K+7)+Z*A(K+8)+A(K+11)
          HA(N)=HA(J)
   6      CONTINUE
   7    CONTINUE
        DO 9 I=1,LT
        U=0.
        V=0.
        X=10000.*REAL(IH(I))
        Y=10000.*REAL(IK(I))
        Z=10000.*REAL(IL(I))
          DO 8 K=1,N
          J=MOD(MOD(NINT(X*XA(K)+Y*YA(K)+Z*ZA(K)),10000)+10000,10000)
          U=U+HA(K)*SC(J+2501)
          V=V+HA(K)*SC(J+1)
   8      CONTINUE
        AR(I)=U
        BR(I)=V*A(41)
   9    CONTINUE
C
C Set up Sim and sigma(E) weighted Eo-Ec coefficients
C
        DO 10 I=LE+1,LT
        Q=TW*(AR(I-LE)**2+BR(I-LE)**2)
        EH(I)=EH(I-LE)*SQRT(Q/(Q+ZW(10)*(AR(I)**2+BR(I)**2)))
  10    CONTINUE
      CALL SXPO(LE,EH(LT-LE+1),SH,AR,BR,DH,AH,CP,QD,A(LS+2))
        DO 14 I=1,LE
        Q=SQRT(AR(I)**2+BR(I)**2)
        IF(Q.LT.1.E-8)GOTO 14
        S=(.5*EH(I))**4
        S=S/(S+SH(I)**4)
        P=1.
        X=2.*EH(I)*AH(I)/CP(I)**2
        IF(DH(I).LT.0.)GOTO 11
        IF(A(62).LT.0.)GOTO 12
  11    IF(X.GT.12.)GOTO 13
        P=EXP(X)
        P=(P-1.)/(P+1.)
        GOTO 13
  12    P=AMIN1(X*(.5658+X*(X*.0106-.1304)),X/(.56+X))
  13    T=(P*EH(I+LT-LE)-AH(I))*S/Q
        AR(I)=AR(I)*T
        BR(I)=BR(I)*T
  14    CONTINUE
C
C Initialize peaklist and start PLOP cycle with Fourier
C
  15  LC=LC+1
      MP=MIN0(INT(ABS(A(LC+50))),LD-LE,LG-1000)
      IF(LC.GT.1)LX=MIN0(MP,LW,NINT(A(68)))
      CALL SX1F(LM,LD,LE,IM,IN,IH,IK,IL,FH,SH,EH,AH,BH,
     +AR,BR,DH,RP,CP,BP,IS,XA,YA,ZA,HA,A,4)
        DO 16 I=LE+1,LT
        U=REAL(IH(I-LE))
        V=REAL(IK(I-LE))
        W=REAL(IL(I-LE))
        IH(I)=NINT(U*ZW(1)+V*ZW(2)+W*ZW(3))
        IK(I)=NINT(U*ZW(4)+V*ZW(5)+W*ZW(6))
        IL(I)=NINT(U*ZW(7)+V*ZW(8)+W*ZW(9))
  16    CONTINUE
      CALL SXTO(6)
      JJ=MAX0(INT(ABS(A(LC+50)*0.5)),LW)
C
C Find initial CC
C
      IF(NP*(LY-97)/12.GT.LM)CALL SXER(
     +'ARRAYS TOO SMALL - INCREASE LM')
        DO 42 NK=1,3
        N=0
        NT=NP
          DO 18 J=1,NP
          IF(IS(J).LE.0)GOTO 18
          W=BP(J)*REAL(IS(J)+9)
          N=N+1
            DO 17 K=121,LY,12
            NT=NT+1
            XA(NT)=XA(J)*A(K)+YA(J)*A(K+1)+ZA(J)*A(K+2)+A(K+9)
            YA(NT)=XA(J)*A(K+3)+YA(J)*A(K+4)+ZA(J)*A(K+5)+A(K+10)
            ZA(NT)=XA(J)*A(K+6)+YA(J)*A(K+7)+ZA(J)*A(K+8)+A(K+11)
            BP(NT)=W
  17        CONTINUE
  18      CONTINUE
          DO 21 I=1,LT
          X=6.2831853*REAL(IH(I))
          Y=6.2831853*REAL(IK(I))
          Z=6.2831853*REAL(IL(I))
          U=0.
          V=0.
          IF(A(41).GT.0.1)THEN
            DO 19 J=NP+1,NT
            H=X*XA(J)+Y*YA(J)+Z*ZA(J)
            U=U+BP(J)*COS(H)
            V=V+BP(J)*SIN(H)
  19        CONTINUE
          ELSE
            DO 20 J=NP+1,NT
            U=U+BP(J)*COS(X*XA(J)+Y*YA(J)+Z*ZA(J))
  20        CONTINUE
          ENDIF
          AR(I)=U
          BR(I)=V
  21      CONTINUE
        R=0.
        S=0.
        T=0.
        U=0.
        V=0.
        W=0.
          DO 22 I=1,LE
          WT=1./(A(40)+SH(I)**2)
          BR(I)=BR(I)*A(41)
          Q=AR(I)**2+BR(I)**2
          IF(LT.GT.LE)THEN
          Q=Q*TW+ZW(10)*(AR(I+LE)**2+A(41)*BR(I+LE)**2)
          ENDIF
          V=V+WT*Q
          S=S+WT*Q*EH(I)**2
          T=T+WT*EH(I)
          U=U+WT*EH(I)**2
          R=R+WT*Q**2
          W=W+WT
  22      CONTINUE
        AK=U/V
        BK=0.
        Q=R*W-V**2
        IF(Q.LE.0.)GOTO 23
        WT=(S*W-V*U)/Q
        IF(WT.LE.0.)GOTO 23
        V=(R*U-V*S)/Q
        IF(V.LE.0.)GOTO 23
        AK=WT
        BK=V
  23    R=0.
        S=0.
        V=0.
          DO 24 I=1,LE
          WT=1./(A(40)+SH(I)**2)
          Q=AR(I)**2+BR(I)**2
          IF(LT.GT.LE)THEN
          Q=Q*TW+ZW(10)*(AR(I+LE)**2+A(41)*BR(I+LE)**2)
          ENDIF
          Q=AK*Q+BK
          V=V+Q*WT
          Q=SQRT(Q)*WT
          R=R+Q
          S=S+Q*EH(I)
  24      CONTINUE
        RT=(S*W-R*T)/SQRT((U*W-T**2)*(V*W-R**2))
        IF(NK.EQ.3)GOTO 42
C
C Try eliminating each peak in turn. The inner loop J=NT,NZ is over
C symmetry operators and so has a run length of 1, 2, 3, 4, 6, 8, 12
C or 24, of which 2 and 4 are the most common, so it has been expanded.
C
        J=NP+1
  25    J=J-1
        IF(J.LE.LX)GOTO 42
        IF(N.LE.JJ)GOTO 42
        IF(IS(J).LE.0)GOTO 25
        P=BP(J)*REAL(IS(J)+9)
        NZ=NP
        NT=NP+1
          DO 26 K=121,LY,12
          NZ=NZ+1
          XA(NZ)=XA(J)*A(K)+YA(J)*A(K+1)+ZA(J)*A(K+2)+A(K+9)
          YA(NZ)=XA(J)*A(K+3)+YA(J)*A(K+4)+ZA(J)*A(K+5)+A(K+10)
          ZA(NZ)=XA(J)*A(K+6)+YA(J)*A(K+7)+ZA(J)*A(K+8)+A(K+11)
  26      CONTINUE
        IF(A(41).LT.0.1)GOTO 35
C
C Expanded loop for one operator
C
        IF(NZ.NE.NT)GOTO 28
          DO 27 I=1,LT
          H=6.2831853*(REAL(IH(I))*XA(NT)+REAL(IK(I))*YA(NT)+
     +    REAL(IL(I))*ZA(NT))
          AH(I)=P*COS(H)
          BH(I)=P*SIN(H)
  27      CONTINUE
        GOTO 38
C
C Expanded loop for two operators
C
  28    IF(NZ.NE.NT+1)GOTO 30
          DO 29 I=1,LT
          X=REAL(IH(I))
          Y=REAL(IK(I))
          Z=REAL(IL(I))
          H=6.2831853*(X*XA(NT)+Y*YA(NT)+Z*ZA(NT))
          R=6.2831853*(X*XA(NZ)+Y*YA(NZ)+Z*ZA(NZ))
          AH(I)=P*(COS(H)+COS(R))
          BH(I)=P*(SIN(H)+SIN(R))
  29      CONTINUE
        GOTO 38
C
C Expanded loop for four operators
C
  30    IF(NZ.NE.NT+3)GOTO 32
          DO 31 I=1,LT
          X=6.2831853*REAL(IH(I))
          Y=6.2831853*REAL(IK(I))
          Z=6.2831853*REAL(IL(I))
          H=X*XA(NT)+Y*YA(NT)+Z*ZA(NT)
          R=X*XA(NT+1)+Y*YA(NT+1)+Z*ZA(NT+1)
          S=X*XA(NT+2)+Y*YA(NT+2)+Z*ZA(NT+2)
          V=X*XA(NZ)+Y*YA(NZ)+Z*ZA(NZ)
          AH(I)=P*(COS(H)+COS(R)+COS(S)+COS(V))
          BH(I)=P*(SIN(H)+SIN(R)+SIN(S)+SIN(V))
  31      CONTINUE
        GOTO 38
C
C General case (3, 6, 8, 12 or 24 operators)
C
  32      DO 34 I=1,LT
          R=0.
          S=0.
          X=6.2831853*REAL(IH(I))
          Y=6.2831853*REAL(IK(I))
          Z=6.2831853*REAL(IL(I))
            DO 33 K=NT,NZ
            H=X*XA(K)+Y*YA(K)+Z*ZA(K)
            R=R+P*COS(H)
            S=S+P*SIN(H)
  33        CONTINUE
          AH(I)=R
          BH(I)=S
  34      CONTINUE
        GOTO 38
C
C Centrosymmetric
C
  35      DO 37 I=1,LT
          R=0.
          X=6.2831853*REAL(IH(I))
          Y=6.2831853*REAL(IK(I))
          Z=6.2831853*REAL(IL(I))
            DO 36 K=NT,NZ
            R=R+P*COS(X*XA(K)+Y*YA(K)+Z*ZA(K))
  36        CONTINUE
          AH(I)=R
          BH(I)=0.
  37      CONTINUE
C
C Sum for correlation coefficient with peak removed
C
  38    R=0.
        S=0.
        V=0.
          DO 39 I=1,LE
          WT=1./(A(40)+SH(I)**2)
          Q=(AR(I)-AH(I))**2+(BR(I)-BH(I))**2
          IF(LT.GT.LE)THEN
          Q=TW*Q+ZW(10)*((AR(I+LE)-AH(I+LE))**2+
     +    (BR(I+LE)-BH(I+LE))**2)
          ENDIF
          V=V+WT*Q
          S=S+WT*Q*EH(I)**2
          R=R+WT*Q**2
  39      CONTINUE
        Q=R*W-V**2
        AK=AMAX1(S*W-V*U,0.)/Q
        BK=AMAX1(R*U-V*S,0.)/Q
        R=0.
        S=0.
        V=0.
          DO 40 I=1,LE
          WT=1./(A(40)+SH(I)**2)
          Q=(AR(I)-AH(I))**2+(BR(I)-BH(I))**2
          IF(LT.GT.LE)Q=Q*TW+ZW(10)*((AR(I+LE)-AH(I+LE))**2+
     +    (BR(I+LE)-BH(I+LE))**2)
          Q=SQRT(AK*Q+BK)
          R=R+WT*Q
          S=S+WT*Q*EH(I)
          V=V+WT*Q**2
  40      CONTINUE
        R=(S*W-R*T)/SQRT((U*W-T**2)*(V*W-R**2))
C
C Eliminate peak and subtract its structure factor contributions
C
        IF(R.LT.RT)GOTO 25
        RT=R
          DO 41 I=1,LT
          AR(I)=AR(I)-AH(I)
          BR(I)=BR(I)-BH(I)
  41      CONTINUE
        IS(J)=-IS(J)
        N=N-1
        GOTO 25
  42    CONTINUE
C
C Output summary of peaklist optimization
C
      RT=100.*RT
      WRITE(*,1)LC,RT,BK,N
      WRITE(LI,1)LC,RT,BK,N
      KR=' Peaks:'
      NK=7
      Q=99.5/AMAX1(1.E-6,ABS(HA(LX+1)))
        DO 46 I=LX+1,NP
        IF(NK.EQ.77)GOTO 47
        J=INT(Q*HA(I))
        IF(IS(I).LE.0)J=-IABS(J)
        WRITE(KM,'(I4)')J
        NK=NK+1
        NJ=NK
          DO 43 J=1,4
          IF(KM(J:J).EQ.' ')GOTO 43
          NK=NK+1
          IF(NK.GT.77)GOTO 44
          KR(NK:NK)=KM(J:J)
  43      CONTINUE
        GOTO 46
  44    NK=78
          DO 45 J=NJ,78
          KR(J:J)=' '
  45      CONTINUE
  46    CONTINUE
  47  WRITE(*,2)KR(1:77)
      WRITE(LI,2)KR(1:77)
C
C Count number of atoms in each moiety
C
      CALL SXTO(10)
      N=-1
        DO 51 J=1,NP
        IN(J)=0
        IF(IS(J).LE.0)GOTO 51
        IN(J)=J
        BH(J)=EF(IS(J)+9)
          DO 50 K=121,LY,12
            DO 49 L=69,LV,4
            X=A(L+1)+A(L)*(XA(J)*A(K)+YA(J)*A(K+1)+
     +      ZA(J)*A(K+2)+A(K+9))
            Y=A(L+2)+A(L)*(XA(J)*A(K+3)+YA(J)*A(K+4)+
     +      ZA(J)*A(K+5)+A(K+10))
            Z=A(L+3)+A(L)*(XA(J)*A(K+6)+YA(J)*A(K+7)+
     +      ZA(J)*A(K+8)+A(K+11))
              DO 48 I=1,J-1
              IF(IS(I).LE.0)GOTO 48
              U=X-XA(I)
              U=U-AINT(U)-0.5
              V=Y-YA(I)
              V=V-AINT(V)-0.5
              W=Z-ZA(I)
              W=W-AINT(W)-0.5
              IF(A(8)*U**2+A(9)*V**2+A(10)*W**2+A(11)*V*W+
     +        A(12)*U*W+A(13)*U*V.GT.(BH(I)+BH(J))**2)GOTO 48
              N=N+2
              IF(N.GE.LD)CALL SXER('REFLECTION ARRAYS TOO SMALL -'//
     +        ' USE -L SWITCH TO INCREASE')
              IM(N)=I
              IM(N+1)=J
              IN(J)=IN(I)
  48          CONTINUE
  49        CONTINUE
  50      CONTINUE
  51    CONTINUE
        DO 53 K=1,N,2
        I=IM(K)
        J=IM(K+1)
        IF(IN(I).EQ.IN(J))GOTO 53
        L=MIN0(IN(I),IN(J))
        NL=MAX0(IN(I),IN(J))
          DO 52 I=1,NP
          IF(IN(I).EQ.NL)IN(I)=L
  52      CONTINUE
  53    CONTINUE
        DO 54 I=1,NP
        IM(I)=0
  54    CONTINUE
        DO 55 I=1,NP
        J=IN(I)
        IF(J.GT.0)IM(J)=IM(J)+1
  55    CONTINUE
      KR=' Fragments:'
      NK=11
  56  NJ=0
      J=0
        DO 57 I=1,NP
        IF(NJ.GE.IM(I))GOTO 57
        NJ=IM(I)
        J=I
  57    CONTINUE
      IF(NJ.EQ.0)GOTO 61
      IM(J)=0
      WRITE(KM,'(I4)')NJ
      NK=NK+1
      NJ=NK
        DO 58 J=1,4
        IF(KM(J:J).EQ.' ')GOTO 58
        NK=NK+1
        IF(NK.GT.78)GOTO 59
        KR(NK:NK)=KM(J:J)
  58    CONTINUE
      GOTO 56
  59    DO 60 J=NJ,78
        KR(J:J)=' '
  60    CONTINUE
  61  WRITE(*,2)KR(1:78)
      WRITE(LI,2)KR(1:78)
C
C Prepare Fourier coefficients 2*Eo*<cos>-Ec (acentric) or Eo*<cos>
C (centric) with phase of Ec, further weighted according to sigma(E)
C
  62  CALL SXTO(6)
        DO 63 I=LE+1,LT
        Q=TW*(AR(I-LE)**2+BR(I-LE)**2)
        EH(I)=EH(I-LE)*SQRT(Q/(Q+ZW(10)*(AR(I)**2+BR(I)**2)))
  63    CONTINUE
      CALL SXPO(LE,EH(LT-LE+1),SH,AR,BR,DH,AH,CP,QD,A(LS+2))
        DO 69 I=1,LE
        Q=SQRT(AR(I)**2+BR(I)**2)
        IF(Q.LT.1.E-8)GOTO 69
        J=I+LT-LE
        S=(.5*EH(I))**4
        S=S/(S+SH(I)**4)
        P=1.
        X=2.*EH(I)*AH(I)/CP(I)**2
        IF(DH(I).LT.0.)GOTO 64
        IF(A(62).LT.0.)GOTO 66
  64    IF(X.GT.12.)GOTO 65
        P=EXP(X)
        P=(P-1.)/(P+1.)
  65    T=P*EH(J)*S/Q
        GOTO 68
  66    IF(X.GT.12.)GOTO 67
        P=AMIN1(X*(.5658+X*(X*.0106-.1304)),X/(.56+X))
  67    T=(2.*P*EH(J)-AH(I))*S/Q
  68    AR(I)=AR(I)*T
        BR(I)=BR(I)*T
  69    CONTINUE
      IF(RT.LT.RM)GOTO 108
      RM=RT
C
C Generate unique molecules
C
      CALL SXTO(10)
        DO 70 J=1,NP
        IF(IS(J).GT.0)CP(J+LE)=EF(IS(J)+9)
  70    CONTINUE
        DO 78 M=1,NP
        IF(IN(M).NE.M)GOTO 78
          DO 71 J=M,NP
          IF(IN(J).NE.M)GOTO 71
          IF(IS(J).GT.0)GOTO 72
  71      CONTINUE
        GOTO 78
  72    IN(J)=-IN(J)
  73    I=J
          DO 76 J=M+1,NP
          IF(IN(J).NE.M)GOTO 76
          IF(IS(J).LE.0)GOTO 76
            DO 75 K=121,LY,12
              DO 74 L=69,LV,4
              U=A(L+1)+A(L)*(XA(J)*A(K)+YA(J)*A(K+1)+
     +        ZA(J)*A(K+2)+A(K+9))-XA(I)
              U=U-AINT(U)-0.5
              V=A(L+2)+A(L)*(XA(J)*A(K+3)+YA(J)*A(K+4)+
     +        ZA(J)*A(K+5)+A(K+10))-YA(I)
              V=V-AINT(V)-0.5
              W=A(L+3)+A(L)*(XA(J)*A(K+6)+YA(J)*A(K+7)+
     +        ZA(J)*A(K+8)+A(K+11))-ZA(I)
              W=W-AINT(W)-0.5
              IF(A(8)*U**2+A(9)*V**2+A(10)*W**2+A(11)*V*W+
     +        A(12)*U*W+A(13)*U*V.GT.(CP(I+LE)+CP(J+LE))**2)GOTO 74
              XA(J)=XA(I)+U
              YA(J)=YA(I)+V
              ZA(J)=ZA(I)+W
              IN(J)=-IN(J)
              IF(J.LT.I)GOTO 73
              GOTO 76
  74          CONTINUE
  75        CONTINUE
  76      CONTINUE
          DO 77 J=I+1,NP
          IF(IN(J)+M.NE.0)GOTO 77
          IF(IS(J).GT.0)GOTO 73
  77      CONTINUE
  78    CONTINUE
C
C Find most compact cluster of unique molecules (keeping first fixed)
C
      M=0
        DO 79 I=1,NP
        IM(I)=0
        IF(IS(I).LE.0)GOTO 79
        J=-IN(I)
        IF(J.LE.0)GOTO 79
        IM(J)=IM(J)+1
        IF(M.EQ.0)M=J
  79    CONTINUE
      X=0.
      Y=0.
      Z=0.
      WT=0.
        DO 80 I=M,NP
        IF(IN(I)+M.NE.0)GOTO 80
        IF(IS(I).LE.0)GOTO 80
        X=X+XA(I)
        Y=Y+YA(I)
        Z=Z+ZA(I)
        WT=WT+1.
  80    CONTINUE
      IF(WT.LT.0.5)GOTO 88
  81  IM(M)=-IM(M)
      X=X/WT
      Y=Y/WT
      Z=Z/WT
      M=0
      K=0
        DO 82 I=1,NP
        IF(IM(I).LE.K)GOTO 82
        K=IM(I)
        M=I
  82    CONTINUE
      IF(M.EQ.0)GOTO 88
      P=0.
      Q=0.
      R=0.
      T=0.
        DO 83 I=M,NP
        IF(IN(I)+M.NE.0)GOTO 83
        IF(IS(I).LE.0)GOTO 83
        P=P+XA(I)
        Q=Q+YA(I)
        R=R+ZA(I)
        T=T+1.
  83    CONTINUE
      P=P/T
      Q=Q/T
      R=R/T
      T=9.E9
        DO 86 K=121,LY,12
          DO 85 L=69,LV,4
          XX=A(L)*(P*A(K)+Q*A(K+1)+R*A(K+2))-X
          U=A(L+1)+A(L)*A(K+9)+XX
          U=U-AINT(U)-0.5
          YY=A(L)*(P*A(K+3)+Q*A(K+4)+R*A(K+5))-Y
          V=A(L+2)+A(L)*A(K+10)+YY
          V=V-AINT(V)-0.5
          ZZ=A(L)*(P*A(K+6)+Q*A(K+7)+R*A(K+8))-Z
          W=A(L+3)+A(L)*A(K+11)+ZZ
          W=W-AINT(W)-0.5
          S=A(8)*U**2+A(9)*V**2+A(10)*W**2+A(11)*V*W+
     +    A(12)*U*W+A(13)*U*V
          IF(S.GT.T)GOTO 85
          T=S
            DO 84 I=1,9
            CP(LE+I)=A(K+I-1)*A(L)
  84        CONTINUE
          CP(LE+10)=U-XX
          CP(LE+11)=V-YY
          CP(LE+12)=W-ZZ
  85      CONTINUE
  86    CONTINUE
      X=X*WT
      Y=Y*WT
      Z=Z*WT
        DO 87 I=M,NP
        IF(IN(I)+M.NE.0)GOTO 87
        IF(IS(I).LE.0)GOTO 87
        P=XA(I)
        Q=YA(I)
        R=ZA(I)
        XA(I)=P*CP(LE+1)+Q*CP(LE+2)+R*CP(LE+3)+CP(LE+10)
        X=X+XA(I)
        YA(I)=P*CP(LE+4)+Q*CP(LE+5)+R*CP(LE+6)+CP(LE+11)
        Y=Y+YA(I)
        ZA(I)=P*CP(LE+7)+Q*CP(LE+8)+R*CP(LE+9)+CP(LE+12)
        Z=Z+ZA(I)
        WT=WT+1.
  87    CONTINUE
      GOTO 81
C
C Output atoms to .res file
C
  88  OPEN(UNIT=LP,FILE=NM(1:LN)//'.res',STATUS='OLD',IOSTAT=I)
      CLOSE(UNIT=LP,STATUS='DELETE',IOSTAT=I)
      OPEN(UNIT=LP,FILE=NM(1:LN)//'.res',STATUS='NEW',ERR=101)
      L=1
        DO 89 I=2,79
        IF(KR(I:I).NE.' ')L=I
  89    CONTINUE
      IF(L.LT.76)GOTO 91
  90  L=L-1
      IF(KR(L:L).NE.' ')GOTO 90
  91  CALL SXTI(T)
      T=T-ST-86400.
  92  T=T+86400.
      IF(T.LT.0.)GOTO 92
      WRITE(LP,3)LO,RM,INT(T),KR(1:L)
        DO 93 I=1,LQ-1
        L=ICHAR(KF(I)(81:81))
        WRITE(LP,2)KF(I)(1:L)
  93    CONTINUE
      NI=0
      NJ=0
      NK=0
        DO 94 K=LY+12,LS,2
        IF(NINT(A(K))/10.EQ.5)NI=(K-LY-10)/2
        IF(NINT(A(K))/10.EQ.6)NJ=(K-LY-10)/2
        IF(NINT(A(K))/10.EQ.7)NK=(K-LY-10)/2
  94    CONTINUE
      Q=99.0001/ABS(HA(LX+1))
      M=0
        DO 100 I=1,NP
        IF(IS(I).LE.0)GOTO 100
        K=IABS(IN(I))
        IF(IABS(IM(K)).LT.INT(1.0001*A(114)))GOTO 100
        M=M+1
        L=MOD(M,10)+10*(M/1000)
        K=MOD(L,36)
        KM(4:4)=CHAR(48+K)
        IF(K.GT.9)KM(4:4)=CHAR(K+55)
        L=MOD(M/10,10)+10*(L/36)
        K=MOD(L,36)
        KM(3:3)=CHAR(48+K)
        IF(K.GT.9)KM(3:3)=CHAR(K+55)
        K=MOD(MOD(M/100,10)+10*(L/36),36)
        KM(2:2)=CHAR(48+K)
        IF(K.GT.9)KM(2:2)=CHAR(K+55)
        KN=KA(IS(I)/10+1)//'  '
        L=INDEX(KN,' ')
        K=L-1
          DO 95 J=L,4
          IF(KM(J:J).EQ.' ')GOTO 95
          K=K+1
          IF(K.GT.4)GOTO 96
          KN(K:K)=KM(J:J)
  95      CONTINUE
  96    J=LS+2
          DO 97 K=LY+12,LS,2
          IF(IS(I).EQ.NINT(A(K)))J=K
  97      CONTINUE
        J=(J-LY-10)/2
        IF(NI.EQ.0)GOTO 99
        IF(J.EQ.NI)GOTO 98
        IF(J.NE.NJ.AND.J.NE.NK)GOTO 99
        J=NI
        KN(1:1)='C'
  98    IF(IABS(IM(IABS(IN(I)))).GT.1.OR.NK.EQ.0)GOTO 99
        J=NK
        KN(1:1)='O'
  99    T=0.
        IF(I.GT.LX)T=Q*HA(I)
        WRITE(LP,4)KN,J,XA(I),YA(I),ZA(I),BP(I)+10.,' 0.1',T
 100    CONTINUE
      IF(KF(LQ)(1:4).EQ.'HKLF')GOTO 102
      WRITE(LP,2)'HKLF 4','END '
      GOTO 103
 101  CALL SXER('CANNOT OPEN .RES AND/OR .PDB FILE ')
 102  L=ICHAR(KF(LQ)(81:81))
      WRITE(LP,2)KF(LQ)(1:L),'END '
 103  CLOSE(LP,STATUS='KEEP')
C
C Output atoms to PDB format file
C
      OPEN(UNIT=LP,FILE=NM(1:LN)//'.pdb',STATUS='OLD',IOSTAT=I)
      CLOSE(UNIT=LP,STATUS='DELETE',IOSTAT=I)
      OPEN(UNIT=LP,FILE=NM(1:LN)//'.pdb',STATUS='NEW',ERR=101)
        DO 104 I=1,3
        Q=1.74533E-2*A(I+4)
        D(I+12)=SIN(Q)
        D(I+15)=COS(Q)
 104    CONTINUE
        DO 105 I=1,12
        D(I)=0.
 105    CONTINUE
      D(1)=1./A(2)
      D(2)=-D(18)/(A(2)*D(15))
      T=SQRT(1.+2.*D(16)*D(17)*D(18)-D(16)**2-D(17)**2-D(18)**2)
      D(3)=(D(16)*D(18)-D(17))/(T*A(2)*D(15))
      D(6)=1./(A(3)*D(15))
      D(7)=(D(17)*D(18)-D(16))/(T*A(3)*D(15))
      D(11)=D(15)/(T*A(4))
      WRITE(LP,'(A6,3F9.3,3F7.2)')'CRYST1',(A(I),I=2,7)
        DO 106 I=4,12,4
        WRITE(LP,'(A5,I1,4X,3F10.6,5X,F10.5)')'SCALE',I/4,
     +  (D(J),J=I-3,I)
 106    CONTINUE
      M=0
        DO 107 I=1,NP
        IF(IS(I).LE.0)GOTO 107
        K=IABS(IN(I))
        IF(IABS(IM(K)).LT.NINT(A(114)))GOTO 107
        M=M+1
        KN=KA(IS(I)/10+1)//'  '
        IF(KN(2:2).EQ.' ')KN=' '//KA(IS(I)/10+1)//' '
        IF(KN.EQ.' N  '.OR.KN.EQ.' O  ')KN=' C  '
        IF(KN.EQ.' C  '.AND.IABS(IM(K)).LT.2)KN=' O  '
        W=(ZA(I)-D(12))/D(11)
        V=(YA(I)-W*D(7)-D(8))/D(6)
        U=(XA(I)-V*D(2)-W*D(3)-D(4))/D(1)
        WRITE(LP,'(A4,I7,1X,2A4,I6,4X,3F8.3,F6.3,A)')'ATOM',M,KN,
     +  ' ABC',M,U,V,W,BP(I),' 10.00'
 107    CONTINUE
      WRITE(LP,2)'END '
      CLOSE(LP,STATUS='KEEP')
 108  IF(LC.LT.NINT(ABS(A(50))))GOTO 15
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SX1F(LM,LD,LC,IM,IN,IH,IK,IL,FH,SH,EH,AH,BH,
     +AR,BR,DH,RP,CP,BP,IS,XA,YA,ZA,HA,A,IQ)
C
C Fourier and peaksearch.  IQ=1 for Patterson, 2 PATS 2nd or following
C cycles or FIND, 3 PATS first cycle (superposition) and 4 PLOP.
C
      INTEGER::IM(LD),IN(LD),IH(LD),IK(LD),IL(LD),IS(LM)
      REAL::FH(LD),SH(LD),AH(LD),BH(LD),EH(LD),AR(LD),BR(LD),DH(LD),
     +RP(LD),CP(LD),BP(LD),XA(LM),YA(LM),ZA(LM),HA(LM),A(596),EF(940)
      REAL,ALLOCATABLE,DIMENSION(:)::B,C
      COMMON/FLAGS/ST,SL,LF,LI,LP,LR,LN,LZ,LY,LE,LW,LS,LV,LQ,JU,
     +LO,LG,LU,LX,NP,MP,JR,JS,JK,JW,FM,RM,PC,PP,HP,FW,PW,WX
      COMMON/SFAC/EF
C
   1  FORMAT(' Fourier grid = ',2(I5,' x'),I5,F10.3,' <= z <=',F6.3)
   2  FORMAT(/1X,77('-'))
   3  FORMAT(1X)
C
C Set up Fourier grid etc.  N1, N2 and N3 are set to the smallest
C powers of 2 which are greater than A(43) times the maximum absolute
C values of h, k and l respectively. Use A(65) instead of A(43) for
C calculating Patterson.
C
      CALL SXTO(8)
      T=1.
      L=INT(ABS(A(62)))
      IF(IABS(L-4).LT.3)T=.5
      IF(L.EQ.3)T=.3333333
      S=T
      P=0.
      AZ=99.
        DO 5 K=133,LY,12
        IF(ABS(A(K+6))+ABS(A(K+7)).GT.0.1)GOTO 5
        U=99.5+A(K+11)
        W=99.5+A(K+11)-S
        IF(A(62).GT.0.)GOTO 4
        IF(A(K+8).GT.0.)GOTO 4
        AZ=AMIN1(AZ,.5*ABS(U-AINT(U)-.5),.5*ABS(W-AINT(W)-.5))
        GOTO 5
   4    V=99.5-A(K+11)
        Q=99.5-A(K+11)-S
        U=AMIN1(ABS(U-AINT(U)-.5),ABS(V-AINT(V)-.5),ABS(W-AINT(W)-.5),
     +  ABS(Q-AINT(Q)-.5))
        IF(U.LT.0.05)GOTO 5
        T=AMIN1(T,U)
   5    CONTINUE
      IF(A(62).GT.0.)AZ=0.
      IF(IQ.EQ.1)AZ=0.
      EZ=.5*T+AZ
      IF(AZ.LT.98.)GOTO 6
      AZ=0.
      EZ=T
   6  IF(IQ.EQ.1)EZ=.5
      L=1
      M=1
      N3=1
        DO 8 N=1,LE
          DO 7 K=121,LY,12
          L=MAX0(L,IABS(INT(1.0001*(REAL(IH(N))*A(K)+
     +    REAL(IK(N))*A(K+3)+REAL(IL(N))*A(K+6)))))
          M=MAX0(M,IABS(INT(1.0001*(REAL(IH(N))*A(K+1)+
     +    REAL(IK(N))*A(K+4)+REAL(IL(N))*A(K+7)))))
          N3=MAX0(N3,IABS(INT(1.0001*(REAL(IH(N))*A(K+2)+
     +    REAL(IK(N))*A(K+5)+REAL(IL(N))*A(K+8)))))
   7      CONTINUE
   8    CONTINUE
      T=A(43)
      IF(IQ.EQ.1)T=ABS(A(65))
      L=INT(T*REAL(L)+0.5)
      M=INT(T*REAL(M)+0.5)
      N3=INT((EZ-AZ)*T*REAL(N3)+0.5)
      N1=1
   9  N1=N1*2
      IF(N1.LT.L)GOTO 9
      N2=1
  10  N2=N2*2
      IF(N2.LT.M)GOTO 10
      DX=1./REAL(N1)
      DY=1./REAL(N2)
      DZ=(EZ-AZ)/REAL(N3)
      N3=N3+3
      JQ=2
      IF(IQ.NE.1)GOTO 11
      IF(N1*N2.GT.LD)CALL SXER('NOT ENOUGH MEMORY ALLOCATED - USE '//
     +'-L SWITCH TO INCREASE')
      IM(1)=N1
      IM(2)=N2
      IM(3)=N3-2
      W=1./DZ
      CALL SXPS(3,0,W,T,XA,YA,ZA,HA,IM)
      GOTO 12
  11  IF(LU.GT.0)GOTO 12
      LU=1
      WRITE(*,1)N1,N2,N3,AZ-DZ,EZ+DZ
      WRITE(LI,2)
      WRITE(LI,3)
      WRITE(LI,1)N1,N2,N3,AZ-DZ,EZ+DZ
      WRITE(LI,2)
  12  N6=2*N1
      N4=N2*N6
      N5=N4-1
      N7=0
      N8=0
      LK=3*N4
      ALLOCATE(B(LK),STAT=I)
      IF(I.NE.0)GOTO 13
      IF(NINT(A(26)).EQ.0)GOTO 14
      IF(IQ.NE.2)GOTO 14
      N7=NINT(A(29)/(DZ*A(4)))+2
      N=N1*N2*(N3+2*N7)
      ALLOCATE(C(N),STAT=I)
      IF(I.EQ.0)GOTO 14
  13  CALL SXER('NOT ENOUGH MEMORY TO STORE FOURIER')
C
C Set up Fourier synthesis in layers perpendicular to ab-plane
C
  14  TH=0.
      TM=0.
      SW=0.
      SN=0.
      PQ=0.
      M1=1
      M2=0
      M3=0
      ZL=(AZ-2.*DZ)*6.283185
      NP=LX
      MQ=MP
      IF(ABS(A(35)-1.).GE.0.0001.AND.IQ.GT.1)MQ=(3*MQ)/2
      ML=7*(MQ+5)
      IF(IQ.EQ.1)ML=NINT(A(42))*(MQ+5)
      ML=MIN0(ML,JW-1000,LD-LC-1000)
      NS=LC+1
      LL=LC
      IF(IQ.EQ.3)GOTO 25
C
C Expand to triclinic hemisphere, avoiding redundancy
C
        DO 23 I=1,LE
        IF(IQ.EQ.1)GOTO 15
        IF(AR(I)**2+BR(I)**2.LT.0.0001)GOTO 23
        GOTO 17
  15    IF(A(65).GT.0.)GOTO 16
        P=SQRT(EH(I)**3*FH(I))
        GOTO 17
  16    P=FH(I)**2
  17    X=REAL(IH(I))
        Y=REAL(IK(I))
        Z=REAL(IL(I))
        M=LL
          DO 22 K=121,LY,12
          NH=INT(1.001*(X*A(K)+Y*A(K+3)+Z*A(K+6)))
          NK=INT(1.001*(X*A(K+1)+Y*A(K+4)+Z*A(K+7)))
          NL=INT(1.001*(X*A(K+2)+Y*A(K+5)+Z*A(K+8)))
          T=6.283185*(X*A(K+9)+Y*A(K+10)+Z*A(K+11))
          S=1.
          L=NL
          IF(L.EQ.0)L=NK
          IF(L.EQ.0)L=NH
          IF(L.GE.0)GOTO 18
          S=-S
          NH=-NH
          NK=-NK
          NL=-NL
  18      J=M
  19      J=J+1
          IF(J.GT.LL)GOTO 20
          IF(NH.NE.IH(J))GOTO 19
          IF(NK.NE.IK(J))GOTO 19
          IF(NL.NE.IL(J))GOTO 19
          GOTO 22
  20      IF(LL.GE.LD)CALL SXER('ARRAYS TOO SMALL - INCREASE LD')
          LL=LL+1
          IH(LL)=NH
          IK(LL)=NK
          IL(LL)=NL
          DH(LL)=0.
          RP(LL)=0.
          IF(IQ.NE.1)GOTO 21
          AR(LL)=P
          BR(LL)=0.
          GOTO 22
  21      U=COS(T)
          V=SIN(T)
          AR(LL)=AR(I)*U+BR(I)*V
          BR(LL)=S*(BR(I)*U-AR(I)*V)
  22      CONTINUE
  23    CONTINUE
      NN=LL-LC
      CALL SXIS(NN,IN(NS),IL(NS),IH(NS),IK(NS),AR(NS),BR(NS),DH(NS),
     +EH(NS),AH(NS),BH(NS),FH(NS),SH(NS),RP(NS),BP(NS),CP(NS))
C
C The array IN holds the addresses of h,k pairs in the FFT array
C
        DO 24 N=NS,LL
        L=IH(N)
        IF(L.LT.0)L=L+N1
        M=IK(N)
        IF(M.LT.0)M=M+N2
        IN(N)=2*(L+M*N1)
  24    CONTINUE
C
C Fourier transform one layer
C
  25    DO 40 NL=1-N7,N3+N7
        IF(NL.GT.0.AND.NL.LE.N3)ZL=ZL+6.283185*DZ
        IF(IQ.EQ.3)GOTO 30
          DO 26 I=M1,M1+N5
          B(I)=0.
  26      CONTINUE
        L=0
        U=1.
        V=0.
          DO 28 N=NS,LL
          IF(IL(N).EQ.L)GOTO 27
          L=IL(N)
          T=ZL*REAL(L)
          U=COS(T)
          V=SIN(T)
  27      I=IN(N)+M1
          B(I)=B(I)+U*AR(N)+V*BR(N)
          B(I+1)=B(I+1)+V*AR(N)-U*BR(N)
  28      CONTINUE
C
C The following 2D radix-2 FFT subroutine can be replaced by other
C FFTs for faster operation, e.g. the Intel MKL routine CFFT2D
C for IA32 and IA64 (about twice as fast).
C
        CALL SXFT(B(M1),N1,N2,1)
C
C       CALL CFFT2D(B(M1),N1,N2,1)
C
        IF(N7.EQ.0)GOTO 33
          DO 29 N=M1,M1+N5,2
          N8=N8+1
          C(N8)=B(N)
  29      CONTINUE
        IF(NL.LT.1.OR.NL.GT.N3)GOTO 40
        GOTO 33
C
C Full-symmetry PSMF if IQ=3
C
  30    CALL SXTO(4)
        ML=LG-1000
          DO 32 N=0,N5,2
          U=.5*DX*REAL(MOD(N,N6))
          V=DY*REAL(N/N6)
          W=DZ*REAL(NL-2)
          M=LG
            DO 31 I=LG,JW-1
            M=M-1
            Q=XA(I)-U
            XA(M)=Q-AINT(Q)-0.5
            Q=YA(I)-V
            YA(M)=Q-AINT(Q)-0.5
            Q=ZA(I)-W
            ZA(M)=Q-AINT(Q)-0.5
  31        CONTINUE
          CALL SXPS(LG-M,2,B(N+M1),A(66),XA(M),YA(M),ZA(M),HA(M),IM)
  32      CONTINUE
C
C Peaksearch and interpolation
C
  33    IF(M3.EQ.0)GOTO 37
        CALL SXTO(9)
        GW=0.
        GN=0.
          DO 36 N=0,N5,2
          P=B(M2+N)
          Q=P
          IF(IQ.EQ.3)Q=AMAX1(Q,0.)
          GW=GW+Q**2
          GN=GN+1.
          IF(P.LT.0.)GOTO 36
          IF(P.LE.B(N+M1))GOTO 36
          IF(P.LE.B(N+M3))GOTO 36
          M=N-2
          IF(MOD(N,N6).EQ.0)M=M+N6
          IF(P.LE.B(M+M1))GOTO 36
          IF(P.LE.B(M+M3))GOTO 36
          XL=B(M+M2)
          IF(P.LE.XL)GOTO 36
          L=M-N6
          IF(L.LT.0)L=L+N4
          IF(P.LE.B(L+M1))GOTO 36
          IF(P.LE.B(L+M2))GOTO 36
          IF(P.LE.B(L+M3))GOTO 36
          L=M+N6
          IF(L.GT.N5)L=L-N4
          IF(P.LE.B(L+M1))GOTO 36
          IF(P.LE.B(L+M2))GOTO 36
          IF(P.LE.B(L+M3))GOTO 36
          M=N+2
          IF(MOD(M,N6).EQ.0)M=M-N6
          IF(P.LE.B(M+M1))GOTO 36
          IF(P.LE.B(M+M3))GOTO 36
          XM=B(M+M2)
          IF(P.LE.XM)GOTO 36
          L=M-N6
          IF(L.LT.0)L=L+N4
          IF(P.LE.B(L+M1))GOTO 36
          IF(P.LE.B(L+M2))GOTO 36
          IF(P.LE.B(L+M3))GOTO 36
          L=M+N6
          IF(L.GT.N5)L=L-N4
          IF(P.LE.B(L+M1))GOTO 36
          IF(P.LE.B(L+M2))GOTO 36
          IF(P.LE.B(L+M3))GOTO 36
          M=N-N6
          IF(M.LT.0)M=M+N4
          IF(P.LE.B(M+M1))GOTO 36
          IF(P.LE.B(M+M3))GOTO 36
          YL=B(M+M2)
          IF(P.LE.YL)GOTO 36
          M=N+N6
          IF(M.GT.N5)M=M-N4
          IF(P.LE.B(M+M1))GOTO 36
          IF(P.LE.B(M+M3))GOTO 36
          YM=B(M+M2)
          IF(P.LE.YM)GOTO 36
          Q=P+P
          U=XL-XM
          V=YL-YM
          W=B(M3+N)-B(M1+N)
          XL=XL+XM-Q
          R=U/XL
          S=YL+YM-Q
          XL=XL+S
          S=V/S
          T=B(M1+N)+B(M3+N)-Q
          XL=XL+T
          T=W/T
          P=P-0.125*(U*R+V*S+W*T)
          IF(P.LE.TH)GOTO 36
          R=.5*DX*(REAL(MOD(N,N6))+R)
          S=DY*(REAL(N/N6)+.5*S)
          T=DZ*(REAL(NL-3)+.5*T)
          NP=NP+1
          HA(NP)=P
          XA(NP)=R
          YA(NP)=S
          ZA(NP)=T
          CP(NP+LC)=ABS(XL)
C
C Increase threshold if not enough memory
C
          TM=AMAX1(TM,P)
  34      IF(NP.LT.ML)GOTO 36
          TH=TH+0.01*TM
          M=LX
            DO 35 L=LX+1,NP
            IF(HA(L).LE.TH)GOTO 35
            M=M+1
            HA(M)=HA(L)
            XA(M)=XA(L)
            YA(M)=YA(L)
            ZA(M)=ZA(L)
  35        CONTINUE
          NP=M
          GOTO 34
  36      CONTINUE
        SW=SW+GW
        SN=SN+GN
C
C Store Patterson and set next Fourier layer
C
  37    CALL SXTO(8)
        K=M1+N4
        IF(K.GT.3*N4)K=1
        IF(IQ.NE.1)GOTO 39
        IF(NL.EQ.N3)GOTO 39
        IF(NL.EQ.1)GOTO 39
        IF(NL.EQ.2)PQ=32000./SQRT(B(M1))
        JQ=0
          DO 38 I=M1,M1+N5,2
          JQ=JQ+1
          J=NINT(SIGN(SQRT(ABS(B(I))),B(I))*PQ)
          IM(JQ)=J
  38      CONTINUE
        CALL SXPS(JQ,1,U,V,XA,YA,ZA,HA,IM)
  39    M3=M2
        M2=M1
        M1=K
  40    CONTINUE
C
C Reject peaks less than smin*sigma
C
      CALL SXTO(9)
      SN=SQRT(SN/AMAX1(0.0001,SW))
      N=NP
      NP=LX
      T=2.
      IF(IQ.EQ.1)T=0.
      IF(IQ.EQ.3)T=1.
        DO 41 I=LX+1,N
        P=HA(I)*SN
        IF(P.LT.T)GOTO 41
        NP=NP+1
        HA(NP)=P
        XA(NP)=XA(I)
        YA(NP)=YA(I)
        ZA(NP)=ZA(I)
        CP(LC+NP)=CP(LC+I)
  41    CONTINUE
C
C Quick and dirty peak-sort
C
      NI=MIN0(100000,LD-NS)
      Q=REAL(NI)/(SN*AMAX1(TM,1.E-6))
      NI=NI+NS
        DO 42 I=NS,NI
        IN(I)=0
  42    CONTINUE
        DO 43 I=LX+1,NP
        J=NI-INT(Q*HA(I))
C
C The following test is included because it prevents an Athlon
C floating point error when the Intel ifort compiler is used.
C It should never produce the message!
C
        IF(J.LT.NS.OR.J.GT.NI)WRITE(*,'(A,3I6)')' ** Error:',NS,J,NI
C
        IN(J)=IN(J)+1
  43    CONTINUE
      J=LX
        DO 44 I=NS,NI
        M=IN(I)
        IN(I)=J
        J=J+M
  44    CONTINUE
      J=LX
  45  J=J+1
      IF(J.GT.NP)GOTO 48
      U=XA(J)
      V=YA(J)
      W=ZA(J)
      P=HA(J)
      R=CP(LC+J)
      GOTO 47
  46  T=U
      U=XA(L)
      XA(L)=T
      T=V
      V=YA(L)
      YA(L)=T
      T=W
      W=ZA(L)
      ZA(L)=T
      T=R
      R=CP(LC+L)
      CP(LC+L)=T
      T=P
      P=HA(L)
      HA(L)=-T
  47  IF(P.LT.0.)GOTO 45
      M=NI-INT(P*Q)
      IN(M)=IN(M)+1
      L=IN(M)
      IF(L.NE.J)GOTO 46
      HA(J)=-P
      XA(J)=U
      YA(J)=V
      ZA(J)=W
      CP(LC+J)=R
      GOTO 45
C
C Generate equivalents of fixed atoms
C
  48  NI=LC
        DO 53 I=1,LX
        P=EF(IS(I)+9)
        X=XA(I)
        Y=YA(I)
        Z=ZA(I)
        J=NI
          DO 52 K=121,LY,12
            DO 51 L=69,LV,4
            J=J+1
            IF(J.GT.LD)GOTO 96
            AH(J)=A(L+1)+A(L)*(X*A(K)+Y*A(K+1)+Z*A(K+2)+A(K+9))
            BH(J)=A(L+2)+A(L)*(X*A(K+3)+Y*A(K+4)+Z*A(K+5)+A(K+10))
            DH(J)=A(L+3)+A(L)*(X*A(K+6)+Y*A(K+7)+Z*A(K+8)+A(K+11))
            R=AH(J)
            R=R-AINT(R)-0.5
            S=BH(J)
            S=S-AINT(S)-0.5
            T=DH(J)
            T=T-AINT(T)-0.5
              DO 49 M=NI+1,J-1
              U=AH(M)-R
              U=U-AINT(U)-0.5
              V=BH(M)-S
              V=V-AINT(V)-0.5
              W=DH(M)-T
              W=W-AINT(W)-0.5
              IF(A(8)*U**2+A(9)*V**2+A(10)*W**2+A(11)*V*W+
     +        A(12)*U*W+A(13)*U*V.LT.0.1)GOTO 50
  49          CONTINUE
            SH(J)=CP(LC+I)
            EH(J)=P**2
            FH(J)=-1.
            IF(IQ.EQ.4)FH(J)=(P+0.96)**2
            GOTO 51
  50        J=J-1
  51        CONTINUE
  52      CONTINUE
        NI=J
  53    CONTINUE
C
C Check for special position and idealize coordinates
C
      N=LX
      M=LX
      NK=LX+NINT(A(36))+1
      QQ=0.25
      O=-0.1
      PO=0.
      LL=9999
      IF(IQ.EQ.1)GOTO 55
      QQ=1.
      PO=1.
      LL=INT(ABS(A(112)))
      IF(IQ.EQ.4)GOTO 54
      QQ=A(63)**2
      IF(A(64).GT.0.)O=A(64)**2
      LL=3
      GOTO 55
  54  IF(A(113).GT.0.)O=A(113)**2
  55  T=1.5*SQRT(AMAX1(QQ,4.12))
      TX=T/A(2)
      TY=T/A(3)
  56  N=N+1
      IF(N.GT.NP)GOTO 68
      X=XA(N)
      Y=YA(N)
      Z=ZA(N)
        DO 60 J=1,3
        R=0.
        S=0.
        T=0.
        Q=1.
        PT=-1.
        IF(IQ.EQ.1)PT=SIGN(1.,-A(62))
  57      DO 59 K=121,LY,12
            DO 58 L=69,LV,4
            IF(K+L.EQ.190)GOTO 58
            U=A(L+1)-PT*A(L)*(X*A(K)+Y*A(K+1)+Z*A(K+2)+PO*A(K+9))-X
            U=U-AINT(U)-0.5
            V=A(L+2)-PT*A(L)*(X*A(K+3)+Y*A(K+4)+Z*A(K+5)+
     +      PO*A(K+10))-Y
            V=V-AINT(V)-0.5
            W=A(L+3)-PT*A(L)*(X*A(K+6)+Y*A(K+7)+Z*A(K+8)+
     +      PO*A(K+11))-Z
            W=W-AINT(W)-0.5
            P=A(8)*U**2+A(9)*V**2+A(10)*W**2+A(11)*V*W+
     +      A(12)*U*W+A(13)*U*V
            IF(P.LT.O)GOTO 56
            IF(P.GT.0.1)GOTO 58
            R=R+U
            S=S+V
            T=T+W
            Q=Q+1.
  58        CONTINUE
  59      CONTINUE
        PT=-PT
        IF(PT.LT.0.)GOTO 57
        X=X+R/Q
        Y=Y+S/Q
        Z=Z+T/Q
  60    CONTINUE
C
C Test peak against equivalents of higher peaks
C
      K=0
      IF(IQ.NE.1)GOTO 61
      Z=Z+999.5
      Z=Z-AINT(Z)-0.5
      IF(Z.GE.0.)GOTO 61
      X=-X
      Y=-Y
      Z=-Z
  61    DO 62 J=NS,NI
        V=BH(J)-Y
        V=V-AINT(V)-0.5
        IF(ABS(V).GT.TY)GOTO 62
        U=AH(J)-X
        U=U-AINT(U)-0.5
        IF(ABS(U).GT.TX)GOTO 62
        W=DH(J)-Z
        W=W-AINT(W)-0.5
        T=A(8)*U**2+A(9)*V**2+A(10)*W**2+A(11)*V*W+
     +  A(12)*U*W+A(13)*U*V
        IF(T.LT.QQ)GOTO 56
        IF(T.LT.EH(J))GOTO 56
        IF(T.LT.FH(J))K=K+1
  62    CONTINUE
      IF(K.GT.LL)GOTO 56
C
C Store atom and generate equivalents
C
      M=M+1
      BP(M)=1./Q
      HA(M)=ABS(HA(N))
      XA(M)=99.+X
      XA(M)=XA(M)-AINT(XA(M))
      YA(M)=99.+Y
      YA(M)=YA(M)-AINT(YA(M))
      ZA(M)=Z
      CP(LC+M)=CP(LC+N)
      IS(M)=51
      J=NI
        DO 67 K=121,LY,12
          DO 66 L=69,LV,4
          J=J+1
          IF(J.GT.LD)GOTO 96
          AH(J)=A(L+1)+A(L)*(X*A(K)+Y*A(K+1)+Z*A(K+2)+PO*A(K+9))
          BH(J)=A(L+2)+A(L)*(X*A(K+3)+Y*A(K+4)+Z*A(K+5)+PO*A(K+10))
          DH(J)=A(L+3)+A(L)*(X*A(K+6)+Y*A(K+7)+Z*A(K+8)+PO*A(K+11))
          T=DH(J)-AINT(DH(J))-0.5
          IF(IQ.NE.1)GOTO 63
          IF(T.GE.0.)GOTO 63
          T=-T
          AH(J)=199.-AH(J)
          BH(J)=199.-BH(J)
          DH(J)=199.-DH(J)
  63      R=AH(J)-AINT(AH(J))-0.5
          S=BH(J)-AINT(BH(J))-0.5
            DO 64 MI=NI+1,J-1
            U=AH(MI)-R
            U=U-AINT(U)-0.5
            V=BH(MI)-S
            V=V-AINT(V)-0.5
            W=DH(MI)-T
            W=W-AINT(W)-0.5
            IF(A(8)*U**2+A(9)*V**2+A(10)*W**2+A(11)*V*W+
     +      A(12)*U*W+A(13)*U*V.LT.0.1)GOTO 65
  64        CONTINUE
          SH(J)=CP(LC+M)
          EH(J)=1.
          FH(J)=-1.
          IF(IQ.EQ.4)FH(J)=4.12
          GOTO 66
  65      J=J-1
  66      CONTINUE
  67    CONTINUE
      NI=J
      IF(M.LT.MQ)GOTO 56
  68  NP=M
C
C Set up starting positions for split disulfides
C
      IF(IQ.EQ.4)GOTO 91
      IF(N7.EQ.0)GOTO 99
      N6=N3-2+N7
        DO 69 I=NI+1,NI+6
        AH(I)=0.
        BH(I)=0.
        DH(I)=0.
  69    CONTINUE
      U=A(27)/A(2)
      AH(NI+1)=-U
      AH(NI+2)=U
      V=A(27)/A(3)
      BH(NI+3)=-V
      BH(NI+4)=V
      W=A(27)/A(4)
      DH(NI+5)=-W
      DH(NI+6)=W
      L=NI+6
        DO 72 I=1,2
          DO 71 J=1,2
            DO 70 K=1,2
            L=L+1
            AH(L)=U*0.57735
            BH(L)=V*0.57735
            DH(L)=W*0.57735
            U=-U
  70        CONTINUE
          V=-V
  71      CONTINUE
        W=-W
  72    CONTINUE
C
C Scan original peaks, refine from each disulfide orientation in turn
C
      NN=NP
        DO 82 L=1,NP
        IF(BP(L).LT.0.9)GOTO 82
        NN=NN+2
        IS(NN)=L
        HA(NN-1)=1.2*HA(L)
        HA(NN)=0.
        NY=NN+1
        NZ=NN+2
        NG=2
          DO 81 M1=NI+1,NI+14
          XA(NY)=XA(L)+0.75*AH(M1)
          XA(NZ)=XA(L)-0.25*AH(M1)
          YA(NY)=YA(L)+0.75*BH(M1)
          YA(NZ)=YA(L)-0.25*BH(M1)
          ZA(NY)=ZA(L)+0.75*DH(M1)
          ZA(NZ)=ZA(L)-0.25*DH(M1)
          NT=0
          NX=0
C
C Normalize S-S distance
C
  73      U=XA(NZ)-XA(NY)
          V=YA(NZ)-YA(NY)
          W=ZA(NZ)-ZA(NY)
          T=0.5*A(27)/SQRT(A(8)*U**2+A(9)*V**2+A(10)*W**2+
     +    A(11)*V*W+A(12)*U*W+A(13)*U*V)
          U=0.5+T
          V=0.5-T
          W=XA(NZ)*U+XA(NY)*V
          XA(NY)=XA(NZ)*V+XA(NY)*U
          XA(NZ)=W
          W=YA(NZ)*U+YA(NY)*V
          YA(NY)=YA(NZ)*V+YA(NY)*U
          YA(NZ)=W
          W=ZA(NZ)*U+ZA(NY)*V
          ZA(NY)=ZA(NZ)*V+ZA(NY)*U
          ZA(NZ)=W
C
C Look up density at each S position and 6 adjacent pixels
C
  74      M=1
            DO 75 N=NY,NZ
            S=XA(N)/DX
            I=NINT(S)
            W=YA(N)/DY
            J=NINT(W)
            Z=(ZA(N)-AZ)/DZ
            K=NINT(Z)
            S=S-REAL(I)
            W=W-REAL(J)
            Z=Z-REAL(K)
            NH=MOD(I+N1,N1)+1
            NL=MAX0(0,MIN0(N6,K)+N7+1)*N2
            NJ=MOD(J+N2,N2)
            NK=(NL+NJ)*N1
            T=C(NK+NH)
            P=C(NK+MOD(I-1+N1,N1)+1)
            Q=C(NK+MOD(I+1+N1,N1)+1)
            U=C((NL+MOD(J-1+N2,N2))*N1+NH)
            V=C((NL+MOD(J+1+N2,N2))*N1+NH)
            X=C((MAX0(0,MIN0(N6,K-1)+N7+1)*N2+NJ)*N1+NH)
            Y=C((MAX0(0,MIN0(N6,K+1)+N7+1)*N2+NJ)*N1+NH)
            R=2.*T
            B(M+4)=P+Q-R
            B(M+5)=U+V-R
            B(M+6)=X+Y-R
            Q=Q-P
            P=S*B(M+4)
            V=V-U
            U=W*B(M+5)
            Y=Y-X
            X=Z*B(M+6)
            B(M)=0.166667*(S*(P+Q)+W*(U+V)+Z*(X+Y))+T
            B(M+1)=P+0.5*Q
            B(M+2)=U+0.5*V
            B(M+3)=X+0.5*Y
            M=M+7
  75        CONTINUE
          NT=NT+1
          IF(NT.GT.50.OR.NX.GT.10)GOTO 80
            DO 76 N=1,7
            B(N+14)=B(N)+B(N+7)
  76        CONTINUE
          X=1./AMAX1(0.01,-B(19))
          Y=1./AMAX1(0.01,-B(20))
          Z=1./AMAX1(0.01,-B(21))
C
C First refine centroid alone
C
          U=B(16)*X
          V=B(17)*Y
          W=B(18)*Z
          IF(AMAX1(ABS(U),ABS(V),ABS(W)).LT.0.2)GOTO 78
          NX=0
          U=SIGN(AMIN1(ABS(U),0.25),U)
          V=SIGN(AMIN1(ABS(V),0.25),V)
          W=SIGN(AMIN1(ABS(W),0.25),W)
            DO 77 N=NY,NZ
            XA(N)=XA(N)+U*DX
            YA(N)=YA(N)+V*DY
            ZA(N)=ZA(N)+W*DZ
  77        CONTINUE
          GOTO 74
C
C Then 6D interpolation to find new S positions
C
  78      NX=NX+1
          M=2
            DO 79 N=NY,NZ
            XA(N)=XA(N)+DX*B(M)*X
            YA(N)=YA(N)+DY*B(M+1)*Y
            ZA(N)=ZA(N)+DZ*B(M+2)*Z
            M=M+7
  79        CONTINUE
          GOTO 73
C
C Save current disulfide with largest rho1+rho2 if rho1+rho2 > 1.3*rho0
C
  80      U=SN*B(1)
          V=SN*B(8)
          IF(HA(NN-1)+HA(NN).GE.U+V)GOTO 81
          IF(AMIN1(U,V).LT.0.5*HA(L))GOTO 81
          NG=0
          HA(NN-1)=U
          XA(NN-1)=XA(NY)
          YA(NN-1)=YA(NY)
          ZA(NN-1)=ZA(NY)
          HA(NN)=V
          XA(NN)=XA(NZ)
          YA(NN)=YA(NZ)
          ZA(NN)=ZA(NZ)
  81      CONTINUE
        NN=NN-NG
  82    CONTINUE
C
C Transfer best nss disulfides to peak list
C
      M1=NP+NINT(A(26))
      M2=NP+2
  83  IF(NP.GE.M1)GOTO 85
      T=-9999.
      M3=0
        DO 84 I=M2,NN,2
        IF(HA(I-1)+HA(I).LE.T)GOTO 84
        M3=I
        T=HA(I-1)+HA(I)
  84    CONTINUE
      IF(M3.EQ.0)GOTO 90
      L=IS(M3)
      XA(L)=XA(M3-1)
      YA(L)=YA(M3-1)
      ZA(L)=ZA(M3-1)
      HA(L)=HA(M3-1)
      NP=NP+1
      XA(NP)=XA(M3)
      YA(NP)=YA(M3)
      ZA(NP)=ZA(M3)
      HA(NP)=HA(M3)
      BP(NP)=1.
      IS(NP)=51
      XA(M3-1)=XA(M2-1)
      YA(M3-1)=YA(M2-1)
      ZA(M3-1)=ZA(M2-1)
      HA(M3-1)=HA(M2-1)
      XA(M3)=XA(M2)
      YA(M3)=YA(M2)
      ZA(M3)=ZA(M2)
      HA(M3)=HA(M2)
      M2=M2+2
      GOTO 83
C
C Eliminate sulfurs that are too close to each other
C
  85  M1=NP
      NP=LX
        DO 89 I=LX+1,M1
        X=XA(I)
        Y=YA(I)
        Z=ZA(I)
          DO 88 K=121,LY,12
            DO 87 L=69,LV,4
            P=A(L+1)+A(L)*(X*A(K)+Y*A(K+1)+Z*A(K+2)+A(K+9))
            Q=A(L+2)+A(L)*(X*A(K+3)+Y*A(K+4)+Z*A(K+5)+A(K+10))
            R=A(L+3)+A(L)*(X*A(K+6)+Y*A(K+7)+Z*A(K+8)+A(K+11))
              DO 86 M=1,I-1
              U=P-XA(M)
              U=U-AINT(U)-0.5
              V=Q-YA(M)
              V=V-AINT(V)-0.5
              W=R-ZA(M)
              W=W-AINT(W)-0.5
              IF(A(8)*U**2+A(9)*V**2+A(10)*W**2+A(11)*V*W+
     +        A(12)*U*W+A(13)*U*V.LT.1.)GOTO 89
  86          CONTINUE
  87        CONTINUE
  88      CONTINUE
        NP=NP+1
        XA(NP)=XA(I)
        YA(NP)=YA(I)
        ZA(NP)=ZA(I)
        HA(NP)=HA(I)
        BP(NP)=BP(I)
        IS(NP)=IS(I)
  89    CONTINUE
  90  DEALLOCATE(C)
      GOTO 99
C
C Match peaklist to expected cell contents
C
  91  K=LX+1
  92  K=K-1
      J=LY+12
      Q=A(J)
        DO 93 I=LY+12,LS,2
        IF(A(I).LT.Q)GOTO 93
        IF(A(I).LT.1.5)GOTO 93
        Q=A(I)
        J=I
  93    CONTINUE
      P=9.E9
      IF(IQ.LT.4)GOTO 95
      IF(J.EQ.LY+12)GOTO 95
      P=A(J+1)+0.0001
        DO 94 I=1,LX
        IF(IS(I).EQ.NINT(ABS(A(J))))P=P-BP(I)*A(42)
  94    CONTINUE
      A(J)=-A(J)
  95  K=K+1
      IF(K.GT.NP)GOTO 97
      P=P-BP(K)*A(42)
      IF(P.LT.0.)GOTO 92
      IS(K)=NINT(ABS(A(J)))
      GOTO 95
  96  CALL SXER('REFLECTION ARRAY SPACE TOO SMALL - '//
     +'USE -L SWITCH TO INCREASE IT')
  97    DO 98 I=LY+12,LS,2
        A(I)=ABS(A(I))
  98    CONTINUE
  99  DEALLOCATE(B)
      RETURN
      END
C
C ------------------------------------------------------------
C
      BLOCK DATA SFACS
      CHARACTER::KA(94)*2
      REAL::EF(940)
      COMMON/SFAC/EF
      COMMON/ATSYM/KA
C
C KA(N) stores the element symbol of the atom with atomic number N.
C
      DATA KA/'H ','HE','LI','BE','B ','C ','N ','O ','F ','NE','NA',
     +'MG','AL','SI','P ','S ','CL','AR','K ','CA','SC','TI','V ',
     +'CR','MN','FE','CO','NI','CU','ZN','GA','GE','AS','SE','BR',
     +'KR','RB','SR','Y ','ZR','NB','MO','TC','RU','RH','PD','AG',
     +'CD','IN','SN','SB','TE','I ','XE','CS','BA','LA','CE','PR',
     +'ND','PM','SM','EU','GD','TB','DY','HO','ER','TM','YB','LU',
     +'HF','TA','W ','RE','OS','IR','PT','AU','HG','TL','PB','BI',
     +'PO','AT','RN','FR','RA','AC','TH','PA','U ','NP','PU'/
C
      DATA EF(10)/.62/,
     +EF(1)/0.49300/,EF(2)/10.51091/,EF(3)/0.32291/,
     +EF(4)/26.12573/,EF(5)/0.14019/,EF(6)/3.14236/,
     +EF(7)/0.04081/,EF(8)/57.79977/,EF(9)/0.00304/
C
      DATA EF(20)/1.8/,
     +EF(11)/0.87340/,EF(12)/9.10371/,EF(13)/0.63090/,
     +EF(14)/3.35680/,EF(15)/0.31120/,EF(16)/22.92763/,
     +EF(17)/0.17800/,EF(18)/0.98210/,EF(19)/0.00640/
C
      DATA EF(30)/1.82/,
     +EF(21)/1.12820/,EF(22)/3.95460/,EF(23)/0.75080/,
     +EF(24)/1.05240/,EF(25)/0.61750/,EF(26)/85.39058/,
     +EF(27)/0.46530/,EF(28)/168.26120/,EF(29)/0.03770/
C
      DATA EF(40)/1.41/,
     +EF(31)/1.59190/,EF(32)/43.64275/,EF(33)/1.12780/,
     +EF(34)/1.86230/,EF(35)/0.53910/,EF(36)/103.48310/,
     +EF(37)/0.70290/,EF(38)/0.54200/,EF(39)/0.03850/
C
      DATA EF(50)/1.12/,
     +EF(41)/2.05450/,EF(42)/23.21852/,EF(43)/1.33260/,
     +EF(44)/1.02100/,EF(45)/1.09790/,EF(46)/60.34987/,
     +EF(47)/0.70680/,EF(48)/0.14030/,EF(49)/-0.19320/
C
      DATA EF(60)/1.07/,
     +EF(51)/2.31000/,EF(52)/20.84392/,EF(53)/1.02000/,
     +EF(54)/10.20751/,EF(55)/1.58860/,EF(56)/0.56870/,
     +EF(57)/0.86500/,EF(58)/51.65125/,EF(59)/0.21560/
C
      DATA EF(70)/1.0/,
     +EF(61)/12.21261/,EF(62)/0.00570/,EF(63)/3.13220/,
     +EF(64)/9.89331/,EF(65)/2.01250/,EF(66)/28.99754/,
     +EF(67)/1.16630/,EF(68)/0.58260/,EF(69)/-11.52901/
C
      DATA EF(80)/0.96/,
     +EF(71)/3.04850/,EF(72)/13.27711/,EF(73)/2.28680/,
     +EF(74)/5.70111/,EF(75)/1.54630/,EF(76)/0.32390/,
     +EF(77)/0.86700/,EF(78)/32.90894/,EF(79)/0.25080/
C
      DATA EF(90)/0.94/,
     +EF(81)/3.53920/,EF(82)/10.28251/,EF(83)/2.64120/,
     +EF(84)/4.29440/,EF(85)/1.51700/,EF(86)/0.26150/,
     +EF(87)/1.02430/,EF(88)/26.14763/,EF(89)/0.27760/
C
      DATA EF(100)/1.8/,
     +EF(91)/3.95530/,EF(92)/8.40421/,EF(93)/3.11250/,
     +EF(94)/3.42620/,EF(95)/1.45460/,EF(96)/0.23060/,
     +EF(97)/1.12510/,EF(98)/21.71841/,EF(99)/0.35150/
C
      DATA EF(110)/2.16/,
     +EF(101)/4.76260/,EF(102)/3.28500/,EF(103)/3.17360/,
     +EF(104)/8.84221/,EF(105)/1.26740/,EF(106)/0.31360/,
     +EF(107)/1.11280/,EF(108)/129.42410/,EF(109)/0.67600/
C
      DATA EF(120)/1.9/,
     +EF(111)/5.42041/,EF(112)/2.82750/,EF(113)/2.17350/,
     +EF(114)/79.26118/,EF(115)/1.22690/,EF(116)/0.38080/,
     +EF(117)/2.30730/,EF(118)/7.19371/,EF(119)/0.85840/
C
      DATA EF(130)/1.55/,
     +EF(121)/6.42021/,EF(122)/3.03870/,EF(123)/1.90020/,
     +EF(124)/0.74260/,EF(125)/1.59360/,EF(126)/31.54724/,
     +EF(127)/1.96460/,EF(128)/85.08868/,EF(129)/1.11510/
C
      DATA EF(140)/1.47/,
     +EF(131)/6.29151/,EF(132)/2.43860/,EF(133)/3.03530/,
     +EF(134)/32.33374/,EF(135)/1.98910/,EF(136)/0.67850/,
     +EF(137)/1.54100/,EF(138)/81.69379/,EF(139)/1.14070/
C
      DATA EF(150)/1.4/,
     +EF(141)/6.43451/,EF(142)/1.90670/,EF(143)/4.17910/,
     +EF(144)/27.15704/,EF(145)/1.78000/,EF(146)/0.52600/,
     +EF(147)/1.49080/,EF(148)/68.16457/,EF(149)/1.11490/
C
      DATA EF(160)/1.33/,
     +EF(151)/6.90531/,EF(152)/1.46790/,EF(153)/5.20341/,
     +EF(154)/22.21512/,EF(155)/1.43790/,EF(156)/0.25360/,
     +EF(157)/1.58630/,EF(158)/56.17207/,EF(159)/0.86690/
C
      DATA EF(170)/1.32/,
     +EF(161)/11.46041/,EF(162)/0.01040/,EF(163)/7.19641/,
     +EF(164)/1.16620/,EF(165)/6.25561/,EF(166)/18.51942/,
     +EF(167)/1.64550/,EF(168)/47.77846/,EF(169)/-9.55741/
C
      DATA EF(180)/1.8/,
     +EF(171)/7.48451/,EF(172)/0.90720/,EF(173)/6.77231/,
     +EF(174)/14.84071/,EF(175)/0.65390/,EF(176)/43.89835/,
     +EF(177)/1.64420/,EF(178)/33.39293/,EF(179)/1.44450/
C
      DATA EF(190)/2.57/,
     +EF(181)/8.21861/,EF(182)/12.79491/,EF(183)/7.43981/,
     +EF(184)/0.77480/,EF(185)/1.05190/,EF(186)/213.18720/,
     +EF(187)/0.86590/,EF(188)/41.68416/,EF(189)/1.42280/
C
      DATA EF(200)/2.27/,
     +EF(191)/8.62661/,EF(192)/10.44211/,EF(193)/7.38731/,
     +EF(194)/0.65990/,EF(195)/1.58990/,EF(196)/85.74849/,
     +EF(197)/1.02110/,EF(198)/178.43720/,EF(199)/1.37510/
C
      DATA EF(210)/1.91/,
     +EF(201)/9.18901/,EF(202)/9.02131/,EF(203)/7.36791/,
     +EF(204)/0.57290/,EF(205)/1.64090/,EF(206)/136.10810/,
     +EF(207)/1.46800/,EF(208)/51.35315/,EF(209)/1.33290/
C
      DATA EF(220)/1.75/,
     +EF(211)/9.75951/,EF(212)/7.85081/,EF(213)/7.35581/,
     +EF(214)/0.50000/,EF(215)/1.69910/,EF(216)/35.63383/,
     +EF(217)/1.90210/,EF(218)/116.10510/,EF(219)/1.28070/
C
      DATA EF(230)/1.61/,
     +EF(221)/10.29711/,EF(222)/6.86571/,EF(223)/7.35111/,
     +EF(224)/0.43850/,EF(225)/2.07030/,EF(226)/26.89383/,
     +EF(227)/2.05710/,EF(228)/102.47810/,EF(229)/1.21990/
C
      DATA EF(240)/1.54/,
     +EF(231)/10.64061/,EF(232)/6.10381/,EF(233)/7.35371/,
     +EF(234)/0.39200/,EF(235)/3.32400/,EF(236)/20.26262/,
     +EF(237)/1.49220/,EF(238)/98.73999/,EF(239)/1.18320/
C
      DATA EF(250)/1.67/,
     +EF(241)/11.28191/,EF(242)/5.34091/,EF(243)/7.35731/,
     +EF(244)/0.34320/,EF(245)/3.01930/,EF(246)/17.86742/,
     +EF(247)/2.24410/,EF(248)/83.75438/,EF(249)/1.08960/
C
      DATA EF(260)/1.54/,
     +EF(251)/11.76951/,EF(252)/4.76111/,EF(253)/7.35731/,
     +EF(254)/0.30720/,EF(255)/3.52220/,EF(256)/15.35351/,
     +EF(257)/2.30450/,EF(258)/76.88058/,EF(259)/1.03690/
C
      DATA EF(270)/1.55/,
     +EF(261)/12.28411/,EF(262)/4.27910/,EF(263)/7.34091/,
     +EF(264)/0.27840/,EF(265)/4.00340/,EF(266)/13.53591/,
     +EF(267)/2.34880/,EF(268)/71.16927/,EF(269)/1.01180/
C
      DATA EF(280)/1.55/,
     +EF(271)/12.83761/,EF(272)/3.87850/,EF(273)/7.29201/,
     +EF(274)/0.25650/,EF(275)/4.44380/,EF(276)/12.17631/,
     +EF(277)/2.38000/,EF(278)/66.34216/,EF(279)/1.03410/
C
      DATA EF(290)/1.58/,
     +EF(281)/13.33801/,EF(282)/3.58280/,EF(283)/7.16761/,
     +EF(284)/0.24700/,EF(285)/5.61581/,EF(286)/11.39661/,
     +EF(287)/1.67350/,EF(288)/64.81267/,EF(289)/1.19100/
C
      DATA EF(300)/1.63/,
     +EF(291)/14.07431/,EF(292)/3.26550/,EF(293)/7.03181/,
     +EF(294)/0.23330/,EF(295)/5.16521/,EF(296)/10.31631/,
     +EF(297)/2.41000/,EF(298)/58.70976/,EF(299)/1.30410/
C
      DATA EF(310)/1.56/,
     +EF(301)/15.23541/,EF(302)/3.06690/,EF(303)/6.70061/,
     +EF(304)/0.24120/,EF(305)/4.35910/,EF(306)/10.78051/,
     +EF(307)/2.96230/,EF(308)/61.41357/,EF(309)/1.71890/
C
      DATA EF(320)/1.52/,
     +EF(311)/16.08162/,EF(312)/2.85090/,EF(313)/6.37471/,
     +EF(314)/0.25160/,EF(315)/3.70680/,EF(316)/11.44681/,
     +EF(317)/3.68300/,EF(318)/54.76256/,EF(319)/2.13130/
C
      DATA EF(330)/1.51/,
     +EF(321)/16.67232/,EF(322)/2.63450/,EF(323)/6.07011/,
     +EF(324)/0.26470/,EF(325)/3.43130/,EF(326)/12.94791/,
     +EF(327)/4.27790/,EF(328)/47.79726/,EF(329)/2.53100/
C
      DATA EF(340)/1.47/,
     +EF(331)/17.00063/,EF(332)/2.40980/,EF(333)/5.81961/,
     +EF(334)/0.27260/,EF(335)/3.97310/,EF(336)/15.23721/,
     +EF(337)/4.35430/,EF(338)/43.81635/,EF(339)/2.84090/
C
      DATA EF(350)/1.44/,
     +EF(341)/17.17892/,EF(342)/2.17230/,EF(343)/5.23581/,
     +EF(344)/16.57962/,EF(345)/5.63771/,EF(346)/0.26090/,
     +EF(347)/3.98510/,EF(348)/41.43285/,EF(349)/2.95570/
C
      DATA EF(360)/1.8/,
     +EF(351)/17.35551/,EF(352)/1.93840/,EF(353)/6.72861/,
     +EF(354)/16.56232/,EF(355)/5.54931/,EF(356)/0.22610/,
     +EF(357)/3.53750/,EF(358)/39.39723/,EF(359)/2.82500/
C
      DATA EF(370)/2.78/,
     +EF(361)/17.17842/,EF(362)/1.78880/,EF(363)/9.64351/,
     +EF(364)/17.31512/,EF(365)/5.13990/,EF(366)/0.27480/,
     +EF(367)/1.52920/,EF(368)/164.93420/,EF(369)/3.48730/
C
      DATA EF(380)/2.45/,
     +EF(371)/17.56631/,EF(372)/1.55640/,EF(373)/9.81841/,
     +EF(374)/14.09881/,EF(375)/5.42200/,EF(376)/0.16640/,
     +EF(377)/2.66940/,EF(378)/132.37610/,EF(379)/2.50640/
C
      DATA EF(390)/2.08/,
     +EF(381)/17.77602/,EF(382)/1.40290/,EF(383)/10.29461/,
     +EF(384)/12.80061/,EF(385)/5.72630/,EF(386)/0.12560/,
     +EF(387)/3.26588/,EF(388)/104.35410/,EF(389)/1.91213/
C
      DATA EF(400)/1.89/,
     +EF(391)/17.87653/,EF(392)/1.27618/,EF(393)/10.94801/,
     +EF(394)/11.91601/,EF(395)/5.41733/,EF(396)/0.11762/,
     +EF(397)/3.65721/,EF(398)/87.66278/,EF(399)/2.06929/
C
      DATA EF(410)/1.73/,
     +EF(401)/17.61423/,EF(402)/1.18865/,EF(403)/12.01441/,
     +EF(404)/11.76601/,EF(405)/4.04183/,EF(406)/0.20479/,
     +EF(407)/3.53346/,EF(408)/69.79576/,EF(409)/3.75591/
C
      DATA EF(420)/1.66/,
     +EF(411)/3.70250/,EF(412)/0.27720/,EF(413)/17.23563/,
     +EF(414)/1.09580/,EF(415)/12.88761/,EF(416)/11.00401/,
     +EF(417)/3.74290/,EF(418)/61.65846/,EF(419)/4.38750/
C
      DATA EF(430)/1.65/,
     +EF(421)/19.13013/,EF(422)/0.86413/,EF(423)/11.09481/,
     +EF(424)/8.14488/,EF(425)/4.64902/,EF(426)/21.57072/,
     +EF(427)/2.71263/,EF(428)/86.84727/,EF(429)/5.40429/
C
      DATA EF(440)/1.63/,
     +EF(431)/19.26743/,EF(432)/0.80852/,EF(433)/12.91821/,
     +EF(434)/8.43468/,EF(435)/4.86337/,EF(436)/24.79974/,
     +EF(437)/1.56756/,EF(438)/94.29289/,EF(439)/5.37875/
C
      DATA EF(450)/1.65/,
     +EF(441)/19.29572/,EF(442)/0.75154/,EF(443)/14.35011/,
     +EF(444)/8.21759/,EF(445)/4.73425/,EF(446)/25.87494/,
     +EF(447)/1.28918/,EF(448)/98.60629/,EF(449)/5.32800/
C
      DATA EF(460)/1.68/,
     +EF(451)/19.33192/,EF(452)/0.69866/,EF(453)/15.50172/,
     +EF(454)/7.98930/,EF(455)/5.29537/,EF(456)/25.20523/,
     +EF(457)/0.60584/,EF(458)/76.89868/,EF(459)/5.26593/
C
      DATA EF(470)/1.74/,
     +EF(461)/19.28082/,EF(462)/0.64460/,EF(463)/16.68852/,
     +EF(464)/7.47261/,EF(465)/4.80451/,EF(466)/24.66054/,
     +EF(467)/1.04630/,EF(468)/99.81570/,EF(469)/5.17900/
C
      DATA EF(480)/1.79/,
     +EF(471)/19.22142/,EF(472)/0.59460/,EF(473)/17.64442/,
     +EF(474)/6.90891/,EF(475)/4.46100/,EF(476)/24.70084/,
     +EF(477)/1.60290/,EF(478)/87.48257/,EF(479)/5.06941/
C
      DATA EF(490)/1.74/,
     +EF(481)/19.16241/,EF(482)/0.54760/,EF(483)/18.55962/,
     +EF(484)/6.37761/,EF(485)/4.29480/,EF(486)/25.84993/,
     +EF(487)/2.03960/,EF(488)/92.80299/,EF(489)/4.93911/
C
      DATA EF(500)/1.7/,
     +EF(491)/19.18892/,EF(492)/5.83031/,EF(493)/19.10052/,
     +EF(494)/0.50310/,EF(495)/4.45850/,EF(496)/26.89093/,
     +EF(497)/2.46630/,EF(498)/83.95718/,EF(499)/4.78211/
C
      DATA EF(510)/1.71/,
     +EF(501)/19.64182/,EF(502)/5.30340/,EF(503)/19.04552/,
     +EF(504)/0.46070/,EF(505)/5.03711/,EF(506)/27.90744/,
     +EF(507)/2.68270/,EF(508)/75.28258/,EF(509)/4.59091/
C
      DATA EF(520)/1.67/,
     +EF(511)/19.96442/,EF(512)/4.81742/,EF(513)/19.01382/,
     +EF(514)/0.42089/,EF(515)/6.14488/,EF(516)/28.52844/,
     +EF(517)/2.52390/,EF(518)/70.84036/,EF(519)/4.35200/
C
      DATA EF(530)/1.63/,
     +EF(521)/20.14722/,EF(522)/4.34700/,EF(523)/18.99492/,
     +EF(524)/0.38140/,EF(525)/7.51381/,EF(526)/27.76604/,
     +EF(527)/2.27350/,EF(528)/66.87767/,EF(529)/4.07120/
C
      DATA EF(540)/1.8/,
     +EF(531)/20.29332/,EF(532)/3.92820/,EF(533)/19.02982/,
     +EF(534)/0.34400/,EF(535)/8.97671/,EF(536)/26.46594/,
     +EF(537)/1.99000/,EF(538)/64.26587/,EF(539)/3.71180/
C
      DATA EF(550)/2.95/,
     +EF(541)/20.38922/,EF(542)/3.56900/,EF(543)/19.10622/,
     +EF(544)/0.31070/,EF(545)/10.66201/,EF(546)/24.38794/,
     +EF(547)/1.49530/,EF(548)/213.90420/,EF(549)/3.33520/
C
      DATA EF(560)/2.47/,
     +EF(551)/20.33612/,EF(552)/3.21600/,EF(553)/19.29703/,
     +EF(554)/0.27560/,EF(555)/10.88801/,EF(556)/20.20732/,
     +EF(557)/2.69590/,EF(558)/167.20220/,EF(559)/2.77310/
C
      DATA EF(570)/2.17/,
     +EF(561)/20.57802/,EF(562)/2.94817/,EF(563)/19.59901/,
     +EF(564)/0.24448/,EF(565)/11.37271/,EF(566)/18.77261/,
     +EF(567)/3.28719/,EF(568)/133.12410/,EF(569)/2.14678/
C
      DATA EF(580)/2.13/,
     +EF(571)/21.16711/,EF(572)/2.81219/,EF(573)/19.76952/,
     +EF(574)/0.22684/,EF(575)/11.85131/,EF(576)/17.60832/,
     +EF(577)/3.33049/,EF(578)/127.11310/,EF(579)/1.86264/
C
      DATA EF(590)/2.12/,
     +EF(581)/22.04402/,EF(582)/2.77393/,EF(583)/19.66972/,
     +EF(584)/0.22209/,EF(585)/12.38561/,EF(586)/16.76692/,
     +EF(587)/2.82428/,EF(588)/143.64410/,EF(589)/2.05830/
C
      DATA EF(600)/2.11/,
     +EF(591)/22.68452/,EF(592)/2.66248/,EF(593)/19.68472/,
     +EF(594)/0.21063/,EF(595)/12.77401/,EF(596)/15.88502/,
     +EF(597)/2.85137/,EF(598)/137.90310/,EF(599)/1.98486/
C
      DATA EF(610)/2.11/,
     +EF(601)/23.34052/,EF(602)/2.56270/,EF(603)/19.60953/,
     +EF(604)/0.20209/,EF(605)/13.12351/,EF(606)/15.10091/,
     +EF(607)/2.87516/,EF(608)/132.72110/,EF(609)/2.02876/
C
      DATA EF(620)/2.1/,
     +EF(611)/24.00424/,EF(612)/2.47274/,EF(613)/19.42583/,
     +EF(614)/0.19645/,EF(615)/13.43961/,EF(616)/14.39961/,
     +EF(617)/2.89604/,EF(618)/128.00710/,EF(619)/2.20963/
C
      DATA EF(630)/2.3/,
     +EF(621)/24.62744/,EF(622)/2.38790/,EF(623)/19.08862/,
     +EF(624)/0.19420/,EF(625)/13.76031/,EF(626)/13.75461/,
     +EF(627)/2.92270/,EF(628)/123.17410/,EF(629)/2.57450/
C
      DATA EF(640)/2.09/,
     +EF(631)/25.07094/,EF(632)/2.25341/,EF(633)/19.07982/,
     +EF(634)/0.18195/,EF(635)/13.85181/,EF(636)/12.93311/,
     +EF(637)/3.54545/,EF(638)/101.39810/,EF(639)/2.41960/
C
      DATA EF(650)/2.06/,
     +EF(641)/25.89763/,EF(642)/2.24256/,EF(643)/18.21852/,
     +EF(644)/0.19614/,EF(645)/14.31671/,EF(646)/12.66481/,
     +EF(647)/2.95354/,EF(648)/115.36210/,EF(649)/3.58324/
C
      DATA EF(660)/2.05/,
     +EF(651)/26.50703/,EF(652)/2.18020/,EF(653)/17.63832/,
     +EF(654)/0.20217/,EF(655)/14.55962/,EF(656)/12.18991/,
     +EF(657)/2.96577/,EF(658)/111.87410/,EF(659)/4.29728/
C
      DATA EF(670)/2.04/,
     +EF(661)/26.90494/,EF(662)/2.07051/,EF(663)/17.29402/,
     +EF(664)/0.19794/,EF(665)/14.55831/,EF(666)/11.44071/,
     +EF(667)/3.63837/,EF(668)/92.65669/,EF(669)/4.56797/
C
      DATA EF(680)/2.03/,
     +EF(671)/27.65634/,EF(672)/2.07356/,EF(673)/16.42853/,
     +EF(674)/0.22355/,EF(675)/14.97791/,EF(676)/11.36041/,
     +EF(677)/2.98233/,EF(678)/105.70310/,EF(679)/5.92047/
C
      DATA EF(690)/2.02/,
     +EF(681)/28.18193/,EF(682)/2.02859/,EF(683)/15.88512/,
     +EF(684)/0.23885/,EF(685)/15.15421/,EF(686)/10.99751/,
     +EF(687)/2.98706/,EF(688)/102.96110/,EF(689)/6.75622/
C
      DATA EF(700)/2.24/,
     +EF(691)/28.66414/,EF(692)/1.98890/,EF(693)/15.43451/,
     +EF(694)/0.25712/,EF(695)/15.30871/,EF(696)/10.66471/,
     +EF(697)/2.98963/,EF(698)/100.41710/,EF(699)/7.56673/
C
      DATA EF(710)/2.02/,
     +EF(701)/28.94763/,EF(702)/1.90182/,EF(703)/15.22081/,
     +EF(704)/9.98520/,EF(705)/15.10001/,EF(706)/0.26103/,
     +EF(707)/3.71601/,EF(708)/84.32988/,EF(709)/7.97629/
C
      DATA EF(720)/1.86/,
     +EF(711)/29.14404/,EF(712)/1.83262/,EF(713)/15.17261/,
     +EF(714)/9.59991/,EF(715)/14.75861/,EF(716)/0.27512/,
     +EF(717)/4.30013/,EF(718)/72.02908/,EF(719)/8.58155/
C
      DATA EF(730)/1.71/,
     +EF(721)/29.20244/,EF(722)/1.77333/,EF(723)/15.22931/,
     +EF(724)/9.37047/,EF(725)/14.51351/,EF(726)/0.29598/,
     +EF(727)/4.76492/,EF(728)/63.36447/,EF(729)/9.24355/
C
      DATA EF(740)/1.67/,
     +EF(731)/29.08183/,EF(732)/1.72029/,EF(733)/15.43001/,
     +EF(734)/9.22591/,EF(735)/14.43271/,EF(736)/0.32170/,
     +EF(737)/5.11983/,EF(738)/57.05606/,EF(739)/9.88751/
C
      DATA EF(750)/1.67/,
     +EF(741)/28.76213/,EF(742)/1.67191/,EF(743)/15.71892/,
     +EF(744)/9.09228/,EF(745)/14.55641/,EF(746)/0.35050/,
     +EF(747)/5.44174/,EF(748)/52.08615/,EF(749)/10.47201/
C
      DATA EF(760)/1.64/,
     +EF(751)/28.18944/,EF(752)/1.62903/,EF(753)/16.15501/,
     +EF(754)/8.97949/,EF(755)/14.93051/,EF(756)/0.38266/,
     +EF(757)/5.67590/,EF(758)/48.16475/,EF(759)/11.00051/
C
      DATA EF(770)/1.66/,
     +EF(761)/27.30493/,EF(762)/1.59279/,EF(763)/16.72961/,
     +EF(764)/8.86554/,EF(765)/15.61152/,EF(766)/0.41792/,
     +EF(767)/5.83378/,EF(768)/45.00114/,EF(769)/11.47221/
C
      DATA EF(780)/1.67/,
     +EF(771)/27.00594/,EF(772)/1.51293/,EF(773)/17.76392/,
     +EF(774)/8.81175/,EF(775)/15.71312/,EF(776)/0.42459/,
     +EF(777)/5.78371/,EF(778)/38.61034/,EF(779)/11.68831/
C
      DATA EF(790)/1.74/,
     +EF(781)/16.88193/,EF(782)/0.46110/,EF(783)/18.59132/,
     +EF(784)/8.62161/,EF(785)/25.55824/,EF(786)/1.48260/,
     +EF(787)/5.86001/,EF(788)/36.39563/,EF(789)/12.06581/
C
      DATA EF(800)/1.8/,
     +EF(791)/20.68092/,EF(792)/0.54500/,EF(793)/19.04172/,
     +EF(794)/8.44841/,EF(795)/21.65752/,EF(796)/1.57290/,
     +EF(797)/5.96761/,EF(798)/38.32463/,EF(799)/12.60891/
C
      DATA EF(810)/1.94/,
     +EF(801)/27.54463/,EF(802)/0.65515/,EF(803)/19.15842/,
     +EF(804)/8.70752/,EF(805)/15.53802/,EF(806)/1.96347/,
     +EF(807)/5.52594/,EF(808)/45.81496/,EF(809)/13.17461/
C
      DATA EF(820)/1.9/,
     +EF(811)/31.06174/,EF(812)/0.69020/,EF(813)/13.06371/,
     +EF(814)/2.35760/,EF(815)/18.44202/,EF(816)/8.61801/,
     +EF(817)/5.96961/,EF(818)/47.25795/,EF(819)/13.41181/
C
      DATA EF(830)/1.9/,
     +EF(821)/33.36894/,EF(822)/0.70400/,EF(823)/12.95101/,
     +EF(824)/2.92380/,EF(825)/16.58772/,EF(826)/8.79371/,
     +EF(827)/6.46921/,EF(828)/48.00935/,EF(829)/13.57821/
C
      DATA EF(840)/1.9/,
     +EF(831)/34.67264/,EF(832)/0.70100/,EF(833)/15.47331/,
     +EF(834)/3.55078/,EF(835)/13.11381/,EF(836)/9.55643/,
     +EF(837)/7.02589/,EF(838)/47.00455/,EF(839)/13.67701/
C
      DATA EF(850)/1.9/,
     +EF(841)/35.31633/,EF(842)/0.68587/,EF(843)/19.02112/,
     +EF(844)/3.97458/,EF(845)/9.49888/,EF(846)/11.38241/,
     +EF(847)/7.42519/,EF(848)/45.47156/,EF(849)/13.71081/
C
      DATA EF(860)/2.1/,
     +EF(851)/35.56314/,EF(852)/0.66310/,EF(853)/21.28162/,
     +EF(854)/4.06910/,EF(855)/8.00371/,EF(856)/14.04221/,
     +EF(857)/7.44331/,EF(858)/44.24734/,EF(859)/13.69051/
C
      DATA EF(870)/3.1/,
     +EF(861)/35.92993/,EF(862)/0.64645/,EF(863)/23.05472/,
     +EF(864)/4.17619/,EF(865)/12.14391/,EF(866)/23.10522/,
     +EF(867)/2.11253/,EF(868)/150.64510/,EF(869)/13.72471/
C
      DATA EF(880)/2.5/,
     +EF(871)/35.76303/,EF(872)/0.61634/,EF(873)/22.90642/,
     +EF(874)/3.87135/,EF(875)/12.47391/,EF(876)/19.98872/,
     +EF(877)/3.21097/,EF(878)/142.32510/,EF(879)/13.62111/
C
      DATA EF(890)/2.2/,
     +EF(881)/35.65973/,EF(882)/0.58909/,EF(883)/23.10323/,
     +EF(884)/3.65155/,EF(885)/12.59771/,EF(886)/18.59901/,
     +EF(887)/4.08655/,EF(888)/117.02010/,EF(889)/13.52661/
C
      DATA EF(900)/2.15/,
     +EF(891)/35.56453/,EF(892)/0.56336/,EF(893)/23.42192/,
     +EF(894)/3.46204/,EF(895)/12.74731/,EF(896)/17.83092/,
     +EF(897)/4.80704/,EF(898)/99.17230/,EF(899)/13.43141/
C
      DATA EF(910)/2.1/,
     +EF(901)/35.88474/,EF(902)/0.54775/,EF(903)/23.29482/,
     +EF(904)/3.41519/,EF(905)/14.18911/,EF(906)/16.92352/,
     +EF(907)/4.17287/,EF(908)/105.25110/,EF(909)/13.42871/
C
      DATA EF(920)/2.1/,
     +EF(911)/36.02284/,EF(912)/0.52930/,EF(913)/23.41283/,
     +EF(914)/3.32530/,EF(915)/14.94911/,EF(916)/16.09273/,
     +EF(917)/4.18800/,EF(918)/100.61310/,EF(919)/13.39661/
C
      DATA EF(930)/2.1/,
     +EF(921)/36.18744/,EF(922)/0.51193/,EF(923)/23.59642/,
     +EF(924)/3.25396/,EF(925)/15.64022/,EF(926)/15.36222/,
     +EF(927)/4.18550/,EF(928)/97.49089/,EF(929)/13.35731/
C
      DATA EF(940)/2.1/,
     +EF(931)/36.52544/,EF(932)/0.49938/,EF(933)/23.80832/,
     +EF(934)/3.26371/,EF(935)/16.77072/,EF(936)/14.94551/,
     +EF(937)/3.47947/,EF(938)/105.98010/,EF(939)/13.38121/
C
      END
