C
      PROGRAM SHELXC
C
C         Create files for phasing with SHELXD and SHELXE
C         ===============================================
C
C          ** FORTRAN-95 version 2006/3 February 2006 **
C
C IH(), IK() and IL() are the reflection indices h, k and l. FF() and
C SA() are experimental intesities sigma(I), EP() holds Sqrt(epsilon),
C SQ() stores 1/(4d^2) = (sin(theta)/lambda)^2, IC is the dataset code,
C Later FA() and FB() are the real and imaginary parts of FA, SA() its
C esd. C(1-6) holds the cell in Angstroms and degrees, C(7-12) the
C coefficients for calculating 1/d^2 = (2sin(theta)/lambda)^2 and C(13)
C the cell volume. SY(1-NS) are the symmetry operators, LT the SHELX
C lattice code, IX(), IY(), IZ() the local scaling offsets, SL() the
C local scaling lookup table and D() and G() local working space.
C
      INTEGER::IA(8)
      REAL::C(13),D(9999),E(9999),G(99),SY(12,48)
      CHARACTER::KX(23)*4,KI(23)*80,KM(12)*3,KF*80,KR*80,KS*80,KT*80
      INTEGER,ALLOCATABLE,DIMENSION(:)::IC,IH,IK,IL,IP,IQ,IX,IY,IZ
      REAL,ALLOCATABLE,DIMENSION(:)::FF,FA,FB,FC,FD,FE,FG,SA,SF,EP,EO,
     +SQ,SL
      DATA KM/'Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep',
     +'Oct','Nov','Dec'/
      DATA KX/'NAT ','SAD ','SIR ','SIRA','LREM','HREM','PEAK','INFL',
     +'CELL','SPAG','FIND','SFAC','MIND','NTRY','SHEL','MAXM','RIP ',
     +'RIPA','RIPW','DSUL','ESEL','DSCA','SMAD'/
C
   1  FORMAT(/2X,72('+')/2X,'+  SHELXC - Create input files for ',
     +'SHELXD and SHELXE - Version 2006/3  +'/2X,'+  Copyright (C) ',
     +'George M. Sheldrick 2003-6',28X,'+'/2X,'+  ',A31,' Started at ',
     +A2,':',A2,':',A2,' on ',A2,1X,A3,1X,A4,'  +'/2X,72('+'))
   2  FORMAT(/' SHELXC reads a filename stem (denoted here by ''xx'')',
     +' on the command line'/' plus some instructions from ''standard',
     +' input''. It writes some statistics to'/' ''standard output''',
     +' and prepares the three files needed to run SHELXD and'/
     +' SHELXE. SHELXC can be called from a GUI by a command',
     +' line such as:'//' shelxc xx <t'//' which would read the',
     +' instructions from the file t, or (under most UNIX'/
     +' systems) by a simple shell script that includes the',
     +' instructions, e.g.'//' shelxc xx <<EOF'/' CELL 49.70 57.90',
     +' 74.17 90 90 90'/' SPAG P212121'/' SAD elastase.sca'/' FIND 12'/
     +' <<EOF'/' shelxd xx_fa'/' shelxe xx xx_fa -s0.37 -m20 -h -b'/
     +' shelxe xx xx_fa -s0.37 -m20 -h -b -i'//' which would also',
     +' run shelxd to locate the sulfur atoms and shelxe (for'/
     +' both substructure enantiomers) to solve elastase by',
     +' sulfur-SAD phasing.'//' This script would read data from',
     +' the .sca file and write the files xx.hkl'/' (h,k,l,I,sig(I)',
     +' in SHELX HKLF4 format for density modification by SHELXE)'/
     +' xx_fa.ins (cell, symmetry etc. for heavy atoms location by',
     +' SHELXD) and')
   3  FORMAT(' xx_fa.hkl (h,k,l,FA,sig(FA),alpha for both',
     +' SHELXD and SHELXE). The starting'/' phases for density',
     +' modification are estimated as (alpha + heavy-atom phase)'/
     +' in the simplified approach used by SHELXE.'//' For SIR or',
     +' SIRAS, two input reflections files are specified by the',
     +' keywords'/' NAT and SIR or SIRA; for MAD at least two of the',
     +' reflection files HREM,'/' LREM, PEAK and INFL are required',
     +' and NAT may also be given if higher'/' resolution native',
     +' data are available (e.g. SMet for SeMet MAD). Reflection'/
     +' data should be in SHELX .hkl or SCALEPACK .sca format; many',
     +' other programs,'/' including SCALA and XPREP, can output',
     +' .sca format too. The keywords CELL,'/' SPAG (space group)',
     +' SPAG (space group) and FIND (number of heavy atoms) are'/
     +' always required, SFAC, MIND, NTRY, SHEL, ESEL and DSUL may',
     +' be given and will'/' be written to the file xx_fa.ins for',
     +' SHELXD. MAXM can be used to reserve'/' memory in units of 1M',
     +' reflections. For RIP phasing, NAT (or BEFORE) denotes'/
     +' the file before radiation damage and RIP (or AFTER) the data',
     +' after radiation')
   4  FORMAT(' damage. For RIPAS the ''after'' file must',
     +' be called ''RIPA'' and a keyword RIPW'/' (default 0.6)',
     +' gives the weight w to be assigned to the ''NAT'' data in the'/
     +' estimation of the anomalous signal (a weight of 1-w is',
     +' applied to the ''RIPA'''/' data). Finally DSCA (default',
     +' 0.98) gives the factor to multiply the native'/
     +' data for SIR and SIRAS or the ''after'' data for RIP after',
     +' the data have been'/' put on the same scale (this allows for',
     +' the extra scattering power of the'/' heavy atoms etc.);',
     +' this can be critical for RIP phasing.'/)
   5  FORMAT(1X,78('='))
C
C Output header and read command line
C
      CALL DATE_AND_TIME(KT,KR,KS,IA)
      LF=2
      NN=0
      WD=0.6
      WI=0.98
      NZ=0
      NG=0
      DM=1.
        DO 6 I=1,23
        KI(I)=' '
   6    CONTINUE
      KF=' '
      I=IARGC()
      CALL GETARG(I,KF)
      IF(I.LT.1)KF=' '
      WRITE(*,1)KF(1:31),KR(1:2),KR(3:4),KR(5:6),KT(7:8),KM(IA(2)),
     +KT(1:4)
      WRITE(*,2)
      WRITE(*,3)
      WRITE(*,4)
      LN=INDEX(KF,' ')-1
      IF(LN.GT.0)GOTO 8
   7  CALL EXIT(0)
      STOP' '
   8  WRITE(*,5)
      KT=' '
C
C Read and store instructions
C
   9  READ(*,'(A)',ERR=17,END=17)KR
      IF(KR(1:1).EQ.'#')GOTO 9
      L=INDEX(KR,'!')
      IF(L.GT.0)KR(L:80)=' '
      L=INDEX(KR,' ')
      IF(L.LT.2)GOTO 9
        DO 10 I=1,L-1
        IF(KR(I:I).GE.'a'.AND.KR(I:I).LE.'z')KR(I:I)=
     +  CHAR(ICHAR(KR(I:I))-32)
  10    CONTINUE
      IF(KR(1:3).EQ.'REM')GOTO 9
      IF(KR(1:5).EQ.'SIRAS')KR(5:5)=' '
      IF(KR(1:3).NE.'BEF')GOTO 11
      KR(1:L)=' '
      KR(1:3)='NAT'
  11  IF(KR(1:3).NE.'AFT')GOTO 12
      KR(1:L)=' '
      KR(1:3)='RIP'
  12    DO 15 I=1,23
        IF(KR(1:4).NE.KX(I))GOTO 15
        IF(KI(I).EQ.KT)GOTO 13
        WRITE(*,'(/A/)')' ** Repeated '//KR(1:4)//' instruction **'
        GOTO 7
  13    KI(I)(5:80)=KR(5:80)
        IF(I.LT.9)NN=IBSET(NN,I-1)
        IF(I.EQ.17)NZ=1
        IF(I.EQ.18)NZ=-1
        IF(I.NE.19)GOTO 14
        READ(KR(5:80),*,ERR=16,END=16)WD
        IF(WD.LT.-0.0001.OR.WD.GT.1.0001)GOTO 16
        GOTO 9
  14    IF(I.EQ.23)DM=0.
        IF(I.NE.22)GOTO 9
        READ(KR(5:80),*,ERR=16,END=16)WI
        IF(WI.LT.0.01.OR.WI.GT.100.)GOTO 16
        GOTO 9
  15    CONTINUE
  16  WRITE(*,'(/A/)')' ** Bad or missing '//KR(1:4)//' instruction **'
      GOTO 7
  17  IF(NZ.EQ.0)GOTO 18
      IF(NN.EQ.1)GOTO 20
      GOTO 19
  18  IF(NN.EQ.2.OR.NN.EQ.3.OR.NN.EQ.5.OR.NN.EQ.9)GOTO 20
      IF(NN.LT.80)GOTO 19
      IF(NN/2.EQ.64)GOTO 19
      IF(MOD(NN/2,8).EQ.0)GOTO 20
  19  WRITE(*,'(/A/)')' ** Forbidden input data combination **'
      GOTO 7
C
C Allocate dynamic memory
C
  20  LD=0
      READ(KI(16),*,ERR=21,END=21)LD
  21  IF(LD.LT.1)LD=2
      LD=1000000*LD
      ALLOCATE(IC(LD),IH(LD),IK(LD),IL(LD),IP(LD),IQ(LD),FF(LD),FA(LD),
     +FB(LD),FC(LD),FD(LD),FE(LD),FG(LD),SA(LD),SF(LD),EP(LD),EO(LD),
     +SQ(LD),STAT=I)
      IF(I.EQ.0)GOTO 25
  22  WRITE(*,'(/A/)')' ** Not enough memory to store reflections -'
     +//' increase MAXM or buy more RAM **'
      GOTO 7
  23  WRITE(*,'(/A/)')' ** Cannot open file '//KR(1:NL)//' **'
      GOTO 7
  24  WRITE(*,'(/A,I8,A/1X,A/)')' ** Input file '//KR(1:NL)//
     +' corrupted at line',NI,' **',KT(1:78)
      GOTO 7
C
C Derive coefficients for calculating 1/d**2, get symops
C
  25  KR='CELL'
      READ(KI(9),*,ERR=26,END=26)WL,(C(I),I=1,6)
      GOTO 27
  26  WL=-1.
      READ(KI(9),*,ERR=16,END=16)(C(I),I=1,6)
  27    DO 28 K=1,3
        IF(C(K).LT.0.1)GOTO 16
        IF(C(K+3).LT.10.)GOTO 16
        X=1.74533E-2*C(K+3)
        D(K)=COS(X)
        D(K+3)=SIN(X)
  28    CONTINUE
      V=1./(1.-D(1)**2-D(2)**2-D(3)**2+2.*D(1)*D(2)*D(3))
      C(7)=V*(D(4)/C(1))**2
      C(8)=V*(D(5)/C(2))**2
      C(9)=V*(D(6)/C(3))**2
      C(10)=2.*V*(D(2)*D(3)-D(1))/(C(2)*C(3))
      C(11)=2.*V*(D(1)*D(3)-D(2))/(C(1)*C(3))
      C(12)=2.*V*(D(1)*D(2)-D(3))/(C(1)*C(2))
      C(13)=C(1)*C(2)*C(3)/V
      KR=KI(10)
      CALL SPAGSY(KR,NS,LT,SY,C)
      KR='SPAG'
      IF(LT.EQ.0)GOTO 16
      IF(WL.GT.0.1)GOTO 29
      WL=0.98
      IF(INDEX(KI(12),'BR').NE.0)WL=0.92
C
C Set up local scaling offsets
C
  29  R=200./C(13)
      IF(LT.LT.-4.OR.LT.EQ.-2)R=2.*R
      IF(LT.EQ.-3)R=3.*R
      IF(LT.EQ.-4)R=4.*R
      R=R**0.3333333
      MH=NINT(C(1)*R)
      MK=NINT(C(2)*R)
      ML=NINT(C(3)*R)
      R=R**2
      JX=0
      JY=0
      JZ=0
        DO 34 ND=1,2
        NX=0
          DO 33 L=0,ML
          W=REAL(L)
            DO 32 K=-MK,MK
            V=REAL(K)
              DO 31 J=-MH,MH
              IF(L.GT.0)GOTO 30
              IF(K.LT.0)GOTO 31
              IF(K.GT.0)GOTO 30
              IF(J.LE.0)GOTO 31
  30          IF(LT.EQ.-2.AND.MOD(J+K+L,2).NE.0)GOTO 31
              IF(LT.EQ.-3.AND.MOD(K+L-J,3).NE.0)GOTO 31
              IF(LT.EQ.-4.AND.MOD(J+K,2).NE.0)GOTO 31
              IF(LT.EQ.-4.AND.MOD(J+L,2).NE.0)GOTO 31
              IF(LT.EQ.-5.AND.MOD(K+L,2).NE.0)GOTO 31
              IF(LT.EQ.-6.AND.MOD(J+L,2).NE.0)GOTO 31
              IF(LT.EQ.-7.AND.MOD(J+K,2).NE.0)GOTO 31
              U=REAL(J)
              IF(C(7)*U**2+C(8)*v**2+C(9)*W**2+C(10)*V*W+
     +        C(11)*U*W+C(12)*U*V.GT.R)GOTO 31
              NX=NX+1
              IF(ND.EQ.1)GOTO 31
              IX(NX)=J
              IY(NX)=K
              IZ(NX)=L
              JX=MAX0(JX,IABS(J))
              JY=MAX0(JY,IABS(K))
              JZ=MAX0(JZ,L)
  31          CONTINUE
  32        CONTINUE
  33      CONTINUE
        IF(ND.EQ.1)ALLOCATE(IX(NX),IY(NX),IZ(NX),STAT=I)
        IF(I.NE.0)GOTO 36
  34    CONTINUE
      GOTO 37
  35  FORMAT(/' ** Not enough available memory for local scaling **')
  36  WRITE(*,35)
      GOTO 7
  37  NR=0
      RT=99.
C
C Set up RIP and RIPAS
C
      IF(NN.EQ.5.OR.NN.EQ.9)WI=1./WI
      IF(NZ.LE.0)GOTO 38
      KI(3)=KI(17)
      NN=5
  38  IF(NZ.GE.0)GOTO 39
      KI(6)=KI(1)
      KI(8)=KI(18)
      NN=161
C
C Open reflection data file
C
  39    DO 200 ND=1,9
        IF(ND.EQ.9)GOTO 154
        IF(.NOT.BTEST(NN,ND-1))GOTO 200
        NF=4
        I=INDEX(KI(ND),' -f ')
        IF(I.EQ.0)I=INDEX(KI(ND),' -F ')
        IF(I.EQ.0)GOTO 40
        NF=3
        KI(ND)(I+1:I+2)='  '
  40    NB=NR
        NI=0
        NL=0
        NK=0
        KR=' '
          DO 41 I=5,80
          IF(KI(ND)(I:I).LE.' ')GOTO 41
          NL=NL+1
          KR(NL:NL)=KI(ND)(I:I)
          IF(KR(NL:NL).EQ.'/')NK=0
          IF(KR(NL:NL).EQ.'.')NK=NL
  41      CONTINUE
        IF(NL.EQ.0)GOTO 23
        IF(NK.NE.0)GOTO 42
        NK=NL+1
        NL=NL+4
        KR(NK:NL)='.hkl'
  42    IF(KR(NK:NL).EQ.'.hkl')GOTO 43
        IF(NF.EQ.3)GOTO 23
        NF=5
        IF(KR(NK:NL).NE.'.sca')GOTO 23
  43    OPEN(LF,FILE=KR(1:NL),STATUS='OLD',ACTION='READ',ERR=23)
        IF(NF.NE.5)GOTO 46
        NI=1
        KT=' '
        READ(LF,'(A)',ERR=24,END=24)KT
        READ(KT,*,ERR=24,END=24)J
        NI=2
        KT=' '
        READ(LF,'(A)',ERR=24,END=24)KT
        READ(KT,*,ERR=44,END=44)I,K
        NF=6
  44    J=2*J-1
        IF(NF.EQ.5)J=1
          DO 45 I=1,J
          NI=NI+1
          KT=' '
          READ(LF,'(A)',ERR=24,END=24)KT
  45      CONTINUE
C
C Read and store reflections
C
  46    KT=' '
        READ(LF,'(A)',ERR=49,END=49)KT
        NI=NI+1
        IF(INDEX(KT,'*').NE.0)GOTO 24
        I=NR+1
        IF(I.GE.LD)GOTO 22
        IF(NF.GT.4)GOTO 47
        READ(KT,'(3I4,2F8.2)',ERR=46,END=46)IH(I),IK(I),IL(I),
     +  FF(I),SA(I)
        IF(IABS(IH(I))+IABS(IK(I))+IABS(IL(I)).EQ.0)GOTO 49
        IF(SA(I).LT.0.01)GOTO 46
        NR=I
        IF(NF.EQ.4)GOTO 46
        T=FF(I)
        SA(I)=AMAX1(0.01,ABS(2.*T*SA(I)))
        T=AMAX1(0.,T)**2
        FF(I)=T
        GOTO 46
  47    READ(KT,'(3I4)',ERR=46,END=46)IH(I),IK(I),IL(I)
        IF(NF.EQ.6)GOTO 48
        KS=KT(13:20)//'00'
        IF(INDEX(KS,'.').EQ.0)KS(9:9)='.'
        READ(KS,*,ERR=24,END=24)FF(I)
        KS=KT(21:28)//'00'
        IF(INDEX(KS,'.').EQ.0)KS(9:9)='.'
        READ(KS,*,ERR=24,END=24)SA(I)
        KS=KT(29:36)//'00'
        IF(INDEX(KS,'.').EQ.0)KS(9:9)='.'
        READ(KS,*,ERR=24,END=24)P
        KS=KT(37:44)//'00'
        IF(INDEX(KS,'.').EQ.0)KS(9:9)='.'
        READ(KS,*,ERR=24,END=24)Q
        IF(SA(I).GT.AMAX1(0.05*Q,0.0001))NR=I
        IF(Q.LE.AMAX1(0.05*SA(I),0.0001))GOTO 46
        NR=NR+1
        IH(NR)=-IH(I)
        IK(NR)=-IK(I)
        IL(NR)=-IL(I)
        FF(NR)=P
        SA(NR)=Q
        GOTO 46
  48    KS=KT(38:45)//'00'
        IF(INDEX(KS,'.').EQ.0)KS(9:9)='.'
        READ(KS,*,ERR=24,END=24)FF(I)
        KS=KT(46:53)//'00'
        IF(INDEX(KS,'.').EQ.0)KS(9:9)='.'
        READ(KS,*,ERR=24,END=24)SA(I)
        IF(SA(I).GT.0.0001)NR=I
        GOTO 46
  49    CLOSE(LF)
        L=4
        IF(KX(ND)(4:4).EQ.' ')L=3
        J=ND
        IF(NZ.GT.0.AND.ND.EQ.3)J=17
        IF(NZ.LT.0.AND.ND.EQ.8)J=18
        IF(NZ.GE.0.OR.ND.NE.6)WRITE(*,'(/I9,A)')NR-NB,
     +  ' Reflections read from '//KX(J)(1:L)//' file '//KR(1:NL)
C
C Check for lattice absences
C
        SM=0.
          DO 57 I=NB+1,NR
          IP(I)=I-NB
          MH=IH(I)
          MK=IK(I)
          ML=IL(I)
          IF(LT.EQ.-2.AND.MOD(MH+MK+ML,2).NE.0)GOTO 56
          IF(LT.EQ.-3.AND.MOD(MK+ML-MH,3).NE.0)GOTO 56
          IF(LT.EQ.-4.AND.MOD(MH+MK,2).NE.0)GOTO 56
          IF(LT.EQ.-4.AND.MOD(MH+ML,2).NE.0)GOTO 56
          IF(LT.EQ.-5.AND.MOD(MK+ML,2).NE.0)GOTO 56
          IF(LT.EQ.-6.AND.MOD(MH+ML,2).NE.0)GOTO 56
          IF(LT.EQ.-7.AND.MOD(MH+MK,2).NE.0)GOTO 56
C
C Convert to standard reflection indices
C
          MT=1
          U=REAL(MH)
          V=REAL(MK)
          W=REAL(ML)
            DO 53 M=1,NS
            J=NINT(U*SY(1,M)+V*SY(4,M)+W*SY(7,M))
            K=NINT(U*SY(2,M)+V*SY(5,M)+W*SY(8,M))
            L=NINT(U*SY(3,M)+V*SY(6,M)+W*SY(9,M))
            NT=1
            IF(L.GT.0)GOTO 51
            IF(L.LT.0)GOTO 50
            IF(K.GT.0)GOTO 51
            IF(K.LT.0)GOTO 50
            IF(J.GE.0)GOTO 51
  50        J=-J
            K=-K
            L=-L
            NT=-1
  51        IF(L.LT.ML)GOTO 53
            IF(L.GT.ML)GOTO 52
            IF(K.LT.MK)GOTO 53
            IF(K.GT.MK)GOTO 52
            IF(J.LT.MH)GOTO 53
            IF(J.GT.MH)GOTO 52
            IF(NT.LT.0)GOTO 53
  52        MH=J
            MK=K
            ML=L
            MT=NT
  53        CONTINUE
          IH(I)=MH
          IK(I)=MK
          IL(I)=ML
          IC(I)=MT
C
C Check for centrics and systematic absences
C
          MT=1
          U=REAL(MH)
          V=REAL(MK)
          W=REAL(ML)
          T=1.
            DO 55 M=2,NS
            J=NINT(U*SY(1,M)+V*SY(4,M)+W*SY(7,M))
            K=NINT(U*SY(2,M)+V*SY(5,M)+W*SY(8,M))
            L=NINT(U*SY(3,M)+V*SY(6,M)+W*SY(9,M))
            IF(J.NE.MH)GOTO 54
            IF(K.NE.MK)GOTO 54
            IF(L.NE.ML)GOTO 54
            T=T+1.
            IF(MOD(12000+NINT(12.*(U*SY(10,M)+V*SY(11,M)+W*SY(12,M))),
     +      12).NE.0)GOTO 56
  54        IF(J.NE.-MH)GOTO 55
            IF(K.NE.-MK)GOTO 55
            IF(L.EQ.-ML)IC(I)=0
  55        CONTINUE
          SQ(I)=C(7)*U**2+C(8)*V**2+C(9)*W**2+C(10)*V*W+
     +    C(11)*U*W+C(12)*U*V
          SM=AMAX1(SM,SQ(I))
          EP(I)=SQRT(T)
          GOTO 57
  56      IC(I)=99
  57      CONTINUE
C
C Sort reflection pointers into standard order
C
        I=NB+1
        N=NR-NB
        CALL INSORT(N,IP(I),IQ(I),IH(I))
        CALL INSORT(N,IQ(I),IP(I),IK(I))
        CALL INSORT(N,IP(I),IQ(I),IL(I))
C
C Define resolution ranges for tables
C
        G(11)=0.01*ANINT(100./SQRT(AMAX1(SM,0.063)))
        Q=0.1*ANINT(10.*G(11))+0.2
          DO 58 I=10,1,-1
          G(I)=Q
          Q=Q+0.2
  58      CONTINUE
        G(1)=8.
          DO 59 I=2,4
          G(I)=AMAX1(G(I),8.-REAL(I))
  59      CONTINUE
          DO 60 I=5,10
          Q=0.5*Q+0.5
          G(I)=AMAX1(G(I),6.-0.5*REAL(I))
  60      CONTINUE
          DO 61 I=12,99
          G(I)=0.
  61      CONTINUE
C
C Merge equivalents
C
        N=NR
        I=NB+1
  62    J=IQ(I)+NB
        NK=I
  63    I=I+1
        IF(I.GT.NR)GOTO 64
        L=IQ(I)+NB
        IF(IH(J).NE.IH(L))GOTO 64
        IF(IK(J).NE.IK(L))GOTO 64
        IF(IL(J).NE.IL(L))GOTO 64
        GOTO 63
  64    IF(IC(J).EQ.99)GOTO 84
        IF(N.GE.LD)GOTO 22
        N=N+1
        IH(N)=IH(J)
        IK(N)=IK(J)
        IL(N)=IL(J)
        SQ(N)=SQ(J)
        EO(N)=ABS(EP(J))
        IF(IC(J).EQ.0)EO(N)=EO(N)*SQRT(2.)
        FF(N)=0.
        SF(N)=0.
C
C Save individual I+ and I- values and sum 1/sigma^2
C
        MH=0
        MK=0
        S=0.
        T=0.
        U=0.
        V=0.
        MX=IQ(NK)+NB
          DO 66 J=NK,I-1
          MX=IQ(J)+NB
          W=1./SA(MX)**2
          IF(IC(MX).LT.0)GOTO 65
          MH=MIN0(MH+1,9999)
          D(MH)=FF(MX)
          U=U+FF(MX)
          S=S+W
          GOTO 66
  65      MK=MIN0(MK+1,9999)
          E(MK)=FF(MX)
          V=V+FF(MX)
          T=T+W
  66      CONTINUE
        R=0.
        IF(MH+MK.GT.0)R=1./(S+T)
        IF(MH.GT.0)S=1./S
        IF(MK.GT.0)T=1./T
C
C Prepare anomalous CC between subsets
C
        FC(N)=-9.E9
        FD(N)=-9.E9
        FE(N)=-9.E9
        FG(N)=-9.E9
        U=U/REAL(MAX0(MH,1))
        P=0.
        IF(MH.GT.0)P=1.
        V=V/REAL(MAX0(MK,1))
        Q=0.
        IF(MK.GT.0)Q=1.
        IF(MH.LT.2.OR.MK.LT.2)GOTO 75
        W=0.
        X=0.
          DO 67 J=1,MH,4
          X=X+D(J)
          W=W+1.
  67      CONTINUE
          DO 68 J=4,MH,4
          X=X+D(J)
          W=W+1.
  68      CONTINUE
        FC(N)=X/W
        W=0.
        Y=0.
          DO 69 J=2,MH,4
          Y=Y+D(J)
          W=W+1.
  69      CONTINUE
          DO 70 J=3,MH,4
          Y=Y+D(J)
          W=W+1.
  70      CONTINUE
        FE(N)=Y/W
        W=0.
        Z=0.
          DO 71 J=1,MK,4
          Z=Z+E(J)
          W=W+1.
  71      CONTINUE
          DO 72 J=4,MK,4
          Z=Z+E(J)
          W=W+1.
  72      CONTINUE
        FD(N)=Z/W
        W=0.
        Z=0.
          DO 73 J=2,MK,4
          Z=Z+E(J)
          W=W+1.
  73      CONTINUE
          DO 74 J=3,MK,4
          Z=Z+E(J)
          W=W+1.
  74      CONTINUE
        FG(N)=Z/W
C
C Internal agreement tests
C
  75    W=0.
        J=0
        M=0
        IF(MH.LT.2)GOTO 77
        J=MH
        M=1
          DO 76 L=1,MH
          W=W+(D(L)-U)**2
  76      CONTINUE
  77    IF(MK.LT.2)GOTO 79
        J=J+MK
        M=M+1
          DO 78 L=1,MK
          W=W+(E(L)-V)**2
  78      CONTINUE
  79    IF(J.LE.M)GOTO 82
        W=W/(REAL(J)*REAL(J-M))
        IF(MH.GT.0)S=AMAX1(S,W)
        IF(MK.GT.0)T=AMAX1(T,W)
        Z=SQRT(1./SQ(N))
          DO 80 K=1,10
          IF(Z.GT.G(K))GOTO 81
  80      CONTINUE
        K=11
  81    G(K+77)=G(K+77)+W
        G(K+88)=G(K+88)+R
C
C Combine I+ and I- and check suitability for use as delta(anom)
C
  82    FF(N)=(U+V)/(P+Q)
        SF(N)=SQRT(R)
        IF(IC(MX).EQ.0)GOTO 83
        IF(ND.EQ.3.OR.MH.EQ.0.OR.MK.EQ.0)GOTO 83
        IF(S.GT.6.25*T.OR.T.GT.6.25*S)GOTO 83
        FA(N)=SQRT(AMAX1(U,0.))
        FB(N)=SQRT(AMAX1(V,0.))
        EP(N)=EP(MX)
C
C Calculate esd of anomalous difference and apply further test
C
        SA(N)=SQRT((SQRT(FA(N)**2+SQRT(S))-FA(N))**2+
     +  (SQRT(FB(N)**2+SQRT(T))-FB(N))**2)
        IF(AMIN1(FA(N),FB(N)).GT.4.*SA(N))GOTO 84
  83    FA(N)=0.
        FB(N)=0.
        SA(N)=-999.
        EP(N)=-EP(MX)
  84    IF(I.LE.NR)GOTO 62
C
C Update reflection list overwriting old list
C
        NT=NR+1
        NR=NB
          DO 85 I=NT,N
          NR=NR+1
          IH(NR)=IH(I)
          IK(NR)=IK(I)
          IL(NR)=IL(I)
          FF(NR)=FF(I)
          FA(NR)=FA(I)
          FB(NR)=FB(I)
          SA(NR)=SA(I)
          SF(NR)=SF(I)
          EP(NR)=EP(I)
          EO(NR)=EO(I)
          FC(NR)=FC(I)
          FD(NR)=FD(I)
          FE(NR)=FE(I)
          FG(NR)=FG(I)
          IP(NR)=NR
          IC(NR)=ND
          SQ(NR)=SQ(I)
  85      CONTINUE
        NT=NB+1
C
C Set up local scaling table for Friedel ratios
C
        MH=0
        MK=0
        ML=0
          DO 87 I=NT,NR
          U=REAL(IH(I))
          V=REAL(IK(I))
          W=REAL(IL(I))
            DO 86 M=1,NS
            MH=MAX0(MH,IABS(NINT(U*SY(1,M)+V*SY(4,M)+W*SY(7,M))))
            MK=MAX0(MK,IABS(NINT(U*SY(2,M)+V*SY(5,M)+W*SY(8,M))))
            ML=MAX0(ML,IABS(NINT(U*SY(3,M)+V*SY(6,M)+W*SY(9,M))))
  86        CONTINUE
  87      CONTINUE
        MH=MH+JX
        NK=2*MH+1
        MK=MK+JY
        NL=(2*MK+1)*NK
        ML=ML+JZ
        M=ML*NL+MK*NK+MH
        ALLOCATE(SL(M),STAT=I)
        IF(I.NE.0)GOTO 36
          DO 88 I=1,M
          SL(I)=-1.
  88      CONTINUE
          DO 90 I=NT,NR
          IF(SA(I).LT.0.)GOTO 90
          IF(FA(I).LT.0.8*FB(I).OR.FB(I).LT.0.8*FA(I))GOTO 90
          T=SQRT(SQRT(FA(I)/FB(I)))
          U=REAL(IH(I))
          V=REAL(IK(I))
          W=REAL(IL(I))
            DO 89 N=1,NS
            J=NINT(U*SY(1,N)+V*SY(4,N)+W*SY(7,N))+NK*NINT(U*SY(2,N)+
     +      V*SY(5,N)+W*SY(8,N))+NL*NINT(U*SY(3,N)+V*SY(6,N)+W*SY(9,N))
            IF(J.GT.0)SL(J)=T
            IF(J.LT.0)SL(-J)=1./T
  89        CONTINUE
  90      CONTINUE
C
C Apply local scaling to Friedel pairs
C
        N=0
          DO 94 I=NT,NR
          IF(SA(I).LT.0.)GOTO 94
          P=0.1
          T=0.1
            DO 93 K=1,NX
            M=IH(I)+IX(K)+(IK(I)+IY(K))*NK+(IL(I)+IZ(K))*NL
            IF(M.LE.0)GOTO 91
            IF(SL(M).LE.0.)GOTO 93
            T=T+SL(M)
            GOTO 92
  91        IF(M.EQ.0)GOTO 93
            M=-M
            IF(SL(M).LE.0.)GOTO 93
            T=T+1./SL(M)
  92        P=P+1.
  93        CONTINUE
          N=N+NINT(P)
          S=1.
          IF(P.GT.9.5)S=(T/P)**2
          FA(I)=FA(I)/S
          FB(I)=FB(I)*S
          IF(FC(I).LT.-8.E9)GOTO 94
          U=FC(I)/S-FG(I)*S
          V=FE(I)/S-FD(I)*S
          FG(I)=FE(I)/S-FG(I)*S
          FD(I)=FC(I)/S-FD(I)*S
          FC(I)=U
          FE(I)=V
  94      CONTINUE
C
C Sum for internal anomalous correlation coefficient
C
          DO 97 I=NT,NR
          IF(SA(I).LT.0.0.OR.FC(I).LT.-8.E9)GOTO 97
          X=FG(I)
          Y=FD(I)
          U=FC(I)
          V=FE(I)
          W=1./(SF(I)**2+(0.05*AMAX1(FF(I),0.))**2)
          Z=SQRT(1./SQ(I))
            DO 95 K=1,10
            IF(Z.GT.G(K))GOTO 96
  95        CONTINUE
          K=11
  96      G(K+11)=G(K+11)+2.*W
          G(K+22)=G(K+22)+W*(X+U)
          G(K+33)=G(K+33)+W*(Y+V)
          G(K+44)=G(K+44)+W*(X**2+U**2)
          G(K+55)=G(K+55)+W*(Y**2+V**2)
          G(K+66)=G(K+66)+W*(X*Y+U*V)
  97      CONTINUE
        DEALLOCATE(SL)
        S=1./SQRT(SM)
        IF(ND.EQ.7)RT=999.
        IF(ND.GT.1)RT=AMIN1(RT,S)
        IF(NZ.LT.0.AND.ND.EQ.6)GOTO 98
        WRITE(*,'(I9,A,F7.3,A)')NR-NB,
     +  ' Unique reflections, highest resolution',S,' Angstroms'
        IF(ND.EQ.2)WRITE(*,'(F9.1,A)')REAL(N)/REAL(NR-NB),
     +  ' Friedel pairs used on average for local scaling'
C
C Calculate and normalize F+-F-
C
  98    IF(ND.EQ.3)GOTO 100
          DO 99 I=NT,NR
          IF(EP(I).LT.0.)GOTO 99
          FA(I)=FA(I)-FB(I)
  99      CONTINUE
        CALL ENORM(NR-NB,FA(NT),SQ(NT),EP(NT),FB(NT),SA(NT))
 100      DO 101 I=1,55
          D(I)=0.
 101      CONTINUE
C
C Theoretical number of unique data in each shell
C
        M=IABS(LT)
        P=1./SQRT(SM)
        MX=NINT(C(1)/G(11)+.5)
        MY=NINT(C(2)/G(11)+.5)
        MZ=NINT(C(3)/G(11)+.5)
        ML=-1
 102    ML=ML+1
        IF(ML.GT.MZ)GOTO 110
        W=REAL(ML)
        MK=-1-MY
        IF(ML.EQ.0)MK=-1
 103    MK=MK+1
        IF(MK.GT.MY)GOTO 102
        V=REAL(MK)
        MT=IABS(MK)+IABS(ML)
        MH=-1-MX
        IF(MT.EQ.0)MH=0
 104    MH=MH+1
        IF(MH.GT.MX)GOTO 103
        IF(IABS(MH)+MT.EQ.0)GOTO 104
        U=REAL(MH)
          DO 107 N=2,NS
          I=NINT(U*SY(1,N)+V*SY(4,N)+W*SY(7,N))
          J=NINT(U*SY(2,N)+V*SY(5,N)+W*SY(8,N))
          K=NINT(U*SY(3,N)+V*SY(6,N)+W*SY(9,N))
          IF(M.EQ.2.AND.MOD(I+J+K,2).NE.0)GOTO 104
          IF(M.EQ.3.AND.MOD(J+K-I,3).NE.0)GOTO 104
          IF((M.EQ.4.OR.M.EQ.5).AND.MOD(J+K,2).NE.0)GOTO 104
          IF((M.EQ.4.OR.M.EQ.6).AND.MOD(I+K,2).NE.0)GOTO 104
          IF(M.EQ.7.AND.MOD(I+J,2).NE.0)GOTO 104
          IF(K.GT.0)GOTO 106
          IF(K.LT.0)GOTO 105
          IF(J.GT.0)GOTO 106
          IF(J.LT.0)GOTO 105
          IF(I.GE.0)GOTO 106
 105      I=-I
          J=-J
          K=-K
 106      IF(K.GT.ML)GOTO 104
          IF(K.LT.ML)GOTO 107
          IF(J.GT.MK)GOTO 104
          IF(J.LT.MK)GOTO 107
          IF(I.GT.MH)GOTO 104
 107      CONTINUE
        T=1./SQRT(C(7)*U**2+C(8)*V**2+C(9)*W**2+C(10)*V*W+C(11)*U*W+
     +  C(12)*U*V)
          DO 108 J=1,10
          IF(T.GE.G(J))GOTO 109
 108      CONTINUE
        IF(T.LT.P)GOTO 104
        J=11
 109    D(J+44)=D(J+44)+1.
        GOTO 104
C
C Data statistics
C
 110      DO 113 I=NT,NR
          FA(I)=0.
          T=SQRT(1./SQ(I))
            DO 111 J=1,10
            IF(T.GT.G(J))GOTO 112
 111        CONTINUE
          J=11
 112      D(J)=D(J)+1.
          D(J+11)=D(J+11)+FF(I)/SF(I)
          IF(EP(I).LT.0.)GOTO 113
          D(J+22)=D(J+22)+1.
          D(J+33)=D(J+33)+ABS(FB(I)/SA(I))
 113      CONTINUE
        IF(ND.EQ.6.AND.NZ.LT.0)GOTO 115
        WRITE(*,'(/A,10(A,F4.1),A,F5.2,A)')' Resl.   Inf',
     +  (' -',G(I),I=1,11)
        WRITE(*,'(A,11I6)')' N(data)  ',(NINT(D(I)),I=1,11)
        KT=' Chi-sq '
        J=0
          DO 114 I=78,88
          IF(G(I+11).LT.1.E-6)GOTO 114
          J=J+1
          WRITE(KT(6*I-457:6*I-452),'(F6.2)')G(I)/G(I+11)
 114      CONTINUE
        IF(J.GT.3)WRITE(*,'(A)')KT(1:76)
        WRITE(*,'(A,11F6.1)')' <I/sig>  ',
     +  (D(I+11)/AMAX1(D(I),1.),I=1,11)
        WRITE(*,'(A,11F6.1)')' %Complete',
     +  (100.*D(I)/AMAX1(D(I+44),1.),I=1,11)
        IF(ND.EQ.3)GOTO 119
 115    KT=' <d"/sig> '
        J=0
          DO 116 I=23,33
          IF(D(I).LT.0.5)GOTO 116
          J=J+1
          WRITE(KT(6*I-127:6*I-122),'(F6.2)')D(I+11)/D(I)
 116      CONTINUE
        IF(J.GT.3)WRITE(*,'(A)')KT(1:76)
        KT=' CC(anom) '
        J=0
          DO 117 I=12,22
          IF(G(I).LE.0.)GOTO 117
          T=(G(I)*G(I+33)-G(I+11)**2)*(G(I)*G(I+44)-G(I+22)**2)
          IF(T.LE.0.)GOTO 117
          J=J+1
          WRITE(KT(6*I-61:6*I-56),'(F6.1)')100.*(G(I)*G(I+55)-
     +    G(I+11)*G(I+22))/SQRT(T)
 117      CONTINUE
        IF(J.GT.3)WRITE(*,'(A)')KT(1:76)
        IF(ND.EQ.1)GOTO 196
        IF(ND.NE.6.OR.NZ.GE.0)GOTO 118
        WRITE(*,183)NR,KF(1:LN)//'.hkl'//' for input to SHELXE'
        WRITE(*,181)
 118    IF(ND.EQ.2)GOTO 184
C
C Scale derivative to native - first scale isotropically
C
        IF(NB.EQ.0)GOTO 199
 119      DO 120 I=1,5
          D(I)=0.
 120      CONTINUE
        M=1
        I=NB
 121    I=I+1
        IF(I.GT.NR)GOTO 125
 122    IF(IL(I).GT.IL(M))GOTO 124
        IF(IL(I).LT.IL(M))GOTO 121
        IF(IK(I).GT.IK(M))GOTO 124
        IF(IK(I).LT.IK(M))GOTO 121
        IF(IH(I).GT.IH(M))GOTO 124
        IF(IH(I).LT.IH(M))GOTO 121
        IF(FF(I).LT.3.*SF(I).OR.FF(M).LT.3.*SF(M))GOTO 123
        P=ALOG(FF(I)/FF(M))
        Q=SQ(I)
        D(1)=D(1)+P
        D(2)=D(2)+P*Q
        D(3)=D(3)+1.
        D(4)=D(4)+Q
        D(5)=D(5)+Q**2
 123    I=I+1
 124    M=M+1
        IF(M.LE.NG)GOTO 122
 125    T=D(3)*D(5)-D(4)**2
        P=(D(1)*D(5)-D(2)*D(4))/T
        Q=(D(2)*D(3)-D(1)*D(4))/T
          DO 126 I=NT,NR
          S=EXP(P+Q*SQ(I))
          FF(I)=FF(I)*S
          SF(I)=SF(I)*S
 126      CONTINUE
C
C Then set up local scaling table
C
        MH=0
        MK=0
        ML=0
          DO 128 I=NT,NR
          U=REAL(IH(I))
          V=REAL(IK(I))
          W=REAL(IL(I))
            DO 127 M=1,NS
            MH=MAX0(MH,IABS(NINT(U*SY(1,M)+V*SY(4,M)+W*SY(7,M))))
            MK=MAX0(MK,IABS(NINT(U*SY(2,M)+V*SY(5,M)+W*SY(8,M))))
            ML=MAX0(ML,IABS(NINT(U*SY(3,M)+V*SY(6,M)+W*SY(9,M))))
 127        CONTINUE
 128      CONTINUE
        MH=MH+JX
        NK=2*MH+1
        MK=MK+JY
        NL=(2*MK+1)*NK
        ML=ML+JZ
        M=ML*NL+MK*NK+MH
        ALLOCATE(SL(M),STAT=I)
        IF(I.NE.0)GOTO 36
          DO 129 I=1,M
          SL(I)=-1.
 129      CONTINUE
        M=1
        I=NB
 130    I=I+1
 131    IF(I.GT.NR)GOTO 135
        IF(IL(I).GT.IL(M))GOTO 134
        IF(IL(I).LT.IL(M))GOTO 130
        IF(IK(I).GT.IK(M))GOTO 134
        IF(IK(I).LT.IK(M))GOTO 130
        IF(IH(I).GT.IH(M))GOTO 134
        IF(IH(I).LT.IH(M))GOTO 130
        IF(FF(I).LT.3.*SF(I).OR.FF(M).LT.3.*SF(M))GOTO 133
        U=REAL(IH(I))
        V=REAL(IK(I))
        W=REAL(IL(I))
        T=SQRT(FF(M)/FF(I))
          DO 132 N=1,NS
          J=NINT(U*SY(1,N)+V*SY(4,N)+W*SY(7,N))+NK*NINT(U*SY(2,N)+
     +    V*SY(5,N)+W*SY(8,N))+NL*NINT(U*SY(3,N)+V*SY(6,N)+W*SY(9,N))
          IF(J.GT.0)SL(J)=T
          IF(J.LT.0)SL(-J)=T
 132      CONTINUE
 133    I=I+1
 134    M=M+1
        IF(M.LE.NG)GOTO 131
C
C Apply local scaling
C
 135      DO 139 I=NT,NR
          P=0.01
          T=0.01
            DO 138 K=1,NX
            M=IH(I)+IX(K)+(IK(I)+IY(K))*NK+(IL(I)+IZ(K))*NL
            IF(M.LE.0)GOTO 136
            IF(SL(M).LE.0.)GOTO 138
            GOTO 137
 136        IF(M.EQ.0)GOTO 138
            M=-M
            IF(SL(M).LE.0.)GOTO 138
 137        T=T+SL(M)
            P=P+1.
 138        CONTINUE
          S=(T/P)**2
          FF(I)=S*FF(I)
          SF(I)=S*SF(I)
 139      CONTINUE
        DEALLOCATE(SL)
C
C SIR, SIRAS and RIP analysis
C
        IF(ND.GT.4)GOTO 200
          DO 140 I=NT,NR
          FA(I)=0.
          EO(I)=-ABS(EO(I))
 140      CONTINUE
          DO 141 I=1,44
          D(I)=0.
 141      CONTINUE
        M=1
        I=NB
 142    I=I+1
        IF(I.GT.NR)GOTO 148
 143    IF(IL(I).GT.IL(M))GOTO 147
        IF(IL(I).LT.IL(M))GOTO 142
        IF(IK(I).GT.IK(M))GOTO 147
        IF(IK(I).LT.IK(M))GOTO 142
        IF(IH(I).GT.IH(M))GOTO 147
        IF(IH(I).LT.IH(M))GOTO 142
        V=SF(I)
        W=V*WI**2
        SF(I)=-999.
        IF(FF(I).LT.V.OR.FF(M).LT.SF(M))GOTO 146
        U=SQRT(FF(M))
        V=SQRT(FF(I))*WI
        SF(I)=SQRT((SQRT(V**2+W)-V)**2+(SQRT(FF(M)+SF(M))-U)**2)
        IF(AMIN1(U,V).GT.2.*SF(I))EP(I)=ABS(EP(I))
        FF(I)=V-U
        IF(NZ.NE.0)FF(I)=-FF(I)
        EO(I)=ABS(EO(I))
        T=SQRT(1./SQ(I))
          DO 144 J=1,10
          IF(T.GT.G(J))GOTO 145
 144      CONTINUE
        J=11
 145    D(J)=D(J)+1.
        D(J+11)=D(J+11)+ABS(FF(I)/SF(I))
        D(J+22)=D(J+22)+ABS(FF(M)-V**2)
        D(J+33)=D(J+33)+FF(M)
 146    I=I+1
 147    M=M+1
        IF(M.LE.NG)GOTO 143
 148    CALL ENORM(NR-NB,FF(NT),SQ(NT),EO(NT),FA(NT),SF(NT))
        KT=' <d''/sig> '
          DO 149 I=1,11
          IF(D(I).LT.0.5)GOTO 149
          WRITE(KT(6*I+5:6*I+10),'(F6.2)')D(I+11)/D(I)
 149      CONTINUE
        WRITE(*,'(A)')KT(1:76)
        KT=' R(isom) '
          DO 150 I=1,11
          IF(D(I).LT.0.5)GOTO 150
          T=D(I+22)/D(I+33)
          WRITE(KT(6*I+5:6*I+10),'(F6.3)')T
          D(I)=1.
 150      CONTINUE
        WRITE(*,'(A)')KT(1:76)
          DO 153 I=NT,NR
          IF(EP(I).LT.0.)GOTO 153
          IF(SF(I).LT.0.)GOTO 153
          T=SQRT(1./SQ(I))
            DO 151 J=1,10
            IF(T.GT.G(J))GOTO 152
 151        CONTINUE
          J=11
 152      SF(I)=SF(I)*D(J)
 153      CONTINUE
        GOTO 184
C
C Extract MAD FA and alpha angles
C
 154    IF(NN.LT.10)GOTO 200
        CALL INSORT(NR,IP,IQ,IH)
        CALL INSORT(NR,IQ,IP,IK)
        CALL INSORT(NR,IP,IQ,IL)
          DO 155 I=5,8
          D(I)=0.
 155      CONTINUE
          DO 156 I=1,NR
          IF(SA(I).LT.0.)SA(I)=AMAX1(0.5,SA(I))
          J=IABS(IC(I))
          D(J)=AMAX1(D(J),SQ(I))
 156      CONTINUE
        J=0
        SM=0.
          DO 157 I=5,8
          IF(SM.GE.D(I))GOTO 157
          J=I
          SM=D(I)
 157      CONTINUE
        D(J)=0.
        SM=0.
          DO 158 I=5,8
          SM=AMAX1(D(I),SM)
 158      CONTINUE
        G(11)=0.01*ANINT(100./SQRT(AMAX1(SM,0.063)))
        Q=0.1*ANINT(10.*G(11))+0.2
          DO 159 I=1,44
          D(I)=0.
 159      CONTINUE
          DO 160 I=10,1,-1
          G(I)=Q
          Q=Q+0.2
 160      CONTINUE
        G(1)=8.
          DO 161 I=2,4
          G(I)=AMAX1(G(I),8.-REAL(I))
 161      CONTINUE
          DO 162 I=5,10
          Q=0.5*Q+0.5
          G(I)=AMAX1(G(I),6.-0.5*REAL(I))
 162      CONTINUE
          DO 163 I=1,396
          D(I)=0.
 163      CONTINUE
        NB=NR
        I=1
 164    J=IQ(I)
        K=I
 165    I=I+1
        IF(I.GT.NB)GOTO 166
        L=IQ(I)
        IF(IH(J).NE.IH(L))GOTO 166
        IF(IK(J).NE.IK(L))GOTO 166
        IF(IL(J).NE.IL(L))GOTO 166
        GOTO 165
 166    T=SQRT(1./SQ(J))
          DO 167 NM=1,10
          IF(T.GT.G(NM))GOTO 168
 167      CONTINUE
        NM=11
 168    U=0.
        R=0.
        NP=0
        NQ=0
        AS=0.
          DO 172 NJ=K,I-1
          J=IQ(NJ)
          NT=IABS(IC(J))
          IF(EP(J).LT.0.)GOTO 171
            DO 169 NL=K,NJ-1
            N=IQ(NL)
            IF(EP(N).LT.0.)GOTO 169
            M=NM
            IF(IABS(IC(N)).EQ.5)M=NM+66*(NT-6)
            IF(IABS(IC(N)).EQ.6)M=NM+66*(NT-4)
            IF(IABS(IC(N)).EQ.7)M=NM+330
            D(M)=D(M)+1.
            D(M+11)=D(M+11)+FB(N)
            D(M+22)=D(M+22)+FB(J)
            D(M+33)=D(M+33)+FB(N)**2
            D(M+44)=D(M+44)+FB(J)**2
            D(M+55)=D(M+55)+FB(J)*FB(N)
 169        CONTINUE
          W=0.
          IF(NT.EQ.6)W=0.5
          IF(NT.EQ.7)W=1.
          IF(NT.EQ.8)W=0.6
          IF(NZ.EQ.0)GOTO 170
          IF(NT.EQ.6)W=1.-WD
          IF(NT.EQ.8)W=WD
 170      U=U+W*FB(J)
          R=R+W
 171      AS=AS+1./SA(J)**2
          IF(FF(J).LT.SF(J))GOTO 172
          NP=NP+1
          IF(NT.LT.7)NQ=NQ+1
 172      CONTINUE
        V=0.
        S=0.
        W=0.
        T=0.
        Q=0.
        QS=0.
        QW=0.
          DO 173 J=K,I-1
          N=IQ(J)
          NT=IABS(IC(N))
          Q=Q+FF(N)
          QS=QS+1./SF(N)**2
          QW=QW+1.
          IF(NP.LE.NQ.OR.NP.LT.2)GOTO 173
          IF(FF(N).LT.SF(N))GOTO 173
          P=0.
          IF(NT.LT.7)P=1.
          IF(NT.EQ.7.AND.NQ.EQ.0)P=1.
          V=V+P*SQRT(FF(N))
          S=S+P
          IF(P.GT.0.1)GOTO 173
          P=0.6
          IF(NT.EQ.8)P=1.
          W=W+P*SQRT(FF(N))
          T=T+P
 173      CONTINUE
        IF(NR.GE.LD)GOTO 22
        NR=NR+1
        IH(NR)=IH(N)
        IK(NR)=IK(N)
        IL(NR)=IL(N)
        FF(NR)=Q/QW
        SF(NR)=SQRT(1./QS)
        SA(NR)=SQRT(1./AS)
        SQ(NR)=SQ(N)
        FA(NR)=0.
        EP(NR)=-1.
        IF(AMIN1(S,T).LT.0.01)GOTO 174
        FA(NR)=(V/S)-(W/T)
        EP(NR)=1.
 174    FB(NR)=0.
        IP(NR)=-1
        IF(R.LT.0.01)GOTO 175
        FB(NR)=U/R
        IP(NR)=1
 175    IF(I.LE.NB)GOTO 164
        NT=NB+1
        CALL ENORM(NR-NB,FA(NT),SQ(NT),EP(NT),FA,FB)
          DO 176 I=NT,NR
          IF(EP(I).GT.0.)FA(I)=FA(I-NB)
          EP(I)=REAL(IP(I))
 176      CONTINUE
        CALL ENORM(NR-NB,FB(NT),SQ(NT),EP(NT),FB,SA(NT))
          DO 177 I=NT,NR
          IF(EP(I).GT.0.)FB(I)=FB(I-NB)
 177      CONTINUE
C
C Output anomalous correlation coefficients
C
        WRITE(*,'(/A)')' Correlation coefficients (%) between signed'
     +  //' anomalous differences'
        WRITE(*,'(A,10(A,F4.1),A,F5.2,A)')' Resl.   Inf',
     +  (' -',G(I),I=1,11)
        N=-66
          DO 180 J=5,8
          KT=' '//KX(J)//'/'
            DO 179 K=J+1,8
            N=N+66
            IF(.NOT.BTEST(NN,K-1))GOTO 179
            IF(.NOT.BTEST(NN,J-1))GOTO 179
            KT(7:10)=KX(K)
              DO 178 I=1,11
              L=I+N
              IF(D(L).LT.1.5)GOTO 178
              WRITE(KT(6*I+5:6*I+10),'(F6.1)')100.*(D(L)*D(L+55)-
     +        D(L+11)*D(L+22))/SQRT((D(L)*D(L+33)-D(L+11)**2)*
     +        (D(L)*D(L+44)-D(L+22)**2))
 178          CONTINUE
            IF(NZ.NE.0)KT(2:10)='NAT/RIPA '
            WRITE(*,'(A)')KT(1:76)
 179        CONTINUE
 180      CONTINUE
C
C Output FA/alpha file
C
 181    FORMAT(/' For zero signal <d''/sig> and <d"/sig> should be',
     +  ' about 0.80')
 182    FORMAT(3I4,2F8.2,I4)
 183    FORMAT(/I9,' Reflections written to file ',A)
 184    WRITE(*,181)
        KR=KF(1:LN)//'_fa.hkl'
        NL=LN+7
        OPEN(LF,FILE=KR(1:NL),STATUS='OLD',IOSTAT=I)
        CLOSE(LF,STATUS='DELETE',IOSTAT=I)
        OPEN(LF,FILE=KR(1:NL),STATUS='NEW',ERR=23)
          DO 185 I=NT,NR
          FC(I)=1.
          FD(I)=1.
 185      CONTINUE
        IF(NN.NE.5)GOTO 187
          DO 186 I=NT,NR
          SA(I)=AMIN1(0.463,SF(I))
          FB(I)=0.
 186      CONTINUE
 187    IF(NN.NE.9)GOTO 191
          DO 190 I=NT,NR
          IF(SA(I).GT.0.)GOTO 188
          SA(I)=0.
          FB(I)=0.
          IF(SF(I).LT.0.)GOTO 190
          IF(ABS(EO(I)-ABS(EP(I))).GT.0.1)GOTO 188
          FB(I)=0.886
          SA(I)=0.463
          FD(I)=0.
 188      IF(SF(I).GT.0.)GOTO 189
          FA(I)=0.886
          SF(I)=0.463
          FC(I)=0.
 189      SA(I)=SQRT(AMIN1(0.2146,SA(I))**2+DM*AMIN1(0.2146,SF(I))**2)
 190      CONTINUE
 191      DO 193 I=NT,NR
          EP(I)=-1.
          IP(I)=0
          T=SQRT(DM*FA(I)**2+FB(I)**2)
          IF(T.LT.0.0001)GOTO 192
          EP(I)=1.
          IP(I)=NINT(AMOD(720.5+57.29578*ATAN2(FB(I)*FD(I),
     +    DM*FA(I)*FC(I)),360.)-0.5)
 192      FA(I)=T
 193      CONTINUE
        Q=0.
          DO 194 I=NT,NR
          IF(EP(I).LT.0.)GOTO 194
          T=EXP(-2.5*SQ(I))
          SA(I)=SA(I)*T
          FA(I)=FA(I)*T
          Q=AMAX1(FA(I),-10.*FA(I),SA(I),-10.*SA(I),Q)
 194      CONTINUE
        Q=9999./Q
        M=0
          DO 195 I=NT,NR
          IF(EP(I).LT.0.)GOTO 195
          WRITE(LF,182)IH(I),IK(I),IL(I),FA(I)*Q,SA(I)*Q,IP(I)
          M=M+1
 195      CONTINUE
        CLOSE(LF)
        WRITE(*,183)M,KR(1:NL)//' for input to SHELXD/E'
        IF(ND.NE.2.AND.ND.NE.9)GOTO 200
        IF(BTEST(NN,0))GOTO 200
C
C Output native data
C
 196    KR=KF(1:LN)//'.hkl'
        NL=LN+4
        OPEN(LF,FILE=KR(1:NL),STATUS='OLD',IOSTAT=I)
        CLOSE(LF,STATUS='DELETE',IOSTAT=I)
        OPEN(LF,FILE=KR(1:NL),STATUS='NEW',ERR=23)
        Q=0.
          DO 197 I=NT,NR
          Q=AMAX1(FF(I),-10.*FF(I),SF(I),-10.*SF(I),Q)
 197      CONTINUE
        Q=9999./Q
          DO 198 I=NT,NR
          WRITE(LF,182)IH(I),IK(I),IL(I),FF(I)*Q,SF(I)*Q
 198      CONTINUE
        CLOSE(LF)
        IF(NZ.GE.0)WRITE(*,183)NR-NB,KR(1:NL)//' for input to SHELXE'
        IF(NN.NE.5.AND.NN.NE.9)NR=0
 199    NG=NR
 200    CONTINUE
C
C Write .ins file for SHELXD
C
      KR=KF(1:LN)//'_fa.ins'
      NL=LN+7
      OPEN(LF,FILE=KR(1:NL),STATUS='OLD',IOSTAT=I)
      CLOSE(LF,STATUS='DELETE',IOSTAT=I)
      OPEN(LF,FILE=KR(1:NL),STATUS='NEW',ERR=23)
      WRITE(*,'(/A/)')' File '//KR(1:NL)//
     +' written for input to SHELXD:'
      L=NL+4
      KR(L-3:L)=' MAD'
      IF(NN.LT.4)KR(L-2:L-2)='S'
      IF(NN.EQ.5)KR(L-2:L)='SIR'
      IF(NN.NE.9)GOTO 201
      L=L+2
      KR(L-4:L)='SIRAS'
 201  IF(NZ.LE.0)GOTO 202
      KR(L-2:L)='RIP'
 202  IF(NZ.GE.0)GOTO 203
      L=L+2
      KR(L-4:L)='RIPAS'
 203  KT='TITL '//KR(1:L)//' in '
      L=L+9
        DO 204 I=1,80
        IF(KI(10)(I:I).LE.' ')GOTO 204
        L=L+1
        KT(L:L)=KI(10)(I:I)
 204    CONTINUE
      WRITE(*,'(1X,A)')KT(1:L)
      WRITE(LF,'(A)')KT(1:L)
      KR=' '
      WRITE(KR,'(A,F9.5,6F8.2,3F8.3)')'CELL',WL,(C(I),I=1,6)
      WRITE(*,'(1X,A)')KR(1:61)
      WRITE(LF,'(A)')KR(1:61)
      KR=' '
      WRITE(KR,'(A,I4)')'LATT',LT
      WRITE(*,'(1X,A)')KR(1:8)
      WRITE(LF,'(A)')KR(1:8)
        DO 210 N=2,NS
        KR='SYMM '
        L=5
        NT=10
          DO 209 K=1,7,3
          J=L
          I=INT(AMOD(288.5+12.*SY(NT,N),12.))
          IF(I.EQ.0)GOTO 205
          L=L+3
          KR(L-2:L)='1/'//CHAR(ICHAR('0')+12/MIN0(I,12-I))
          IF(I.GT.7)KR(L-2:L-2)=CHAR(ICHAR('2')+I-8+I/10)
 205        DO 208 I=K,K+2
            IF(SY(I,N).GT.-0.5)GOTO 206
            L=L+1
            KR(L:L)='-'
            GOTO 207
 206        IF(SY(I,N).LT.0.5)GOTO 208
            IF(L.EQ.J)GOTO 207
            L=L+1
            KR(L:L)='+'
 207        L=L+1
            KR(L:L)=CHAR(ICHAR('X')+I-K)
 208        CONTINUE
          L=L+2
          KR(L-1:L)=', '
          NT=NT+1
 209      CONTINUE
        L=L-2
        WRITE(LF,'(A)')KR(1:L)
        WRITE(*,'(1X,A)')KR(1:L)
 210    CONTINUE
      KR='SFAC '
      L=5
        DO 211 I=1,80
        IF(KI(12)(I:I).LE.' ')GOTO 211
        L=L+1
        KR(L:L)=KI(12)(I:I)
 211    CONTINUE
      IF(L.GT.5)GOTO 212
      L=7
      KR(6:7)='SE'
 212  WRITE(LF,'(A)')KR(1:L)
      WRITE(*,'(1X,A)')KR(1:L)
      READ(KI(11),*,ERR=213,END=213)N
      IF(N.GT.1)GOTO 214
 213  N=8
 214  M=4*N*NS
      IF(LT.LT.-4)M=M*2
      IF(LT.GT.-5)M=-M*LT
      KR=' '
      WRITE(KR,'(A,I6)')'UNIT',M
      WRITE(LF,'(A)')KR(1:10)
      WRITE(*,'(1X,A)')KR(1:10)
      J=1
      L=0
        DO 215 I=1,80
        IF(KI(15)(I:I).LE.' ')GOTO 215
        IF(L.EQ.0)J=I
        L=I
 215    CONTINUE
      IF(L.EQ.0)GOTO 216
      KR='SHEL '//KI(15)(J:L)
      L=L-J+6
      GOTO 217
 216  L=12
      T=RT+0.5
      IF(IAND(NN,12).NE.0)T=RT+0.3
      WRITE(KR,'(A,F4.1)')'SHEL 999',T
 217  WRITE(LF,'(A)')KR(1:L),'PATS'
      WRITE(*,'(1X,A)')KR(1:L),'PATS'
      J=1
      L=0
        DO 218 I=1,80
        IF(KI(11)(I:I).LE.' ')GOTO 218
        IF(L.EQ.0)J=I
        L=I
 218    CONTINUE
      IF(L.GT.0)GOTO 219
      L=1
      KI(11)(J:L)='8'
 219  KR='FIND '//KI(11)(J:L)
      L=L+6-J
      WRITE(LF,'(A)')KR(1:L)
      WRITE(*,'(1X,A)')KR(1:L)
      J=1
      L=0
        DO 220 I=1,80
        IF(KI(13)(I:I).LE.' ')GOTO 220
        IF(L.EQ.0)J=I
        L=I
 220    CONTINUE
      IF(L.GT.0)GOTO 221
      L=9
      KI(13)(J:L)='-1.5 -0.1'
 221  KR='MIND '//KI(13)(J:L)
      L=L+6-J
      WRITE(LF,'(A)')KR(1:L)
      WRITE(*,'(1X,A)')KR(1:L)
      J=1
      L=0
        DO 222 I=1,80
        IF(KI(21)(I:I).LE.' ')GOTO 222
        IF(L.EQ.0)J=I
        L=I
 222    CONTINUE
      IF(L.EQ.0)GOTO 223
      KR='ESEL '//KI(21)(J:L)
      L=L+6-J
      WRITE(LF,'(A)')KR(1:L)
      WRITE(*,'(1X,A)')KR(1:L)
 223  J=1
      L=0
        DO 224 I=1,80
        IF(KI(20)(I:I).LE.' ')GOTO 224
        IF(L.EQ.0)J=I
        L=I
 224    CONTINUE
      IF(L.EQ.0)GOTO 225
      KR='DSUL '//KI(20)(J:L)
      L=L+6-J
      WRITE(LF,'(A)')KR(1:L)
      WRITE(*,'(1X,A)')KR(1:L)
 225  J=1
      L=0
        DO 226 I=1,80
        IF(KI(14)(I:I).LE.' ')GOTO 226
        IF(L.EQ.0)J=I
        L=I
 226    CONTINUE
      IF(L.GT.0)GOTO 227
      L=3
      KI(14)(J:L)='100'
 227  KR='NTRY '//KI(14)(J:L)
      L=L+6-J
      WRITE(LF,'(A)')KR(1:L),'SEED 1','HKLF 3','END '
      WRITE(*,'(1X,A)')KR(1:L),'SEED 1','HKLF 3','END '
      CLOSE(LF)
C
C Finish off
C
      CALL DATE_AND_TIME(KT,KR,KS,IA)
      KS='  +  SHELXC for '//KF(1:LN)//' finished at '//KR(1:2)//':'
     +//KR(3:4)//':'//KR(5:6)//' on '//KT(7:8)//' '//KM(IA(2))//' '//
     +KT(1:4)
      WRITE(*,228)KS(1:71)
 228  FORMAT(/2X,72('+')/A,'  +'/2X,72('+')/)
      CALL EXIT(0)
      STOP' '
      END
C
C --------------------------------------------------------------------
C
      SUBROUTINE INSORT(N,IP,IQ,ID)
C
C Sort-merge integer data in order of ascending ID(I). IP is the
C current pointer array to ID and IQ becomes the new pointer array.
C
      INTEGER::IP(N),IQ(N),ID(N)
      INTEGER,ALLOCATABLE,DIMENSION(:)::IT
      L=1000000
      M=-1000000
        DO 1 I=1,N
        J=ID(IP(I))
        IF(L.GT.J)L=J
        IF(M.LT.J)M=J
   1    CONTINUE
      L=L-1
      M=M-L
      ALLOCATE(IT(M))
        DO 2 I=1,M
        IT(I)=0
   2    CONTINUE
        DO 3 I=1,N
        J=ID(IP(I))-L
        IT(J)=IT(J)+1
   3    CONTINUE
      J=0
        DO 4 I=1,M
        K=J
        J=J+IT(I)
        IT(I)=K
   4    CONTINUE
        DO 5 I=1,N
        J=ID(IP(I))-L
        IT(J)=IT(J)+1
        J=IT(J)
        IQ(J)=IP(I)
   5    CONTINUE
      DEALLOCATE(IT)
      RETURN
      END
C
C --------------------------------------------------------------------
C
      SUBROUTINE ENORM(NR,F,SQ,EP,E,SA)
      REAL::F(NR),SQ(NR),EP(NR),E(NR),SA(NR),B(42)
C
C Estimate E*sqrt(epsilon)
C
      R=0.
        DO 1 I=1,NR
        R=AMAX1(R,SQ(I))
   1    CONTINUE
      R=20./AMAX1(R,0.0001)
        DO 2 I=1,42
        B(I)=0.
   2    CONTINUE
        DO 3 I=1,NR
        IF(EP(I).LT.0.)GOTO 3
        P=R*SQ(I)
        N=MIN0(INT(P),19)
        P=P-REAL(N)
        Q=1.-P
        T=(F(I)/EP(I))**2
        B(N+1)=B(N+1)+Q*T
        B(N+2)=B(N+2)+P*T
        B(N+22)=B(N+22)+Q
        B(N+23)=B(N+23)+P
   3    CONTINUE
        DO 4 I=1,21
        B(I)=B(I+21)/AMAX1(B(I),0.0001)
   4    CONTINUE
        DO 5 I=1,NR
        E(I)=0.
        IF(EP(I).LT.0.)GOTO 5
        IF(SA(I).LT.0.)GOTO 5
        P=R*SQ(I)
        N=MIN0(INT(P),19)
        P=P-REAL(N)
        Q=1.-P
        T=SQRT(B(N+1)*Q+B(N+2)*P)
        IF(SA(I).LE.0.)GOTO 5
        SA(I)=SA(I)*T
        IF(ABS(F(I)).LT.0.0001)GOTO 5
        E(I)=SIGN(EP(I)*SQRT(SQRT(1./(.00390625+1./
     +  AMAX1(0.01,ABS(T*F(I)/EP(I)))**4))),F(I))
   5    CONTINUE
      RETURN
      END
C
C --------------------------------------------------------------------
C
      SUBROUTINE SPAGSY(KR,NS,LT,SY,C)
C
C Interpret string KR as a space group in PDB notation. Store symmetry
C operations in SY, number of symops in NS and SHELX LATT code in LT.
C
      CHARACTER::S(81)*21,KR*80,KT*1
      REAL::SY(12,48),C(12)
C
C Encoded space group operators (chiral space groups only). Some
C common non-standard settings are allowed, eg. I2, P22(1)2(1), A222.
C R3 and R32 may be given with either rhombohedral or hexagonal axes.
C
      DATA S(1)/'P1'/,S(2)/'A1'/,S(3)/'B1'/,S(4)/'C1'/,S(5)/'I1'/,
     +S(6)/'F1'/,S(7)/'P2 UYW'/,S(8)/'P7 UEW'/,S(9)/'C2 UYW'/,S(10)/
     +'I2 UYW'/,S(11)/'P82 UVZUYW'/,S(12)/'P87 UVFUYC'/,S(13)/
     +'P78 DVWAVZ'/,S(14)/'P272 UEWXBW'/,S(15)/'P772 UVZAEW'/
      DATA S(16)/'P277 XVWUBF'/,S(17)/'P727 UYWDVC'/,S(18)/
     +'P777 AVFUEC'/,S(19)/'C87 UVFUYC'/,S(20)/'A78 DVWAVZ'/,S(21)/
     +'B272 UEWXBW'/,S(22)/'C82 UVZUYW'/,S(23)/'A82 XVWUVZ'/,S(24)/
     +'B82 UYWXVW'/,S(25)/'F82 UVZUYW'/,S(26)/'I82 UVZUYW'/
      DATA S(27)/'I777 AVFUEC'/,S(28)/'P4 VXZ'/,S(29)/'P42 VXF'/,
     +S(30)/'P41 VX1Z'/,S(31)/'P43 VX3Z'/,S(32)/'I4 VXZ'/,S(33)/
     +'I41 VD1Z'/,S(34)/'P48 VXZUYW'/,S(35)/'P472 BDZAEW'/,S(36)/
     +'P482 VXFUYW'/,S(37)/'P4272 BDFAEC'/
      DATA S(38)/'P418 VX1ZUYW'/,S(39)/'P438 VX3ZUYW'/,S(40)/
     +'P4172 BD1ZAE1W'/,S(41)/'P4372 BD3ZAE3W'/,S(42)/
     +'I48 VXZUYW'/,S(43)/'I418 VD1ZAY3W'/,S(44)/'P3 VTZ'/S(45)/
     +'P31 VT4Z'/,S(46)/'P9 VT5Z'/,S(47)/'H3 VTZ'/,S(48)/'R3 ZXY'/
      DATA S(49)/'P37 VTZYXW'/,S(50)/'P317 VT4ZYXW'/,S(51)/
     +'P97 VT5ZYXW'/,S(52)/'H9 VTZYXW'/,S(53)/'R9 ZXYVUW'/,S(54)/
     +'P312 VTZVUW'/,S(55)/'P3112 VT4ZVU5W'/,S(56)/'P372 VT5ZVU4W'/,
     +S(57)/'P6 VTZUVZ'/,S(58)/'P63 VTZUVF'/,S(59)/'P62 VT5ZUVZ'/
      DATA S(60)/'P64 VT4ZUVZ'/,S(61)/'P61 VT4ZUVF'/,S(62)/
     +'P65 VT5ZUVF'/,S(63)/'P68 VTZUVZYXW'/,S(64)/'P638 VTZUVFYXW'/,
     +S(65)/'P682 VT5ZUVZYX5W'/,S(66)/'P648 VT4ZUVZYX4W'/,
     +S(67)/'P618 VT4ZUVFYX4W'/,S(68)/'P658 VT5ZUVFYX5W'/
      DATA S(69)/'P23 UVZUYWZXY'/,S(70)/'P73 AVFUECZXY'/,
     +S(71)/'I23 UVZUYWZXY'/,S(72)/'I73 AVFUECZXY'/,S(73)/
     +'F23 UVZUYWZXY'/,S(74)/'P49 UVZUYWZXYYXW'/,S(75)/
     +'P429 UVZUYWZXYEDC'/,S(76)/'P419 AVFUECZXY3Y1X1W'/
      DATA S(77)/'P439 AVFUECZXY1Y3X3W'/,S(78)/
     +'I49 UVZUYWZXYYXW'/,S(79)/'I419 AVFUECZXY3Y1X1W'/,S(80)/
     +'F49 UVZUYWZXYYXW'/,S(81)/'F419 UBFAEWZXY3Y1X3W'/
C
C Standardize space group name
C
      LT=0
      K=0
        DO 1 I=1,80
        KT=KR(I:I)
        IF(KT.GE.'a'.AND.KT.LE.'z')KT=CHAR(ICHAR(KT)-32)
        IF(KT.EQ.' ')GOTO 1
        IF(KT.EQ.CHAR(40))GOTO 1
        IF(KT.EQ.CHAR(41))GOTO 1
        K=K+1
        KR(K:K)=KT
   1    CONTINUE
      IF(KR(1:5).EQ.'P1211')KR='P21'
      IF(KR(1:4).EQ.'P121')KR='P2'
      IF(KR(1:4).EQ.'C121')KR='C2'
      IF(KR(1:4).EQ.'I121')KR='I2'
      KR(K+1:80)=' '
      IF(KR(1:1).NE.'R')GOTO 2
      IF(C(6)-C(5).GT.20.)KR(1:1)='H'
   2  I=INDEX(KR(1:11),'21')
      IF(I.EQ.0)GOTO 4
      KR(I:I)='7'
        DO 3 J=I+1,11
        KR(J:J)=KR(J+1:J+1)
   3    CONTINUE
      GOTO 2
   4  I=INDEX(KR(1:11),'22')
      IF(I.EQ.0)GOTO 6
      KR(I:I)='8'
        DO 5 J=I+1,11
        KR(J:J)=KR(J+1:J+1)
   5    CONTINUE
      GOTO 4
   6  I=INDEX(KR(1:11),'32')
      IF(I.EQ.0)GOTO 8
      KR(I:I)='9'
        DO 7 J=I+1,11
        KR(J:J)=KR(J+1:J+1)
   7    CONTINUE
      GOTO 6
C
C Identify space group and set SHELX LATT code in LT
C
   8  K=INDEX(KR,' ')
        DO 9 NG=1,81
        IF(KR(1:K).EQ.S(NG)(1:K))GOTO 10
   9    CONTINUE
      GOTO 25
  10  LT=-1
      KT=KR(1:1)
      IF(KT.EQ.'I')LT=-2
      IF(KT.EQ.'H')LT=-3
      IF(KT.EQ.'F')LT=-4
      IF(KT.LE.'C')LT=-5+ICHAR('A')-ICHAR(KT)
C
C Store symmetry generators in SY
C
      NS=1
        DO 11 I=1,12
        SY(I,NS)=0.
  11    CONTINUE
        DO 12 I=1,9,4
        SY(I,NS)=1.
  12    CONTINUE
      K=K+1
  13  IF(S(NG)(K:K).EQ.' ')GOTO 25
      NS=NS+1
      N=1
      L=10
        DO 14 I=1,12
        SY(I,NS)=0.
  14    CONTINUE
  15  KT=S(NG)(K:K)
      IF(KT.LT.'A'.OR.KT.GT.'F')GOTO 16
      KT=CHAR(ICHAR(KT)+20)
      SY(L,NS)=0.5
  16  T=1.
      IF(KT.LT.'U'.OR.KT.GT.'W')GOTO 17
      KT=CHAR(ICHAR(KT)+3)
      T=-1.
  17  IF(KT.LT.'X'.OR.KT.GT.'Z')GOTO 18
      I=N+ICHAR(KT)-ICHAR('X')
      SY(I,NS)=T
      GOTO 20
  18  IF(KT.EQ.'T')GOTO 19
      I=3*(ICHAR(KT)-ICHAR('0'))
      IF(I.EQ.21)I=10
      IF(I.EQ.18)I=2
      IF(I.EQ.15)I=8
      IF(I.EQ.12)I=4
      SY(L,NS)=REAL(I)/12.
      GOTO 21
  19  SY(N,NS)=1.
      SY(N+1,NS)=-1.
  20  N=N+3
      L=L+1
  21  K=K+1
      IF(N.LT.8)GOTO 15
C
C Expand to symmetry operators in SY
C
      NL=NS
  22  J=NS
        DO 24 I=2,NL
        NS=NS+1
        N=10
          DO 23 L=1,7,3
          SY(L,NS)=SY(L,J)*SY(1,I)+SY(L+1,J)*SY(4,I)+
     +    SY(L+2,J)*SY(7,I)
          SY(L+1,NS)=SY(L,J)*SY(2,I)+SY(L+1,J)*SY(5,I)+
     +    SY(L+2,J)*SY(8,I)
          SY(L+2,NS)=SY(L,J)*SY(3,I)+SY(L+1,J)*SY(6,I)+
     +    SY(L+2,J)*SY(9,I)
          SY(N,NS)=SY(L,J)*SY(10,I)+SY(L+1,J)*SY(11,I)+
     +    SY(L+2,J)*SY(12,I)+SY(N,J)
          N=N+1
  23      CONTINUE
  24    CONTINUE
      J=NS
      IF(SY(1,J)+SY(5,J)+SY(9,J)-ABS(SY(2,J))-ABS(SY(4,J))
     +.LT.2.9)GOTO 22
      NS=NS-1
      GOTO 13
  25  RETURN
      END
