C
C                SHELXA - Release 97-2
C
C SHELXA applies "Absorption corrections" by fitting the observed
C to the calculated intensities in the DIFABS tradition.  This is
C is intended for EMERGENCY USE ONLY, e.g. when the world's only
C crystal falls off the diffractometer before there is time to make
C proper absorption corrections by indexing crystal faces or by
C determining an absorption surface experimentally by measuring
C equivalent reflections at different azimuthal angles etc.
C
C SHELXA reads an .fcf file written by SHELXL-96 (using LIST 4 or
C LIST 6 and any combination of MERG, OMIT etc.) and a .raw file in
C SHELX HKLF 4 format containing direction cosines, and writes a new
C SHELX .hkl file in HKLF 4 format.  THIS WILL OVERWRITE AN EXISTING
C .hkl FILE !  A SHELXL-93 .fcf file is not suitable because some
C information is missing.  There are only four restrictions on the
C use of SHELXA:
C
C 1. The structure should not be twinned.
C
C 2. There may not be a reorientation matrix on the HKLF instruction
C    used in the SHELXL job that created the .fcf file.
C
C 3. It is understood that any structure determined by means of this
C    scientifically dubious procedure WILL NEVER BE PUBLISHED !
C
C 4. The anonymous author of this program has no intention of writing a
C    paper on it that could be quoted and thereby ruin his reputation.
C
C    The absorption is modeled by spherical harmonic functions using
C full-matrix least-squares more or less by the method of Blessing,
C Acta Cryst. A51 (1995) 33-38; n.b. it is not this model that should
C be regarded as dubious, just the way SHELXA misuses it.  Data are
C used for parameter determination if the I/sigma(I) ratios for both
C the observed and calculated intensities exceed a given (by the -t
C switch) or assumed threshold (equal to 5.0).  The -u switch specifies
C an artificial delta-U/(lambda-squared) value that is applied to the
C calculated intensities; this helps to prevent atoms going NPD, but
C the default value is zero.  The -e and -o switches specify the
C highest even and odd order spherical harmonics to employ; the
C refinement may be unstable if these are too high, especially if only
C part of reciprocal space is sampled, e.g. because only an asymmetric
C unit was collected for a high symmetry structure.  Allowed values are
C (0,2,4,6,8) and (0,1,3,5,7) respectively.  Thus:
C
C               shelxa -t3 -u0.002 -e4 -o1 baddata
C
C would read baddata.raw and baddata.fcf and write baddata.hkl, with
C data with I>3sigma used to fit the absorption parameters, a delta-U
C of 0.002 effectively added to all current isotropic displacement
C parameters, and highest even and odd harmonics 4 and 1 respectively.
C Such UNIX switches will also be recognized under MSDOS, VMS etc.;
C no spaces are allowed between the letter and value.  The filename
C stem (here "baddata") must come last.  Usually the default values
C should prove sensible, i.e:
C
C                        shelxa baddata
C
C The data may be re-processed when, for example, extra atoms are
C added; however, as with DIFABS, best results are obtained if the
C procedure is last run with the final ISOTROPIC model; re-running it
C after anisotropic refinement will result in a deterioration of the
C structure and (most important) the R-factors.  The delta-U fudge
C should not be used repetitively, because the effects will be
C cumulative !
C
      PROGRAM SHELXA
C
C MR is the maximum number of reflections from the .raw file that
C can be used for parameter fitting, and MF is the maximum number of
C (merged) reflections in the .fcf file.  It may be necessary to
C increase these for very large structures.
C
      PARAMETER(MR=100000,MF=100000)
C
      CHARACTER TX(3)*10
      CHARACTER*80 KN,KR,KT
      INTEGER IN(MF)
      REAL FF(MR),XI(MR),XD(MR),YI(MR),YD(MR),ZI(MR),ZD(MR),FC(MR)
      REAL FD(MF),D(12),SY(9,49)
      REAL*8 B(3570),C(84),E(84),F(84),DD,DT
      COMMON/HUGE/B,F,C,IN,FF,XI,XD,YI,YD,ZI,ZD,FC,FD,D,SY
C
C The following possibly computer-specific items should be modified
C as required.  NOS is 1 for MSDOS, 2 for VMS and 3 for UNIX. For
C some systems CARRIAGECONTROL='LIST' should be removed from the
C OPEN statement for the output .hkl file as well.
C
C Comment out the following unless MSDOS:
C
C     NOS=1
C     KT=' '
C     CALL GETCL(KT)
C
C Comment out the following unless VMS:
C
C     INTEGER CLI$GET_VALUE
C     NOS=2
C     KT=' '
C     I=CLI$GET_VALUE('$LINE',KT)
C
C Comment out the following unless UNIX:
C
      NOS=3
      KT=' '
      L=0
        DO 3 I=1,IARGC()
        KN=' '
        CALL GETARG(I,KN)
        IF(KN(1:1).EQ.'-')GOTO 1
        IF(I.LT.IARGC())GOTO 3
   1    DO 2 J=1,80
          IF(KN(J:J).EQ.' ')GOTO 2
          L=L+1
          IF(L.GT.79)GOTO 12
          KT(L:L)=KN(J:J)
   2    CONTINUE
      L=L+1
   3  CONTINUE
C
C The rest is unlikely to require changing for different computers
C
   4  FORMAT(/' SHELXA-97 - Release 97-2 - Apply "absorption ',
     +'corrections" by fitting the'/' observed to the calculated ',
     +'diffraction intensities (similar to the program'/' DIFABS).',
     +'  This ethically questionable method is intended for ',
     +'DEMONSTRATION'/' and EMERGENCY use ONLY.  It is understood',
     +' that the resulting structure will'/' NOT be submitted ',
     +'for publication, and that the anonymous author of the'/
     +' program will NOT be cited in this non-existent paper.')
      WRITE(*,4)
C
C Interpret the command line
C
      TH=5.
      DU=0.
      ME=6
      MO=3
      LN=0
      I=0
   5  I=I+1
      IF(I.GT.80)GOTO 15
      IF(KT(I:I).LE.' ')GOTO 5
      L=0
      KR=' '
   6  L=L+1
      KR(L:L)=KT(I:I)
      I=I+1
      IF(I.GT.80)GOTO 12
      IF(KT(I:I).GT.' ')GOTO 6
      IF(KR(1:1).EQ.'-')GOTO 7
      LN=L
      KN=KR(1:80)
      GOTO 5
   7  IF(KR(2:2).NE.'t'.AND.KR(2:2).NE.'T')GOTO 8
      READ(KR(3:80),*,ERR=12,END=12)TH
      GOTO 5
   8  IF(KR(2:2).NE.'u'.AND.KR(2:2).NE.'U')GOTO 9
      READ(KR(3:80),*,ERR=12,END=12)DU
      GOTO 5
   9  IF(KR(2:2).NE.'e'.AND.KR(2:2).NE.'E')GOTO 10
      READ(KR(3:80),*,ERR=12,END=12)ME
      GOTO 5
  10  IF(KR(2:2).NE.'o'.AND.KR(2:2).NE.'O')GOTO 12
      READ(KR(3:80),*,ERR=12,END=12)MO
      GOTO 5
  11  WRITE(*,'(/A/)')' ** No filename specified on command line **'
      GOTO 76
  12  WRITE(*,'(/A/)')' ** Bad command line **'
      GOTO 76
C
C Open files
C
  13  WRITE(*,'(/A/)')' ** Cannot open file '//KN(1:LN)//' **'
      GOTO 76
  14  WRITE(*,'(/A/)')' ** Unsuitable file '//KN(1:LN)//' **'
      GOTO 76
  15  IF(LN.EQ.0)GOTO 11
      LN=LN+4
      LR=3
      KN(LN-3:LN)='.raw'
      OPEN(LR,FILE=KN(1:LN),STATUS='OLD',ERR=13)
      LF=2
      KN(LN-2:LN)='fcf'
      OPEN(LF,FILE=KN(1:LN),STATUS='OLD',ERR=13)
      LH=4
      KN(LN-2:LN)='hkl'
      IF(NOS.EQ.2)GOTO 16
      OPEN(LH,FILE=KN(1:LN),STATUS='OLD',IOSTAT=I)
      CLOSE(LH,STATUS='DELETE',IOSTAT=I)
C
C Remove CARRIAGECONTROL='LIST' from the following statement if
C the FORTRAN compiler objects to it
C
  16  OPEN(LH,FILE=KN(1:LN),STATUS='NEW',ERR=13)
C    +CARRIAGECONTROL='LIST')
C
C Summarize command line options
C
      WRITE(*,'(/A/)')' Command line switches set or assumed '//
     +'(must be given before filename):'
      WRITE(KR,'(A,F5.1)')'-t',TH
      KT=' '
      J=1
        DO 17 I=1,7
        IF(KR(I:I).EQ.' ')GOTO 17
        J=J+1
        KT(J:J)=KR(I:I)
  17    CONTINUE
      WRITE(*,'(A)')KT(1:J)//' I/sigma threshold for reflections '//
     +'used in parameter determination'
      WRITE(KR,'(A,F8.3)')'-u',DU
      KT=' '
      J=1
        DO 18 I=1,10
        IF(KR(I:I).EQ.' ')GOTO 18
        J=J+1
        KT(J:J)=KR(I:I)
  18    CONTINUE
      WRITE(*,'(A)')KT(1:J)//' delta(U)/lambda^2 where '//
     +'delta-U is effectively added to all U'
      WRITE(*,'(A,I1,A)')' -e',ME,' highest even order for '//
     +'spherical harmonic functions (0,2,4,6 or 8)'
      WRITE(*,'(A,I1,A)')' -o',MO,' highest odd order for '//
     +'spherical harmonic functions (1,3,5 or 7)'
C
C Read the .fcf file and extract useful information
C
      KN(LN-2:LN)='fcf'
      NS=0
      LL=0
  19  MS=0
  20  KR=' '
      READ(LF,'(A)',ERR=14,END=14)KR
      CALL LINTRM(KR,I)
      IF(MS.EQ.0)GOTO 25
C
C Decode symmetry and eliminate lattice and inversion operators
C
      IF(INDEX(KR,'y').EQ.0)GOTO 19
      N=NS+1
        DO 21 I=1,9
        SY(I,N)=0.
  21    CONTINUE
      K=INDEX(KR,'''')+1
      J=INDEX(KR,',')
      TX(1)='+'//KR(K:J-1)
      I=INDEX(KR(J+1:80),',')+J
      TX(2)='+'//KR(J+2:I-1)
      J=INDEX(KR(I+1:80),'''')+I-1
      TX(3)='+'//KR(I+2:J)
      M=1
        DO 22 I=1,3
        IF(INDEX(TX(I),'+x').NE.0)SY(M,N)=1.
        IF(INDEX(TX(I),'-x').NE.0)SY(M,N)=-1.
        IF(INDEX(TX(I),'+y').NE.0)SY(M+1,N)=1.
        IF(INDEX(TX(I),'-y').NE.0)SY(M+1,N)=-1.
        IF(INDEX(TX(I),'+z').NE.0)SY(M+2,N)=1.
        IF(INDEX(TX(I),'-z').NE.0)SY(M+2,N)=-1.
        M=M+3
  22    CONTINUE
        DO 24 I=1,NS
        U=0.
        V=0.
          DO 23 J=1,9
          U=U+ABS(SY(J,N)-SY(J,I))
          V=V+ABS(SY(J,N)+SY(J,I))
  23      CONTINUE
        IF(AMIN1(U,V).LT.0.1)GOTO 20
  24    CONTINUE
      NS=N
      GOTO 20
C
C Extract LIST code and compress symmetry operators
C
  25  I=INDEX(KR,'_shelx_refln_list_code')
      IF(I.NE.0)READ(KR(I+22:80),*,ERR=39)LL
      IF(INDEX(KR,'_symmetry_equiv_pos_as_xyz').NE.0)MS=1
      IF(INDEX(KR,'_refln_index_h').EQ.0)GOTO 20
      IF(NS.LT.1)GOTO 14
      IF(LL.NE.4.AND.LL.NE.6)GOTO 14
        DO 26 I=1,NS
        SY(1,I)=SY(1,I)+1000.*(SY(2,I)+1000.*SY(3,I))
        SY(2,I)=SY(4,I)+1000.*(SY(5,I)+1000.*SY(6,I))
        SY(3,I)=SY(7,I)+1000.*(SY(8,I)+1000.*SY(9,I))
  26    CONTINUE
C
C Read in reference intensities
C
      NF=1
      IN(NF)=-1
  27  KR=' '
      READ(LF,'(A)',ERR=27,END=32)KR
      CALL LINTRM(KR,I)
      IF(INDEX(KR,'_').EQ.0)GOTO 28
      IF(NF.EQ.1)GOTO 27
      GOTO 32
  28  IF(LL.NE.4)GOTO 29
      READ(KR,*,ERR=27,END=27)(D(I),I=1,6)
      GOTO 30
  29  READ(KR,*,ERR=27,END=27)D(1),D(2),D(3),D(5),D(6),U
      D(4)=U**2
  30  IF(AMIN1(D(4),D(5)).LT.TH*D(6))GOTO 27
      N=0
        DO 31 I=1,NS
        N=MAX0(N,INT(.5+ABS(D(1)*SY(1,I)+D(2)*SY(2,I)+D(3)*SY(3,I))))
  31    CONTINUE
      IF(N.EQ.0)GOTO 27
      NF=NF+1
      IN(NF)=N
      FD(NF)=D(4)
      IF(NF.LT.MF)GOTO 27
      WRITE(*,'(/A/)')' ** Too many reflections in .fcf file - use '
     +//'larger version of SHELXA **'
      GOTO 76
C
C Sort reference intensities (not the fastest way, but good enough)
C
  32  CLOSE(LF,IOSTAT=I)
      IF(NF.EQ.0)GOTO 14
      K=NF
  33  K=INT(REAL(K)/1.3)
      IF(K.LT.1)K=1
      IF(K.EQ.9.OR.K.EQ.10)K=11
      M=0
        DO 34 I=1,NF-K
        IF(IN(I+K).GE.IN(I))GOTO 34
        M=IN(I)
        IN(I)=IN(I+K)
        IN(I+K)=M
        T=FD(I)
        FD(I)=FD(I+K)
        FD(I+K)=T
  34    CONTINUE
      IF(M+K.GT.1)GOTO 33
C
C Average and combine equivalent reference reflections
C
      N=NF
      NF=0
      U=0.
      V=0.
        DO 36 I=1,N
        U=U+FD(I)
        V=V+1.
        IF(I.EQ.N)GOTO 35
        IF(IN(I).EQ.IN(I+1))GOTO 36
  35    NF=NF+1
        IN(NF)=IN(I)
        FD(NF)=U/V
        U=0.
        V=0.
  36    CONTINUE
C
C Read in raw reflection data and look up calculated intensity
C
      KN(LN-2:LN)='raw'
      NR=0
  37  NR=NR+1
      IF(NR.LE.MR)GOTO 39
      WRITE(*,'(/A/)')' ** Too many .raw data - use higher I/sigma '
     +//'or larger version of SHELXA **'
      GOTO 76
  38  FORMAT(3I4,2F8.2,I4,6F8.5)
  39  READ(LR,38,ERR=39,END=44)IH,IK,IL,FF(NR),Q,J,
     +XI(NR),XD(NR),YI(NR),YD(NR),ZI(NR),ZD(NR)
      IF(FF(NR).LT.TH*Q)GOTO 39
      IF(Q.LE.0.)GOTO 39
      U=REAL(IH)
      V=REAL(IK)
      W=REAL(IL)
      N=0
        DO 40 I=1,NS
        N=MAX0(N,INT(.5+ABS(U*SY(1,I)+V*SY(2,I)+W*SY(3,I))))
  40    CONTINUE
      IF(N.EQ.0)GOTO 39
      J=NF
      I=1
      GOTO 43
  41  IF(M.EQ.I)GOTO 39
      I=M
  42  M=(I+J)/2
      IF(N.GT.IN(M))GOTO 41
      J=M
  43  IF(N.LT.IN(J))GOTO 42
      IF(N.GT.IN(J))GOTO 39
      FC(NR)=FD(J)
      GOTO 37
  44  NR=NR-1
      IF(NR.LT.1)GOTO 14
C
C Derive orthogonal transformation matrix for direction cosines
C
        DO 45 I=1,6
        C(I)=0.D0
  45    CONTINUE
        DO 46 I=1,21
        B(I)=0.D0
  46    CONTINUE
        DO 49 I=1,NR
        F(1)=XI(I)**2
        F(2)=YI(I)**2
        F(3)=ZI(I)**2
        F(4)=YI(I)*ZI(I)
        F(5)=XI(I)*ZI(I)
        F(6)=XI(I)*YI(I)
        F(7)=XD(I)**2
        F(8)=YD(I)**2
        F(9)=ZD(I)**2
        F(10)=YD(I)*ZD(I)
        F(11)=XD(I)*ZD(I)
        F(12)=XD(I)*YD(I)
        L=0
          DO 48 J=1,6
          C(J)=C(J)+F(J)+F(J+6)
            DO 47 K=1,J
            L=L+1
            B(L)=B(L)+F(J)*F(K)+F(J+6)*F(K+6)
  47        CONTINUE
  48      CONTINUE
  49    CONTINUE
      CALL LSOLVE(6,21,C,B)
        DO 50 I=1,6
        D(I+6)=C(I)
  50    CONTINUE
      D(1)=SQRT(D(7))
      D(2)=0.5*D(12)/D(1)
      D(3)=0.5*D(11)/D(1)
      D(4)=SQRT(D(8)-D(2)**2)
      D(5)=(0.5*D(10)-D(2)*D(3))/D(4)
      D(6)=SQRT(D(9)-D(3)**2-D(5)**2)
C
C Orthogonalize and check direction cosines
C
      T=0.
      S=0.
      R=0.
      U=0.
      V=0.
        DO 51 I=1,NR
        U=U+FF(I)
        V=V+FC(I)
        XI(I)=XI(I)*D(1)+YI(I)*D(2)+ZI(I)*D(3)
        YI(I)=YI(I)*D(4)+ZI(I)*D(5)
        ZI(I)=ZI(I)*D(6)
        XD(I)=XD(I)*D(1)+YD(I)*D(2)+ZD(I)*D(3)
        YD(I)=YD(I)*D(4)+ZD(I)*D(5)
        ZD(I)=ZD(I)*D(6)
        P=ABS(1.-XI(I)**2-YI(I)**2-ZI(I)**2)
        Q=ABS(1.-XD(I)**2-YD(I)**2-ZD(I)**2)
        R=R+P+Q
        T=AMAX1(T,P,Q)
        S=AMAX1(S,0.5*(XI(I)*XD(I)+YI(I)*YD(I)+ZI(I)*ZD(I)+1.))
  51    CONTINUE
      R=0.5*R/REAL(NR)
      S=114.59156*ATAN2(SQRT(S),SQRT(1.-S))
      WRITE(*,52)R,T,S
  52  FORMAT(/' Mean and maximum errors in direction cosine check ',
     +'function =',2F7.3/' The mean error should not exceed 0.005,',
     +' and is usually caused by matrix'/' changes during data ',
     +'processing.  Maximum 2-theta =',F8.2,' degrees')
C
C Number of parameters and R1 before refinement
C
      CALL SPHAR(MO,ME,XI(1),YI(1),ZI(1),F,I)
      NP=I+4
      T=V/U
      U=0.
      V=0.
        DO 53 I=1,NR
        P=SQRT(T*FF(I))
        Q=SQRT(FC(I))
        U=U+ABS(P-Q)
        V=V+Q
  53    CONTINUE
      WRITE(*,54)NR,NP,U/V
  54  FORMAT(/I8,' Reflections used to determine',I3,' parameters'
     +//' R1 =',F9.4,'  before parameter refinement')
C
C Damped full-matrix least-squares refinement of absorption parameters
C Sum normal matrix and vector
C
      NN=(NP*(NP+1))/2
        DO 55 I=1,NN
        B(I)=0.D0
  55    CONTINUE
        DO 56 I=1,NP
        C(I)=0.D0
  56    CONTINUE
        DO 60 I=1,NR
        CALL SPHAR(MO,ME,XI(I),YI(I),ZI(I),E,L)
        CALL SPHAR(MO,ME,XD(I),YD(I),ZD(I),F,L)
        S=0.5*(XI(I)*XD(I)+YI(I)*YD(I)+ZI(I)*ZD(I)+1.)
          DO 57 J=1,L
          F(J)=F(J)+E(J)
  57      CONTINUE
        F(L+1)=S
        F(L+2)=1.
        F(L+3)=1./S
        F(L+4)=1./S**2
        DD=ALOG(FC(I)/FF(I))
        M=0
          DO 59 J=1,NP
          C(J)=C(J)+DD*F(J)
          DT=F(J)
            DO 58 K=1,J
            M=M+1
            B(M)=B(M)+DT*F(K)
  58        CONTINUE
  59      CONTINUE
  60    CONTINUE
      CALL LSOLVE(NP,NN,C,B)
C
C Calculate corrected intensities and R1 after refinement
C
      TM=-9.E9
      TZ=9.E9
      U=0.
      V=0.
        DO 63 I=1,NR
        CALL SPHAR(MO,ME,XI(I),YI(I),ZI(I),E,L)
        CALL SPHAR(MO,ME,XD(I),YD(I),ZD(I),F,L)
        S=0.5*(XI(I)*XD(I)+YI(I)*YD(I)+ZI(I)*ZD(I)+1.)
          DO 61 J=1,L
          F(J)=F(J)+E(J)
  61      CONTINUE
        F(L+1)=S
        F(L+2)=1.
        F(L+3)=1./S
        F(L+4)=1./S**2
        T=0.
          DO 62 K=1,NP
          T=T+C(K)*F(K)
  62      CONTINUE
        T=AMIN1(T,15.)
        TM=AMAX1(TM,T)
        TZ=AMIN1(TZ,T)
        S=SQRT(FC(I))
        U=U+ABS(SQRT(FF(I)*EXP(T))-S)
        V=V+S
  63    CONTINUE
      WRITE(*,64)U/V
  64  FORMAT(' R1 =',F9.4,'  after parameter refinement'/)
C
C Read .raw and write corrected data to new .hkl file
C
  65  FORMAT(3I4,2F8.2,I4)
  66  FORMAT(3I4,2F8.0,I4)
  67  FORMAT(I8,' Corrected reflections written to file ',A//
     +' Minimum and maximum virtual transmission =',2F12.6/)
      O=1.
      TA=-9.E9
      TB=9.E9
  68  REWIND LR
      N=0
  69  READ(LR,38,ERR=69,END=75)IH,IK,IL,T,S,M,U,P,V,Q,W,R
      IF(IABS(IH)+IABS(IK)+IABS(IL).EQ.0)GOTO 69
      U=U*D(1)+V*D(2)+W*D(3)
      V=V*D(4)+W*D(5)
      W=W*D(6)
      P=P*D(1)+Q*D(2)+R*D(3)
      Q=Q*D(4)+R*D(5)
      R=R*D(6)
      N=N+1
      CALL SPHAR(MO,ME,U,V,W,E,L)
      CALL SPHAR(MO,ME,P,Q,R,F,L)
      Q=0.5*(U*P+V*Q+W*R+1.)
        DO 70 J=1,L
        F(J)=F(J)+E(J)
  70    CONTINUE
      F(L+1)=Q
      F(L+2)=1.
      F(L+3)=1./Q
      F(L+4)=1./Q**2
      P=-157.9137*Q*DU
        DO 71 K=1,NP
        P=P+C(K)*F(K)
  71    CONTINUE
      P=EXP(AMAX1(TZ,AMIN1(P,TM)))
      TA=AMAX1(TA,P)
      TB=AMIN1(TB,P)
      Q=O*P
      T=T*Q
      S=S*Q
      IF(T.GT.99999.99)GOTO 72
      IF(S.GT.99999.99)GOTO 72
      IF(T.LT.-9999.99)GOTO 72
      IF(S.LT.-9999.99)GOTO 72
      WRITE(LH,65)IH,IK,IL,T,S,M
      GOTO 69
  72  IF(T.GT.9999999.)GOTO 73
      IF(S.GT.9999999.)GOTO 73
      IF(T.LT.-999999.)GOTO 73
      IF(S.GT.-999999.)GOTO 74
  73  REWIND LH
      O=O*0.1
      REWIND LH
      GOTO 68
  74  WRITE(LH,66)IH,IK,IL,T,S,M
      GOTO 69
  75  I=0
      T=0.
      WRITE(LH,65)I,I,I,T,T,I
      KN(LN-2:LN)='hkl'
      T=(TB/TA)**0.3333
      WRITE(*,67)N,KN(1:LN),T*TB/TA,T
  76  CLOSE(LH,IOSTAT=I)
      CLOSE(LR,IOSTAT=I)
      END
C
C -------------------------------------------------------------------
C
      SUBROUTINE LINTRM(KR,L)
C
C Replace control characters with blanks and set L to position of
C last non_blank character in a string
C
      CHARACTER*(*)KR
C
      M=LEN(KR)
      L=0
        DO 1 I=1,M
        IF(KR(I:I).LT.' ')KR(I:I)=' '
        IF(KR(I:I).NE.' ')L=I
   1    CONTINUE
      RETURN
      END
C
C -------------------------------------------------------------------
C
      SUBROUTINE SPHAR(M,N,X,Y,Z,F,NP)
C
C Generates spherical harmonic functions in terms of orthogonal
C direction cosines up to odd order M and even order N.  X,Y,Z are
C the direction cosines and the functions are returned in F(1..NP).
C The functions have not been normalized (not required for SHELXA)!
C
      REAL*8 F(81)
      XX=X**2
      YY=Y**2
      ZZ=Z**2
      XY=X*Y
      XZ=X*Z
      YZ=Y*Z
      U=XX-YY
      V=3.*XX-YY
      W=XX-3.*YY
      T=XX*(XX-6.*YY)+YY**2
      NP=0
      IF(N.LT.2)GOTO 1
C
      NP=5
      F(1)=1.5*ZZ-0.5
      F(2)=3.*XZ
      F(3)=3.*YZ
      F(4)=3.*U
      F(5)=6.*XY
      IF(N.LT.4)GOTO 1
C
      NP=14
      F(6)=ZZ*(4.375*ZZ-3.75)+0.375
      F(7)=XZ*(17.5*ZZ-7.5)
      F(8)=YZ*(17.5*ZZ-7.5)
      F(9)=(52.5*ZZ-7.5)*U
      F(10)=(105.*ZZ-15.)*XY
      F(11)=105.*XZ*W
      F(12)=105.*YZ*V
      F(13)=105.*T
      F(14)=420.*XY*U
      IF(N.LT.6)GOTO 1
C
      NP=27
      F(15)=ZZ*(ZZ*(14.4375*ZZ-19.6875)+6.5625)-0.3125
      F(16)=XZ*(ZZ*(86.625*ZZ-78.75)+13.125)
      F(17)=YZ*(ZZ*(86.625*ZZ-78.75)+13.125)
      F(18)=(ZZ*(433.125*ZZ-236.25)+13.125)*U
      F(19)=(ZZ*(866.25*ZZ-472.5)+26.25)*XY
      F(20)=XZ*(1732.5*ZZ-472.5)*W
      F(21)=YZ*(1732.5*ZZ-472.5)*V
      F(22)=(5197.5*ZZ-472.5)*T
      F(23)=XY*(20790.*ZZ-1890.)*U
      F(24)=10395.*XZ*(XX*(XX-10.*YY)+5.*YY**2)
      F(25)=10395.*YZ*(XX*(5.*XX-10.*YY)+YY**2)
      F(26)=10395.*(XX*(XX*(XX-15.)*YY+15.*YY**2)-YY**3)
      F(27)=62370.*XY*(XX*(XX-3.333333*YY)+YY**2)
      IF(N.LT.8)GOTO 1
C
      NP=44
      F(28)=(((50.2734375*ZZ-93.84375)*ZZ+54.140625)*ZZ-9.84375)*ZZ+
     +0.2734375
      Q=((402.1875*ZZ-563.0625)*ZZ+216.5625)*ZZ-19.6875
      F(29)=XZ*Q
      F(30)=YZ*Q
      Q=((2815.3125*ZZ-2815.3125)*ZZ+649.6875)*ZZ-19.6875
      F(31)=U*Q
      F(32)=2.*XY*Q
      Q=(16891.875*ZZ-11261.25)*ZZ+1299.375
      F(33)=XZ*Q*W
      F(34)=YZ*Q*V
      Q=(84459.375*ZZ-33783.75)*ZZ+1299.375
      F(35)=Q*T
      F(36)=4.*XY*Q*U
      Q=337837.5*ZZ-67567.5
      F(37)=XZ*Q*(XX*(XX-10.*YY)+5.*YY**2)
      F(38)=YZ*Q*(XX*(5.*XX-10.*YY)+YY**2)
      Q=1013512.5*ZZ-67567.5
      F(39)=Q*(XX*(XX*(XX-15.*YY)+15.*YY**2)-YY**3)
      F(40)=Q*XY*(XX*(6.*XX-20.*YY)+6.*YY**2)
      F(41)=2027025.*XZ*(XX*(XX*(XX-21.*YY)+35.*YY**2)-7.*YY**3)
      F(42)=2027025.*YZ*(XX*(XX*(7.*XX-35.*YY)+21.*YY**2)-YY**3)
      F(43)=2027025.*(XX*(XX*(XX*(XX-28.*YY)+70.*YY**2)-28.*YY**3)+
     +YY**4)
      F(44)=16216200.*XY*(XX*(XX*(XX-7.*YY)+7.*YY**2)-YY**3)
   1  IF(M.LT.1)GOTO 2
C
      NP=NP+3
      F(NP-2)=Z
      F(NP-1)=X
      F(NP)=Y
      IF(M.LT.3)GOTO 2
C
      NP=NP+7
      F(NP-6)=Z*(2.5*ZZ-1.5)
      Q=7.5*ZZ-1.5
      F(NP-5)=X*Q
      F(NP-4)=Y*Q
      F(NP-3)=15.*Z*U
      F(NP-2)=30.*X*YZ
      F(NP-1)=15.*X*W
      F(NP)=15.*Y*V
      IF(M.LT.5)GOTO 2
C
      NP=NP+11
      F(NP-10)=Z*(ZZ*(ZZ*7.875-8.75)+1.875)
      Q=ZZ*(39.375*ZZ-26.25)+1.875
      F(NP-9)=X*Q
      F(NP-8)=Y*Q
      Q=Z*(157.5*ZZ-52.5)
      F(NP-7)=Q*U
      F(NP-6)=2.*Q*XY
      Q=472.5*ZZ-52.5
      F(NP-5)=Q*X*W
      F(NP-4)=Q*Y*V
      F(NP-3)=945.*Z*T
      F(NP-2)=3780.*Z*XY*U
      F(NP-1)=945.*X*(XX*(XX-10.*YY)+5.*YY**2)
      F(NP)=945.*Y*(XX*(5.*XX-10.*YY)+YY**2)
      IF(M.LT.7)GOTO 2
C
      NP=NP+15
      F(NP-14)=Z*(ZZ*(ZZ*(ZZ*26.8125-43.3125)+19.6875)-2.1875)
      Q=ZZ*(ZZ*(ZZ*187.6875-216.5625)+59.0625)-2.1875
      F(NP-13)=X*Q
      F(NP-12)=Y*Q
      Q=Z*(ZZ*(ZZ*1126.125-866.25)+118.125)
      F(NP-11)=Q*U
      F(NP-10)=2.*XY*Q
      Q=ZZ*(ZZ*5630.625-2598.75)+118.125
      F(NP-9)=Q*X*W
      F(NP-8)=Q*Y*V
      Q=Z*(22522.5*ZZ-5197.5)
      F(NP-7)=Q*T
      F(NP-6)=4.*Q*XY*U
      Q=67567.5*ZZ-5197.5
      F(NP-5)=Q*X*(XX*(XX-10.*YY)+5.*YY**2)
      F(NP-4)=Q*Y*(XX*(5.*XX-10.*YY)+YY**2)
      F(NP-3)=135135.*Z*(XX*(XX*(XX-15.*YY)+15.*YY**2)-YY**3)
      F(NP-2)=810810.*Z*XY*(XX*(XX-3.333333*YY)+YY**2)
      F(NP-1)=135135.*X*(XX*(XX*(XX-21.*YY)+35.*YY**2)-7.*YY**3)
      F(NP)=135135.*Y*(XX*(XX*(7.*XX-35.*YY)+21.*YY**2)-YY**3)
   2  RETURN
      END
C
C -------------------------------------------------------------------
C
      SUBROUTINE LSOLVE(NP,NN,C,B)
C
C Invert lower triangular matrix B and multiply by vector C.
C NN should be NP*(NP+1) where NP is the number of l.s. parameters.
C
      REAL*8 C(NP),B(NN),DT
C
C Cholesky factorization
C
      I=0
        DO 4 N=1,NP
        I=I+1
        L=I
        M=1
        J=1
   1    IF(J.EQ.I)GOTO 3
        B(I)=B(I)*B(J)
        C(N)=C(N)-B(I)*C(M)
        M=M+1
        NI=I
        I=I+1
        J=J+1
        DT=B(I)
          DO 2 K=L,NI
          DT=DT-B(J)*B(K)
          J=J+1
   2      CONTINUE
        B(I)=DT
        GOTO 1
   3    B(I)=1./DSQRT(B(I))
        C(N)=C(N)*B(I)
   4    CONTINUE
C
C Calculate and add shifts
C
      DT=C(M)
   5  C(M)=DT*B(I)
      I=I-M
      M=M-1
      IF(M.LT.1)GOTO 7
      DT=C(M)
      K=I+M
        DO 6 N=M+1,NP
        DT=DT-C(N)*B(K)
        K=K+N
   6    CONTINUE
      GOTO 5
   7  RETURN
      END
