C
      PROGRAM CIFTAB
C
C CIFTAB Release 97-2.  Copyright(C) George M. Sheldrick 1993-7
C
C Preparation of tables for publication etc. from .cif and .fcf
C CIF format output files written by SHELXL-97.  This is not a
C general CIF utility and may or may not work with CIF files
C written by other programs.  CIFTAB reads a format definition
C file, which users are encouraged to adapt to their individual
C requirements, eg. to produce tables for different journals.
C
      CHARACTER*1 CR,ESC,AMP,OPT,KS,KZ
      CHARACTER*7 SYO(512)
      CHARACTER*40 SYM(192),FMT,CDN(500),CSS(40),DATB,MC
      CHARACTER*80 IS,IR,IW,CDS(500),CSV(40),CIFDIR,COD
      INTEGER LDS(500),LSS(40),NCOL(40),MLT(40),MSG(40),LSV(40),
     +IG(30),IH(800),IK(800),IL(800),IO(800),IC(800),IE(800)
      COMMON LDS,LSS,LSV,NCOL,MLT,MSG,NCD,LS,NSS,LB,LC,LO,LU,MX,LR
      COMMON/CBUF/IR,IS,IW,CDS,CDN,CSS,CSV,DATB,CR,ESC,AMP,FMT,MC,
     +CIFDIR,COD
      COMMON/CSYM/SYM,SYO
      COMMON/ISYM/NSY
      COMMON/CSFT/IG,IH,IK,IL,IO,IC,IE
C
C Possibly system-dependent constants.  NOS is 1 for DOS, 2 for VMS and
C 3 for UNIX.  FMT is a run-time format for requesting an answer on the
C same line.  CIFDIR is the name of the directory to be searched if the
C format files are not in the current directory.  The filename stem may
C be read from the command line if a suitable utility is available;
C otherwise it may be initialized as a blank string, in which case it
C will be prompted for.
C
C Comment out the following unless MSDOS or WINDOWS:
C
C     NOS=1
C     CIFDIR='C:\EXE\'
C     IR=' '
C     CALL GETCL(IR)
C
C Comment out the following unless VMS; note that it is also ESSENTIAL
C 'uncomment' one OPEN statement in subroutine CIFOUT for VMS !
C
C     INTEGER CLI$GET_VALUE
C     CIFDIR='[SHELX]'
C     NOS=2
C     IR=' '
C     I=CLI$GET_VALUE('$LINE',IR)
C
C Comment out the following unless UNIX:
C
      NOS=3
      CIFDIR='/usr/local/bin/'
      IR=' '
      CALL GETARG(IARGC(),IR)
C
C Remove ",$" from the following if the compiler objects to it (it
C allows the cursor to stay on the same line for user input, but
C this is not essential).
C
      FMT='(/'' '',A,'' ['',A,'']: '',$)'
C
C The following may need changing if the internal collating sequence
C is not ASCII.  ESC and AMP are the ASCII codes for carriage return,
C escape and ampersand resp.  CR should be set to CHAR(13) to write DOS
C format files from a UNIX system, otherwise to CHAR(32). The structure
C factor tables are always written in local format.  LU is used to
C convert upper to lower case.
C
      WRITE(*,'(//A/A)')' CIFTAB - Tables from shelxl CIF files - '//
     +'Release 97-3',' Copyright(c) George Sheldrick 1993-97'
      ESC=CHAR(27)
      AMP=CHAR(38)
      CR=CHAR(13)
      LU=ICHAR('a')-ICHAR('A')
C
C The rest of the program is unlikely to need changing on porting to
C different systems, except that READONLY should be removed from
C the OPEN statement in subroutine TABLES and CARRIAGECONTROL='LIST'
C should be removed from the OPEN statement in subroutine CIFOUT if
C the compiler objects to it.  LC, LO and LR are I/O unit numbers.
C
      LC=1
      LO=2
      LR=3
      OPT='S'
      MX=1
      L=0
      COD='?'
      MC='?'
      L=80
   1  IF(IR(L:L).LT.' ')IR(L:L)=' '
      IF(IR(L:L).NE.' ')GOTO 2
      L=L-1
      IF(L.EQ.0)GOTO 8
      GOTO 1
   2  J=L
      N=L-5
   3  IF(IR(J:J).LT.' ')IR(J:J)=' '
      IF(IR(J:J).EQ.' ')GOTO 4
      J=J-1
      IF(J.GT.0)GOTO 3
   4  IF(J.GT.N)GOTO 5
      IF(JCMP(IR(N:L),'CIFTAB').EQ.0)GOTO 8
   5  COD=IR(J+1:L)
      MC=COD(1:40)
   6  CLOSE(LR,IOSTAT=I)
      CLOSE(LC,IOSTAT=I)
      CLOSE(LO,IOSTAT=I)
C
C Main menu - request option
C
      KS='Y'
      L=INDEX(COD,' ')-1
      IF(OPT.EQ.'F')OPT='Q'
      IF(OPT.EQ.'T')OPT='F'
      IF(OPT.EQ.'N')OPT='T'
      IF(OPT.EQ.'D')OPT='T'
      IF(OPT.EQ.'C')OPT='N'
      IF(OPT.EQ.'R')OPT='C'
      IF(OPT.EQ.'S')OPT='R'
      IF(OPT.EQ.'?')OPT='S'
      J=1
        DO 7 I=1,40
        IF(MC(I:I).GT.' ')J=I
   7    CONTINUE
      WRITE(*,13)COD(1:L),MC(1:J),MX
      CALL GETANS('Option',OPT)
      IF(OPT.GE.'a')OPT=CHAR(ICHAR(OPT)-LU)
      IF(OPT.NE.'S')GOTO 9
   8  COD='?'
      CALL GETANS('Input new structure code (filename stem)',COD)
      MC=COD(1:40)
      GOTO 6
   9  IF(OPT.NE.'C')GOTO 10
      CALL GETANS('Input new compound name for tables',MC)
      GOTO 6
  10  IF(OPT.NE.'N')GOTO 12
      IR=' '
      WRITE(IR,'(1X,I9)',ERR=6)MX
      J=0
        DO 11 I=1,10
        IF(IR(I:I).EQ.' ')GOTO 11
        J=J+1
        IR(J:J)=IR(I:I)
        IR(I:I)=' '
  11    CONTINUE
      CALL GETANS('Input number of next table (for title)',IR)
      READ(IR,*,ERR=10)MX
      GOTO 6
  12  IF(OPT.NE.'D')GOTO 14
      CALL GETANS('Default format file directory',CIFDIR)
      GOTO 6
  13  FORMAT(//' Structure Code: ',A//' [S] Change structure code'/
     +' [R] Use another CIF file to resolve ? items'/
     +' [C] Set compound name for tables (currently ''',A,''')'/
     +' [N] Set next table number (currently ',I3,')'/
     +' [D] Set default directory for format files'/
     +' [T] Crystal/atom tables from .cif'/
     +' [F] Structure factor tables from .fcf'/' [Q] Quit')
C
C Resolve simple '?' items by reference to another .cif file
C
  14  IF(OPT.NE.'R')GOTO 46
      IS=COD(1:L)//'.pcf'
      CALL GETANS('Name of reference file',IS)
      CALL CIFIN(IS,KS)
      IF(KS.EQ.'N')GOTO 6
      IS=COD(1:L)//'.cif'
      CALL GETANS('Name of CIF file to be modified',IS)
      L=INDEX(IS,' ')-1
      IF(L.LE.0)GOTO 20
      OPEN(LR,FILE=IS(1:L),STATUS='OLD',ERR=20)
      OPEN(LO,STATUS='SCRATCH',FORM='UNFORMATTED',ERR=21)
  15  READ(LR,'(A)',END=17,ERR=17)IR
        DO 16 I=1,80
        IF(IR(I:I).LT.' ')IR(I:I)=' '
  16    CONTINUE
      WRITE(LO)IR
      GOTO 15
  17  IF(NOS.NE.2)GOTO 18
      CLOSE(LR,IOSTAT=I)
      GOTO 19
  18  CLOSE(LR,STATUS='DELETE',IOSTAT=I)
  19  OPEN(LR,FILE=IS(1:L),STATUS='NEW',ERR=20)
      REWIND LO
      GOTO 23
  20  WRITE(*,'(/A)')' ** cannot open CIF file **'
      GOTO 6
  21  WRITE(*,'(/A)')' ** cannot open scratch file **'
      GOTO 6
C
C Select appropriate data_ set
C
  22  WRITE(*,'(/A)')' ** (Next) data_ not found before eof **'
      GOTO 6
  23  READ(LO,END=22)IS
      LS=0
        DO 24 I=1,80
        IF(IS(I:I).LT.' ')IS(I:I)=' '
        IF(IS(I:I).GE.'A'.AND.IS(I:I).LE.'Z')IS(I:I)=
     +  CHAR(ICHAR(IS(I:I))+LU)
        IF(IS(I:I).NE.' ')LS=I
  24    CONTINUE
      WRITE(LR,'(A)')IS(1:LS)//CR
      K=JIND(IS(1:LS),'data_')
      IF(K.EQ.0)GOTO 23
  25  KZ='Y'
      CALL GETANS('Select '//IS(K:LS)//' ? (Y or N)',KZ)
      IF(KZ.GE.'a')KZ=CHAR(ICHAR(KZ)-LU)
      IF(KZ.EQ.'N')GOTO 23
      IF(KZ.NE.'Y')GOTO 25
      IXT=0
      IFL=0
      GOTO 27
C
C Copy back CIF file, identify non-looped '?' items
C
  26  WRITE(LR,'(A)')IS(1:L)//CR
  27  READ(LO,END=6)IS
      IF(IS(1:1).EQ.';')IXT=1-IXT
      LS=0
      K=0
      J=0
      M=0
      N=0
      L=1
        DO 28 I=1,80
        IF(IS(I:I).LT.' ')IS(I:I)=' '
        KZ=IS(I:I)
        IF(KZ.EQ.'''')M=1-M
        IF(KZ.EQ.'_'.AND.M.EQ.0.AND.J.EQ.0)J=I
        IF(KZ.EQ.'?'.AND.M.EQ.0)N=I
        IR(I:I)=KZ
        IF(KZ.GE.'A'.AND.KZ.LE.'Z')IR(I:I)=CHAR(ICHAR(KZ)+LU)
        IF(KZ.EQ.' ')GOTO 28
        L=I
        K=K+1
  28    CONTINUE
      IF(IXT.EQ.0)GOTO 29
      IF(K.NE.1)GOTO 26
      GOTO 30
  29  IF(JIND(IS,'loop_').NE.0)IFL=1
      IF(J.EQ.0)GOTO 30
      IF(IFL.LT.0)IFL=0
      LS=INDEX(IR(J+1:80),' ')
      IW=IR(J:J+LS-1)
      GOTO 31
  30  IFL=-IABS(IFL)
  31  IF(N.EQ.0)GOTO 26
      IF(IFL.NE.0)GOTO 26
C
C Update '?' items if possible
C
        DO 32 I=1,NCD
        IF(JCMP(IW,CDN(I)).EQ.0)GOTO 33
  32    CONTINUE
      GOTO 26
  33  IF(LDS(I).EQ.0)GOTO 35
      IW=IS(N+1:80)
      IS(N:80)=CDS(I)(1:IABS(LDS(I)))//IW
      L=0
        DO 34 I=N,80
        IF(IS(I:I).NE.' ')L=I
  34    CONTINUE
      IF(INDEX(IS(N:80),' ').EQ.L-N+2)GOTO 26
      WRITE(LR,'(A)')IS(1:N-1)//''''//IS(N:L)//''''//CR
      GOTO 27
  35  IF(J.NE.0)WRITE(LR,'(A)')IS(1:N-1)//CR
      IF(IXT.EQ.0)WRITE(LR,'(A)')';'//CR
      REWIND LC
  36  CALL NEXT
      IF(JCMP(IS,DATB).NE.0)GOTO 36
  37  CALL NEXT
      IF(JCMP(IS,IW).NE.0)GOTO 37
  38  READ(LC,'(A)')IS
        DO 39 I=1,80
        IF(IS(I:I).LT.' ')IS(I:I)=' '
  39    CONTINUE
      IF(IS(1:1).NE.';')GOTO 38
        DO 40 I=2,80
        IF(IS(I:I).NE.' ')GOTO 41
  40    CONTINUE
      GOTO 44
  41  IS(1:1)=' '
  42  L=1
        DO 43 I=1,80
        IF(IS(I:I).NE.' ')L=I
  43    CONTINUE
      WRITE(LR,'(A)')IS(1:L)//CR
  44  READ(LC,'(A)')IS
        DO 45 I=1,80
        IF(IS(I:I).LT.' ')IS(I:I)=' '
  45    CONTINUE
      IF(IS(1:1).NE.';')GOTO 42
      IF(IXT.EQ.0)WRITE(LR,'(A)')';'//CR
      GOTO 27
C
C Prepare tables of crystal data, atoms, bond lengths and angles etc.
C
  46  IF(OPT.NE.'T')GOTO 47
      CALL TABLES(KS,NOS)
      GOTO 6
C
C Print structure factor tables
C
  47  IF(OPT.NE.'F')GOTO 51
      IS=COD(1:L)//'.fcf'
      CALL GETANS('Name of CIF structure factor file',IS)
      L=INDEX(IS,' ')-1
      IF(L.LT.1)GOTO 48
      CLOSE(LC,IOSTAT=I)
      OPEN(LC,FILE=IS(1:L),STATUS='OLD',ERR=48)
      L=INDEX(COD,' ')-1
      IS=COD(1:L)//'.sft'
      CALL CIFOUT(LO,IS,KS,NOS)
      IF(KS.NE.'N')CALL CIFSFT(KS)
      GOTO 6
  48  L=INDEX(IS,' ')-1
      WRITE(*,'(/A)')' ** Cannot open file '//IS(1:L)//' **'
      GOTO 6
  49  WRITE(*,'(/A)')' ** Unknown option **'
      GOTO 6
C
C Finish off
C
  51  CONTINUE
      IF(OPT.NE.'Q')GOTO 49
      END
C
C -------------------------------------------------------------------
C
      SUBROUTINE TABLES(KS,NOS)
C
C Prepare tables of crystal data, atoms, bond lengths and angles etc.
C
      CHARACTER*1 CR,ESC,AMP,KS,KZ
      CHARACTER*2 KK
      CHARACTER*7 SYO(512)
      CHARACTER*40 SYM(192),FMT,CDN(500),CSS(40),DATB,MC
      CHARACTER*80 IS,IR,IW,CDS(500),CSV(40),CIFDIR,COD
      INTEGER LDS(500),LSS(40),NCOL(40),MLT(40),MSG(40),LSV(40),NS(50),
     +IG(30),IH(800),IK(800),IL(800),IO(800),IC(800),IE(800),IP(4)
      COMMON LDS,LSS,LSV,NCOL,MLT,MSG,NCD,LS,NSS,LB,LC,LO,LU,MX,LR
      COMMON/CBUF/IR,IS,IW,CDS,CDN,CSS,CSV,DATB,CR,ESC,AMP,FMT,MC,
     +CIFDIR,COD
      COMMON/CSYM/SYM,SYO
      COMMON/ISYM/NSY
      COMMON/CSFT/IG,IH,IK,IL,IO,IC,IE
   1  FORMAT(A)
C
      L=INDEX(COD,' ')-1
      IS=COD(1:L)//'.cif'
      CALL GETANS('Name of CIF file',IS)
      CALL CIFIN(IS,KS)
      IF(KS.EQ.'N')GOTO 109
      IS=COD(1:L)//'.tex'
      CALL CIFOUT(LO,IS,KS,NOS)
      IF(KS.EQ.'N')GOTO 109
      IS='def'
      WRITE(*,'(/A/A/A)')' The format definition file should be '//
     +'specified by means of the extensions',' ''rta'' (Rich Text '//
     +'Format for input to MSWord / Angstroms), ''rtm'' (RTF / pm),',
     +' ''def'' (plain text) or other extensions for local versions.'
      CALL GETANS('Filename extension for ciftab.??? format '//
     +'definition file',IS)
      L=INDEX(IS,' ')-1
        DO 2 I=1,L
        KZ=IS(I:I)
        IF(KZ.LE.'Z'.AND.KZ.GE.'A')IS(I:I)=CHAR(ICHAR(KZ)+LU)
   2    CONTINUE
      OPEN(LR,FILE='ciftab.'//IS(1:L),STATUS='OLD',ERR=3)
      GOTO 6
   3  K=INDEX(CIFDIR,' ')-1
C
C READONLY may have to be changed on the next statement for some
C systems.  It enables a 'read-only' file to be opened for reading.
C
      OPEN(LR,FILE=CIFDIR(1:K)//'ciftab.'//IS(1:L),STATUS='OLD',
     +READONLY,ERR=5)
      GOTO 6
   4  WRITE(*,'(/A)')' ** Cannot open file **'
      GOTO 108
   5  WRITE(*,'(/A)')' ** Cannot open file '//CIFDIR(1:K)//
     +'ciftab.'//IS(1:L)//' **'
      IS='?'
      CALL GETANS('Enter FULL name of format file:',IS)
      L=INDEX(IS,' ')-1
      IF(L.LT.1)GOTO 4
      OPEN(LR,FILE=IS(1:L),STATUS='OLD',ERR=4)
C
C Initialize tables
C
   6  IXT=0
      IRT=0
      IDT=0
      NSO=0
      IRH=-1
      IBR=1
      IFL=1
C
C Analyse special directives
C
      NBL=0
   7  LOOP=0
      NSS=0
      NT=0
   8  IR=' '
      READ(LR,1,END=109)IR
        DO 9 I=1,80
        IF(IR(I:I).LT.' ')IR(I:I)=' '
   9    CONTINUE
      IF(IR(1:1).NE.'?')GOTO 14
  10  M=2
        DO 11 I=1,80
        IF(IR(I:I).NE.' ')M=I
  11    CONTINUE
      KZ='Y'
      IF(IR(2:9).EQ.'Selected')KZ='N'
      CALL GETANS(IR(2:M),KZ)
      IF(KZ.GE.'a')KZ=CHAR(ICHAR(KZ)-LU)
      IF(KZ.EQ.'Y')GOTO 8
  12  READ(LR,1,END=109)IR
        DO 13 I=1,80
        IF(IR(I:I).LT.' ')IR(I:I)=' '
  13    CONTINUE
      IF(IR(1:1).NE.'?')GOTO 12
      GOTO 10
  14  IF(IR(1:1).NE.'$')GOTO 27
        DO 15 I=2,80
        IF(IR(I:I).GE.'A'.AND.IR(I:I).LE.'Z')IR(I:I)=
     +  CHAR(ICHAR(IR(I:I))+LU)
  15    CONTINUE
      IF(INDEX(IR,'rtf').NE.0)IRT=1
      IF(INDEX(IR,'xtext').NE.0)IXT=1
      IF(INDEX(IR,'deutsch').NE.0)IDT=1
      IF(INDEX(IR,'h=none').NE.0)IRH=-1
      IF(INDEX(IR,'h=free').NE.0)IRH=0
      IF(INDEX(IR,'h=all').NE.0)IRH=1
      IF(INDEX(IR,'h=only').NE.0)IRH=2
      IF(INDEX(IR,'brack').NE.0)IBR=1
      IF(INDEX(IR,'nobrack').NE.0)IBR=0
      IF(INDEX(IR,'flag').NE.0)IFL=1
      IF(INDEX(IR,'noflag').NE.0)IFL=0
C
C Output symmetry operators
C
      M=INDEX(IR,'symops')+6
      IF(M.EQ.6)GOTO 8
      CALL RINT(M,NJ)
      M=NJ-1
      IR=' '
        DO 26 I=1,NSO
        READ(SYO(I),'(I3,1X,3I1)')IP
        IF(M.LT.50)GOTO 16
        WRITE(LO,'(A)')IR(1:M)//CR
        IF(IRT.NE.0)WRITE(LO,'(A)')' '//CHAR(92)//'par'
        IR=' '
        M=NJ-1
  16    M=M+1
        IR(M:M)='#'
        WRITE(IW,'(I4)')I
          DO 17 K=1,4
          IF(IW(K:K).EQ.' ')GOTO 17
          M=M+1
          IR(M:M)=IW(K:K)
  17      CONTINUE
        M=M+1
        IW(1:40)=SYM(IP(1))
        K=2
          DO 25 L=1,40
          IF(L.EQ.40)GOTO 18
          IF(IW(L:L).NE.',')GOTO 24
  18      IF(IR(M-1:M-1).EQ.'/')GOTO 21
          J=IP(K)
          IF(J.EQ.5)GOTO 23
          IF(IR(M:M).GT.'9'.OR.IR(M:M).LT.'1')GOTO 19
          READ(IR(M-1:M),'(I2)')J
          J=J+IP(K)
          M=M-2
  19      WRITE(KK,'(I2)')IABS(J-5)
          IR(M+1:M+1)='+'
          IF(J.LT.5)IR(M+1:M+1)='-'
          M=M+2
          IF(KK(1:1).EQ.' ')GOTO 20
          IR(M:M)=KK(1:1)
          M=M+1
  20      IR(M:M)=KK(2:2)
          GOTO 23
  21      READ(IR(M-2:M),'(I1,1X,I1)')J,N
          IF(IR(M-3:M-3).EQ.'-')J=-J
          J=J+N*(IP(K)-5)
          IR(M-3:M-3)='+'
          IF(J.LT.0)IR(M-3:M-3)='-'
          J=IABS(J)
          IF(J.LT.10)GOTO 22
          M=M+1
          WRITE(IR(M-3:M),'(I2,A1,I1)')J,'/',N
          GOTO 23
  22      WRITE(IR(M-2:M),'(I1,A1,I1)')J,'/',N
  23      K=K+1
  24      IF(IW(L:L).EQ.' ')GOTO 25
          M=M+1
          IR(M:M)=IW(L:L)
  25      CONTINUE
        M=M+4
  26    CONTINUE
      IF(M.GT.0)WRITE(LO,'(A)')IR(1:M)//CR
      IF(IRT.NE.0)WRITE(LO,'(A)')' '//CHAR(92)//'par'
      GOTO 8
C
C Construct request list for one text line
C
  27  IF(INDEX(IR,'____').EQ.0)GOTO 29
      M=1
        DO 28 I=1,80
        IF(IR(I:I).NE.' ')M=I
  28    CONTINUE
      WRITE(LO,1)IR(1:M)//CR
      GOTO 8
  29  IF(NBL.EQ.0)GOTO 31
      NBL=0
        DO 30 I=1,80
        IF(IR(I:I).NE.' ')GOTO 31
  30    CONTINUE
      GOTO 8
  31  MT=0
      I=0
      IF(JCMP(IR,'loop_').NE.0)GOTO 32
      LOOP=1
      I=5
  32  I=I+1
      IF(I.GT.80)GOTO 45
      IF(IR(I:I).NE.'_')GOTO 39
  33  IF(I.EQ.80)GOTO 8
      IF(IR(I+1:I+1).EQ.' ')GOTO 8
      NT=NT+1
      NSS=NSS+1
      IF(NSS.GT.40)GOTO 107
      CSS(NSS)=' '
      LSS(NSS)=0
      LSV(NSS)=-1
      NCOL(NSS)=0
      MLT(NSS)=0
      MSG(NSS)=20
      MT=0
      K=0
      M=1
      I=I-1
  34  I=I+1
      IF(I.GT.80)GOTO 107
      IF(IR(I:I).EQ.'>')GOTO 35
      IF(IR(I:I).EQ.'<')GOTO 36
      IF(IR(I:I).EQ.':')GOTO 37
      IF(IR(I:I).EQ.'=')GOTO 38
      IF(IR(I:I).EQ.' ')GOTO 32
      K=K+1
      CSS(NSS)(K:K)=IR(I:I)
      LSS(NSS)=K
      GOTO 34
  35  M=-1
  36  CALL RINT(I,N)
      NCOL(NSS)=M*N
      IF(I.GT.80)GOTO 32
      IF(IR(I:I).EQ.'=')GOTO 38
      IF(IR(I:I).NE.':')GOTO 32
  37  CALL RINT(I,MLT(NSS))
      LSV(NSS)=1
      IF(IR(I:I).EQ.'>')GOTO 35
      IF(IR(I:I).EQ.'<')GOTO 36
      IF(IR(I:I).NE.'=')GOTO 32
  38  CALL RINT(I,MSG(NSS))
      IF(IR(I:I).EQ.'>')GOTO 35
      IF(IR(I:I).EQ.'<')GOTO 36
      IF(IR(I:I).EQ.':')GOTO 37
      GOTO 32
  39  NSS=NSS+1
      IF(NSS.GT.40)GOTO 107
      CSS(NSS)=' '
      LSS(NSS)=-1
      CSV(NSS)=' '
      NCOL(NSS)=0
      MLT(NSS)=0
  40  IF(IR(I:I).NE.CHAR(92))GOTO 41
      CALL RINT(I,N)
      IR(I:I)=CHAR(N)
  41  IF(MT.GE.128)GOTO 42
      MT=MT+1
      CSV(NSS)(MT:MT)=IR(I:I)
      LSV(NSS)=-MT
  42  IF(I.GE.80)GOTO 44
      I=I+1
      IF(IR(I:I).EQ.'_')GOTO 33
      GOTO 40
  43  MT=MT-1
      LSV(NSS)=-MT
  44  IF(CSV(NSS)(MT:MT).NE.' ')GOTO 45
      IF(MT.GT.1)GOTO 43
      NSS=NSS-1
C
C Search list for non-looped CIF data names
C
  45  IF(LOOP.NE.0)GOTO 73
      NBL=0
        DO 72 M=1,NSS
        IF(LSS(M).LT.0)GOTO 72
        IF(JCMP(CSS(M)(2:6),'tabno').NE.0)GOTO 47
        WRITE(IS,'(I8)')MX
        J=0
          DO 46 I=1,8
          IF(IS(I:I).EQ.' ')GOTO 46
          J=J+1
          CDS(2)(J:J)=IS(I:I)
  46      CONTINUE
        LDS(2)=J
        MX=MX+1
  47      DO 48 N=1,NCD
          IF(JCMP(CDN(N),CSS(M)).EQ.0)GOTO 49
  48      CONTINUE
        IF(JCMP(CSS(M)(12:30),'abs_structure_flack').EQ.0)GOTO 50
        IF(JCMP(CSS(M)(8:28),'absorp_correction_t_m').EQ.0)GOTO 50
        IF(JCMP(CSS(M)(12:26),'extinction_coef').EQ.0)GOTO 50
        IF(JIND(CSS(M),'_theta_full').NE.0)GOTO 50
        WRITE(*,'(/A)')' ** '//CSS(M)(1:LSS(M))//' not found **'
        GOTO 108
C
C Deal with special cases
C
  49    IF(CDS(N)(1:4).NE.'?   ')GOTO 51
        IF(JCMP(CSS(M)(12:26),'extinction_coef').EQ.0)GOTO 50
        IF(JIND(CSS(M),'_theta_full').NE.0)GOTO 50
        IF(JCMP(CSS(M)(8:27),'absorpt_correction_t').NE.0)GOTO 51
  50    NBL=1
        GOTO 7
  51    IW(1:40)=CDN(N)
        IS=CDS(N)
        IR=IS
        LS=LDS(N)
        L=LS
        IF(IXT.EQ.0)GOTO 60
        IF(JCMP(IW,'_symmetry_space_group_name_h-m').NE.0)
     +  GOTO 56
        LS=0
        I=0
  52    I=I+1
        IF(I.GT.L)GOTO 71
        IF(IR(I:I).EQ.' ')GOTO 52
        IF(IR(I:I).NE.'-')GOTO 53
        LS=LS+7
        IS(LS-6:LS)=AMP//'^-'//AMP//'0'//AMP//'B'
        GOTO 52
  53    IF(IR(I:I).NE.')')GOTO 54
        LS=LS+2
        IS(LS-1:LS)=AMP//'0'
        GOTO 52
  54    IF(IR(I:I).NE.'(')GOTO 55
        LS=LS+2
        IS(LS-1:LS)=AMP//'v'
        GOTO 52
  55    LS=LS+1
        IS(LS:LS)=IR(I:I)
        GOTO 52
  56    IF(JCMP(IW,'_chemical_formula_sum').NE.0)GOTO 60
        LS=0
        K=0
        I=0
  57    I=I+1
        IF(I.GT.L)GOTO 71
        IF(IR(I:I).NE.' ')GOTO 58
        IF(K.EQ.0)GOTO 57
        LS=LS+2
        IS(LS-1:LS)=AMP//'0'
        K=0
        GOTO 57
  58    IF(K.EQ.1)GOTO 59
        IF(IR(I:I).GT.'9'.OR.IR(I:I).LT.'0')GOTO 59
        LS=LS+2
        IS(LS-1:LS)=AMP//'v'
        K=1
  59    LS=LS+1
        IS(LS:LS)=IR(I:I)
        GOTO 57
  60    IF(JCMP(IW(8:30),'absorpt_correction_type').NE.0)GOTO 63
        KZ=IS(1:1)
        IF(KZ.GE.'a')IS(1:1)=CHAR(ICHAR(KZ)-LU)
        IF(JCMP(IS,'multi-scan').NE.0)GOTO 61
        IS(1:31)='Semi-empirical from equivalents'
        LS=31
        IF(IDT.EQ.0)GOTO 71
        IS(1:32)='Semi-empirisch aus Aequivalenten'
        LS=32
        IF(IXT.NE.0)IS(20:21)=AMP//'A'
        GOTO 71
  61    IF(JCMP(IS,'Empirical')+JCMP(IS,'psi-scan').NE.0)GOTO 62
        IS(1:29)='Semi-empirical from psi-scans'
        LS=29
        IF(IXT.NE.0)IS(21:23)=AMP//'Gu'
        IF(IDT.EQ.0)GOTO 71
        IS(1:28)='Semi-empirisch aus psi-scans'
        LS=28
        IF(IXT.NE.0)IS(20:22)=AMP//'Gu'
        GOTO 71
  62    IF(JCMP(IS,'Refdelf').NE.0)GOTO 65
        IS(1:18)='Empirical (SHELXA)'
        LS=18
        IF(IDT.EQ.0)GOTO 71
        IS(7:19)='sche (SHELXA)'
        LS=19
        GOTO 71
  63    IF(JCMP(IW(9:22),'ls_matrix_type').NE.0)GOTO 65
        IF(JCMP(IS,'full').NE.0)GOTO 71
        IF(JCMP(IS(5:9),'cycle').NE.0)GOTO 64
        IS='Full-matrix-block'
        LS=17
        IF(IDT.EQ.0)GOTO 71
        IS='Vollmatrix-Block'
        LS=16
        GOTO 71
  64    IF(LS.NE.4)GOTO 71
        IS='Full-matrix'
        LS=11
        IF(IDT.EQ.0)GOTO 71
        IS='Vollmatrix'
        LS=10
        GOTO 71
  65    IF(JCMP(IW,'_symmetry_cell_setting').NE.0)GOTO 70
        KZ=IS(1:1)
        IF(KZ.GE.'a')IS(1:1)=CHAR(ICHAR(KZ)-LU)
        IF(IDT.EQ.0)GOTO 70
        IF(JCMP(IS,'Tric').NE.0)GOTO 66
        IS(4:7)='klin'
        LS=7
        GOTO 71
  66    IF(JCMP(IS,'Mono').NE.0)GOTO 67
        IS(5:8)='klin'
        LS=8
        GOTO 71
  67    IF(JCMP(IS,'Orth').NE.0)GOTO 68
        IS(12:14)='sch'
        LS=14
        GOTO 71
  68    IF(JCMP(IS,'Rhom').NE.0)GOTO 69
        IS(7:13)='edrisch'
        LS=13
        GOTO 71
  69    IF(JCMP(IS,'Cubi').NE.0)GOTO 70
        IS='Kubisch'
        LS=7
  70    IF(JCMP(IW,'_cell_angle').NE.0)GOTO 71
        K=INDEX(IS,'0.00 ')
        IF(K.NE.0)LS=K
  71    LSV(M)=ISIGN(MAX0(1,LS),LSV(M))
        CSV(M)=IS
  72    CONTINUE
      CALL LINOUT
      GOTO 7
C
C Seach name.cif for looped CIF data names
C
  73  REWIND LC
  74  CALL NEXT
      IF(LS.EQ.0)GOTO 74
      IF(JCMP(IS,DATB).NE.0)GOTO 74
  75  CALL NEXT
      IF(LS.LT.0)GOTO 106
      IF(LS.EQ.0)GOTO 75
      IF(JCMP(IS,'data_').EQ.0)GOTO 106
      IF(JCMP(IS,'loop_').NE.0)GOTO 75
        DO 76 I=1,50
        NS(I)=0
  76    CONTINUE
      NHIT=0
      NFLG=0
      NHFL=0
      NRFL=0
      NL=0
        DO 77 I=1,4
        IP(I)=0
  77    CONTINUE
  78  CALL NEXT
      IF(LS.LT.0)GOTO 81
      IF(IS(1:1).NE.'_')GOTO 81
      NL=NL+1
      IF(JIND(IS(1:LS),'_publ_flag').NE.0)NFLG=NL
      IF(JCMP(IS,'_atom_site_type_symbol').EQ.0)NHFL=NL
      IF(JCMP(IS,'_atom_site_refinement_flags').EQ.0)NRFL=NL
      IF(JIND(IS,'_site_symmetry_mult').NE.0)GOTO 79
      M=JIND(IS,'_site_symmetry_')+15
      IF(M.EQ.15)GOTO 79
      IF(JCMP(IS(M:M),'D').EQ.0)IS(M:M)='1'
      IF(JCMP(IS(M:M),'H').EQ.0)IS(M:M)='2'
      IF(JCMP(IS(M:M),'A').EQ.0)IS(M:M)='3'
      READ(IS(M:M),'(I1)')M
      IF(M.GT.4)GOTO 79
      IP(M)=NL
  79    DO 80 M=1,NSS
        IF(LSS(M).NE.LS)GOTO 80
        IF(JCMP(IS,CSS(M)(1:LS)).NE.0)GOTO 80
        NS(NL)=M
        NHIT=NHIT+1
  80    CONTINUE
      GOTO 78
C
C Extract looped CIF items from name.cif
C
  81  IF(NHIT.EQ.0)GOTO 75
      IF(NHIT.NE.NT)GOTO 106
  82  ISKP=0
      IHSK=0
      IRSK=0
      LSO=NSO
      M=0
  83  M=M+1
      IF(NHFL.NE.M)GOTO 84
      IF(IS(1:LS).EQ.'H'.OR.IS(1:LS).EQ.'h')IHSK=1
  84  IF(NRFL.NE.M)GOTO 85
      IF(JIND(IS(1:LS),'R')+JIND(IS(1:LS),'G').NE.0)IRSK=1
  85  IF(NFLG.NE.M)GOTO 86
      ISKP=IFL
      IF(IS(1:1).EQ.'y'.OR.IS(1:1).EQ.'Y')ISKP=0
  86    DO 94 I=1,4
        IF(M.NE.IP(I))GOTO 94
        IF(IS(1:1).EQ.'.')GOTO 95
        N=0
        IF(LS.GT.3)GOTO 87
        LS=LS+4
        IS(LS-3:LS)='_555'
  87    N=N+1
        IF(N.GT.NSO)GOTO 88
        IF(LS.EQ.6.AND.SYO(N)(1:1).NE.' ')GOTO 87
        IF(LS.EQ.5.AND.SYO(N)(1:2).NE.'  ')GOTO 87
        IF(JCMP(IS,SYO(N)(8-LS:7)).NE.0)GOTO 87
        GOTO 89
  88    NSO=MIN0(N,512)
        SYO(N)=' '
        SYO(N)(8-LS:7)=IS(1:LS)
  89    WRITE(IS,'(A12,I1)')'_site_label_',I
          DO 90 K=1,NSS
          IF(JIND(CSS(K),IS(1:13)).NE.0)GOTO 92
  90      CONTINUE
        IF(I.EQ.1)IS(13:13)='D'
        IF(I.EQ.2)IS(13:13)='H'
        IF(I.EQ.3)IS(13:13)='A'
          DO 91 K=1,NSS
          IF(JIND(CSS(K),IS(1:13)).NE.0)GOTO 92
  91      CONTINUE
        GOTO 95
  92    J=IABS(LSV(K))
        WRITE(IS,'(A1,I4)')'#',N
          DO 93 N=1,5
          IF(IS(N:N).EQ.' ')GOTO 93
          J=J+1
          CSV(K)(J:J)=IS(N:N)
  93      CONTINUE
        LSV(K)=ISIGN(J,LSV(K))
  94    CONTINUE
  95  N=NS(M)
      IF(N.EQ.0)GOTO 101
C
C Modify atom names
C
      IF(JIND(CSS(N),'_atom_site_label').NE.0)GOTO 96
      IF(JIND(CSS(N),'_atom_site_aniso_label').EQ.0)GOTO 100
  96  IF(INDEX(IS(1:LS),'_').EQ.0)GOTO 99
      IR=IS
      IS=' '
      K=LS
      LS=0
      J=0
      I=0
  97  I=I+1
      IF(I.GT.K)GOTO 100
      IF(IR(I:I).NE.'_')GOTO 98
      J=J+1
      IF(J.NE.3)GOTO 97
  98  IF(J.EQ.2)GOTO 97
      LS=LS+1
      IS(LS:LS)=IR(I:I)
      GOTO 97
  99  IF(IBR.EQ.0)GOTO 100
      I=2
      IF(IS(2:2).GE.'a'.AND.IS(2:2).LE.'z')I=3
      IF(IS(I:I).GT.'9'.OR.IS(I:I).LT.'0')GOTO 100
      LS=LS+2
      IR(I:LS)='('//IS(I:LS-2)//')'
      IS(I:LS)=IR(I:LS)
 100  CSV(N)=IS
      LSV(N)=ISIGN(MAX0(1,LS),LSV(N))
 101  IF(M.LT.NL)GOTO 104
      IF(ISKP.NE.0)GOTO 103
      IF(IHSK+1.LT.IRH)GOTO 103
      IF(IRH.EQ.2.OR.IHSK.EQ.0)GOTO 102
      IF(IRSK.GT.IRH)GOTO 103
 102  CALL LINOUT
      GOTO 104
 103  NSO=LSO
 104  CALL NEXT
      IF(LS.LT.0)GOTO 105
      IF(IS(1:1).EQ.'_')GOTO 105
      IF(JCMP(IS,'loop_').EQ.0)GOTO 105
      IF(M.EQ.NL)GOTO 82
      GOTO 83
 105  IF(M.EQ.NL)GOTO 7
C
C Error and normal termination
C
 106  WRITE(*,'(/A)')' ** Loop mismatch or items missing **'
      GOTO 108
 107  WRITE(*,'(/A)')' ** Syntax error in ciftab.* file **'
 108  KS='N'
      IRT=0
 109  IF(IRT.NE.0)WRITE(LO,1)'}'//CR
      RETURN
      END
C
C -------------------------------------------------------------------
C
      SUBROUTINE GETANS(PRO,STR)
C
C Read a string from the keyboard with echo and default
C
      CHARACTER*(*)PRO,STR
      CHARACTER*80 IN
      CHARACTER*1 CR,ESC,AMP
      CHARACTER*40 FMT,CDN(500),CSS(40),DATB,MC
      CHARACTER*80 IS,IR,IW,CDS(500),CSV(40),CIFDIR,COD
      COMMON/CBUF/IR,IS,IW,CDS,CDN,CSS,CSV,DATB,CR,ESC,AMP,FMT,MC,
     +CIFDIR,COD
C
      L=MAX0(INDEX(STR,' '),2)-1
      WRITE(*,FMT)PRO,STR(1:L)
      IN=' '
      READ(*,'(A)')IN
        DO 1 I=1,80
        IF(IN(I:I).LT.' ')IN(I:I)=' '
   1    CONTINUE
        DO 2 I=1,80
        IF(IN(I:I).NE.' ')GOTO 3
   2    CONTINUE
      GOTO 4
   3  STR=IN(I:INDEX(IN(I:80),' ')+I-2)
   4  RETURN
      END
C
C -------------------------------------------------------------------
C
      SUBROUTINE CIFIN(FN,OPT)
C
C Scan .cif file and store non-looped items for desired data_ only.
C CDN stores CIF data names and CDS their values as strings (lengths in
C LDS).  NCD is set to the number of items.
C
      CHARACTER*1 CR,ESC,AMP,OPT,KS
      CHARACTER*7 SYO(512)
      CHARACTER*40 SYM(192),FMT,CDN(500),CSS(40),DATB,KIO(10),MC
      CHARACTER*40 KIN(10)
      CHARACTER*80 IS,IR,IW,CDS(500),CSV(40),FN,CIFDIR,COD
      INTEGER LDS(500),LSS(40),NCOL(40),MLT(40),MSG(40),LSV(40)
      COMMON LDS,LSS,LSV,NCOL,MLT,MSG,NCD,LS,NSS,LB,LC,LO,LU,MX,LR
      COMMON/CBUF/IR,IS,IW,CDS,CDN,CSS,CSV,DATB,CR,ESC,AMP,FMT,MC,
     +CIFDIR,COD
      COMMON/CSYM/SYM,SYO
      COMMON/ISYM/NSY
C
C Table of alternative spellings (as understood by SHELXL !)
C
      NIO=10
      KIO(1)='_reflns_number_observed'
      KIN(1)='_reflns_number_gt'
      KIO(2)='_reflns_observed_criterion'
      KIN(2)='_reflns_threshold_expression'
      KIO(3)='_refine_ls_R_factor_obs'
      KIN(3)='_refine_ls_R_factor_gt'
      KIO(4)='_refine_ls_R_factor_all'
      KIN(4)='_refine_ls_R_factor_ref'
      KIO(5)='_refine_ls_wR_factor_obs'
      KIN(5)='_refine_ls_wR_factor_gt'
      KIO(6)='_refine_ls_wR_factor_all'
      KIN(6)='_refine_ls_wR_factor_ref'
      KIO(7)='_refine_ls_goodness_of_fit_obs'
      KIN(7)='_refine_ls_goodness_of_fit_gt'
      KIO(8)='_refine_ls_goodness_of_fit_all'
      KIN(8)='_refine_ls_goodness_of_fit_ref'
      KIO(9)='_refine_ls_shift/esd_max'
      KIN(9)='_refine_ls_shift/su_max'
      KIO(10)='_refine_ls_shift/esd_mean'
      KIN(10)='_refine_ls_shift/su_mean'
C
      OPT='Y'
      L=INDEX(FN,' ')-1
      IF(L.LT.1)GOTO 10
      CLOSE(LC,IOSTAT=LB)
      OPEN(LC,FILE=FN(1:L),STATUS='OLD',ERR=10)
      LB=0
C
C Select appropriate data_ set
C
   1  CALL NEXT
      IF(LS.GE.0)GOTO 2
      WRITE(*,'(/A)')' ** (next) data_ not found before eof **'
      GOTO 11
   2  IF(JCMP(IS,'data_').NE.0)GOTO 1
   3  KS='Y'
      CALL GETANS('Select '//IS(1:LS)//' ? (Y or N)',KS)
      IF(KS.GE.'a')KS=CHAR(ICHAR(KS)-LU)
      IF(KS.EQ.'N')GOTO 1
      IF(KS.NE.'Y')GOTO 3
      DATB=IS(1:40)
      LOOP=0
      MSY=0
      NSY=0
      NCD=3
      CDN(1)='_data'
      CDS(1)=IS(6:LS)
      LDS(1)=LS-5
      CDN(2)='_tabno'
      CDN(3)='_comno'
      CDS(3)=MC
      LDS(3)=0
        DO 4 I=1,40
        IF(MC(I:I).NE.' ')LDS(3)=I
   4    CONTINUE
   5  CALL NEXT
      IF(LS.LT.0)GOTO 12
      IF(JCMP(IS,'loop_').NE.0)GOTO 6
      LOOP=1
      GOTO 5
   6  IF(LOOP.EQ.0)GOTO 7
      IF(JCMP(IS(2:19),'symmetry_equiv_pos').EQ.0)MSY=1
      IF(IS(1:1).EQ.'_')GOTO 5
      LOOP=0
   7  IF(IS(1:1).EQ.'_')GOTO 8
      IF(MSY.NE.1)GOTO 5
      NSY=NSY+1
      SYM(NSY)=IS(1:40)
      GOTO 5
   8  MSY=0
   9  NCD=NCD+1
      CDN(NCD)=IS(1:40)
      CDS(NCD)=' '
      LDS(NCD)=0
      CALL NEXT
      IF(LS.LT.0)GOTO 12
      IF(IS(1:1).EQ.'_')GOTO 9
      CDS(NCD)=IS
      LDS(NCD)=LS
      GOTO 5
  10  WRITE(*,'(/A)')' ** cannot open file '//FN(1:L)//' **'
  11  OPT='N'
      GOTO 18
C
C Add aliases
C
  12  J=NCD
        DO 16 I=1,NCD
          DO 15 M=1,NIO
          IF(JCMP(CDN(I),KIO(M)).NE.0)GOTO 13
          CDN(J+1)=KIN(M)
          GOTO 14
  13      IF(JCMP(CDN(I),KIN(M)).NE.0)GOTO 15
          CDN(J+1)=KIO(M)
  14      J=J+1
          CDS(J)=CDS(I)
          LDS(J)=LDS(I)
          IF(J.EQ.500)GOTO 17
  15      CONTINUE
  16    CONTINUE
  17  NCD=J
  18  RETURN
      END
C
C -------------------------------------------------------------------
C
      SUBROUTINE CIFOUT(LO,FN,KS,NOS)
      CHARACTER*1 KS
      CHARACTER*26 KZ
      CHARACTER*80 FN
C
C Prompt for and open output file on unit LO.
C
      IF(NOS.NE.3)FN=' '
      I=26
      KZ='s (<CR> to print directly)'
      IF(NOS.EQ.3)I=1
      CALL GETANS('Filename for table'//KZ(1:I),FN)
      CLOSE(LO,IOSTAT=I)
      L=INDEX(FN,' ')-1
      IF(L.GT.0)GOTO 3
      IF(NOS.NE.1)GOTO 2
      OPEN(LO,FILE='PRN',STATUS='OLD',ERR=1)
      GOTO 7
   1  WRITE(*,'(/A)')' ** Cannot write directly to printer **'
      GOTO 6
   2  IF(NOS.NE.2)GOTO 1
C
C ** Uncomment the next statement for compiling under VMS
C
C     OPEN(LO,DISPOSE='PRINT/DELETE',STATUS='NEW',
C    +FORM='FORMATTED',ERR=4)
      GOTO 7
   3  IF(NOS.EQ.2)GOTO 4
      OPEN(LO,FILE=FN(1:L),STATUS='OLD',IOSTAT=I)
      CLOSE(LO,STATUS='DELETE',IOSTAT=I)
C
C CARRIAGECONTROL='LIST' should be removed from the next statement
C if the compiler objects to it
C
   4  OPEN(LO,FILE=FN(1:L),STATUS='NEW',ERR=5)
      GOTO 7
   5  WRITE(*,'(/A)')' ** Cannot open file '//FN(1:L)//' **'
   6  KS='N'
   7  RETURN
      END
C
C -------------------------------------------------------------------
C
      SUBROUTINE NEXT
C
C Return the next item from unit LC (CIF format) in buffer IS.
C LS returns the string length.  Text information produces a
C blank string (with LS=0).  LS=-1 flags end of the file LC.
C All characters are converted to lower case.
C
      CHARACTER*1 CR,ESC,AMP
      CHARACTER*40 CDN(500),CSS(40),DATB,FMT,MC
      CHARACTER*80 IS,IR,IW,CDS(500),CSV(40),CIFDIR,COD
      INTEGER LDS(500),LSS(40),NCOL(40),MLT(40),MSG(40),LSV(40)
      COMMON LDS,LSS,LSV,NCOL,MLT,MSG,NCD,LS,NSS,LB,LC,LO,LU,MX,LR
      COMMON/CBUF/IR,IS,IW,CDS,CDN,CSS,CSV,DATB,CR,ESC,AMP,FMT,MC,
     +CIFDIR,COD
   1  FORMAT(A)
C
      LK=0
      LS=0
      IS=' '
   2  LB=LB+1
      IF(LB.LT.81)GOTO 4
      IF(LS.NE.0)GOTO 9
      LB=0
      IW=' '
      READ(LC,1,END=7)IW
      I=INDEX(IW,CHAR(13))
      IF(I.GT.0)IW(I:I)=' '
      IF(IW(1:1).NE.';')GOTO 2
   3  READ(LC,1,END=7)IW
      I=INDEX(IW,CHAR(13))
      IF(I.GT.0)IW(I:I)=' '
      IF(IW(1:1).NE.';')GOTO 3
      GOTO 9
   4  IF(LK.EQ.0)GOTO 8
      IF(IW(LB:LB).EQ.'''')GOTO 12
   5  LS=LS+1
      IS(LS:LS)=IW(LB:LB)
      GOTO 2
   6  IF(LS.GE.80)GOTO 2
      IF(IW(LB:LB).NE.'''')GOTO 5
      IF(LS.NE.0)GOTO 5
      LK=1
      GOTO 2
   7  LS=-1
      GOTO 12
   8  IF(IW(LB:LB).NE.' ')GOTO 6
      IF(LS.EQ.0)GOTO 2
   9  IF(IS(1:1).EQ.'_')GOTO 10
      IF(JCMP(IS,'Loop_').NE.0)GOTO 12
  10    DO 11 I=1,LS
        IF(IS(I:I).GE.'A'.AND.IS(I:I).LE.'Z')IS(I:I)=
     +  CHAR(ICHAR(IS(I:I))+LU)
  11    CONTINUE
  12  RETURN
      END
C
C -------------------------------------------------------------------
C
      SUBROUTINE RINT(I,N)
C
C Set N to the integer which begins at position I in string IR.
C I is incremented to point to the character following this integer.
C
      CHARACTER*1 CR,ESC,AMP
      CHARACTER*40 CDN(500),CSS(40),DATB,FMT,MC
      CHARACTER*80 IS,IR,IW,CDS(500),CSV(40),CIFDIR,COD
      COMMON/CBUF/IR,IS,IW,CDS,CDN,CSS,CSV,DATB,CR,ESC,AMP,FMT,MC,
     +CIFDIR,COD
C
      N=0
      M=1
      IF(IR(I+1:I+1).NE.'-')GOTO 1
      M=-1
      I=I+1
   1  I=I+1
      IF(I.GT.80)GOTO 2
      K=ICHAR(IR(I:I))
      IF(K.LT.48)GOTO 2
      IF(K.GT.57)GOTO 2
      N=N*10+K-48
      GOTO 1
   2  N=N*M
      RETURN
      END
C
C -------------------------------------------------------------------
C
      SUBROUTINE LINOUT
C
C Combine text line in IT with CIF items and output it
C
      CHARACTER*1 CR,ESC,AMP
      CHARACTER*40 CDN(500),CSS(40),DATB,FMT,MC
      CHARACTER*80 IS,IR,IW,CDS(500),CSV(40),CIFDIR,COD
      CHARACTER*128 IT
      INTEGER LDS(500),LSS(40),NCOL(40),MLT(40),MSG(40),LSV(40)
      COMMON LDS,LSS,LSV,NCOL,MLT,MSG,NCD,LS,NSS,LB,LC,LO,LU,MX,LR
      COMMON/CBUF/IR,IS,IW,CDS,CDN,CSS,CSV,DATB,CR,ESC,AMP,FMT,MC,
     +CIFDIR,COD
   1  FORMAT(A)
C
      MT=0
      IT=' '
        DO 9 M=1,NSS
        IR=CSV(M)
        L=IABS(LSV(M))
        IF(LSV(M).LT.0)GOTO 7
C
C Interpret numerical string with esd
C
        K=INDEX(IR(1:L),'(')-1
        IF(K.LE.0)K=L
        J=INDEX(IR(1:L),'.')
        IF(J.GT.0)GOTO 2
        J=K+1
        IR(J:J)='.'
   2    N=K-J
        WRITE(IS,'(A,I2,A,I1,A)')'(F',MAX0(J,K),'.',MAX0(0,N),')'
        READ(IR,IS(1:7),ERR=7)X
        Y=-9.E9
        IF(L.LT.K+2)GOTO 4
        IR(L:L)='.'
        WRITE(IS,'(A,I1,A)')'(F',L-K-1,'.0)'
        READ(IR(K+2:L),IS(1:6),ERR=7)Y
          DO 3 I=1,N
          Y=0.1*Y
   3      CONTINUE
C
C Multiply by power of 10
C
   4    T=10.
        IF(MLT(M).LT.0)T=0.1
        J=IABS(MLT(M))
          DO 5 I=1,J
          X=X*T
          Y=Y*T
   5      CONTINUE
        J=MAX0(0,MIN0(MSG(M),N-MLT(M)))
        WRITE(IR,'(A,2(I1,A))')'(F20.',J,',A,F12.',J,',A)'
        IS=' '
        IF(Y.GE.0.)WRITE(IS,IR(1:17))X,' (',Y,' )'
        IR(7:7)=')'
        IF(Y.LT.0.)WRITE(IS,IR(1:7))X
        L=0
        IR=' '
          DO 6 I=1,36
          IF(IS(I:I).EQ.' ')GOTO 6
          IF(I.GT.19.AND.IS(I:I).EQ.'.')GOTO 6
          L=L+1
          IR(L:L)=IS(I:I)
          IF(L.EQ.1)GOTO 6
          IF(IR(L-1:L).EQ.'(0')L=L-1
   6      CONTINUE
        IF(IR(L-1:L).NE.'()')GOTO 7
        L=L+1
        IR(L-1:L)='1)'
C
C Insert string into text line
C
   7    J=MT+1
        N=MT+L
        IF(NCOL(M).EQ.0)GOTO 8
        J=NCOL(M)
        N=J+L-1
        IF(J.GT.0)GOTO 8
        N=IABS(J)
        J=MAX0(1,N-L+1)
        IF(LSV(M).LE.0)GOTO 8
        K=INDEX(IR(1:L),'.')
        IF(K.EQ.0)K=INDEX(IR(1:L),'(')
        IF(K.EQ.0)GOTO 8
        K=L-K+1
        N=N+K
        J=J+K
   8    N=MIN0(N,128)
        L=MIN0(L,N-J+1)
        IT(J:N)=IR(1:L)
        MT=MIN0(MAX0(N,MT),127)
   9    CONTINUE
      IF(MT.EQ.0)MT=1
      WRITE(LO,1)IT(1:MT)//CR
      RETURN
      END
C
C -------------------------------------------------------------------
C
      SUBROUTINE CIFSFT(KS)
C
C Reads name.fcf (CIF format) and outputs structure factors to .sft in
C compressed format for an HP-Laserjet or compatible printer. The .fcf
C file must have been created using the LIST 4 (or ACTA) instructions
C of SHELXL.  h, k, l, 10Fo, 10Fc and 10sigma(F) are printed in five
C columns per page, unless 10Fo or 10Fc would be too large to print,
C in which case Fo etc. is printed instead.  Fo is set to zero if Fo^2
C is negative, and negative sigma(Fo) flags reflections suppressed for
C refinement purposes.
C
      CHARACTER*1 CR,ESC,AMP,KS
      CHARACTER*40 CDN(500),CSS(40),DATB,FMT,MC,KT
      CHARACTER*80 IS,IR,IW,CDS(500),CSV(40),CIFDIR,COD
      CHARACTER*128 KR
      INTEGER LDS(500),LSS(40),NCOL(40),MLT(40),MSG(40),LSV(40),
     +IG(30),IH(800),IK(800),IL(800),IO(800),IC(800),IE(800)
      COMMON LDS,LSS,LSV,NCOL,MLT,MSG,NCD,LS,NSS,LB,LC,LO,LU,MX,LR
      COMMON/CBUF/IR,IS,IW,CDS,CDN,CSS,CSV,DATB,CR,ESC,AMP,FMT,MC,
     +CIFDIR,COD
      COMMON/CSFT/IG,IH,IK,IL,IO,IC,IE
C
   1  FORMAT(A)
   2  FORMAT(3I4,2F12.2,F10.2,1X,A)
   3  FORMAT(1X,A)
   4  FORMAT('   Table',I4,'.     Observed and calculated structure ',
     +'factors for ',A,17X,'Page',I3,A1/A1)
   5  FORMAT(3X,4('h  k  l 10Fo 10Fc 10s',5X),'h  k  l 10Fo 10Fc 10s',
     +A1/A1)
   6  FORMAT(3X,4('h  k  l   Fo   Fc   s',5X),'h  k  l   Fo   Fc   s',
     +A1/A1)
   7  FORMAT(4(I4,2I3,2I5,I4,2X),I4,2I3,2I5,I4)
   8  FORMAT($,1X,A)
C
      WRITE(LO,1)' '//ESC//AMP//'l0o5c1x'//ESC//'(0u'//
     +ESC//'(s0p16.66h8.5v0s0b0T'//CR
      FMAX=9999.
      FSCA=1.
C
C Check CIF file and set scale factor
C
   9  READ(LC,1,ERR=29,END=29)IR
        DO 10 I=1,80
        IF(IR(I:I).LT.' ')IR(I:I)=' '
  10    CONTINUE
      IF(JCMP(IR,'_shelx_refln_list_code').NE.0)GOTO 9
      IF(INDEX(IR(23:80),' 4 ').EQ.0)GOTO 29
  11  READ(LC,1,ERR=29,END=29)IR
        DO 12 I=1,80
        IF(IR(I:I).LT.' ')IR(I:I)=' '
  12    CONTINUE
      IF(JIND(IR,'_shelx_F_calc_maximum').NE.0)
     +READ(IR(22:80),*,ERR=29,END=29)FMAX
      IF(JIND(IR,'_shelx_F_squared_multiplier').NE.0)
     +READ(IR(29:80),*,ERR=29,END=29)FSCA
      IF(JIND(IR,'_refln_index_').EQ.0)GOTO 11
  13  READ(LC,1,ERR=29,END=29)IR
      IF(INDEX(IR,'_').NE.0)GOTO 13
      IF(FMAX.LE.0.)GOTO 29
      IF(FSCA.LE.0.)GOTO 29
      FSCA=SQRT(FSCA)
      SC=10.
      IF(FMAX.GT.999.)SC=1.
C
C Set number of lines per page for A or A4 size paper
C
      KS='U'
  14  CALL GETANS('US (U) or European (E) sized paper',KS)
      IF(KS.GE.'a')KS=CHAR(ICHAR(KS)-LU)
      NLINE=87
      IF(KS.EQ.'U')GOTO 15
      IF(KS.NE.'E')GOTO 14
      NLINE=93
  15  KT=' '
      WRITE(KT,'(I2)')MIN0(93,NLINE)
      GOTO 17
  16  KT='?'
  17  CALL GETANS('Number of Fo/Fc lines per page',KT)
      READ(KT,*,ERR=16)NLINE
      IF(NLINE.LT.1)GOTO 16
      IF(NLINE.GT.160)GOTO 16
C
C Read block of data in fixed format (faster), scale and store
C
      NMAX=5*NLINE
      NE=0
      NP=0
  18  NP=NP+1
      M=0
  19  M=M+1
      IF(M.GT.NMAX)GOTO 23
      IF(NP+M.GT.2)GOTO 20
      READ(IR,2,ERR=29,END=22)IH(M),IK(M),IL(M),C,F,S,KS
      GOTO 21
  20  READ(LC,2,ERR=29,END=22)IH(M),IK(M),IL(M),C,F,S,KS
  21  IF(IABS(IH(M))+IABS(IK(M))+IABS(IL(M)).EQ.0)GOTO 22
      F=AMAX1(F,0.0001)
      T=S/F
      F=SC*SQRT(F)/FSCA
      C=SC*SQRT(C)/FSCA
      IO(M)=INT(F+0.5)
      IC(M)=INT(C+0.5)
      IE(M)=MAX0(1,INT(F*(1.-SQRT(AMAX1(0.,1.-T)))))
      IF(KS.NE.'o')IE(M)=-IE(M)
      GOTO 19
  22  NE=1
  23  M=M-1
      NB=(M+4)/5
      IF(NB.EQ.0)GOTO 31
      IF(NP.NE.1)WRITE(LO,3)CHAR(12)
      WRITE(LO,4)MX,MC,NP,CR,CR
      IF(SC.GT.5.)WRITE(LO,5)CR,CR
      IF(SC.LT.5.)WRITE(LO,6)CR,CR
C
C Output transposed data
C
      J=0
  24  J=J+1
      IF(J.GT.NB)GOTO 30
      K=J+NB*((M-J)/NB)
      L=0
        DO 25 I=J,K,NB
        L=L+6
        IG(L-5)=IH(I)
        IG(L-4)=IK(I)
        IG(L-3)=IL(I)
        IG(L-2)=IO(I)
        IG(L-1)=IC(I)
        IG(L)=IE(I)
  25    CONTINUE
      KR=' '
      WRITE(KR,7)(IG(I),I=1,L)
        DO 28 I=1,105,26
        IF(KR(I+7:I+7).NE.' '.AND.KR(I+7:I+7).NE.'-')GOTO 26
        IF(KR(I+4:I+4).EQ.' '.OR.KR(I+4:I+4).EQ.'-')GOTO 28
        KR(I:I)=KR(I+1:I+1)
        KR(I+1:I+1)=KR(I+2:I+2)
        KR(I+2:I+2)=KR(I+3:I+3)
        KR(I+4:I+4)=' '
        GOTO 28
  26    IF(KR(I+4:I+5).EQ.'  '.OR.KR(I+4:I+5).EQ.' -')GOTO 27
        KR(I:I)=KR(I+1:I+1)
        KR(I+1:I+1)=KR(I+2:I+2)
        KR(I+2:I+2)=KR(I+3:I+3)
        KR(I+3:I+3)=KR(I+4:I+4)
  27    KR(I+4:I+4)=KR(I+5:I+5)
        KR(I+5:I+5)=KR(I+6:I+6)
        KR(I+6:I+6)=' '
  28    CONTINUE
      WRITE(LO,'(A)')KR//CR
      GOTO 24
  29  WRITE(*,'(/A)')' ** Bad .fcf file **'
      KS='N'
      GOTO 32
  30  IF(NE.EQ.0)GOTO 18
  31  MX=MX+1
      KS='Y'
C
C Reset HP Laserjet
C
  32  WRITE(LO,8)ESC//'E'//CR
      RETURN
      END
C
C -------------------------------------------------------------------
C
      INTEGER FUNCTION JCMP(KS,KT)
C
C Compares two strings, returns 0 if they are the same, 1 if not,
C treating upper and lower case as identical, up to the length of
C the SECOND string
C
      CHARACTER*(*)KS,KT
      CHARACTER*1 KP,KQ
      L=ICHAR('a')-ICHAR('A')
      N=LEN(KT)
      JCMP=1
        DO 1 J=1,N
        KP=KS(J:J)
        IF(KP.GE.'A'.AND.KP.LE.'Z')KP=CHAR(ICHAR(KP)+L)
        KQ=KT(J:J)
        IF(KQ.GE.'A'.AND.KQ.LE.'Z')KQ=CHAR(ICHAR(KQ)+L)
        IF(KP.NE.KQ)GOTO 2
   1    CONTINUE
      JCMP=0
   2  RETURN
      END
C
C -------------------------------------------------------------------
C
      INTEGER FUNCTION JIND(KS,KT)
C
C Returns the position in KS at which string KT starts, otherwise 0.
C Upper and lower case are treated as identical.
C
      CHARACTER*(*)KS,KT
      CHARACTER*1 KP,KQ
      L=ICHAR('a')-ICHAR('A')
      M=LEN(KS)
      N=LEN(KT)
      JIND=0
        DO 2 J=0,M-N
          DO 1 I=1,N
          KP=KS(I+J:I+J)
          IF(KP.GE.'A'.AND.KP.LE.'Z')KP=CHAR(ICHAR(KP)+L)
          KQ=KT(I:I)
          IF(KQ.GE.'A'.AND.KQ.LE.'Z')KQ=CHAR(ICHAR(KQ)+L)
          IF(KP.NE.KQ)GOTO 2
   1      CONTINUE
        JIND=J+1
        GOTO 3
   2    CONTINUE
   3  RETURN
      END
