C
C ------------------------------------------------------------
C
C The following vectorizable subroutines are rate determining for
C direct methods.  Subroutine SX21 uses up about half of the CPU
C time for centrosymmetric direct methods.
C
      SUBROUTINE SV21(D,AR,BR,NQ)
      REAL D(0:127),AR(0:127),BR(0:127)
      N=NQ-1
        DO 1 K=0,N
        D(K)=D(K)+AR(K)*BR(K)
   1    CONTINUE
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SV22(D,AR,BR,T,NQ)
      REAL D(0:127),AR(0:127),BR(0:127)
      N=NQ-1
        DO 1 K=0,N
        D(K)=D(K)+T*AR(K)*BR(K)
   1    CONTINUE
      RETURN
      END
C
C ------------------------------------------------------------
C
C The following procedure accounts for about half the CPU time
C for a typical non-centrosymmetric direct methods run.
C
      SUBROUTINE SV23(D,E,AR,AI,BR,BI,R,S,U,V,NQ)
      REAL D(0:127),E(0:127),AR(0:127),AI(0:127),BR(0:127),BI(0:127)
      N=NQ-1
        DO 1 K=0,N
        P=R*AI(K)
        X=U*AR(K)-V*P
        Y=V*AR(K)+U*P
        P=S*BI(K)
        D(K)=D(K)+X*BR(K)-Y*P
        E(K)=E(K)+Y*BR(K)+X*P
   1    CONTINUE
      RETURN
      END
C
C ------------------------------------------------------------
C
C Subroutine SV24 accounts for about one quarter of the CPU time
C consumed by a typical centrosymmetric direct methods run.
C
      SUBROUTINE SV24(H,AR,BR,CR,WQ,NQ)
      REAL H(0:127),AR(0:127),BR(0:127),CR(0:127)
      N=NQ-1
        DO 1 K=0,N
        H(K)=H(K)+WQ*AR(K)*BR(K)*CR(K)
   1    CONTINUE
      RETURN
      END
C
C ------------------------------------------------------------
C
C The following procedure accounts for about one quarter of the
C CPU time for non-centrosymmetric direct methods.
C
      SUBROUTINE SV25(H,C,AR,AI,BR,BI,CR,CI,R,S,T,P,Q,NQ)
      REAL H(0:127),C(0:127),AR(0:127),AI(0:127),BR(0:127),
     +BI(0:127),CR(0:127),CI(0:127)
      N=NQ-1
        DO 1 K=0,N
        W=R*AI(K)
        V=S*BI(K)
        U=AR(K)*BR(K)-W*V
        V=BR(K)*W+AR(K)*V
        W=T*CI(K)
        X=U*CR(K)-V*W
        Y=V*CR(K)+U*W
        H(K)=H(K)+P*X+Q*Y
        C(K)=C(K)-P*Y+Q*X
   1    CONTINUE
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SV26(H,C,D,E,U,V,NQ)
      REAL H(0:127),C(0:127),D(0:127),E(0:127)
      N=NQ-1
        DO 1 K=0,N
        H(K)=H(K)*U+C(K)*V
        D(K)=D(K)*U+E(K)*V
        C(K)=V*H(K)
        E(K)=V*D(K)
        H(K)=U*H(K)
        D(K)=U*D(K)
   1    CONTINUE
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SV27(H,D,FB,FC,FD,FE,FF,T,Z,ZG,NQ)
      REAL H(0:127),D(0:127),FB(0:127),FC(0:127),FD(0:127),
     +FE(0:127),FF(0:127)
      N=NQ-1
        DO 1 K=0,N
        W=H(K)*D(K)
        FB(K)=FB(K)+W
        FC(K)=FC(K)+ABS(W)
        W=T*ABS(D(K))
        FE(K)=FE(K)+W
        FF(K)=FF(K)+ZG*W**2
        FD(K)=FD(K)+ZG*(W-Z)**2
   1    CONTINUE
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SV28(H,C,D,E,FB,FC,FD,FE,FF,T,Z,ZG,NQ)
      REAL H(0:127),C(0:127),D(0:127),E(0:127),FB(0:127),
     +FC(0:127),FD(0:127),FE(0:127),FF(0:127)
      N=NQ-1
        DO 1 K=0,N
        FB(K)=FB(K)+H(K)*D(K)+C(K)*E(K)
        W=SQRT(D(K)**2+E(K)**2)
        FC(K)=FC(K)+W*SQRT(H(K)**2+C(K)**2)
        W=W*T
        FE(K)=FE(K)+W
        FF(K)=FF(K)+ZG*W**2
        FD(K)=FD(K)+ZG*(W-Z)**2
   1    CONTINUE
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SV29(D,E,U,V,NQ)
      REAL D(0:127),E(0:127)
      N=NQ-1
        DO 1 K=0,N
        X=D(K)*U+E(K)*V
        E(K)=X*V
        D(K)=X*U
   1    CONTINUE
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SV2A(FB,FC,FD,FE,FF,P,NQ)
      REAL FB(0:127),FC(0:127),FD(0:125),FE(0:125),FF(0:127)
      N=NQ-1
        DO 1 K=0,N
        FD(K)=FD(K)/FF(K)
        FB(K)=FB(K)/FC(K)
        FE(K)=FE(K)/P
   1    CONTINUE
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SV2B(H,C,D,E,RV,AR,AI,TT,P,ZZ,NQ)
      REAL H(0:127),C(0:127),D(0:127),E(0:127),
     +RV(0:127),AR(0:127),AI(0:127)
      T=4.*TT
      Z=SQRT(ZZ)
      N=NQ-1
        DO 1 K=0,N
        U=D(K)
        V=E(K)
        W=SQRT(U**2+V**2)+.0001
        RV(K)=(1.+2.*AINT(1048576.*RV(K)+.3))*5./2097152.
        RV(K)=RV(K)-AINT(RV(K))
        X=ALOG(RV(K)+1.E-6)/W
        X=AMIN1((T+X)/(T-X),Z/W)
        Y=SIGN(SQRT(ABS(1.-X**2)),H(K)*V-C(K)*U+AMOD(RV(K),.002)-.001)
        W=P/W
        AR(K)=(U*X-V*Y)*W
        AI(K)=(U*Y+V*X)*W
        H(K)=0.
        C(K)=0.
        D(K)=0.
        E(K)=0.
   1    CONTINUE
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SV2C(H,C,D,E,AR,AI,P,NQ)
      REAL H(0:127),C(0:127),D(0:127),E(0:127),AR(0:127),AI(0:127)
      N=NQ-1
        DO 1 K=0,N
        U=D(K)-H(K)
        V=E(K)-C(K)
        W=U**2+V**2+.0001
        W=P/SQRT(W)
        AR(K)=W*U
        AI(K)=W*V
        H(K)=0.
        C(K)=0.
        D(K)=0.
        E(K)=0.
   1    CONTINUE
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SV2D(H,D,AR,AI,P,NQ)
      REAL H(0:127),D(0:127),AR(0:127),AI(0:127)
      N=NQ-1
        DO 1 K=0,N
        AR(K)=SIGN(P,D(K)-H(K))
        AI(K)=-AR(K)
        H(K)=0.
        D(K)=0.
   1    CONTINUE
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SV2E(H,D,RV,AR,AI,T,P,NQ)
      REAL H(0:127),D(0:127),RV(0:127),AR(0:127),AI(0:127)
      N=NQ-1
        DO 1 K=0,N
        RV(K)=(1.+2.*AINT(1048576.*RV(K)+.3))*5./2097152.
        RV(K)=RV(K)-AINT(RV(K))
        W=D(K)-H(K)
        AR(K)=SIGN(P,W*(ABS(T*W)-ALOG(2.*RV(K)+1.E-6)))
        AI(K)=-AR(K)
        H(K)=0.
        D(K)=0.
   1    CONTINUE
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SV2F(H,C,D,E,ZZ,NQ)
      REAL H(0:127),C(0:127),D(0:127),E(0:127)
      N=NQ-1
        DO 1 K=0,N
        X=D(K)**2+E(K)**2
        IF(X.LT.ZZ)GOTO 1
        X=ZZ/X
        Y=SIGN(SQRT(ABS(1.-X)),H(K)*E(K)-D(K)*C(K)+AMOD(X,.002)-.001)
        X=SQRT(X)
        H(K)=E(K)*Y-D(K)*X
        E(K)=E(K)*X+D(K)*Y
        D(K)=0.
        C(K)=0.
   1    CONTINUE
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SV2G(H,C,D,E,RV,AR,AI,T,P,NQ)
      REAL H(0:127),C(0:127),D(0:127),E(0:127),
     +RV(0:127),AR(0:127),AI(0:127)
      N=NQ-1
        DO 1 K=0,N
        RV(K)=(1.+2.*AINT(1048576.*RV(K)+.3))*5./2097152.
        RV(K)=RV(K)-AINT(RV(K))
        U=D(K)-H(K)
        V=E(K)-C(K)
        W=SQRT(U**2+V**2)
        W=SIGN(P/(W+.0001),T*W-ALOG(2.*RV(K)+1.E-6))
        AR(K)=W*U
        AI(K)=W*V
        H(K)=0.
        C(K)=0.
        D(K)=0.
        E(K)=0.
   1    CONTINUE
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SV2H(H,C,D,E,NQ)
      REAL H(0:127),C(0:127),D(0:127),E(0:127)
      N=NQ-1
        DO 1 K=0,N
        H(K)=0.
        C(K)=0.
        D(K)=0.
        E(K)=0.
   1    CONTINUE
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SV2I(D,AR,AI,T,P,NQ)
      REAL D(0:127),AR(0:127),AI(0:127)
      N=NQ-1
        DO 1 K=0,N
        W=D(K)
        AR(K)=SIGN(P*AMIN1(1.,T*ABS(W)),W)
        AI(K)=-AR(K)
        D(K)=0.
   1    CONTINUE
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SV2J(D,E,AR,AI,T,P,NQ)
      REAL D(0:127),E(0:127),AR(0:127),AI(0:127)
      N=NQ-1
        DO 1 K=0,N
        U=T*D(K)
        V=T*E(K)
        W=AMAX1(1.,U**2+V**2)
        W=P/SQRT(W)
        AR(K)=W*U
        AI(K)=W*V
        D(K)=0.
        E(K)=0.
   1    CONTINUE
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SV2K(FB,AR,BR,CR,DR,WQ,NQ)
      REAL FB(0:127),AR(0:127),BR(0:127),CR(0:127),DR(0:127)
      N=NQ-1
        DO 1 K=0,N
        FB(K)=FB(K)+WQ*AR(K)*BR(K)*CR(K)*DR(K)
   1    CONTINUE
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SV2L(FB,AR,AI,BR,BI,CR,CI,DR,DI,R,S,T,P,Q,NQ)
      REAL FB(0:127),AR(0:127),AI(0:127),BR(0:127),
     +BI(0:127),CR(0:127),CI(0:127),DR(0:127),DI(0:127)
      N=NQ-1
        DO 1 K=0,N
        W=R*AI(K)
        V=S*BI(K)
        U=AR(K)*BR(K)-W*V
        V=BR(K)*W+AR(K)*V
        W=T*CI(K)
        X=U*CR(K)-V*W
        Y=V*CR(K)+U*W
        FB(K)=FB(K)+(P*X+Q*Y)*DR(K)-(P*Y-Q*X)*DI(K)
   1    CONTINUE
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SV2P(A,P,X,Y,Z,N)
      REAL A(0:N)
      M=N-4
        DO 1 I=0,M,5
        A(I)=A(I)+P*COS(X*A(I+1)+Y*A(I+2)+Z*A(I+3))
   1    CONTINUE
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXF1(E,W,Z,S,T,N)
      REAL E(0:N)
        DO 1 I=1,N,2
        E(I)=E(I)+T
        E(I+1)=E(I+1)+S
        Q=T*W-S*Z
        S=T*Z+S*W
        T=Q
   1    CONTINUE
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXF2(E,W,Z,S,T,X,Y,N)
      REAL E(0:N)
        DO 1 I=1,N,4
        E(I)=E(I)+T
        E(I+1)=E(I+1)+S
        Q=T*W-S*Z
        S=T*Z+S*W
        T=Q
        E(I+2)=E(I+2)+Y
        E(I+3)=E(I+3)+X
        Q=Y*W-X*Z
        X=Y*Z+X*W
        Y=Q
   1    CONTINUE
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXCA(A,B,N)
C
C Copy N elements from array A to array B.  Some computers may
C have a fast byte string copy routine which could be used here.
C
      DIMENSION A(0:N),B(0:N)
      M=N-1
        DO 1 I=0,M
        B(I)=A(I)
   1    CONTINUE
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXZA(A,N)
C
C Zero first N elements of array A.  Some computers may have a
C fast routine which could be used here.
C
      DIMENSION A(0:N)
      M=N-1
        DO 1 I=0,M
        A(I)=0.
   1    CONTINUE
      RETURN
      END
