C
C -----------------------------------------------------------------
C ** For optimum efficiency the following SHELXL routines should **
C ** be compiled with the highest level of optimization and      **
C ** vectorization available.  For large structures they account **
C ** for about 99% of the total cpu time.  It may well prove     **
C ** counter-productive to try to optimize and/or vectorize the  **
C ** rest of the program (i.e. it will probably run more slowly  **
C ** and may even give the wrong answers) !  For large matrix    **
C ** blocks SXMM and SXPV are the most important. Computer Gurus **
C ** may enjoy hand-tuning these routines !                      **
C -----------------------------------------------------------------
C
      SUBROUTINE SXMM(NP,MT,JP,JN,JT,JM,CG,JW,JK,B,
     +C,C1,C2,C3,C4,C5,C6,C7)
C
C Accumulate least-squares matrix and two vectors
C
      REAL B(JW),C(JK),C1(JK),C2(JK),
     +C3(JK),C4(JK),C5(JK),C6(JK),C7(JK)
C
      IF(CG.LT.0.)GOTO 6
      Q1=1.
      Q2=Q1
      Q3=Q1
      Q4=Q1
      Q5=Q1
      Q6=Q1
      Q7=Q1
      JZ=JP+MT
      J3=JT
      JS=JP
   1  IF(JS.LT.JZ-7)GOTO 2
      Q7=0.
      IF(JS.LT.JZ-6)GOTO 2
      Q6=0.
      IF(JS.LT.JZ-5)GOTO 2
      Q5=0.
      IF(JS.LT.JZ-4)GOTO 2
      Q4=0.
      IF(JS.LT.JZ-3)GOTO 2
      Q3=0.
      IF(JS.LT.JZ-2)GOTO 2
      Q2=0.
      IF(JS.LT.JZ-1)GOTO 2
      Q1=0.
   2  J1=JS-JM
        DO 3 M=1,NP
        J1=J1+JM
        C(M)=B(J1)
        C1(M)=B(J1+1)*Q1
        C2(M)=B(J1+2)*Q2
        C3(M)=B(J1+3)*Q3
        C4(M)=B(J1+4)*Q4
        C5(M)=B(J1+5)*Q5
        C6(M)=B(J1+6)*Q6
        C7(M)=B(J1+7)*Q7
   3    CONTINUE
      CALL SXCC
      JF=JN
      J=NP
        DO 5 M=1,NP
        T=C(M)
        T1=C1(M)
        T2=C2(M)
        T3=C3(M)
        T4=C4(M)
        T5=C5(M)
        T6=C6(M)
        T7=C7(M)
        B(M)=B(M)+T*B(J3)+T1*B(J3+1)+T2*B(J3+2)+T3*B(J3+3)+
     +  T4*B(J3+4)+T5*B(J3+5)+T6*B(J3+6)+T7*B(J3+7)
        B(JF)=B(JF)+T*B(JS)+T1*B(JS+1)+T2*B(JS+2)+T3*B(JS+3)+
     +  T4*B(JS+4)+T5*B(JS+5)+T6*B(JS+6)+T7*B(JS+7)
        JF=JF+1
          DO 4 N=M,NP
          J=J+1
          B(J)=B(J)+T*C(N)+T1*C1(N)+T2*C2(N)+T3*C3(N)+
     +    T4*C4(N)+T5*C5(N)+T6*C6(N)+T7*C7(N)
   4      CONTINUE
   5    CONTINUE
      J3=J3+8
      JS=JS+8
      IF(JS.LT.JZ)GOTO 1
      GOTO 9
C
C For CGLS, sum two vectors and diagonal elements of matrix only
C
   6  J1=JP
      JF=JN
        DO 8 M=1,NP
        T1=B(M)
        JZ=J1+MT-1
        T2=B(JF)
        J3=JT
        JG=M+NP
        T3=B(JG)
        JS=JP
          DO 7 J=J1,JZ
          T1=T1+B(J)*B(J3)
          J3=J3+1
          T2=T2+B(J)*B(JS)
          JS=JS+1
          T3=T3+B(J)**2
   7      CONTINUE
        B(M)=T1
        J1=J1+JM
        B(JF)=T2
        JF=JF+1
        B(JG)=T3
   8    CONTINUE
      CALL SXCC
   9  RETURN
      END
C
C -----------------------------------------------------------
C
      SUBROUTINE SXPV(A,B,C,PP,QQ,N)
C
C Key vector subroutine for matrix inversion
C
      REAL A(N),B(N),C(N)
C
      M=(N/4)*4
      P=PP
      Q=QQ
        DO 1 I=1,M,4
        A(I)=A(I)+P*B(I)
        A(I+1)=A(I+1)+P*B(I+1)
        A(I+2)=A(I+2)+P*B(I+2)
        A(I+3)=A(I+3)+P*B(I+3)
        Q=Q+B(I)*C(I)+B(I+1)*C(I+1)+B(I+2)*C(I+2)+B(I+3)*C(I+3)
   1    CONTINUE
      IF(M+1.GT.N)GOTO 2
      A(M+1)=A(M+1)+P*B(M+1)
      Q=Q+B(M+1)*C(M+1)
      IF(M+2.GT.N)GOTO 2
      A(M+2)=A(M+2)+P*B(M+2)
      Q=Q+B(M+2)*C(M+2)
      IF(M+3.NE.N)GOTO 2
      A(N)=A(N)+P*B(N)
      Q=Q+B(N)*C(N)
   2  QQ=Q
      RETURN
      END
C
C -----------------------------------------------------------
C
      SUBROUTINE SXSV(A,B,PP,N)
C
C Vector X scalar and add result to vector
C
      REAL A(N),B(N)
C
      P=PP
      M=(N/4)*4
        DO 1 I=1,M,4
        A(I)=A(I)+P*B(I)
        A(I+1)=A(I+1)+P*B(I+1)
        A(I+2)=A(I+2)+P*B(I+2)
        A(I+3)=A(I+3)+P*B(I+3)
   1    CONTINUE
      IF(M+1.GT.N)GOTO 2
      A(M+1)=A(M+1)+P*B(M+1)
      IF(M+2.GT.N)GOTO 2
      A(M+2)=A(M+2)+P*B(M+2)
      IF(M+3.NE.N)GOTO 2
      A(N)=A(N)+P*B(N)
   2  RETURN
      END
C
C -----------------------------------------------------------
C
      SUBROUTINE SXSS(A,B,P,N)
C
C Vector X scalar
C
      REAL A(N),B(N)
C
      M=(N/4)*4
        DO 1 I=1,M,4
        A(I)=P*B(I)
        A(I+1)=P*B(I+1)
        A(I+2)=P*B(I+2)
        A(I+3)=P*B(I+3)
   1    CONTINUE
      IF(M+1.GT.N)GOTO 2
      A(M+1)=P*B(M+1)
      IF(M+2.GT.N)GOTO 2
      A(M+2)=P*B(M+2)
      IF(M+3.NE.N)GOTO 2
      A(N)=P*B(N)
   2  RETURN
      END
C
C -----------------------------------------------------------
C
      SUBROUTINE SXCG(LI,NP,Q,JW,B)
C
C Solve sparse normal equations by the conjugate gradient method.
C This routine is inherently only partially vectorizable, but it
C is still worth vectorizing the loops which run 1..NP (NP is the
C number of least-squares parameters). The remaining loops involve
C indirect addressing and in any case are too short to benefit.
C
      REAL B(JW)
C
   1  FORMAT(/' Conjugate gradient solution of sparse normal ',
     +'equations'/I4,' Iterations    Ratio of residuals =',F9.5,
     +'    Maximum memory (B) =',I7)
C
C Precondition all equations
C
      JJ=2*NP
      JK=JJ+NP
      JL=JK+NP
      JT=JL+NP
      JE=JT+JJ+1
      CALL SXCA(B(1),B(JE-NP),NP)
      CALL SXCA(B(NP+1),B(JL+1),NP)
      JF=JE
   2  M=INT(B(JF))
      IF(M.EQ.0)GOTO 4
      JI=JF+M
        DO 3 JS=JF+1,JI
        JN=INT(B(JS))+JL
        B(JN)=B(JN)+B(JS+M)**2
   3    CONTINUE
      JF=JI+M+1
      GOTO 2
   4  P=0.
      J=JL
      JI=JJ
      JN=NP
        DO 5 I=1,NP
        J=J+1
        S=1./(B(J)+Q)
        JN=JN+1
        B(JN)=B(JN)*S
        S=SQRT(S)
        B(J)=S
        T=B(I)*S
        JI=JI+1
        B(JI)=T
        B(JI+NP)=T
        P=P+T**2
        B(I)=0.
   5    CONTINUE
      R=P
      L=0
      J=JE
   6  M=INT(B(J))
      IF(M.EQ.0)GOTO 8
      JI=J+M
        DO 7 JS=J+1,JI
        JN=INT(B(JS))+JL
        B(JS+M)=B(JS+M)*B(JN)
   7    CONTINUE
      J=JI+M+1
      GOTO 6
C
C Conjugate gradient iterations
C
   8  JI=JK
      JN=JT
        DO 9 J=NP+1,JJ
        JI=JI+1
        JN=JN+1
        B(JN)=B(JI)*B(J)
   9    CONTINUE
      J=JE
  10  M=INT(B(J))
      IF(M.EQ.0)GOTO 13
      Q=0.
      JI=J+M
        DO 11 JS=J+1,JI
        JN=INT(B(JS))+JK
        Q=Q+B(JN)*B(JS+M)
  11    CONTINUE
        DO 12 JS=J+1,JI
        JN=INT(B(JS))+JT
        B(JN)=B(JN)+Q*B(JS+M)
  12    CONTINUE
      J=JI+M+1
      GOTO 10
  13  T=0.
      JI=JK
      JN=JT+NP
        DO 14 J=JT+1,JN
        JI=JI+1
        T=T+B(JI)*B(J)
  14    CONTINUE
      T=P/T
      Q=P
      P=0.
      J=JK
      JI=JT
      JN=JJ
        DO 15 I=1,NP
        J=J+1
        B(I)=B(I)+T*B(J)
        JN=JN+1
        JI=JI+1
        S=B(JN)-T*B(JI)
        P=P+S**2
        B(JN)=S
  15    CONTINUE
      Q=P/Q
      S=P/R
      JN=JJ
        DO 16 J=JK+1,JL
        JN=JN+1
        B(J)=B(JN)+Q*B(J)
  16    CONTINUE
      L=L+1
      IF(L.GT.99)GOTO 17
      IF(S.GT.0.00001)GOTO 8
  17    DO 18 I=1,NP
        JL=JL+1
        B(I)=B(I)*B(JL)
  18    CONTINUE
      WRITE(LI,1)L,S,JF
      RETURN
      END
C
C -----------------------------------------------------------
C
      SUBROUTINE SXVC(FA,FB,AR,BR,CR,DR,SH,SK,SL,ST,TF,
     +F,G,A,T,N)
C
C Vector inner loop of SFLS calculation
C
      REAL FA(N),FB(N),AR(N),BR(N),CR(N),DR(N),
     +SH(N),SK(N),SL(N),ST(N),TF(N),F(N),G(N),A(3)
C
      X=A(1)
      Y=A(2)
      Z=A(3)
        DO 1 I=1,N
        C=SH(I)*X+SK(I)*Y+SL(I)*Z+ST(I)
        S=SIN(C)*TF(I)
        C=COS(C)*TF(I)
        P=S*T
        Q=C*T
        AR(I)=F(I)*C-G(I)*P
        BR(I)=F(I)*P+G(I)*C
        CR(I)=-F(I)*S-G(I)*Q
        DR(I)=F(I)*Q-G(I)*S
        FA(I)=FA(I)+AR(I)
        FB(I)=FB(I)+BR(I)
   1    CONTINUE
      RETURN
      END
C
C -----------------------------------------------------------
C
      SUBROUTINE SXCV(A,B,C,D,PP,N)
C
C Complex vector X scalar and add result to vector
C
      REAL A(N),B(N),C(N),D(N)
C
      M=(N/4)*4
      P=PP
        DO 1 I=1,M,4
        A(I)=A(I)+P*C(I)
        B(I)=B(I)+P*D(I)
        A(I+1)=A(I+1)+P*C(I+1)
        B(I+1)=B(I+1)+P*D(I+1)
        A(I+2)=A(I+2)+P*C(I+2)
        B(I+2)=B(I+2)+P*D(I+2)
        A(I+3)=A(I+3)+P*C(I+3)
        B(I+3)=B(I+3)+P*D(I+3)
   1    CONTINUE
      IF(M+1.GT.N)GOTO 2
      A(M+1)=A(M+1)+P*C(M+1)
      B(M+1)=B(M+1)+P*D(M+1)
      IF(M+2.GT.N)GOTO 2
      A(M+2)=A(M+2)+P*C(M+2)
      B(M+2)=B(M+2)+P*D(M+2)
      IF(M+3.NE.N)GOTO 2
      A(N)=A(N)+P*C(N)
      B(N)=B(N)+P*D(N)
   2  RETURN
      END
C
C -----------------------------------------------------------
C
      SUBROUTINE SXCT(A,B,C,D,E,PP,N)
C
C Complex vector X vector X scalar and add result to vector
C
      REAL A(N),B(N),C(N),D(N),E(N)
C
      M=(N/4)*4
      P=PP
        DO 1 I=1,M,4
        A(I)=A(I)+P*C(I)*D(I)
        B(I)=B(I)+P*C(I)*E(I)
        A(I+1)=A(I+1)+P*C(I+1)*D(I+1)
        B(I+1)=B(I+1)+P*C(I+1)*E(I+1)
        A(I+2)=A(I+2)+P*C(I+2)*D(I+2)
        B(I+2)=B(I+2)+P*C(I+2)*E(I+2)
        A(I+3)=A(I+3)+P*C(I+3)*D(I+3)
        B(I+3)=B(I+3)+P*C(I+3)*E(I+3)
   1    CONTINUE
      IF(M+1.GT.N)GOTO 2
      A(M+1)=A(M+1)+P*C(M+1)*D(M+1)
      B(M+1)=B(M+1)+P*C(M+1)*E(M+1)
      IF(M+2.GT.N)GOTO 2
      A(M+2)=A(M+2)+P*C(M+2)*D(M+2)
      B(M+2)=B(M+2)+P*C(M+2)*E(M+2)
      IF(M+3.NE.N)GOTO 2
      A(N)=A(N)+P*C(N)*D(N)
      B(N)=B(N)+P*C(N)*E(N)
   2  RETURN
      END
C
C -----------------------------------------------------------
C
      SUBROUTINE SXCD(A,B,C,D,E,N)
C
C Complex vector X vector and add result to vector
C
      REAL A(N),B(N),C(N),D(N),E(N)
C
      M=(N/4)*4
        DO 1 I=1,M,4
        A(I)=A(I)+C(I)*D(I)
        B(I)=B(I)+C(I)*E(I)
        A(I+1)=A(I+1)+C(I+1)*D(I+1)
        B(I+1)=B(I+1)+C(I+1)*E(I+1)
        A(I+2)=A(I+2)+C(I+2)*D(I+2)
        B(I+2)=B(I+2)+C(I+2)*E(I+2)
        A(I+3)=A(I+3)+C(I+3)*D(I+3)
        B(I+3)=B(I+3)+C(I+3)*E(I+3)
   1    CONTINUE
      IF(M+1.GT.N)GOTO 2
      A(M+1)=A(M+1)+C(M+1)*D(M+1)
      B(M+1)=B(M+1)+C(M+1)*E(M+1)
      IF(M+2.GT.N)GOTO 2
      A(M+2)=A(M+2)+C(M+2)*D(M+2)
      B(M+2)=B(M+2)+C(M+2)*E(M+2)
      IF(M+3.NE.N)GOTO 2
      A(N)=A(N)+C(N)*D(N)
      B(N)=B(N)+C(N)*E(N)
   2  RETURN
      END
C
C -----------------------------------------------------------
C
      SUBROUTINE SXFX(FA,FB,GA,GB,SH,SK,SL,ST,TF,F,G,A,TT,N)
C
C Vector computer inner loop of final SF calculation for SX3H
C
      REAL FA(N),FB(N),GA(N),GB(N),SH(N),SK(N),SL(N),ST(N),
     +TF(N),F(N),G(N),A(3)
C
      X=A(1)
      Y=A(2)
      Z=A(3)
      T=TT
        DO 1 I=1,N
        C=SH(I)*X+SK(I)*Y+SL(I)*Z+ST(I)
        S=SIN(C)*TF(I)*T
        C=COS(C)*TF(I)
        AR=F(I)*C
        BR=F(I)*S
        CR=G(I)*C
        DR=G(I)*S
        FA(I)=FA(I)+AR-DR
        FB(I)=FB(I)+BR+CR
        GA(I)=GA(I)+AR+DR
        GB(I)=GB(I)-BR+CR
   1    CONTINUE
      RETURN
      END
C
C -----------------------------------------------------------
C
      SUBROUTINE SXSM(A,B,C,D,N)
C
C Combine two parts of derivative sums before adding to l.s. matrix
C
      REAL A(N),B(N),C(N),D(N)
C
      M=(N/4)*4
        DO 1 I=1,M,4
        A(I)=C(I)*A(I)+D(I)*B(I)
        A(I+1)=C(I+1)*A(I+1)+D(I+1)*B(I+1)
        A(I+2)=C(I+2)*A(I+2)+D(I+2)*B(I+2)
        A(I+3)=C(I+3)*A(I+3)+D(I+3)*B(I+3)
   1    CONTINUE
      IF(M+1.GT.N)GOTO 2
      A(M+1)=C(M+1)*A(M+1)+D(M+1)*B(M+1)
      IF(M+2.GT.N)GOTO 2
      A(M+2)=C(M+2)*A(M+2)+D(M+2)*B(M+2)
      IF(M+3.NE.N)GOTO 2
      A(N)=C(N)*A(N)+D(N)*B(N)
   2  RETURN
      END
C
C -----------------------------------------------------------
C
      SUBROUTINE SXSP(A,B,C,N)
C
C Vector X vector
C
      REAL A(N),B(N),C(N)
C
      M=(N/4)*4
        DO 1 I=1,M,4
        A(I)=B(I)*C(I)
        A(I+1)=B(I+1)*C(I+1)
        A(I+2)=B(I+2)*C(I+2)
        A(I+3)=B(I+3)*C(I+3)
   1    CONTINUE
      IF(M+1.GT.N)GOTO 2
      A(M+1)=B(M+1)*C(M+1)
      IF(M+2.GT.N)GOTO 2
      A(M+2)=B(M+2)*C(M+2)
      IF(M+3.NE.N)GOTO 2
      A(N)=B(N)*C(N)
   2  RETURN
      END
C
C -----------------------------------------------------------
C
      SUBROUTINE SXCS(A,B,C,D,N)
C
C Complex vector add
C
      REAL A(N),B(N),C(N),D(N)
C
      M=(N/4)*4
        DO 1 I=1,M,4
        A(I)=A(I)+C(I)
        B(I)=B(I)+D(I)
        A(I+1)=A(I+1)+C(I+1)
        B(I+1)=B(I+1)+D(I+1)
        A(I+2)=A(I+2)+C(I+2)
        B(I+2)=B(I+2)+D(I+2)
        A(I+3)=A(I+3)+C(I+3)
        B(I+3)=B(I+3)+D(I+3)
   1    CONTINUE
      IF(M+1.GT.N)GOTO 2
      A(M+1)=A(M+1)+C(M+1)
      B(M+1)=B(M+1)+D(M+1)
      IF(M+2.GT.N)GOTO 2
      A(M+2)=A(M+2)+C(M+2)
      B(M+2)=B(M+2)+D(M+2)
      IF(M+3.NE.N)GOTO 2
      A(N)=A(N)+C(N)
      B(N)=B(N)+D(N)
   2  RETURN
      END
C
C -----------------------------------------------------------
C
      SUBROUTINE SXCP(A,B,C,D,P,N)
C
C Complex vector X scalar (not important but easy to vectorize)
C
      REAL A(N),B(N),C(N),D(N)
C
        DO 1 I=1,N
        A(I)=P*C(I)
        B(I)=P*D(I)
   1    CONTINUE
      RETURN
      END
C
C -----------------------------------------------------------
C
      SUBROUTINE SXDI(A,B,C,D,E,P,N)
C
C Vector product used for isotropic U derivatives
C (not important but easy to vectorize)
C
      REAL A(N),B(N),C(N),D(N),E(N)
C
        DO 1 I=1,N
        T=P*C(I)
        A(I)=T*D(I)
        B(I)=T*E(I)
   1    CONTINUE
      RETURN
      END
C
C -----------------------------------------------------------
C
      SUBROUTINE SXFC(FA,FB,DE,DD,DF,DG,HO,FF,SI,FC,SQ,WL,
     +SH,SK,SZ,MB,N,LM,A)
C
C Calculate Fc etc. for structure-factor least-squares
C
      INTEGER MB(N)
      REAL FF(N),SI(N),FC(N),SQ(N),WL(N),SH(N),SK(N),SZ(N)
      REAL FA(N),FB(N),DD(N),DE(N),DF(N),DG(N),HO(N),A(LM)
      COMMON/MEM/ST,SL,TC,TL,IV,LR,LG,LH,LI,LP,LF,LA,LC,LW,LY,LL,LB,
     +LX,LE,LV,LJ,LD,LS,LO,LT,LK,LQ,LZ,LN,KH,JA,JB,JC,JD,JE,HA,HD
C
      WW=A(69)
      IF(ABS(A(75)-1.).LT.0.00001)WW=1.
        DO 1 I=1,N
        DF(I)=1.
        FC(I)=FA(I)**2+FB(I)**2
        DD(I)=0.
        DE(I)=0.
   1    CONTINUE
      NA=INT(1.001*ABS(A(167)))
      NB=LS
      IF(NA.GT.0)NB=LS-12
      IF(NB.LE.LD)GOTO 3
      IF(INT(A(160)).NE.0)GOTO 3
C
C The following loop (BASF) does not vectorize, but is rarely entered
C
        DO 2 I=1,N
        K=IABS(MB(I))
        IF(K.LE.1)GOTO 2
        L=K+LD-1
        IF(L.GT.NB)GOTO 2
        DF(I)=A(L)
   2    CONTINUE
C
C Anisotropic scaling
C
   3  IF(NA.EQ.0)GOTO 5
      NA=NA+LD
        DO 4 I=1,N
        HO(I)=FC(I)
        S=1./SQ(I)
        T=-.0506606*(SH(I)**2*A(14)*(A(NA)*S+A(NA+6))+SK(I)**2*A(15)
     +  *(A(NA+1)*S+A(NA+7))+SZ(I)**2*A(16)*(A(NA+2)*S+A(NA+8))+
     +  SK(I)*SZ(I)*A(17)*(A(NA+3)*S+A(NA+9))+SH(I)*SZ(I)*A(18)*
     +  (A(NA+4)*S+A(NA+10))+SH(I)*SK(I)*A(19)*(A(NA+5)*S+A(NA+11)))
        T=AMAX1(T,0.)
        FC(I)=FC(I)*T
        T=SQRT(T)
        FA(I)=FA(I)*T
        FB(I)=FB(I)*T
   4    CONTINUE
C
C Apply extinction if necessary
C
   5  IF(A(39).LT.-8.E9)GOTO 9
      IF(A(200).GT.-998.)GOTO 7
        DO 6 I=1,N
        P=WL(I)**2
        T=P*SQ(I)
        X=0.0005*P*ABS(WL(I))*FC(I)/SQRT(ABS(T*(1.-T)))
        P=1.+X*A(39)
        T=SQRT(P)
        FF(I)=FF(I)*T
        SI(I)=SI(I)*T
        DE(I)=-0.5*X*FC(I)/P
        T=1.-0.5*X*A(39)/P
        FA(I)=FA(I)*T
        FB(I)=FB(I)*T
   6    CONTINUE
      GOTO 9
C
C Bulk solvent correction
C
   7    DO 8 I=1,N
        P=EXP(-78.956835*A(200)*SQ(I))
        Q=A(39)*P-1.
        DE(I)=100.*P*Q*FC(I)
        DD(I)=-1579.1367*A(39)*DE(I)*SQ(I)
        T=Q**2
        FC(I)=FC(I)*T
        FA(I)=FA(I)*T
        FB(I)=FB(I)*T
        HO(I)=HO(I)*T
   8    CONTINUE
C
C Apply weighting scheme, sum residuals
C
   9  A(125)=A(125)+REAL(N)
        DO 10 I=1,N
        FF(I)=FF(I)/DF(I)
        SI(I)=SI(I)/DF(I)
        W=AMAX1(0.,WW*FF(I)/A(75))+(1.-WW)*FC(I)
        W=(A(70)+A(71)*EXP(A(66)*SQ(I)))/((SI(I)/A(75))**2+
     +  (A(64)*W)**2+A(67)+A(65)*W+A(68)*SQRT(SQ(I)))
        A(126)=A(126)+W*FF(I)**2
        A(127)=A(127)+W*FF(I)*FC(I)
        A(128)=A(128)+W*FC(I)**2
        A(169)=A(169)+W*FC(I)
        W=SQRT(W)
        FA(I)=2.*FA(I)*W
        FB(I)=2.*FB(I)*W
        DD(I)=W*DD(I)
        DE(I)=W*DE(I)
        DF(I)=W*FF(I)
        DG(I)=W*FC(I)
        HO(I)=W*HO(I)
  10    CONTINUE
      RETURN
      END
C
C -----------------------------------------------------------
C
      SUBROUTINE SXTC(DA,DE,DD,DF,DG,FF,SI,FC,SQ,WL,SH,SK,SZ,HO,LD,N,
     +LM,A)
      REAL DA(N),DE(N),DD(N),DF(N),DG(N),FF(N),SI(N),FC(N)
      REAL SQ(N),WL(N),SH(N),SK(N),SZ(N),HO(N),A(LM)
C
C Calculate Fc etc. for twinned and powder least-squares
C
      WW=A(69)
      IF(ABS(A(75)-1.).LT.0.00001)WW=1.
        DO 1 I=1,N
        DA(I)=1.
        DE(I)=0.
        DD(I)=0.
   1    CONTINUE
C
C Anisotropic scaling
C
      NA=INT(1.0001*ABS(A(167)))
      IF(NA.EQ.0)GOTO 3
      NA=NA+LD
        DO 2 I=1,N
        HO(I)=FC(I)
        S=1./SQ(I)
        T=-.0506606*(SH(I)**2*A(14)*(A(NA)*S+A(NA+6))+SK(I)**2*A(15)
     +  *(A(NA+1)*S+A(NA+7))+SZ(I)**2*A(16)*(A(NA+2)*S+A(NA+8))+
     +  SK(I)*SZ(I)*A(17)*(A(NA+3)*S+A(NA+9))+SH(I)*SZ(I)*A(18)*
     +  (A(NA+4)*S+A(NA+10))+SH(I)*SK(I)*A(19)*(A(NA+5)*S+A(NA+11)))
        T=AMAX1(T,0.)
        FC(I)=FC(I)*T
        DA(I)=T
   2    CONTINUE
C
C Apply extinction if necessary
C
   3  IF(A(39).LT.-8.E9)GOTO 7
      IF(A(200).GT.-998.)GOTO 5
        DO 4 I=1,N
        P=WL(I)**2
        T=P*SQ(I)
        X=0.0005*P*ABS(WL(I))*FC(I)/SQRT(ABS(T*(1.-T)))
        P=1.+X*A(39)
        T=SQRT(P)
        FF(I)=FF(I)*T
        SI(I)=SI(I)*T
        DE(I)=-0.5*X*FC(I)/P
        DA(I)=DA(I)*(1.-0.5*X*A(39)/P)
   4    CONTINUE
      GOTO 7
C
C Bulk solvent correction
C
   5    DO 6 I=1,N
        P=EXP(-78.956835*A(200)*SQ(I))
        Q=A(39)*P-1.
        DE(I)=100.*P*Q*FC(I)
        DD(I)=-1579.1367*A(39)*DE(I)*SQ(I)
        T=Q**2
        FC(I)=FC(I)*T
        DA(I)=DA(I)*T
   6    CONTINUE
C
C Apply weighting scheme, sum residuals
C
   7  A(125)=A(125)+REAL(N)
        DO 8 I=1,N
        W=AMAX1(0.,WW*FF(I)/A(75))+(1.-WW)*FC(I)
        W=(A(70)+A(71)*EXP(A(66)*SQ(I)))/((SI(I)/A(75))**2+
     +  (A(64)*W)**2+A(67)+A(65)*W+A(68)*SQRT(SQ(I)))
        A(126)=A(126)+W*FF(I)**2
        A(127)=A(127)+W*FF(I)*FC(I)
        A(128)=A(128)+W*FC(I)**2
        A(169)=A(169)+W*FC(I)
        W=SQRT(W)
        DA(I)=2.*DA(I)*W
        DE(I)=W*DE(I)
        DD(I)=W*DD(I)
        DF(I)=W*FF(I)
        DG(I)=W*FC(I)
   8    CONTINUE
      RETURN
      END
C
C -----------------------------------------------------------
C
      SUBROUTINE SXSF(FA,FB,GA,GB,DA,DB,WT,DX,DY,DZ,FF,SI,FC,
     +SQ,WL,SH,SK,SZ,MB,MH,MK,ML,N,M,MR,LM,A,KD)
C
C Calculate Fc etc. for final structure-factor cycle
C
      CHARACTER*1 KD
      CHARACTER*255 KO
      INTEGER MB(N),MH(N),MK(N),ML(N)
      REAL FF(N),SI(N),FC(N),SQ(N),WL(N),SH(N),SK(N),SZ(N),A(LM),E(20)
      REAL FA(N),FB(N),GA(N),GB(N),DA(N),DB(N),WT(N),DX(N),DY(N),DZ(N)
      COMMON/MEM/ST,SL,TC,TL,IV,LR,LG,LH,LI,LP,LF,LA,LC,LW,LY,LL,LB,
     +LX,LE,LV,LJ,LD,LS,LO,LT,LK,LQ,LZ,LN,KH,JA,JB,JC,JD,JE,HA,HD
C
   1  FORMAT(3(I4,'$'),20(F11.2,'$'))
   2  FORMAT(3(I4,'$'),20(F11.0,'$'))
   3  FORMAT(A)
C
      WW=A(69)
      IF(ABS(A(75)-1.).LT.0.00001)WW=1.
      MX=INT(A(160))
      NA=N
      IF(A(23).GT.0.5)GOTO 5
        DO 4 I=1,N
        DZ(I)=1.
        FC(I)=FA(I)**2+FB(I)**2
        DA(I)=FA(I)
        DB(I)=0.
   4    CONTINUE
      GOTO 7
   5    DO 6 I=1,N
        DZ(I)=1.
        FC(I)=FA(I)**2+FB(I)**2
        DA(I)=0.5*(FA(I)+GA(I))
        DB(I)=0.5*(FB(I)-GB(I))
        GA(I)=GA(I)**2+GB(I)**2-FC(I)
   6    CONTINUE
   7  NC=INT(1.0001*ABS(A(167)))
      ND=LS
      IF(NC.NE.0)ND=LS-12
      IF(ND.LE.LD)GOTO 9
      IF(MX.NE.0)GOTO 9
C
C The following loop (BASF) does not vectorize, but is rarely entered
C
        DO 8 I=1,N
        K=IABS(MB(I))
        IF(K.LE.1)GOTO 8
        L=K+LD-1
        IF(L.GT.ND)GOTO 8
        DZ(I)=A(L)
   8    CONTINUE
C
C Combine twin or powder components
C
   9  IF(MX.EQ.0)GOTO 16
      NF=MR
      MT=M
      M=0
      NA=0
      MR=0
      I=0
  10  I=I+1
      IF(I.GT.N)GOTO 16
      K=I
  11  IF(MB(I).GT.0)GOTO 12
      I=I+1
      GOTO 11
  12  NA=NA+1
      IF(I.LE.NF)MR=NA
      IF(I.LE.MT)M=NA
      MH(NA)=MH(I)
      MK(NA)=MK(I)
      ML(NA)=ML(I)
      FF(NA)=FF(I)
      SI(NA)=SI(I)
      SH(NA)=SH(I)
      SK(NA)=SK(I)
      SZ(NA)=SZ(I)
      SQ(NA)=SQ(I)
      WL(NA)=WL(I)
      DA(NA)=DA(I)
      DB(NA)=DB(I)
      X=0.
      Y=0.
        DO 15 L=K,I
        NT=IABS(MB(L))
        IF(MX.GT.-990)GOTO 13
        T=REAL(NT)
        GOTO 14
  13    T=1./ABS(A(160))
        IF(LS.LE.LD)GOTO 14
        T=A(168)
        IF(NT.EQ.1)GOTO 14
        T=A(LD+NT-1)
  14    FB(L)=T*FC(L)
        X=X+FB(L)
        Y=Y+T*GA(L)
  15    CONTINUE
      FC(NA)=X
      FA(NA)=X
      GA(NA)=Y
      GOTO 10
C
C Anisotropic scaling
C
  16  IF(NC.EQ.0)GOTO 18
      NC=NC+LD
        DO 17 I=1,NA
        S=1./SQ(I)
        T=-.0506606*(SH(I)**2*A(14)*(A(NC)*S+A(NC+6))+SK(I)**2*A(15)
     +  *(A(NC+1)*S+A(NC+7))+SZ(I)**2*A(16)*(A(NC+2)*S+A(NC+8))+
     +  SK(I)*SZ(I)*A(17)*(A(NC+3)*S+A(NC+9))+SH(I)*SZ(I)*A(18)*
     +  (A(NC+4)*S+A(NC+10))+SH(I)*SK(I)*A(19)*(A(NC+5)*S+A(NC+11)))
        T=AMAX1(T,0.)
        FC(I)=FC(I)*T
        GA(I)=GA(I)*T
        T=SQRT(T)
        DA(I)=DA(I)*T
        DB(I)=DB(I)*T
  17    CONTINUE
C
C Apply extinction if necessary
C
  18  IF(A(39).LT.-8.E9)GOTO 22
      IF(A(200).GT.-998.)GOTO 20
        DO 19 I=1,NA
        P=WL(I)**2
        T=P*SQ(I)
        X=0.0005*P*ABS(WL(I))*FC(I)/SQRT(ABS(T*(1.-T)))
        P=1.+X*A(39)
        T=SQRT(P)
        FF(I)=FF(I)*T
        SI(I)=SI(I)*T
  19    CONTINUE
      GOTO 22
C
C Bulk solvent correction
C
  20    DO 21 I=1,NA
        T=1.-A(39)*EXP(-78.956835*A(200)*SQ(I))
        FC(I)=FC(I)*T**2
        DA(I)=DA(I)*T
        DB(I)=DB(I)*T
        GA(I)=GA(I)*T**2
  21    CONTINUE
C
C Apply weighting scheme, sum residuals, set up Flack x-refinement
C
  22    DO 24 I=1,NA
        FF(I)=FF(I)/DZ(I)
        SI(I)=SI(I)/DZ(I)
        W=AMAX1(0.,WW*FF(I)/A(75))+(1.-WW)*FC(I)
        WT(I)=(A(70)+A(71)*EXP(A(66)*SQ(I)))/((SI(I)/A(75))**2+
     +  (A(64)*W)**2+A(67)+A(65)*W+A(68)*SQRT(SQ(I)))
        IF(A(134).LT.FC(I))A(134)=FC(I)
        IF(A(135).LT.SQ(I))A(135)=SQ(I)
        IF(I.LE.M)GOTO 23
        IF(I.GT.MR)GOTO 23
        T=SQRT(AMAX1(FF(I)/A(75),0.))
        V=SQRT(FC(I))
        A(163)=A(163)+T
        A(164)=A(164)+ABS(T-V)
        A(124)=A(124)+1.
        IF(FF(I).LT.2.*SI(I))GOTO 24
        A(161)=A(161)+T
        A(162)=A(162)+ABS(T-V)
        A(165)=A(165)+1.
        GOTO 24
  23    A(125)=A(125)+1.
        A(126)=A(126)+WT(I)*FF(I)**2
        A(127)=A(127)+WT(I)*FF(I)*FC(I)
        A(128)=A(128)+WT(I)*FC(I)**2
        P=SQRT(AMAX1(FF(I)/A(75),0.))
        T=ABS(P-SQRT(FC(I)))
        A(174)=A(174)+T
        A(175)=A(175)+P
        IF(I.GT.M)GOTO 24
        IF(FF(I).LT.2.*SI(I))GOTO 24
        A(129)=A(129)+1.
        A(130)=A(130)+T
        A(131)=A(131)+P
        A(171)=A(171)+WT(I)*FF(I)**2
        A(172)=A(172)+WT(I)*FF(I)*FC(I)
        A(173)=A(173)+WT(I)*FC(I)**2
  24    CONTINUE
      IF(A(23).LT.0.5)GOTO 26
        DO 25 I=1,M
        W=SQRT(WT(I))
        DX(I)=W*FC(I)
        DY(I)=W*GA(I)
        DZ(I)=W*FF(I)
  25    CONTINUE
  26  MR=NA
C
C LIST 7 Output of twin contributions
C
      IF(MX.EQ.0)GOTO 36
      IF(INT(A(73)).NE.7)GOTO 36
      J=MIN0(IABS(MX)+2,20)
      NA=0
      I=0
  27  I=I+1
      IF(I.GT.N)GOTO 36
      K=I
  28  IF(MB(I).GT.0)GOTO 29
      I=I+1
      GOTO 28
  29  NA=NA+1
      T=A(155)*FC(NA)/AMAX1(1.E-8,FA(NA))
        DO 30 L=3,J
        E(L)=-1.
  30    CONTINUE
      E(1)=FF(NA)*A(155)/A(75)
      E(2)=SI(NA)*A(155)/A(75)
      Q=AMAX1(ABS(E(1)),E(2))
        DO 31 L=K,I
        NT=IABS(MB(L))+2
        IF(NT.EQ.2)GOTO 31
        IF(NT.GT.20)GOTO 31
        E(NT)=T*FB(L)
        Q=AMAX1(Q,E(NT),-10.*E(NT))
  31    CONTINUE
      IF(Q.GT.99999999.99)GOTO 32
      WRITE(KO,1)MH(NA),MK(NA),ML(NA),(E(L),L=1,J)
      GOTO 33
  32  WRITE(KO,2)MH(NA),MK(NA),ML(NA),(E(L),L=1,J)
  33  K=0
        DO 35 L=1,12*J+15
        IF(KO(L:L).EQ.' ')GOTO 35
        IF(KO(L:L).NE.'.')GOTO 34
        IF(KO(L+1:L+3).EQ.'00$')KO(L+1:L+2)='  '
        IF(KO(L+2:L+3).EQ.'0$')KO(L+2:L+2)=' '
  34    K=K+1
        KO(K:K)=KO(L:L)
        IF(KO(K:K).EQ.'$')KO(K:K)=' '
  35    CONTINUE
      IF(KO(K:K).EQ.' ')K=K-1
      WRITE(LZ,3)KO(1:K)//KD
      GOTO 27
  36  RETURN
      END
C
C -----------------------------------------------------------
C
      SUBROUTINE SXHX(E,TT,SS,XX,YY,N)
C
C hx summations for Fourier - suitable for optimization but
C probably not vectorization
C
      REAL E(N)
C
      T=TT
      S=SS
      X=XX
      Y=YY
        DO 1 I=1,N,2
        E(I)=E(I)+T
        E(I+1)=E(I+1)+S
        Q=T*X-S*Y
        S=T*Y+S*X
        T=Q
   1    CONTINUE
      SS=S
      TT=T
      RETURN
      END
C
C -----------------------------------------------------------
C
      SUBROUTINE SXKY(F,G,C,D,UU,VV,N)
C
C ky summations for Fourier
C
      REAL F(N),G(N),C(N),D(N)
C
      U=UU
      V=VV
        DO 1 I=1,N
        F(I)=F(I)+U*C(I)-V*D(I)
        G(I)=G(I)-V*C(I)-U*D(I)
   1    CONTINUE
      RETURN
      END
C
C -----------------------------------------------------------
C
      SUBROUTINE SXLZ(E,F,G,UU,VV,N)
C
C lz summations for Fourier
C
      REAL E(N),F(N),G(N)
C
      U=UU
      V=VV
        DO 1 I=1,N
        E(I)=E(I)+V*F(I)+U*G(I)
   1    CONTINUE
      RETURN
      END
C
C -----------------------------------------------------------
C
      SUBROUTINE SXVS(FA,FB,SH,SK,SZ,ST,TF,F,G,A,T,N)
C
C Vector computer inner loop of structure factor summation for SX3G
C
      REAL FA(N),FB(N),SH(N),SK(N),SZ(N),ST(N),TF(N),F(N),G(N),A(3)
C
      X=A(1)
      Y=A(2)
      Z=A(3)
        DO 1 I=1,N
        C=SH(I)*X+SK(I)*Y+SZ(I)*Z+ST(I)
        S=SIN(C)*TF(I)
        C=COS(C)*TF(I)
        FA(I)=FA(I)+F(I)*C-G(I)*S*T
        FB(I)=FB(I)+F(I)*S*T+G(I)*C
   1    CONTINUE
      RETURN
      END
C
C -----------------------------------------------------------
C
      SUBROUTINE SXVR(U,V,W,FA,FB,FC,FD,FF,FG,SI,SQ,WL,SH,SK,SZ,
     +MB,MH,MK,ML,N,LM,A)
C
C Vector Fc summation for SX3G including extinction and BASF
C
      INTEGER MB(N),MH(N),MK(N),ML(N)
      REAL FA(N),FB(N),FC(N),FD(N),FF(N),FG(N),SI(N),SQ(N),WL(N)
      REAL SH(N),SK(N),SZ(N),A(LM)
      COMMON/MEM/ST,SL,TC,TL,IV,LR,LG,LH,LI,LP,LF,LA,LC,LW,LY,LL,LB,
     +LX,LE,LV,LJ,LD,LS,LO,LT,LK,LQ,LZ,LN,KH,JA,JB,JC,JD,JE,HA,HD
C
      MX=INT(A(160))
        DO 1 I=1,N
        FG(I)=1.
        FC(I)=FA(I)**2+FB(I)**2
   1    CONTINUE
      NA=INT(1.0001*ABS(A(167)))
      ND=LS
      IF(NA.NE.0)ND=LS-12
      IF(ND.LE.LD)GOTO 3
      IF(MX.NE.0)GOTO 3
C
C The following loop does not vectorize, but is rarely entered
C
        DO 2 I=1,N
        K=IABS(MB(I))
        IF(K.LE.1)GOTO 2
        L=K+LD-1
        IF(L.GT.ND)GOTO 2
        FG(I)=A(L)
   2    CONTINUE
C
C Combine twin or powder components
C
   3  IF(MX.EQ.0)GOTO 10
      NN=N
      N=0
      I=0
   4  I=I+1
      IF(I.GT.NN)GOTO 10
      K=I
   5  IF(MB(I).GT.0)GOTO 6
      I=I+1
      GOTO 5
   6  N=N+1
      MH(N)=MH(I)
      MK(N)=MK(I)
      ML(N)=ML(I)
      FF(N)=FF(I)
      SI(N)=SI(I)
      SQ(N)=SQ(I)
      WL(N)=WL(I)
      FA(N)=FA(I)
      FB(N)=FB(I)
      Y=0.
        DO 9 L=K,I
        NT=IABS(MB(L))
        IF(MX.GT.-990)GOTO 7
        T=REAL(NT)
        GOTO 8
   7    T=1./ABS(A(160))
        IF(LS.LE.LD)GOTO 8
        T=A(168)
        IF(NT.EQ.1)GOTO 8
        T=A(LD+NT-1)
   8    Y=Y+T*FC(L)
   9    CONTINUE
      FC(N)=Y
      GOTO 4
C
C Anisotropic scaling
C
  10  IF(NA.EQ.0)GOTO 12
      NA=NA+LD
        DO 11 I=1,N
        S=1./SQ(I)
        T=-.0506606*(SH(I)**2*A(14)*(A(NA)*S+A(NA+6))+SK(I)**2*A(15)
     +  *(A(NA+1)*S+A(NA+7))+SZ(I)**2*A(16)*(A(NA+2)*S+A(NA+8))+
     +  SK(I)*SZ(I)*A(17)*(A(NA+3)*S+A(NA+9))+SH(I)*SZ(I)*A(18)*
     +  (A(NA+4)*S+A(NA+10))+SH(I)*SK(I)*A(19)*(A(NA+5)*S+A(NA+11)))
        T=AMAX1(T,0.)
        FC(I)=FC(I)*T
        T=SQRT(T)
        FA(I)=FA(I)*T
        FB(I)=FB(I)*T
  11    CONTINUE
C
C Apply extinction if necessary
C
  12  IF(A(39).LT.-8.E9)GOTO 16
      IF(A(200).GT.-998.)GOTO 14
        DO 13 I=1,N
        S=FC(I)
        P=WL(I)**2
        T=P*SQ(I)
        Q=SQRT(1.+.0005*A(39)*P*ABS(WL(I))*S/
     +  SQRT(ABS(T*(1.-T))))/FG(I)
        T=AMAX1(0.,Q*FF(I))
        Q=1./(SI(I)**2+(A(64)*S)**2)
        U=U+Q*T**2
        V=V+Q*T*S
        W=W+Q*S**2
        Q=AMAX1(T**2,0.)/(T**2+4.*(Q*SI(I))**2)
        FA(I)=FA(I)*Q
        FB(I)=FB(I)*Q
        T=SQRT(T/(S+1.E-8))
        FC(I)=FA(I)*T
        FD(I)=FB(I)*T
        FG(I)=S
  13    CONTINUE
      GOTO 18
C
C Bulk solvent correction
C
  14    DO 15 I=1,N
        S=FC(I)*(A(39)*EXP(-78.956835*A(200)*SQ(I))-1.)**2
        T=AMAX1(0.,FF(I)/FG(I))
        Q=1./(SI(I)**2+(A(64)*S)**2)
        U=U+Q*T**2
        V=V+Q*T*S
        W=W+Q*S**2
        Q=AMAX1(T**2,0.)/(T**2+4.*(SI(I)/FG(I))**2)
        FA(I)=FA(I)*Q
        FB(I)=FB(I)*Q
        T=SQRT(T/(S+1.E-8))
        FC(I)=FA(I)*T
        FD(I)=FB(I)*T
        FG(I)=S
  15    CONTINUE
      GOTO 18
C
C No corrections
C
  16    DO 17 I=1,N
        S=FC(I)
        T=AMAX1(0.,FF(I)/FG(I))
        Q=1./(SI(I)**2+(A(64)*S)**2)
        U=U+Q*T**2
        V=V+Q*T*S
        W=W+Q*S**2
        Q=AMAX1(T**2,0.)/(T**2+4.*(SI(I)/FG(I))**2)
        FA(I)=FA(I)*Q
        FB(I)=FB(I)*Q
        T=SQRT(T/(S+1.E-8))
        FC(I)=FA(I)*T
        FD(I)=FB(I)*T
        FG(I)=S
  17    CONTINUE
  18  RETURN
      END
C
C -----------------------------------------------------------
C
      SUBROUTINE SXVD(A,SH,SK,SZ,ST,FA,FB,FC,FD,N)
C
C Vector point Fourier used to locate H-atoms in SX3G
C
      REAL A(5),SH(N),SK(N),SZ(N),ST(N),FA(N),FB(N),FC(N),FD(N)
C
      P=A(1)
      Q=A(2)
      X=A(3)
      Y=A(4)
      Z=A(5)
        DO 1 I=1,N
        C=SH(I)*X+SK(I)*Y+SZ(I)*Z+ST(I)
        S=SIN(C)
        C=COS(C)
        P=P+C*FC(I)+S*FD(I)
        Q=Q+C*FA(I)+S*FB(I)
   1    CONTINUE
      A(1)=P
      A(2)=Q
      RETURN
      END
C
C -----------------------------------------------------------
C
      SUBROUTINE SXVE(SH,SK,SZ,ST,HH,HK,HL,A,N)
C
C Generate equivalent index and shift vectors
C
      REAL SH(N),SK(N),SZ(N),ST(N),HH(N),HK(N),HL(N),A(12)
C
        DO 1 I=1,N
        SH(I)=A(1)*HH(I)+A(4)*HK(I)+A(7)*HL(I)
        SK(I)=A(2)*HH(I)+A(5)*HK(I)+A(8)*HL(I)
        SZ(I)=A(3)*HH(I)+A(6)*HK(I)+A(9)*HL(I)
        ST(I)=A(10)*HH(I)+A(11)*HK(I)+A(12)*HL(I)
   1    CONTINUE
      RETURN
      END
C
C -----------------------------------------------------------
C
      SUBROUTINE SXZA(A,N)
C
C Zero first N elements of array A.  Some computers may have a
C fast routine which could be used here.
C
      REAL A(N)
C
      M=(N/4)*4
        DO 1 I=1,M,4
        A(I)=0.
        A(I+1)=0.
        A(I+2)=0.
        A(I+3)=0.
   1    CONTINUE
      IF(M+1.GT.N)GOTO 2
      A(M+1)=0.
      IF(M+2.GT.N)GOTO 2
      A(M+2)=0.
      IF(M+3.NE.N)GOTO 2
      A(N)=0.
   2  RETURN
      END
C
C -----------------------------------------------------------
C
      SUBROUTINE SXCA(A,B,N)
C
C Copy N elements from array A to array B.  Some computers may
C have a fast byte string copy routine which could be used here.
C
      REAL A(N),B(N)
C
      M=(N/4)*4
        DO 1 I=1,M,4
        B(I)=A(I)
        B(I+1)=A(I+1)
        B(I+2)=A(I+2)
        B(I+3)=A(I+3)
   1    CONTINUE
      IF(M+1.GT.N)GOTO 2
      B(M+1)=A(M+1)
      IF(M+2.GT.N)GOTO 2
      B(M+2)=A(M+2)
      IF(M+3.NE.N)GOTO 2
      B(N)=A(N)
   2  RETURN
      END
C
C -----------------------------------------------------------
C
      SUBROUTINE SXVH(HH,HK,HL,MH,MK,ML,N)
C
C Vector multiply reflection indices by 2*pi
C
      INTEGER MH(N),MK(N),ML(N)
C
      REAL HH(N),HK(N),HL(N)
      T=6.2831853
        DO 1 I=1,N
        HH(I)=T*REAL(MH(I))
        HK(I)=T*REAL(MK(I))
        HL(I)=T*REAL(ML(I))
   1    CONTINUE
      RETURN
      END
C
C -----------------------------------------------------------
C
      SUBROUTINE SXVA(TF,SH,SK,SZ,C,A,N)
C
C Generate anisotropic temperature factor vector multiplied by s.o.f.
C
      REAL TF(N),SH(N),SK(N),SZ(N),C(19),A(10)
C
      U1=A(5)*C(14)
      U2=A(6)*C(15)
      U3=A(7)*C(16)
      U4=A(8)*C(17)
      U5=A(9)*C(18)
      U6=A(10)*C(19)
        DO 1 I=1,N
        TF(I)=A(4)*EXP(U1*SH(I)**2+U2*SK(I)**2+U3*SZ(I)**2+
     +  U4*SK(I)*SZ(I)+U5*SH(I)*SZ(I)+U6*SH(I)*SK(I))
   1    CONTINUE
      RETURN
      END
C
C -----------------------------------------------------------
C
      SUBROUTINE SXVI(TF,S,A,N)
C
C Generate isotropic temperature factor vector multiplied by s.o.f.
C
      REAL TF(N),S(N),A(10)
C
      P=A(4)
      T=-78.956835*A(5)
        DO 1 I=1,N
        TF(I)=P*EXP(T*S(I))
   1    CONTINUE
      RETURN
      END
C
C -----------------------------------------------------------
C
      SUBROUTINE SXVF(F,G,SQ,WL,L,N,LM,A)
      REAL F(N),G(N),SQ(N),WL(N),A(LM)
      COMMON/MEM/ST,SL,TC,TL,IV,LR,LG,LH,LI,LP,LF,LA,LC,LW,LY,LL,LB,
     +LX,LE,LV,LJ,LD,LS,LO,LT,LK,LQ,LZ,LN,KH,JA,JB,JC,JD,JE,HA,HD
C
C Vector calculation of scattering factors multiplied by A(24)
C
      D=ABS(A(24))
      P=D*A(L+1)
      A1=D*A(L+3)
      B1=A(L+4)
      A2=D*A(L+5)
      B2=A(L+6)
      A3=D*A(L+7)
      B3=A(L+8)
      A4=D*A(L+9)
      B4=A(L+10)
      C=D*A(L+11)
        DO 1 I=1,N
        G(I)=P
        Q=-SQ(I)
        F(I)=A1*EXP(B1*Q)+A2*EXP(B2*Q)+A3*EXP(B3*Q)+A4*EXP(B4*Q)+C
   1    CONTINUE
      IF(LT.LT.LX+32)GOTO 5
C
C Wavelength-dependent scattering factors for Laue data
C
      M=INT(A(L+12))
      IF(M.EQ.0)GOTO 5
      K=INT(A(M))
      M=M+1
        DO 4 I=1,N
        Q=ABS(WL(I))
        IF(A(K).LT.Q-0.0001)GOTO 4
        IF(A(M).GT.Q+0.0001)GOTO 4
        NI=M
        NJ=K
   2    IF(NJ.LT.NI+4)GOTO 3
        NK=NI+((NJ-NI)/6)*3
        IF(A(NK).GE.Q)NJ=NK
        IF(A(NK).LE.Q)NI=NK
        GOTO 2
   3    IF(NJ.NE.NI)P=(Q-A(NI))/(A(NJ)-A(NI))
        F(I)=F(I)+D*(P*A(NJ+1)+(1.-P)*A(NI+1)-A(L))
        G(I)=D*(P*A(NJ+2)+(1.-P)*A(NI+2))
   4    CONTINUE
   5  RETURN
      END
