C
      PROGRAM SHELXL
C
C            Crystal structure refinement - release 97-2
C                        ** UNIX Version **
C
      PARAMETER(LM=1200000,JW=1600000,IM=12000,LU=512)
C
C To increase the dimensions of the arrays A, B and C, increase LM, JW
C and IM in the above PARAMETER statement.  No other action is needed.
C The program should terminate with the appropriate message if this is
C necessary, otherwise it may be assumed that the above dimensions are
C OK. A stores atoms, restraints, instructions etc; LM should be about
C 200 times the number of atoms for restrained refinement of a typical
C macromolecule.  B and C are used as working space.  IM should not be
C smaller than 10000. For full-matrix refinement IM should be at least
C 8 times the number of parameters and JW should be IM*(IM+48)/128 or
C more.  Depending on the computer hardware and cache size, they may
C be an optimum value for B for fastest execution, since the program
C will buffer the reflection processing depending on this dimension.
C LU is the buffer size for batching reflection input/output; a power
C of 2 in the range 512 to 4096 will probably prove to be best. LU
C shou1d not be smaller than 256.  These dimensions are independent
C of the number of reflections, for which there is no limit.
C
      CHARACTER*1 IH(50),KD
      CHARACTER*2 KA(94)
      CHARACTER*76 IT
      CHARACTER*80 NM,FN,IR
      INTEGER MH(LU),MK(LU),ML(LU),MB(LU)
      REAL FF(LU),SI(LU),FC(LU),SQ(LU),WL(LU),FB(LU)
      REAL A(LM),B(JW),C(IM),EF(1880)
      COMMON MB,MH,MK,ML,FF,SI,SQ,WL,FB,FC,A,B,C,EF
      COMMON/MEM/ST,SL,TC,TL,IV,LR,LG,LH,LI,LP,LF,LA,LC,LW,LY,LL,LB,
     +LX,LE,LV,LJ,LD,LS,LO,LT,LK,LQ,LZ,LN,KH,JA,JB,JC,JD,JE,HA,HD
      COMMON/WORD/IH,IT,IR,NM,KA,KD
      CALL SXTO(0)
      CALL SXTO(1)
C
C KD should be set to CHAR(13) for UNIX systems to write the .res
C file in DOS rather than UNIX format with <CR><LF> instead of <LF>
C as line terminator. This is useful if the disk can also be accessed
C by MSDOS PC's.  For standard UNIX action, set KD to CHAR(32) here.
C
      KD=CHAR(32)
C
C IV is the optimum vector length for the least-squares calculations,
C and determines the dynamic memory partitioning of array B. The best
C value to use involves a subtle compromise between vector processing
C efficiency and cache sizes. Even for purely scalar machines too low
C a value will certainly be inefficient.  it is more efficient if IV
C is a multiple of 8 and if LU is a multiple of IV. If the array B is
C not large enough, the program may have to use a smaller vector run;
C the value actually used is printed out at the start of each cycle
C (it may change from cycle to cycle !). The fourth number on the L.S.
C and CGLS instructions overrides the default maximum value defined
C below, and so can be used for testing the effect of different vector
C run lengths.
C
      IV=512
C
C Set chars/inch across (HA) and lines/inch down page (HD)
C (usually HA=10. and HD=6. or 8., more for laser printers).
C This is only used for the 'lineprinter plots' of electron
C density syntheses (PLAN -n).
C
      HA=16.6667
      HD=10.
C
C Set unit numbers for files.   All unit numbers must be
C different, and all files used by SHELXL-97 are sequential.
C LR is incremented to read include files ('+filename') and
C so must be larger than all other unit numbers; LK stores
C the original value of LR.
C
      LW=1
      LA=2
      LH=3
      LC=4
      LF=8
      LP=9
      LI=10
      LZ=11
      LQ=12
      LR=13
      LK=LR
C
C Start timing and set default maxtime TL for finishing off.  TL
C could be set to say 0.8 times CPU limit for the job, if known.
C The value of TL may be reduced but not increased by means of
C the TIME instruction in the .ins file.  TC handles possible
C resetting of the clock at midnight.
C
      TL=999999.
      TC=0.
      CALL SXTI(SL)
      ST=SL
C
C Switch off meaningless 'underflows' here if necessary
C
C Open files using name from command line and standard extensions.
C The OPEN statements may need to be changed for some computers.
C Subroutine SXNM gets the generic filename from the command line.
C If the files are to be defined completely externally to the program
C (e.g. in an IBM or REX 'EXEC' procedure on an IBM computer),
C then SXNM should set LN to 0.  Units 9 and 11 will often have
C STATUS='UNKNOWN' but VMS requires 'NEW'.  For UNIX, all filenames
C should be lower case.
C
      CALL SXNM
      L=0
      IF(LN.EQ.0)GOTO 1
      L=LN+4
      FN=NM(1:LN)//'.ins'
      OPEN(UNIT=LR,FILE=FN(1:L),STATUS='OLD',ERR=7)
      FN=NM(1:LN)//'.lst'
      OPEN(UNIT=LI,FILE=FN(1:L),STATUS='OLD',IOSTAT=I)
      CLOSE(UNIT=LI,STATUS='DELETE',IOSTAT=I)
      OPEN(UNIT=LI,FILE=FN(1:L),STATUS='NEW',ERR=7)
C
C Comment out the next statement if the listing file is NOT destined
C for compressed mode output on an HP or compatible laserprinter.  It
C may be necessary to add a directive to the format (1X,A) to make
C sure that no carriage control characters are written to the file
C before the first escape character.  Note that the ampersand (&) is
C sometimes lost in email transmissions; it comes before 'l0o..' in
C the first text string.
C
C     WRITE(LI,'(1X,A)')CHAR(27)//'&l0o5c1X'//CHAR(27)//'(0u'//
C    +CHAR(27)//'(s0p16.66h8.5v0s0b0T'
C
      FN=NM(1:LN)//'.res'
      OPEN(UNIT=LP,FILE=FN(1:L),STATUS='OLD',IOSTAT=I)
      CLOSE(UNIT=LP,STATUS='DELETE',IOSTAT=I)
      OPEN(UNIT=LP,FILE=FN(1:L),STATUS='NEW',ERR=7)
C
C Open scratch files (unformatted, sequential).  As above,
C OPEN statements may need to be changed for some computers
C
      FN='SCRATCH'
      L=7
      OPEN(UNIT=LA,STATUS='SCRATCH',FORM='UNFORMATTED',ERR=7)
      OPEN(UNIT=LC,STATUS='SCRATCH',FORM='UNFORMATTED',ERR=7)
      OPEN(UNIT=LF,STATUS='SCRATCH',FORM='UNFORMATTED',ERR=7)
C
C Delete any name.fin left over from a previous job
C
      CALL SXFN(I)
C
C Call main subroutines, which may be overlay segments
C
   1  CALL SXTL
      CALL SX3A(LM,A,EF)
      CALL SX3B(LM,JW,LU,MK,ML,FF,SI,FC,A,B,EF)
      CALL SX3C(LM,JW,LU,MK,ML,MB,FF,FC,A,B)
      CALL SX3D(LM,JW,LU,IM,MK,ML,MB,SI,FC,SQ,WL,A,B,C)
      CALL SX3E(LM,JW,LU,IM,MH,MK,MB,A,B,C)
C
C Open remaining files here if required by input instructions
C
      IF(LN.EQ.0)GOTO 2
      L=LN+4
      IF(A(131).LT.0.5)GOTO 2
      FN=NM(1:LN)//'.hkl'
      OPEN(UNIT=LW,FILE=FN(1:L),STATUS='OLD',ERR=7)
   2  CALL SX3F(LM,JW,LU,MH,MK,ML,MB,FF,SI,FC,SQ,WL,A,B)
      CALL SX3G(LM,JW,LU,MH,MK,ML,MB,FF,SI,FC,SQ,WL,FB,A,B)
      CLOSE(UNIT=LR,STATUS='KEEP',IOSTAT=I)
      IF(A(73).LT.0.5)GOTO 3
      IF(LN.EQ.0)GOTO 3
      FN=NM(1:LN)//'.fcf'
      OPEN(UNIT=LZ,FILE=FN(1:L),STATUS='OLD',IOSTAT=I)
      CLOSE(UNIT=LZ,STATUS='DELETE',IOSTAT=I)
      OPEN(UNIT=LZ,FILE=FN(1:L),STATUS='NEW',ERR=7)
   3  IF(A(74).LT.0.5)GOTO 4
      IF(LN.EQ.0)GOTO 4
      FN=NM(1:LN)//'.cif'
      OPEN(UNIT=LH,FILE=FN(1:L),STATUS='OLD',IOSTAT=I)
      CLOSE(UNIT=LH,STATUS='DELETE',IOSTAT=I)
      OPEN(UNIT=LH,FILE=FN(1:L),STATUS='NEW',ERR=7)
   4  IF(ABS(A(79)).LT.0.5.AND.A(51).GT.-0.5)GOTO 5
      IF(LN.EQ.0)GOTO 5
      FN=NM(1:LN)//'.pdb'
      IF(A(51).LT.-0.5)FN(LN+1:LN+4)='.mat'
      OPEN(UNIT=LQ,FILE=FN(1:L),STATUS='OLD',IOSTAT=I)
      CLOSE(UNIT=LQ,STATUS='DELETE',IOSTAT=I)
      OPEN(UNIT=LQ,FILE=FN(1:L),STATUS='NEW',ERR=7)
C
C Call remaining subroutines, which may each be overlay segments.
C
   5  CALL SX3H(LM,JW,LU,IM,MH,MK,ML,MB,FF,SI,FC,SQ,WL,FB,A,B,C)
      CALL SX3I(LM,JW,LU,MH,MK,MB,FF,SI,SQ,WL,A,B)
      CALL SX3J(LM,JW,LU,MH,MK,ML,MB,FF,SI,FC,SQ,WL,A,B)
      IF(LK.GT.0)GOTO 5
      CALL SX3K(LM,LU,MB,A)
      CALL SX3L(LM,JW,LU,MH,MK,ML,MB,FF,SI,FC,SQ,WL,FB,A,B)
      CALL SX3M(LM,JW,LU,MH,MK,ML,MB,FF,SI,FC,SQ,WL,FB,A,B)
      CALL SX3N(LM,JW,LU,MH,MK,ML,MB,FF,SI,FC,WL,FB,A,B)
      CALL SXIT
   6  FORMAT(/'  CANNOT OPEN FILE ',A)
   7  WRITE(*,6)FN(1:L)
      CALL SXFL
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXNM
C
C Get generic filename (NAME) and its length (LN) from the command
C line.  Set LN to 0 if the file names are to be defined externally
C in a command procedure.  This subroutine is very computer-specific.
C For UNIX, all filenames are converted to lower case.
C
      CHARACTER*1 IH(50),KD,KS
      CHARACTER*2 KA(94)
      CHARACTER*76 IT
      CHARACTER*80 NM,IR
      COMMON/MEM/ST,SL,TC,TL,IV,LR,LG,LH,LI,LP,LF,LA,LC,LW,LY,LL,LB,
     +LX,LE,LV,LJ,LD,LS,LO,LT,LK,LQ,LZ,LN,KH,JA,JB,JC,JD,JE,HA,HD
      COMMON/WORD/IH,IT,IR,NM,KA,KD
   1  FORMAT(/'   ** BAD COMMAND LINE **'/)
C
      LN=0
      NM=' '
      CALL GETARG(IARGC(),NM)
        DO 2 I=1,80
        KS=NM(I:I)
        NM(I:I)=' '
        IF(KS.EQ.' ')GOTO 2
        LN=LN+1
        IF(KS.GE.'A'.AND.KS.LE.'Z')KS=CHAR(ICHAR(KS)+32)
        NM(LN:LN)=KS
   2    CONTINUE
      IF(LN.GT.0)GOTO 3
      WRITE(*,1)
      CALL SXFL
      STOP
   3  RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXTL
C
C Put out heading and other useful information. This computer-
C specific routine is called once, from the main program.
C
      CHARACTER*1 IH(50),KD
      CHARACTER*2 KA(94)
      CHARACTER*25 TM
      CHARACTER*76 IT
      CHARACTER*80 NM,IR
      COMMON/MEM/ST,SL,TC,TL,IV,LR,LG,LH,LI,LP,LF,LA,LC,LW,LY,LL,LB,
     +LX,LE,LV,LJ,LD,LS,LO,LT,LK,LQ,LZ,LN,KH,JA,JB,JC,JD,JE,HA,HD
      COMMON/WORD/IH,IT,IR,NM,KA,KD
C
   1  FORMAT(/' ',61('+')/' +  SHELXL-97 - ',
     +'CRYSTAL STRUCTURE REFINEMENT - UNIX VERSION  +'/
     +' +  Copyright(C) George M. Sheldrick 1993-7    Release ',
     +'97-2  +'/' +  ',A19,'  started at ',A8,' on ',A2,
     +'-',A3,'-',A4,'  +'/' ',61('+')/)
C
      CALL FDATE(TM)
      WRITE(LI,1)NM(1:19),TM(12:19),TM(9:10),TM(5:7),TM(21:24)
      WRITE(*,1)NM(1:19),TM(12:19),TM(9:10),TM(5:7),TM(21:24)
      CALL SXFL
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXTI(T)
      COMMON/MEM/ST,SL,TC,TL,IV,LR,LG,LH,LI,LP,LF,LA,LC,LW,LY,LL,LB,
     +LX,LE,LV,LJ,LD,LS,LO,LT,LK,LQ,LZ,LN,KH,JA,JB,JC,JD,JE,HA,HD
C
C Sets T to the CPU time used so far in seconds (not necessarily
C zero at the start of SHELXL). If the operating system does not
C provide this information, the subroutine should set T to -1.
C TC keeps track of the last time reported to detect if the clock
C is reset at midnight
C
      CALL CPU_TIME(T)
   1  IF(T.GT.TC-0.1)GOTO 2
      T=T+86400.
      GOTO 1
   2  TC=T
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXTX(KR)
C
C Put current time in format hr:mn:sc in string KR
C
      CHARACTER*8 KR
      CHARACTER*25 TM
      CALL FDATE(TM)
      KR=TM(12:19)
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXIT
C
C Terminate job in manner appropriate to operating system
C - e.g. print time and trailer, then stop.
C
      CHARACTER*1 IH(50),KD
      CHARACTER*2 KA(94)
      CHARACTER*8 TM
      CHARACTER*76 IT
      CHARACTER*80 NM,IR
      COMMON/MEM/ST,SL,TC,TL,IV,LR,LG,LH,LI,LP,LF,LA,LC,LW,LY,LL,LB,
     +LX,LE,LV,LJ,LD,LS,LO,LT,LK,LQ,LZ,LN,KH,JA,JB,JC,JD,JE,HA,HD
      COMMON/WORD/IH,IT,IR,NM,KA,KD
C
   1  FORMAT(/' ',77('+')/' +  ',A17,' finished at ',A8,3X,
     +'Total CPU time:',F10.1,' secs  +'/' ',77('+'))
C
      CALL SXTX(TM)
      CALL SXOT(LI)
      CALL SXTI(T)
      T=T-ST
      WRITE(LI,1)NM(1:17),TM(1:8),T
      WRITE(*,1)NM(1:17),TM(1:8),T
      CALL SXFL
C
C Comment out the next statement if the listing file is NOT destined
C for compressed mode output on an HP or compatible laserprinter
C
C     WRITE(LI,'(1X,A)')CHAR(27)//'E'
C
      CLOSE(LI,IOSTAT=JE)
      CLOSE(LP,IOSTAT=JE)
      CLOSE(LH,IOSTAT=JE)
      CLOSE(LZ,IOSTAT=JE)
      CLOSE(LQ,IOSTAT=JE)
      CLOSE(LA,STATUS='DELETE',IOSTAT=JE)
      CLOSE(LC,STATUS='DELETE',IOSTAT=JE)
      CLOSE(LF,STATUS='DELETE',IOSTAT=JE)
      STOP
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXOT(LI)
C
C Print time profile
C
      REAL TMI(30)
      COMMON/TIMS/TMI,ETI,NTI
C
   1  FORMAT(//A/A/)
   2  FORMAT(F10.2,': ',A)
C
      CALL SXTO(1)
      WRITE(LI,1)' Time profile in seconds',' -----------------------'
      WRITE(LI,2)TMI(1),'Read and process instructions'
      WRITE(LI,2)TMI(2),'Fit rigid groups'
      WRITE(LI,2)TMI(3),'Interpret restraints etc.'
      WRITE(LI,2)TMI(4),'Generate connectivity array'
      WRITE(LI,2)TMI(21),'Analyse DFIX/DANG restraints'
      WRITE(LI,2)TMI(22),'Analyse SAME/SADI restraints'
      WRITE(LI,2)TMI(26),'Generate CHIV restraints'
      WRITE(LI,2)TMI(24),'Check if bonds in residues restrained'
      WRITE(LI,2)TMI(25),'Generate DELU restraints'
      WRITE(LI,2)TMI(27),'Generate SIMU restraints'
      WRITE(LI,2)TMI(28),'Generate ISOR restraints'
      WRITE(LI,2)TMI(30),'Generate NCSY restraints'
      WRITE(LI,2)TMI(5),'Analyse other restraints etc.'
      WRITE(LI,2)TMI(6),'Read intensity data, sort/merge etc.'
      WRITE(LI,2)TMI(7),'Set up constraints'
      WRITE(LI,2)TMI(8),'OSF, H-atoms from difference map'
      WRITE(LI,2)TMI(9),'Set up l.s. refinement'
      WRITE(LI,2)TMI(10),'Generate idealized H-atoms'
      WRITE(LI,2)TMI(11),'Structure factors and derivatives'
      WRITE(LI,2)TMI(12),'Sum l.s. matrices'
      WRITE(LI,2)TMI(29),'Generate and apply antibumping restraints'
      WRITE(LI,2)TMI(13),'Apply other restraints'
      WRITE(LI,2)TMI(14),'Solve l.s. equations'
      WRITE(LI,2)TMI(23),'Generate HTAB table'
      WRITE(LI,2)TMI(15),'Other dependent quantities, CIF, tables'
      WRITE(LI,2)TMI(16),'Analysis of variance'
      WRITE(LI,2)TMI(17),'Merge reflections for Fourier and .fcf'
      WRITE(LI,2)TMI(18),'Fourier summations'
      WRITE(LI,2)TMI(19),'Peaksearch'
      WRITE(LI,2)TMI(20),'Analyse peaklist'
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXFL
C
C Flush standard output buffer - useful for log files in batch jobs
C Comment out if not acceptable to compiler !
C
      CALL FLUSH(6)
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXCC
C
C This subroutine is polled frequently to enable the user to signal
C to the program (with <Escape>) that he wishes to do no more
C refinement cycles but instead to tidy up and finish off, or (with
C <Ctrl-C> or - better - <Crtl-I>) that the job should be aborted.
C
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXTO(N)
C
C Sum times for different operations
C
      REAL TMI(30)
      COMMON/TIMS/TMI,ETI,NTI
      IF(N.GT.0)GOTO 2
      ETI=0.
      NTI=0
        DO 1 I=1,30
        TMI(I)=0.
   1    CONTINUE
   2  CALL SXTI(Q)
      T=Q-ETI-86400.
      ETI=Q
      IF(NTI.EQ.0)GOTO 4
   3  T=T+86400.
      IF(T.LT.0.)GOTO 3
      IF(NTI.GT.0)TMI(NTI)=TMI(NTI)+T
   4  NTI=N
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXPG(LI)
C
C Print form feed = start new page.
C
      WRITE(LI,'(1X,A)')CHAR(12)
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXFN(I)
C
C This routine deletes the dummy file name.fin.  If successful
C (i.e. the file existed) the program tidies up and finishes off
C instead of doing further least-squares refinement cycles.  The
C subroutine signals this by setting I to -1.  If the file name.fin
C cannot be deleted I is set to 0.  Note that this routine is also
C called at the beginning of a run to clear any name.fin left over
C from a previous job.  This facility has the same action on a batch
C job as hitting the escape key for an interactive SHELXL run.
C
      CHARACTER*1 IH(50),KD
      CHARACTER*2 KA(94)
      CHARACTER*76 IT
      CHARACTER*80 NM,IR
      COMMON/MEM/ST,SL,TC,TL,IV,LR,LG,LH,LI,LP,LF,LA,LC,LW,LY,LL,LB,
     +LX,LE,LV,LJ,LD,LS,LO,LT,LK,LQ,LZ,LN,KH,JA,JB,JC,JD,JE,HA,HD
      COMMON/WORD/IH,IT,IR,NM,KA,KD
C
      I=0
      OPEN(UNIT=LW,FILE=NM(1:LN)//'.fin',STATUS='OLD',ERR=1)
      CLOSE(UNIT=LW,STATUS='DELETE',ERR=1)
      I=-1
   1  RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXLC(K)
C
C Convert an upper case character to lower case.
C If it is not an upper case letter do nothing.
C
      CHARACTER K*1
      IF(K.GT.'Z')GOTO 1
      IF(K.LT.'A')GOTO 1
      K=CHAR(ICHAR(K)+ICHAR('a')-ICHAR('A'))
   1  RETURN
      END
C
C -----------------------------------------------------------
C
      SUBROUTINE SXUC(K)
C
C Convert a lower case character to upper case.
C If it is not a lower case letter do nothing.
C
      CHARACTER K*1
      IF(K.GT.'z')GOTO 1
      IF(K.LT.'a')GOTO 1
      K=CHAR(ICHAR(K)+ICHAR('A')-ICHAR('a'))
   1  RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXPS(X,KS)
C
C Pack 4 characters from character*4 string into one real
C
      CHARACTER*4 KS
      READ(KS,'(A4)')X
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXUS(X,KS)
C
C Unpack 4 characters from one real into character*4 string
C
      CHARACTER*4 KS
      WRITE(KS,'(A4)')X
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXER(KS)
      CHARACTER KS*(*)
C
C Error exit - output diagnostic message to console and
C printer (.LST file), then call exit routine.
C
      COMMON/MEM/ST,SL,TC,TL,IV,LR,LG,LH,LI,LP,LF,LA,LC,LW,LY,LL,LB,
     +LX,LE,LV,LJ,LD,LS,LO,LT,LK,LQ,LZ,LN,KH,JA,JB,JC,JD,JE,HA,HD
C
   1  FORMAT(/' ** ',A,' **'/)
   2  FORMAT(/' ** ',A,' **')
      WRITE(LI,1)KS
      WRITE(*,2)KS
      CALL SXFL
      CALL SXIT
      RETURN
      END
C
C ------------------------------------------------------------
C **      End of possibly system-specific subroutines       **
C ------------------------------------------------------------
C
      SUBROUTINE SX3A(LM,A,EF)
C
C Starting values for COMMON variables
C
      CHARACTER*1 IH(50),IG(50),KD
      CHARACTER*2 KA(94),KQ(94)
      CHARACTER*76 IT
      CHARACTER*80 NM,IR
      REAL A(LM),EF(1880),EG(1880)
      COMMON/MEM/ST,SL,TC,TL,IV,LR,LG,LH,LI,LP,LF,LA,LC,LW,LY,LL,LB,
     +LX,LE,LV,LJ,LD,LS,LO,LT,LK,LQ,LZ,LN,KH,JA,JB,JC,JD,JE,HA,HD
      COMMON/WORD/IH,IT,IR,NM,KA,KD
C
C Character DATA statements
C
      DATA IG/'0','1','2','3','4','5','6','7','8','9','.','-',
     +'+','X','Y','Z',',','=','/',' ','*','_','<','>','(',')',
     +'A','B','C','D','E','F','G','H','I','J','K','L','M','N',
     +'O','P','Q','R','S','T','U','V','W','$'/
C
C Data specific to chemical elements
C
      DATA KQ(1)/'H '/,EG(13)/.32/,EG(14)/1.008/,
     +EG(1)/0.49300/,EG(2)/10.51091/,EG(3)/0.32291/,
     +EG(4)/26.12573/,EG(5)/0.14019/,EG(6)/3.14236/,
     +EG(7)/0.04081/,EG(8)/57.79977/,EG(9)/0.00304/,
     +EG(10)/0.000/,EG(11)/0.000/,EG(12)/.655/,
     +EG(15)/0.000/,EG(16)/0.000/,EG(17)/.624/,
     +EG(18)/0.000/,EG(19)/0.000/,EG(20)/.614/
C
      DATA KQ(2)/'HE'/,EG(33)/1.50/,EG(34)/4.00/,
     +EG(21)/0.87340/,EG(22)/9.10371/,EG(23)/0.63090/,
     +EG(24)/3.35680/,EG(25)/0.31120/,EG(26)/22.92763/,
     +EG(27)/0.17800/,EG(28)/0.98210/,EG(29)/0.00640/,
     +EG(30)/0.000/,EG(31)/0.000/,EG(32)/1.94/,
     +EG(35)/0.000/,EG(36)/0.000/,EG(37)/1.34/,
     +EG(38)/0.000/,EG(39)/0.000/,EG(40)/1.28/
C
      DATA KQ(3)/'LI'/,EG(53)/1.52/,EG(54)/6.94/,
     +EG(41)/1.12820/,EG(42)/3.95460/,EG(43)/0.75080/,
     +EG(44)/1.05240/,EG(45)/0.61750/,EG(46)/85.39058/,
     +EG(47)/0.46530/,EG(48)/168.26120/,EG(49)/0.03770/,
     +EG(50)/0.0008/,EG(51)/0.0003/,EG(52)/5.76/,
     +EG(55)/-0.0003/,EG(56)/0.0001/,EG(57)/2.28/,
     +EG(58)/-0.0004/,EG(59)/0.0000/,EG(60)/2.06/
C
      DATA KQ(4)/'BE'/,EG(73)/1.11/,EG(74)/9.01/,
     +EG(61)/1.59190/,EG(62)/43.64275/,EG(63)/1.12780/,
     +EG(64)/1.86230/,EG(65)/0.53910/,EG(66)/103.48310/,
     +EG(67)/0.70290/,EG(68)/0.54200/,EG(69)/0.03850/,
     +EG(70)/0.0038/,EG(71)/0.0014/,EG(72)/16.6/,
     +EG(75)/0.0005/,EG(76)/0.0002/,EG(77)/3.83/,
     +EG(78)/0.0001/,EG(79)/0.0001/,EG(80)/3.13/
C
      DATA KQ(5)/'B '/,EG(93)/0.82/,EG(94)/10.81/,
     +EG(81)/2.05450/,EG(82)/23.21852/,EG(83)/1.33260/,
     +EG(84)/1.02100/,EG(85)/1.09790/,EG(86)/60.34987/,
     +EG(87)/0.70680/,EG(88)/0.14030/,EG(89)/-0.19320/,
     +EG(90)/0.0090/,EG(91)/0.0039/,EG(92)/41.5/,
     +EG(95)/0.0013/,EG(96)/0.0007/,EG(97)/6.61/,
     +EG(98)/0.0004/,EG(99)/0.0004/,EG(100)/4.79/
C
      DATA KQ(6)/'C '/,EG(113)/0.77/,EG(114)/12.01/,
     +EG(101)/2.31000/,EG(102)/20.84392/,EG(103)/1.02000/,
     +EG(104)/10.20751/,EG(105)/1.58860/,EG(106)/0.56870/,
     +EG(107)/0.86500/,EG(108)/51.65125/,EG(109)/0.21560/,
     +EG(110)/0.0181/,EG(111)/0.0091/,EG(112)/89.9/,
     +EG(115)/0.0033/,EG(116)/0.0016/,EG(117)/11.5/,
     +EG(118)/0.0015/,EG(119)/0.0009/,EG(120)/7.45/
C
      DATA KQ(7)/'N '/,EG(133)/0.70/,EG(134)/14.01/,
     +EG(121)/12.21261/,EG(122)/0.00570/,EG(123)/3.13220/,
     +EG(124)/9.89331/,EG(125)/2.01250/,EG(126)/28.99754/,
     +EG(127)/1.16630/,EG(128)/0.58260/,EG(129)/-11.52901/,
     +EG(130)/0.0311/,EG(131)/0.0180/,EG(132)/173./,
     +EG(135)/0.0061/,EG(136)/0.0033/,EG(137)/19.6/,
     +EG(138)/0.0030/,EG(139)/0.0019/,EG(140)/11.7/
C
      DATA KQ(8)/'O '/,EG(153)/0.66/,EG(154)/16.00/,
     +EG(141)/3.04850/,EG(142)/13.27711/,EG(143)/2.28680/,
     +EG(144)/5.70111/,EG(145)/1.54630/,EG(146)/0.32390/,
     +EG(147)/0.86700/,EG(148)/32.90894/,EG(149)/0.25080/,
     +EG(150)/0.0492/,EG(151)/0.0322/,EG(152)/304./,
     +EG(155)/0.0106/,EG(156)/0.0060/,EG(157)/32.5/,
     +EG(158)/0.0056/,EG(159)/0.0036/,EG(160)/18.2/
C
      DATA KQ(9)/'F '/,EG(173)/0.64/,EG(174)/19.00/,
     +EG(161)/3.53920/,EG(162)/10.28251/,EG(163)/2.64120/,
     +EG(164)/4.29440/,EG(165)/1.51700/,EG(166)/0.26150/,
     +EG(167)/1.02430/,EG(168)/26.14763/,EG(169)/0.27760/,
     +EG(170)/0.0727/,EG(171)/0.0534/,EG(172)/498./,
     +EG(175)/0.0171/,EG(176)/0.0103/,EG(177)/51.5/,
     +EG(178)/0.0096/,EG(179)/0.0061/,EG(180)/27.7/
C
      DATA KQ(10)/'NE'/,EG(193)/1.50/,EG(194)/20.18/,
     +EG(181)/3.95530/,EG(182)/8.40421/,EG(183)/3.11250/,
     +EG(184)/3.42620/,EG(185)/1.45460/,EG(186)/0.23060/,
     +EG(187)/1.12510/,EG(188)/21.71841/,EG(189)/0.35150/,
     +EG(190)/0.1019/,EG(191)/0.0833/,EG(192)/768./,
     +EG(195)/0.0259/,EG(196)/0.0164/,EG(197)/78.6/,
     +EG(198)/0.0152/,EG(199)/0.0098/,EG(200)/41.2/
C
      DATA KQ(11)/'NA'/,EG(213)/1.86/,EG(214)/22.99/,
     +EG(201)/4.76260/,EG(202)/3.28500/,EG(203)/3.17360/,
     +EG(204)/8.84221/,EG(205)/1.26740/,EG(206)/0.31360/,
     +EG(207)/1.11280/,EG(208)/129.42410/,EG(209)/0.67600/,
     +EG(210)/0.1353/,EG(211)/0.1239/,EG(212)/1140./,
     +EG(215)/0.0362/,EG(216)/0.0249/,EG(217)/116./,
     +EG(218)/0.0218/,EG(219)/0.0150/,EG(220)/59.6/
C
      DATA KQ(12)/'MG'/,EG(233)/1.60/,EG(234)/24.31/,
     +EG(221)/5.42041/,EG(222)/2.82750/,EG(223)/2.17350/,
     +EG(224)/79.26118/,EG(225)/1.22690/,EG(226)/0.38080/,
     +EG(227)/2.30730/,EG(228)/7.19371/,EG(229)/0.85840/,
     +EG(230)/0.1719/,EG(231)/0.1771/,EG(232)/1610./,
     +EG(235)/0.0486/,EG(236)/0.0363/,EG(237)/165./,
     +EG(238)/0.0298/,EG(239)/0.0220/,EG(240)/84.2/
C
      DATA KQ(13)/'AL'/,EG(253)/1.25/,EG(254)/26.98/,
     +EG(241)/6.42021/,EG(242)/3.03870/,EG(243)/1.90020/,
     +EG(244)/0.74260/,EG(245)/1.59360/,EG(246)/31.54724/,
     +EG(247)/1.96460/,EG(248)/85.08868/,EG(249)/1.11510/,
     +EG(250)/0.2130/,EG(251)/0.2455/,EG(252)/2220./,
     +EG(255)/0.0645/,EG(256)/0.0514/,EG(257)/229./,
     +EG(258)/0.0406/,EG(259)/0.0313/,EG(260)/116./
C
      DATA KQ(14)/'SI'/,EG(273)/1.17/,EG(274)/28.09/,
     +EG(261)/6.29151/,EG(262)/2.43860/,EG(263)/3.03530/,
     +EG(264)/32.33374/,EG(265)/1.98910/,EG(266)/0.67850/,
     +EG(267)/1.54100/,EG(268)/81.69379/,EG(269)/1.14070/,
     +EG(270)/0.2541/,EG(271)/0.3302/,EG(272)/2970./,
     +EG(275)/0.0817/,EG(276)/0.0704/,EG(277)/310./,
     +EG(278)/0.0522/,EG(279)/0.0431/,EG(280)/156./
C
      DATA KQ(15)/'P '/,EG(293)/1.10/,EG(294)/30.97/,
     +EG(281)/6.43451/,EG(282)/1.90670/,EG(283)/4.17910/,
     +EG(284)/27.15704/,EG(285)/1.78000/,EG(286)/0.52600/,
     +EG(287)/1.49080/,EG(288)/68.16457/,EG(289)/1.11490/,
     +EG(290)/0.2955/,EG(291)/0.4335/,EG(292)/3880./,
     +EG(295)/0.1023/,EG(296)/0.0942/,EG(297)/410./,
     +EG(298)/0.0667/,EG(299)/0.0580/,EG(300)/206./
C
      DATA KQ(16)/'S '/,EG(313)/1.03/,EG(314)/32.06/,
     +EG(301)/6.90531/,EG(302)/1.46790/,EG(303)/5.20341/,
     +EG(304)/22.21512/,EG(305)/1.43790/,EG(306)/0.25360/,
     +EG(307)/1.58630/,EG(308)/56.17207/,EG(309)/0.86690/,
     +EG(310)/0.3331/,EG(311)/0.5567/,EG(312)/4970./,
     +EG(315)/0.1246/,EG(316)/0.1234/,EG(317)/532./,
     +EG(318)/0.0826/,EG(319)/0.0763/,EG(320)/267./
C
      DATA KQ(17)/'CL'/,EG(333)/0.99/,EG(334)/35.45/,
     +EG(321)/11.46041/,EG(322)/0.01040/,EG(323)/7.19641/,
     +EG(324)/1.16620/,EG(325)/6.25561/,EG(326)/18.51942/,
     +EG(327)/1.64550/,EG(328)/47.77846/,EG(329)/-9.55741/,
     +EG(330)/0.3639/,EG(331)/0.7018/,EG(332)/6240./,
     +EG(335)/0.1484/,EG(336)/0.1585/,EG(337)/678./,
     +EG(338)/0.0998/,EG(339)/0.0984/,EG(340)/341./
C
      DATA KQ(18)/'AR'/,EG(353)/1.50/,EG(354)/39.95/,
     +EG(341)/7.48451/,EG(342)/0.90720/,EG(343)/6.77231/,
     +EG(344)/14.84071/,EG(345)/0.65390/,EG(346)/43.89835/,
     +EG(347)/1.64420/,EG(348)/33.39293/,EG(349)/1.44450/,
     +EG(350)/0.3843/,EG(351)/0.8717/,EG(352)/7720./,
     +EG(355)/0.1743/,EG(356)/0.2003/,EG(357)/851./,
     +EG(358)/0.1191/,EG(359)/0.1249/,EG(360)/429./
C
      DATA KQ(19)/'K '/,EG(373)/2.27/,EG(374)/39.10/,
     +EG(361)/8.21861/,EG(362)/12.79491/,EG(363)/7.43981/,
     +EG(364)/0.77480/,EG(365)/1.05190/,EG(366)/213.18720/,
     +EG(367)/0.86590/,EG(368)/41.68416/,EG(369)/1.42280/,
     +EG(370)/0.3868/,EG(371)/1.0657/,EG(372)/9400./,
     +EG(375)/0.2009/,EG(376)/0.2494/,EG(377)/1050./,
     +EG(378)/0.1399/,EG(379)/0.1562/,EG(380)/532./
C
      DATA KQ(20)/'CA'/,EG(393)/1.97/,EG(394)/40.08/,
     +EG(381)/8.62661/,EG(382)/10.44211/,EG(383)/7.38731/,
     +EG(384)/0.65990/,EG(385)/1.58990/,EG(386)/85.74849/,
     +EG(387)/1.02110/,EG(388)/178.43720/,EG(389)/1.37510/,
     +EG(390)/0.3641/,EG(391)/1.2855/,EG(392)/11300./,
     +EG(395)/0.2262/,EG(396)/0.3064/,EG(397)/1290./,
     +EG(398)/0.1611/,EG(399)/0.1926/,EG(400)/652./
C
      DATA KQ(21)/'SC'/,EG(413)/1.61/,EG(414)/44.96/,
     +EG(401)/9.18901/,EG(402)/9.02131/,EG(403)/7.36791/,
     +EG(404)/0.57290/,EG(405)/1.64090/,EG(406)/136.10810/,
     +EG(407)/1.46800/,EG(408)/51.35315/,EG(409)/1.33290/,
     +EG(410)/0.3119/,EG(411)/1.5331/,EG(412)/13500./,
     +EG(415)/0.2519/,EG(416)/0.3716/,EG(417)/1560./,
     +EG(418)/0.1829/,EG(419)/0.2348/,EG(420)/789./
C
      DATA KQ(22)/'TI'/,EG(433)/1.45/,EG(434)/47.90/,
     +EG(421)/9.75951/,EG(422)/7.85081/,EG(423)/7.35581/,
     +EG(424)/0.50000/,EG(425)/1.69910/,EG(426)/35.63383/,
     +EG(427)/1.90210/,EG(428)/116.10510/,EG(429)/1.28070/,
     +EG(430)/0.2191/,EG(431)/1.8069/,EG(432)/15900./,
     +EG(435)/0.2776/,EG(436)/0.4457/,EG(437)/1860./,
     +EG(438)/0.2060/,EG(439)/0.2830/,EG(440)/947./
C
      DATA KQ(23)/'V '/,EG(453)/1.31/,EG(454)/50.94/,
     +EG(441)/10.29711/,EG(442)/6.86571/,EG(443)/7.35111/,
     +EG(444)/0.43850/,EG(445)/2.07030/,EG(446)/26.89383/,
     +EG(447)/2.05710/,EG(448)/102.47810/,EG(449)/1.21990/,
     +EG(450)/0.0687/,EG(451)/2.1097/,EG(452)/18500./,
     +EG(455)/0.3005/,EG(456)/0.5294/,EG(457)/2200./,
     +EG(458)/0.2276/,EG(459)/0.3376/,EG(460)/1120./
C
      DATA KQ(24)/'CR'/,EG(473)/1.24/,EG(474)/52.00/,
     +EG(461)/10.64061/,EG(462)/6.10381/,EG(463)/7.35371/,
     +EG(464)/0.39200/,EG(465)/3.32400/,EG(466)/20.26262/,
     +EG(467)/1.49220/,EG(468)/98.73999/,EG(469)/1.18320/,
     +EG(470)/-0.1635/,EG(471)/2.4439/,EG(472)/21300./,
     +EG(475)/0.3209/,EG(476)/0.6236/,EG(477)/2580./,
     +EG(478)/0.2496/,EG(479)/0.3992/,EG(480)/1330./
C
      DATA KQ(25)/'MN'/,EG(493)/1.37/,EG(494)/54.94/,
     +EG(481)/11.28191/,EG(482)/5.34091/,EG(483)/7.35731/,
     +EG(484)/0.34320/,EG(485)/3.01930/,EG(486)/17.86742/,
     +EG(487)/2.24410/,EG(488)/83.75438/,EG(489)/1.08960/,
     +EG(490)/-0.5299/,EG(491)/2.8052/,EG(492)/24600./,
     +EG(495)/0.3368/,EG(496)/0.7283/,EG(497)/3020./,
     +EG(498)/0.2704/,EG(499)/0.4681/,EG(500)/1550./
C
      DATA KQ(26)/'FE'/,EG(513)/1.24/,EG(514)/55.85/,
     +EG(501)/11.76951/,EG(502)/4.76111/,EG(503)/7.35731/,
     +EG(504)/0.30720/,EG(505)/3.52220/,EG(506)/15.35351/,
     +EG(507)/2.30450/,EG(508)/76.88058/,EG(509)/1.03690/,
     +EG(510)/-1.1336/,EG(511)/3.1974/,EG(512)/28000./,
     +EG(515)/0.3463/,EG(516)/0.8444/,EG(517)/3490./,
     +EG(518)/0.2886/,EG(519)/0.5448/,EG(520)/1800./
C
      DATA KQ(27)/'CO'/,EG(533)/1.25/,EG(534)/58.93/,
     +EG(521)/12.28411/,EG(522)/4.27910/,EG(523)/7.34091/,
     +EG(524)/0.27840/,EG(525)/4.00340/,EG(526)/13.53591/,
     +EG(527)/2.34880/,EG(528)/71.16927/,EG(529)/1.01180/,
     +EG(530)/-2.3653/,EG(531)/3.6143/,EG(532)/31400./,
     +EG(535)/0.3494/,EG(536)/0.9721/,EG(537)/4010./,
     +EG(538)/0.3050/,EG(539)/0.6296/,EG(540)/2070./
C
      DATA KQ(28)/'NI'/,EG(553)/1.25/,EG(554)/58.71/,
     +EG(541)/12.83761/,EG(542)/3.87850/,EG(543)/7.29201/,
     +EG(544)/0.25650/,EG(545)/4.44380/,EG(546)/12.17631/,
     +EG(547)/2.38000/,EG(548)/66.34216/,EG(549)/1.03410/,
     +EG(550)/-3.0029/,EG(551)/0.5091/,EG(552)/4760./,
     +EG(555)/0.3393/,EG(556)/1.1124/,EG(557)/4570./,
     +EG(558)/0.3147/,EG(559)/0.7232/,EG(560)/2380./
C
      DATA KQ(29)/'CU'/,EG(573)/1.28/,EG(574)/63.54/,
     +EG(561)/13.33801/,EG(562)/3.58280/,EG(563)/7.16761/,
     +EG(564)/0.24700/,EG(565)/5.61581/,EG(566)/11.39661/,
     +EG(567)/1.67350/,EG(568)/64.81267/,EG(569)/1.19100/,
     +EG(570)/-1.9646/,EG(571)/0.5888/,EG(572)/5470./,
     +EG(575)/0.3201/,EG(576)/1.2651/,EG(577)/5180./,
     +EG(578)/0.3240/,EG(579)/0.8257/,EG(580)/2710./
C
      DATA KQ(30)/'ZN'/,EG(593)/1.33/,EG(594)/65.37/,
     +EG(581)/14.07431/,EG(582)/3.26550/,EG(583)/7.03181/,
     +EG(584)/0.23330/,EG(585)/5.16521/,EG(586)/10.31631/,
     +EG(587)/2.41000/,EG(588)/58.70976/,EG(589)/1.30410/,
     +EG(590)/-1.5491/,EG(591)/0.6778/,EG(592)/6290./,
     +EG(595)/0.2839/,EG(596)/1.4301/,EG(597)/5860./,
     +EG(598)/0.3242/,EG(599)/0.9375/,EG(600)/3070./
C
      DATA KQ(31)/'GA'/,EG(613)/1.26/,EG(614)/69.72/,
     +EG(601)/15.23541/,EG(602)/3.06690/,EG(603)/6.70061/,
     +EG(604)/0.24120/,EG(605)/4.35910/,EG(606)/10.78051/,
     +EG(607)/2.96230/,EG(608)/61.41357/,EG(609)/1.71890/,
     +EG(610)/-1.2846/,EG(611)/0.7763/,EG(612)/7190./,
     +EG(615)/0.2307/,EG(616)/1.6083/,EG(617)/6600./,
     +EG(618)/0.3179/,EG(619)/1.0589/,EG(620)/3460./
C
      DATA KQ(32)/'GE'/,EG(633)/1.22/,EG(634)/72.59/,
     +EG(621)/16.08162/,EG(622)/2.85090/,EG(623)/6.37471/,
     +EG(624)/0.25160/,EG(625)/3.70680/,EG(626)/11.44681/,
     +EG(627)/3.68300/,EG(628)/54.76256/,EG(629)/2.13130/,
     +EG(630)/-1.0885/,EG(631)/0.8855/,EG(632)/8190./,
     +EG(635)/0.1547/,EG(636)/1.8001/,EG(637)/7380./,
     +EG(638)/0.3016/,EG(639)/1.1903/,EG(640)/3870./
C
      DATA KQ(33)/'AS'/,EG(653)/1.21/,EG(654)/74.92/,
     +EG(641)/16.67232/,EG(642)/2.63450/,EG(643)/6.07011/,
     +EG(644)/0.26470/,EG(645)/3.43130/,EG(646)/12.94791/,
     +EG(647)/4.27790/,EG(648)/47.79726/,EG(649)/2.53100/,
     +EG(650)/-0.9300/,EG(651)/1.0051/,EG(652)/9290./,
     +EG(655)/0.0499/,EG(656)/2.0058/,EG(657)/8220./,
     +EG(658)/0.2758/,EG(659)/1.3314/,EG(660)/4330./
C
      DATA KQ(34)/'SE'/,EG(673)/1.17/,EG(674)/78.96/,
     +EG(661)/17.00063/,EG(662)/2.40980/,EG(663)/5.81961/,
     +EG(664)/0.27260/,EG(665)/3.97310/,EG(666)/15.23721/,
     +EG(667)/4.35430/,EG(668)/43.81635/,EG(669)/2.84090/,
     +EG(670)/-0.7943/,EG(671)/1.1372/,EG(672)/10500./,
     +EG(675)/-0.0929/,EG(676)/2.2259/,EG(677)/9110./,
     +EG(678)/0.2367/,EG(679)/1.4831/,EG(680)/4820./
C
      DATA KQ(35)/'BR'/,EG(693)/1.14/,EG(694)/79.91/,
     +EG(681)/17.17892/,EG(682)/2.17230/,EG(683)/5.23581/,
     +EG(684)/16.57962/,EG(685)/5.63771/,EG(686)/0.26090/,
     +EG(687)/3.98510/,EG(688)/41.43285/,EG(689)/2.95570/,
     +EG(690)/-0.6763/,EG(691)/1.2805/,EG(692)/11800./,
     +EG(695)/-0.2901/,EG(696)/2.4595/,EG(697)/10000./,
     +EG(698)/0.1811/,EG(699)/1.6452/,EG(700)/5350./
C
      DATA KQ(36)/'KR'/,EG(713)/1.50/,EG(714)/83.80/,
     +EG(701)/17.35551/,EG(702)/1.93840/,EG(703)/6.72861/,
     +EG(704)/16.56232/,EG(705)/5.54931/,EG(706)/0.22610/,
     +EG(707)/3.53750/,EG(708)/39.39723/,EG(709)/2.82500/,
     +EG(710)/-0.5657/,EG(711)/1.4385/,EG(712)/13200./,
     +EG(715)/-0.5574/,EG(716)/2.7079/,EG(717)/11000./,
     +EG(718)/0.1067/,EG(719)/1.8192/,EG(720)/5920./
C
      DATA KQ(37)/'RB'/,EG(733)/2.48/,EG(734)/85.47/,
     +EG(721)/17.17842/,EG(722)/1.78880/,EG(723)/9.64351/,
     +EG(724)/17.31512/,EG(725)/5.13990/,EG(726)/0.27480/,
     +EG(727)/1.52920/,EG(728)/164.93420/,EG(729)/3.48730/,
     +EG(730)/-0.4688/,EG(731)/1.6079/,EG(732)/14800./,
     +EG(735)/-0.9393/,EG(736)/2.9676/,EG(737)/12100./,
     +EG(738)/0.0068/,EG(739)/2.0025/,EG(740)/6520./
C
      DATA KQ(38)/'SR'/,EG(753)/2.15/,EG(754)/87.62/,
     +EG(741)/17.56631/,EG(742)/1.55640/,EG(743)/9.81841/,
     +EG(744)/14.09881/,EG(745)/5.42200/,EG(746)/0.16640/,
     +EG(747)/2.66940/,EG(748)/132.37610/,EG(749)/2.50640/,
     +EG(750)/-0.3528/,EG(751)/1.8200/,EG(752)/16500./,
     +EG(755)/-1.5307/,EG(756)/3.2498/,EG(757)/13200./,
     +EG(758)/-0.1172/,EG(759)/2.2025/,EG(760)/7150./
C
      DATA KQ(39)/'Y '/,EG(773)/1.78/,EG(774)/88.91/,
     +EG(761)/17.77602/,EG(762)/1.40290/,EG(763)/10.29461/,
     +EG(764)/12.80061/,EG(765)/5.72630/,EG(766)/0.12560/,
     +EG(767)/3.26588/,EG(768)/104.35410/,EG(769)/1.91213/,
     +EG(770)/-0.2670/,EG(771)/2.0244/,EG(772)/18300./,
     +EG(775)/-2.7962/,EG(776)/3.5667/,EG(777)/14300./,
     +EG(778)/-0.2879/,EG(779)/2.4099/,EG(780)/7800./
C
      DATA KQ(40)/'ZR'/,EG(793)/1.59/,EG(794)/91.22/,
     +EG(781)/17.87653/,EG(782)/1.27618/,EG(783)/10.94801/,
     +EG(784)/11.91601/,EG(785)/5.41733/,EG(786)/0.11762/,
     +EG(787)/3.65721/,EG(788)/87.66278/,EG(789)/2.06929/,
     +EG(790)/-0.1862/,EG(791)/2.2449/,EG(792)/20300./,
     +EG(795)/-2.9673/,EG(796)/0.5597/,EG(797)/2470./,
     +EG(798)/-0.5364/,EG(799)/2.6141/,EG(800)/8470./
C
      DATA KQ(41)/'NB'/,EG(813)/1.43/,EG(814)/92.91/,
     +EG(801)/17.61423/,EG(802)/1.18865/,EG(803)/12.01441/,
     +EG(804)/11.76601/,EG(805)/4.04183/,EG(806)/0.20479/,
     +EG(807)/3.53346/,EG(808)/69.79576/,EG(809)/3.75591/,
     +EG(810)/-0.1121/,EG(811)/2.4826/,EG(812)/22300./,
     +EG(815)/-2.0727/,EG(816)/0.6215/,EG(817)/2730./,
     +EG(818)/-0.8282/,EG(819)/2.8404/,EG(820)/9220./
C
      DATA KQ(42)/'MO'/,EG(833)/1.36/,EG(834)/95.94/,
     +EG(821)/3.70250/,EG(822)/0.27720/,EG(823)/17.23563/,
     +EG(824)/1.09580/,EG(825)/12.88761/,EG(826)/11.00401/,
     +EG(827)/3.74290/,EG(828)/61.65846/,EG(829)/4.38750/,
     +EG(830)/-0.0483/,EG(831)/2.7339/,EG(832)/24600./,
     +EG(835)/-1.6832/,EG(836)/0.6857/,EG(837)/3000./,
     +EG(838)/-1.2703/,EG(839)/3.0978/,EG(840)/11500./
C
      DATA KQ(43)/'TC'/,EG(853)/1.35/,EG(854)/98.00/,
     +EG(841)/19.13013/,EG(842)/0.86413/,EG(843)/11.09481/,
     +EG(844)/8.14488/,EG(845)/4.64902/,EG(846)/21.57072/,
     +EG(847)/2.71263/,EG(848)/86.84727/,EG(849)/5.40429/,
     +EG(850)/0.0057/,EG(851)/3.0049/,EG(852)/27000./,
     +EG(855)/-1.4390/,EG(856)/0.7593/,EG(857)/3320./,
     +EG(858)/-2.0087/,EG(859)/3.3490/,EG(860)/10700./
C
      DATA KQ(44)/'RU'/,EG(873)/1.33/,EG(874)/101.07/,
     +EG(861)/19.26743/,EG(862)/0.80852/,EG(863)/12.91821/,
     +EG(864)/8.43468/,EG(865)/4.86337/,EG(866)/24.79974/,
     +EG(867)/1.56756/,EG(868)/94.29289/,EG(869)/5.37875/,
     +EG(870)/0.0552/,EG(871)/3.2960/,EG(872)/29500./,
     +EG(875)/-1.2594/,EG(876)/0.8363/,EG(877)/3640./,
     +EG(878)/-5.3630/,EG(879)/3.6506/,EG(880)/1920./
C
      DATA KQ(45)/'RH'/,EG(893)/1.35/,EG(894)/102.91/,
     +EG(881)/19.29572/,EG(882)/0.75154/,EG(883)/14.35011/,
     +EG(884)/8.21759/,EG(885)/4.73425/,EG(886)/25.87494/,
     +EG(887)/1.28918/,EG(888)/98.60629/,EG(889)/5.32800/,
     +EG(890)/0.0927/,EG(891)/3.6045/,EG(892)/32300./,
     +EG(895)/-1.1178/,EG(896)/0.9187/,EG(897)/3990./,
     +EG(898)/-2.5280/,EG(899)/0.5964/,EG(900)/2100./
C
      DATA KQ(46)/'PD'/,EG(913)/1.38/,EG(914)/106.40/,
     +EG(901)/19.33192/,EG(902)/0.69866/,EG(903)/15.50172/,
     +EG(904)/7.98930/,EG(905)/5.29537/,EG(906)/25.20523/,
     +EG(907)/0.60584/,EG(908)/76.89868/,EG(909)/5.26593/,
     +EG(910)/0.1215/,EG(911)/3.9337/,EG(912)/35200./,
     +EG(915)/-0.9988/,EG(916)/1.0072/,EG(917)/4360./,
     +EG(918)/-1.9556/,EG(919)/0.6546/,EG(920)/2300./
C
      DATA KQ(47)/'AG'/,EG(933)/1.44/,EG(934)/107.87/,
     +EG(921)/19.28082/,EG(922)/0.64460/,EG(923)/16.68852/,
     +EG(924)/7.47261/,EG(925)/4.80451/,EG(926)/24.66054/,
     +EG(927)/1.04630/,EG(928)/99.81570/,EG(929)/5.17900/,
     +EG(930)/0.1306/,EG(931)/4.2820/,EG(932)/38200./,
     +EG(935)/-0.8971/,EG(936)/1.1015/,EG(937)/4760./,
     +EG(938)/-1.6473/,EG(939)/0.7167/,EG(940)/2510./
C
      DATA KQ(48)/'CD'/,EG(953)/1.49/,EG(954)/112.40/,
     +EG(941)/19.22142/,EG(942)/0.59460/,EG(943)/17.64442/,
     +EG(944)/6.90891/,EG(945)/4.46100/,EG(946)/24.70084/,
     +EG(947)/1.60290/,EG(948)/87.48257/,EG(949)/5.06941/,
     +EG(950)/0.1185/,EG(951)/4.6533/,EG(952)/41500./,
     +EG(955)/-0.8075/,EG(956)/1.2024/,EG(957)/5180./,
     +EG(958)/-1.4396/,EG(959)/0.7832/,EG(960)/2730./
C
      DATA KQ(49)/'IN'/,EG(973)/1.44/,EG(974)/114.82/,
     +EG(961)/19.16241/,EG(962)/0.54760/,EG(963)/18.55962/,
     +EG(964)/6.37761/,EG(965)/4.29480/,EG(966)/25.84993/,
     +EG(967)/2.03960/,EG(968)/92.80299/,EG(969)/4.93911/,
     +EG(970)/0.0822/,EG(971)/5.0449/,EG(972)/45000./,
     +EG(975)/-0.7276/,EG(976)/1.3100/,EG(977)/5630./,
     +EG(978)/-1.2843/,EG(979)/0.8542/,EG(980)/2970./
C
      DATA KQ(50)/'SN'/,EG(993)/1.40/,EG(994)/118.69/,
     +EG(981)/19.18892/,EG(982)/5.83031/,EG(983)/19.10052/,
     +EG(984)/0.50310/,EG(985)/4.45850/,EG(986)/26.89093/,
     +EG(987)/2.46630/,EG(988)/83.95718/,EG(989)/4.78211/,
     +EG(990)/0.0259/,EG(991)/5.4591/,EG(992)/48600./,
     +EG(995)/-0.6537/,EG(996)/1.4246/,EG(997)/6110./,
     +EG(998)/-1.1587/,EG(999)/0.9299/,EG(1000)/3230./
C
      DATA KQ(51)/'SB'/,EG(1013)/1.41/,EG(1014)/121.75/,
     +EG(1001)/19.64182/,EG(1002)/5.30340/,EG(1003)/19.04552/,
     +EG(1004)/0.46070/,EG(1005)/5.03711/,EG(1006)/27.90744/,
     +EG(1007)/2.68270/,EG(1008)/75.28258/,EG(1009)/4.59091/,
     +EG(1010)/-0.0562/,EG(1011)/5.8946/,EG(1012)/52500./,
     +EG(1015)/-0.5866/,EG(1016)/1.5461/,EG(1017)/6620./,
     +EG(1018)/-1.0547/,EG(1019)/1.0104/,EG(1020)/3500./
C
      DATA KQ(52)/'TE'/,EG(1033)/1.37/,EG(1034)/127.60/,
     +EG(1021)/19.96442/,EG(1022)/4.81742/,EG(1023)/19.01382/,
     +EG(1024)/0.42089/,EG(1025)/6.14488/,EG(1026)/28.52844/,
     +EG(1027)/2.52390/,EG(1028)/70.84036/,EG(1029)/4.35200/,
     +EG(1030)/-0.1759/,EG(1031)/6.3531/,EG(1032)/56500./,
     +EG(1035)/-0.5308/,EG(1036)/1.6751/,EG(1037)/7160./,
     +EG(1038)/-0.9710/,EG(1039)/1.0960/,EG(1040)/3780./
C
      DATA KQ(53)/'I '/,EG(1053)/1.33/,EG(1054)/126.90/,
     +EG(1041)/20.14722/,EG(1042)/4.34700/,EG(1043)/18.99492/,
     +EG(1044)/0.38140/,EG(1045)/7.51381/,EG(1046)/27.76604/,
     +EG(1047)/2.27350/,EG(1048)/66.87767/,EG(1049)/4.07120/,
     +EG(1050)/-0.3257/,EG(1051)/6.8362/,EG(1052)/60700./,
     +EG(1055)/-0.4742/,EG(1056)/1.8119/,EG(1057)/7730./,
     +EG(1058)/-0.8919/,EG(1059)/1.1868/,EG(1060)/4090./
C
      DATA KQ(54)/'XE'/,EG(1073)/1.50/,EG(1074)/131.30/,
     +EG(1061)/20.29332/,EG(1062)/3.92820/,EG(1063)/19.02982/,
     +EG(1064)/0.34400/,EG(1065)/8.97671/,EG(1066)/26.46594/,
     +EG(1067)/1.99000/,EG(1068)/64.26587/,EG(1069)/3.71180/,
     +EG(1070)/-0.5179/,EG(1071)/7.3500/,EG(1072)/65200./,
     +EG(1075)/-0.4205/,EG(1076)/1.9578/,EG(1077)/8340./,
     +EG(1078)/-0.8200/,EG(1079)/1.2838/,EG(1080)/4410./
C
      DATA KQ(55)/'CS'/,EG(1093)/2.65/,EG(1094)/132.91/,
     +EG(1081)/20.38922/,EG(1082)/3.56900/,EG(1083)/19.10622/,
     +EG(1084)/0.31070/,EG(1085)/10.66201/,EG(1086)/24.38794/,
     +EG(1087)/1.49530/,EG(1088)/213.90420/,EG(1089)/3.33520/,
     +EG(1090)/-0.7457/,EG(1091)/7.9052/,EG(1092)/70000./,
     +EG(1095)/-0.3680/,EG(1096)/2.1192/,EG(1097)/8980./,
     +EG(1098)/-0.7527/,EG(1099)/1.3916/,EG(1100)/4750./
C
      DATA KQ(56)/'BA'/,EG(1113)/2.17/,EG(1114)/137.34/,
     +EG(1101)/20.33612/,EG(1102)/3.21600/,EG(1103)/19.29703/,
     +EG(1104)/0.27560/,EG(1105)/10.88801/,EG(1106)/20.20732/,
     +EG(1107)/2.69590/,EG(1108)/167.20220/,EG(1109)/2.77310/,
     +EG(1110)/-1.0456/,EG(1111)/8.4617/,EG(1112)/75000./,
     +EG(1115)/-0.3244/,EG(1116)/2.2819/,EG(1117)/9650./,
     +EG(1118)/-0.6940/,EG(1119)/1.5004/,EG(1120)/5110./
C
      DATA KQ(57)/'LA'/,EG(1133)/1.87/,EG(1134)/138.91/,
     +EG(1121)/20.57802/,EG(1122)/2.94817/,EG(1123)/19.59901/,
     +EG(1124)/0.24448/,EG(1125)/11.37271/,EG(1126)/18.77261/,
     +EG(1127)/3.28719/,EG(1128)/133.12410/,EG(1129)/2.14678/,
     +EG(1130)/-1.4094/,EG(1131)/9.0376/,EG(1132)/80300./,
     +EG(1135)/-0.2871/,EG(1136)/2.4523/,EG(1137)/10400./,
     +EG(1138)/-0.6411/,EG(1139)/1.6148/,EG(1140)/5490./
C
      DATA KQ(58)/'CE'/,EG(1153)/1.83/,EG(1154)/140.12/,
     +EG(1141)/21.16711/,EG(1142)/2.81219/,EG(1143)/19.76952/,
     +EG(1144)/0.22684/,EG(1145)/11.85131/,EG(1146)/17.60832/,
     +EG(1147)/3.33049/,EG(1148)/127.11310/,EG(1149)/1.86264/,
     +EG(1150)/-1.8482/,EG(1151)/9.6596/,EG(1152)/85700./,
     +EG(1155)/-0.2486/,EG(1156)/2.6331/,EG(1157)/11100./,
     +EG(1158)/-0.5890/,EG(1159)/1.7358/,EG(1160)/5880./
C
      DATA KQ(59)/'PR'/,EG(1173)/1.82/,EG(1174)/140.91/,
     +EG(1161)/22.04402/,EG(1162)/2.77393/,EG(1163)/19.66972/,
     +EG(1164)/0.22209/,EG(1165)/12.38561/,EG(1166)/16.76692/,
     +EG(1167)/2.82428/,EG(1168)/143.64410/,EG(1169)/2.05830/,
     +EG(1170)/-2.4164/,EG(1171)/10.2820/,EG(1172)/91200./,
     +EG(1175)/-0.2180/,EG(1176)/2.8214/,EG(1177)/11900./,
     +EG(1178)/-0.5424/,EG(1179)/1.8624/,EG(1180)/6300./
C
      DATA KQ(60)/'ND'/,EG(1193)/1.81/,EG(1194)/144.24/,
     +EG(1181)/22.68452/,EG(1182)/2.66248/,EG(1183)/19.68472/,
     +EG(1184)/0.21063/,EG(1185)/12.77401/,EG(1186)/15.88502/,
     +EG(1187)/2.85137/,EG(1188)/137.90310/,EG(1189)/1.98486/,
     +EG(1190)/-3.1807/,EG(1191)/10.9079/,EG(1192)/96800./,
     +EG(1195)/-0.1943/,EG(1196)/3.0179/,EG(1197)/12700./,
     +EG(1198)/-0.5012/,EG(1199)/1.9950/,EG(1200)/6740./
C
      DATA KQ(61)/'PM'/,EG(1213)/1.81/,EG(1214)/147.00/,
     +EG(1201)/23.34052/,EG(1202)/2.56270/,EG(1203)/19.60953/,
     +EG(1204)/0.20209/,EG(1205)/13.12351/,EG(1206)/15.10091/,
     +EG(1207)/2.87516/,EG(1208)/132.72110/,EG(1209)/2.02876/,
     +EG(1210)/-4.0598/,EG(1211)/11.5523/,EG(1212)/102000./,
     +EG(1215)/-0.1753/,EG(1216)/3.2249/,EG(1217)/13500./,
     +EG(1218)/-0.4626/,EG(1219)/2.1347/,EG(1220)/7200./
C
      DATA KQ(62)/'SM'/,EG(1233)/1.80/,EG(1234)/150.35/,
     +EG(1221)/24.00424/,EG(1222)/2.47274/,EG(1223)/19.42583/,
     +EG(1224)/0.19645/,EG(1225)/13.43961/,EG(1226)/14.39961/,
     +EG(1227)/2.89604/,EG(1228)/128.00710/,EG(1229)/2.20963/,
     +EG(1230)/-5.3236/,EG(1231)/12.2178/,EG(1232)/108000./,
     +EG(1235)/-0.1638/,EG(1236)/3.4418/,EG(1237)/14400./,
     +EG(1238)/-0.4287/,EG(1239)/2.2815/,EG(1240)/7680./
C
      DATA KQ(63)/'EU'/,EG(1253)/2.00/,EG(1254)/151.96/,
     +EG(1241)/24.62744/,EG(1242)/2.38790/,EG(1243)/19.08862/,
     +EG(1244)/0.19420/,EG(1245)/13.76031/,EG(1246)/13.75461/,
     +EG(1247)/2.92270/,EG(1248)/123.17410/,EG(1249)/2.57450/,
     +EG(1250)/-8.9294/,EG(1251)/11.1857/,EG(1252)/110000./,
     +EG(1255)/-0.1578/,EG(1256)/3.6682/,EG(1257)/15400./,
     +EG(1258)/-0.3977/,EG(1259)/2.4351/,EG(1260)/8190./
C
      DATA KQ(64)/'GD'/,EG(1273)/1.79/,EG(1274)/157.25/,
     +EG(1261)/25.07094/,EG(1262)/2.25341/,EG(1263)/19.07982/,
     +EG(1264)/0.18195/,EG(1265)/13.85181/,EG(1266)/12.93311/,
     +EG(1267)/3.54545/,EG(1268)/101.39810/,EG(1269)/2.41960/,
     +EG(1270)/-8.8380/,EG(1271)/11.9157/,EG(1272)/105000./,
     +EG(1275)/-0.1653/,EG(1276)/3.9035/,EG(1277)/16300./,
     +EG(1278)/-0.3741/,EG(1279)/2.5954/,EG(1280)/8720./
C
      DATA KQ(65)/'TB'/,EG(1293)/1.76/,EG(1294)/158.92/,
     +EG(1281)/25.89763/,EG(1282)/2.24256/,EG(1283)/18.21852/,
     +EG(1284)/0.19614/,EG(1285)/14.31671/,EG(1286)/12.66481/,
     +EG(1287)/2.95354/,EG(1288)/115.36210/,EG(1289)/3.58324/,
     +EG(1290)/-9.1472/,EG(1291)/9.1891/,EG(1292)/84700./,
     +EG(1295)/-0.1723/,EG(1296)/4.1537/,EG(1297)/17400./,
     +EG(1298)/-0.3496/,EG(1299)/2.7654/,EG(1300)/9270./
C
      DATA KQ(66)/'DY'/,EG(1313)/1.75/,EG(1314)/162.50/,
     +EG(1301)/26.50703/,EG(1302)/2.18020/,EG(1303)/17.63832/,
     +EG(1304)/0.20217/,EG(1305)/14.55962/,EG(1306)/12.18991/,
     +EG(1307)/2.96577/,EG(1308)/111.87410/,EG(1309)/4.29728/,
     +EG(1310)/-9.8046/,EG(1311)/9.8477/,EG(1312)/97700./,
     +EG(1315)/-0.1892/,EG(1316)/4.4098/,EG(1317)/18400./,
     +EG(1318)/-0.3302/,EG(1319)/2.9404/,EG(1320)/9850./
C
      DATA KQ(67)/'HO'/,EG(1333)/1.74/,EG(1334)/164.93/,
     +EG(1321)/26.90494/,EG(1322)/2.07051/,EG(1323)/17.29402/,
     +EG(1324)/0.19794/,EG(1325)/14.55831/,EG(1326)/11.44071/,
     +EG(1327)/3.63837/,EG(1328)/92.65669/,EG(1329)/4.56797/,
     +EG(1330)/-14.9734/,EG(1331)/3.7046/,EG(1332)/34700./,
     +EG(1335)/-0.2175/,EG(1336)/4.6783/,EG(1337)/19500./,
     +EG(1338)/-0.3168/,EG(1339)/3.1241/,EG(1340)/10400./
C
      DATA KQ(68)/'ER'/,EG(1353)/1.73/,EG(1354)/167.26/,
     +EG(1341)/27.65634/,EG(1342)/2.07356/,EG(1343)/16.42853/,
     +EG(1344)/0.22355/,EG(1345)/14.97791/,EG(1346)/11.36041/,
     +EG(1347)/2.98233/,EG(1348)/105.70310/,EG(1349)/5.92047/,
     +EG(1350)/-9.4367/,EG(1351)/3.9380/,EG(1352)/36700./,
     +EG(1355)/-0.2586/,EG(1356)/4.9576/,EG(1357)/20700./,
     +EG(1358)/-0.3091/,EG(1359)/3.3158/,EG(1360)/11100./
C
      DATA KQ(69)/'TM'/,EG(1373)/1.72/,EG(1374)/168.93/,
     +EG(1361)/28.18193/,EG(1362)/2.02859/,EG(1363)/15.88512/,
     +EG(1364)/0.23885/,EG(1365)/15.15421/,EG(1366)/10.99751/,
     +EG(1367)/2.98706/,EG(1368)/102.96110/,EG(1369)/6.75622/,
     +EG(1370)/-8.0393/,EG(1371)/4.1821/,EG(1372)/39300./,
     +EG(1375)/-0.3139/,EG(1376)/5.2483/,EG(1377)/21900./,
     +EG(1378)/-0.3084/,EG(1379)/3.5155/,EG(1380)/11700./
C
      DATA KQ(70)/'YB'/,EG(1393)/1.94/,EG(1394)/173.04/,
     +EG(1381)/28.66414/,EG(1382)/1.98890/,EG(1383)/15.43451/,
     +EG(1384)/0.25712/,EG(1385)/15.30871/,EG(1386)/10.66471/,
     +EG(1387)/2.98963/,EG(1388)/100.41710/,EG(1389)/7.56673/,
     +EG(1390)/-7.2108/,EG(1391)/4.4329/,EG(1392)/41000./,
     +EG(1395)/-0.3850/,EG(1396)/5.5486/,EG(1397)/23100./,
     +EG(1398)/-0.3157/,EG(1399)/3.7229/,EG(1400)/12400./
C
      DATA KQ(71)/'LU'/,EG(1413)/1.72/,EG(1414)/174.97/,
     +EG(1401)/28.94763/,EG(1402)/1.90182/,EG(1403)/15.22081/,
     +EG(1404)/9.98520/,EG(1405)/15.10001/,EG(1406)/0.26103/,
     +EG(1407)/3.71601/,EG(1408)/84.32988/,EG(1409)/7.97629/,
     +EG(1410)/-6.6179/,EG(1411)/4.6937/,EG(1412)/45000./,
     +EG(1415)/-0.4720/,EG(1416)/5.8584/,EG(1417)/24400./,
     +EG(1418)/-0.3299/,EG(1419)/3.9377/,EG(1420)/13100./
C
      DATA KQ(72)/'HF'/,EG(1433)/1.56/,EG(1434)/178.49/,
     +EG(1421)/29.14404/,EG(1422)/1.83262/,EG(1423)/15.17261/,
     +EG(1424)/9.59991/,EG(1425)/14.75861/,EG(1426)/0.27512/,
     +EG(1427)/4.30013/,EG(1428)/72.02908/,EG(1429)/8.58155/,
     +EG(1430)/-6.1794/,EG(1431)/4.9776/,EG(1432)/46000./,
     +EG(1435)/-0.5830/,EG(1436)/6.1852/,EG(1437)/25800./,
     +EG(1438)/-0.3548/,EG(1439)/4.1643/,EG(1440)/13900./
C
      DATA KQ(73)/'TA'/,EG(1453)/1.43/,EG(1454)/180.95/,
     +EG(1441)/29.20244/,EG(1442)/1.77333/,EG(1443)/15.22931/,
     +EG(1444)/9.37047/,EG(1445)/14.51351/,EG(1446)/0.29598/,
     +EG(1447)/4.76492/,EG(1448)/63.36447/,EG(1449)/9.24355/,
     +EG(1450)/-5.7959/,EG(1451)/5.2718/,EG(1452)/48500./,
     +EG(1455)/-0.7052/,EG(1456)/6.5227/,EG(1457)/27200./,
     +EG(1458)/-0.3831/,EG(1459)/4.3992/,EG(1460)/14600./
C
      DATA KQ(74)/'W '/,EG(1473)/1.37/,EG(1474)/183.85/,
     +EG(1461)/29.08183/,EG(1462)/1.72029/,EG(1463)/15.43001/,
     +EG(1464)/9.22591/,EG(1465)/14.43271/,EG(1466)/0.32170/,
     +EG(1467)/5.11983/,EG(1468)/57.05606/,EG(1469)/9.88751/,
     +EG(1470)/-5.4734/,EG(1471)/5.5774/,EG(1472)/51300./,
     +EG(1475)/-0.8490/,EG(1476)/6.8722/,EG(1477)/28600./,
     +EG(1478)/-0.4201/,EG(1479)/4.6430/,EG(1480)/15400./
C
      DATA KQ(75)/'RE'/,EG(1493)/1.37/,EG(1494)/186.20/,
     +EG(1481)/28.76213/,EG(1482)/1.67191/,EG(1483)/15.71892/,
     +EG(1484)/9.09228/,EG(1485)/14.55641/,EG(1486)/0.35050/,
     +EG(1487)/5.44174/,EG(1488)/52.08615/,EG(1489)/10.47201/,
     +EG(1490)/-5.2083/,EG(1491)/5.8923/,EG(1492)/57200./,
     +EG(1495)/-1.0185/,EG(1496)/7.2310/,EG(1497)/30100./,
     +EG(1498)/-0.4693/,EG(1499)/4.8944/,EG(1500)/16200./
C
      DATA KQ(76)/'OS'/,EG(1513)/1.34/,EG(1514)/190.20/,
     +EG(1501)/28.18944/,EG(1502)/1.62903/,EG(1503)/16.15501/,
     +EG(1504)/8.97949/,EG(1505)/14.93051/,EG(1506)/0.38266/,
     +EG(1507)/5.67590/,EG(1508)/48.16475/,EG(1509)/11.00051/,
     +EG(1510)/-4.9801/,EG(1511)/6.2216/,EG(1512)/58000./,
     +EG(1515)/-1.2165/,EG(1516)/7.6030/,EG(1517)/31600./,
     +EG(1518)/-0.5280/,EG(1519)/5.1558/,EG(1520)/17100./
C
      DATA KQ(77)/'IR'/,EG(1533)/1.36/,EG(1534)/192.20/,
     +EG(1521)/27.30493/,EG(1522)/1.59279/,EG(1523)/16.72961/,
     +EG(1524)/8.86554/,EG(1525)/15.61152/,EG(1526)/0.41792/,
     +EG(1527)/5.83378/,EG(1528)/45.00114/,EG(1529)/11.47221/,
     +EG(1530)/-4.7710/,EG(1531)/6.5667/,EG(1532)/62400./,
     +EG(1535)/-1.4442/,EG(1536)/7.9887/,EG(1537)/33100./,
     +EG(1538)/-0.5977/,EG(1539)/5.4269/,EG(1540)/18000./
C
      DATA KQ(78)/'PT'/,EG(1553)/1.37/,EG(1554)/195.09/,
     +EG(1541)/27.00594/,EG(1542)/1.51293/,EG(1543)/17.76392/,
     +EG(1544)/8.81175/,EG(1545)/15.71312/,EG(1546)/0.42459/,
     +EG(1547)/5.78371/,EG(1548)/38.61034/,EG(1549)/11.68831/,
     +EG(1550)/-4.5932/,EG(1551)/6.9264/,EG(1552)/63400./,
     +EG(1555)/-1.7033/,EG(1556)/8.3905/,EG(1557)/34800./,
     +EG(1558)/-0.6812/,EG(1559)/5.7081/,EG(1560)/18900./
C
      DATA KQ(79)/'AU'/,EG(1573)/1.44/,EG(1574)/196.9665/,
     +EG(1561)/16.88193/,EG(1562)/0.46110/,EG(1563)/18.59132/,
     +EG(1564)/8.62161/,EG(1565)/25.55824/,EG(1566)/1.48260/,
     +EG(1567)/5.86001/,EG(1568)/36.39563/,EG(1569)/12.06581/,
     +EG(1570)/-4.4197/,EG(1571)/7.2980/,EG(1572)/66900./,
     +EG(1575)/-2.0133/,EG(1576)/8.8022/,EG(1577)/36500./,
     +EG(1578)/-0.7638/,EG(1579)/5.9978/,EG(1580)/19900./
C
      DATA KQ(80)/'HG'/,EG(1593)/1.50/,EG(1594)/200.59/,
     +EG(1581)/20.68092/,EG(1582)/0.54500/,EG(1583)/19.04172/,
     +EG(1584)/8.44841/,EG(1585)/21.65752/,EG(1586)/1.57290/,
     +EG(1587)/5.96761/,EG(1588)/38.32463/,EG(1589)/12.60891/,
     +EG(1590)/-4.2923/,EG(1591)/7.6849/,EG(1592)/66800./,
     +EG(1595)/-2.3894/,EG(1596)/9.2266/,EG(1597)/38200./,
     +EG(1598)/-0.8801/,EG(1599)/6.2989/,EG(1600)/20900./
C
      DATA KQ(81)/'TL'/,EG(1613)/1.64/,EG(1614)/204.37/,
     +EG(1601)/27.54463/,EG(1602)/0.65515/,EG(1603)/19.15842/,
     +EG(1604)/8.70752/,EG(1605)/15.53802/,EG(1606)/1.96347/,
     +EG(1607)/5.52594/,EG(1608)/45.81496/,EG(1609)/13.17461/,
     +EG(1610)/-4.1627/,EG(1611)/8.0900/,EG(1612)/75400./,
     +EG(1615)/-2.8358/,EG(1616)/9.6688/,EG(1617)/40100./,
     +EG(1618)/-1.0117/,EG(1619)/6.6090/,EG(1620)/21900./
C
      DATA KQ(82)/'PB'/,EG(1633)/1.60/,EG(1634)/207.19/,
     +EG(1621)/31.06174/,EG(1622)/0.69020/,EG(1623)/13.06371/,
     +EG(1624)/2.35760/,EG(1625)/18.44202/,EG(1626)/8.61801/,
     +EG(1627)/5.96961/,EG(1628)/47.25795/,EG(1629)/13.41181/,
     +EG(1630)/-4.0753/,EG(1631)/8.5060/,EG(1632)/79800./,
     +EG(1635)/-3.3944/,EG(1636)/10.1111/,EG(1637)/41900./,
     +EG(1638)/-1.1676/,EG(1639)/6.9287/,EG(1640)/22900./
C
      DATA KQ(83)/'BI'/,EG(1653)/1.60/,EG(1654)/208.98/,
     +EG(1641)/33.36894/,EG(1642)/0.70400/,EG(1643)/12.95101/,
     +EG(1644)/2.92380/,EG(1645)/16.58772/,EG(1646)/8.79371/,
     +EG(1647)/6.46921/,EG(1648)/48.00935/,EG(1649)/13.57821/,
     +EG(1650)/-4.0111/,EG(1651)/8.9310/,EG(1652)/84300./,
     +EG(1655)/-4.1077/,EG(1656)/10.2566/,EG(1657)/43800./,
     +EG(1658)/-1.3494/,EG(1659)/7.2566/,EG(1660)/24000./
C
      DATA KQ(84)/'PO'/,EG(1673)/1.60/,EG(1674)/210.00/,
     +EG(1661)/34.67264/,EG(1662)/0.70100/,EG(1663)/15.47331/,
     +EG(1664)/3.55078/,EG(1665)/13.11381/,EG(1666)/9.55643/,
     +EG(1667)/7.02589/,EG(1668)/47.00455/,EG(1669)/13.67701/,
     +EG(1670)/-3.9670/,EG(1671)/9.3834/,EG(1672)/88100./,
     +EG(1675)/-5.1210/,EG(1676)/11.0496/,EG(1677)/45800./,
     +EG(1678)/-1.5613/,EG(1679)/7.5986/,EG(1680)/25100./
C
      DATA KQ(85)/'AT'/,EG(1693)/1.60/,EG(1694)/210.00/,
     +EG(1681)/35.31633/,EG(1682)/0.68587/,EG(1683)/19.02112/,
     +EG(1684)/3.97458/,EG(1685)/9.49888/,EG(1686)/11.38241/,
     +EG(1687)/7.42519/,EG(1688)/45.47156/,EG(1689)/13.71081/,
     +EG(1690)/-3.9588/,EG(1691)/9.8433/,EG(1692)/86500./,
     +EG(1695)/-7.9122/,EG(1696)/9.9777/,EG(1697)/40700./,
     +EG(1698)/-1.8039/,EG(1699)/7.9509/,EG(1700)/26200./
C
      DATA KQ(86)/'RN'/,EG(1713)/1.80/,EG(1714)/222.00/,
     +EG(1701)/35.56314/,EG(1702)/0.66310/,EG(1703)/21.28162/,
     +EG(1704)/4.06910/,EG(1705)/8.00371/,EG(1706)/14.04221/,
     +EG(1707)/7.44331/,EG(1708)/44.24734/,EG(1709)/13.69051/,
     +EG(1710)/-3.9487/,EG(1711)/10.3181/,EG(1712)/97200./,
     +EG(1715)/-8.0659/,EG(1716)/10.4580/,EG(1717)/39800./,
     +EG(1718)/-2.0847/,EG(1719)/8.3112/,EG(1720)/27300./
C
      DATA KQ(87)/'FR'/,EG(1733)/2.80/,EG(1734)/223.00/,
     +EG(1721)/35.92993/,EG(1722)/0.64645/,EG(1723)/23.05472/,
     +EG(1724)/4.17619/,EG(1725)/12.14391/,EG(1726)/23.10522/,
     +EG(1727)/2.11253/,EG(1728)/150.64510/,EG(1729)/13.72471/,
     +EG(1730)/-3.9689/,EG(1731)/10.8038/,EG(1732)/102000./,
     +EG(1735)/-7.2224/,EG(1736)/7.7847/,EG(1737)/32200./,
     +EG(1738)/-2.4129/,EG(1739)/8.6839/,EG(1740)/28500./
C
      DATA KQ(88)/'RA'/,EG(1753)/2.20/,EG(1754)/226.00/,
     +EG(1741)/35.76303/,EG(1742)/0.61634/,EG(1743)/22.90642/,
     +EG(1744)/3.87135/,EG(1745)/12.47391/,EG(1746)/19.98872/,
     +EG(1747)/3.21097/,EG(1748)/142.32510/,EG(1749)/13.62111/,
     +EG(1750)/-4.0088/,EG(1751)/11.2969/,EG(1752)/102000./,
     +EG(1755)/-6.7704/,EG(1756)/8.1435/,EG(1757)/33000./,
     +EG(1758)/-2.8081/,EG(1759)/9.0614/,EG(1760)/29800./
C
      DATA KQ(89)/'AC'/,EG(1773)/1.90/,EG(1774)/227.00/,
     +EG(1761)/35.65973/,EG(1762)/0.58909/,EG(1763)/23.10323/,
     +EG(1764)/3.65155/,EG(1765)/12.59771/,EG(1766)/18.59901/,
     +EG(1767)/4.08655/,EG(1768)/117.02010/,EG(1769)/13.52661/,
     +EG(1770)/-4.0794/,EG(1771)/11.7994/,EG(1772)/143000./,
     +EG(1775)/-6.8494/,EG(1776)/8.5178/,EG(1777)/54000./,
     +EG(1778)/-3.2784/,EG(1779)/9.4502/,EG(1780)/31100./
C
      DATA KQ(90)/'TH'/,EG(1793)/1.85/,EG(1794)/232.04/,
     +EG(1781)/35.56453/,EG(1782)/0.56336/,EG(1783)/23.42192/,
     +EG(1784)/3.46204/,EG(1785)/12.74731/,EG(1786)/17.83092/,
     +EG(1787)/4.80704/,EG(1788)/99.17230/,EG(1789)/13.43141/,
     +EG(1790)/-4.1491/,EG(1791)/12.3296/,EG(1792)/118000./,
     +EG(1795)/-7.2400/,EG(1796)/8.8979/,EG(1797)/37000./,
     +EG(1798)/-3.8533/,EG(1799)/9.8403/,EG(1800)/32300./
C
      DATA KQ(91)/'PA'/,EG(1813)/1.80/,EG(1814)/231.00/,
     +EG(1801)/35.88474/,EG(1802)/0.54775/,EG(1803)/23.29482/,
     +EG(1804)/3.41519/,EG(1805)/14.18911/,EG(1806)/16.92352/,
     +EG(1807)/4.17287/,EG(1808)/105.25110/,EG(1809)/13.42871/,
     +EG(1810)/-4.2473/,EG(1811)/12.8681/,EG(1812)/106000./,
     +EG(1815)/-8.0334/,EG(1816)/9.2807/,EG(1817)/38700./,
     +EG(1818)/-4.6067/,EG(1819)/10.2413/,EG(1820)/34200./
C
      DATA KQ(92)/'U '/,EG(1833)/1.80/,EG(1834)/238.03/,
     +EG(1821)/36.02284/,EG(1822)/0.52930/,EG(1823)/23.41283/,
     +EG(1824)/3.32530/,EG(1825)/14.94911/,EG(1826)/16.09273/,
     +EG(1827)/4.18800/,EG(1828)/100.61310/,EG(1829)/13.39661/,
     +EG(1830)/-4.3638/,EG(1831)/13.4090/,EG(1832)/112000./,
     +EG(1835)/-9.6767/,EG(1836)/9.6646/,EG(1837)/40300./,
     +EG(1838)/-5.7225/,EG(1839)/10.6428/,EG(1840)/35000./
C
      DATA KQ(93)/'NP'/,EG(1853)/1.80/,EG(1854)/237.00/,
     +EG(1841)/36.18744/,EG(1842)/0.51193/,EG(1843)/23.59642/,
     +EG(1844)/3.25396/,EG(1845)/15.64022/,EG(1846)/15.36222/,
     +EG(1847)/4.18550/,EG(1848)/97.49089/,EG(1849)/13.35731/,
     +EG(1850)/-4.5053/,EG(1851)/13.9666/,EG(1852)/123000./,
     +EG(1855)/-11.4937/,EG(1856)/4.1493/,EG(1857)/25700./,
     +EG(1858)/-6.9995/,EG(1859)/9.5876/,EG(1860)/29900./
C
      DATA KQ(94)/'PU'/,EG(1873)/1.80/,EG(1874)/242.00/,
     +EG(1861)/36.52544/,EG(1862)/0.49938/,EG(1863)/23.80832/,
     +EG(1864)/3.26371/,EG(1865)/16.77072/,EG(1866)/14.94551/,
     +EG(1867)/3.47947/,EG(1868)/105.98010/,EG(1869)/13.38121/,
     +EG(1870)/-4.6563/,EG(1871)/14.3729/,EG(1872)/113000./,
     +EG(1875)/-9.4100/,EG(1876)/4.3056/,EG(1877)/16200./,
     +EG(1878)/-13.5905/,EG(1879)/6.9468/,EG(1880)/22700./
C
C Default parameters
C
        DO 1 I=1,50
        IH(I)=IG(I)
   1    CONTINUE
        DO 2 I=1,1880
        EF(I)=EG(I)
   2    CONTINUE
        DO 3 I=1,94
        KA(I)=KQ(I)
   3    CONTINUE
      JA=1
      JB=0
      JC=0
      KH=0
      LY=201
      LL=1
      LB=0
      LX=0
      LT=0
        DO 4 I=1,212
        A(I)=0.
   4    CONTINUE
        DO 5 I=33,35
        A(I)=-2.
        A(I+3)=2.
   5    CONTINUE
      A(39)=-9.E9
      A(46)=2.
      A(49)=1.
      A(51)=1.
      A(52)=-1.
      A(53)=1.
      A(56)=53.
      A(59)=3.
      A(63)=1.
      A(64)=.1
      A(69)=.3333333
      A(70)=1.
      A(72)=.7
      A(104)=20.
      A(121)=.001
      A(122)=.001
      A(123)=9.E9
      A(124)=9.E9
      A(125)=.2
      A(126)=12.
      A(130)=9.E9
      A(132)=.02
      A(133)=.1
      A(134)=.01
      A(135)=.04
      A(155)=1.
      A(170)=15.
      A(180)=-999.
      A(194)=-999.
      A(196)=1.
      A(198)=.01
      A(200)=-999.
      A(201)=1.
      A(205)=1.
      A(209)=1.
C
      WRITE(*,'(A)')' Read instructions and data'
      CALL SXFL
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SX3B(LM,JW,LU,MK,ML,FF,SI,FC,A,B,EF)
C
C Read and interpret instructions
C
      CHARACTER*1 IH(50),KK,KJ,KD
      CHARACTER*2 KA(94)
      CHARACTER*4 KL,KQ,KS,KT,KU,KV,KW,KX,KY,KZ,KC(70)
      CHARACTER*76 IT
      CHARACTER*80 NM,IR
      INTEGER MK(LU),ML(LU)
      REAL FF(LU),SI(LU),FC(LU),A(LM),B(JW),EF(1880)
      COMMON/MEM/ST,SL,TC,TL,IV,LR,LG,LH,LI,LP,LF,LA,LC,LW,LY,LL,LB,
     +LX,LE,LV,LJ,LD,LS,LO,LT,LK,LQ,LZ,LN,KH,JA,JB,JC,JD,JE,HA,HD
      COMMON/WORD/IH,IT,IR,NM,KA,KD
C
C Instruction codewords
C
      DATA KC/'    ','END ','MOVE','SWAT','WPDB','BASF','EXTI',
     +'FVAR','WGHT','FRAG','FEND','REM ','CELL','ZERR','LATT',
     +'SYMM','SFAC','UNIT','GRID','MOLE','FMAP','PLAN','AFIX',
     +'TWIN','SPEC','OMIT','MERG','SUMP','RESI','SHEL','MORE',
     +'TIME','L.S.','CGLS','ACTA','DAMP','LIST','PART','DISP',
     +'HKLF','HOPE','SIZE','NCSY','EQIV','EXYZ','EADP','BOND',
     +'FREE','BIND','DFIX','SAME','CONF','RTAB','MPLA','FLAT',
     +'CHIV','BLOC','DELU','SIMU','ISOR','SADI','ANIS','CONN',
     +'HFIX','LAUE','BUMP','TEMP','DEFS','HTAB','TITL'/,KJ/'!'/
C
   1  FORMAT(A)
   2  FORMAT(1X,A)
   3  FORMAT(/' V =',F12.2,5X,'F(000) =',F10.1,5X,'Mu =',F7.2,
     +' mm-1',5X,' Cell Wt =',F12.2,'    Rho =',F7.3/)
   4  FORMAT(/' Name    a1       b1       a2       b2       a3      ',
     +' b3       a4       b4        c        f''       f"        mu ',
     +'     M    rad'/)
   5  FORMAT(1X,A4,11F9.5,F10.2,F7.2,F6.2)
   6  FORMAT(F7.3,2F8.3)
   7  FORMAT(/' ** SHELX-76/XLS weights are inappropriate for ',
     +'refinement against F-squared **'/)
C
C Default parameters
C
      IA=0
      JE=0
      JQ=0
      KI=0
      KG=0
      NA=LU
      NQ=12
      DT=.05
      B(JA)=0.
      CALL SXPS(A(43),KC(1))
      CALL SXPS(A(44),'0   ')
      ML(1)=1
C
C Read instruction and identify codeword
C
   8  IF(LX.GT.LM-1000)GOTO 74
      IF(JA.GT.JW-1000)GOTO 74
      CALL SXCC
      READ(LR,1,END=97)IR
      KS='    '
      IF(IR(1:1).EQ.IH(13))GOTO 18
        DO 9 KB=1,4
        IF(IR(KB:KB).LT.IH(20))IR(KB:KB)=IH(20)
        KK=IR(KB:KB)
        IF(KK.EQ.IH(20))GOTO 10
        IF(KK.EQ.IH(22))GOTO 10
        IF(KK.EQ.KJ)GOTO 10
        CALL SXUC(KK)
        KS(KB:KB)=KK
   9    CONTINUE
      KB=5
  10  KB=KB-1
      KR=KB
      IF(KR.EQ.0)KR=1
      KE=80
        DO 11 I=KB+1,80
        IF(IR(I:I).LT.IH(20))IR(I:I)=IH(20)
        IF(IR(I:I).EQ.KJ)KE=MIN0(KE,I-1)
        IF(IR(I:I).NE.IH(20))KR=I
  11    CONTINUE
      IF(KE.GT.KR)KE=KR
      IF(ABS(A(51)).GT.0.5)WRITE(LI,2)IR(1:KR)
      DF=1.
        DO 12 NK=1,70
        IF(KC(NK).EQ.KS)GOTO 14
  12    CONTINUE
      NK=30
      IF(KS.EQ.'STIR')GOTO 14
      IF(KS.EQ.'DANG')GOTO 13
      NK=1
      IF(LR.NE.LK)GOTO 21
      IF(JB.EQ.0)WRITE(LC)NK,KR,KS,IR
      GOTO 21
  13  NK=50
      DF=-1.
  14  IF(NK.EQ.62)GOTO 17
      IF(NK.EQ.64)GOTO 17
      IF(KR.NE.1)GOTO 15
      NK=NQ
      NQ=1
  15  IF(NK.EQ.1)GOTO 8
      IF(LR.NE.LK)GOTO 17
      IF(NK.EQ.5)GOTO 16
      IF(KS.EQ.'STIR')GOTO 17
      IF(NK.LT.12)GOTO 17
  16  WRITE(LC)NK,KR,KS,IR
      IF(KR.NE.1)NQ=12
  17  IF(NK.EQ.12)GOTO 8
      IF(NK.NE.70)GOTO 20
      IF(KE.LT.5)KE=5
      IT=IR(5:KE)
      GOTO 8
C
C Open nested input files
C
  18  K=0
        DO 19 I=2,80
        IF(IR(I:I).EQ.IH(20))GOTO 19
        K=K+1
        IR(K:K)=IR(I:I)
        CALL SXLC(IR(K:K))
  19    CONTINUE
      I=-1
      WRITE(LC)I,K+1,KS,IH(13)//IR(1:79)
      LR=LR+1
      OPEN(LR,FILE=IR(1:K),STATUS='OLD',ERR=94)
      GOTO 8
C
C Decode instruction
C
  20  IF(JB.EQ.0)GOTO 21
      IF(NK.NE.11)CALL SXER(KS//' NOT ALLOWED IN FRAG...FEND SECTION')
  21  MQ=0
        DO 26 I=KB+1,KE
        CALL SXUC(IR(I:I))
        IF(IR(I:I).EQ.IH(23))GOTO 22
        IF(IR(I:I).NE.IH(24))GOTO 25
  22    IF(MQ.EQ.0)GOTO 24
        IF(I.EQ.KE)GOTO 24
        IF(IR(I-1:I-1).NE.IH(20))GOTO 23
        IF(IR(I+1:I+1).EQ.IH(20))GOTO 26
  23    CALL SXER('SPACE NEEDED BEFORE AND AFTER < OR >')
  24    CALL SXER('MISPLACED < OR >')
  25    IF(IR(I:I).NE.IH(20))MQ=1
  26    CONTINUE
      CALL SXUS(A(44),KT)
      CALL SXPS(FC(1),KT)
      IF(NA.LT.1)NA=1
      CALL SXZA(FF,NA)
      NA=0
      MQ=1
C
C Evaluate numbers in instruction
C
      N=KB
      NJ=77
      L=91
      IF(NK.EQ.44)GOTO 27
      NJ=LY+7
      L=LY+21
      IF(NK.NE.16)GOTO 29
  27  M=L+2
        DO 28 I=NJ+5,M
        A(I)=0.
  28    CONTINUE
  29  W=1.
  30  V=0.
      NB=0
      Y=1.
      U=10.
      Z=1.
      X=0.
      GOTO 32
  31  Z=Y*Z
      V=U*ABS(V)+Z*X
      NB=1
      IF(ABS(V).LT.1.E-8)GOTO 32
      V=SIGN(V,W)
      W=V
  32  N=N+1
      K=11
      IF(N.GT.KE)GOTO 35
      X=0.
        DO 33 K=1,19
        IF(IR(N:N).EQ.IH(K))GOTO 34
        X=X+1.
  33    CONTINUE
      K=1
      GOTO 35
C
C SYMM and EQIV
C
  34  IF(K.LT.11)GOTO 31
      K=K-9
  35  IF(NK.NE.44)GOTO 36
      M=0
      IF(IR(N:N).EQ.IH(50))GOTO 55
      GOTO 37
  36  IF(NK.NE.16)GOTO 49
  37  IF(K.NE.10)GOTO 41
      IF(ABS(V).LT.1.E-8)GOTO 81
      N=N+1
      IF(N.GT.KE)GOTO 81
        DO 38 I=2,7
        IF(IH(I).EQ.IR(N:N))GOTO 39
  38    CONTINUE
      GOTO 81
  39  V=V/REAL(I-1)
      W=V
      IF(N.EQ.KE)GOTO 32
        DO 40 I=1,10
        IF(IH(I).EQ.IR(N+1:N+1))GOTO 81
  40    CONTINUE
      GOTO 32
  41  IF(K.EQ.9)GOTO 45
      IF(K.GT.7)GOTO 44
      IF(K.GT.4)GOTO 43
      IF(K.GT.2)GOTO 51
      IF(K.EQ.1)GOTO 32
  42  U=1.
      Y=0.1
      GOTO 32
  43  K=K+NJ
      A(K)=W
      GOTO 29
  44  U=AINT(V)
      A(L)=A(L)+U+AINT(24.5*(V-U))/24.
      L=L+1
      NJ=NJ+3
      IF(NJ+8.LT.L)GOTO 29
      IF(NK.EQ.44)GOTO 215
      LY=LY+12
      IF(LB.EQ.0)GOTO 8
      CALL SXER('MISPLACED SYMM INSTRUCTION')
C
C Continuation lines and errors
C
  45  IF(NK.EQ.44)GOTO 78
      IF(NK.EQ.16)GOTO 78
      READ(LR,1,END=48)IR
      KR=1
      KE=80
        DO 46 I=1,80
        IF(IR(I:I).LT.IH(20))IR(I:I)=IH(20)
        IF(IR(I:I).EQ.KJ)KE=MIN0(KE,I-1)
        IF(IR(I:I).EQ.IH(20))GOTO 46
        KR=I
        CALL SXUC(IR(I:I))
  46    CONTINUE
      IF(KE.GT.KR)KE=KR
      N=0
      IF(ABS(A(51)).GT.0.5)WRITE(LI,2)IR(1:KR)
      IF(NK.EQ.62)GOTO 47
      IF(NK.EQ.64)GOTO 47
      IF(LR.NE.LK)GOTO 47
      IF(NK.GT.11)WRITE(LC)N,KR,KS,IR
  47  IF(IR(1:1).NE.IH(20))CALL SXER('BAD CONTINUATION LINE')
      GOTO 29
  48  CALL SXER('END OF FILE INSTEAD OF CONTINUATION LINE')
  49  IF(K.EQ.2)GOTO 42
      IF(NB.EQ.0)GOTO 53
      NA=NA+1
      IF(NA.GT.LU)CALL SXER('TOO MANY NUMBERS IN COMMAND')
      FF(NA)=V
  50  IF(K.LT.9)GOTO 52
      IF(K.GT.9)GOTO 98
      GOTO 45
  51  U=AINT(V)
      A(L)=A(L)+U+AINT(24.5*(V-U))/24.
  52  IF(K.NE.3)GOTO 29
      W=-1.
      GOTO 30
  53  IF(K.EQ.1)K=6
      IF(IABS(K-6).GT.1)GOTO 50
      IF(IR(N:N).EQ.IH(20))GOTO 50
C
C Decode atom names and residue references
C
      M=0
      IF(IR(N:N).NE.IH(22))GOTO 55
      IF(N.GT.KB+1)CALL SXER('RESIDUE REFERENCE MUST '//
     +'IMMEDIATELY FOLLOW COMMAND OR ATOM NAME')
  54  N=N+1
      M=1
  55  KT=KC(1)
        DO 56 K=1,4
        IF(N.GT.KE)GOTO 57
        IF(IR(N:N).EQ.IH(17))GOTO 57
        IF(IR(N:N).EQ.IH(18))GOTO 57
        IF(IR(N:N).EQ.IH(20))GOTO 57
        IF(IR(N:N).EQ.IH(22))GOTO 57
        KT(K:K)=IR(N:N)
        N=N+1
  56    CONTINUE
  57  IF(M.NE.0)GOTO 67
      MQ=MQ+2
      IF(MQ.GE.LU)CALL SXER('TOO MANY NAMES IN COMMAND')
      CALL SXPS(FC(MQ-1),KT)
      CALL SXPS(FC(MQ),KC(1))
      IF(KT(1:1).NE.IH(23))GOTO 58
      IF(NK.EQ.51)GOTO 29
      GOTO 92
  58  IF(KT(1:1).NE.IH(24))GOTO 59
      IF(NK.EQ.61)GOTO 92
      IF(NK.EQ.26)GOTO 29
      IF(NK.EQ.43)GOTO 29
      IF(NK.GT.50)GOTO 29
      IF(IABS(NK-46).LT.2)GOTO 29
      GOTO 92
  59  IF(KT(1:1).NE.IH(50))GOTO 65
      IF(NK.EQ.61)GOTO 92
      IF(NK.EQ.69)GOTO 60
      IF(NK.GE.57)GOTO 66
      IF(NK.EQ.26)GOTO 66
      IF(NK.EQ.39)GOTO 66
      IF(NK.NE.47)GOTO 60
      IF(KT(2:2).NE.IH(34))GOTO 66
      IF(KT(3:3).EQ.IH(20))GOTO 29
      GOTO 66
  60  IF(NK.NE.17)GOTO 61
      KQ=KT(2:4)
      KT=KQ
      GOTO 29
  61  IF(NK.NE.44)GOTO 92
      GOTO 63
  62  IF(NK.EQ.61)GOTO 63
      IF(NK.EQ.69)GOTO 63
      IF(NK.GT.55)GOTO 92
      IF(NK.EQ.51)GOTO 92
      IF(NK.LT.47)GOTO 92
  63    DO 64 I=1,10
        IF(IH(I).EQ.KT(2:2))GOTO 29
  64    CONTINUE
      GOTO 93
  65  IF(NK.EQ.17)GOTO 66
      IF(NK.EQ.26)GOTO 66
      IF(NK.EQ.29)GOTO 66
      IF(NK.EQ.39)GOTO 66
      IF(NK.EQ.43)GOTO 66
      IF(NK.EQ.69)GOTO 66
      IF(NK.LT.45)GOTO 88
      IF(NK.GT.65)GOTO 88
  66  IF(IR(N:N).NE.IH(22))GOTO 29
      GOTO 54
  67  CALL SXPS(FC(MQ),KT)
      IF(NK.EQ.26)GOTO 68
      IF(NK.EQ.43)GOTO 68
      IF(NK.EQ.69)GOTO 68
      IF(NK.LT.45)GOTO 91
      IF(NK.GT.64)GOTO 91
  68  IF(KT(1:1).EQ.IH(50))GOTO 62
      IF(KT(1:1).EQ.IH(12))GOTO 69
      IF(KT(1:1).NE.IH(13))GOTO 71
  69  IF(MQ.EQ.1)GOTO 92
      IF(NK.EQ.50)GOTO 70
      IF(NK.EQ.57)GOTO 70
      IF(NK.EQ.61)GOTO 70
      IF(NK.EQ.69)GOTO 70
      IF(NK.LT.52)GOTO 92
      IF(NK.GT.55)GOTO 92
  70  IF(KT(2:2).NE.IH(20))GOTO 91
      GOTO 29
  71  IF(MQ.EQ.1)GOTO 29
        DO 72 K=1,10
        IF(KT(1:1).EQ.IH(K))GOTO 29
  72    CONTINUE
      IF(KT(1:1).NE.IH(21))GOTO 91
      IF(KT(2:2).NE.IH(20))GOTO 91
      CALL SXUS(FC(MQ-1),KT)
      IF(KT(1:1).NE.IH(50))GOTO 91
      IF(NK.EQ.58)GOTO 29
      IF(NK.EQ.59)GOTO 29
      GOTO 91
C
C Error diagnostics
C
  73  CALL SXER('INCOMPLETE '//KS//' GROUP')
  74  CALL SXER('PROBLEM TOO LARGE FOR CURRENT ARRAY DIMENSIONS')
  75  CALL SXER('WRONG NUMBER OF NUMERICAL PARAMETERS')
  76  CALL SXER('WRONG NUMBER OF ATOM NAMES')
  77  CALL SXER('REPEATED '//KS//' INSTRUCTION')
  78  CALL SXER('CONTINUATION LINE NOT ALLOWED AFTER '//KS)
  79  CALL SXER('CELL MISSING')
  80  CALL SXER('BAD CELL')
  81  CALL SXER('BAD SYMMETRY OPERATOR')
  82  CALL SXER('INCONSISTENT LATT/SYMM')
  83  CALL SXER('BAD ATOM OR UNKNOWN INSTRUCTION')
  84  CALL SXER('CONFLICTING AFIX BEFORE END OF FITTED GROUP')
  85  CALL SXER('AFIX REFERS TO UNKNOWN FRAG')
  86  CALL SXER('FREE VARIABLE REFERENCE PREVENTS MOVE')
  87  CALL SXER('PARAMETER OUT OF RANGE')
  88  CALL SXER('ATOM NAMES NOT ALLOWED')
  89  CALL SXER('LAUE REQUIRES ONE $EL TO SPECIFY ELEMENT')
  90  CALL SXER('LAUE MUST FOLLOW ALL ATOMS')
  91  CALL SXER('ILLEGAL REFERENCE TO RESIDUE '//KT)
  92  CALL SXER(KT(1:1)//' NOT ALLOWED HERE')
  93  CALL SXER('EQIV MUST BE FOLLOWED BY $n THEN SYMMETRY OPERATOR')
  94  CALL SXER('CANNOT OPEN NESTED INPUT FILE '//IR(1:K))
  95  CALL SXER(KS//'NOT ALLOWED IN INCLUDE FILE')
  96  CALL SXER('TOO MANY ATOMS REFERENCED IN SINGLE '//KS//
     +' INSTRUCTION')
C
C Eof or END - close current input file and return to previous level
C
  97  NK=2
      NA=0
  98  IF(NK.NE.2)GOTO 100
      IF(NA.NE.0)CALL SXER('BAD END')
      IF(LR.LE.LK)GOTO 99
      CLOSE(LR,STATUS='KEEP')
      LR=LR-1
      GOTO 8
  99  NK=40
      NA=1
      FF(1)=4.
      KR=6
      IR='HKLF 4'
      IF(LR.EQ.LK)WRITE(LC)NK,KR,IR(1:4),IR
C
C Set up crystal data - CELL
C
 100  IF(NK.GT.69)GOTO 8
      IF(NK.NE.13)GOTO 104
      IF(A(1).GT.0.001)GOTO 77
      IF(NA.NE.7)GOTO 80
      IF(FF(1).LE.0.)GOTO 80
      A(1)=FF(1)
        DO 101 I=2,NA
        IF(.1.GT.FF(I))GOTO 80
        A(I)=FF(I)
 101    CONTINUE
      U=2.*A(2)*A(3)*A(4)
        DO 102 I=2,4
        X=1.74533E-2*A(I+3)
        FF(I)=COS(X)
        FF(I+3)=SIN(X)
        A(I+9)=U*FF(I)/A(I)
        FF(I+6)=A(I+9)**2
        A(I+6)=A(I)**2
 102    CONTINUE
      X=(FF(2)-FF(3)*FF(4))/(FF(6)*FF(7))
      A(94)=A(2)
      A(95)=A(3)*FF(4)
      A(96)=A(4)*FF(3)
      A(97)=A(3)*FF(7)
      A(98)=A(4)*FF(6)*X
      A(99)=A(4)*FF(6)*SQRT(ABS(1.-X**2))
      A(20)=A(94)*A(97)*A(99)
      V=.125*(A(1)/A(20))**2
        DO 103 I=8,10
        A(I+6)=.5*V*((U**2/A(I))-FF(I))
        A(I+9)=-2.*V*A(I)*A(I+3)
 103    CONTINUE
      A(17)=A(17)+V*A(12)*A(13)
      A(18)=A(18)+V*A(11)*A(13)
      A(19)=A(19)+V*A(11)*A(12)
      NA=10
      GOTO 8
C
C ZERR
C
 104  IF(NK.NE.14)GOTO 107
      IF(FF(1).LT.0.01)GOTO 87
      NJ=26
      K=7
 105  IF(NA.GT.K)GOTO 75
      IF(MQ.NE.1)GOTO 88
      NA=MAX0(NA,1)
        DO 106 I=1,NA
        A(NJ)=FF(I)
        NJ=NJ+1
 106    CONTINUE
      GOTO 8
C
C LATT
C
 107  IF(NK.NE.15)GOTO 108
      IF(ABS(A(1)).LT.1.E-8)GOTO 79
      IF(FF(1).LT.0.)A(23)=1.
      IF(LL.NE.1)GOTO 77
      LL=INT(0.5+ABS(FF(1)))
      IF(LL.EQ.0)GOTO 87
      IF(LL.GT.7)GOTO 87
      GOTO 8
C
C SFAC - set up lattice transformations
C
 108  IF(NK.NE.17)GOTO 134
      IF(ABS(A(1)).LT.1.E-8)GOTO 79
      IF(LL.GT.160)GOTO 124
      IF(A(26).LT.0.1)CALL SXER('ZERR MISSING')
      N=3*LL+20
      L=INT(4.1-2.*A(23))
        DO 109 I=24,32
        SI(I)=.5
 109    CONTINUE
      IF(N.LT.32)GOTO 111
      IF(N.GT.32)GOTO 113
        DO 110 I=24,32,4
        SI(I)=0.
 110    CONTINUE
 111  IF(N.NE.29)GOTO 114
        DO 112 I=24,29
        SI(I)=.6666667
 112    CONTINUE
      SI(25)=.3333333
      SI(26)=.3333333
      SI(27)=.3333333
      GOTO 114
 113  SI(LL+19)=0.
      N=24
 114  LL=LY+8
        DO 116 K=2,L,2
          DO 115 M=21,N,3
          LL=LL+4
          A(LL)=3.-REAL(K)
          A(LL+1)=SI(M)+99.5
          A(LL+2)=SI(M+1)+99.5
          A(LL+3)=SI(M+2)+99.5
 115      CONTINUE
 116    CONTINUE
      LB=LL-12
C
C Check LATT/SYMM
C
      M=LY+12
      N=LL+2
        DO 118 K=201,LY,12
        CALL SXCC
        IF(ABS(ABS(A(K)*(A(K+4)*A(K+8)-A(K+5)*A(K+7))+A(K+1)*
     +  (A(K+5)*A(K+6)-A(K+3)*A(K+8))+A(K+2)*(A(K+3)*A(K+7)-
     +  A(K+4)*A(K+6)))-1.).GT.0.01)GOTO 81
          DO 117 L=M,LL,4
          N=N+3
          A(N)=AMOD(A(L)*(.143*A(K)+.277*A(K+1)+
     +    .811*A(K+2)+A(K+9))+A(L+1)+.5,1.)
          A(N+1)=AMOD(A(L)*(.143*A(K+3)+.277*A(K+4)+
     +    .811*A(K+5)+A(K+10))+A(L+2)+.5,1.)
          A(N+2)=AMOD(A(L)*(.143*A(K+6)+.277*A(K+7)+
     +    .811*A(K+8)+A(K+11))+A(L+3)+.5,1.)
 117      CONTINUE
 118    CONTINUE
        DO 123 K=201,LY,12
          DO 122 L=M,LL,4
          CALL SXCC
          I=LL+2
 119      I=I+3
          IF(I.GT.N)GOTO 122
          X=AMOD(A(L)*(A(I)*A(K)+A(I+1)*A(K+1)+
     +    A(I+2)*A(K+2)+A(K+9))+A(L+1)+.5,1.)
          Y=AMOD(A(L)*(A(I)*A(K+3)+A(I+1)*A(K+4)+
     +    A(I+2)*A(K+5)+A(K+10))+A(L+2)+.5,1.)
          Z=AMOD(A(L)*(A(I)*A(K+6)+A(I+1)*A(K+7)+
     +    A(I+2)*A(K+8)+A(K+11))+A(L+3)+.5,1.)
          NB=0
          NJ=LL+2
 120      NJ=NJ+3
          IF(NJ.GT.N)GOTO 121
          IF(ABS(X-A(NJ))+ABS(Y-A(NJ+1))+ABS(Z-A(NJ+2)).LT.0.001)
     +    NB=NB+1
          GOTO 120
 121      IF(NB.EQ.1)GOTO 119
          GOTO 82
 122      CONTINUE
 123    CONTINUE
C
C SFAC
C
 124  IF(NA.GT.0)GOTO 130
      K=0
 125  K=K+2
      IF(K.GT.MQ)GOTO 8
      CALL SXUS(FC(K),KT)
      T=0.
        DO 126 M=1,94
        IF(KA(M).EQ.KT(1:2))GOTO 128
 126    CONTINUE
      IF(KT(1:2).NE.'D ')GOTO 127
      M=1
      T=1.006
      GOTO 128
 127  CALL SXER('UNKNOWN ELEMENT')
 128  LB=LB+16
      M=20*M-19
      I=M+9
      IF(A(1).LT.1.)I=I+5
      IF(A(1).LT.0.6)I=I+3
      IF(M.EQ.1)KH=LB
      A(LB)=EF(I)
      A(LB+1)=EF(I+1)
      A(LB+2)=EF(M+12)
      L=LB+3
        DO 129 N=M,M+7
        A(L)=EF(N)
        L=L+1
 129    CONTINUE
      A(L)=EF(M+8)+EF(I)
      A(LB+12)=EF(M+13)+T
      CALL SXPS(A(LB+13),KT)
      A(LB+14)=EF(I+2)
      A(LB+15)=AINT(.5+EF(M)+EF(M+2)+EF(M+4)+EF(M+6)+EF(M+8))
      GOTO 125
 130  IF(MQ.LT.2)CALL SXER('NO ELEMENT NAME FOR SFAC')
      LB=LB+16
      IF(NA.EQ.14)GOTO 132
      IF(NA.NE.5)GOTO 75
        DO 131 I=LB,LB+10
        A(I)=0.
 131    CONTINUE
      A(LB+11)=FF(1)
 132  A(LB+1)=FF(NA-3)
      A(LB+2)=FF(NA-1)
      A(LB+14)=FF(NA-2)
      A(LB+15)=0.
      IF(FF(NA).LT.0.0001)GOTO 87
      A(LB+12)=-FF(NA)
      CALL SXUS(FC(2),KT)
      CALL SXPS(A(LB+13),KT)
      IF(KT.EQ.'H   ')KH=LB
      IF(NA.NE.14)GOTO 8
      L=LB+3
        DO 133 M=1,8
        A(L)=FF(M)
        L=L+1
 133    CONTINUE
      A(L)=FF(9)+FF(10)
      A(LB)=FF(10)
      A(LB+15)=FF(1)+FF(3)+FF(5)+FF(7)+FF(9)
      GOTO 8
C
C DISP
C
 134  IF(NK.NE.39)GOTO 139
      IF(NA.GT.3)GOTO 75
      IF(NA.EQ.0)GOTO 75
      IF(LX.NE.0)GOTO 135
      IF(LB.GT.LL)GOTO 136
 135  CALL SXER('DISP MUST COME BETWEEN SFAC AND UNIT')
 136  IF(MQ.LT.3)CALL SXER('DISP REQUIRES ATOM TYPES')
      CALL SXUS(FC(1),KT)
      IF(KT.NE.'0   ')GOTO 91
        DO 138 I=2,MQ,2
        CALL SXUS(FC(I+1),KT)
        IF(KT.NE.'    ')GOTO 91
        CALL SXUS(FC(I),KT)
        KS=KT(1:4)
        IF(KT(1:1).EQ.IH(50))KS=KT(2:4)//IH(20)
          DO 137 K=LL+4,LB,16
          CALL SXUS(A(K+13),KT)
          IF(KT.NE.KS)GOTO 137
          A(K+11)=A(K+11)-A(K)+FF(1)
          A(K)=FF(1)
          IF(NA.GT.1)A(K+1)=FF(2)
          IF(NA.GT.2)A(K+14)=FF(3)
          GOTO 138
 137      CONTINUE
        CALL SXER('UNKNOWN ELEMENT '//KS//' FOR DISP')
 138    CONTINUE
      GOTO 8
C
C UNIT
C
 139  IF(NK.NE.18)GOTO 141
      MZ=(LB+16-LL)/16
      IF(MZ.EQ.0)CALL SXER('SFAC MISSING')
      IF(NA.NE.MZ)GOTO 75
      IF(LX.NE.0)GOTO 77
      LX=LB-16
      A(24)=.25*REAL(LL-LY-8)
      IF(ABS(A(51)).GT.2.5)WRITE(LI,4)
      M=LL-12
        DO 140 I=1,NA
        M=M+16
        CALL SXUS(A(M+13),KS)
        IF(ABS(A(51)).GT.2.5)WRITE(LI,5)KS,(A(K),K=M+3,M+10),
     +  A(M+11)-A(M),A(M),A(M+1),A(M+14),A(M+12),A(M+2)
        A(21)=A(21)+FF(I)*ABS(A(M+12))
        A(M+12)=0.
        A(22)=A(22)+FF(I)*A(M+15)
        A(25)=A(25)+FF(I)*A(M+14)
        A(M+14)=FF(I)
        A(M+15)=0.
 140    CONTINUE
      A(45)=A(21)*1.66054/A(20)
      A(25)=.1*A(25)/A(20)
      IF(ABS(A(51)).GT.0.5)WRITE(LI,3)A(20),A(22),A(25),A(21),A(45)
      GOTO 8
C
C Atoms in FRAG ... FEND section
C
 141  IF(LX.EQ.0)CALL SXER('UNIT MISSING')
      IF(NK.GT.1)GOTO 183
      IF(JB.EQ.0)GOTO 142
      JA=JA+3
      B(JA-3)=FF(2)*A(76)+FF(3)*A(77)+FF(4)*A(78)
      B(JA-2)=FF(3)*A(79)+FF(4)*A(80)
      B(JA-1)=FF(4)*A(81)
      B(JA)=0.
      B(JB)=640000.1+REAL(JA-JB)
      GOTO 8
C
C Atoms
C
 142  IF(LR.NE.LK)GOTO 95
      IF(FF(1).LT.0.9999)GOTO 83
      IF(AMOD(FF(1)+.0001,1.).GT.0.0002)GOTO 83
      K=INT(ABS(FF(1))+0.01)*16+LL-12
      IF(K.GT.LB)GOTO 83
      IF(NA.LT.4)GOTO 83
      IF(NA.LT.7)GOTO 143
      IF(NA.EQ.11)GOTO 143
      IF(NA.GT.7)GOTO 83
      FF(NA)=0.
      NA=6
 143  IF(LT.NE.0)GOTO 90
      LX=LX+32
      CALL SXPS(A(LX),KS)
      CALL SXUS(A(44),KT)
      CALL SXPS(A(LX+1),KT)
      CALL SXUS(A(43),KT)
      CALL SXPS(A(LX+2),KT)
      A(LX+27)=A(125)
      A(LX+29)=1.000001*A(42)
      A(LX+30)=0.
      A(LX+31)=.01*A(40)+.001
      A(LX+3)=REAL(K)+.1
      IF(NA.EQ.11)A(LX+3)=-A(LX+3)
      A(LX+4)=0.
      A(LX+5)=A(126)+AMIN1(.99,.01*A(K+2))
      A(LX+6)=A(121)
      A(LX+28)=REAL(KG)+.1
      IF(KG.EQ.1)A(122)=AMOD(A(122),10.)
      IF(KG.GT.0)KG=KG-1
      L=LX+7
      IF(ABS(A(60))+ABS(A(61))+ABS(A(62))+ABS(A(63)-1.).LT.0.0001)
     +GOTO 145
        DO 144 I=2,4
        IF(ABS(FF(I)).GT.15.)GOTO 86
        X=AMOD(FF(I)+5.,10.)-5.
        FF(I)=FF(I)+A(I+58)+X*(A(63)-1.)
 144    CONTINUE
 145  IF(NA.GT.5)GOTO 147
      FF(6)=DT
      IF(NA.GT.4)GOTO 146
      FF(5)=11.
 146  NA=6
 147  IF(A(123).LT.99998.)FF(5)=A(123)
      IF(NA.GT.6)GOTO 148
      IF(A(124).LT.99998.)FF(6)=A(124)
 148  IF(A(130).LT.8.E9)FF(5)=A(130)
        DO 149 I=2,11
        A(L)=FF(I)
        A(L+10)=0.
        L=L+1
 149    CONTINUE
      IF(JC.EQ.0)GOTO 150
      A(LX+17)=B(JC)
      A(LX+18)=B(JC+1)
      A(LX+19)=B(JC+2)
      JC=JC+3
      IF(JC.GE.JD)JC=0
      IF(JC.EQ.0)A(122)=AMOD(A(122),10.)
 150  A(121)=A(122)
C
C Compare stored ANIS, CONN, OMIT and HFIX instructions
C
      CALL SXUS(A(43),KY)
      CALL SXUS(A(44),KZ)
      MX=LX
      JZ=1
      JE=0
      IF(NA.EQ.11)GOTO 151
      IF(IA.EQ.0)GOTO 151
      IF(K.EQ.KH)GOTO 151
      IA=IA-1
      A(LX+6)=-ABS(A(LX+6))
 151  JZ=JZ+JE
      IF(JZ.GT.JQ)GOTO 8
      NK=INT(B(JZ)/64000.)
      JE=INT(AMOD(B(JZ),64000.))
      IF(NK.EQ.0)GOTO 8
      IF(NK.LT.62)GOTO 151
      IF(NK.GT.65)GOTO 151
      J=JZ+1
      IF(NK.EQ.63)J=JZ+3
      IF(NK.EQ.64)J=JZ+4
      CALL SXUS(B(J),KL)
 152  J=J+2
      IF(J.GE.JZ+JE)GOTO 151
C
C Interpret _code
C
      CALL SXUS(B(J-1),KT)
      IF(KT(1:1).EQ.IH(24))GOTO 153
      IF(KT(1:1).NE.IH(50))GOTO 156
      CALL SXUS(A(K+13),KU)
      IF(KU(1:3).NE.KT(2:4))GOTO 152
      GOTO 157
 153  IF(K.EQ.KH)GOTO 152
      CALL SXUS(B(J-3),KV)
      CALL SXUS(B(J-2),KX)
      IF(KX.EQ.KC(1))KX=KL
      J=J+2
      IF(J.GE.JZ+JE)GOTO 151
      CALL SXUS(B(J-1),KT)
      CALL SXUS(B(J),KU)
      IF(KU.EQ.KC(1))KU=KL
      L=MX
 154  L=L-32
      IF(L.LT.LB+16)GOTO 152
      CALL SXUS(A(L),KW)
      IF(KW.NE.KT)GOTO 155
      CALL SXUS(A(L+1),KQ)
      IF(KQ.EQ.KU)GOTO 152
      CALL SXUS(A(L+2),KQ)
      IF(KQ.EQ.KU)GOTO 152
 155  IF(KW.NE.KV)GOTO 154
      CALL SXUS(A(L+1),KW)
      IF(KW.EQ.KX)GOTO 158
      CALL SXUS(A(L+2),KW)
      IF(KW.NE.KX)GOTO 154
      GOTO 158
 156  IF(KT.NE.KS)GOTO 152
 157  CALL SXUS(B(J),KW)
      IF(KW.EQ.KC(1))KW=KL
      IF(KW(1:1).EQ.IH(21))GOTO 158
      IF(KW.EQ.KZ)GOTO 158
      IF(KW.NE.KY)GOTO 152
C
C Apply ANIS, OMIT, CONN and HFIX
C
 158  IF(NK.GT.62)GOTO 159
      A(MX+6)=-ABS(A(MX+6))
      GOTO 152
 159  IF(NK.NE.65)GOTO 160
      A(MX+31)=-ABS(A(MX+31))
      GOTO 152
 160  IF(NK.EQ.64)GOTO 161
      A(LX+5)=B(JZ+1)+AMOD(A(LX+5),1.)
      IF(B(JZ+2).GE.-8.E9)A(LX+5)=B(JZ+1)+
     +AMIN1(.99,AMAX1(-.99,.01*B(JZ+2)))
      GOTO 152
 161  IF(A(MX+30).GT.0.5)GOTO 152
      A(MX+30)=1.
      N=INT(.1*ABS(B(JZ+1)))
      IF(N.EQ.0)GOTO 152
      V=ABS(B(JZ+1))+.1*B(JZ+3)
      Z=SIGN(5.,A(MX+10))
      R=A(MX+10)
      IF(N.NE.12)GOTO 162
      R=R-0.5*(AMOD(R+Z,10.)-Z)
      N=6
      GOTO 163
 162  IF(N.EQ.13)N=3
      IF(N.EQ.9)N=2
      IF(N.GT.3)N=1
 163  N=N*32+MX
C
C Create dummy AFIX
C
      IR=KC(23)
      Z=B(JZ+1)
      NI=INT(Z)
      M=8
 164  I=MOD(IABS(NI),10)
      IR(M:M)=IH(I+1)
      M=M-1
      NI=NI/10
      IF(NI.GT.0)GOTO 164
      Y=B(JZ+3)
      IF(ABS(Y).LT.1.E-4)GOTO 167
      IR(12:12)=IH(11)
      X=AMOD(ABS(Y),1.)
        DO 165 NI=13,16
        X=10.*AMOD(X,1.)
        L=INT(X)
        IR(NI:NI)=IH(L+1)
 165    CONTINUE
      L=11
      NI=INT(ABS(Y))
 166  I=MOD(NI,10)
      IR(L:L)=IH(I+1)
      L=L-1
      NI=NI/10
      IF(NI.GT.0)GOTO 166
      IF(Y.LT.0.)IR(L:L)=IH(12)
 167  KR=16
      NI=23
      WRITE(LC)NI,KR,KC(23),IR
C
C Insert extra hydrogens for HFIX
C
      KR=1
        DO 168 I=1,76
        IR(I:I)=IH(20)
 168    CONTINUE
      CALL SXUS(A(LX),KT)
      KT(1:1)=IH(34)
        DO 169 NI=1,4
        IF(KT(NI:NI).EQ.IH(20))GOTO 170
 169    CONTINUE
      NI=4
 170  IF(NI.NE.2)GOTO 171
      KT(2:2)=IH(1)
      NI=3
 171  L=26
      KK=KT(NI-1:NI-1)
        DO 172 I=1,10
        IF(KK.EQ.IH(I))GOTO 173
 172    CONTINUE
      L=1
 173  IF(N.EQ.MX+32)GOTO 175
 174  L=L+1
      IF(L.EQ.11)L=14
      IF(L.EQ.17)L=27
      KT(NI:NI)=IH(L)
 175  M=LB-16
 176  M=M+32
      IF(M.GE.LX)GOTO 177
      CALL SXUS(A(M),KX)
      IF(KX.NE.KT)GOTO 176
      CALL SXUS(A(M+1),KX)
      IF(KX.NE.KZ)GOTO 176
      IF(L.LT.50)GOTO 174
 177  LX=LX+32
      CALL SXPS(A(LX),KT)
      M=1
      WRITE(LC)M,KR,KT,IR
      CALL SXPS(A(LX+1),KZ)
      CALL SXPS(A(LX+2),KY)
      A(LX+3)=REAL(KH)+.1
        DO 178 I=LX+4,LX+30
        A(I)=0.
 178    CONTINUE
      A(LX+6)=V
      A(LX+10)=R
      A(LX+11)=B(JZ+2)
      A(LX+27)=A(125)
      A(LX+28)=REAL((N+32-LX)/32)+.1
      A(LX+29)=1.000001*A(42)
      A(LX+31)=A(LX-1)
C
C Check if OMIT $H for HFIX hydrogens
C
      JT=1
      JO=0
 179  JT=JT+JO
      IF(JT.GT.JQ)GOTO 182
      JP=INT(B(JT)/64000.)
      JO=INT(AMOD(B(JT),64000.))
      IF(JP.NE.65)GOTO 179
      JP=JT+1
      CALL SXUS(B(JP),KL)
 180  JP=JP+2
      IF(JP.GE.JT+JO)GOTO 179
      CALL SXUS(B(JP-1),KW)
      IF(KW.NE.'$H  ')GOTO 180
      CALL SXUS(B(JP),KW)
      IF(KW.EQ.KC(1))KW=KL
      IF(KW(1:1).EQ.'*')GOTO 181
      IF(KW.EQ.KY)GOTO 181
      IF(KW.NE.KZ)GOTO 180
 181  A(LX+31)=-ABS(A(LX+31))
 182  IF(LX.LT.N)GOTO 174
      IR=KC(23)
      IR(7:7)=IH(1)
      N=23
      KR=7
      WRITE(LC)N,KR,KC(23),IR
      GOTO 152
C
C Other instructions - ACTA
C
 183  IF(NK.NE.35)GOTO 184
      A(74)=180.
      IF(NA.EQ.1)A(74)=FF(1)
      IF(A(74).LT.1.)GOTO 87
      IF(NA.GT.1)GOTO 75
      GOTO 8
C
C AFIX
C
 184  IF(NK.NE.23)GOTO 189
      IF(LR.NE.LK)GOTO 95
      IF(NA.GT.4)GOTO 75
      A(123)=99999.
      IF(NA.GE.3)A(123)=FF(3)
      A(124)=99999.
      IF(NA.EQ.4)A(124)=FF(4)
      FF(1)=ABS(FF(1))
      K=INT(.1*FF(1))
      IF(KG.LE.0)GOTO 185
      IF(KI.NE.0)GOTO 84
      IF(IABS(K-6).LT.2)GOTO 84
      IF(K.EQ.10)GOTO 84
      IF(K.EQ.11)GOTO 84
      IF(K.GT.16)GOTO 84
      KI=KG
 185  KG=K
      IF(K.EQ.4)KG=1
      IF(K.EQ.7)KG=6
      IF(K.EQ.8)KG=1
      IF(K.EQ.9)KG=2
      IF(K.EQ.11)KG=10
      IF(K.EQ.12)KG=6
      IF(K.GT.12)KG=3-2*(K/14)
      IF(KI.EQ.0)GOTO 187
      IF(IABS(K-6).LT.2)GOTO 186
      IF(K.GT.16)GOTO 186
      IF(K.EQ.10)GOTO 186
      IF(K.NE.11)GOTO 187
 186  KG=KI
      KI=0
 187  JC=0
      IF(FF(2).LT.0.)GOTO 87
      IF(FF(2).GT.9.)GOTO 87
      IF(NA.LT.2)FF(2)=.01
      A(121)=AINT(FF(1)+.1)+.1*FF(2)
      A(122)=A(121)
      I=INT(AMOD(FF(1)+.1,10.))
      IF(I.EQ.9)A(122)=A(122)-4.
      IF(I.EQ.6)A(122)=A(122)-1.
      NA=4
C
C FRAG/AFIX fit coordinates
C
      IF(K.LT.17)GOTO 8
      JD=1
 188  JC=JD
      JD=INT(AMOD(B(JC),64000.))+JC
      IF(JD.EQ.JC)GOTO 85
      IF(INT(B(JC)/64000.).NE.10)GOTO 188
      IF(K.NE.INT(B(JC+1)))GOTO 188
      JC=JC+3
      KG=(JD-JC)/3
      GOTO 8
C
C ANIS
C
 189  IF(NK.NE.62)GOTO 195
      IF(LR.NE.LK)GOTO 95
      IF(NA.GT.1)GOTO 75
      IF(NA.GT.0)GOTO 190
      IF(MQ.LT.2)FF(1)=64000.
 190  IA=INT(ABS(FF(1))+.1)
      IF(MQ.LT.2)GOTO 8
      NA=0
 191  JQ=JA
C
C Buffer instructions in B
C
 192  I=NK
      IF(NK.EQ.69)I=53
      B(JA)=64000.*REAL(I)+REAL(MQ+NA)+1.1
      IF(MQ+NA.GT.63998)GOTO 96
      JA=JA+1
        DO 193 I=1,NA
        B(JA)=FF(I)
        JA=JA+1
 193    CONTINUE
        DO 194 I=1,MQ
        CALL SXUS(FC(I),KT)
        CALL SXPS(B(JA),KT)
        JA=JA+1
 194    CONTINUE
      B(JA)=0.
      IF(NK.EQ.69)GOTO 235
      GOTO 8
C
C BASF
C
 195  IF(NK.NE.6)GOTO 197
      IF(NA.EQ.0)GOTO 75
      IF(LR.NE.LK)GOTO 95
 196  MQ=0
      GOTO 192
C
C BIND and FREE
C
 197  IF(NK.EQ.48)GOTO 198
      IF(NK.NE.49)GOTO 200
 198  IF(MOD(MQ,4).NE.1)GOTO 76
      IF(MQ.EQ.1)GOTO 76
 199  IF(NA.GT.0)GOTO 75
      GOTO 192
C
C BLOC
C
 200  IF(NK.NE.57)GOTO 201
      IF(NA.GT.2)GOTO 75
      A(103)=AMAX1(A(103),ABS(FF(1)),ABS(FF(2)))
      NA=2
      GOTO 192
C
C BOND
C
 201  IF(NK.NE.47)GOTO 203
      NA=0
      IF(MQ.GT.1)GOTO 202
      IF(ABS(A(158)).LT.0.1)A(158)=1.1
      GOTO 8
 202  CALL SXUS(FC(2),KT)
      IF(KT.NE.'$H  ')GOTO 192
      A(158)=-1.1
      GOTO 8
C
C BUMP
C
 203  IF(NK.NE.66)GOTO 204
      IF(NA.GT.1)GOTO 75
      A(180)=A(132)
      IF(NA.GT.0)A(180)=FF(1)
      GOTO 8
C
C CHIV
C
 204  IF(NK.NE.56)GOTO 206
      IF(NA.GT.2)GOTO 75
      IF(NA.LT.2)FF(2)=A(133)
      IF(NA.LT.1)FF(1)=0.
      CALL SXUS(FC(1),KS)
        DO 205 I=3,MQ
        B(JA)=3584006.1
        B(JA+1)=FF(1)
        B(JA+2)=FF(2)
        CALL SXUS(FC(I),KT)
        IF(KT.EQ.KC(1))KT=KS
        CALL SXPS(B(JA+3),KT)
        CALL SXUS(FC(I-1),KT)
        CALL SXPS(B(JA+4),KT)
        CALL SXPS(B(JA+5),KC(1))
        JA=JA+6
 205    CONTINUE
      B(JA)=0.
      GOTO 8
C
C CONF
C
 206  IF(NK.NE.52)GOTO 208
      IF(MQ.GT.1)GOTO 207
      A(128)=2.
      GOTO 8
 207  IF(MQ.LT.9)GOTO 76
      GOTO 199
C
C CONN
C
 208  IF(NK.NE.63)GOTO 209
      IF(NA.LT.1)GOTO 75
      IF(NA.GT.2)GOTO 75
      FF(1)=AINT(ABS(FF(1)))
      IF(NA.LT.2)FF(2)=-9.E9
      NA=2
      IF(MQ.GT.1)GOTO 191
      IF(FF(2).GT.-8.E9)GOTO 75
      A(126)=FF(1)
      GOTO 8
C
C DAMP
C
 209  IF(NK.NE.36)GOTO 210
      IF(NA.GT.0)A(72)=FF(1)
      IF(NA.GT.1)A(170)=FF(2)
      IF(NA.GT.2)GOTO 75
      IF(A(72).LT.0.)GOTO 87
      IF(A(170).LT.0.)GOTO 87
      GOTO 8
C
C DEFS
C
 210  IF(NK.NE.68)GOTO 212
      IF(NA.GT.5)GOTO 75
      IF(NA.GT.4)A(196)=FF(5)
      IF(NA.GT.4)NA=4
        DO 211 I=1,NA
        IF(FF(I).LE.0.)GOTO 87
        A(I+131)=FF(I)
 211    CONTINUE
      GOTO 8
C
C DELU
C
 212  IF(NK.NE.58)GOTO 213
      IF(NA.GT.2)GOTO 75
      IF(NA.LT.1)FF(1)=A(134)
      IF(NA.LT.2)FF(2)=FF(1)
      NA=2
      GOTO 192
C
C DFIX and DANG
C
 213  IF(NK.NE.50)GOTO 214
      IF(NA.LT.1)GOTO 75
      IF(NA.GT.2)GOTO 75
      IF(NA.LT.2)FF(2)=A(132)*(1.5-0.5*DF)
      FF(2)=DF*FF(2)
      IF(MOD(MQ,4).NE.1)GOTO 76
      IF(MQ.EQ.1)GOTO 76
      IF(ABS(FF(1)).LT.0.0001)GOTO 87
      NA=2
      GOTO 192
C
C EADP
C
 214  IF(NK.NE.46)GOTO 217
      GOTO 199
C
C EQIV
C
 215    DO 216 I=1,12
        FF(I)=A(I+81)
 216    CONTINUE
      IF(ABS(1.-ABS(FF(1)*(FF(5)*FF(9)-FF(6)*FF(8))+FF(2)*(FF(4)*FF(9)
     +-FF(6)*FF(7))-FF(3)*(FF(4)*FF(8)-FF(5)*FF(7)))).GT.0.1)GOTO 81
      NA=12
      IF(MQ.NE.3)GOTO 93
      CALL SXUS(FC(2),KZ)
      IF(KZ(1:1).NE.IH(50))GOTO 93
      GOTO 192
C
C EXTI and SWAT
C
 217  IF(NK.NE.4)GOTO 219
      IF(A(200).GT.-998.)A(39)=-9.E9
      IF(NA.LT.1)FF(1)=0.8
      IF(NA.LT.2)FF(2)=5.0
      NA=2
      A(200)=FF(2)
      IF(A(39).LT.-8.E9)GOTO 220
 218  CALL SXER('EXTI and SWAT may not be used together')
 219  IF(NK.NE.7)GOTO 221
      IF(A(200).GT.-998.)GOTO 218
 220  IF(LR.NE.LK)GOTO 95
      IF(FF(1).LT.0.)FF(1)=0.
      A(39)=FF(1)
      GOTO 8
C
C EXYZ
C
 221  IF(NK.EQ.45)GOTO 199
C
C FEND
C
      IF(NK.NE.11)GOTO 222
      JB=0
      GOTO 8
C
C FLAT
C
 222  IF(NK.NE.55)GOTO 223
      IF(MQ.LT.7)GOTO 76
      IF(NA.EQ.0)FF(1)=A(133)
      IF(NA.GT.1)GOTO 75
      NA=1
      GOTO 192
C
C FMAP
C
 223  IF(NK.NE.21)GOTO 224
      IF(NA.EQ.0)FF(1)=2.
      IF(ABS(FF(1)).LT.1.9)GOTO 87
      IF(ABS(FF(1)).GT.6.1)GOTO 87
      NJ=54
      K=3
      GOTO 105
C
C FRAG
C
 224  IF(NK.NE.10)GOTO 227
      JB=JA
      IF(NA.EQ.7)GOTO 225
      FF(5)=90.
      FF(6)=90.
      FF(7)=90.
      IF(NA.EQ.4)GOTO 225
      FF(2)=1.
      FF(3)=1.
      FF(4)=1.
      IF(NA.EQ.1)GOTO 225
      IF(NA.NE.0)GOTO 75
      FF(1)=17.
 225    DO 226 I=2,4
        IF(FF(I).LT.0.1)GOTO 87
        X=1.74533E-2*FF(I+3)
        FC(I)=COS(X)
        FC(I+3)=SIN(X)
 226    CONTINUE
      X=(FC(2)-FC(3)*FC(4))/(FC(6)*FC(7))
      A(76)=FF(2)
      A(77)=FF(3)*FC(4)
      A(78)=FF(4)*FC(3)
      A(79)=FF(3)*FC(7)
      A(80)=FF(4)*FC(6)*X
      A(81)=FF(4)*FC(6)*SQRT(ABS(1.-X**2))
      CALL SXZA(FF(2),6)
      NA=1
      GOTO 192
C
C FVAR
C
 227  IF(NK.NE.8)GOTO 228
      IF(LR.NE.LK)GOTO 95
      GOTO 196
C
C GRID
C
 228  IF(NK.NE.19)GOTO 229
      NJ=33
      K=6
      GOTO 105
C
C HFIX
C
 229  IF(NK.NE.64)GOTO 232
      IF(KH.EQ.0)CALL SXER('H SFAC REQUIRED FOR HFIX')
      IF(LR.NE.LK)GOTO 95
      IF(NA.LT.1)GOTO 75
      IF(NA.GT.3)GOTO 75
      FF(1)=ABS(FF(1))
      K=MOD(INT(FF(1)+.1),10)
      IF(K.EQ.6)GOTO 87
      IF(K.EQ.9)GOTO 87
      K=INT(.1*FF(1)+.1)
      IF(K.GT.16)GOTO 87
      IF(K.GT.11)GOTO 230
      IF(K.GT.9)GOTO 87
      IF(IABS(K-6).LT.2)GOTO 87
 230  IF(NA.GT.1)GOTO 231
      FF(2)=-1.2
      IF(K.EQ.3)FF(2)=-1.5
      IF(K.EQ.8)FF(2)=-1.5
      IF(K.GT.11)FF(2)=-1.5
      IF(K.GT.14)FF(2)=-1.2
 231  NA=3
      IF(MQ.LT.3)GOTO 76
      GOTO 191
C
C HOPE
C
 232  IF(NK.NE.41)GOTO 233
      IF(NA.GT.1)GOTO 75
      IF(NA.LT.1)FF(1)=1.
      A(181)=FF(1)
      GOTO 8
C
C HTAB
C
 233  IF(NK.NE.69)GOTO 238
      IF(MQ.GT.1)GOTO 234
      IF(NA.EQ.0)FF(1)=2.
      A(194)=FF(1)
      IF(NA.GT.1)GOTO 75
      GOTO 8
 234  IF(NA.NE.0)GOTO 75
      IF(MQ.NE.5)GOTO 76
      CALL SXUS(FC(3),KT)
      IF(KT(1:1).EQ.IH(50))CALL SXER('SYMMETRY TRANSFORMATION NOT '//
     +'PERMITTED FOR FIRST HTAB ATOM')
      CALL SXUS(FC(5),KT)
      CALL SXPS(FC(7),KT)
      CALL SXPS(FC(9),KT)
      CALL SXUS(FC(4),KT)
      CALL SXPS(FC(6),KT)
      CALL SXPS(FC(8),KT)
      CALL SXUS(FC(3),KT)
      CALL SXPS(FC(5),KT)
      CALL SXUS(FC(2),KT)
      CALL SXPS(FC(4),KT)
      CALL SXPS(FC(3),KC(1))
      MQ=9
      KW='4DHA'
      CALL SXPS(FC(2),KW)
      GOTO 192
 235  IF(KW.NE.'4DHA')GOTO 236
      KW='1DHA'
      CALL SXPS(FC(2),KW)
      MQ=7
      GOTO 192
 236  IF(KW.NE.'1DHA')GOTO 237
      KW='2DHA'
      CALL SXPS(FC(2),KW)
      GOTO 192
 237  IF(KW.NE.'2DHA')GOTO 8
      KW='3DHA'
      CALL SXPS(FC(2),KW)
      GOTO 192
C
C ISOR
C
 238  IF(NK.NE.60)GOTO 239
      IF(NA.EQ.0)FF(1)=0.1
      IF(NA.LT.2)FF(2)=FF(1)
      IF(NA.GT.2)GOTO 75
      NA=2
      GOTO 192
C
C L.S. and CGLS
C
 239  IF(NK.EQ.33)GOTO 240
      IF(NK.NE.34)GOTO 241
 240  NJ=177
      K=3
      FF(1)=ABS(FF(1))+0.1
      IF(NK.EQ.34)FF(1)=-FF(1)
      IF(NA.GT.4)GOTO 75
      IF(NA.EQ.4)IV=MAX0(INT(FF(4)),8)
      FF(4)=0.
      NA=3
      GOTO 105
C
C LAUE
C
 241  IF(NK.NE.65)GOTO 247
      IF(LX.LT.LB)GOTO 90
      A(46)=1.1
      IF(MQ.LT.3)GOTO 89
      CALL SXUS(FC(2),KS)
      KT=KS
      IF(KS(1:1).EQ.IH(50))KT=KS(2:4)//IH(20)
      READ(LR,1,END=245)IR
      I=LL-12
 242  I=I+16
      IF(I.GT.LB)CALL SXER('NO SFAC FOR LAUE ELEMENT')
      CALL SXUS(A(I+13),KS)
      IF(KS.NE.KT)GOTO 242
      IF(A(I+12).GT.0.5)CALL SXER('TWO LAUE INSTRUCTIONS FOR '//KS)
      IF(LT.EQ.0)LT=LX+31
      LT=LT+1
      M=LT
      A(I+12)=REAL(LT)
 243  IF(LT+5.GT.LM)GOTO 74
      IR=' '
      READ(LR,1,END=245)IR
        DO 244 I=1,23
        IF(IR(I:I).LT.IH(20))IR(I:I)=IH(20)
 244    CONTINUE
      READ(IR,6,ERR=245,END=245)A(LT+1),A(LT+2),A(LT+3)
      IF(A(LT+1).LT.1.E-6)GOTO 246
      LT=LT+3
      IF(LT.LT.M+4)GOTO 243
      IF(A(LT-2).LT.A(LT-5)+1.E-6)CALL SXER('WAVELENGTHS NOT IN '//
     +'ASCENDING ORDER FOR LAUE '//KS)
      GOTO 243
 245  CALL SXER('ERROR OR END OF FILE READING DISPERSION FACTORS'//
     +' (LAUE)')
 246  IF(LT.EQ.M)GOTO 75
      A(M)=REAL(LT-2)
      GOTO 8
C
C LIST
C
 247  IF(NK.NE.37)GOTO 248
      IF(NA.GT.2)GOTO 75
      IF(NA.EQ.0)FF(1)=4.
      A(73)=ABS(FF(1))
      IF(A(73).GT.7.5)GOTO 87
      IF(NA.EQ.2)A(155)=ABS(FF(2))
      GOTO 8
C
C MERG
C
 248  IF(NK.NE.27)GOTO 251
      IF(ABS(FF(1)).GT.4.1)GOTO 87
      IF(NA.EQ.0)FF(1)=2.1
      IF(NA.GT.1)GOTO 75
      IF(ABS(FF(1)).LT.3.5)GOTO 250
        DO 249 I=LL+4,LB,16
        A(I+1)=0.
 249    CONTINUE
      FF(1)=SIGN(3.1,FF(1))
 250  A(46)=ABS(FF(1))
      IF(ABS(FF(1)).LT.1.1)GOTO 8
      IF(LT.NE.0)CALL SXER('MERG NOT COMPATIBLE WITH LAUE')
      GOTO 8
C
C MOLE
C
 251  IF(NK.NE.20)GOTO 252
      IF(LR.NE.LK)GOTO 95
      A(40)=AINT(ABS(FF(1)))
      IF(A(40).GT.99.1)GOTO 87
      GOTO 8
C
C MORE
C
 252  IF(NK.NE.31)GOTO 253
      A(51)=FF(1)
      GOTO 8
C
C MOVE
C
 253  IF(NK.NE.3)GOTO 254
      IF(LR.NE.LK)GOTO 95
      IF(NA.LT.4)FF(4)=1.
      IF(ABS(ABS(FF(4))-1.).GT.0.0001)GOTO 87
      NJ=60
      K=4
      NA=4
      GOTO 105
C
C MPLA
C
 254  IF(NK.NE.54)GOTO 255
      IF(NA.GT.1)GOTO 75
      IF(ABS(ABS(FF(1))-1.5).LT.1.4)GOTO 87
      IF(MQ/2.GT.(LU-1)/3)GOTO 76
      NA=1
      GOTO 192
C
C NCSY
C
 255  IF(NK.NE.43)GOTO 256
      IF(NA.GT.3)GOTO 75
      IF(INT(FF(1)).EQ.0)GOTO 87
      IF(NA.LT.2)FF(2)=5.*A(132)
      IF(NA.LT.3)FF(3)=A(135)
      IF(FF(2).LT.-0.0001)GOTO 87
      IF(FF(3).LT.-0.0001)GOTO 87
      NA=3
      GOTO 192
C
C OMIT
C
 256  IF(NK.NE.26)GOTO 258
      IF(NA.EQ.3)GOTO 196
      IF(NA.NE.0)GOTO 257
      NK=65
      IF(MQ.GT.1)GOTO 191
      GOTO 75
 257  IF(MQ.GT.1)GOTO 75
      A(52)=.5*FF(1)
      IF(NA.LT.2)GOTO 8
      IF(FF(2).LT.0.0001)GOTO 87
      IF(FF(2).GT.180.)GOTO 87
      A(53)=SIGN(SIN(8.726646E-3*FF(2))**2,FF(2))
      IF(NA.LT.3)GOTO 8
      GOTO 75
C
C PART
C
 258  IF(NK.NE.38)GOTO 259
      IF(LR.NE.LK)GOTO 95
      A(130)=9.E9
      IF(NA.EQ.2)A(130)=FF(2)
      A(42)=FF(1)
      IF(NA.LT.3)GOTO 8
      GOTO 75
C
C PLAN
C
 259  IF(NK.NE.22)GOTO 260
      NJ=57
      K=3
      I=NA
      NA=3
      IF(ABS(FF(1)).GT.999.5)GOTO 87
      IF(I.EQ.0)FF(1)=20.
      IF(I.LT.2)FF(2)=0.
      IF(I.LT.3)FF(3)=3.
      IF(FF(1).GT.-0.5)GOTO 105
      IF(I.LT.2)FF(2)=.5
      IF(FF(2).LT.0.)GOTO 87
      IF(I.LT.3)FF(3)=2.
      GOTO 105
C
C RESI
C
 260  IF(NK.NE.29)GOTO 263
      IF(LR.NE.LK)GOTO 95
      IF(MQ.GT.3)GOTO 76
      KT=KC(1)
      IF(MQ.EQ.3)CALL SXUS(FC(2),KT)
      CALL SXPS(A(43),KT)
      IF(NA.EQ.0)GOTO 75
      IF(NA.GT.2)GOTO 75
      IF(FF(1).GT.9999.1)GOTO 87
      IF(FF(1).LT.-0.1)GOTO 87
      IF(ABS(FF(2)).GT.9999.1)GOTO 87
      K=INT(FF(1)*1.00001)
      IF(K.LT.0)GOTO 261
      I=INT(FF(2)*1.00001)
      IF(I.LE.0)GOTO 261
      N=ML(1)+1
      IF(N.GT.LU)CALL SXER('TOO MANY RESIDUE ALIASES')
      ML(1)=N
      MK(N)=I
      ML(N)=K
 261  CALL SXPN(A(44),K)
      CALL SXUS(A(44),KZ)
      N=LX+32
 262  N=N-32
      IF(N.LT.LB)GOTO 8
      CALL SXUS(A(N+1),KS)
      IF(KS.NE.KZ)GOTO 262
      CALL SXUS(A(N+2),KS)
      IF(KS.EQ.KT)GOTO 8
      CALL SXER('RESIDUE '//KZ//' ALREADY DEFINED AS CLASS '//KS)
C
C RTAB
C
 263  IF(NK.NE.53)GOTO 264
      IF(MQ.LT.5)GOTO 76
      IF(MQ.GT.11)GOTO 76
      IF(NA.NE.0)GOTO 75
      GOTO 192
C
C SADI
C
 264  IF(NK.NE.61)GOTO 265
      IF(NA.EQ.0)FF(1)=A(132)
      IF(NA.GT.1)GOTO 75
      IF(MOD(MQ,2).NE.1)GOTO 76
      IF(MQ.EQ.1)GOTO 76
      NA=1
      GOTO 192
C
C SAME
C
 265  IF(NK.NE.51)GOTO 266
      IF(NA.GT.2)GOTO 75
      IF(NA.LT.1)FF(1)=A(132)
      IF(NA.LT.2)FF(2)=2.*FF(1)
      FF(3)=REAL(LX)+32.1
      NA=3
      IF(MQ.LT.5)GOTO 76
      GOTO 192
C
C SHEL and STIR
C
 266  IF(NK.NE.30)GOTO 269
      IF(KS.EQ.'SHEL')GOTO 267
      IF(NA.LT.1)GOTO 75
      A(197)=FF(1)
      IF(NA.LT.2)GOTO 8
      A(198)=FF(2)
      IF(NA.LT.3)GOTO 8
      GOTO 75
 267  IF(NA.NE.2)GOTO 75
        DO 268 I=1,NA
        A(I+48)=AMIN1(1.,(.5*A(1)/AMAX1(FF(I),0.0001))**2)
 268    CONTINUE
      GOTO 8
C
C SIMU
C
 269  IF(NK.NE.59)GOTO 270
      IF(NA.GT.3)GOTO 75
      IF(NA.LT.1)FF(1)=A(135)
      IF(NA.LT.2)FF(2)=2.*FF(1)
      IF(NA.LT.3)FF(3)=1.7
      NA=3
      GOTO 192
C
C SIZE
C
 270  IF(NK.NE.42)GOTO 271
      K=3
      NJ=100
      IF(NA.NE.3)GOTO 75
      GOTO 105
C
C SPEC
C
 271  IF(NK.NE.25)GOTO 272
      A(125)=FF(1)
      IF(NA.EQ.0)A(125)=.2
      GOTO 8
C
C SUMP
C
 272  IF(NK.NE.28)GOTO 273
      IF(NA.LT.3)GOTO 75
      IF(MOD(NA,2).NE.0)GOTO 75
      GOTO 196
C
C TEMP
C
 273  IF(NK.NE.67)GOTO 274
      IF(LX.GT.LB)CALL SXER('TEMP MUST PRECEDE ALL ATOMS')
      IF(FF(1).LT.-273.9)GOTO 87
      A(104)=FF(1)
      IF(FF(1).LT.-40.)DT=.04
      IF(FF(1).LT.-80.)DT=.03
      GOTO 8
C
C TIME
C
 274  IF(NK.NE.32)GOTO 275
      TL=FF(1)
      GOTO 8
C
C TWIN
C
 275  IF(NK.NE.24)GOTO 278
      IF(ABS(A(160)).GT.0.1)GOTO 77
      A(160)=2.01
      IF(NA.NE.10)GOTO 276
      IF(INT(ABS(FF(10))).LT.2)GOTO 87
      A(160)=FF(10)
      FF(10)=0.
      NA=9
 276  IF(NA.NE.9)GOTO 277
      IF(ABS(1.-ABS(FF(1)*(FF(5)*FF(9)-FF(6)*FF(8))+FF(2)*(FF(6)*FF(7)-
     +FF(4)*FF(9))+FF(3)*(FF(4)*FF(8)-FF(5)*FF(7)))).GT.0.01)GOTO 87
      IF(ABS(A(161)+1.)+ABS(A(162))+ABS(A(163))+ABS(A(164))+
     +ABS(A(165)+1.)+ABS(A(166))+ABS(A(167))+ABS(A(168))+
     +ABS(A(169)+1.).LT.0.01)A(160)=2.2
      NJ=161
      K=9
      GOTO 105
 277  IF(NA.NE.0)GOTO 75
      A(160)=2.2
      A(161)=-1.
      A(165)=-1.
      A(169)=-1.
      GOTO 8
C
C WGHT
C
 278  IF(NK.NE.9)GOTO 281
      IF(LR.NE.LK)GOTO 95
      IF(NA.GT.6)GOTO 75
      IF(FF(1).LT.0.)GOTO 279
      IF(FF(1).GT.0.011)GOTO 280
      IF(NA.LT.3)GOTO 280
      IF(NA.GT.4)GOTO 280
 279  WRITE(LI,7)
      WRITE(*,7)
      CALL SXFL
 280  IF(NA.LT.6)FF(6)=.333333
      IF(NA.LT.1)FF(1)=.1
      IF(FF(1).LT.0.)GOTO 87
      A(70)=1.
      IF(FF(3).GT.0.)A(70)=0.
      A(71)=0.
      IF(FF(3).GT.0.)A(71)=1.
      IF(FF(3).LT.0.)A(71)=-1.
      NJ=64
      K=6
      NA=6
      GOTO 105
C
C WPDB
C
 281  IF(NK.NE.5)GOTO 282
      IF(NA.EQ.0)FF(1)=2.
      A(199)=FF(1)
      IF(NA.GT.1)GOTO 75
      GOTO 8
C
C HKLF (actual or implied)
C
 282  IF(NK.NE.40)GOTO 83
      IF(ABS(FF(1)).GT.6.1)GOTO 87
        DO 283 I=131,143
        A(I)=0.
 283    CONTINUE
      IF(NA.LT.3)GOTO 284
      IF(IABS(NA-12).GT.2)GOTO 75
 284  A(132)=1.
      A(133)=1.
      A(137)=1.
      A(141)=1.
      A(142)=1.
        DO 285 I=1,NA
        A(I+130)=FF(I)
 285    CONTINUE
      KS=KC(23)
      IF(KG.NE.0)GOTO 73
      KR=4
      IR='END '
      IF(LR.NE.LK)WRITE(LC)NK,KR,IR(1:4),IR
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SX3C(LM,JW,LU,MK,ML,MB,FF,FC,A,B)
C
C Group fitting and bookkeeping
C
      CHARACTER*1 IH(50),KD
      CHARACTER*2 KA(94)
      CHARACTER*4 KS,KT,KU,KW,KX,KZ,KQ(23)
      CHARACTER*76 IT
      CHARACTER*80 NM,IR
      INTEGER MK(LU),ML(LU),MB(LU)
      REAL FF(LU),FC(LU)
      REAL A(LM),B(JW)
      COMMON/MEM/ST,SL,TC,TL,IV,LR,LG,LH,LI,LP,LF,LA,LC,LW,LY,LL,LB,
     +LX,LE,LV,LJ,LD,LS,LO,LT,LK,LQ,LZ,LN,KH,JA,JB,JC,JD,JE,HA,HD
      COMMON/WORD/IH,IT,IR,NM,KA,KD
      DATA KQ/'NCSY','????','EXYZ','EADP','BOND','FREE','BIND','DFIX',
     +'SAME','CONF','RTAB','MPLA','FLAT','CHIV','BLOC','DELU','SIMU',
     +'ISOR','SADI','ANIS','CONN','HFIX','OMIT'/
C
   1  FORMAT(' ** Warning: HKLF matrix changes hand of axes **')
   2  FORMAT(' ** Warning: unusual EXTI or SWAT parameter **')
   3  FORMAT(///' Crystal coordinates after fitting group starting ',
     +A4//' Atom      x         y         z     Deviation'/)
   4  FORMAT(1X,A4,3F10.5,F9.3)
   5  FORMAT(/' ** Atom ',A4,' deviates by',F8.3,
     +' Angstroms on fitting group starting ',A4/)
   6  FORMAT(/' Rms deviation =',F8.3,' Angstroms')
   7  FORMAT(' ** Warning: no match for',I5,' atoms in ',A,' **')
   8  FORMAT(/' ** Unknown atom',A,' in ',A,' instruction **')
C
C Check for unusual or illegal combinations of instructions
C
      IF(ABS(A(199)).GT.0.5.AND.A(51).LT.0.)CALL SXER(
     +'WPDB NOT ALLOWED WITH NEGATIVE MORE')
      T=A(133)*(A(137)*A(141)-A(138)*A(140))+A(134)*(A(138)*A(139)-
     +A(136)*A(141))+A(135)*(A(136)*A(140)-A(137)*A(139))
      IF(T.GT.0.01)GOTO 9
      IF(T.GT.-0.01)CALL SXER('HKLF MATRIX SINGULAR')
      WRITE(*,1)
      WRITE(LI,4)
      WRITE(LI,1)
      CALL SXFL
   9  IF(A(200).LT.0.0.AND.A(200).GT.-998.)GOTO 10
      IF(A(39).LT.0.0.AND.A(39).GT.-998.)GOTO 10
      IF(A(39).LT.1.2)GOTO 11
  10  WRITE(*,2)
      CALL SXFL
      WRITE(LI,4)
      WRITE(LI,2)
  11  A(76)=A(197)
      A(77)=A(198)
      A(78)=A(196)
      A(79)=A(199)
      A(80)=A(194)
      IF(A(177).LT.0.0.AND.A(72).GT.1.)CALL SXER('DAMP out of '//
     +'range for CGLS (shift multiplier > 1)')
      IF(A(74).LT.0.5)GOTO 14
      IF(A(177).LT.0.)CALL SXER('CGLS INCOMPATIBLE WITH ACTA')
      IF(A(177).LT.0.5)CALL SXER('L.S. 0 INCOMPATIBLE WITH ACTA')
      IF(A(52).GT.0.0001)CALL SXER('OMIT INCOMPATIBLE WITH ACTA')
      M=INT(ABS(A(54)))
      IF(M.EQ.2)GOTO 13
      IR=' '
      WRITE(IR,'(I3)',ERR=12)M
  12  IF(M.NE.0)CALL SXER('FMAP'//IR(1:3)//' INCOMPATIBLE WITH ACTA')
      A(54)=2.
  13  IF(A(73).LT.0.5)A(73)=4.1
      IF(ABS(A(158)).LT.0.5)A(158)=1.
  14  IF(INT(A(54)).EQ.0)GOTO 15
      IF(ABS(A(57)).LT.0.1)A(57)=20.1
  15  N=ML(1)
      IF(N.EQ.1)GOTO 20
      NN=LB-16
  16  NN=NN+32
      IF(NN.GT.LX)GOTO 20
      CALL SXUS(A(NN+1),KT)
      L=0
        DO 18 I=1,4
          DO 17 K=1,10
          IF(IH(K).EQ.KT(I:I))L=10*L+K-1
  17      CONTINUE
  18    CONTINUE
      IF(L.EQ.0)GOTO 16
        DO 19 I=2,N
        IF(MK(I).EQ.L)CALL SXER('BAD CLASS OR ALIAS IN RESI '//
     +  KT//'INSTRUCTION')
  19    CONTINUE
      GOTO 16
C
C Find Cp, Cp*, Ph and Naph groups
C
  20  IF(LT.EQ.0)LT=LX+31
      CALL SXTO(2)
      NN=LB-16
  21  NN=NN+32
      IF(NN.GT.LX)GOTO 57
      NA=INT(ABS(A(NN+6))*.1)
      IF(NA.LT.5)GOTO 21
      IF(NA.EQ.8)GOTO 21
      IF(NA.EQ.9)GOTO 21
      IF(NA.GT.16)GOTO 22
      IF(NA.GT.11)GOTO 21
  22  CALL SXCC
      IF(NA.EQ.7)NA=6
      NS=NA
      IF(NA.EQ.11)NS=10
      IF(NA.GT.12)NS=INT(A(NN+28))
      NS=NS+LT
      CALL SXUS(A(NN),KT)
      R=AMOD(ABS(A(NN+6)*10.),10.)
      N=LT
  23  M=INT(ABS(A(NN+6))*.1)
      IF(M.EQ.7)M=6
      IF(M.NE.NA)GOTO 27
      IF(M.GT.11)GOTO 24
      I=INT(AMOD(ABS(A(NN+6)),10.))
      IF(I.EQ.5)GOTO 25
      IF(I.EQ.6)GOTO 25
  24  A(NN+6)=AMOD(A(NN+6),10.)
  25  IF(AMAX1(ABS(A(NN+7)),ABS(A(NN+8)),ABS(A(NN+9))).LT.5.)GOTO 26
      CALL SXUS(A(NN),KS)
      CALL SXER('CONSTRAINED XYZ FOR '//KS//
     +' CANNOT BE FITTED TO GROUP STARTING '//KT)
  26  N=N+1
      A(N)=REAL(NN)+7.1
      IF(N.GE.NS)GOTO 28
  27  NN=NN+32
      IF(NN.GT.LX)CALL SXER('FITTED GROUP STARTING '//KT//
     +' INCOMPLETE')
      GOTO 23
  28  NT=0
        DO 29 I=LT+1,NS
        N=INT(A(I))
        IF(ABS(A(N))+ABS(A(N+1))+ABS(A(N+2)).LT.0.0001)A(I)=-A(I)
        IF(A(I).GT.0.)NT=NT+1
  29    CONTINUE
      IF(NT.LT.3)CALL SXER('CANNOT FIT GROUP STARTING '//KT//
     +' TO LESS THAN 3 ATOMS')
      IF(NA.GT.15)GOTO 34
C
C Generate target group coordinates
C
      U=0.
      V=0.
      Y=0.
      N=LT+MOD(NA,5)+5
      IF(N.NE.LT+5)GOTO 30
      IF(R.LT.0.2)R=1.42
      X=.8506508*R
      T=1.256637
      GOTO 31
  30  IF(R.LT.0.2)R=1.39
      X=R
      T=1.047193
  31  P=COS(T)
      Q=SIN(T)
      Y=0.
      L=LT
  32  Z=X
      X=X*P+Y*Q
      Y=-Z*Q+Y*P
      L=L+1
      K=IABS(INT(A(L)))
      A(K+10)=X+U
      A(K+11)=Y+V
      A(K+12)=0.
      IF(L.LT.N)GOTO 32
      IF(L.EQ.NS)GOTO 34
      N=NS
      IF(NA.EQ.11)GOTO 33
      X=X*2.24963
      GOTO 32
  33  U=1.5*X
      V=Q*X
      Q=-Q
      Y=-V
      X=-.5*X
      GOTO 32
C
C Iterative quaternion fit
C
  34  IF(ABS(A(51)).GT.2.5)WRITE(LI,3)KT
      NI=0
      U=0.
  35    DO 36 I=1,20
        FF(I)=0.
  36    CONTINUE
        DO 51 M=1,3
          DO 43 N=LT+1,NS
          K=IABS(INT(A(N)))
          IF(M.NE.1)GOTO 38
          IF(A(N).LT.0.)GOTO 43
            DO 37 I=1,3
            FF(I)=FF(I)+A(K+10)
            FF(I+3)=FF(I+3)+A(K)
            K=K+1
  37        CONTINUE
          GOTO 43
  38        DO 39 I=1,3
            FF(I+20)=A(K+10)-FF(I)
            FF(I+23)=A(K)-FF(I+3)
            K=K+1
  39        CONTINUE
          FF(24)=FF(24)*A(94)+FF(25)*A(95)+FF(26)*A(96)
          FF(25)=FF(25)*A(97)+FF(26)*A(98)
          FF(26)=FF(26)*A(99)
          IF(M.NE.2)GOTO 41
          IF(A(N).LT.0.)GOTO 43
          W=SQRT(FF(21)**2+FF(22)**2+FF(23)**2)
            DO 40 I=21,23
            FF(I+6)=FF(I)+FF(I+3)
            FF(I+9)=FF(I)-FF(I+3)
  40        CONTINUE
          FF(9)=FF(9)+(FF(28)**2+FF(29)**2)*W
          FF(10)=FF(10)-W*FF(27)*FF(28)
          FF(11)=FF(11)+(FF(27)*FF(27)+FF(29)*FF(29))*W
          FF(12)=FF(12)-W*FF(27)*FF(29)
          FF(13)=FF(13)-W*FF(29)*FF(28)
          FF(14)=FF(14)+(FF(27)*FF(27)+FF(28)*FF(28))*W
          FF(15)=FF(15)+W*(FF(32)*FF(28)-FF(31)*FF(29))
          FF(16)=FF(16)+W*(FF(30)*FF(29)-FF(32)*FF(27))
          FF(17)=FF(17)+W*(FF(31)*FF(27)-FF(30)*FF(28))
          GOTO 43
  41      Q=0.
            DO 42 I=33,35
            FF(I+9)=FF(I)*FF(21)+FF(I+3)*FF(22)+FF(I+6)*FF(23)
            IF(A(N).GT.0.)Q=Q+(FF(I+9)-FF(I-9))**2
  42        CONTINUE
          IF(NI.LT.4)GOTO 43
          U=U+Q
          Z=FF(44)/A(99)
          Y=(FF(43)-Z*A(98))/A(97)
          X=(FF(42)-Y*A(95)-Z*A(96))/A(94)
          A(K-3)=X+FF(4)
          A(K-2)=Y+FF(5)
          A(K-1)=Z+FF(6)
          CALL SXUS(A(K-10),KS)
          Q=SQRT(Q)
          IF(Q.GT.0.5)WRITE(LI,5)KS,Q,KT
          IF(ABS(A(51)).LT.2.5)GOTO 43
          IF(A(N).GT.0.)WRITE(LI,4)KS,A(K-3),A(K-2),A(K-1),Q
          IF(A(N).LT.0.)WRITE(LI,4)KS,A(K-3),A(K-2),A(K-1)
  43      CONTINUE
        IF(M.NE.1)GOTO 45
        W=1./REAL(NT)
          DO 44 I=1,3
          FF(I)=FF(I)*W
          FF(I+3)=FF(I+3)*W
  44      CONTINUE
  45    IF(M.NE.2)GOTO 51
C
C Solve quaternion equations
C
        IF(FF(9).LT.1.E-8)GOTO 56
        FF(9)=1./SQRT(FF(9))
        FF(10)=FF(10)*FF(9)
        T=FF(11)-FF(10)*FF(10)
        IF(T.LT.1.E-8)GOTO 56
        FF(11)=1./SQRT(T)
        FF(12)=FF(12)*FF(9)
        FF(13)=FF(11)*(FF(13)-FF(10)*FF(12))
        FF(15)=FF(15)*FF(9)
        FF(16)=FF(11)*(FF(16)-FF(10)*FF(15))
        T=FF(14)-FF(13)*FF(13)-FF(12)*FF(12)
        IF(T.LT.1.E-8)GOTO 56
        FF(17)=(FF(17)-FF(12)*FF(15)-FF(13)*FF(16))/T
        FF(16)=FF(11)*(FF(16)-FF(17)*FF(13))
        FF(15)=FF(9)*(FF(15)-FF(16)*FF(10)-FF(17)*FF(12))
        T=FF(15)*FF(15)+FF(16)*FF(16)+FF(17)*FF(17)
        Q=SQRT(T)
        IF(Q.LT.1.E-8)GOTO 47
          DO 46 I=15,17
          FF(I+3)=FF(I)/Q
  46      CONTINUE
  47    S=1.+T
        T=2.*T/S
        S=2.*Q/S
        Q=1.-T
          DO 48 I=33,41,4
          FF(I)=Q
  48      CONTINUE
        FF(40)=S*FF(18)
        FF(38)=-FF(40)
        FF(35)=S*FF(19)
        FF(39)=-FF(35)
        FF(36)=S*FF(20)
        FF(34)=-FF(36)
        K=33
          DO 50 I=18,20
            DO 49 L=18,20
            FF(K)=FF(K)+T*FF(I)*FF(L)
            K=K+1
  49        CONTINUE
  50      CONTINUE
  51    CONTINUE
      NI=NI+1
      IF(NI.GT.4)GOTO 55
        DO 54 N=LT+1,NS
        K=IABS(INT(A(N)))+10
          DO 52 I=33,35
          FF(I+9)=A(K)*FF(I)+A(K+1)*FF(I+3)+A(K+2)*FF(I+6)
  52      CONTINUE
          DO 53 I=42,44
          A(K)=FF(I)
          K=K+1
  53      CONTINUE
  54    CONTINUE
      GOTO 35
  55  IF(ABS(A(51)).LT.2.5)GOTO 21
      U=SQRT(U/REAL(NT))
      WRITE(LI,6)U
      GOTO 21
  56  CALL SXER('GROUP STARTING WITH '//KT//' CANNOT BE FITTED')
C
C Collect and store free variables
C
  57  LV=LT
      A(LV+1)=1.
      CALL SXTO(3)
      J=1
  58  IF(J.GE.JA)GOTO 60
      JD=J
      J=J+INT(AMOD(B(J),64000.))
      IF(INT(B(JD)/64000.).NE.8)GOTO 58
  59  JD=JD+1
      IF(JD.GE.J)GOTO 58
      LV=LV+1
      A(LV)=B(JD)
      GOTO 59
C
C Evaluate atom coordinates
C
  60  IF(LV.LT.LT+1)LV=LT+1
      IF(A(LT+1).LE.0.)CALL SXER('BAD OVERALL SCALE')
      A(75)=A(LT+1)**2
      A(LT+1)=1.
      NN=LB-16
  61  NN=NN+32
      IF(NN.GT.LX)GOTO 63
      CALL SXUS(A(NN),KS)
      K=NN+7
      L=NN+11
      IF(A(NN+3).LT.0.)L=NN+16
        DO 62 I=K,L
        N=MAX0(0,INT(.1*ABS(A(I))-.5))+LT+1
        IF(N.GT.LV)CALL SXER('UNSET FREE VARIABLE FOR ATOM '//KS)
        R=SIGN(.5,A(I)+5.)
        A(I+10)=(AMOD(A(I)+5.,10.)-10.*R)*(R+AMOD(A(N)+5.,10.)-5.5)
  62    CONTINUE
      IF(A(NN+20).LT.0.)CALL SXER('NEGATIVE OCCUPANCY FOR ATOM '//KS)
      GOTO 61
C
C Check for unknown atoms on HFIX, ANIS, OMIT and CONN instructions
C
  63  J=1
        DO 64 I=62,65
        MB(I)=0
  64    CONTINUE
  65  IF(J.GE.JA)GOTO 77
      JD=J
      J=J+INT(AMOD(B(JD),64000.))
      NK=INT(B(JD)/64000.)
      IF(NK.LT.62)GOTO 65
      IF(NK.GT.65)GOTO 65
      JC=JD+1
      IF(NK.EQ.63)JC=JD+3
      IF(NK.EQ.64)JC=JD+4
      CALL SXUS(B(JC),KZ)
      N=0
      GOTO 68
  66  IF(N.EQ.1)GOTO 67
      IF(JC.LT.J-2)GOTO 68
  67  CALL SXER('BADLY PLACED '//KT(1:1)//' ON '//KQ(NK-42)//
     +' INSTRUCTION')
  68  JC=JC+2
      IF(JC.GE.J)GOTO 65
      N=N+1
      CALL SXUS(B(JC-1),KT)
      IF(KT(1:1).EQ.IH(24))GOTO 66
      IF(KT.EQ.'LAST')GOTO 68
      IF(KT(1:1).NE.IH(50))GOTO 70
        DO 69 N=LL+4,LB,16
        CALL SXUS(A(N+13),KW)
        IF(KW(1:2).EQ.KT(2:3))GOTO 68
  69    CONTINUE
  70  CALL SXUS(B(JC),KU)
      IF(KU(1:1).EQ.IH(20))KU=KZ
      IF(KU(1:1).NE.IH(50))GOTO 71
      KT=KU
      GOTO 67
  71  NN=LB-16
  72  NN=NN+32
      IF(NN.GT.LX)GOTO 73
      CALL SXUS(A(NN),KW)
      IF(KW.NE.KT)GOTO 72
      IF(KU(1:1).EQ.IH(21))GOTO 68
      CALL SXUS(A(NN+1),KW)
      IF(KU.EQ.KW)GOTO 68
      CALL SXUS(A(NN+2),KW)
      IF(KU.EQ.KW)GOTO 68
      GOTO 72
  73  N=1
      IR=' '
        DO 74 K=1,4
        IF(KT(K:K).EQ.IH(20))GOTO 74
        N=N+1
        IR(N:N)=KT(K:K)
  74    CONTINUE
      IF(KU.EQ.'0   ')GOTO 76
      N=N+1
      IR(N:N)=IH(22)
        DO 75 K=1,4
        IF(KU(K:K).EQ.IH(20))GOTO 75
        N=N+1
        IR(N:N)=KU(K:K)
  75    CONTINUE
  76  WRITE(LI,8)IR(1:N),KQ(NK-42)
      MB(NK)=MB(NK)+1
      GOTO 68
  77    DO 78 I=62,65
        IF(MB(I).NE.0)WRITE(*,7)MB(I),KQ(I-42)
  78    CONTINUE
      CALL SXFL
C
C Scan restraints to set up EQIV pointers in FC
C
        DO 79 I=1,LU
        FC(I)=0.
        MB(I)=0
  79    CONTINUE
      J=1
  80  IF(J.GE.JA)GOTO 87
      JD=J
      J=J+INT(AMOD(B(JD),64000.))
      IF(INT(B(JD)/64000.).NE.44)GOTO 80
      CALL SXUS(B(JD+14),KS)
      N=0
        DO 83 I=2,4
          DO 81 K=1,10
          IF(KS(I:I).EQ.IH(K))GOTO 82
  81      CONTINUE
        GOTO 84
  82    N=10*N+K-1
  83    CONTINUE
  84  IF(N.EQ.0)GOTO 85
      IF(N.LE.LU)GOTO 86
  85  CALL SXPN(X,LU)
      CALL SXUS(X,KT)
      CALL SXER('SYMMETRY CODE '//KS//
     +' OUTSIDE ALLOWED RANGE OF $1 - $'//KT)
  86  FC(N)=REAL(JD)+0.1
      GOTO 80
C
C Check if atoms names unique and set up cyclic disorder pointers
C
  87  LE=LV-19
      CALL SXTO(3)
      N=LB-16
  88  N=N+32
      IF(N.GT.LX)GOTO 93
      CALL SXUS(A(N+1),KZ)
      M=0
        DO 91 I=1,4
          DO 89 K=1,10
          IF(KZ(I:I).EQ.IH(K))GOTO 90
  89      CONTINUE
        GOTO 92
  90    M=10*M+K-1
  91    CONTINUE
  92  A(N+30)=REAL(M+1)
      A(N+28)=0.
      GOTO 88
  93  N=LB-16
  94  N=N+32
      IF(N.GT.LX)GOTO 97
      CALL SXUS(A(N),KX)
      NI=INT(A(N+30))
      NJ=INT(ABS(A(N+29)))
      MM=0
      M=N
  95  M=M+32
      IF(M.GT.LX)GOTO 94
      IF(NI.NE.INT(A(M+30)))GOTO 95
      CALL SXUS(A(M),KS)
      IF(KS.NE.KX)GOTO 95
      NK=INT(ABS(A(M+29)))
      CALL SXUS(A(N+1),KZ)
      IF(NJ.NE.NK)GOTO 96
      IF(INT(A(N+3)).EQ.KH.AND.INT(A(M+3)).EQ.KH)GOTO 95
      CALL SXPN(Q,NJ)
      CALL SXUS(Q,KT)
      CALL SXER('DUPLICATE ATOM '//KS//' IN RESIDUE '
     +//KZ//' WITH PART NUMBER '//KT)
  96  IF(MM.EQ.0)A(N+28)=REAL(M)
      MM=1
      IF(A(M+28).LT.0.5)A(M+28)=REAL(N)
      GOTO 95
  97  RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SX3D(LM,JW,LU,IM,MK,ML,MB,SI,FC,SQ,WL,A,B,C)
C
C Connectivity, interpret restraints
C
      CHARACTER*1 IH(50),KD
      CHARACTER*2 KA(94)
      CHARACTER*4 KG,KP,KS,KT,KU,KX,KY,KZ,KQ(23)
      CHARACTER*76 IT
      CHARACTER*80 NM,IR
      CHARACTER*128 KR
      INTEGER MK(LU),ML(LU),MB(LU)
      REAL SI(LU),FC(LU),SQ(LU),WL(LU),A(LM),B(JW),C(IM)
      COMMON/MEM/ST,SL,TC,TL,IV,LR,LG,LH,LI,LP,LF,LA,LC,LW,LY,LL,LB,
     +LX,LE,LV,LJ,LD,LS,LO,LT,LK,LQ,LZ,LN,KH,JA,JB,JC,JD,JE,HA,HD
      COMMON/WORD/IH,IT,IR,NM,KA,KD
      DATA KQ/'NCSY','????','EXYZ','EADP','BOND','FREE','BIND','DFIX',
     +'SAME','CONF','RTAB','MPLA','FLAT','CHIV','BLOC','DELU','SIMU',
     +'ISOR','SADI','ANIS','CONN','HFIX','OMIT'/
C
   1  FORMAT(' ** Warning: no match for',I5,' atoms in ',A,' **')
   2  FORMAT(//' Covalent radii and connectivity table for ',A/)
   3  FORMAT(1X,A,F6.3)
   4  FORMAT(//' Operators for generating equivalent atoms:'/)
   5  FORMAT(/' Following atoms could not be matched for ',
     +'particular residues for ',A,':'/)
   6  FORMAT(/' The list(s) of unresolved atoms may be incomplete')
C
C Expand restraints and generate equivalent atoms referenced
C
      MF=0
      JC=1
      JB=JA+1
   7  IF(JC.GE.JA)GOTO 114
      JE=JC
      NK=INT(B(JC)/64000.)
      JC=JC+INT(AMOD(B(JC),64000.))
      IF(NK.LT.43)GOTO 7
      IF(NK.EQ.44)GOTO 7
      IF(NK.GT.61)GOTO 7
      CALL SXCC
      JP=0
      JD=1
      IF(NK.EQ.43)JD=4
      IF(NK.EQ.51)JD=4
      IF(NK.EQ.50)JD=3
      IF(NK.GT.53)JD=2
      IF(IABS(NK-57).LT.2)JD=3
      IF(NK.EQ.59)JD=4
      IF(NK.EQ.60)JD=3
      JD=JE+JD
      CALL SXUS(B(JD),KZ)
      IF(NK.NE.51)GOTO 9
      CALL SXUS(B(JD+1),KT)
      N=INT(B(JE+3))-32
   8  N=N+32
      IF(N.GT.LX)GOTO 9
      CALL SXUS(A(N+2),KP)
      IF(KP.NE.KZ)GOTO 8
      CALL SXUS(A(N),KP)
      IF(KP.NE.KT)GOTO 8
      B(JE+3)=REAL(N)+0.1
   9  KP=KZ
      IF(NK.EQ.53)JD=JD+2
C
C Replicate instruction for all global residues
C
      B(JE)=AMOD(B(JE),64000.)
      MG=LB+16
      MQ=LX
      KG=KZ
      IF(KZ(1:1).GE.'0'.AND.KZ(1:1).LE.'9')GOTO 17
      NQ=LB-16
      N=NQ
  10  N=N+32
      IF(N.GT.LX)GOTO 11
      A(N+30)=ABS(A(N+30))
      GOTO 10
  11  IF(KP(1:1).EQ.IH(21))GOTO 13
      N=NQ
  12  N=N+32
      IF(N.GT.LX)GOTO 13
      CALL SXUS(A(N+2),KT)
      IF(KT.NE.KG)A(N+30)=-ABS(A(N+30))
      GOTO 12
  13  MG=LX+32
      MQ=LB-16
  14  NQ=NQ+32
      IF(NQ.GT.LX)GOTO 7
      IF(A(NQ+30).LT.0.)GOTO 14
      ME=INT(A(NQ+30))
      N=NQ-32
  15  N=N+32
      IF(N.GT.LX)GOTO 16
      IF(A(N+30).LT.0.)GOTO 15
      IF(INT(A(N+30)).NE.ME)GOTO 15
      MG=MIN0(MG,N)
      MQ=MAX0(MQ,N)
      A(N+30)=-ABS(A(N+30))
      GOTO 15
  16  NQ=MG
      GOTO 22
  17  NQ=LX
      ME=0
        DO 20 I=1,4
          DO 18 K=1,10
          IF(KZ(I:I).EQ.IH(K))GOTO 19
  18      CONTINUE
        GOTO 21
  19    ME=10*ME+K-1
  20    CONTINUE
  21  ME=ME+1
  22  NG=0
      MD=0
      KU='    '
        DO 61 J=JD+2,JC,2
        CALL SXUS(B(J-1),KX)
        CALL SXUS(B(J),KY)
        IF(KY(1:1).NE.IH(50))GOTO 34
        N=0
          DO 25 I=2,4
            DO 23 K=1,10
            IF(KY(I:I).EQ.IH(K))GOTO 24
  23        CONTINUE
          GOTO 26
  24      N=10*N+K-1
  25      CONTINUE
  26    IF(N.EQ.0)GOTO 27
        IF(N.LE.LU)GOTO 28
  27    CALL SXPN(X,LU)
        CALL SXUS(X,KT)
        CALL SXER('SYMMETRY CODE '//KT//
     +  ' OUTSIDE ALLOWED RANGE OF $1 - $'//KT)
  28    TN=REAL(N)
        JF=INT(FC(N))
        IF(JF.LT.1)CALL SXER('NO EQIV INSTRUCTION FOR SYMMETRY '
     +  //'OPERATION '//KY)
C
C Check existing equivalents
C
        N=LV-19
  29    N=N+20
        IF(N.GT.LE)GOTO 30
        CALL SXUS(A(N+2),KS)
        IF(KS.NE.KY)GOTO 29
        CALL SXUS(A(N),KS)
        IF(KS.NE.KX)GOTO 29
        L=INT(A(N+3))
        IF(INT(ABS(A(L+30))).NE.ME)GOTO 29
        NG=NG+1
        IF(NG.GT.IM)GOTO 113
        C(NG)=REAL(N)+.1
        GOTO 61
C
C Generate extra equivalent atom
C
  30    N=MG-32
        M=LE
  31    N=N+32
        IF(N.GT.MQ)GOTO 33
        IF(INT(ABS(A(N+30))).NE.ME)GOTO 31
        CALL SXUS(A(N),KS)
        IF(KS.NE.KX)GOTO 31
        IF(A(N+28).GT.0.5)CALL SXER('AMBIGUOUS ATOM '//KX//'_'//
     +  KY//' FOR SYMMETRY TRANSFORMATION')
        LE=LE+20
        IF(LE.GT.LM-19)GOTO 101
        CALL SXPS(A(LE),KX)
        CALL SXPS(A(LE+1),'    ')
        CALL SXPS(A(LE+2),KY)
        A(LE+3)=REAL(N)+.1
        A(LE+4)=TN
        JG=JF
          DO 32 L=LE+5,LE+16
          JG=JG+1
          A(L)=B(JG)
  32      CONTINUE
        A(LE+17)=A(N+17)*A(LE+5)+A(N+18)*A(LE+6)+A(N+19)*A(LE+7)+
     +  A(LE+14)
        A(LE+18)=A(N+17)*A(LE+8)+A(N+18)*A(LE+9)+A(N+19)*A(LE+10)+
     +  A(LE+15)
        A(LE+19)=A(N+17)*A(LE+11)+A(N+18)*A(LE+12)+A(N+19)*A(LE+13)+
     +  A(LE+16)
        NG=NG+1
        IF(NG.GT.IM)GOTO 113
        C(NG)=REAL(LE)+.1
        GOTO 61
  33    CALL SXER('CANNOT FIND ATOM '//KX//' IN RESIDUE '//KZ//
     +  ' FOR OPERATION '//KY)
C
C Special symbols in atom list
C
  34    MA=MG
        MC=MQ
        MM=ME
        IF(MD.NE.0)GOTO 36
        IF(KX(1:1).EQ.IH(23))MD=-32
        IF(KX(1:1).EQ.IH(24))MD=32
        IF(MD.EQ.0)GOTO 37
        IF(NG.GT.0)GOTO 61
  35    CALL SXER('MISPLACED '//KX)
  36    IF(KX(1:1).EQ.IH(23))GOTO 35
        IF(KX(1:1).EQ.IH(24))GOTO 35
        IF(KX(1:1).EQ.IH(50))GOTO 35
  37    M=0
        IF(KY(1:1).EQ.IH(12))M=-1
        IF(KY(1:1).EQ.IH(13))M=1
        NS=0
        IF(KX(1:1).NE.IH(50))GOTO 39
        IF(M.NE.0)GOTO 35
        NS=LL-12
  38    NS=NS+16
        IF(NS.GT.LB)CALL SXER('UNKNOWN SFAC ELEMENT '//KX)
        CALL SXUS(A(NS+13),KS)
        IF(KS(1:3).NE.KX(2:4))GOTO 38
  39    N=ME
        IF(KY(1:1).LT.IH(1).OR.KY(1:1).GT.IH(10))GOTO 44
        N=0
          DO 42 I=1,4
            DO 40 K=1,10
            IF(KY(I:I).EQ.IH(K))GOTO 41
  40        CONTINUE
          GOTO 43
  41      N=10*N+K-1
  42      CONTINUE
  43    N=N+1
  44    N=N+M
        IF(N.LT.0)GOTO 53
        IF(N.GT.9999)GOTO 53
        K=ML(1)
          DO 45 I=2,K
          IF(MK(I).EQ.N-1)N=ML(I)+1
  45      CONTINUE
        IF(N.EQ.ME)GOTO 46
        MM=N
        MA=LB+16
        MC=LX
C
C Locate atom/residue combination referenced
C
  46    N=LX
        IF(KX.EQ.'LAST')GOTO 50
        N=MA-32
  47    IF(KY(1:1).NE.'*')GOTO 49
  48    N=N+32
        IF(N.GT.MC)GOTO 53
        IF(NS.EQ.INT(ABS(A(N+3))))GOTO 50
        CALL SXUS(A(N),KS)
        IF(KS.NE.KX)GOTO 48
        GOTO 50
  49    N=N+32
        IF(N.GT.MC)GOTO 53
        IF(INT(ABS(A(N+30))).NE.MM)GOTO 49
        IF(NS.EQ.INT(ABS(A(N+3))))GOTO 50
        CALL SXUS(A(N),KS)
        IF(KS.NE.KX)GOTO 49
  50    IF(MD.EQ.0)GOTO 59
        IF(NG.EQ.0)GOTO 52
        M=INT(ABS(C(NG)))
        IF(M.EQ.N)GOTO 60
  51    M=M+MD
        IF(M.EQ.N)GOTO 59
        IF(M.GT.LX)GOTO 52
        IF(M.LT.LB)GOTO 52
        IF(INT(ABS(A(M+3))).EQ.KH)GOTO 51
        NG=NG+1
        IF(NG.GT.IM)GOTO 113
        C(NG)=REAL(M)
        GOTO 51
  52    N=23
        IF(MD.GT.0)N=24
        CALL SXER('CANNOT RESOLVE '//KQ(NK-42)//' .. '//KU//IH(20)//
     +  IH(N)//IH(20)//KX)
C
C Take missing atoms into account
C
  53    IF(NS.NE.0)GOTO 61
        IF(J.GT.JC-2)GOTO 56
        CALL SXUS(B(J+1),KS)
        IF(KS.EQ.'>   ')GOTO 54
        IF(KS.NE.'<   ')GOTO 56
        MD=-32
        GOTO 55
  54    MD=32
  55    KU=KX
        KX='    '
        IF(J.GT.JC-4)GOTO 52
        CALL SXUS(B(J+3),KX)
        GOTO 52
  56    IF(KP(1:1).EQ.IH(21))GOTO 58
        MF=MF+1
        IF(MF.GT.LU)GOTO 57
        CALL SXPS(SI(MF),KX)
        CALL SXPS(SQ(MF),KY)
        IF(KY.EQ.'    ')CALL SXPN(SQ(MF),MM-1)
        WL(MF)=REAL(NK-42)
  57    MB(NK-42)=1
  58    N=0
        IF(NK.EQ.53)GOTO 13
        IF(NK.EQ.61)GOTO 59
        IF(IABS(NK-50).GT.2)GOTO 61
  59    NG=NG+1
        IF(NG.GT.IM)GOTO 113
        C(NG)=REAL(N)
  60    KU=KX
        IF(NS.NE.0)GOTO 47
        MD=0
  61    CONTINUE
        DO 62 N=1,NG
        IF(C(N).GT.0.9)GOTO 63
  62    CONTINUE
      IF(NG.GT.0)GOTO 13
      IF(NK.GT.60)GOTO 13
      IF(NK.LT.57)GOTO 13
  63  IF(NK.EQ.61)GOTO 64
      IF(IABS(NK-49).GT.1)GOTO 68
  64  N=-1
  65  N=N+2
  66  IF(N.GT.NG)GOTO 72
      IF(AMAX1(C(N),C(N+1)).LT.0.5)GOTO 67
      IF(ABS(C(N)*C(N+1)).GT.0.9)GOTO 65
  67  C(N)=C(NG-1)
      C(N+1)=C(NG)
      NG=NG-2
      GOTO 66
  68  IF(NK.NE.52)GOTO 72
      MD=NG
      NA=0
  69  NG=0
  70  NA=NA+1
      IF(NA.GT.MD)GOTO 71
      IF(ABS(C(NA)).LT.0.5)GOTO 71
      NG=NG+1
      C(NG)=ABS(C(NA))
      GOTO 70
  71  IF(NG.GT.3)GOTO 73
      IF(NA.GT.MD)GOTO 13
      GOTO 69
  72  IF(NG.GT.3)GOTO 73
      IF(NK.EQ.55)GOTO 13
      IF(NG.EQ.3)GOTO 73
      IF(NK.EQ.54)GOTO 13
      IF(NG.GT.0)GOTO 73
      IF(NK.EQ.61)GOTO 13
      IF(NK.GT.56)GOTO 73
      IF(NK.NE.47)GOTO 13
C
C Take disordered atoms with same names into account
C
  73  MA=0
      MC=NG
      K=0
      IF(NK.EQ.43)GOTO 100
        DO 78 I=1,MC
        N=INT(ABS(C(I)))
        IF(N.EQ.0)GOTO 78
        IF(N.GT.LX)GOTO 78
        IF(A(N+28).GT.0.5)GOTO 74
        K=MAX0(K,INT(ABS(A(N+29))))
        GOTO 78
  74    L=N
        IF(IABS(NK-46).LT.2)GOTO 75
        IF(IABS(NK-58).GT.2)GOTO 76
  75    L=INT(A(L+28))
        IF(L.EQ.0)GOTO 78
        IF(L.EQ.N)GOTO 78
        NG=NG+1
        IF(NG.GT.IM)GOTO 113
        C(NG)=REAL(L)
        GOTO 75
  76    L=N
  77    MA=MAX0(MA,INT(ABS(A(L+29))))
        L=INT(A(L+28))
        IF(L.NE.N)GOTO 77
  78    CONTINUE
      IF(MA.EQ.0)GOTO 100
      IF(K.EQ.0)GOTO 95
        DO 82 I=1,NG
        N=INT(ABS(C(I)))
        IF(N.EQ.0)GOTO 82
        L=INT(A(N+28))
        IF(L.GT.0)GOTO 79
        IF(INT(A(N+29)).EQ.0)GOTO 82
        IF(INT(A(N+29)).NE.K)GOTO 13
        GOTO 82
  79    N=L
        IF(INT(A(N+29)).EQ.K)GOTO 81
  80    N=INT(A(N+28))
        IF(N.EQ.L)GOTO 13
        IF(INT(A(N+29)).NE.K)GOTO 80
  81    C(I)=REAL(N)
  82    CONTINUE
      MA=0
      GOTO 100
  83    DO 94 I=1,MC,2
        N=INT(ABS(C(I)))
        L=INT(ABS(C(I+1)))
        IF(N.GT.LX)GOTO 84
        IF(A(N+28).GT.0.5)GOTO 86
  84    IF(L.GT.LX)GOTO 94
        IF(A(L+28).LT.0.5)GOTO 94
        K=L
  85    K=INT(A(K+28))
        IF(K.EQ.L)GOTO 94
        NG=NG+2
        IF(NG.GT.IM)GOTO 113
        C(NG-1)=REAL(N)
        C(NG)=REAL(K)
        GOTO 85
  86    IF(L.GT.LX)GOTO 87
        IF(A(L+28).GT.0.5)GOTO 89
  87    K=N
  88    K=INT(A(K+28))
        IF(K.EQ.N)GOTO 94
        NG=NG+2
        IF(NG.GT.IM)GOTO 113
        C(NG-1)=REAL(K)
        C(NG)=REAL(L)
        GOTO 88
  89    K=L
  90    IF(INT(A(K+29)).EQ.INT(A(N+29)))GOTO 91
        K=INT(A(K+28))
        IF(K.EQ.L)GOTO 94
        GOTO 90
  91    C(I+1)=REAL(K)
        MA=N
  92    MA=INT(A(MA+28))
        IF(MA.EQ.N)GOTO 94
        L=K
  93    L=INT(A(L+28))
        IF(L.EQ.K)GOTO 92
        IF(INT(A(L+29)).NE.INT(A(MA+29)))GOTO 93
        NG=NG+2
        IF(NG.GT.IM)GOTO 113
        C(NG-1)=REAL(MA)
        C(NG)=REAL(L)
        GOTO 93
  94    CONTINUE
      MA=0
      GOTO 100
  95  IF(IABS(NK-49).LT.2)GOTO 83
      IF(NK.EQ.61)GOTO 83
      IF(IABS(NK-54).GT.1)CALL SXER('MULTIPLE ATOMS WITH SAME '
     +//'NAMES NOT COMPATIBLE WITH '//KQ(NK-42)//' INSTRUCTION')
  96  MA=MA-1
      IF(MA.LT.0)GOTO 13
        DO 99 I=1,NG
        N=INT(ABS(C(I)))
        IF(INT(A(N+28)).EQ.0)GOTO 99
        L=N
  97    IF(INT(A(L+29)).EQ.MA+1)GOTO 98
        L=INT(A(L+28))
        IF(L.NE.N)GOTO 97
        GOTO 96
  98    C(I)=REAL(L)
  99    CONTINUE
C
C Change atom names to pointers
C
 100  J=NG
      IF(JB+JD-JE+J.LT.JW)GOTO 103
      I=28
      GOTO 102
 101  I=27
 102  CALL SXER('PROBLEM TOO LARGE - INCREASE DIMENSION OF ARRAY '
     +//IH(I))
 103  J=JE+1
      JF=JB-1
      IF(NK.NE.53)GOTO 105
      CALL SXUS(B(J+1),KT)
      CALL SXPS(B(JB),KT)
      JB=JB+1
      GOTO 106
 104  IF(J.GE.JD)GOTO 106
      B(JB)=B(J)
      JB=JB+1
      J=J+1
      GOTO 104
 105  IF(JP.EQ.0)GOTO 104
      JF=JP
      JB=JB-1
 106  IF(NK.GT.46)GOTO 108
      IF(NK.EQ.43)GOTO 108
      IF(NG.EQ.0)GOTO 108
      T=9.E9
        DO 107 I=1,NG
        IF(T.LT.ABS(C(I)))GOTO 107
        T=ABS(C(I))
        L=I
 107    CONTINUE
      B(JB)=T
      JB=JB+1
      C(L)=C(NG)
      NG=NG-1
 108  IF(NK.NE.56)GOTO 111
      I=0
 109  I=I+1
      IF(I.GT.NG)GOTO 110
      IF(C(I).GT.0.5)GOTO 109
      C(I)=C(NG)
      NG=NG-1
      GOTO 109
 110  IF(NG.EQ.0)GOTO 13
 111    DO 112 I=1,NG
        B(JB)=ABS(C(I))
        JB=JB+1
 112    CONTINUE
      IF(JB.GT.JF+63998)GOTO 113
      B(JB)=0.
      B(JF)=64000.*REAL(NK)+REAL(JB-JF)+.1
      IF(NK.EQ.61)JP=JF
      JB=JB+1
      IF(MA.GT.0)GOTO 96
      IF(NK.EQ.52)GOTO 69
      GOTO 13
 113  CALL SXER('TOO MANY ATOMS REFERENCED IN A SINGLE '//KQ(NK-42)
     +//' INSTRUCTION')
C
C Report missing atoms
C
 114  IF(MF.EQ.0)GOTO 122
      KR=' '
      L=1
        DO 115 I=1,19
        IF(MB(I).EQ.0)GOTO 115
        L=L+5
        KR(L-4:L)=KQ(I)//' '
 115    CONTINUE
      WRITE(*,1)MF,KR(1:L)
      CALL SXFL
      WRITE(LI,3)
      WRITE(LI,1)MF,KR(1:L)
      IF(MF.GT.LU)MF=LU
      IF(ABS(A(51)).LT.0.5)GOTO 122
        DO 121 I=1,19
        IF(MB(I).EQ.0)GOTO 121
        WRITE(LI,5)KQ(I)
        L=0
        KR(1:1)=' '
          DO 120 K=1,MF
          IF(INT(WL(K)).NE.I)GOTO 120
          IF(L.LT.111)GOTO 116
          WRITE(LI,3)KR(1:L)
          L=0
 116      CALL SXUS(SI(K),KS)
            DO 117 M=1,4
            IF(KS(M:M).EQ.' ')GOTO 117
            L=L+1
            KR(L:L)=KS(M:M)
 117        CONTINUE
          CALL SXUS(SQ(K),KS)
          IF(KS.EQ.'0   ')GOTO 119
          L=L+1
          KR(L:L)=IH(22)
            DO 118 M=1,4
            IF(KS(M:M).EQ.' ')GOTO 118
            L=L+1
            KR(L:L)=KS(M:M)
 118        CONTINUE
 119      L=L+1
          KR(L:L)=' '
 120      CONTINUE
        IF(L.GT.0)WRITE(LI,3)KR(1:L)
 121    CONTINUE
      IF(MF.EQ.LU)WRITE(LI,6)
C
C Orthogonal coordinates and limits
C
 122  JB=JB-1
      CALL SXTO(4)
        DO 123 I=1,6
        FC(I)=9.E9
        FC(I+6)=-9.E9
 123    CONTINUE
      MF=0
      N=LB-16
 124  N=N+32
      IF(N.GT.LX)GOTO 126
      K=INT(ABS(A(N+3)))
      A(N+20)=A(94)*A(N+17)+A(95)*A(N+18)+A(96)*A(N+19)
      A(N+21)=A(97)*A(N+18)+A(98)*A(N+19)
      A(N+22)=A(99)*A(N+19)
      IF(K.EQ.KH)GOTO 124
      A(N+30)=100.*AMOD(A(N+5),1.)+0.25
      M=N+20
      L=1
        DO 125 I=23,25
        T=A(M)-A(N+30)
        IF(T.LT.FC(L))FC(L)=T
        T=A(M)+A(N+30)
        IF(T.GT.FC(L+6))FC(L+6)=T
        IF(A(M-3).LT.FC(L+3))FC(L+3)=A(M-3)
        IF(A(M-3).GT.FC(L+9))FC(L+9)=A(M-3)
        L=L+1
        M=M+1
 125    CONTINUE
      GOTO 124
C
C Generate equivalents
C
 126  N=LB-16
        DO 127 I=4,6
        FC(I+6)=FC(I+6)+1.
        FC(I+9)=FC(I)-2.5
 127    CONTINUE
        DO 128 I=1,IM
        C(I)=0.
 128    CONTINUE
      I=LV-19
 129  I=I+20
      IF(I.GT.LE)GOTO 130
      K=INT(A(I+4))
      IF(K.LT.1)GOTO 129
      IF(K.GT.IM)GOTO 129
      IF(C(K).GT.0.5)GOTO 129
      C(K)=REAL(I)
      GOTO 129
 130  N=N+32
      IF(N.GT.LX)GOTO 149
      IF(INT(ABS(A(N+3))).EQ.KH)GOTO 130
      IF(ABS(A(N+10)-10.).LT.0.0001)GOTO 130
      IF(INT(ABS(A(N+5))).EQ.0)GOTO 130
      NI=INT(ABS(.1*A(N+6)))
      IF(NI.EQ.0)GOTO 131
      IF(ABS(A(N+7))+ABS(A(N+8))+ABS(A(N+9)).GT.0.0001)GOTO 131
      IF(NI.LT.5)GOTO 130
      IF(NI.EQ.9)GOTO 130
      IF(IABS(NI-10).EQ.2)GOTO 130
 131  CALL SXCC
      R=A(N+30)
      IF(INT(A(N+5)).EQ.0)R=4.
        DO 132 I=1,3
        FC(I+15)=FC(I)-R
        FC(I+18)=FC(I+6)+R
 132    CONTINUE
        DO 148 K=201,LY,12
        UU=A(N+17)*A(K)+A(N+18)*A(K+1)+A(N+19)*A(K+2)+A(K+9)
        VV=A(N+17)*A(K+3)+A(N+18)*A(K+4)+A(N+19)*A(K+5)+A(K+10)
        WW=A(N+17)*A(K+6)+A(N+18)*A(K+7)+A(N+19)*A(K+8)+A(K+11)
          DO 147 L=LY+12,LL,4
          XS=FC(13)+AMOD(A(L)*UU+A(L+1)-FC(4),1.)
          YS=FC(14)+AMOD(A(L)*VV+A(L+2)-FC(5),1.)
          Z=FC(15)+AMOD(A(L)*WW+A(L+3)-FC(6),1.)
 133      Z=Z+1.
          IF(Z.GT.FC(12))GOTO 147
          W=Z*A(99)
          IF(W.LT.FC(18))GOTO 133
          IF(W.GT.FC(21))GOTO 147
          Y=YS
 134      Y=Y+1.
          IF(Y.GT.FC(11))GOTO 133
          V=Y*A(97)+Z*A(98)
          IF(V.LT.FC(17))GOTO 134
          IF(V.GT.FC(20))GOTO 133
          X=XS
 135      X=X+1.
          IF(X.GT.FC(10))GOTO 134
          U=X*A(94)+Y*A(95)+Z*A(96)
          IF(U.LT.FC(16))GOTO 135
          IF(U.GT.FC(19))GOTO 134
C
C Check against existing atoms and equivalents
C
          IF((U-A(N+20))**2+(V-A(N+21))**2+(W-A(N+22))**2.LT.
     +    0.01)GOTO 135
          I=LV-19
 136      I=I+20
          IF(I.GT.LE)GOTO 137
          IF(INT(A(I+3)).NE.N)GOTO 136
          P=X-A(I+17)
          Q=Y-A(I+18)
          S=Z-A(I+19)
          IF(A(8)*P**2+A(9)*Q**2+A(10)*S**2+A(11)*Q*S+A(12)*P*S+
     +    A(13)*P*Q.GT.0.01)GOTO 136
          GOTO 135
C
C Identify bonded shell
C
 137      M=INT(ABS(A(N+29)))
          I=LB-16
 138      I=I+32
          IF(I.GT.LX)GOTO 135
          IF(INT(ABS(A(I+3))).EQ.KH)GOTO 138
          IF(ABS(A(I+10)-10.).LT.0.0001)GOTO 138
          IF(INT(ABS(A(I+5))).EQ.0)GOTO 138
          NI=INT(ABS(.1*A(I+6)))
          IF(NI.EQ.0)GOTO 139
          IF(ABS(A(I+7))+ABS(A(I+8))+ABS(A(I+9)).GT.0.0001)GOTO 139
          IF(NI.LT.5)GOTO 138
          IF(NI.EQ.9)GOTO 138
          IF(IABS(NI-10).EQ.2)GOTO 138
 139      IF(M.EQ.0)GOTO 140
          NI=INT(A(I+29))
          IF(NI.EQ.0)GOTO 140
          IF(A(N+29).LT.0.)NI=-IABS(NI)
          IF(NI.NE.M)GOTO 138
 140      T=A(N+30)+A(I+30)
          P=ABS(U-A(I+20))
          IF(P.GT.T)GOTO 138
          P=P**2+(V-A(I+21))**2+(W-A(I+22))**2
          IF(P.GT.T**2)GOTO 138
          IF(P.LT.0.25)GOTO 138
C
C Generate bonded equivalent atom, assigning $n operator
C
          LE=LE+20
          IF(LE.GT.LM-19)GOTO 101
          NQ=LE
          CALL SXUS(A(N),KT)
          CALL SXPS(A(LE),KT)
          CALL SXPS(A(LE+1),'    ')
          A(LE+3)=REAL(N)+0.1
          NI=LE+5
            DO 141 NJ=K,K+8
            A(NI)=A(NJ)*A(L)
            NI=NI+1
 141        CONTINUE
          A(LE+14)=X-A(L)*(UU-A(K+9))
          A(LE+15)=Y-A(L)*(VV-A(K+10))
          A(LE+16)=Z-A(L)*(WW-A(K+11))
          A(LE+17)=X
          A(LE+18)=Y
          A(LE+19)=Z
          NI=LV-19
 142      NI=NI+20
          IF(NI.GE.LE)GOTO 144
          NT=LE+5
            DO 143 NJ=NI+5,NI+16
            IF(ABS(A(NT)-A(NJ)).GT.0.01)GOTO 142
            NT=NT+1
 143        CONTINUE
          CALL SXUS(A(NI+2),KT)
          CALL SXPS(A(LE+2),KT)
          A(LE+4)=A(NI+4)
          GOTO 135
 144        DO 145 NI=1,IM
            IF(C(NI).LT.0.5)GOTO 146
 145        CONTINUE
          CALL SXER('TOO MANY SYMMETRY OPERATORS GENERATED')
 146      IF(NI.GT.999)NI=999
          CALL SXPN(Q,NI)
          CALL SXUS(Q,KT)
          KS=IH(50)//KT(1:3)
          CALL SXPS(A(LE+2),KS)
          A(LE+4)=REAL(NI)
          C(NI)=REAL(LE)
          GOTO 135
 147      CONTINUE
 148    CONTINUE
      GOTO 130
C
C Reserve space for residue diagnostics table
C
 149  MN=LE+39
      LJ=LE+31+(LX-LB)/32
      NN=LJ+10
      IF(NN.GT.LM)GOTO 101
      N=LB-16
 150  N=N+32
      IF(N.GT.LX)GOTO 155
      MN=MN+1
      A(MN)=0.
      IF(INT(ABS(A(N+3))).EQ.KH)GOTO 150
      IF(A(N+31).LT.0.)GOTO 150
      CALL SXUS(A(N+1),KT)
      L=0
        DO 151 I=1,4
        IF(KT(I:I).GE.'0'.AND.KT(I:I).LE.'9')L=10*L+ICHAR(KT(I:I))-48
 151    CONTINUE
      IF(L.EQ.0)GOTO 150
      CALL SXUS(A(N),KT)
      I=INDEX(KT,'''')
      IF(I.EQ.0)I=INDEX(KT,'"')
      IF(I.NE.0)KT(I:I)=' '
      IF(KT.EQ.'N   '.OR.KT.EQ.'CA  '.OR.KT.EQ.'C   '.OR.KT.EQ.
     +'OXT '.OR.KT.EQ.'OT1 '.OR.KT.EQ.'OT2 ')L=-L
      IF(KT.NE.'O   ')GOTO 152
      CALL SXUS(A(N+2),KT)
      IF(KT.NE.'HOH '.AND.KT.NE.'H2O '.AND.KT.NE.'WAT ')L=-L
 152    DO 153 I=NN,LJ,10
        IF(INT(A(I)).NE.L)GOTO 153
        A(MN)=REAL(I)+0.1
        A(I+3)=A(I+3)+1.
        GOTO 150
 153    CONTINUE
      LJ=LJ+10
      IF(LJ+10.GT.LM)GOTO 101
      A(LJ)=1.000001*REAL(L)
        DO 154 I=LJ+1,LJ+9
        A(I)=0.
 154    CONTINUE
      A(LJ+7)=1.
      A(LJ+3)=1.
      A(MN)=REAL(LJ)+0.1
      CALL SXUS(A(N+2),KT)
      CALL SXPS(A(LJ+1),KT)
      GOTO 150
C
C Set up connectivity table
C
 155  CALL SXTO(21)
      LJ=LJ+10
      A(LJ)=0.
      N=LB-16
      IF(ABS(A(51)).LT.0.5)GOTO 157
      WRITE(LI,2)IT
        DO 156 I=LL+4,LB,16
        CALL SXUS(A(I+13),KS)
        WRITE(LI,3)KS,A(I+2)
 156    CONTINUE
      WRITE(LI,3)
 157  N=N+32
      IF(N.GT.LX)GOTO 185
      A(N+4)=0.
      IF(INT(ABS(A(N+3))).EQ.KH)GOTO 157
      IF(INT(A(N+5)).EQ.0)GOTO 157
      CALL SXCC
      NT=LJ
      M=INT(ABS(A(N+29)))
      R=A(N+30)
      U=A(N+20)
      V=A(N+21)
      W=A(N+22)
      I=LB-16
 158  I=I+32
      IF(I.GT.LX)GOTO 160
      IF(INT(ABS(A(I+3))).EQ.KH)GOTO 158
      IF(INT(A(I+5)).EQ.0)GOTO 158
      IF(M.EQ.0)GOTO 159
      NI=INT(ABS(A(I+29)))
      IF(NI.EQ.0)GOTO 159
      IF(NI.NE.M)GOTO 158
 159  T=R+A(I+30)
      P=ABS(U-A(I+20))
      IF(P.GT.T)GOTO 158
      P=P**2+(V-A(I+21))**2+(W-A(I+22))**2
      IF(P.GT.T**2)GOTO 158
      IF(P.LT.0.25)GOTO 158
      LJ=LJ+1
      IF(LJ.GT.LM)GOTO 101
      A(LJ)=REAL(I)
      GOTO 158
 160  I=LV-19
      U=A(N+17)
      V=A(N+18)
      W=A(N+19)
 161  I=I+20
      IF(I.GT.LE)GOTO 163
      K=INT(A(I+3))
      IF(INT(ABS(A(K+3))).EQ.KH)GOTO 161
      IF(INT(A(K+5)).EQ.0)GOTO 161
      T=(A(K+30)+R)**2
      IF(M.EQ.0)GOTO 162
      K=INT(A(K+29))
      IF(K.EQ.0)GOTO 162
      IF(A(N+29).LT.0.)GOTO 161
      IF(K.NE.M)GOTO 161
 162  P=U-A(I+17)
      Q=V-A(I+18)
      S=W-A(I+19)
      IF(A(8)*P**2+A(9)*Q**2+A(10)*S**2+A(11)*Q*S+A(12)*P*S+
     +A(13)*P*Q.GT.T)GOTO 161
      LJ=LJ+1
      IF(LJ.GT.LM)GOTO 101
      A(LJ)=REAL(I)
      GOTO 161
C
C Edit with BIND and FREE instructions
C
 163  JC=JA
 164  IF(JC.GE.JB)GOTO 171
      J=JC+1
      K=INT(B(JC)/64000.)
      JC=JC+INT(AMOD(B(JC),64000.))
      IF(K.LT.48)GOTO 164
      IF(K.GT.49)GOTO 164
 165  NI=INT(B(J))
      IF(NI.EQ.0)GOTO 170
      NJ=INT(B(J+1))
      IF(NJ.EQ.0)GOTO 170
      IF(NI.EQ.N)GOTO 166
      IF(NJ.NE.N)GOTO 170
      NJ=NI
 166  L=NT
 167  L=L+1
 168  IF(L.GT.LJ)GOTO 169
      IF(NJ.NE.INT(A(L)))GOTO 167
      IF(K.EQ.49)GOTO 170
      A(L)=A(LJ)
      LJ=LJ-1
      GOTO 168
 169  IF(K.EQ.48)GOTO 170
      LJ=LJ+1
      A(LJ)=REAL(NJ)
 170  J=J+2
      IF(J.LT.JC)GOTO 165
      GOTO 164
C
C Sort, prune and print connectivity
C
 171  A(N+4)=REAL(NT)
      KR=' '
      L=0
      CALL SXAN(N,KR,L,LM,A)
      L=L+2
      KR(L-1:L)=' -'
      IF(LJ.EQ.NT)GOTO 183
      NI=INT(A(N+5))
      IF(NI.EQ.0)GOTO 183
      NJ=NT
      M=0
 172  M=M+1
      NJ=NJ+1
      K=INT(A(NJ))
      P=A(K+17)-A(N+17)
      Q=A(K+18)-A(N+18)
      R=A(K+19)-A(N+19)
      FC(M)=A(8)*P**2+A(9)*Q**2+A(10)*R**2+A(11)*Q*R+
     +A(12)*P*R+A(13)*P*Q
      IF(NJ.LT.LJ)GOTO 172
      LJ=NT
      NJ=0
 173  NJ=NJ+1
      Q=9.E9
        DO 174 I=NJ,M
        IF(FC(I).GT.Q)GOTO 174
        Q=FC(I)
        K=I
 174    CONTINUE
      IF(Q.GT.8.E9)GOTO 175
      FC(K)=FC(NJ)
      LJ=LJ+1
      Q=A(LJ)
      I=NT+K
      A(LJ)=A(I)
      A(I)=Q
      IF(NJ.LT.NI)GOTO 173
C
C Transfer part numbers to AFIXed hydrogens if required
C
 175  IF(N.EQ.LX)GOTO 179
      NJ=INT(.1*ABS(A(N+38)))
      IF(NJ.EQ.0)GOTO 179
      IF(NJ.GT.16)GOTO 179
      IF(NJ.GT.11)GOTO 176
      IF(NJ.EQ.9)GOTO 176
      IF(NJ.EQ.8)GOTO 176
      IF(NJ.GT.4)GOTO 179
 176  IF(INT(A(N+61)).NE.0)GOTO 179
      T=9.E9
        DO 177 I=NT+1,LJ
        K=INT(A(I))
        IF(K.GT.LX)GOTO 177
        S=A(K+29)
        IF(S.GT.0.5)T=AMIN1(T,S)
 177    CONTINUE
      IF(T.GT.8.E9)GOTO 179
      K=N
 178  K=K+32
      IF(K.GT.LX)GOTO 179
      IF(INT(.1*ABS(A(K+6))).NE.NJ)GOTO 179
      IF(INT(A(K+29)).NE.0)GOTO 179
      A(K+29)=T
      GOTO 178
 179  IF(ABS(A(51)).LT.0.5)GOTO 182
      NJ=NT
 180  NJ=NJ+1
      IF(L.GT.107)GOTO 181
      L=L+1
      K=INT(A(NJ))
      CALL SXAN(K,KR,L,LM,A)
      IF(NJ.LT.LJ)GOTO 180
      WRITE(LI,3)KR(1:L)
      GOTO 182
 181  WRITE(LI,3)KR(1:L)//' etc.'
 182  IF(LJ.EQ.NT)GOTO 184
      A(LJ)=-A(LJ)
      GOTO 157
 183  IF(ABS(A(51)).GT.0.5)WRITE(LI,3)KR(1:L)//' no bonds found'
 184  A(N+4)=0.
      GOTO 157
C
C Print operators for generating equivalent atoms
C
 185  IF(ABS(A(51)).LT.0.5)GOTO 187
      IF(LE.LT.LV)GOTO 187
      WRITE(LI,4)
        DO 186 N=1,IM-1
        I=INT(C(N))
        IF(I.EQ.0)GOTO 186
        KR=' '
        CALL SXUS(A(I+2),KR(1:4))
        L=5
        CALL SXOP(KR,A(I+5),A(LY+12),L)
        WRITE(LI,3)KR(1:L)
 186    CONTINUE
      IF(C(IM).GT.0.5)WRITE(LI,3)'** etc. **'
 187  RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SX3E(LM,JW,LU,IM,MH,MK,MB,A,B,C)
C
C Further analysis of restraints
C
      CHARACTER*1 IH(50),KD
      CHARACTER*2 KA(94)
      CHARACTER*4 KS,KT,KX,KY,KZ
      CHARACTER*76 IT
      CHARACTER*80 NM,IR
      CHARACTER*128 KR
      INTEGER MH(LU),MK(LU),MB(LU)
      REAL A(LM),B(JW),C(IM)
      COMMON/MEM/ST,SL,TC,TL,IV,LR,LG,LH,LI,LP,LF,LA,LC,LW,LY,LL,LB,
     +LX,LE,LV,LJ,LD,LS,LO,LT,LK,LQ,LZ,LN,KH,JA,JB,JC,JD,JE,HA,HD
      COMMON/WORD/IH,IT,IR,NM,KA,KD
C
   1  FORMAT(1X,A,F6.3)
   2  FORMAT(//' Following 1,2- or 1,3-distances involving ',
     +'residues not restrained'/)
   3  FORMAT(' ** Warning:',I6,
     +' distances involving residues not restrained **')
   4  FORMAT(///' Summary of restraints for ',A)
   5  FORMAT(1X,F8.4,A)
   6  FORMAT(//
     +' Atom, chiral volume, sigma and bonded atoms for CHIV'/)
   7  FORMAT(' ** Bad CHIV: ',A,' bonds to',A,' - ignored **')
   8  FORMAT(2F8.4)
   9  FORMAT(F10.4,F8.4)
  10  FORMAT(//' Distance, sigma and atom pairs for DFIX and DANG'/)
  11  FORMAT(//
     +' Sigma and equivalent (non)bonds for SAME, SADI and NCSY'/)
  12  FORMAT(//' Sigma and atoms for FLAT'/)
  13  FORMAT(//' c, sigma, c1, #fv1, c2, #fv2, ... for SUMP:',
     +'  c = c1*fv1 + c2*fv2 + ...'/)
  14  FORMAT(2F10.5,(5(F12.5,F6.0)))
  15  FORMAT(//' Sigma and atom pairs for non-crystallographic ',
     +'symmetry equal-U restraints'/)
  16  FORMAT(//' Sigma and atom pairs for delta-U (DELU) restraints'/)
  17  FORMAT(//
     +' Sigma and atom pairs for similar-Uij (SIMU) restraints'/)
  18  FORMAT(//' Sigma and atoms for isotropic restraints (ISOR)'/)
  19  FORMAT(' ** Warning:',I5,' bad CHIV instructions ignored **')
C
C Sort DFIX restraints
C
      JN=JB-5
      JC=JA
      CALL SXTO(21)
  20  IF(JC.GE.JB)GOTO 25
      J=JC
      NK=INT(B(J)/64000.)
      R=AMOD(B(J),64000.)
      JC=JC+INT(R)
      IF(NK.NE.50)GOTO 20
      B(J)=R
      R=B(J+1)+0.00001
      S=B(J+2)+SIGN(0.00001,B(J+2))
      J=J+3
      JD=JN+5
      JE=JN
      JG=JN+((JC-J)/2)*5
      JN=JG
      IF(JN+5.GT.JW)GOTO 29
  21  JD=JD-5
      IF(JD.LT.JB)GOTO 23
      IF(B(JD+1).GT.R)GOTO 21
      IF(B(JD+1).LT.R-.00002)GOTO 23
      IF(ABS(B(JD+2)).GT.ABS(S))GOTO 21
      GOTO 23
  22  B(JG+1)=B(JE+1)
      B(JG+2)=B(JE+2)
      B(JG+3)=B(JE+3)
      B(JG+4)=B(JE+4)
      JG=JG-5
      JE=JE-5
  23  IF(JE.GT.JD)GOTO 22
  24  JD=JD+5
      B(JD+1)=R-.00001
      B(JD+2)=S-SIGN(.00001,S)
      B(JD+3)=B(J)
      B(JD+4)=B(J+1)
      J=J+2
      IF(J.LT.JC)GOTO 24
      GOTO 20
  25  JC=JB
  26  IF(JC.GT.JN)GOTO 32
      J=JB+1
      R=B(JC+1)
      S=B(JC+2)
      B(J)=R
      B(J+1)=S
  27  J=J+2
      B(J)=B(JC+3)
      B(J+1)=B(JC+4)
      JC=JC+5
      IF(JC.GT.JN)GOTO 28
      IF(ABS(B(JC+1)-R).GT.0.00001)GOTO 28
      IF(ABS(ABS(B(JC+2))-ABS(S)).GT.0.00001)GOTO 28
      IF(J+2.LT.JB+LU)GOTO 27
  28  B(JB)=3200002.1+REAL(J-JB)
      JB=J+2
      B(JB)=0.
      GOTO 26
  29  I=28
      GOTO 31
  30  I=27
  31  CALL SXER('PROBLEM TOO LARGE - INCREASE DIMENSION OF ARRAY '
     +//IH(I))
C
C Analyse SAME and SADI restraints
C
  32  CALL SXTO(22)
      NT=0
      JN=JB+6
      JC=JA
  33  IF(JC.GE.JB)GOTO 66
      J=JC
      NK=INT(B(J)/64000.)
      JC=JC+INT(AMOD(B(J),64000.))
      IF(NK.NE.61)GOTO 37
      IF(JC-J.EQ.4)GOTO 33
      R=B(J+1)
  34  J=J+2
      IF(J.GE.JC)GOTO 33
      JF=J
      MJ=INT(B(J))
      NJ=INT(B(J+1))
      IF(NJ.GT.MJ)GOTO 35
      IF(NJ.EQ.MJ)GOTO 34
      M=NJ
      NJ=MJ
      MJ=M
  35  IF(MJ.EQ.0)GOTO 34
      JF=JF+2
      IF(JF.GE.JC-1)GOTO 34
      NN=INT(B(JF))
      NK=INT(B(JF+1))
      IF(NK.GT.NN)GOTO 36
      IF(NN.EQ.NK)GOTO 35
      M=NN
      NN=NK
      NK=M
  36  IF(IABS(MJ-NN)+IABS(NJ-NK).EQ.0)GOTO 35
      JN=JN+6
      IF(JN+5.GT.JW)GOTO 29
      B(JN)=R
      B(JN+1)=0.
      B(JN+2)=REAL(MJ)+0.1
      B(JN+3)=REAL(NJ)+0.1
      B(JN+4)=REAL(NN)+0.1
      B(JN+5)=REAL(NK)+0.1
      GOTO 35
  37  IF(NK.NE.51)GOTO 49
      B(J)=AMOD(B(J),64000.)
      J=J+3
      JE=J
      S=B(J-2)
      T=B(J-1)
      MM=INT(B(J))-32
      M=MM
  38  J=J+1
      IF(J.GE.JC)GOTO 33
  39  M=M+32
      IF(M.GT.LX)GOTO 33
      IF(KH.EQ.INT(ABS(A(M+3))))GOTO 39
      NI=INT(A(M+4))
      IF(NI.LE.0)GOTO 38
      NN=INT(B(J))
      IF(NN.EQ.0)GOTO 38
      JD=JE
      MJ=MM
  40  JD=JD+1
      IF(JD.GE.J)GOTO 38
  41  MJ=MJ+32
      IF(MJ.GE.M)GOTO 38
      IF(KH.EQ.INT(ABS(A(MJ+3))))GOTO 41
      NJ=INT(A(MJ+4))
      IF(NJ.LE.0)GOTO 38
      NK=INT(B(JD))
      IF(NK.EQ.0)GOTO 40
      IF(S.LT.1.E-6)GOTO 43
      R=S
      K=NI
  42  K=K+1
      IF(INT(ABS(A(K))).EQ.MJ)GOTO 46
      IF(A(K).GT.0.)GOTO 42
  43  IF(T.LT.1.E-6)GOTO 40
      R=T
      K=NI
  44  K=K+1
      I=INT(ABS(A(K)))
      L=NJ
  45  L=L+1
      IF(I.EQ.INT(ABS(A(L))))GOTO 46
      IF(A(L).GT.0.)GOTO 45
      IF(A(K).GT.0.)GOTO 44
      GOTO 40
  46  IF(INT(A(NK+29))*INT(A(NN+29)).EQ.0)GOTO 47
      IF(INT(A(NK+29)).NE.INT(A(NN+29)))GOTO 40
  47  IF(INT(A(M+29))*INT(A(MJ+29)).EQ.0)GOTO 48
      IF(INT(A(M+29)).NE.INT(A(MJ+29)))GOTO 40
  48  JN=JN+6
      IF(JN+5.GT.JW)GOTO 29
      B(JN)=R
      B(JN+1)=0.
      B(JN+2)=REAL(NK)+0.1
      B(JN+3)=REAL(NN)+0.1
      B(JN+4)=REAL(M)+0.1
      B(JN+5)=REAL(MJ)+0.1
      GOTO 40
C
C Add 1,4-distance restraints from NCSY
C
  49  IF(NK.NE.43)GOTO 33
      R=B(J+2)
      IF(R.LT.0.00001)GOTO 33
      CALL SXTO(30)
      J=J+3
      MM=INT(B(J-2))
      M=LB-16
  50  M=M+32
      IF(M.GT.LX)GOTO 51
      A(M+30)=0.
      GOTO 50
  51  J=J+1
      IF(J.GE.JC)GOTO 65
      M=INT(B(J))
      CALL SXUS(A(M),KX)
      CALL SXUS(A(M+1),KY)
      L=0
        DO 54 I=1,4
          DO 52 K=1,10
          IF(KY(I:I).EQ.IH(K))GOTO 53
  52      CONTINUE
        GOTO 54
  53    L=10*L+K-1
  54    CONTINUE
      CALL SXPN(X,L+MM)
      CALL SXUS(X,KY)
      I=LB-16
  55  I=I+32
      IF(I.GT.LX)GOTO 51
      CALL SXUS(A(I),KS)
      IF(KS.NE.KX)GOTO 55
      CALL SXUS(A(I+1),KS)
      IF(KS.NE.KY)GOTO 55
      A(M+30)=REAL(I)+0.1
      NI=INT(A(M+4))
      IF(NI.EQ.0)GOTO 51
      NN=NI
  56  NI=NI+1
      NJ=INT(ABS(A(NI)))
      IF(NJ.GT.LX)GOTO 64
      NJ=INT(A(NJ+4))
      IF(NJ.EQ.0)GOTO 64
  57  NJ=NJ+1
      NK=INT(ABS(A(NJ)))
      IF(NK.GT.LX)GOTO 63
      IF(NK.EQ.M)GOTO 63
      NK=INT(A(NK+4))
      IF(NK.EQ.0)GOTO 63
  58  NK=NK+1
      N=INT(ABS(A(NK)))
      IF(N.GT.LX)GOTO 62
      IF(N.EQ.M)GOTO 62
      IF(INT(A(N+30)).EQ.0)GOTO 62
      MJ=NN
  59  MJ=MJ+1
      MN=INT(ABS(A(MJ)))
      IF(N.EQ.MN)GOTO 62
      IF(MN.GT.LX)GOTO 61
      MN=INT(A(MN+4))
      IF(MN.EQ.0)GOTO 61
  60  MN=MN+1
      IF(N.EQ.INT(ABS(A(MN))))GOTO 62
      IF(A(MN).GT.0.)GOTO 60
  61  IF(A(MJ).GT.0.)GOTO 59
      JN=JN+6
      IF(JN+5.GT.JW)GOTO 29
      B(JN)=R
      B(JN+1)=0.
      B(JN+2)=REAL(M)+0.1
      B(JN+3)=REAL(N)+0.1
      B(JN+4)=A(M+30)
      B(JN+5)=A(N+30)
  62  IF(A(NK).GT.0.)GOTO 58
  63  IF(A(NJ).GT.0.)GOTO 57
  64  IF(A(NI).GT.0.)GOTO 56
      GOTO 51
  65  CALL SXTO(30)
      GOTO 33
C
C Eliminate superfluous restraints
C
  66  JM=JB+12
        DO 68 JK=JM,JN,6
        IF(B(JK+3).GT.B(JK+2))GOTO 67
        Q=B(JK+2)
        B(JK+2)=B(JK+3)
        B(JK+3)=Q
  67    IF(B(JK+5).GT.B(JK+4))GOTO 68
        Q=B(JK+4)
        B(JK+4)=B(JK+5)
        B(JK+5)=Q
  68    CONTINUE
      JK=JM-6
  69  JK=JK+6
  70  IF(JK.GT.JN)GOTO 72
      IF(ABS(B(JK+2)-B(JK+3)).LT.0.5)GOTO 71
      IF(ABS(B(JK+4)-B(JK+5)).LT.0.5)GOTO 71
      IF(ABS(B(JK+2)-B(JK+4)).GT.0.5)GOTO 69
      IF(ABS(B(JK+3)-B(JK+5)).GT.0.5)GOTO 69
  71  CALL SXCA(B(JN),B(JK),6)
      JN=JN-6
      GOTO 70
C
C Sort rest on sigma
C
  72  IF(JM.GT.JN)GOTO 89
      Q=9.E9
      CALL SXCC
        DO 73 JL=JM,JN,6
        IF(B(JL).LT.Q)Q=B(JL)
  73    CONTINUE
      Q=Q+1.E-6
      JK=JM-6
      JL=JN
  74  JK=JK+6
  75  IF(JK.GT.JL)GOTO 79
      IF(B(JK).LT.Q)GOTO 74
  76  IF(B(JL).LT.Q)GOTO 77
      JL=JL-6
      IF(JL.LT.JK)GOTO 79
      GOTO 76
  77    DO 78 JI=JL,JL+5
        T=B(JI)
        B(JI)=B(JK)
        B(JK)=T
        JK=JK+1
  78    CONTINUE
      JL=JL-6
      GOTO 75
C
C Collect equivalent bonds, eliminating duplicates
C
  79  J=JB+6
      B(J-5)=B(JM)
      CALL SXCA(B(JM+2),B(J-4),4)
      CALL SXSW(B(J-4),B(J-2),NT,LM,A)
      JL=JM
      JM=JM+6
  80  NI=0
  81  JL=JL+6
      IF(JL.GE.JK)GOTO 87
      JI=0
        DO 82 JF=JB+3,J-1,2
        IF(ABS(B(JF-1)-B(JL+2)).GT.0.2)GOTO 82
        IF(ABS(B(JF)-B(JL+3)).LT.0.2)GOTO 83
  82    CONTINUE
      JI=JL+3
  83    DO 84 JF=JB+3,J-1,2
        IF(ABS(B(JF-1)-B(JL+4)).GT.0.2)GOTO 84
        IF(ABS(B(JF)-B(JL+5)).LT.0.2)GOTO 85
  84    CONTINUE
      IF(JI.NE.0)GOTO 81
      JI=JL+5
  85  IF(JI.EQ.0)GOTO 86
      J=J+2
      B(J-2)=B(JI-1)
      B(J-1)=B(JI)
      CALL SXSW(B(JB+2),B(J-2),NT,LM,A)
      NI=1
  86  IF(JL.GT.JM)CALL SXCA(B(JM),B(JL),6)
      JM=JM+6
      GOTO 81
  87  IF(NI.EQ.0)GOTO 88
      JL=JM-6
      GOTO 80
  88  B(JB)=3264000.1+REAL(J-JB)
      IF(J.GT.JB+63998)CALL SXER('TOO MANY EQUIVALENT BONDS GENERATED'
     +//' BY SAME AND/OR SADI INSTRUCTIONS')
      JB=J
      B(JB)=0.
      IF(JM.LT.JK)GOTO 79
      GOTO 72
C
C Check if bonds involving residues restrained by DFIX or SAME/SADI
C
  89  IF(A(180).LT.-998.)GOTO 102
      CALL SXTO(24)
      NN=0
      L=0
      I=LB-16
  90  I=I+32
      IF(I.GT.LX)GOTO 101
      CALL SXUS(A(I+1),KS)
      IF(KS.EQ.'0   ')GOTO 90
      IF(INT(ABS(A(I+3))).EQ.KH)GOTO 90
      NI=INT(A(I+29))
      N=INT(A(I+4))
      IF(N.EQ.0)GOTO 90
      MM=0
  91  N=N+1
      K=INT(ABS(A(N)))
      IF(K.GT.LX)GOTO 94
      IF(INT(ABS(A(K+3))).EQ.KH)GOTO 94
      NJ=INT(A(K+29))
      IF(NI*NJ.NE.0.AND.NI.NE.NJ)GOTO 94
      MM=MIN0(MM+1,LU)
      MH(MM)=K
      IF(K.LT.I)MM=MM-1
      M=INT(A(K+4))
      IF(M.EQ.0)GOTO 94
  92  M=M+1
      NT=INT(ABS(A(M)))
      IF(NT.LE.I)GOTO 93
      IF(INT(ABS(A(NT+3))).EQ.KH)GOTO 93
      NJ=INT(A(NT+29))
      IF(NI*NJ.NE.0.AND.NI.NE.NJ)GOTO 93
      MM=MIN0(MM+1,LU)
      MH(MM)=NT
  93  IF(A(M).GT.0.)GOTO 92
  94  IF(A(N).GT.0.)GOTO 91
      IF(MM.EQ.0)GOTO 90
      JC=JA
  95  IF(JC.GE.JB)GOTO 99
      J=JC
      NK=INT(B(J)/64000.)
      JC=JC+INT(AMOD(B(J),64000.))
      IF(NK.EQ.51)GOTO 96
      J=J+1
      IF(NK.NE.50)GOTO 95
  96  J=J+2
      IF(J.GE.JC)GOTO 95
      M=INT(B(J))
      K=INT(B(J+1))
      IF(K.EQ.I)GOTO 97
      IF(M.NE.I)GOTO 96
      M=K
  97  K=0
  98  K=K+1
      IF(K.GT.MM)GOTO 96
      IF(MH(K).NE.M)GOTO 98
      MH(K)=MH(MM)
      K=K-1
      MM=MM-1
      IF(MM.EQ.0)GOTO 90
      GOTO 98
  99  IF(NN.EQ.0)WRITE(LI,2)
      NN=NN+MM
        DO 100 K=1,MM
        CALL SXAN(I,KR,L,LM,A)
        L=L+1
        KR(L:L)=' '
        CALL SXAN(MH(K),KR,L,LM,A)
        L=L+3
        KR(L-2:L)='   '
        IF(L.LT.99)GOTO 100
        WRITE(LI,1)KR(1:L-3)
        L=0
 100    CONTINUE
      GOTO 90
 101  IF(NN.EQ.0)GOTO 102
      WRITE(*,3)NN
      CALL SXFL
      IF(L.GT.0)WRITE(LI,1)KR(1:L-3)
C
C Flag dependent EXYZ atoms so that they are ignored by BOND and CONF
C
 102  N=LB-16
 103  N=N+32
      IF(N.GT.LX)GOTO 104
      A(N+5)=0.
      GOTO 103
 104  JC=JA
 105  IF(JC.GE.JB)GOTO 107
      J=JC
      NK=INT(B(J)/64000.)
      R=AMOD(B(J),64000.)
      JC=JC+INT(R)
      IF(NK.NE.45)GOTO 105
      JD=J+1
 106  JD=JD+1
      IF(JD.GE.JC)GOTO 105
      N=INT(B(JD))
      A(N+5)=2.
      GOTO 106
C
C Analyse BOND instructions
C
 107  LD=LJ+1
      CALL SXTO(5)
      A(LD)=0.
      MM=INT(A(158))
      N=LB-16
 108  N=N+32
      IF(N.GT.LX)GOTO 124
      IF(A(N+5).GT.1.)GOTO 108
      I=INT(ABS(A(N+3)))
      M=0
      L=INT(A(N+4))
      IF(L.GT.0)GOTO 109
      IF(I.EQ.KH)GOTO 108
      GOTO 110
 109  M=MIN0(M+1,IM)
      L=L+1
      C(M)=ABS(A(L))
      NJ=INT(C(M))
      IF(A(NJ+5).GT.1.)M=M-1
      IF(A(L).GT.0.)GOTO 109
 110  CALL SXCC
      IF(MM.EQ.0)GOTO 116
      IF(MM.EQ.1)GOTO 121
C
C Add bonds to hydrogen (free and AFIX'ed except m=12)
C
      NJ=1
      U=A(N+20)
      V=A(N+21)
      W=A(N+22)
      R=(A(I+2)+.82)**2
      I=LB-16
 111  I=I+32
      IF(I.GT.LX)GOTO 121
      IF(INT(ABS(A(I+3))).EQ.KH)GOTO 112
      NJ=1
      GOTO 111
 112  NI=INT(ABS(.1*A(I+6)))
      IF(NI.EQ.0)GOTO 113
      IF(NI.LT.5)GOTO 114
      IF(NI.EQ.8)GOTO 114
      IF(NI.EQ.9)GOTO 114
      IF(NI.GT.16)GOTO 113
      IF(NI.GT.11)GOTO 114
 113  NJ=1
      IF((U-A(I+20))**2+(V-A(I+21))**2+(W-A(I+22))**2.GT.R)GOTO 111
      GOTO 115
 114  IF(I.EQ.N+32)NJ=0
      IF(NJ.NE.0)GOTO 111
 115  M=MIN0(M+1,IM)
      C(M)=REAL(I)
      GOTO 111
C
C Add other bonds and store
C
 116  IF(M.EQ.0)GOTO 108
      JC=JA
      L=M
      M=0
      NI=0
 117  IF(JC.GE.JB)GOTO 121
      J=JC
      NK=INT(B(J)/64000.)
      JC=JC+INT(AMOD(B(J),64000.))
      IF(NK.NE.47)GOTO 117
      IF(M.EQ.L)GOTO 121
      JE=J
 118  J=J+1
      IF(J.GE.JC)GOTO 117
      IF(N.NE.INT(B(J)))GOTO 118
 119  JE=JE+1
      IF(JE.GE.JC)GOTO 117
      NJ=INT(B(JE))
      IF(NJ.EQ.N)GOTO 119
      I=M
 120  I=I+1
      IF(I.GT.L)GOTO 119
      IF(INT(C(I)).NE.NJ)GOTO 120
      M=M+1
      T=C(I)
      C(I)=C(M)
      C(M)=T
      GOTO 120
 121  IF(M.EQ.0)GOTO 108
      NI=LD
      A(LD+1)=REAL(N)
      LD=LD+2
        DO 123 I=1,M
        IF(LD+2*I.GE.LM)GOTO 30
        A(LD)=C(I)
        LD=LD+1
          DO 122 L=1,I
          A(LD)=0.
          LD=LD+1
          A(LD)=-1.
          LD=LD+1
 122      CONTINUE
 123    CONTINUE
      A(NI)=3008000.1+REAL(LD-NI)
      A(LD)=0.
      GOTO 108
C
C Generate all torsion angles (CONF without atom names)
C
 124  IF(A(128).LT.1.)GOTO 133
      NN=LB-16
 125  NN=NN+32
      IF(NN.GT.LX)GOTO 133
      IF(A(NN+5).GT.1.)GOTO 125
      L=INT(A(NN+4))
      IF(L.LE.0)GOTO 125
      MM=L
 126  L=L+1
      NK=INT(ABS(A(L)))
      IF(NK.GT.NN)GOTO 131
      IF(A(NK+5).GT.1.)GOTO 131
      M=MM
 127  M=M+1
      IF(M.EQ.L)GOTO 130
      NB=INT(ABS(A(M)))
      IF(A(NB+5).GT.1.)GOTO 130
      N=INT(A(NK+4))
      IF(N.LE.0)GOTO 131
 128  N=N+1
      NR=INT(ABS(A(N)))
      IF(NR.EQ.NN)GOTO 129
      IF(A(NR+5).GT.1.)GOTO 129
      IF(NR.EQ.NB)GOTO 129
      A(LD)=3328007.1
      LD=LD+7
      IF(LD.GT.LM)GOTO 30
      A(LD-6)=ABS(A(N))
      A(LD-5)=ABS(A(L))
      A(LD-4)=REAL(NN)+.1
      A(LD-3)=ABS(A(M))
      A(LD-2)=0.
      A(LD-1)=-1.
      A(LD)=0.
 129  IF(A(N).GT.0.)GOTO 128
 130  IF(A(M).GT.0.)GOTO 127
 131  IF(A(L).GT.0.)GOTO 126
      GOTO 125
 132  CALL SXER('TOO MANY ATOMS REFERENCED ON SINGLE INSTRUCTION')
C
C Add extra dummy MPLA instructions for FLAT
C
 133  JC=1
      JD=JB
 134  IF(JC.GE.JD)GOTO 136
      J=JC
      JE=INT(AMOD(B(J),64000.))
      JC=JC+JE
      IF(INT(B(J)/64000.).NE.55)GOTO 134
      IF(JB+JE.GT.JW)GOTO 29
      B(JB)=B(J)-64000.
      B(JB+1)=1.9-REAL(JE)
      JB=JB+2
        DO 135 JE=J+2,JC-1
        B(JB)=B(JE)
        JB=JB+1
 135    CONTINUE
      GOTO 134
 136  B(JB)=0.
C
C Scan restraints etc.
C
      LO=0
      NB=0
        DO 226 NN=43,60
        IF(NN.EQ.44)GOTO 226
        IF(NN.EQ.47)GOTO 226
        IF(NN.EQ.48)GOTO 226
        CALL SXTO(5)
        IF(NN.EQ.43)CALL SXTO(30)
        IF(NN.EQ.50)CALL SXTO(21)
        IF(NN.EQ.51)CALL SXTO(22)
        IF(NN.EQ.58)CALL SXTO(25)
        IF(NN.EQ.56)CALL SXTO(26)
        IF(NN.EQ.59)CALL SXTO(27)
        IF(NN.EQ.60)CALL SXTO(28)
        CALL SXCC
        NR=1
        IF(IABS(NN-53).LT.2)NR=0
        IF(NN.EQ.57)NR=0
        IF(ABS(A(51)).LT.1.5)NR=0
        MZ=LD
        LS=1-NR
        JC=1
 137    IF(JC.GE.JB)GOTO 217
        J=JC
        NK=INT(B(J)/64000.)
        RI=AMOD(B(J),64000.)
        JC=JC+INT(RI)
        IF(NK.NE.49)GOTO 138
        B(J)=RI
        GOTO 137
 138    IF(NK.EQ.28)NK=49
        IF(NK.NE.NN)GOTO 137
C
C Interpret DELU restraints - flag atoms involved
C
        IF(NN.NE.58)GOTO 158
        J=J+2
        JE=J
        S=AMIN1(99.,B(J-1))
        T=AMIN1(99.,B(J))
        I=LB-16
 139    I=I+32
        IF(I.GT.LX)GOTO 142
        A(I+28)=-1.
        IF(KH.EQ.INT(ABS(A(I+3))))GOTO 139
        IF(INT(A(I+4)).LE.0)GOTO 139
        IF(JE+2.GT.JC)GOTO 141
        J=JE
 140    J=J+1
        IF(J.GE.JC)GOTO 139
        K=INT(B(J))
        IF(K.NE.I)GOTO 140
 141    A(I+28)=0.1
        GOTO 139
C
C Generate corresponding 1,2- and 1,3-distances
C
 142    M=LD
        I=LB-16
 143    I=I+32
        IF(I.GT.LX)GOTO 152
        IF(A(I+28).LT.0.)GOTO 143
        A(I+28)=REAL(M)+0.1
        MM=INT(A(I+29))
        L=INT(A(I+4))
 144    L=L+1
        N=INT(ABS(A(L)))
        IF(N.GT.LX)GOTO 151
        IF(A(N+28).LT.0.)GOTO 151
        MA=INT(A(N+29))
        IF(MA.EQ.MM)GOTO 145
        IF(MA*MM.NE.0)GOTO 151
 145    IF(N.LE.I)GOTO 146
        IF(S.LT.0.0001)GOTO 146
        A(M)=3712004.1
        M=M+4
        IF(M.GT.LM)GOTO 30
        A(M-3)=S
        A(M-2)=REAL(I)
        A(M-1)=REAL(N)
 146    IF(T.LT.0.0001)GOTO 151
        K=INT(A(N+4))
        IF(K.EQ.0)GOTO 151
 147    K=K+1
        NI=INT(ABS(A(K)))
        IF(NI.LE.I)GOTO 150
        IF(NI.GT.LX)GOTO 150
        IF(A(NI+28).LT.0.)GOTO 150
        MC=INT(A(NI+29))
        IF(MC.EQ.MA)GOTO 148
        IF(MC*MA.NE.0)GOTO 150
 148    IF(MC.EQ.MM)GOTO 149
        IF(MC*MM.NE.0)GOTO 150
 149    M=M+4
        IF(M.GT.LM)GOTO 30
        A(M-3)=T
        A(M-2)=REAL(I)
        A(M-1)=REAL(NI)
 150    IF(A(K).GT.0.)GOTO 147
 151    IF(A(L).GT.0.)GOTO 144
        A(I+30)=REAL(M)-3.9
        GOTO 143
C
C Eliminate duplicate DELU restraints and store unique ones
C
 152    A(M)=0.
        N=MZ
 153    N=N+4
        IF(N.GT.LD)GOTO 155
        I=INT(A(N-2))
        NI=INT(A(I+28))
        IF(NI.LT.MZ)GOTO 153
        NJ=INT(A(I+30))
        K=INT(A(N-1))
          DO 154 I=NI,NJ,4
          IF(INT(A(I+3)).NE.K)GOTO 154
          A(N-3)=AMIN1(A(N-3),A(I+1))
          A(I+3)=-1.
 154      CONTINUE
        GOTO 153
 155    IF(N.GT.M)GOTO 157
        IF(A(N-1).LT.0.)GOTO 156
        A(LD)=3712004.1
        A(LD+1)=A(N-3)
        A(LD+2)=A(N-2)
        A(LD+3)=A(N-1)
        LD=LD+4
 156    N=N+4
        GOTO 155
 157    A(LD)=0.
        GOTO 137
C
C Interpret and copy CHIV restraints
C
 158    IF(NN.NE.56)GOTO 172
          DO 171 JE=J+3,JC-1
          I=INT(B(JE))
          IF(I.GT.LX)GOTO 167
          NI=INT(A(I+4))
          IF(NI.LE.0)GOTO 167
          MA=INT(ABS(A(I+29)))
          NK=MA
          NJ=0
 159      NJ=NJ+1
          L=INT(ABS(A(NI+NJ)))
          MH(NJ)=L
          IF(L.GT.LX)L=INT(A(L+3))
          MK(NJ)=INT(ABS(A(L+29)))
          NK=MAX0(NK,MK(NJ))
          IF(A(NI+NJ).GT.0.)GOTO 159
          IF(NJ.LT.3)GOTO 167
          K=-1
 160      K=K+1
          IF(K.GT.NK)GOTO 171
          IF(MA.NE.0.AND.MA.NE.K)GOTO 160
          M=0
            DO 162 L=1,NJ
            IF(MK(L).EQ.0)GOTO 161
            IF(MK(L).NE.K)GOTO 162
 161        M=M+1
            MB(M)=MH(L)
 162        CONTINUE
          IF(M.LT.3)GOTO 160
          IF(M.GT.3)GOTO 167
          CALL SXUS(A(MB(1)),KX)
          CALL SXUS(A(MB(2)),KY)
          CALL SXUS(A(MB(3)),KZ)
 163      IF(KY.GE.KX)GOTO 164
          L=MB(2)
          MB(2)=MB(1)
          MB(1)=L
          KT=KX
          KX=KY
          KY=KT
 164      IF(KZ.GE.KY)GOTO 165
          L=MB(3)
          MB(3)=MB(2)
          MB(2)=L
          KT=KZ
          KZ=KY
          KY=KT
          GOTO 163
 165      M=0
          CALL SXAN(I,KR,M,LM,A)
          WRITE(IR,9)B(J+1),B(J+2)
          KR(M+1:M+18)=IR(1:18)
          M=M+18
          A(LD)=3584007.1
          LD=LD+7
          IF(LD.GT.LM)GOTO 30
          A(LD-6)=B(J+1)
          A(LD-5)=B(J+2)
          A(LD-4)=REAL(I)
          N=LD-3
            DO 166 L=1,3
            A(N)=REAL(MB(L))+0.1
            N=N+1
            M=M+2
            KR(M-1:M)='  '
            CALL SXAN(MB(L),KR,M,LM,A)
 166        CONTINUE
          IF(NR.EQ.0)GOTO 160
          IF(LO.EQ.0)WRITE(LI,4)IT
          LO=1
          IF(LS.EQ.0)WRITE(LI,6)
          LS=1
          WRITE(LI,1)KR(1:M)
          GOTO 160
 167      IR=' no atoms'
          M=0
          CALL SXAN(I,KR,M,LM,A)
          K=9
          IF(NI.LE.0)GOTO 170
          IR=' '
          K=0
 168      NI=NI+1
          K=K+1
          IF(K.GT.65)GOTO 169
          CALL SXAN(IABS(INT(A(NI))),IR,K,LM,A)
          IF(A(NI).LE.0.)GOTO 170
          GOTO 168
 169      K=K+4
          IR(K-3:K)='etc.'
 170      WRITE(LI,7)KR(1:M),IR(1:K)
          NB=NB+1
 171      CONTINUE
        GOTO 137
C
C Interpret and copy unique SIMU restraints
C
 172    IF(NN.NE.59)GOTO 181
        S=B(J+3)**2
        NJ=LB-16
 173    NJ=NJ+32
        IF(NJ.GT.LX)GOTO 174
        A(NJ+28)=-1.
        IF(KH.EQ.INT(ABS(A(NJ+3))))GOTO 173
        IF(JC.EQ.J+4)A(NJ+28)=1.
        GOTO 173
 174      DO 175 JE=J+4,JC-1
          N=INT(B(JE))
          A(N+28)=1.
 175      CONTINUE
        NJ=LB-16
 176    NJ=NJ+32
        IF(NJ.GT.LX)GOTO 137
        IF(A(NJ+28).LT.0.)GOTO 176
        T=AMIN1(99.,B(J+1))
        M=INT(A(NJ+4))
        IF(M.LE.0)GOTO 177
        IF(A(M+1).LT.0.)T=AMIN1(99.,B(J+2))
 177    X=A(NJ+20)
        Y=A(NJ+21)
        Z=A(NJ+22)
        NI=NJ
 178    NI=NI+32
        IF(NI.GT.LX)GOTO 176
        IF(A(NI+28).LT.0.)GOTO 178
        IF(S.LT.(X-A(NI+20))**2+(Y-A(NI+21))**2+(Z-A(NI+22))**2)
     +  GOTO 178
        R=T
        L=MZ
        M=INT(A(NI+4))
        IF(M.LE.0)GOTO 179
        IF(A(M+1).LT.0.)R=AMIN1(99.,B(J+2))
 179    IF(L.GE.LD)GOTO 180
        K=L+1
        L=L+4
        IF(INT(A(K+1)).NE.NJ)GOTO 179
        IF(INT(A(K+2)).NE.NI)GOTO 179
        A(K)=AMIN1(A(K),R)
        GOTO 178
 180    A(LD)=3776004.1
        LD=LD+4
        IF(LD.GT.LM)GOTO 30
        A(LD-3)=R
        A(LD-2)=REAL(NJ)
        A(LD-1)=REAL(NI)
        GOTO 178
C
C Generate SIMU restraints from NCSY for isotropic atoms only
C
 181    IF(NN.NE.43)GOTO 187
        J=J+3
        R=B(J)
        IF(R.LT.1.E-6)GOTO 137
        MM=INT(B(J-2))
 182    J=J+1
        IF(J.GE.JC)GOTO 137
        M=INT(B(J))
        IF(A(M+3).LT.0.)GOTO 182
        IF(A(M+6).LT.0.)GOTO 182
        CALL SXUS(A(M),KX)
        CALL SXUS(A(M+1),KY)
        L=0
          DO 185 I=1,4
            DO 183 K=1,10
            IF(KY(I:I).EQ.IH(K))GOTO 184
 183        CONTINUE
          GOTO 185
 184      L=10*L+K-1
 185      CONTINUE
        CALL SXPN(X,L+MM)
        CALL SXUS(X,KY)
        I=LB-16
 186    I=I+32
        IF(I.GT.LX)GOTO 182
        CALL SXUS(A(I),KS)
        IF(KS.NE.KX)GOTO 186
        CALL SXUS(A(I+1),KS)
        IF(KS.NE.KY)GOTO 186
        IF(A(I+3).LT.0.)GOTO 182
        IF(A(I+6).LT.0.)GOTO 182
        A(LD)=3776004.1
        LD=LD+4
        IF(LD.GT.LM)GOTO 30
        A(LD-3)=R
        A(LD-2)=REAL(M)
        A(LD-1)=REAL(I)
        GOTO 182
C
C Copy and print remaining restraints etc.
C
 187    K=LD
        JD=J+1
        IF(NR.EQ.0)GOTO 188
        IF(LO.EQ.0)WRITE(LI,4)IT
        LO=1
 188    IF(NN.EQ.60)GOTO 207
        L=JC-J
        MD=LD
        LD=LD+L
        IF(NN.EQ.52)LD=LD+2*(L-4)
        IF(NN.EQ.53)LD=LD+2
        IF(NN.EQ.54)LD=LD+2*L+4
        IF(LD.GT.LM)GOTO 30
        A(K)=64000.*REAL(NN)+REAL(LD-K)
        IF(LD.GT.K+63998)GOTO 132
        A(LD)=0.
        K=K+1
        IF(NN.NE.49)GOTO 189
        MJ=LD-1
        IF(NR.EQ.0)GOTO 205
        IF(LS.EQ.0)WRITE(LI,13)
        WRITE(LI,14)(B(JD),JD=J+1,JC-1)
        GOTO 205
 189    IF(NN.EQ.50)JD=JD+1
        IF(NR.EQ.0)GOTO 195
        IF(NN.NE.50)GOTO 190
        IF(LS.EQ.0)WRITE(LI,10)
        WRITE(KR,9)B(J+1),ABS(B(JD))
        L=17
        GOTO 191
 190    IF(NN.NE.51)GOTO 195
        IF(LS.EQ.0)WRITE(LI,11)
        WRITE(KR,8)B(JD)
        L=8
 191      DO 194 JE=JD+2,JC,2
          IR='   '
          M=0
            DO 192 JF=JE-1,JE
            M=M+3
            I=INT(B(JF))
            CALL SXAN(I,IR,M,LM,A)
            IR(M+1:M+3)=' - '
 192        CONTINUE
          IF(L+M.LT.120)GOTO 193
          WRITE(LI,1)KR(1:L)
          L=8
          IF(NN.EQ.50)L=17
          KR=' '
 193      KR(L+1:L+M)=IR(1:M)
          L=L+M
 194      CONTINUE
        WRITE(LI,1)KR(1:L)
        GOTO 205
 195    IF(NN.NE.52)GOTO 197
          DO 196 I=1,3
          J=J+1
          A(K)=B(J)
          K=K+1
 196      CONTINUE
        GOTO 199
 197    IF(NN.NE.54)GOTO 200
        J=J+1
        A(K)=B(J)
        IF(ABS(A(K)).LT.0.5)A(K)=REAL((LD-K-9)/3)+.1
        K=K+1
          DO 198 I=1,4
          A(K)=0.
          K=K+1
          A(K)=-1.
          K=K+1
 198      CONTINUE
 199    IF(K.GE.LD)GOTO 137
        J=J+1
        A(K)=B(J)
        A(K+1)=0.
        A(K+2)=-1.
        K=K+3
        GOTO 199
 200    IF(NN.NE.55)GOTO 203
        IF(NR.EQ.0)GOTO 205
        IF(LS.EQ.0)WRITE(LI,12)
        WRITE(KR,8)B(JD)
        KR(9:10)=' '
        L=10
          DO 202 JE=JD+1,JC-1
          IR=' '
          M=1
          I=INT(B(JE))
          CALL SXAN(I,IR,M,LM,A)
          IF(L+M.LT.116)GOTO 201
          WRITE(LI,1)KR(1:L)
          L=10
          KR=' '
 201      KR(L+1:L+M)=IR(1:M)
          L=L+M
 202      CONTINUE
        WRITE(LI,1)KR(1:L)
 203    IF(NN.NE.53)GOTO 205
        J=J+1
        CALL SXUS(B(J),KS)
        CALL SXPS(A(K),KS)
        A(K+1)=0.
        A(K+2)=-1.
        K=K+3
        IF(K.LT.LD-1)GOTO 205
        NI=INT(B(J+1))
        M=0
        CALL SXAN(NI,KR,M,LM,A)
        NI=INT(A(NI+4))
        IF(NI.LE.0)GOTO 204
        IF(A(NI+1).LT.0.)GOTO 204
        IF(A(NI+2).LT.0.)GOTO 204
        IF(A(NI+3).LT.0.)GOTO 205
 204    LD=MD
        A(LD)=0.
        GOTO 137
 205    LS=1
 206    IF(K.GE.LD)GOTO 137
        J=J+1
        A(K)=B(J)
        K=K+1
        GOTO 206
C
C Sort and print ISOR restraints
C
 207      DO 216 JF=JD,JD+1
          LD=K+1
          A(LD)=B(JF)
          WRITE(KR,8)B(JF)
          KR(9:10)='  '
          L=10
          I=LB-16
          JE=JD+1
 208      IF(JD.GE.JC-2)GOTO 209
          JE=JE+1
          IF(JE.GE.JC)GOTO 215
          I=INT(B(JE))
          GOTO 210
 209      I=I+32
          IF(I.GT.LX)GOTO 215
          IF(INT(ABS(A(I+3))).EQ.KH)GOTO 209
 210      IF(A(I+3).LT.0.)GOTO 211
          IF(A(I+6).GT.0.)GOTO 208
 211      M=INT(A(I+4))
          IF(M.LE.0)GOTO 712
          IF(A(M+1).GT.0.)GOTO 212
 712      IF(JF.EQ.JD)GOTO 208
          GOTO 213
 212      IF(JF.NE.JD)GOTO 208
 213      LD=LD+1
          IF(LD.GE.LM)GOTO 30
          A(LD)=REAL(I)
          IF(NR.EQ.0)GOTO 208
          IF(LS.EQ.0)WRITE(LI,18)
          LS=1
          IR=' '
          M=1
          CALL SXAN(I,IR,M,LM,A)
          IF(L+M.LT.120)GOTO 214
          WRITE(LI,1)KR(1:L)
          L=10
 214      KR(L+1:L+M)=IR(1:M)
          L=L+M
          GOTO 208
 215      IF(L.GT.10)WRITE(LI,1)KR(1:L)
          LD=LD+1
          A(LD)=0.
          A(K)=64000.*REAL(NN)+REAL(LD-K)
          IF(LD.GT.K+63998)GOTO 132
          K=LD
 216      CONTINUE
        GOTO 137
C
C Print DELU and SIMU restraints
C
 217    IF(NR.EQ.0)GOTO 226
        IF(NN.EQ.43)GOTO 218
        IF(NN.EQ.58)GOTO 218
        IF(NN.NE.59)GOTO 226
 218    R=99.9
        L=MZ
 219    IF(L.GE.LD)GOTO 220
        NJ=L+1
        L=L+4
        IF(A(NJ).LT.R)R=A(NJ)
        GOTO 219
 220    L=MZ
        IF(R.LT.99.8)GOTO 222
 221    IF(L.GE.LD)GOTO 226
        A(L+1)=AMOD(A(L+1),100.)
        L=L+4
        GOTO 221
 222    NI=0
        KR=' '
 223    IF(L.GE.LD)GOTO 225
        NJ=L+1
        L=L+4
        IF(ABS(A(NJ)-R).GT.1.E-4)GOTO 223
        A(NJ)=A(NJ)+100.
        IF(LO.EQ.0)WRITE(LI,4)IT
        LO=1
        IF(LS.NE.0)GOTO 224
        IF(NN.EQ.43)WRITE(LI,15)
        IF(NN.EQ.58)WRITE(LI,16)
        IF(NN.EQ.59)WRITE(LI,17)
        LS=1
 224    I=INT(A(NJ+1))
        NI=NI+3
        CALL SXAN(I,KR,NI,LM,A)
        I=INT(A(NJ+2))
        NI=NI+3
        KR(NI-2:NI)=' - '
        CALL SXAN(I,KR,NI,LM,A)
        IF(NI.LT.92)GOTO 223
        WRITE(LI,5)R,KR(1:NI)
        GOTO 222
 225    IF(NI.GT.0)WRITE(LI,5)R,KR(1:NI)
        GOTO 218
 226    CONTINUE
      CALL SXTO(5)
      IF(NB.GT.0)WRITE(*,19)NB
      CALL SXFL
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SX3F(LM,JW,LU,MH,MK,ML,MB,FF,SI,FC,SQ,WL,A,B)
C
C Read and sort reflection data
C
      CHARACTER*1 IH(50),KD
      CHARACTER*2 KA(94)
      CHARACTER*76 IT
      CHARACTER*80 NM,IR
      INTEGER MH(LU),MK(LU),ML(LU),MB(LU),IP(24)
      REAL FF(LU),SI(LU),FC(LU),SQ(LU),WL(LU),A(LM),B(JW)
      COMMON/MEM/ST,SL,TC,TL,IV,LR,LG,LH,LI,LP,LF,LA,LC,LW,LY,LL,LB,
     +LX,LE,LV,LJ,LD,LS,LO,LT,LK,LQ,LZ,LN,KH,JA,JB,JC,JD,JE,HA,HD
      COMMON/WORD/IH,IT,IR,NM,KA,KD
C
   1  FORMAT(' ** MERG code changed to 0 for compatibility with',
     +' HKLF and BASF parameters **')
   2  FORMAT(A)
   3  FORMAT(//' Floating origin restraints generated'/)
   4  FORMAT(20I4)
   5  FORMAT(I8)
   6  FORMAT(3I4,2F8.0,I4,F8.4)
   7  FORMAT(//'   h   k   l',7X,'Fo^2      Sigma',6X,'Why rejected'/)
   8  FORMAT(3I4,F12.2,F10.2,'     sin(theta) greater than 1')
   9  FORMAT(3I4,F12.2,F10.2,
     +'     observed but should be systematically absent')
  10  FORMAT(/' ** etc. **')
  11  FORMAT(/' Checksum O.K.')
  12  FORMAT(//I8,'  Reflections read, of which',I6,'  rejected'//
     +I4,' =< h =<',I3,',',I7,' =< k =<',I3,',',I7,' =< l =<',I3,
     +',   Max. 2-theta =',F8.2//I8,'  Systematic absence violations')
  13  FORMAT(/I8,'  Data suppressed,     R(sigma) =',F7.4//
     +' Maximum memory for data reduction =',I6,' /',I8)
  14  FORMAT(///' Inconsistent equivalents etc.'//'   h   k   l',
     +'      Fo^2   Sigma(Fo^2)  N  Esd of mean(Fo^2)'/)
  15  FORMAT(3I4,F12.2,F10.2,I5,F10.2)
  16  FORMAT(' Data:',I8,' unique,',I7,' suppressed   R(int) =',
     +F7.4,'   R(sigma) =',F7.4)
  17  FORMAT(' Systematic absence violations:',
     +I5,'    Bad equivalents:',I5)
  18  FORMAT(/I8,'  Inconsistent equivalents')
  19  FORMAT(/I8,'  Unique reflections, of which',I7,
     +'  suppressed'//' R(int) =',F7.4,'     R(sigma) =',F7.4,
     +'      Friedel opposites',A,'merged'//
     +' Maximum memory for data reduction =',I6,' /',I8/)
C
C Collect BASF parameters and set up HOPE
C
      CALL SXTO(6)
      NL=27
      L=LD
      IF(A(177).GT.0.5.AND.A(181).GT.0.5)LD=LD+9
      LS=LD
      JC=1
  20  IF(JC.GE.JA)GOTO 22
      J=JC+1
      K=INT(B(JC)/64000.)
      JC=JC+INT(AMOD(B(JC),64000.))
      IF(K.NE.6)GOTO 20
  21  IF(J.GE.JC)GOTO 20
      LS=LS+1
      IF(LS.GT.LM)GOTO 30
      A(LS)=B(J)
      J=J+1
      GOTO 21
  22  M=INT(ABS(A(181)))
      IF(M.EQ.0)GOTO 26
      M=M+LD
      IF(M.EQ.LS-11)GOTO 24
      IF(M.NE.LS+1)CALL SXER('INCOMPATIBLE BASF AND HOPE '//
     +'INSTRUCTIONS')
      IF(LS+12.GT.LM)GOTO 30
        DO 23 I=LS+1,LS+6
        A(I)=0.25
        A(I+6)=0.
  23    CONTINUE
      A(LS+4)=0.125*A(17)/SQRT(A(15)*A(16))
      A(LS+5)=0.125*A(18)/SQRT(A(14)*A(16))
      A(LS+6)=0.125*A(19)/SQRT(A(14)*A(15))
      LS=LS+12
  24  IF(L.EQ.LD)GOTO 26
      A(L)=3136009.1
      A(L+1)=0.75
      A(L+2)=0.001
      T=REAL(LV-LT)+A(181)+.1
        DO 25 I=L+3,L+7,2
        A(I)=1.
        A(I+1)=T
        T=T+1.
  25    CONTINUE
      A(LD)=0.
C
C Collect OMIT reflections
C
  26  LO=LS-2
      JC=1
  27  IF(JC.GE.JA)GOTO 31
      J=JC+1
      K=INT(B(JC)/64000.)
      JC=JC+INT(AMOD(B(JC),64000.))
      IF(K.NE.26)GOTO 27
  28  IF(J.GE.JC)GOTO 27
      LO=LO+3
      IF(LO.GT.LM)GOTO 30
      K=LO
        DO 29 I=1,3
        A(K)=B(J)
        K=K+1
        J=J+1
  29    CONTINUE
      GOTO 28
  30  CALL SXER('ARRAY '//IH(NL)//' TOO SMALL FOR THIS PROBLEM')
C
C Set up origin fixing restraints (Acta Cryst. A44 (1988) 499)
C
  31  CALL SXZA(A(145),10)
      IF(A(23).LT.0.5)GOTO 39
      IF(A(177).LT.0.5)GOTO 39
      S=12./REAL(LY-189)
      K=201
  32    DO 33 I=145,153
        A(I)=A(I)+S*A(K)
        K=K+1
  33    CONTINUE
      K=K+3
      IF(K.LE.LY)GOTO 32
      A(154)=A(145)+A(149)+A(153)
      IF(A(154).LT.0.01)GOTO 39
      NN=LB-16
  34  NN=NN+32
      IF(NN.GT.LX)GOTO 38
      IF(INT(ABS(A(NN+3))).EQ.KH)GOTO 34
      N=NN+6
        DO 37 I=1,3
        N=N+1
        IF(ABS(A(N)-10.).GT.5.)GOTO 37
        FF(1)=A(I+144)
        FF(2)=A(I+147)
        FF(3)=A(I+150)
        IF(ABS(FF(1)**2+FF(2)**2+FF(3)**2-1.).GT.0.01)GOTO 37
        M=145
          DO 36 K=1,3
            DO 35 L=1,3
            A(M)=A(M)-FF(K)*FF(L)
            M=M+1
  35        CONTINUE
  36      CONTINUE
        A(154)=A(145)+A(149)+A(153)
        IF(A(154).LT.0.01)GOTO 39
  37    CONTINUE
      GOTO 34
  38  WRITE(LI,3)
  39  CALL SXCC
C
C Check HKLF/TWIN/BASF combination and set MERG 0 if HKLF 5 or 6
C
      ND=LS
      IF(ABS(A(181)).GT.0.5)ND=ND-12
      IW=0
      RF=A(178)
      A(88)=0.
      A(89)=1.
      JC=JB
      T=A(46)
      M=INT(ABS(A(131)))
      IF(M.EQ.0)GOTO 141
      IF(M.GT.6)CALL SXER('UNKNOWN HKLF CODE')
      IF(INT(A(160)).EQ.0)GOTO 42
      IF(M.GT.4)GOTO 40
      IF(M.GT.2)GOTO 41
  40  CALL SXER('ILLEGAL TWIN/HKLF COMBINATION')
  41  IF(ND.EQ.LD)GOTO 43
      IF(INT(ABS(A(160))).NE.ND-LD+1)CALL SXER
     +('WRONG NUMBER OF BASF COEFFICIENTS FOR TWIN')
      GOTO 43
  42  IF(M.GT.4)GOTO 43
      IF(ND.GT.LD)A(46)=0.
  43  IF(M.LE.4)GOTO 45
      A(160)=-999.1
      IF(M.NE.6)GOTO 44
      IF(ND.NE.LD)CALL SXER('BASF CANNOT BE USED WITH HKLF 6')
  44  IF(M.NE.5)GOTO 45
      A(160)=1.01+REAL(ND-LD)
  45  IF(M.GT.4)A(46)=0.
      IF(LT.LT.LX+32)GOTO 46
      IF(M.NE.2)CALL SXER('LAUE REQUIRES HKLF 2')
  46  IF(A(131).LT.0.5)GOTO 48
  47  CLOSE(LR,STATUS='KEEP')
      LR=LR-1
      IF(LR.GE.LK)GOTO 47
      LR=LW
C
C Initialize reading of reflection data
C
  48  IF(A(46)+0.1.GT.T)GOTO 49
      WRITE(*,1)
      CALL SXFL
      WRITE(LI,2)
      WRITE(LI,1)
  49  MM=LY+12
      MT=MM
        DO 50 I=MM,LL,4
        IF(A(I).GT.0.)MT=I
        A(I+1)=A(I+1)-99.5
        A(I+2)=A(I+2)-99.5
        A(I+3)=A(I+3)-99.5
  50    CONTINUE
      MW=INT(ABS(A(160)))
      IF(A(46).GT.1.5)MW=0
      IF(M.LT.5)GOTO 51
      MW=9999
      IF(ND.GT.LD)MW=ND-LD+1
  51  LG=0
      NF=-2
      NU=0
      NI=0
      JE=0
      JF=0
      JG=0
      NB=0
      MB(LU)=0
        DO 52 I=82,86,2
        A(I)=999.
        A(I+100)=999.
        A(I+1)=-999.
        A(I+101)=-999.
  52    CONTINUE
      QA=AMIN1(A(49),A(50))
      QZ=AMAX1(A(49),A(50))
      RA=0.
      RB=.0001
      RC=0.
      RD=.0001
C
C Read and unpack condensed data
C
      IF(M.NE.1)GOTO 68
      NB=1
      UM=A(143)
      JI=0
      JK=0
  53  IR=' '
      READ(LR,2,END=63)IR
        DO 54 I=1,80
        IF(IR(I:I).LT.' ')IR(I:I)=' '
  54    CONTINUE
      IW=IW+1
      READ(IR,4,ERR=64)(IP(I),I=1,20)
      JK=MOD(JK,99)+1
      NJ=0
      GOTO 57
  55  X=1.
  56  UM=UM+X*ABS(REAL(IP(NJ)))
      UM=AINT(UM+SIGN(.3,UM))
  57  NJ=NJ+1
      X=100.
      IF(NJ.GT.20)GOTO 53
      JI=INT(AMOD(REAL(JI)+REAL(JK)*REAL(IP(NJ)),10000.))
      IF(IP(NJ).LT.0)GOTO 55
      IF(IP(NJ).GT.0)GOTO 60
      IF(20.GT.NJ)GOTO 59
      IR=' '
      READ(LR,2,END=63)IR
        DO 58 I=1,80
        IF(IR(I:I).LT.' ')IR(I:I)=' '
  58    CONTINUE
      IW=IW+1
      READ(IR,4,ERR=64)(IP(I),I=1,20)
      NJ=0
  59  NJ=NJ+1
      IF(IP(NJ).EQ.0)GOTO 103
      IF(IP(NJ).NE.JI)GOTO 63
      WRITE(LI,11)
      GOTO 103
  60  L=IP(NJ)/1000
      IF(L.LT.0)GOTO 55
      IF(L.EQ.0)GOTO 56
      UM=UM+REAL(L)
      L=MOD(IP(NJ)/100,10)-5
      Q=REAL(MOD(IP(NJ),100))*(10.**L)
      NJ=NJ+1
      IF(NJ.LT.21)GOTO 62
      IR=' '
      READ(LR,2,END=63)IR
        DO 61 I=1,80
        IF(IR(I:I).LT.' ')IR(I:I)=' '
  61    CONTINUE
      IW=IW+1
      READ(IR,4,ERR=64)(IP(I),I=1,20)
      JK=MOD(JK,99)+1
      NJ=1
  62  L=(IP(NJ)/1000)-4
      JI=INT(AMOD(REAL(JI)+REAL(JK)*REAL(IP(NJ)),10000.))
      T=REAL(MOD(IP(NJ),1000))*(10.**L)
      S=100.*T
      IF(Q.GT.0.)S=AMIN1(S,AMAX1(.001*T,1./Q))
      Q=ABS(UM)
      Z=AINT(.5+.0001*Q)
      X=(AINT(.5+Q)-10000.*Z)*.01
      Y=AINT(X+SIGN(.5,X+.1))
      X=AINT(101.*(X-Y))
      T=T*A(132)
      S=2.*T*A(132)*A(142)*SQRT(S)
      T=T**2
      WA=A(1)
      GOTO 73
C
C Report data format errors
C
  63  CALL SXER('BAD CONDENSED DATA')
  64  K=81
  65  K=K-1
      IF(K.LT.2)GOTO 66
      IF(IR(K:K).EQ.' ')GOTO 65
  66  IF(M.EQ.1)GOTO 67
      I=32
      IF(M.EQ.2)I=40
      IT='   1111222233334444444455555555666677777777'
      WRITE(LI,2)
      WRITE(LI,2)IT(1:I+3)
      WRITE(*,2)
      WRITE(*,2)IT(1:I+3)
      K=MIN0(I,K)
      WRITE(*,2)' >>'//IR(1:K)//'<< ??'
      CALL SXFL
  67  WRITE(LI,2)' >>'//IR(1:K)//'<< ??'
      WRITE(IT,5)IW
      CALL SXER('REFLECTION'//IT(1:8)//'  HAS WRONG FORMAT')
C
C Read h, k, l, F*F, sigma(F*F), batch no., possibly wavelength
C
  68  IF(M.EQ.1)GOTO 57
      IR=' '
      READ(LR,2,END=103)IR
        DO 69 I=1,80
        IF(IR(I:I).LT.' ')IR(I:I)=' '
  69    CONTINUE
      IW=IW+1
      READ(IR,6,ERR=64)N,K,L,T,S,NB,WA
      IF(IABS(N)+IABS(K)+IABS(L).EQ.0)GOTO 103
      IF(IR(4:4).EQ.' ')GOTO 64
      IF(IR(8:8).EQ.' ')GOTO 64
      IF(IR(12:12).EQ.' ')GOTO 64
      QR=1.
      IF(M.NE.2)WA=A(1)
      IF(WA.LT.1.E-4)CALL SXER('MISSING OR BAD WAVELENGTH(S)'
     +//' FOR LAUE DATA (HKLF 2)')
      IF(M.NE.5)GOTO 70
      IF(NB.EQ.0)GOTO 64
      IF(IABS(NB).GT.MW)GOTO 64
      A(160)=AMAX1(A(160),REAL(IABS(NB)))
  70  IF(M.GT.4)GOTO 71
      IF(NB.LT.0.AND.ABS(A(178)+1.).LT.0.1)QR=-1.
      NB=IABS(NB)
      IF(LD.EQ.ND)GOTO 71
      IF(INT(A(160)).NE.0)GOTO 71
      IF(NB-1.GT.ND-LD)GOTO 64
  71  IF(NB.EQ.0)NB=1
      T=T*A(132)
      S=ABS(S*A(132)*A(142))
      IF(M.NE.3)GOTO 72
      S=2.*AMAX1(.01,S)*ABS(AMAX1(.01,ABS(T),S))
      T=T**2
  72  IF(S.LT.1.E-4)S=.1
      X=REAL(N)
      Y=REAL(K)
      Z=REAL(L)
  73  CALL SXCC
      TT=T
C
C Reorientate and reject any resulting non-integer indices
C
      U=X*A(133)+Y*A(134)+Z*A(135)
      V=X*A(136)+Y*A(137)+Z*A(138)
      W=X*A(139)+Y*A(140)+Z*A(141)
      IF(ABS(AMOD(U+999.5,1.)-.5)+ABS(AMOD(V+999.5,1.)-.5)+
     +ABS(AMOD(W+999.5,1.)-.5).GT.0.01)GOTO 75
      X=SIGN(AINT(ABS(U)+.1),U+.1)
      Y=SIGN(AINT(ABS(V)+.1),V+.1)
      Z=SIGN(AINT(ABS(W)+.1),W+.1)
      NH=INT(X)
      NK=INT(Y)
      NL=INT(Z)
C
C Ignore entirely if outside SHEL or OMIT 2-theta limits
C
      Q=(A(14)*X**2+A(15)*Y**2+A(16)*Z**2+A(17)*Y*Z+
     +A(18)*X*Z+A(19)*X*Y)*(WA/A(1))**2
      IF(Q.LT.QA)GOTO 74
      IF(Q.GT.QZ)GOTO 74
      IF(Q.LE.A(53))GOTO 76
  74  IF(ABS(A(51)).LT.0.5)GOTO 75
      IF(Q.LT.1.)GOTO 75
      IF(NI.EQ.0)WRITE(LI,7)
      WRITE(LI,8)NH,NK,NL,TT,S
      NI=1
  75  JF=JF+1
      JG=JG+1
      GOTO 68
C
C Establish limiting input indices
C
  76  IF(A(82).GT.X)A(82)=X
      IF(A(83).LT.X)A(83)=X
      IF(A(84).GT.Y)A(84)=Y
      IF(A(85).LT.Y)A(85)=Y
      IF(A(86).GT.Z)A(86)=Z
      IF(A(87).LT.Z)A(87)=Z
C
C TWIN component generation
C
      IF(MW.EQ.0)GOTO 80
      IF(M.GT.4)GOTO 80
      XX=AINT(X)
      YY=AINT(Y)
      ZZ=AINT(Z)
      NW=MW
  77  IF(NW.LE.0)GOTO 68
      NB=-NW
      NW=NW-1
      NY=NW
      IF(NW.EQ.0)NB=-NB
      U=1.
      IF(A(160).GT.0.)GOTO 78
      IF(NW.LT.MW/2)GOTO 78
      NY=NW-MW/2
      U=-1.
  78  X=XX*U
      Y=YY*U
      Z=ZZ*U
        DO 79 I=1,NY
        U=X*A(161)+Y*A(162)+Z*A(163)
        V=X*A(164)+Y*A(165)+Z*A(166)
        W=X*A(167)+Y*A(168)+Z*A(169)
        X=U
        Y=V
        Z=W
  79    CONTINUE
      IF(ABS(AMOD(X+999.5,1.)-.5)+ABS(AMOD(Y+999.5,1.)-.5)+
     +ABS(AMOD(Z+999.5,1.)-.5).GT.0.01)GOTO 93
      X=AINT(SIGN(ABS(X)+.1,X+.1))
      Y=AINT(SIGN(ABS(Y)+.1,Y+.1))
      Z=AINT(SIGN(ABS(Z)+.1,Z+.1))
      IF(A(82).GT.X)A(82)=X
      IF(A(83).LT.X)A(83)=X
      IF(A(84).GT.Y)A(84)=Y
      IF(A(85).LT.Y)A(85)=Y
      IF(A(86).GT.Z)A(86)=Z
      IF(A(87).LT.Z)A(87)=Z
      NH=INT(X)
      NK=INT(Y)
      NL=INT(Z)
C
C Reject lattice absences
C
  80  I=MM
  81  I=I+4
      IF(I.GT.MT)GOTO 82
      IF(ABS(AMOD(X*A(I+1)+Y*A(I+2)+
     +Z*A(I+3)+999.5,1.)-.5).GT.0.01)GOTO 93
      GOTO 81
C
C Maximize indices (unless MERG 0)
C
  82  IF(A(46).LT.0.5)GOTO 89
      IF(A(46).GT.2.5)GOTO 83
      IF(A(23).GT.0.5)GOTO 84
  83  I=NL
      IF(I.EQ.0)I=NK
      IF(I.EQ.0)I=NH
      IF(I.GT.0)GOTO 84
      NH=-NH
      NK=-NK
      NL=-NL
  84    DO 88 K=201,LY,12
        IX=INT(1.001*(X*A(K)+Y*A(K+3)+Z*A(K+6)))
        IY=INT(1.001*(X*A(K+1)+Y*A(K+4)+Z*A(K+7)))
        IZ=INT(1.001*(X*A(K+2)+Y*A(K+5)+Z*A(K+8)))
        IF(A(46).GT.2.5)GOTO 85
        IF(A(23).GT.0.5)GOTO 86
  85    I=IZ
        IF(I.EQ.0)I=IY
        IF(I.EQ.0)I=IX
        IF(I.GT.0)GOTO 86
        IX=-IX
        IY=-IY
        IZ=-IZ
  86    IF(NL.GT.IZ)GOTO 88
        IF(NL.LT.IZ)GOTO 87
        IF(NK.GT.IY)GOTO 88
        IF(NK.LT.IY)GOTO 87
        IF(NH.GE.IX)GOTO 88
  87    NH=IX
        NK=IY
        NL=IZ
  88    CONTINUE
      X=REAL(NH)
      Y=REAL(NK)
      Z=REAL(NL)
C
C Reject systematic absences (unless twinned and MERG N > 1)
C
  89  IF(A(46).LT.1.5)GOTO 90
      IF(INT(A(160)).EQ.0)GOTO 90
      IF(ABS(A(161)+1.)+ABS(A(162))+ABS(A(163))+ABS(A(164))+
     +ABS(A(165)+1.)+ABS(A(166))+ABS(A(167))+ABS(A(168))+
     +ABS(A(169)+1.).GT.0.01)GOTO 94
  90  K=201
      MC=NL
      IF(MC.EQ.0)MC=NK
      IF(MC.EQ.0)MC=NH
  91  K=K+12
      IF(K.GT.LY)GOTO 94
      IX=INT(1.001*(X*A(K)+Y*A(K+3)+Z*A(K+6)))
      IY=INT(1.001*(X*A(K+1)+Y*A(K+4)+Z*A(K+7)))
      IZ=INT(1.001*(X*A(K+2)+Y*A(K+5)+Z*A(K+8)))
      IF(A(23).GT.0.5)GOTO 92
      I=IZ
      IF(I.EQ.0)I=IY
      IF(I.EQ.0)I=IX
      IF(I*MC.GT.0)GOTO 92
      IX=-IX
      IY=-IY
      IZ=-IZ
  92  IF(IABS(IX-NH)+IABS(IY-NK)+IABS(IZ-NL).NE.0)GOTO 91
      IF(ABS(AMOD(.5+ABS(X*A(K+9)+Y*A(K+10)+Z*A(K+11)),1.)-.5)
     +.LT.0.1)GOTO 91
C
C Lattice or systematically absent twinned or powder components
C
  93  IF(MW.EQ.0)GOTO 96
      IF(NB.LT.0)GOTO 102
      IF(LG.EQ.0)GOTO 96
      IF(MB(LG).GT.0)GOTO 96
      NH=MH(LG)
      NK=MK(LG)
      NL=ML(LG)
      NB=IABS(MB(LG))
      T=FF(LG)
      S=SI(LG)
      WA=ABS(WL(LG))
      Q=SQ(LG)*WA**2
C
C Omit if OMIT h k l and output first 50 systematic absence violations
C
  94  I=LS-2
  95  I=I+3
      IF(I.GT.LO)GOTO 99
      IF(ABS(X-A(I))+ABS(Y-A(I+1))+ABS(Z-A(I+2)).GT.0.5)GOTO 95
      GOTO 98
C
C Output first 50 significant bad systematic absences
C
  96  IF(T.LT.4.*S)GOTO 98
      NU=NU+1
      IF(ABS(A(51)).LT.0.5)GOTO 98
      IF(ABS(A(51)).GT.2.5)GOTO 97
      IF(NU.GT.50)GOTO 98
  97  IF(NI.EQ.0)WRITE(LI,7)
      WRITE(LI,9)NH,NK,NL,TT,S
      IF(ABS(A(51)).GT.2.5)GOTO 98
      IF(NU.EQ.50)WRITE(LI,10)
      NI=1
  98  JG=JG+1
      GOTO 102
C
C Establish limiting (maximized) h,k,l and sin(theta)
C
  99  IF(Q.GT.A(88))A(88)=Q
      IF(Q.LT.A(89))A(89)=Q
      IF(A(182).GT.X)A(182)=X
      IF(A(183).LT.X)A(183)=X
      IF(A(184).GT.Y)A(184)=Y
      IF(A(185).LT.Y)A(185)=Y
      IF(A(186).GT.Z)A(186)=Z
      IF(A(187).LT.Z)A(187)=Z
C
C OMIT threshold
C
      IF(A(46).GT.1.5)GOTO 101
      IF(NB.LT.0)GOTO 100
      U=A(52)
      IF(A(52).GT.0.)U=-1.
      T=AMAX1(T,U*S)
      IF(A(52).LE.0.)GOTO 100
      IF(T.GT.S*A(52))GOTO 100
      WA=-QR*ABS(WA)
      JE=JE+1
C
C Store data if no sort/merge required
C
 100  LG=LG+1
      IF(LG.GE.LU)CALL SXWF(RF,A(178),LU,MH,MK,ML,MB,FF,SI,SQ,WL)
      MH(LG)=NH
      MK(LG)=NK
      ML(LG)=NL
      MB(LG)=NB
      FF(LG)=T
      SI(LG)=S
      SQ(LG)=QR*Q/WA**2
      WL(LG)=QR*WA
      IF(NB.LT.0)GOTO 102
      RC=RC+S
      RD=RD+T
      GOTO 102
C
C Temporary data storage for subsequent sort/merge
C
 101  NF=NF+3
      MB(NF)=NH
      MB(NF+1)=NK
      MB(NF+2)=NL
      FF(NF)=T
      FF(NF+1)=S
      FF(NF+2)=QR*Q/WA**2
      IF(NF.LT.LU-5)GOTO 102
      WRITE(LA)MB,FF
      NF=-2
 102  IF(NB.GT.0)JF=JF+1
      IF(M.GT.4)GOTO 68
      IF(MW.GT.0)GOTO 77
      GOTO 68
C
C End of data - print limiting h,k,l etc.
C
 103  IF(A(88).GT.1.)A(88)=1.
      X=114.5916*ATAN2(SQRT(A(88)),SQRT(ABS(1.-A(88))))
      A(74)=AMIN1(X,A(74))
      WRITE(LI,12)JF,JG,(INT(A(I)),I=82,87),X,NU
      A(47)=REAL(JF-JG)
      IF(A(47).LT.0.5)CALL SXER('NO REFLECTION DATA')
        DO 104 NJ=MM,LL,4
        A(NJ+1)=A(NJ+1)+99.5
        A(NJ+2)=A(NJ+2)+99.5
        A(NJ+3)=A(NJ+3)+99.5
 104    CONTINUE
      IF(A(46).LT.1.5)GOTO 140
C
C Initialize sort/merge
C
      MW=INT(ABS(A(160)))
      MB(LU)=NF
      WRITE(LA)MB,FF
      REWIND LA
      NX=0
      NJ=0
      JF=0
      QH=A(183)-A(182)+1.
      QK=A(185)-A(184)+1.
      QL=.3
      QC=QL+.8-A(182)-QH*(A(184)+QK*A(186))
C
C Sort/merge reflection data
C
 105  QM=REAL(JW)+.3
      NT=0
      JB=INT(AMIN1(QC+A(183)+QH*(A(185)+QK*A(187)),QM))
      NF=0
      JA=1
 106    DO 107 J=JA,JB
        B(J)=0.
 107    CONTINUE
      IF(JC.LT.JB)JC=JB
 108  CALL SXCC
      READ(LA)MB,FC
      I=-2
      NZ=MB(LU)
      IF(NZ.EQ.0)NZ=LU-3
      GOTO 110
 109  NT=-1
 110  I=I+3
      IF(I.LE.NZ)GOTO 111
      IF(MB(LU).NE.0)GOTO 115
      GOTO 108
 111  Q=QC+QH*(REAL(MB(I+1))+QK*REAL(MB(I+2)))+REAL(MB(I))
      IF(Q.LT.QL)GOTO 110
      IF(Q.GT.QM)GOTO 109
      J=INT(Q)
      IF(NF.GT.0)GOTO 112
      B(J)=1.
      GOTO 110
 112  JD=INT(B(J))
      IF(NF.GT.1)GOTO 114
      W=AMAX1(FC(I)/FC(I+1),3.)/FC(I+1)
      B(JD)=REAL(MB(I))
      B(JD+1)=REAL(MB(I+1))
      B(JD+2)=REAL(MB(I+2))
      B(JD+3)=B(JD+3)+W
      B(JD+4)=B(JD+4)+W*FC(I)
      B(JD+5)=B(JD+5)+1.
      B(JD+6)=B(JD+6)+FC(I)
      IF(B(JD+5).GT.1.5)GOTO 113
      B(JD+7)=FC(I+2)
      GOTO 110
 113  B(JD+7)=AMAX1(B(JD+7),FC(I+2))
      GOTO 110
 114  B(JD+3)=B(JD+3)+ABS(FC(I)-B(JD+4))
      B(JD+6)=B(JD+6)+1./FC(I+1)**2
      GOTO 110
 115  REWIND LA
      IF(NF.GT.0)GOTO 119
      NF=1
      Q=.3
      JD=JA
        DO 116 J=JA,JB
        IF(B(J).LT.0.5)GOTO 116
        B(J)=Q
        Q=Q+8.
        IF(J+INT(Q).GT.JW)GOTO 117
        JD=J
 116    CONTINUE
      NT=NT+1
      Q=Q+8.
 117  QM=REAL(JD)+1.
        DO 118 J=JA,JB
        B(J)=B(J)+QM
 118    CONTINUE
      JA=JD+1
      QM=QM-.7
      JB=JD+INT(Q-8.)
      GOTO 106
 119  J=JA-8
      IF(NF.EQ.2)GOTO 122
 120  J=J+8
      IF(J.GT.JB)GOTO 121
      B(J+4)=B(J+4)/B(J+3)
      B(J+3)=0.
      IF(B(J+5).GT.1.5)RB=RB+B(J+6)
      B(J+6)=0.
      GOTO 120
 121  NF=2
      GOTO 108
C
C Eliminate OMIT hkl without comment
C
 122  J=J+8
      IF(J.GT.JB)GOTO 137
      NI=LS-2
 123  NI=NI+3
      IF(NI.GT.LO)GOTO 124
      IF(ABS(B(J)-A(NI))+ABS(B(J+1)-A(NI+1))+ABS(B(J+2)-A(NI+2))
     +.LT.0.5)GOTO 122
      GOTO 123
C
C Output inconsistent equivalents
C
 124  V=B(J+4)
      W=1./SQRT(B(J+6))
      IF(B(J+5).LT.1.5)GOTO 128
      RA=RA+B(J+3)
      P=B(J+3)/(B(J+5)*SQRT(B(J+5)-1.))
      IF(P.GT.5.*W)GOTO 125
      IF(ABS(A(51)).LT.2.5)GOTO 127
      GOTO 126
 125  NX=NX+1
      IF(NX.GT.50)GOTO 127
 126  IF(NJ.EQ.0)WRITE(LI,14)
      NJ=1
      WRITE(LI,15)INT(B(J)),INT(B(J+1)),INT(B(J+2)),V,W,INT(B(J+5)),P
      IF(NX.NE.50)GOTO 127
      IF(ABS(A(51)).LT.2.5)WRITE(LI,10)
 127  W=AMAX1(P,W)
C
C Generate twin components (if MERG N > 1)
C
 128  NW=MW
 129  NW=NW-1
      NY=NW
      Z=1.
      IF(A(160).GT.0.)GOTO 130
      IF(NW.LT.MW/2)GOTO 130
      NY=NW-MW/2
      Z=-1.
 130  X=B(J)*Z
      Y=B(J+1)*Z
      Z=B(J+2)*Z
      IF(INT(A(160)).EQ.0)GOTO 134
        DO 131 NI=1,NY
        XX=X*A(161)+Y*A(162)+Z*A(163)
        YY=X*A(164)+Y*A(165)+Z*A(166)
        ZZ=X*A(167)+Y*A(168)+Z*A(169)
        X=XX
        Y=YY
        Z=ZZ
 131    CONTINUE
C
C Systematic absence check on TWIN components
C
      NH=INT(X)
      NK=INT(Y)
      NL=INT(Z)
      MC=NL
      IF(MC.EQ.0)MC=NK
      IF(MC.EQ.0)MC=NH
      K=201
 132  K=K+12
      IF(K.GT.LY)GOTO 134
      IX=INT(1.001*(X*A(K)+Y*A(K+3)+Z*A(K+6)))
      IY=INT(1.001*(X*A(K+1)+Y*A(K+4)+Z*A(K+7)))
      IZ=INT(1.001*(X*A(K+2)+Y*A(K+5)+Z*A(K+8)))
      IF(A(23).GT.0.5)GOTO 133
      I=IZ
      IF(I.EQ.0)I=IY
      IF(I.EQ.0)I=IX
      IF(I*MC.GT.0)GOTO 133
      IX=-IX
      IY=-IY
      IZ=-IZ
 133  IF(IABS(IX-NH)+IABS(IY-NK)+IABS(IZ-NL).NE.0)GOTO 132
      IF(ABS(AMOD(.5+ABS(X*A(K+9)+Y*A(K+10)+Z*A(K+11)),1.)-.5)
     +.LT.0.1)GOTO 132
      IF(NW.GT.0)GOTO 129
      IF(LG.EQ.0)GOTO 122
      IF(MB(LG).GT.0)GOTO 122
      MB(LG)=-MB(LG)
      GOTO 135
 134  LG=LG+1
      IF(LG.GE.LU)CALL SXWF(RF,A(178),LU,MH,MK,ML,MB,FF,SI,SQ,WL)
      MH(LG)=INT(X)
      MK(LG)=INT(Y)
      ML(LG)=INT(Z)
      MB(LG)=-1-NW
      FF(LG)=V
      SI(LG)=W
      SQ(LG)=B(J+7)
      WL(LG)=SIGN(A(1),B(J+7))
      IF(NW.GT.0)GOTO 129
      MB(LG)=1
C
C Flag OMITted reflections
C
 135  U=A(52)
      IF(A(52).GT.0.)U=-1.
      V=AMAX1(V,U*W)
      FF(LG)=V
      IF(A(52).LE.0.)GOTO 136
      IF(V.GT.W*A(52))GOTO 136
      IF(WL(LG).LT.0.)GOTO 136
      WL(LG)=-ABS(WL(LG))
      JE=JE+1
 136  RC=RC+W
      RD=RD+V
      JF=JF+1
      GOTO 122
C
C Calculate and print R-indices etc.
C
 137  QC=QC-QM+QL
      IF(NT.LT.1)GOTO 105
      A(48)=RA/RB
      A(90)=RC/RD
      WRITE(*,16)JF,JE,A(48),A(90)
      WRITE(*,17)NU,NX
      CALL SXFL
      WRITE(LI,18)NX
      I=LO+2
      IF(A(46).GT.2.5)GOTO 138
      IF(A(23).GT.0.5)GOTO 139
 138  WRITE(LI,19)JF,JE,A(48),A(90),' ',I,JC
      GOTO 141
 139  WRITE(LI,19)JF,JE,A(48),A(90),' not ',I,JC
      GOTO 141
 140  A(90)=RC/RD
      A(48)=0.
      I=LO+2
      WRITE(LI,13)JE,A(90),I,JC
 141  CLOSE(LR,STATUS='KEEP')
      LG=LG+1
      IF(LG.GE.LU)CALL SXWF(RF,A(178),LU,MH,MK,ML,MB,FF,SI,SQ,WL)
      CALL SXWF(RF,A(178),LU,MH,MK,ML,MB,FF,SI,SQ,WL)
      REWIND LF
      CALL SXTO(7)
C
C Set up trig and Ueq coefficients
C
      P=A(14)*A(15)*A(16)
      Q=-2./A(1)**2
        DO 142 I=1,3
        Y=SQRT(P/A(I+13))*2.
        A(I+117)=A(I+16)/Y
        A(I+13)=Q*A(I+13)
        A(I+16)=Q*Y
        Y=1.74533E-2*A(I+4)
        FC(I)=SIN(Y)
        FC(I+3)=COS(Y)
 142    CONTINUE
      Q=1./(3.+6.*FC(4)*FC(5)*FC(6)-3.*(FC(4)**2+FC(5)**2+FC(6)**2))
      A(136)=Q*FC(1)**2
      A(137)=Q*FC(2)**2
      A(138)=Q*FC(3)**2
      A(139)=2.*Q*FC(2)*FC(3)*FC(4)
      A(140)=2.*Q*FC(3)*FC(1)*FC(5)
      A(141)=2.*Q*FC(1)*FC(2)*FC(6)
      A(171)=1./A(94)
      A(172)=-A(95)/(A(94)*A(97))
      A(173)=(A(95)*A(98)/A(97)-A(96))/(A(94)*A(99))
      A(174)=1./A(97)
      A(175)=-A(98)/(A(97)*A(99))
      A(176)=1./A(99)
C
C Calculate first twin factor
C
      A(168)=1.
        DO 143 I=LD+1,ND
        A(168)=A(168)-A(I)
 143    CONTINUE
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SX3G(LM,JW,LU,MH,MK,ML,MB,FF,SI,FC,SQ,WL,FB,A,B)
C
C Analyse constraints, set initial -CH3 and -OH hydrogens
C
      CHARACTER*1 IH(50),KD
      CHARACTER*2 KA(94)
      CHARACTER*4 KS,KT,KV(4)
      CHARACTER*25 KB(5)
      CHARACTER*76 IT
      CHARACTER*80 NM,IR
      INTEGER MH(LU),MK(LU),ML(LU),MB(LU),IP(24)
      REAL FF(LU),SI(LU),FC(LU),SQ(LU),WL(LU),FB(LU),A(LM),B(JW)
      COMMON/MEM/ST,SL,TC,TL,IV,LR,LG,LH,LI,LP,LF,LA,LC,LW,LY,LL,LB,
     +LX,LE,LV,LJ,LD,LS,LO,LT,LK,LQ,LZ,LN,KH,JA,JB,JC,JD,JE,HA,HD
      COMMON/WORD/IH,IT,IR,NM,KA,KD
C
   1  FORMAT(/' Special position constraints for ',A)
   2  FORMAT(1X,5A25)
   3  FORMAT(' Input constraints retained (at least in part) for ',4A)
   4  FORMAT(//' Default effective X-H distances for T =',F7.1,' C'
     +//' AFIX m =    1     2     3     4   4[N]  3[N]  15[B]  8[O]',
     +'   9   9[N]   16'/' d(X-H) =',11F6.2//' Note that these',
     +' distances are chosen to give the best fit to the X-ray data'/
     +' and so avoid the introduction of systematic error.  The true',
     +' internuclear'/' distances are longer and do not vary with',
     +' temperature !  The apparent'/' variation with temperature',
     +' is caused by libration.')
   5  FORMAT(//' Difference electron density (eA^-3x100) at 15 ',
     +'degree intervals for AFIX',I4,' group attached to ',A/
     +' The center of the range is eclipsed (cis) to ',A,
     +' and rotation is clockwise looking down ',A,' to ',A)
   6  FORMAT(1X,24I5)
   7  FORMAT(/'    Rho       x        y        z'/)
   8  FORMAT(F8.2,3F9.4)
   9  FORMAT(/' After local symmetry averaging: ',8I6)
  10  FORMAT('   ** Cell contents from UNIT instruction and atom ',
     +'list do not agree **')
  11  FORMAT(//' Unit-cell contents from UNIT instruction and',
     +' atom list resp.'/)
  12  FORMAT(1X,A4,2F10.2)
C
C Scan atom list and find atoms on special positions
C
      UQ=-9.E9
      NH=0
      NN=LB-16
  13  NN=NN+32
      IF(NN.GT.LX)GOTO 77
      L=INT(ABS(0.1*A(NN+6)))
      IF(L.GT.16)GOTO 14
      IF(L.GT.11)NH=1
      IF(L.GT.9)GOTO 14
      IF(L.EQ.0)GOTO 14
      IF(IABS(L-6).GT.1)NH=1
  14  NV=0
      NS=0
      NP=0
      N=NN+16
      IF(A(NN+3).GT.0.)N=NN+11
        DO 16 I=NN+7,N
        A(I+10)=A(I)
        M=INT((ABS(A(I))+5.)*.1)+LT
        IF(M.EQ.LT)GOTO 16
        IF(I.LT.NN+10)NP=1
        IF(I.GT.NN+10)NV=1
        IF(M.EQ.LT+1)GOTO 15
        IF(I.EQ.NN+10)NS=1
  15    R=SIGN(.5,A(I)+5.)
        A(I+10)=(AMOD(A(I)+5.,10.)-10.*R)*(R+A(M)-.5)
  16    CONTINUE
      IF(A(NN+3).GE.0.)GOTO 18
      UQ=0.
      M=NN+21
        DO 17 I=136,141
        UQ=UQ+A(I)*A(M)
        M=M+1
  17    CONTINUE
      GOTO 22
  18  IF(A(NN+11).LE.-5.)GOTO 20
      IF(A(NN+11).GE.-0.5)GOTO 20
      IF(UQ.GE.0.)GOTO 19
      I=0
      CALL SXAN(NN,IR,I,LM,A)
      CALL SXER('BAD Ueq DEPENDENCE FOR '//IR(1:I))
  19  A(NN+21)=ABS(A(NN+21))*UQ
      GOTO 21
  20  UQ=A(NN+21)
  21  IF(A(NN+6).GT.0.)GOTO 22
      NV=0
      A(NN+11)=A(NN+21)
  22  NJ=INT(.1*ABS(A(NN+6)))
      IF(NJ.EQ.0)GOTO 23
      IF(NJ.EQ.8)GOTO 13
      IF(NJ.EQ.9)GOTO 13
      IF(NJ.GT.16)GOTO 23
      IF(IABS(NJ-8).GT.3)GOTO 13
  23  IF(A(NN+27).LT.1.E-6)GOTO 13
      IF(A(NN+29).LT.0.)GOTO 13
      R=1.
      FC(1)=A(NN+17)
      FC(2)=A(NN+18)
      FC(3)=A(NN+19)
        DO 24 NJ=37,42
        FC(NJ)=REAL(NJ)
        FC(NJ+6)=1.
        FC(NJ+12)=0.
  24    CONTINUE
        DO 25 NJ=91,99
        FC(NJ)=9.E9
  25    CONTINUE
      M=189
  26  M=M+12
      IF(M.GT.LY)GOTO 51
      NL=LY+8
      IF(M.EQ.201)NL=NL+4
  27  NL=NL+4
      IF(NL.GT.LL)GOTO 26
      U=AMOD(A(NL+1)+A(NL)*(FC(1)*A(M)+FC(2)*A(M+1)+FC(3)*A(M+2)+
     +A(M+9))-FC(1),1.)-.5
      V=AMOD(A(NL+2)+A(NL)*(FC(1)*A(M+3)+FC(2)*A(M+4)+FC(3)*A(M+5)+
     +A(M+10))-FC(2),1.)-.5
      W=AMOD(A(NL+3)+A(NL)*(FC(1)*A(M+6)+FC(2)*A(M+7)+FC(3)*A(M+8)+
     +A(M+11))-FC(3),1.)-.5
      IF(A(8)*U**2+A(9)*V**2+A(10)*W**2+A(11)*V*W+A(12)*U*W+
     +A(13)*U*V.GT.A(NN+27)**2)GOTO 27
      R=R+1.
C
C Set up x,y,z constraints
C
        DO 34 I=1,3
        K=M+3*(I-1)
        L=M+I+8
        FC(4)=A(K)*A(NL)
        FC(5)=A(K+1)*A(NL)
        FC(6)=A(K+2)*A(NL)
        FC(I+3)=FC(I+3)-1.
        NJ=NL+I
        T=A(NL)*A(L)+A(NJ)
        T=AINT(FC(1)*FC(4)+FC(2)*FC(5)+FC(3)*FC(6)+T)-T+0.5
        N=4
        IF(ABS(FC(6)).GT.0.1)GOTO 30
        NJ=4
        IF(ABS(FC(5)).LT.0.1)GOTO 32
        NJ=5
        IF(ABS(FC(4)).LT.0.1)GOTO 33
        NT=91
  28    P=T/FC(NJ)
        Q=-FC(N)/FC(NJ)
        IF(FC(NT).LT.8.E9)GOTO 29
        FC(NT)=Q
        FC(NT+3)=P
        GOTO 34
  29    IF(ABS(FC(NT)-Q).LT.0.1)GOTO 34
        IF(FC(N+93).GT.8.E9)FC(N+93)=(P-FC(NT+3))/(FC(NT)-Q)
        IF(FC(NJ+93).GT.8.E9)FC(NJ+93)=Q*FC(N+93)+P
        GOTO 34
  30    NJ=6
        IF(ABS(FC(5)).LT.0.1)GOTO 31
        IF(ABS(FC(4)).GT.0.1)GOTO 34
        NT=93
        N=5
        GOTO 28
  31    NT=92
        IF(ABS(FC(4)).GT.0.1)GOTO 28
  32    IF(ABS(FC(NJ)).LT.0.1)GOTO 34
  33    FC(NJ+93)=T/FC(NJ)
  34    CONTINUE
      IF(A(NN+3).LT.0.)GOTO 35
      IF(A(NN+6).GT.0.)GOTO 27
  35  I=M
      N=55
        DO 36 K=1,6
        IF(K.EQ.6)I=M+3
        NJ=I
        IF(K.GT.3)NJ=NJ-3
        IF(K.EQ.5)NJ=I-6
        FC(N)=A(I)*A(NJ)
        FC(N+1)=A(I+1)*A(NJ+1)
        FC(N+2)=A(I+2)*A(NJ+2)
        FC(N+3)=A(I+1)*A(NJ+2)+A(I+2)*A(NJ+1)
        FC(N+4)=A(I)*A(NJ+2)+A(I+2)*A(NJ)
        FC(N+5)=A(I)*A(NJ+1)+A(I+1)*A(NJ)
        I=MIN0(M+6,I+3)
        N=N+6
  36    CONTINUE
        DO 37 K=55,90,7
        FC(K)=FC(K)-1.
  37    CONTINUE
C
C Solve Uij equations
C
  38  N=42
  39  K=INT(FC(N))
      IF(K.EQ.N)GOTO 41
      NJ=N
  40  NJ=NJ+1
      IF(NJ.GT.42)GOTO 41
      L=INT(FC(NJ))
      IF(L.NE.N)GOTO 40
      FC(NJ)=FC(N)
      FC(NJ+6)=FC(N+6)*FC(NJ+6)
      GOTO 40
  41  N=N-1
      IF(N.GT.36)GOTO 39
        DO 45 I=55,85,6
        L=I+5
        NJ=42
  42    IF(ABS(FC(L)).LT.0.01)GOTO 44
        K=INT(FC(NJ))
        IF(K.EQ.NJ)GOTO 44
        IF(K.EQ.0)GOTO 43
        K=L+K-NJ
        FC(K)=FC(K)+FC(NJ+6)*FC(L)
  43    FC(L)=0.
  44    L=L-1
        NJ=NJ-1
        IF(NJ.GT.36)GOTO 42
  45    CONTINUE
        DO 50 I=55,85,6
        K=0
        N=0
        L=I+5
          DO 47 NJ=I,L
          IF(ABS(FC(NJ)).LT.0.01)GOTO 47
          IF(K.EQ.0)GOTO 46
          IF(N.NE.0)GOTO 50
          N=NJ-I+37
          GOTO 47
  46      K=NJ-I+37
  47      CONTINUE
        IF(N.EQ.0)GOTO 48
        L=INT(FC(N))
        IF(L.EQ.0)GOTO 48
        IF(L.LT.K)GOTO 50
        FC(N)=REAL(K)
        FC(K+12)=1.
        L=N+I-37
        NJ=K+I-37
        FC(N+6)=-FC(NJ)/FC(L)
        GOTO 38
  48    IF(K.EQ.0)GOTO 50
  49    N=K
        K=INT(FC(N))
        FC(N)=0.
        IF(K.GT.0)GOTO 49
        GOTO 38
  50    CONTINUE
      GOTO 27
C
C Set up positional constraints
C
  51  IF(R.LT.1.5)GOTO 13
      CALL SXCC
      NT=0
      CALL SXAN(NN,IR,NT,LM,A)
      WRITE(LI,1)IR(1:NT)
      NT=0
      IF(FC(92).LT.8.E9)GOTO 52
      IF(FC(91)+FC(93).GT.8.E9)GOTO 52
      FC(96)=FC(96)+FC(93)*FC(94)
      FC(93)=FC(93)*FC(91)
  52  IF(FC(98).GT.8.E9)GOTO 53
      IF(FC(93).GT.8.E9)GOTO 53
      IF(FC(99).GT.8.E9)FC(99)=FC(93)*FC(98)+FC(96)
  53  IF(FC(97).GT.8.E9)GOTO 55
      IF(FC(92).GT.8.E9)GOTO 54
      IF(FC(99).GT.8.E9)FC(99)=FC(92)*FC(97)+FC(95)
  54  IF(FC(91).GT.8.E9)GOTO 55
      IF(FC(98).GT.8.E9)FC(98)=FC(91)*FC(97)+FC(94)
  55    DO 56 I=97,99
        IF(FC(I).GT.8.E9)GOTO 56
        NT=NT+1
        KB(NT)=' '
        WRITE(KB(NT),'(A1,A2,F8.4,14X)')IH(I-83),' =',FC(I)
        CALL SXLC(KB(NT)(1:1))
        NJ=I+NN-90
        IF(ABS(A(NJ)).GT.4.999)GOTO 56
        A(NJ)=100000.*(500.+FC(I))
  56    CONTINUE
      IF(FC(98).LT.8.E9)GOTO 58
      IF(FC(91).GT.8.E9)GOTO 58
      I=13
      IF(FC(94).LT.0.)I=12
      X=ABS(FC(94))
      NT=NT+1
      KB(NT)=' '
      WRITE(KB(NT),'(A3,F5.1,A5,A1,F7.4,4X)')'y =',FC(91),
     +' * x ',IH(I),X
      IF(ABS(A(NN+8)).GT.4.999)GOTO 58
      IF(ABS(FC(91)).LT.0.1)GOTO 57
      IF(ABS(A(NN+7)).GT.14.999)GOTO 59
  57  A(NN+8)=100000.*(510.+FC(94)+AINT(2.02*FC(91))*100.)
  58  IF(FC(99).LT.8.E9)GOTO 63
      IF(FC(92).GT.8.E9)GOTO 60
      L=92
      GOTO 61
  59  CALL SXER('LOCAL CONSTRAINTS CLASH WITH FREE VARIABLES')
  60  IF(FC(93).GT.8.E9)GOTO 63
      L=93
  61  I=13
      IF(FC(L+3).LT.0.)I=12
      X=ABS(FC(L+3))
      NT=NT+1
      KB(NT)=' '
      WRITE(KB(NT),'(A3,F5.1,A3,3A1,F7.4,4X)')'z =',FC(L),
     +' * ',IH(L-78),' ',IH(I),X
      CALL SXLC(KB(NT)(12:12))
      IF(ABS(A(NN+9)).GT.4.999)GOTO 63
      IF(ABS(FC(L)).LT.0.1)GOTO 62
      IF(ABS(A(NN+L-85)).GT.14.999)GOTO 59
  62  A(NN+9)=100000.*(510.+FC(L+3)+AINT(2.02*FC(L))*100.+
     +10.*REAL(L-92))
C
C Set up Uij constraints
C
  63  K=NN+11
        DO 69 N=37,42
        L=INT(FC(N))
        IF(L.EQ.N)GOTO 68
        I=11*(N-36)
        IF(N.EQ.40)I=23
        IF(N.EQ.41)I=13
        IF(N.EQ.42)I=12
        IF(L.GT.0)GOTO 65
        IF(NT.LT.5)GOTO 64
        WRITE(LI,2)KB
        NT=0
  64    NT=NT+1
        KB(NT)=' '
        WRITE(KB(NT),'(A1,I2,A4,18X)')'U',I,' = 0'
        IF(NV.GT.0)GOTO 68
        A(K)=5.E7
        GOTO 68
  65    L=L-36
        NJ=11*L
        IF(L.EQ.4)NJ=23
        IF(L.EQ.5)NJ=13
        IF(L.EQ.6)NJ=12
        IF(NT.LT.5)GOTO 66
        WRITE(LI,2)KB
        NT=0
  66    NT=NT+1
        KB(NT)=' '
        WRITE(KB(NT),'(A1,I2,A2,F4.1,A4,I2,10X)')'U',I,' =',
     +  FC(N+6),' * U',NJ
        IF(ABS(A(K)).GT.4.999)GOTO 68
        IF(ABS(FC(N+6)).LT.0.1)GOTO 67
        IF(ABS(A(NN+L+10)).GT.14.999)GOTO 59
  67    A(K)=1000000.*(REAL(L+4)+50.+AINT(2.02*FC(N+6))*10.)
  68    K=K+1
  69    CONTINUE
C
C Sof constraints
C
      R=1./R
      IF(NT.LT.5)GOTO 70
      WRITE(LI,2)KB
      NT=0
  70  NT=NT+1
      KB(NT)=' '
      WRITE(KB(NT),'(A5,F8.5,12X)')'sof =',R
      IF(ABS(A(NN+10)-11.).GT.0.0001)NS=1
      IF(NS.GT.0)GOTO 72
      A(NN+20)=R
      A(NN+10)=R+10.*AINT(.1*ABS(A(NN+10))+.5)
      IF(NN.EQ.LX)GOTO 72
      K=INT(ABS(.1*A(NN+38)))
      IF(K.EQ.0)GOTO 72
      N=NN
      P=.5*R
      IF(K.EQ.12)GOTO 71
      P=R
      IF(K.GT.15)GOTO 72
      IF(K.GT.11)GOTO 71
      IF(K.EQ.9)GOTO 71
      IF(K.EQ.8)GOTO 71
      IF(K.GT.4)GOTO 72
  71  N=N+32
      IF(N.GT.LX)GOTO 72
      IF(INT(ABS(.1*A(N+6))).NE.K)GOTO 72
      A(N+20)=R
      A(N+10)=A(NN+10)-R+P
      GOTO 71
  72  WRITE(LI,2)(KB(I),I=1,NT)
      NT=0
      IF(NP.EQ.0)GOTO 73
      NT=NT+1
      KV(NT)=' xyz'
  73  IF(NS.EQ.0)GOTO 74
      NT=NT+1
      KV(NT)=' sof'
  74  IF(NV.EQ.0)GOTO 75
      NT=NT+1
      KV(NT)=' Uij'
  75  IF(NT.LT.2)GOTO 76
      KV(NT+1)=KV(NT)
      KV(NT)=' and'
      NT=NT+1
  76  IF(NT.GT.0)WRITE(LI,3)(KV(I),I=1,NT)
      GOTO 13
C
C Set default X-H bond lengths depending upon temperature
C
  77  IF(NH.EQ.0)GOTO 79
      A(105)=.98
      A(106)=.97
      A(107)=.96
      A(108)=.93
      A(109)=.86
      A(110)=.89
      A(111)=1.10
      A(112)=.82
      A(113)=.93
      A(114)=.86
      T=0.
      IF(A(104).LT.-20.)T=.01
      IF(A(104).LT.-70.)T=.02
        DO 78 I=105,114
        A(I)=A(I)+T
  78    CONTINUE
      IF(ABS(A(51)).GT.0.5)WRITE(LI,4)(A(I),I=104,114),A(108)
C
C Sum unit-cell contents, check AFIX 13N and 14N
C
  79  CALL SXTO(8)
      MM=1+LU/5
      IF(INT(A(160)).NE.0)MM=LU-1
      R=A(24)*REAL(LY-189)/12.
      LO=LS-4
      NH=0
      NN=LB-16
  80  NN=NN+32
      IF(NN.GT.LX)GOTO 96
      A(NN+27)=-1.1
      L=INT(ABS(A(NN+3)))
      A(L+15)=A(L+15)+A(NN+20)*R
      M=INT(ABS(.1*A(NN+6)))
      IF(M.EQ.0)GOTO 81
      IF(M.GT.16)GOTO 81
      IF(M.EQ.14)GOTO 82
      IF(M.EQ.13)GOTO 82
      IF(M.EQ.11)GOTO 81
      IF(M.EQ.10)GOTO 81
      IF(M.GT.7)GOTO 80
      IF(M.LT.5)GOTO 80
  81  NH=NN
      IF(KH.NE.L)A(NH+27)=0.
      GOTO 80
  82  IF(NH.EQ.0)GOTO 84
      IF(A(NH+27).GT.0.5)GOTO 80
      IF(A(NH+27).LT.0.)GOTO 84
      N=INT(ABS(A(NH+4)))+1
      IF(N.LT.2)GOTO 83
      IF(A(N).LT.0.)GOTO 86
  83  NN=NH
  84  MN=0
      CALL SXAN(NN,IR,MN,LM,A)
  85  CALL SXER(IR(1:MN)//' NOT BONDED TO SUITABLE ATOM FOR AFIX')
  86  IF(ABS(A(NN+7))+ABS(A(NN+8))+ABS(A(NN+9)).GT.0.0001)GOTO 80
      N=INT(ABS(A(N)))
      MM=LU-1
      NL=27
      IF(LO+254.GT.LM)GOTO 95
      A(NH+27)=REAL(M)
      A(NH+28)=REAL(LO+5)
      A(NH+30)=0.
C
C Generate potential hydrogen sites for AFIX 13N and 14N
C
      X=.1234
      Y=.2839
      Z=.3099
      IF(N.GT.LX)GOTO 89
      L=INT(ABS(A(N+4)))+1
      IF(L.LT.2)GOTO 89
  87  I=INT(ABS(A(L)))
      IF(I.NE.NH)GOTO 88
      IF(A(L).LT.0.)GOTO 89
      L=L+1
      GOTO 87
  88  A(NH+30)=REAL(I)
      U=A(I+17)-A(N+17)
      V=A(I+18)-A(N+18)
      W=A(I+19)-A(N+19)
      IF(ABS(U)+ABS(V)+ABS(W).LT.0.001)GOTO 89
      X=U*A(94)+V*A(95)+W*A(96)
      Y=V*A(97)+W*A(98)
      Z=W*A(99)
  89  U=A(N+17)-A(NH+17)
      V=A(N+18)-A(NH+18)
      W=A(N+19)-A(NH+19)
      FC(1)=U*A(94)+V*A(95)+W*A(96)
      FC(2)=V*A(97)+W*A(98)
      FC(3)=W*A(99)
      FC(4)=FC(2)*Z-FC(3)*Y
      FC(5)=FC(3)*X-FC(1)*Z
      FC(6)=FC(1)*Y-FC(2)*X
      FC(7)=FC(3)*FC(5)-FC(2)*FC(6)
      FC(8)=FC(1)*FC(6)-FC(3)*FC(4)
      FC(9)=FC(2)*FC(4)-FC(1)*FC(5)
        DO 90 I=1,7,3
        FC(I+9)=SQRT(FC(I)**2+FC(I+1)**2+FC(I+2)**2)
  90    CONTINUE
        DO 91 I=1,3
        FC(I)=FC(I)/FC(10)
        FC(I+3)=FC(I+3)/FC(13)
        FC(I+6)=FC(I+6)/FC(16)
  91    CONTINUE
      T=10.*AMOD(ABS(A(NN+6)),1.)
      I=112
      IF(M.NE.13)GOTO 92
      I=107
      L=INT(ABS(A(NH+3)))
      CALL SXUS(A(L+13),KS)
      IF(KS(1:2).EQ.'N ')I=110
  92  IF(T.LT.0.02)T=A(I)
      IF(MOD(INT(ABS(A(NN+6))),10).NE.4)GOTO 93
      IF(ABS(A(NN+7))+ABS(A(NN+8))+ABS(A(NN+9)).LT.0.0001)GOTO 93
      Y=A(NN+18)-A(NH+18)
      Z=A(NN+19)-A(NH+19)
      X=A(94)*(A(NN+17)-A(NH+17))+A(95)*Y+A(96)*Z
      T=SQRT(X**2+(A(97)*Y+A(98)*Z)**2+(A(99)*Z)**2)
  93  P=0.942804*T
      Q=0.
      U=.965926
      V=.258819
      T=-0.333333*T
        DO 94 I=1,24
        LO=LO+5
        A(LO)=0.
        A(LO+1)=0.
        Z=(T*FC(3)+P*FC(9)+Q*FC(6))/A(99)
        Y=(T*FC(2)+P*FC(8)+Q*FC(5)-Z*A(98))/A(97)
        X=(T*FC(1)+P*FC(7)+Q*FC(4)-Y*A(95)-Z*A(96))/A(94)
        W=P*U-Q*V
        Q=P*V+Q*U
        P=W
        A(LO+2)=X+A(NH+17)
        A(LO+3)=Y+A(NH+18)
        A(LO+4)=Z+A(NH+19)
  94    CONTINUE
      GOTO 80
C
C Partition memory for vector Fc sums
C
  95  CALL SXER('ARRAY '//IH(NL)//' TOO SMALL FOR THIS PROBLEM')
  96  IF(LO.GT.LS-4)GOTO 97
      IF(ABS(A(75)-1.).GT.0.00001)GOTO 116
  97  U=0.
      V=0.
      W=0.
      JM=MM
      JK=(LB-LL+12)/8+13
      NL=28
      IF(JM*JK.GT.JW)GOTO 95
      JU=1
      JV=JU+JM
      JE=JV+JM
      JX=JE+JM
      JY=JX+JM
      JZ=JY+JM
      JT=JZ+JM
      JH=JT+JM
      JK=JH+JM
      JL=JK+JM
      JP=JL+JM
      JQ=JP+JM
      J5=JQ+JM
C
C Read reflection data block and calculate sfacs for each element
C
  98  READ(LF)MB,MH,MK,ML,FF,SI,SQ,WL
      MN=MIN0(MM,MK(LU))
      IF(MN.EQ.0)GOTO 106
      CALL SXZA(B(JU),MN)
      CALL SXZA(B(JV),MN)
      JG=J5
      L=LL-12
  99  L=L+16
      IF(L.GT.LB)GOTO 100
      JF=JG+JM
      JG=JF+JM
      CALL SXVF(B(JF),B(JG),SQ,WL,L,MN,LM,A)
      GOTO 99
C
C Scan atoms and perform structure factor calculation for data block
C
 100  NN=LB-16
 101  NN=NN+32
      IF(NN.GT.LX)GOTO 103
      IF(A(NN+27).LT.-1.)GOTO 101
      IF(A(NN+31).LT.0.)GOTO 101
      CALL SXCC
      JG=(INT(ABS(A(NN+3)))+12-LL)/8
      JF=JQ+JG*JM
      JG=JF+JM
      CALL SXVH(B(JH),B(JK),B(JL),MH,MK,ML,MN)
      IF(A(NN+3).GE.0.)CALL SXVI(B(JE),SQ,A(NN+17),MN)
        DO 102 K=201,LY,12
        CALL SXVE(B(JX),B(JY),B(JZ),B(JT),B(JH),B(JK),B(JL),A(K),MN)
        IF(A(NN+3).LT.0.)CALL SXVA(B(JE),B(JX),B(JY),B(JZ),A(1),
     +  A(NN+17),MN)
        CALL SXVS(B(JU),B(JV),B(JX),B(JY),B(JZ),B(JT),B(JE),B(JF),
     +  B(JG),A(NN+17),A(23),MN)
 102    CONTINUE
      GOTO 101
 103  CALL SXVR(U,V,W,B(JU),B(JV),B(JP),B(JQ),FF,FC,SI,SQ,WL,
     +B(JH),B(JK),B(JL),MB,MH,MK,ML,MN,LM,A)
C
C Calculate difference electron density at hydrogen positions
C
      CALL SXCC
      CALL SXVH(B(JH),B(JK),B(JL),MH,MK,ML,MN)
        DO 105 I=LS+1,LO,5
          DO 104 K=201,LY,12
          CALL SXVE(B(JX),B(JY),B(JZ),B(JT),B(JH),B(JK),B(JL),A(K),MN)
          CALL SXVD(A(I),B(JX),B(JY),B(JZ),B(JT),B(JU),B(JV),B(JP),
     +    B(JQ),MN)
 104      CONTINUE
 105    CONTINUE
 106  IF(MB(LU).GT.0)GOTO 98
      REWIND LF
      T=V/AMAX1(1.E-8,W)
      IF(ABS(A(75)-1.).LT.0.00001)A(75)=T
      T=1./AMAX1(1.E-8,SQRT(T))
      NN=LB-16
C
C Locate maxima after local symmetry averaging
C
 107  NN=NN+32
      IF(NN.GT.LX)GOTO 116
      IF(A(NN+27).LT.0.5)GOTO 107
      M=INT(A(NN+27))
      N=INT(A(NN+28))
      NH=N+115
      L=0
      NI=LO+5
      A(NI+2)=A(NH+2)
      A(NI+3)=A(NH+3)
      A(NI+4)=A(NH+4)
        DO 108 K=N,NH,5
        A(K)=2.*(T*A(K)-A(K+1))/A(20)
        L=L+1
        IP(L)=INT(AMAX1(-9999.,AMIN1(9999.,100.*A(K))))
        NI=NI+5
        A(NI+2)=A(K+2)
        A(NI+3)=A(K+3)
        A(NI+4)=A(K+4)
 108    CONTINUE
      NI=NI+5
      A(NI+2)=A(N+2)
      A(NI+3)=A(N+3)
      A(NI+4)=A(N+4)
      IF(ABS(A(51)).LT.0.5)GOTO 111
      NI=0
      CALL SXAN(NN,IR,NI,LM,A)
      L=0
      K=INT(A(NN+30))
      KB(1)='no atom'
      IF(K.GT.0)CALL SXAN(K,KB(1),L,LM,A)
      IF(L.EQ.0)L=7
      NK=INT(A(NN+4))
      NK=INT(ABS(A(NK+1)))
      K=0
      CALL SXAN(NK,KB(2),K,LM,A)
      WRITE(LI,5)INT(ABS(A(NN+38))),IR(1:NI),KB(1)(1:L),
     +KB(2)(1:K),IR(1:NI)
      IF(ABS(A(51)).LT.1.5)GOTO 110
      WRITE(LI,7)
        DO 109 K=N,NH,5
        U=A(K)
        WRITE(LI,8)U,A(K+2),A(K+3),A(K+4)
 109    CONTINUE
      GOTO 111
 110  WRITE(LI,6)IP
 111  IF(M.EQ.13)NH=N+35
      NI=LO+5
      L=0
      U=-9.E9
        DO 112 K=N,NH,5
        Q=A(K)
        IF(M.EQ.13)Q=.333333*(Q+A(K+40)+A(K+80))
        L=L+1
        IP(L)=INT(AMAX1(-9999.,AMIN1(9999.,100.*Q)))
        NI=NI+5
        A(NI)=Q
        IF(Q.LT.U)GOTO 112
        U=Q
        NK=NI
 112    CONTINUE
      A(LO+5)=A(NI)
      A(NI+5)=A(LO+10)
      NJ=NK
      U=.5*(A(NK+5)-A(NK-5))/AMAX1(1.E-8,2.*A(NK)-A(NK-5)-A(NK+5))
      IF(ABS(A(51)).LT.0.5)GOTO 113
      IF(M.EQ.13)WRITE(LI,9)(IP(I),I=1,L)
C
C Circular interpolation to get hydrogen coordinates
C
 113    DO 115 L=1,3
        K=NJ+1
        IF(K.GT.LO+126)K=K-120
        NN=NN+32
          DO 114 I=NN+7,NN+9
          K=K+1
          A(I)=A(K)*(1.-U**2)+.5*U*(A(K+5)*(U+1.)+A(K-5)*(U-1.))
          A(I+10)=A(I)
 114      CONTINUE
        IF(M.EQ.14)GOTO 107
        NJ=NJ+40
 115    CONTINUE
      GOTO 107
C
C Geometric location of initial torsions for AFIX 3N, 8N and 12N
C
 116  MN=0
      NN=LB-16
      NS=-1
      IF(ABS(A(51)).LT.0.5)NS=0
 117  NN=NN+32
      IF(NN.GE.LX)GOTO 152
      Q=ABS(A(NN+6))
      NA=INT(Q)/10
      IF(NA.EQ.3)GOTO 119
      IF(IABS(NA-10).EQ.2)GOTO 119
      IF(NA.EQ.0)GOTO 118
      IF(NA.LT.5)GOTO 117
      IF(NA.EQ.9)GOTO 117
      IF(IABS(NA-14).LT.3)GOTO 117
 118  MA=NN
      IR=' '
      MN=0
      CALL SXAN(NN,IR,MN,LM,A)
      GOTO 117
 119  IF(MN.GT.0)GOTO 120
      CALL SXAN(NN,IR,MN,LM,A)
      CALL SXER('BAD AFIX FOR '//IR(1:MN))
 120  MM=NN
      IF(NA.NE.8)MM=NN+64
      IF(ABS(A(NN+7))+ABS(A(NN+8))+ABS(A(NN+9)).GT.0.0001)GOTO 151
      R=10.*AMOD(Q,1.)
      IF(R.GT.0.2)GOTO 121
      K=INT(ABS(A(NN+3)))
      CALL SXUS(A(K+13),KS)
      K=NA
      IF(K.EQ.12)K=3
      IF(KS(1:1).EQ.'N')K=6
      R=A(K+104)
 121  NH=INT(A(NN+29))
      L=INT(A(MA+29))
      I=NN
      IF(L.EQ.0)GOTO 122
      IF(L.NE.NH)GOTO 123
 122  I=I+32
      IF(I.GT.MM)GOTO 124
      IF(I.GT.LX)GOTO 123
      IF(INT(A(I+29)).NE.NH)GOTO 123
      IF(INT(ABS(A(I+6))).EQ.INT(Q))GOTO 122
 123  CALL SXER('UNSUITABLE AFIX HYDROGENS FOLLOW '//IR(1:MN))
C
C Identify bonded atoms
C
 124  L=INT(A(MA+4))
      IF(L.LE.0)GOTO 85
      NK=0
      NB=-4
 125  L=L+1
      M=INT(ABS(A(L)))
      IF(M.LT.NN)GOTO 126
      IF(M.LE.MM)GOTO 128
 126  IF(M.EQ.MA)GOTO 128
      K=M
      IF(M.LT.LV)GOTO 127
      IF(NH.LT.0)GOTO 128
      K=INT(A(M+3))
 127  I=INT(A(K+29))
      IF(I.EQ.0)GOTO 132
      IF(I.EQ.NH)GOTO 132
 128  IF(A(L).GT.0.)GOTO 125
      IF(NK.GT.0)GOTO 133
      IF(NB.LT.1)GOTO 85
      IF(NB.GT.1)GOTO 129
      NK=INT(FB(1))
      IF(NK.GT.LV)GOTO 85
      L=INT(A(NK+4))
      IF(L.GT.0)GOTO 125
      MN=0
      CALL SXAN(NK,IR,MN,LM,A)
      GOTO 85
 129  IT=' '
      K=0
      NI=-4
 130  NI=NI+5
      K=K+1
      CALL SXAN(INT(FB(NI)),IT,K,LM,A)
      IF(NI.GE.NB)GOTO 131
      IF(K.LT.67)GOTO 130
      IF(K.GT.72)K=72
      K=K+4
      IT(K-3:K)=' etc'
 131  CALL SXER('BAD AFIX CONNECTIVITY: '//IR(1:MN)//' BONDS TO'
     +//IT(1:K))
 132  X=A(M+17)-A(MA+17)
      Y=A(M+18)-A(MA+18)
      Z=A(M+19)-A(MA+19)
      NB=NB+5
      U=A(94)*X+A(95)*Y+A(96)*Z
      V=A(97)*Y+A(98)*Z
      W=A(99)*Z
      T=SQRT(U**2+V**2+W**2)
      IF(T.LT.0.01)GOTO 85
      FB(NB)=REAL(M)
      FB(NB+1)=U/T
      FB(NB+2)=V/T
      FB(NB+3)=W/T
      FB(NB+4)=T
      GOTO 128
C
C Find vector trans to first hydrogen
C
 133  IF(NB.LT.6)GOTO 85
      IF(NB.LT.11)GOTO 135
      M=INT(FB(6))
      IF(M.GT.LV)M=INT(A(M+3))
      M=INT(ABS(A(M+3)))
      CALL SXUS(A(M+13),KT)
      IF(KT.EQ.'C   ')GOTO 135
      M=INT(FB(11))
      IF(M.GT.LV)M=INT(A(M+3))
      M=INT(ABS(A(M+3)))
      CALL SXUS(A(M+13),KT)
      IF(KT.NE.'C   ')GOTO 135
        DO 134 M=6,10
        Q=FB(M)
        FB(M)=FB(M+5)
        FB(M+5)=Q
 134    CONTINUE
 135  XX=FB(3)*FB(9)-FB(4)*FB(8)
      YY=FB(4)*FB(7)-FB(2)*FB(9)
      ZZ=FB(2)*FB(8)-FB(3)*FB(7)
      U=FB(4)*YY-FB(3)*ZZ
      V=FB(2)*ZZ-FB(4)*XX
      W=FB(3)*XX-FB(2)*YY
      P=U**2+V**2+W**2
      IF(P.LT.0.01)GOTO 85
      Q=SQRT(P)
      X=-.942809*R/Q
      P=-.333333*R
      NI=13
      NJ=NI
C
C OH on aromatic ring etc.
C
      IF(NA.NE.8)GOTO 137
      IF(NB.NE.11)GOTO 137
      IF(INT(ABS(A(NK+6)))/10.EQ.1)GOTO 137
      IF(ABS(XX*FB(12)+YY*FB(13)+ZZ*FB(14))**2.GT.0.2*
     +SQRT(XX**2+YY**2+ZZ**2))GOTO 137
        DO 136 N=1,2
        NJ=NJ+3
        FB(NJ)=FB(2)*P+U*X
        FB(NJ+1)=FB(3)*P+V*X
        FB(NJ+2)=FB(4)*P+W*X
        X=-X
 136    CONTINUE
      GOTO 140
C
C Methyls (types 3 and 12) and OH (type 8)
C
 137  Z=XX**2+YY**2+ZZ**2
      IF(Z.LT.0.01)GOTO 85
      Z=-.816497*R/SQRT(Z)
      Y=.5*X
 138  NJ=NJ+3
      FB(NJ)=FB(2)*P+U*X
      FB(NJ+1)=FB(3)*P+V*X
      FB(NJ+2)=FB(4)*P+W*X
        DO 139 N=1,2
        NJ=NJ+3
        FB(NJ)=FB(2)*P+XX*Z-U*Y
        FB(NJ+1)=FB(3)*P+YY*Z-V*Y
        FB(NJ+2)=FB(4)*P+ZZ*Z-W*Y
        Z=-Z
 139    CONTINUE
      X=-X
      Y=-Y
      Z=-Z
      IF(NJ.EQ.31)GOTO 149
      IF(NA.EQ.12)GOTO 138
      IF(NA.EQ.3)GOTO 149
C
C Test for possible hydrogen bonds
C
 140  T=9.E9
        DO 148 N=16,NJ,3
        Z=3.*FB(N+2)/A(99)
        Y=(3.*FB(N+1)-A(98)*Z)/A(97)
        X=(3.*FB(N)-A(95)*Y-A(96)*Z)/A(94)+A(MA+17)
        Y=Y+A(MA+18)
        Z=Z+A(MA+19)
          DO 147 M=LB+16,LX,32
          K=INT(ABS(A(M+3)))
          CALL SXUS(A(K+13),KS)
          IF(KS.EQ.'N   ')GOTO 141
          IF(KS.EQ.'O   ')GOTO 141
          IF(KS.EQ.'F   ')GOTO 141
          IF(KS.NE.'CL  ')GOTO 147
 141        DO 146 K=201,LY,12
            XX=A(M+17)*A(K)+A(M+18)*A(K+1)+A(M+19)*A(K+2)+A(K+9)
            YY=A(M+17)*A(K+3)+A(M+18)*A(K+4)+A(M+19)*A(K+5)+A(K+10)
            ZZ=A(M+17)*A(K+6)+A(M+18)*A(K+7)+A(M+19)*A(K+8)+A(K+11)
              DO 145 L=LY+12,LL,4
              U=AMOD(A(L)*XX+A(L+1)-X,1.)-.5
              V=AMOD(A(L)*YY+A(L+2)-Y,1.)-.5
              W=AMOD(A(L)*ZZ+A(L+3)-Z,1.)-.5
              Q=A(8)*U**2+A(9)*V**2+A(10)*W**2+A(11)*V*W+
     +        A(12)*U*W+A(13)*U*V
              IF(Q.GT.T)GOTO 145
              NL=INT(A(M+4))
              IF(NL.LE.0)GOTO 143
 142          NL=NL+1
              I=INT(ABS(A(NL)))
              U=AMOD(A(L)*(A(I+17)*A(K)+A(I+18)*A(K+1)+A(I+19)*
     +        A(K+2)+A(K+9))+A(L+1)-X,1.)-.5
              V=AMOD(A(L)*(A(I+17)*A(K+3)+A(I+18)*A(K+4)+A(I+19)*
     +        A(K+5)+A(K+10))+A(L+2)-Y,1.)-.5
              W=AMOD(A(L)*(A(I+17)*A(K+6)+A(I+18)*A(K+7)+A(I+19)*
     +        A(K+8)+A(K+11))+A(L+3)-Z,1.)-.5
              IF(A(8)*U**2+A(9)*V**2+A(10)*W**2+A(11)*V*W+
     +        A(12)*U*W+A(13)*U*V.LT.Q)GOTO 145
              IF(A(NL).GT.0.)GOTO 142
 143          IF(M.EQ.LX)GOTO 144
              IF(KH.EQ.INT(ABS(A(M+36))))Q=Q+2.
              IF(Q.GT.T)GOTO 145
 144          T=Q
              NI=N-3
 145          CONTINUE
 146        CONTINUE
 147      CONTINUE
 148    CONTINUE
C
C Store H-atoms in crystal coordinates
C
 149    DO 150 I=NN,MM,32
        NI=NI+3
        Z=FB(NI+2)/A(99)
        Y=(FB(NI+1)-A(98)*Z)/A(97)
        X=(FB(NI)-A(95)*Y-A(96)*Z)/A(94)+A(MA+17)
        Y=Y+A(MA+18)
        Z=Z+A(MA+19)
        A(I+7)=X
        A(I+17)=X
        A(I+8)=Y
        A(I+18)=Y
        A(I+9)=Z
        A(I+19)=Z
        IF(MOD(INT(ABS(A(I+6))),5).EQ.0)A(I+6)=SIGN(.01,A(I+6))
 150    CONTINUE
 151  NN=MM
      GOTO 117
C
C Check/print cell contents
C
 152  X=0.
      I=LL-12
 153  I=I+16
      X=X+ABS(A(I+14)-A(I+15))
      IF(I.LT.LB)GOTO 153
      IF(X.LT.0.1)GOTO 154
      WRITE(LI,8)
      WRITE(LI,8)
      WRITE(LI,10)
      IF(A(74).GT.0.5)WRITE(*,10)
      CALL SXFL
      GOTO 155
 154  IF(ABS(A(51)).LT.1.5)GOTO 157
 155  WRITE(LI,11)
      I=LL-12
 156  I=I+16
      CALL SXUS(A(I+13),KS)
      WRITE(LI,12)KS,A(I+14),A(I+15)
      IF(I.LT.LB)GOTO 156
 157  A(40)=0.
      A(41)=9.E9
      A(126)=8.E9
      A(142)=0.
      A(166)=A(180)
      A(167)=A(181)
      LK=0
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SX3H(LM,JW,LU,IM,MH,MK,ML,MB,FF,SI,FC,SQ,WL,FB,A,B,C)
C
C Structure-factor and least-squares calculations
C
      CHARACTER*1 IH(50),KD
      CHARACTER*2 KA(94)
      CHARACTER*4 KS
      CHARACTER*76 IT
      CHARACTER*80 NM,IR,KQ
      INTEGER MH(LU),MK(LU),ML(LU),MB(LU),IX(9),IY(9),IZ(9),IU(7)
      REAL FF(LU),SI(LU),FC(LU),SQ(LU),WL(LU),FB(LU),A(LM),B(JW),C(IM)
      REAL DX(9),DY(9),DZ(9),DU(7),CG(9)
      COMMON/MEM/ST,SL,TC,TL,IV,LR,LG,LH,LI,LP,LF,LA,LC,LW,LY,LL,LB,
     +LX,LE,LV,LJ,LD,LS,LO,LT,LK,LQ,LZ,LN,KH,JA,JB,JC,JD,JE,HA,HD
      COMMON/WORD/IH,IT,IR,NM,KA,KD
C
   1  FORMAT(///' Idealized hydrogen atom generation before cycle',
     +I4//' Name     x       y       z    AFIX  d(X-H)  shift  ',
     +'Bonded to  Conformation determined by'/)
   2  FORMAT(I6)
   3  FORMAT(1X,A4,3F8.4,I5,2F8.3,3X,A)
   4  FORMAT(///1X,A//' ATOM           x         y         z',10X,
     +'sof',9X,'U11       U22       U33       U23       U13',7X,
     +'U12',8X,'Ueq'/)
   5  FORMAT(A)
   6  FORMAT('CRYST1',3F9.3,3F7.2)
   7  FORMAT('SCALE',I1,4X,3F10.6,F15.6)
   8  FORMAT('WGHT',6F12.6)
   9  FORMAT('EXTI',F12.6)
  10  FORMAT('BASF',7F10.5)
  11  FORMAT('FVAR',F14.5,6F10.5)
  12  FORMAT('AFIX',I4,F8.4)
  13  FORMAT(A4,I3,3F12.6,F12.5,2F11.5,' =')
  14  FORMAT(5X,4F11.5)
  15  FORMAT('ATOM  ',I5,' ',A4,14X,3F8.3,F6.3,F6.2)
  16  FORMAT(A10,3F10.5,2F12.5,5F10.5,F11.5)
  17  FORMAT(4F10.5,2F12.5,5F10.5,F11.5)
  18  FORMAT(40X,2F12.5,5F10.5,F11.5)
  19  FORMAT(//' Final Structure Factor Calculation for ',A//
     +' Total number of l.s. parameters =',I6,'     Maximum ',
     +'vector length =',I5,'      Memory required =',I7,' /',I8)
  20  FORMAT(//' Least-squares cycle',I4,'      Maximum ',
     +'vector length =',I5,'      Memory required =',I7,' /',I8)
  21  FORMAT(//I6,' l.s. parameters for cycle',I5,'  - use BLOC to',
     +' reduce number or redimension array B to at least',I8)
C
C Count L.S. cycles and flag atoms in current refinement BLOC
C
      CALL SXTO(9)
      IW=LS
      IF(A(167).LT.-0.5)IW=IW-12
      IB=LS
      IF(ABS(A(167)).GT.0.5)IB=IB-12
      KQ=' '
      MV=INT(ABS(A(177))+1.1)
      MP=INT(AMAX1(0.,A(178)))
      LK=LK+1
      IF(LX.LT.LB)CALL SXER('NO ATOMS FOR SFLS')
      NN=0
      MU=0
      NJ=0
      IF(LK.EQ.MV)GOTO 28
      IF(INT(A(103)).GT.0)GOTO 23
      N=LJ+1
  22  K=INT(A(N)/64000.)
      IF(K.EQ.0)GOTO 28
      M=N
      N=N+INT(AMOD(A(N),64000.))
      IF(K.NE.57)GOTO 22
      IF(INT(ABS(A(M+1)))+INT(ABS(A(M+2))).EQ.0)NJ=1
      GOTO 22
  23  NJ=MOD(LK-1,INT(A(103)))+1
      N=LJ+1
  24  K=INT(A(N)/64000.)
      IF(K.EQ.0)GOTO 27
      M=N
      N=N+INT(AMOD(A(N),64000.))
      IF(K.NE.57)GOTO 24
        DO 25 I=M+1,M+2
        NI=INT(A(I))
        IF(IABS(NI).NE.NJ)GOTO 25
        IF(MU*NI.LT.0)GOTO 26
        MU=NI
        NN=1
  25    CONTINUE
      GOTO 24
  26  MU=0
  27  NJ=NJ*NN
  28  T=.31
      IF(NJ.GT.0)T=.01
      NN=LB-16
  29  NN=NN+32
      IF(NN.GT.LX)GOTO 30
      A(NN+5)=T
      IF(A(NN+31).LT.0.)A(NN+5)=.01
      A(NN+31)=SIGN(.001+.01*AINT(AMOD(.1+100.*ABS(A(NN+31)),100.)),
     +A(NN+31))
      GOTO 29
  30  IF(NJ.LE.0)GOTO 35
      N=LJ+1
  31  K=INT(A(N)/64000.)
      IF(K.EQ.0)GOTO 35
      L=INT(AMOD(A(N),64000.))
      M=N
      N=N+L
      IF(K.NE.57)GOTO 31
        DO 34 I=M+1,M+2
        NI=INT(A(I))
        IF(IABS(NI).NE.NJ)GOTO 34
        NK=M+1
        NN=LB+16
        IF(L.EQ.3)GOTO 33
  32    NK=NK+1
        IF(NK.GE.N)GOTO 34
        NN=INT(A(NK))
        IF(NN.LE.0)GOTO 32
  33    S=AMOD(A(NN+5),0.2)
        T=A(NN+5)-S
        IF(NI.GT.0)S=.11
        IF(NI.LT.0)T=.2
        A(NN+5)=S+T
        NN=NN+32
        IF(NN.GT.LX)GOTO 34
        IF(L.EQ.3)GOTO 33
        IF(INT(ABS(A(NN+3))).EQ.KH)GOTO 33
        K=INT(AMOD(ABS(A(NN+6)),10.))
        IF(K.EQ.9)GOTO 32
        IF(K.EQ.6)GOTO 32
        IF(K.LT.3)GOTO 32
        GOTO 33
  34    CONTINUE
      GOTO 31
C
C Flag EXYZ and EADP conditions
C
  35  N=LJ+1
  36  K=INT(A(N)/64000.)
      IF(K.EQ.0)GOTO 43
      L=INT(AMOD(A(N),64000.))
      M=N
      N=N+L
      IF(L.LT.2)GOTO 36
      IF(K.NE.45)GOTO 40
      M=M+1
      L=INT(A(M))
      IF(A(L+5).LT.0.9)GOTO 39
      K=L
  37  KS='EXYZ'
  38  M=0
      CALL SXAN(K,IR,M,LM,A)
      CALL SXER('INCORRECT '//KS//' INVOLVING '//IR(1:M))
  39  M=M+1
      IF(M.GE.N)GOTO 36
      K=INT(A(M))
      IF(A(K+5).GT.0.9)GOTO 37
      IF(ABS(A(K+5)-A(L+5)).GT.0.05)GOTO 37
      A(K+5)=A(K+5)+REAL(L)
      IF(K.EQ.46)GOTO 39
      IF(INT(AMOD(ABS(A(K+6)),10.)).GT.2)GOTO 37
      GOTO 39
  40  IF(K.NE.46)GOTO 36
      M=M+1
      L=INT(A(M))
      IF(ABS(A(L+31)).LT.0.9)GOTO 42
      K=L
  41  KS='EADP'
      GOTO 38
  42  M=M+1
      IF(M.GE.N)GOTO 36
      K=INT(A(M))
      IF(ABS(A(K+31)).GT.0.999)GOTO 41
      IF(ABS(A(L+31)).GT.0.999)GOTO 41
      IF(ABS(AMOD(A(K+5),1.)-AMOD(A(L+5),1.)).GT.0.05)GOTO 41
      IF(A(K+3)*A(L+3).LT.0.)GOTO 41
      IF(A(K+6)*A(L+6).LT.0.)GOTO 41
      A(K+31)=SIGN(ABS(A(K+31))+REAL(L),A(K+31))
      GOTO 42
C
C Evaluate atom parameters and total number of variables
C
  43  A(168)=1.
      L=LS
      IF(ABS(A(167)).GT.0.5)L=L-12
        DO 44 I=LD+1,L
        A(168)=A(168)-A(I)
  44    CONTINUE
      UE=.05
      XX=.01
      YY=.01
      NP=LV-LT+IW-LD
      NN=LB-16
      NK=0
      MT=1
      NE=0
      IF(A(39).GT.-8.E9)NE=NP+1
      IF(NP.LT.NE)NP=NE
      IF(A(200).GT.-998.)NP=MAX0(NP,NE+1)
      MY=NP
  45  NN=NN+32
      IF(NN.GT.LX)GOTO 68
      N=NN+11
      IF(A(NN+3).LT.0.)N=N+5
      L=INT(AMOD(ABS(A(NN+6)),10.))
      IF(L.EQ.4)MY=MY+MT
      IF(L.EQ.6)MY=MY+3
      IF(L.EQ.7)MY=MY+MT
      IF(L.EQ.8)MY=MY+MT*2
      IF(L.EQ.9)MY=MY+4
      MT=1
      IF(L.EQ.4)MT=0
      IF(L.EQ.7)MT=0
      IF(L.EQ.8)MT=0
      NI=NN+7
      M=INT(A(NN+5))
      IF(M.EQ.0)GOTO 46
      NI=NN+10
      CALL SXCA(A(M+17),A(NN+17),3)
  46  M=INT(ABS(A(NN+31)))
      IF(M.EQ.0)GOTO 47
      N=NN+10
      CALL SXCA(A(M+21),A(NN+21),6)
  47    DO 52 I=NI,N
        IF(A(I).GE.1.E6)GOTO 48
        A(I+10)=A(I)
        M=INT((ABS(A(I))+5.)*.1)+LT
        IF(M.EQ.LT)GOTO 49
        R=SIGN(.5,A(I)+5.)
        A(I+10)=(AMOD(A(I)+5.,10.)-10.*R)*(R+A(M)-.5)
        GOTO 52
  48    M=MOD(INT(1.E-6*A(I)+.5),10)
        P=AINT(1.E-7*A(I)+.05)
        Q=AINT(48.1*(1.E-5*A(I)-10.*REAL(M)-100.*P))/48.
        P=P*.5-2.5
        M=M+NN+16
        A(I+10)=A(M)*P+Q
        GOTO 52
  49    IF(L.EQ.1)GOTO 52
        IF(I.GT.NN+9)GOTO 50
        IF(L.EQ.6)MY=MY+1
        IF(L.EQ.9)MY=MY+1
        IF(L.LT.3)MY=MY+1
        GOTO 52
  50    IF(L.EQ.2)GOTO 52
        IF(I.NE.NN+11)GOTO 51
        IF(ABS(A(I)+2.75).LT.2.25)GOTO 52
  51    MY=MY+1
  52    CONTINUE
      IF(A(NN+20).LT.1.E-6)A(NN+20)=1.E-6
C
C Set up Ueq and ANIS
C
      IF(A(NN+3).LT.0.)GOTO 57
      IF(ABS(A(NN+11)+2.75).GT.2.75)GOTO 53
      A(NN+21)=-A(NN+11)*UE
      GOTO 54
  53  UE=A(NN+21)
  54  A(NN+27)=A(NN+21)
      IF(LK.LE.MP)GOTO 59
      IF(A(NN+6).GE.0.)GOTO 59
      A(NN+6)=ABS(A(NN+6))
      A(NN+3)=-ABS(A(NN+3))
      M=INT(ABS(A(NN+31)))
      IF(M.EQ.0)GOTO 55
      CALL SXCA(A(M+21),A(NN+21),6)
      GOTO 59
  55  Q=A(NN+21)
      IF(ABS(A(NN+11)+2.75).LT.2.25)MY=MY+1
      A(NN+11)=Q
      A(NN+22)=Q
      A(NN+23)=Q
      A(NN+24)=Q*A(118)
      A(NN+25)=Q*A(119)
      A(NN+26)=Q*A(120)
      N=NN+16
        DO 56 I=NN+12,N
        IF(ABS(A(I)).GT.5.)GOTO 56
        A(I)=A(I+10)
        MY=MY+1
  56    CONTINUE
      GOTO 59
  57  UE=0.
      M=NN+21
        DO 58 I=136,141
        UE=UE+A(M)*A(I)
        M=M+1
  58    CONTINUE
      A(NN+27)=UE
C
C Count current l.s. variables and set refinement flags
C
  59  A(NN+28)=0.
      T=.01
      K=MOD(INT(ABS(A(NN+6))),10)
      IF(K.LT.3)GOTO 62
      IF(AMOD(A(NN+5),.2).GT.0.05)GOTO 60
      K=0
      YY=.01
      GOTO 65
  60  IF(K.EQ.9)T=.41
      IF(K.EQ.6)T=.31
      IF(T.GT.0.3)GOTO 62
      IF(K.NE.5)GOTO 63
      IF(XX.GT.1.)GOTO 61
      M=0
      CALL SXAN(NN,IR,M,LM,A)
      CALL SXER('NO PIVOT ATOM FOR RIGID GROUP CONTAINING '//IR(1:M))
  61  A(NN+28)=XX
  62  YY=REAL(NN)+.11
      GOTO 65
  63  IF(YY.GT.1.)GOTO 64
      M=0
      CALL SXAN(NN,IR,M,LM,A)
      CALL SXER(IR(1:M)//' CANNOT RIDE')
  64  A(NN+28)=YY
      IF(AMOD(YY,1.).LT.0.05)GOTO 65
      IF(K.GT.3)T=.11
      IF(K.EQ.8)T=.21
      S=T+.1
      IF(K.EQ.7)S=.41
      YY=REAL(NN)+.01
      A(NN+28)=AINT(A(NN+28))+S
  65  NP=NP+INT(10.*T)
      A(NN+30)=REAL(NP)+T
      IF(K.EQ.1)GOTO 45
      IF(T.GT.0.3)XX=REAL(NN)+T+.2
      L=NN+7
      M=NN+11
      IF(ABS(A(NN+11)+2.75).LT.2.25)M=NN+10
      IF(A(NN+3).LT.0.)M=NN+16
      T=AMOD(A(NN+5),1.)
      IF(AMOD(T,0.2).LT.0.05)L=NN+10
      IF(A(NN+5).GT.1.)L=NN+10
      IF(T.LT.0.15)M=NN+9
      IF(ABS(A(NN+31)).GT.1.)M=MIN0(M,NN+10)
      IF(K.EQ.2)M=NN+9
      IF(K.LT.3)GOTO 66
      IF(K.EQ.6)GOTO 66
      IF(K.NE.9)L=NN+10
  66  IF(L.GT.M)GOTO 45
        DO 67 I=L,M
        IF(ABS(A(I)).LT.5.)NP=NP+1
  67    CONTINUE
      GOTO 45
C
C Update coordinates for dependent atoms
C
  68  M=LV-19
  69  M=M+20
      IF(M.GT.LE)GOTO 70
      K=INT(A(M+3))
      A(M+17)=A(K+17)*A(M+5)+A(K+18)*A(M+6)+A(K+19)*A(M+7)+A(M+14)
      A(M+18)=A(K+17)*A(M+8)+A(K+18)*A(M+9)+A(K+19)*A(M+10)+A(M+15)
      A(M+19)=A(K+17)*A(M+11)+A(K+18)*A(M+12)+A(K+19)*A(M+13)+A(M+16)
      GOTO 69
C
C Set up idealized hydrogen atom generation
C
  70  IF(A(142).LT.-0.5)GOTO 119
      CALL SXTO(10)
      NN=LB-16
      NS=-1
      IF(ABS(A(51)).LT.0.5)NS=0
      IF(ABS(A(51)).GT.1.5)GOTO 71
      IF(LK.LT.MV)NS=0
  71  NN=NN+32
      IF(NN.GE.LX)GOTO 119
      IR=' '
      MN=0
      CALL SXAN(NN,IR,MN,LM,A)
      MA=NN
      K=INT(ABS(A(NN+6)))/10
      IF(K.EQ.0)GOTO 73
      IF(IABS(K-6).LT.2)GOTO 73
      IF(K.GT.16)GOTO 73
      IF(K.GT.11)GOTO 72
      IF(K.GT.9)GOTO 73
  72  CALL SXER('BAD AFIX FOR '//IR(1:MN))
  73  Q=ABS(A(MA+38))
      K=INT(Q)
      NA=K/10
      IF(NA.LT.1)GOTO 117
      IF(NA.GT.16)GOTO 117
      IF(NA.GT.11)GOTO 74
      IF(NA.GT.9)GOTO 117
      IF(IABS(NA-6).LT.2)GOTO 117
  74  MM=32*NA+MA
      IF(NA.GT.3)MM=MA+32
      IF(NA.EQ.9)MM=MA+64
      IF(NA.EQ.12)MM=MA+192
      IF(NA.EQ.13)MM=MA+96
      IF(MOD(K,10).EQ.5)GOTO 118
      R=10.*AMOD(Q,1.)
      IF(IABS(MOD(K,10)-6).NE.2)GOTO 75
      K=MA+32
      IF(ABS(A(K+7))+ABS(A(K+8))+ABS(A(K+9)).LT.0.0001)GOTO 75
      Y=A(K+18)-A(NN+18)
      Z=A(K+19)-A(NN+19)
      U=A(94)*(A(K+17)-A(NN+17))+A(95)*Y+A(96)*Z
      R=SQRT(U**2+(A(97)*Y+A(98)*Z)**2+(A(99)*Z)**2)
  75  IF(R.GT.0.2)GOTO 76
      NQ=INT(A(NN+29))
      K=INT(ABS(A(NN+3)))
      CALL SXUS(A(K+13),KS)
      K=NA
      IF(K.EQ.16)K=4
      IF(K.EQ.15)K=7
      IF(K.EQ.14)K=8
      IF(K.GT.11)K=3
      R=A(K+104)
      IF(KS(1:2).EQ.'N ')R=R-.07
      IF(KS(1:2).EQ.'S ')R=1.20
  76  I=MA+32
      NH=INT(A(I+29))
  77  I=I+32
      IF(I.GT.MM)GOTO 82
      IF(I.GT.LX)GOTO 78
      IF(INT(A(I+29)).NE.NH)GOTO 78
      IF(INT(ABS(A(I+6))).EQ.INT(ABS(A(MA+38))))GOTO 77
  78  CALL SXER('UNSUITABLE AFIX HYDROGENS FOLLOW '//IR(1:MN))
  79  KQ=' NO ATOMS'
      K=9
      NI=INT(A(NN+4))
      IF(NI.LE.0)GOTO 81
      KQ=' '
      K=0
  80  NI=NI+1
      K=K+1
      CALL SXAN(IABS(INT(A(NI))),KQ,K,LM,A)
      IF(A(NI).LE.0.)GOTO 81
      IF(K.LT.71)GOTO 80
      IF(K.GT.76)K=76
      K=K+4
      IR(K-3:K)=' etc'
  81  CALL SXER('BAD AFIX CONNECTIVITY: '//IR(1:MN)//' BONDS TO'
     +//KQ(1:K))
C
C Identify bonded atoms
C
  82  L=INT(A(NN+4))
      IF(L.LT.0)GOTO 79
      ME=32000
      NJ=12
      NB=-4
      NK=0
  83  L=L+1
      M=INT(ABS(A(L)))
      IF(M.EQ.NN)GOTO 90
      K=M
      IF(M.LT.LV)GOTO 84
      K=INT(A(M+3))
      IF(INT(A(K+29)).LT.0)GOTO 89
  84  I=INT(ABS(A(K+6)))/10
      IF(I.EQ.0)GOTO 85
      IF(I.GT.15)GOTO 85
      IF(IABS(I-6).LT.2)GOTO 85
      IF(I.EQ.10)GOTO 85
      IF(I.NE.11)GOTO 89
  85  I=INT(A(K+29))
      IF(I.EQ.0)GOTO 88
      IF(I.EQ.NQ)GOTO 88
      IF(I.EQ.NH)GOTO 88
      IF(NQ.NE.NH)GOTO 89
      I=IABS(I)
      IF(I.EQ.ME)GOTO 88
      IF(I.GT.ME)GOTO 89
      ME=I
      MG=-4
        DO 87 I=1,NB,5
        MF=INT(FB(I))
        IF(MF.GT.LV)MF=INT(A(MF+3))
        MF=INT(ABS(A(MF+29)))
        IF(MF.EQ.NQ)GOTO 86
        IF(MF.GT.ME)GOTO 87
  86    MG=MG+5
        FB(MG)=FB(I)
        FB(MG+1)=FB(I+1)
        FB(MG+2)=FB(I+2)
        FB(MG+3)=FB(I+3)
        FB(MG+4)=FB(I+4)
  87    CONTINUE
      NB=MG
  88  X=A(M+17)-A(NN+17)
      Y=A(M+18)-A(NN+18)
      Z=A(M+19)-A(NN+19)
      NB=NB+5
      U=A(94)*X+A(95)*Y+A(96)*Z
      V=A(97)*Y+A(98)*Z
      W=A(99)*Z
      T=SQRT(U**2+V**2+W**2)
      IF(T.LT.0.01)GOTO 79
      FB(NB)=REAL(M)
      FB(NB+1)=U/T
      FB(NB+2)=V/T
      FB(NB+3)=W/T
      FB(NB+4)=T
  89  IF(M.EQ.MA+32)GOTO 104
  90  IF(A(L).GT.0.)GOTO 83
      IF(NA.NE.9)GOTO 94
      IF(NK.NE.0)GOTO 92
      IF(NB.LT.1)GOTO 79
      IF(NB.EQ.1)GOTO 91
      IF(FB(10)-FB(5).LT.0.3)GOTO 79
      CALL SXBB(FB,IR,NN,NB,1,NS,LM,A)
  91  M=INT(FB(NB))
      IF(M.GT.LV)M=INT(A(M+3))
      L=INT(A(M+4))
      IF(L.EQ.0)GOTO 79
      NK=1
      GOTO 83
  92  IF(NB.LT.6)GOTO 79
      IF(NB.LT.12)GOTO 93
      IF(FB(20)-FB(10).LT.0.3)GOTO 79
  93  NB=6
      GOTO 108
  94  M=MA+32
      IF(NA.EQ.15)GOTO 100
      IF(NA.EQ.16)GOTO 98
      IF(NA.EQ.3)GOTO 95
      IF(NA.LT.5)GOTO 96
  95  IF(NB.EQ.1)GOTO 88
      IF(FB(10)-FB(5).LT.0.3)GOTO 79
      CALL SXBB(FB,IR,NN,NB,1,NS,LM,A)
      GOTO 88
C
C Type 1 - tertiary C-H
C
  96  IF(NA.NE.1)GOTO 104
      IF(NB.LT.11)GOTO 79
      IF(NB.EQ.11)GOTO 97
      IF(FB(20)-FB(15).LT.0.3)GOTO 79
      CALL SXBB(FB,IR,NN,NB,11,NS,LM,A)
  97  XX=FB(12)-FB(2)
      YY=FB(13)-FB(3)
      ZZ=FB(14)-FB(4)
      X=FB(7)-FB(2)
      Y=FB(8)-FB(3)
      Z=FB(9)-FB(4)
      U=Y*ZZ-Z*YY
      V=Z*XX-X*ZZ
      W=X*YY-Y*XX
      Q=U**2+V**2+W**2
      IF(Q.LT.0.01)GOTO 79
      S=R/SQRT(Q)
      IF(U*(FB(2)+FB(7)+FB(12))+V*(FB(3)+FB(8)+FB(13))+
     +W*(FB(4)+FB(9)+FB(14)).GT.0.)S=-S
      GOTO 103
C
C Type 16 - acetylenic C-H
C
  98  IF(NB.LT.1)GOTO 79
      IF(NB.EQ.1)GOTO 99
      IF(FB(10)-FB(5).LT.0.3)GOTO 79
      NB=1
  99  Q=FB(2)**2+FB(3)**2+FB(4)**2
      IF(Q.LT.0.01)GOTO 79
      S=-R/SQRT(Q)
      FB(17)=FB(2)*S
      FB(18)=FB(3)*S
      FB(19)=FB(4)*S
      GOTO 113
C
C Type 15 - B-H (B bonded to 4 or 5 other atoms)
C
 100  IF(NB.LT.16)GOTO 79
      IF(NB.LT.22)GOTO 101
      IF(FB(30)-FB(25).LT.0.3)GOTO 79
      NB=21
 101  U=0.
      V=0.
      W=0.
        DO 102 NJ=1,NB,5
        U=U+FB(NJ+1)
        V=V+FB(NJ+2)
        W=W+FB(NJ+3)
 102    CONTINUE
      Q=U**2+V**2+W**2
      IF(Q.LT.0.01)GOTO 79
      S=-R/SQRT(Q)
 103  FB(17)=U*S
      FB(18)=V*S
      FB(19)=W*S
      GOTO 113
C
C Types 2 (secondary CH2) and 4 (aromatic CH, amide NH)
C
 104  IF(NB.LT.6)GOTO 79
      IF(NB.EQ.6)GOTO 105
      IF(FB(15)-FB(10).LT.0.3)GOTO 79
      CALL SXBB(FB,IR,NN,NB,6,NS,LM,A)
 105  IF(IABS(NA-3).NE.1)GOTO 108
      U=-FB(2)-FB(7)
      V=-FB(3)-FB(8)
      W=-FB(4)-FB(9)
      Q=U**2+V**2+W**2
      IF(Q.LT.0.01)GOTO 79
      Q=R/SQRT(Q)
      IF(NA.NE.4)GOTO 106
      FB(17)=U*Q
      FB(18)=V*Q
      FB(19)=W*Q
      GOTO 113
 106  XX=FB(2)-FB(7)
      YY=FB(3)-FB(8)
      ZZ=FB(4)-FB(9)
      S=XX**2+YY**2+ZZ**2
      IF(S.LT.0.01)GOTO 79
      X=V*ZZ-W*YY
      Y=W*XX-U*ZZ
      Z=U*YY-V*XX
      P=X**2+Y**2+Z**2
      IF(P.LT.0.01)GOTO 79
      S=1.0376-.0349*S
      Q=Q*COS(S)
      P=R*SIN(S)/SQRT(P)
        DO 107 NJ=17,22,5
        FB(NJ)=U*Q+X*P
        FB(NJ+1)=V*Q+Y*P
        FB(NJ+2)=W*Q+Z*P
        P=-P
 107    CONTINUE
      GOTO 113
C
C Define plane containing one or more H
C
 108  XX=FB(3)*FB(9)-FB(4)*FB(8)
      YY=FB(4)*FB(7)-FB(2)*FB(9)
      ZZ=FB(2)*FB(8)-FB(3)*FB(7)
      U=FB(4)*YY-FB(3)*ZZ
      V=FB(2)*ZZ-FB(4)*XX
      W=FB(3)*XX-FB(2)*YY
      Q=U**2+V**2+W**2
      IF(Q.LT.0.01)GOTO 79
      Q=R/SQRT(Q)
      P=-.333333*R
C
C Terminal methylene or NH2+ (Type 9)
C
      IF(NA.NE.9)GOTO 110
      Q=.866025*Q
      P=-.5*R
        DO 109 NJ=17,22,5
        FB(NJ)=P*FB(2)+Q*U
        FB(NJ+1)=P*FB(3)+Q*V
        FB(NJ+2)=P*FB(4)+Q*W
        Q=-Q
 109    CONTINUE
      GOTO 113
C
C Methyls (types 3 and 12) and OH (type 8)
C
 110  X=.942809*Q
      IF(IABS(NA-11).EQ.3)GOTO 111
      Z=XX**2+YY**2+ZZ**2
      IF(Z.LT.0.01)GOTO 79
      Z=.816497*R/SQRT(Z)
      Y=.471405*Q
 111  NJ=NJ+5
      FB(NJ)=FB(2)*P+U*X
      FB(NJ+1)=FB(3)*P+V*X
      FB(NJ+2)=FB(4)*P+W*X
      IF(IABS(NA-11).EQ.3)GOTO 113
        DO 112 N=1,2
        NJ=NJ+5
        FB(NJ)=FB(2)*P+XX*Z-U*Y
        FB(NJ+1)=FB(3)*P+YY*Z-V*Y
        FB(NJ+2)=FB(4)*P+ZZ*Z-W*Y
        Z=-Z
 112    CONTINUE
      X=-X
      Y=-Y
      Z=-Z
      IF(NJ.EQ.42)GOTO 113
      IF(NA.EQ.12)GOTO 111
C
C Store H-atoms in crystal coordinates
C
 113  U=A(NN+17)
      V=A(NN+18)
      W=A(NN+19)
      N=12
        DO 116 I=MA+32,MM,32
        N=N+5
        Z=FB(N+2)/A(99)
        Y=(FB(N+1)-A(98)*Z)/A(97)
        X=(FB(N)-A(95)*Y-A(96)*Z)/A(94)+U
        Y=Y+V
        Z=Z+W
        CALL SXUS(A(I),KS)
        XX=X-A(I+17)
        YY=Y-A(I+18)
        ZZ=Z-A(I+19)
        S=SQRT(A(8)*XX**2+A(9)*YY**2+A(10)*ZZ**2+A(11)*YY*ZZ+
     +  A(12)*XX*ZZ+A(13)*XX*YY)
        A(I+7)=X
        A(I+17)=X
        A(I+8)=Y
        A(I+18)=Y
        A(I+9)=Z
        A(I+19)=Z
C
C Print AFIX H-atoms
C
        L=INT(ABS(A(I+6)))
        IF(MOD(L,10).EQ.0)A(I+6)=SIGN(.01,A(I+6))
        IF(NS.EQ.0)GOTO 116
        IF(NS.GT.0)GOTO 114
        NS=IABS(NS)
        WRITE(LI,1)LK
 114    NJ=16
          DO 115 M=1,NB,5
          K=INT(FB(M))
          CALL SXAN(K,IR,NJ,LM,A)
          NJ=NJ+2
          IR(NJ-1:NJ)='  '
 115      CONTINUE
        WRITE(LI,3)KS,X,Y,Z,L,R,S,IR(1:NJ)
 116    CONTINUE
      MA=MM
      IF(NH.EQ.0)GOTO 117
      IF(MA.GE.LX)GOTO 119
      L=INT(A(MA+61))
      IF(L.EQ.0)GOTO 117
      IF(L.NE.NH)GOTO 73
 117  NN=MA
      GOTO 71
 118  NN=MM
      GOTO 71
C
C Read character scratch file and write FVAR etc. to .res
C
 119  CALL SXTO(9)
      IF(ABS(A(51)).LT.0.5)GOTO 120
      IF(LK.EQ.MV)WRITE(LI,4)IT
 120  A(142)=REAL(MU)
      IF(ABS(A(79)).LT.0.5)GOTO 121
      WRITE(KQ,6)(A(I),I=2,7)
      CALL SXLP(KQ,LQ)
      T=0.
      S=A(94)*A(97)*A(99)
      I=1
      WRITE(KQ,7)I,1./A(94),-A(95)*A(99)/S,(A(95)*A(98)-
     +A(96)*A(97))/S,T
      CALL SXLP(KQ,LQ)
      I=2
      WRITE(KQ,7)I,T,1./A(97),-A(94)*A(98)/S,T
      CALL SXLP(KQ,LQ)
      I=3
      WRITE(KQ,7)I,T,T,1./A(99),T
      CALL SXLP(KQ,LQ)
 121    DO 122 I=5,7
        T=1.745329E-2*A(I)
        DX(I-3)=SIN(T)
        DX(I)=COS(T)
 122    CONTINUE
      DU(1)=SQRT(30000.*A(136))
      T=DU(1)/DX(2)
      DU(2)=DX(7)*DX(3)*T
      DU(3)=DX(6)*DX(4)*T
      DU(4)=DX(3)*DX(4)*T
      DU(5)=(DX(5)-DX(6)*DX(7))*T
      NX=0
      NY=0
      MJ=-9999
      NT=1
      LO=LS
      NL=27
      REWIND LC
      NN=LB-16
 123  NN=NN+32
      NI=0
      NJ=0
      IF(NN.LE.LX)NJ=MOD(INT(ABS(A(NN+6))),10)
      IF(NN.EQ.LB+16)GOTO 124
      IF(NN.GT.LX)GOTO 124
      NI=MOD(INT(ABS(A(NN-26))),10)
 124  READ(LC)NK,KR,KS,IR
      IF(NK.EQ.20)GOTO 126
      IF(NK.EQ.29)GOTO 126
      IF(NK.EQ.38)GOTO 126
      IF(NK.NE.23)GOTO 125
      IF(NI+NJ.EQ.0)GOTO 124
      GOTO 126
 125  IF(NK.NE.1)GOTO 135
 126  IF(NT.LT.0)GOTO 134
      L=69
      IF(ABS(A(69)-0.333333).LT.0.0001)L=68
 127  IF(ABS(A(L)).GT.1.E-6)GOTO 128
      L=L-1
      IF(L.GT.64)GOTO 127
 128  WRITE(KQ,8)(A(I),I=64,L)
      CALL SXLP(KQ,LP)
      L=LD
      IF(A(39).LT.-8.E9)GOTO 130
      WRITE(KQ,9)A(39)
      IF(A(200).LT.-998.)GOTO 129
      KQ(1:4)='SWAT'
      WRITE(KQ(17:26),'(F10.4)',ERR=129)A(200)
 129  CALL SXLP(KQ,LP)
 130  K=L+1
      L=MIN0(K+6,LS)
      IF(L.LT.K)GOTO 131
      WRITE(KQ,10)(A(I),I=K,L)
      CALL SXLP(KQ,LP)
      GOTO 130
 131  A(LT+1)=SQRT(A(75))
      L=LT
 132  K=L+1
      L=MIN0(K+6,LV)
      IF(L.LT.K)GOTO 133
      WRITE(KQ,11)(A(I),I=K,L)
      CALL SXLP(KQ,LP)
      GOTO 132
 133  A(LT+1)=1.
      NT=-1
 134  IF(NK.EQ.1)GOTO 139
      IF(NK.NE.23)GOTO 135
      NI=INT(ABS(A(NN+6)))
      R=AMOD(ABS(A(NN+6)),1.)*10.
      IF(NI.EQ.MJ)GOTO 124
      WRITE(KQ,12)NI
      IF(R.GT.0.2)WRITE(KQ,12)NI,R
      CALL SXLP(KQ,LP)
      MJ=NI
      GOTO 124
 135  IF(NK.NE.40)GOTO 138
        DO 137 I=5,KR
        IF(IR(I:I).EQ.IH(12))GOTO 158
          DO 136 K=1,10
          IF(IR(I:I).EQ.IH(K))GOTO 138
 136      CONTINUE
 137    CONTINUE
 138  WRITE(KQ,5)IR(1:KR)
      CALL SXLP(KQ,LP)
      IF(NK.EQ.40)GOTO 158
      GOTO 124
C
C Write atoms to .res and .pdb and atom refinement table to .lst
C
 139  N=NN+16
      IF(A(NN+3).GT.0.)N=NN+11
      K=0
      A(NN+27)=REAL(LO+1)
      IF(MV.EQ.1)GOTO 140
      L=LO
      M=6
      IF(A(NN+3).LT.0.)M=12
      IF(A(NN+6).LT.0.)M=12
      LO=LO+M
      IF(LO.GT.LM)GOTO 165
      IF(LK.GT.1)GOTO 140
      CALL SXZA(A(L+1),M)
 140  SI(1)=A(LO)
        DO 141 I=NN+7,N
        K=K+1
        FC(K)=A(I)
        IF(A(I).GE.1.E6)FC(K)=A(I+10)
        FB(K)=A(I+10)
        L=L+1
        SI(K+1)=A(L)
 141    CONTINUE
      SI(12)=A(L+1)
      L=INT(A(NN+5))+7
      IF(L.LT.LB)GOTO 143
        DO 142 I=1,3
        FC(I)=A(L)
        IF(A(L).GE.1.E6)FC(I)=A(L+10)
        FB(I)=A(L+10)
        L=L+1
 142    CONTINUE
 143  L=INT(ABS(A(NN+31)))+11
      IF(L.LT.LB)GOTO 145
      FC(5)=A(L)
      FB(5)=A(L+10)
      IF(A(NN+3).GT.0.)GOTO 145
        DO 144 I=6,10
        L=L+1
        FC(I)=A(L)
        IF(A(L).GE.1.E6)FC(I)=A(L+10)
        FB(I)=A(L+10)
 144    CONTINUE
 145  NK=5
      IF(N.LT.NN+12)GOTO 147
      NK=11
      FB(11)=0.
      M=NN+21
        DO 146 I=136,141
        FB(11)=FB(11)+A(M)*A(I)
        M=M+1
 146    CONTINUE
 147  N=N+10
      NU=INT(ABS(A(NN+3)))
      M=(NU-LL+12)/16
      L=MIN0(K,6)
      WRITE(KQ,13)KS,M,(FC(I),I=1,L)
      CALL SXLP(KQ,LP)
      MJ=-9999
      IF(L.GE.K)GOTO 148
      WRITE(KQ,14)(FC(I),I=7,K)
      CALL SXLP(KQ,LP)
 148  IF(ABS(A(79)).LT.0.5)GOTO 155
      IF(NU.NE.KH)GOTO 149
      IF(A(79).GT.0.)GOTO 155
 149  NX=NX+1
      WRITE(KQ,15)NX,KS,A(94)*FB(1)+A(95)*FB(2)+A(96)*FB(3),
     +A(97)*FB(2)+A(98)*FB(3),A(99)*FB(3),FB(4),78.956835*FB(NK)
      CALL SXUS(A(NU+13),KS)
      IF(KS(2:2).NE.IH(20))GOTO 150
      KQ(16:16)=KQ(15:15)
      KQ(15:15)=KQ(14:14)
      KQ(14:14)=KQ(13:13)
      KQ(13:13)=IH(20)
 150  L=MIN0(24,INT(ABS(A(NN+29))))
      IF(L.EQ.0)GOTO 151
      IF(ABS(A(79)).GT.2.5)GOTO 151
      KQ(17:17)=IH(L+26)
 151  CALL SXUS(A(NN+2),KQ(18:21))
      CALL SXUS(A(NN+1),IR(1:4))
      L=27
        DO 152 I=1,4
        IF(IR(5-I:5-I).EQ.' ')GOTO 152
        L=L-1
        KQ(L:L)=IR(5-I:5-I)
 152    CONTINUE
      IF(KQ(23:26).NE.'   0')GOTO 153
      IF(NY.EQ.0)GOTO 154
      NY=NY+1
      WRITE(IR,'(I4)')NY
      KQ(23:26)=IR(1:4)
      KQ(18:21)='HOH '
 153  IR(1:4)=KQ(23:26)
      READ(IR,'(I4)',ERR=154)NY
 154  CALL SXLP(KQ,LQ)
      IF(A(NN+3).GT.0.)GOTO 155
      IF(ABS(ABS(A(79))-2.).GT.0.5)GOTO 155
      KQ(1:6)='ANISOU'
      WRITE(IR,'(6I7)')NINT(FB(5)*DU(1)**2+FB(6)*DU(2)**2+
     +FB(7)*DU(3)**2+2.*FB(8)*DU(2)*DU(3)+2.*FB(9)*DU(1)*DU(3)+
     +2.*FB(10)*DU(1)*DU(2)),NINT(FB(6)*DU(4)**2+FB(7)*DU(5)**2+
     +2.*FB(8)*DU(4)*DU(5)),NINT(FB(7)*10000.),NINT(FB(6)*DU(2)*
     +DU(4)+FB(7)*DU(3)*DU(5)+FB(8)*(DU(2)*DU(5)+DU(3)*DU(4))+FB(9)*
     +DU(1)*DU(5)+FB(10)*DU(1)*DU(4)),NINT(FB(7)*DU(3)*100.+FB(8)*
     +DU(2)*100.+FB(9)*DU(1)*100.),NINT(FB(7)*DU(5)*100.+FB(8)*
     +DU(4)*100.)
      KQ(29:70)=IR(1:42)
      CALL SXLP(KQ,LQ)
 155  IF(LK.LT.MV)GOTO 123
      IR=' '
      L=1
      CALL SXAN(NN,IR,L,LM,A)
      IF(ABS(A(51)).LT.0.5)GOTO 123
      WRITE(LI,16)IR(1:10),(FB(I),I=1,NK)
      IF(MV.EQ.1)GOTO 123
      IF(A(177).LT.0.)GOTO 123
      IF(KH.NE.INT(ABS(A(NN+3))))GOTO 156
      L=IABS(6-MOD(INT(ABS(A(NN+6))),10))
      IF(L.EQ.2)GOTO 156
      IF(L.GT.3)GOTO 156
      WRITE(LI,18)(SI(I),I=5,NK+1)
      GOTO 157
 156  WRITE(LI,17)(SI(I),I=1,NK+1)
 157  WRITE(LI,3)
      GOTO 123
C
C Assign memory for l.s. vector and matrix and zero them
C
 158  IF(LK.EQ.MV)GOTO 159
      IF(A(126).GT.A(41)+0.2)CALL SXER('REFINEMENT UNSTABLE')
      REWIND LP
      IF(ABS(A(79)).GT.0.5)REWIND LQ
      GOTO 160
 159  NP=2*INT(A(23)+.1)
 160  A(41)=A(126)
      J=(LB-LL+12)/8+2*NP+37
      JJ=NP
      JD=(JJ*(JJ+5))/2
      IF(A(177).LT.0.)JD=3*JJ
      JB=(JW-JD)/J
      IF(A(177).GE.0.)GOTO 161
      IF(JW.LT.J)GOTO 163
      GOTO 162
 161  IF(NP.GT.IM/8)JB=0
 162  IF(JB.GT.7)GOTO 166
 163  J=MAX0(J*8,3*JJ+1)+JD
      WRITE(LI,21)NP,LK,J
      IF(A(177).LT.0.)GOTO 164
      WRITE(IR,2)IM/8
      IF(NP.GT.IM)CALL SXER('TOO MANY PARAMETERS - MAXIMUM ALLOWED'
     +//IR(1:6))
 164  NL=28
 165  CALL SXER('ARRAY '//IH(NL)//' TOO SMALL FOR THIS PROBLEM')
 166  MO=MIN0(IV,LU-1)
      IF(MO.GT.JB)MO=JB
      IF(MO.LT.LU-1)MO=8*(MO/8)
      JB=MO
      J=JB*J+JD
      JA=JD+1
      JN=JA-JJ
      JZ=LO
      IF(JZ+JJ.LE.LM)JZ=JZ+JJ
      IF(LK.NE.MV)GOTO 167
      WRITE(LI,19)IT,MY,MO,JZ,J
      GOTO 168
 167  IF(ABS(A(51)).GT.0.5)WRITE(LI,20)LK,MO,JZ,J
 168    DO 169 J=1,JD
        B(J)=0.
 169    CONTINUE
      CALL SXZA(A(124),12)
      A(169)=0.
      CALL SXZA(CG,7)
      MX=INT(A(160))
      CALL SXTO(11)
      IF(LK.NE.MV)GOTO 170
      CALL SXZA(A(161),5)
      CALL SXZA(A(171),5)
C
C Read reflection data block and apply STIR if not final SF calc.
C
 170  READ(LF)MB,MH,MK,ML,FF,SI,SQ,WL
      MS=ML(LU)
      MG=MK(LU)
      MM=MH(LU)
      IF(LK.EQ.MV)GOTO 172
      MM=MG
      IF(A(76).LT.0.0001)GOTO 172
      T=.25/A(76)**2
      MM=0
        DO 171 I=1,MG
        IF(SQ(I).GT.T)GOTO 171
        MM=MM+1
        MB(MM)=MB(I)
        MH(MM)=MH(I)
        MK(MM)=MK(I)
        ML(MM)=ML(I)
        FF(MM)=FF(I)
        SI(MM)=SI(I)
        SQ(MM)=SQ(I)
        WL(MM)=WL(I)
 171    CONTINUE
      MG=MM
C
C Partition memory for vector sfls
C
 172  MN=MIN0(MM,MO)
      MZ=1-MN
      MW=0
      MQ=0
 173  IF(MM.LE.0)GOTO 220
      MZ=MZ+MN
      MN=MIN0(MM,MO)
 174  IF(MB(MN+MZ-1).GE.0)GOTO 175
      MN=MN-1
      IF(MN.GT.0)GOTO 174
      GOTO 164
 175  MM=MM-MN
      MT=MIN0(MG,MN)
      MG=MG-MN
      MR=MIN0(MS,MN)
      MS=MS-MN
      JM=MN
      JJ=JM+JM
      JB=JA+JM
      JC=JB+JM
      JD=JC+JM
      JU=JD+JM
      JV=JU+JM
      JR=JV+JM
      JS=JR+JM
      JE=JS+JM
      JX=JE+JM
      JY=JX+JM
      JZ=JY+JM
      JT=JZ+JM
      JH=JT+JM
      JK=JH+JM
      JL=JK+JM
      J5=JL+JM
      CALL SXZA(B(JU),MN)
      CALL SXZA(B(JV),MN)
      CALL SXZA(B(JR),MN)
      CALL SXZA(B(JS),MN)
C
C Calculate sfacs for each element
C
      JG=J5
      L=LL-12
 176  L=L+16
      IF(L.GT.LB)GOTO 177
      JF=JG+JM
      JG=JF+JM
      CALL SXVF(B(JF),B(JG),SQ(MZ),WL(MZ),L,MN,LM,A)
      GOTO 176
 177  JI=JG+JM
      JP=JI+20*JM
      JF=NP
      JO=JF*JM
      JQ=JP+JO
      JG=JQ+JO-1
        DO 178 JF=JP,JG
        B(JF)=0.
 178    CONTINUE
      J=JM*(NE-1)
C
C Scan atoms and perform structure factor calculation for data block
C
      NN=LB-16
 179  NN=NN+32
      IF(NN.GT.LX)GOTO 190
      IF(A(NN+31).LT.0.)GOTO 179
      L=20*MN
      CALL SXZA(B(JI),L)
      CALL SXCC
      IF(LK.EQ.MV)GOTO 180
      CALL SXZA(B(JR),MN)
      CALL SXZA(B(JS),MN)
      CALL SXDX(NN,DX,DY,DZ,IX,IY,IZ,NX,NY,NZ,LM,A)
      CALL SXDU(NN,DU,IU,NU,LM,A)
 180  JG=(INT(ABS(A(NN+3)))+12-LL)/8
      JF=JL+JG*JM
      JG=JF+JM
      CALL SXVH(B(JH),B(JK),B(JL),MH(MZ),MK(MZ),ML(MZ),MN)
      IF(A(NN+3).GE.0.)CALL SXVI(B(JE),SQ(MZ),A(NN+17),MN)
        DO 183 K=201,LY,12
        CALL SXVE(B(JX),B(JY),B(JZ),B(JT),B(JH),B(JK),B(JL),A(K),MN)
        IF(A(NN+3).LT.0.)CALL SXVA(B(JE),B(JX),B(JY),B(JZ),A(1),
     +  A(NN+17),MN)
        IF(LK.EQ.MV)GOTO 182
        CALL SXVC(B(JR),B(JS),B(JA),B(JB),B(JC),B(JD),
     +  B(JX),B(JY),B(JZ),B(JT),B(JE),B(JF),B(JG),A(NN+17),A(23),MN)
        IF(NX.GT.0)CALL SXCD(B(JI),B(JI+JM),B(JX),B(JC),B(JD),MN)
        J=JI+JJ
        IF(NY.GT.0)CALL SXCD(B(J),B(J+JM),B(JY),B(JC),B(JD),MN)
        J=J+JJ
        IF(NZ.GT.0)CALL SXCD(B(J),B(J+JM),B(JZ),B(JC),B(JD),MN)
        IF(NU.LT.2)GOTO 183
        IF(A(NN+3).GT.0.)GOTO 183
        J=J+JJ
          DO 181 I=2,7
          J=J+JJ
          IF(IU(I).EQ.0)GOTO 181
          J1=JX
          J2=JY
          IF(IABS(I-4).EQ.1)J1=JY
          IF(I.EQ.4)J1=JZ
          IF(IABS(I-5).LT.2)J2=JZ
          IF(I.EQ.2)J2=JX
          CALL SXSP(B(JT),B(J1),B(J2),MN)
          CALL SXCT(B(J),B(J+JM),B(JT),B(JA),B(JB),A(I+12),MN)
 181      CONTINUE
        GOTO 183
 182    CALL SXFX(B(JR),B(JS),B(JU),B(JV),B(JX),B(JY),
     +  B(JZ),B(JT),B(JE),B(JF),B(JG),A(NN+17),A(23),MN)
 183    CONTINUE
      IF(LK.EQ.MV)GOTO 179
      CALL SXCS(B(JU),B(JV),B(JR),B(JS),MN)
      J=JI+3*JJ
      IF(IU(1).EQ.0)GOTO 184
      P=1./A(NN+20)
      CALL SXCP(B(J),B(J+JM),B(JR),B(JS),P,MN)
 184  J=J+JJ
      IF(A(NN+3).LT.0.)GOTO 185
      IF(IU(2).EQ.0)GOTO 185
      P=-78.956835
      CALL SXDI(B(J),B(J+JM),SQ(MZ),B(JR),B(JS),P,MN)
C
C Combine derivatives
C
 185    DO 186 I=1,NX
        J=JM*(IX(I)-1)
        J1=JP+J
        J2=JQ+J
        CALL SXCV(B(J1),B(J2),B(JI),B(JI+JM),DX(I),MN)
 186    CONTINUE
      JO=JI+JJ
        DO 187 I=1,NY
        J=JM*(IY(I)-1)
        J1=JP+J
        J2=JQ+J
        CALL SXCV(B(J1),B(J2),B(JO),B(JO+JM),DY(I),MN)
 187    CONTINUE
      JO=JO+JJ
        DO 188 I=1,NZ
        J=JM*(IZ(I)-1)
        J1=JP+J
        J2=JQ+J
        CALL SXCV(B(J1),B(J2),B(JO),B(JO+JM),DZ(I),MN)
 188    CONTINUE
        DO 189 I=1,NU
        JO=JO+JJ
        IF(IU(I).EQ.0)GOTO 189
        J=JM*(IU(I)-1)
        J1=JP+J
        J2=JQ+J
        CALL SXCV(B(J1),B(J2),B(JO),B(JO+JM),DU(I),MN)
 189    CONTINUE
      GOTO 179
C
C Sum residuals etc. in final structure factor cycle
C
 190  IF(LK.NE.MV)GOTO 194
      J2=JP+JM
      CALL SXSF(B(JR),B(JS),B(JU),B(JV),B(JX),B(JY),B(JZ),B(JP),
     +B(J2),B(JT),FF(MZ),SI(MZ),FC(MZ),SQ(MZ),WL(MZ),B(JH),
     +B(JK),B(JL),MB(MZ),MH(MZ),MK(MZ),ML(MZ),MN,MT,MR,LM,A,KD)
      CALL SXCA(B(JX),WL(MZ),MN)
      CALL SXCA(B(JY),FB(MZ),MN)
      IF(MX.EQ.0)GOTO 192
      I=MZ
        DO 191 K=1,MR
        MW=MW+1
        IF(I.LE.MT)MQ=MW
        FF(MW)=FF(I)
        FC(MW)=FC(I)
        MH(MW)=MH(I)
        MK(MW)=MK(I)
        ML(MW)=ML(I)
        SI(MW)=SI(I)
        SQ(MW)=SQ(I)
        FB(MW)=FB(I)
        WL(MW)=WL(I)
        I=I+1
 191    CONTINUE
 192  IF(A(23).LT.0.5)GOTO 173
      J1=JP
      JF=JT+MT-1
        DO 193 J=JT,JF
        B(1)=B(1)+B(J1)*B(J)
        B(2)=B(2)+B(J2)*B(J)
        B(3)=B(3)+B(J1)**2
        B(4)=B(4)+B(J1)*B(J2)
        B(5)=B(5)+B(J2)**2
        J1=J1+1
        J2=J2+1
 193    CONTINUE
      GOTO 173
C
C Process derivatives etc. for twinned crystals and powders
C
 194  MD=LV-LT
      J1=JP
      J2=JQ
      NJ=MAX0(NE,MD+IW-LD)
      IF(A(200).GT.-998.)NJ=MAX0(NE+1,NJ)
      JO=JP+JM*(MD-2)-1
      IF(MX.EQ.0)GOTO 212
        DO 197 NI=2,NP
        J1=J1+JM
        J2=J2+JM
        IF(NI.LE.MD)GOTO 195
        IF(NI.LE.NJ)GOTO 196
 195    CALL SXSM(B(J2),B(J1),B(JV),B(JU),MN)
 196    CALL SXZA(B(J1),MN)
 197    CONTINUE
      J1=JP
      J2=JQ
      N=0
      I=MZ-1
 198  I=I+1
      IF(I.GE.MN+MZ)GOTO 209
      K=I
 199  IF(MB(I).GT.0)GOTO 200
      I=I+1
      GOTO 199
 200  N=N+1
      FF(N)=FF(I)
      SI(N)=SI(I)
      SQ(N)=SQ(I)
      WL(N)=WL(I)
      B(JH+N-1)=B(JH+I-1)
      B(JK+N-1)=B(JK+I-1)
      B(JL+N-1)=B(JL+I-1)
      IF(IB.LE.LD)GOTO 203
        DO 202 L=K,I
        IF(IABS(MB(L)).NE.1)GOTO 202
        NN=L-MZ
        U=-0.5*(B(JU+NN)**2+B(JV+NN)**2)
        J=JO+JM+N
          DO 201 M=LD+1,IB
          J=J+JM
          B(J)=U
 201      CONTINUE
 202    CONTINUE
 203  FC(N)=0.
        DO 208 L=K,I
        NT=IABS(MB(L))
        IF(MX.GT.-990)GOTO 204
        T=REAL(NT)
        GOTO 205
 204    T=1./ABS(A(160))
        IF(IB.LE.LD)GOTO 205
        T=A(168)
        IF(NT.EQ.1)GOTO 205
        T=A(LD+NT-1)
 205    M=L-MZ
        V=B(JU+M)**2+B(JV+M)**2
        FC(N)=FC(N)+T*V
        NH=J1
        NK=J2
          DO 207 NI=2,NP
          NH=NH+JM
          NK=NK+JM
          IF(NI.LE.MD)GOTO 206
          IF(NI.LE.NJ)GOTO 207
 206      B(NH)=B(NH)+B(NK)*T
 207      CONTINUE
        J2=J2+1
        IF(IB.LE.LD)GOTO 208
        IF(NT.EQ.1)GOTO 208
        J=JO+JM*NT+N
        B(J)=B(J)+0.5*V
 208    CONTINUE
      J1=J1+1
      GOTO 198
 209  CALL SXTC(B(JX),B(JZ),B(JY),B(JT),B(JP),FF,SI,FC,SQ,WL,
     +B(JH),B(JK),B(JL),B(J5),LD,N,LM,A)
      J1=JP
        DO 211 M=2,NP
        J1=J1+JM
        JO=J1+N-1
        J2=JX
          DO 210 J=J1,JO
          B(J)=B(J)*B(J2)
          J2=J2+1
 210      CONTINUE
 211    CONTINUE
      GOTO 216
C
C Process derivatives etc. for normal crystals
C
 212  CALL SXFC(B(JU),B(JV),B(JZ),B(JY),B(JT),B(JP),B(J5),FF(MZ),
     +SI(MZ),FC(MZ),SQ(MZ),WL(MZ),B(JH),B(JK),B(JL),MB(MZ),MN,LM,A)
        DO 214 N=2,NP
        J1=J1+JM
        J2=J2+JM
        IF(N.LE.MD)GOTO 213
        IF(N.LE.NJ)GOTO 214
 213    CALL SXSM(B(J1),B(J2),B(JU),B(JV),MN)
 214    CONTINUE
      N=MN
      IF(IB.LE.LD)GOTO 216
      J1=JP
        DO 215 I=1,MN
        M=IABS(MB(I+MZ-1))
        IF(M.LE.1)GOTO 215
        IF(M.GT.IB-LD+1)GOTO 215
        J=JO+M*JM+I
        B(J)=B(J1)
        J1=J1+1
 215    CONTINUE
C
C HOPE derivatives for normal crystals
C
 216  K=INT(A(167))
      IF(K.LT.1)GOTO 218
      J1=J5
      J2=JO+(K+1)*JM
        DO 217 I=0,N-1
        J2=J2+1
        M=I+MZ
        W=1./SQ(M)
        T=-.506606*B(JH+I)**2*A(14)
        J=J2+6*JM
        B(J)=B(J1)*T
        B(J2)=W*B(J)
        T=-.506606*B(JK+I)**2*A(15)
        J=J2+7*JM
        B(J)=B(J1)*T
        B(J2+JM)=W*B(J)
        T=-.506606*B(JL+I)**2*A(16)
        J=J2+8*JM
        B(J)=B(J1)*T
        B(J2+2*JM)=W*B(J)
        T=-.506606*B(JK+I)*B(JL+I)*A(17)
        J=J2+9*JM
        B(J)=B(J1)*T
        B(J2+3*JM)=W*B(J)
        T=-.506606*B(JH+I)*B(JL+I)*A(18)
        J=J2+10*JM
        B(J)=B(J1)*T
        B(J2+4*JM)=W*B(J)
        T=-.506606*B(JH+I)*B(JK+I)*A(19)
        J=J2+11*JM
        B(J)=B(J1)*T
        B(J2+5*JM)=W*B(J)
        J1=J1+1
 217    CONTINUE
C
C Complete derivative manipulations and write Fc file
C
 218  IF(NE.EQ.0)GOTO 219
      JO=JP+JM*(NE-1)
      CALL SXCA(B(JZ),B(JO),N)
      IF(A(200).LT.-998.)GOTO 219
      CALL SXCA(B(JY),B(JO+JM),N)
 219  CALL SXTO(12)
      J=IM/8
      CALL SXMM(NP,N,JP,JN,JT,JM,A(177),JW,J,B,C(1),C(J+1),C(J*2+1),
     +C(J*3+1),C(J*4+1),C(J*5+1),C(J*6+1),C(J*7+1))
      CALL SXTO(11)
      GOTO 173
 220  IF(MX.EQ.0)GOTO 221
      MH(LU)=MW
      MK(LU)=MQ
 221  ML(LU)=MB(LU)
      IF(LK.EQ.MV)WRITE(LA)MH,MK,ML,FF,SI,SQ,WL,FB,FC
      IF(MB(LU).GT.0)GOTO 170
      JB=NE
      JC=JN
      JD=NP
      JE=MY
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SX3I(LM,JW,LU,MH,MK,MB,FF,SI,SQ,WL,A,B)
C
C Structure-factor and least-squares calculations - Part 2
C
      CHARACTER*1 KQ,KB
      CHARACTER*4 KP(24),KX,KY
      CHARACTER*128 KR
      INTEGER MH(LU),MK(LU),MB(LU),IX(9),IY(9),IZ(9)
      REAL FF(LU),SI(LU),SQ(LU),WL(LU),A(LM),B(JW)
      COMMON/MEM/ST,SL,TC,TL,IV,LR,LG,LH,LI,LP,LF,LA,LC,LW,LY,LL,LB,
     +LX,LE,LV,LJ,LD,LS,LO,LT,LK,LQ,LZ,LN,KH,JA,JB,JC,JD,JE,HA,HD
      REAL DX(9),DY(9),DZ(9),F(25),G(11)
C
      DATA KP/'  x ','  y ','  z ',' sof',' U11',' U22',' U33',
     +' U23',' U13',' U12','EXTI','BASF','FVAR','size','rotX',
     +'rotY','rotZ','dist',' OSF','    ','tors','Uiso',' rho','SWAT'/
C
   1  FORMAT(' wR2 =',F8.4,' before cycle',I4,' for',I7,' data and',
     +I6,' /',I6,' parameters')
   2  FORMAT(//' Disagreeable restraints before cycle',I5//
     +'   Observed   Target    Error     Sigma     Restraint'/)
   3  FORMAT(4F10.4,4X,A)
   4  FORMAT(20X,2F10.4,4X,A)
   5  FORMAT(//' Summary of restraints applied in cycle',I5//17X,
     +'ANTIBUMP   DFIX     DANG  SAME/SADI  CHIV/Z  CHIV/NZ    FLAT',
     +'     DELU     SIMU     ISOR     SUMP'//8X,'Number',11F9.0//
     +' rms sigma    ',11F9.3//' rms deviation',11F9.3/)
   6  FORMAT(' GooF = S =',F10.3,';     Restrained GooF = ',F10.3,
     +'  for',I7,' restraints')
   7  FORMAT(/' Weight = 1 / [ sigma^2(Fo^2) + (',F7.4,' * P )^2 +',
     +F7.2,' * P ]   where  P = ( Max ( Fo^2, 0 ) + 2 * Fc^2 ) / 3')
   8  FORMAT(/' Weight = [',F8.2,' +',F8.2,' * exp (',F8.2,
     +'*s^2 ) ] / [ sigma^2(Fo^2) +',F7.4,' +',F7.2,'*P + (',F6.4,
     +'*P)^2 +',F7.4,'*s ]'/' where s = sin(theta)/lambda  and  ',
     +'P = Max ( ',F8.5,'*Fo^2, 0 ) +',F8.5,'*Fc^2')
C
C R-Indices before cycle
C
      MV=INT(ABS(A(177))+1.1)
      J=INT(A(125))
      A(91)=REAL(JE)
      SC=1.
      IF(A(128).GT.1.E-6)SC=A(127)/A(128)
      A(126)=A(126)/SC**2
      A(128)=AMAX1(0.,A(126)-A(127)/SC)
      A(126)=SQRT(A(128)/A(126))
      A(127)=99.999
      T=A(125)-A(91)-A(179)
      IF(T.GT.1.)A(127)=SQRT(A(128)/T)
      A(62)=A(128)/AMAX1(1.,A(125))
      WRITE(LI,3)
      WRITE(LI,1)A(126),LK,J,JD,JE
      WRITE(*,1)A(126),LK,J,JD,JE
      CALL SXFL
C
C Scale l.s. vector
C
      IF(JD.EQ.0)GOTO 10
      IF(LK.GE.MV)GOTO 10
      J=JC
        DO 9 I=1,JD
        B(I)=B(I)/SC-B(J)
        J=J+1
   9    CONTINUE
      A(169)=A(169)*A(127)**2
  10  A(63)=A(75)
      A(75)=SC
      A(144)=SC
      IC=LS
      IF(A(167).LT.-0.5)IC=IC-12
C
C Apply restraints
C
      CALL SXTO(13)
      JE=0
      IF(A(177).GE.0.)GOTO 11
      JE=JD*7+1
      B(JE)=0.
  11  NP=JD
      A(132)=0.
        DO 12 I=11,13
        A(I+104)=1.
        F(I+2)=.5*A(I)
        F(I+5)=2.*A(I+3)
        F(I+8)=2.*A(I+6)
  12    CONTINUE
      CALL SXZA(A(180),20)
      CALL SXZA(WL,13)
      NT=0
      NE=0
      IF(ABS(A(51)).GT.0.5)NE=1
      IF(LK.EQ.MV)NE=1
C
C Anti-bumping restraints - scan equivalents
C
      IF(A(142).LT.0.)GOTO 43
      IF(A(166).LT.-998.)GOTO 43
      CALL SXTO(29)
      A(44)=REAL(LE+20)+0.1
      RZ=1.
      KR='BUMP'
      CALL SXPS(A(LE+21),'    ')
      CALL SXPS(A(LE+22),'    ')
      NI=0
      NK=50
      NN=45
      MM=180
      MZ=LB-16
  13  MZ=MZ+32
      IF(MZ.GT.LX)GOTO 41
      A(MZ+20)=-A(MZ+20)
      IF(A(MZ+31).LT.0.)GOTO 13
      IL=INT(ABS(A(MZ+3)))
      CALL SXUS(A(IL+13),KX)
      IF(KX.NE.'C   '.AND.KX.NE.'N   '.AND.KX.NE.'O   '.AND.KX.NE.
     +'S   '.AND.KX.NE.'H   ')GOTO 13
      IF(A(MZ+20).GT.-0.0001)GOTO 13
      A(MZ+20)=-A(MZ+20)
      MU=INT(A(MZ+29))
      KQ=KX(1:1)
      MX=-2
      IL=189
  14  IL=IL+12
      IF(IL.GT.LY)GOTO 13
      XA=A(MZ+17)*A(IL)+A(MZ+18)*A(IL+1)+A(MZ+19)*A(IL+2)+A(IL+9)
      YA=A(MZ+17)*A(IL+3)+A(MZ+18)*A(IL+4)+A(MZ+19)*A(IL+5)+A(IL+10)
      ZA=A(MZ+17)*A(IL+6)+A(MZ+18)*A(IL+7)+A(MZ+19)*A(IL+8)+A(IL+11)
      IW=LY+8
  15  IW=IW+4
      IF(IW.GT.LL)GOTO 14
      XB=A(IW)*XA+A(IW+1)
      YB=A(IW)*YA+A(IW+2)
      ZB=A(IW)*ZA+A(IW+3)
        DO 16 MY=1,MX,3
        R=AMOD(XB-FF(MY),1.)-.5
        S=AMOD(YB-FF(MY+1),1.)-.5
        T=AMOD(ZB-FF(MY+2),1.)-.5
        IF(A(8)*R**2+A(9)*S**2+A(10)*T**2+S*T*A(11)+
     +  R*T*A(12)+R*S*A(13).LT.0.01)GOTO 15
  16    CONTINUE
      MX=MX+3
      FF(MX)=XB-99.5
      FF(MX+1)=YB-99.5
      FF(MX+2)=ZB-99.5
      MY=MZ
      IF(MX.EQ.1)MY=MY-32
      MW=LB-16
  17  MW=MW+32
      IF(MW.GT.MY)GOTO 15
      IF(A(MW+20).LT.0.0001)GOTO 17
      U=AMOD(XB-A(MW+17),1.)-.5
      V=AMOD(YB-A(MW+18),1.)-.5
      W=AMOD(ZB-A(MW+19),1.)-.5
      Q=A(8)*U**2+A(9)*V**2+A(10)*W**2+V*W*A(11)+
     +U*W*A(12)+U*V*A(13)
      IF(Q.GT.11.56)GOTO 17
C
C Check occupancies, PARTs and target distances
C
      I=INT(A(MW+29))
      IF(I*MU.EQ.0)GOTO 18
      IF(I.NE.MU)GOTO 17
      IF(I.LT.0)GOTO 17
      GOTO 19
  18  IF(A(MZ+20)+A(MW+20).LT.1.1)GOTO 17
  19  I=INT(ABS(A(MW+3)))
      CALL SXUS(A(I+13),KY)
      KB=KY(1:1)
      T=3.0
      IF(KY.NE.'H   ')GOTO 21
      IF(KQ.NE.'H')GOTO 17
      T=2.1
      IF(MX.NE.1)GOTO 22
      I=MW
  20  I=I+32
      K=INT(ABS(A(I+3)))
      CALL SXUS(A(K+13),KY)
      IF(KY.NE.'H   ')GOTO 22
      IF(I.NE.MZ)GOTO 20
      GOTO 17
  21  IF(KQ.EQ.'H')GOTO 17
      IF(KQ.EQ.'O'.AND.KB.EQ.'O')T=2.3
      IF(KQ.EQ.'O'.AND.KB.EQ.'N')T=2.5
      IF(KQ.EQ.'N'.AND.KB.EQ.'O')T=2.5
      IF(KQ.EQ.'C'.AND.KB.EQ.'O')T=2.8
      IF(KQ.EQ.'O'.AND.KB.EQ.'C')T=2.8
      IF(KQ.EQ.'N'.AND.KB.EQ.'N')T=2.7
      IF(KQ.EQ.'S'.AND.KB.EQ.'N')T=3.1
      IF(KQ.EQ.'N'.AND.KB.EQ.'S')T=3.1
      IF(KQ.EQ.'C'.AND.KB.EQ.'S')T=3.2
      IF(KQ.EQ.'S'.AND.KB.EQ.'C')T=3.3
      IF(KQ.EQ.'C'.AND.KB.EQ.'C')T=3.3
      IF(KQ.EQ.'S'.AND.KB.EQ.'S')T=3.3
  22  IF(Q.GT.T**2)GOTO 17
      U=U+A(MW+17)
      V=V+A(MW+18)
      W=W+A(MW+19)
      IF(MX.GT.1.AND.A(166).GT.0.)GOTO 39
C
C Joined by 1, 2 or 3 bonds in connectivity array ?
C
      MN=INT(A(MW+4))
      IF(MN.EQ.0)GOTO 39
  23  MN=MN+1
      I=INT(ABS(A(MN)))
      IF(I.LE.LX)GOTO 29
      IF(A(166).GT.0.)GOTO 38
      IF(MX.EQ.1)GOTO 38
      L=INT(A(I+3))
      IF(L.NE.MZ)GOTO 24
      P=U-A(I+17)
      Q=V-A(I+18)
      R=W-A(I+19)
      IF(A(8)*P**2+A(9)*Q**2+A(10)*R**2+A(11)*Q*R+
     +A(12)*P*R+A(13)*P*Q.LT.0.01)GOTO 17
      GOTO 38
  24  N=INT(ABS(A(L+4)))
      IF(N.EQ.0)GOTO 38
  25  N=N+1
      NL=INT(ABS(A(N)))
      IF(NL.GT.LX)GOTO 28
      IF(NL.EQ.MZ)GOTO 27
      NL=INT(A(NL+4))
      IF(NL.EQ.0)GOTO 28
  26  NL=NL+1
      IF(INT(ABS(A(NL))).EQ.MZ)GOTO 27
      IF(A(NL).GT.0.)GOTO 26
      GOTO 28
  27  P=AMOD(A(IW)*(A(L+17)*A(IL)+A(L+18)*A(IL+1)+A(L+19)*A(IL+2)+
     +A(IL+9))+A(IW+1)-A(I+17),1.)-0.5
      Q=AMOD(A(IW)*(A(L+17)*A(IL+3)+A(L+18)*A(IL+4)+A(L+19)*A(IL+5)+
     +A(IL+10))+A(IW+2)-A(I+18),1.)-0.5
      R=AMOD(A(IW)*(A(L+17)*A(IL+6)+A(L+18)*A(IL+7)+A(L+19)*A(IL+8)+
     +A(IL+11))+A(IW+3)-A(I+19),1.)-0.5
      IF(A(8)*P**2+A(9)*Q**2+A(10)*R**2+A(11)*Q*R+
     +A(12)*P*R+A(13)*P*Q.LT.0.01)GOTO 17
  28  IF(A(N).GT.0.)GOTO 25
      GOTO 38
  29  IF(MX.EQ.1.AND.I.EQ.MZ)GOTO 17
      NL=INT(A(I+4))
      IF(NL.EQ.0)GOTO 38
  30  NL=NL+1
      K=INT(ABS(A(NL)))
      IF(K.EQ.MW)GOTO 37
      IF(K.LE.LX)GOTO 34
      IF(A(166).GT.0.)GOTO 37
      L=INT(A(K+3))
      IF(L.NE.MZ)GOTO 31
      P=U-A(K+17)
      Q=V-A(K+18)
      R=W-A(K+19)
      IF(A(8)*P**2+A(9)*Q**2+A(10)*R**2+A(11)*Q*R+
     +A(12)*P*R+A(13)*P*Q.LT.0.01)GOTO 17
  31  N=INT(A(L+4))
      IF(N.EQ.0)GOTO 37
  32  N=N+1
      IF(INT(ABS(A(N))).EQ.MZ)GOTO 33
      IF(A(N).GT.0.)GOTO 32
      GOTO 37
  33  P=AMOD(A(IW)*(A(L+17)*A(IL)+A(L+18)*A(IL+1)+A(L+19)*A(IL+2)+
     +A(IL+9))+A(IW+1)-A(K+17),1.)-0.5
      Q=AMOD(A(IW)*(A(L+17)*A(IL+3)+A(L+18)*A(IL+4)+A(L+19)*A(IL+5)+
     +A(IL+10))+A(IW+2)-A(K+18),1.)-0.5
      R=AMOD(A(IW)*(A(L+17)*A(IL+6)+A(L+18)*A(IL+7)+A(L+19)*A(IL+8)+
     +A(IL+11))+A(IW+3)-A(K+19),1.)-0.5
      IF(A(8)*P**2+A(9)*Q**2+A(10)*R**2+A(11)*Q*R+
     +A(12)*P*R+A(13)*P*Q.LT.0.01)GOTO 17
      GOTO 37
  34  IF(K.EQ.MZ)GOTO 17
      NB=INT(A(K+4))
      IF(NB.EQ.0)GOTO 37
  35  NB=NB+1
      N=INT(ABS(A(NB)))
      IF(N.EQ.MZ)GOTO 17
      IF(N.LE.LX)GOTO 36
      IF(A(166).GT.0.)GOTO 36
      IF(MX.EQ.1)GOTO 36
      IF(INT(A(N+3)).NE.MZ)GOTO 36
      P=U-A(N+17)
      Q=V-A(N+18)
      R=W-A(N+19)
      IF(A(8)*P**2+A(9)*Q**2+A(10)*R**2+A(11)*Q*R+
     +A(12)*P*R+A(13)*P*Q.LT.0.01)GOTO 17
  36  IF(A(NB).GT.0.)GOTO 35
  37  IF(A(NL).GT.0.)GOTO 30
  38  IF(A(MN).GT.0.)GOTO 23
C
C Set up dummy atom for restraint
C
  39  R=ABS(A(166))
      UM=-1.
      CALL SXUS(A(MZ),KY)
      CALL SXPS(A(LE+20),KY)
      A(LE+23)=REAL(MZ)+0.1
      A(LE+24)=0.
      K=IL
        DO 40 I=LE+25,LE+33
        A(I)=A(IW)*A(K)
        K=K+1
  40    CONTINUE
      A(LE+37)=U
      A(LE+38)=V
      A(LE+39)=W
      A(LE+34)=U-FF(MX)+A(IL+9)*A(IW)
      A(LE+35)=V-FF(MX+1)+A(IL+10)*A(IW)
      A(LE+36)=W-FF(MX+2)+A(IL+11)*A(IW)
      A(43)=REAL(MW)+0.1
      A(44)=REAL(LE)+20.1
      MN=41
      NL=45
      GOTO 66
  41    DO 42 I=LB+16,LX,32
        A(I+20)=ABS(A(I+20))
  42    CONTINUE
C
C Scan stored restraints
C
  43  NN=LJ+1
      CALL SXTO(13)
  44  NK=INT(A(NN)/64000.)
      IF(NK.EQ.0)GOTO 116
      CALL SXCC
      N=NN+1
      NN=NN+INT(AMOD(A(NN),64000.))
      NL=NN
      L=4
      S=0.
      NB=0
      T=A(N)
      R=A(N+1)
      IF(NK.NE.50)R=AMAX1(R,0.0001)
      RZ=1.
      UM=-1.
C
C SUMP
C
      IF(NK.NE.49)GOTO 63
      KR='SUMP'
      MM=0
  45  N=N+2
      IF(N.GE.NN)GOTO 47
      K=INT(A(N+1))
      IF(K.LT.2)GOTO 44
      I=LT+K
      IF(I.GT.LV)I=I+LD-LV
      IF(A(39).LT.-998.)GOTO 46
      IF(I.GT.LS)K=K-LS+IC
      IF(I.EQ.LS+1)I=39
      IF(I.EQ.LS+2)I=200
  46  IF(I.GT.LS)GOTO 44
      S=S+A(N)*A(I)
      NB=NB+1
      MK(NB)=K
      SI(NB)=A(N)
      GOTO 45
C
C Comment on largest discrepancies
C
  47  U=S-T
      IF(ABS(A(51)).GT.2.5)GOTO 48
      IF(ABS(U).LT.3.*R)GOTO 55
  48  IF(NK.EQ.51)GOTO 53
      IF(NK.EQ.55)GOTO 53
  49  IF(N.GE.NL)GOTO 50
      K=INT(A(N))
      L=L+1
      KR(L:L)=' '
      CALL SXAN(K,KR,L,LM,A)
      N=N+1
      IF(L.LT.70)GOTO 49
      L=L+6
      KR(L-5:L)='  etc.'
  50  IF(NT.EQ.0)WRITE(LI,2)LK
      NT=1
      IF(NK.GT.57)GOTO 52
      IF(MN.NE.43)GOTO 51
      IF(KR(L:L).EQ.'_')L=L-1
      IF(MX.EQ.1)GOTO 51
      L=L+3
      KR(L-2:L)=' [ '
      CALL SXOP(KR,A(LE+25),A(LY+12),L)
      L=L+2
      KR(L-1:L)=' ]'
  51  WRITE(LI,3)S,T,U,R,KR(1:L)
      GOTO 55
  52  WRITE(LI,4)U,R,KR(1:L)
      GOTO 55
  53  IF(ABS(U).LT.UM)GOTO 55
      W=UM
      UM=ABS(U)
      L=4
      IF(NK.EQ.51)L=9
        DO 54 K=1,4
        L=L+1
        KR(L:L)=' '
        CALL SXAN(MB(K),KR,L,LM,A)
  54    CONTINUE
      IF(W.LT.0.)GOTO 55
      L=L+6
      KR(L-5:L)='  etc.'
  55  W=A(62)/((AMAX1(R,0.01*ABS(U)))**2*RZ)
      A(132)=A(132)+1.
      V=(U/R)**2
      A(133)=A(133)+V
      IF(MM.NE.0)GOTO 56
      WL(11)=WL(11)+1.
      WL(12)=WL(12)+R**2
      WL(13)=WL(13)+U**2
      GOTO 57
  56  A(MM)=A(MM)+R**2
      A(MM+10)=A(MM+10)+U**2
      WL(MM-179)=WL(MM-179)+1.
  57  IF(NB.EQ.0)GOTO 58
      IF(LK.EQ.MV)GOTO 58
      CALL SXAM(SI,MK,W,U,JD,NB,JE,JW,B)
  58  IF(NK.EQ.50)GOTO 66
      IF(NK.EQ.51)GOTO 90
      IF(NK.EQ.55)GOTO 74
      GOTO 44
C
C Add worst SIMU (iso) and BUMP discrepancies to residue tables
C
  59  IF(MM.NE.180)GOTO 47
  60  IF(LK.NE.MV)GOTO 47
      U=ABS(S-T)
      MU=I
  61  IB=MU
      IF(IB.GT.LE)IB=INT(A(IB+3))
      IB=(IB-LB)/32+LE+40
      IB=INT(A(IB))
      IF(IB.EQ.0)GOTO 62
      IF(MM.EQ.180)A(IB+9)=AMAX1(A(IB+9),U)
      IF(MM.EQ.188)A(IB+8)=AMAX1(A(IB+8),U)
  62  IF(MU.EQ.K)GOTO 47
      MU=K
      GOTO 61
C
C DFIX
C
  63  IF(NK.NE.50)GOTO 69
      IF(A(142).LT.-0.5)GOTO 44
      KR='DFIX'
      MM=181
      IF(T.GT.0.)GOTO 64
      MM=180
      KR='BUMP'
  64  IF(R.GT.0.)GOTO 65
      MM=182
      KR='DANG'
  65  MN=N
      T=ABS(T)
      R=ABS(R)
      NI=INT((T+5.)*.1)
      IF(NI.LE.1)GOTO 66
      P=AMOD(T+5.,10.)-5.
      T=P*A(NI+LT)
  66  MN=MN+2
      IF(MN.EQ.45)GOTO 17
      IF(MN.GE.NN)GOTO 44
      L=4
      N=MN
      NL=MN+2
      I=INT(A(N))
      K=INT(A(N+1))
      X=A(I+17)-A(K+17)
      Y=A(I+18)-A(K+18)
      Z=A(I+19)-A(K+19)
      S=SQRT(A(8)*X**2+A(9)*Y**2+A(10)*Z**2+A(11)*Y*Z+
     +A(12)*X*Z+A(13)*X*Y)
      IF(MM.NE.180)GOTO 67
      IF(S.GT.T)GOTO 66
  67  NB=0
      IF(LK.EQ.MV)GOTO 59
      U=(A(8)*X+0.5*(A(12)*Z+A(13)*Y))/S
      V=(A(9)*Y+0.5*(A(11)*Z+A(13)*X))/S
      W=(A(10)*Z+0.5*(A(11)*Y+A(12)*X))/S
      NJ=0
      IF(NI.LE.1)GOTO 68
      NB=1
      MK(1)=NI
      SI(1)=-P
  68  CALL SXDX(I,DX,DY,DZ,IX,IY,IZ,NX,NY,NZ,LM,A)
      CALL SXDD(SI,MK,DX,IX,U,NB,NX,LU)
      CALL SXDD(SI,MK,DY,IY,V,NB,NY,LU)
      CALL SXDD(SI,MK,DZ,IZ,W,NB,NZ,LU)
      NJ=NJ+1
      IF(NJ.GT.1)GOTO 47
      I=K
      U=-U
      V=-V
      W=-W
      GOTO 68
C
C CHIV and FLAT
C
  69  KR='CHIV'
      MM=185
      IF(ABS(T).LT.0.0001)MM=184
      IF(NK.EQ.56)GOTO 70
      R=AMAX1(T,0.001)
      T=0.
      IF(NK.NE.55)GOTO 78
      KR='FLAT'
      MM=186
      N=N-1
      NJ=0
      GOTO 71
  70  NJ=INT((ABS(T)+5.)*.1)
      IF(NJ.LE.1)GOTO 71
      Z=SIGN(.5,T+5.)
      P=AMOD(T+5.,10.)-10.*Z
      T=P*(A(NJ+LT)+Z-.5)
  71  IF(A(142).LT.-0.5)GOTO 44
      MN=0
      NI=3
      N=N+2
        DO 72 K=N,NN-1
        MN=MN+1
        MB(MN)=INT(A(K))
  72    CONTINUE
      M=1
        DO 73 K=1,3
        I=MB(K)
        F(M)=A(I+17)
        F(M+1)=A(I+18)
        F(M+2)=A(I+19)
        M=M+3
  73    CONTINUE
  74  NI=NI+1
      IF(NI.GT.MN)GOTO 87
      I=MB(NI)
      MB(4)=I
      F(10)=A(I+17)
      F(11)=A(I+18)
      F(12)=A(I+19)
        DO 75 K=1,3
        G(K)=F(K)-F(K+9)
        G(K+3)=F(K+3)-F(K+9)
        G(K+6)=F(K+6)-F(K+9)
  75    CONTINUE
      S=A(20)*(G(1)*(G(6)*G(8)-G(5)*G(9))+G(4)*(G(2)*G(9)-
     +G(3)*G(8))+G(7)*(G(3)*G(5)-G(2)*G(6)))
      NB=0
      IF(LK.EQ.MV)GOTO 47
      IF(NJ.LE.1)GOTO 76
      NB=1
      MK(1)=NJ
      SI(1)=-P
  76  V=A(20)
      M=4
      K=7
        DO 77 MT=1,4
        I=M
        M=K
        K=MOD(K+3,12)
        CALL SXDX(MB(MT),DX,DY,DZ,IX,IY,IZ,NX,NY,NZ,LM,A)
        U=V*(F(I+2)*(F(M+1)-F(K+1))+F(M+2)*(F(K+1)-F(I+1))+
     +  F(K+2)*(F(I+1)-F(M+1)))
        CALL SXDD(SI,MK,DX,IX,U,NB,NX,LU)
        U=V*(F(I)*(F(M+2)-F(K+2))+F(M)*(F(K+2)-F(I+2))+
     +  F(K)*(F(I+2)-F(M+2)))
        CALL SXDD(SI,MK,DY,IY,U,NB,NY,LU)
        U=V*(F(I+1)*(F(M)-F(K))+F(M+1)*(F(K)-F(I))+
     +  F(K+1)*(F(I)-F(M)))
        CALL SXDD(SI,MK,DZ,IZ,U,NB,NZ,LU)
        V=-V
  77    CONTINUE
      GOTO 47
C
C ISOR
C
  78  IF(NK.NE.60)GOTO 85
      IF(A(142).GT.0.5)GOTO 44
      KR='ISOR'
      MM=189
      L=8
  79  N=N+1
      IF(N.GE.NN)GOTO 44
      I=INT(A(N))
      IF(A(I+3).GT.0.)GOTO 79
      CALL SXDU(I,DX,IX,NX,LM,A)
      NI=I+20
        DO 84 M=2,7
        NI=NI+1
        U=0.
        NJ=I+21
          DO 80 K=2,7
          V=A(M+113)*A(K+134)
          SI(K)=V*DX(K)
          U=U+V*A(NJ)
          NJ=NJ+1
  80      CONTINUE
        U=U-A(NI)
        SI(M)=SI(M)-DX(M)
        IF(ABS(A(51)).GT.2.5)GOTO 81
        IF(ABS(U).LT.3.*R)GOTO 82
        IF(NE.EQ.0)GOTO 82
  81    KR(5:8)=KP(M+3)
        L=9
        KR(L:L)=' '
        CALL SXAN(I,KR,L,LM,A)
        IF(NT.EQ.0)WRITE(LI,2)LK
        NT=1
        WRITE(LI,4)U,R,KR(1:L)
  82    W=A(62)/R**2
        A(132)=A(132)+1.
        V=(U/R)**2
        A(133)=A(133)+V
        A(MM)=A(MM)+R**2
        A(MM+10)=A(MM+10)+U**2
        WL(MM-179)=WL(MM-179)+1.
        IF(LK.EQ.MV)GOTO 84
        NB=0
          DO 83 K=2,7
          IF(IX(K).EQ.0)GOTO 83
          IF(ABS(SI(K)).LT.0.0001)GOTO 83
          NB=NB+1
          MK(NB)=IX(K)
          SI(NB)=SI(K)
  83      CONTINUE
        U=SIGN(AMIN1(10.*R,ABS(U)),U)
        IF(NB.GT.0)CALL SXAM(SI,MK,W,U,JD,NB,JE,JW,B)
  84    CONTINUE
      GOTO 79
C
C SAME and SADI
C
  85  IF(NK.NE.51)GOTO 93
      IF(A(142).LT.-0.5)GOTO 44
      KR='SAME/SADI'
      MM=183
      RZ=0.25*REAL(NN-N-1)
      MN=N-1
  86  MN=MN+2
      IF(MN.LT.NN)GOTO 88
  87  IF(UM.LT.0.)GOTO 44
      IF(NT.EQ.0)WRITE(LI,2)LK
      NT=1
      WRITE(LI,4)UM,R,KR(1:L)
      GOTO 44
  88  NL=MN
      I=INT(A(MN))
      MB(1)=I
      K=INT(A(MN+1))
      MB(2)=K
      X=A(I+17)-A(K+17)
      Y=A(I+18)-A(K+18)
      Z=A(I+19)-A(K+19)
      Q=-SQRT(A(8)*X**2+A(9)*Y**2+A(10)*Z**2+A(11)*Y*Z+
     +A(12)*X*Z+A(13)*X*Y)
      NA=0
      IF(LK.EQ.MV)GOTO 90
      U=(A(8)*X+0.5*(A(12)*Z+A(13)*Y))/Q
      V=(A(9)*Y+0.5*(A(11)*Z+A(13)*X))/Q
      W=(A(10)*Z+0.5*(A(11)*Y+A(12)*X))/Q
      NJ=0
  89  CALL SXDX(I,DX,DY,DZ,IX,IY,IZ,NX,NY,NZ,LM,A)
      CALL SXDD(SQ,MH,DX,IX,U,NA,NX,LU)
      CALL SXDD(SQ,MH,DY,IY,V,NA,NY,LU)
      CALL SXDD(SQ,MH,DZ,IZ,W,NA,NZ,LU)
      NJ=NJ+1
      IF(NJ.GT.1)GOTO 90
      I=K
      U=-U
      V=-V
      W=-W
      GOTO 89
  90  NL=NL+2
      IF(NL.GE.NN)GOTO 86
      I=INT(A(NL))
      MB(3)=I
      K=INT(A(NL+1))
      MB(4)=K
      X=A(I+17)-A(K+17)
      Y=A(I+18)-A(K+18)
      Z=A(I+19)-A(K+19)
      S=SQRT(A(8)*X**2+A(9)*Y**2+A(10)*Z**2+A(11)*Y*Z+
     +A(12)*X*Z+A(13)*X*Y)
      NB=NA
      U=(A(8)*X+0.5*(A(12)*Z+A(13)*Y))/S
      V=(A(9)*Y+0.5*(A(11)*Z+A(13)*X))/S
      W=(A(10)*Z+0.5*(A(11)*Y+A(12)*X))/S
      S=S+Q
      IF(LK.EQ.MV)GOTO 47
      NJ=0
        DO 91 MT=1,NA
        MK(MT)=MH(MT)
        SI(MT)=SQ(MT)
  91    CONTINUE
  92  CALL SXDX(I,DX,DY,DZ,IX,IY,IZ,NX,NY,NZ,LM,A)
      CALL SXDD(SI,MK,DX,IX,U,NB,NX,LU)
      CALL SXDD(SI,MK,DY,IY,V,NB,NY,LU)
      CALL SXDD(SI,MK,DZ,IZ,W,NB,NZ,LU)
      NJ=NJ+1
      IF(NJ.GT.1)GOTO 47
      I=K
      U=-U
      V=-V
      W=-W
      GOTO 92
C
C DELU
C
  93  N=N+1
      IF(A(142).GT.0.5)GOTO 44
      IF(NK.NE.58)GOTO 103
      KR='DELU'
      MM=187
      I=INT(A(N))
      IF(A(I+3).GT.0.)GOTO 44
      K=INT(A(N+1))
      IF(A(K+3).GT.0.)GOTO 44
      X=A(K+17)-A(I+17)
      Y=A(K+18)-A(I+18)
      Z=A(K+19)-A(I+19)
      S=A(8)*X**2+A(9)*Y**2+A(10)*Z**2+A(11)*Y*Z+A(12)*X*Z+A(13)*X*Y
      IF(S.LT.0.0001)GOTO 44
      S=1./SQRT(S)
      U=S*(A(8)*X+F(15)*Y+F(14)*Z)
      V=S*(F(15)*X+A(9)*Y+F(13)*Z)
      W=S*(F(14)*X+F(13)*Y+A(10)*Z)
      G(1)=F(16)*U**2
      G(2)=F(17)*V**2
      G(3)=F(18)*W**2
      G(4)=F(19)*V*W
      G(5)=F(20)*U*W
      G(6)=F(21)*U*V
      S=0.
      CALL SXDU(I,DX,IX,NX,LM,A)
      NI=I+21
      IF(A(I+3).LT.0.)GOTO 94
      S=S+A(NI)
      NA=1
      SI(NA)=DX(2)
      MK(NA)=IX(2)
      GOTO 96
  94    DO 95 M=1,6
        S=S+G(M)*A(NI)
        MK(M)=IX(M+1)
        SI(M)=DX(M+1)*G(M)
        NI=NI+1
  95    CONTINUE
      NA=6
  96  CALL SXDU(K,DY,IY,NY,LM,A)
      NI=K+21
      IF(A(K+3).LT.0.)GOTO 97
      S=S-A(NI)
      NA=NA+1
      SI(NA)=-DY(2)
      MK(NA)=IY(2)
      GOTO 99
  97    DO 98 M=1,6
        S=S-G(M)*A(NI)
        NA=NA+1
        MK(NA)=IY(M+1)
        SI(NA)=-DY(M+1)*G(M)
        NI=NI+1
  98    CONTINUE
  99    DO 102 M=1,NA
        IF(MK(M).EQ.0)GOTO 102
        IF(ABS(SI(M)).LT.0.0001)GOTO 102
        NI=0
 100    NI=NI+1
        IF(NI.GT.NB)GOTO 101
        IF(MK(NI).NE.MK(M))GOTO 100
        SI(NI)=SI(NI)+SI(M)
        IF(ABS(SI(NI)).GT.0.0001)GOTO 102
        MK(NI)=MK(NB)
        SI(NI)=SI(NB)
        NB=NB-1
        GOTO 102
 101    NB=NB+1
        MK(NB)=MK(M)
        SI(NB)=SI(M)
 102    CONTINUE
      IF(NK.EQ.59)GOTO 60
      GOTO 47
C
C SIMU
C
 103  IF(NK.NE.59)GOTO 44
      KR='SIMU'
      MM=188
      I=INT(A(N))
      K=INT(A(N+1))
      CALL SXDU(I,DX,IX,NX,LM,A)
      CALL SXDU(K,DY,IY,NY,LM,A)
      IF(AMIN1(A(I+3),A(K+3)).LT.0.)GOTO 104
      S=A(I+21)-A(K+21)
      MK(1)=IX(2)
      SI(1)=DX(2)
      MK(2)=IY(2)
      SI(2)=-DY(2)
      NA=2
      GOTO 99
 104  IF(A(I+3).LT.0.)GOTO 106
      NI=I+21
        DO 105 M=3,7
        NI=NI+1
        A(NI)=A(I+21)
        IX(M)=IX(2)
        DX(M)=DX(2)
        IF(M.GT.4)DX(M)=DX(M)*A(M+113)
 105    CONTINUE
 106  IF(A(K+3).LT.0.)GOTO 108
      NI=K+21
        DO 107 M=3,7
        NI=NI+1
        A(NI)=A(K+21)
        IY(M)=IY(2)
        DY(M)=DY(2)
        IF(M.LT.5)GOTO 107
        A(NI)=A(NI)*A(M+113)
        DY(M)=DY(M)*A(M+113)
 107    CONTINUE
 108  S=0.
      NI=I+20
      NJ=K+20
      IQ=I
      IK=I
        DO 115 M=2,7
        N=NL-2
        NB=0
        NI=NI+1
        NJ=NJ+1
        U=A(NI)-A(NJ)
        MK(1)=IX(M)
        SI(1)=DX(M)
        IF(IX(M).GT.0)NB=1
        MK(NB+1)=IY(M)
        SI(NB+1)=-DY(M)
        IF(IY(M).GT.0)NB=NB+1
        IF(ABS(A(51)).GT.2.5)GOTO 109
        IF(ABS(U).LT.3.*R)GOTO 111
        IF(NE.EQ.0)GOTO 111
 109    KR(5:8)=KP(M+3)
        L=8
          DO 110 I=N,N+1
          K=INT(A(I))
          L=L+1
          KR(L:L)=' '
          CALL SXAN(K,KR,L,LM,A)
 110      CONTINUE
        IF(NT.EQ.0)WRITE(LI,2)LK
        NT=1
        WRITE(LI,4)U,R,KR(1:L)
 111    IF(LK.NE.MV)GOTO 114
        MU=IQ
 112    MZ=(MU-LB)/32+LE+40
        MW=INT(A(MZ))
        IF(MW.EQ.0)GOTO 113
        A(MW+8)=AMAX1(A(MW+8),ABS(U))
 113    IF(MU.EQ.IK)GOTO 114
        MU=IK
        GOTO 112
 114    W=A(62)/R**2
        A(132)=A(132)+1.
        V=(U/R)**2
        A(133)=A(133)+V
        A(MM)=A(MM)+R**2
        A(MM+10)=A(MM+10)+U**2
        WL(MM-179)=WL(MM-179)+1.
        IF(NB.EQ.0)GOTO 115
        IF(LK.EQ.MV)GOTO 115
        U=SIGN(AMIN1(10.*R,ABS(U)),U)
        CALL SXAM(SI,MK,W,U,JD,NB,JE,JW,B)
 115    CONTINUE
      GOTO 44
C
C Summary of restraints
C
 116  IF(A(132).LT.0.5)GOTO 119
      IF(LK.EQ.MV)GOTO 117
      IF(ABS(A(51)).LT.0.5)GOTO 119
 117    DO 118 I=180,189
        T=AMAX1(WL(I-179),0.1)
        A(I)=AMIN1(9999.999,SQRT(A(I)/T))
        A(I+10)=AMIN1(9999.999,SQRT(A(I+10)/T))
 118    CONTINUE
      T=AMAX1(WL(11),0.1)
      WL(12)=AMIN1(9999.999,SQRT(WL(12)/T))
      WL(13)=AMIN1(9999.999,SQRT(WL(13)/T))
      WRITE(LI,5)LK,(WL(I),I=1,11),(A(I),I=180,189),WL(12),
     +(A(I),I=190,199),WL(13)
C
C Polar axis restraints - identify x, y and z type parameters
C
 119  IF(LK.EQ.MV)GOTO 137
      IF(A(154).LT.0.5)GOTO 138
      IF(A(142).LT.-0.5)GOTO 138
      IF(A(177).LT.0.)GOTO 138
      JE=(JD*(JD+3))/2
      JF=JE+JD
      N=(LX-LB+16)/32
      JR=N
      N=2*N+NP
      CALL SXZA(B(JE+1),N)
      NA=0
      NB=0
      NN=LB-16
 120  NN=NN+32
      IF(NN.GT.LX)GOTO 123
      IF(A(NN+5).GT.1.)GOTO 120
      IF(A(NN+28).GT.0.05)GOTO 120
      IF(A(NN+31).LT.0.)GOTO 120
      IF(INT(ABS(A(NN+3))).EQ.KH)GOTO 120
      NB=NB+1
      IF(AMOD(A(NN+5),0.2).LT.0.05)GOTO 120
      IF(MOD(INT(ABS(A(NN+6))),10).EQ.1)GOTO 120
      NB=NB-1
      NA=NA+4
      K=0
      N=INT(A(NN+30))
        DO 122 I=NN+7,NN+9
        K=K+1
        IF(A(I).GT.1.E6)GOTO 122
        M=INT(.1*(ABS(A(I))+5.))
        IF(M.EQ.1)GOTO 122
        IF(M.GT.1)GOTO 121
        N=N+1
        M=N
 121    B(JE+M)=REAL(K+NA)
 122    CONTINUE
      GOTO 120
C
C Scan over all l.s. matrix elements to sum b and q
C
 123  IF(NB.GT.7)GOTO 138
      J=JD
        DO 126 N=1,NP
          DO 125 M=N,NP
          J=J+1
          K=INT(B(JE+M))
          IF(K/4.EQ.0)GOTO 125
          I=INT(B(JE+N))
          IF(K/4.NE.I/4)GOTO 125
          JG=JF+(K/4)
          K=MOD(K,4)
          I=MOD(I,4)
          L=141+K+3*I
          IF(K.NE.I)GOTO 124
          B(JG)=B(JG)+A(L)
          B(JG+JR)=B(JG+JR)+A(L)*B(J)
          GOTO 125
 124      B(JG+JR)=B(JG+JR)+2.*A(L)*B(J)
 125      CONTINUE
 126    CONTINUE
      JG=JF+JR
        DO 127 J=JF+1,JG
        IF(B(J).GT.0.1)B(J+JR)=B(J+JR)/B(J)
 127    CONTINUE
      JH=JG+JR
      B(JH+1)=SQRT(AMAX1(1.E4,B(JG+1)))
      B(JH+2)=SQRT(AMAX1(1.E4,B(JG+2)))
      IF(NA.LT.12)GOTO 134
C
C Solve equations for a
C
      NA=JR
      JJ=JH+JR
      CALL SXZA(B(JF+1),NA)
      V=REAL(NA-1)
      U=REAL(NA-2)/V
      W=0.
        DO 128 J=JG+1,JH
        W=W+B(J)
 128    CONTINUE
        DO 133 M=1,20
          DO 129 J=JG+1,JH
          B(J+JR)=B(J)*SQRT(U/AMAX1(1.E-8,W-2.*B(J)+B(J-JR)))
 129      CONTINUE
        S=0.
          DO 132 JI=JH+1,JJ
          T=B(JI)
            DO 130 J=JH+1,JJ
            T=T-B(J)
 130        CONTINUE
          T=T/V
          S=0.
            DO 131 J=JH+1,JJ
            IF(JI.NE.J)S=S+(B(J)+T)**2
 131        CONTINUE
          J=JI-2*JR
          B(J)=S
 132      CONTINUE
 133    CONTINUE
C
C Add origin restraints to l.s. matrix
C
 134  J=JD
        DO 136 N=1,NP
        I=INT(B(JE+N))
        NI=MOD(I,4)
        I=I/4
          DO 135 M=N,NP
          J=J+1
          K=INT(B(JE+M))
          NK=MOD(K,4)
          IF(NI*NK.EQ.0)GOTO 135
          K=K/4
          L=141+NK+3*NI
          B(J)=B(J)+B(JH+I)*B(JH+K)*A(L)
 135      CONTINUE
 136    CONTINUE
 137  A(132)=A(132)+A(154)
C
C Restrained GooF
C
 138  A(130)=A(130)/AMAX1(A(131),1.E-8)
      A(131)=99.9999
      T=A(125)+A(132)-A(179)-A(91)
      IF(T.GT.1.)A(131)=SQRT((A(62)*A(133)+A(128))/T)
      JR=INT(A(132))
      WRITE(LI,3)
      WRITE(LI,6)A(127),A(131),JR
      WRITE(*,6)A(127),A(131),JR
      CALL SXFL
      IF(ABS(A(69)-0.333333).GT.0.0001)GOTO 140
        DO 139 I=66,68
        IF(ABS(A(I)).GT.1.E-6)GOTO 140
 139    CONTINUE
      WRITE(LI,7)A(64),A(65)
      GOTO 141
 140  T=1.-A(69)
      WRITE(LI,8)A(70),A(71),A(66),A(67),A(65),A(64),A(68),A(69),T
 141  RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SX3J(LM,JW,LU,MH,MK,ML,MB,FF,SI,FC,SQ,WL,A,B)
C
C Structure-factor and least-squares calculations - Part 3
C
      CHARACTER*1 IH(50),KD
      CHARACTER*2 KA(94)
      CHARACTER*4 KP(24),KQ,KX,KY,KZ
      CHARACTER*14 KT
      CHARACTER*76 IT
      CHARACTER*80 NM,IR
      CHARACTER*128 KR
      INTEGER MH(LU),MK(LU),ML(LU),MB(LU),IX(9),IY(9),IZ(9),IU(9)
      REAL FF(LU),SI(LU),FC(LU),SQ(LU),WL(LU),A(LM),B(JW)
      COMMON/MEM/ST,SL,TC,TL,IV,LR,LG,LH,LI,LP,LF,LA,LC,LW,LY,LL,LB,
     +LX,LE,LV,LJ,LD,LS,LO,LT,LK,LQ,LZ,LN,KH,JA,JB,JC,JD,JE,HA,HD
      REAL DX(9),DY(9),DZ(9),DU(9),F(25),G(11)
      COMMON/WORD/IH,IT,IR,NM,KA,KD
C
      DATA KP/'  x ','  y ','  z ',' sof',' U11',' U22',' U33',
     +' U23',' U13',' U12','EXTI','BASF','FVAR','size','rotX',
     +'rotY','rotZ','dist',' OSF','    ','tors','Uiso',' rho','SWAT'/
   1  FORMAT(/'     N      value        esd    shift/esd  ',
     +'parameter'/)
   2  FORMAT(/A//I6,' Parameters refined in final cycle')
   3  FORMAT(/I9,' Correlation matrix elements follow as upper ',
     +'triangular matrix'/)
   4  FORMAT(10F8.5)
   5  FORMAT(I6,2F12.5,F10.3,3X,A)
   6  FORMAT(A4,I3,' ')
   7  FORMAT(' Mean shift/esd =',F8.3,'    Maximum =',
     +F8.3,' for ',A,2X,A)
   8  FORMAT(//' Constrained refinement of X-H distances'//
     +' Distance   esd   AFIX   Bond(s)'/)
   9  FORMAT(2F8.3,I5,3X,A)
  10  FORMAT(F8.3,8X,I5,3X,A)
  11  FORMAT(//' Largest correlation matrix elements'/)
  12  FORMAT(F8.3)
  13  FORMAT(A)
  14  FORMAT(/' No correlation matrix elements larger than',F7.3)
  15  FORMAT(' R1 =',F8.4,' for',I7,' Fo > 4sig(Fo)  and',F8.4,
     +' for all',I7,' data')
  16  FORMAT(' wR2 =',F8.4,',  GooF = S =',F8.3,',  Restrained ',
     +'GooF = ',F8.3,'  for all data')
  17  FORMAT(' R1(Free) =',F8.4,' for',I6,' Fo > 4sig(Fo)  and',
     +F8.4,' for all',I6,' data')
  18  FORMAT('REM',I7,' parameters refined using',I7,' restraints')
  19  FORMAT(/' RMS deviation from FLAT planes =',F8.4,'  for',I6,
     +' atoms')
  20  FORMAT(/' Flack x parameter =',F9.4,'   with esd',F8.4/
     +' Expected values are 0 (within 3 esd''s) for correct and ',
     +'+1 for inverted absolute structure.'/' Note that this rough',
     +' estimate ignores correlation with other parameters; if the'/
     +' above value differs significantly from zero, it is ',
     +'ESSENTIAL to test the'/' inverted structure or refine x ',
     +'as a full-matrix parameter using TWIN and BASF')
  21  FORMAT(/' Absolute structure cannot be determined reliably')
  22  FORMAT(/' ** Possible racemic twin or wrong absolute ',
     +'structure - try TWIN refinement **'/)
  23  FORMAT(/'   ** Absolute structure probably wrong - ',
     +'invert and repeat refinement **'/)
C
      MV=INT(ABS(A(177))+1.1)
      NP=JD
      IC=LS
      IF(A(167).LT.-0.5)IC=IC-12
      ID=LS
      IF(ABS(A(167)).GT.0.5)ID=ID-12
      NE=JB
      IF(LK.NE.MV)GOTO 24
      CALL SXTO(15)
      IF(ABS(A(177)).LT.0.5)GOTO 123
      GOTO 224
C
C Update and print global parameters and esd's
C
  24  KR=' Parameter shifts / values:'
      NQ=31
      NW=31
      CALL SXTO(14)
      CALL SXIM(LI,NP,LK,LO,LM,JW,A,B)
      CALL SXTO(15)
      CALL SXFN(I)
      IF(I.LT.0)MV=MIN0(MV,LK+1)
      CALL SXTI(T)
      IF(T.GT.TL)MV=MIN0(MV,LK+1)
      A(177)=SIGN(REAL(MV)-.9,A(177))
      A(75)=A(144)*AMAX1(1.+B(1),0.5)
      M=1
      KT=KP(20)
      A(92)=0.
      A(93)=0.
      Q=9.E9
      IF(A(177).LT.0.)GOTO 28
      IF(LK.EQ.MV-1)Q=3.
      IF(ABS(A(51)).LT.0.5)GOTO 25
      Q=3.
      IF(ABS(A(51)).GT.1.5)Q=1.
      IF(LK.EQ.MV-1)Q=Q/3.
      IF(ABS(A(51)).GT.2.5)Q=-1.
  25  IF(Q.GT.8.E9)GOTO 26
      WRITE(LI,5)
      WRITE(LI,1)
  26  IF(LK.NE.MV-1)GOTO 27
      IF(A(51).GE.-0.5)GOTO 27
      WRITE(LQ,2)IT,NP
      WRITE(LQ,1)
  27  JE=NP
      JF=JA
      JA=JA+JE+JE
      JG=JF-1
      JK=JG-JE
      B(JF)=19.1
      B(JF+JE)=0.
      J=NP+1
  28  X=SQRT(A(75))
      B(1)=X-SQRT(A(63))
      IR=KP(19)
      L=4
      W=1.
  29  IF(A(177).LT.0.)GOTO 32
      U=A(131)*SQRT(ABS(B(J)))
      IF(M.EQ.1)U=.5*A(131)*SQRT(ABS(A(144)*B(J)))
      V=B(M)/AMAX1(U,1.E-6)
      S=U*W
      IF(S.GT.9.99999)S=9.99999
      A(92)=A(92)+ABS(V)
      IF(ABS(V).LT.ABS(A(93)))GOTO 30
      A(93)=V
      KT=IR(1:14)
  30  J=J+NP-M+1
      IF(Q.GT.8.E9)GOTO 31
      WRITE(LI,5)M,X,S,V,IR(1:L)
  31  IF(LK.NE.MV-1)GOTO 36
      IF(A(51).LT.-0.5)WRITE(LQ,5)M,X,S,V,IR(1:L)
      GOTO 36
  32  IF(LK.EQ.MV-1)GOTO 33
      IF(ABS(A(51)).LT.0.5)GOTO 36
  33  IF(NW.LT.92)GOTO 34
      WRITE(LI,'(A)')KR(1:NQ-2)
      KR=' '
      NQ=1
      NW=1
  34  NQ=NQ+L
      KR(NQ-L+1:NQ)=IR(1:L)
      WRITE(IR,'(2F12.5)')W*B(M),X
      IR(13:13)='/'
      NQ=NQ+1
        DO 35 I=1,24
        IF(IR(I:I).EQ.' ')GOTO 35
        NQ=NQ+1
        KR(NQ:NQ)=IR(I:I)
  35    CONTINUE
      NW=NW+30
      NQ=MAX0(NQ+2,NW)
  36  W=1.
      M=M+1
      IF(M.GT.LV-LT)GOTO 37
      WRITE(IR,6)KP(13),M
      L=8
      X=A(M+LT)+B(M)
      A(M+LT)=X
      IF(A(177).LT.0.)GOTO 32
      JF=JF+1
      B(JF)=13.1
      B(JF+JE)=-0.1-REAL(M)
      GOTO 29
  37  N=M-LV+LT
      IF(N.GT.IC-LD)GOTO 40
      IF(N+LD.GT.ID)GOTO 38
      IF(INT(A(160)).EQ.0)W=A(N+LD)
      X=AMAX1(0.00001,A(N+LD)+W*B(M))
      A(N+LD)=X
      IF(ABS(A(160)-2.2).GT.0.01)GOTO 39
      A(156)=X
      A(157)=0.
      IF(A(177).GT.0.)A(157)=A(131)*SQRT(ABS(B(J)))
      GOTO 39
  38  W=10.
      X=A(N+LD)+W*B(M)
      A(N+LD)=X
  39  WRITE(IR,6)KP(12),N
      L=8
      IF(A(177).LT.0.)GOTO 32
      JF=JF+1
      B(JF)=12.1
      B(JF+JE)=-0.1-REAL(N)
      GOTO 29
  40  IF(M.EQ.NE)GOTO 41
      IF(M.NE.NE+1)GOTO 43
      IF(A(200).LT.-998.)GOTO 43
      W=1000.
      X=AMAX1(0.,A(200)+B(M)*W)
      L=2
      WRITE(IR,6)KP(24),L
      L=8
      A(200)=X
      IF(A(177).LT.0.)GOTO 32
      JF=JF+1
      B(JF)=24.1
      B(JF+JE)=-2.1
      GOTO 29
  41  IF(A(200).GT.-998.)W=50.
      X=AMAX1(0.,A(39)+B(M)*W)
      IR=KP(11)
      L=4
      IF(A(200).LT.-998.)GOTO 42
      L=1
      WRITE(IR,6)KP(24),L
  42  L=8
      A(39)=X
      A(40)=0.
      IF(A(177).LT.0.)GOTO 32
      A(40)=A(131)*SQRT(ABS(B(J)))*W
      JF=JF+1
      B(JF)=11.1
      B(JF+JE)=0.
      IF(A(200).LT.-998.)GOTO 29
      B(JF)=24.1
      B(JF+JE)=-1.1
      GOTO 29
C
C Print rigid group and riding parameter shifts and esd's
C
  43  NN=LB-16
      JB=JA-2
      TQ=-1.
      UQ=0.
      MQ=0
      MU=0
  44  NN=NN+32
      IF(NN.GT.LX)GOTO 88
      PX=A(NN+17)
      PY=A(NN+18)
      PZ=A(NN+19)
      CALL SXZA(G,10)
      NI=MOD(INT(ABS(A(NN+6))),10)
      NL=INT(A(NN+27))
      NU=4
      K=INT(A(NN+5))
      IF(K.EQ.0)GOTO 45
      L=INT(A(K+27))
      CALL SXCA(A(K+7),A(NN+7),3)
      CALL SXCA(A(K+17),A(NN+17),3)
      GOTO 57
  45  IF(NI.EQ.1)GOTO 72
      T=AMOD(A(NN+5),1.)
      IF(AMOD(T,.2).LT.0.05)GOTO 57
      NJ=INT(10.*AMOD(A(NN+28),1.))
      NK=14
      IF(NI.EQ.9)GOTO 46
      NK=15
      IF(NI.EQ.6)GOTO 46
      NK=21
      IF(NJ.EQ.3)GOTO 46
      IF(NJ.EQ.4)GOTO 46
      NK=18
      IF(NJ.NE.2)GOTO 56
  46  F(NK)=B(M)
      IF(NK.EQ.18)F(NK)=10.*F(NK)
      IF(NK.EQ.21)F(NK)=10.*F(NK)
      IR=KP(NK)
      L=5
      CALL SXAN(NN,IR,L,LM,A)
      IF(A(177).LT.0.)GOTO 49
      JF=JF+1
      B(JF)=REAL(NK)
      B(JF+JE)=REAL(NN)
      S=A(131)*SQRT(ABS(B(J)))
      IF(NK.EQ.18)S=10.*S
      IF(NK.EQ.21)S=10.*S
      V=F(NK)/AMAX1(S,1.E-6)
      IF(S.GT.9.99999)S=9.99999
      A(92)=A(92)+ABS(V)
      IF(ABS(V).LT.ABS(A(93)))GOTO 47
      A(93)=V
      KT=IR(1:14)
  47  IF(ABS(V).LT.Q)GOTO 48
      WRITE(LI,5)M,F(NK),S,V,IR(1:L)
  48  IF(LK.NE.MV-1)GOTO 52
      IF(A(51).LT.-0.5)WRITE(LQ,5)M,F(NK),S,V,IR(1:L)
      GOTO 52
  49  IF(ABS(A(51)).LT.2.5)GOTO 52
      IF(NW.LT.92)GOTO 50
      WRITE(LI,'(A)')KR(1:NQ-2)
      KR=' '
      NQ=1
      NW=1
  50  NQ=NQ+L
      KR(NQ-L+1:NQ)=IR(1:L)
      WRITE(IR,'(F12.5)')F(NK)
      NQ=NQ+1
        DO 51 I=1,12
        IF(IR(I:I).EQ.' ')GOTO 51
        NQ=NQ+1
        KR(NQ:NQ)=IR(I:I)
  51    CONTINUE
      NW=NW+30
      NQ=MAX0(NQ+2,NW)
  52  IF(NK.NE.18)GOTO 53
      JB=JB+2
      B(JB)=REAL(NN)+.1
      B(JB+1)=S
  53  J=J+NP-M+1
      M=M+1
      NK=NK+1
      IF(NK.LT.18)GOTO 46
      IF(NK.GT.18)GOTO 55
        DO 54 I=15,17
        F(I-4)=SIN(F(I))
        F(I)=COS(F(I))
  54    CONTINUE
      IF(NI.EQ.6)F(14)=0.
      GOTO 56
  55  IF(NK.EQ.19)GOTO 56
      NK=18
      IF(NJ.EQ.3)GOTO 46
C
C Print xyz and Uij parameter shifts and esd's
C
  56  NU=1
  57  NT=5
      IF(A(NN+3).LT.0.)NT=10
      IF(ABS(A(NN+31)).GT.1.)NT=4
      IF(T.LT.0.2)NT=3
      IF(NI.EQ.6)GOTO 58
      IF(NI.EQ.9)GOTO 58
      IF(NI.GT.2)NU=4
      IF(NI.EQ.2)NT=MIN0(NT,4)
  58  N=NN+NU+5
        DO 69 NK=NU,NT
        N=N+1
        IF(A(N).LT.1.E6)GOTO 59
        K=MOD(INT(1.E-6*A(N)+.5),10)
        P=AINT(1.E-7*A(N)+.05)
        S=AINT(48.1*(1.E-5*A(N)-10.*REAL(K)-100.*P))/48.
        P=P*.5-2.5
        K=K+NN+16
        G(NK)=A(K)*P+S-A(N+10)
        GOTO 69
  59    K=INT((ABS(A(N))+5.)*.1)+LT
        IF(K.EQ.LT)GOTO 60
        IF(K.EQ.LT+1)GOTO 69
        R=SIGN(.5,A(N)+5.)
        G(NK)=(AMOD(A(N)+5.,10.)-10.*R)*(R+A(K)-.5)-A(N+10)
        GOTO 69
  60    IF(NK.NE.5)GOTO 61
        IF(ABS(A(N)+2.75).LE.2.25)GOTO 69
  61    IR=KP(NK)
        L=5
        CALL SXAN(NN,IR,L,LM,A)
        IF(A(177).LT.0.)GOTO 62
        JF=JF+1
        B(JF)=REAL(NK)
        B(JF+JE)=REAL(NN)
  62    V=B(M)
        S=A(N)
        A(N)=AMAX1(-4.,AMIN1(4.,S+V))
        IF(NK.EQ.4)A(N)=AMIN1(A(N),A(78))
        IF(NK.GT.4)A(N)=AMAX1(-1.,AMIN1(A(N),2.))
        IF(IABS(NK-6).LT.2)A(N)=AMAX1(.00001,A(N))
        G(NK)=A(N)-S
        IF(A(177).LT.0.)GOTO 65
        S=A(131)*SQRT(ABS(B(J)))
        V=V/AMAX1(S,1.E-6)
        IF(S.GT.9.99999)S=9.99999
        A(92)=A(92)+ABS(V)
        IF(ABS(V).LT.ABS(A(93)))GOTO 63
        A(93)=V
        KT=IR(1:14)
  63    J=J+NP-M+1
        IF(ABS(V).LT.Q)GOTO 64
        WRITE(LI,5)M,A(N),S,V,IR(1:L)
  64    IF(LK.NE.MV-1)GOTO 68
        IF(A(51).LT.-0.5)WRITE(LQ,5)M,A(N),S,V,IR(1:L)
        GOTO 68
  65    IF(ABS(A(51)).LT.2.5)GOTO 68
        IF(NW.LT.92)GOTO 66
        WRITE(LI,'(A)')KR(1:NQ-2)
        KR=' '
        NQ=1
        NW=1
  66    NQ=NQ+L
        KR(NQ-L+1:NQ)=IR(1:L)
        WRITE(IR,'(2F12.5)')B(M),A(N)
        IR(13:13)='/'
        NQ=NQ+1
          DO 67 I=1,24
          IF(IR(I:I).EQ.' ')GOTO 67
          NQ=NQ+1
          KR(NQ:NQ)=IR(I:I)
  67      CONTINUE
        NW=NW+30
        NQ=MAX0(NQ+2,NW)
  68    M=M+1
  69    CONTINUE
      IF(AMOD(T,.2).LT.0.05)GOTO 77
      IF(NI.LT.3)GOTO 72
      IF(NI.EQ.5)GOTO 71
      IF(NI.EQ.6)GOTO 70
      IF(NI.EQ.9)GOTO 70
      K=INT(A(NN+28))
      IF(AMOD(A(NN+28),1.).LT.0.05)K=INT(A(K+28))
      IF(A(K+28).GT.1.)GOTO 71
      GOTO 73
  70  CALL SXCA(G,F,3)
      F(23)=G(1)+A(NN+17)
      F(24)=G(2)+A(NN+18)
      F(25)=G(3)+A(NN+19)
      GOTO 72
C
C Apply rigid group and riding constraints
C
  71  A(NN+17)=A(NN+17)+F(1)
      A(NN+18)=A(NN+18)+F(2)
      A(NN+19)=A(NN+19)+F(3)
      P=1.+F(14)
      A(NN+17)=P*A(NN+17)-F(14)*F(23)
      A(NN+18)=P*A(NN+18)-F(14)*F(24)
      A(NN+19)=P*A(NN+19)-F(14)*F(25)
      Y=A(NN+18)-F(24)
      Z=A(NN+19)-F(25)
      U=A(94)*(A(NN+17)-F(23))+A(95)*Y+A(96)*Z
      V=A(97)*Y+A(98)*Z
      X=A(99)*Z
      W=V*F(11)+X*F(15)
      V=V*F(15)-X*F(11)
      X=W*F(12)+U*F(16)
      W=W*F(16)-U*F(12)
      U=X*F(17)-V*F(13)
      V=X*F(13)+V*F(17)
      Z=W/A(99)
      Y=(V-Z*A(98))/A(97)
      G(1)=(U-Y*A(95)-Z*A(96))/A(94)+F(23)-A(NN+17)
      G(2)=Y+F(24)-A(NN+18)
      G(3)=Z+F(25)-A(NN+19)
      IF(NI.EQ.5)GOTO 72
      A(NN+17)=A(NN+17)+G(1)
      A(NN+18)=A(NN+18)+G(2)
      A(NN+19)=A(NN+19)+G(3)
      GOTO 74
  72  F(7)=G(1)+A(NN+17)
      F(8)=G(2)+A(NN+18)
      F(9)=G(3)+A(NN+19)
      CALL SXCA(G,F(4),3)
      CALL SXCA(F(7),A(NN+17),3)
      MT=NN
      IF(NI.EQ.5)GOTO 76
      GOTO 77
  73  A(NN+17)=A(NN+17)+F(4)
      A(NN+18)=A(NN+18)+F(5)
      A(NN+19)=A(NN+19)+F(6)
  74  IF(NI.EQ.3)GOTO 76
      IF(NI.EQ.7)GOTO 75
      P=1.+F(18)
      A(NN+17)=P*A(NN+17)-F(18)*F(7)
      A(NN+18)=P*A(NN+18)-F(18)*F(8)
      A(NN+19)=P*A(NN+19)-F(18)*F(9)
      IF(NI.EQ.4)GOTO 76
  75  Y=A(NN+18)-F(8)
      Z=A(NN+19)-F(9)
      U=A(94)*(A(NN+17)-F(7))+A(95)*Y+A(96)*Z
      V=A(97)*Y+A(98)*Z
      W=A(99)*Z
      Y=SQRT(U**2+V**2+W**2)
      IF(Y.LT.0.01)GOTO 76
      K=INT(A(MT+4))
      IF(K.LE.0)GOTO 76
      K=INT(-A(K+1))
      IF(K.LE.0)GOTO 76
      XX=A(K+17)-F(7)
      YY=A(K+18)-F(8)
      ZZ=A(K+19)-F(9)
      P=A(94)*XX+A(95)*YY+A(96)*ZZ
      T=A(97)*YY+A(98)*ZZ
      R=A(99)*ZZ
      X=SQRT(P**2+T**2+R**2)
      IF(X.LT.0.01)GOTO 76
      Z=(P*U+T*V+R*W)/(X*Y)
      UU=F(7)+Z*XX
      VV=F(8)+Z*YY
      WW=F(9)+Z*ZZ
      XX=A(NN+17)-UU
      YY=A(NN+18)-VV
      ZZ=A(NN+19)-WW
      X=V*R-W*T
      Y=W*P-U*R
      Z=U*T-V*P
      R=SQRT(X**2+Y**2+Z**2)
      IF(R.LT.0.01)GOTO 76
      S=SQRT(A(8)*XX**2+A(9)*YY**2+A(10)*ZZ**2+A(11)*YY*ZZ+
     +A(12)*XX*ZZ+A(13)*XX*YY)
      P=F(21)/S
      T=COS(P)
      S=SIN(P)*S/R
      Z=Z/A(99)
      Y=(Y-A(98)*Z)/A(97)
      A(NN+17)=S*(X-Y*A(95)-Z*A(96))/A(94)+XX*T+UU
      A(NN+18)=S*Y+YY*T+VV
      A(NN+19)=S*Z+ZZ*T+WW
  76  CALL SXCA(A(NN+17),A(NN+7),3)
C
C Maximum shift and delta(U)
C
  77  IF(A(NN+5).GT.0.999)GOTO 78
      IF(AMOD(A(NN+5),.2).LT.0.05)GOTO 78
      X=A(NN+17)-PX
      Y=A(NN+18)-PY
      Z=A(NN+19)-PZ
      T=SQRT(A(8)*X**2+A(9)*Y**2+A(10)*Z**2+A(11)*Y*Z+A(12)*X*Z+
     +A(13)*X*Y)
      IF(T.LE.TQ)GOTO 78
      TQ=T
      MQ=NN
  78  IF(ABS(A(NN+31)).GT.0.999)GOTO 79
      IF(AMOD(A(NN+5),1.).LT.0.15)GOTO 79
      U=G(5)
      IF(A(NN+3).LT.0.)U=G(5)*A(136)+G(6)*A(137)+G(7)*A(138)+
     +G(8)*A(139)+G(9)*A(140)+G(10)*A(141)
      IF(ABS(U).LE.ABS(UQ))GOTO 79
      UQ=U
      MU=NN
C
C Update table of atom parameter esd's
C
  79  IF(A(177).LT.0.)GOTO 44
      IF(KH.NE.INT(ABS(A(NN+3))))GOTO 80
      I=IABS(6-MOD(INT(ABS(A(NN+6))),10))
      IF(I.EQ.2)GOTO 80
      IF(I.LT.4)GOTO 86
  80  CALL SXDX(NN,DX,DY,DZ,IX,IY,IZ,NX,NY,NZ,LM,A)
      IF(NX.GT.0)CALL SXSD(DX,IX,A(131),A(NL),NP,NX,JW,B)
      IF(NY.GT.0)CALL SXSD(DY,IY,A(131),A(NL+1),NP,NY,JW,B)
      IF(NZ.GT.0)CALL SXSD(DZ,IZ,A(131),A(NL+2),NP,NZ,JW,B)
        DO 81 I=1,NX
        DX(I)=DX(I)*A(2)
  81    CONTINUE
        DO 83 I=1,NY
          DO 82 K=1,NX
          IF(IY(I).NE.IX(K))GOTO 82
          DX(K)=DX(K)+DY(I)*A(3)
          GOTO 83
  82      CONTINUE
        NX=NX+1
        IX(NX)=IY(I)
        DX(NX)=DY(I)*A(3)
  83    CONTINUE
        DO 85 I=1,NZ
          DO 84 K=1,NX
          IF(IZ(I).NE.IX(K))GOTO 84
          DX(K)=DX(K)+DZ(I)*A(4)
          GOTO 85
  84      CONTINUE
        NX=NX+1
        IX(NX)=IZ(I)
        DX(NX)=DZ(I)*A(4)
  85    CONTINUE
  86  N=NL+5
      IF(A(NN+3).LT.0.)N=NL+11
      IF(NX.GT.0)CALL SXSD(DX,IX,A(131),A(N),NP,NX,JW,B)
      CALL SXDU(NN,DU,IU,NU,LM,A)
      IF(NU.EQ.0)GOTO 44
      N=NL+2
      K=134
      NX=1
      NY=0
        DO 87 I=1,NU
        K=K+1
        N=N+1
        IF(IU(I).EQ.0)GOTO 87
        DX(1)=DU(I)
        IX(1)=IU(I)
        CALL SXSD(DX,IX,A(131),A(N),NP,NX,JW,B)
        IF(I.EQ.1)GOTO 87
        NY=NY+1
        IY(NY)=IU(I)
        DY(NY)=DU(I)*A(K)
  87    CONTINUE
      IF(NY.EQ.0)GOTO 44
      IF(A(NN+3).LT.0.)CALL SXSD(DY,IY,A(131),A(NL+10),NP,NY,JW,B)
      GOTO 44
C
C Update coordinates for dependent atoms
C
  88  IF(LK.EQ.MV-1)GOTO 89
      IF(ABS(A(51)).LT.0.5)GOTO 90
  89  IF(A(177).GE.0.)GOTO 90
      IF(NQ.LT.3)GOTO 90
      WRITE(LI,'(A)')KR(1:NQ-2)
  90  M=LV-19
  91  M=M+20
      IF(M.GT.LE)GOTO 92
      K=INT(A(M+3))
      A(M+17)=A(K+17)*A(M+5)+A(K+18)*A(M+6)+A(K+19)*A(M+7)+A(M+14)
      A(M+18)=A(K+17)*A(M+8)+A(K+18)*A(M+9)+A(K+19)*A(M+10)+A(M+15)
      A(M+19)=A(K+17)*A(M+11)+A(K+18)*A(M+12)+A(K+19)*A(M+13)+A(M+16)
      GOTO 91
C
C Print mean/maximum shift/esd
C
  92  IR=' '
      IR(68:69)='at'
      CALL SXTX(IR(71:78))
      IF(A(177).LT.0.)GOTO 93
      A(92)=AMIN1(A(92)/REAL(NP),9999.999)
      IF(ABS(A(93)).GT.9999.999)A(93)=SIGN(9999.999,A(93))
      WRITE(LI,5)
      WRITE(LI,7)A(92),A(93),KT
      WRITE(*,7)A(92),A(93),KT,'at '//IR(71:78)
      CALL SXFL
      IR=' '
  93  M=1
      IF(MQ.EQ.0)GOTO 94
      M=26
      IR(2:26)='Max. shift =       A for '
      WRITE(IR(14:19),'(F6.3)')TQ
      CALL SXAN(MQ,IR,M,LM,A)
      M=MIN0(M+6,37)
  94  IF(MU.EQ.0)GOTO 95
      M=M+20
      IR(M-19:M)='Max. dU =       for '
      WRITE(IR(M-10:M-5),'(F6.3)')UQ
      CALL SXAN(MU,IR,M,LM,A)
  95  IF(M.LT.2)GOTO 96
      WRITE(*,13)IR(1:78)
      CALL SXFL
      WRITE(LI,13)
      WRITE(LI,13)IR(1:67)
C
C Print refined C-H distances with esd's (AFIX 4, 7 and 8)
C
  96  IF(JB.LT.JA)GOTO 102
      IF(ABS(A(51)).LT.0.5)GOTO 122
      IF(LK.EQ.MV-1)GOTO 97
      IF(ABS(A(51)).LT.2.5)GOTO 102
  97  WRITE(LI,8)
        DO 101 J=JA,JB,2
        N=INT(B(J))
        L=INT(A(N+28))
        X=A(N+17)-A(L+17)
        Y=A(N+18)-A(L+18)
        Z=A(N+19)-A(L+19)
        R=SQRT(A(8)*X**2+A(9)*Y**2+A(10)*Z**2+A(11)*Y*Z+
     +  A(12)*X*Z+A(13)*X*Y)
        S=-1.
        IF(A(177).GT.0.)S=R*B(J+1)
        M=INT(ABS(A(N+6)))
        I=0
        CALL SXAN(L,IR,I,LM,A)
  98    I=I+3
        IR(I-2:I)=' - '
        CALL SXAN(N,IR,I,LM,A)
        I=I+2
        IR(I-1:I)='  '
        N=N+32
        IF(N.GT.LX)GOTO 99
        IF(M.NE.INT(ABS(A(N+6))))GOTO 99
        IF(I.LT.71)GOTO 98
        I=I+6
        IR(I-5:I)='  etc.'
  99    IF(S.LT.0.)GOTO 100
        WRITE(LI,9)R,S,M,IR(1:I)
        GOTO 101
 100    WRITE(LI,10)R,M,IR(1:I)
 101    CONTINUE
C
C Print largest correlation matrix elements
C
 102  IF(A(177).LT.0.)GOTO 122
      IF(ABS(A(51)).LT.0.5)GOTO 122
      IF(A(103).GT.0.5)GOTO 103
      IF(ABS(A(51)).GT.1.5)GOTO 103
      IF(LK.NE.MV-1)GOTO 122
 103  NA=1
      FF(NA)=9.E9
      NB=25
      IF(ABS(A(51)).GT.2.5)NB=LU
      IF(NB.GE.LU)NB=LU-1
      S=.5
      IF(ABS(A(51)).GT.1.5)S=0.25
      IF(ABS(A(51)).GT.2.5)S=0.1
      J=JD+1
        DO 104 N=1,NP
        B(JK+N)=SQRT(ABS(B(J)))
        J=J+NP-N+1
 104    CONTINUE
      IF(A(51).GT.-0.5)GOTO 108
      IF(LK.NE.MV-1)GOTO 108
      L=J-1
      WRITE(LQ,3)L-NP
      N=0
      M=-1
        DO 107 J=JD,L-1,10
        K=MIN0(10,L-J)
          DO 106 I=1,K
          M=MOD(M,NP)+1
          IF(M.GT.N)GOTO 105
          N=N+1
          M=N
 105      G(I)=SIGN(AMIN1(9.99999,ABS(B(J+I)/
     +    (B(JK+N)*B(JK+M)))),B(J+I))
 106      CONTINUE
        WRITE(LQ,4)(G(I),I=1,K)
 107    CONTINUE
      WRITE(LQ,4)
 108  J=JD
        DO 113 N=1,NP
          DO 112 M=N,NP
          J=J+1
          IF(M.EQ.N)GOTO 112
          T=B(J)/(B(JK+N)*B(JK+M))
          U=AMIN1(999.999,ABS(T))
          IF(U.LT.S)GOTO 112
          L=NA+1
          K=L
 109      L=L-1
          IF(ABS(FF(L)).LT.U)GOTO 109
 110      K=K-1
          IF(L.GE.K)GOTO 111
          FF(K+1)=FF(K)
          MH(K+1)=MH(K)
          MK(K+1)=MK(K)
          GOTO 110
 111      FF(L+1)=SIGN(U,T)
          MH(L+1)=M
          MK(L+1)=N
          NA=MIN0(NA+1,NB)
          IF(NA.EQ.NB)S=ABS(FF(NA))
 112      CONTINUE
 113    CONTINUE
      IF(NA.LT.2)GOTO 121
      WRITE(LI,11)
      N=(NA+1)/3
        DO 120 I=2,N+1
        KR=' '
        NL=-30
        NJ=I+2*N
          DO 119 M=I,NJ,N
          IF(M.GT.NA)GOTO 119
          NL=NL+40
          L=NL
          WRITE(KT,12)FF(M)
          KR(L-7:L)=KT(1:8)
          JF=JG+MH(M)
            DO 118 NI=1,2
            K=INT(B(JF))
            L=L+1
            KT(1:4)=KP(K)
              DO 114 NB=1,4
              IF(KT(NB:NB).EQ.' ')GOTO 114
              L=L+1
              KR(L:L)=KT(NB:NB)
 114          CONTINUE
            L=L+1
            K=INT(B(JF+JE))
            IF(K.EQ.0)GOTO 117
            IF(K.GT.0)GOTO 116
            WRITE(KT,5)-K
              DO 115 NB=1,6
              IF(KT(NB:NB).EQ.' ')GOTO 115
              L=L+1
              KR(L:L)=KT(NB:NB)
 115          CONTINUE
            GOTO 117
 116        CALL SXAN(K,KR,L,LM,A)
 117        IF(NI.EQ.2)GOTO 118
            JF=JG+MK(M)
            IF(KR(L:L).NE.' ')L=L+1
            L=L+1
            KR(L:L)='/'
 118        CONTINUE
 119      CONTINUE
        WRITE(LI,13)KR(1:L)
 120    CONTINUE
      GOTO 122
 121  WRITE(LI,14)S
C
C Set up calculation of derived quantities and their esd's
C
 122  IF(NP.LT.3)GOTO 123
      IF(A(92).GT.99.)CALL SXER('REFINEMENT UNSTABLE')
 123  IF(LK.EQ.1)GOTO 124
      IF(A(142).LT.-0.5)GOTO 224
 124  MQ=0
        DO 125 I=201,LY,12
        IF(ABS(A(I+1)).GT.0.5)MQ=MAX0(MQ,1)
        IF(ABS(A(I+2)).GT.0.5)MQ=MAX0(MQ,2)
 125    CONTINUE
      IF(MQ.NE.2)GOTO 126
      IF(LY.LT.262)MQ=3
 126  NN=LJ+1
      IF(A(103).GT.0.5)GOTO 127
      IF(LK.LT.MV-1)GOTO 224
 127  A(42)=0.
      A(81)=0.
 128  NK=INT(A(NN)/64000.)
      IF(NK.EQ.0)GOTO 224
      CALL SXCC
      N=NN+1
      NN=NN+INT(AMOD(A(NN),64000.))
      MO=19
C
C Bond lengths and angles
C
      IF(NK.NE.47)GOTO 131
      MB(1)=INT(A(N))
      N=N+1
      NI=0
 129  NI=NI+1
      N=N+1
      NT=INT(A(N-1))
      MB(2)=NT
      ML(NI)=NT
      NT=0
      MN=2
      PL=.001
      GOTO 153
 130  IF(N.GE.NN)GOTO 128
      IF(NK.NE.47)GOTO 133
      NT=NT+1
      IF(NT.GE.NI)GOTO 129
      MB(3)=ML(NT)
      MN=3
      PL=.05
      GOTO 153
C
C CONF
C
 131  IF(NK.NE.52)GOTO 135
        DO 132 I=1,4
        MB(I)=INT(A(N))
        N=N+1
 132    CONTINUE
      MN=4
      PL=.05
      GOTO 153
 133  IF(NK.NE.52)GOTO 128
        DO 134 I=1,3
        MB(I)=MB(I+1)
 134    CONTINUE
      MB(4)=INT(A(N))
      N=N+1
      GOTO 153
C
C Update HTAB H-atoms disguised as RTAB
C
 135  IF(NK.NE.53)GOTO 151
      CALL SXUS(A(N),KQ)
      IF(KQ.NE.'4DHA')GOTO 143
      CALL SXCC
      Q=9.E9
      NA=INT(A(N+3))
      NB=INT(A(N+5))
      MN=INT(A(NA+29))
      K=0
      I=LB+16
 136  I=I+32
      IF(I.GT.LX)GOTO 138
      IF(INT(ABS(A(I+3))).NE.KH)GOTO 136
      IF(MN.EQ.0)GOTO 137
      IF(INT(A(I+29)).NE.MN)GOTO 136
 137  XX=A(I+17)-A(NA+17)
      YY=A(I+18)-A(NA+18)
      ZZ=A(I+19)-A(NA+19)
      XX=A(94)*XX+A(95)*YY+A(96)*ZZ
      YY=A(97)*YY+A(98)*ZZ
      ZZ=A(99)*ZZ
      R=XX**2+YY**2+ZZ**2
      X=A(I+17)-A(NB+17)
      Y=A(I+18)-A(NB+18)
      Z=A(I+19)-A(NB+19)
      X=A(94)*X+A(95)*Y+A(96)*Z
      Y=A(97)*Y+A(98)*Z
      Z=A(99)*Z
      S=X**2+Y**2+Z**2
      IF(R.GT.S)GOTO 136
      T=(X*XX+Y*YY+Z*ZZ)/SQRT(R*R)
      IF(T.GT.Q)GOTO 136
      Q=T
      K=I
      GOTO 136
 138  IF(K.GT.0)GOTO 139
      IR=' '
      L=0
      CALL SXAN(NA,IR,L,LM,A)
      L=L+1
      CALL SXAN(NB,IR,L,LM,A)
      CALL SXER('NO SUITABLE HYDROGEN ATOM FOUND FOR HTAB '//IR(1:L))
 139  A(N+4)=REAL(K)+0.1
      L=NN
 140  K=INT(A(L)/64000.)
      IF(K.EQ.0)GOTO 141
      J=L+1
      L=L+INT(AMOD(A(L),64000.))
      IF(K.NE.53)GOTO 140
      CALL SXUS(A(J),KQ)
      IF(KQ.NE.'1DHA')GOTO 140
      IF(INT(A(J+3)).NE.NA)GOTO 140
      A(J+4)=A(N+4)
 141  L=NN
 142  K=INT(A(L)/64000.)
      IF(K.EQ.0)GOTO 143
      J=L+1
      L=L+INT(AMOD(A(L),64000.))
      IF(K.NE.53)GOTO 142
      CALL SXUS(A(J),KQ)
      IF(KQ.NE.'2DHA')GOTO 142
      IF(INT(A(J+4)).NE.NB)GOTO 142
      A(J+3)=A(N+4)
C
C RTAB
C
 143  K=N+3
      MN=NN-K
      PL=.05
      IF(MN.LT.3)PL=.001
        DO 144 I=1,MN
        MB(I)=INT(A(K))
        K=K+1
 144    CONTINUE
      IF(MN.NE.3)GOTO 145
      K=MB(1)
      MB(1)=MB(2)
      MB(2)=K
 145  N=N+1
      IF(MN.GT.1)GOTO 153
      K=MB(1)
      IF(K.GT.LX)GOTO 128
      K=INT(A(K+4))
      IF(K.EQ.0)GOTO 128
      IF(A(K+1).LT.0.5)GOTO 128
      IF(A(K+2).LT.0.5)GOTO 128
        DO 146 I=2,4
        K=K+1
        MB(I)=INT(ABS(A(K)))
 146    CONTINUE
      IF(A(K).GT.-0.5)GOTO 128
      NA=0
        DO 147 I=1,4
        NB=MB(I)
        IF(NB.GT.LX)NB=INT(A(NB+3))
        NA=MAX0(NA,INT(ABS(A(NB+29))))
 147    CONTINUE
        DO 148 I=1,4
        NB=MB(I)
        IF(NB.GT.LX)NB=INT(A(NB+3))
        NB=INT(ABS(A(NB+29)))
        IF(NB.EQ.0)GOTO 148
        IF(NB.NE.NA)GOTO 128
 148    CONTINUE
      MN=4
      MO=6
      CALL SXUS(A(MB(2)),KX)
      CALL SXUS(A(MB(3)),KY)
      CALL SXUS(A(MB(4)),KZ)
 149  IF(KY.GE.KX)GOTO 150
      KQ=KX
      KX=KY
      KY=KQ
      I=MB(2)
      MB(2)=MB(3)
      MB(3)=I
 150  IF(KZ.GE.KY)GOTO 153
      KQ=KY
      KY=KZ
      KZ=KQ
      I=MB(3)
      MB(3)=MB(4)
      MB(4)=I
      GOTO 149
C
C MPLA
C
 151  IF(NK.NE.54)GOTO 128
      K=N+9
      MN=MIN0(INT(ABS(A(N))),(NN-K)/3)
      PL=-1.
      N=N+1
        DO 152 I=1,MN
        MB(I)=INT(A(K))
        K=K+3
 152    CONTINUE
C
C Convert to orthogonal coordinates
C
 153  NB=0
      JF=JC
      CE=0.
      NA=7
      FC(1)=0.
        DO 154 I=1,MN
        K=MB(I)
        FC(NA+1)=A(K+17)
        FC(NA+2)=A(K+18)
        NA=NA+3
        FC(NA)=A(K+19)
 154    CONTINUE
C
C Numerical differentiation
C
        DO 202 MT=1,NA
        PP=0.
        PQ=4096.
        IF(MT.GT.8)GOTO 162
        IF(NK.NE.54)GOTO 155
        IF(MT.EQ.8)GOTO 162
        IF(MT.NE.1)GOTO 202
 155      DO 156 I=2,7
          FC(I)=A(I)
 156      CONTINUE
        IF(MT.EQ.1)GOTO 159
        IF(MT.EQ.8)GOTO 159
        IF(ABS(A(MT+25)).LT.1.E-6)GOTO 202
        FC(MT)=FC(MT)+A(MT+25)/16.
        IF(MQ.EQ.0)GOTO 159
        IF(MQ.NE.3)GOTO 157
        IF(MT.LT.5)GOTO 158
        IF(MT.GT.5)GOTO 202
        FC(6)=FC(6)+A(31)/16.
        FC(7)=FC(7)+A(32)/16.
        GOTO 159
 157    IF(MQ.EQ.2)GOTO 158
        IF(MT.EQ.4)GOTO 159
 158    IF(MT.NE.2)GOTO 202
        IF(MQ.NE.1)FC(4)=FC(4)+A(29)/16.
        FC(3)=FC(3)+A(28)/16.
 159      DO 160 I=5,7
          P=.01745329*FC(I)
          FF(I-3)=SIN(P)
          FF(I)=COS(P)
 160      CONTINUE
        FC(5)=FC(3)*FF(4)
        FC(6)=FC(4)*(FF(5)-FF(6)*FF(7))/FF(4)
        FC(7)=FC(4)*SQRT(1.-FF(5)**2-FF(6)**2-FF(7)**2+
     +  2.*FF(5)*FF(6)*FF(7))/FF(4)
        FC(4)=FC(4)*FF(6)
        FC(3)=FC(3)*FF(7)
        K=8
          DO 161 I=1,MN
          FF(K)=FC(2)*FC(K)+FC(3)*FC(K+1)+FC(4)*FC(K+2)
          FF(K+1)=FC(5)*FC(K+1)+FC(6)*FC(K+2)
          FF(K+2)=FC(7)*FC(K+2)
          K=K+3
 161      CONTINUE
        IF(MT.NE.8)GOTO 163
 162    FC(MT)=FC(MT)+1./PQ
        MM=3*((MT-2)/3)+1
        FF(MM+1)=FC(2)*FC(MM+1)+FC(3)*FC(MM+2)+FC(4)*FC(MM+3)
        FF(MM+2)=FC(5)*FC(MM+2)+FC(6)*FC(MM+3)
        FF(MM+3)=FC(7)*FC(MM+3)
 163    IF(NK.EQ.54)GOTO 165
        K=8
        IF(NA.EQ.MO)K=14
          DO 164 I=8,NA,3
          IF(I.EQ.K)GOTO 164
          WL(I)=FF(I)-FF(K)
          WL(I+1)=FF(I+1)-FF(K+1)
          WL(I+2)=FF(I+2)-FF(K+2)
 164      CONTINUE
        IF(MO.EQ.6)GOTO 182
        IF(NA.EQ.19)GOTO 180
        IF(NA.EQ.13)GOTO 183
        P=WL(11)*WL(14)+WL(12)*WL(15)+WL(13)*WL(16)
        S=SQRT((WL(12)*WL(16)-WL(13)*WL(15))**2+(WL(13)*WL(14)-
     +  WL(11)*WL(16))**2+(WL(11)*WL(15)-WL(12)*WL(14))**2)
        GOTO 181
C
C Find l.s. plane by matrix squaring method
C
 165    CALL SXZA(F,12)
          DO 166 I=8,NA,3
          F(10)=F(10)+FF(I)
          F(11)=F(11)+FF(I+1)
          F(12)=F(12)+FF(I+2)
 166      CONTINUE
        W=REAL(MN)
        U=F(10)/W
        V=F(11)/W
        W=F(12)/W
          DO 167 I=8,NA,3
          X=FF(I)-U
          Y=FF(I+1)-V
          Z=FF(I+2)-W
          F(1)=F(1)+Y**2+Z**2
          F(2)=F(2)-X*Y
          F(3)=F(3)-X*Z
          F(5)=F(5)+X**2+Z**2
          F(6)=F(6)-Y*Z
          F(9)=F(9)+X**2+Y**2
 167      CONTINUE
        F(4)=F(2)
        F(7)=F(3)
        F(8)=F(6)
          DO 171 I=1,8
          CALL SXCA(F,G,9)
          T=0.
          M=0
            DO 169 K=1,7,3
              DO 168 L=1,3
              M=M+1
              G(M)=F(K)*F(L)+F(K+1)*F(L+3)+F(K+2)*F(L+6)
 168          CONTINUE
 169        CONTINUE
          T=1./(G(1)+G(5)+G(9))
            DO 170 K=1,9
            F(K)=G(K)*T
 170        CONTINUE
 171      CONTINUE
        T=0.
          DO 172 I=1,9,4
          IF(F(I).LT.T)GOTO 172
          K=I
          T=F(I)
 172      CONTINUE
        K=((K-1)/3)+1
        T=SQRT(F(K)**2+F(K+3)**2+F(K+6)**2)
        U=F(K)/T
        V=F(K+3)/T
        W=F(K+6)/T
        G(1)=U*FC(2)
        G(2)=U*FC(3)+V*FC(5)
        G(3)=U*FC(4)+V*FC(6)+W*FC(7)
        G(4)=(U*F(10)+V*F(11)+W*F(12))/REAL(MN)
        K=N
        IF(MT.NE.1)GOTO 174
          DO 173 L=1,4
          A(K)=G(L)
          K=K+2
 173      CONTINUE
        GOTO 201
 174    IF(MT.NE.MM+1)GOTO 176
          DO 175 I=1,4
          SI(I)=4096.*(G(I)-A(K))
          K=K+2
 175      CONTINUE
        GOTO 200
 176    IF(MT.NE.MM+2)GOTO 178
          DO 177 I=1,4
          SQ(I)=4096.*(G(I)-A(K))
          K=K+2
 177      CONTINUE
        GOTO 200
 178      DO 179 I=1,4
          WL(I)=4096.*(G(I)-A(K))
          K=K+2
 179      CONTINUE
        M=4
        GOTO 187
C
C Torsion angles
C
 180    U=WL(9)*WL(13)-WL(10)*WL(12)
        V=WL(10)*WL(11)-WL(8)*WL(13)
        W=WL(8)*WL(12)-WL(9)*WL(11)
        X=WL(18)*WL(13)-WL(19)*WL(12)
        Y=WL(19)*WL(11)-WL(17)*WL(13)
        Z=WL(17)*WL(12)-WL(18)*WL(11)
        R=W*Y-V*Z
        S=U*Z-W*X
        T=V*X-U*Y
        P=U*X+V*Y+W*Z
        S=SIGN(SQRT(R**2+S**2+T**2),WL(11)*R+WL(12)*S+WL(13)*T)
 181    IF(ABS(P)+ABS(S).LT.1.E-10)GOTO 184
        P=AMOD(540.005+ATAN2(S,P)*57.29578,360.)-180.005
        GOTO 184
 182    P=WL(11)*(WL(15)*WL(19)-WL(18)*WL(16))+WL(14)*(WL(13)*WL(18)-
     +  WL(12)*WL(19))+WL(17)*(WL(12)*WL(16)-WL(13)*WL(15))
        GOTO 184
 183    P=SQRT(WL(11)**2+WL(12)**2+WL(13)**2)
 184    IF(MT.NE.1)GOTO 185
        IF(P.LT.-179.995)P=P+360.
        A(N)=P
        GOTO 201
C
C Combine derivatives
C
 185    IF(ABS(P-A(N)-360.).LT.1.)P=P-360.
        IF(ABS(P-A(N)+360.).LT.1.)P=P+360.
        P=P-A(N)
        IF(MT.GT.7)GOTO 186
        CE=CE+(16.*P)**2
        GOTO 202
 186    P=4096.*P
        IF(PQ.GT.0.)PP=P
        IF(ABS(PP).LT.ABS(P).AND.PQ.LT.0.)PP=-P
        PQ=-PQ/2.
        IF(PQ.LT.0.)GOTO 162
        PQ=-4096.
        IF(MT.EQ.MM+1)SI(1)=PP
        IF(MT.EQ.MM+2)SQ(1)=PP
        IF(MT.NE.MM+3)GOTO 200
        WL(1)=PP
        M=1
 187    K=(MT-5)/3
        CALL SXDX(MB(K),DX,DY,DZ,IX,IY,IZ,NX,NY,NZ,LM,A)
          DO 191 I=1,NX
            DO 188 MA=1,NB
            IF(IX(I).EQ.MK(MA))GOTO 189
 188        CONTINUE
          MA=NB+1
          MK(MA)=IX(I)
 189      J=JC+MA-1
            DO 190 L=1,M
            IF(MA.GT.NB)B(J)=0.
            P=SI(L)*DX(I)
            B(J)=B(J)+P
            J=J+JD
 190        CONTINUE
          IF(MA.GT.NB)NB=MA
 191      CONTINUE
          DO 195 I=1,NY
            DO 192 MA=1,NB
            IF(IY(I).EQ.MK(MA))GOTO 193
 192        CONTINUE
          MA=NB+1
          MK(MA)=IY(I)
 193      J=JC+MA-1
            DO 194 L=1,M
            IF(MA.GT.NB)B(J)=0.
            P=SQ(L)*DY(I)
            B(J)=B(J)+P
            J=J+JD
 194        CONTINUE
          IF(MA.GT.NB)NB=MA
 195      CONTINUE
          DO 199 I=1,NZ
            DO 196 MA=1,NB
            IF(IZ(I).EQ.MK(MA))GOTO 197
 196        CONTINUE
          MA=NB+1
          MK(MA)=IZ(I)
 197      J=JC+MA-1
            DO 198 L=1,M
            IF(MA.GT.NB)B(J)=0.
            P=WL(L)*DZ(I)
            B(J)=B(J)+P
            J=J+JD
 198        CONTINUE
          IF(MA.GT.NB)NB=MA
 199      CONTINUE
 200    FC(MT)=FC(MT)-1./PQ
        IF(MT.LT.MM+3)GOTO 202
        FF(MM+1)=A(94)*FC(MM+1)+A(95)*FC(MM+2)+A(96)*FC(MM+3)
        FF(MM+2)=A(97)*FC(MM+2)+A(98)*FC(MM+3)
        FF(MM+3)=A(99)*FC(MM+3)
 201    IF(A(177).GT.0.5)GOTO 202
        N=N+2
        IF(NK.EQ.54)N=N+6
        GOTO 210
 202    CONTINUE
C
C Estimate esd, checking for rigid and riding groups
C
      J=JC
        DO 209 I=1,M
        IF(NB.NE.0)GOTO 205
          DO 204 K=1,MN
          L=MB(K)
          IF(L.GT.LX)L=INT(A(L+3))
          IF(A(L+5).GT.0.9999)L=INT(A(L+5))
            DO 203 NJ=L+7,L+9
            IF(A(NJ).GT.1.E7)GOTO 203
            IF(ABS(ABS(A(NJ))-10.).GT.5.)GOTO 208
 203        CONTINUE
 204      CONTINUE
        P=0.
        GOTO 207
 205    CALL SXSD(B(J),MK,A(131),P,NP,NB,JW,B)
        IF(P.GT.PL)GOTO 207
        NJ=0
          DO 206 K=1,MN
          L=MB(K)
          IF(L.GT.LX)L=INT(A(L+3))
          IF(A(L+5).GT.0.9999)L=INT(A(L+5))
          IF(INT(AMOD(ABS(A(L+6)),10.)).LT.3)NJ=NJ+1
 206      CONTINUE
        IF(NJ.LT.2)GOTO 208
 207    A(N+1)=AMAX1(SQRT(P**2+CE),A(N+1))
 208    N=N+2
        J=J+JD
 209    CONTINUE
C
C Deviations from l.s. plane with esd's
C
 210  IF(NK.NE.54)GOTO 130
      JE=JC+4*JD
      L=N-8
 211  IF(N.GE.NN)GOTO 128
      K=INT(A(N))
      A(N+1)=A(L)*A(K+17)+A(L+2)*A(K+18)+A(L+4)*A(K+19)-A(L+6)
      IF(A(L-1).GT.0.)GOTO 212
      A(42)=A(42)+A(N+1)**2
      A(81)=A(81)+1.
      GOTO 223
 212  IF(A(177).LT.0.5)GOTO 223
      CALL SXDX(K,DX,DY,DZ,IX,IY,IZ,NX,NY,NZ,LM,A)
      J=JE-1
      JF=JC
      JG=JF+JD
      JH=JG+JD
      JK=JH+JD
        DO 213 I=1,NB
        J=J+1
        B(J)=A(K+17)*B(JF)+A(K+18)*B(JG)+A(K+19)*B(JH)-B(JK)
        JF=JF+1
        JG=JG+1
        JH=JH+1
        JK=JK+1
 213    CONTINUE
      NA=NB
        DO 216 I=1,NX
        IF(ABS(DX(I)).LT.0.0001)GOTO 216
          DO 214 MA=1,NA
          IF(IX(I).EQ.MK(MA))GOTO 215
 214      CONTINUE
        MA=NA+1
        MK(MA)=IX(I)
        J=J+1
        B(J)=0.
 215    J=JE+MA-1
        B(J)=B(J)+A(L)*DX(I)
        IF(MA.GT.NA)NA=MA
 216    CONTINUE
        DO 219 I=1,NY
        IF(ABS(DY(I)).LT.0.0001)GOTO 219
          DO 217 MA=1,NA
          IF(IY(I).EQ.MK(MA))GOTO 218
 217      CONTINUE
        MA=NA+1
        MK(MA)=IY(I)
        J=J+1
        B(J)=0.
 218    J=JE+MA-1
        B(J)=B(J)+A(L+2)*DY(I)
        IF(MA.GT.NA)NA=MA
 219    CONTINUE
        DO 222 I=1,NZ
        IF(ABS(DZ(I)).LT.0.0001)GOTO 222
          DO 220 MA=1,NA
          IF(IZ(I).EQ.MK(MA))GOTO 221
 220      CONTINUE
        MA=NA+1
        MK(MA)=IZ(I)
        J=J+1
        B(J)=0.
 221    J=JE+MA-1
        B(J)=B(J)+A(L+4)*DZ(I)
        IF(MA.GT.NA)NA=MA
 222    CONTINUE
      P=-1.
      IF(NA.GT.0)CALL SXSD(B(JE),MK,A(131),P,NP,NA,JW,B)
      A(N+2)=AMAX1(A(N+2),P)
 223  N=N+3
      GOTO 211
C
C Residuals and Flack x
C
 224  IF(LK.NE.MV)GOTO 229
      IF(A(81).GT.0.5)WRITE(LI,19)SQRT(A(42)/A(81)),INT(A(81))
      IR=' '
      CALL SXLP(IR,LP)
      IR='REM '//IT
      CALL SXLP(IR,LP)
      IF(A(178).GT.-0.5)GOTO 225
      J1=INT(A(165)+0.1)
      J2=INT(A(124)+0.1)
      Q=A(162)/AMAX1(A(161),1.E-8)
      S=A(164)/AMAX1(A(163),1.E-8)
      WRITE(*,17)Q,J1,S,J2
      CALL SXFL
      WRITE(IR,17)Q,J1,S,J2
      KR='REM'//IR(1:75)
      CALL SXLP(KR,LP)
      WRITE(LI,5)
      WRITE(LI,17)Q,J1,S,J2
 225  A(174)=A(174)/AMAX1(A(175),1.E-8)
      J1=INT(A(125))
      J2=INT(A(129))
      WRITE(LI,5)
      WRITE(LI,15)A(130),J2,A(174),J1
      WRITE(*,15)A(130),J2,A(174),J1
      CALL SXFL
      WRITE(IR,15)A(130),J2,A(174),J1
      KR='REM'//IR(1:71)
      CALL SXLP(KR,LP)
      IR=' '
      WRITE(IR,18)INT(A(91)),INT(A(132))
      CALL SXLP(IR,LP)
      IR=' '
      CALL SXLP(IR,LP)
      T=A(125)-A(91)-A(179)
      A(143)=A(125)/AMAX1(1.,T)
      WRITE(LI,16)A(126),A(127),A(131)
      WRITE(*,16)A(126),A(127),A(131)
      CALL SXFL
      A(171)=A(171)/A(144)**2
      A(172)=A(172)/A(144)
      Q=AMAX1(0.,A(171)-2.*A(172)+A(173))
      A(175)=SQRT(AMAX1(0.,Q/A(171)))
      S=A(129)-A(91)-A(179)
      A(173)=99.9999
      IF(S.GT.0.5)A(173)=SQRT(Q/S)
      A(172)=99.9999
      IF(S+A(132).GT.0.5)A(172)=SQRT((A(133)+Q)/(S+A(132)))
      IF(NP.LT.2)GOTO 229
      IF(A(160).LT.-0.1.AND.A(160).GT.-998.)GOTO 229
      IF(ABS(A(160)-2.2).LT.0.01)GOTO 229
      A(156)=B(1)*B(5)-B(2)*B(4)
      A(157)=99.99
      IF(A(156).LE.0.)GOTO 226
      Q=B(3)*B(5)-B(4)**2
      IF(Q.LE.0.)GOTO 226
      A(156)=(B(2)*B(3)-B(1)*B(4))/A(156)
      A(157)=SQRT(B(3)/Q)*A(131)
      IF(A(157).LT.9.999)WRITE(LI,20)A(156),A(157)
      IF(A(157).GT.0.5)GOTO 226
      IF(ABS(A(156)-.5).GT.A(157))GOTO 227
 226  WRITE(LI,21)
      GOTO 229
 227  IF(.5-AMIN1(.5,ABS(A(156)-.5)).LT.2.5*A(157))GOTO 228
      IF(A(156).LT.0.1)GOTO 229
      IF(A(156).GT.0.7)GOTO 228
      WRITE(LI,5)
      WRITE(LI,22)
      WRITE(*,22)
      CALL SXFL
      GOTO 229
 228  IF(A(156).LT.0.5)GOTO 229
      WRITE(LI,5)
      WRITE(LI,23)
      WRITE(*,23)
      CALL SXFL
 229  REWIND LF
      A(76)=A(76)-A(77)
      IF(LK.GE.MV)LK=0
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SX3K(LM,LU,MB,A)
C
C CIF-output and tables
C
      CHARACTER*1 IH(50),KD
      CHARACTER*2 KA(94)
      CHARACTER*4 KS,KT
      CHARACTER*76 IT
      CHARACTER*80 NM,IR,KQ
      CHARACTER*128 KR
      INTEGER MB(LU)
      REAL A(LM)
      COMMON/MEM/ST,SL,TC,TL,IV,LR,LG,LH,LI,LP,LF,LA,LC,LW,LY,LL,LB,
     +LX,LE,LV,LJ,LD,LS,LO,LT,LK,LQ,LZ,LN,KH,JA,JB,JC,JD,JE,HA,HD
      COMMON/WORD/IH,IT,IR,NM,KA,KD
C
   1  FORMAT(/' Occupancy sum of asymmetric unit =',F8.2,
     +' for non-hydrogen and',F8.2,' for hydrogen atoms')
   2  FORMAT(/' Final diffuse solvent parameters (SWAT) are',2F10.5)
   3  FORMAT(A)
   4  FORMAT(F12.2)
   5  FORMAT(2F9.4)
   6  FORMAT(I6)
C
C Occupancy sums etc.
C
      U=0.
      V=0.
        DO 7 I=LB+16,LX,32
        K=INT(ABS(A(I+3)))
        IF(K.EQ.KH)V=V+A(I+20)
        IF(K.NE.KH)U=U+A(I+20)
   7    CONTINUE
      WRITE(LI,1)U,V
      IF(A(200).GT.-998.)WRITE(LI,2)A(39),A(200)
C
C Write .cif file - chemical composition
C
      IF(A(74).LT.0.5)GOTO 84
      WRITE(LH,3)KD
        DO 8 I=1,LN
        CALL SXLC(NM(I:I))
   8    CONTINUE
      WRITE(LH,3)'data_'//NM(1:LN)//KD
      WRITE(LH,3)KD
      IR='_audit_creation_method'
      IR(35:43)='SHELXL-97'
      WRITE(LH,3)IR(1:43)//KD
      IR='_chemical_name_systematic'
      WRITE(LH,3)IR(1:25)//KD
      WRITE(LH,3)';'//KD
      WRITE(LH,3)' ?'//KD
      WRITE(LH,3)';'//KD
      IR(16:36)='common             ?'//KD
      WRITE(LH,3)IR(1:36)
      IR(11:24)='melting_point '
      WRITE(LH,3)IR(1:36)
      IR(11:24)='formula_moiety'
      WRITE(LH,3)IR(1:36)
C
C Sum formula (C,H then alphabetical)
C
      IR(19:21)='sum'
      WRITE(LH,3)IR(1:21)//KD
      S=0.
      L=1
      KR=' '''
   9  N=0
      KT='zzzz'
        DO 11 K=LL+4,LB,16
        IF(A(K+14).LT.0.)GOTO 11
        CALL SXUS(A(K+13),KS)
        KS(3:4)='  '
        CALL SXLC(KS(2:2))
        IF(KS.EQ.'C   ')GOTO 10
        IF(KT.EQ.'H   ')GOTO 11
        IF(KS.EQ.'H   ')GOTO 10
        IF(KT.LT.KS)GOTO 11
  10    KT=KS
        N=K
        IF(KT.EQ.'C   ')GOTO 12
  11    CONTINUE
  12  IF(N.EQ.0)GOTO 14
      P=A(N+14)/A(26)
      A(N+14)=-1.
      L=L+2
      KR(L:L+1)=KT(1:2)
      IF(KT(2:2).NE.' ')L=L+1
      IF(ABS(P-1.).LT.0.005)GOTO 9
      WRITE(KQ,4)P
      M=12
      IF(KQ(10:12).EQ.'.00')M=9
        DO 13 I=1,M
        IF(KQ(I:I).EQ.' ')GOTO 13
        L=L+1
        KR(L:L)=KQ(I:I)
  13    CONTINUE
      GOTO 9
  14  L=L+2
      KR(L-1:L)=''''//KD
      WRITE(LH,3)KR(1:L)
      IR(19:28)='weight    '
      L=33
      CALL SXCF(IR,A(21)/A(26),0.,2,L)
      WRITE(LH,3)IR(1:L)//KD
C
C Scattering factor output
C
      WRITE(LH,3)KD
      WRITE(LH,3)'loop_'//KD
      KR(1:28)=' _atom_type_scat_dispersion_'
      WRITE(LH,3)KR(1:12)//'symbol'//KD
      WRITE(LH,3)KR(1:12)//'description'//KD
      WRITE(LH,3)KR(1:28)//'real'//KD
      WRITE(LH,3)KR(1:28)//'imag'//KD
      WRITE(LH,3)KR(1:17)//'source'//KD
        DO 16 N=LL+4,LB,16
        L=1
        IR(1:1)=''''
        CALL SXUS(A(N+13),KS)
        KT=KS
        CALL SXLC(KS(2:2))
          DO 15 I=1,4
          IF(KS(I:I).EQ.' ')GOTO 15
          L=L+1
          IR(L:L)=KS(I:I)
  15      CONTINUE
        M=2
        IF(KT(2:2).NE.KS(2:2))M=3
        WRITE(KR,5)A(N),A(N+1)
        WRITE(LH,3)' '//IR(1:M)//'''  '//IR(1:L)//''''//KR(1:18)//KD
        WRITE(LH,3)' ''International Tables Vol C Tables 4.2.6.8'//
     +  ' and 6.1.1.4'''//KD
  16    CONTINUE
      WRITE(LH,3)KD
C
C Symmetry
C
      IR='_symmetry_cell_setting            ?'//KD
      WRITE(LH,3)IR(1:36)
      IR(11:30)='space_group_name_H-M'
      WRITE(LH,3)IR(1:36)
      WRITE(LH,3)KD
      WRITE(LH,3)'loop_'//KD
      WRITE(LH,3)' _symmetry_equiv_pos_as_xyz'//KD
      KR=' '''
        DO 18 MM=LY+12,LL,4
          DO 17 N=201,LY,12
          L=2
          CALL SXOP(KR,A(N),A(MM),L)
          WRITE(LH,3)KR(1:L)//''''//KD
  17      CONTINUE
  18    CONTINUE
      WRITE(LH,3)KD
C
C Crystal and experimental data
C
      IR='_cell_length_a'
      L=33
      CALL SXCF(IR,A(2),A(27),-3,L)
      WRITE(LH,3)IR(1:L)//KD
      IR(14:14)='b'
      L=33
      CALL SXCF(IR,A(3),A(28),-3,L)
      WRITE(LH,3)IR(1:L)//KD
      IR(14:14)='c'
      L=33
      CALL SXCF(IR,A(4),A(29),-3,L)
      WRITE(LH,3)IR(1:L)//KD
      IR='_cell_angle_alpha'
      L=33
      CALL SXCF(IR,A(5),A(30),-2,L)
      WRITE(LH,3)IR(1:L)//KD
      IR(13:17)='beta '
      L=33
      CALL SXCF(IR,A(6),A(31),-2,L)
      WRITE(LH,3)IR(1:L)//KD
      IR(13:17)='gamma'
      L=33
      CALL SXCF(IR,A(7),A(32),-2,L)
      WRITE(LH,3)IR(1:L)//KD
      IR(7:17)='volume     '
      S=A(20)*SQRT((A(27)/A(2))**2+(A(28)/A(3))**2+(A(29)/A(4))**2)
      L=33
      CALL SXCF(IR,A(20),S,-1,L)
      WRITE(LH,3)IR(1:L)//KD
      IR(7:21)='formula_units_Z'
      M=0
      IF(ABS(AMOD(A(26)+0.005,1.)-0.005).GT.0.005)M=2
      L=33
      CALL SXCF(IR,A(26),0.,M,L)
      WRITE(LH,3)IR(1:L)//KD
      IR='_cell_measurement_temperature'
      L=33
      CALL SXCF(IR,A(104)+273.,2.,0,L)
      WRITE(LH,3)IR(1:L)//KD
      IR(19:36)='reflns_used     ?'//KD
      WRITE(LH,3)IR(1:36)
      IR(19:29)='theta_min  '
      WRITE(LH,3)IR(1:36)
      IR(26:27)='ax'
      WRITE(LH,3)IR(1:36)
      WRITE(LH,3)KD
      IR(1:27)='_exptl_crystal_description '
      WRITE(LH,3)IR(1:36)
      IR(16:26)='colour     '
      WRITE(LH,3)IR(1:36)
      IR(16:23)='size_max'
      UU=AMAX1(A(100),A(101),A(102))
      IF(UU.LT.1.E-4)GOTO 19
      WW=AMIN1(A(100),A(101),A(102))
      V=A(100)+A(101)+A(102)-UU-WW
      L=33
      CALL SXCF(IR,UU,0.,2,L)
      WRITE(LH,3)IR(1:L)//KD
      IR(22:23)='id'
      L=33
      CALL SXCF(IR,V,0.,2,L)
      WRITE(LH,3)IR(1:L)//KD
      IR(23:23)='n'
      L=33
      CALL SXCF(IR,WW,0.,2,L)
      WRITE(LH,3)IR(1:L)//KD
      GOTO 20
  19  WRITE(LH,3)IR(1:36)
      IR(22:23)='id'
      WRITE(LH,3)IR(1:36)
      IR(23:23)='n'
      WRITE(LH,3)IR(1:36)
  20  IR(16:36)='density_meas       ?'//KD
      WRITE(LH,3)IR(1:36)
      IR(24:29)='diffrn'
      L=33
      CALL SXCF(IR,A(45),0.,3,L)
      WRITE(LH,3)IR(1:L)//KD
      IR(24:49)='method     ''not measured'''//KD
      WRITE(LH,3)IR(1:49)
      IR(16:29)='F_000'
      L=33
      N=0
      IF(ABS(AMOD(A(22)+0.005,1.)-0.005).GT.0.005)M=2
      CALL SXCF(IR,A(22),0.,N,L)
      WRITE(LH,3)IR(1:L)//KD
      IR(8:29)='absorpt_coefficient_mu'
      L=33
      CALL SXCF(IR,A(25),0.,3,L)
      WRITE(LH,3)IR(1:L)//KD
      IR(16:36)='correction_type    ?'//KD
      WRITE(LH,3)IR(1:36)
      IR(27:31)='T_min'
      IF(UU.LT.1.E-4)GOTO 21
      IF(A(25).LT.1.E-4)GOTO 21
      L=33
      CALL SXCF(IR,EXP(-1./(.2+1./(UU*A(25)))),0.,4,L)
      WRITE(LH,3)IR(1:L)//KD
      IR(30:31)='ax'
      L=33
      CALL SXCF(IR,EXP(-1./(.2+1./(WW*A(25)))),0.,4,L)
      WRITE(LH,3)IR(1:L)//KD
      GOTO 22
  21  WRITE(LH,3)IR(1:36)
      IR(30:31)='ax'
      WRITE(LH,3)IR(1:36)
  22  IR(16:36)='process_details    ?'//KD
      WRITE(LH,3)IR(1:36)
      WRITE(LH,3)KD
      WRITE(LH,3)'_exptl_special_details'//KD
      WRITE(LH,3)';'//KD
      WRITE(LH,3)' ?'//KD
      WRITE(LH,3)';'//KD
      WRITE(LH,3)KD
      IR(1:31)='_diffrn_ambient_temperature    '
      L=33
      CALL SXCF(IR,A(104)+273.,2.,0,L)
      WRITE(LH,3)IR(1:L)//KD
      IR(9:28)='radiation_wavelength'
      L=33
      CALL SXCF(IR,A(1),0.,5,L)
      WRITE(LH,3)IR(1:L)//KD
      IR(19:35)='type            ?'
      L=35
      IF(ABS(A(1)-1.54178).GT.0.001)GOTO 23
      IR(35:36)='Cu'
      GOTO 25
  23  IF(ABS(A(1)-0.71073).GT.0.001)GOTO 24
      IR(35:36)='Mo'
      GOTO 25
  24  IF(ABS(A(1)-0.56086).GT.0.001)GOTO 26
      IR(35:36)='Ag'
  25  IR(37:39)='K'//CHAR(92)//'a'
      L=39
  26  WRITE(LH,3)IR(1:L)//KD
      IR(19:58)='source          ''fine-focus sealed tube'''
      WRITE(LH,3)IR(1:58)//KD
      IR(19:42)='monochromator   graphite'
      WRITE(LH,3)IR(1:42)//KD
      IR(9:36)='measurement_device_type   ?'//KD
      WRITE(LH,3)IR(1:36)
      IR(21:32)='method      '
      WRITE(LH,3)IR(1:36)
      IR(9:32)='detector_area_resol_mean'
      WRITE(LH,3)IR(1:36)
      IR(9:32)='standards_number        '
      WRITE(LH,3)IR(1:36)
      IR(19:32)='interval_count'
      WRITE(LH,3)IR(1:36)
      IR(28:32)='time '
      WRITE(LH,3)IR(1:36)
      IR(19:31)='decay_%      '
      WRITE(LH,3)IR(1:36)
      IR(9:25)='reflns_number    '
      L=33
      CALL SXCF(IR,A(47),0.,0,L)
      WRITE(LH,3)IR(1:L)//KD
      IR(16:33)='av_R_equivalents  '
      L=33
      CALL SXCF(IR,A(48),0.,4,L)
      WRITE(LH,3)IR(1:L)//KD
      IR(19:31)='sigmaI/netI  '
      L=33
      CALL SXCF(IR,A(90),0.,4,L)
      WRITE(LH,3)IR(1:L)//KD
      IR(16:29)='limit_h_min   '
      L=33
      CALL SXCF(IR,A(82),0.,0,L)
      WRITE(LH,3)IR(1:L)//KD
      IR(25:26)='ax'
      L=33
      CALL SXCF(IR,A(83),0.,0,L)
      WRITE(LH,3)IR(1:L)//KD
      IR(22:26)='k_min'
      L=33
      CALL SXCF(IR,A(84),0.,0,L)
      WRITE(LH,3)IR(1:L)//KD
      IR(25:26)='ax'
      L=33
      CALL SXCF(IR,A(85),0.,0,L)
      WRITE(LH,3)IR(1:L)//KD
      IR(22:26)='l_min'
      L=33
      CALL SXCF(IR,A(86),0.,0,L)
      WRITE(LH,3)IR(1:L)//KD
      IR(25:26)='ax'
      L=33
      CALL SXCF(IR,A(87),0.,0,L)
      WRITE(LH,3)IR(1:L)//KD
      IR(16:26)='theta_min  '
      T=57.29578*ATAN2(SQRT(A(89)),SQRT(ABS(1.-A(89))))
      L=33
      CALL SXCF(IR,T,0.,2,L)
      WRITE(LH,3)IR(1:L)//KD
      IR(23:24)='ax'
      T=57.29578*ATAN2(SQRT(A(88)),SQRT(ABS(1.-A(88))))
      L=33
      CALL SXCF(IR,T,0.,2,L)
      WRITE(LH,3)IR(1:L)//KD
      IR(36:36)=KD
      IR='_reflns_number_total'
      L=33
      CALL SXCF(IR,A(125),0.,0,L)
      WRITE(LH,3)IR(1:L)//KD
      IR(16:20)='gt   '
      L=33
      CALL SXCF(IR,A(129),0.,0,L)
      WRITE(LH,3)IR(1:L)//KD
      IR(9:44)='threshold_expression      >2sigma(I)'
      WRITE(LH,3)IR(1:44)//KD
      WRITE(LH,3)KD
      IR(1:36)='_computing_data_collection        ?'//KD
      WRITE(LH,3)IR(1:36)
      IR(12:26)='cell_refinement'
      WRITE(LH,3)IR(1:36)
      IR(12:26)='data_reduction '
      WRITE(LH,3)IR(1:36)
      IR(12:64)='structure_solution     ''SHELXS-97'//
     +' (Sheldrick, 1990)'''//KD
      WRITE(LH,3)IR(1:64)
      IR(22:31)='refinement'
      IR(41:44)='L-97'
      IR(61:61)='7'
      WRITE(LH,3)IR(1:64)
      IR(12:36)='molecular_graphics     ?'//KD
      WRITE(LH,3)IR(1:36)
      IR(12:31)='publication_material'
      WRITE(LH,3)IR(1:36)
      WRITE(LH,3)KD
C
C Refinement data
C
      WRITE(LH,3)'_refine_special_details'//KD
      WRITE(LH,3)';'//KD
      WRITE(LH,3)' Refinement of F^2^ against ALL reflections.'
     +//'  The weighted R-factor wR and'//KD
      WRITE(LH,3)' goodness of fit S are based on F^2^,'
     +//' conventional R-factors R are based'//KD
      WRITE(LH,3)' on F, with F set to zero for negative '
     +//'F^2^. The threshold expression of'//KD
      WRITE(LH,3)' F^2^ > 2sigma(F^2^) is used only for calculati'
     +//'ng R-factors(gt) etc. and is'//KD
      WRITE(LH,3)' not relevant to the choice of reflections for re'
     +//'finement.  R-factors based'//KD
      WRITE(LH,3)' on F^2^ are statistically about twice as large as'
     +//' those based on F, and R-'//KD
      WRITE(LH,3)' factors based on ALL data will be even larger.'
     +//KD
      WRITE(LH,3)';'//KD
      WRITE(LH,3)KD
      KR(1:39)='_refine_ls_structure_factor_coef  Fsqd'
      WRITE(LH,3)KR(1:39)//KD
      KR(12:43)='matrix_type            fullcycle'
      L=38
      IF(A(103).GT.0.5)L=43
      WRITE(LH,3)KR(1:L)//KD
      KR(12:39)='weighting_scheme       calc'
      WRITE(LH,3)KR(1:39)//KD
      KR(12:28)='weighting_details'
      WRITE(LH,3)KR(1:28)//KD
      IF(ABS(A(69)-0.333333).GT.0.0001)GOTO 28
        DO 27 I=66,68
        IF(ABS(A(I)).GT.1.E-6)GOTO 28
  27    CONTINUE
      L=25
      CALL SXCF(IR,A(64),0.,4,L)
      IR(1:26)=' ''calc w=1/['//CHAR(92)//'s^2^(Fo^2^)+('
      L=L+5
      M=L
      CALL SXCF(IR,A(65),0.,4,L)
      IR(M-4:M+1)='P)^2^+'
      L=L+28
      IR(L-27:L)='P] where P=(Fo^2^+2Fc^2^)/3'''
      WRITE(LH,3)IR(1:L)//KD
      GOTO 29
  28  WRITE(LH,3)'; calc'//KD
      L=1
      CALL SXCF(IR,A(70),0.,5,L)
      IR(1:2)=' ['
      M=L+1
      CALL SXCF(IR,A(71),0.,5,L)
      IR(M:M)='+'
      L=L+3
      M=L
      CALL SXCF(IR,A(66),0.,2,L)
      IR(M-2:M+1)='exp('
      L=L+16
      IR(L-15:L)='(sin'//CHAR(92)//'q/'//CHAR(92)//'l)^2^)]/'
      WRITE(LH,3)IR(1:L)//KD
      L=16
      CALL SXCF(IR,A(67),0.,4,L)
      IR(1:17)='   ['//CHAR(92)//'s^2^(Fo^2^)+'
      M=L+1
      CALL SXCF(IR,A(65),0.,4,L)
      IR(M:M)='+'
      L=L+3
      M=L
      CALL SXCF(IR,A(64),0.,4,L)
      IR(M-2:M+1)='*P+('
      L=L+5
      M=L
      CALL SXCF(IR,A(68),0.,4,L)
      IR(M-4:M+1)='P)^2^+'
      L=L+9
      IR(L-8:L)='sin'//CHAR(92)//'q/'//CHAR(92)//'l]'
      WRITE(LH,3)IR(1:L)//KD
      IR(1:11)=' where P = '
      L=10
      CALL SXCF(IR,A(69),0.,5,L)
      L=L+7
      M=L
      T=1.-A(69)
      CALL SXCF(IR,T,0.,5,L)
      IR(M-6:M+1)='Fo^2^ + '
      L=L+5
      IR(L-4:L)='Fc^2^'
      WRITE(LH,3)IR(1:L)//KD
      WRITE(LH,3)';'//KD
  29  IR='_atom_sites_solution_primary      direct'//KD
      WRITE(LH,3)IR(1:41)
      IR(22:30)='secondary'
      IR(35:40)='difmap'
      WRITE(LH,3)IR(1:41)
      IR(22:30)='hydrogens'
      IR(35:39)='geom'//KD
      WRITE(LH,3)IR(1:39)
      WRITE(LH,3)'_refine_ls_hydrogen_treatment     mixed'//KD
      L=38
      IR(1:38)='_refine_ls_extinction_method      none'
      IF(A(39).LT.-8.E9)GOTO 30
      IF(A(200).GT.-998.)GOTO 30
      L=40
      IR(35:40)='SHELXL'
  30  WRITE(LH,3)IR(1:L)//KD
      L=35
      IR(23:35)='coef        ?'
      IF(A(39).LT.-8.E9)GOTO 31
      IF(A(200).GT.-998.)GOTO 31
      L=33
      CALL SXCF(IR,A(39),A(40),-5,L)
  31  WRITE(LH,3)IR(1:L)//KD
      IF(A(39).LT.-8.E9)GOTO 32
      IF(A(200).GT.-998.)GOTO 32
      IR(23:32)='expression'
      WRITE(LH,3)IR(1:32)//KD
      WRITE(LH,3)' ''Fc^*^=kFc[1+0.001xFc^2^'//CHAR(92)//'l^3^'//
     +'/sin(2'//CHAR(92)//'q)]^-1/4^'''//KD
  32  IF(A(23).LT.0.5)GOTO 33
      IR(1:32)='_refine_ls_abs_structure_details'
      WRITE(LH,3)IR(1:32)//KD
      WRITE(LH,3)' ''Flack H D (1983), Acta Cryst. A39, 876-881'''//KD
      IR(26:35)='Flack     '
      L=33
      P=AMIN1(9.99,AMAX1(-9.99,A(156)))
      Q=AMIN1(9.99,A(157))
      CALL SXCF(IR,P,Q,-2,L)
      WRITE(LH,3)IR(1:L)//KD
  33  IR(12:33)='number_reflns         '
      L=33
      CALL SXCF(IR,A(125),0.,0,L)
      WRITE(LH,3)IR(1:L)//KD
      IR(19:28)='parameters'
      L=33
      CALL SXCF(IR,A(91),0.,0,L)
      WRITE(LH,3)IR(1:L)//KD
      IR(19:28)='restraints'
      L=33
      CALL SXCF(IR,A(132),0.,0,L)
      WRITE(LH,3)IR(1:L)//KD
      IR(12:29)='R_factor_all      '
      L=33
      CALL SXCF(IR,A(174),0.,4,L)
      WRITE(LH,3)IR(1:L)//KD
      IR(21:23)='gt '
      L=33
      CALL SXCF(IR,A(130),0.,4,L)
      WRITE(LH,3)IR(1:L)//KD
      IR(12:24)='wR_factor_ref'
      L=33
      CALL SXCF(IR,A(126),0.,4,L)
      WRITE(LH,3)IR(1:L)//KD
      IR(22:24)='gt '
      L=33
      CALL SXCF(IR,A(175),0.,4,L)
      WRITE(LH,3)IR(1:L)//KD
      IR(12:30)='goodness_of_fit_ref'
      L=33
      CALL SXCF(IR,A(127),0.,3,L)
      WRITE(LH,3)IR(1:L)//KD
      IR(12:30)='restrained_S_all   '
      L=33
      CALL SXCF(IR,A(131),0.,3,L)
      WRITE(LH,3)IR(1:L)//KD
      IR(12:27)='shift/su_max    '
      L=33
      CALL SXCF(IR,ABS(A(93)),0.,3,L)
      WRITE(LH,3)IR(1:L)//KD
      IR(22:24)='ean'
      L=33
      CALL SXCF(IR,A(92),0.,3,L)
      WRITE(LH,3)IR(1:L)//KD
      WRITE(LH,3)KD
C
C Atomic coordinates and isotropic displacement parameters
C
      WRITE(LH,3)'loop_'//KD
      KR(1:17)=' _atom_site_label'
      WRITE(LH,3)KR(1:17)//KD
      KR(13:23)='type_symbol'
      WRITE(LH,3)KR(1:23)//KD
      KR(13:19)='fract_x'
      WRITE(LH,3)KR(1:19)//KD
      KR(19:19)='y'
      WRITE(LH,3)KR(1:19)//KD
      KR(19:19)='z'
      WRITE(LH,3)KR(1:19)//KD
      KR(13:26)='U_iso_or_equiv'
      WRITE(LH,3)KR(1:26)//KD
      KR(13:20)='adp_type'
      WRITE(LH,3)KR(1:20)//KD
      KR(13:21)='occupancy'
      WRITE(LH,3)KR(1:21)//KD
      KR(13:32)='symetry_multiplicity'
      WRITE(LH,3)KR(1:32)//KD
      KR(13:21)='calc_flag'
      WRITE(LH,3)KR(1:21)//KD
      KR(13:28)='refinement_flags'
      WRITE(LH,3)KR(1:28)//KD
      KR(13:29)='disorder_assembly'
      WRITE(LH,3)KR(1:29)//KD
      KR(22:26)='group'
      WRITE(LH,3)KR(1:26)//KD
C
C Flag atoms not in PART 0 and correlate fv's for occupancies
C
        DO 34 I=1,LU
        MB(I)=LX
  34    CONTINUE
      NN=LB-16
  35  NN=NN+32
      IF(NN.GT.LX)GOTO 37
      A(NN+5)=0.
      IF(INT(A(NN+29)).EQ.0)GOTO 35
      K=MIN(LU,INT(0.5+0.1*ABS(A(NN+10))))
      IF(K.LT.2)GOTO 36
      IF(MB(K).GT.NN)MB(K)=NN
  36  A(NN+5)=REAL(NN)+0.1
      K=INT(A(NN+28))
      IF(K.EQ.0)GOTO 35
      IF(INT(A(K+5)).NE.0)A(NN+5)=A(K+5)
      GOTO 35
  37  NN=LB-16
  38  NN=NN+32
      IF(NN.GT.LX)GOTO 39
      IF(INT(A(NN+29)).EQ.0)GOTO 38
      K=MIN(LU,INT(0.5+0.1*ABS(A(NN+10))))
      IF(K.LT.2)GOTO 38
      A(NN+5)=REAL(MB(K))+0.1
      GOTO 38
C
C Take into account disordered atoms attached to the same PART 0 atom
C
  39  NN=LB-16
  40  NN=NN+32
      IF(NN.GT.LX)GOTO 47
      IF(INT(A(NN+5)).NE.0)GOTO 40
      L=INT(A(NN+4))
      IF(L.EQ.0)GOTO 40
      N=LX+1
  41  L=L+1
      M=INT(ABS(A(L)))
      IF(M.GT.LX)GOTO 42
      M=INT(A(M+5))
      IF(M.GT.0)N=MIN0(N,M)
  42  IF(A(L).GT.0.)GOTO 41
      IF(N.GT.LX)GOTO 40
      T=REAL(N)+0.1
      L=NN
  43  L=L+32
      IF(L.GT.LX)GOTO 44
      M=INT(A(L+28))
      IF(M.NE.NN)GOTO 43
      IF(INT(A(L+5)).EQ.0)A(L+5)=T
      A(L+5)=AMIN1(A(L+5),T)
      GOTO 43
  44  L=INT(A(NN+4))
  45  L=L+1
      M=INT(ABS(A(L)))
      IF(M.GT.LX)GOTO 46
      IF(INT(A(M+5)).EQ.0)A(M+5)=T
      A(M+5)=AMIN1(A(M+5),T)
  46  IF(A(L).GT.0.)GOTO 45
      GOTO 40
C
C Connected atoms with same non-zero PART number
C
  47  J=0
      NN=LB-16
  48  NN=NN+32
      IF(NN.GT.LX)GOTO 52
      K=INT(A(NN+5))
      IF(K.EQ.0)GOTO 48
      L=K
      M=INT(A(NN+4))
      IF(M.EQ.0)GOTO 48
  49  M=M+1
      N=INT(ABS(A(M)))
  50  N=INT(A(N+5))
      IF(N.EQ.0)GOTO 51
      L=MIN0(L,N)
      IF(N.GT.INT(A(N+5)))GOTO 50
  51  IF(A(M).GT.0.)GOTO 49
      IF(L.EQ.K)GOTO 48
      A(NN+5)=REAL(L)+0.1
      J=1
      GOTO 48
  52  IF(J.GT.0)GOTO 47
      NN=LB-16
  53  NN=NN+32
      IF(NN.GT.LX)GOTO 54
      IF(INT(A(NN+28)).EQ.0)GOTO 53
      K=INT(A(NN+5))
      IF(K.NE.0)A(NN+5)=AMIN1(A(NN+5),A(K+5))
      GOTO 53
C
C Assign codes for different disorder assemblies
C
  54  T=-0.1
      NN=LB-16
  55  NN=NN+32
      IF(NN.GT.LX)GOTO 56
      N=INT(A(NN+5))
      IF(N.EQ.0)GOTO 55
      IF(NN.NE.N)GOTO 55
      T=T-1.
      A(NN+5)=T
      GOTO 55
  56  NN=LB-16
  57  NN=NN+32
      IF(NN.GT.LX)GOTO 58
      N=INT(A(NN+5))
      IF(N.LE.0)GOTO 57
      A(NN+5)=A(N+5)
      GOTO 57
C
C Scan atom list for CIF coordinate table
C
  58  NN=LB-16
  59  NN=NN+32
      IF(NN.GT.LX)GOTO 79
      L=0
      KR=' '
      CALL SXAN(-NN,KR,L,LM,A)
      K=INT(ABS(A(NN+3)))
      CALL SXUS(A(K+13),KS)
      CALL SXLC(KS(2:2))
      L=L+1
        DO 60 I=1,4
        IF(KS(I:I).EQ.IH(20))GOTO 60
        L=L+1
        KR(L:L)=KS(I:I)
  60    CONTINUE
      K=INT(A(NN+27))-1
      P=A(NN+21)
      X=A(K+5)
      IF(A(NN+3).GE.0.)GOTO 62
      A(K+5)=A(K+11)
      Q=0.
      M=NN+21
        DO 61 I=136,141
        Q=Q+A(M)*A(I)
        M=M+1
  61    CONTINUE
      A(NN+21)=Q
  62    DO 63 N=NN+17,NN+21
        K=K+1
        IF(N.EQ.NN+20)GOTO 63
        I=4
        IF(N.EQ.NN+21)I=3
        CALL SXCF(KR,A(N),A(K),-I,L)
  63    CONTINUE
      A(K)=X
      A(NN+21)=P
      L=L+5
      KR(L-3:L)='Uiso'
      IF(A(NN+3).LT.0.)KR(L-2:L)='ani'
      P=0.
        DO 65 I=201,LY,12
        X=A(NN+17)*A(I)+A(NN+18)*A(I+1)+A(NN+19)*A(I+2)+A(I+9)
        Y=A(NN+17)*A(I+3)+A(NN+18)*A(I+4)+A(NN+19)*A(I+5)+A(I+10)
        Z=A(NN+17)*A(I+6)+A(NN+18)*A(I+7)+A(NN+19)*A(I+8)+A(I+11)
          DO 64 M=LY+12,LL,4
          U=AMOD(A(M)*X+A(M+1)-A(NN+17),1.)-.5
          V=AMOD(A(M)*Y+A(M+2)-A(NN+18),1.)-.5
          W=AMOD(A(M)*Z+A(M+3)-A(NN+19),1.)-.5
          IF(U**2*A(8)+V**2*A(9)+W**2*A(10)+V*W*A(11)+U*W*A(12)+
     +    U*V*A(13).LT.0.01)P=P+1.
  64      CONTINUE
  65    CONTINUE
      U=A(NN+20)*P
      IF(ABS(U-1.).LT.0.001)U=1.
      V=A(K-1)*P
      I=0
      IF(V.GT.1.E-6)I=2
      IF(ABS(U-1.).GT.1.E-4)I=2
      CALL SXCF(KR,U,V,-I,L)
      L=L+1
      WRITE(KQ,6)INT(P)
        DO 678 I=1,6
        IF(KQ(I:I).EQ.' ')GOTO 678
        L=L+1
        IF(L.GT.128)L=128
        KR(L:L)=KQ(I:I)
 678    CONTINUE
      M=INT(ABS(A(NN+6))*.1)
      L=L+2
      IF(L.GT.128)L=128
      KR(L:L)='d'
      IF(M.GT.16)GOTO 67
      IF(M.GT.11)GOTO 66
      IF(M.EQ.9)GOTO 66
      IF(M.EQ.8)GOTO 66
      IF(M.GT.4)GOTO 67
      IF(M.EQ.0)GOTO 67
  66  L=L+3
      IF(L.GT.128)L=128
      KR(L-3:L)='calc'
  67  L=L+1
      NL=L
      IF(P.LT.1.5)GOTO 68
      L=L+1
      IF(L.GT.128)L=128
      KR(L:L)='S'
  68  IF(ABS(P*A(NN+20)-1.).LT.0.001)GOTO 69
      L=L+1
      IF(L.GT.128)L=128
      KR(L:L)='P'
  69  N=INT(AMOD(ABS(A(NN+6)),10.))
      IF(N.LT.3)GOTO 71
      L=L+1
      IF(L.GT.128)L=128
      KR(L:L)='R'
      IF(N.EQ.5)GOTO 70
      IF(N.EQ.6)GOTO 70
      IF(N.NE.9)GOTO 71
  70  KR(L:L)='G'
  71  NI=0
      NJ=0
      K=LJ+1
  72  N=INT(A(K)/64000.)
      IF(N.EQ.0)GOTO 76
      NK=K
      NT=NK
      K=K+INT(AMOD(A(K),64000.))
      IF(NI.NE.0)GOTO 74
      IF(N.EQ.50)NK=NK+2
      IF(N.EQ.51)NK=NK+1
      IF(N.EQ.55)NK=NK+1
      IF(N.EQ.56)NK=NK+2
      IF(NK.EQ.NT)GOTO 74
  73  NK=NK+1
      IF(NK.GE.K)GOTO 74
      IF(INT(A(NK)).NE.NN)GOTO 73
      NI=1
      L=L+1
      IF(L.GT.128)L=128
      KR(L:L)='D'
      IF(NJ.NE.0)GOTO 76
  74  IF(NJ.NE.0)GOTO 72
      IF(IABS(N-59).GT.1)GOTO 72
      NK=NT+1
  75  NK=NK+1
      IF(NK.GE.K)GOTO 72
      IF(INT(A(NK)).NE.NN)GOTO 75
      NJ=1
      L=L+1
      IF(L.GT.128)L=128
      KR(L:L)='U'
      IF(NI.EQ.0)GOTO 72
  76  IF(L.GT.NL)GOTO 77
      L=L+1
      IF(L.GT.128)L=128
      KR(L:L)='.'
  77  L=L+2
      IF(L.GT.128)L=128
      KR(L-1:L)=' .'
      I=INT(A(NN+5))
      IF(I.LT.0)KR(L:L)=CHAR(ICHAR('A')-MOD(I+1,26))
      L=L+1
      WRITE(KQ,6)INT(A(NN+29))
      IF(KQ(5:6).EQ.' 0')KQ(5:6)='.'
        DO 78 I=1,6
        IF(KQ(I:I).EQ.' ')GOTO 78
        L=L+1
        IF(L.GT.128)L=128
        KR(L:L)=KQ(I:I)
  78    CONTINUE
      WRITE(LH,3)KR(1:L)//KD
      GOTO 59
C
C Anisotropic displacement parameters
C
  79  NN=LB-16
  80  NN=NN+32
      IF(NN.GT.LX)GOTO 83
      IF(A(NN+3).GT.0.)GOTO 80
      WRITE(LH,3)KD
      WRITE(LH,3)'loop_'//KD
      KR(1:23)=' _atom_site_aniso_label'
      WRITE(LH,3)KR(1:23)//KD
      KR(19:22)='U_11'
      WRITE(LH,3)KR(1:22)//KD
      KR(21:22)='22'
      WRITE(LH,3)KR(1:22)//KD
      KR(21:22)='33'
      WRITE(LH,3)KR(1:22)//KD
      KR(21:22)='23'
      WRITE(LH,3)KR(1:22)//KD
      KR(21:22)='13'
      WRITE(LH,3)KR(1:22)//KD
      KR(21:22)='12'
      WRITE(LH,3)KR(1:22)//KD
      NN=LB-16
  81  NN=NN+32
      IF(NN.GT.LX)GOTO 83
      IF(A(NN+3).GT.0.)GOTO 81
      L=0
      IR=' '
      CALL SXAN(-NN,IR,L,LM,A)
      K=INT(A(NN+27))+3
        DO 82 N=NN+21,NN+26
        K=K+1
        CALL SXCF(IR,A(N),A(K),-3,L)
  82    CONTINUE
      WRITE(LH,3)IR(1:L)//KD
      GOTO 81
  83  WRITE(LH,3)KD
  84  REWIND LA
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SX3L(LM,JW,LU,MH,MK,ML,MB,FF,SI,FC,SQ,WL,FB,A,B)
C
C Tables and analysis of variance
C
      CHARACTER*1 IH(50),KD
      CHARACTER*2 KA(94)
      CHARACTER*4 KS,KT,KY,KZ,KW
      CHARACTER*76 IT
      CHARACTER*80 NM,IR,KQ
      CHARACTER*128 KR,KX
      INTEGER MH(LU),MK(LU),ML(LU),MB(LU)
      REAL FF(LU),SI(LU),FC(LU),SQ(LU),WL(LU),FB(LU),A(LM),B(JW)
      COMMON/MEM/ST,SL,TC,TL,IV,LR,LG,LH,LI,LP,LF,LA,LC,LW,LY,LL,LB,
     +LX,LE,LV,LJ,LD,LS,LO,LT,LK,LQ,LZ,LN,KH,JA,JB,JC,JD,JE,HA,HD
      COMMON/WORD/IH,IT,IR,NM,KA,KD
C
   1  FORMAT(///' Principal mean square atomic displacements U'/)
   2  FORMAT(3F9.4,A,'  may be split into',3F8.4,'  and',3F8.4)
   3  FORMAT(3F9.4,2A,'** NON POSITIVE DEFINITE **')
   4  FORMAT(A)
   5  FORMAT(' Sigma-A =',F7.4,' for reference set and',F7.4,
     +' for working set, ratio =',F7.4)
   6  FORMAT(///' Analysis of variance for reflections employed in ',
     +'refinement',6X,'K = Mean[Fo^2] / Mean[Fc^2]  for group'///
     +' Fc/Fc(max)       0.000',10F9.3//' Number in group  ',
     +10F9.0//12X,'GooF  ',10F9.3//13X,'K    ',10F9.3///' Resolutio',
     +'n(A)',F8.2,9F9.2,'     inf'//' Number in group  ',10F9.0//12X,
     +'GooF  ',10F9.3//13X,'K    ',10F9.3//13X,'R1   ',10F9.3/)
   7  FORMAT(/' ** Extinction (EXTI) or solvent water (SWAT) ',
     +'correction may be required **')
   8  FORMAT(/' Recommended weighting scheme:  WGHT',2F12.4/
     +' Note that in most cases convergence will be faster if fixed',
     +' weights (e.g. the'/' default WGHT 0.1) are retained until ',
     +'the refinement is virtually complete, and'/' only then should',
     +' the above recommended values be used.'/)
   9  FORMAT('END ',A1/'    ',A1/'WGHT',2F12.4,A1)
  10  FORMAT(//' Most Disagreeable Reflections (* if suppressed or ',
     +'used for Rfree)'//'     h   k   l        Fo^2         Fc^2   ',
     +'Delta(F^2)/esd  Fc/Fc(max)  Resolution(A)'/)
  11  FORMAT(1X,A1,3I4,2F14.2,F11.2,F12.3,F11.2)
  12  FORMAT(///' Bond lengths and angles')
  13  FORMAT(/A,'Distance       Angles')
  14  FORMAT(A,F7.4,' (',F6.4,') ',7(F7.2,' (',F4.2,')'))
  15  FORMAT(///' Selected torsion angles'/)
  16  FORMAT(F9.2,' ',A,F5.2,')  ',A)
  17  FORMAT(F9.2,2X,A)
  18  FORMAT(///' Specified hydrogen bonds (with esds except fixed',
     +' and riding H)'//'  D-H',10X,'H...A',8X,'D...A',8X,'<(DHA)'/)
  19  FORMAT(' ** No suitable H-bond found for',A,' A **')
  20  FORMAT(///' Least-squares planes (x,y,z in crystal coord',
     +'inates) and deviations from them'/' (* indicates atom ',
     +'used to define plane)')
  21  FORMAT(' Angle to previous plane (with approximate esd) =',
     +F6.2,' (',F5.2,' )'/)
  22  FORMAT(' Angle to previous plane =',F6.2/)
  23  FORMAT(1X,A,F10.4,' ',A,F6.4,')  ',A)
  24  FORMAT(1X,A,F10.4,2X,A)
  25  FORMAT(/' Rms deviation of fitted atoms =',F9.4/)
C
      CALL SXZA(FB,9)
        DO 26 I=5,7
        FF(I)=SIN(.0174533*A(I))
        FC(I)=COS(.0174533*A(I))
  26    CONTINUE
      Q=(FC(7)-FC(5)*FC(6))/(FF(5)*FF(6))
      S=SQRT(AMAX1(0.,1.-Q**2))
      FB(1)=1.
      FB(4)=Q/S
      FB(5)=1./S
      FB(7)=FC(6)*FB(5)/FF(6)
      FB(8)=FC(5)*FB(5)/FF(5)
      FB(9)=FF(7)/(FF(5)*FF(6)*S)
      NT=0
      NN=LB-16
  27  NN=NN+32
      IF(NN.GT.LX)GOTO 46
      N=NN+21
      IF(A(NN+3).LT.0.)GOTO 29
        DO 28 I=1,3
        SQ(I)=A(N)
  28    CONTINUE
      GOTO 36
  29    DO 31 K=1,6
        I=(K-1)*3
        L=I
        IF(K.LT.4)GOTO 30
        I=MOD(K,3)*3
        L=MOD(K+1,3)*3
  30    SQ(K)=A(N)*FB(I+1)*FB(L+1)+A(N+1)*FB(I+2)*FB(L+2)+A(N+2)*
     +  FB(I+3)*FB(L+3)+A(N+3)*(FB(I+2)*FB(L+3)+FB(I+3)*FB(L+2))+
     +  A(N+4)*(FB(I+1)*FB(L+3)+FB(I+3)*FB(L+1))+A(N+5)*(FB(I+1)*
     +  FB(L+2)+FB(I+2)*FB(L+1))
  31    CONTINUE
      CALL SXZA(SI,9)
        DO 32 I=1,9,4
        SI(I)=1.
  32    CONTINUE
      NI=0
  33  Q=-1.
        DO 34 M=4,6
        P=ABS(SQ(M))
        IF(Q.GT.P)GOTO 34
        K=M
        Q=P
  34    CONTINUE
      IF(Q.LT.1.E-6)GOTO 36
      IF(NI.GT.99)GOTO 36
      NI=NI+1
      L=MOD(K,3)+1
      I=MOD(L,3)+1
      Y=SQ(I)-SQ(L)
      IF(Y*SQ(K).LT.0.)Q=-Q
      Z=SQRT(4.*Q**2+Y**2)
      V=.5*(Z+ABS(Y))/Z
      Y=SQRT(V)
      X=Q/(Y*Z)
      U=X**2
      W=2.*X*Y
      Z=SQ(L)
      SQ(L)=Z*V-SQ(K)*W+SQ(I)*U
      SQ(I)=Z*U+SQ(K)*W+SQ(I)*V
      Z=SQ(I+3)
      SQ(I+3)=Z*Y-SQ(L+3)*X
      SQ(L+3)=SQ(L+3)*Y+Z*X
      SQ(K)=0.
      M=3*I-2
      L=3*L-2
        DO 35 I=M,M+2
        Q=SI(L)
        SI(L)=Q*Y-SI(I)*X
        SI(I)=Q*X+SI(I)*Y
        L=L+1
  35    CONTINUE
      GOTO 33
  36  IR=' '
      L=3
      CALL SXAN(NN,IR,L,LM,A)
      L=L+2
      IF(SQ(1).GE.SQ(2))GOTO 37
      U=SQ(1)
      SQ(1)=SQ(2)
      SQ(2)=U
      CALL SXCA(SI(4),SI(1),3)
  37  IF(SQ(2).GE.SQ(3))GOTO 38
      U=SQ(2)
      SQ(2)=SQ(3)
      SQ(3)=U
      CALL SXCA(SI(7),SI(4),3)
  38  IF(SQ(1).GE.SQ(2))GOTO 39
      U=SQ(1)
      SQ(1)=SQ(2)
      SQ(2)=U
      CALL SXCA(SI(4),SI(1),3)
  39  M=(NN-LB)/32+LE+40
      K=INT(A(M))
      IF(K.EQ.0)GOTO 40
      T=A(NN+20)
      A(K+2)=A(K+2)+T
      U=(SQ(1)+SQ(2)+SQ(3))/3.
      A(K+4)=A(K+4)+T*U
      A(K+5)=AMAX1(A(K+5),U)
      U=1.
      IF(SQ(1).GT.0.00001)U=SQ(3)/SQ(1)
      A(K+6)=A(K+6)+T*U
      A(K+7)=AMIN1(A(K+7),U)
  40  IF(SQ(3).LE.0.)GOTO 44
      IF(SQ(1).LT.0.2)GOTO 42
      IF(SQ(1).LT.2.5*SQ(2))GOTO 42
      T=0.5*SQRT(SQ(1)-SQ(2))
      SI(3)=T*SI(3)/A(99)
      SI(2)=(T*SI(2)-A(98)*SI(3))/A(97)
      SI(1)=(T*SI(1)-A(95)*SI(2)-A(96)*SI(3))/A(94)
      M=NN+17
        DO 41 I=1,3
        SI(I+3)=A(M)-SI(I)
        SI(I)=A(M)+SI(I)
        M=M+1
  41    CONTINUE
      IF(NT.EQ.0)WRITE(LI,1)
      WRITE(LI,2)(SQ(I),I=1,3),IR(1:L),(SI(I),I=1,6)
      GOTO 45
  42  IF(ABS(A(51)).LT.0.5)GOTO 27
      IF(ABS(A(51)).GT.2.5)GOTO 43
      IF(A(NN+3).GT.0.)GOTO 27
  43  IF(NT.EQ.0)WRITE(LI,1)
      WRITE(LI,3)(SQ(I),I=1,3),IR(1:L)
      GOTO 45
  44  IF(NT.EQ.0)WRITE(LI,1)
      WRITE(LI,3)(SQ(I),I=1,3),IR(1:L),IH(20)
  45  NT=1
      GOTO 27
  46  CALL SXTO(16)
C
C Estimate overfit parameter if R(free) used (and get max sinsq theta
C for use in Sim weights)
C
      R=0.
  47  READ(LA)MH,MK,ML,FF,SI,SQ,WL,FB,FC
      CALL SXCC
      N=MH(LU)
        DO 48 I=1,N
        R=AMAX1(R,ABS(SQ(I)))
  48    CONTINUE
      IF(ML(LU).GT.0)GOTO 47
      REWIND LA
      A(144)=10./R
      IF(A(165).LT.0.5)GOTO 55
        DO 49 I=1,39
        B(I)=0.
  49    CONTINUE
  50  READ(LA)MH,MK,ML,FF,SI,SQ,WL,FB,FC
      CALL SXCC
      N=MH(LU)
        DO 51 I=1,N
        V=A(144)*ABS(SQ(I))
        K=MIN0(INT(V),9)
        V=V-REAL(K)
        U=1.-V
        B(K+1)=B(K+1)+U*FF(I)
        B(K+2)=B(K+2)+V*FF(I)
        B(K+12)=B(K+12)+U*FC(I)
        B(K+13)=B(K+13)+V*FC(I)
        B(K+23)=B(K+23)+U
        B(K+24)=B(K+24)+V
  51    CONTINUE
      IF(ML(LU).GT.0)GOTO 50
      REWIND LA
        DO 52 I=1,11
        B(I)=B(I+22)/AMAX1(0.0001,B(I))
        B(I+11)=B(I+22)/AMAX1(0.0001,B(I+11))
  52    CONTINUE
  53  READ(LA)MH,MK,ML,FF,SI,SQ,WL,FB,FC
      CALL SXCC
      N=MH(LU)
        DO 54 I=1,N
        V=A(144)*ABS(SQ(I))
        K=MIN0(INT(V),9)
        V=V-REAL(K)
        U=1.-V
        P=FF(I)*(U*B(K+1)+V*B(K+2))-1.
        Q=FC(I)*(U*B(K+12)+V*B(K+13))-1.
        L=34
        IF(I.GT.MK(LU))L=37
        B(L)=B(L)+P*Q
        B(L+1)=B(L+1)+P**2
        B(L+2)=B(L+2)+Q**2
  54    CONTINUE
      IF(ML(LU).GT.0)GOTO 53
      REWIND LA
      P=SQRT(B(37)/AMAX1(0.0001,SQRT(B(38)*B(39))))
      Q=SQRT(B(34)/AMAX1(0.0001,SQRT(B(35)*B(36))))
      WRITE(*,5)P,Q,P/Q
      WRITE(LI,4)
      WRITE(LI,5)P,Q,P/Q
C
C Analysis of variance - scan once through reflection data
C
  55  WW=A(69)
      IF(ABS(A(75)-1.).LT.0.00001)WW=1.
        DO 56 I=1,16700
        B(I)=0.
  56    CONTINUE
      B(16001)=9.E9
      X=0.
      Y=0.
      Z=0.
      NI=16001
      NJ=16051
      IF(ABS(A(51)).LT.0.5)NJ=16001
      IF(ABS(A(51)).GT.1.5)NJ=16100
  57  READ(LA)MH,MK,ML,FF,SI,SQ,WL,FB,FC
      CALL SXCC
      MN=MH(LU)
        DO 62 I=1,MN
        P=FF(I)/A(75)
        S=(SI(I)/A(75))**2
        T=AMAX1(0.,WW*P)+(1.-WW)*FC(I)
        W=(S+(A(64)*T)**2+A(67)+A(65)*T+A(68)*SQRT(SQ(I)))/
     +  (A(70)+A(71)*EXP(A(66)*SQ(I)))
        Q=(P-FC(I))**2
        U=Q/W
        IF(I.GT.MK(LU))GOTO 58
C
C Sum for small ranges of Fc and resolution
C
        K=MIN0(1000,INT(1000.*SQRT(FC(I)/A(134)))+1)
        B(K)=B(K)+1.
        B(K+1000)=B(K+1000)+U
        B(K+2000)=B(K+2000)+P
        B(K+3000)=B(K+3000)+FC(I)
        K=MAX0(1,2000-INT(1000.*SQRT(SQ(I))))
        B(K+4000)=B(K+4000)+1.
        B(K+6000)=B(K+6000)+U
        B(K+8000)=B(K+8000)+P
        B(K+10000)=B(K+10000)+FC(I)
        V=SQRT(ABS(P))
        B(K+12000)=B(K+12000)+ABS(V-SQRT(FC(I)))
        B(K+14000)=B(K+14000)+V
        W=T**2
        X=X+(Q-S)*W/S
        Y=Y+W**2/S
        Z=Z+T
C
C Inconsistent reflections
C
  58    IF(B(NJ).GE.U)GOTO 62
        L=NI+1
        K=L
  59    L=L-1
        IF(B(L).LT.U)GOTO 59
  60    K=K-1
        IF(L.GE.K)GOTO 61
        B(K+1)=B(K)
        B(K+101)=B(K+100)
        B(K+201)=B(K+200)
        B(K+301)=B(K+300)
        B(K+401)=B(K+400)
        B(K+501)=B(K+500)
        B(K+601)=B(K+600)
        GOTO 60
  61    B(L+1)=U
        B(L+101)=REAL(MH(I))
        B(L+201)=REAL(MK(I))
        B(L+301)=REAL(ML(I))
        B(L+401)=P
        B(L+501)=FC(I)
        IF(I.GT.MK(LU))B(L+501)=-B(L+501)
        B(L+601)=SQ(I)
        NI=MIN0(NI+1,NJ)
  62    CONTINUE
      IF(ML(LU).GT.0)GOTO 57
      REWIND LA
C
C Print analysis of variance
C
      CALL SXZA(FF,90)
      CALL SXZA(FC,90)
      Q=.0999*A(125)
      T=Q
      S=0.
      K=1
        DO 63 I=1,1000
        IF(B(I).LT.0.5)GOTO 63
        S=S+B(I)
        FF(K)=0.001*REAL(I)
        FF(K+10)=FF(K+10)+B(I)
        FF(K+20)=FF(K+20)+B(I+1000)
        FF(K+30)=FF(K+30)+B(I+2000)
        FC(K+30)=FC(K+30)+B(I+3000)
        IF(S.LE.T)GOTO 63
        MB(K)=I
        K=MIN0(K+1,10)
        T=T+Q
  63    CONTINUE
      T=Q
      S=0.
      K=41
        DO 64 I=4001,6000
        IF(B(I).LT.0.5)GOTO 64
        S=S+B(I)
        IF(FF(K).LT.1.E-8)FF(K)=500./REAL(6001-I)
        FF(K+10)=FF(K+10)+B(I)
        FF(K+20)=FF(K+20)+B(I+2000)
        FF(K+30)=FF(K+30)+B(I+4000)
        FC(K+30)=FC(K+30)+B(I+6000)
        FF(K+40)=FF(K+40)+B(I+8000)
        FC(K+40)=FC(K+40)+B(I+10000)
        IF(S.LE.T)GOTO 64
        K=MIN0(K+1,50)
        T=T+Q
  64    CONTINUE
        DO 66 N=21,61,40
          DO 65 I=N,N+9
          FF(I)=SQRT(A(143)*FF(I)/AMAX1(0.0001,FF(I-10)))
          FF(I+10)=AMIN1(999.999,AMAX1(-999.999,FF(I+10)/
     +    AMAX1(0.0001,FC(I+10))))
  65      CONTINUE
  66    CONTINUE
        DO 67 N=81,90
        FF(N)=FF(N)/AMAX1(0.0001,FC(N))
  67    CONTINUE
      WRITE(LI,6)(FF(I),I=1,90)
C
C Analyse weighting scheme
C
      IF(A(127).GT.99.)GOTO 81
      MB(10)=1001
      P=SQRT(AMAX1(.0001,.64*X/AMAX1(1.E-8,Y)))
      Q=.5*Z*P**2/A(125)
      RR=.2*P
      R=.4*Q
      IF(A(39).GT.-8.E9)GOTO 68
      IF(FF(40).GT.0.95*FF(39))GOTO 68
      IF(FF(80).GT.0.95*FF(79))GOTO 68
      WRITE(*,7)
      WRITE(*,11)
      CALL SXFL
      WRITE(LI,7)
  68  P=AMAX1(P,4.*RR)-4.*RR
      Q=AMAX1(Q,4.*R)-4.*R
      IF(P.GT.0.3)GOTO 79
      CALL SXZA(B(1),820)
  69  READ(LA)MH,MK,ML,FF,SI,SQ,WL,FB,FC
      CALL SXCC
      MN=MK(LU)
        DO 72 I=1,MN
        U=FF(I)/A(75)
        S=(SI(I)/A(75))**2
        T=AMAX1(0.,WW*U)+(1.-WW)*FC(I)
        IF(ABS(A(75)-1.).LT.1.E-6)T=AMAX1(FF(I),0.)
        U=(U-FC(I))**2
        K=MIN0(1000,INT(1000.*SQRT(FC(I)/A(134)))+1)
        M=0
  70    M=M+1
        IF(MB(M).LT.K)GOTO 70
        B(M)=B(M)+1.
        X=P
        Y=Q
          DO 71 K=1,81
          M=M+10
          B(M)=B(M)+U/(S+(T*X)**2+T*Y)
          X=X+RR
          IF(MOD(K,9).NE.0)GOTO 71
          X=P
          Y=Y+R
  71      CONTINUE
  72    CONTINUE
      IF(ML(LU).GT.0)GOTO 69
      REWIND LA
      S=9.E9
      M=10
        DO 74 K=1,81
        Z=0.
          DO 73 N=1,10
          M=M+1
          V=SQRT(B(M)*A(143)/AMAX1(0.01,B(N)))
          W=(V-1.)**2
          Z=Z+W
          IF(V.LT.1.)Z=Z+9.*W
  73      CONTINUE
        IF(Z.GT.S)GOTO 74
        S=Z
        NN=K-1
  74    CONTINUE
      K=MOD(NN,9)
      L=NN/9
      P=P+REAL(K)*RR
      Q=Q+REAL(L)*R
      IF(K.EQ.8)RR=2.*RR
      IF(L.EQ.8)R=2.*R
      IF(K.EQ.8)GOTO 68
      IF(L.EQ.8)GOTO 68
      IF(P.LT.1.E-4)GOTO 75
      IF(K.EQ.0)GOTO 76
  75  RR=.25*RR
  76  IF(Q.LT.1.E-3)GOTO 77
      IF(L.EQ.0)GOTO 78
  77  R=.25*R
  78  IF(RR.GT.0.0001)GOTO 68
      IF(R.GT.0.005)GOTO 68
      IF(P.LT.0.2)GOTO 80
  79  P=0.2
      Q=0.
  80  WRITE(LI,8)P,Q
      WRITE(LP,9)KD,KD,P,Q,KD
C
C Print most disagreeable reflections
C
  81  IF(NI.LE.16001)GOTO 83
      WRITE(LI,10)
        DO 82 I=16002,NI
        S=SQRT(B(I)/A(62))
        K=INT(B(I+100))
        M=INT(B(I+200))
        N=INT(B(I+300))
        T=ABS(B(I+500))
        P=SQRT(T/A(134))
        Q=0.5/SQRT(B(I+600))
        NN=20
        IF(B(I+500).LT.0.)NN=21
        WRITE(LI,11)IH(NN),K,M,N,B(I+400),T,S,P,Q
  82    CONTINUE
C
C .cif and .lst output of bond lengths and angles
C
  83  NT=0
      CALL SXTO(15)
      ND=1
      IF(A(74).GT.0.5)ND=3
      IF(ND.NE.3)GOTO 84
      WRITE(LH,4)'_geom_special_details'//KD
      WRITE(LH,4)';'//KD
      WRITE(LH,4)' All esds (except the esd in the dihedral '//
     +'angle between two l.s. planes)'//KD
      WRITE(LH,4)' are estimated using the full covariance matrix.'
     +//'  The cell esds are taken'//KD
      WRITE(LH,4)' into account individually in the estimation of '
     +//'esds in distances, angles'//KD
      WRITE(LH,4)' and torsion angles; correlations between esds in'
     +//' cell parameters are only'//KD
      WRITE(LH,4)' used when they are defined by crystal symmetry.'
     +//'  An approximate (isotropic)'//KD
      WRITE(LH,4)' treatment of cell esds is used for estimating'
     +//' esds involving l.s. planes.'//KD
      WRITE(LH,4)';'//KD
      WRITE(LH,4)KD
  84    DO 98 NC=1,ND
        NN=LJ+1
        IF(NC.LT.2)GOTO 86
        WRITE(LH,4)'loop_'//KD
        IF(NC.EQ.3)GOTO 85
        KR(1:29)=' _geom_bond_atom_site_label_1'
        WRITE(LH,4)KR(1:29)//KD
        KR(29:29)='2'
        WRITE(LH,4)KR(1:29)//KD
        KR(13:20)='distance'
        WRITE(LH,4)KR(1:20)//KD
        KR(13:27)='site_symmetry_2'
        WRITE(LH,4)KR(1:27)//KD
        KR(13:21)='publ_flag'
        WRITE(LH,4)KR(1:21)//KD
        GOTO 86
  85    KR(1:30)=' _geom_angle_atom_site_label_1'
        WRITE(LH,4)KR(1:30)//KD
        KR(30:30)='2'
        WRITE(LH,4)KR(1:30)//KD
        KR(30:30)='3'
        WRITE(LH,4)KR(1:30)//KD
        WRITE(LH,4)KR(1:12)//KD
        KR(14:28)='site_symmetry_1'
        WRITE(LH,4)KR(1:28)//KD
        KR(28:28)='3'
        WRITE(LH,4)KR(1:28)//KD
        KR(14:22)='publ_flag'
        WRITE(LH,4)KR(1:22)//KD
  86    NK=INT(A(NN)/64000.)
        IF(NK.EQ.0)GOTO 97
        N=NN+1
        NN=INT(AMOD(A(NN),64000.))+NN
        IF(NK.NE.47)GOTO 86
        IF(NT.EQ.0)WRITE(LI,12)
        NT=1
        NA=INT(A(N))
        NB=NA
        MN=0
        N=N+1
        IR=' '
        IF(NC.LT.2)GOTO 87
        L=NA
        IF(L.GT.LX)L=INT(A(L+3))
        NL=0
        CALL SXAN(-L,IR,NL,LM,A)
        GOTO 88
  87    L=1
        CALL SXAN(NA,IR,L,LM,A)
        IR(L+1:L+2)=' -'
        WRITE(LI,13)IR(1:13)
        NL=14
  88    KR=IR
  89    IF(N.GE.NN)GOTO 96
        IR=' '
        L=1
        NA=INT(A(N))
        K=NA
        IF(K.GT.LX)K=INT(A(K+3))
        NJ=NA
        IF(NC.NE.1)NJ=-K
        CALL SXAN(NJ,IR,L,LM,A)
        FC(1)=A(N+1)
        FC(2)=AMIN1(9.999,A(N+2))
        IF(FC(2).LT.0.0001)FC(2)=-1.
        IF(INT(ABS(A(K+3))).NE.KH)K=0
        IF(K.NE.0)K=MOD(INT(ABS(A(K+6))),10)
        IF(K.EQ.1.OR.K.EQ.3.OR.K.EQ.4.OR.K.EQ.5.OR.K.EQ.7
     +  .OR.K.EQ.8)FC(2)=-1.
        IF(NC.NE.2)GOTO 91
        N=N+3+MN*2
        IF(NA.GT.LX)GOTO 90
        IF(INT(ABS(A(NA+3))).EQ.KH)GOTO 90
        IF(NB.GT.NA)GOTO 94
  90    CALL SXCF(IR,FC(1),FC(2),-4,L)
        CALL SXSO(NA,IR,L,LM,A)
        WRITE(LH,4)KR(1:NL)//' '//IR(2:L)//' ?'//KD
        GOTO 94
  91    N=N+3
        M=2
        NQ=INT(ABS(A(K+29)))
          DO 93 I=1,MN
          FC(M+1)=A(N)
          M=M+2
          FC(M)=AMIN1(9.99,A(N+1))
          IF(FC(M).LT.0.0005)FC(M)=-1.
          NI=MB(I)
          NJ=NI
          IF(NJ.GT.LX)NJ=INT(A(NJ+3))
          J=MOD(INT(ABS(A(NJ+6))),10)
          IF(INT(ABS(A(NJ+3))).NE.KH)J=0
          IF(J.EQ.1.OR.J.EQ.3.OR.J.EQ.4.OR.J.EQ.5.OR.J.EQ.7
     +    .OR.J.EQ.8)FC(M)=-1.
          IF(K.EQ.1.OR.K.EQ.3.OR.K.EQ.4.OR.K.EQ.5.OR.K.EQ.7
     +    .OR.K.EQ.8)FC(M)=-1.
          N=N+2
          IF(NC.NE.3)GOTO 93
          J=INT(ABS(A(NJ+29)))
          IF(NQ.EQ.J)GOTO 92
          IF(NQ*J.NE.0)GOTO 93
  92      J=L
          CALL SXCF(IR,FC(M-1),FC(M),-1,J)
          CALL SXSO(NI,IR,J,LM,A)
          CALL SXSO(NA,IR,J,LM,A)
          KQ=' '
          NK=0
          CALL SXAN(-NJ,KQ,NK,LM,A)
          WRITE(LH,4)KQ(1:NK)//' '//KR(1:NL)//' '//IR(2:J)//' ?'//KD
  93      CONTINUE
  94    MN=MN+1
        MB(MN)=NA
        IF(NC.GT.1)GOTO 89
        M=MIN0(M,16)
        WRITE(KX,14)IR(1:10),(ABS(FC(I)),I=1,M)
          DO 95 I=2,M,2
          IF(FC(I).GE.0.)GOTO 95
          L=7*I+13
          K=L-5
          IF(I.EQ.2)K=19
          KX(K:L)=' '
  95      CONTINUE
        WRITE(LI,4)KX(1:7*M+13)
        IF(MN.GT.8)GOTO 89
        NL=NL+14
        KR(NL-13:NL)=IR(1:14)
        GOTO 89
  96    IF(NC.GT.1)GOTO 86
        WRITE(LI,4)'              '//KR(1:NL-14)
        GOTO 86
  97    IF(NC.GT.1)WRITE(LH,4)KD
  98    CONTINUE
C
C .cif and .lst output of torsion angles
C
      NT=0
      NN=LJ+1
  99  NK=INT(A(NN)/64000.)
      IF(NK.EQ.0)GOTO 100
      NN=INT(AMOD(A(NN),64000.))+NN
      IF(NK.NE.52)GOTO 99
      NT=1
      GOTO 99
 100  IF(NT.EQ.0)GOTO 107
      IF(A(74).LT.0.5)GOTO 101
      WRITE(LH,4)'loop_'//KD
      KR(1:32)=' _geom_torsion_atom_site_label_1'
      WRITE(LH,4)KR(1:32)//KD
      KR(32:32)='2'
      WRITE(LH,4)KR(1:32)//KD
      KR(32:32)='3'
      WRITE(LH,4)KR(1:32)//KD
      KR(32:32)='4'
      WRITE(LH,4)KR(1:32)//KD
      WRITE(LH,4)KR(1:14)//KD
      KR(16:30)='site_symmetry_1'
      WRITE(LH,4)KR(1:30)//KD
      KR(30:30)='2'
      WRITE(LH,4)KR(1:30)//KD
      KR(30:30)='3'
      WRITE(LH,4)KR(1:30)//KD
      KR(30:30)='4'
      WRITE(LH,4)KR(1:30)//KD
      KR(16:24)='publ_flag'
      WRITE(LH,4)KR(1:24)//KD
 101  NT=0
      NN=LJ+1
 102  NK=INT(A(NN)/64000.)
      IF(NK.EQ.0)GOTO 106
      N=NN+1
      NN=INT(AMOD(A(NN),64000.))+NN
      IF(NK.NE.52)GOTO 102
      MB(2)=INT(A(N))
      MB(3)=INT(A(N+1))
      MB(4)=INT(A(N+2))
      IF(NT.EQ.0)WRITE(LI,15)
      NT=1
 103  N=N+3
      IF(N.GE.NN)GOTO 102
      MB(1)=MB(2)
      MB(2)=MB(3)
      MB(3)=MB(4)
      MB(4)=INT(A(N))
      S=AMIN1(99.99,A(N+2))
      IF(S.LT.0.001)S=-1.
      KR=' '
      NL=0
      IR=' '
      L=0
        DO 104 I=1,4
        NB=MB(I)
        IF(NB.GT.LX)NB=INT(A(NB+3))
        KQ=' '
        K=0
        CALL SXAN(-NB,KQ,K,LM,A)
        NL=NL+K+1
        KR(NL-K+1:NL)=KQ(1:NL)
        CALL SXAN(MB(I),IR,L,LM,A)
        L=L+3
        IR(L-2:L)=' - '
        IF(INT(ABS(A(NB+3))).NE.KH)GOTO 104
        NA=MOD(INT(ABS(A(NB+6))),10)
        IF(NA.EQ.1.OR.NA.EQ.3.OR.NA.EQ.4.OR.NA.EQ.5.OR.NA.EQ.7
     +  .OR.NA.EQ.8)S=-1.
 104    CONTINUE
      IF(S.GE.0.)WRITE(LI,16)A(N+1),'(',S,IR(1:L-3)
      IF(S.LT.0.)WRITE(LI,17)A(N+1),IR(1:L-3)
      IF(A(74).LT.0.5)GOTO 103
      KQ=KR(1:80)
      CALL SXCF(KQ,A(N+1),S,-1,NL)
        DO 105 I=1,4
        CALL SXSO(MB(I),KQ,NL,LM,A)
 105    CONTINUE
      WRITE(LH,4)KQ(2:NL)//' ?'//KD
      GOTO 103
C
C RTAB (residue) tables of derived parameters
C
 106  IF(A(74).GT.0.5)WRITE(LH,4)KD
 107  NT=1
 108  IF(NT.EQ.0)GOTO 125
      NT=0
      NN=LJ+1
 109  NK=INT(A(NN)/64000.)
      IF(NK.EQ.0)GOTO 108
      N=NN+1
      NN=INT(AMOD(A(NN),64000.))+NN
      IF(NK.NE.53)GOTO 109
      NI=NN-N
      CALL SXUS(A(N),KS)
      IF(KS.EQ.'1DHA'.OR.KS.EQ.'2DHA')GOTO 109
      IF(KS.EQ.'3DHA'.OR.KS.EQ.'4DHA')GOTO 109
      IF(NT.NE.0)GOTO 110
      NJ=NI
      KT=KS
      WRITE(LI,13)
      IF(NI.EQ.4)WRITE(LI,4)' Chiral volume '//KS
      IF(NI.EQ.5)WRITE(LI,4)' Distance '//KS
      IF(NI.EQ.6)WRITE(LI,4)' Angle '//KS
      IF(NI.EQ.7)WRITE(LI,4)' Dihedral angle '//KS
      WRITE(LI,4)
      NT=1
 110  IF(KS.NE.KT)GOTO 109
      IF(NI.NE.NJ)GOTO 109
      A(N-1)=AMOD(A(N-1),64000.)+3072000.
      KR=' '
      L=0
      I=N+3
      IF(NN.EQ.6)I=N+4
      IF(NI.EQ.7)I=N+5
      K=INT(A(I))
      IF(K.GT.LX)GOTO 112
      CALL SXUS(A(K+1),IR(6:9))
      IF(IR(6:6).EQ.'0')GOTO 112
      IR(5:5)='_'
      CALL SXUS(A(K+2),IR(1:4))
        DO 111 I=1,9
        IF(IR(I:I).EQ.' ')GOTO 111
        L=L+1
        IF(I.GT.1)CALL SXLC(IR(I:I))
        KR(L:L)=IR(I:I)
 111    CONTINUE
      L=L+2
 112    DO 113 I=N+3,NN-1
        K=INT(A(I))
        CALL SXAN(K,KR,L,LM,A)
        IF(K.GT.LX)K=INT(A(K+3))
        NA=MOD(INT(ABS(A(K+6))),10)
        IF(INT(ABS(A(K+3))).NE.KH)NA=0
        IF(NA.EQ.1.OR.NA.EQ.3.OR.NA.EQ.4.OR.NA.EQ.5.OR.NA.EQ.7
     +  .OR.NA.EQ.8)A(N+2)=-1.
        L=L+3
        KR(L-2:L)=' - '
 113    CONTINUE
      L=L-3
      IF(NI.NE.4)GOTO 121
      IF(K.GT.LX)GOTO 109
      MB(1)=K
      K=INT(A(K+4))
      IF(K.LE.0)GOTO 109
      IF(A(K+1).LT.0.5)GOTO 109
      IF(A(K+2).LT.0.5)GOTO 109
        DO 114 I=2,4
        K=K+1
        MB(I)=INT(ABS(A(K)))
 114    CONTINUE
      IF(A(K).GT.-0.5)GOTO 109
      NA=0
        DO 115 I=1,4
        NB=MB(I)
        IF(NB.GT.LX)NB=INT(A(NB+3))
        NA=MAX0(NA,INT(ABS(A(NB+29))))
 115    CONTINUE
        DO 116 I=1,4
        NB=MB(I)
        IF(NB.GT.LX)NB=INT(A(NB+3))
        NB=INT(ABS(A(NB+29)))
        IF(NB.EQ.0)GOTO 116
        IF(NB.NE.NA)GOTO 109
 116    CONTINUE
      CALL SXUS(A(MB(2)),KS)
      CALL SXUS(A(MB(3)),KY)
      CALL SXUS(A(MB(4)),KZ)
 117  IF(KY.GE.KS)GOTO 118
      I=MB(2)
      MB(2)=MB(3)
      MB(3)=I
      KW=KS
      KS=KY
      KY=KW
 118  IF(KZ.GE.KY)GOTO 119
      I=MB(3)
      MB(3)=MB(4)
      MB(4)=I
      KW=KY
      KY=KZ
      KZ=KW
      GOTO 117
 119  L=L+2
      KR(L-1:L)=' ['
        DO 120 I=2,4
        L=L+1
        KR(L:L)=' '
        CALL SXAN(MB(I),KR,L,LM,A)
 120    CONTINUE
      L=L+2
      KR(L-1:L)=' ]'
 121  T=A(N+1)
      IF(NI.NE.5)GOTO 123
      S=AMIN1(9.999,A(N+2))
      IF(S.LE.0.0001)GOTO 122
      WRITE(LI,23)IH(20),T,'(',S,KR(1:L)
      GOTO 109
 122  WRITE(LI,24)IH(20),T,KR(1:L)
      GOTO 109
 123  S=AMIN1(99.99,A(N+2))
      IF(S.LT.0.0005)GOTO 124
      WRITE(LI,16)T,'(',S,KR(1:L)
      GOTO 109
 124  WRITE(LI,17)T,KR(1:L)
      GOTO 109
C
C HTAB table for specified H-bonds
C
 125  NT=0
      NN=LJ+1
 126  NK=INT(A(NN)/64000.)
      IF(NK.EQ.0)GOTO 135
      N=NN+1
      NN=INT(AMOD(A(NN),64000.))+NN
      IF(NK.NE.53)GOTO 126
      CALL SXUS(A(N),KS)
      IF(KS.NE.'4DHA')GOTO 126
      MB(1)=INT(A(N+3))
      MB(2)=INT(A(N+4))
      MB(3)=INT(A(N+5))
      L=NN
 127  K=INT(A(L)/64000.)
      IF(K.EQ.0)GOTO 126
      NI=L+1
      L=L+INT(AMOD(A(L),64000.))
      IF(K.NE.53)GOTO 127
      CALL SXUS(A(NI),KS)
      IF(KS.NE.'1DHA')GOTO 127
      IF(INT(A(NI+3)).NE.MB(1))GOTO 127
      IF(INT(A(NI+4)).NE.MB(2))GOTO 127
      L=NN
 128  K=INT(A(L)/64000.)
      IF(K.EQ.0)GOTO 126
      NJ=L+1
      L=L+INT(AMOD(A(L),64000.))
      IF(K.NE.53)GOTO 128
      CALL SXUS(A(NJ),KS)
      IF(KS.NE.'2DHA')GOTO 128
      IF(INT(A(NJ+3)).NE.MB(2))GOTO 128
      IF(INT(A(NJ+4)).NE.MB(3))GOTO 128
      L=NN
 129  K=INT(A(L)/64000.)
      IF(K.EQ.0)GOTO 126
      NK=L+1
      L=L+INT(AMOD(A(L),64000.))
      IF(K.NE.53)GOTO 129
      CALL SXUS(A(NK),KS)
      IF(KS.NE.'3DHA')GOTO 129
      IF(INT(A(NK+3)).NE.MB(1))GOTO 129
      IF(INT(A(NK+4)).NE.MB(3))GOTO 129
      IF(NT.GT.0)GOTO 130
      NT=1
      WRITE(LI,18)
      IF(A(74).LT.0.5)GOTO 130
      WRITE(LH,4)'loop_'//KD
      KR=' _geom_hbond_atom_site_label_D'//KD
      WRITE(LH,4)KR(1:31)
      KR(30:30)='H'
      WRITE(LH,4)KR(1:31)
      KR(30:30)='A'
      WRITE(LH,4)KR(1:31)
      KR(14:25)='distance_DH'//KD
      WRITE(LH,4)KR(1:25)
      KR(23:24)='HA'
      WRITE(LH,4)KR(1:25)
      KR(23:24)='DA'
      WRITE(LH,4)KR(1:25)
      KR(14:23)='angle_DHA'//KD
      WRITE(LH,4)KR(1:23)
      KR(14:29)='site_symmetry_A'//KD
      WRITE(LH,4)KR(1:29)
 130  IF(A(N+1).GT.85.0.AND.A(NJ+1).LT.3.6.AND.A(NI+1).LT.1.6)GOTO 132
      KR=' '
      L=1
        DO 131 I=1,3,2
        CALL SXAN(MB(I),KR,L,LM,A)
        L=L+3
        KR(L-2:L)='...'
 131    CONTINUE
      KQ=KR(1:80)
      KQ(L-2:L)=' = '
      L=L-1
      CALL SXCF(KQ,A(NK+1),A(NK+2),-3,L)
      WRITE(LI,19)KQ(1:L)
      WRITE(*,19)KQ(1:L)
      GOTO 126
 132  KR=' '
      NL=0
      KX=' '
      L=54
        DO 133 I=1,3
        K=MB(I)
        IF(K.GT.LX)K=INT(A(K+3))
        CALL SXAN(-K,KR,NL,LM,A)
        NL=NL+1
        CALL SXAN(MB(I),KX,L,LM,A)
        L=L+1
        KX(L:L)='-'
        IF(I.NE.2)GOTO 133
        L=L+2
        KX(L-2:L)='...'
 133    CONTINUE
      A(NI+2)=AMIN1(99.99,A(NI+2))
      IF(A(NI+2).LT.0.001)A(NI+2)=-1.
      A(NJ+2)=AMIN1(99.99,A(NJ+2))
      IF(A(NJ+2).LT.0.001)A(NJ+2)=-1.
      A(NK+2)=AMIN1(99.99,A(NK+2))
      IF(A(NK+2).LT.0.0001)A(NK+2)=-1.
      A(N+2)=AMIN1(99.99,A(N+2))
      IF(A(N+2).LT.0.0005)A(N+2)=-1.
      K=MOD(INT(ABS(A(MB(2)+6))),10)
      IF(K.EQ.0.OR.K.EQ.2.OR.K.EQ.6.OR.K.EQ.9)GOTO 134
      A(NI+2)=-1.
      A(NJ+2)=-1.
      A(N+2)=-1.
 134  KQ=KR(1:80)
      K=NL
      CALL SXCF(KQ,A(NI+1),A(NI+2),-2,NL)
      KX(2:NL-K+1)=KQ(K+1:NL)
      K=NL
      CALL SXCF(KQ,A(NJ+1),A(NJ+2),-2,NL)
      KX(15:NL-K+14)=KQ(K+1:NL)
      K=NL
      CALL SXCF(KQ,A(NK+1),A(NK+2),-3,NL)
      KX(28:NL-K+27)=KQ(K+1:NL)
      K=NL
      CALL SXCF(KQ,A(N+1),A(N+2),-1,NL)
      KX(41:NL-K+40)=KQ(K+1:NL)
      WRITE(LI,4)KX(1:L-1)
      IF(A(74).LT.0.5)GOTO 126
      CALL SXSO(MB(3),KQ,NL,LM,A)
      WRITE(LH,4)KQ(1:NL)//KD
      GOTO 126
C
C Least-squares planes and deviations from them
C
 135  IF(NT.NE.0.AND.A(74).GT.0.5)WRITE(LH,4)KD
      VV=0.
        DO 136 I=2,4
        VV=AMAX1(VV,A(I+25)/A(I),.01745329*A(I+28))
 136    CONTINUE
      NT=0
      MF=0
      NN=LJ+1
 137  NK=INT(A(NN)/64000.)
      IF(NK.EQ.0)GOTO 152
      N=NN+2
      NN=INT(AMOD(A(NN),64000.))+NN
      IF(NK.NE.54)GOTO 137
      IF(A(N-1).LT.0.)GOTO 137
      IF(NT.EQ.0)WRITE(LI,20)
      MM=N
      NT=1
      R=1.
      IF(A(N+6).LT.0.)R=-1.
      KR=' -'
      L=1
      IF(R*A(N).LT.0.)L=2
        DO 145 I=1,4
        A(N)=A(N)*R
        KS='    '
        IF(I.NE.1)GOTO 138
        KS=' x +'
        GOTO 139
 138    IF(I.NE.2)GOTO 140
        KS=' y +'
 139    IF(R*A(N+2).LT.0.)KS(4:4)='-'
 140    IF(I.EQ.3)KS=' z ='
        T=ABS(A(N))
        IF(A(N+1).GE.0.)GOTO 141
        IR=' '
        WRITE(IR,23)IH(20),T,KS
        GOTO 142
 141    S=AMIN1(SQRT(A(N+1)**2+(VV*T)**2),9.999)
        WRITE(IR,23)IH(20),T,'(',S,KS
 142    M=1
          DO 144 K=1,27
          KR(L+1:L+1)=IR(K:K)
          IF(IR(K:K).NE.' ')GOTO 143
          L=L+M
          M=0
          GOTO 144
 143      M=1
          L=L+M
 144      CONTINUE
        N=N+2
 145    CONTINUE
      WRITE(LI,4)
      WRITE(LI,4)KR(1:L)
      WRITE(LI,4)
      IF(MF.EQ.0)GOTO 147
      U=A(MF)/A(94)
      V=(A(MF+2)-U*A(95))/A(97)
      W=(A(MF+4)-U*A(96)-V*A(98))/A(99)
      X=A(MM)/A(94)
      Y=(A(MM+2)-X*A(95))/A(97)
      Z=(A(MM+4)-X*A(96)-Y*A(98))/A(99)
      T=(V*Z-W*Y)**2+(W*X-U*Z)**2+(U*Y-V*X)**2
      P=ABS(AMOD(450.+ATAN2(SQRT(T),U*X+V*Y+W*Z)*57.29578,180.)-90.)
      IF(AMIN1(A(MM+1),A(MF+1)).GE.0.)GOTO 146
      WRITE(LI,22)P
      GOTO 147
 146  S=SQRT(4000.*(((U*A(MM+1))**2+(X*A(MF+1))**2)/A(94)**2+
     +((V*A(MM+3))**2+(Y*A(MF+3))**2)/A(97)**2+((W*A(MM+5))**2+
     +(Z*A(MF+5))**2)/A(99)**2)/(.2+T)+(VV*57.29578)**2)
      WRITE(LI,21)P,AMIN1(99.99,S)
 147  MF=MM
      U=0.
      V=0.
      M=21
      NL=N+3*INT(A(N-9))
 148  L=0
      K=INT(A(N))
      CALL SXAN(K,IR,L,LM,A)
      T=R*A(N+1)
      M=20
      IF(N.GE.NL)GOTO 149
      M=21
      U=U+T**2
      V=V+1.
 149  IF(A(N+2).LT.0.)GOTO 150
      WRITE(LI,23)IH(M),T,'(',AMIN1(9.999,SQRT(A(N+2)**2+
     +(VV*T)**2)),IR(1:L)
      GOTO 151
 150  WRITE(LI,23)IH(M),T,' '//IR(1:L)
 151  N=N+3
      IF(N.LT.NN)GOTO 148
      U=SQRT(U/V)
      WRITE(LI,25)U
      GOTO 137
 152  RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SX3M(LM,JW,LU,MH,MK,ML,MB,FF,SI,FC,SQ,WL,FB,A,B)
C
C Sort reflections for Fourier maps, write .fcf file
C
      CHARACTER*1 IH(50),KD,KK
      CHARACTER*2 KA(94)
      CHARACTER*4 KT
      CHARACTER*76 IT
      CHARACTER*80 NM,IR
      CHARACTER*128 KR
      INTEGER MH(LU),MK(LU),ML(LU),MB(LU)
      REAL FF(LU),SI(LU),FC(LU),SQ(LU),WL(LU),FB(LU),A(LM),B(JW),QW(6)
      COMMON/MEM/ST,SL,TC,TL,IV,LR,LG,LH,LI,LP,LF,LA,LC,LW,LY,LL,LB,
     +LX,LE,LV,LJ,LD,LS,LO,LT,LK,LQ,LZ,LN,KH,JA,JB,JC,JD,JE,HA,HD
      COMMON/WORD/IH,IT,IR,NM,KA,KD
C
   1  FORMAT(1X,A)
   2  FORMAT(//' FMAP and GRID set by program'//' FMAP',3I4/
     +' GRID',2(F10.3,2I4))
   3  FORMAT('#',A1/'# Unique observed reflections after correcting',
     +A1/'# for dispersion and merging Friedel opposites',A1/'#',A1)
   4  FORMAT('#',A1/'# h,k,l, Fc-squared, Fo-squared, sigma(Fo-',
     +'squared) and status flag',A1/'#',A1)
   5  FORMAT('#',A1/'# h,k,l, Fo-squared, sigma(Fo-squared), Fc ',
     +'and phi(calc)',A1/'#',A1)
   6  FORMAT('data_',A,A1/'_shelx_title ''',A,'''',A1/'_shelx_',
     +'refln_list_code',I11,A1/'_shelx_F_calc_maximum',F12.2,A1/
     +'_exptl_crystal_F_000',F13.2,A1/'_reflns_d_resolution_high',
     +F8.4,A1/A1/'loop_',A1/' _symmetry_equiv_pos_as_xyz',A1)
   7  FORMAT(A1/'_cell_length_a',F11.4,A1/'_cell_length_b',F11.4,
     +A1/'_cell_length_c',F11.4,A1/'_cell_angle_alpha',F8.3,A1/
     +'_cell_angle_beta',F9.3,A1/'_cell_angle_gamma',F8.3,A1/A1)
   8  FORMAT('_shelx_F_squared_multiplier',F10.3,A1/A1)
   9  FORMAT('loop_',A1/' _refln_index_h',A1/' _refln_index_k',A1/
     +' _refln_index_l',A1)
  10  FORMAT(' _refln_F_squared_meas',A1/' _refln_F_squared_sigma',
     +A1/' _refln_F_calc',A1/' _refln_phase_calc',A1)
  11  FORMAT(' _refln_F_squared_calc',A1/' _refln_F_squared_meas',
     +A1/' _refln_F_squared_sigma',A1/' _refln_observed_status',A1)
  12  FORMAT(' _refln_F_meas',A1/' _refln_F_sigma',A1)
  13  FORMAT(' _refln_A_calc',A1/' _refln_B_calc',A1)
  14  FORMAT(3I4,2F12.2,F10.2,1X,2A1)
  15  FORMAT(3I4,4F12.4,A1)
  16  FORMAT('index$',3(I4,'$'),'fobs$',F12.2,'$fcalc$',F12.2,'$',
     +F8.1,A)
  17  FORMAT(3I4,2F10.2,F7.2,A1)
  18  FORMAT(3I4,2F8.2,I4,A1)
  19  FORMAT(3I4,2F8.0,I4,A1)
  20  FORMAT(3(I5,'$'),3(F14.2,'$'),F7.1,A1)
  21  FORMAT(' R1 =',F8.4,' for',I7,' unique reflections after ',
     +'merging for Fourier')
  22  FORMAT(A,A3,'  1 ',3F8.4,F10.5,'  0.05',F8.2,A)
  23  FORMAT('_diffrn_reflns_theta_full',11X,F8.2,A1)
  24  FORMAT('_diffrn_measured_fraction_theta_',A4,F8.3,A1)
C
      IF(A(80).GT.-998.)CALL SXHT(LM,LU,A,MB,MH,MK,ML,FF,SI,SQ,FB,FC)
      CALL SXTO(17)
C
C Find asymmetric unit of Fourier
C
      MM=LY+12
      NZ=INT(ABS(A(54)))
      IF(ABS(A(57)).LT.0.5)NZ=0
      IF(NZ.EQ.0)GOTO 48
      IF(ABS(A(55)).GT.0.5)GOTO 48
      XJ=A(2)
      YJ=A(3)
      ZJ=A(4)
      IX=0
      IY=0
      IZ=0
        DO 26 I=1,3
        NJ=I+30
          DO 25 K=I,NJ,6
          FF(K)=9.E9
          FF(K+3)=1.
  25      CONTINUE
  26    CONTINUE
        DO 36 L=MM,LL,4
          DO 35 N=201,LY,12
          X=AMOD(A(N+9)*A(L)+A(L+1)+.501,1.)-.001
          Y=AMOD(A(N+10)*A(L)+A(L+2)+.501,1.)-.001
          Z=AMOD(A(N+11)*A(L)+A(L+3)+.501,1.)-.001
          IX=9
          IF(AMAX1(ABS(A(N+1)),ABS(A(N+2))).GT.0.01)GOTO 27
          IX=1
          IF(ABS(X).GT.0.01)GOTO 27
          IF(A(N)*A(L).LT.0.5)GOTO 27
          IX=0
  27      IY=9
          IF(AMAX1(ABS(A(N+3)),ABS(A(N+5))).GT.0.01)GOTO 28
          IY=1
          IF(ABS(Y).GT.0.01)GOTO 28
          IF(A(N+4)*A(L).LT.0.5)GOTO 28
          IY=0
  28      IZ=9
          IF(AMAX1(ABS(A(N+6)),ABS(A(N+7))).GT.0.01)GOTO 31
          IZ=1
          IF(ABS(Z).GT.0.01)GOTO 29
          IF(A(N+8)*A(L).LT.0.5)GOTO 29
          IZ=0
  29      IF(A(N+8)*A(L).LT.0.)GOTO 30
          IF(IZ.EQ.0)GOTO 31
          IF(IX+IY.LT.1)FF(6)=AMIN1(FF(6),Z)
          IF(IX.LT.1)FF(12)=AMIN1(FF(12),Z)
          IF(IY.LT.1)FF(18)=AMIN1(FF(18),Z)
          IF(FF(30).GT.Z)FF(30)=Z
          GOTO 31
  30      IF(IX+IY.LT.1)FF(3)=AMIN1(FF(3),Z)
          IF(IX.LT.1)FF(9)=AMIN1(FF(9),Z)
          IF(IY.LT.1)FF(15)=AMIN1(FF(15),Z)
          IF(FF(27).GT.Z)FF(27)=Z
  31      IF(IY.GT.1)GOTO 33
          IF(A(N+4)*A(L).LT.0.)GOTO 32
          IF(IY.EQ.0)GOTO 33
          IF(IX+IZ.LT.1)FF(11)=AMIN1(FF(11),Y)
          IF(IX.LT.1)FF(5)=AMIN1(FF(5),Y)
          IF(IZ.LT.1)FF(35)=AMIN1(FF(35),Y)
          IF(FF(17).GT.Y)FF(17)=Y
          GOTO 33
  32      IF(IX+IZ.LT.1)FF(8)=AMIN1(FF(8),Y)
          IF(IX.LT.1)FF(2)=AMIN1(FF(2),Y)
          IF(IZ.LT.1)FF(32)=AMIN1(FF(32),Y)
          IF(FF(14).GT.Y)FF(14)=Y
  33      IF(IX.GT.1)GOTO 35
          IF(A(N)*A(L).LT.0.)GOTO 34
          IF(IX.EQ.0)GOTO 35
          IF(IY+IZ.LT.1)FF(16)=AMIN1(FF(16),X)
          IF(IY.LT.1)FF(22)=AMIN1(FF(22),X)
          IF(IZ.LT.1)FF(28)=AMIN1(FF(28),X)
          IF(FF(4).GT.X)FF(4)=X
          GOTO 35
  34      IF(IY+IZ.LT.1)FF(13)=AMIN1(FF(13),X)
          IF(IY.LT.1)FF(19)=AMIN1(FF(19),X)
          IF(IZ.LT.1)FF(25)=AMIN1(FF(25),X)
          IF(FF(1).GT.X)FF(1)=X
  35      CONTINUE
  36    CONTINUE
        DO 37 I=1,27,13
        FF(I+6)=FF(I)
        FF(I+9)=FF(I+3)
  37    CONTINUE
        DO 38 I=3,13,5
        FF(I+18)=FF(I)
        FF(I+21)=FF(I+3)
  38    CONTINUE
        DO 40 I=1,31,6
        J=I+2
          DO 39 K=I,J
          FF(K)=.5*FF(K)
          IF(FF(K).LT.1.)FF(K+3)=.5*FF(K+3)
          IF(FF(K).GT.1.)FF(K)=0.
  39      CONTINUE
  40    CONTINUE
C
C Set up FMAP and GRID
C
      RE=16.*AMIN1(SIN(1.74533E-2*A(5)),SIN(1.74533E-2*A(6)),
     +SIN(1.74533E-2*A(7)))**2*A(1)/SQRT(A(88))
      RR=1.
  41  U=9.E9
        DO 46 M=1,31,6
          DO 45 N=1,3
          K=1
          IF(.501.GT.FF(M+5)*RR)GOTO 42
          K=2
  42      J=1
          IF(.501.GT.FF(M+4)*RR)GOTO 43
          J=2
  43      V=REAL(J*K)*FF(M+3)
          IF(V.GT.U)GOTO 44
          IF(U.GT.V+.01)W=9.E9
          U=V+.001
          X=YJ*REAL(J)-RE
          Y=ZJ*REAL(K)-RE
          Z=X**2+Y**2
          IF(Z.GT.W)GOTO 44
          W=Z
          ER=AMAX1(X,0.)+AMAX1(Y,0.)
          A(55)=REAL(N)
          IX=INT(100.01*FF(M+1))-J
          IY=INT(100.01*FF(M+2))-K
          IZ=J
          KP=K
          A(56)=RR*AINT(4.5+100.*FF(M+3)*XJ/RE)
          A(36)=FF(M+3)*100./(ABS(A(56))-3.)
          A(33)=100.*FF(M)-A(36)
  44      X=XJ
          XJ=YJ
          YJ=ZJ
          ZJ=X
          X=FF(M)
          FF(M)=FF(M+1)
          FF(M+1)=FF(M+2)
          FF(M+2)=X
          X=FF(M+3)
          FF(M+3)=FF(M+4)
          FF(M+4)=FF(M+5)
          FF(M+5)=X
  45      CONTINUE
  46    CONTINUE
      IF(RR.LT.0.)GOTO 47
      IF(IZ+KP.LT.3)GOTO 47
      IF(ER.LT.RE)GOTO 47
      RR=-1.
      GOTO 41
  47  L=INT(A(54))
      M=INT(A(55))
      K=INT(A(56))
      WRITE(LI,2)L,M,K,A(33),IX,IY,A(36),IZ,KP
      A(34)=IX
      A(35)=IY
      A(37)=IZ
      A(38)=KP
C
C Initiate .fcf file
C
  48  MU=INT(ABS(A(73))+.1)
      IF(MU.EQ.3)GOTO 49
      IF(IABS(MU-5).NE.1)GOTO 56
  49  Q=SQRT(A(134))
      K=1
      L=1
        DO 51 I=1,76
        IF(IT(I:I).EQ.IH(20))GOTO 50
        L=I
        GOTO 51
  50    IF(L.EQ.0)K=I+1
  51    CONTINUE
      IF(L.EQ.1)K=1
      IF(MU.EQ.3)WRITE(LZ,3)KD,KD,KD,KD
      IF(MU.EQ.4)WRITE(LZ,4)KD,KD,KD
      IF(MU.EQ.6)WRITE(LZ,5)KD,KD,KD
      WRITE(LZ,6)NM(1:LN),KD,IT(K:L),KD,MU,KD,Q,KD,A(22),KD,
     +.5*A(1)/SQRT(A(88)),KD,KD,KD,KD
      KR=''''
        DO 53 M=LY+12,LL,4
          DO 52 N=201,LY,12
          L=1
          CALL SXOP(KR,A(N),A(M),L)
          WRITE(LZ,1)KR(1:L)//''''//KD
  52      CONTINUE
  53    CONTINUE
      WRITE(LZ,7)KD,A(2),KD,A(3),KD,A(4),KD,A(5),KD,A(6),KD,A(7),
     +KD,KD
      IF(MU.EQ.4)WRITE(LZ,8)A(155),KD,KD
      WRITE(LZ,9)KD,KD,KD,KD
      IF(MU.EQ.3)GOTO 55
      IF(MU.EQ.6)GOTO 54
      WRITE(LZ,11)KD,KD,KD,KD
      GOTO 56
  54  WRITE(LZ,10)KD,KD,KD,KD
      GOTO 56
  55  WRITE(LZ,12)KD,KD
      WRITE(LZ,13)KD,KD
C
C Index ranges for sort/merge
C
  56  CALL SXZA(A(136),6)
      CALL SXZA(A(LS+1),33)
  57  READ(LA)MH,MK,ML,FF,SI,SQ,WL,FB,FC
      CALL SXCC
      MZ=MH(LU)
      IF(MZ.EQ.0)GOTO 71
      MN=MK(LU)
        DO 63 I=1,MZ
        FF(I)=FF(I)/A(75)
        SI(I)=-SI(I)/A(75)
        IF(I.GT.MN)GOTO 63
        SI(I)=ABS(SI(I))
        X=REAL(MH(I))
        Y=REAL(MK(I))
        Z=REAL(ML(I))
        P=0.
        Q=0.
        R=0.
          DO 61 K=201,LY,12
          U=A(K)*X+A(K+3)*Y+A(K+6)*Z
          V=A(K+1)*X+A(K+4)*Y+A(K+7)*Z
          W=A(K+2)*X+A(K+5)*Y+A(K+8)*Z
          IF(W.GT.0.5)GOTO 59
          IF(W.LT.-0.5)GOTO 58
          IF(V.GT.0.5)GOTO 59
          IF(V.LT.-0.5)GOTO 58
          IF(U.GT.0.5)GOTO 59
  58      U=-U
          V=-V
          W=-W
  59      IF(R.LT.W-.5)GOTO 60
          IF(W.LT.R-.5)GOTO 61
          IF(Q.LT.V-.5)GOTO 60
          IF(V.LT.Q-.5)GOTO 61
          IF(P.GT.U-.5)GOTO 61
  60      R=W
          Q=V
          P=U
  61      CONTINUE
        IF(A(136).GT.P)A(136)=P
        IF(A(137).LT.P)A(137)=P
        IF(A(138).GT.Q)A(138)=Q
        IF(A(139).LT.Q)A(139)=Q
        IF(A(140).GT.R)A(140)=R
        IF(A(141).LT.R)A(141)=R
C
C E-value normalization curve (for Sim weights)
C
        IF(NZ.LT.5)GOTO 63
        T=1.
          DO 62 K=213,LY,12
          U=A(K)*P+A(K+3)*Q+A(K+6)*R
          V=A(K+1)*P+A(K+4)*Q+A(K+7)*R
          W=A(K+2)*P+A(K+5)*Q+A(K+8)*R
          IF(ABS(U-P)+ABS(V-Q)+ABS(W-R).LT.0.5)T=T+1.
          IF(A(23).GT.0.5)GOTO 62
          IF(ABS(U+P)+ABS(V+Q)+ABS(W+R).LT.0.5)T=T+1.
  62      CONTINUE
        V=(WL(I)**2+FB(I)**2)/T
        T=V*FF(I)/AMAX1(0.0001,FC(I))
        Q=A(144)*ABS(SQ(I))+1.0001
        K=MIN0(INT(Q),10)
        Q=Q-REAL(K)
        P=1.-Q
        K=K+LS
        A(K)=A(K)+P*T
        A(K+1)=A(K+1)+Q*T
        A(K+11)=A(K+11)+P
        A(K+12)=A(K+12)+Q
        A(K+22)=A(K+22)+P*V
        A(K+23)=A(K+23)+Q*V
  63    CONTINUE
C
C 'Comb' sort LIST 4 output then write it to .fcf
C
      IF(MU.NE.4)GOTO 70
      IF(ABS(A(46)).LT.0.5)GOTO 67
      K=MZ
  64  M=0
      K=INT(REAL(K)/1.3)
      IF(K.LT.1)K=1
      IF(K.EQ.9)K=11
      IF(K.EQ.10)K=11
        DO 66 I=1,MZ-K
        NJ=I+K
        IF(ML(NJ).GT.ML(I))GOTO 66
        IF(ML(NJ).LT.ML(I))GOTO 65
        IF(MK(NJ).GT.MK(I))GOTO 66
        IF(MK(NJ).LT.MK(I))GOTO 65
        IF(MH(NJ).GE.MH(I))GOTO 66
  65    M=M+1
        L=MH(NJ)
        MH(NJ)=MH(I)
        MH(I)=L
        L=MK(NJ)
        MK(NJ)=MK(I)
        MK(I)=L
        L=ML(NJ)
        ML(NJ)=ML(I)
        ML(I)=L
        T=FF(NJ)
        FF(NJ)=FF(I)
        FF(I)=T
        T=SI(NJ)
        SI(NJ)=SI(I)
        SI(I)=T
        T=FC(NJ)
        FC(NJ)=FC(I)
        FC(I)=T
  66    CONTINUE
      IF(M+K.GT.1)GOTO 64
  67    DO 69 I=1,MZ
        KK='o'
        IF(SI(I).GT.0.)GOTO 68
        KK='x'
        IF(FF(I).LT.A(52)*ABS(SI(I)))KK='<'
  68    SI(I)=ABS(SI(I))
        U=A(155)*FC(I)
        V=A(155)*FF(I)
        W=A(155)*SI(I)
        WRITE(LZ,14)MH(I),MK(I),ML(I),U,V,W,KK,KD
  69    CONTINUE
  70  IF(ML(LU).GT.0)GOTO 57
  71  REWIND LA
      IF(MU+NZ.EQ.0)GOTO 132
      MA=MAX0(MIN0(INT(ABS(A(55))),3),1)
C
C Get crystal coordinates of map center
C
      P=26.
      IF(A(56).LT.0.)P=51.
      XS=.01*P*A(38)
      U=.01*A(35)+XS
      YS=.01*P*A(37)
      V=.01*A(34)+YS
      Q=AINT(ABS(A(56)))-1.
      ZS=.005*Q*A(36)
      W=.01*A(33)+ZS
      Q=.5*Q+1.5
      IF(A(55).LT.0.)GOTO 72
      T=U
      U=V
      V=T
      T=XS
      XS=YS
      YS=T
  72    DO 73 NK=1,MA
        T=W
        W=V
        V=U
        U=T
        T=ZS
        ZS=YS
        YS=XS
        XS=T
  73    CONTINUE
C
C Shuffle up atom list, set special position flag and find nearest
C pixels to atoms
C
      A(103)=-9.E9
      A(188)=-9.E9
      A(193)=0.
      A(194)=9.E9
      A(199)=0.
      KC=0
        DO 74 I=LL+4,LB,16
        CALL SXUS(A(I+13),KT)
        IF(KT.EQ.'C   ')KC=I
  74    CONTINUE
      NG=-2
      MZ=LE+39
      NR=(LX-LB+16)/32
      M=LB-16
      N=LB+7
  75  M=M+32
      IF(M.GT.LX)GOTO 81
      TQ=9.E9
      NG=NG+3
      MZ=MZ+1
      B(NG)=0.
      NX=INT(A(MZ))
        DO 80 L=201,LY,12
        XA=A(M+17)*A(L)+A(M+18)*A(L+1)+A(M+19)*A(L+2)+A(L+9)
        YA=A(M+17)*A(L+3)+A(M+18)*A(L+4)+A(M+19)*A(L+5)+A(L+10)
        ZA=A(M+17)*A(L+6)+A(M+18)*A(L+7)+A(M+19)*A(L+8)+A(L+11)
          DO 79 K=MM,LL,4
          IF(K+L.EQ.MM+201)GOTO 76
          R=AMOD(A(K)*XA+A(K+1)-A(M+17),1.)-.5
          S=AMOD(A(K)*YA+A(K+2)-A(M+18),1.)-.5
          T=AMOD(A(K)*ZA+A(K+3)-A(M+19),1.)-.5
          TQ=AMIN1(TQ,A(8)*R**2+A(9)*S**2+A(10)*T**2+S*T*A(11)+
     +    R*T*A(12)+R*S*A(13))
  76      IF(NX.EQ.0)GOTO 79
          R=AMOD(A(K)*XA+A(K+1)-U,1.)-.5
          IF(ABS(R).GT.XS+.0001)GOTO 79
          S=AMOD(A(K)*YA+A(K+2)-V,1.)-.5
          IF(ABS(S).GT.YS+.0001)GOTO 79
          T=AMOD(A(K)*ZA+A(K+3)-W,1.)-.5
          IF(ABS(T).GT.ZS+.0001)GOTO 79
            DO 77 MP=1,MA
            RA=R
            R=S
            S=T
            T=RA
  77        CONTINUE
          IF(A(55).LT.0.)GOTO 78
          RA=R
          R=S
          S=RA
  78      B(NG)=REAL(7*((NX-LE-NR)/5)+3*NR)-54.9
          B(NG+1)=Q-100.*T/A(36)
          T=AINT(P+.5+100.*R/A(38))
          B(NG+2)=0.5+P+100.*S/A(37)+(2.*P+1.)*T
          NX=0
  79      CONTINUE
  80    CONTINUE
      N=N+9
      CALL SXUS(A(M),KT)
      CALL SXPS(A(N),KT)
      CALL SXUS(A(M+1),KT)
      CALL SXPS(A(N+1),KT)
      K=INT(ABS(A(M+3)))
      A(N+2)=A(M+17)
      A(N+3)=A(M+18)
      A(N+4)=A(M+19)
      A(N+5)=A(M+20)
      A(N+6)=0.
      A(N+7)=100.*AMIN1(99.,AINT(AMOD(.1+100.*ABS(A(M+31)),100.)))+
     +A(K+2)
      IF(KC.EQ.K)A(N+7)=-A(N+7)
      A(N+8)=0.
      IF(A(57).LT.0.)GOTO 75
      IF(ABS(A(M+29)).GT.0.5)GOTO 75
      IF(TQ.GT.0.1)GOTO 75
      IF(A(M+20).LT.0.6)A(N+8)=.5
      GOTO 75
C
C Move residue diagnostics table
C
  81  MZ=MZ-9
      NR=NG-11
  82  MZ=MZ+10
      IF(INT(A(MZ)).EQ.0)GOTO 84
        DO 83 I=MZ,MZ+9
        B(NR+14)=A(I)
        NR=NR+1
  83    CONTINUE
      NR=NR+4
      CALL SXUS(A(MZ+1),KT)
      CALL SXPS(B(NR+1),KT)
      T=AMAX1(0.0001,B(NR+2))
      B(NR+4)=B(NR+4)/T
      B(NR+6)=B(NR+6)/T
      B(NR+10)=999.
      B(NR+11)=0.
      B(NR+12)=0.
      B(NR+13)=0.
      GOTO 82
C
C Prepare space for peaklist and lookup table
C
  84  LX=N
      LD=LX
      MP=LX+9*INT(ABS(A(57)))
      MZ=MAX0(MP+18,LS+34)
      IF(MZ+5142.GT.LM)CALL SXER('ARRAY A TOO SMALL FOR PEAKLIST')
      P=AMAX1(ABS(A(136)),ABS(A(137)))
      Q=AMAX1(ABS(A(138)),ABS(A(139)))
      R=AMAX1(ABS(A(140)),ABS(A(141)))
        DO 85 I=1,MA
        T=P
        P=Q
        Q=R
        R=T
  85    CONTINUE
      IF(A(55).LT.0.)GOTO 87
      T=P
      P=Q
      Q=T
      GOTO 87
  86  P=P-1.
      Q=Q-1.
  87  QA=ABS(Q+Q)+1.
      QQ=ABS(Q)+.1
      L=INT(ABS(P)*QA+QQ+1.)
      LO=L+MZ
      IF(LO.GT.LM)GOTO 86
      QP=ABS(P)+.1
        DO 88 I=MZ,LO
        A(I)=-2.
  88    CONTINUE
      REWIND LC
C
C Initialize sort/merge
C
        DO 89 I=1,6
        QW(I)=-0.5*A(1)**2*A(I+13)*A(I+114)
  89    CONTINUE
      SM=SQRT(A(155))
      SG=SIN(.0087266463*A(74))**2+1.E-6
      LG=0
      JF=0
      JQ=0
      RA=0.
      RB=1.E-6
      QH=A(137)-A(136)+1.
      QK=A(139)-A(138)+1.
      QL=.3+REAL(NR+13)
      QC=QL+.8-A(136)-QH*(A(138)+QK*A(140))
      IF(NZ.LT.5)GOTO 93
        DO 90 J=14,19
        A(J)=-0.5*A(J)*A(J+101)
  90    CONTINUE
        DO 92 J=LS+1,LS+11
        A(J)=A(J+11)/AMAX1(A(J),1.E-8)
        Q=REAL(LS+1-J)/A(144)
        P=0.
        T=0.
          DO 91 K=LL+4,LB,16
          S=(A(K+3)*EXP(Q*A(K+4))+A(K+5)*EXP(Q*A(K+6))+A(K+7)*
     +    EXP(Q*A(K+8))+A(K+9)*EXP(Q*A(K+10))+A(K+11))**2
          P=P+A(K+15)*S
          T=T+A(K+14)*S
  91      CONTINUE
        A(J+11)=A(J+11)/AMAX1(A(J+22),1.E-8)
        A(J+22)=P*A(J+11)/(AMAX1(P,T)*AMAX1(A(J),1.E-8))
  92    CONTINUE
C
C Sort/merge Fo and Fc after eliminating dispersion
C
  93  QM=REAL(JW)+.3
      NT=0
      JB=INT(AMIN1(QC+A(137)+QH*(A(139)+QK*A(141)),QM))
      NF=0
      JA=NR+14
  94    DO 95 J=JA,JB
        B(J)=0.
  95    CONTINUE
  96  READ(LA)MH,MK,ML,FF,SI,SQ,WL,FB,FC
      IF(MK(LU).EQ.0)GOTO 99
      CALL SXCC
      I=0
      GOTO 98
  97  NT=-1
  98  I=I+1
      IF(I.LE.MK(LU))GOTO 100
  99  IF(ML(LU).GT.0)GOTO 96
      GOTO 106
 100  IF(FC(I).LT.1.E-8)GOTO 98
      X=REAL(MH(I))
      Y=REAL(MK(I))
      Z=REAL(ML(I))
      FF(I)=FF(I)/A(75)
      SI(I)=SI(I)/A(75)
      P=0.
      Q=0.
      R=0.
      T=0.
        DO 104 K=201,LY,12
        U=A(K)*X+A(K+3)*Y+A(K+6)*Z
        V=A(K+1)*X+A(K+4)*Y+A(K+7)*Z
        W=A(K+2)*X+A(K+5)*Y+A(K+8)*Z
        T=1.
        IF(W.GT.0.5)GOTO 102
        IF(W.LT.-0.5)GOTO 101
        IF(V.GT.0.5)GOTO 102
        IF(V.LT.-0.5)GOTO 101
        IF(U.GT.0.5)GOTO 102
 101    U=-U
        V=-V
        W=-W
        T=-1.
 102    IF(R.LT.W-.5)GOTO 103
        IF(W.LT.R-.5)GOTO 104
        IF(Q.LT.V-.5)GOTO 103
        IF(V.LT.Q-.5)GOTO 104
        IF(P.GT.U-.5)GOTO 104
 103    R=W
        Q=V
        P=U
        M=K
        S=T
 104    CONTINUE
      T=QC+QH*(Q+QK*R)+P
      IF(T.LT.QL)GOTO 98
      IF(T.GT.QM)GOTO 97
      J=INT(T)
      IF(NF.GT.0)GOTO 105
      B(J)=1.
      GOTO 98
 105  JD=INT(B(J))
      B(JD)=P
      B(JD+1)=Q
      B(JD+2)=R
      P=6.2831853*(A(M+9)*X+A(M+10)*Y+A(M+11)*Z)
      Q=SIN(P)
      P=COS(P)
      W=AMAX1(FF(I)/SI(I),3.)/SI(I)
      B(JD+3)=B(JD+3)+FF(I)*W*(WL(I)**2+FB(I)**2)/FC(I)
      B(JD+4)=B(JD+4)+W
      B(JD+5)=B(JD+5)+1./SI(I)**2
      B(JD+6)=WL(I)*P+FB(I)*Q
      B(JD+7)=S*(FB(I)*P-WL(I)*Q)
      GOTO 98
 106  REWIND LA
      IF(NF.GT.0)GOTO 110
      NF=1
      Q=.3
      JD=JA
        DO 107 J=JA,JB
        IF(B(J).LT.0.5)GOTO 107
        B(J)=Q
        Q=Q+8.
        IF(J+INT(Q).GT.JW)GOTO 108
        JD=J
 107    CONTINUE
      NT=NT+1
      Q=Q+8.
 108  QM=REAL(JD)+1.
        DO 109 J=JA,JB
        B(J)=B(J)+QM
 109    CONTINUE
      JA=JD+1
      QM=QM-.7
      JB=JD+INT(Q-8.)
      GOTO 94
 110  J=JA-8
      IF(JF.EQ.0)GOTO 111
      READ(LC)MK,ML,FF,SI
      REWIND LC
 111  J=J+8
      IF(J.GT.JB)GOTO 130
      JF=JF+1
      X=B(J)
      Y=B(J+1)
      Z=B(J+2)
      IF(X**2*QW(1)+Y**2*QW(2)+Z**2*QW(3)+Y*Z*QW(4)+
     +X*Z*QW(5)+X*Y*QW(6).LT.SG)JQ=JQ+1
      U=SQRT(AMAX1(0.,B(J+3)/B(J+4)))
      W=1./SQRT(B(J+5))
C
C Phased reflection lists
C
      IF(MU.EQ.7)GOTO 119
      IF(IABS(MU-2).EQ.2)GOTO 119
      MB(1)=INT(1.0001*X)
      MB(2)=INT(1.0001*Y)
      MB(3)=INT(1.0001*Z)
      T=U*SM
      P=B(J+6)*SM
      Q=B(J+7)*SM
      R=SQRT(P**2+Q**2)
      V=AMOD(ATAN2(Q,P)*57.29578+720.003,360.)
      IF(MU.NE.1)GOTO 112
      WRITE(IR,16)MB(1),MB(2),MB(3),T,R,V,KD
      N=67
      GOTO 114
 112  IF(MU.NE.5)GOTO 113
      WRITE(LZ,17)MB(1),MB(2),MB(3),T,R,V,KD
      GOTO 119
 113  IF(MU.NE.6)GOTO 116
      WRITE(IR,20)MB(1),MB(2),MB(3),T**2,W,R,V,KD
      N=79
 114  K=0
        DO 115 I=1,N
        IF(IR(I:I).EQ.' ')GOTO 115
        K=K+1
        IR(K:K)=IR(I:I)
        IF(IR(I:I).EQ.'$')IR(K:K)=' '
 115    CONTINUE
      WRITE(LZ,22)IR(1:K)
      GOTO 119
 116  S=0.7071068*SM*AMIN1(SQRT(W),W/AMAX1(U,0.0001))
      IF(MU.NE.2)GOTO 118
      N=INT(V)
      IF(T.GT.9999.99)GOTO 117
      WRITE(LZ,18)MB(1),MB(2),MB(3),T,S,N,KD
      GOTO 119
 117  WRITE(LZ,19)MB(1),MB(2),MB(3),T,S,N,KD
      GOTO 119
 118  WRITE(LZ,15)MB(1),MB(2),MB(3),T,S,P,Q,KD
 119  T=B(J+6)**2+B(J+7)**2
      S=SQRT(T)
      RA=RA+ABS(U-S)
      RB=RB+U
      IF(NZ.EQ.0)GOTO 111
C
C Sim weights
C
      IF(NZ.LT.5)GOTO 123
      M=0
      P=1.
        DO 120 K=213,LY,12
        XX=A(K)*X+A(K+3)*Y+A(K+6)*Z
        YY=A(K+1)*X+A(K+4)*Y+A(K+7)*Z
        ZZ=A(K+2)*X+A(K+5)*Y+A(K+8)*Z
        IF(ABS(XX-X)+ABS(YY-Y)+ABS(ZZ-Z).LT.0.5)P=P+1.
        IF(ABS(XX+X)+ABS(YY+Y)+ABS(ZZ+Z).GT.0.5)GOTO 120
        IF(A(23).LT.0.5)P=P+1.
        M=1
 120    CONTINUE
      IF(A(23).LT.0.5)M=1
      Q=A(144)*(A(14)*X**2+A(15)*Y**2+A(16)*Z**2+A(17)*Y*Z+
     +A(18)*X*Z+A(19)*X*Y)+1.0001
      K=MIN0(INT(Q),10)
      Q=Q-REAL(K)
      K=K+LS
      R=1.-Q
      P=2.*U*S*SQRT((R*A(K)+Q*A(K+1))*(R*A(K+11)+Q*A(K+12)))/P
      IF(M.EQ.0)GOTO 121
      H=1.
      IF(P.GT.12.)GOTO 122
      H=EXP(P)
      H=(H-1.)/(H+1.)
      GOTO 122
 121  H=AMIN1(P*(.5658+P*(P*.0106-.1304)),P/(.56+P))
 122  V=H*U-S*SQRT(R*A(K+22)+Q*A(K+23))
      IF(NZ.LT.6)GOTO 124
      V=V*SQRT(SQRT((R*A(K)+Q*A(K+1))/A(LS+4)))
      GOTO 124
C
C Expand, transform and save reflections for Fourier
C
 123  V=U
      IF(NZ.NE.3)V=V-S
      IF(NZ.EQ.4)V=V+U
 124  V=V*S*T/(T**2+4.*W**2)
      U=V*B(J+6)
      V=V*B(J+7)
      N=LG
        DO 129 K=201,LY,12
        P=X*A(K)+Y*A(K+3)+Z*A(K+6)
        Q=X*A(K+1)+Y*A(K+4)+Z*A(K+7)
        R=X*A(K+2)+Y*A(K+5)+Z*A(K+8)
        MB(1)=INT(1.0001*P)
        MB(2)=INT(1.0001*Q)
        MB(3)=INT(1.0001*R)
          DO 125 I=1,MA
          T=P
          P=Q
          Q=R
          R=T
 125      CONTINUE
        IF(A(55).LT.0.)GOTO 126
        T=P
        P=Q
        Q=T
 126    IF(ABS(P).GT.QP)GOTO 129
        IF(ABS(Q).GT.QQ)GOTO 129
        T=P*QA+Q
        S=SIGN(1.0001,T+0.1)
        M=INT(ABS(T)+0.1)+MZ
        A(M)=1.1
        L=LG+1
        MK(L)=M
        ML(L)=INT(R*S)
        I=N
 127    I=I+1
        IF(I.GT.LU)I=1
        IF(I.EQ.L)GOTO 128
        IF(M.NE.MK(I))GOTO 127
        IF(ML(L).EQ.ML(I))GOTO 129
        GOTO 127
 128    T=6.283185*(X*A(K+9)+Y*A(K+10)+Z*A(K+11))
        P=COS(T)
        Q=SIN(T)
        FF(L)=U*P+V*Q
        SI(L)=AINT(S)*(V*P-U*Q)
        LG=L
        IF(LG.LT.LU)GOTO 129
        WRITE(LF)MK,ML,FF,SI
        CALL SXCC
        LG=0
 129    CONTINUE
      GOTO 111
C
C Reiterate if necessary and print R-index
C
 130  QC=QC-QM+QL
      IF(NT.GT.0)GOTO 131
      WRITE(LC)MK,ML,FF,SI
      REWIND LC
      GOTO 93
 131  RA=RA/RB
      WRITE(LI,19)
      WRITE(LI,21)RA,JF
      WRITE(*,21)RA,JF
      CALL SXFL
      IF(NZ.EQ.0)GOTO 132
      MK(LG+1)=0
      WRITE(LF)MK,ML,FF,SI
      REWIND LF
      JB=NR
      JC=MZ
      JD=NG
      IV=MM
      A(179)=QQ
 132  JA=NZ
C
C Theoretical number of unique reflections (Friedel merged)
C
      IF(A(74).LT.0.5)GOTO 141
      Q=0.
      P=0.
      S=2.*SQRT(A(88))/A(1)
      I=INT(A(2)*S+.5)
      J=INT(A(3)*S+.5)
      K=INT(A(4)*S+.5)
      S=A(88)+1.E-6
      NL=-1
 133  NL=NL+1
      IF(NL.GT.K)GOTO 140
      W=REAL(NL)
      NK=-1-J
      IF(NL.EQ.0)NK=-1
 134  NK=NK+1
      IF(NK.GT.J)GOTO 133
      V=REAL(NK)
      MT=IABS(NK)+IABS(NL)
      NH=-1-I
      IF(MT.EQ.0)NH=0
 135  NH=NH+1
      IF(NH.GT.I)GOTO 134
      IF(IABS(NH)+MT.EQ.0)GOTO 135
      U=REAL(NH)
        DO 136 N=LY+16,LL,4
        IF(ABS(AMOD(999.5-U*(A(N+1)-99.5)-V*(A(N+2)-99.5)-
     +  W*(A(N+3)-99.5),1.)-0.5).GT.0.1)GOTO 135
 136    CONTINUE
        DO 139 N=213,LY,12
        R=A(23)
        IJ=INT(1.0001*(U*A(N)+V*A(N+3)+W*A(N+6)))
        IK=INT(1.0001*(U*A(N+1)+V*A(N+4)+W*A(N+7)))
        IL=INT(1.0001*(U*A(N+2)+V*A(N+5)+W*A(N+8)))
        IF(IL.GT.0)GOTO 138
        IF(IL.LT.0)GOTO 137
        IF(IK.GT.0)GOTO 138
        IF(IK.LT.0)GOTO 137
        IF(IJ.GE.0)GOTO 138
 137    IJ=-IJ
        IK=-IK
        IL=-IL
        R=-R
 138    IF(IL.GT.NL)GOTO 135
        IF(IL.LT.NL)GOTO 139
        IF(IK.GT.NK)GOTO 135
        IF(IK.LT.NK)GOTO 139
        IF(IJ.GT.NH)GOTO 135
        IF(IJ.LT.NH)GOTO 139
        IF(R.LT.-0.5)GOTO 139
        IF(ABS(AMOD(999.5+U*A(N+9)+V*A(N+10)+W*A(N+11),1.)-
     +  .5).GT.0.1)GOTO 135
 139    CONTINUE
      T=QW(1)*U**2+QW(2)*V**2+QW(3)*W**2+QW(4)*V*W+QW(5)*U*W+
     +QW(6)*U*V
      IF(T.LT.S)Q=Q+1.
      IF(T.LT.SG)P=P+1.
      GOTO 135
 140  WRITE(LH,24)'max ',REAL(JF)/AMAX1(1.,Q),KD
      WRITE(LH,23)0.5*A(74),KD
      WRITE(LH,24)'full',REAL(JQ)/AMAX1(1.,P),KD
 141  RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SX3N(LM,JW,LU,MH,MK,ML,MB,FF,SI,FC,WL,FB,A,B)
C
C Fourier maps, peaksearch and unique molecule assembly
C
      CHARACTER*1 IH(50),KD,KK
      CHARACTER*2 KA(94)
      CHARACTER*4 KS,KT
      CHARACTER*76 IT
      CHARACTER*80 NM,IR
      CHARACTER*128 KR
      INTEGER MH(LU),MK(LU),ML(LU),MB(LU)
      REAL FF(LU),SI(LU),FC(LU),WL(LU),FB(LU),A(LM),B(JW)
      COMMON/MEM/ST,SL,TC,TL,IV,LR,LG,LH,LI,LP,LF,LA,LC,LW,LY,LL,LB,
     +LX,LE,LV,LJ,LD,LS,LO,LT,LK,LQ,LZ,LN,KH,JA,JB,JC,JD,JE,HA,HD
      COMMON/WORD/IH,IT,IR,NM,KA,KD
C
   1  FORMAT(1X,A)
   2  FORMAT(//' Residue reliability criteria ',A/)
   3  FORMAT(' Residue    Mean(DD) Min(DD) Max(Peak)  Mean(U)   ',
     +'Max(U) Mean(Anis) Min(Anis) Max(SIMU)  Max(BUMP)  Sum(occ)',
     +'  N(ats)'/)
   4  FORMAT(1X,A9,F8.2,2F9.2,7F10.3,F8.0)
   5  FORMAT(//' Electron density synthesis with coefficients ',A/)
   6  FORMAT(' Highest peak',F8.2,'  at',3F8.4,'  [',F6.2,' A from ',
     +A,' ]'/' Deepest hole',F8.2,'  at',3F8.4,'  [',F6.2,' A from ',
     +A,' ]')
   7  FORMAT(/' Mean =',F8.2,',   Rms deviation from mean =',F8.2,
     +' e/A^3,   Highest memory used =',I6,' /',I6)
 777  FORMAT('REM Highest difference peak',F7.3,',  deepest hole',
     +F7.3,',  1-sigma level',F7.3)
   8  FORMAT('_refine_diff_density_max',F9.3,A1/'_refine_diff',
     +'_density_min',F9.3,A1/'_refine_diff_density_rms',F9.3,A1)
   9  FORMAT(//' Fourier peaks appended to .res file'//14X,'x',7X,
     +'y       z       sof     U      Peak   Distances to nearest',
     +' atoms (including symmetry equivalents)'/)
  10  FORMAT(/' No peaks closer than 4 Angstroms to each other')
  11  FORMAT(/' Shortest distances between peaks (including ',
     +'symmetry equivalents)'/)
  12  FORMAT(7(I7,I4,F6.2))
  13  FORMAT(F8.2)
  14  FORMAT(A,A3,'  1 ',3F8.4,F10.5,'  0.05',F8.2,A)
  15  FORMAT(A,A3,'  4 ',3F8.4,F10.5,'  0.75',F8.2)
  16  FORMAT('ATOM  ',I5,'  W   HOH',I6,4X,3F8.3,F6.3,' 50.00')
  17  FORMAT(//' Unique Molecule Assembly'//' Atom      Mole  Peak',
     +'     x        y        z     Bonded to'/)
  18  FORMAT(1X,A8,I4,F7.2,3F9.5,3X,A)
  19  FORMAT(' Molecule',I3,5X,'scale',F6.3,
     +' inches =',F6.3,' cm per Angstrom')
  20  FORMAT(///' Molecule',I3)
  21  FORMAT(//' Atom       Peak    x',7X,'y',7X,'z',5X,
     +'Sof  Height      Distances and Angles')
  22  FORMAT(/1X,A9,F6.2,3F8.4,F6.3,F5.1,I4,1X,A9,F6.3)
  23  FORMAT(51X,I4,1X,A9,F6.3,10F6.1)
  24  FORMAT(//' Code  Atom         x       y       z   Height',
     +'  Symmetry Transformation'/)
  25  FORMAT(I4,2X,A9,3F8.4,F6.1,1X,3(F8.4,A4))
  26  FORMAT(80A1)
C
C Set up Fourier
C
      IF(JA.EQ.0)GOTO 188
      CALL SXTO(18)
      NZ=JA
      NR=JB
      MZ=JC
      NG=JD
      SF=0.
      IF(NZ.NE.2)SF=A(22)/A(20)
      MA=MAX0(MIN0(INT(ABS(A(55))),3),1)
      MP=LX+9*INT(ABS(A(57)))
        DO 27 I=1,126
        WL(I)=SIN(6.283185E-2*REAL(I-1))
  27    CONTINUE
      JC=-1
      JB=-1
      JA=NR+14
      RR=.1
      IF(AMAX1(A(5),A(6),A(7)).GT.110.)RR=.3
      SS=2./A(20)
      ED=0.
      ES=0.
      MQ=53
      IF(A(56).LT.0.)MQ=103
      MW=MQ**2
      MG=MW-MQ-MQ
      JS=3*MW+NR+14
      JT=0
      JM=0
        DO 28 I=MZ,LO
        IF(A(I).LT.0.5)GOTO 28
        A(I)=REAL(JM)
        JM=JM+1
  28    CONTINUE
      IF(JM.EQ.0)CALL SXER('NO DATA FOR FOURIER')
      ZZ=A(33)
      YM=AMOD(A(34)+1000.1,100.)-.1
      ZM=AMOD(A(35)+1000.1,100.)-.1
      NX=INT(ABS(A(56)))
  29  NH=2*MIN0(NX,(JW-JS)/(2*JM))
      IF(NH.LT.1)CALL SXER('INSUFFICIENT MEMORY FOR FOURIER')
      JE=JS+NH*JM-1
      IF(JT.LT.JE)JT=JE
        DO 30 J=JS,JE
        B(J)=0.
  30    CONTINUE
C
C Read reflections
C
  31  READ(LF)MK,ML,FF,SI
      CALL SXCC
      I=0
  32  I=I+1
      IF(I.GT.LU)GOTO 31
      M=MK(I)
      IF(M.EQ.0)GOTO 33
      J=JS+NH*INT(A(M))
      X=.06283185*REAL(ML(I))
C
C hx sums
C
      S=X*ZZ
      V=COS(S)
      U=SIN(S)
      T=FF(I)*V+SI(I)*U
      S=FF(I)*U-SI(I)*V
      X=X*A(36)
      Y=SIN(X)
      X=COS(X)
      CALL SXHX(B(J),T,S,X,Y,NH)
      GOTO 32
C
C Second and third Fourier summations
C
  33  REWIND LF
      MS=1
  34  Z=0.
      Y=-1.
      JF=JA+MW-1
        DO 35 J=JA,JF
        B(J)=SF
  35    CONTINUE
      CALL SXZA(FF,MQ)
      CALL SXZA(SI,MQ)
      JF=JS+MS
        DO 39 M=MZ,LO
        Y=Y+1.
        IF(Y.LT.A(179))GOTO 37
        CALL SXCC
        K=INT(AMOD(Z*A(38),100.))
        L=INT(AMOD(Z*ZM,100.))
        J=JA
          DO 36 N=1,MQ
          L=MOD(L,100)
          U=WL(L+1)
          V=WL(L+26)
          CALL SXLZ(B(J),FF,SI,U,V,MQ)
          J=J+MQ
          L=L+K
  36      CONTINUE
        CALL SXZA(FF,MQ)
        CALL SXZA(SI,MQ)
        Y=0.1-A(179)
        Z=Z+1.
  37    IF(A(M).LT.-1.)GOTO 39
        K=INT(AMOD(10000.1+Y*A(37),100.))
        L=INT(AMOD(10000.1+Y*YM,100.))
        U=B(JF-1)*SS
        V=B(JF)*SS
          DO 38 N=1,MQ
          FC(N)=WL(L+1)
          FB(N)=WL(L+26)
          L=MOD(L+K,100)
  38      CONTINUE
        CALL SXKY(FF,SI,FB,FC,U,V,MQ)
        JF=JF+NH
  39    CONTINUE
C
C Determine mean and minimum density for each residue
C
        DO 40 I=1,NG,3
        K=INT(B(I))
        IF(K.EQ.0)GOTO 40
        IF(INT(B(I+1)).NE.NX)GOTO 40
        M=INT(B(I+2))+JA
        B(K+10)=AMIN1(B(K+10),B(M))
        B(K+12)=B(K+12)+B(M)
        B(K+13)=B(K+13)+1.
  40    CONTINUE
C
C Locate maxima
C
      IF(JC.LT.0)GOTO 63
      CALL SXTO(19)
      Z=A(35)
        DO 62 I=MQ,MG,MQ
        Z=Z+A(38)
        Y=A(34)
          DO 61 K=1,MQ-2
          Y=Y+A(37)
          NK=I+K
          M=NK+JB
          P=B(M)
          ED=ED+P
          ES=ES+P**2
          IF(P.LT.0.)GOTO 41
          IF(B(M-1).GT.P)GOTO 61
          IF(B(M+1).GT.P)GOTO 61
          MC=M-MQ
          IF(AMAX1(B(MC-1),B(MC),B(MC+1)).GT.P)GOTO 61
          MX=M+MQ
          IF(AMAX1(B(MX-1),B(MX),B(MX+1)).GT.P)GOTO 61
          L=NK+JC
          MJ=L-MQ
          MD=L+MQ
          IF(AMAX1(B(MJ),B(L-1),B(L),B(L+1),B(MD)).GT.P)GOTO 61
          N=NK+JA
          MJ=N-MQ
          MD=N+MQ
          IF(AMAX1(B(MJ),B(N-1),B(N),B(N+1),B(MD)).GT.P)GOTO 61
          GOTO 42
  41      IF(B(M-1).LT.P)GOTO 61
          IF(B(M+1).LT.P)GOTO 61
          MC=M-MQ
          IF(AMIN1(B(MC-1),B(MC),B(MC+1)).LT.P)GOTO 61
          MX=M+MQ
          IF(AMIN1(B(MX-1),B(MX),B(MX+1)).LT.P)GOTO 61
          L=NK+JC
          MJ=L-MQ
          MD=L+MQ
          IF(AMIN1(B(MJ),B(L-1),B(L),B(L+1),B(MD)).LT.P)GOTO 61
          N=NK+JA
          MJ=N-MQ
          MD=N+MQ
          IF(AMIN1(B(MJ),B(N-1),B(N),B(N+1),B(MD)).LT.P)GOTO 61
  42      Q=P+P
          U=B(L)-B(N)
          V=B(M-1)-B(M+1)
          W=B(MC)-B(MX)
          R=U/(B(N)+B(L)-Q)
          S=V/(B(M-1)+B(M+1)-Q)
          T=W/(B(MC)+B(MX)-Q)
          H=P-(U*R+V*S+W*T)*.0416667
          AH=H
          IF(A(54).LT.0.)AH=ABS(H)
C
C Check for special position, find s.o.f. (iteratively !)
C
          W=.01*ZZ+A(36)*(.005*R-.01)
          V=.005*(Y+Y+A(37)*S)
          U=.005*(Z+Z+A(38)*T)
          IF(A(55).LT.0.)GOTO 43
          T=U
          U=V
          V=T
  43        DO 44 NK=1,MA
            T=W
            W=V
            V=U
            U=T
  44        CONTINUE
            DO 47 NK=1,3
            SK=0.
            XS=0.
            YS=0.
            ZS=0.
              DO 46 L=201,LY,12
              XA=U*A(L)+V*A(L+1)+W*A(L+2)+A(L+9)
              YA=U*A(L+3)+V*A(L+4)+W*A(L+5)+A(L+10)
              ZA=U*A(L+6)+V*A(L+7)+W*A(L+8)+A(L+11)
                DO 45 M=IV,LL,4
                O=A(M)*XA+A(M+1)
                P=A(M)*YA+A(M+2)
                Q=A(M)*ZA+A(M+3)
                R=AMOD(O-U,1.)-.5
                S=AMOD(P-V,1.)-.5
                T=AMOD(Q-W,1.)-.5
                IF(A(8)*R**2+A(9)*S**2+A(10)*T**2+S*T*A(11)+
     +          R*T*A(12)+R*S*A(13).GT.RR)GOTO 45
                XS=XS+R+U
                YS=YS+S+V
                ZS=ZS+T+W
                SK=SK+1.
  45            CONTINUE
  46          CONTINUE
            SK=1./SK
            U=XS*SK
            V=YS*SK
            W=ZS*SK
            IF(SK.GT.0.9)GOTO 48
  47        CONTINUE
C
C Eliminate equivalents
C
  48      MD=0
          AD=4.
          AP=9.E9
          AQ=9.E9
          MY=0
          MN=0
            DO 53 L=201,LY,12
            XA=U*A(L)+V*A(L+1)+W*A(L+2)+A(L+9)
            YA=U*A(L+3)+V*A(L+4)+W*A(L+5)+A(L+10)
            ZA=U*A(L+6)+V*A(L+7)+W*A(L+8)+A(L+11)
              DO 52 M=IV,LL,4
              O=A(M)*XA+A(M+1)
              P=A(M)*YA+A(M+2)
              Q=A(M)*ZA+A(M+3)
              N=LB+7
  49          N=N+9
              IF(N.GT.LD)GOTO 52
              R=AMOD(O-A(N+2),1.)-.5
              S=AMOD(P-A(N+3),1.)-.5
              T=AMOD(Q-A(N+4),1.)-.5
              T=A(8)*R**2+A(9)*S**2+A(10)*T**2+S*T*A(11)+R*T*A(12)+
     +        R*S*A(13)
              IF(T.GT.AD)GOTO 50
              IF(N.GT.LX)GOTO 50
              ND=3*((N-LB)/9)-2
              ND=INT(B(ND))
              IF(ND.LE.0)GOTO 50
              MD=ND
              AD=T
  50          IF(T.GT.AP)GOTO 51
              AP=T
              MY=N
  51          IF(T.GT.AQ)GOTO 49
              IF(N.GT.LX)GOTO 49
              AQ=T
              MN=N
              GOTO 49
  52          CONTINUE
  53        CONTINUE
          NK=LD+9
          IF(AP.GT.RR)GOTO 54
          NK=LX
          IF(AH.LE.ABS(A(MY+6)))GOTO 54
          NK=MY
          A(MY+6)=H
  54      IF(H.LE.A(188))GOTO 55
          A(188)=H
          A(189)=U
          A(190)=V
          A(191)=W
          A(192)=SQRT(AQ)
          A(193)=REAL(MN)
  55      IF(H.GE.A(194))GOTO 56
          A(194)=H
          A(195)=U
          A(196)=V
          A(197)=W
          A(198)=SQRT(AQ)
          A(199)=REAL(MN)
  56      IF(NK.LE.LX)GOTO 60
C
C Sort peaks
C
          IF(AH.LT.0.)GOTO 61
          IF(NK.GT.LD)LD=MIN0(NK,MP)
          NJ=NK
  57      NJ=NJ-9
          IF(ABS(A(NJ+6)).GT.AH)GOTO 59
          IF(NJ.LE.LX)GOTO 59
          GOTO 57
  58      CALL SXCA(A(NK+2),A(NK+11),7)
  59      NK=NK-9
          IF(NJ.LT.NK)GOTO 58
          A(NJ+11)=U
          A(NJ+12)=V
          A(NJ+13)=W
          A(NJ+14)=SK
          A(NJ+15)=H
          A(NJ+16)=A(LL+6)
          A(NJ+17)=0.
  60      IF(MD.GT.0)B(MD+11)=AMAX1(B(MD+11),H)
  61      CONTINUE
  62    CONTINUE
      CALL SXCC
C
C Recycle
C
  63  NX=NX-1
      IF(NX.EQ.0)GOTO 64
      CALL SXTO(18)
      JC=JB
      JB=JA
      JA=JA+MW
      IF(JA.GE.JS)JA=NR+14
      ZZ=ZZ+A(36)
      MS=MS+2
      IF(MS.GT.NH)GOTO 29
      GOTO 34
C
C Print residue diagnostics - main-chain
C
  64  M=0
        DO 68 I=NG+3,NR,14
        NK=INT(B(I))
        IF(NK.GE.0)GOTO 68
        IF(M.GT.0)GOTO 65
        WRITE(LI,2)'(main-chain)'
        WRITE(LI,3)
        M=1
  65    WRITE(IR,'(A5,I4)')'    _',IABS(NK)
        CALL SXUS(B(I+1),IR(1:4))
          DO 66 K=2,4
          CALL SXLC(IR(K:K))
  66      CONTINUE
        L=0
          DO 67 K=1,9
          IF(IR(K:K).EQ.' ')GOTO 67
          L=L+1
          IR(L:L)=IR(K:K)
  67      CONTINUE
        IR(L+1:9)=' '
        WRITE(LI,4)IR(1:9),B(I+12)/AMAX1(.1,B(I+13)),
     +  B(I+10),B(I+11),(B(K),K=I+4,I+9),B(I+2),B(I+3)
  68    CONTINUE
C
C Side-chains (corresponding main-chains must be present)
C
        DO 74 I=NG+3,NR,14
        NK=INT(B(I))
        IF(NK.LE.0)GOTO 74
          DO 69 K=NG+3,NR,14
          IF(INT(B(K))+NK.EQ.0)GOTO 70
  69      CONTINUE
        GOTO 74
  70    IF(M.GT.1)GOTO 71
        WRITE(LI,2)'(side-chain)'
        WRITE(LI,3)
        M=2
  71    WRITE(IR,'(A5,I4)')'    _',IABS(NK)
        CALL SXUS(B(I+1),IR(1:4))
          DO 72 K=2,4
          CALL SXLC(IR(K:K))
  72      CONTINUE
        L=0
          DO 73 K=1,9
          IF(IR(K:K).EQ.' ')GOTO 73
          L=L+1
          IR(L:L)=IR(K:K)
  73      CONTINUE
        IR(L+1:9)=' '
        WRITE(LI,4)IR(1:9),B(I+12)/AMAX1(.1,B(I+13)),
     +  B(I+10),B(I+11),(B(K),K=I+4,I+9),B(I+2),B(I+3)
        B(I)=0.
  74    CONTINUE
C
C Other residues and solvent
C
        DO 78 I=NG+3,NR,14
        NK=INT(B(I))
        IF(NK.LE.0)GOTO 78
        IF(M.GT.2)GOTO 75
        WRITE(LI,2)'(solvent and other residues)'
        WRITE(LI,3)
        M=3
  75    WRITE(IR,'(A5,I4)')'    _',IABS(NK)
        CALL SXUS(B(I+1),IR(1:4))
          DO 76 K=2,4
          CALL SXLC(IR(K:K))
  76      CONTINUE
        L=0
          DO 77 K=1,9
          IF(IR(K:K).EQ.' ')GOTO 77
          L=L+1
          IR(L:L)=IR(K:K)
  77      CONTINUE
        IR(L+1:9)=' '
        WRITE(LI,4)IR(1:9),B(I+12)/AMAX1(.1,B(I+13)),
     +  B(I+10),B(I+11),(B(K),K=I+4,I+9),B(I+2),B(I+3)
  78    CONTINUE
C
C Print electron density statistics
C
      IF(NZ.EQ.2)WRITE(LI,5)'Fo-Fc'
      IF(NZ.EQ.3)WRITE(LI,5)'Fo'
      IF(NZ.EQ.4)WRITE(LI,5)'2Fo-Fc'
      IF(NZ.EQ.5)WRITE(LI,5)'mFo-Fc (Sim weighted)'
      IF(NZ.EQ.6)WRITE(LI,5)'mFo-Fc (Sim weighted and sharpened)'
      W=AMAX1(1.,REAL((MQ-2)**2)*(ABS(A(56))-2.))
      ED=ED/W
      ES=SQRT(ES/W-ED**2)
      IF(INT(A(193))*INT(A(199)).EQ.0)GOTO 79
      L=0
      CALL SXAN(INT(A(193)),IR,L,LM,A)
      M=0
      CALL SXAN(INT(A(199)),KR,M,LM,A)
      WRITE(*,6)(A(I),I=188,192),IR(1:L),(A(I),I=194,198),KR(1:M)
      CALL SXFL
      WRITE(LI,6)(A(I),I=188,192),IR(1:L),(A(I),I=194,198),KR(1:M)
  79  WRITE(LI,7)ED,ES,LO,JT
      WRITE(IR,777)A(188),A(194),ES
      CALL SXLP(IR,LP)
      IF(A(74).GT.0.5)WRITE(LH,8)A(188),KD,A(194),KD,ES,KD
C
C Assign names to peaks
C
      CALL SXTO(20)
      M=0
      I=LX
  80  I=I+9
      IF(I.GT.LD)GOTO 81
      M=M+1
      CALL SXPN(A(I),M)
      CALL SXPS(A(I+1),'0   ')
      GOTO 80
C
C Start new molecule
C
  81  IF(A(57).GE.0.)GOTO 102
      IF(ABS(A(51)).GT.2.5)WRITE(LI,17)
        DO 82 I=1,LU
        MB(I)=0
  82    CONTINUE
      NK=0
      I=LB+7
  83  I=I+9
      IF(I.GT.LX)GOTO 85
      K=MIN0(99,INT(.01*ABS(A(I+7))))
      IF(K.EQ.0)GOTO 83
      IF(A(59).LT.0.)GOTO 84
      IF(AMOD(ABS(A(I+7)),100.).LT.0.4)GOTO 83
  84  MB(K)=MB(K)+1
      NK=-1
      GOTO 83
  85  IF(NK.NE.0)GOTO 89
  86  NK=0
      L=LB+7
  87  L=L+9
      IF(L.GT.LD)GOTO 103
      IF(ABS(A(L+7)).GT.100.)GOTO 87
      IF(A(59).LT.0.)GOTO 88
      IF(AMOD(ABS(A(L+7)),100.).LT.0.4)GOTO 87
  88  NK=NK+1
      IF(MB(NK).NE.0)GOTO 88
      NK=MIN0(NK,99)
      A(L+7)=SIGN(100.*REAL(NK)+AMOD(ABS(A(L+7)),100.),A(L+7))
      MB(NK)=1
      IF(ABS(A(51)).LT.2.5)GOTO 89
      IR=' '
      I=0
      CALL SXAN(L,IR,I,LM,A)
      WRITE(LI,18)IR(1:9),NK,A(L+6),A(L+2),A(L+3),A(L+4),
     +'new molecule'
  89  CALL SXCC
C
C Add atom or peak to existing molecule
C
      NJ=LB+7
  90  L=NJ+9
      IF(L.GT.LD)GOTO 86
      NJ=L
      IF(ABS(A(L+7)).GT.100.)GOTO 90
      NI=LD+6
      P=A(58)+AMOD(ABS(A(L+7)),100.)
        DO 94 K=201,LY,12
        X=A(L+2)*A(K)+A(L+3)*A(K+1)+A(L+4)*A(K+2)+A(K+9)
        Y=A(L+2)*A(K+3)+A(L+3)*A(K+4)+A(L+4)*A(K+5)+A(K+10)
        Z=A(L+2)*A(K+6)+A(L+3)*A(K+7)+A(L+4)*A(K+8)+A(K+11)
          DO 93 M=IV,LL,4
          IF(NI+5.GT.LM)GOTO 101
          XX=A(M)*X+A(M+1)
          YY=A(M)*Y+A(M+2)
          ZZ=A(M)*Z+A(M+3)
          N=LD+6
  91      N=N+3
          IF(N.GT.NI)GOTO 92
          U=AMOD(99.5+A(M)-XX,1.)-.5
          V=AMOD(99.5+A(M+1)-YY,1.)-.5
          W=AMOD(99.5+A(N+2)-ZZ,1.)-.5
          IF(A(8)*U**2+A(9)*V**2+A(10)*W**2+A(11)*V*W+
     +    A(12)*U*W+A(13)*U*V.LT.RR)GOTO 93
          GOTO 91
  92      NI=NI+3
          A(NI)=XX
          A(NI+1)=YY
          A(NI+2)=ZZ
  93      CONTINUE
  94    CONTINUE
      MY=0
      MJ=LB+7
  95  MJ=MJ+9
      IF(MJ.GT.LD)GOTO 100
      S=(P+AMOD(ABS(A(MJ+7)),100.))**2
        DO 99 I=LD+9,NI,3
        U=AMOD(A(I)-A(MJ+2),1.)-.5
        V=AMOD(A(I+1)-A(MJ+3),1.)-.5
        W=AMOD(A(I+2)-A(MJ+4),1.)-.5
        IF(A(8)*U**2+A(9)*V**2+A(10)*W**2+V*W*A(11)+U*W*A(12)+
     +  U*V*A(13).GT.S)GOTO 99
        K=INT(.01*ABS(A(MJ+7)))
        IF(K.NE.0)GOTO 96
        NJ=MIN0(NJ,MJ-9)
        GOTO 95
  96    IF(MY.NE.0)GOTO 95
        IF(L.LE.LX)GOTO 98
        A(L+2)=A(MJ+2)+U
        A(L+3)=A(MJ+3)+V
        A(L+4)=A(MJ+4)+W
  97    MB(K)=MB(K)+1
        A(L+7)=SIGN(100.*REAL(K)+AMOD(ABS(A(L+7)),100.),A(L+7))
        MY=K
        IF(ABS(A(51)).LT.2.5)GOTO 95
        KR=' '
        M=0
        CALL SXAN(L,KR,M,LM,A)
        M=0
        CALL SXAN(MJ,IR,M,LM,A)
        WRITE(LI,18)KR(1:9),MY,A(L+6),A(L+2),A(L+3),A(L+4),IR(1:M)
        GOTO 95
  98    IF(ABS(A(MJ+2)+U-A(L+2))+ABS(A(MJ+3)+V-A(L+3))+
     +  ABS(A(MJ+4)+W-A(L+4)).LT.0.001)GOTO 97
  99    CONTINUE
      GOTO 95
 100  IF(MY.EQ.0)NJ=L
      GOTO 90
 101  CALL SXER('NOT ENOUGH MEMORY FOR PLAN')
C
C Output peaks to .res file
C
 102  WRITE(LI,9)
 103  I=LX
 104  I=I+9
      IF(I.GT.LD)GOTO 118
      CALL SXUS(A(I),KT)
      IF(A(57).LT.0.)GOTO 117
      HB=1.
      DB=-1.
      MP=1
      SI(MP)=-1.
      T=9.E9
      UU=A(I+2)
      VV=A(I+3)
      WW=A(I+4)
        DO 114 L=201,LY,12
        U=UU*A(L)+VV*A(L+1)+WW*A(L+2)+A(L+9)
        V=UU*A(L+3)+VV*A(L+4)+WW*A(L+5)+A(L+10)
        W=UU*A(L+6)+VV*A(L+7)+WW*A(L+8)+A(L+11)
          DO 113 M=IV,LL,4
          X=A(M)*U+A(M+1)
          Y=A(M)*V+A(M+2)
          Z=A(M)*W+A(M+3)
          MJ=LB+7
 105      MJ=MJ+9
          IF(MJ.GT.LX)GOTO 113
          P=AMOD(X-A(MJ+2),1.)-.5
          Q=AMOD(Y-A(MJ+3),1.)-.5
          R=AMOD(Z-A(MJ+4),1.)-.5
          O=A(8)*P**2+A(9)*Q**2+A(10)*R**2+Q*R*A(11)+P*R*A(12)+
     +    P*Q*A(13)+0.001
          CALL SXUS(A(MJ),KS)
          IF(A(MJ+8).LT.0.1)GOTO 106
          IF(O.GE.A(58)**2)GOTO 106
          A(I+8)=.5
          GOTO 109
 106      IF(KS(1:1).EQ.'H')GOTO 109
          IF(KS(1:1).EQ.'O')GOTO 107
          IF(KS(1:1).NE.'N')GOTO 108
 107      IF(O.LT.16.)HB=-1.
          IF(O.LT.A(58)**2)DB=1.
          GOTO 109
 108      IF(O.LT.A(59)**2)DB=1.
 109      IF(O.GT.T)GOTO 105
          K=MP+1
          N=K
 110      K=K-1
          IF(SI(K).GT.O)GOTO 110
          IF(SI(K).LT.O-0.002)GOTO 112
          IF(MH(K).EQ.MJ)GOTO 105
          GOTO 112
 111      SI(N+1)=SI(N)
          MH(N+1)=MH(N)
 112      N=N-1
          IF(N.GT.K)GOTO 111
          SI(K+1)=O-0.001
          MH(K+1)=MJ
          IF(K.GE.4)T=O-0.001
          MP=MIN0(MP+1,5)
          IF(K.GT.1)GOTO 105
          A(I+2)=P+A(MJ+2)
          A(I+3)=Q+A(MJ+3)
          A(I+4)=R+A(MJ+4)
          GOTO 105
 113      CONTINUE
 114    CONTINUE
      K=1
      KR=' '
        DO 116 L=2,MP
        WRITE(IR,13)SQRT(SI(L))
        K=K+2
          DO 115 N=1,8
          IF(IR(N:N).EQ.' ')GOTO 115
          K=K+1
          KR(K:K)=IR(N:N)
 115      CONTINUE
        K=K+1
        CALL SXAN(MH(L),KR,K,LM,A)
 116    CONTINUE
      WRITE(LI,14)' Q',KT(1:3),(A(L),L=I+2,I+6),KR(1:K)
      A(I+5)=A(I+5)*AMAX1(HB,DB)
      IF(ABS(A(58)).GT.0.1)GOTO 104
 117  A(I+5)=ABS(A(I+5))+10.
      WRITE(IR,14)'Q',KT(1:3),(A(K),K=I+2,I+6)
      CALL SXLP(IR,LP)
      A(I+5)=A(I+5)-10.
      GOTO 104
 118  IF(A(57).LT.0.)GOTO 133
      T=9.
      MP=1
      SI(1)=-1.
      I=LX
 119  I=I+9
      IF(I.GT.LD)GOTO 127
        DO 126 L=201,LY,12
        U=A(I+2)*A(L)+A(I+3)*A(L+1)+A(I+4)*A(L+2)+A(L+9)
        V=A(I+2)*A(L+3)+A(I+3)*A(L+4)+A(I+4)*A(L+5)+A(L+10)
        W=A(I+2)*A(L+6)+A(I+3)*A(L+7)+A(I+4)*A(L+8)+A(L+11)
          DO 125 M=IV,LL,4
          X=A(M)*U+A(M+1)
          Y=A(M)*V+A(M+2)
          Z=A(M)*W+A(M+3)
          MJ=I-9
 120      MJ=MJ+9
          IF(MJ.GT.LD)GOTO 125
          P=AMOD(X-A(MJ+2),1.)-.5
          Q=AMOD(Y-A(MJ+3),1.)-.5
          R=AMOD(Z-A(MJ+4),1.)-.5
          O=A(8)*P**2+A(9)*Q**2+A(10)*R**2+Q*R*A(11)+P*R*A(12)+
     +    P*Q*A(13)
          IF(O.LT.0.01.AND.MJ.EQ.I)GOTO 120
          IF(O.GT.A(58)**2)GOTO 121
          IF(A(I+5).GT.0.)GOTO 121
          A(MJ+8)=A(I+8)
          IF(A(I+8).LT.0.1)A(MJ+5)=ABS(A(MJ+5))
 121      IF(O.GT.T)GOTO 120
          K=MP+1
          N=K
 122      K=K-1
          IF(SI(K).GT.O)GOTO 122
          IF(SI(K).LT.O-0.002)GOTO 124
          IF(MH(K).NE.I)GOTO 124
          IF(MK(K).NE.MJ)GOTO 124
          GOTO 120
 123      SI(N+1)=SI(N)
          MH(N+1)=MH(N)
          MK(N+1)=MK(N)
 124      N=N-1
          IF(N.GT.K)GOTO 123
          SI(K+1)=O-0.001
          MH(K+1)=I
          MK(K+1)=MJ
          IF(K.EQ.LU-2)T=SI(K+1)
          MP=MIN0(MP+1,LU-1)
          GOTO 120
 125      CONTINUE
 126    CONTINUE
      GOTO 119
 127  IF(MP.GT.1)GOTO 128
      WRITE(LI,10)
      GOTO 129
 128  WRITE(LI,11)
      WRITE(LI,12)((MH(I)-LX)/9,(MK(I)-LX)/9,SQRT(SI(I)),I=2,MP)
 129  NX=(LX-LB)/9
      NY=0
        DO 131 I=LB+16,LX,9
        CALL SXUS(A(I+1),KT)
        L=0
          DO 130 M=1,4
          IF(KT(M:M).EQ.IH(20))GOTO 130
          L=10*L+ICHAR(KT(M:M))-48
 130      CONTINUE
        IF(NY.LT.L)NY=L
 131    CONTINUE
      I=LX
 132  I=I+9
      IF(I.GT.LD)GOTO 133
      IF(A(I+5).GT.0.)GOTO 132
      A(I+5)=10.+ABS(A(I+5))*(1.-A(I+8))
      CALL SXUS(A(I),KT)
      WRITE(IR,15)'Q',KT(1:3),(A(L),L=I+2,I+6)
      CALL SXLP(IR,LP)
      IF(ABS(A(79)).LT.0.5)GOTO 132
      NX=NX+1
      NY=NY+1
      WRITE(IR,16)NX,NY,A(94)*A(I+2)+A(95)*A(I+3)+A(96)*A(I+4),
     +A(97)*A(I+3)+A(98)*A(I+4),A(99)*A(I+4),A(I+5)-10.
      CALL SXLP(IR,LQ)
      GOTO 132
 133  IF(A(57).GE.0.)GOTO 188
C
C Environment
C
      NX=0
 134  NX=NX+1
      IF(NX.GT.99)GOTO 188
      IF(MB(NX).EQ.0)GOTO 134
      N=LD
      I=LB+7
 135  I=I+9
      IF(I.GT.LD)GOTO 147
      CALL SXCC
      S=AMOD(ABS(A(I+7)),100.)
      T=S+A(58)
      S=AMAX1(T,S+ABS(A(59)))
      IF(I.LE.LX)GOTO 136
      IF(A(I+6).LT.0.8)S=T
 136    DO 146 L=201,LY,12
        U=A(I+2)*A(L)+A(I+3)*A(L+1)+A(I+4)*A(L+2)+A(L+9)
        V=A(I+2)*A(L+3)+A(I+3)*A(L+4)+A(I+4)*A(L+5)+A(L+10)
        W=A(I+2)*A(L+6)+A(I+3)*A(L+7)+A(I+4)*A(L+8)+A(L+11)
          DO 145 M=IV,LL,4
          X=A(M)*U+A(M+1)
          Y=A(M)*V+A(M+2)
          Z=A(M)*W+A(M+3)
          MJ=LB+7
 137      MJ=MJ+9
          IF(MJ.GT.LD)GOTO 145
          IF(INT(.01*ABS(A(MJ+7))).NE.NX)GOTO 137
          IF(MJ.LE.LX)GOTO 138
          IF(A(MJ+6).LT.1.)GOTO 137
 138      P=AMOD(X-A(MJ+2),1.)-.5
          Q=AMOD(Y-A(MJ+3),1.)-.5
          R=AMOD(Z-A(MJ+4),1.)-.5
          O=A(8)*P**2+A(9)*Q**2+A(10)*R**2+Q*R*A(11)+P*R*A(12)+
     +    P*Q*A(13)
          IF(O.GT.(S+AMOD(ABS(A(MJ+7)),100.))**2)GOTO 137
          P=P+A(MJ+2)
          Q=Q+A(MJ+3)
          R=R+A(MJ+4)
          IF(INT(.01*ABS(A(I+7))).NE.NX)GOTO 139
          IF(ABS(P-A(I+2))+ABS(Q-A(I+3))+ABS(R-A(I+4)).LT.0.001)
     +    GOTO 137
 139      IF(O.LT.(T+AMOD(ABS(A(MJ+7)),100.))**2)GOTO 141
          IF(MJ.LE.LX)GOTO 140
          IF(A(MJ+6).LT.0.8)GOTO 137
 140      IF(AMIN1(A(I+7),A(MJ+7)).LT.0.)GOTO 137
          IF(AMOD(A(I+7)+A(MJ+7),100.).LT.0.8)GOTO 137
 141      K=N+9
 142      K=K-9
          IF(K.LE.LD)GOTO 143
          IF(ABS(P-A(K+2))+ABS(Q-A(K+3))+ABS(R-A(K+4)).LT.0.001)
     +    GOTO 137
          GOTO 142
 143      N=N+9
          IF(N+59.GT.LM)GOTO 101
          A(N)=REAL(I)
          A(N+1)=0.
          A(N+2)=P
          A(N+3)=Q
          A(N+4)=R
          A(N+5)=REAL(M)
          A(N+6)=REAL(L)
          A(N+7)=SIGN(100.*REAL(NX)+AMOD(ABS(A(I+7)),100.),A(I+7))
          A(N+8)=0.
          IF(A(59).LT.0.)GOTO 144
          IF(AMOD(ABS(A(N+7)),100.).LT.0.4)GOTO 137
 144      MB(NX)=MB(NX)+1
          GOTO 137
 145      CONTINUE
 146    CONTINUE
      GOTO 135
C
C Find scale and orientation
C
 147  IF(MB(NX).LT.4)GOTO 168
      IF(NX.EQ.99)GOTO 168
      MA=N+9
      IF(MA+((N-LD)/4).GT.LM)GOTO 101
      A(MA)=-9.E9
        DO 148 M=1,9
        FF(M)=0.
 148    CONTINUE
      FF(10)=9.E9
      FF(11)=-9.E9
      FF(12)=9.E9
      FF(13)=-9.E9
      FF(14)=9.E9
        DO 161 K=4,13,3
        IF(K.LT.10)S=.01
        I=LB+7
 149    I=I+9
        IF(I.GT.N)GOTO 159
        IF(INT(.01*ABS(A(I+7))).NE.NX)GOTO 149
        U=A(94)*A(I+2)+A(95)*A(I+3)+A(96)*A(I+4)
        V=A(97)*A(I+3)+A(98)*A(I+4)
        W=A(99)*A(I+4)
        IF(K.GT.7)GOTO 153
        MJ=I
 150    MJ=MJ+9
        IF(MJ.GT.N)GOTO 149
        IF(INT(.01*ABS(A(MJ+7))).NE.NX)GOTO 150
        IF(A(59).LT.0.)GOTO 151
        IF(AMOD(ABS(A(MJ+7)),100.).LT.0.4)GOTO 150
 151    X=A(94)*A(MJ+2)+A(95)*A(MJ+3)+A(96)*A(MJ+4)-U
        Y=A(97)*A(MJ+3)+A(98)*A(MJ+4)-V
        Z=A(99)*A(MJ+4)-W
        IF(K.EQ.4)GOTO 152
        P=Y*FF(6)-Z*FF(5)
        Q=Z*FF(4)-X*FF(6)
        Z=X*FF(5)-Y*FF(4)
        X=P
        Y=Q
 152    R=X**2+Y**2+Z**2
        IF(R.LT.S)GOTO 150
        S=R
        R=1./SQRT(R)
        FF(K)=X*R
        FF(K+1)=Y*R
        FF(K+2)=Z*R
        GOTO 150
 153    X=U*FF(1)+V*FF(2)+W*FF(3)
        Y=U*FF(4)+V*FF(5)+W*FF(6)
        Z=U*FF(7)+V*FF(8)+W*FF(9)
        IF(K.GT.10)GOTO 154
        IF(FF(10).GT.X)FF(10)=X
        IF(FF(11).LT.X)FF(11)=X
        IF(FF(12).GT.Y)FF(12)=Y
        IF(FF(13).LT.Y)FF(13)=Y
        IF(FF(14).GT.Z)FF(14)=Z
        GOTO 150
 154    U=X-FF(10)
        V=Y-FF(12)
        IF(T.GT.0.)GOTO 155
        U=V
        V=FF(11)-X
 155    Q=200.*AINT(R*U+.5)+S*V+201.5
        MJ=MA+2
        L=MJ
 156    MJ=MJ-2
        IF(A(MJ).GT.Q)GOTO 156
        GOTO 158
 157    A(L+2)=A(L)
        A(L+3)=A(L+1)
 158    L=L-2
        IF(MJ.LT.L)GOTO 157
        A(MJ+2)=Q
        A(MJ+3)=REAL(I)
        IF(I.GT.LD)A(MJ+3)=A(I)
        MA=MA+2
        A(I+8)=(Z-FF(14))*ABS(T)
        GOTO 149
 159    IF(K.NE.7)GOTO 160
        FF(1)=FF(5)*FF(9)-FF(6)*FF(8)
        FF(2)=FF(6)*FF(7)-FF(4)*FF(9)
        FF(3)=FF(4)*FF(8)-FF(5)*FF(7)
 160    IF(K.NE.10)GOTO 161
        R=FF(13)-FF(12)
        S=FF(11)-FF(10)
        IF(AMIN1(R,S).LT.0.0001)GOTO 168
        T=AMIN1(1.,118./(HA*R),55./(HD*S))
        IF(T.LT.0.8)T=-AMIN1(1.,92./(HD*R),118./(HA*S))
        R=HD*ABS(T)
        S=HA*ABS(T)
 161    CONTINUE
C
C Plot atoms
C
      S=2.54*ABS(T)
      CALL SXPG(LI)
      WRITE(LI,19)NX,ABS(T),S
      M=0
      KR(1:120)=' '
      K=1
      I=N+9
 162  I=I+2
      IF(I.GT.MA)GOTO 167
      CALL SXCC
      NC=INT(A(I)*.005)
 163  IF(NC.EQ.M)GOTO 164
      WRITE(LI,1)KR(1:K)
      KR(1:K)=' '
      K=1
      M=M+1
      GOTO 163
 164  L=INT(A(I+1))
      IF(A(59).LT.0.)GOTO 165
      IF(AMOD(ABS(A(L+7)),100.).LT.0.4)GOTO 162
 165  NT=0
      CALL SXAN(L,IR,NT,LM,A)
      L=INT(AMOD(A(I),200.))
        DO 166 MJ=1,NT
        KK=IR(MJ:MJ)
        IF(KK.EQ.IH(20))GOTO 162
        IF(KR(L:L).NE.IH(20))KK=IH(21)
        KR(L:L)=KK
        IF(K.LT.L)K=L
        L=L+1
 166    CONTINUE
      GOTO 162
 167  WRITE(LI,1)KR(1:K)
      IF(M.GT.80)CALL SXPG(LI)
      GOTO 169
C
C Distances and angles
C
 168  WRITE(LI,20)NX
 169  WRITE(LI,21)
      I=LB+7
 170  I=I+9
      IF(I.GT.LD)GOTO 183
      IF(INT(.01*ABS(A(I+7))).NE.NX)GOTO 170
      CALL SXCC
      T=AMOD(ABS(A(I+7)),100.)+A(58)
      S=AMAX1(T,AMOD(ABS(A(I+7)),100.)+ABS(A(59)))
      IF(I.LE.LX)GOTO 171
      IF(A(I+6).LT.0.8)S=T
 171  MA=N+7
      NJ=LB+7
 172  NJ=NJ+9
      IF(NJ.GT.N)GOTO 179
      IF(INT(.01*ABS(A(NJ+7))).NE.NX)GOTO 172
      IF(NJ.EQ.I)GOTO 172
      X=A(I+2)-A(NJ+2)
      Y=A(I+3)-A(NJ+3)
      Z=A(I+4)-A(NJ+4)
      R=X**2*A(8)+Y**2*A(9)+Z**2*A(10)+Y*Z*A(11)+X*Z*A(12)+X*Y*A(13)
      IF(R.GT.(S+AMOD(ABS(A(NJ+7)),100.))**2)GOTO 172
      R=SQRT(R)
      RR=AMOD(ABS(A(NJ+7)),100.)
      IF(R.LT.T+RR)GOTO 175
      IF(NJ.LE.LX)GOTO 173
      IF(A(NJ+6).LT.0.8)GOTO 172
 173  L=LB+7
      IF(AMIN1(A(I+7),A(NJ+7)).LT.0.)GOTO 172
      IF(AMOD(A(I+7)+A(NJ+7),100.).LT.0.8)GOTO 172
 174  L=L+9
      IF(L.GT.LX)GOTO 175
      IF(INT(.01*ABS(A(L+7))).NE.NX)GOTO 174
      U=A(L+2)-A(I+2)
      V=A(L+3)-A(I+3)
      W=A(L+4)-A(I+4)
      RA=AMOD(ABS(A(L+7)),100.)
      IF(A(8)*U**2+A(9)*V**2+A(10)*W**2+V*W*A(11)+U*W*A(12)+
     +U*V*A(13).GT.(T+RA)**2)GOTO 174
      U=A(L+2)-A(NJ+2)
      V=A(L+3)-A(NJ+3)
      W=A(L+4)-A(NJ+4)
      IF(A(8)*U**2+A(9)*V**2+A(10)*W**2+V*W*A(11)+U*W*A(12)+
     +U*V*A(13).GT.(RA+RR+A(58))**2)GOTO 174
      GOTO 172
 175  L=MA+2
      K=L
 176  L=L-2
      IF(L.LT.N+8)GOTO 178
      IF(INT(A(L+1)).LE.LX)GOTO 178
      IF(A(L).GT.R)GOTO 176
      GOTO 178
 177  A(K+2)=A(K)
      A(K+3)=A(K+1)
 178  K=K-2
      IF(K.GT.L)GOTO 177
      A(L+2)=R
      A(L+3)=REAL(NJ)
      MA=MIN0(MA+2,N+47)
      GOTO 172
 179  NJ=N+7
      NT=0
      IR=' '
      CALL SXAN(I,IR,NT,LM,A)
      IF(MA.GT.N+7)GOTO 180
      WRITE(LI,22)IR(1:9),A(I+6),A(I+2),A(I+3),A(I+4),A(I+5)
      GOTO 170
 180  NJ=NJ+2
      IF(NJ.GT.MA)GOTO 170
      NB=N+7
      M=1
      FC(1)=A(NJ)
      NC=INT(A(NJ+1))
      K=MAX0(0,(NC-LD)/9)
      MF=NC
      IF(MF.GT.LD)MF=INT(A(NC))
      KR=' '
      NT=0
      CALL SXAN(MF,KR,NT,LM,A)
      IF(NJ.GT.N+9)GOTO 181
      WRITE(LI,22)IR(1:9),A(I+6),A(I+2),A(I+3),A(I+4),A(I+5),A(I+8),
     +K,KR(1:9),FC(1)
      GOTO 180
 181  NB=NB+2
      IF(NB.EQ.NJ)GOTO 182
      L=INT(A(NB+1))
      U=A(NC+2)-A(L+2)
      V=A(NC+3)-A(L+3)
      W=A(NC+4)-A(L+4)
      T=A(8)*U**2+A(9)*V**2+A(10)*W**2+V*W*A(11)+U*W*A(12)+U*V*A(13)
      S=(A(NJ)**2+A(NB)**2-T)/AMAX1(0.0001,2.*A(NJ)*A(NB))
      W=SQRT(ABS(1.-S**2))
      M=M+1
      FC(M)=ATAN2(W,S)*57.29578
      IF(M.LT.11)GOTO 181
 182  WRITE(LI,23)K,KR(1:9),(FC(L),L=1,M)
      GOTO 180
C
C Symmetry generated atoms
C
 183  M=0
      IF(N.EQ.LD)GOTO 134
      WRITE(LI,24)
      I=LD
 184  I=I+9
      IF(I.GT.N)GOTO 134
      CALL SXCC
      M=M+1
      K=INT(A(I))
      NJ=INT(A(I+6))
      L=INT(A(I+5))
      S=A(L)
      U=A(I+2)-S*(A(K+2)*A(NJ)+A(K+3)*A(NJ+1)+A(K+4)*A(NJ+2))
      V=A(I+3)-S*(A(K+2)*A(NJ+3)+A(K+3)*A(NJ+4)+A(K+4)*A(NJ+5))
      W=A(I+4)-S*(A(K+2)*A(NJ+6)+A(K+3)*A(NJ+7)+A(K+4)*A(NJ+8))
      KR(1:12)=' '
        DO 187 NB=1,9,4
        L=NB
          DO 186 NC=14,16
          T=S*A(NJ)
          IF(ABS(T).LT.0.5)GOTO 185
          KR(L:L)=IH(13)
          IF(T.LT.0.)KR(L:L)=IH(12)
          KR(L+1:L+1)=IH(NC)
          L=L+2
 185      NJ=NJ+1
 186      CONTINUE
 187    CONTINUE
      L=0
      IR=' '
      CALL SXAN(K,IR,L,LM,A)
      WRITE(LI,25)M,IR(1:9),A(I+2),A(I+3),A(I+4),A(I+8),
     +U,KR(1:4),V,KR(5:8),W,KR(9:12)
      GOTO 184
 188  N=0
      M=INT(ABS(A(73))+.1)
      IF(M.EQ.2)N=32
      IF(M.EQ.3)N=52
      IF(M.EQ.4)N=48
      IF(M.EQ.6)N=1
      IF(N.GT.0)WRITE(LZ,26)(IH(20),I=1,N),KD
      CALL SXIT
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXPN(X,N)
C
C Left justify integer as string and pack into one real
C
      CHARACTER*1 IH(50),KD
      CHARACTER*2 KA(94)
      CHARACTER*4 KS
      CHARACTER*76 IT
      CHARACTER*80 NM,IR
      COMMON/WORD/IH,IT,IR,NM,KA,KD
C
      KS=' '
      K=0
      L=IABS(N)
      M=1000
   1  IF(M.LE.L)GOTO 2
      M=M/10
      IF(M.GT.1)GOTO 1
   2  K=K+1
      I=MOD(L/M,10)
      KS(K:K)=IH(I+1)
      M=M/10
      IF(M.GT.0)GOTO 2
      CALL SXPS(X,KS)
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXAS(X,IS,L)
C
C Append character*4 string stored in real X to a string variable
C IS, eliminating blanks and updating the current length L of IS.
C
      CHARACTER*4 KT
      CHARACTER*(*)IS
      CALL SXUS(X,KT)
        DO 1 I=1,4
        IF(KT(I:I).EQ.' ')GOTO 1
        L=L+1
        IS(L:L)=KT(I:I)
   1    CONTINUE
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXAN(NQ,IS,L,LM,A)
C
C Append full atom name of atom starting in A(N) to a string variable
C IS, eliminating blanks and updating the current length L of IS.
C Append PART identifier (lower case letter) unless NQ negative.
C
      CHARACTER*4 KT
      CHARACTER*(*)IS
      REAL A(LM)
      N=IABS(NQ)
      NL=L
      K=N
      CALL SXUS(A(K+1),KT)
      IF(A(103).GT.-8.E9)GOTO 1
      CALL SXAS(A(N),IS,L)
      IF(KT(1:4).EQ.'0   ')GOTO 4
      I=0
      GOTO 3
   1  IF(KT.EQ.'    ')K=INT(A(N+3))
      M=INT(ABS(A(K+3)))
      CALL SXUS(A(M+13),KT)
      M=L
      CALL SXAS(A(N),IS,L)
      IF(KT(2:2).EQ.' ')GOTO 2
      IF(L.EQ.M+1)GOTO 2
      M=M+2
      IF(KT(2:2).EQ.IS(M:M))CALL SXLC(IS(M:M))
   2  CALL SXUS(A(K+1),KT)
      I=MAX0(0,INT(A(K+29)))
      IF(KT.NE.'0   ')GOTO 3
      IF(K.NE.N)GOTO 3
      IF(NQ.LT.0)GOTO 4
      IF(I.EQ.0)GOTO 4
   3  L=L+1
      IS(L:L)='_'
      IF(KT.NE.'0    ')CALL SXAS(A(K+1),IS,L)
      IF(K.NE.N)CALL SXAS(A(N+2),IS,L)
      IF(I.EQ.0)GOTO 4
      IF(NQ.LT.0)GOTO 4
      IF(L-NL.GT.12)GOTO 4
      L=L+1
      IS(L:L)=CHAR(ICHAR('a')+MIN0(I-1,25))
   4  RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXOP(KR,C,D,L)
C
C Generate symmetry operator as text string in KR(*:L).  The 3x3
C matrix and 3x1 vector in C are combined with a possible inversion
C [D(1)=+1 or -1] and lattice translation [+99.5 in D(2-4)].
C
      CHARACTER*128 KR
      REAL C(12),D(4)
      CHARACTER*1 KX(3)
      DATA KX/'x','y','z'/
C
      K=0
        DO 9 NI=2,4
        NL=L
          DO 3 M=1,3
          K=K+1
          P=C(K)*D(1)
          IF(P.GT.0.0001)GOTO 1
          IF(P.GT.-0.0001)GOTO 3
          KR(L+1:L+1)='-'
          L=L+1
          GOTO 2
   1      IF(L.EQ.NL)GOTO 2
          L=L+1
          KR(L:L)='+'
   2      L=L+1
          KR(L:L)=KX(M)
   3      CONTINUE
        NT=INT((D(NI)+D(1)*C(NI+8)-99.5)*48.1)
        KR(L+1:L+1)='+'
        IF(NT.GT.0)GOTO 4
        IF(NT.EQ.0)GOTO 8
        KR(L+1:L+1)='-'
   4    L=L+1
        M=48
   5    IF(MOD(NT,2).NE.0)GOTO 6
        IF(MOD(M,2).NE.0)GOTO 6
        M=M/2
        NT=NT/2
        IF(NT.NE.0)GOTO 5
   6    IF(MOD(NT,3).NE.0)GOTO 7
        IF(MOD(M,3).NE.0)GOTO 7
        M=M/3
        NT=NT/3
        IF(NT.NE.0)GOTO 6
   7    CALL SXPN(P,NT)
        CALL SXAS(P,KR,L)
        IF(M.EQ.1)GOTO 8
        L=L+1
        KR(L:L)='/'
        CALL SXPN(P,M)
        CALL SXAS(P,KR,L)
   8    L=L+2
        KR(L-1:L)=', '
   9    CONTINUE
      L=L-2
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXLP(KR,L)
C
C Outputs a record to logical unit L with blanks stripped and
C terminator KD appended (unless KD is a space).
C
      CHARACTER*1 IH(50),KD
      CHARACTER*2 KA(94)
      CHARACTER*76 IT
      CHARACTER*80 NM,IR,KR
      COMMON/WORD/IH,IT,IR,NM,KA,KD
   1  FORMAT(A)
C
      M=1
        DO 2 I=1,80
        IF(KR(I:I).NE.IH(20))M=I
   2    CONTINUE
      IF(KD.EQ.' ')GOTO 3
      WRITE(L,1)KR(1:M)//KD
      GOTO 4
   3  WRITE(L,1)KR(1:M)
   4  RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXDX(NN,DX,DY,DZ,IX,IY,IZ,NX,NY,NZ,LM,A)
C
C Set partial derivatives DX(1..9),DY(1..9),DZ(1..9) and parameter
C numbers IX(1..9),IY(1..9),IZ(1..9) for x, y and z of atom NN
C (which may point to a symmetry equivalent generated using EQIV).
C NX,NY,NZ are the highest elements of DX etc. used (no zero elements
C are generated in IX,IY,IZ).  EXYZ is also taken into account, and
C AFIX 3, 4, 7 or 8 atoms may ride on rigid group atoms.
C
      INTEGER IX(9),IY(9),IZ(9)
      REAL A(LM),DX(9),DY(9),DZ(9),PY(9),PZ(9)
      COMMON/MEM/ST,SL,TC,TL,IV,LR,LG,LH,LI,LP,LF,LA,LC,LW,LY,LL,LB,
     +LX,LE,LV,LJ,LD,LS,LO,LT,LK,LQ,LZ,LN,KH,JA,JB,JC,JD,JE,HA,HD
C
      NX=0
      NY=0
      NZ=0
      N=NN
      IF(NN.GT.LX)N=INT(A(NN+3))
      L=INT(A(N+5))
      IF(L.GT.0)N=L
      IF(AMOD(A(N+5),.2).LT.0.05)GOTO 28
      IF(MOD(INT(ABS(A(N+6))),10).EQ.1)GOTO 28
      NI=INT(A(N+30))
      NL=INT(A(N+28))
      IF(NL.EQ.0)GOTO 6
      NA=INT(10.*AMOD(A(N+28),1.))
      IF(NA.NE.0)GOTO 2
   1  NI=INT(A(NL+30))
      NA=INT(10.*AMOD(A(NL+28),1.))
      NL=INT(A(NL+28))
   2  N=NL
      NS=0
      NG=0
      NT=0
      IF(NA.EQ.1)GOTO 3
      IF(NA.LT.4)NS=NI
      IF(NA.EQ.3)NT=NI-1
      IF(NA.EQ.4)NT=NI
   3  NI=INT(A(N+30))
      IF(NA.GT.4)NG=NI-2
      IF(NA.EQ.6)NS=NG-1
C
C Riding or rigid group motion along vector to pivot atom
C
      IF(NS.EQ.0)GOTO 4
      U=1.
      IF(NG.EQ.0)U=10.
      NX=NX+1
      IX(NX)=NS
      DX(NX)=U*(A(NN+17)-A(N+17))
      NY=NY+1
      IY(NY)=NS
      DY(NY)=U*(A(NN+18)-A(N+18))
      NZ=NZ+1
      IZ(NZ)=NS
      DZ(NZ)=U*(A(NN+19)-A(N+19))
C
C Tangential motion
C
   4  IF(NG+NT.EQ.0)GOTO 5
      Y=A(NN+18)-A(N+18)
      Z=A(NN+19)-A(N+19)
      U=A(94)*(A(NN+17)-A(N+17))+A(95)*Y+A(96)*Z
      V=A(97)*Y+A(98)*Z
      W=A(99)*Z
      IF(NT.EQ.0)GOTO 5
      K=INT(A(N+4))
      IF(K.LE.0)GOTO 5
      K=INT(-A(K+1))
      IF(K.LE.0)GOTO 5
      Y=A(K+18)-A(N+18)
      Z=A(K+19)-A(N+19)
      P=A(94)*(A(K+17)-A(N+17))+A(95)*Y+A(96)*Z
      Q=A(97)*Y+A(98)*Z
      R=A(99)*Z
      X=V*R-W*Q
      Y=W*P-U*R
      Z=U*Q-V*P
      R=0.1*SQRT(X**2+Y**2+Z**2)
      IF(R.LT.0.0001)GOTO 5
      NX=NX+1
      IX(NX)=NT
      DX(NX)=(X*A(171)+Y*A(172)+Z*A(173))/R
      NY=NY+1
      IY(NY)=NT
      DY(NY)=(Y*A(174)+Z*A(175))/R
      NZ=NZ+1
      IZ(NZ)=NT
      DZ(NZ)=Z*A(176)/R
C
C Rigid group rotations
C
   5  IF(A(N+28).GT.1.)GOTO 1
      IF(NG.EQ.0)GOTO 6
      NX=NX+1
      IX(NX)=NG
      DX(NX)=-W*A(172)+V*A(173)
      NY=NY+1
      IY(NY)=NG
      DY(NY)=-W*A(174)+V*A(175)
      NZ=NZ+1
      IZ(NZ)=NG
      DZ(NZ)=V*A(176)
      NG=NG+1
      NX=NX+1
      IX(NX)=NG
      DX(NX)=W*A(171)-U*A(173)
      NY=NY+1
      IY(NY)=NG
      DY(NY)=-U*A(175)
      NZ=NZ+1
      IZ(NZ)=NG
      DZ(NZ)=-U*A(176)
      NG=NG+1
      NX=NX+1
      IX(NX)=NG
      DX(NX)=-V*A(171)+U*A(172)
      NY=NY+1
      IY(NY)=NG
      DY(NY)=U*A(174)
C
C xyz parameters
C
   6    DO 13 I=N+7,N+9
        IF(A(I).GE.1.E6)GOTO 7
        M=INT((ABS(A(I))+5.)*.1)
        IF(M.EQ.1)GOTO 13
        T=AMOD(A(I)+5.,10.)-10.*SIGN(.5,A(I)+5.)
        IF(M.NE.0)GOTO 10
        T=1.
        NI=NI+1
        M=NI
        GOTO 10
   7    M=MOD(INT(1.E-6*A(I)+.5),10)
        IF(M.LT.1)GOTO 13
        IF(M.NE.1)GOTO 8
        T=DX(1)
        M=IX(1)
        GOTO 9
   8    T=DY(1)
        M=IY(1)
   9    T=T*(AINT(1.E-7*A(I)+.05)*.5-2.5)
  10    IF(I.NE.N+7)GOTO 11
        NX=NX+1
        IX(NX)=M
        DX(NX)=T
        GOTO 13
  11    IF(I.NE.N+8)GOTO 12
        NY=NY+1
        IY(NY)=M
        DY(NY)=T
        GOTO 13
  12    NZ=NZ+1
        IZ(NZ)=M
        DZ(NZ)=T
  13    CONTINUE
C
C Equivalent atom transformation
C
      IF(NN.LE.LX)GOTO 28
      MM=NX
        DO 14 I=1,7
        PY(I)=0.
        PZ(I)=0.
  14    CONTINUE
        DO 20 I=1,NX
        L=0
  15    L=L+1
  16    IF(L.GT.NY)GOTO 17
        IF(IY(L).NE.IX(I))GOTO 15
        PY(I)=DY(L)
        IY(I)=IY(NY)
        DY(L)=DY(NY)
        NY=NY-1
        GOTO 16
  17    L=0
  18    L=L+1
  19    IF(L.GT.NZ)GOTO 20
        IF(IZ(L).NE.IX(I))GOTO 18
        PZ(I)=DZ(L)
        IZ(L)=IZ(NZ)
        DZ(L)=DZ(NZ)
        NZ=NZ-1
        GOTO 19
  20    CONTINUE
        DO 23 I=1,NY
        MM=MM+1
        IX(MM)=IY(I)
        PY(MM)=DY(I)
        DX(MM)=0.
        L=0
  21    L=L+1
  22    IF(L.GT.NZ)GOTO 23
        IF(IZ(L).NE.IX(MM))GOTO 21
        PZ(MM)=DZ(L)
        DZ(L)=DZ(NZ)
        IZ(L)=IZ(NZ)
        NZ=NZ-1
        GOTO 22
  23    CONTINUE
        DO 24 I=1,NZ
        MM=MM+1
        IX(MM)=IZ(I)
        DX(MM)=0.
        PZ(MM)=DZ(I)
  24    CONTINUE
      NX=0
      NY=0
      NZ=0
        DO 27 I=1,MM
        T=A(NN+11)*DX(I)+A(NN+12)*PY(I)+A(NN+13)*PZ(I)
        IF(ABS(T).LT.1.E-6)GOTO 25
        NZ=NZ+1
        IZ(NZ)=IX(I)
        DZ(NZ)=T
  25    T=A(NN+8)*DX(I)+A(NN+9)*PY(I)+A(NN+10)*PZ(I)
        IF(ABS(T).LT.1.E-6)GOTO 26
        NY=NY+1
        IY(NY)=IX(I)
        DY(NY)=T
  26    T=A(NN+5)*DX(I)+A(NN+6)*PY(I)+A(NN+7)*PZ(I)
        IF(ABS(T).LT.1.E-6)GOTO 27
        NX=NX+1
        IX(NX)=IX(I)
        DX(NX)=T
  27    CONTINUE
  28  RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXDU(NN,D,IP,N,LM,A)
C
C Set partial derivatives D and parameter numbers IP for sof..U12 of
C atom NN (which may not be a symmetry equivalent).  N is the highest
C element of D, IP actually used (zero elements should be skipped).
C EADP is taken into account.
C
      INTEGER IP(7)
      REAL A(LM),D(7)
C
      N=0
        DO 1 I=1,7
        IP(I)=0
        D(I)=0.
   1    CONTINUE
      IF(AMOD(A(NN+5),1.).LT.0.15)GOTO 14
      NI=MOD(INT(ABS(A(NN+6))),10)
      IF(NI.EQ.1)GOTO 14
      IF(NI.EQ.2)GOTO 14
      NI=INT(A(NN+30))
      NT=NN+11
      IF(A(NN+3).LT.0.)NT=NN+16
      IF(ABS(A(NN+31)).GE.1.)NT=NN+10
      IF(A(NN+5).GE.1.)GOTO 3
      IF(A(NN+28).GT.1.)GOTO 3
      IF(AMOD(A(NN+5),.2).LT.0.05)GOTO 3
        DO 2 I=NN+7,NN+9
        IF(ABS(A(I)).LT.5.)NI=NI+1
   2    CONTINUE
   3  K=0
        DO 7 I=NN+10,NT
        K=K+1
        IF(A(I).GE.1.E6)GOTO 5
        M=INT((ABS(A(I))+5.)*.1)
        IF(M.EQ.1)GOTO 7
        IF(I.NE.NN+11)GOTO 4
        IF(A(I).LT.-.5)GOTO 7
   4    D(K)=AMOD(A(I)+5.,10.)-10.*SIGN(.5,A(I)+5.)
        IP(K)=M
        IF(M.NE.0)GOTO 6
        NI=NI+1
        IP(K)=NI
        D(K)=1.
        GOTO 6
   5    M=MOD(INT(1.E-6*A(I)+.5),10)-3
        IF(M.LT.1)GOTO 7
        D(K)=(AINT(1.E-7*A(I)+.05)*.5-2.5)*D(M)
        IP(K)=IP(M)
   6    N=K
   7    CONTINUE
C
C EADP cross-reference
C
      L=INT(ABS(A(NN+31)))
      IF(L.LT.1)GOTO 14
      IF(AMOD(A(L+5),1.).LT.0.15)GOTO 14
      NI=MOD(INT(ABS(A(L+6))),10)
      IF(NI.EQ.1)GOTO 14
      IF(NI.EQ.2)GOTO 14
      NI=INT(A(L+30))
      NT=L+11
      IF(A(L+3).LT.0.)NT=L+16
      IF(A(L+5).GE.1.)GOTO 9
      IF(A(L+28).GT.1.)GOTO 9
        DO 8 I=L+7,L+9
        IF(ABS(A(I)).LT.5.)NI=NI+1
   8    CONTINUE
   9    DO 13 I=L+11,NT
        K=K+1
        IF(A(I).GE.1.E6)GOTO 11
        M=INT((ABS(A(I))+5.)*.1)
        IF(M.EQ.1)GOTO 13
        IF(I.NE.L+11)GOTO 10
        IF(A(I).LT.-.5)GOTO 13
  10    D(K)=AMOD(A(I)+5.,10.)-10.*SIGN(.5,A(I)+5.)
        IP(K)=M
        IF(M.NE.0)GOTO 12
        NI=NI+1
        IP(K)=NI
        D(K)=1.
        GOTO 12
  11    M=MOD(INT(1.E-6*A(I)+.5),10)-3
        IF(M.LT.1)GOTO 13
        D(K)=(AINT(1.E-7*A(I)+.05)*.5-2.5)*D(M)
        IP(K)=IP(M)
  12    N=K
  13    CONTINUE
  14  RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXSW(C,D,NT,LM,A)
C
C Output warning if SAME/SADI sfac type mismatch
C
      CHARACTER*1 IH(50),KD
      CHARACTER*2 KA(94)
      CHARACTER*76 IT
      CHARACTER*80 NM,IR
      INTEGER IN(4),IX(4)
      REAL A(LM),C(2),D(2)
      COMMON/MEM/ST,SL,TC,TL,IV,LR,LG,LH,LI,LP,LF,LA,LC,LW,LY,LL,LB,
     +LX,LE,LV,LJ,LD,LS,LO,LT,LK,LQ,LZ,LN,KH,JA,JB,JC,JD,JE,HA,HD
      COMMON/WORD/IH,IT,IR,NM,KA,KD
C
   1  FORMAT('   ** SAME/SADI sfac type mismatch **')
   2  FORMAT(/' ** SAME/SADI sfac type mismatch for',A,' **')
C
      IN(1)=INT(C(1))
      IN(2)=INT(C(2))
      IN(3)=INT(D(1))
      IN(4)=INT(D(2))
        DO 3 I=1,4
        K=IN(I)
        IF(K.GT.LX)K=INT(A(K+3))
        IX(I)=INT(ABS(A(K+3)))
   3    CONTINUE
      IF(IABS(IX(1)-IX(3))+IABS(IX(2)-IX(4)).EQ.0)GOTO 5
      IF(IABS(IX(2)-IX(3))+IABS(IX(1)-IX(4)).EQ.0)GOTO 5
      IR=' '
      L=0
        DO 4 I=1,4
        L=L+1
        CALL SXAN(IN(I),IR,L,LM,A)
   4    CONTINUE
      IF(NT.EQ.0)WRITE(*,1)
      CALL SXFL
      NT=1
      WRITE(LI,2)IR(1:L)
   5  RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXWF(RF,RT,LU,MH,MK,ML,MB,FF,SI,SQ,WL)
C
C Write one block of sorted reflection data to unit LF.  First test for
C incomplete sets and flag any prime reflections needed for R(free).
C
      INTEGER MH(LU),MK(LU),ML(LU),MB(LU)
      REAL FF(LU),SI(LU),SQ(LU),WL(LU)
      COMMON/MEM/ST,SL,TC,TL,IV,LR,LG,LH,LI,LP,LF,LA,LC,LW,LY,LL,LB,
     +LX,LE,LV,LJ,LD,LS,LO,LT,LK,LQ,LZ,LN,KH,JA,JB,JC,JD,JE,HA,HD
C
      MB(LU)=1
      IF(LG.LT.LU)MB(LU)=0
      MH(LU)=0
      MK(LU)=0
      ML(LU)=0
      N=LG
      IF(LG.EQ.1)GOTO 25
      NK=0
      K=0
   1  N=N-1
      IF(N.LE.0)CALL SXER('LAST REFLECTION MUST HAVE POSITIVE M')
      IF(MB(N).LE.0)GOTO 1
      IF(RT.GT.-1.5)GOTO 3
   2  K=K+1
      IF(K.GT.N)GOTO 3
      IF(MB(K).LT.0)GOTO 2
      RF=RF+1.
      IF(ABS(RF).GT.0.5)GOTO 2
      RF=RT
      IF(WL(K).LT.0.)GOTO 2
      SQ(K)=-SQ(K)
      WL(K)=-ABS(WL(K))
      GOTO 2
C
C Find next two sets which should be exchanged
C
   3  MI=1
      MJ=N+1
      NI=MI
   4  IF(MB(NI).GE.0)GOTO 5
      NI=NI+1
      GOTO 4
   5  IF(WL(NI).LT.0.)GOTO 7
   6  MI=NI+1
      IF(MI.GE.MJ)GOTO 21
      NI=MI
      GOTO 4
   7  NJ=MJ-1
      IF(NJ.LE.NI)GOTO 21
      MJ=NJ
   8  IF(MB(MJ-1).GE.0)GOTO 9
      MJ=MJ-1
      GOTO 8
   9  IF(WL(NJ).LT.0.)GOTO 7
C
C Swap sets if same number of reflections in each
C
      IF(NI-MI.NE.NJ-MJ)GOTO 11
      K=MJ
        DO 10 I=MI,NI
        T=WL(I)
        WL(I)=WL(K)
        WL(K)=T
        T=SQ(I)
        SQ(I)=SQ(K)
        SQ(K)=T
        T=SI(I)
        SI(I)=SI(K)
        SI(K)=T
        T=FF(I)
        FF(I)=FF(K)
        FF(K)=T
        L=MB(I)
        MB(I)=MB(K)
        MB(K)=L
        L=ML(I)
        ML(I)=ML(K)
        ML(K)=L
        L=MK(I)
        MK(I)=MK(K)
        MK(K)=L
        L=MH(I)
        MH(I)=MH(K)
        MH(K)=L
        K=K+1
  10    CONTINUE
      GOTO 6
C
C Otherwise perform cyclic shuffle (slower)
C
  11    DO 20 M=MI,NI
        T=WL(MI)
          DO 12 I=MI+1,NJ
          WL(I-1)=WL(I)
  12      CONTINUE
        WL(NJ)=T
        T=SQ(MI)
          DO 13 I=MI+1,NJ
          SQ(I-1)=SQ(I)
  13      CONTINUE
        SQ(NJ)=T
        T=SI(MI)
          DO 14 I=MI+1,NJ
          SI(I-1)=SI(I)
  14      CONTINUE
        SI(NJ)=T
        T=FF(MI)
          DO 15 I=MI+1,NJ
          FF(I-1)=FF(I)
  15      CONTINUE
        FF(NJ)=T
        L=MB(MI)
          DO 16 I=MI+1,NJ
          MB(I-1)=MB(I)
  16      CONTINUE
        MB(NJ)=L
        L=ML(MI)
          DO 17 I=MI+1,NJ
          ML(I-1)=ML(I)
  17      CONTINUE
        ML(NJ)=L
        L=MK(MI)
          DO 18 I=MI+1,NJ
          MK(I-1)=MK(I)
  18      CONTINUE
        MK(NJ)=L
        L=MH(MI)
          DO 19 I=MI+1,NJ
          MH(I-1)=MH(I)
  19      CONTINUE
        MH(NJ)=L
  20    CONTINUE
      MJ=NJ-NI+MI
      GOTO 4
C
C Recycle for R(free)
C
  21  IF(NK.GT.0)GOTO 23
      MK(LU)=MI-1
      MH(LU)=N
      IF(RT.GT.-0.5)GOTO 23
      NK=1
      MJ=N+1
        DO 22 I=MI,N
        IF(SQ(I).LT.0.)WL(I)=ABS(WL(I))
        SQ(I)=ABS(SQ(I))
  22    CONTINUE
      GOTO 5
C
C Write to file and shuffle up partial set
C
  23  ML(LU)=MI-1
        DO 24 I=MI,N
        WL(I)=ABS(WL(I))
  24    CONTINUE
  25  WRITE(LF)MB,MH,MK,ML,FF,SI,SQ,WL
      M=LG
      LG=0
  26  LG=LG+1
      N=N+1
      IF(N.GE.M)GOTO 27
      WL(LG)=WL(N)
      SQ(LG)=SQ(N)
      SI(LG)=SI(N)
      FF(LG)=FF(N)
      MB(LG)=MB(N)
      ML(LG)=ML(N)
      MK(LG)=MK(N)
      MH(LG)=MH(N)
      GOTO 26
  27  RETURN
      END
C
C -----------------------------------------------------------
C
      SUBROUTINE SXBB(F,IR,NN,NB,N,NS,LM,A)
C
C Report bad connectivity for hydrogen generation
C
      CHARACTER*80 IR
      REAL A(LM),F(36)
      COMMON/MEM/ST,SL,TC,TL,IV,LR,LG,LH,LI,LP,LF,LA,LC,LW,LY,LL,LB,
     +LX,LE,LV,LJ,LD,LS,LO,LT,LK,LQ,LZ,LN,KH,JA,JB,JC,JD,JE,HA,HD
C
   1  FORMAT(///' Idealized hydrogen atom generation before cycle',
     +I4//' Name     x       y       z    AFIX  d(X-H)  shift  ',
     +'Bonded to  Conformation determined by')
   2  FORMAT(/' ** Bond(s) to',A,'ignored in idealizing H-atoms ',
     +'attached to  ',A,' **'/)
C
      IF(NS.EQ.0)GOTO 4
      IF(NS.LT.1)WRITE(LI,1)LK
      NS=IABS(NS)
      L=18
      IR(17:18)='  '
        DO 3 I=N+5,NB,5
        K=INT(F(I))
        CALL SXAN(K,IR,L,LM,A)
        L=L+2
        IR(L-1:L)=' '
   3    CONTINUE
      M=L
      CALL SXAN(NN,IR,L,LM,A)
      WRITE(LI,2)IR(17:M),IR(M+1:L)
   4  NB=N
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXIM(LI,NP,LK,LO,LM,JW,A,B)
C
C Calculate shifts and covariance matrix.
C
      REAL A(LM),B(JW)
C
   1  FORMAT(/' Shifts scaled down to reduce maximum shift/esd ',
     +'from',F8.2,'  to',F8.2)
C
      P=0.001*(1000.+A(72))
      Q=1.E-6*A(169)
      J=NP
      JT=J*6
      IF(A(177).LT.0.)GOTO 10
      SF=.75
      JT=(J*(J+3))/2
      CALL SXCA(B(1),B(JT+1),NP)
      JK=0
      J=NP+1
        DO 3 NI=1,NP
        CALL SXCC
        JK=JK+2
        JI=J-1
        JJ=J+1
        B(J)=1./AMAX1(B(J)*P,Q)
        IF(NI.EQ.NP)GOTO 3
        T=-B(J)
        L=J-JK
        CALL SXSS(B(JK),B(JJ),T,L)
        JJ=JJ+L
        JK=J
   2    JL=J+NI-NP
        J=J+1
        IF(JL.GT.JI)GOTO 3
        T=B(J)
        L=JI-JL+1
        CALL SXSV(B(JJ),B(JL),T,L)
        JJ=JJ+L
        GOTO 2
   3    CONTINUE
        DO 6 NI=2,NP
        CALL SXCC
        J=JK
        JJ=JK-NI
        JL=JJ-1
        JI=JJ+1
        JK=JI-NI
        L=J-JI
        CALL SXZA(B(JI),L)
   4    JJ=JJ+1
        S=B(JK)
        T=B(JJ)+B(J)*S
        JN=JK+1
        IF(JN.GT.JL)GOTO 5
        L=JL-JK
        CALL SXPV(B(JJ+1),B(J+1),B(JN),S,T,L)
        JN=JN+L
        J=J+L
   5    B(JN)=S*T+B(JN)
        B(JJ)=T
        J=J+1
        JK=JK+1
        IF(JL.GE.JK)GOTO 4
   6    CONTINUE
      CALL SXZA(B(1),NP)
      JL=NP+1
        DO 7 I=1,NP
        S=B(JT+I)
        T=-S*B(JL)
        L=NP-I+1
        CALL SXPV(B(I),B(JL),B(JT+I),S,T,L)
        B(I)=T+B(I)
        JL=JL+L
   7    CONTINUE
      S=1.E-8
      JL=NP+1
        DO 8 I=1,NP
        S=AMAX1(S,ABS(B(I))/AMAX1(1.E-6,A(131)*SQRT(AMAX1(0.,B(JL)))))
        JL=JL+NP-I+1
   8    CONTINUE
      IF(S.LE.A(170))GOTO 11
      WRITE(LI,1)S,A(170)
      S=A(170)/S
        DO 9 I=1,NP
        B(I)=B(I)*S
   9    CONTINUE
      GOTO 11
  10  CALL SXCG(LI,NP,Q,JW,B)
      SF=.75*A(72)
  11  IF(LO+NP.GT.LM)GOTO 13
      IF(A(103).GT.0.5)GOTO 13
      IF(LK.GT.1)GOTO 15
      L=LO
        DO 12 I=1,NP
        L=L+1
        A(L)=B(I)
  12    CONTINUE
  13    DO 14 I=1,NP
        B(I)=B(I)*SF
  14    CONTINUE
      GOTO 20
  15  L=LO
      IF(A(177).GT.0.)GOTO 17
      U=0.
      V=0.
      W=0.
      R=0.
      JK=4*NP
        DO 16 J=1,NP
        S=B(J+JK)**2
        L=L+1
        U=U+A(L)**2/S
        V=V+A(L)*B(J)/S
        W=W+B(J)**2/S
        R=R+S*B(JT+J)**2
  16    CONTINUE
      L=L-NP
      A(72)=AMIN1(1.,AMAX1(.1,A(72)*(1.+0.3*V/U)))
      SF=.75*A(72)
  17  Q=SF/3.
        DO 18 J=1,NP
        L=L+1
        T=SIGN(AMIN1(ABS(A(L)),ABS(B(J))),A(L))
        A(L)=B(J)
        B(J)=SF*B(J)+Q*T
  18    CONTINUE
      IF(A(177).GT.0.)GOTO 20
      IF(ABS(A(51)).LT.1.5)GOTO 20
      IF(AMIN1(U,W).LE.0.)GOTO 20
      V=V/SQRT(U*W)
      U=SQRT(W/U)
      R=SQRT(R/REAL(NP))
      WRITE(*,19)A(72),U,V,R
      CALL SXFL
      WRITE(LI,19)A(72),U,V,R
  19  FORMAT(' DAMP =',F6.3,'  Shift ratio =',F6.3,'  Shift ',
     +'corr.=',F7.3,'  Mean grad.=',E10.3)
  20  RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXSD(D,IP,R,E,NP,N,JW,B)
C
C Calculate esd E of a derived parameter given an array D(1..N) of
C its partial derivatives in terms of refined parameters which are
C numbered in IP(1..N).  R is Sqrt[sigma(w*del**2)/(n-p)] and NP is
C the number of l.s. parameters.
C
      INTEGER IP(N)
      REAL D(N),B(JW)
C
      Q=0.
        DO 3 I=1,N
        T=1.
          DO 2 K=I,N
          JI=MIN0(IP(I),IP(K))
          IF(JI.LT.1)GOTO 1
          JK=MAX0(IP(I),IP(K))
          J=JK+(JI*(2*NP-JI+1))/2
          Q=Q+T*D(I)*D(K)*B(J)
   1      T=2.
   2      CONTINUE
   3    CONTINUE
      E=R*SQRT(ABS(Q))
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXAM(D,IP,R,S,JR,N,JE,JW,B)
C
C Add a restraint, for which the partial derivatives and parameter
C numbers are stored in D(1..N) and IP(1..N), to the l.s. vector
C starting at B(1) and matrix starting at B(JR+1).  R is
C (Sigma(w*del**2)/(n-p))/esd(y)**2 and S is y(calc)-y(target).
C
      INTEGER IP(N)
      REAL D(N),B(JW)
C
      IF(N.EQ.0)GOTO 5
      IF(JE.GT.0)GOTO 3
        DO 2 I=1,N
        JK=IP(I)
        Q=R*D(I)
        B(JK)=B(JK)-Q*S
          DO 1 K=I,N
          JI=MIN0(IP(I),IP(K))
          JK=MAX0(IP(I),IP(K))
          J=JK+(JI*(2*JR-JI+1))/2
          B(J)=B(J)+Q*D(K)
   1      CONTINUE
   2    CONTINUE
      GOTO 5
   3  J=JE
      JE=JE+2*N+1
      IF(JE.GT.JW)CALL SXER('ARRAY B TOO SMALL TO STORE RESTRAINTS')
      B(J)=REAL(N)+0.1
      B(JE)=0.
      T=SQRT(R)
        DO 4 I=1,N
        JK=IP(I)
        B(JK)=B(JK)-R*S*D(I)
        J=J+1
        B(J)=REAL(JK)+0.1
        B(J+N)=T*D(I)
   4    CONTINUE
   5  RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXDD(D,IP,DX,IX,U,N,NX,NP)
C
C Combine partial derivatives with those for atoms
C
      REAL D(NP),DX(9)
      INTEGER IP(NP),IX(9)
C
        DO 3 I=1,NX
        IF(ABS(DX(I)).LT.0.0001)GOTO 3
          DO 1 M=1,N
          IF(IX(I).EQ.IP(M))GOTO 2
   1      CONTINUE
        N=N+1
        M=N
        IP(M)=IX(I)
        D(M)=0.
   2    D(M)=D(M)+U*DX(I)
        IF(ABS(D(M)).GT.0.0001)GOTO 3
        D(M)=D(N)
        IP(M)=IP(N)
        N=N-1
   3    CONTINUE
      RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXCF(IR,X,S,N,L)
C
C Puts X with esd S into string IR starting at position L+2; on
C return L points last non-blank character in the string.  N is the
C number of decimal places (the program adds one or two more if need
C be).  S is given as an integer in brackets in units of the least
C significant figure.  If S is negative or zero, no esd is given.
C If N is negative, the esd is rounded according to the 'rule of 19'
C as required for CIF files submitted to Acta Cryst.
C
      CHARACTER*16 KT
      CHARACTER*31 KR
      CHARACTER*80 IR
C
      KT='(F20.0,A1,I9,A1)'
      M=IABS(N)
      T=AMAX1(S,0.)
        DO 1 I=1,M
        T=10.*T
   1    CONTINUE
      K=20
      IF(T.LT.0.001)GOTO 4
      NL=2
      IF(N.GT.0)GOTO 2
      NL=NL-N
      M=0
      T=AMAX1(S,0.)
   2  K=31
        DO 3 I=1,NL
        IF(T.GT.1.950001)GOTO 3
        T=T*10.
        M=M+1
   3    CONTINUE
   4  KT(6:6)=CHAR(M+48)
      WRITE(KR,KT)X,CHAR(40),INT(T+0.5),CHAR(41)
      I=INDEX(KR,' .')
      IF(I.GT.0)KR(I:I+1)='0.'
      I=INDEX(KR,'-.')
      IF(I.GT.0)KR(I-1:I+1)='-0.'
      IF(KR(20:20).EQ.'.')KR(20:20)=' '
      L=L+1
      IR(L:L)=' '
      I=0
   5  I=I+1
      IF(I.GT.K)GOTO 6
      IF(KR(I:I).EQ.' ')GOTO 5
      L=L+1
      IR(L:L)=KR(I:I)
      IF(KR(I:I).NE.CHAR(41))GOTO 5
   6  RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXSO(NN,KR,L,LM,A)
C
C Generate _site_symmetry according to CIF rules for atom starting
C at A(NN).  A blank character precedes the string in KR(*:L).
C
      CHARACTER*4 KT
      CHARACTER*80 KR
      REAL A(LM)
      COMMON/MEM/ST,SL,TC,TL,IV,LR,LG,LH,LI,LP,LF,LA,LC,LW,LY,LL,LB,
     +LX,LE,LV,LJ,LD,LS,LO,LT,LK,LQ,LZ,LN,KH,JA,JB,JC,JD,JE,HA,HD
C
   1  FORMAT(I4)
C
      L=L+1
      KR(L:L)=' '
      IF(NN.GT.LX)GOTO 2
      L=L+1
      KR(L:L)='.'
      GOTO 8
   2  NI=NN+13
      NJ=0
        DO 7 M=LY+12,LL,4
          DO 6 K=201,LY,12
          NJ=NJ+1
          NK=K
            DO 3 I=NN+5,NI
            IF(ABS(A(NK)*A(M)-A(I)).GT.0.1)GOTO 6
            NK=NK+1
   3        CONTINUE
          WRITE(KT,1)NJ
          NL=L
            DO 4 I=1,4
            IF(KT(I:I).EQ.' ')GOTO 4
            NL=NL+1
            KR(NL:NL)=KT(I:I)
   4        CONTINUE
          NL=NL+1
          KR(NL:NL)='_'
          NM=M
            DO 5 I=NI+1,NI+3
            NM=NM+1
            X=1.0001*(A(I)-A(NK)*A(M)-A(NM)+99.5)
            IF(AMOD(ABS(X),1.).GT.0.01)GOTO 6
            NK=NK+1
            NL=NL+1
            KR(NL:NL)=CHAR(53+INT(X))
   5        CONTINUE
          L=NL
          IF(KR(L-2:L).EQ.'555')L=L-4
          GOTO 8
   6      CONTINUE
   7    CONTINUE
      L=L+1
      KR(L:L)='?'
   8  RETURN
      END
C
C ------------------------------------------------------------
C
      SUBROUTINE SXHT(LM,LU,A,MB,MH,MK,ML,FF,SI,SQ,FB,FC)
C
C Analyse hydrogen bonds
C
      CHARACTER*1 KS
      CHARACTER*4 KT
      CHARACTER*128 KR
      INTEGER MH(LU),MK(LU),ML(LU),MB(LU)
      REAL FF(LU),SI(LU),FC(LU),SQ(LU),FB(LU),A(LM)
      COMMON/MEM/ST,SL,TC,TL,IV,LR,LG,LH,LI,LP,LF,LA,LC,LW,LY,LL,LB,
     +LX,LE,LV,LJ,LD,LS,LO,LT,LK,LQ,LZ,LN,KH,JA,JB,JC,JD,JE,HA,HD
C
   1  FORMAT(//' Hydrogen bonds with  H..A < r(A) +',F6.3,
     +' Angstroms  and  <DHA > 110 deg.'//
     +' D-H',11X,'d(D-H)   d(H..A)   <DHA    d(D..A)   A')
   2  FORMAT(1X,A)
C
C Find hydrogens and electronegative atoms in their environments
C
      CALL SXTO(23)
      NE=0
      NN=LB-16
   3  NN=NN+32
      IF(NN.GT.LX)GOTO 33
      IF(INT(ABS(A(NN+3))).NE.KH)GOTO 3
      NP=INT(ABS(A(NN+29)))
      X=A(NN+17)
      Y=A(NN+18)
      Z=A(NN+19)
      M=1
      SQ(1)=-9.E9
      N=LB-16
   4  N=N+32
      IF(N.GT.LX)GOTO 13
      IF(N.EQ.NN)GOTO 4
      K=INT(ABS(A(N+3)))
      CALL SXUS(A(K+13),KT)
      IF(K.EQ.KH)GOTO 5
      IF(KT.NE.'O   '.AND.KT.NE.'N   '.AND.KT.NE.'S   '.AND.
     +KT.NE.'F   '.AND.KT.NE.'CL  '.AND.KT.NE.'BR  '.AND.KT
     +.NE.'I   ')GOTO 4
   5  MP=INT(ABS(A(N+29)))
      IF(MP.LT.0)GOTO 4
      IF(MP*NP.EQ.0)GOTO 6
      IF(MP.NE.NP)GOTO 4
   6  P=(ABS(A(80))+A(K+2))**2
      IL=189
   7  IL=IL+12
      IF(IL.GT.LY)GOTO 4
      XA=A(N+17)*A(IL)+A(N+18)*A(IL+1)+A(N+19)*A(IL+2)+A(IL+9)
      YA=A(N+17)*A(IL+3)+A(N+18)*A(IL+4)+A(N+19)*A(IL+5)+A(IL+10)
      ZA=A(N+17)*A(IL+6)+A(N+18)*A(IL+7)+A(N+19)*A(IL+8)+A(IL+11)
      IW=LY+8
   8  IW=IW+4
      IF(IW.GT.LL)GOTO 7
      XB=A(IW)*XA+A(IW+1)
      YB=A(IW)*YA+A(IW+2)
      ZB=A(IW)*ZA+A(IW+3)
      U=AMOD(XB-X,1.)-.5
      V=AMOD(YB-Y,1.)-.5
      W=AMOD(ZB-Z,1.)-.5
      Q=A(8)*U**2+A(9)*V**2+A(10)*W**2+V*W*A(11)+U*W*A(12)+U*V*A(13)
      IF(Q.GT.P)GOTO 8
      U=U+X
      V=V+Y
      W=W+Z
        DO 9 I=2,M
        IF(MP.NE.MB(I))GOTO 9
        R=U-FF(I)
        S=V-FB(I)
        T=W-FC(I)
        IF(A(8)*R**2+A(9)*S**2+A(10)*T**2+S*T*A(11)+
     +  R*T*A(12)+R*S*A(13).LT.0.01)GOTO 8
   9    CONTINUE
      L=M+1
      I=L
  10  I=I-1
      IF(Q.LT.SQ(I))GOTO 10
      GOTO 12
  11  SQ(L+1)=SQ(L)
      FF(L+1)=FF(L)
      FB(L+1)=FB(L)
      FC(L+1)=FC(L)
      MB(L+1)=MB(L)
      MH(L+1)=MH(L)
      MK(L+1)=MK(L)
      ML(L+1)=ML(L)
  12  L=L-1
      IF(L.GT.I)GOTO 11
      SQ(L+1)=Q
      FF(L+1)=U
      FB(L+1)=V
      FC(L+1)=W
      MB(L+1)=MP
      MH(L+1)=N
      IF(K.EQ.KH)MH(L+1)=-N
      MK(L+1)=IL
      ML(L+1)=IW
      M=MIN0(M+1,LU-1)
      GOTO 8
C
C Find covalently bonded atom
C
  13    DO 14 I=2,M
        IF(MK(I).NE.201)GOTO 14
        IF(ML(I).NE.LY+12)GOTO 14
        IF(MH(I).LT.0)GOTO 14
        N=IABS(MH(I))
        L=INT(ABS(A(N+3)))
        IF(SQ(I).LT.(0.8+A(L+2))**2)GOTO 15
  14    CONTINUE
      GOTO 3
  15  IF(NE.EQ.0)WRITE(LI,1)ABS(A(80))
      NE=I
      KR=' '
      WRITE(KR,'(F20.3)')SQRT(SQ(I))
      CALL SXUS(A(N),KR(1:4))
      L=INDEX(KR,' ')
      KR(L:L)='-'
      CALL SXAN(NN,KR,L,LM,A)
C
C Output hydrogen bonds if any for given hydrogen
C
      NH=0
      WRITE(LI,2)
        DO 20 I=2,M
        IF(I.EQ.NE)GOTO 20
        N=IABS(MH(I))
        SI(1)=A(ML(I))
        K=MK(I)
        SI(2)=99.5+FF(I)-SI(1)*(A(N+17)*A(K)+A(N+18)*A(K+1)+
     +  A(N+19)*A(K+2)+A(K+9))
        SI(3)=99.5+FB(I)-SI(1)*(A(N+17)*A(K+3)+A(N+18)*A(K+4)+
     +  A(N+19)*A(K+5)+A(K+10))
        SI(4)=99.5+FC(I)-SI(1)*(A(N+17)*A(K+6)+A(N+18)*A(K+7)+
     +  A(N+19)*A(K+8)+A(K+11))
        U=FF(NE)-FF(I)
        V=FB(NE)-FB(I)
        W=FC(NE)-FC(I)
        Q=A(8)*U**2+A(9)*V**2+A(10)*W**2+V*W*A(11)+U*W*A(12)+U*V*A(13)
        IF(MH(I).GT.0)GOTO 17
        IF(SQ(I).GT.1.7)GOTO 20
        L=INT(ABS(A(N+3)))
        IF(L.NE.KH)GOTO 16
        IF(Q.LT.1.44)GOTO 17
  16    WRITE(KR(21:58),'(A,F6.3,A)')' ** Short contact ',SQRT(SQ(I)),
     +  ' Angstroms to '
        L=58
        NH=-9999
        GOTO 18
  17    T=(SQ(NE)+SQ(I)-Q)/SQRT(4.*SQ(NE)*SQ(I))
        T=AMOD(720.+57.29578*ATAN2(SQRT(ABS(1.-T**2)),T),360.)
        IF(T.LT.110.)GOTO 20
        NH=NH+1
        WRITE(KR(21:48),'(F9.3,F9.2,F9.3)')SQRT(SQ(I)),T,SQRT(Q)
        L=51
        KR(49:51)='   '
  18    CALL SXAN(IABS(MH(I)),KR,L,LM,A)
        L=L+3
        KR(L-2:L)=' [ '
        CALL SXOP(KR,A(K),SI,L)
        L=L+2
        KR(L-1:L)=' ]'
        IF(KR(L-10:L).EQ.'[ x, y, z ]')L=L-11
        IF(MH(I).GT.0)GOTO 19
        L=L+3
        KR(L-2:L)=' **'
  19    WRITE(LI,2)KR(1:L)
  20    CONTINUE
      IF(NH.GT.0)GOTO 3
      IF(NH.EQ.0)WRITE(LI,2)KR(1:20)
C
C Suggest alternative H(O) sites if no H-bonds or H..H clash
C
      J=INT(ABS(A(MH(NE)+3)))
      CALL SXUS(A(J+13),KT)
      IF(KT.NE.'O   ')GOTO 3
      L=53
      KR=' Alternative approximate positions for H attached to '
      CALL SXAN(MH(NE),KR,L,LM,A)
      WRITE(LI,'(1X,78A1/A)')('-',N=1,78),KR(1:L)//':'
      X=FF(NE)
      Y=FB(NE)
      Z=FC(NE)
      M=1
      SQ(1)=-9.E9
      N=LB-16
  21  N=N+32
      IF(N.GT.LX)GOTO 29
      IF(N.EQ.NN)GOTO 21
      MP=INT(ABS(A(N+29)))
      IF(MP.LT.0)GOTO 21
      IF(MP*NP.EQ.0)GOTO 22
      IF(MP.NE.NP)GOTO 21
  22  K=INT(ABS(A(N+3)))
      P=(2.8+A(K+2))**2
      IL=189
  23  IL=IL+12
      IF(IL.GT.LY)GOTO 21
      XA=A(N+17)*A(IL)+A(N+18)*A(IL+1)+A(N+19)*A(IL+2)+A(IL+9)
      YA=A(N+17)*A(IL+3)+A(N+18)*A(IL+4)+A(N+19)*A(IL+5)+A(IL+10)
      ZA=A(N+17)*A(IL+6)+A(N+18)*A(IL+7)+A(N+19)*A(IL+8)+A(IL+11)
      IW=LY+8
      IF(N.NE.MH(NE))GOTO 24
      IF(IL.EQ.189)IW=IW+4
  24  IW=IW+4
      IF(IW.GT.LL)GOTO 23
      XB=A(IW)*XA+A(IW+1)
      YB=A(IW)*YA+A(IW+2)
      ZB=A(IW)*ZA+A(IW+3)
      U=AMOD(XB-X,1.)-.5
      V=AMOD(YB-Y,1.)-.5
      W=AMOD(ZB-Z,1.)-.5
      Q=A(8)*U**2+A(9)*V**2+A(10)*W**2+V*W*A(11)+U*W*A(12)+U*V*A(13)
      IF(Q.LT.0.01)GOTO 24
      IF(Q.GT.P)GOTO 24
      U=U+X
      V=V+Y
      W=W+Z
        DO 25 I=2,M
        IF(MP.NE.MB(I))GOTO 25
        R=U-FF(I)
        S=V-FB(I)
        T=W-FC(I)
        IF(A(8)*R**2+A(9)*S**2+A(10)*T**2+S*T*A(11)+
     +  R*T*A(12)+R*S*A(13).LT.0.01)GOTO 24
  25    CONTINUE
      L=M+1
      I=L
  26  I=I-1
      IF(Q.LT.SQ(I))GOTO 26
      GOTO 28
  27  SQ(L+1)=SQ(L)
      FF(L+1)=FF(L)
      FB(L+1)=FB(L)
      FC(L+1)=FC(L)
      MB(L+1)=MB(L)
      MH(L+1)=MH(L)
      MK(L+1)=MK(L)
      ML(L+1)=ML(L)
  28  L=L-1
      IF(L.GT.I)GOTO 27
      SQ(L+1)=Q
      FF(L+1)=U
      FB(L+1)=V
      FC(L+1)=W
      MB(L+1)=MP
      MH(L+1)=N
      MK(L+1)=IL
      ML(L+1)=IW
      M=MIN0(M+1,LU-1)
      GOTO 24
  29  IF(M.LT.2)GOTO 32
      NK=2
      L=INT(ABS(A(MH(2)+3)))
      IF(SQ(2).LT.(0.5+A(J+2)+A(L+2))**2)NK=3
        DO 31 I=NK,M
        L=INT(ABS(A(MH(I)+3)))
        CALL SXUS(A(L+13),KT)
        IF(KT.NE.'O   '.AND.KT.NE.'F   '.AND.KT.NE.'CL  '.AND.KT
     +  .NE.'BR  '.AND.KT.NE.'I   '.AND.KT.NE.'S   ')GOTO 31
        S=SQRT(SQ(I))
        IF(S.LT.2.)GOTO 31
        U=0.85/S
        V=1.-U
        KR=' '
        WRITE(KR,'(3F8.4,A)')V*X+U*FF(I),V*Y+U*FB(I),V*Z+U*FC(I),
     +  '  O..'
        L=29
        N=MH(I)
        CALL SXAN(N,KR,L,LM,A)
        SI(1)=A(ML(I))
        K=MK(I)
        SI(2)=99.5+FF(I)-SI(1)*(A(N+17)*A(K)+A(N+18)*A(K+1)+
     +  A(N+19)*A(K+2)+A(K+9))
        SI(3)=99.5+FB(I)-SI(1)*(A(N+17)*A(K+3)+A(N+18)*A(K+4)+
     +  A(N+19)*A(K+5)+A(K+10))
        SI(4)=99.5+FC(I)-SI(1)*(A(N+17)*A(K+6)+A(N+18)*A(K+7)+
     +  A(N+19)*A(K+8)+A(K+11))
        L=L+3
        KR(L-2:L)=' [ '
        CALL SXOP(KR,A(K),SI,L)
        L=L+2
        KR(L-1:L)=' ]'
        IF(KR(L-10:L).EQ.'[ x, y, z ]')L=L-11
        WRITE(KR(L+1:L+7),'(F7.3)')S
        L=L+7
        IF(NK.EQ.2)GOTO 30
        U=FF(2)-FF(I)
        V=FB(2)-FB(I)
        W=FC(2)-FC(I)
        Q=A(8)*U**2+A(9)*V**2+A(10)*W**2+V*W*A(11)+U*W*A(12)+U*V*A(13)
        T=(SQ(2)+SQ(I)-Q)/SQRT(4.*SQ(2)*SQ(I))
        T=AMOD(720.+57.29578*ATAN2(SQRT(ABS(1.-T**2)),T),360.)
        IF(T.LT.85.)GOTO 31
        K=INT(ABS(A(MH(2)+3)))
        CALL SXUS(A(K+13),KT)
        K=INDEX(KT,' ')-1
        KS=KT(2:2)
        IF(KS.GE.'A'.AND.KS.LE.'Z')KT(2:2)=CHAR(ICHAR(KS)+32)
        L=L+K+11
        WRITE(KR(L-10-K:L),'(A,I4)')'  <'//KT(1:K)//'OH =',INT(T+0.5)
  30    WRITE(LI,2)KR(1:L)
  31    CONTINUE
  32  WRITE(LI,'(1X,78A1)')('-',N=1,78)
      GOTO 3
  33  RETURN
      END
