/*
 * 
 * This source code is part of 
 *   MARBLE (MoleculAR simulation package for BiomoLEcules)
 * 
 * Written by Mitsunori Ikeguchi
 * Copyright (c) 2012 Yokohama City University
 *  
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 */

#ifndef _UTIL_H_INCLUDED
#define _UTIL_H_INCLUDED

#define MOL     6.022045e23

#define TRUE  1
#define FALSE 0
#define SQR(x)  ((x)*(x))

typedef struct s_vec {
  double x,y,z;
} vec_t;

void *emalloc(char *pos, size_t size);
void malloc_error_exit(char *pos, size_t size);
char *cfg_fgets(char *buf, int size, FILE *fp) ;
char *par_fgets(char *buf, int size, FILE *fp) ;
char *top_fgets(char *buf, int size, FILE *fp) ;
void v_add(vec_t *c, vec_t *a, vec_t *b);
void v_sub(vec_t *c, vec_t *a, vec_t *b);
void v_mul(vec_t *c, double a, vec_t *b);
double v_inner_pro(vec_t *a, vec_t *b);
void v_outer_pro(vec_t *c, vec_t *a, vec_t *b);
double v_len(vec_t *a);
double v_ang(vec_t *a, vec_t *b);
void v_norm(vec_t *a);
void v_mat_mul(vec_t *b, double mat[3][3], vec_t *a);
void v_mul_mat(vec_t *b, vec_t *a, double mat[3][3]);
void v_rot(vec_t *b, vec_t *axis, double theta, vec_t *a);

#define FNAME_LEN 1000

FILE *env_fopen(char fname[FNAME_LEN], char *mode);

extern int _warning;
extern int _debug;
extern int _no_abort;

#endif  /* _UTIL_H_INCLUDED */
