/*
 * 
 * This source code is part of 
 *   MARBLE (MoleculAR simulation package for BiomoLEcules)
 * 
 * Written by Mitsunori Ikeguchi
 * Copyright (c) 2012 Yokohama City University
 *  
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 */

#ifndef _SOLVATE_H_INCLUDED
#define _SOLVATE_H_INCLUDED

typedef struct s_cell {
  mdat_atom_t *atom;
} cell_t;

typedef struct s_linked_cell {
  cell_t *cell;
  int nx, ny, nz;
  double dx, dy, dz;
} linked_cell_t;

#define LC(i,j,k) _lc.cell[(k)+_lc.nz*((j)+_lc.ny*(i))]

void solvate(mdat_t *mdat);
void sol_set_crystal_solvent(mdat_t *mdat);
void sol_set_added_solvent(mdat_t *mdat);
void sol_setup_box_size(mdat_t *mdat);
void sol_fill_solvent(mdat_t *mdat, pdb_t *o_pdb, pdb_t *i_pdb);
void sol_exclude_solvent(mdat_t *mdat, pdb_t *sol);
void sol_initialize_lc(mdat_t *mdat, double cut);
void sol_assign_lc(mdat_t *mdat);
void sol_set_pos_crystal_water(mdat_t *mdat);
void sol_solvent_renumbering(mdat_t *mdat);
void sol_solvent_renumbering_chain(mdat_t *mdat);

extern linked_cell_t _lc;
extern pdb_t _solvent_input_pdb;
extern pdb_t _solvent_pdb;
extern mdat_t _solvent_mdat;

#endif  /* _SOLVATE_H_INCLUDED */
