/*
 * 
 * This source code is part of 
 *   MARBLE (MoleculAR simulation package for BiomoLEcules)
 * 
 * Written by Mitsunori Ikeguchi
 * Copyright (c) 2012 Yokohama City University
 *  
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 */

#ifndef _PDB_H_INCLUDED
#define _PDB_H_INCLUDED

#define PDB_ATOM    1
#define PDB_HETATM  2
#define PDB_TER     3
#define PDB_CRYST1  4
#define PDB_CONNCT  5
#define PDB_MBLBOX  6  /* for marble box */
#define PDB_UNKNOWN 0

typedef struct pdb {
  struct pdb_atom *atom;
  struct pdb_res *res;
  int n_atom, n_hetatm, n_res;
  double a,b,c,alpha,beta,gamma;

} pdb_t;

typedef struct pdb_atom {
  int  header;
  int  no;
  char name[5];
  char alt_loc;
  char res_name[10];
  char chain;
  int  res_no;
  char code_ins;
  double x, y, z, o, t;
  int  ter, check;
  struct pdb_atom *next;
} pdb_atom_t; 

typedef struct pdb_res {
  int  no;
  char name[10], pdb_name[10];
  char chain;
  int  ter, check;
  double x, y, z;
  struct pdb_atom *beg_atom,*end_atom;

  struct pdb_res *next;
} pdb_res_t;

typedef struct pdb_rename_res {
  char res_name[10];
  int  res_no;
  char chain;
  
  struct pdb_rename_res *next;
} pdb_rename_res_t;

void pdb_init(pdb_t *pdb);
void pdb_read_file(pdb_t *pdb, char *fname);
void pdb_hydrogen_number(char *buf);
int  pdb_parse_header(char *buf);
void pdb_make_res_list(pdb_t *pdb);
void pdb_read_seq(pdb_t *pdb, char *fname);
void pdb_read_seq_buf(pdb_t *pdb, char *buf0);
char *cutstr(char *buf, char *dst, int from, int to);
void pdb_count_data(pdb_t *pdb);
void pdb_print_info(pdb_t *pdb, char *fname);

pdb_atom_t *pdb_search_atom_in_res(char *name, pdb_res_t *res);
void pdb_print_unchecked(pdb_t *pdb);
char *pdb_atom_name(char *name, char *buf);

void pdb_renumber(pdb_t *pdb, int start, char chain);
void pdb_rename_res(pdb_t *pdb, pdb_rename_res_t *res_list);
void pdb_duplicate_atoms(pdb_t *o_pdb, pdb_t *i_pdb, double shift[3]);
void pdb_remove_residues(pdb_t *pdb);

extern pdb_t _pdb;

#endif  /* _PDB_H_INCLUDED */
