/*
 * 
 * This source code is part of 
 *   MARBLE (MoleculAR simulation package for BiomoLEcules)
 * 
 * Written by Mitsunori Ikeguchi
 * Copyright (c) 2012 Yokohama City University
 *  
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 */

#ifndef _PATCH_H_INCLUDED
#define _PATCH_H_INCLUDED

void patch(mdat_t *mdat);
void patch_no_auto(mdat_t *mdat);
void patch_terminal_residue(mdat_t *mdat);
void patch_cfg(mdat_t *mdat, int no_auto);
void patch_residue(mdat_t *mdat, mdat_res_t *mres[3], top_res_t *pres, int ter, int no_auto);
void patch_delete_atom(mdat_t *mdat, mdat_res_t *mres[3], top_res_t *pres);
void patch_delete_bond(mdat_t *mdat, mdat_atom_t *d_atom);
void patch_delete_angle(mdat_t *mdat, mdat_atom_t *d_atom);
void patch_delete_angle_ex(mdat_t *mdat, mdat_res_t *mres[3], top_res_t *pres);
void patch_delete_dihedral(mdat_t *mdat, mdat_atom_t *d_atom);
void patch_delete_impr(mdat_t *mdat, mdat_atom_t *d_atom);
void patch_delete_impr_ex(mdat_t *mdat, mdat_res_t *mres[3], top_res_t *pres);
void patch_delete_cmap(mdat_t *mdat, mdat_atom_t *d_atom);
void patch_delete_ic(mdat_t *mdat, mdat_atom_t *d_atom);
void patch_generate_atom(mdat_t *mdat, mdat_res_t *mres[3], top_res_t *pres);
void patch_generate_bond(mdat_t *mdat, mdat_res_t *mres[3], top_res_t *pres);
void patch_generate_angle(mdat_t *mdat, mdat_res_t *mres[3], top_res_t *pres);
void patch_generate_dihedral(mdat_t *mdat, mdat_res_t *mres[3], top_res_t *pres);
void patch_generate_impr(mdat_t *mdat, mdat_res_t *mres[3], top_res_t *pres);
void patch_generate_cmap(mdat_t *mdat, mdat_res_t *mres[3], top_res_t *pres);
void patch_generate_ic(mdat_t *mdat, mdat_res_t *mres[3], top_res_t *pres);
void patch_make_nb14(mdat_t *mdat);

#endif  /* _PATCH_H_INCLUDED */
