/*
 * 
 * This source code is part of 
 *   MARBLE (MoleculAR simulation package for BiomoLEcules)
 * 
 * Written by Mitsunori Ikeguchi
 * Copyright (c) 2012 Yokohama City University
 *  
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "matrix.h"

void print_mat33(double m[3][3])
{
  int i,j;

  for (i=0;i<3;i++) {
    printf("%f %f %f\n",m[i][0],m[i][1],m[i][2]);
  }
     
}

void diag33(double m[3][3], double eig[3], double eigv[3][3])
{
  double temp[3][3];
  int i,j;
  for (i=0;i<3;i++) {
    for (j=0;j<3;j++) {
      temp[i][j]=m[i][j];
    }
  }
  jacobi(3, &temp[0][0], eig, &eigv[0][0]);

  /* 
  sort_eigen(3, eig, &eigv[0][0], 1);
  { double tmp[3][3], tmp2[3][3]; int k;
  for (i=0;i<3;i++) {
    for (j=0;j<3;j++) {
      tmp[i][j]=eig[i]*eigv[j][i];
    }
  }
  for (i=0;i<3;i++) {
    for (j=0;j<3;j++) {
      tmp2[i][j]=0.0;
      for (k=0;k<3;k++) {
	tmp2[i][j]+=eigv[i][k]*tmp[k][j];
      }
    }
  }
  print_mat33(tmp2);
  print_mat33(m);
  print_mat33(eigv);
  }/**/
}


#define AA(i,j)   a[i*n+j]
#define UU(i,j)   u[i*n+j]
#define DD(i)     d[i]
void jacobi(int n, double *a, double *d, double *u)
{
  int i,j,k,count;
  double sum,th,theta,t,s,c,h,g,tau,aki,akj;
  double fabsii,fabsij,fabsjj;

  for (i=0;i<n;i++) {
    for (j=0;j<n;j++) {
      UU(i,j)=0.0;
    }
    UU(i,i)=1.0;
    DD(i)=AA(i,i);
  }

  for (count=1;count<=50;count++) {
    sum = 0.0;
    for (i=0;i<n-1;i++) {
      for(j=i+1;j<n;j++) {
	sum += fabs(AA(i,j));
      }
    }
    if (sum == 0.0) {
      return;
    }
    if (count < 4)
      th = 0.2*sum/(n*n);
    else
      th = 0.0;
    for (i=0;i<n-1;i++) {
      for(j=i+1;j<n;j++) {
	fabsij=fabs(AA(i,j));
	fabsii=fabs(DD(i));
	fabsjj=fabs(DD(j));
	g=100.0*fabsij;
	if (count > 4 && fabsii+g == fabsii
	              && fabsjj+g == fabsjj) {
	  AA(i,j) = 0.0;
	} else if (fabsij > th) {
	  h = DD(j)-DD(i);
	  if (fabs(h)+g==fabs(h)) {
	    t = AA(i,j) / h;
	  } else {
	    theta = 0.5 * h / AA(i,j);
	    t = 1.0/(fabs(theta)+sqrt(1.0+theta*theta));
	    if (theta<0.0) t = -t;
	  }
	  c=1.0/sqrt(1.0+t*t);
	  s=t*c;
	  tau=s/(1.0+c);
	  h=t*AA(i,j);
	  DD(i) -= h;
	  DD(j) += h;
	  AA(i,j) = 0.0;
	  for (k=0;k<i;k++) {
	    aki = AA(k,i);
	    akj = AA(k,j);
	    AA(k,i)=aki-s*(akj+tau*aki);
	    AA(k,j)=akj+s*(aki-tau*akj);
	  }
	  for (k=i+1;k<j;k++) {
	    aki = AA(i,k);
	    akj = AA(k,j);
	    AA(i,k)=aki-s*(akj+tau*aki);
	    AA(k,j)=akj+s*(aki-tau*akj);
	  }
	  for (k=j+1;k<n;k++) {
	    aki = AA(i,k);
	    akj = AA(j,k);
	    AA(i,k)=aki-s*(akj+tau*aki);
	    AA(j,k)=akj+s*(aki-tau*akj);
	  }
	  for (k=0;k<n;k++) {
	    aki = UU(k,i);
	    akj = UU(k,j);
	    UU(k,i)=aki-s*(akj+tau*aki);
	    UU(k,j)=akj+s*(aki-tau*akj);
	  }
	}
	/*
	printf("c=%d,i=%d,j=%d\n",count,i,j);
	print_mat(n,a);
	*/
      }
    }
  }
}

void sort_eigen(int n, double *d, double *u, int dir)
{
  int i,j,ip;
  double p;

  for (i=0;i<n;i++) {
    ip=i;
    p=d[i];
    for (j=i+1; j<n; j++) {
      if ((dir && d[j] >= p) || (!dir && d[j] <= p)) {
	p=d[j];
	ip=j;
      }
    }
    if (ip != i) {
      d[ip]=d[i];
      d[i]=p;
      for (j=0;j<n;j++) {
	p=UU(j,i);
	UU(j,i)=UU(j,ip);
	UU(j,ip)=p;
      }
    }
  }
}

