/*
 * 
 * This source code is part of 
 *   MARBLE (MoleculAR simulation package for BiomoLEcules)
 * 
 * Written by Mitsunori Ikeguchi
 * Copyright (c) 2012 Yokohama City University
 *  
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 */

#ifndef _ION_H_INCLUDED
#define _ION_H_INCLUDED

typedef struct s_ion_grid {
  int flag;
  int water;
} ion_grid_t;

typedef struct bulk_water_s {
  double epot, ion_density;
  double x, y, z;
  int flag;
  pdb_res_t *r;
} bulk_water_t;

typedef struct ion_site_s {
  mdat_atom_t *a;
  int site;
} ion_site_t;

typedef struct s_ion {
  ion_grid_t *grid;
  int nx, ny, nz;
  double dx, dy, dz;
  double min[3];
  
  bulk_water_t *water;
  int n_water;
  
  top_res_t *cation_top, *anion_top;
  int n_cation, n_anion;
  ion_site_t *cation, *anion;
} ion_t;

#define ION_GRID(i,j,k) _ion.grid[(k)+_ion.nz*((j)+_ion.ny*(i))]
#define IG(i,j,k)       ((k)+_ion.nz*((j)+_ion.ny*(i)))

void ion_setup(mdat_t *mdat);
void ion_initialize(ion_t *ion, mdat_t *mdat, pdb_t *sol);
void ion_finalize(ion_t *ion);
void ion_setup_potential(ion_t *ion, mdat_t *mdat);
void ion_setup_number(ion_t *ion, mdat_t *mdat);
void ion_insert_residues(ion_t *ion, mdat_t *mdat);
void ion_placement(ion_t *ion, mdat_t *mdat);
void ion_remove_overlap_water(ion_t *ion, pdb_t *sol);

extern ion_t _ion;

#endif /* _ION_H_INCLUDED */
