/*
 * 
 * This source code is part of 
 *   MARBLE (MoleculAR simulation package for BiomoLEcules)
 * 
 * Written by Mitsunori Ikeguchi
 * Copyright (c) 2012 Yokohama City University
 *  
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 */

#ifndef _CONFIG_H_INCLUDED
#define _CONFIG_H_INCLUDED

typedef struct cfg_patch {
  char patch_name[5];
  int n_pres;
  int res[3];
  char chain[3];
  int n_patch, step;
  int ter, no_auto;
  struct cfg_patch *next;
} cfg_patch_t;

typedef struct cfg_alias {
  char str[2][10];
  struct cfg_alias *next;
} cfg_alias_t;

typedef struct cfg_ic_seed {
  char  atom[3][6];
  int   resno[3];
  char  chain[3];
  struct cfg_ic_seed *next;
} cfg_ic_seed_t;

typedef struct cfg_ic_add {
  int   impr;
  char  atom[4][6];
  int   resno[4];
  char  chain[4];
  double length[2], angle[2], dihedral;
  struct cfg_ic_add *next;
} cfg_ic_add_t;

typedef struct cfg_ionic_site {
  double x, y, z;
  struct cfg_ionic_site *next;
} cfg_ionic_site_t;

#define MAX_N_TOP_FILE    5
#define MAX_N_PAR_FILE    5
#define MAX_N_TOPPAR_FILE 5

#define CFG_BUFLEN  10000

typedef struct cfg {

  /* Force field section */
  int  n_top_file; /* Number of top files */
  int  n_par_file; /* Number of par files */
  int  n_toppar_file; /* Number of toppar files */
  char top_file[MAX_N_TOP_FILE][FNAME_LEN]; /* Filenames of top files */
  char par_file[MAX_N_PAR_FILE][FNAME_LEN]; /* Filenames of par files */
  char toppar_file[MAX_N_TOPPAR_FILE][FNAME_LEN]; /* Filenames of toppar files */

  /* Input section */
  char input_pdb[FNAME_LEN]; /* Filename of input pdb file */ 
  char input_seq[FNAME_LEN]; /* Filename of input seq file */ 
  char input_crd[FNAME_LEN]; /* Filename of input crd file */
  char *input_seq_buf; /* Buffer for input sequence */

  /* Output section */
  char output_pdb[FNAME_LEN]; /* Filename of output pdb file */
  char output_pdb_orig_res_no[FNAME_LEN]; /* Filename of output pdb file with original residue names and numbers */
  char output_mdat[FNAME_LEN]; /* Filename of ouput mdat file */
  char title[100]; /* Title for mdat file */
  char output_crd[FNAME_LEN]; /* Filename of output crd file */
  char output_xyzs[FNAME_LEN]; /* Filename */
  char output_bond_file[FNAME_LEN]; /* Filename of output bond file */
  char output_angle_file[FNAME_LEN]; /* Filename of output angle file */
  int  mdat_amber;
  
  /* Model building section */
  cfg_ic_seed_t  *ic_seed;
  cfg_ic_add_t   *ic_add;
  cfg_patch_t *patch;
  cfg_alias_t *alias;
  int renumber_pdb;
  pdb_rename_res_t *rename_res;
  double bond_length_limit;
  int use_vdw_radii;

  /* System building section */
  /* Putting into a box  */
  int     align_axis;
  /* Solvating into water */ 
  char    solvent_pdb[FNAME_LEN];
  double  solvent_buffer;
  double  solvent_exclusion_layer;
  double  box_buffer;
  int     solvent_cube;
  char    solvent_chain;
  int     solvent_renumbering;
  int     wrap_molecules;
  /* Adding ions  */
  char    ion_chain, other_chain;
  int     ion_order_flag;
  int     ion_placement;
  double  ion_cutoff, solvent_radius, ion_density;
  double  ion_exclusion_layer, ion2_exclusion_layer;
  double  ion_grid_spacing;
  char    ion_cation[10], ion_anion[10];
  int     n_cation, n_anion;
  cfg_ionic_site_t *pos_site, *neg_site;

} cfg_t;

#define ALIGN_AXIS      1
#define ALIGN_AXIS_Z    2
#define ALIGN_DIAGONAL  3

#define ION_ENERGY  1
#define ION_RANDOM  2

void cfg_read_file(char *fname);
int  cfg_read_filenames(char *buf);
int  cfg_read_patch(char *buf);
int  cfg_read_alias(char *buf);
int  cfg_read_misc(char *buf);
int  cfg_read_ic(char *buf);
int  cfg_read_ion(char *buf);
int  cfg_read_boundary(char *buf);
int  cfg_read_solvate(char *buf);
void cfg_print_patch();
void cfg_print_alias();
int  aliascmp(char *target1,char *target2);
void cfg_str_to_atom_res_no(char *name, char *atom, int *resno, char *chain);
void cfg_str_to_res_no(char *name, int *resno, char *chain);

extern cfg_t _cfg;

#endif /* _CONFIG_H_INCLUDED */
