/*
 * 
 * This source code is part of 
 *   MARBLE (MoleculAR simulation package for BiomoLEcules)
 * 
 * Written by Mitsunori Ikeguchi
 * Copyright (c) 2012 Yokohama City University
 *  
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <ctype.h>
#include <string.h>

#include "util.h"
#include "charmm_par.h"
#include "charmm_top.h" 
#include "pdb.h" 
#include "config.h" 

#define TOPPAR_READ       1
#define TOPPAR_RTF        2
#define TOPPAR_PAR        3
#define TOPPAR_UNKNOWN   -1

void toppar_read_file(char fname[][FNAME_LEN], int n_fname)
{
  FILE *fp;
  int i, hid, hid2;
  char header[100], header2[100], buf[1000], fname2[1000];
  
  for (i=0;i<_cfg.n_toppar_file;i++) {
    fp = env_fopen(fname[i], "r");
    if (fp==NULL) {
      fprintf(stderr,"ERROR: %s: No such file\n", fname[i]);
      exit(1);
    }
    while (top_fgets(buf, 1000, fp) != NULL) {
      if (sscanf(buf,"%99s%99s", header, header2)!=2) continue;
      hid = toppar_header_cmp(header);
      hid2= toppar_header_cmp(header2);
      switch (hid) {
      case TOPPAR_READ:
	switch (hid2) {
	case TOPPAR_RTF:
	  top_read(fp);
	  break;
	case TOPPAR_PAR:
	  par_read(fp);
	  break;
	}
      }
    }
    fclose(fp);
    sprintf(fname2,"+ %s", fname[i]);

    top_count();
    top_print_info(fname2);
    top_check_dup();
    par_print_info(fname2);
    par_check_dup();
  }
}


int toppar_header_cmp(char *header)
{
  if (strncmp(header,"READ",4)==0)
    return(TOPPAR_READ);
  else if (strncmp(header,"RTF",3)==0)
    return(TOPPAR_RTF);
  else if (strncmp(header,"PAR",3)==0)
    return(TOPPAR_PAR);
  
  return(TOPPAR_UNKNOWN);
}
