/*
 * 
 * This source code is part of 
 *   MARBLE (MoleculAR simulation package for BiomoLEcules)
 * 
 * Written by Mitsunori Ikeguchi
 * Copyright (c) 2012 Yokohama City University
 *  
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 */

#ifndef _CHARMM_TOP_H_INCLUDED
#define _CHARMM_TOP_H_INCLUDED

#define LISTMAX              200

#define TOP_DEFA      1
#define TOP_RESI      2
#define TOP_PRES      3
#define TOP_END       4
#define TOP_GROUP     5
#define TOP_ATOM      6
#define TOP_BOND      7
#define TOP_DOUBLE    8
#define TOP_TRIPLE    9
#define TOP_IMPR     10
#define TOP_DONOR    11
#define TOP_ACCEPTOR 12
#define TOP_ANGLE    13
#define TOP_DIHE     14
#define TOP_PATCHING 15
#define TOP_DELETE   16
#define TOP_IC       17
#define TOP_DECL     18
#define TOP_AUTO     19
#define TOP_CMAP     20
#define TOP_MASS     21
#define TOP_UNKNOWN  22

#define MAXANUM 7
#define MAXRNUM 7

typedef struct top {
  int major_version,minor_version;
  int n_mass, n_res, n_pres;
  struct top_mass *mass;
  struct top_res *res;
  struct top_res *pres;

  struct top_nonbond *nobondlist[LISTMAX][LISTMAX];  
} top_t;

typedef struct top_bond {
  int                     no;
  char                    atom[2][MAXANUM]; 
  int                     type; 
  struct top_bond	  *next;
} top_bond_t;

typedef struct top_d_atom {
  char                    name[MAXANUM]; 
  struct top_d_atom	  *next;
} top_d_atom_t;

typedef struct top_angle{
  char                    atom[3][MAXANUM]; 
  struct top_angle	  *next;
} top_angle_t;

typedef struct top_dihedral{
  char                    atom[4][MAXANUM]; 
  struct top_dihedral	  *next;
} top_dihedral_t;

typedef struct top_impr{
  char                    atom[4][MAXANUM]; 
  struct top_impr	  *next;
} top_impr_t;

typedef struct top_cmap{
  char                    atom[8][MAXANUM]; 
  struct top_cmap	  *next;
} top_cmap_t;

typedef struct top_donor{
  char                    atom[2][MAXANUM]; 
  struct top_donor	  *next;
} top_donor_t;

typedef struct top_acceptor{
  char                    atom[2][MAXANUM]; 
  struct top_acceptor	  *next;
} top_acceptor_t;

typedef struct top_atom{
  int                     no;
  int			  group;
  char                    name[MAXANUM];
  char			  sym[MAXSYM];
  double                  charge;
  struct top_atom	  *next;
} top_atom_t;


typedef struct top_mass {
  int                     no;
  int                     check;
  char                    sym[MAXANUM];
  char			  type[MAXANUM]; 
  double                  weight;
  struct top_mass	  *next;
} top_mass_t;

typedef struct top_ic {
  char                    atom[4][MAXANUM];
  double                  length[2];
  double                  angle[2];
  double                  dihedral;
  struct top_ic           *next;
} top_ic_t;

typedef struct top_res {
  int                     num;
  int                     c_angle,c_dihedral;
  int                     target_n;
  int                     patch_res;
  char                    target_c;
  char                    patch[2][MAXRNUM];
  char                    name[20];
  double                  charge; 
  struct top_atom	  *atom;
  struct top_d_atom	  *d_atom;
  struct top_bond         *bond;
  struct top_bond         *d_bond;
  struct top_angle        *angle;
  struct top_angle        *d_angle;
  struct top_dihedral     *dihedral;
  struct top_dihedral     *d_dihedral;
  struct top_impr	  *impr;
  struct top_impr         *d_impr;
  struct top_cmap	  *cmap;
  struct top_donor	  *donor;
  struct top_donor	  *d_donor;
  struct top_acceptor	  *accept;
  struct top_acceptor	  *d_accept;
  struct top_ic           *ic;
  struct top_res	  *next;
} top_res_t;


typedef struct top_nonbond {
  double epsilon;
  double rmin2;
  double eps14;
  double rmin214;
} top_nonbond_t;

void top_init();
void top_read_file(char fname[][FNAME_LEN], int n_fname);
void top_read(FILE *fp);
void top_print_info(char *fname);
void top_count();
int  top_resi_header_cmp(char *header);
void top_print_out(struct top_res *pointer);

top_res_t  *top_search_res(char *name);
top_res_t  *top_search_pres(char *name);
top_mass_t *top_search_mass(top_t *top, char *name);

#define MAXNARG  100
int top_scan_string_list(char *buf1, char arg[MAXNARG][MAXANUM]);

void top_check_dup();
void top_check_dup_mass();
void top_check_dup_res();
void top_check_dup_pres();

void toppar_read_file(char fname[][FNAME_LEN], int n_fname);
int toppar_header_cmp(char *header);

extern top_t _top;

#endif /* _CHARMM_TOP_H_INCLUDED */
