/*
 * 
 * This source code is part of 
 *   MARBLE (MoleculAR simulation package for BiomoLEcules)
 * 
 * Written by Mitsunori Ikeguchi
 * Copyright (c) 2012 Yokohama City University
 *  
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 */

#ifndef _ALIGN_AXIS_H_INCLUDED
#define _ALIGN_AXIS_H_INCLUDED

void align_axis(mdat_t *mdat);
void aln_centering(mdat_t *mdat);
void aln_moment_of_inertia(mdat_t *mdat, double m[3][3]);
void aln_correct_mirror(double u[3][3]);
void aln_rotate(mdat_t *mdat, double u[3][3]);
void cross3(double a[3],double b[3],double c[3]);
double dot3(double a[3], double b[3]);
void normalize3(double a[3]);
void aln_diagonal_rotate(mdat_t *mdat);

#endif /* _ALIGN_AXIS_H_INCLUDED */
