/*
 * 
 * This source code is part of 
 *   MARBLE (MoleculAR simulation package for BiomoLEcules)
 * 
 * Written by Mitsunori Ikeguchi
 * Copyright (c) 2012 Yokohama City University
 *  
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 */

#ifndef _SDMD_H_INCLUDED
#define _SDMD_H_INCLUDED

#define SDMD_TAG_MAKE_TR_LIST   1
#define SDMD_TAG_MAKE_TR_LIST2  2
#define SDMD_TAG_DIST_X         3
#define SDMD_TAG_DIST_F         4
#define SDMD_TAG_GATHER_X       5
#define SDMD_TAG_DIST_RMOL      6
#define SDMD_TAG_PROP           7
#define SDMD_TAG_DIST_X2        8
#define SDMD_TAG_DIST_F2        9



/* sdmd.c */
void SDMD_main_loop(MD_SYSTEM *sys, int max_step);
void SDMD_info(MD_SYSTEM *sys, int max_step);
void SDMD_clear_time(MD_SYSTEM *sys);
void SDMD_print_time(MD_SYSTEM *sys, double total, double loop);
void SDMD_integrate_vel1(MD_SYSTEM *sys, double dt, VEC *f);
void SDMD_integrate_vel2(MD_SYSTEM *sys, double dt, VEC *f);
void SDMD_integrate_coord(MD_SYSTEM *sys, double dt);
void SDMD_output(MD_SYSTEM *sys, int step);
void SDMD_calc_force(MD_SYSTEM *sys);
void SDMD_clear_force(MD_SYSTEM *sys);
void SDMD_calc_virial(MD_SYSTEM *sys);
void SDMD_correct_virial(MD_SYSTEM *sys);
void SDMD_reduce_energy(MD_SYSTEM *sys);
void SDMD_calc_kene(MD_SYSTEM *sys);
void SDMD_remove_momentum(MD_SYSTEM *sys);
int  SDMD_check_migration(MD_SYSTEM *sys,int step);
void SDMD_migration(MD_SYSTEM *sys, int step, double dt_ps);
void SDMD_load_balancer_setup(LINKED_CELL *lc, NONBOND_LIST *nl);
void SDMD_load_balancer(LINKED_CELL *lc,int step, double dt_ps);
void SDMD_load_balancer_clear_time(LINKED_CELL *lc, double *check);
void SDMD_load_balancer_measure_time(LINKED_CELL *lc, double check, int step, double dt_ps);
void SDMD_check_time_overflow(LINKED_CELL *lc, double *time, char *comment);
void SDMD_load_balancer_gather(LINKED_CELL *lc);
void SDMD_load_balancer_exec(LINKED_CELL *lc, int method);
void SDMD_load_balancer_all(LINKED_CELL *lc, double over_load, double ave_load);
int SDMD_load_balancer_multirefine(LINKED_CELL *lc, double min_over_load, double max_over_load,
				    double ave_load);
int  SDMD_load_balancer_refine(LINKED_CELL *lc, double over_load, double ave_load);
void SDMD_nonbond_energy_force_smooth(LINKED_CELL *lc, NONBOND_LIST *nl,
				      ATOM_DATA *ad, BOUNDARY *bc,
				      double *vdw, double *elec, double *hbond);
void SDMD_check_force(LINKED_CELL *lc, ATOM_DATA *ad);

/* sdmd_setup.c */
void SDMD_setup0(MD_SYSTEM *sys);
void SDMD_setup(MD_SYSTEM *sys);
void SDMD_cell_setup(LINKED_CELL *lc, NONBOND_LIST *nl,
		     ATOM_DATA *ad,   BOUNDARY *bc);
void SDMD_assign_cells_to_PE(LINKED_CELL *lc);
void SDMD_get_npx(LINKED_CELL *lc, BOUNDARY *bc, int npx[3]);

#if 0
void SDMD_assign_cells_sparse(LINKED_CELL *lc);
void SDMD_assign_cells_round_robin(LINKED_CELL *lc);
void SDMD_assign_cells_bisection(LINKED_CELL *lc);
void SDMD_assign_cells_bisection_rec(LINKED_CELL *lc,
				     int pe[2], int region[3][2], int dir);
void SDMD_sort_pe_for_cells(LINKED_CELL *lc);
#endif

void SDMD_assign_node_atom(LINKED_CELL *lc, ATOM_DATA *ad);
void SDMD_assign_node_rmol(RMOL_DATA *md, ATOM_DATA *ad);
void SDMD_assign_node_rattle(RATTLE *rt, ATOM_DATA *ad);
void SDMD_clear_cell_req(LINKED_CELL *lc, ATOM_DATA *ad);
void SDMD_clear_cell_req_internal(LINKED_CELL *lc, ATOM_DATA *ad);
void SDMD_assign_internal_to_PE(LINKED_CELL *lc, ATOM_DATA *ad, BOND_DATA *bd,
				ANGLE_DATA *and, DIHEDRAL_DATA *dd, EWALD *ew);
void SDMD_assign_bond_to_PE(LINKED_CELL *lc, BOND_DATA *bd, ATOM_DATA *ad);
void SDMD_assign_angle_to_PE(LINKED_CELL *lc, ANGLE_DATA *and, ATOM_DATA *ad);
void SDMD_assign_dihedral_to_PE(LINKED_CELL *lc, DIHEDRAL_DATA *dd, ATOM_DATA *ad);
void SDMD_assign_cmap_to_PE(LINKED_CELL *lc, DIHEDRAL_DATA *dd, ATOM_DATA *ad);

void SDMD_assign_cmap_to_PE_static(LINKED_CELL *lc, DIHEDRAL_DATA *dd, ATOM_DATA *ad);

int  SDMD_cellcmp(LINKED_CELL *lc, int icell, int jcell);
void SDMD_assign_cellpair_to_PE(LINKED_CELL *lc);

void SDMD_assign_atom_req(LINKED_CELL *lc);

void SDMD_check_alloc_tr_list(LINKED_CELL *lc, int pe, int n);
void SDMD_alloc_tr_list(LINKED_CELL *lc, ATOM_DATA *ad);
void SDMD_setup_tr_list_xyz_ES(LINKED_CELL *lc, ATOM_DATA *ad);
void SDMD_setup_tr_list_xyz_MP(LINKED_CELL *lc, ATOM_DATA *ad);
void SDMD_make_tr_list_xyz(LINKED_CELL *lc, ATOM_DATA *ad);

void SDMD_make_tr_list_by_cell_req(LINKED_CELL *lc, ATOM_DATA *ad);
void SDMD_make_tr_list_by_atom_req(LINKED_CELL *lc, ATOM_DATA *ad);

void SDMD_setup_ex_tr_atom(LINKED_CELL *lc, int n_atom, int *atom_list);

void SDMD_clear_tr_list(LINKED_CELL *lc);
void SDMD_add_tr_list(LINKED_CELL *lc, ATOM_DATA *ad);
void SDMD_make_send_list(LINKED_CELL *lc, ATOM_DATA *ad);


void SDMD_dist_x_xyz(LINKED_CELL *lc, ATOM_DATA *ad);
void SDMD_dist_f_xyz(LINKED_CELL *lc, ATOM_DATA *ad);

void SDMD_dist_x(LINKED_CELL *lc, ATOM_DATA *ad);
void SDMD_dist_v(LINKED_CELL *lc, ATOM_DATA *ad);
void SDMD_dist_f(LINKED_CELL *lc, ATOM_DATA *ad);

void SDMD_dist_rmol(LINKED_CELL *lc, RMOL_DATA *md);
void SDMD_MPI_Wait(LINKED_CELL *lc, MPI_Request *req, MPI_Status *stat);
void SDMD_gather_x(LINKED_CELL *lc, ATOM_DATA *ad);
void SDMD_gather_v(LINKED_CELL *lc, ATOM_DATA *ad);
void SDMD_gather_f(LINKED_CELL *lc, ATOM_DATA *ad);
void SDMD_gather_all(LINKED_CELL *lc, ATOM_DATA *ad, RMOL_DATA *md);
void SDMD_alloc_nonbond_list(LINKED_CELL *lc, NONBOND_LIST *nl,
			     ATOM_DATA *ad, BOUNDARY *bc);
int SDMD_make_nonbond_list(LINKED_CELL *lc,NONBOND_LIST *nl,
			   ATOM_DATA *ad, BOUNDARY *bc, int only_count);

int SDMD_check_resetup(MD_SYSTEM *sys);
void SDMD_resetup(MD_SYSTEM *sys);


/* sdmd_ewald.c */
void SDMD_EW_pme_init(EWALD *ew, BOUNDARY *bc, NONBOND_LIST *nl, ATOM_DATA *ad,
		      double tol_beta, int tol_beta_flag,
		      int grid[3], double d_grid, 
		      double diel_sur, int n_spline, int erfc_resolution,
		      int pme_n_pe);
int SDMD_EW_grid_divisor(int grid, int max);
void SDMD_EW_assign_cor_to_PE(EWALD *ew, LINKED_CELL *lc, ATOM_DATA *ad);
void SDMD_EW_direct_energy_force(EWALD *ew, LINKED_CELL *lc, NONBOND_LIST *nl,
                                 ATOM_DATA *ad, BOUNDARY *bc,
                                 double *vdw, double *edir, double *erec, double *hbond);

void SDMD_EW_pme(EWALD *ew, LINKED_CELL *lc, ATOM_DATA *ad, BOUNDARY *bc, double *elec);
void SDMD_EW_pme1(EWALD *ew, LINKED_CELL *lc, ATOM_DATA *ad, BOUNDARY *bc);

void SDMD_EW_pme2(EWALD *ew, LINKED_CELL *lc, ATOM_DATA *ad, BOUNDARY *bc);
void SDMD_EW_pme3(EWALD *ew, LINKED_CELL *lc, ATOM_DATA *ad, BOUNDARY *bc);

void SDMD_EW_charge_grid(EWALD *ew, LINKED_CELL *lc, ATOM_DATA *ad, BOUNDARY *bc);
void SDMD_EW_fft(EWALD *ew);
void SDMD_EW_energy(EWALD *ew, ATOM_DATA *ad, BOUNDARY *bc, double *elec);
void SDMD_EW_fft_back(EWALD *ew);
void SDMD_EW_force(EWALD *ew, LINKED_CELL *lc, ATOM_DATA *ad, BOUNDARY *bc);

void SDMD_EW_cor_energy_force(EWALD *ew, BOUNDARY *bc,
                              ATOM_DATA *ad, double *elec);
void SDMD_EW_calc_b_array(EWALD *ew);
void SDMD_EW_calc_c_array(EWALD *ew, BOUNDARY *bc);

void SDMD_EW_clear_time(EWALD *ew);
void SDMD_EW_dtime();
void SDMD_EW_add_dtime(double *d);
void SDMD_EW_print_time(EWALD *ew);

/* #define TR_LIST_ATOM_REQ */

#endif  /* _SDMD_H_INCLUDED */
