/*
 * 
 * This source code is part of 
 *   MARBLE (MoleculAR simulation package for BiomoLEcules)
 * 
 * Written by Mitsunori Ikeguchi
 * Copyright (c) 2012 Yokohama City University
 *  
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 */

#ifndef _RATTLE_H_INCLUDED
#define _RATTLE_H_INCLUDED

typedef struct _s_RATTLE_GROUP {
  int parent_atom;
  
  VEC rg, vg;
  double w;

  int node_grp_n;
} RATTLE_GROUP;

typedef struct _s_RATTLE {
  double tolerance;
  int    max_loop, n_bond;
  int    flag;

  int n_grp;
  RATTLE_GROUP *grp;
  
  int node_grp_h;
} RATTLE;

typedef enum {
  RATTLE_ALL, RATTLE_HYDR, RATTLE_WAT, RATTLE_NONE
} RATTLE_TYPE;

void RATTLE_init(RATTLE *rt);
void RATTLE_init_time0(RATTLE *rt, ATOM_DATA *ad);
void RATTLE_time_integration_v1(RATTLE *rt, BOND_DATA *bd, ATOM_DATA *ad, double dt);
void RATTLE_time_integration_v2(RATTLE *rt, BOND_DATA *bd, ATOM_DATA *ad, double dt);
void RATTLE_time_integration_p(RATTLE *rt, BOND_DATA *bd, ATOM_DATA *ad, double dt);
void RATTLE_time_integration_p_NPT(RATTLE *rt, BOND_DATA *bd, ATOM_DATA *ad, double dt,
				   double AA2, double BB);
void RATTLE_time_integration_p_NPT_full(RATTLE *rt, BOND_DATA *bd, ATOM_DATA *ad, double dt,
					double Vg_vec[3][3], double AA2[3], double BB[3]);
void RATTLE_scale_velocity(RATTLE *rt, ATOM_DATA *ad, double *scale_tr, double *scale_rot);
void RATTLE_scale_velocity_full(RATTLE *rt, ATOM_DATA *ad,
				double scale_tr[][3][3],
				double scale_rot[]);
void RATTLE_kene(RATTLE *rt, ATOM_DATA *ad,
		 double *kene_t, double *kene_r, double *kene_arr);
void RATTLE_kene_full(RATTLE *rt, ATOM_DATA *ad,
		      double *kene_t, double *kene_r, int n_ex_system,
		      double kene_tr_arr[][3][3], double kene_rot_arr[]);
void RATTLE_calc_rg(RATTLE *rt, ATOM_DATA *ad);
void RATTLE_calc_vg(RATTLE *rt, ATOM_DATA *ad);
void RATTLE_backup_x(ATOM_DATA *ad);
void RATTLE_a(RATTLE *rt, BOND_DATA *bd, ATOM_DATA *ad, double dt);
void RATTLE_b(RATTLE *rt, BOND_DATA *bd, ATOM_DATA *ad);
void RATTLE_setup(RATTLE *rt, BOND_DATA *bd, ATOM_DATA *ad,
		  RATTLE_TYPE type, double tol);
void RATTLE_setup_group(RATTLE *rt, BOND_DATA *bd, ATOM_DATA *ad);
void RATTLE_degree_of_freedom(RATTLE *rt, BOND_DATA *bd, ATOM_DATA *ad,
  int *degree_of_freedom_ex, int *n_rattle_group);
void RATTLE_correct_virial(RATTLE *rt, ATOM_DATA *ad);
 

#endif  /* RATTLE_H_INCLUDED */
