/*
 * 
 * This source code is part of 
 *   MARBLE (MoleculAR simulation package for BiomoLEcules)
 * 
 * Written by Mitsunori Ikeguchi
 * Copyright (c) 2012 Yokohama City University
 *  
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 */

#ifndef _PT_CTRL_H_INCLUDED
#define _PT_CTRL_H_INCLUDED

/* main update routines */
void PTC_update1(MD_SYSTEM *sys, double dt);
void PTC_update2(MD_SYSTEM *sys, double dt);

/* gradual change routines */
void PTC_set_gradual_change_T(MD_SYSTEM *sys, int gradual_change_step,
			      double target_T1);
void PTC_gradual_change(MD_SYSTEM *sys, int step);

/*************************************************************************/
/***** Weak Coupling Methods: Berendesen Methods..                   *****/
/*************************************************************************/
void PTC_set_weak_coupling_T(MD_SYSTEM *sys, double T, double tau_t);
void PTC_weak_coupling_T(MD_SYSTEM *sys, double dt_ps);
void PTC_set_weak_coupling_P(MD_SYSTEM *sys, double P, double tau_p,
			     double comp);
void PTC_weak_coupling_P(MD_SYSTEM *sys, double dt_ps);

/*************************************************************************/
/*****    Constraint T                                               *****/
/*************************************************************************/
void PTC_set_constraint_T(MD_SYSTEM *sys, double T);
void PTC_constraint_T(MD_SYSTEM *sys, double T);
void PTC_constraint_T1(MD_SYSTEM *sys, double *chi);
void PTC_constraint_T2(MD_SYSTEM *sys, double *chi);

/*************************************************************************/
/*****    Rescaling T:                                               *****/
/*************************************************************************/
void PTC_set_rescaling_T(MD_SYSTEM *sys, double T, double delta_T);
void PTC_rescaling_T2(MD_SYSTEM *sys);

/*************************************************************************/
/***** Extended System Methods: Nose-Hoover                          *****/
/*************************************************************************/
void PTC_set_Ex_System_T_cnst(MD_SYSTEM *sys, double target_T,
			      double period, int n_chain_T,
			      int ex_system_div_flag);
void PTC_setup_P_flag(MD_SYSTEM *sys);
void PTC_set_Ex_System_PT_cnst(MD_SYSTEM *sys,
			       double target_T,double period_T,
			       int    n_chain_T,
			       int    ex_system_div_flag,
			       double target_P,double period_P,
			       int    P_flag);
void PTC_set_Ex_System_off(MD_SYSTEM *sys);
void PTC_set_gamma_ex(MD_SYSTEM *sys, double f);
void PTC_Ex_System_print(MD_SYSTEM *sys);
void PTC_Ex_System_read_data(MD_SYSTEM *sys, FILE *fp);
#ifdef MPI
void PTC_Ex_System_comm_data(MD_SYSTEM *sys);
#endif
void PTC_Ex_System_write_data(MD_SYSTEM *sys, FILE *fp);
void PTC_scale_velocity(MD_SYSTEM *sys, double *scale_tr, double *scale_rot);
void PTC_scale_velocity_full(MD_SYSTEM *sys, double scale_tr[MAX_EX_SYSTEM][3][3],
			     double scale_rot[MAX_EX_SYSTEM]);
void PTC_Ex_System_T_update(MD_SYSTEM *sys, double hdt);
void PTC_Ex_System_PT_update(MD_SYSTEM *sys, double hdt);
void PTC_Ex_System_PT_update_iso(MD_SYSTEM *sys, double hdt);
void PTC_Ex_System_PT_update_full(MD_SYSTEM *sys, double hdt);
void PTC_Ex_System_PT_update_x(MD_SYSTEM *sys, double dt);
void PTC_Ex_System_PT_update_x_iso(MD_SYSTEM *sys, double dt);
void PTC_Ex_System_PT_update_x_full(MD_SYSTEM *sys, double dt);


/*************************************************************************/
/***** Scaling for Pressure Contorol                                 *****/
/*************************************************************************/

void PTC_scale_system(MD_SYSTEM *sys, double scale);
void PTC_scale_system_anisotropic(MD_SYSTEM *sys, double scale[3]);

#endif /* _PT_CTRL_H_INCLUDED */
