/*
 * 
 * This source code is part of 
 *   MARBLE (MoleculAR simulation package for BiomoLEcules)
 * 
 * Written by Mitsunori Ikeguchi
 * Copyright (c) 2012 Yokohama City University
 *  
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 */

#ifndef _PARALLEL_H_INCLUDED
#define _PARALLEL_H_INCLUDED

#define TAG_PLPRINTF 1

void assign_tasks(MD_SYSTEM *sys);
void assign_tasks_atom(ATOM_DATA *ad);
void assign_tasks_bond(BOND_DATA *bd);
void assign_tasks_angle(ANGLE_DATA *ad);
void assign_tasks_dihedral(DIHEDRAL_DATA *dd);
void assign_tasks_nonbond_list(NONBOND_LIST *nl);
void assign_tasks_linked_cell(LINKED_CELL *lc);
void reduce_energy_force(MD_SYSTEM *sys);

void sync_xv(MD_SYSTEM *sys);
void plprintf(char *fmt, ...);
void   *get_buf(size_t size);
double *get_double_buf(size_t size);
int    *get_int_buf(size_t size);
void    free_buf(void *p);

void ave_min_max(double val, double ave_min_max[3]);

FILE *par_fopen(char *fname, char *mode);
char *par_fgets(char *buf, int size, FILE *fp);
int   par_fclose(FILE *fp);

#endif /* _PARALLEL_H_INCLUDED */
