/*
 * 
 * This source code is part of 
 *   MARBLE (MoleculAR simulation package for BiomoLEcules)
 * 
 * Written by Mitsunori Ikeguchi
 * Copyright (c) 2012 Yokohama City University
 *  
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 */

#ifndef _MPI_GLOBAL_H_INCLUDED
#define _MPI_GLOBAL_H_INCLUDED

#ifdef MPI

#include "mpi.h"

struct s_mpi {
  int rank;
  int n_pe;
  int master, master_pe;
  int n_threads;
  MPI_Comm comm, all_comm;

  MPI_Comm cart_comm;
  int npx[3];
  int cart_rank, px[3];

#ifdef KCOMP
  int npx_in_node[3];
  int np_in_node;
  int dim;
#endif
};

#ifdef _MPI_SETUP_C_
struct s_mpi mpi;
#else
extern struct s_mpi mpi;
#endif

#define TAG_BUILT_IN  1

void mpi_setup();
void mpi_cart3D_setup(int npx[3]);
void mpi_rank2xyz(int rank, int *px, int *py, int *pz);
void mpi_xyz2rank(int ix, int iy, int iz, int *prank);

#endif /* MPI */

#endif /* _MPI_GLOBAL_H_INCLUDED */
