/*
 * 
 * This source code is part of 
 *   MARBLE (MoleculAR simulation package for BiomoLEcules)
 * 
 * Written by Mitsunori Ikeguchi
 * Copyright (c) 2012 Yokohama City University
 *  
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 */

#ifndef _MIN_H_INCLUDED
#define _MIN_H_INCLUDED

#ifndef  _ATOM_H_INCLUDED
#include "atom.h"
#endif

void MIN_main(MD_SYSTEM *sys, 
	      int sd_step, double sd_init_step, double sd_largest_step,
	      double rms,  int print_out_step,
	      int cg_step, double cg_init_step, double cg_largest_step,
	      double cg_line_min_tol);

void MIN_steepest(MD_SYSTEM *sys, int max_step, double dstep_init, double dstep_largest,
		  double rms_cri, int print_out_step);
double MIN_flen(ATOM_DATA *ad);

/*
void MIN_conjugate_gradient(MD_SYSTEM *sys, int max_step, double rms,
			VEC *g, VEC *h, VEC *x_opt, VEC *f_opt);
int MIN_line_min(MD_SYSTEM *sys, VEC *dir, VEC *x_opt, VEC *f_opt);
*/
void MIN_conjugate_gradient(MD_SYSTEM *sys, int max_step,
			    double init_step, double largest_step,
			    double line_min_tol, double rms_cri, int print_out_step);


#endif  /* _MIN_H_INCLUDED */
