/*
 * 
 * This source code is part of 
 *   MARBLE (MoleculAR simulation package for BiomoLEcules)
 * 
 * Written by Mitsunori Ikeguchi
 * Copyright (c) 2012 Yokohama City University
 *  
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 */

#ifndef _LINKED_CELL_H_INCLUDED
#define _LINKED_CELL_H_INCLUDED

#define CHARMM_SMOOTH
/* #define CHARMM_VFSWITCH */

#define HG_MODE

/* LINKED CELL */
typedef struct {
  int ix, iy, iz;
  int head, tail, n_atom;
  int fold_id;
#ifdef MPI_SDMD
  int pe, req, req_xyz;
  int node_next, req_next;
#endif  
} CELL;

#define CELL_REQ_HOME      1
#define CELL_REQ_BOND      2
#define CELL_REQ_ANGLE     4
#define CELL_REQ_DIHED     8
#define CELL_REQ_EW_COR   16
#define CELL_REQ_INTERNAL 30
#define CELL_REQ_NONBOND  32
#define CELL_REQ_XYZ      64

typedef struct {
  int i, j, offset;
  int alist_start, alist_end;
#ifdef MPI_SDMD
  int pe;
  double time;
  int ipart, npart;
  int next;
#endif  

  int n_i_list, n_list;

  /* for OMP 
#define CP_JLIST_UNIT 1000
  RESIZABLE_INT_ARRAY j_list;
#define CP_FI_UNIT 1000
  int n_fi, n_fj;
  RESIZABLE_VEC_ARRAY fi, fj;
  double vdw, elec, virial[6];
  */

} CELL_PAIR;

#ifdef MPI_SDMD
typedef struct {
  int n_cell;
  int *cell;
  int min[3], max[3];
  int neighbor_pe[2][2][3];  
  /* neighbor_pe[neighbor0:1][direction minus:positive][xyz] */
} CELL_PE;

typedef struct {
  int n_recv_x, *recv_x;
  int n_send_x, *send_x;
  int n_recv_f, *recv_f;
  int n_send_f, *send_f;
  int n_alloc;
} TR_LIST;

#define TR_LIST_ALLOC_UNIT 1000

typedef struct {
  int pe;
  int n_atom, n_cell;
  RESIZABLE_INT_ARRAY aid, cid;
} TR_LIST_XYZ;

typedef struct {
  int icp;
  double time;
} LB_CELL_PAIR;

typedef struct {
  int req;
  int nb;
} LB_CELL;

typedef struct {
  double bg_time, nb_time;
  double cur_load;
  LB_CELL *cell;
} LB_PE;

typedef struct {
  LB_PE *pe;
  LB_CELL_PAIR *cell_pair;
} LOAD_BALANCER;

typedef struct s_ex_tr_atom {
  int n_atom;
  int *atom_list;

  struct s_ex_tr_atom *next;
} EX_TR_ATOM;

#endif

#ifdef MPI_SDMD
#define SDMD_TIME_BOND        0
#define SDMD_TIME_ANGLE       1
#define SDMD_TIME_DIHED       2
#define SDMD_TIME_NONBOND     3
#define SDMD_TIME_EW_DIR      4
#define SDMD_TIME_EW_REC      5
#define SDMD_TIME_EW_COR      6
#define SDMD_TIME_FMM         7
#define SDMD_TIME_BOUNDARY    8
#define SDMD_TIME_EP          9
#define SDMD_TIME_NBLIST     10
#define SDMD_TIME_RATTLE     11
#define SDMD_TIME_FRCMAN     12
#define SDMD_TIME_MIGRATION  13
#define SDMD_TIME_LB         14
#define SDMD_TIME_COMM_X     15
#define SDMD_TIME_COMM_F     16
#define SDMD_TIME_COMM_E     17
#define SDMD_TIME_IDLE       18
#define SDMD_TIME_OTHER      19
#define SDMD_TIME_SETUP      20
#define SDMD_TIME_AFTER_LOOP 21
#define SDMD_N_TIME          22

/*
#define SDMD_TIME_RM_TFRC    16
#define SDMD_TIME_EW_REC2    16
#define SDMD_TIME_MIGRATION2 17
#define SDMD_TIME_MIGRATION3 18
  
#define SDMD_TIME_EX_SYSTEM  22
#define SDMD_TIME_INT_X      23
#define SDMD_TIME_INT_V      24
#define SDMD_TIME_KENE       25
#define SDMD_TIME_OUTPUT     26
#define SDMD_TIME_CLFRC      27
#define SDMD_TIME_VIRIAL     28
#define SDMD_TIME_OTHER      29
#define SDMD_TIME_SETUP      30
#define SDMD_TIME_AS_BOND    31
#define SDMD_TIME_AS_ANGLE   32
#define SDMD_TIME_AS_DIHED   33
#define SDMD_TIME_AS_EWALD   34
#define SDMD_N_TIME          35
*/
#endif


typedef struct {
  int *cell_pair_req;
  int n_cell_pair_req;
  int n_i_list, n_list;
  RESIZABLE_INT_ARRAY j_list;
  VEC *fold_f;
  double virial[6];
  double vdw, elec;
} THREAD_DATA;

typedef struct {
  int request_grid;
  int n_grid[3], neighbor[3], n_grid_h[3];
  int n_cell, n_alloc_cell;
  CELL *cell;
  /* CELL ***cell_index; */
  int *next_atom;
  int *prev_atom;
  int max_n_atom;
#ifdef MPI_SDMD
  int *atom_cell;
  unsigned char *atom_req;
  CELL_PE *cell_pe;

  int request_npx;
  int req_npx[3];
#endif

  int n_cell_pair, n_alloc_cell_pair;
  CELL_PAIR *cell_pair;

#ifdef MPI_SDMD
  int n_cell_pair_req;
  int *cell_pair_req;
#endif

#ifdef MPI_SDMD
  TR_LIST *tr_list;
  int tr_list_factor;

#define TR_MODE_P2P  1
#define TR_MODE_ES   2
#define TR_MODE_MP   3

  int tr_mode, tr_dist_xf_flag;
  TR_LIST_XYZ *sxl_x, *sxl_y, *sxl_z;
  TR_LIST_XYZ *rxl_x, *rxl_y, *rxl_z;
  TR_LIST_XYZ *sfl_x, *sfl_y, *sfl_z;
  TR_LIST_XYZ *rfl_x, *rfl_y, *rfl_z;

  VEC *f;
  LOAD_BALANCER *lb;
  double idle_time, nb_time, total_time;
  int load_balancer_exec_step;
  int load_balancer_step;
  int load_balancer_flag;
  int lb_cycle;
  double time[SDMD_N_TIME];
  EX_TR_ATOM *ex_tr_atom;
  int check_time_overflow;
  int n_part;
  double start_overload, max_overload;
  int node_head, req_head;
  int pair_head;

  int n_atom_cell_req;
  int *atom_cell_req;

  THREAD_DATA *td;

#endif  


  
} LINKED_CELL;

/* typedef struct _s_NONBOND_LIST NONBOND_LIST; */

#define CELL_INDEX(lc,x,y,z) ((z)+(lc)->n_grid[2]*((y)+(lc)->n_grid[1]*(x)))

/* LINKED CELL ROUTINES */

void LINKED_CELL_init(LINKED_CELL *lc);

/* These definitions moves to nonbond.h
void LINKED_CELL_setup(LINKED_CELL *lc,
                       NONBOND_LIST *nl,
                       ATOM_DATA *ad,
                       BOUNDARY *bc, int neighbor);
void LINKED_CELL_set_neighbor(LINKED_CELL *lc, BOUNDARY *bc, NONBOND_LIST *nl);
*/

void LINKED_CELL_alloc(LINKED_CELL *lc, int n_grid[3], int n_atom);
void LINKED_CELL_free(LINKED_CELL *lc);
void LINKED_CELL_assign_atom(LINKED_CELL *lc, ATOM_DATA *ad, BOUNDARY *bc);
void LINKED_CELL_calc_tr_x(LINKED_CELL *lc, ATOM_DATA *ad, BOUNDARY *bc);
void LINKED_CELL_make_cell_pairlist(LINKED_CELL *lc, BOUNDARY *bc);


void LINKED_CELL_migration(LINKED_CELL *lc, int iatom,
		      int oldcell, int newcell);

#endif  /* _LINKED_CELL_H_INCLUDED */
