/*
 * 
 * This source code is part of 
 *   MARBLE (MoleculAR simulation package for BiomoLEcules)
 * 
 * Written by Mitsunori Ikeguchi
 * Copyright (c) 2012 Yokohama City University
 *  
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 */

#ifndef _FIT_H_INCLUDED
#define _FIT_H_INCLUDED

typedef struct {
  double *w, total_w;
  VEC *x0, *x1;
  VEC com0, com1;
  double R[3][3];
  double rmsd;
  int n_atom;

  int flag;
} FIT;

typedef struct _s_WEIGHT_LIST {
  double weight;
  STR_LIST *group_str;
  struct _s_WEIGHT_LIST *next;
} WEIGHT_LIST;


void FIT_init(FIT *fit, int n_atom, double *w);
double FIT_calc_rmsd(FIT *fit, VEC *x0, VEC *x1);
void FIT_calc_com(FIT *fit, VEC *x0, VEC *com);
void FIT_copy_vec(FIT *fit, VEC *x0, VEC *x1);
void FIT_shift(FIT *fit, VEC *x0, VEC *shift);
void FIT_only_translation(FIT *fit, VEC *x0, VEC *x1);
void FIT_best_fit(FIT *fit, VEC *x0, VEC *x1, VEC *x0r);
void FIT_fit_rotation(FIT *fit, VEC *x0, VEC *x1);
void FIT_make_U(FIT *fit, double *a, double *b, double U[3][3]);
void FIT_make_Omega(double O[6][6],double U[3][3],double Ut[3][3]);
void FIT_diag_Omega(double det, double O[6][6],double J[6][6],
                    double h[3][3],double k[3][3],double D[3]);
void FIT_make_R(double h[3][3],double k[3][3],double R[3][3]);
void FIT_rotation(FIT *fit, VEC *x0, double R[3][3]);

void FIT_append_weight_list(WEIGHT_LIST **headp, double weight);
void FIT_set_weight_list_group_str(WEIGHT_LIST *headp, char *str);


#endif /* _FIT_H_INCLUDED */
