/*
 * 
 * This source code is part of 
 *   MARBLE (MoleculAR simulation package for BiomoLEcules)
 * 
 * Written by Mitsunori Ikeguchi
 * Copyright (c) 2012 Yokohama City University
 *  
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 */

#ifndef _FFT3D_H_INCLUDED
#define _FFT3D_H_INCLUDED

#include <fftw3.h>

#define c_re(c) ((c)[0])
#define c_im(c) ((c)[1])

#ifdef FFT_FLOAT
typedef float fftw_real;
typedef float fftw_complex[2];
#else
typedef double fftw_real;
/*typedef double fftw_complex[2]; */
typedef double FFTW_COMPLEX[2]; 
#endif

typedef struct _s_FFT3DXYZ {
  MPI_Comm comm;
#ifdef FFT_OMP
  fftw_plan *f_plan, *b_plan;
#else
  fftw_plan f_plan, b_plan;
#endif

  int *pe_list, n_pe;   /* pe_list for this direction */
  int n_all_fft;        /* total number of fft for this direction */
  int n_local_fft;      /* number of fft that this node performs */
  int n_local_fft_div;  /* n_all_fft / n_pe */
  int n_local_fft_mod;  /* n_all_fft % n_pe */
  int *sf_count, *sf_displ;
  int *rf_count, *rf_displ;
  int *sb_count, *sb_displ;
  int *rb_count, *rb_displ;
  int *sf_count_c, *sf_displ_c;
  int *rf_count_c, *rf_displ_c;
  int *sb_count_c, *sb_displ_c;
  int *rb_count_c, *rb_displ_c;
  int alltoall_flag;
  int count0, count0_c;
} FFT3DXYZ;

typedef struct _s_FFT3D {
  int n_data, n_tdata, transpose;
  int nx[3];          /* global grid dimension */
  int npx[3];         /* node number */
  int lnx[3];         /* local grid dimension */
  int start_x[3];     /* local grid position */
  int pe;             /* my rank */
  int px[3];          /* my rank position */
  FFT3DXYZ xyz[3];
  fftw_real *s_data, *r_data, *fft_data, *fft_tdata;
  int (*ikxy_tdata)[2], n_ikxy_tdata;
} FFT3D;

#define ARR2D(a, i, j, lda) a[(i)+(j)*(lda)]
#define ARR3D(a, i, j, k, lda1, lda2) a[(i)+(lda1)*((j)+(k)*(lda2))]
#define c_assgn(d, s) c_re(d)=c_re(s);c_im(d)=c_im(s)

int FFT3D_setup(FFT3D *ft, int nx[3], int transpose);
void *FFT3D_emalloc(char *routine, size_t size);
void FFT3D_forward(FFT3D *ft, fftw_real *data, fftw_complex *tdata);
void FFT3D_backward(FFT3D *ft, fftw_real *data, fftw_complex *tdata);

#endif /* _FFT3D_H_INCLUDED */
