/*
 * 
 * This source code is part of 
 *   MARBLE (MoleculAR simulation package for BiomoLEcules)
 * 
 * Written by Mitsunori Ikeguchi
 * Copyright (c) 2012 Yokohama City University
 *  
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 */

#ifndef _EXTRA_POT_FUNC_H_INCLUDED
#define _EXTRA_POT_FUNC_H_INCLUDED

void EP_init(EXTRA_POT *ep);
void EP_add_item(EXTRA_POT *ep, EP_ITEM *dat);
void EP_energy_force(EXTRA_POT *ep, MD_SYSTEM *sys, double *energy);
void EP_gradual_change(EXTRA_POT *ep, MD_SYSTEM *sys, int step);
void EP_prop_header(EXTRA_POT *ep, FILE *fp, int *id);
void EP_prop_out(EXTRA_POT *ep, MD_SYSTEM *sys, FILE *fp);
void EP_output(EXTRA_POT *ep, MD_SYSTEM *sys);
void EP_DISTANCE_setup(EXTRA_POT *ep,
		       ATOM_DATA *ad,
		       BOUNDARY *bc,
		       LINKED_CELL *lc,
		       char *atom1, char *atom2,
		       double k, double r0,
		       int gradual_change_step, double k1, int virial_flag,
		       int potential_flag,
		       int x_flag, int y_flag, int z_flag);
void EP_DISTANCE_energy_force(EP_DISTANCE *ed, ATOM_DATA *ad,
			      BOUNDARY *bc, LINKED_CELL *lc);
void EP_DISTANCE_prop_header(EP_DISTANCE *ed,
			     FILE *fp, int *id);
void EP_DISTANCE_prop_out(EP_DISTANCE *ed, MD_SYSTEM *sys, FILE *fp);
void EP_DISTANCE_gradual_change(EP_DISTANCE *ed, int step);
void EP_GROUP_DISTANCE_setup(EXTRA_POT *ep,
			     ATOM_DATA *ad,
			     BOUNDARY *bc,
			     LINKED_CELL *lc,
			     STR_LIST *group1_str, STR_LIST *group2_str,
			     int group1, int group2,
			     double k, double r0,
			     int gradual_change_step, double k1, 
			     int gradual_change_step_r0, double r1, 
			     int virial_flag,
			     int potential_flag,
			     int x_flag, int y_flag, int z_flag);
void EP_GROUP_DISTANCE_energy_force(EP_GROUP_DISTANCE *eg,
				    ATOM_DATA *ad,
				    BOUNDARY *bc,
				    LINKED_CELL *lc);
void EP_GROUP_DISTANCE_prop_header(EP_GROUP_DISTANCE *eg,
				    FILE *fp, int *id);
void EP_GROUP_DISTANCE_prop_out(EP_GROUP_DISTANCE *eg,
				MD_SYSTEM *sys, FILE *fp);
void EP_GROUP_DISTANCE_gradual_change(EP_GROUP_DISTANCE *eg, int step);
void EP_POSITION_setup(EXTRA_POT *ep,
		       ATOM_DATA *ad, STR_LIST *group_str, int group_no,
		       char *file_name, double k,
		       int gradual_change_step, double k1, int virial_flag,
		       int x_flag, int y_flag, int z_flag);
void EP_POSITION_energy_force(EP_POSITION *epos,ATOM_DATA *ad);
void EP_POSITION_gradual_change(EP_POSITION *epos, int step);
void EP_GROUP_POSITION_setup(EXTRA_POT *ep,
			     ATOM_DATA *ad,
			     BOUNDARY *bc,
			     LINKED_CELL *lc,
			     STR_LIST *group_str,
			     int group_no, char *file_name, double target[3], double k,
			     int gradual_change_step, double k1, int virial_flag,
			     int x_flag, int y_flag, int z_flag);
void EP_GROUP_POSITION_energy_force(EP_GROUP_POSITION *egpos,
                                    ATOM_DATA *ad,
                                    BOUNDARY *bc,
                                    LINKED_CELL *lc);
void EP_GROUP_POSITION_prop_header(EP_GROUP_POSITION *egpos,
				   FILE *fp, int *id);
void EP_GROUP_POSITION_prop_out(EP_GROUP_POSITION *egpos,
				MD_SYSTEM *sys, FILE *fp);
void EP_GROUP_POSITION_gradual_change(EP_GROUP_POSITION *egpos, int step);
void EP_MOLECULE_POSITION_setup(EXTRA_POT *ep,
				ATOM_DATA *ad,
				BOUNDARY *bc,
				LINKED_CELL *lc,
				int group_no, char *file_name, double k,
				int gradual_change_step, double k1, int virial_flag,
				int mole_residue,
				int x_flag, int y_flag, int z_flag);
void EP_MOLECULE_POSITION_energy_force(EP_MOLECULE_POSITION *empos,
                                       ATOM_DATA *ad,
                                       BOUNDARY *bc,
                                       LINKED_CELL *lc);
void EP_MOLECULE_POSITION_gradual_change(EP_MOLECULE_POSITION *empos, int step);

/* yss-add (Mar04/2004) */
void EP_TORSION_setup(EXTRA_POT *ep,
		      ATOM_DATA *ad,
		      BOUNDARY *bc,
		      LINKED_CELL *lc,
		      char *atom1, char *atom2, char *atom3, char *atom4,
		      double k, double r0, double delta,
		      int gradual_change_step, double k1, int virial_flag);
void EP_TORSION_energy_force(EP_TORSION *et, ATOM_DATA *ad,
		             BOUNDARY *bc, LINKED_CELL *lc);
void EP_TORSION_prop_header(EP_TORSION *et,
			    FILE *fp, int *id);
void EP_TORSION_prop_out(EP_TORSION *et, MD_SYSTEM *sys, FILE *fp);
void EP_TORSION_gradual_change(EP_TORSION *et, int step);
/* yse */

/* for nmr.c */
/* YAMANE_ADDED */
void EP_NMR_DIS_setup(EXTRA_POT *ep,
		      ATOM_DATA *ad, 
		      LINKED_CELL *lc,
		      char *file_name, double scal, double scal1, double Ceil,
		      double sqof, double sqcs, double sqex,
		      double soex, double asym, double rswi,
                      double viol_dis, int n_output_viol,
		      int gradual_change_step, int virial_flag);
void EP_NMR_DIS_energy_force(EP_NMRDIS *ndis, ATOM_DATA *ad, LINKED_CELL *lc);
void EP_NMR_DIS_prop_header(EP_NMRDIS *ndis, FILE *fp, int *id);
void EP_NMR_DIS_prop_out(EP_NMRDIS *ndis, MD_SYSTEM *sys, FILE *fp);
void EP_NMR_DIS_gradual_change(EP_NMRDIS *ndis, int step);
void EP_NMR_DIS_output(EP_NMRDIS *ndis, MD_SYSTEM *sys);
void EP_NMR_DIH_setup(EXTRA_POT *ep,
                      ATOM_DATA *ad,
		      LINKED_CELL *lc,
                      char *file_name, double scal, double scal1,
                      double viol_dih, int n_output_viol,
                      int gradual_change_step,
                      int virial_flag);
void EP_NMR_DIH_energy_force(EP_NMRDIH *ndih, ATOM_DATA *ad, LINKED_CELL *lc);
void EP_NMR_DIH_prop_header(EP_NMRDIH *ndih,FILE *fp, int *id);
void EP_NMR_DIH_prop_out(EP_NMRDIH *ndih, MD_SYSTEM *sys, FILE *fp);
void EP_NMR_DIH_gradual_change(EP_NMRDIH *ndih, int step);
void EP_NMR_DIH_output(EP_NMRDIH *ndih, MD_SYSTEM *sys);
void EP_NMR_PLN_setup(EXTRA_POT *ep,
		      ATOM_DATA *ad,
		      LINKED_CELL *lc,
		      char *file_name,
		      double weight, double wei1, int gradual_change_setup,
		      int virial_flag);
void EP_NMR_PLN_energy_force(EP_NMRPLN *npln,ATOM_DATA *ad, LINKED_CELL *lc);
void EP_NMR_PLN_gradual_change(EP_NMRPLN *npln, int step);
/* E_YAMANE_ADDED */

/* Steered MD */

void EP_SMD_CV_setup(EXTRA_POT *ep,
		     ATOM_DATA *ad, LINKED_CELL *lc,
		     STR_LIST *group_str, int group_no,
		     char *crd_file,  double k,
		     double vel, double ang_vel,
		     double init_trans, double init_rot,
		     double dir[3],  double pos[3], 
		     int center_flag, int weight_flag,
		     int gradual_change_step, double k1, 
		     int virial_flag,
		     int x_flag, int y_flag, int z_flag);
void EP_SMD_CV_test(EXTRA_POT *ep, ATOM_DATA *ad, char *base_file,
		    double timestep, int step, int interval);
void EP_SMD_CV_energy_force(EP_SMD *smd, ATOM_DATA *ad, LINKED_CELL *lc);
void EP_SMD_CV_prop_header(EP_SMD *smd,
                           FILE *fp, int *id);
void EP_SMD_CV_prop_out(EP_SMD *smd, MD_SYSTEM *sys, FILE *fp);
void EP_SMD_CV_gradual_change(EP_SMD *smd, MD_SYSTEM *sys, int step);
void EP_SMD_CV_trans_rot(EP_SMD *smd, double trans, double rot);

/* rmsd */

void EP_RMSD_setup(EXTRA_POT *ep,
		   ATOM_DATA *ad,
		   LINKED_CELL *lc,
		   STR_LIST *group_str, int group_no,
		   char *crd_file,  char *crd_file2,
		   int pdb_mode, int pdb2_mode,
		   STR_LIST *pdb_group_str, STR_LIST *pdb_group_str2, 
		   int check_pdb_group,
		   int best_fit, int weight_flag, WEIGHT_LIST *weight_list,
		   double k, double r0,
		   int gradual_change_step_k,  double k1, 
		   int gradual_change_step_r, double r1, 
		   int k_per_atom_flag,
		   int potential_type,
		   int virial_flag);
void EP_RMSD_energy_force(EP_RMSD *rmsd, ATOM_DATA *ad, LINKED_CELL *lc);
void EP_RMSD_prop_header(EP_RMSD *rmsd, FILE *fp, int *id);
void EP_RMSD_prop_out(EP_RMSD *rmsd, MD_SYSTEM *sys, FILE *fp);
void EP_RMSD_gradual_change(EP_RMSD *rmsd, MD_SYSTEM *sys, int step);


#endif /* _EXTRA_POT_FUNC_H_INCLUDED */
