/*
 * 
 * This source code is part of 
 *   MARBLE (MoleculAR simulation package for BiomoLEcules)
 * 
 * Written by Mitsunori Ikeguchi
 * Copyright (c) 2012 Yokohama City University
 *  
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 */

#ifndef _EXTRA_POT_H_INCLUDED
#define _EXTRA_POT_H_INCLUDED

#define EP_T_DISTANCE           1
#define EP_T_GROUP_DISTANCE     2
#define EP_T_POSITION           3
/* ys-add */
#define EP_T_GROUP_POSITION     4
#define EP_T_MOLECULE_POSITION  5
#define EP_T_TORSION            6
/* yse */
/* YAMANE_ADDED */
#define EP_T_NMR_DIS           11
#define EP_T_NMR_DIH           12
#define EP_T_NMR_PLN           13 
/* E_YAMANE_ADDED */

#define EP_T_SMD_CF            14
#define EP_T_SMD_CV            15

#define EP_T_RMSD              16

#define EP_T_USER              30

typedef struct _s_EP_ITEM {
  int type;
  struct _s_EP_ITEM *next;
  double energy;
} EP_ITEM;

typedef struct _s_EP_DISTANCE {
  /* common data */
  int type;
  struct _s_EP_ITEM *next;
  double energy;

  /* each data */
  int atom1, atom2;
  double k, k0, k1, r0;
  double distance;
  int gradual_change_step;
  int virial_flag;
  int potential_type;
  int x_flag, y_flag, z_flag;
  
} EP_DISTANCE;

typedef struct _s_EP_GROUP_DISTANCE {
  /* common data */
  int type;
  struct _s_EP_ITEM *next;
  double energy;

  /* each data */
  int n_list1, *list1, n_list2, *list2;
  int group1, group2;
  double k, k0, k1, r0, r00, r01;
  double distance;
  int gradual_change_step, gradual_change_step_r0;
  int virial_flag;
  int potential_type;
  int x_flag, y_flag, z_flag;
  int flag;
  
} EP_GROUP_DISTANCE;

typedef struct _s_EP_POSITION {
  /* common data */
  int type;
  struct _s_EP_ITEM *next;
  double energy;

  /* each data */
  int group_no;
  double k, k0, k1;
  VEC *x0;
  double deviation;
  char fname[100];
  char *atom_flag;
  int gradual_change_step;
  int virial_flag;
  int flag;
  int x_flag, y_flag, z_flag;
  
} EP_POSITION;

/* yss-add */
typedef struct _s_EP_GROUP_POSITION {
  /* common data */
  int type;
  struct _s_EP_ITEM *next;
  double energy;

  /* each data */
  int n_list, *list;
  int group_no;
  double k, k0, k1;
  double x0, y0, z0;
  double deviation;
  char fname[100];
  int gradual_change_step;
  int virial_flag;
  int flag;
  int x_flag, y_flag, z_flag;

} EP_GROUP_POSITION;

typedef struct _s_EP_MOL_DATA {
  int no,n_list, *list;
} EP_MOL_DATA;

typedef struct _s_EP_MOLECULE_POSITION {
  /* common data */
  int type;
  struct _s_EP_ITEM *next;
  double energy;

  /* each data */
  int n_list, *list;
  int group_no;
  double k, k0, k1;
  VEC *xm0;
  double deviation;
  char fname[100];
  int gradual_change_step;
  int virial_flag;
  int flag;
  int x_flag, y_flag, z_flag;
  int n_mole, n_residue, natom_mole;
  int mole_residue;
  EP_MOL_DATA *mole;

} EP_MOLECULE_POSITION;
/* yse */

/* yss-add (Mar09/2004) */
typedef struct _s_EP_TORSION {
  /* common data */
  int type;
  struct _s_EP_ITEM *next;
  double energy;

  /* each data */
  int *atom1, *atom2, *atom3, *atom4;
  int n_torsion;
  double k, k0, k1, r0;
  double delta, r1, r2;
  double *torsion;
  int gradual_change_step;
  int virial_flag;

} EP_TORSION;
/* yse */

/* YAMANE_ADDED
 *   nmr_pot.h
 *   Thu Jan 29 2004
 */

typedef struct _s_both {
  int noe_num,lh, rh, start_lh, start_rh;
} BOTH;

typedef struct _s_rests {
  double ds,dm,dp;
} RESTS;

typedef struct _s_EP_NMRDIS {
  /* common data */
  int type;
  struct _s_EP_ITEM *next;
  double energy;

  /* each data */
  int nnoedis;
  double scl_dis;
  double scl_dis0;
  double scl_dis1;
  double Ceil;
  double sqof;
  double sqcs;
  double sqex;
  double soex;
  double asym;
  double rswi;
  double viol_noe;
  int *lrnoe;
  int num_lh;
  int num_rh;
  int num_viol_noe;
  BOTH *pn;
  RESTS *rst;
  double deviation;
  char fname[100];
  int major_version, minor_version;
  int gradual_change_step;
  int n_output_viol;
  int virial_flag;
  int flag;
} EP_NMRDIS;

typedef struct _s_EP_NMRDIH {
  /* common data */
  int type;
  struct _s_EP_ITEM *next;
  double energy;

  /* each data */
  int nnoedih;
  double scl_dih;
  double scl_dih0;
  double scl_dih1;
  int *pks;
  int *numdi;
  double *f_cons, *eqbl, *rng, *expo; 
  double deviation;
  double viol_dih;
  int num_viol_dih;
  int n_output_viol;
  int virial_flag;
  char fname[100];
  int major_version, minor_version;
  int gradual_change_step;
  int flag;
} EP_NMRDIH;

struct _s_NMR_PLN {
  int n_atom, start_atom;
  double weight;
};

typedef struct _s_EP_NMRPLN {
  /* common data */
  int type;
  struct _s_EP_ITEM *next;
  double energy;

  /* each data */
  int nnpln, n_total_atom;
  struct _s_NMR_PLN *pln;
  double scl_pln;
  double scl_pln0;
  double scl_pln1;
  int *pl_atom;
  char fname[100];
  int major_version, minor_version;
  int gradual_change_step;
  int virial_flag;
  int flag;
} EP_NMRPLN;

/* E_YAMANE_ADDED */

typedef struct _s_EP_SMD {
  /* common data */
  int type;
  struct _s_EP_ITEM *next;
  double energy;

  /* each data */
  int group_no;
  double k, k0, k1;
  int *atom_list, n_atom;
  double vel, ang_vel;
  double init_trans, init_rot;
  double dir[3], pos[3];
  int center_flag, weight_flag;
  int n_x0;
  VEC center;
  VEC *x0;
  double *w, *ene_list, total_w;
  char crd_file[100];
  char *atom_flag;
  int gradual_change_step;
  int virial_flag;
  int flag;
  int x_flag, y_flag, z_flag;
  
} EP_SMD;

typedef struct _s_EP_RMSD {
  /* common data */
  int type;
  struct _s_EP_ITEM *next;
  double energy;

  /* each data */
  int group_no;
  double k, k0, k1;
  double r, r0, r1;
  double cur_rmsd, cur_rmsd1;
  int *atom_list, n_atom;
  FIT *fit;
  VEC *x0, *x1, *x, *x0r, *x1r;
  double *w;
  char crd_file[100], crd_file2[100];
  int gradual_change_step_k;
  int gradual_change_step_r;
  int virial_flag;
  int best_fit, weight_flag;
  int mode;
  int potential_type;
  int flag;
  
} EP_RMSD;

typedef struct _s_EP_USER {
  /* common data */
  int type;
  struct _s_EP_ITEM *next;
  double energy;

  /* each data */
  
} EP_USER;


typedef struct _s_EP {
  int flag;
  EP_ITEM *head;
} EXTRA_POT;

/* Function definitions are in extra_pot_func.h */

#endif /* _EXTRA_POT_H_INCLUDED */
