/*
 * 
 * This source code is part of 
 *   MARBLE (MoleculAR simulation package for BiomoLEcules)
 * 
 * Written by Mitsunori Ikeguchi
 * Copyright (c) 2012 Yokohama City University
 *  
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 */

#ifndef _EWALD_H_INCLUDED
#define _EWALD_H_INCLUDED

#define ERFC_TABLE
/* #define N_DIV_ERFC_TABLE 10000 */

#include "fft3d.h"

#define QARR(i,j,k)  ew->Q[(k)+ew->pme_grid[2]*((j)+ew->pme_grid[1]*(i))]
#define BARR(i,j,k)  ew->B[(k)+ew->pme_grid[2]*((j)+ew->pme_grid[1]*(i))]
#define CARR(i,j,k)  ew->C[(k)+ew->pme_grid[2]*((j)+ew->pme_grid[1]*(i))]
/*
#define QARR(i,j,k)  ew->Qindex[i][j][k]
#define BARR(i,j,k)  ew->Bindex[i][j][k]
#define CARR(i,j,k)  ew->Cindex[i][j][k]
*/
#ifdef MPI_SDMD
#define QRARR(i,j,k) ew->qr[(i)+ew->pme_local[0]*((j)+ew->pme_local[1]*(k))]


typedef struct {
  int i, j;
} EW_COR;

#endif /* MPI_SDMD */

typedef enum {
  FLAG_NO_EWALD, FLAG_EWALD, FLAG_PME
} EWALD_FLAG;

typedef struct {
  fftw_real *qr;
  double *Mnx, *Mny, *Mnz;
  double *Mn1x, *Mn1y, *Mn1z;
  VEC *recf;
} EW_TD;

typedef struct {
  EWALD_FLAG flag;
  
  double tolerance,beta;
  int mmax;
  double dir_const;
  double edir, erec, ecor;
  
  VEC *sx;
  MD_COMPLEX *exp_mx, *exp_my, *exp_mz, *exp_mr;
  double self_energy, self_energy_v;
  double diel_sur;
  int self_energy_v_flag;
  int pressure_flag;

#ifdef ERFC_TABLE  
  double (*erfc_table)[4];
  int n_erfc_table;
  double dx_erfc_table, max_erfc_table;
#endif  

  FFTW_COMPLEX *Q;
  double *B, *C;

  FFTW_COMPLEX ***Qindex;
  double ***Bindex, ***Cindex;
  
  double *Mnx, *Mny, *Mnz;
  double *Mn1x, *Mn1y, *Mn1z;
  int pme_grid[3], pme_grid_h[3];
  int n_spline, n_spline_h;
  int opt_infl;
  /*fftwnd_plan for_plan, back_plan;*/

#ifdef MPI_SDMD
  LINKED_CELL *lc;
  
  MPI_Comm comm;

  int pme_local[3];
  int local_start[3], local_end[3];
  int n_pme_local;
  
  FFT3D *fft3d;
  double *qr;
  fftw_real *fqr, *work;
  fftw_complex *fqc;

#ifdef _OPENMP
  EW_TD *td;
#endif
  
  /* int **cor_pe; */
  EW_COR *cor_list;
  int n_cor_list;

#define SDMD_EW_TIME_CHARGE_GRID  0
#define SDMD_EW_TIME_FFT          1
#define SDMD_EW_TIME_ENERGY       2
#define SDMD_EW_TIME_FFTB         3
#define SDMD_EW_TIME_FORCE        4
#define SDMD_EW_N_TIME            5
  
  double time[SDMD_EW_N_TIME], check_time;

#endif /* MPI_SDMD */
} EWALD;

void EWALD_init(EWALD *ew);
void EW_normal_init(EWALD *ew, ATOM_DATA *ad,
		       double beta, int mmax, double diel_sur);
void EW_direct_energy_force(EWALD *ew, LINKED_CELL *lc, NONBOND_LIST *nl,
			    ATOM_DATA *ad, BOUNDARY *bc,
			    double *vdw, double *edir, double *hbond);
void EW_rec_energy_force(EWALD *ew, double box[3], double min[3],
			    ATOM_DATA *ad, double *elec);
void EW_cor_energy_force(EWALD *ew, BOUNDARY *bc, ATOM_DATA *ad, double *elec);
void EW_nb_cor_energy_force(EWALD *ew, double box[3],
			    ATOM_DATA *ad, NONBOND_LIST *nl,
			    double *elec);

void EW_pme_init(EWALD *ew, BOUNDARY *bc, NONBOND_LIST *nl, ATOM_DATA *ad, 
		 double tol_beta, int tol_beta_flag,
		 int gridx, int gridy, int gridz,
		 double diel_sur, int n_spline, int erfc_resolution);
void EW_pme_energy_force(EWALD *ew, ATOM_DATA *ad, BOUNDARY *bc, double *elec);
void EW_calc_c_array(EWALD *ew, BOUNDARY *bc);
void EW_calc_b_array(EWALD *ew);

#ifdef ERFC_TABLE
void EW_set_erfc_table(EWALD *ew, double cutoff, int erfc_resolution);
void EW_cubic_spline(double (*y)[4], int n, double dx);
#endif /* ERFC_TABLE */

#endif  /* _EWALD_H_INCLUDED */
