/*
 * 
 * This source code is part of 
 *   MARBLE (MoleculAR simulation package for BiomoLEcules)
 * 
 * Written by Mitsunori Ikeguchi
 * Copyright (c) 2012 Yokohama City University
 *  
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 */

#ifndef _BOND_H_INCLUDED
#define _BOND_H_INCLUDED

#ifndef  _ATOM_H_INCLUDED
#include "atom.h"
#endif   /* _ATOM_H_INCLUDED */

#define NOT_HYDROGEN_INCLUDED  0
#define HYDROGEN_INCLUDED      1
#define WATER_BOND             3
#define RATTLE_FLAG            4
#define BOND_IN_RIGID          8
#define BOND_OTHER_NODE       16
#define NO_CALC_BOND          28   /* 4+8+16 */

typedef struct s_bond {
  int type, atom1, atom2;
  int flag;
  int rnext;
#ifdef MPI_SDMD  
  int next;
#endif  
} BOND;

typedef struct s_bond_type {
  double k, r0;
} BOND_TYPE;

typedef struct s_bond_data {
  int n_bond, n_bond_h;
  BOND *bonds;
  
  int n_bond_type;
  BOND_TYPE *bond_type;

  int rhead;
#ifdef MPI_SDMD
  int head;
#endif
  
#ifdef MPI_RDMD
  int start_task, end_task;
#endif /* MPI_RDMD */
  
} BOND_DATA;

void BOND_DATA_init(BOND_DATA *bd);
void BOND_DATA_finalize(BOND_DATA *bd);
void bond_energy_force(BOND_DATA *, ATOM_DATA *, double *);
int  read_bond_data(BOND_DATA*, ATOM_DATA*, FILE *);
void print_bonds(FILE *, BOND_DATA *);
void set_all_bonds_flag(BOND_DATA *bd, ATOM_DATA *ad);

void BOND_DATA_omit_data_for_rigid_mol(BOND_DATA *bd, ATOM_DATA *ad);
void BOND_DATA_check_hydrogen(BOND_DATA *bd, ATOM_DATA *ad);
void BOND_DATA_set_hydrogen_group(BOND_DATA *bd, ATOM_DATA *ad);
double BOND_DATA_standard_length(BOND_DATA *bd, int atom1, int atom2);
void BOND_DATA_scale_bond_k(BOND_DATA *bd, double scale);
void BOND_DATA_overwrite_bond_k(BOND_DATA *bd, double val);

#define get_bond_atom1(bd,i)  ((bd)->bonds[i].atom1)
#define get_bond_atom2(bd,i)  ((bd)->bonds[i].atom2)
#define set_bond_flag(bd,i,f)  ((bd)->bonds[i].flag |= (f))



#endif    /* _BOND_H_INCLUDED */
