/*
 * 
 * This source code is part of 
 *   MARBLE (MoleculAR simulation package for BiomoLEcules)
 * 
 * Written by Mitsunori Ikeguchi
 * Copyright (c) 2012 Yokohama City University
 *  
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 */

#ifndef _ANGLE_H_INCLUDED
#define _ANGLE_H_INCLUDED

#ifndef _ATOM_H_INCLUDED
#include "atom.h"
#endif

#define ANGLE_OTHER_NODE 1

typedef struct s_angle {
  int atom1, atom2, atom3, type;
#ifdef MPI_SDMD
  int flag;
  int next;
#endif  
} ANGLE;

typedef struct s_angle_type {
  double k, th0, kub, s0;
} ANGLE_TYPE;

typedef struct s_angle_data {
  int n_angle, n_angle_h;
  ANGLE *angles;

  int n_angle_type;
  ANGLE_TYPE *angle_type;

#ifdef MPI_RDMD
  int start_task, end_task;
#endif

#ifdef MPI_SDMD
  int head;
#endif
  
} ANGLE_DATA;

void ANGLE_DATA_init(ANGLE_DATA *and);
void ANGLE_DATA_finalize(ANGLE_DATA *and);
void angle_energy_force(ANGLE_DATA *, ATOM_DATA *, double *energy, double *energy_ub);
void print_angles(FILE *fp, ANGLE_DATA *ad);
void ANGLE_DATA_omit_data_for_rigid_mol(ANGLE_DATA *and, ATOM_DATA *ad);
double ANGLE_DATA_standard_angle(ANGLE_DATA *and, int atom1, int atom2, int atom3);
void ANGLE_DATA_scale_angle_k(ANGLE_DATA *and, double scale);
void ANGLE_DATA_overwrite_angle_k(ANGLE_DATA *and, double overwrite);

#endif  /* _ANGLE_H_INCLUDED */
